import sys

from PyQt5.QtCore import Qt
from PyQt5.QtGui import QFontDatabase
from PyQt5.QtWidgets import QApplication

from config import config
from pages.window import Window

if __name__ == "__main__":
    QApplication.setAttribute(Qt.AA_EnableHighDpiScaling)
    QApplication.setAttribute(Qt.AA_UseHighDpiPixmaps)

    app = QApplication(sys.argv)
    fontId = QFontDatabase.addApplicationFont("assets/iconfont.ttf")

    qss = config.init_qss()
    app.setStyleSheet(qss)

    main = Window()
    main.resize(800, 600)
    main.show()

    sys.exit(app.exec_())
