from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QScrollArea, QWidget, QGridLayout, QLabel, QCheckBox, QComboBox, QSpinBox, QDoubleSpinBox, \
    QLineEdit, QRadioButton, QSlider, QProgressBar

from kit.component.kit_button import KitButton
from kit.component.kit_icon import KitIcon


class BasicExample(QScrollArea):

    def __init__(self, parent=None):
        super(BasicExample, self).__init__(parent=parent)

        self.__init_widget()
        self.__init_slot()
        self.__init_qss()

    def __init_widget(self):
        self.main_widget = QWidget()
        self.setWidget(self.main_widget)

        self.layout = QGridLayout()
        self.layout.setSpacing(16)
        self.main_widget.setLayout(self.layout)

        # 按钮
        label1 = QLabel("按钮")
        label1.setObjectName("title")
        self.layout.addWidget(label1, 0, 0)

        button1 = KitButton("默认")
        self.layout.addWidget(button1, 1, 0)

        button2 = KitButton("圆角")
        button2.setShape(KitButton.Round)
        self.layout.addWidget(button2, 1, 1)

        button3 = KitButton("边框")
        button3.setType(KitButton.OutLined)
        self.layout.addWidget(button3, 1, 2)

        button4 = KitButton("文字")
        button4.setType(KitButton.Text)
        self.layout.addWidget(button4, 1, 3)

        button_icon = KitButton("下载", "\ue60c")
        self.layout.addWidget(button_icon, 1, 4)

        button_round = KitButton("", "\ue60c")
        button_round.setShape(KitButton.Round)
        button_round.setFixedWidth(40)
        self.layout.addWidget(button_round, 1, 5)

        # 图标
        label2 = QLabel("图标")
        label2.setObjectName("title")
        self.layout.addWidget(label2, 2, 0)

        icon_1 = KitIcon("\ue669")
        self.layout.addWidget(icon_1, 3, 0)

        icon_2 = KitIcon("\ue608")
        self.layout.addWidget(icon_2, 3, 1)

        icon_3 = KitIcon("\ue657")
        self.layout.addWidget(icon_3, 3, 2)

        icon_4 = KitIcon("\ue659")
        self.layout.addWidget(icon_4, 3, 3)

        icon_5 = KitIcon("\ue60c")
        self.layout.addWidget(icon_5, 3, 4)

        # 勾选框
        label3 = QLabel("勾选框")
        label3.setObjectName("title")
        self.layout.addWidget(label3, 4, 0)

        check_box_1 = QCheckBox("默认")
        self.layout.addWidget(check_box_1, 5, 0)

        check_box_2 = QCheckBox("三态")
        check_box_2.setTristate(True)
        self.layout.addWidget(check_box_2, 5, 1)

        # 选择器
        label4 = QLabel("选择器")
        label4.setObjectName("title")
        self.layout.addWidget(label4, 6, 0)

        combo_1 = QComboBox()
        combo_1.addItem("选项1")
        combo_1.addItem("选项2")
        combo_1.addItem("选项3")
        self.layout.addWidget(combo_1, 7, 0)

        combo_2 = QComboBox()
        combo_2.addItems(["选项1", "选项2", "选项3"])
        self.layout.addWidget(combo_2, 7, 1)

        # 步进器
        label5 = QLabel("步进器")
        label5.setObjectName("title")
        self.layout.addWidget(label5, 8, 0)

        spinbox_1 = QSpinBox()
        spinbox_1.setRange(0, 10)
        self.layout.addWidget(spinbox_1, 9, 0)

        spinbox_2 = QDoubleSpinBox()
        spinbox_2.setRange(0, 5.00)
        spinbox_2.setSingleStep(0.5)
        self.layout.addWidget(spinbox_2, 9, 1)

        # 输入框
        label6 = QLabel("输入框")
        label6.setObjectName("title")
        self.layout.addWidget(label6, 10, 0)

        line_edit_1 = QLineEdit()
        self.layout.addWidget(line_edit_1, 11, 0)

        line_label = QLabel()
        self.layout.addWidget(line_label, 11, 1)

        line_edit_1.textChanged.connect(lambda text: line_label.setText(text))

        # 单选
        label7 = QLabel("单选")
        label7.setObjectName("title")
        self.layout.addWidget(label7, 12, 0)

        radio_1 = QRadioButton("选项1")
        self.layout.addWidget(radio_1, 13, 0)

        radio_2 = QRadioButton("选项2")
        self.layout.addWidget(radio_2, 13, 1)

        radio_3 = QRadioButton("选项3")
        self.layout.addWidget(radio_3, 13, 2)

        # 滑块
        label8 = QLabel("滑块")
        label8.setObjectName("title")
        self.layout.addWidget(label8, 14, 0)

        slider_1 = QSlider(Qt.Horizontal)
        slider_1.setRange(0, 100)
        self.layout.addWidget(slider_1, 15, 0)

        slider_2 = QSlider(Qt.Vertical)
        slider_2.setRange(0, 100)
        self.layout.addWidget(slider_2, 15, 1)

        # 进度条
        label9 = QLabel("进度条")
        label9.setObjectName("title")
        self.layout.addWidget(label9, 16, 0)

        progress_1 = QProgressBar()
        progress_1.setValue(50)
        self.layout.addWidget(progress_1, 17, 0)

        progress_2 = QProgressBar()
        progress_2.setRange(0, 0)
        self.layout.addWidget(progress_2, 17, 1)

        self.main_widget.adjustSize()

    def __init_slot(self):
        pass

    def __init_qss(self):
        self.setAttribute(Qt.WA_StyledBackground, True)
