import * as Cesium from "cesium";
import computerAngle from "./angle";
 
let myAngle = new computerAngle();
let sectorNum = 0;
// 存储高程数组
let height = [];
// 地图容器对象
let v;
/**
 * 扇形实体
 */

  draw(parameter) {
    let xy = parameter.clickPointH;
    v = parameter.viewer;
    for (let i = 2; i < xy.length; i = i + 3) {
      height.push(xy[i]);
    }
    // 计算扇形起始线和正北的夹角
    let AB = xy.slice(0, 6);
    let Pab = myAngle.angle(AB);
    // 计算扇形终点线和正北的夹角
    let AC = [...xy.slice(0, 3), ...xy.slice(6, 9)];
    let Pac = myAngle.angle(AC);
    // 如果C点是往北边画的，则置换两个角度，方便计算
    Pab[0] > Pac[0] ? ([Pab[0], Pac[0]] = [Pac[0], Pab[0]]) : [];
    if (
      // 当B点在A点西部，且C点在A点东北部的时候||当B点在A点东部，且C点在A点西北部的时候
      (xy[3] > xy[0] && xy[7] > xy[1] && xy[6] < xy[0]) ||
      (xy[3] < xy[0] && xy[7] > xy[1] && xy[6] > xy[0])
    ) {
      [Pab[0], Pac[0]] = [Pac[0], 360 + Pab[0]];
    }
    return this.drawNow(xy[0], xy[1], Pab[0], Pac[0], Pab[1], parameter);
  }
  drawNow(x, y, Pab, Pac, ac, p) {
    let id = "扇形" + (sectorNum == 0 ? "" : sectorNum);
    let points = [];
    // 地球两极稍扁，赤道略鼓
    // 计算椭球体中心到圆心的距离（纬度越接近极点，则使用短半径，否则使用长半径）
    let oa = 6378137 - ((6378137 - 6356752) * y) / 90;
    // 计算圆心在赤道面的垂足投影长度（米）
    let oh = oa * Math.cos((y * Math.PI) / 180);
    for (let i = Pab, j = 0; i <= Pac; i += 0.03, j++) {
      // 计算距离坐标点ac米，方位角为i处的坐标点到圆心的X，Y轴距离（米）
      let clon = ac * Math.sin((i * Math.PI) / 180);
      let clat = ac * Math.cos((i * Math.PI) / 180);
      // 在圆心坐标上叠加X，Y轴弧度（弧度=周长/半径）后的新坐标
      let jlon = ((clon / oh + (x * Math.PI) / 180) * 180) / Math.PI;
      let jlat = ((clat / oa + (y * Math.PI) / 180) * 180) / Math.PI;
      j > 2 ? (j = 2) : "";
      points.push(jlon, jlat, height[j]);
    }
    points.push(x, y, height[0]);
    var sector = new Cesium.Entity({
      id,
      polygon: {
        show: true,
        hierarchy: {
          positions: Cesium.Cartesian3.fromDegreesArrayHeights(points),
        },
        height: 2000,
        extrudedHeight: 10,
        material: Cesium.Color.fromCssColorString(p.entityColor || "#007acc"),
        heightReference: Cesium.HeightReference.CLAMP_TO_GROUND,
      },
    });
    sectorNum++;
    // 添加实体时新增，视图缩放至实体
    v.entities.add(sector);
    v.zoomTo(sector);
    return sector;
  }

const Sector = new SectorGraphics();
export function drawSector(a) {
  let entity = Sector.draw(a);
  return entity;
}