### 创建扇形实体函数

通过entity添加实体ellipsoid，

ellipsoid是椭圆的实体，里面有角度信息，即配置角度可以显示想要范围的扇形，

代码如下：

```
function draw_sector(point, angleone, angletwo, r) {
        console.log(angleone, angletwo)
        const sector = viewer.entities.add({
            name: "Wedge",
            position: point,
            ellipsoid: {
                radii: new Cesium.Cartesian3(r, r, 1.0),
                minimumClock: Cesium.Math.toRadians(angleone),
                maximumClock: Cesium.Math.toRadians(angletwo),
                material: Cesium.Color.DARKCYAN.withAlpha(0.3),
                outline: false,
            },
        });
        return sector
        }
```

### 计算角度

```
function computerJiao(point_one, point_two) {
        let one = Cesium.Cartographic.fromCartesian(point_one)
        let two = Cesium.Cartographic.fromCartesian(point_two)
        let onelon = Cesium.Math.toDegrees(one.longitude)
        let onelat = Cesium.Math.toDegrees(one.latitude)
        let twolon = Cesium.Math.toDegrees(two.longitude)
        let twolat = Cesium.Math.toDegrees(two.latitude)
        let jiaorad = Math.atan(((twolon) - (onelon)) / ((twolat) - (onelat)))
        let jiao=jiaorad*(180/Math.PI)
        return jiao
    }
```

### 计算半径

```
function computerR(point_one, point_two) {
        let one = Cesium.Cartographic.fromCartesian(point_one)
        let two = Cesium.Cartographic.fromCartesian(point_two)
        let onelon = Cesium.Math.toDegrees(one.longitude)
        let onelat = Cesium.Math.toDegrees(one.latitude)
        let twolon = Cesium.Math.toDegrees(two.longitude)
        let twolat = Cesium.Math.toDegrees(two.latitude)
        let chang = Math.abs(onelon - twolon)
        let kuang = Math.abs(onelat - twolat)
        let r = Math.sqrt(chang * chang + kuang * kuang)
        return r*89990
    }
```

### 点击事件

```
const handler = new Cesium.ScreenSpaceEventHandler(viewer.canvas);
    handler.setInputAction(function (event) {
        const ray = viewer.camera.getPickRay(event.position);
        const earthPosition = viewer.scene.globe.pick(ray, viewer.scene);
        let angleone
        let angletwo
        let r
        if (Cesium.defined(earthPosition)) {
            if (count == 0) {
                onepoint = earthPosition;
                count = count + 1
            }
            else if (count == 1) {
                twopoint = earthPosition;
                count = count + 1
            }
            else if (count == 2) {
                threepoint = earthPosition;
                count = count + 1
            }
            if (count==3) {
                angleone = computerJiao(onepoint, twopoint)
                angletwo = computerJiao(onepoint, threepoint)
                r = computerR(onepoint, twopoint)
           
                draw_sector(onepoint, angleone, angletwo, r)
                console.log(r)
                count=0
            }
            console.log(count)
        }
    }, Cesium.ScreenSpaceEventType.LEFT_CLICK);
```

点击事件通过三次点击来确定扇形所需要的三个点的坐标信息，再通过半径和角度的计算从而获得实体所需要的数据；

### 总结

在写扇形这一块的代码时遇到了许多的困难，

1、entity中没有扇形示例，圆形实例没有角度的配置项，询问良哥可以使用椭圆来写，

2、在计算角度时，计算给出的是弧度制，但是需要的是角度制，因此需要再加上一步运算，

3、因为在计算角度和半径的过程中是使用经纬度来计算的，但是经纬度在地球表面是弧形的，在精准度小的地方有很大的误差，但在精准度高的地方误差很小，这里还需要优化。