import * as Cesium from 'cesium'

/**
 * @class 平面区域类
 * @classdesc 基于Entity.Polygon封装的区域
 */
class polygon {
  /**
   * 区域的构造函数
   * @param {Object} map - Viewer对象
   * @param {String} [id] - 区域的对象ID
   * @param {Array<Array>} [positions] - 区域范围
   * @param {Boolean} [visible=true] - 区域的显隐性
   * @param {String} [color='rgb(255,0,0)'] - 区域的颜色
   * @param {Number} [alpha=1.0] - 区域的不透明度
   * @param {String} [name='polygon'] - 区域的名称
   * @param {Boolean} [nameVisible=true] - 区域名称的可见性
   * @param {Number} [nameSize=14] - 区域名称的大小
   * @param {Array} [nameOffset=[10,0]] - 区域名称的偏移
   * @param {Boolean} [lineVisible] - 线的可见性
   * @param {String} [lineStyle='solid'] - 线的样式
   * @param {Number} [lineWidth=1] - 线的宽度
   * @param {Boolean} [pointVisible] - 中心点可见性
   * @param {Number} [pointSize] - 中心点尺寸
   * @param {Array} [centerPosition] - 中心点位置
   * @param {Number} [extrudedHeight] -
   * @param {Number} [extrudedAlpha] -
   * @param {Number} [extrudedOutlineColor] -
   * @param {Number} [extrudedOutlineVisible] -
   */
  constructor() {
    const POLYGON = {
      id: 'pplygon',
      positions: null,
      visible: true,
      color: Cesium.Color(255, 0, 0),
      alpha: 1.0,
      name: 'polygon',
      nameVisible: true,
      nameSize: 14,
      nameOffset: [10, 0],
      lineVisible: false,
      lineStyle: solid,
      lineWidth: 1,
    }




  }

  /**
   * 设置点位的回调函数
   */
  _setCallback() {}

  /**
   * 获取点，拾取模型（效果未知）
   */
  getKeyPoint() {}

  /**
   * 从场景中移除区域
   */
  removeFromScene() {}
}
