import * as Cesium from "cesium";

/**
 * @class 站点类
 * @classdesc 创建有一个站点
 */
class station {
  /**
   * 构造函数
   * @param {Object} map - viewer对象
   * @param {String} [id] - 站点ID
   * @param {Cesium.Cartesian3} [viewForm] - 追踪相机位置
   * @param {Array} [position] - 点位
   * @param {Boolean} [visible=true] - 显隐性
   * @param {String} [color='rgb(255,0,0)'] - 站点颜色
   * @param {Number} [alpha=1.0] - 站点透明度
   * @param {Number} [heading=0] - 方位角
   * @param {Number} [pitch=0] - 俯仰角
   * @param {Number} [roll=0] - 滚动角
   * @param {String} [name='station'] - 站点名称
   * @param {Number} [nameSize=14] - 站点名称尺寸
   * @param {Boolean} [nameVisible=true] - 站点名称可见性
   * @param {Array} [nameOffset=[10,0]] - 站点名称偏移
   * @param {String} [modelUrl] 站点模型地址
   * @param {Number} [modelScale=1] 站点模型缩放比例
   * @param {Boolean} [modelVisible=true] 站点模型可见性
   * @param {Array} [modelDistance=[0,500000]] 站点模型可见范围
   * @param {String} [markUrl] 站点标记图案地址
   * @param {Number} [markSize=10] 站点标记尺寸
   * @param {Boolean} [markVisible=true] 站点标记可见性
   * @param {Array} [markDistance=[500000,300000000]] 站点标记可见范围
   */
  constructor(map, options = {}) {
    const viewer = map
    this.entityCollection = viewer.entities; 
    const STATION = {
      id: null,
      viewForm: null,
      position: null,
      visible: true,
      color: Cesium.Color.fromBytes(255,0,0),
      alpha: 1.0,
      heading: 0,
      pitch: 0,
      roll: 0,
      name: 'station',
      nameSize: 14,
      nameVisible: true,
      nameOffset: [10, 0],
      modelUrl: '',
      modelScale: 1,
      modelVisible: false,
      modelDistance:[0,500000],
      markUrl: '',
      markScale: 10,
      markVisible: false,
      markDistance: [500000,300000000]
    };
    const finalOptions = { ...STATION, ...options };
    const { position, id, ...stationOptions } = finalOptions;
        this.entity = viewer.entities.add({
      id: id,
      position: position,
        elliposd: stationOptions.visible ? {
        radii:
        color: Cesium.Color.clone(stationOptions.color).withAlpha(stationOptions.alpha)
      }: undefined,
      // label: pointOptions.nameVisible ? {
      //   text: pointOptions.name,
      //   font: `${pointOptions.nameSize}px sans-serif`,
      //   fillColor: Cesium.Color.WHITE,
      //   pixelOffset: new Cesium.Cartesian2(...pointOptions.nameOffset),
      // } : undefined,
      // model: pointOptions.modelVisible ? {
      //   uri: pointOptions.modelUrl,
      //   scale: pointOptions.modelScale,
      //   minimumPixelSize: 640,
      //   maximumScale: 20000,
      //   modelMatrix: Cesium.Transforms.headingPitchRollToFixedFrame(
      //     position,
      //     new Cesium.HeadingPitchRoll(
      //       Cesium.Math.toRadians(pointOptions.heading),
      //       Cesium.Math.toRadians(pointOptions.pitch),
      //       Cesium.Math.toRadians(pointOptions.roll)
      //     )
      //   ),
      // } : undefined,
      // billboard: pointOptions.markVisible ? {
      //   image: pointOptions.markUrl,
      //   scale: pointOptions.markScale
      // } : undefined
    });

  }

  /**
   * 获取某一时刻下的站点位置
   * @param {Cesium.JulianDate} time 查询时刻
   */
  getPosition(time) {}

  /**
   * 在场景中移除该站点
   */
  removeFromScene(){}

  /**
   * 设置站点属性
   */
  setProperty(){}
}

export default Point;
