/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.99
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

var Cesium = (() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
    get: (a3, b) => (typeof require !== "undefined" ? require : a3)[b]
  }) : x)(function(x) {
    if (typeof require !== "undefined")
      return require.apply(this, arguments);
    throw new Error('Dynamic require of "' + x + '" is not supported');
  });
  var __commonJS = (cb, mod2) => function __require2() {
    return mod2 || (0, cb[__getOwnPropNames(cb)[0]])((mod2 = { exports: {} }).exports, mod2), mod2.exports;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM = (mod2, isNodeMode, target) => (target = mod2 != null ? __create(__getProtoOf(mod2)) : {}, __copyProps(
    isNodeMode || !mod2 || !mod2.__esModule ? __defProp(target, "default", { value: mod2, enumerable: true }) : target,
    mod2
  ));
  var __toCommonJS = (mod2) => __copyProps(__defProp({}, "__esModule", { value: true }), mod2);

  // node_modules/mersenne-twister/src/mersenne-twister.js
  var require_mersenne_twister = __commonJS({
    "node_modules/mersenne-twister/src/mersenne-twister.js"(exports2, module2) {
      var MersenneTwister4 = function(seed) {
        if (seed == void 0) {
          seed = new Date().getTime();
        }
        this.N = 624;
        this.M = 397;
        this.MATRIX_A = 2567483615;
        this.UPPER_MASK = 2147483648;
        this.LOWER_MASK = 2147483647;
        this.mt = new Array(this.N);
        this.mti = this.N + 1;
        if (seed.constructor == Array) {
          this.init_by_array(seed, seed.length);
        } else {
          this.init_seed(seed);
        }
      };
      MersenneTwister4.prototype.init_seed = function(s) {
        this.mt[0] = s >>> 0;
        for (this.mti = 1; this.mti < this.N; this.mti++) {
          var s = this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30;
          this.mt[this.mti] = (((s & 4294901760) >>> 16) * 1812433253 << 16) + (s & 65535) * 1812433253 + this.mti;
          this.mt[this.mti] >>>= 0;
        }
      };
      MersenneTwister4.prototype.init_by_array = function(init_key, key_length) {
        var i, j, k;
        this.init_seed(19650218);
        i = 1;
        j = 0;
        k = this.N > key_length ? this.N : key_length;
        for (; k; k--) {
          var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
          this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1664525 << 16) + (s & 65535) * 1664525) + init_key[j] + j;
          this.mt[i] >>>= 0;
          i++;
          j++;
          if (i >= this.N) {
            this.mt[0] = this.mt[this.N - 1];
            i = 1;
          }
          if (j >= key_length)
            j = 0;
        }
        for (k = this.N - 1; k; k--) {
          var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
          this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1566083941 << 16) + (s & 65535) * 1566083941) - i;
          this.mt[i] >>>= 0;
          i++;
          if (i >= this.N) {
            this.mt[0] = this.mt[this.N - 1];
            i = 1;
          }
        }
        this.mt[0] = 2147483648;
      };
      MersenneTwister4.prototype.random_int = function() {
        var y;
        var mag01 = new Array(0, this.MATRIX_A);
        if (this.mti >= this.N) {
          var kk;
          if (this.mti == this.N + 1)
            this.init_seed(5489);
          for (kk = 0; kk < this.N - this.M; kk++) {
            y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
            this.mt[kk] = this.mt[kk + this.M] ^ y >>> 1 ^ mag01[y & 1];
          }
          for (; kk < this.N - 1; kk++) {
            y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
            this.mt[kk] = this.mt[kk + (this.M - this.N)] ^ y >>> 1 ^ mag01[y & 1];
          }
          y = this.mt[this.N - 1] & this.UPPER_MASK | this.mt[0] & this.LOWER_MASK;
          this.mt[this.N - 1] = this.mt[this.M - 1] ^ y >>> 1 ^ mag01[y & 1];
          this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 2636928640;
        y ^= y << 15 & 4022730752;
        y ^= y >>> 18;
        return y >>> 0;
      };
      MersenneTwister4.prototype.random_int31 = function() {
        return this.random_int() >>> 1;
      };
      MersenneTwister4.prototype.random_incl = function() {
        return this.random_int() * (1 / 4294967295);
      };
      MersenneTwister4.prototype.random = function() {
        return this.random_int() * (1 / 4294967296);
      };
      MersenneTwister4.prototype.random_excl = function() {
        return (this.random_int() + 0.5) * (1 / 4294967296);
      };
      MersenneTwister4.prototype.random_long = function() {
        var a3 = this.random_int() >>> 5, b = this.random_int() >>> 6;
        return (a3 * 67108864 + b) * (1 / 9007199254740992);
      };
      module2.exports = MersenneTwister4;
    }
  });

  // node_modules/urijs/src/punycode.js
  var require_punycode = __commonJS({
    "node_modules/urijs/src/punycode.js"(exports2, module2) {
      /*! https://mths.be/punycode v1.4.0 by @mathias */
      (function(root) {
        var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
        var freeModule = typeof module2 == "object" && module2 && !module2.nodeType && module2;
        var freeGlobal = typeof global == "object" && global;
        if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
          root = freeGlobal;
        }
        var punycode, maxInt = 2147483647, base = 36, tMin = 1, tMax = 26, skew = 38, damp = 700, initialBias = 72, initialN = 128, delimiter = "-", regexPunycode = /^xn--/, regexNonASCII = /[^\x20-\x7E]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = {
          "overflow": "Overflow: input needs wider integers to process",
          "not-basic": "Illegal input >= 0x80 (not a basic code point)",
          "invalid-input": "Invalid input"
        }, baseMinusTMin = base - tMin, floor = Math.floor, stringFromCharCode = String.fromCharCode, key;
        function error(type) {
          throw new RangeError(errors[type]);
        }
        function map(array, fn) {
          var length3 = array.length;
          var result = [];
          while (length3--) {
            result[length3] = fn(array[length3]);
          }
          return result;
        }
        function mapDomain(string, fn) {
          var parts = string.split("@");
          var result = "";
          if (parts.length > 1) {
            result = parts[0] + "@";
            string = parts[1];
          }
          string = string.replace(regexSeparators, ".");
          var labels = string.split(".");
          var encoded = map(labels, fn).join(".");
          return result + encoded;
        }
        function ucs2decode(string) {
          var output = [], counter = 0, length3 = string.length, value, extra;
          while (counter < length3) {
            value = string.charCodeAt(counter++);
            if (value >= 55296 && value <= 56319 && counter < length3) {
              extra = string.charCodeAt(counter++);
              if ((extra & 64512) == 56320) {
                output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
              } else {
                output.push(value);
                counter--;
              }
            } else {
              output.push(value);
            }
          }
          return output;
        }
        function ucs2encode(array) {
          return map(array, function(value) {
            var output = "";
            if (value > 65535) {
              value -= 65536;
              output += stringFromCharCode(value >>> 10 & 1023 | 55296);
              value = 56320 | value & 1023;
            }
            output += stringFromCharCode(value);
            return output;
          }).join("");
        }
        function basicToDigit(codePoint) {
          if (codePoint - 48 < 10) {
            return codePoint - 22;
          }
          if (codePoint - 65 < 26) {
            return codePoint - 65;
          }
          if (codePoint - 97 < 26) {
            return codePoint - 97;
          }
          return base;
        }
        function digitToBasic(digit, flag) {
          return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
        }
        function adapt(delta, numPoints, firstTime) {
          var k = 0;
          delta = firstTime ? floor(delta / damp) : delta >> 1;
          delta += floor(delta / numPoints);
          for (; delta > baseMinusTMin * tMax >> 1; k += base) {
            delta = floor(delta / baseMinusTMin);
          }
          return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
        }
        function decode(input) {
          var output = [], inputLength = input.length, out, i = 0, n = initialN, bias = initialBias, basic, j, index, oldi, w, k, digit, t, baseMinusT;
          basic = input.lastIndexOf(delimiter);
          if (basic < 0) {
            basic = 0;
          }
          for (j = 0; j < basic; ++j) {
            if (input.charCodeAt(j) >= 128) {
              error("not-basic");
            }
            output.push(input.charCodeAt(j));
          }
          for (index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
            for (oldi = i, w = 1, k = base; ; k += base) {
              if (index >= inputLength) {
                error("invalid-input");
              }
              digit = basicToDigit(input.charCodeAt(index++));
              if (digit >= base || digit > floor((maxInt - i) / w)) {
                error("overflow");
              }
              i += digit * w;
              t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
              if (digit < t) {
                break;
              }
              baseMinusT = base - t;
              if (w > floor(maxInt / baseMinusT)) {
                error("overflow");
              }
              w *= baseMinusT;
            }
            out = output.length + 1;
            bias = adapt(i - oldi, out, oldi == 0);
            if (floor(i / out) > maxInt - n) {
              error("overflow");
            }
            n += floor(i / out);
            i %= out;
            output.splice(i++, 0, n);
          }
          return ucs2encode(output);
        }
        function encode(input) {
          var n, delta, handledCPCount, basicLength, bias, j, m, q, k, t, currentValue, output = [], inputLength, handledCPCountPlusOne, baseMinusT, qMinusT;
          input = ucs2decode(input);
          inputLength = input.length;
          n = initialN;
          delta = 0;
          bias = initialBias;
          for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < 128) {
              output.push(stringFromCharCode(currentValue));
            }
          }
          handledCPCount = basicLength = output.length;
          if (basicLength) {
            output.push(delimiter);
          }
          while (handledCPCount < inputLength) {
            for (m = maxInt, j = 0; j < inputLength; ++j) {
              currentValue = input[j];
              if (currentValue >= n && currentValue < m) {
                m = currentValue;
              }
            }
            handledCPCountPlusOne = handledCPCount + 1;
            if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
              error("overflow");
            }
            delta += (m - n) * handledCPCountPlusOne;
            n = m;
            for (j = 0; j < inputLength; ++j) {
              currentValue = input[j];
              if (currentValue < n && ++delta > maxInt) {
                error("overflow");
              }
              if (currentValue == n) {
                for (q = delta, k = base; ; k += base) {
                  t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                  if (q < t) {
                    break;
                  }
                  qMinusT = q - t;
                  baseMinusT = base - t;
                  output.push(
                    stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                  );
                  q = floor(qMinusT / baseMinusT);
                }
                output.push(stringFromCharCode(digitToBasic(q, 0)));
                bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                delta = 0;
                ++handledCPCount;
              }
            }
            ++delta;
            ++n;
          }
          return output.join("");
        }
        function toUnicode(input) {
          return mapDomain(input, function(string) {
            return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
          });
        }
        function toASCII(input) {
          return mapDomain(input, function(string) {
            return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
          });
        }
        punycode = {
          "version": "1.3.2",
          "ucs2": {
            "decode": ucs2decode,
            "encode": ucs2encode
          },
          "decode": decode,
          "encode": encode,
          "toASCII": toASCII,
          "toUnicode": toUnicode
        };
        if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
          define("punycode", function() {
            return punycode;
          });
        } else if (freeExports && freeModule) {
          if (module2.exports == freeExports) {
            freeModule.exports = punycode;
          } else {
            for (key in punycode) {
              punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
            }
          }
        } else {
          root.punycode = punycode;
        }
      })(exports2);
    }
  });

  // node_modules/urijs/src/IPv6.js
  var require_IPv6 = __commonJS({
    "node_modules/urijs/src/IPv6.js"(exports2, module2) {
      /*!
       * URI.js - Mutating URLs
       * IPv6 Support
       *
       * Version: 1.19.11
       *
       * Author: Rodney Rehm
       * Web: http://medialize.github.io/URI.js/
       *
       * Licensed under
       *   MIT License http://www.opensource.org/licenses/mit-license
       *
       */
      (function(root, factory) {
        "use strict";
        if (typeof module2 === "object" && module2.exports) {
          module2.exports = factory();
        } else if (typeof define === "function" && define.amd) {
          define(factory);
        } else {
          root.IPv6 = factory(root);
        }
      })(exports2, function(root) {
        "use strict";
        var _IPv6 = root && root.IPv6;
        function bestPresentation(address) {
          var _address = address.toLowerCase();
          var segments = _address.split(":");
          var length3 = segments.length;
          var total = 8;
          if (segments[0] === "" && segments[1] === "" && segments[2] === "") {
            segments.shift();
            segments.shift();
          } else if (segments[0] === "" && segments[1] === "") {
            segments.shift();
          } else if (segments[length3 - 1] === "" && segments[length3 - 2] === "") {
            segments.pop();
          }
          length3 = segments.length;
          if (segments[length3 - 1].indexOf(".") !== -1) {
            total = 7;
          }
          var pos;
          for (pos = 0; pos < length3; pos++) {
            if (segments[pos] === "") {
              break;
            }
          }
          if (pos < total) {
            segments.splice(pos, 1, "0000");
            while (segments.length < total) {
              segments.splice(pos, 0, "0000");
            }
          }
          var _segments;
          for (var i = 0; i < total; i++) {
            _segments = segments[i].split("");
            for (var j = 0; j < 3; j++) {
              if (_segments[0] === "0" && _segments.length > 1) {
                _segments.splice(0, 1);
              } else {
                break;
              }
            }
            segments[i] = _segments.join("");
          }
          var best = -1;
          var _best = 0;
          var _current = 0;
          var current = -1;
          var inzeroes = false;
          for (i = 0; i < total; i++) {
            if (inzeroes) {
              if (segments[i] === "0") {
                _current += 1;
              } else {
                inzeroes = false;
                if (_current > _best) {
                  best = current;
                  _best = _current;
                }
              }
            } else {
              if (segments[i] === "0") {
                inzeroes = true;
                current = i;
                _current = 1;
              }
            }
          }
          if (_current > _best) {
            best = current;
            _best = _current;
          }
          if (_best > 1) {
            segments.splice(best, _best, "");
          }
          length3 = segments.length;
          var result = "";
          if (segments[0] === "") {
            result = ":";
          }
          for (i = 0; i < length3; i++) {
            result += segments[i];
            if (i === length3 - 1) {
              break;
            }
            result += ":";
          }
          if (segments[length3 - 1] === "") {
            result += ":";
          }
          return result;
        }
        function noConflict() {
          if (root.IPv6 === this) {
            root.IPv6 = _IPv6;
          }
          return this;
        }
        return {
          best: bestPresentation,
          noConflict
        };
      });
    }
  });

  // node_modules/urijs/src/SecondLevelDomains.js
  var require_SecondLevelDomains = __commonJS({
    "node_modules/urijs/src/SecondLevelDomains.js"(exports2, module2) {
      /*!
       * URI.js - Mutating URLs
       * Second Level Domain (SLD) Support
       *
       * Version: 1.19.11
       *
       * Author: Rodney Rehm
       * Web: http://medialize.github.io/URI.js/
       *
       * Licensed under
       *   MIT License http://www.opensource.org/licenses/mit-license
       *
       */
      (function(root, factory) {
        "use strict";
        if (typeof module2 === "object" && module2.exports) {
          module2.exports = factory();
        } else if (typeof define === "function" && define.amd) {
          define(factory);
        } else {
          root.SecondLevelDomains = factory(root);
        }
      })(exports2, function(root) {
        "use strict";
        var _SecondLevelDomains = root && root.SecondLevelDomains;
        var SLD = {
          list: {
            "ac": " com gov mil net org ",
            "ae": " ac co gov mil name net org pro sch ",
            "af": " com edu gov net org ",
            "al": " com edu gov mil net org ",
            "ao": " co ed gv it og pb ",
            "ar": " com edu gob gov int mil net org tur ",
            "at": " ac co gv or ",
            "au": " asn com csiro edu gov id net org ",
            "ba": " co com edu gov mil net org rs unbi unmo unsa untz unze ",
            "bb": " biz co com edu gov info net org store tv ",
            "bh": " biz cc com edu gov info net org ",
            "bn": " com edu gov net org ",
            "bo": " com edu gob gov int mil net org tv ",
            "br": " adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",
            "bs": " com edu gov net org ",
            "bz": " du et om ov rg ",
            "ca": " ab bc mb nb nf nl ns nt nu on pe qc sk yk ",
            "ck": " biz co edu gen gov info net org ",
            "cn": " ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",
            "co": " com edu gov mil net nom org ",
            "cr": " ac c co ed fi go or sa ",
            "cy": " ac biz com ekloges gov ltd name net org parliament press pro tm ",
            "do": " art com edu gob gov mil net org sld web ",
            "dz": " art asso com edu gov net org pol ",
            "ec": " com edu fin gov info med mil net org pro ",
            "eg": " com edu eun gov mil name net org sci ",
            "er": " com edu gov ind mil net org rochest w ",
            "es": " com edu gob nom org ",
            "et": " biz com edu gov info name net org ",
            "fj": " ac biz com info mil name net org pro ",
            "fk": " ac co gov net nom org ",
            "fr": " asso com f gouv nom prd presse tm ",
            "gg": " co net org ",
            "gh": " com edu gov mil org ",
            "gn": " ac com gov net org ",
            "gr": " com edu gov mil net org ",
            "gt": " com edu gob ind mil net org ",
            "gu": " com edu gov net org ",
            "hk": " com edu gov idv net org ",
            "hu": " 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",
            "id": " ac co go mil net or sch web ",
            "il": " ac co gov idf k12 muni net org ",
            "in": " ac co edu ernet firm gen gov i ind mil net nic org res ",
            "iq": " com edu gov i mil net org ",
            "ir": " ac co dnssec gov i id net org sch ",
            "it": " edu gov ",
            "je": " co net org ",
            "jo": " com edu gov mil name net org sch ",
            "jp": " ac ad co ed go gr lg ne or ",
            "ke": " ac co go info me mobi ne or sc ",
            "kh": " com edu gov mil net org per ",
            "ki": " biz com de edu gov info mob net org tel ",
            "km": " asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",
            "kn": " edu gov net org ",
            "kr": " ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",
            "kw": " com edu gov net org ",
            "ky": " com edu gov net org ",
            "kz": " com edu gov mil net org ",
            "lb": " com edu gov net org ",
            "lk": " assn com edu gov grp hotel int ltd net ngo org sch soc web ",
            "lr": " com edu gov net org ",
            "lv": " asn com conf edu gov id mil net org ",
            "ly": " com edu gov id med net org plc sch ",
            "ma": " ac co gov m net org press ",
            "mc": " asso tm ",
            "me": " ac co edu gov its net org priv ",
            "mg": " com edu gov mil nom org prd tm ",
            "mk": " com edu gov inf name net org pro ",
            "ml": " com edu gov net org presse ",
            "mn": " edu gov org ",
            "mo": " com edu gov net org ",
            "mt": " com edu gov net org ",
            "mv": " aero biz com coop edu gov info int mil museum name net org pro ",
            "mw": " ac co com coop edu gov int museum net org ",
            "mx": " com edu gob net org ",
            "my": " com edu gov mil name net org sch ",
            "nf": " arts com firm info net other per rec store web ",
            "ng": " biz com edu gov mil mobi name net org sch ",
            "ni": " ac co com edu gob mil net nom org ",
            "np": " com edu gov mil net org ",
            "nr": " biz com edu gov info net org ",
            "om": " ac biz co com edu gov med mil museum net org pro sch ",
            "pe": " com edu gob mil net nom org sld ",
            "ph": " com edu gov i mil net ngo org ",
            "pk": " biz com edu fam gob gok gon gop gos gov net org web ",
            "pl": " art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",
            "pr": " ac biz com edu est gov info isla name net org pro prof ",
            "ps": " com edu gov net org plo sec ",
            "pw": " belau co ed go ne or ",
            "ro": " arts com firm info nom nt org rec store tm www ",
            "rs": " ac co edu gov in org ",
            "sb": " com edu gov net org ",
            "sc": " com edu gov net org ",
            "sh": " co com edu gov net nom org ",
            "sl": " com edu gov net org ",
            "st": " co com consulado edu embaixada gov mil net org principe saotome store ",
            "sv": " com edu gob org red ",
            "sz": " ac co org ",
            "tr": " av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",
            "tt": " aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",
            "tw": " club com ebiz edu game gov idv mil net org ",
            "mu": " ac co com gov net or org ",
            "mz": " ac co edu gov org ",
            "na": " co com ",
            "nz": " ac co cri geek gen govt health iwi maori mil net org parliament school ",
            "pa": " abo ac com edu gob ing med net nom org sld ",
            "pt": " com edu gov int net nome org publ ",
            "py": " com edu gov mil net org ",
            "qa": " com edu gov mil net org ",
            "re": " asso com nom ",
            "ru": " ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",
            "rw": " ac co com edu gouv gov int mil net ",
            "sa": " com edu gov med net org pub sch ",
            "sd": " com edu gov info med net org tv ",
            "se": " a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",
            "sg": " com edu gov idn net org per ",
            "sn": " art com edu gouv org perso univ ",
            "sy": " com edu gov mil net news org ",
            "th": " ac co go in mi net or ",
            "tj": " ac biz co com edu go gov info int mil name net nic org test web ",
            "tn": " agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",
            "tz": " ac co go ne or ",
            "ua": " biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",
            "ug": " ac co go ne or org sc ",
            "uk": " ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",
            "us": " dni fed isa kids nsn ",
            "uy": " com edu gub mil net org ",
            "ve": " co com edu gob info mil net org web ",
            "vi": " co com k12 net org ",
            "vn": " ac biz com edu gov health info int name net org pro ",
            "ye": " co com gov ltd me net org plc ",
            "yu": " ac co edu gov org ",
            "za": " ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",
            "zm": " ac co com edu gov net org sch ",
            "com": "ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",
            "net": "gb jp se uk ",
            "org": "ae",
            "de": "com "
          },
          has: function(domain) {
            var tldOffset = domain.lastIndexOf(".");
            if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
              return false;
            }
            var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
            if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
              return false;
            }
            var sldList = SLD.list[domain.slice(tldOffset + 1)];
            if (!sldList) {
              return false;
            }
            return sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") >= 0;
          },
          is: function(domain) {
            var tldOffset = domain.lastIndexOf(".");
            if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
              return false;
            }
            var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
            if (sldOffset >= 0) {
              return false;
            }
            var sldList = SLD.list[domain.slice(tldOffset + 1)];
            if (!sldList) {
              return false;
            }
            return sldList.indexOf(" " + domain.slice(0, tldOffset) + " ") >= 0;
          },
          get: function(domain) {
            var tldOffset = domain.lastIndexOf(".");
            if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
              return null;
            }
            var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
            if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
              return null;
            }
            var sldList = SLD.list[domain.slice(tldOffset + 1)];
            if (!sldList) {
              return null;
            }
            if (sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") < 0) {
              return null;
            }
            return domain.slice(sldOffset + 1);
          },
          noConflict: function() {
            if (root.SecondLevelDomains === this) {
              root.SecondLevelDomains = _SecondLevelDomains;
            }
            return this;
          }
        };
        return SLD;
      });
    }
  });

  // node_modules/urijs/src/URI.js
  var require_URI = __commonJS({
    "node_modules/urijs/src/URI.js"(exports2, module2) {
      /*!
       * URI.js - Mutating URLs
       *
       * Version: 1.19.11
       *
       * Author: Rodney Rehm
       * Web: http://medialize.github.io/URI.js/
       *
       * Licensed under
       *   MIT License http://www.opensource.org/licenses/mit-license
       *
       */
      (function(root, factory) {
        "use strict";
        if (typeof module2 === "object" && module2.exports) {
          module2.exports = factory(require_punycode(), require_IPv6(), require_SecondLevelDomains());
        } else if (typeof define === "function" && define.amd) {
          define(["./punycode", "./IPv6", "./SecondLevelDomains"], factory);
        } else {
          root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
        }
      })(exports2, function(punycode, IPv6, SLD, root) {
        "use strict";
        var _URI = root && root.URI;
        function URI(url2, base) {
          var _urlSupplied = arguments.length >= 1;
          var _baseSupplied = arguments.length >= 2;
          if (!(this instanceof URI)) {
            if (_urlSupplied) {
              if (_baseSupplied) {
                return new URI(url2, base);
              }
              return new URI(url2);
            }
            return new URI();
          }
          if (url2 === void 0) {
            if (_urlSupplied) {
              throw new TypeError("undefined is not a valid argument for URI");
            }
            if (typeof location !== "undefined") {
              url2 = location.href + "";
            } else {
              url2 = "";
            }
          }
          if (url2 === null) {
            if (_urlSupplied) {
              throw new TypeError("null is not a valid argument for URI");
            }
          }
          this.href(url2);
          if (base !== void 0) {
            return this.absoluteTo(base);
          }
          return this;
        }
        function isInteger(value) {
          return /^[0-9]+$/.test(value);
        }
        URI.version = "1.19.11";
        var p = URI.prototype;
        var hasOwn = Object.prototype.hasOwnProperty;
        function escapeRegEx(string) {
          return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, "\\$1");
        }
        function getType(value) {
          if (value === void 0) {
            return "Undefined";
          }
          return String(Object.prototype.toString.call(value)).slice(8, -1);
        }
        function isArray(obj) {
          return getType(obj) === "Array";
        }
        function filterArrayValues(data, value) {
          var lookup = {};
          var i, length3;
          if (getType(value) === "RegExp") {
            lookup = null;
          } else if (isArray(value)) {
            for (i = 0, length3 = value.length; i < length3; i++) {
              lookup[value[i]] = true;
            }
          } else {
            lookup[value] = true;
          }
          for (i = 0, length3 = data.length; i < length3; i++) {
            var _match = lookup && lookup[data[i]] !== void 0 || !lookup && value.test(data[i]);
            if (_match) {
              data.splice(i, 1);
              length3--;
              i--;
            }
          }
          return data;
        }
        function arrayContains(list, value) {
          var i, length3;
          if (isArray(value)) {
            for (i = 0, length3 = value.length; i < length3; i++) {
              if (!arrayContains(list, value[i])) {
                return false;
              }
            }
            return true;
          }
          var _type = getType(value);
          for (i = 0, length3 = list.length; i < length3; i++) {
            if (_type === "RegExp") {
              if (typeof list[i] === "string" && list[i].match(value)) {
                return true;
              }
            } else if (list[i] === value) {
              return true;
            }
          }
          return false;
        }
        function arraysEqual(one, two) {
          if (!isArray(one) || !isArray(two)) {
            return false;
          }
          if (one.length !== two.length) {
            return false;
          }
          one.sort();
          two.sort();
          for (var i = 0, l = one.length; i < l; i++) {
            if (one[i] !== two[i]) {
              return false;
            }
          }
          return true;
        }
        function trimSlashes(text) {
          var trim_expression = /^\/+|\/+$/g;
          return text.replace(trim_expression, "");
        }
        URI._parts = function() {
          return {
            protocol: null,
            username: null,
            password: null,
            hostname: null,
            urn: null,
            port: null,
            path: null,
            query: null,
            fragment: null,
            preventInvalidHostname: URI.preventInvalidHostname,
            duplicateQueryParameters: URI.duplicateQueryParameters,
            escapeQuerySpace: URI.escapeQuerySpace
          };
        };
        URI.preventInvalidHostname = false;
        URI.duplicateQueryParameters = false;
        URI.escapeQuerySpace = true;
        URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
        URI.idn_expression = /[^a-z0-9\._-]/i;
        URI.punycode_expression = /(xn--)/i;
        URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
        URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
        URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
        URI.findUri = {
          start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
          end: /[\s\r\n]|$/,
          trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
          parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g
        };
        URI.leading_whitespace_expression = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
        URI.ascii_tab_whitespace = /[\u0009\u000A\u000D]+/g;
        URI.defaultPorts = {
          http: "80",
          https: "443",
          ftp: "21",
          gopher: "70",
          ws: "80",
          wss: "443"
        };
        URI.hostProtocols = [
          "http",
          "https"
        ];
        URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
        URI.domAttributes = {
          "a": "href",
          "blockquote": "cite",
          "link": "href",
          "base": "href",
          "script": "src",
          "form": "action",
          "img": "src",
          "area": "href",
          "iframe": "src",
          "embed": "src",
          "source": "src",
          "track": "src",
          "input": "src",
          "audio": "src",
          "video": "src"
        };
        URI.getDomAttribute = function(node) {
          if (!node || !node.nodeName) {
            return void 0;
          }
          var nodeName = node.nodeName.toLowerCase();
          if (nodeName === "input" && node.type !== "image") {
            return void 0;
          }
          return URI.domAttributes[nodeName];
        };
        function escapeForDumbFirefox36(value) {
          return escape(value);
        }
        function strictEncodeURIComponent(string) {
          return encodeURIComponent(string).replace(/[!'()*]/g, escapeForDumbFirefox36).replace(/\*/g, "%2A");
        }
        URI.encode = strictEncodeURIComponent;
        URI.decode = decodeURIComponent;
        URI.iso8859 = function() {
          URI.encode = escape;
          URI.decode = unescape;
        };
        URI.unicode = function() {
          URI.encode = strictEncodeURIComponent;
          URI.decode = decodeURIComponent;
        };
        URI.characters = {
          pathname: {
            encode: {
              expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
              map: {
                "%24": "$",
                "%26": "&",
                "%2B": "+",
                "%2C": ",",
                "%3B": ";",
                "%3D": "=",
                "%3A": ":",
                "%40": "@"
              }
            },
            decode: {
              expression: /[\/\?#]/g,
              map: {
                "/": "%2F",
                "?": "%3F",
                "#": "%23"
              }
            }
          },
          reserved: {
            encode: {
              expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
              map: {
                "%3A": ":",
                "%2F": "/",
                "%3F": "?",
                "%23": "#",
                "%5B": "[",
                "%5D": "]",
                "%40": "@",
                "%21": "!",
                "%24": "$",
                "%26": "&",
                "%27": "'",
                "%28": "(",
                "%29": ")",
                "%2A": "*",
                "%2B": "+",
                "%2C": ",",
                "%3B": ";",
                "%3D": "="
              }
            }
          },
          urnpath: {
            encode: {
              expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
              map: {
                "%21": "!",
                "%24": "$",
                "%27": "'",
                "%28": "(",
                "%29": ")",
                "%2A": "*",
                "%2B": "+",
                "%2C": ",",
                "%3B": ";",
                "%3D": "=",
                "%40": "@"
              }
            },
            decode: {
              expression: /[\/\?#:]/g,
              map: {
                "/": "%2F",
                "?": "%3F",
                "#": "%23",
                ":": "%3A"
              }
            }
          }
        };
        URI.encodeQuery = function(string, escapeQuerySpace) {
          var escaped = URI.encode(string + "");
          if (escapeQuerySpace === void 0) {
            escapeQuerySpace = URI.escapeQuerySpace;
          }
          return escapeQuerySpace ? escaped.replace(/%20/g, "+") : escaped;
        };
        URI.decodeQuery = function(string, escapeQuerySpace) {
          string += "";
          if (escapeQuerySpace === void 0) {
            escapeQuerySpace = URI.escapeQuerySpace;
          }
          try {
            return URI.decode(escapeQuerySpace ? string.replace(/\+/g, "%20") : string);
          } catch (e) {
            return string;
          }
        };
        var _parts = { "encode": "encode", "decode": "decode" };
        var _part;
        var generateAccessor = function(_group, _part2) {
          return function(string) {
            try {
              return URI[_part2](string + "").replace(URI.characters[_group][_part2].expression, function(c) {
                return URI.characters[_group][_part2].map[c];
              });
            } catch (e) {
              return string;
            }
          };
        };
        for (_part in _parts) {
          URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
          URI[_part + "UrnPathSegment"] = generateAccessor("urnpath", _parts[_part]);
        }
        var generateSegmentedPathFunction = function(_sep, _codingFuncName, _innerCodingFuncName) {
          return function(string) {
            var actualCodingFunc;
            if (!_innerCodingFuncName) {
              actualCodingFunc = URI[_codingFuncName];
            } else {
              actualCodingFunc = function(string2) {
                return URI[_codingFuncName](URI[_innerCodingFuncName](string2));
              };
            }
            var segments = (string + "").split(_sep);
            for (var i = 0, length3 = segments.length; i < length3; i++) {
              segments[i] = actualCodingFunc(segments[i]);
            }
            return segments.join(_sep);
          };
        };
        URI.decodePath = generateSegmentedPathFunction("/", "decodePathSegment");
        URI.decodeUrnPath = generateSegmentedPathFunction(":", "decodeUrnPathSegment");
        URI.recodePath = generateSegmentedPathFunction("/", "encodePathSegment", "decode");
        URI.recodeUrnPath = generateSegmentedPathFunction(":", "encodeUrnPathSegment", "decode");
        URI.encodeReserved = generateAccessor("reserved", "encode");
        URI.parse = function(string, parts) {
          var pos;
          if (!parts) {
            parts = {
              preventInvalidHostname: URI.preventInvalidHostname
            };
          }
          string = string.replace(URI.leading_whitespace_expression, "");
          string = string.replace(URI.ascii_tab_whitespace, "");
          pos = string.indexOf("#");
          if (pos > -1) {
            parts.fragment = string.substring(pos + 1) || null;
            string = string.substring(0, pos);
          }
          pos = string.indexOf("?");
          if (pos > -1) {
            parts.query = string.substring(pos + 1) || null;
            string = string.substring(0, pos);
          }
          string = string.replace(/^(https?|ftp|wss?)?:+[/\\]*/i, "$1://");
          string = string.replace(/^[/\\]{2,}/i, "//");
          if (string.substring(0, 2) === "//") {
            parts.protocol = null;
            string = string.substring(2);
            string = URI.parseAuthority(string, parts);
          } else {
            pos = string.indexOf(":");
            if (pos > -1) {
              parts.protocol = string.substring(0, pos) || null;
              if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
                parts.protocol = void 0;
              } else if (string.substring(pos + 1, pos + 3).replace(/\\/g, "/") === "//") {
                string = string.substring(pos + 3);
                string = URI.parseAuthority(string, parts);
              } else {
                string = string.substring(pos + 1);
                parts.urn = true;
              }
            }
          }
          parts.path = string;
          return parts;
        };
        URI.parseHost = function(string, parts) {
          if (!string) {
            string = "";
          }
          string = string.replace(/\\/g, "/");
          var pos = string.indexOf("/");
          var bracketPos;
          var t;
          if (pos === -1) {
            pos = string.length;
          }
          if (string.charAt(0) === "[") {
            bracketPos = string.indexOf("]");
            parts.hostname = string.substring(1, bracketPos) || null;
            parts.port = string.substring(bracketPos + 2, pos) || null;
            if (parts.port === "/") {
              parts.port = null;
            }
          } else {
            var firstColon = string.indexOf(":");
            var firstSlash = string.indexOf("/");
            var nextColon = string.indexOf(":", firstColon + 1);
            if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
              parts.hostname = string.substring(0, pos) || null;
              parts.port = null;
            } else {
              t = string.substring(0, pos).split(":");
              parts.hostname = t[0] || null;
              parts.port = t[1] || null;
            }
          }
          if (parts.hostname && string.substring(pos).charAt(0) !== "/") {
            pos++;
            string = "/" + string;
          }
          if (parts.preventInvalidHostname) {
            URI.ensureValidHostname(parts.hostname, parts.protocol);
          }
          if (parts.port) {
            URI.ensureValidPort(parts.port);
          }
          return string.substring(pos) || "/";
        };
        URI.parseAuthority = function(string, parts) {
          string = URI.parseUserinfo(string, parts);
          return URI.parseHost(string, parts);
        };
        URI.parseUserinfo = function(string, parts) {
          var _string = string;
          var firstBackSlash = string.indexOf("\\");
          if (firstBackSlash !== -1) {
            string = string.replace(/\\/g, "/");
          }
          var firstSlash = string.indexOf("/");
          var pos = string.lastIndexOf("@", firstSlash > -1 ? firstSlash : string.length - 1);
          var t;
          if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
            t = string.substring(0, pos).split(":");
            parts.username = t[0] ? URI.decode(t[0]) : null;
            t.shift();
            parts.password = t[0] ? URI.decode(t.join(":")) : null;
            string = _string.substring(pos + 1);
          } else {
            parts.username = null;
            parts.password = null;
          }
          return string;
        };
        URI.parseQuery = function(string, escapeQuerySpace) {
          if (!string) {
            return {};
          }
          string = string.replace(/&+/g, "&").replace(/^\?*&*|&+$/g, "");
          if (!string) {
            return {};
          }
          var items = {};
          var splits = string.split("&");
          var length3 = splits.length;
          var v7, name, value;
          for (var i = 0; i < length3; i++) {
            v7 = splits[i].split("=");
            name = URI.decodeQuery(v7.shift(), escapeQuerySpace);
            value = v7.length ? URI.decodeQuery(v7.join("="), escapeQuerySpace) : null;
            if (name === "__proto__") {
              continue;
            } else if (hasOwn.call(items, name)) {
              if (typeof items[name] === "string" || items[name] === null) {
                items[name] = [items[name]];
              }
              items[name].push(value);
            } else {
              items[name] = value;
            }
          }
          return items;
        };
        URI.build = function(parts) {
          var t = "";
          var requireAbsolutePath = false;
          if (parts.protocol) {
            t += parts.protocol + ":";
          }
          if (!parts.urn && (t || parts.hostname)) {
            t += "//";
            requireAbsolutePath = true;
          }
          t += URI.buildAuthority(parts) || "";
          if (typeof parts.path === "string") {
            if (parts.path.charAt(0) !== "/" && requireAbsolutePath) {
              t += "/";
            }
            t += parts.path;
          }
          if (typeof parts.query === "string" && parts.query) {
            t += "?" + parts.query;
          }
          if (typeof parts.fragment === "string" && parts.fragment) {
            t += "#" + parts.fragment;
          }
          return t;
        };
        URI.buildHost = function(parts) {
          var t = "";
          if (!parts.hostname) {
            return "";
          } else if (URI.ip6_expression.test(parts.hostname)) {
            t += "[" + parts.hostname + "]";
          } else {
            t += parts.hostname;
          }
          if (parts.port) {
            t += ":" + parts.port;
          }
          return t;
        };
        URI.buildAuthority = function(parts) {
          return URI.buildUserinfo(parts) + URI.buildHost(parts);
        };
        URI.buildUserinfo = function(parts) {
          var t = "";
          if (parts.username) {
            t += URI.encode(parts.username);
          }
          if (parts.password) {
            t += ":" + URI.encode(parts.password);
          }
          if (t) {
            t += "@";
          }
          return t;
        };
        URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
          var t = "";
          var unique, key, i, length3;
          for (key in data) {
            if (key === "__proto__") {
              continue;
            } else if (hasOwn.call(data, key)) {
              if (isArray(data[key])) {
                unique = {};
                for (i = 0, length3 = data[key].length; i < length3; i++) {
                  if (data[key][i] !== void 0 && unique[data[key][i] + ""] === void 0) {
                    t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                    if (duplicateQueryParameters !== true) {
                      unique[data[key][i] + ""] = true;
                    }
                  }
                }
              } else if (data[key] !== void 0) {
                t += "&" + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
              }
            }
          }
          return t.substring(1);
        };
        URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
          return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
        };
        URI.addQuery = function(data, name, value) {
          if (typeof name === "object") {
            for (var key in name) {
              if (hasOwn.call(name, key)) {
                URI.addQuery(data, key, name[key]);
              }
            }
          } else if (typeof name === "string") {
            if (data[name] === void 0) {
              data[name] = value;
              return;
            } else if (typeof data[name] === "string") {
              data[name] = [data[name]];
            }
            if (!isArray(value)) {
              value = [value];
            }
            data[name] = (data[name] || []).concat(value);
          } else {
            throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
          }
        };
        URI.setQuery = function(data, name, value) {
          if (typeof name === "object") {
            for (var key in name) {
              if (hasOwn.call(name, key)) {
                URI.setQuery(data, key, name[key]);
              }
            }
          } else if (typeof name === "string") {
            data[name] = value === void 0 ? null : value;
          } else {
            throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");
          }
        };
        URI.removeQuery = function(data, name, value) {
          var i, length3, key;
          if (isArray(name)) {
            for (i = 0, length3 = name.length; i < length3; i++) {
              data[name[i]] = void 0;
            }
          } else if (getType(name) === "RegExp") {
            for (key in data) {
              if (name.test(key)) {
                data[key] = void 0;
              }
            }
          } else if (typeof name === "object") {
            for (key in name) {
              if (hasOwn.call(name, key)) {
                URI.removeQuery(data, key, name[key]);
              }
            }
          } else if (typeof name === "string") {
            if (value !== void 0) {
              if (getType(value) === "RegExp") {
                if (!isArray(data[name]) && value.test(data[name])) {
                  data[name] = void 0;
                } else {
                  data[name] = filterArrayValues(data[name], value);
                }
              } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
                data[name] = void 0;
              } else if (isArray(data[name])) {
                data[name] = filterArrayValues(data[name], value);
              }
            } else {
              data[name] = void 0;
            }
          } else {
            throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");
          }
        };
        URI.hasQuery = function(data, name, value, withinArray) {
          switch (getType(name)) {
            case "String":
              break;
            case "RegExp":
              for (var key in data) {
                if (hasOwn.call(data, key)) {
                  if (name.test(key) && (value === void 0 || URI.hasQuery(data, key, value))) {
                    return true;
                  }
                }
              }
              return false;
            case "Object":
              for (var _key in name) {
                if (hasOwn.call(name, _key)) {
                  if (!URI.hasQuery(data, _key, name[_key])) {
                    return false;
                  }
                }
              }
              return true;
            default:
              throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter");
          }
          switch (getType(value)) {
            case "Undefined":
              return name in data;
            case "Boolean":
              var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
              return value === _booly;
            case "Function":
              return !!value(data[name], name, data);
            case "Array":
              if (!isArray(data[name])) {
                return false;
              }
              var op = withinArray ? arrayContains : arraysEqual;
              return op(data[name], value);
            case "RegExp":
              if (!isArray(data[name])) {
                return Boolean(data[name] && data[name].match(value));
              }
              if (!withinArray) {
                return false;
              }
              return arrayContains(data[name], value);
            case "Number":
              value = String(value);
            case "String":
              if (!isArray(data[name])) {
                return data[name] === value;
              }
              if (!withinArray) {
                return false;
              }
              return arrayContains(data[name], value);
            default:
              throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
          }
        };
        URI.joinPaths = function() {
          var input = [];
          var segments = [];
          var nonEmptySegments = 0;
          for (var i = 0; i < arguments.length; i++) {
            var url2 = new URI(arguments[i]);
            input.push(url2);
            var _segments = url2.segment();
            for (var s = 0; s < _segments.length; s++) {
              if (typeof _segments[s] === "string") {
                segments.push(_segments[s]);
              }
              if (_segments[s]) {
                nonEmptySegments++;
              }
            }
          }
          if (!segments.length || !nonEmptySegments) {
            return new URI("");
          }
          var uri = new URI("").segment(segments);
          if (input[0].path() === "" || input[0].path().slice(0, 1) === "/") {
            uri.path("/" + uri.path());
          }
          return uri.normalize();
        };
        URI.commonPath = function(one, two) {
          var length3 = Math.min(one.length, two.length);
          var pos;
          for (pos = 0; pos < length3; pos++) {
            if (one.charAt(pos) !== two.charAt(pos)) {
              pos--;
              break;
            }
          }
          if (pos < 1) {
            return one.charAt(0) === two.charAt(0) && one.charAt(0) === "/" ? "/" : "";
          }
          if (one.charAt(pos) !== "/" || two.charAt(pos) !== "/") {
            pos = one.substring(0, pos).lastIndexOf("/");
          }
          return one.substring(0, pos + 1);
        };
        URI.withinString = function(string, callback, options) {
          options || (options = {});
          var _start = options.start || URI.findUri.start;
          var _end = options.end || URI.findUri.end;
          var _trim = options.trim || URI.findUri.trim;
          var _parens = options.parens || URI.findUri.parens;
          var _attributeOpen = /[a-z0-9-]=["']?$/i;
          _start.lastIndex = 0;
          while (true) {
            var match = _start.exec(string);
            if (!match) {
              break;
            }
            var start = match.index;
            if (options.ignoreHtml) {
              var attributeOpen = string.slice(Math.max(start - 3, 0), start);
              if (attributeOpen && _attributeOpen.test(attributeOpen)) {
                continue;
              }
            }
            var end = start + string.slice(start).search(_end);
            var slice = string.slice(start, end);
            var parensEnd = -1;
            while (true) {
              var parensMatch = _parens.exec(slice);
              if (!parensMatch) {
                break;
              }
              var parensMatchEnd = parensMatch.index + parensMatch[0].length;
              parensEnd = Math.max(parensEnd, parensMatchEnd);
            }
            if (parensEnd > -1) {
              slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, "");
            } else {
              slice = slice.replace(_trim, "");
            }
            if (slice.length <= match[0].length) {
              continue;
            }
            if (options.ignore && options.ignore.test(slice)) {
              continue;
            }
            end = start + slice.length;
            var result = callback(slice, start, end, string);
            if (result === void 0) {
              _start.lastIndex = end;
              continue;
            }
            result = String(result);
            string = string.slice(0, start) + result + string.slice(end);
            _start.lastIndex = start + result.length;
          }
          _start.lastIndex = 0;
          return string;
        };
        URI.ensureValidHostname = function(v7, protocol) {
          var hasHostname = !!v7;
          var hasProtocol = !!protocol;
          var rejectEmptyHostname = false;
          if (hasProtocol) {
            rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
          }
          if (rejectEmptyHostname && !hasHostname) {
            throw new TypeError("Hostname cannot be empty, if protocol is " + protocol);
          } else if (v7 && v7.match(URI.invalid_hostname_characters)) {
            if (!punycode) {
              throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
            }
            if (punycode.toASCII(v7).match(URI.invalid_hostname_characters)) {
              throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-:_]');
            }
          }
        };
        URI.ensureValidPort = function(v7) {
          if (!v7) {
            return;
          }
          var port = Number(v7);
          if (isInteger(port) && port > 0 && port < 65536) {
            return;
          }
          throw new TypeError('Port "' + v7 + '" is not a valid port');
        };
        URI.noConflict = function(removeAll2) {
          if (removeAll2) {
            var unconflicted = {
              URI: this.noConflict()
            };
            if (root.URITemplate && typeof root.URITemplate.noConflict === "function") {
              unconflicted.URITemplate = root.URITemplate.noConflict();
            }
            if (root.IPv6 && typeof root.IPv6.noConflict === "function") {
              unconflicted.IPv6 = root.IPv6.noConflict();
            }
            if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === "function") {
              unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
            }
            return unconflicted;
          } else if (root.URI === this) {
            root.URI = _URI;
          }
          return this;
        };
        p.build = function(deferBuild) {
          if (deferBuild === true) {
            this._deferred_build = true;
          } else if (deferBuild === void 0 || this._deferred_build) {
            this._string = URI.build(this._parts);
            this._deferred_build = false;
          }
          return this;
        };
        p.clone = function() {
          return new URI(this);
        };
        p.valueOf = p.toString = function() {
          return this.build(false)._string;
        };
        function generateSimpleAccessor(_part2) {
          return function(v7, build) {
            if (v7 === void 0) {
              return this._parts[_part2] || "";
            } else {
              this._parts[_part2] = v7 || null;
              this.build(!build);
              return this;
            }
          };
        }
        function generatePrefixAccessor(_part2, _key) {
          return function(v7, build) {
            if (v7 === void 0) {
              return this._parts[_part2] || "";
            } else {
              if (v7 !== null) {
                v7 = v7 + "";
                if (v7.charAt(0) === _key) {
                  v7 = v7.substring(1);
                }
              }
              this._parts[_part2] = v7;
              this.build(!build);
              return this;
            }
          };
        }
        p.protocol = generateSimpleAccessor("protocol");
        p.username = generateSimpleAccessor("username");
        p.password = generateSimpleAccessor("password");
        p.hostname = generateSimpleAccessor("hostname");
        p.port = generateSimpleAccessor("port");
        p.query = generatePrefixAccessor("query", "?");
        p.fragment = generatePrefixAccessor("fragment", "#");
        p.search = function(v7, build) {
          var t = this.query(v7, build);
          return typeof t === "string" && t.length ? "?" + t : t;
        };
        p.hash = function(v7, build) {
          var t = this.fragment(v7, build);
          return typeof t === "string" && t.length ? "#" + t : t;
        };
        p.pathname = function(v7, build) {
          if (v7 === void 0 || v7 === true) {
            var res = this._parts.path || (this._parts.hostname ? "/" : "");
            return v7 ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
          } else {
            if (this._parts.urn) {
              this._parts.path = v7 ? URI.recodeUrnPath(v7) : "";
            } else {
              this._parts.path = v7 ? URI.recodePath(v7) : "/";
            }
            this.build(!build);
            return this;
          }
        };
        p.path = p.pathname;
        p.href = function(href, build) {
          var key;
          if (href === void 0) {
            return this.toString();
          }
          this._string = "";
          this._parts = URI._parts();
          var _URI2 = href instanceof URI;
          var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
          if (href.nodeName) {
            var attribute = URI.getDomAttribute(href);
            href = href[attribute] || "";
            _object = false;
          }
          if (!_URI2 && _object && href.pathname !== void 0) {
            href = href.toString();
          }
          if (typeof href === "string" || href instanceof String) {
            this._parts = URI.parse(String(href), this._parts);
          } else if (_URI2 || _object) {
            var src = _URI2 ? href._parts : href;
            for (key in src) {
              if (key === "query") {
                continue;
              }
              if (hasOwn.call(this._parts, key)) {
                this._parts[key] = src[key];
              }
            }
            if (src.query) {
              this.query(src.query, false);
            }
          } else {
            throw new TypeError("invalid input");
          }
          this.build(!build);
          return this;
        };
        p.is = function(what) {
          var ip = false;
          var ip4 = false;
          var ip6 = false;
          var name = false;
          var sld = false;
          var idn = false;
          var punycode2 = false;
          var relative = !this._parts.urn;
          if (this._parts.hostname) {
            relative = false;
            ip4 = URI.ip4_expression.test(this._parts.hostname);
            ip6 = URI.ip6_expression.test(this._parts.hostname);
            ip = ip4 || ip6;
            name = !ip;
            sld = name && SLD && SLD.has(this._parts.hostname);
            idn = name && URI.idn_expression.test(this._parts.hostname);
            punycode2 = name && URI.punycode_expression.test(this._parts.hostname);
          }
          switch (what.toLowerCase()) {
            case "relative":
              return relative;
            case "absolute":
              return !relative;
            case "domain":
            case "name":
              return name;
            case "sld":
              return sld;
            case "ip":
              return ip;
            case "ip4":
            case "ipv4":
            case "inet4":
              return ip4;
            case "ip6":
            case "ipv6":
            case "inet6":
              return ip6;
            case "idn":
              return idn;
            case "url":
              return !this._parts.urn;
            case "urn":
              return !!this._parts.urn;
            case "punycode":
              return punycode2;
          }
          return null;
        };
        var _protocol = p.protocol;
        var _port = p.port;
        var _hostname = p.hostname;
        p.protocol = function(v7, build) {
          if (v7) {
            v7 = v7.replace(/:(\/\/)?$/, "");
            if (!v7.match(URI.protocol_expression)) {
              throw new TypeError('Protocol "' + v7 + `" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);
            }
          }
          return _protocol.call(this, v7, build);
        };
        p.scheme = p.protocol;
        p.port = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 !== void 0) {
            if (v7 === 0) {
              v7 = null;
            }
            if (v7) {
              v7 += "";
              if (v7.charAt(0) === ":") {
                v7 = v7.substring(1);
              }
              URI.ensureValidPort(v7);
            }
          }
          return _port.call(this, v7, build);
        };
        p.hostname = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 !== void 0) {
            var x = { preventInvalidHostname: this._parts.preventInvalidHostname };
            var res = URI.parseHost(v7, x);
            if (res !== "/") {
              throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
            }
            v7 = x.hostname;
            if (this._parts.preventInvalidHostname) {
              URI.ensureValidHostname(v7, this._parts.protocol);
            }
          }
          return _hostname.call(this, v7, build);
        };
        p.origin = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 === void 0) {
            var protocol = this.protocol();
            var authority = this.authority();
            if (!authority) {
              return "";
            }
            return (protocol ? protocol + "://" : "") + this.authority();
          } else {
            var origin = URI(v7);
            this.protocol(origin.protocol()).authority(origin.authority()).build(!build);
            return this;
          }
        };
        p.host = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 === void 0) {
            return this._parts.hostname ? URI.buildHost(this._parts) : "";
          } else {
            var res = URI.parseHost(v7, this._parts);
            if (res !== "/") {
              throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
            }
            this.build(!build);
            return this;
          }
        };
        p.authority = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 === void 0) {
            return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
          } else {
            var res = URI.parseAuthority(v7, this._parts);
            if (res !== "/") {
              throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
            }
            this.build(!build);
            return this;
          }
        };
        p.userinfo = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 === void 0) {
            var t = URI.buildUserinfo(this._parts);
            return t ? t.substring(0, t.length - 1) : t;
          } else {
            if (v7[v7.length - 1] !== "@") {
              v7 += "@";
            }
            URI.parseUserinfo(v7, this._parts);
            this.build(!build);
            return this;
          }
        };
        p.resource = function(v7, build) {
          var parts;
          if (v7 === void 0) {
            return this.path() + this.search() + this.hash();
          }
          parts = URI.parse(v7);
          this._parts.path = parts.path;
          this._parts.query = parts.query;
          this._parts.fragment = parts.fragment;
          this.build(!build);
          return this;
        };
        p.subdomain = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 === void 0) {
            if (!this._parts.hostname || this.is("IP")) {
              return "";
            }
            var end = this._parts.hostname.length - this.domain().length - 1;
            return this._parts.hostname.substring(0, end) || "";
          } else {
            var e = this._parts.hostname.length - this.domain().length;
            var sub = this._parts.hostname.substring(0, e);
            var replace = new RegExp("^" + escapeRegEx(sub));
            if (v7 && v7.charAt(v7.length - 1) !== ".") {
              v7 += ".";
            }
            if (v7.indexOf(":") !== -1) {
              throw new TypeError("Domains cannot contain colons");
            }
            if (v7) {
              URI.ensureValidHostname(v7, this._parts.protocol);
            }
            this._parts.hostname = this._parts.hostname.replace(replace, v7);
            this.build(!build);
            return this;
          }
        };
        p.domain = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (typeof v7 === "boolean") {
            build = v7;
            v7 = void 0;
          }
          if (v7 === void 0) {
            if (!this._parts.hostname || this.is("IP")) {
              return "";
            }
            var t = this._parts.hostname.match(/\./g);
            if (t && t.length < 2) {
              return this._parts.hostname;
            }
            var end = this._parts.hostname.length - this.tld(build).length - 1;
            end = this._parts.hostname.lastIndexOf(".", end - 1) + 1;
            return this._parts.hostname.substring(end) || "";
          } else {
            if (!v7) {
              throw new TypeError("cannot set domain empty");
            }
            if (v7.indexOf(":") !== -1) {
              throw new TypeError("Domains cannot contain colons");
            }
            URI.ensureValidHostname(v7, this._parts.protocol);
            if (!this._parts.hostname || this.is("IP")) {
              this._parts.hostname = v7;
            } else {
              var replace = new RegExp(escapeRegEx(this.domain()) + "$");
              this._parts.hostname = this._parts.hostname.replace(replace, v7);
            }
            this.build(!build);
            return this;
          }
        };
        p.tld = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (typeof v7 === "boolean") {
            build = v7;
            v7 = void 0;
          }
          if (v7 === void 0) {
            if (!this._parts.hostname || this.is("IP")) {
              return "";
            }
            var pos = this._parts.hostname.lastIndexOf(".");
            var tld = this._parts.hostname.substring(pos + 1);
            if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
              return SLD.get(this._parts.hostname) || tld;
            }
            return tld;
          } else {
            var replace;
            if (!v7) {
              throw new TypeError("cannot set TLD empty");
            } else if (v7.match(/[^a-zA-Z0-9-]/)) {
              if (SLD && SLD.is(v7)) {
                replace = new RegExp(escapeRegEx(this.tld()) + "$");
                this._parts.hostname = this._parts.hostname.replace(replace, v7);
              } else {
                throw new TypeError('TLD "' + v7 + '" contains characters other than [A-Z0-9]');
              }
            } else if (!this._parts.hostname || this.is("IP")) {
              throw new ReferenceError("cannot set TLD on non-domain host");
            } else {
              replace = new RegExp(escapeRegEx(this.tld()) + "$");
              this._parts.hostname = this._parts.hostname.replace(replace, v7);
            }
            this.build(!build);
            return this;
          }
        };
        p.directory = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 === void 0 || v7 === true) {
            if (!this._parts.path && !this._parts.hostname) {
              return "";
            }
            if (this._parts.path === "/") {
              return "/";
            }
            var end = this._parts.path.length - this.filename().length - 1;
            var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");
            return v7 ? URI.decodePath(res) : res;
          } else {
            var e = this._parts.path.length - this.filename().length;
            var directory = this._parts.path.substring(0, e);
            var replace = new RegExp("^" + escapeRegEx(directory));
            if (!this.is("relative")) {
              if (!v7) {
                v7 = "/";
              }
              if (v7.charAt(0) !== "/") {
                v7 = "/" + v7;
              }
            }
            if (v7 && v7.charAt(v7.length - 1) !== "/") {
              v7 += "/";
            }
            v7 = URI.recodePath(v7);
            this._parts.path = this._parts.path.replace(replace, v7);
            this.build(!build);
            return this;
          }
        };
        p.filename = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (typeof v7 !== "string") {
            if (!this._parts.path || this._parts.path === "/") {
              return "";
            }
            var pos = this._parts.path.lastIndexOf("/");
            var res = this._parts.path.substring(pos + 1);
            return v7 ? URI.decodePathSegment(res) : res;
          } else {
            var mutatedDirectory = false;
            if (v7.charAt(0) === "/") {
              v7 = v7.substring(1);
            }
            if (v7.match(/\.?\//)) {
              mutatedDirectory = true;
            }
            var replace = new RegExp(escapeRegEx(this.filename()) + "$");
            v7 = URI.recodePath(v7);
            this._parts.path = this._parts.path.replace(replace, v7);
            if (mutatedDirectory) {
              this.normalizePath(build);
            } else {
              this.build(!build);
            }
            return this;
          }
        };
        p.suffix = function(v7, build) {
          if (this._parts.urn) {
            return v7 === void 0 ? "" : this;
          }
          if (v7 === void 0 || v7 === true) {
            if (!this._parts.path || this._parts.path === "/") {
              return "";
            }
            var filename = this.filename();
            var pos = filename.lastIndexOf(".");
            var s, res;
            if (pos === -1) {
              return "";
            }
            s = filename.substring(pos + 1);
            res = /^[a-z0-9%]+$/i.test(s) ? s : "";
            return v7 ? URI.decodePathSegment(res) : res;
          } else {
            if (v7.charAt(0) === ".") {
              v7 = v7.substring(1);
            }
            var suffix = this.suffix();
            var replace;
            if (!suffix) {
              if (!v7) {
                return this;
              }
              this._parts.path += "." + URI.recodePath(v7);
            } else if (!v7) {
              replace = new RegExp(escapeRegEx("." + suffix) + "$");
            } else {
              replace = new RegExp(escapeRegEx(suffix) + "$");
            }
            if (replace) {
              v7 = URI.recodePath(v7);
              this._parts.path = this._parts.path.replace(replace, v7);
            }
            this.build(!build);
            return this;
          }
        };
        p.segment = function(segment, v7, build) {
          var separator = this._parts.urn ? ":" : "/";
          var path = this.path();
          var absolute = path.substring(0, 1) === "/";
          var segments = path.split(separator);
          if (segment !== void 0 && typeof segment !== "number") {
            build = v7;
            v7 = segment;
            segment = void 0;
          }
          if (segment !== void 0 && typeof segment !== "number") {
            throw new Error('Bad segment "' + segment + '", must be 0-based integer');
          }
          if (absolute) {
            segments.shift();
          }
          if (segment < 0) {
            segment = Math.max(segments.length + segment, 0);
          }
          if (v7 === void 0) {
            return segment === void 0 ? segments : segments[segment];
          } else if (segment === null || segments[segment] === void 0) {
            if (isArray(v7)) {
              segments = [];
              for (var i = 0, l = v7.length; i < l; i++) {
                if (!v7[i].length && (!segments.length || !segments[segments.length - 1].length)) {
                  continue;
                }
                if (segments.length && !segments[segments.length - 1].length) {
                  segments.pop();
                }
                segments.push(trimSlashes(v7[i]));
              }
            } else if (v7 || typeof v7 === "string") {
              v7 = trimSlashes(v7);
              if (segments[segments.length - 1] === "") {
                segments[segments.length - 1] = v7;
              } else {
                segments.push(v7);
              }
            }
          } else {
            if (v7) {
              segments[segment] = trimSlashes(v7);
            } else {
              segments.splice(segment, 1);
            }
          }
          if (absolute) {
            segments.unshift("");
          }
          return this.path(segments.join(separator), build);
        };
        p.segmentCoded = function(segment, v7, build) {
          var segments, i, l;
          if (typeof segment !== "number") {
            build = v7;
            v7 = segment;
            segment = void 0;
          }
          if (v7 === void 0) {
            segments = this.segment(segment, v7, build);
            if (!isArray(segments)) {
              segments = segments !== void 0 ? URI.decode(segments) : void 0;
            } else {
              for (i = 0, l = segments.length; i < l; i++) {
                segments[i] = URI.decode(segments[i]);
              }
            }
            return segments;
          }
          if (!isArray(v7)) {
            v7 = typeof v7 === "string" || v7 instanceof String ? URI.encode(v7) : v7;
          } else {
            for (i = 0, l = v7.length; i < l; i++) {
              v7[i] = URI.encode(v7[i]);
            }
          }
          return this.segment(segment, v7, build);
        };
        var q = p.query;
        p.query = function(v7, build) {
          if (v7 === true) {
            return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          } else if (typeof v7 === "function") {
            var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
            var result = v7.call(this, data);
            this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
            this.build(!build);
            return this;
          } else if (v7 !== void 0 && typeof v7 !== "string") {
            this._parts.query = URI.buildQuery(v7, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
            this.build(!build);
            return this;
          } else {
            return q.call(this, v7, build);
          }
        };
        p.setQuery = function(name, value, build) {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          if (typeof name === "string" || name instanceof String) {
            data[name] = value !== void 0 ? value : null;
          } else if (typeof name === "object") {
            for (var key in name) {
              if (hasOwn.call(name, key)) {
                data[key] = name[key];
              }
            }
          } else {
            throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
          }
          this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          if (typeof name !== "string") {
            build = value;
          }
          this.build(!build);
          return this;
        };
        p.addQuery = function(name, value, build) {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          URI.addQuery(data, name, value === void 0 ? null : value);
          this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          if (typeof name !== "string") {
            build = value;
          }
          this.build(!build);
          return this;
        };
        p.removeQuery = function(name, value, build) {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          URI.removeQuery(data, name, value);
          this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          if (typeof name !== "string") {
            build = value;
          }
          this.build(!build);
          return this;
        };
        p.hasQuery = function(name, value, withinArray) {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          return URI.hasQuery(data, name, value, withinArray);
        };
        p.setSearch = p.setQuery;
        p.addSearch = p.addQuery;
        p.removeSearch = p.removeQuery;
        p.hasSearch = p.hasQuery;
        p.normalize = function() {
          if (this._parts.urn) {
            return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
          }
          return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
        };
        p.normalizeProtocol = function(build) {
          if (typeof this._parts.protocol === "string") {
            this._parts.protocol = this._parts.protocol.toLowerCase();
            this.build(!build);
          }
          return this;
        };
        p.normalizeHostname = function(build) {
          if (this._parts.hostname) {
            if (this.is("IDN") && punycode) {
              this._parts.hostname = punycode.toASCII(this._parts.hostname);
            } else if (this.is("IPv6") && IPv6) {
              this._parts.hostname = IPv6.best(this._parts.hostname);
            }
            this._parts.hostname = this._parts.hostname.toLowerCase();
            this.build(!build);
          }
          return this;
        };
        p.normalizePort = function(build) {
          if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
            this._parts.port = null;
            this.build(!build);
          }
          return this;
        };
        p.normalizePath = function(build) {
          var _path = this._parts.path;
          if (!_path) {
            return this;
          }
          if (this._parts.urn) {
            this._parts.path = URI.recodeUrnPath(this._parts.path);
            this.build(!build);
            return this;
          }
          if (this._parts.path === "/") {
            return this;
          }
          _path = URI.recodePath(_path);
          var _was_relative;
          var _leadingParents = "";
          var _parent, _pos;
          if (_path.charAt(0) !== "/") {
            _was_relative = true;
            _path = "/" + _path;
          }
          if (_path.slice(-3) === "/.." || _path.slice(-2) === "/.") {
            _path += "/";
          }
          _path = _path.replace(/(\/(\.\/)+)|(\/\.$)/g, "/").replace(/\/{2,}/g, "/");
          if (_was_relative) {
            _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || "";
            if (_leadingParents) {
              _leadingParents = _leadingParents[0];
            }
          }
          while (true) {
            _parent = _path.search(/\/\.\.(\/|$)/);
            if (_parent === -1) {
              break;
            } else if (_parent === 0) {
              _path = _path.substring(3);
              continue;
            }
            _pos = _path.substring(0, _parent).lastIndexOf("/");
            if (_pos === -1) {
              _pos = _parent;
            }
            _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
          }
          if (_was_relative && this.is("relative")) {
            _path = _leadingParents + _path.substring(1);
          }
          this._parts.path = _path;
          this.build(!build);
          return this;
        };
        p.normalizePathname = p.normalizePath;
        p.normalizeQuery = function(build) {
          if (typeof this._parts.query === "string") {
            if (!this._parts.query.length) {
              this._parts.query = null;
            } else {
              this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
            }
            this.build(!build);
          }
          return this;
        };
        p.normalizeFragment = function(build) {
          if (!this._parts.fragment) {
            this._parts.fragment = null;
            this.build(!build);
          }
          return this;
        };
        p.normalizeSearch = p.normalizeQuery;
        p.normalizeHash = p.normalizeFragment;
        p.iso8859 = function() {
          var e = URI.encode;
          var d = URI.decode;
          URI.encode = escape;
          URI.decode = decodeURIComponent;
          try {
            this.normalize();
          } finally {
            URI.encode = e;
            URI.decode = d;
          }
          return this;
        };
        p.unicode = function() {
          var e = URI.encode;
          var d = URI.decode;
          URI.encode = strictEncodeURIComponent;
          URI.decode = unescape;
          try {
            this.normalize();
          } finally {
            URI.encode = e;
            URI.decode = d;
          }
          return this;
        };
        p.readable = function() {
          var uri = this.clone();
          uri.username("").password("").normalize();
          var t = "";
          if (uri._parts.protocol) {
            t += uri._parts.protocol + "://";
          }
          if (uri._parts.hostname) {
            if (uri.is("punycode") && punycode) {
              t += punycode.toUnicode(uri._parts.hostname);
              if (uri._parts.port) {
                t += ":" + uri._parts.port;
              }
            } else {
              t += uri.host();
            }
          }
          if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== "/") {
            t += "/";
          }
          t += uri.path(true);
          if (uri._parts.query) {
            var q3 = "";
            for (var i = 0, qp = uri._parts.query.split("&"), l = qp.length; i < l; i++) {
              var kv = (qp[i] || "").split("=");
              q3 += "&" + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace).replace(/&/g, "%26");
              if (kv[1] !== void 0) {
                q3 += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace).replace(/&/g, "%26");
              }
            }
            t += "?" + q3.substring(1);
          }
          t += URI.decodeQuery(uri.hash(), true);
          return t;
        };
        p.absoluteTo = function(base) {
          var resolved = this.clone();
          var properties = ["protocol", "username", "password", "hostname", "port"];
          var basedir, i, p2;
          if (this._parts.urn) {
            throw new Error("URNs do not have any generally defined hierarchical components");
          }
          if (!(base instanceof URI)) {
            base = new URI(base);
          }
          if (resolved._parts.protocol) {
            return resolved;
          } else {
            resolved._parts.protocol = base._parts.protocol;
          }
          if (this._parts.hostname) {
            return resolved;
          }
          for (i = 0; p2 = properties[i]; i++) {
            resolved._parts[p2] = base._parts[p2];
          }
          if (!resolved._parts.path) {
            resolved._parts.path = base._parts.path;
            if (!resolved._parts.query) {
              resolved._parts.query = base._parts.query;
            }
          } else {
            if (resolved._parts.path.substring(-2) === "..") {
              resolved._parts.path += "/";
            }
            if (resolved.path().charAt(0) !== "/") {
              basedir = base.directory();
              basedir = basedir ? basedir : base.path().indexOf("/") === 0 ? "/" : "";
              resolved._parts.path = (basedir ? basedir + "/" : "") + resolved._parts.path;
              resolved.normalizePath();
            }
          }
          resolved.build();
          return resolved;
        };
        p.relativeTo = function(base) {
          var relative = this.clone().normalize();
          var relativeParts, baseParts, common, relativePath, basePath;
          if (relative._parts.urn) {
            throw new Error("URNs do not have any generally defined hierarchical components");
          }
          base = new URI(base).normalize();
          relativeParts = relative._parts;
          baseParts = base._parts;
          relativePath = relative.path();
          basePath = base.path();
          if (relativePath.charAt(0) !== "/") {
            throw new Error("URI is already relative");
          }
          if (basePath.charAt(0) !== "/") {
            throw new Error("Cannot calculate a URI relative to another relative URI");
          }
          if (relativeParts.protocol === baseParts.protocol) {
            relativeParts.protocol = null;
          }
          if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
            return relative.build();
          }
          if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
            return relative.build();
          }
          if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
            relativeParts.hostname = null;
            relativeParts.port = null;
          } else {
            return relative.build();
          }
          if (relativePath === basePath) {
            relativeParts.path = "";
            return relative.build();
          }
          common = URI.commonPath(relativePath, basePath);
          if (!common) {
            return relative.build();
          }
          var parents = baseParts.path.substring(common.length).replace(/[^\/]*$/, "").replace(/.*?\//g, "../");
          relativeParts.path = parents + relativeParts.path.substring(common.length) || "./";
          return relative.build();
        };
        p.equals = function(uri) {
          var one = this.clone();
          var two = new URI(uri);
          var one_map = {};
          var two_map = {};
          var checked = {};
          var one_query, two_query, key;
          one.normalize();
          two.normalize();
          if (one.toString() === two.toString()) {
            return true;
          }
          one_query = one.query();
          two_query = two.query();
          one.query("");
          two.query("");
          if (one.toString() !== two.toString()) {
            return false;
          }
          if (one_query.length !== two_query.length) {
            return false;
          }
          one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
          two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);
          for (key in one_map) {
            if (hasOwn.call(one_map, key)) {
              if (!isArray(one_map[key])) {
                if (one_map[key] !== two_map[key]) {
                  return false;
                }
              } else if (!arraysEqual(one_map[key], two_map[key])) {
                return false;
              }
              checked[key] = true;
            }
          }
          for (key in two_map) {
            if (hasOwn.call(two_map, key)) {
              if (!checked[key]) {
                return false;
              }
            }
          }
          return true;
        };
        p.preventInvalidHostname = function(v7) {
          this._parts.preventInvalidHostname = !!v7;
          return this;
        };
        p.duplicateQueryParameters = function(v7) {
          this._parts.duplicateQueryParameters = !!v7;
          return this;
        };
        p.escapeQuerySpace = function(v7) {
          this._parts.escapeQuerySpace = !!v7;
          return this;
        };
        return URI;
      });
    }
  });

  // node_modules/dompurify/dist/purify.js
  var require_purify = __commonJS({
    "node_modules/dompurify/dist/purify.js"(exports2, module2) {
      /*! @license DOMPurify 2.4.7 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.4.7/LICENSE */
      (function(global2, factory) {
        typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, global2.DOMPurify = factory());
      })(exports2, function() {
        "use strict";
        function _typeof(obj) {
          "@babel/helpers - typeof";
          return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
            return typeof obj2;
          } : function(obj2) {
            return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
          }, _typeof(obj);
        }
        function _setPrototypeOf(o, p) {
          _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o2, p2) {
            o2.__proto__ = p2;
            return o2;
          };
          return _setPrototypeOf(o, p);
        }
        function _isNativeReflectConstruct() {
          if (typeof Reflect === "undefined" || !Reflect.construct)
            return false;
          if (Reflect.construct.sham)
            return false;
          if (typeof Proxy === "function")
            return true;
          try {
            Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
            }));
            return true;
          } catch (e) {
            return false;
          }
        }
        function _construct(Parent, args, Class) {
          if (_isNativeReflectConstruct()) {
            _construct = Reflect.construct;
          } else {
            _construct = function _construct2(Parent2, args2, Class2) {
              var a3 = [null];
              a3.push.apply(a3, args2);
              var Constructor = Function.bind.apply(Parent2, a3);
              var instance = new Constructor();
              if (Class2)
                _setPrototypeOf(instance, Class2.prototype);
              return instance;
            };
          }
          return _construct.apply(null, arguments);
        }
        function _toConsumableArray(arr) {
          return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
        }
        function _arrayWithoutHoles(arr) {
          if (Array.isArray(arr))
            return _arrayLikeToArray(arr);
        }
        function _iterableToArray(iter) {
          if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
            return Array.from(iter);
        }
        function _unsupportedIterableToArray(o, minLen) {
          if (!o)
            return;
          if (typeof o === "string")
            return _arrayLikeToArray(o, minLen);
          var n = Object.prototype.toString.call(o).slice(8, -1);
          if (n === "Object" && o.constructor)
            n = o.constructor.name;
          if (n === "Map" || n === "Set")
            return Array.from(o);
          if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
            return _arrayLikeToArray(o, minLen);
        }
        function _arrayLikeToArray(arr, len) {
          if (len == null || len > arr.length)
            len = arr.length;
          for (var i = 0, arr2 = new Array(len); i < len; i++)
            arr2[i] = arr[i];
          return arr2;
        }
        function _nonIterableSpread() {
          throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
        }
        var hasOwnProperty = Object.hasOwnProperty, setPrototypeOf = Object.setPrototypeOf, isFrozen = Object.isFrozen, getPrototypeOf = Object.getPrototypeOf, getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
        var freeze = Object.freeze, seal = Object.seal, create = Object.create;
        var _ref = typeof Reflect !== "undefined" && Reflect, apply = _ref.apply, construct = _ref.construct;
        if (!apply) {
          apply = function apply2(fun, thisValue, args) {
            return fun.apply(thisValue, args);
          };
        }
        if (!freeze) {
          freeze = function freeze2(x) {
            return x;
          };
        }
        if (!seal) {
          seal = function seal2(x) {
            return x;
          };
        }
        if (!construct) {
          construct = function construct2(Func, args) {
            return _construct(Func, _toConsumableArray(args));
          };
        }
        var arrayForEach = unapply(Array.prototype.forEach);
        var arrayPop = unapply(Array.prototype.pop);
        var arrayPush = unapply(Array.prototype.push);
        var stringToLowerCase = unapply(String.prototype.toLowerCase);
        var stringToString = unapply(String.prototype.toString);
        var stringMatch = unapply(String.prototype.match);
        var stringReplace = unapply(String.prototype.replace);
        var stringIndexOf = unapply(String.prototype.indexOf);
        var stringTrim = unapply(String.prototype.trim);
        var regExpTest = unapply(RegExp.prototype.test);
        var typeErrorCreate = unconstruct(TypeError);
        function unapply(func) {
          return function(thisArg) {
            for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
              args[_key - 1] = arguments[_key];
            }
            return apply(func, thisArg, args);
          };
        }
        function unconstruct(func) {
          return function() {
            for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
              args[_key2] = arguments[_key2];
            }
            return construct(func, args);
          };
        }
        function addToSet(set2, array, transformCaseFunc) {
          var _transformCaseFunc;
          transformCaseFunc = (_transformCaseFunc = transformCaseFunc) !== null && _transformCaseFunc !== void 0 ? _transformCaseFunc : stringToLowerCase;
          if (setPrototypeOf) {
            setPrototypeOf(set2, null);
          }
          var l = array.length;
          while (l--) {
            var element = array[l];
            if (typeof element === "string") {
              var lcElement = transformCaseFunc(element);
              if (lcElement !== element) {
                if (!isFrozen(array)) {
                  array[l] = lcElement;
                }
                element = lcElement;
              }
            }
            set2[element] = true;
          }
          return set2;
        }
        function clone2(object2) {
          var newObject = create(null);
          var property;
          for (property in object2) {
            if (apply(hasOwnProperty, object2, [property]) === true) {
              newObject[property] = object2[property];
            }
          }
          return newObject;
        }
        function lookupGetter(object2, prop) {
          while (object2 !== null) {
            var desc = getOwnPropertyDescriptor(object2, prop);
            if (desc) {
              if (desc.get) {
                return unapply(desc.get);
              }
              if (typeof desc.value === "function") {
                return unapply(desc.value);
              }
            }
            object2 = getPrototypeOf(object2);
          }
          function fallbackValue(element) {
            console.warn("fallback value for", element);
            return null;
          }
          return fallbackValue;
        }
        var html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
        var svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
        var svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
        var svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "fedropshadow", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
        var mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover"]);
        var mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
        var text = freeze(["#text"]);
        var html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
        var svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
        var mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
        var xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
        var MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
        var ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
        var TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
        var DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
        var ARIA_ATTR = seal(/^aria-[\-\w]+$/);
        var IS_ALLOWED_URI = seal(
          /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
        );
        var IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
        var ATTR_WHITESPACE = seal(
          /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
        );
        var DOCTYPE_NAME = seal(/^html$/i);
        var getGlobal = function getGlobal2() {
          return typeof window === "undefined" ? null : window;
        };
        var _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, document2) {
          if (_typeof(trustedTypes) !== "object" || typeof trustedTypes.createPolicy !== "function") {
            return null;
          }
          var suffix = null;
          var ATTR_NAME = "data-tt-policy-suffix";
          if (document2.currentScript && document2.currentScript.hasAttribute(ATTR_NAME)) {
            suffix = document2.currentScript.getAttribute(ATTR_NAME);
          }
          var policyName = "dompurify" + (suffix ? "#" + suffix : "");
          try {
            return trustedTypes.createPolicy(policyName, {
              createHTML: function createHTML(html2) {
                return html2;
              },
              createScriptURL: function createScriptURL(scriptUrl) {
                return scriptUrl;
              }
            });
          } catch (_) {
            console.warn("TrustedTypes policy " + policyName + " could not be created.");
            return null;
          }
        };
        function createDOMPurify() {
          var window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
          var DOMPurify2 = function DOMPurify3(root) {
            return createDOMPurify(root);
          };
          DOMPurify2.version = "2.4.7";
          DOMPurify2.removed = [];
          if (!window2 || !window2.document || window2.document.nodeType !== 9) {
            DOMPurify2.isSupported = false;
            return DOMPurify2;
          }
          var originalDocument = window2.document;
          var document2 = window2.document;
          var DocumentFragment2 = window2.DocumentFragment, HTMLTemplateElement = window2.HTMLTemplateElement, Node6 = window2.Node, Element2 = window2.Element, NodeFilter = window2.NodeFilter, _window$NamedNodeMap = window2.NamedNodeMap, NamedNodeMap = _window$NamedNodeMap === void 0 ? window2.NamedNodeMap || window2.MozNamedAttrMap : _window$NamedNodeMap, HTMLFormElement = window2.HTMLFormElement, DOMParser2 = window2.DOMParser, trustedTypes = window2.trustedTypes;
          var ElementPrototype = Element2.prototype;
          var cloneNode = lookupGetter(ElementPrototype, "cloneNode");
          var getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
          var getChildNodes = lookupGetter(ElementPrototype, "childNodes");
          var getParentNode = lookupGetter(ElementPrototype, "parentNode");
          if (typeof HTMLTemplateElement === "function") {
            var template = document2.createElement("template");
            if (template.content && template.content.ownerDocument) {
              document2 = template.content.ownerDocument;
            }
          }
          var trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, originalDocument);
          var emptyHTML = trustedTypesPolicy ? trustedTypesPolicy.createHTML("") : "";
          var _document = document2, implementation2 = _document.implementation, createNodeIterator = _document.createNodeIterator, createDocumentFragment = _document.createDocumentFragment, getElementsByTagName = _document.getElementsByTagName;
          var importNode = originalDocument.importNode;
          var documentMode = {};
          try {
            documentMode = clone2(document2).documentMode ? document2.documentMode : {};
          } catch (_) {
          }
          var hooks = {};
          DOMPurify2.isSupported = typeof getParentNode === "function" && implementation2 && implementation2.createHTMLDocument !== void 0 && documentMode !== 9;
          var MUSTACHE_EXPR$1 = MUSTACHE_EXPR, ERB_EXPR$1 = ERB_EXPR, TMPLIT_EXPR$1 = TMPLIT_EXPR, DATA_ATTR$1 = DATA_ATTR, ARIA_ATTR$1 = ARIA_ATTR, IS_SCRIPT_OR_DATA$1 = IS_SCRIPT_OR_DATA, ATTR_WHITESPACE$1 = ATTR_WHITESPACE;
          var IS_ALLOWED_URI$1 = IS_ALLOWED_URI;
          var ALLOWED_TAGS = null;
          var DEFAULT_ALLOWED_TAGS = addToSet({}, [].concat(_toConsumableArray(html$1), _toConsumableArray(svg$1), _toConsumableArray(svgFilters), _toConsumableArray(mathMl$1), _toConsumableArray(text)));
          var ALLOWED_ATTR = null;
          var DEFAULT_ALLOWED_ATTR = addToSet({}, [].concat(_toConsumableArray(html), _toConsumableArray(svg), _toConsumableArray(mathMl), _toConsumableArray(xml)));
          var CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
            tagNameCheck: {
              writable: true,
              configurable: false,
              enumerable: true,
              value: null
            },
            attributeNameCheck: {
              writable: true,
              configurable: false,
              enumerable: true,
              value: null
            },
            allowCustomizedBuiltInElements: {
              writable: true,
              configurable: false,
              enumerable: true,
              value: false
            }
          }));
          var FORBID_TAGS = null;
          var FORBID_ATTR = null;
          var ALLOW_ARIA_ATTR = true;
          var ALLOW_DATA_ATTR = true;
          var ALLOW_UNKNOWN_PROTOCOLS = false;
          var ALLOW_SELF_CLOSE_IN_ATTR = true;
          var SAFE_FOR_TEMPLATES = false;
          var WHOLE_DOCUMENT = false;
          var SET_CONFIG = false;
          var FORCE_BODY = false;
          var RETURN_DOM = false;
          var RETURN_DOM_FRAGMENT = false;
          var RETURN_TRUSTED_TYPE = false;
          var SANITIZE_DOM = true;
          var SANITIZE_NAMED_PROPS = false;
          var SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
          var KEEP_CONTENT = true;
          var IN_PLACE = false;
          var USE_PROFILES = {};
          var FORBID_CONTENTS = null;
          var DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
          var DATA_URI_TAGS = null;
          var DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
          var URI_SAFE_ATTRIBUTES = null;
          var DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
          var MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
          var SVG_NAMESPACE = "http://www.w3.org/2000/svg";
          var HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
          var NAMESPACE = HTML_NAMESPACE;
          var IS_EMPTY_INPUT = false;
          var ALLOWED_NAMESPACES = null;
          var DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
          var PARSER_MEDIA_TYPE;
          var SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
          var DEFAULT_PARSER_MEDIA_TYPE = "text/html";
          var transformCaseFunc;
          var CONFIG = null;
          var formElement = document2.createElement("form");
          var isRegexOrFunction = function isRegexOrFunction2(testValue) {
            return testValue instanceof RegExp || testValue instanceof Function;
          };
          var _parseConfig = function _parseConfig2(cfg) {
            if (CONFIG && CONFIG === cfg) {
              return;
            }
            if (!cfg || _typeof(cfg) !== "object") {
              cfg = {};
            }
            cfg = clone2(cfg);
            PARSER_MEDIA_TYPE = SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE;
            transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
            ALLOWED_TAGS = "ALLOWED_TAGS" in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
            ALLOWED_ATTR = "ALLOWED_ATTR" in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
            ALLOWED_NAMESPACES = "ALLOWED_NAMESPACES" in cfg ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
            URI_SAFE_ATTRIBUTES = "ADD_URI_SAFE_ATTR" in cfg ? addToSet(
              clone2(DEFAULT_URI_SAFE_ATTRIBUTES),
              cfg.ADD_URI_SAFE_ATTR,
              transformCaseFunc
            ) : DEFAULT_URI_SAFE_ATTRIBUTES;
            DATA_URI_TAGS = "ADD_DATA_URI_TAGS" in cfg ? addToSet(
              clone2(DEFAULT_DATA_URI_TAGS),
              cfg.ADD_DATA_URI_TAGS,
              transformCaseFunc
            ) : DEFAULT_DATA_URI_TAGS;
            FORBID_CONTENTS = "FORBID_CONTENTS" in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
            FORBID_TAGS = "FORBID_TAGS" in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
            FORBID_ATTR = "FORBID_ATTR" in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
            USE_PROFILES = "USE_PROFILES" in cfg ? cfg.USE_PROFILES : false;
            ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
            ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
            ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
            ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
            SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
            WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
            RETURN_DOM = cfg.RETURN_DOM || false;
            RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
            RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
            FORCE_BODY = cfg.FORCE_BODY || false;
            SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
            SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
            KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
            IN_PLACE = cfg.IN_PLACE || false;
            IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI$1;
            NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
            CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
            if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
              CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
            }
            if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
              CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
            }
            if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
              CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
            }
            if (SAFE_FOR_TEMPLATES) {
              ALLOW_DATA_ATTR = false;
            }
            if (RETURN_DOM_FRAGMENT) {
              RETURN_DOM = true;
            }
            if (USE_PROFILES) {
              ALLOWED_TAGS = addToSet({}, _toConsumableArray(text));
              ALLOWED_ATTR = [];
              if (USE_PROFILES.html === true) {
                addToSet(ALLOWED_TAGS, html$1);
                addToSet(ALLOWED_ATTR, html);
              }
              if (USE_PROFILES.svg === true) {
                addToSet(ALLOWED_TAGS, svg$1);
                addToSet(ALLOWED_ATTR, svg);
                addToSet(ALLOWED_ATTR, xml);
              }
              if (USE_PROFILES.svgFilters === true) {
                addToSet(ALLOWED_TAGS, svgFilters);
                addToSet(ALLOWED_ATTR, svg);
                addToSet(ALLOWED_ATTR, xml);
              }
              if (USE_PROFILES.mathMl === true) {
                addToSet(ALLOWED_TAGS, mathMl$1);
                addToSet(ALLOWED_ATTR, mathMl);
                addToSet(ALLOWED_ATTR, xml);
              }
            }
            if (cfg.ADD_TAGS) {
              if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
                ALLOWED_TAGS = clone2(ALLOWED_TAGS);
              }
              addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
            }
            if (cfg.ADD_ATTR) {
              if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
                ALLOWED_ATTR = clone2(ALLOWED_ATTR);
              }
              addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
            }
            if (cfg.ADD_URI_SAFE_ATTR) {
              addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
            }
            if (cfg.FORBID_CONTENTS) {
              if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
                FORBID_CONTENTS = clone2(FORBID_CONTENTS);
              }
              addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
            }
            if (KEEP_CONTENT) {
              ALLOWED_TAGS["#text"] = true;
            }
            if (WHOLE_DOCUMENT) {
              addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
            }
            if (ALLOWED_TAGS.table) {
              addToSet(ALLOWED_TAGS, ["tbody"]);
              delete FORBID_TAGS.tbody;
            }
            if (freeze) {
              freeze(cfg);
            }
            CONFIG = cfg;
          };
          var MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
          var HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
          var COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
          var ALL_SVG_TAGS = addToSet({}, svg$1);
          addToSet(ALL_SVG_TAGS, svgFilters);
          addToSet(ALL_SVG_TAGS, svgDisallowed);
          var ALL_MATHML_TAGS = addToSet({}, mathMl$1);
          addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
          var _checkValidNamespace = function _checkValidNamespace2(element) {
            var parent = getParentNode(element);
            if (!parent || !parent.tagName) {
              parent = {
                namespaceURI: NAMESPACE,
                tagName: "template"
              };
            }
            var tagName = stringToLowerCase(element.tagName);
            var parentTagName = stringToLowerCase(parent.tagName);
            if (!ALLOWED_NAMESPACES[element.namespaceURI]) {
              return false;
            }
            if (element.namespaceURI === SVG_NAMESPACE) {
              if (parent.namespaceURI === HTML_NAMESPACE) {
                return tagName === "svg";
              }
              if (parent.namespaceURI === MATHML_NAMESPACE) {
                return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
              }
              return Boolean(ALL_SVG_TAGS[tagName]);
            }
            if (element.namespaceURI === MATHML_NAMESPACE) {
              if (parent.namespaceURI === HTML_NAMESPACE) {
                return tagName === "math";
              }
              if (parent.namespaceURI === SVG_NAMESPACE) {
                return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
              }
              return Boolean(ALL_MATHML_TAGS[tagName]);
            }
            if (element.namespaceURI === HTML_NAMESPACE) {
              if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
                return false;
              }
              if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
                return false;
              }
              return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
            }
            if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element.namespaceURI]) {
              return true;
            }
            return false;
          };
          var _forceRemove = function _forceRemove2(node) {
            arrayPush(DOMPurify2.removed, {
              element: node
            });
            try {
              node.parentNode.removeChild(node);
            } catch (_) {
              try {
                node.outerHTML = emptyHTML;
              } catch (_2) {
                node.remove();
              }
            }
          };
          var _removeAttribute = function _removeAttribute2(name, node) {
            try {
              arrayPush(DOMPurify2.removed, {
                attribute: node.getAttributeNode(name),
                from: node
              });
            } catch (_) {
              arrayPush(DOMPurify2.removed, {
                attribute: null,
                from: node
              });
            }
            node.removeAttribute(name);
            if (name === "is" && !ALLOWED_ATTR[name]) {
              if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
                try {
                  _forceRemove(node);
                } catch (_) {
                }
              } else {
                try {
                  node.setAttribute(name, "");
                } catch (_) {
                }
              }
            }
          };
          var _initDocument = function _initDocument2(dirty) {
            var doc;
            var leadingWhitespace;
            if (FORCE_BODY) {
              dirty = "<remove></remove>" + dirty;
            } else {
              var matches = stringMatch(dirty, /^[\r\n\t ]+/);
              leadingWhitespace = matches && matches[0];
            }
            if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
              dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
            }
            var dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
            if (NAMESPACE === HTML_NAMESPACE) {
              try {
                doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
              } catch (_) {
              }
            }
            if (!doc || !doc.documentElement) {
              doc = implementation2.createDocument(NAMESPACE, "template", null);
              try {
                doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
              } catch (_) {
              }
            }
            var body = doc.body || doc.documentElement;
            if (dirty && leadingWhitespace) {
              body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
            }
            if (NAMESPACE === HTML_NAMESPACE) {
              return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
            }
            return WHOLE_DOCUMENT ? doc.documentElement : body;
          };
          var _createIterator = function _createIterator2(root) {
            return createNodeIterator.call(
              root.ownerDocument || root,
              root,
              NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT,
              null,
              false
            );
          };
          var _isClobbered = function _isClobbered2(elm) {
            return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
          };
          var _isNode = function _isNode2(object2) {
            return _typeof(Node6) === "object" ? object2 instanceof Node6 : object2 && _typeof(object2) === "object" && typeof object2.nodeType === "number" && typeof object2.nodeName === "string";
          };
          var _executeHook = function _executeHook2(entryPoint, currentNode, data) {
            if (!hooks[entryPoint]) {
              return;
            }
            arrayForEach(hooks[entryPoint], function(hook) {
              hook.call(DOMPurify2, currentNode, data, CONFIG);
            });
          };
          var _sanitizeElements = function _sanitizeElements2(currentNode) {
            var content;
            _executeHook("beforeSanitizeElements", currentNode, null);
            if (_isClobbered(currentNode)) {
              _forceRemove(currentNode);
              return true;
            }
            if (regExpTest(/[\u0080-\uFFFF]/, currentNode.nodeName)) {
              _forceRemove(currentNode);
              return true;
            }
            var tagName = transformCaseFunc(currentNode.nodeName);
            _executeHook("uponSanitizeElement", currentNode, {
              tagName,
              allowedTags: ALLOWED_TAGS
            });
            if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
              _forceRemove(currentNode);
              return true;
            }
            if (tagName === "select" && regExpTest(/<template/i, currentNode.innerHTML)) {
              _forceRemove(currentNode);
              return true;
            }
            if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
              if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
                if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName))
                  return false;
                if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName))
                  return false;
              }
              if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
                var parentNode = getParentNode(currentNode) || currentNode.parentNode;
                var childNodes = getChildNodes(currentNode) || currentNode.childNodes;
                if (childNodes && parentNode) {
                  var childCount = childNodes.length;
                  for (var i = childCount - 1; i >= 0; --i) {
                    parentNode.insertBefore(cloneNode(childNodes[i], true), getNextSibling(currentNode));
                  }
                }
              }
              _forceRemove(currentNode);
              return true;
            }
            if (currentNode instanceof Element2 && !_checkValidNamespace(currentNode)) {
              _forceRemove(currentNode);
              return true;
            }
            if ((tagName === "noscript" || tagName === "noembed" || tagName === "noframes") && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
              _forceRemove(currentNode);
              return true;
            }
            if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
              content = currentNode.textContent;
              content = stringReplace(content, MUSTACHE_EXPR$1, " ");
              content = stringReplace(content, ERB_EXPR$1, " ");
              content = stringReplace(content, TMPLIT_EXPR$1, " ");
              if (currentNode.textContent !== content) {
                arrayPush(DOMPurify2.removed, {
                  element: currentNode.cloneNode()
                });
                currentNode.textContent = content;
              }
            }
            _executeHook("afterSanitizeElements", currentNode, null);
            return false;
          };
          var _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value) {
            if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value in document2 || value in formElement)) {
              return false;
            }
            if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR$1, lcName))
              ;
            else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR$1, lcName))
              ;
            else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
              if (_basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value)))
                ;
              else {
                return false;
              }
            } else if (URI_SAFE_ATTRIBUTES[lcName])
              ;
            else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE$1, "")))
              ;
            else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value, "data:") === 0 && DATA_URI_TAGS[lcTag])
              ;
            else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA$1, stringReplace(value, ATTR_WHITESPACE$1, "")))
              ;
            else if (value) {
              return false;
            } else
              ;
            return true;
          };
          var _basicCustomElementTest = function _basicCustomElementTest2(tagName) {
            return tagName.indexOf("-") > 0;
          };
          var _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
            var attr;
            var value;
            var lcName;
            var l;
            _executeHook("beforeSanitizeAttributes", currentNode, null);
            var attributes = currentNode.attributes;
            if (!attributes) {
              return;
            }
            var hookEvent = {
              attrName: "",
              attrValue: "",
              keepAttr: true,
              allowedAttributes: ALLOWED_ATTR
            };
            l = attributes.length;
            while (l--) {
              attr = attributes[l];
              var _attr = attr, name = _attr.name, namespaceURI = _attr.namespaceURI;
              value = name === "value" ? attr.value : stringTrim(attr.value);
              lcName = transformCaseFunc(name);
              hookEvent.attrName = lcName;
              hookEvent.attrValue = value;
              hookEvent.keepAttr = true;
              hookEvent.forceKeepAttr = void 0;
              _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
              value = hookEvent.attrValue;
              if (hookEvent.forceKeepAttr) {
                continue;
              }
              _removeAttribute(name, currentNode);
              if (!hookEvent.keepAttr) {
                continue;
              }
              if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value)) {
                _removeAttribute(name, currentNode);
                continue;
              }
              if (SAFE_FOR_TEMPLATES) {
                value = stringReplace(value, MUSTACHE_EXPR$1, " ");
                value = stringReplace(value, ERB_EXPR$1, " ");
                value = stringReplace(value, TMPLIT_EXPR$1, " ");
              }
              var lcTag = transformCaseFunc(currentNode.nodeName);
              if (!_isValidAttribute(lcTag, lcName, value)) {
                continue;
              }
              if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
                _removeAttribute(name, currentNode);
                value = SANITIZE_NAMED_PROPS_PREFIX + value;
              }
              if (trustedTypesPolicy && _typeof(trustedTypes) === "object" && typeof trustedTypes.getAttributeType === "function") {
                if (namespaceURI)
                  ;
                else {
                  switch (trustedTypes.getAttributeType(lcTag, lcName)) {
                    case "TrustedHTML": {
                      value = trustedTypesPolicy.createHTML(value);
                      break;
                    }
                    case "TrustedScriptURL": {
                      value = trustedTypesPolicy.createScriptURL(value);
                      break;
                    }
                  }
                }
              }
              try {
                if (namespaceURI) {
                  currentNode.setAttributeNS(namespaceURI, name, value);
                } else {
                  currentNode.setAttribute(name, value);
                }
                arrayPop(DOMPurify2.removed);
              } catch (_) {
              }
            }
            _executeHook("afterSanitizeAttributes", currentNode, null);
          };
          var _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
            var shadowNode;
            var shadowIterator = _createIterator(fragment);
            _executeHook("beforeSanitizeShadowDOM", fragment, null);
            while (shadowNode = shadowIterator.nextNode()) {
              _executeHook("uponSanitizeShadowNode", shadowNode, null);
              if (_sanitizeElements(shadowNode)) {
                continue;
              }
              if (shadowNode.content instanceof DocumentFragment2) {
                _sanitizeShadowDOM2(shadowNode.content);
              }
              _sanitizeAttributes(shadowNode);
            }
            _executeHook("afterSanitizeShadowDOM", fragment, null);
          };
          DOMPurify2.sanitize = function(dirty) {
            var cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
            var body;
            var importedNode;
            var currentNode;
            var oldNode;
            var returnNode;
            IS_EMPTY_INPUT = !dirty;
            if (IS_EMPTY_INPUT) {
              dirty = "<!-->";
            }
            if (typeof dirty !== "string" && !_isNode(dirty)) {
              if (typeof dirty.toString === "function") {
                dirty = dirty.toString();
                if (typeof dirty !== "string") {
                  throw typeErrorCreate("dirty is not a string, aborting");
                }
              } else {
                throw typeErrorCreate("toString is not a function");
              }
            }
            if (!DOMPurify2.isSupported) {
              if (_typeof(window2.toStaticHTML) === "object" || typeof window2.toStaticHTML === "function") {
                if (typeof dirty === "string") {
                  return window2.toStaticHTML(dirty);
                }
                if (_isNode(dirty)) {
                  return window2.toStaticHTML(dirty.outerHTML);
                }
              }
              return dirty;
            }
            if (!SET_CONFIG) {
              _parseConfig(cfg);
            }
            DOMPurify2.removed = [];
            if (typeof dirty === "string") {
              IN_PLACE = false;
            }
            if (IN_PLACE) {
              if (dirty.nodeName) {
                var tagName = transformCaseFunc(dirty.nodeName);
                if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
                  throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
                }
              }
            } else if (dirty instanceof Node6) {
              body = _initDocument("<!---->");
              importedNode = body.ownerDocument.importNode(dirty, true);
              if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
                body = importedNode;
              } else if (importedNode.nodeName === "HTML") {
                body = importedNode;
              } else {
                body.appendChild(importedNode);
              }
            } else {
              if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && dirty.indexOf("<") === -1) {
                return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
              }
              body = _initDocument(dirty);
              if (!body) {
                return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
              }
            }
            if (body && FORCE_BODY) {
              _forceRemove(body.firstChild);
            }
            var nodeIterator = _createIterator(IN_PLACE ? dirty : body);
            while (currentNode = nodeIterator.nextNode()) {
              if (currentNode.nodeType === 3 && currentNode === oldNode) {
                continue;
              }
              if (_sanitizeElements(currentNode)) {
                continue;
              }
              if (currentNode.content instanceof DocumentFragment2) {
                _sanitizeShadowDOM(currentNode.content);
              }
              _sanitizeAttributes(currentNode);
              oldNode = currentNode;
            }
            oldNode = null;
            if (IN_PLACE) {
              return dirty;
            }
            if (RETURN_DOM) {
              if (RETURN_DOM_FRAGMENT) {
                returnNode = createDocumentFragment.call(body.ownerDocument);
                while (body.firstChild) {
                  returnNode.appendChild(body.firstChild);
                }
              } else {
                returnNode = body;
              }
              if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmod) {
                returnNode = importNode.call(originalDocument, returnNode, true);
              }
              return returnNode;
            }
            var serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
            if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
              serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
            }
            if (SAFE_FOR_TEMPLATES) {
              serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR$1, " ");
              serializedHTML = stringReplace(serializedHTML, ERB_EXPR$1, " ");
              serializedHTML = stringReplace(serializedHTML, TMPLIT_EXPR$1, " ");
            }
            return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
          };
          DOMPurify2.setConfig = function(cfg) {
            _parseConfig(cfg);
            SET_CONFIG = true;
          };
          DOMPurify2.clearConfig = function() {
            CONFIG = null;
            SET_CONFIG = false;
          };
          DOMPurify2.isValidAttribute = function(tag, attr, value) {
            if (!CONFIG) {
              _parseConfig({});
            }
            var lcTag = transformCaseFunc(tag);
            var lcName = transformCaseFunc(attr);
            return _isValidAttribute(lcTag, lcName, value);
          };
          DOMPurify2.addHook = function(entryPoint, hookFunction) {
            if (typeof hookFunction !== "function") {
              return;
            }
            hooks[entryPoint] = hooks[entryPoint] || [];
            arrayPush(hooks[entryPoint], hookFunction);
          };
          DOMPurify2.removeHook = function(entryPoint) {
            if (hooks[entryPoint]) {
              return arrayPop(hooks[entryPoint]);
            }
          };
          DOMPurify2.removeHooks = function(entryPoint) {
            if (hooks[entryPoint]) {
              hooks[entryPoint] = [];
            }
          };
          DOMPurify2.removeAllHooks = function() {
            hooks = {};
          };
          return DOMPurify2;
        }
        var purify = createDOMPurify();
        return purify;
      });
    }
  });

  // node_modules/jsep/build/jsep.js
  var require_jsep = __commonJS({
    "node_modules/jsep/build/jsep.js"(exports2, module2) {
      (function(root) {
        "use strict";
        var COMPOUND = "Compound", IDENTIFIER = "Identifier", MEMBER_EXP = "MemberExpression", LITERAL = "Literal", THIS_EXP = "ThisExpression", CALL_EXP = "CallExpression", UNARY_EXP = "UnaryExpression", BINARY_EXP = "BinaryExpression", LOGICAL_EXP = "LogicalExpression", CONDITIONAL_EXP = "ConditionalExpression", ARRAY_EXP = "ArrayExpression", PERIOD_CODE = 46, COMMA_CODE = 44, SQUOTE_CODE = 39, DQUOTE_CODE = 34, OPAREN_CODE = 40, CPAREN_CODE = 41, OBRACK_CODE = 91, CBRACK_CODE = 93, QUMARK_CODE = 63, SEMCOL_CODE = 59, COLON_CODE = 58, throwError = function(message, index) {
          var error = new Error(message + " at character " + index);
          error.index = index;
          error.description = message;
          throw error;
        }, t = true, unary_ops = { "-": t, "!": t, "~": t, "+": t }, binary_ops = {
          "||": 1,
          "&&": 2,
          "|": 3,
          "^": 4,
          "&": 5,
          "==": 6,
          "!=": 6,
          "===": 6,
          "!==": 6,
          "<": 7,
          ">": 7,
          "<=": 7,
          ">=": 7,
          "<<": 8,
          ">>": 8,
          ">>>": 8,
          "+": 9,
          "-": 9,
          "*": 10,
          "/": 10,
          "%": 10
        }, getMaxKeyLen = function(obj) {
          var max_len = 0, len;
          for (var key in obj) {
            if ((len = key.length) > max_len && obj.hasOwnProperty(key)) {
              max_len = len;
            }
          }
          return max_len;
        }, max_unop_len = getMaxKeyLen(unary_ops), max_binop_len = getMaxKeyLen(binary_ops), literals = {
          "true": true,
          "false": false,
          "null": null
        }, this_str = "this", binaryPrecedence = function(op_val) {
          return binary_ops[op_val] || 0;
        }, createBinaryExpression = function(operator, left, right) {
          var type = operator === "||" || operator === "&&" ? LOGICAL_EXP : BINARY_EXP;
          return {
            type,
            operator,
            left,
            right
          };
        }, isDecimalDigit = function(ch) {
          return ch >= 48 && ch <= 57;
        }, isIdentifierStart = function(ch) {
          return ch === 36 || ch === 95 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 128 && !binary_ops[String.fromCharCode(ch)];
        }, isIdentifierPart = function(ch) {
          return ch === 36 || ch === 95 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch >= 128 && !binary_ops[String.fromCharCode(ch)];
        }, jsep2 = function(expr) {
          var index = 0, charAtFunc = expr.charAt, charCodeAtFunc = expr.charCodeAt, exprI = function(i) {
            return charAtFunc.call(expr, i);
          }, exprICode = function(i) {
            return charCodeAtFunc.call(expr, i);
          }, length3 = expr.length, gobbleSpaces = function() {
            var ch = exprICode(index);
            while (ch === 32 || ch === 9 || ch === 10 || ch === 13) {
              ch = exprICode(++index);
            }
          }, gobbleExpression = function() {
            var test = gobbleBinaryExpression(), consequent, alternate;
            gobbleSpaces();
            if (exprICode(index) === QUMARK_CODE) {
              index++;
              consequent = gobbleExpression();
              if (!consequent) {
                throwError("Expected expression", index);
              }
              gobbleSpaces();
              if (exprICode(index) === COLON_CODE) {
                index++;
                alternate = gobbleExpression();
                if (!alternate) {
                  throwError("Expected expression", index);
                }
                return {
                  type: CONDITIONAL_EXP,
                  test,
                  consequent,
                  alternate
                };
              } else {
                throwError("Expected :", index);
              }
            } else {
              return test;
            }
          }, gobbleBinaryOp = function() {
            gobbleSpaces();
            var biop, to_check = expr.substr(index, max_binop_len), tc_len = to_check.length;
            while (tc_len > 0) {
              if (binary_ops.hasOwnProperty(to_check) && (!isIdentifierStart(exprICode(index)) || index + to_check.length < expr.length && !isIdentifierPart(exprICode(index + to_check.length)))) {
                index += tc_len;
                return to_check;
              }
              to_check = to_check.substr(0, --tc_len);
            }
            return false;
          }, gobbleBinaryExpression = function() {
            var ch_i2, node2, biop, prec, stack, biop_info, left, right, i, cur_biop;
            left = gobbleToken();
            biop = gobbleBinaryOp();
            if (!biop) {
              return left;
            }
            biop_info = { value: biop, prec: binaryPrecedence(biop) };
            right = gobbleToken();
            if (!right) {
              throwError("Expected expression after " + biop, index);
            }
            stack = [left, biop_info, right];
            while (biop = gobbleBinaryOp()) {
              prec = binaryPrecedence(biop);
              if (prec === 0) {
                break;
              }
              biop_info = { value: biop, prec };
              cur_biop = biop;
              while (stack.length > 2 && prec <= stack[stack.length - 2].prec) {
                right = stack.pop();
                biop = stack.pop().value;
                left = stack.pop();
                node2 = createBinaryExpression(biop, left, right);
                stack.push(node2);
              }
              node2 = gobbleToken();
              if (!node2) {
                throwError("Expected expression after " + cur_biop, index);
              }
              stack.push(biop_info, node2);
            }
            i = stack.length - 1;
            node2 = stack[i];
            while (i > 1) {
              node2 = createBinaryExpression(stack[i - 1].value, stack[i - 2], node2);
              i -= 2;
            }
            return node2;
          }, gobbleToken = function() {
            var ch, to_check, tc_len;
            gobbleSpaces();
            ch = exprICode(index);
            if (isDecimalDigit(ch) || ch === PERIOD_CODE) {
              return gobbleNumericLiteral();
            } else if (ch === SQUOTE_CODE || ch === DQUOTE_CODE) {
              return gobbleStringLiteral();
            } else if (ch === OBRACK_CODE) {
              return gobbleArray();
            } else {
              to_check = expr.substr(index, max_unop_len);
              tc_len = to_check.length;
              while (tc_len > 0) {
                if (unary_ops.hasOwnProperty(to_check) && (!isIdentifierStart(exprICode(index)) || index + to_check.length < expr.length && !isIdentifierPart(exprICode(index + to_check.length)))) {
                  index += tc_len;
                  return {
                    type: UNARY_EXP,
                    operator: to_check,
                    argument: gobbleToken(),
                    prefix: true
                  };
                }
                to_check = to_check.substr(0, --tc_len);
              }
              if (isIdentifierStart(ch) || ch === OPAREN_CODE) {
                return gobbleVariable();
              }
            }
            return false;
          }, gobbleNumericLiteral = function() {
            var number = "", ch, chCode;
            while (isDecimalDigit(exprICode(index))) {
              number += exprI(index++);
            }
            if (exprICode(index) === PERIOD_CODE) {
              number += exprI(index++);
              while (isDecimalDigit(exprICode(index))) {
                number += exprI(index++);
              }
            }
            ch = exprI(index);
            if (ch === "e" || ch === "E") {
              number += exprI(index++);
              ch = exprI(index);
              if (ch === "+" || ch === "-") {
                number += exprI(index++);
              }
              while (isDecimalDigit(exprICode(index))) {
                number += exprI(index++);
              }
              if (!isDecimalDigit(exprICode(index - 1))) {
                throwError("Expected exponent (" + number + exprI(index) + ")", index);
              }
            }
            chCode = exprICode(index);
            if (isIdentifierStart(chCode)) {
              throwError("Variable names cannot start with a number (" + number + exprI(index) + ")", index);
            } else if (chCode === PERIOD_CODE) {
              throwError("Unexpected period", index);
            }
            return {
              type: LITERAL,
              value: parseFloat(number),
              raw: number
            };
          }, gobbleStringLiteral = function() {
            var str = "", quote = exprI(index++), closed = false, ch;
            while (index < length3) {
              ch = exprI(index++);
              if (ch === quote) {
                closed = true;
                break;
              } else if (ch === "\\") {
                ch = exprI(index++);
                switch (ch) {
                  case "n":
                    str += "\n";
                    break;
                  case "r":
                    str += "\r";
                    break;
                  case "t":
                    str += "	";
                    break;
                  case "b":
                    str += "\b";
                    break;
                  case "f":
                    str += "\f";
                    break;
                  case "v":
                    str += "\v";
                    break;
                  default:
                    str += ch;
                }
              } else {
                str += ch;
              }
            }
            if (!closed) {
              throwError('Unclosed quote after "' + str + '"', index);
            }
            return {
              type: LITERAL,
              value: str,
              raw: quote + str + quote
            };
          }, gobbleIdentifier = function() {
            var ch = exprICode(index), start = index, identifier;
            if (isIdentifierStart(ch)) {
              index++;
            } else {
              throwError("Unexpected " + exprI(index), index);
            }
            while (index < length3) {
              ch = exprICode(index);
              if (isIdentifierPart(ch)) {
                index++;
              } else {
                break;
              }
            }
            identifier = expr.slice(start, index);
            if (literals.hasOwnProperty(identifier)) {
              return {
                type: LITERAL,
                value: literals[identifier],
                raw: identifier
              };
            } else if (identifier === this_str) {
              return { type: THIS_EXP };
            } else {
              return {
                type: IDENTIFIER,
                name: identifier
              };
            }
          }, gobbleArguments = function(termination) {
            var ch_i2, args = [], node2, closed = false;
            var separator_count = 0;
            while (index < length3) {
              gobbleSpaces();
              ch_i2 = exprICode(index);
              if (ch_i2 === termination) {
                closed = true;
                index++;
                if (termination === CPAREN_CODE && separator_count && separator_count >= args.length) {
                  throwError("Unexpected token " + String.fromCharCode(termination), index);
                }
                break;
              } else if (ch_i2 === COMMA_CODE) {
                index++;
                separator_count++;
                if (separator_count !== args.length) {
                  if (termination === CPAREN_CODE) {
                    throwError("Unexpected token ,", index);
                  } else if (termination === CBRACK_CODE) {
                    for (var arg = args.length; arg < separator_count; arg++) {
                      args.push(null);
                    }
                  }
                }
              } else {
                node2 = gobbleExpression();
                if (!node2 || node2.type === COMPOUND) {
                  throwError("Expected comma", index);
                }
                args.push(node2);
              }
            }
            if (!closed) {
              throwError("Expected " + String.fromCharCode(termination), index);
            }
            return args;
          }, gobbleVariable = function() {
            var ch_i2, node2;
            ch_i2 = exprICode(index);
            if (ch_i2 === OPAREN_CODE) {
              node2 = gobbleGroup();
            } else {
              node2 = gobbleIdentifier();
            }
            gobbleSpaces();
            ch_i2 = exprICode(index);
            while (ch_i2 === PERIOD_CODE || ch_i2 === OBRACK_CODE || ch_i2 === OPAREN_CODE) {
              index++;
              if (ch_i2 === PERIOD_CODE) {
                gobbleSpaces();
                node2 = {
                  type: MEMBER_EXP,
                  computed: false,
                  object: node2,
                  property: gobbleIdentifier()
                };
              } else if (ch_i2 === OBRACK_CODE) {
                node2 = {
                  type: MEMBER_EXP,
                  computed: true,
                  object: node2,
                  property: gobbleExpression()
                };
                gobbleSpaces();
                ch_i2 = exprICode(index);
                if (ch_i2 !== CBRACK_CODE) {
                  throwError("Unclosed [", index);
                }
                index++;
              } else if (ch_i2 === OPAREN_CODE) {
                node2 = {
                  type: CALL_EXP,
                  "arguments": gobbleArguments(CPAREN_CODE),
                  callee: node2
                };
              }
              gobbleSpaces();
              ch_i2 = exprICode(index);
            }
            return node2;
          }, gobbleGroup = function() {
            index++;
            var node2 = gobbleExpression();
            gobbleSpaces();
            if (exprICode(index) === CPAREN_CODE) {
              index++;
              return node2;
            } else {
              throwError("Unclosed (", index);
            }
          }, gobbleArray = function() {
            index++;
            return {
              type: ARRAY_EXP,
              elements: gobbleArguments(CBRACK_CODE)
            };
          }, nodes = [], ch_i, node;
          while (index < length3) {
            ch_i = exprICode(index);
            if (ch_i === SEMCOL_CODE || ch_i === COMMA_CODE) {
              index++;
            } else {
              if (node = gobbleExpression()) {
                nodes.push(node);
              } else if (index < length3) {
                throwError('Unexpected "' + exprI(index) + '"', index);
              }
            }
          }
          if (nodes.length === 1) {
            return nodes[0];
          } else {
            return {
              type: COMPOUND,
              body: nodes
            };
          }
        };
        jsep2.version = "0.3.5";
        jsep2.toString = function() {
          return "JavaScript Expression Parser (JSEP) v" + jsep2.version;
        };
        jsep2.addUnaryOp = function(op_name) {
          max_unop_len = Math.max(op_name.length, max_unop_len);
          unary_ops[op_name] = t;
          return this;
        };
        jsep2.addBinaryOp = function(op_name, precedence) {
          max_binop_len = Math.max(op_name.length, max_binop_len);
          binary_ops[op_name] = precedence;
          return this;
        };
        jsep2.addLiteral = function(literal_name, literal_value) {
          literals[literal_name] = literal_value;
          return this;
        };
        jsep2.removeUnaryOp = function(op_name) {
          delete unary_ops[op_name];
          if (op_name.length === max_unop_len) {
            max_unop_len = getMaxKeyLen(unary_ops);
          }
          return this;
        };
        jsep2.removeAllUnaryOps = function() {
          unary_ops = {};
          max_unop_len = 0;
          return this;
        };
        jsep2.removeBinaryOp = function(op_name) {
          delete binary_ops[op_name];
          if (op_name.length === max_binop_len) {
            max_binop_len = getMaxKeyLen(binary_ops);
          }
          return this;
        };
        jsep2.removeAllBinaryOps = function() {
          binary_ops = {};
          max_binop_len = 0;
          return this;
        };
        jsep2.removeLiteral = function(literal_name) {
          delete literals[literal_name];
          return this;
        };
        jsep2.removeAllLiterals = function() {
          literals = {};
          return this;
        };
        if (typeof exports2 === "undefined") {
          var old_jsep = root.jsep;
          root.jsep = jsep2;
          jsep2.noConflict = function() {
            if (root.jsep === jsep2) {
              root.jsep = old_jsep;
            }
            return jsep2;
          };
        } else {
          if (typeof module2 !== "undefined" && module2.exports) {
            exports2 = module2.exports = jsep2;
          } else {
            exports2.parse = jsep2;
          }
        }
      })(exports2);
    }
  });

  // node_modules/bitmap-sdf/index.js
  var require_bitmap_sdf = __commonJS({
    "node_modules/bitmap-sdf/index.js"(exports2, module2) {
      "use strict";
      module2.exports = calcSDF;
      var INF = 1e20;
      function calcSDF(src, options) {
        if (!options)
          options = {};
        var cutoff = options.cutoff == null ? 0.25 : options.cutoff;
        var radius = options.radius == null ? 8 : options.radius;
        var channel = options.channel || 0;
        var w, h, size, data, intData, stride, ctx, canvas, imgData, i, l;
        if (ArrayBuffer.isView(src) || Array.isArray(src)) {
          if (!options.width || !options.height)
            throw Error("For raw data width and height should be provided by options");
          w = options.width, h = options.height;
          data = src;
          if (!options.stride)
            stride = Math.floor(src.length / w / h);
          else
            stride = options.stride;
        } else {
          if (window.HTMLCanvasElement && src instanceof window.HTMLCanvasElement) {
            canvas = src;
            ctx = canvas.getContext("2d");
            w = canvas.width, h = canvas.height;
            imgData = ctx.getImageData(0, 0, w, h);
            data = imgData.data;
            stride = 4;
          } else if (window.CanvasRenderingContext2D && src instanceof window.CanvasRenderingContext2D) {
            canvas = src.canvas;
            ctx = src;
            w = canvas.width, h = canvas.height;
            imgData = ctx.getImageData(0, 0, w, h);
            data = imgData.data;
            stride = 4;
          } else if (window.ImageData && src instanceof window.ImageData) {
            imgData = src;
            w = src.width, h = src.height;
            data = imgData.data;
            stride = 4;
          }
        }
        size = Math.max(w, h);
        if (window.Uint8ClampedArray && data instanceof window.Uint8ClampedArray || window.Uint8Array && data instanceof window.Uint8Array) {
          intData = data;
          data = Array(w * h);
          for (i = 0, l = Math.floor(intData.length / stride); i < l; i++) {
            data[i] = intData[i * stride + channel] / 255;
          }
        } else {
          if (stride !== 1)
            throw Error("Raw data can have only 1 value per pixel");
        }
        var gridOuter = Array(w * h);
        var gridInner = Array(w * h);
        var f = Array(size);
        var d = Array(size);
        var z = Array(size + 1);
        var v7 = Array(size);
        for (i = 0, l = w * h; i < l; i++) {
          var a3 = data[i];
          gridOuter[i] = a3 === 1 ? 0 : a3 === 0 ? INF : Math.pow(Math.max(0, 0.5 - a3), 2);
          gridInner[i] = a3 === 1 ? INF : a3 === 0 ? 0 : Math.pow(Math.max(0, a3 - 0.5), 2);
        }
        edt(gridOuter, w, h, f, d, v7, z);
        edt(gridInner, w, h, f, d, v7, z);
        var dist = window.Float32Array ? new Float32Array(w * h) : new Array(w * h);
        for (i = 0, l = w * h; i < l; i++) {
          dist[i] = Math.min(Math.max(1 - ((gridOuter[i] - gridInner[i]) / radius + cutoff), 0), 1);
        }
        return dist;
      }
      function edt(data, width, height, f, d, v7, z) {
        for (var x = 0; x < width; x++) {
          for (var y = 0; y < height; y++) {
            f[y] = data[y * width + x];
          }
          edt1d(f, d, v7, z, height);
          for (y = 0; y < height; y++) {
            data[y * width + x] = d[y];
          }
        }
        for (y = 0; y < height; y++) {
          for (x = 0; x < width; x++) {
            f[x] = data[y * width + x];
          }
          edt1d(f, d, v7, z, width);
          for (x = 0; x < width; x++) {
            data[y * width + x] = Math.sqrt(d[x]);
          }
        }
      }
      function edt1d(f, d, v7, z, n) {
        v7[0] = 0;
        z[0] = -INF;
        z[1] = +INF;
        for (var q = 1, k = 0; q < n; q++) {
          var s = (f[q] + q * q - (f[v7[k]] + v7[k] * v7[k])) / (2 * q - 2 * v7[k]);
          while (s <= z[k]) {
            k--;
            s = (f[q] + q * q - (f[v7[k]] + v7[k] * v7[k])) / (2 * q - 2 * v7[k]);
          }
          k++;
          v7[k] = q;
          z[k] = s;
          z[k + 1] = +INF;
        }
        for (q = 0, k = 0; q < n; q++) {
          while (z[k + 1] < q)
            k++;
          d[q] = (q - v7[k]) * (q - v7[k]) + f[v7[k]];
        }
      }
    }
  });

  // node_modules/grapheme-splitter/index.js
  var require_grapheme_splitter = __commonJS({
    "node_modules/grapheme-splitter/index.js"(exports2, module2) {
      function GraphemeSplitter2() {
        var CR = 0, LF = 1, Control = 2, Extend = 3, Regional_Indicator = 4, SpacingMark = 5, L = 6, V = 7, T = 8, LV = 9, LVT = 10, Other = 11, Prepend = 12, E_Base = 13, E_Modifier = 14, ZWJ = 15, Glue_After_Zwj = 16, E_Base_GAZ = 17;
        var NotBreak = 0, BreakStart = 1, Break = 2, BreakLastRegional = 3, BreakPenultimateRegional = 4;
        function isSurrogate(str, pos) {
          return 55296 <= str.charCodeAt(pos) && str.charCodeAt(pos) <= 56319 && 56320 <= str.charCodeAt(pos + 1) && str.charCodeAt(pos + 1) <= 57343;
        }
        function codePointAt(str, idx) {
          if (idx === void 0) {
            idx = 0;
          }
          var code = str.charCodeAt(idx);
          if (55296 <= code && code <= 56319 && idx < str.length - 1) {
            var hi = code;
            var low = str.charCodeAt(idx + 1);
            if (56320 <= low && low <= 57343) {
              return (hi - 55296) * 1024 + (low - 56320) + 65536;
            }
            return hi;
          }
          if (56320 <= code && code <= 57343 && idx >= 1) {
            var hi = str.charCodeAt(idx - 1);
            var low = code;
            if (55296 <= hi && hi <= 56319) {
              return (hi - 55296) * 1024 + (low - 56320) + 65536;
            }
            return low;
          }
          return code;
        }
        function shouldBreak(start, mid, end) {
          var all = [start].concat(mid).concat([end]);
          var previous = all[all.length - 2];
          var next = end;
          var eModifierIndex = all.lastIndexOf(E_Modifier);
          if (eModifierIndex > 1 && all.slice(1, eModifierIndex).every(function(c) {
            return c == Extend;
          }) && [Extend, E_Base, E_Base_GAZ].indexOf(start) == -1) {
            return Break;
          }
          var rIIndex = all.lastIndexOf(Regional_Indicator);
          if (rIIndex > 0 && all.slice(1, rIIndex).every(function(c) {
            return c == Regional_Indicator;
          }) && [Prepend, Regional_Indicator].indexOf(previous) == -1) {
            if (all.filter(function(c) {
              return c == Regional_Indicator;
            }).length % 2 == 1) {
              return BreakLastRegional;
            } else {
              return BreakPenultimateRegional;
            }
          }
          if (previous == CR && next == LF) {
            return NotBreak;
          } else if (previous == Control || previous == CR || previous == LF) {
            if (next == E_Modifier && mid.every(function(c) {
              return c == Extend;
            })) {
              return Break;
            } else {
              return BreakStart;
            }
          } else if (next == Control || next == CR || next == LF) {
            return BreakStart;
          } else if (previous == L && (next == L || next == V || next == LV || next == LVT)) {
            return NotBreak;
          } else if ((previous == LV || previous == V) && (next == V || next == T)) {
            return NotBreak;
          } else if ((previous == LVT || previous == T) && next == T) {
            return NotBreak;
          } else if (next == Extend || next == ZWJ) {
            return NotBreak;
          } else if (next == SpacingMark) {
            return NotBreak;
          } else if (previous == Prepend) {
            return NotBreak;
          }
          var previousNonExtendIndex = all.indexOf(Extend) != -1 ? all.lastIndexOf(Extend) - 1 : all.length - 2;
          if ([E_Base, E_Base_GAZ].indexOf(all[previousNonExtendIndex]) != -1 && all.slice(previousNonExtendIndex + 1, -1).every(function(c) {
            return c == Extend;
          }) && next == E_Modifier) {
            return NotBreak;
          }
          if (previous == ZWJ && [Glue_After_Zwj, E_Base_GAZ].indexOf(next) != -1) {
            return NotBreak;
          }
          if (mid.indexOf(Regional_Indicator) != -1) {
            return Break;
          }
          if (previous == Regional_Indicator && next == Regional_Indicator) {
            return NotBreak;
          }
          return BreakStart;
        }
        this.nextBreak = function(string, index) {
          if (index === void 0) {
            index = 0;
          }
          if (index < 0) {
            return 0;
          }
          if (index >= string.length - 1) {
            return string.length;
          }
          var prev = getGraphemeBreakProperty(codePointAt(string, index));
          var mid = [];
          for (var i = index + 1; i < string.length; i++) {
            if (isSurrogate(string, i - 1)) {
              continue;
            }
            var next = getGraphemeBreakProperty(codePointAt(string, i));
            if (shouldBreak(prev, mid, next)) {
              return i;
            }
            mid.push(next);
          }
          return string.length;
        };
        this.splitGraphemes = function(str) {
          var res = [];
          var index = 0;
          var brk;
          while ((brk = this.nextBreak(str, index)) < str.length) {
            res.push(str.slice(index, brk));
            index = brk;
          }
          if (index < str.length) {
            res.push(str.slice(index));
          }
          return res;
        };
        this.iterateGraphemes = function(str) {
          var index = 0;
          var res = {
            next: function() {
              var value;
              var brk;
              if ((brk = this.nextBreak(str, index)) < str.length) {
                value = str.slice(index, brk);
                index = brk;
                return { value, done: false };
              }
              if (index < str.length) {
                value = str.slice(index);
                index = str.length;
                return { value, done: false };
              }
              return { value: void 0, done: true };
            }.bind(this)
          };
          if (typeof Symbol !== "undefined" && Symbol.iterator) {
            res[Symbol.iterator] = function() {
              return res;
            };
          }
          return res;
        };
        this.countGraphemes = function(str) {
          var count = 0;
          var index = 0;
          var brk;
          while ((brk = this.nextBreak(str, index)) < str.length) {
            index = brk;
            count++;
          }
          if (index < str.length) {
            count++;
          }
          return count;
        };
        function getGraphemeBreakProperty(code) {
          if (1536 <= code && code <= 1541 || 1757 == code || 1807 == code || 2274 == code || 3406 == code || 69821 == code || 70082 <= code && code <= 70083 || 72250 == code || 72326 <= code && code <= 72329 || 73030 == code) {
            return Prepend;
          }
          if (13 == code) {
            return CR;
          }
          if (10 == code) {
            return LF;
          }
          if (0 <= code && code <= 9 || 11 <= code && code <= 12 || 14 <= code && code <= 31 || 127 <= code && code <= 159 || 173 == code || 1564 == code || 6158 == code || 8203 == code || 8206 <= code && code <= 8207 || 8232 == code || 8233 == code || 8234 <= code && code <= 8238 || 8288 <= code && code <= 8292 || 8293 == code || 8294 <= code && code <= 8303 || 55296 <= code && code <= 57343 || 65279 == code || 65520 <= code && code <= 65528 || 65529 <= code && code <= 65531 || 113824 <= code && code <= 113827 || 119155 <= code && code <= 119162 || 917504 == code || 917505 == code || 917506 <= code && code <= 917535 || 917632 <= code && code <= 917759 || 918e3 <= code && code <= 921599) {
            return Control;
          }
          if (768 <= code && code <= 879 || 1155 <= code && code <= 1159 || 1160 <= code && code <= 1161 || 1425 <= code && code <= 1469 || 1471 == code || 1473 <= code && code <= 1474 || 1476 <= code && code <= 1477 || 1479 == code || 1552 <= code && code <= 1562 || 1611 <= code && code <= 1631 || 1648 == code || 1750 <= code && code <= 1756 || 1759 <= code && code <= 1764 || 1767 <= code && code <= 1768 || 1770 <= code && code <= 1773 || 1809 == code || 1840 <= code && code <= 1866 || 1958 <= code && code <= 1968 || 2027 <= code && code <= 2035 || 2070 <= code && code <= 2073 || 2075 <= code && code <= 2083 || 2085 <= code && code <= 2087 || 2089 <= code && code <= 2093 || 2137 <= code && code <= 2139 || 2260 <= code && code <= 2273 || 2275 <= code && code <= 2306 || 2362 == code || 2364 == code || 2369 <= code && code <= 2376 || 2381 == code || 2385 <= code && code <= 2391 || 2402 <= code && code <= 2403 || 2433 == code || 2492 == code || 2494 == code || 2497 <= code && code <= 2500 || 2509 == code || 2519 == code || 2530 <= code && code <= 2531 || 2561 <= code && code <= 2562 || 2620 == code || 2625 <= code && code <= 2626 || 2631 <= code && code <= 2632 || 2635 <= code && code <= 2637 || 2641 == code || 2672 <= code && code <= 2673 || 2677 == code || 2689 <= code && code <= 2690 || 2748 == code || 2753 <= code && code <= 2757 || 2759 <= code && code <= 2760 || 2765 == code || 2786 <= code && code <= 2787 || 2810 <= code && code <= 2815 || 2817 == code || 2876 == code || 2878 == code || 2879 == code || 2881 <= code && code <= 2884 || 2893 == code || 2902 == code || 2903 == code || 2914 <= code && code <= 2915 || 2946 == code || 3006 == code || 3008 == code || 3021 == code || 3031 == code || 3072 == code || 3134 <= code && code <= 3136 || 3142 <= code && code <= 3144 || 3146 <= code && code <= 3149 || 3157 <= code && code <= 3158 || 3170 <= code && code <= 3171 || 3201 == code || 3260 == code || 3263 == code || 3266 == code || 3270 == code || 3276 <= code && code <= 3277 || 3285 <= code && code <= 3286 || 3298 <= code && code <= 3299 || 3328 <= code && code <= 3329 || 3387 <= code && code <= 3388 || 3390 == code || 3393 <= code && code <= 3396 || 3405 == code || 3415 == code || 3426 <= code && code <= 3427 || 3530 == code || 3535 == code || 3538 <= code && code <= 3540 || 3542 == code || 3551 == code || 3633 == code || 3636 <= code && code <= 3642 || 3655 <= code && code <= 3662 || 3761 == code || 3764 <= code && code <= 3769 || 3771 <= code && code <= 3772 || 3784 <= code && code <= 3789 || 3864 <= code && code <= 3865 || 3893 == code || 3895 == code || 3897 == code || 3953 <= code && code <= 3966 || 3968 <= code && code <= 3972 || 3974 <= code && code <= 3975 || 3981 <= code && code <= 3991 || 3993 <= code && code <= 4028 || 4038 == code || 4141 <= code && code <= 4144 || 4146 <= code && code <= 4151 || 4153 <= code && code <= 4154 || 4157 <= code && code <= 4158 || 4184 <= code && code <= 4185 || 4190 <= code && code <= 4192 || 4209 <= code && code <= 4212 || 4226 == code || 4229 <= code && code <= 4230 || 4237 == code || 4253 == code || 4957 <= code && code <= 4959 || 5906 <= code && code <= 5908 || 5938 <= code && code <= 5940 || 5970 <= code && code <= 5971 || 6002 <= code && code <= 6003 || 6068 <= code && code <= 6069 || 6071 <= code && code <= 6077 || 6086 == code || 6089 <= code && code <= 6099 || 6109 == code || 6155 <= code && code <= 6157 || 6277 <= code && code <= 6278 || 6313 == code || 6432 <= code && code <= 6434 || 6439 <= code && code <= 6440 || 6450 == code || 6457 <= code && code <= 6459 || 6679 <= code && code <= 6680 || 6683 == code || 6742 == code || 6744 <= code && code <= 6750 || 6752 == code || 6754 == code || 6757 <= code && code <= 6764 || 6771 <= code && code <= 6780 || 6783 == code || 6832 <= code && code <= 6845 || 6846 == code || 6912 <= code && code <= 6915 || 6964 == code || 6966 <= code && code <= 6970 || 6972 == code || 6978 == code || 7019 <= code && code <= 7027 || 7040 <= code && code <= 7041 || 7074 <= code && code <= 7077 || 7080 <= code && code <= 7081 || 7083 <= code && code <= 7085 || 7142 == code || 7144 <= code && code <= 7145 || 7149 == code || 7151 <= code && code <= 7153 || 7212 <= code && code <= 7219 || 7222 <= code && code <= 7223 || 7376 <= code && code <= 7378 || 7380 <= code && code <= 7392 || 7394 <= code && code <= 7400 || 7405 == code || 7412 == code || 7416 <= code && code <= 7417 || 7616 <= code && code <= 7673 || 7675 <= code && code <= 7679 || 8204 == code || 8400 <= code && code <= 8412 || 8413 <= code && code <= 8416 || 8417 == code || 8418 <= code && code <= 8420 || 8421 <= code && code <= 8432 || 11503 <= code && code <= 11505 || 11647 == code || 11744 <= code && code <= 11775 || 12330 <= code && code <= 12333 || 12334 <= code && code <= 12335 || 12441 <= code && code <= 12442 || 42607 == code || 42608 <= code && code <= 42610 || 42612 <= code && code <= 42621 || 42654 <= code && code <= 42655 || 42736 <= code && code <= 42737 || 43010 == code || 43014 == code || 43019 == code || 43045 <= code && code <= 43046 || 43204 <= code && code <= 43205 || 43232 <= code && code <= 43249 || 43302 <= code && code <= 43309 || 43335 <= code && code <= 43345 || 43392 <= code && code <= 43394 || 43443 == code || 43446 <= code && code <= 43449 || 43452 == code || 43493 == code || 43561 <= code && code <= 43566 || 43569 <= code && code <= 43570 || 43573 <= code && code <= 43574 || 43587 == code || 43596 == code || 43644 == code || 43696 == code || 43698 <= code && code <= 43700 || 43703 <= code && code <= 43704 || 43710 <= code && code <= 43711 || 43713 == code || 43756 <= code && code <= 43757 || 43766 == code || 44005 == code || 44008 == code || 44013 == code || 64286 == code || 65024 <= code && code <= 65039 || 65056 <= code && code <= 65071 || 65438 <= code && code <= 65439 || 66045 == code || 66272 == code || 66422 <= code && code <= 66426 || 68097 <= code && code <= 68099 || 68101 <= code && code <= 68102 || 68108 <= code && code <= 68111 || 68152 <= code && code <= 68154 || 68159 == code || 68325 <= code && code <= 68326 || 69633 == code || 69688 <= code && code <= 69702 || 69759 <= code && code <= 69761 || 69811 <= code && code <= 69814 || 69817 <= code && code <= 69818 || 69888 <= code && code <= 69890 || 69927 <= code && code <= 69931 || 69933 <= code && code <= 69940 || 70003 == code || 70016 <= code && code <= 70017 || 70070 <= code && code <= 70078 || 70090 <= code && code <= 70092 || 70191 <= code && code <= 70193 || 70196 == code || 70198 <= code && code <= 70199 || 70206 == code || 70367 == code || 70371 <= code && code <= 70378 || 70400 <= code && code <= 70401 || 70460 == code || 70462 == code || 70464 == code || 70487 == code || 70502 <= code && code <= 70508 || 70512 <= code && code <= 70516 || 70712 <= code && code <= 70719 || 70722 <= code && code <= 70724 || 70726 == code || 70832 == code || 70835 <= code && code <= 70840 || 70842 == code || 70845 == code || 70847 <= code && code <= 70848 || 70850 <= code && code <= 70851 || 71087 == code || 71090 <= code && code <= 71093 || 71100 <= code && code <= 71101 || 71103 <= code && code <= 71104 || 71132 <= code && code <= 71133 || 71219 <= code && code <= 71226 || 71229 == code || 71231 <= code && code <= 71232 || 71339 == code || 71341 == code || 71344 <= code && code <= 71349 || 71351 == code || 71453 <= code && code <= 71455 || 71458 <= code && code <= 71461 || 71463 <= code && code <= 71467 || 72193 <= code && code <= 72198 || 72201 <= code && code <= 72202 || 72243 <= code && code <= 72248 || 72251 <= code && code <= 72254 || 72263 == code || 72273 <= code && code <= 72278 || 72281 <= code && code <= 72283 || 72330 <= code && code <= 72342 || 72344 <= code && code <= 72345 || 72752 <= code && code <= 72758 || 72760 <= code && code <= 72765 || 72767 == code || 72850 <= code && code <= 72871 || 72874 <= code && code <= 72880 || 72882 <= code && code <= 72883 || 72885 <= code && code <= 72886 || 73009 <= code && code <= 73014 || 73018 == code || 73020 <= code && code <= 73021 || 73023 <= code && code <= 73029 || 73031 == code || 92912 <= code && code <= 92916 || 92976 <= code && code <= 92982 || 94095 <= code && code <= 94098 || 113821 <= code && code <= 113822 || 119141 == code || 119143 <= code && code <= 119145 || 119150 <= code && code <= 119154 || 119163 <= code && code <= 119170 || 119173 <= code && code <= 119179 || 119210 <= code && code <= 119213 || 119362 <= code && code <= 119364 || 121344 <= code && code <= 121398 || 121403 <= code && code <= 121452 || 121461 == code || 121476 == code || 121499 <= code && code <= 121503 || 121505 <= code && code <= 121519 || 122880 <= code && code <= 122886 || 122888 <= code && code <= 122904 || 122907 <= code && code <= 122913 || 122915 <= code && code <= 122916 || 122918 <= code && code <= 122922 || 125136 <= code && code <= 125142 || 125252 <= code && code <= 125258 || 917536 <= code && code <= 917631 || 917760 <= code && code <= 917999) {
            return Extend;
          }
          if (127462 <= code && code <= 127487) {
            return Regional_Indicator;
          }
          if (2307 == code || 2363 == code || 2366 <= code && code <= 2368 || 2377 <= code && code <= 2380 || 2382 <= code && code <= 2383 || 2434 <= code && code <= 2435 || 2495 <= code && code <= 2496 || 2503 <= code && code <= 2504 || 2507 <= code && code <= 2508 || 2563 == code || 2622 <= code && code <= 2624 || 2691 == code || 2750 <= code && code <= 2752 || 2761 == code || 2763 <= code && code <= 2764 || 2818 <= code && code <= 2819 || 2880 == code || 2887 <= code && code <= 2888 || 2891 <= code && code <= 2892 || 3007 == code || 3009 <= code && code <= 3010 || 3014 <= code && code <= 3016 || 3018 <= code && code <= 3020 || 3073 <= code && code <= 3075 || 3137 <= code && code <= 3140 || 3202 <= code && code <= 3203 || 3262 == code || 3264 <= code && code <= 3265 || 3267 <= code && code <= 3268 || 3271 <= code && code <= 3272 || 3274 <= code && code <= 3275 || 3330 <= code && code <= 3331 || 3391 <= code && code <= 3392 || 3398 <= code && code <= 3400 || 3402 <= code && code <= 3404 || 3458 <= code && code <= 3459 || 3536 <= code && code <= 3537 || 3544 <= code && code <= 3550 || 3570 <= code && code <= 3571 || 3635 == code || 3763 == code || 3902 <= code && code <= 3903 || 3967 == code || 4145 == code || 4155 <= code && code <= 4156 || 4182 <= code && code <= 4183 || 4228 == code || 6070 == code || 6078 <= code && code <= 6085 || 6087 <= code && code <= 6088 || 6435 <= code && code <= 6438 || 6441 <= code && code <= 6443 || 6448 <= code && code <= 6449 || 6451 <= code && code <= 6456 || 6681 <= code && code <= 6682 || 6741 == code || 6743 == code || 6765 <= code && code <= 6770 || 6916 == code || 6965 == code || 6971 == code || 6973 <= code && code <= 6977 || 6979 <= code && code <= 6980 || 7042 == code || 7073 == code || 7078 <= code && code <= 7079 || 7082 == code || 7143 == code || 7146 <= code && code <= 7148 || 7150 == code || 7154 <= code && code <= 7155 || 7204 <= code && code <= 7211 || 7220 <= code && code <= 7221 || 7393 == code || 7410 <= code && code <= 7411 || 7415 == code || 43043 <= code && code <= 43044 || 43047 == code || 43136 <= code && code <= 43137 || 43188 <= code && code <= 43203 || 43346 <= code && code <= 43347 || 43395 == code || 43444 <= code && code <= 43445 || 43450 <= code && code <= 43451 || 43453 <= code && code <= 43456 || 43567 <= code && code <= 43568 || 43571 <= code && code <= 43572 || 43597 == code || 43755 == code || 43758 <= code && code <= 43759 || 43765 == code || 44003 <= code && code <= 44004 || 44006 <= code && code <= 44007 || 44009 <= code && code <= 44010 || 44012 == code || 69632 == code || 69634 == code || 69762 == code || 69808 <= code && code <= 69810 || 69815 <= code && code <= 69816 || 69932 == code || 70018 == code || 70067 <= code && code <= 70069 || 70079 <= code && code <= 70080 || 70188 <= code && code <= 70190 || 70194 <= code && code <= 70195 || 70197 == code || 70368 <= code && code <= 70370 || 70402 <= code && code <= 70403 || 70463 == code || 70465 <= code && code <= 70468 || 70471 <= code && code <= 70472 || 70475 <= code && code <= 70477 || 70498 <= code && code <= 70499 || 70709 <= code && code <= 70711 || 70720 <= code && code <= 70721 || 70725 == code || 70833 <= code && code <= 70834 || 70841 == code || 70843 <= code && code <= 70844 || 70846 == code || 70849 == code || 71088 <= code && code <= 71089 || 71096 <= code && code <= 71099 || 71102 == code || 71216 <= code && code <= 71218 || 71227 <= code && code <= 71228 || 71230 == code || 71340 == code || 71342 <= code && code <= 71343 || 71350 == code || 71456 <= code && code <= 71457 || 71462 == code || 72199 <= code && code <= 72200 || 72249 == code || 72279 <= code && code <= 72280 || 72343 == code || 72751 == code || 72766 == code || 72873 == code || 72881 == code || 72884 == code || 94033 <= code && code <= 94078 || 119142 == code || 119149 == code) {
            return SpacingMark;
          }
          if (4352 <= code && code <= 4447 || 43360 <= code && code <= 43388) {
            return L;
          }
          if (4448 <= code && code <= 4519 || 55216 <= code && code <= 55238) {
            return V;
          }
          if (4520 <= code && code <= 4607 || 55243 <= code && code <= 55291) {
            return T;
          }
          if (44032 == code || 44060 == code || 44088 == code || 44116 == code || 44144 == code || 44172 == code || 44200 == code || 44228 == code || 44256 == code || 44284 == code || 44312 == code || 44340 == code || 44368 == code || 44396 == code || 44424 == code || 44452 == code || 44480 == code || 44508 == code || 44536 == code || 44564 == code || 44592 == code || 44620 == code || 44648 == code || 44676 == code || 44704 == code || 44732 == code || 44760 == code || 44788 == code || 44816 == code || 44844 == code || 44872 == code || 44900 == code || 44928 == code || 44956 == code || 44984 == code || 45012 == code || 45040 == code || 45068 == code || 45096 == code || 45124 == code || 45152 == code || 45180 == code || 45208 == code || 45236 == code || 45264 == code || 45292 == code || 45320 == code || 45348 == code || 45376 == code || 45404 == code || 45432 == code || 45460 == code || 45488 == code || 45516 == code || 45544 == code || 45572 == code || 45600 == code || 45628 == code || 45656 == code || 45684 == code || 45712 == code || 45740 == code || 45768 == code || 45796 == code || 45824 == code || 45852 == code || 45880 == code || 45908 == code || 45936 == code || 45964 == code || 45992 == code || 46020 == code || 46048 == code || 46076 == code || 46104 == code || 46132 == code || 46160 == code || 46188 == code || 46216 == code || 46244 == code || 46272 == code || 46300 == code || 46328 == code || 46356 == code || 46384 == code || 46412 == code || 46440 == code || 46468 == code || 46496 == code || 46524 == code || 46552 == code || 46580 == code || 46608 == code || 46636 == code || 46664 == code || 46692 == code || 46720 == code || 46748 == code || 46776 == code || 46804 == code || 46832 == code || 46860 == code || 46888 == code || 46916 == code || 46944 == code || 46972 == code || 47e3 == code || 47028 == code || 47056 == code || 47084 == code || 47112 == code || 47140 == code || 47168 == code || 47196 == code || 47224 == code || 47252 == code || 47280 == code || 47308 == code || 47336 == code || 47364 == code || 47392 == code || 47420 == code || 47448 == code || 47476 == code || 47504 == code || 47532 == code || 47560 == code || 47588 == code || 47616 == code || 47644 == code || 47672 == code || 47700 == code || 47728 == code || 47756 == code || 47784 == code || 47812 == code || 47840 == code || 47868 == code || 47896 == code || 47924 == code || 47952 == code || 47980 == code || 48008 == code || 48036 == code || 48064 == code || 48092 == code || 48120 == code || 48148 == code || 48176 == code || 48204 == code || 48232 == code || 48260 == code || 48288 == code || 48316 == code || 48344 == code || 48372 == code || 48400 == code || 48428 == code || 48456 == code || 48484 == code || 48512 == code || 48540 == code || 48568 == code || 48596 == code || 48624 == code || 48652 == code || 48680 == code || 48708 == code || 48736 == code || 48764 == code || 48792 == code || 48820 == code || 48848 == code || 48876 == code || 48904 == code || 48932 == code || 48960 == code || 48988 == code || 49016 == code || 49044 == code || 49072 == code || 49100 == code || 49128 == code || 49156 == code || 49184 == code || 49212 == code || 49240 == code || 49268 == code || 49296 == code || 49324 == code || 49352 == code || 49380 == code || 49408 == code || 49436 == code || 49464 == code || 49492 == code || 49520 == code || 49548 == code || 49576 == code || 49604 == code || 49632 == code || 49660 == code || 49688 == code || 49716 == code || 49744 == code || 49772 == code || 49800 == code || 49828 == code || 49856 == code || 49884 == code || 49912 == code || 49940 == code || 49968 == code || 49996 == code || 50024 == code || 50052 == code || 50080 == code || 50108 == code || 50136 == code || 50164 == code || 50192 == code || 50220 == code || 50248 == code || 50276 == code || 50304 == code || 50332 == code || 50360 == code || 50388 == code || 50416 == code || 50444 == code || 50472 == code || 50500 == code || 50528 == code || 50556 == code || 50584 == code || 50612 == code || 50640 == code || 50668 == code || 50696 == code || 50724 == code || 50752 == code || 50780 == code || 50808 == code || 50836 == code || 50864 == code || 50892 == code || 50920 == code || 50948 == code || 50976 == code || 51004 == code || 51032 == code || 51060 == code || 51088 == code || 51116 == code || 51144 == code || 51172 == code || 51200 == code || 51228 == code || 51256 == code || 51284 == code || 51312 == code || 51340 == code || 51368 == code || 51396 == code || 51424 == code || 51452 == code || 51480 == code || 51508 == code || 51536 == code || 51564 == code || 51592 == code || 51620 == code || 51648 == code || 51676 == code || 51704 == code || 51732 == code || 51760 == code || 51788 == code || 51816 == code || 51844 == code || 51872 == code || 51900 == code || 51928 == code || 51956 == code || 51984 == code || 52012 == code || 52040 == code || 52068 == code || 52096 == code || 52124 == code || 52152 == code || 52180 == code || 52208 == code || 52236 == code || 52264 == code || 52292 == code || 52320 == code || 52348 == code || 52376 == code || 52404 == code || 52432 == code || 52460 == code || 52488 == code || 52516 == code || 52544 == code || 52572 == code || 52600 == code || 52628 == code || 52656 == code || 52684 == code || 52712 == code || 52740 == code || 52768 == code || 52796 == code || 52824 == code || 52852 == code || 52880 == code || 52908 == code || 52936 == code || 52964 == code || 52992 == code || 53020 == code || 53048 == code || 53076 == code || 53104 == code || 53132 == code || 53160 == code || 53188 == code || 53216 == code || 53244 == code || 53272 == code || 53300 == code || 53328 == code || 53356 == code || 53384 == code || 53412 == code || 53440 == code || 53468 == code || 53496 == code || 53524 == code || 53552 == code || 53580 == code || 53608 == code || 53636 == code || 53664 == code || 53692 == code || 53720 == code || 53748 == code || 53776 == code || 53804 == code || 53832 == code || 53860 == code || 53888 == code || 53916 == code || 53944 == code || 53972 == code || 54e3 == code || 54028 == code || 54056 == code || 54084 == code || 54112 == code || 54140 == code || 54168 == code || 54196 == code || 54224 == code || 54252 == code || 54280 == code || 54308 == code || 54336 == code || 54364 == code || 54392 == code || 54420 == code || 54448 == code || 54476 == code || 54504 == code || 54532 == code || 54560 == code || 54588 == code || 54616 == code || 54644 == code || 54672 == code || 54700 == code || 54728 == code || 54756 == code || 54784 == code || 54812 == code || 54840 == code || 54868 == code || 54896 == code || 54924 == code || 54952 == code || 54980 == code || 55008 == code || 55036 == code || 55064 == code || 55092 == code || 55120 == code || 55148 == code || 55176 == code) {
            return LV;
          }
          if (44033 <= code && code <= 44059 || 44061 <= code && code <= 44087 || 44089 <= code && code <= 44115 || 44117 <= code && code <= 44143 || 44145 <= code && code <= 44171 || 44173 <= code && code <= 44199 || 44201 <= code && code <= 44227 || 44229 <= code && code <= 44255 || 44257 <= code && code <= 44283 || 44285 <= code && code <= 44311 || 44313 <= code && code <= 44339 || 44341 <= code && code <= 44367 || 44369 <= code && code <= 44395 || 44397 <= code && code <= 44423 || 44425 <= code && code <= 44451 || 44453 <= code && code <= 44479 || 44481 <= code && code <= 44507 || 44509 <= code && code <= 44535 || 44537 <= code && code <= 44563 || 44565 <= code && code <= 44591 || 44593 <= code && code <= 44619 || 44621 <= code && code <= 44647 || 44649 <= code && code <= 44675 || 44677 <= code && code <= 44703 || 44705 <= code && code <= 44731 || 44733 <= code && code <= 44759 || 44761 <= code && code <= 44787 || 44789 <= code && code <= 44815 || 44817 <= code && code <= 44843 || 44845 <= code && code <= 44871 || 44873 <= code && code <= 44899 || 44901 <= code && code <= 44927 || 44929 <= code && code <= 44955 || 44957 <= code && code <= 44983 || 44985 <= code && code <= 45011 || 45013 <= code && code <= 45039 || 45041 <= code && code <= 45067 || 45069 <= code && code <= 45095 || 45097 <= code && code <= 45123 || 45125 <= code && code <= 45151 || 45153 <= code && code <= 45179 || 45181 <= code && code <= 45207 || 45209 <= code && code <= 45235 || 45237 <= code && code <= 45263 || 45265 <= code && code <= 45291 || 45293 <= code && code <= 45319 || 45321 <= code && code <= 45347 || 45349 <= code && code <= 45375 || 45377 <= code && code <= 45403 || 45405 <= code && code <= 45431 || 45433 <= code && code <= 45459 || 45461 <= code && code <= 45487 || 45489 <= code && code <= 45515 || 45517 <= code && code <= 45543 || 45545 <= code && code <= 45571 || 45573 <= code && code <= 45599 || 45601 <= code && code <= 45627 || 45629 <= code && code <= 45655 || 45657 <= code && code <= 45683 || 45685 <= code && code <= 45711 || 45713 <= code && code <= 45739 || 45741 <= code && code <= 45767 || 45769 <= code && code <= 45795 || 45797 <= code && code <= 45823 || 45825 <= code && code <= 45851 || 45853 <= code && code <= 45879 || 45881 <= code && code <= 45907 || 45909 <= code && code <= 45935 || 45937 <= code && code <= 45963 || 45965 <= code && code <= 45991 || 45993 <= code && code <= 46019 || 46021 <= code && code <= 46047 || 46049 <= code && code <= 46075 || 46077 <= code && code <= 46103 || 46105 <= code && code <= 46131 || 46133 <= code && code <= 46159 || 46161 <= code && code <= 46187 || 46189 <= code && code <= 46215 || 46217 <= code && code <= 46243 || 46245 <= code && code <= 46271 || 46273 <= code && code <= 46299 || 46301 <= code && code <= 46327 || 46329 <= code && code <= 46355 || 46357 <= code && code <= 46383 || 46385 <= code && code <= 46411 || 46413 <= code && code <= 46439 || 46441 <= code && code <= 46467 || 46469 <= code && code <= 46495 || 46497 <= code && code <= 46523 || 46525 <= code && code <= 46551 || 46553 <= code && code <= 46579 || 46581 <= code && code <= 46607 || 46609 <= code && code <= 46635 || 46637 <= code && code <= 46663 || 46665 <= code && code <= 46691 || 46693 <= code && code <= 46719 || 46721 <= code && code <= 46747 || 46749 <= code && code <= 46775 || 46777 <= code && code <= 46803 || 46805 <= code && code <= 46831 || 46833 <= code && code <= 46859 || 46861 <= code && code <= 46887 || 46889 <= code && code <= 46915 || 46917 <= code && code <= 46943 || 46945 <= code && code <= 46971 || 46973 <= code && code <= 46999 || 47001 <= code && code <= 47027 || 47029 <= code && code <= 47055 || 47057 <= code && code <= 47083 || 47085 <= code && code <= 47111 || 47113 <= code && code <= 47139 || 47141 <= code && code <= 47167 || 47169 <= code && code <= 47195 || 47197 <= code && code <= 47223 || 47225 <= code && code <= 47251 || 47253 <= code && code <= 47279 || 47281 <= code && code <= 47307 || 47309 <= code && code <= 47335 || 47337 <= code && code <= 47363 || 47365 <= code && code <= 47391 || 47393 <= code && code <= 47419 || 47421 <= code && code <= 47447 || 47449 <= code && code <= 47475 || 47477 <= code && code <= 47503 || 47505 <= code && code <= 47531 || 47533 <= code && code <= 47559 || 47561 <= code && code <= 47587 || 47589 <= code && code <= 47615 || 47617 <= code && code <= 47643 || 47645 <= code && code <= 47671 || 47673 <= code && code <= 47699 || 47701 <= code && code <= 47727 || 47729 <= code && code <= 47755 || 47757 <= code && code <= 47783 || 47785 <= code && code <= 47811 || 47813 <= code && code <= 47839 || 47841 <= code && code <= 47867 || 47869 <= code && code <= 47895 || 47897 <= code && code <= 47923 || 47925 <= code && code <= 47951 || 47953 <= code && code <= 47979 || 47981 <= code && code <= 48007 || 48009 <= code && code <= 48035 || 48037 <= code && code <= 48063 || 48065 <= code && code <= 48091 || 48093 <= code && code <= 48119 || 48121 <= code && code <= 48147 || 48149 <= code && code <= 48175 || 48177 <= code && code <= 48203 || 48205 <= code && code <= 48231 || 48233 <= code && code <= 48259 || 48261 <= code && code <= 48287 || 48289 <= code && code <= 48315 || 48317 <= code && code <= 48343 || 48345 <= code && code <= 48371 || 48373 <= code && code <= 48399 || 48401 <= code && code <= 48427 || 48429 <= code && code <= 48455 || 48457 <= code && code <= 48483 || 48485 <= code && code <= 48511 || 48513 <= code && code <= 48539 || 48541 <= code && code <= 48567 || 48569 <= code && code <= 48595 || 48597 <= code && code <= 48623 || 48625 <= code && code <= 48651 || 48653 <= code && code <= 48679 || 48681 <= code && code <= 48707 || 48709 <= code && code <= 48735 || 48737 <= code && code <= 48763 || 48765 <= code && code <= 48791 || 48793 <= code && code <= 48819 || 48821 <= code && code <= 48847 || 48849 <= code && code <= 48875 || 48877 <= code && code <= 48903 || 48905 <= code && code <= 48931 || 48933 <= code && code <= 48959 || 48961 <= code && code <= 48987 || 48989 <= code && code <= 49015 || 49017 <= code && code <= 49043 || 49045 <= code && code <= 49071 || 49073 <= code && code <= 49099 || 49101 <= code && code <= 49127 || 49129 <= code && code <= 49155 || 49157 <= code && code <= 49183 || 49185 <= code && code <= 49211 || 49213 <= code && code <= 49239 || 49241 <= code && code <= 49267 || 49269 <= code && code <= 49295 || 49297 <= code && code <= 49323 || 49325 <= code && code <= 49351 || 49353 <= code && code <= 49379 || 49381 <= code && code <= 49407 || 49409 <= code && code <= 49435 || 49437 <= code && code <= 49463 || 49465 <= code && code <= 49491 || 49493 <= code && code <= 49519 || 49521 <= code && code <= 49547 || 49549 <= code && code <= 49575 || 49577 <= code && code <= 49603 || 49605 <= code && code <= 49631 || 49633 <= code && code <= 49659 || 49661 <= code && code <= 49687 || 49689 <= code && code <= 49715 || 49717 <= code && code <= 49743 || 49745 <= code && code <= 49771 || 49773 <= code && code <= 49799 || 49801 <= code && code <= 49827 || 49829 <= code && code <= 49855 || 49857 <= code && code <= 49883 || 49885 <= code && code <= 49911 || 49913 <= code && code <= 49939 || 49941 <= code && code <= 49967 || 49969 <= code && code <= 49995 || 49997 <= code && code <= 50023 || 50025 <= code && code <= 50051 || 50053 <= code && code <= 50079 || 50081 <= code && code <= 50107 || 50109 <= code && code <= 50135 || 50137 <= code && code <= 50163 || 50165 <= code && code <= 50191 || 50193 <= code && code <= 50219 || 50221 <= code && code <= 50247 || 50249 <= code && code <= 50275 || 50277 <= code && code <= 50303 || 50305 <= code && code <= 50331 || 50333 <= code && code <= 50359 || 50361 <= code && code <= 50387 || 50389 <= code && code <= 50415 || 50417 <= code && code <= 50443 || 50445 <= code && code <= 50471 || 50473 <= code && code <= 50499 || 50501 <= code && code <= 50527 || 50529 <= code && code <= 50555 || 50557 <= code && code <= 50583 || 50585 <= code && code <= 50611 || 50613 <= code && code <= 50639 || 50641 <= code && code <= 50667 || 50669 <= code && code <= 50695 || 50697 <= code && code <= 50723 || 50725 <= code && code <= 50751 || 50753 <= code && code <= 50779 || 50781 <= code && code <= 50807 || 50809 <= code && code <= 50835 || 50837 <= code && code <= 50863 || 50865 <= code && code <= 50891 || 50893 <= code && code <= 50919 || 50921 <= code && code <= 50947 || 50949 <= code && code <= 50975 || 50977 <= code && code <= 51003 || 51005 <= code && code <= 51031 || 51033 <= code && code <= 51059 || 51061 <= code && code <= 51087 || 51089 <= code && code <= 51115 || 51117 <= code && code <= 51143 || 51145 <= code && code <= 51171 || 51173 <= code && code <= 51199 || 51201 <= code && code <= 51227 || 51229 <= code && code <= 51255 || 51257 <= code && code <= 51283 || 51285 <= code && code <= 51311 || 51313 <= code && code <= 51339 || 51341 <= code && code <= 51367 || 51369 <= code && code <= 51395 || 51397 <= code && code <= 51423 || 51425 <= code && code <= 51451 || 51453 <= code && code <= 51479 || 51481 <= code && code <= 51507 || 51509 <= code && code <= 51535 || 51537 <= code && code <= 51563 || 51565 <= code && code <= 51591 || 51593 <= code && code <= 51619 || 51621 <= code && code <= 51647 || 51649 <= code && code <= 51675 || 51677 <= code && code <= 51703 || 51705 <= code && code <= 51731 || 51733 <= code && code <= 51759 || 51761 <= code && code <= 51787 || 51789 <= code && code <= 51815 || 51817 <= code && code <= 51843 || 51845 <= code && code <= 51871 || 51873 <= code && code <= 51899 || 51901 <= code && code <= 51927 || 51929 <= code && code <= 51955 || 51957 <= code && code <= 51983 || 51985 <= code && code <= 52011 || 52013 <= code && code <= 52039 || 52041 <= code && code <= 52067 || 52069 <= code && code <= 52095 || 52097 <= code && code <= 52123 || 52125 <= code && code <= 52151 || 52153 <= code && code <= 52179 || 52181 <= code && code <= 52207 || 52209 <= code && code <= 52235 || 52237 <= code && code <= 52263 || 52265 <= code && code <= 52291 || 52293 <= code && code <= 52319 || 52321 <= code && code <= 52347 || 52349 <= code && code <= 52375 || 52377 <= code && code <= 52403 || 52405 <= code && code <= 52431 || 52433 <= code && code <= 52459 || 52461 <= code && code <= 52487 || 52489 <= code && code <= 52515 || 52517 <= code && code <= 52543 || 52545 <= code && code <= 52571 || 52573 <= code && code <= 52599 || 52601 <= code && code <= 52627 || 52629 <= code && code <= 52655 || 52657 <= code && code <= 52683 || 52685 <= code && code <= 52711 || 52713 <= code && code <= 52739 || 52741 <= code && code <= 52767 || 52769 <= code && code <= 52795 || 52797 <= code && code <= 52823 || 52825 <= code && code <= 52851 || 52853 <= code && code <= 52879 || 52881 <= code && code <= 52907 || 52909 <= code && code <= 52935 || 52937 <= code && code <= 52963 || 52965 <= code && code <= 52991 || 52993 <= code && code <= 53019 || 53021 <= code && code <= 53047 || 53049 <= code && code <= 53075 || 53077 <= code && code <= 53103 || 53105 <= code && code <= 53131 || 53133 <= code && code <= 53159 || 53161 <= code && code <= 53187 || 53189 <= code && code <= 53215 || 53217 <= code && code <= 53243 || 53245 <= code && code <= 53271 || 53273 <= code && code <= 53299 || 53301 <= code && code <= 53327 || 53329 <= code && code <= 53355 || 53357 <= code && code <= 53383 || 53385 <= code && code <= 53411 || 53413 <= code && code <= 53439 || 53441 <= code && code <= 53467 || 53469 <= code && code <= 53495 || 53497 <= code && code <= 53523 || 53525 <= code && code <= 53551 || 53553 <= code && code <= 53579 || 53581 <= code && code <= 53607 || 53609 <= code && code <= 53635 || 53637 <= code && code <= 53663 || 53665 <= code && code <= 53691 || 53693 <= code && code <= 53719 || 53721 <= code && code <= 53747 || 53749 <= code && code <= 53775 || 53777 <= code && code <= 53803 || 53805 <= code && code <= 53831 || 53833 <= code && code <= 53859 || 53861 <= code && code <= 53887 || 53889 <= code && code <= 53915 || 53917 <= code && code <= 53943 || 53945 <= code && code <= 53971 || 53973 <= code && code <= 53999 || 54001 <= code && code <= 54027 || 54029 <= code && code <= 54055 || 54057 <= code && code <= 54083 || 54085 <= code && code <= 54111 || 54113 <= code && code <= 54139 || 54141 <= code && code <= 54167 || 54169 <= code && code <= 54195 || 54197 <= code && code <= 54223 || 54225 <= code && code <= 54251 || 54253 <= code && code <= 54279 || 54281 <= code && code <= 54307 || 54309 <= code && code <= 54335 || 54337 <= code && code <= 54363 || 54365 <= code && code <= 54391 || 54393 <= code && code <= 54419 || 54421 <= code && code <= 54447 || 54449 <= code && code <= 54475 || 54477 <= code && code <= 54503 || 54505 <= code && code <= 54531 || 54533 <= code && code <= 54559 || 54561 <= code && code <= 54587 || 54589 <= code && code <= 54615 || 54617 <= code && code <= 54643 || 54645 <= code && code <= 54671 || 54673 <= code && code <= 54699 || 54701 <= code && code <= 54727 || 54729 <= code && code <= 54755 || 54757 <= code && code <= 54783 || 54785 <= code && code <= 54811 || 54813 <= code && code <= 54839 || 54841 <= code && code <= 54867 || 54869 <= code && code <= 54895 || 54897 <= code && code <= 54923 || 54925 <= code && code <= 54951 || 54953 <= code && code <= 54979 || 54981 <= code && code <= 55007 || 55009 <= code && code <= 55035 || 55037 <= code && code <= 55063 || 55065 <= code && code <= 55091 || 55093 <= code && code <= 55119 || 55121 <= code && code <= 55147 || 55149 <= code && code <= 55175 || 55177 <= code && code <= 55203) {
            return LVT;
          }
          if (9757 == code || 9977 == code || 9994 <= code && code <= 9997 || 127877 == code || 127938 <= code && code <= 127940 || 127943 == code || 127946 <= code && code <= 127948 || 128066 <= code && code <= 128067 || 128070 <= code && code <= 128080 || 128110 == code || 128112 <= code && code <= 128120 || 128124 == code || 128129 <= code && code <= 128131 || 128133 <= code && code <= 128135 || 128170 == code || 128372 <= code && code <= 128373 || 128378 == code || 128400 == code || 128405 <= code && code <= 128406 || 128581 <= code && code <= 128583 || 128587 <= code && code <= 128591 || 128675 == code || 128692 <= code && code <= 128694 || 128704 == code || 128716 == code || 129304 <= code && code <= 129308 || 129310 <= code && code <= 129311 || 129318 == code || 129328 <= code && code <= 129337 || 129341 <= code && code <= 129342 || 129489 <= code && code <= 129501) {
            return E_Base;
          }
          if (127995 <= code && code <= 127999) {
            return E_Modifier;
          }
          if (8205 == code) {
            return ZWJ;
          }
          if (9792 == code || 9794 == code || 9877 <= code && code <= 9878 || 9992 == code || 10084 == code || 127752 == code || 127806 == code || 127859 == code || 127891 == code || 127908 == code || 127912 == code || 127979 == code || 127981 == code || 128139 == code || 128187 <= code && code <= 128188 || 128295 == code || 128300 == code || 128488 == code || 128640 == code || 128658 == code) {
            return Glue_After_Zwj;
          }
          if (128102 <= code && code <= 128105) {
            return E_Base_GAZ;
          }
          return Other;
        }
        return this;
      }
      if (typeof module2 != "undefined" && module2.exports) {
        module2.exports = GraphemeSplitter2;
      }
    }
  });

  // node_modules/earcut/src/earcut.js
  var require_earcut = __commonJS({
    "node_modules/earcut/src/earcut.js"(exports2, module2) {
      "use strict";
      module2.exports = earcut2;
      module2.exports.default = earcut2;
      function earcut2(data, holeIndices, dim) {
        dim = dim || 2;
        var hasHoles = holeIndices && holeIndices.length, outerLen = hasHoles ? holeIndices[0] * dim : data.length, outerNode = linkedList(data, 0, outerLen, dim, true), triangles = [];
        if (!outerNode || outerNode.next === outerNode.prev)
          return triangles;
        var minX, minY, maxX, maxY, x, y, invSize;
        if (hasHoles)
          outerNode = eliminateHoles(data, holeIndices, outerNode, dim);
        if (data.length > 80 * dim) {
          minX = maxX = data[0];
          minY = maxY = data[1];
          for (var i = dim; i < outerLen; i += dim) {
            x = data[i];
            y = data[i + 1];
            if (x < minX)
              minX = x;
            if (y < minY)
              minY = y;
            if (x > maxX)
              maxX = x;
            if (y > maxY)
              maxY = y;
          }
          invSize = Math.max(maxX - minX, maxY - minY);
          invSize = invSize !== 0 ? 32767 / invSize : 0;
        }
        earcutLinked(outerNode, triangles, dim, minX, minY, invSize, 0);
        return triangles;
      }
      function linkedList(data, start, end, dim, clockwise) {
        var i, last;
        if (clockwise === signedArea(data, start, end, dim) > 0) {
          for (i = start; i < end; i += dim)
            last = insertNode(i, data[i], data[i + 1], last);
        } else {
          for (i = end - dim; i >= start; i -= dim)
            last = insertNode(i, data[i], data[i + 1], last);
        }
        if (last && equals(last, last.next)) {
          removeNode(last);
          last = last.next;
        }
        return last;
      }
      function filterPoints(start, end) {
        if (!start)
          return start;
        if (!end)
          end = start;
        var p = start, again;
        do {
          again = false;
          if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {
            removeNode(p);
            p = end = p.prev;
            if (p === p.next)
              break;
            again = true;
          } else {
            p = p.next;
          }
        } while (again || p !== end);
        return end;
      }
      function earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {
        if (!ear)
          return;
        if (!pass && invSize)
          indexCurve(ear, minX, minY, invSize);
        var stop2 = ear, prev, next;
        while (ear.prev !== ear.next) {
          prev = ear.prev;
          next = ear.next;
          if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {
            triangles.push(prev.i / dim | 0);
            triangles.push(ear.i / dim | 0);
            triangles.push(next.i / dim | 0);
            removeNode(ear);
            ear = next.next;
            stop2 = next.next;
            continue;
          }
          ear = next;
          if (ear === stop2) {
            if (!pass) {
              earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1);
            } else if (pass === 1) {
              ear = cureLocalIntersections(filterPoints(ear), triangles, dim);
              earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);
            } else if (pass === 2) {
              splitEarcut(ear, triangles, dim, minX, minY, invSize);
            }
            break;
          }
        }
      }
      function isEar(ear) {
        var a3 = ear.prev, b = ear, c = ear.next;
        if (area(a3, b, c) >= 0)
          return false;
        var ax = a3.x, bx = b.x, cx = c.x, ay = a3.y, by = b.y, cy = c.y;
        var x0 = ax < bx ? ax < cx ? ax : cx : bx < cx ? bx : cx, y0 = ay < by ? ay < cy ? ay : cy : by < cy ? by : cy, x1 = ax > bx ? ax > cx ? ax : cx : bx > cx ? bx : cx, y1 = ay > by ? ay > cy ? ay : cy : by > cy ? by : cy;
        var p = c.next;
        while (p !== a3) {
          if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
            return false;
          p = p.next;
        }
        return true;
      }
      function isEarHashed(ear, minX, minY, invSize) {
        var a3 = ear.prev, b = ear, c = ear.next;
        if (area(a3, b, c) >= 0)
          return false;
        var ax = a3.x, bx = b.x, cx = c.x, ay = a3.y, by = b.y, cy = c.y;
        var x0 = ax < bx ? ax < cx ? ax : cx : bx < cx ? bx : cx, y0 = ay < by ? ay < cy ? ay : cy : by < cy ? by : cy, x1 = ax > bx ? ax > cx ? ax : cx : bx > cx ? bx : cx, y1 = ay > by ? ay > cy ? ay : cy : by > cy ? by : cy;
        var minZ = zOrder(x0, y0, minX, minY, invSize), maxZ = zOrder(x1, y1, minX, minY, invSize);
        var p = ear.prevZ, n = ear.nextZ;
        while (p && p.z >= minZ && n && n.z <= maxZ) {
          if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a3 && p !== c && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
            return false;
          p = p.prevZ;
          if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a3 && n !== c && pointInTriangle(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0)
            return false;
          n = n.nextZ;
        }
        while (p && p.z >= minZ) {
          if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a3 && p !== c && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
            return false;
          p = p.prevZ;
        }
        while (n && n.z <= maxZ) {
          if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a3 && n !== c && pointInTriangle(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0)
            return false;
          n = n.nextZ;
        }
        return true;
      }
      function cureLocalIntersections(start, triangles, dim) {
        var p = start;
        do {
          var a3 = p.prev, b = p.next.next;
          if (!equals(a3, b) && intersects(a3, p, p.next, b) && locallyInside(a3, b) && locallyInside(b, a3)) {
            triangles.push(a3.i / dim | 0);
            triangles.push(p.i / dim | 0);
            triangles.push(b.i / dim | 0);
            removeNode(p);
            removeNode(p.next);
            p = start = b;
          }
          p = p.next;
        } while (p !== start);
        return filterPoints(p);
      }
      function splitEarcut(start, triangles, dim, minX, minY, invSize) {
        var a3 = start;
        do {
          var b = a3.next.next;
          while (b !== a3.prev) {
            if (a3.i !== b.i && isValidDiagonal(a3, b)) {
              var c = splitPolygon(a3, b);
              a3 = filterPoints(a3, a3.next);
              c = filterPoints(c, c.next);
              earcutLinked(a3, triangles, dim, minX, minY, invSize, 0);
              earcutLinked(c, triangles, dim, minX, minY, invSize, 0);
              return;
            }
            b = b.next;
          }
          a3 = a3.next;
        } while (a3 !== start);
      }
      function eliminateHoles(data, holeIndices, outerNode, dim) {
        var queue = [], i, len, start, end, list;
        for (i = 0, len = holeIndices.length; i < len; i++) {
          start = holeIndices[i] * dim;
          end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
          list = linkedList(data, start, end, dim, false);
          if (list === list.next)
            list.steiner = true;
          queue.push(getLeftmost(list));
        }
        queue.sort(compareX);
        for (i = 0; i < queue.length; i++) {
          outerNode = eliminateHole(queue[i], outerNode);
        }
        return outerNode;
      }
      function compareX(a3, b) {
        return a3.x - b.x;
      }
      function eliminateHole(hole, outerNode) {
        var bridge = findHoleBridge(hole, outerNode);
        if (!bridge) {
          return outerNode;
        }
        var bridgeReverse = splitPolygon(bridge, hole);
        filterPoints(bridgeReverse, bridgeReverse.next);
        return filterPoints(bridge, bridge.next);
      }
      function findHoleBridge(hole, outerNode) {
        var p = outerNode, hx = hole.x, hy = hole.y, qx = -Infinity, m;
        do {
          if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {
            var x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);
            if (x <= hx && x > qx) {
              qx = x;
              m = p.x < p.next.x ? p : p.next;
              if (x === hx)
                return m;
            }
          }
          p = p.next;
        } while (p !== outerNode);
        if (!m)
          return null;
        var stop2 = m, mx = m.x, my = m.y, tanMin = Infinity, tan;
        p = m;
        do {
          if (hx >= p.x && p.x >= mx && hx !== p.x && pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {
            tan = Math.abs(hy - p.y) / (hx - p.x);
            if (locallyInside(p, hole) && (tan < tanMin || tan === tanMin && (p.x > m.x || p.x === m.x && sectorContainsSector(m, p)))) {
              m = p;
              tanMin = tan;
            }
          }
          p = p.next;
        } while (p !== stop2);
        return m;
      }
      function sectorContainsSector(m, p) {
        return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;
      }
      function indexCurve(start, minX, minY, invSize) {
        var p = start;
        do {
          if (p.z === 0)
            p.z = zOrder(p.x, p.y, minX, minY, invSize);
          p.prevZ = p.prev;
          p.nextZ = p.next;
          p = p.next;
        } while (p !== start);
        p.prevZ.nextZ = null;
        p.prevZ = null;
        sortLinked(p);
      }
      function sortLinked(list) {
        var i, p, q, e, tail, numMerges, pSize, qSize, inSize = 1;
        do {
          p = list;
          list = null;
          tail = null;
          numMerges = 0;
          while (p) {
            numMerges++;
            q = p;
            pSize = 0;
            for (i = 0; i < inSize; i++) {
              pSize++;
              q = q.nextZ;
              if (!q)
                break;
            }
            qSize = inSize;
            while (pSize > 0 || qSize > 0 && q) {
              if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {
                e = p;
                p = p.nextZ;
                pSize--;
              } else {
                e = q;
                q = q.nextZ;
                qSize--;
              }
              if (tail)
                tail.nextZ = e;
              else
                list = e;
              e.prevZ = tail;
              tail = e;
            }
            p = q;
          }
          tail.nextZ = null;
          inSize *= 2;
        } while (numMerges > 1);
        return list;
      }
      function zOrder(x, y, minX, minY, invSize) {
        x = (x - minX) * invSize | 0;
        y = (y - minY) * invSize | 0;
        x = (x | x << 8) & 16711935;
        x = (x | x << 4) & 252645135;
        x = (x | x << 2) & 858993459;
        x = (x | x << 1) & 1431655765;
        y = (y | y << 8) & 16711935;
        y = (y | y << 4) & 252645135;
        y = (y | y << 2) & 858993459;
        y = (y | y << 1) & 1431655765;
        return x | y << 1;
      }
      function getLeftmost(start) {
        var p = start, leftmost = start;
        do {
          if (p.x < leftmost.x || p.x === leftmost.x && p.y < leftmost.y)
            leftmost = p;
          p = p.next;
        } while (p !== start);
        return leftmost;
      }
      function pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {
        return (cx - px) * (ay - py) >= (ax - px) * (cy - py) && (ax - px) * (by - py) >= (bx - px) * (ay - py) && (bx - px) * (cy - py) >= (cx - px) * (by - py);
      }
      function isValidDiagonal(a3, b) {
        return a3.next.i !== b.i && a3.prev.i !== b.i && !intersectsPolygon(a3, b) && (locallyInside(a3, b) && locallyInside(b, a3) && middleInside(a3, b) && (area(a3.prev, a3, b.prev) || area(a3, b.prev, b)) || equals(a3, b) && area(a3.prev, a3, a3.next) > 0 && area(b.prev, b, b.next) > 0);
      }
      function area(p, q, r) {
        return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
      }
      function equals(p1, p2) {
        return p1.x === p2.x && p1.y === p2.y;
      }
      function intersects(p1, q12, p2, q22) {
        var o1 = sign2(area(p1, q12, p2));
        var o2 = sign2(area(p1, q12, q22));
        var o3 = sign2(area(p2, q22, p1));
        var o4 = sign2(area(p2, q22, q12));
        if (o1 !== o2 && o3 !== o4)
          return true;
        if (o1 === 0 && onSegment(p1, p2, q12))
          return true;
        if (o2 === 0 && onSegment(p1, q22, q12))
          return true;
        if (o3 === 0 && onSegment(p2, p1, q22))
          return true;
        if (o4 === 0 && onSegment(p2, q12, q22))
          return true;
        return false;
      }
      function onSegment(p, q, r) {
        return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
      }
      function sign2(num) {
        return num > 0 ? 1 : num < 0 ? -1 : 0;
      }
      function intersectsPolygon(a3, b) {
        var p = a3;
        do {
          if (p.i !== a3.i && p.next.i !== a3.i && p.i !== b.i && p.next.i !== b.i && intersects(p, p.next, a3, b))
            return true;
          p = p.next;
        } while (p !== a3);
        return false;
      }
      function locallyInside(a3, b) {
        return area(a3.prev, a3, a3.next) < 0 ? area(a3, b, a3.next) >= 0 && area(a3, a3.prev, b) >= 0 : area(a3, b, a3.prev) < 0 || area(a3, a3.next, b) < 0;
      }
      function middleInside(a3, b) {
        var p = a3, inside = false, px = (a3.x + b.x) / 2, py = (a3.y + b.y) / 2;
        do {
          if (p.y > py !== p.next.y > py && p.next.y !== p.y && px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x)
            inside = !inside;
          p = p.next;
        } while (p !== a3);
        return inside;
      }
      function splitPolygon(a3, b) {
        var a22 = new Node6(a3.i, a3.x, a3.y), b2 = new Node6(b.i, b.x, b.y), an = a3.next, bp = b.prev;
        a3.next = b;
        b.prev = a3;
        a22.next = an;
        an.prev = a22;
        b2.next = a22;
        a22.prev = b2;
        bp.next = b2;
        b2.prev = bp;
        return b2;
      }
      function insertNode(i, x, y, last) {
        var p = new Node6(i, x, y);
        if (!last) {
          p.prev = p;
          p.next = p;
        } else {
          p.next = last.next;
          p.prev = last;
          last.next.prev = p;
          last.next = p;
        }
        return p;
      }
      function removeNode(p) {
        p.next.prev = p.prev;
        p.prev.next = p.next;
        if (p.prevZ)
          p.prevZ.nextZ = p.nextZ;
        if (p.nextZ)
          p.nextZ.prevZ = p.prevZ;
      }
      function Node6(i, x, y) {
        this.i = i;
        this.x = x;
        this.y = y;
        this.prev = null;
        this.next = null;
        this.z = 0;
        this.prevZ = null;
        this.nextZ = null;
        this.steiner = false;
      }
      earcut2.deviation = function(data, holeIndices, dim, triangles) {
        var hasHoles = holeIndices && holeIndices.length;
        var outerLen = hasHoles ? holeIndices[0] * dim : data.length;
        var polygonArea = Math.abs(signedArea(data, 0, outerLen, dim));
        if (hasHoles) {
          for (var i = 0, len = holeIndices.length; i < len; i++) {
            var start = holeIndices[i] * dim;
            var end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
            polygonArea -= Math.abs(signedArea(data, start, end, dim));
          }
        }
        var trianglesArea = 0;
        for (i = 0; i < triangles.length; i += 3) {
          var a3 = triangles[i] * dim;
          var b = triangles[i + 1] * dim;
          var c = triangles[i + 2] * dim;
          trianglesArea += Math.abs(
            (data[a3] - data[c]) * (data[b + 1] - data[a3 + 1]) - (data[a3] - data[b]) * (data[c + 1] - data[a3 + 1])
          );
        }
        return polygonArea === 0 && trianglesArea === 0 ? 0 : Math.abs((trianglesArea - polygonArea) / polygonArea);
      };
      function signedArea(data, start, end, dim) {
        var sum = 0;
        for (var i = start, j = end - dim; i < end; i += dim) {
          sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);
          j = i;
        }
        return sum;
      }
      earcut2.flatten = function(data) {
        var dim = data[0][0].length, result = { vertices: [], holes: [], dimensions: dim }, holeIndex = 0;
        for (var i = 0; i < data.length; i++) {
          for (var j = 0; j < data[i].length; j++) {
            for (var d = 0; d < dim; d++)
              result.vertices.push(data[i][j][d]);
          }
          if (i > 0) {
            holeIndex += data[i - 1].length;
            result.holes.push(holeIndex);
          }
        }
        return result;
      };
    }
  });

  // node_modules/rbush/rbush.min.js
  var require_rbush_min = __commonJS({
    "node_modules/rbush/rbush.min.js"(exports2, module2) {
      !function(t, i) {
        "object" == typeof exports2 && "undefined" != typeof module2 ? module2.exports = i() : "function" == typeof define && define.amd ? define(i) : (t = t || self).RBush = i();
      }(exports2, function() {
        "use strict";
        function t(t2, r2, e2, a4, h2) {
          !function t3(n2, r3, e3, a5, h3) {
            for (; a5 > e3; ) {
              if (a5 - e3 > 600) {
                var o2 = a5 - e3 + 1, s2 = r3 - e3 + 1, l2 = Math.log(o2), f2 = 0.5 * Math.exp(2 * l2 / 3), u4 = 0.5 * Math.sqrt(l2 * f2 * (o2 - f2) / o2) * (s2 - o2 / 2 < 0 ? -1 : 1), m2 = Math.max(e3, Math.floor(r3 - s2 * f2 / o2 + u4)), c14 = Math.min(a5, Math.floor(r3 + (o2 - s2) * f2 / o2 + u4));
                t3(n2, r3, m2, c14, h3);
              }
              var p2 = n2[r3], d2 = e3, x = a5;
              for (i(n2, e3, r3), h3(n2[a5], p2) > 0 && i(n2, e3, a5); d2 < x; ) {
                for (i(n2, d2, x), d2++, x--; h3(n2[d2], p2) < 0; )
                  d2++;
                for (; h3(n2[x], p2) > 0; )
                  x--;
              }
              0 === h3(n2[e3], p2) ? i(n2, e3, x) : i(n2, ++x, a5), x <= r3 && (e3 = x + 1), r3 <= x && (a5 = x - 1);
            }
          }(t2, r2, e2 || 0, a4 || t2.length - 1, h2 || n);
        }
        function i(t2, i2, n2) {
          var r2 = t2[i2];
          t2[i2] = t2[n2], t2[n2] = r2;
        }
        function n(t2, i2) {
          return t2 < i2 ? -1 : t2 > i2 ? 1 : 0;
        }
        var r = function(t2) {
          void 0 === t2 && (t2 = 9), this._maxEntries = Math.max(4, t2), this._minEntries = Math.max(2, Math.ceil(0.4 * this._maxEntries)), this.clear();
        };
        function e(t2, i2, n2) {
          if (!n2)
            return i2.indexOf(t2);
          for (var r2 = 0; r2 < i2.length; r2++)
            if (n2(t2, i2[r2]))
              return r2;
          return -1;
        }
        function a3(t2, i2) {
          h(t2, 0, t2.children.length, i2, t2);
        }
        function h(t2, i2, n2, r2, e2) {
          e2 || (e2 = p(null)), e2.minX = 1 / 0, e2.minY = 1 / 0, e2.maxX = -1 / 0, e2.maxY = -1 / 0;
          for (var a4 = i2; a4 < n2; a4++) {
            var h2 = t2.children[a4];
            o(e2, t2.leaf ? r2(h2) : h2);
          }
          return e2;
        }
        function o(t2, i2) {
          return t2.minX = Math.min(t2.minX, i2.minX), t2.minY = Math.min(t2.minY, i2.minY), t2.maxX = Math.max(t2.maxX, i2.maxX), t2.maxY = Math.max(t2.maxY, i2.maxY), t2;
        }
        function s(t2, i2) {
          return t2.minX - i2.minX;
        }
        function l(t2, i2) {
          return t2.minY - i2.minY;
        }
        function f(t2) {
          return (t2.maxX - t2.minX) * (t2.maxY - t2.minY);
        }
        function u3(t2) {
          return t2.maxX - t2.minX + (t2.maxY - t2.minY);
        }
        function m(t2, i2) {
          return t2.minX <= i2.minX && t2.minY <= i2.minY && i2.maxX <= t2.maxX && i2.maxY <= t2.maxY;
        }
        function c(t2, i2) {
          return i2.minX <= t2.maxX && i2.minY <= t2.maxY && i2.maxX >= t2.minX && i2.maxY >= t2.minY;
        }
        function p(t2) {
          return { children: t2, height: 1, leaf: true, minX: 1 / 0, minY: 1 / 0, maxX: -1 / 0, maxY: -1 / 0 };
        }
        function d(i2, n2, r2, e2, a4) {
          for (var h2 = [n2, r2]; h2.length; )
            if (!((r2 = h2.pop()) - (n2 = h2.pop()) <= e2)) {
              var o2 = n2 + Math.ceil((r2 - n2) / e2 / 2) * e2;
              t(i2, o2, n2, r2, a4), h2.push(n2, o2, o2, r2);
            }
        }
        return r.prototype.all = function() {
          return this._all(this.data, []);
        }, r.prototype.search = function(t2) {
          var i2 = this.data, n2 = [];
          if (!c(t2, i2))
            return n2;
          for (var r2 = this.toBBox, e2 = []; i2; ) {
            for (var a4 = 0; a4 < i2.children.length; a4++) {
              var h2 = i2.children[a4], o2 = i2.leaf ? r2(h2) : h2;
              c(t2, o2) && (i2.leaf ? n2.push(h2) : m(t2, o2) ? this._all(h2, n2) : e2.push(h2));
            }
            i2 = e2.pop();
          }
          return n2;
        }, r.prototype.collides = function(t2) {
          var i2 = this.data;
          if (!c(t2, i2))
            return false;
          for (var n2 = []; i2; ) {
            for (var r2 = 0; r2 < i2.children.length; r2++) {
              var e2 = i2.children[r2], a4 = i2.leaf ? this.toBBox(e2) : e2;
              if (c(t2, a4)) {
                if (i2.leaf || m(t2, a4))
                  return true;
                n2.push(e2);
              }
            }
            i2 = n2.pop();
          }
          return false;
        }, r.prototype.load = function(t2) {
          if (!t2 || !t2.length)
            return this;
          if (t2.length < this._minEntries) {
            for (var i2 = 0; i2 < t2.length; i2++)
              this.insert(t2[i2]);
            return this;
          }
          var n2 = this._build(t2.slice(), 0, t2.length - 1, 0);
          if (this.data.children.length)
            if (this.data.height === n2.height)
              this._splitRoot(this.data, n2);
            else {
              if (this.data.height < n2.height) {
                var r2 = this.data;
                this.data = n2, n2 = r2;
              }
              this._insert(n2, this.data.height - n2.height - 1, true);
            }
          else
            this.data = n2;
          return this;
        }, r.prototype.insert = function(t2) {
          return t2 && this._insert(t2, this.data.height - 1), this;
        }, r.prototype.clear = function() {
          return this.data = p([]), this;
        }, r.prototype.remove = function(t2, i2) {
          if (!t2)
            return this;
          for (var n2, r2, a4, h2 = this.data, o2 = this.toBBox(t2), s2 = [], l2 = []; h2 || s2.length; ) {
            if (h2 || (h2 = s2.pop(), r2 = s2[s2.length - 1], n2 = l2.pop(), a4 = true), h2.leaf) {
              var f2 = e(t2, h2.children, i2);
              if (-1 !== f2)
                return h2.children.splice(f2, 1), s2.push(h2), this._condense(s2), this;
            }
            a4 || h2.leaf || !m(h2, o2) ? r2 ? (n2++, h2 = r2.children[n2], a4 = false) : h2 = null : (s2.push(h2), l2.push(n2), n2 = 0, r2 = h2, h2 = h2.children[0]);
          }
          return this;
        }, r.prototype.toBBox = function(t2) {
          return t2;
        }, r.prototype.compareMinX = function(t2, i2) {
          return t2.minX - i2.minX;
        }, r.prototype.compareMinY = function(t2, i2) {
          return t2.minY - i2.minY;
        }, r.prototype.toJSON = function() {
          return this.data;
        }, r.prototype.fromJSON = function(t2) {
          return this.data = t2, this;
        }, r.prototype._all = function(t2, i2) {
          for (var n2 = []; t2; )
            t2.leaf ? i2.push.apply(i2, t2.children) : n2.push.apply(n2, t2.children), t2 = n2.pop();
          return i2;
        }, r.prototype._build = function(t2, i2, n2, r2) {
          var e2, h2 = n2 - i2 + 1, o2 = this._maxEntries;
          if (h2 <= o2)
            return a3(e2 = p(t2.slice(i2, n2 + 1)), this.toBBox), e2;
          r2 || (r2 = Math.ceil(Math.log(h2) / Math.log(o2)), o2 = Math.ceil(h2 / Math.pow(o2, r2 - 1))), (e2 = p([])).leaf = false, e2.height = r2;
          var s2 = Math.ceil(h2 / o2), l2 = s2 * Math.ceil(Math.sqrt(o2));
          d(t2, i2, n2, l2, this.compareMinX);
          for (var f2 = i2; f2 <= n2; f2 += l2) {
            var u4 = Math.min(f2 + l2 - 1, n2);
            d(t2, f2, u4, s2, this.compareMinY);
            for (var m2 = f2; m2 <= u4; m2 += s2) {
              var c14 = Math.min(m2 + s2 - 1, u4);
              e2.children.push(this._build(t2, m2, c14, r2 - 1));
            }
          }
          return a3(e2, this.toBBox), e2;
        }, r.prototype._chooseSubtree = function(t2, i2, n2, r2) {
          for (; r2.push(i2), !i2.leaf && r2.length - 1 !== n2; ) {
            for (var e2 = 1 / 0, a4 = 1 / 0, h2 = void 0, o2 = 0; o2 < i2.children.length; o2++) {
              var s2 = i2.children[o2], l2 = f(s2), u4 = (m2 = t2, c14 = s2, (Math.max(c14.maxX, m2.maxX) - Math.min(c14.minX, m2.minX)) * (Math.max(c14.maxY, m2.maxY) - Math.min(c14.minY, m2.minY)) - l2);
              u4 < a4 ? (a4 = u4, e2 = l2 < e2 ? l2 : e2, h2 = s2) : u4 === a4 && l2 < e2 && (e2 = l2, h2 = s2);
            }
            i2 = h2 || i2.children[0];
          }
          var m2, c14;
          return i2;
        }, r.prototype._insert = function(t2, i2, n2) {
          var r2 = n2 ? t2 : this.toBBox(t2), e2 = [], a4 = this._chooseSubtree(r2, this.data, i2, e2);
          for (a4.children.push(t2), o(a4, r2); i2 >= 0 && e2[i2].children.length > this._maxEntries; )
            this._split(e2, i2), i2--;
          this._adjustParentBBoxes(r2, e2, i2);
        }, r.prototype._split = function(t2, i2) {
          var n2 = t2[i2], r2 = n2.children.length, e2 = this._minEntries;
          this._chooseSplitAxis(n2, e2, r2);
          var h2 = this._chooseSplitIndex(n2, e2, r2), o2 = p(n2.children.splice(h2, n2.children.length - h2));
          o2.height = n2.height, o2.leaf = n2.leaf, a3(n2, this.toBBox), a3(o2, this.toBBox), i2 ? t2[i2 - 1].children.push(o2) : this._splitRoot(n2, o2);
        }, r.prototype._splitRoot = function(t2, i2) {
          this.data = p([t2, i2]), this.data.height = t2.height + 1, this.data.leaf = false, a3(this.data, this.toBBox);
        }, r.prototype._chooseSplitIndex = function(t2, i2, n2) {
          for (var r2, e2, a4, o2, s2, l2, u4, m2 = 1 / 0, c14 = 1 / 0, p2 = i2; p2 <= n2 - i2; p2++) {
            var d2 = h(t2, 0, p2, this.toBBox), x = h(t2, p2, n2, this.toBBox), v7 = (e2 = d2, a4 = x, o2 = void 0, s2 = void 0, l2 = void 0, u4 = void 0, o2 = Math.max(e2.minX, a4.minX), s2 = Math.max(e2.minY, a4.minY), l2 = Math.min(e2.maxX, a4.maxX), u4 = Math.min(e2.maxY, a4.maxY), Math.max(0, l2 - o2) * Math.max(0, u4 - s2)), M = f(d2) + f(x);
            v7 < m2 ? (m2 = v7, r2 = p2, c14 = M < c14 ? M : c14) : v7 === m2 && M < c14 && (c14 = M, r2 = p2);
          }
          return r2 || n2 - i2;
        }, r.prototype._chooseSplitAxis = function(t2, i2, n2) {
          var r2 = t2.leaf ? this.compareMinX : s, e2 = t2.leaf ? this.compareMinY : l;
          this._allDistMargin(t2, i2, n2, r2) < this._allDistMargin(t2, i2, n2, e2) && t2.children.sort(r2);
        }, r.prototype._allDistMargin = function(t2, i2, n2, r2) {
          t2.children.sort(r2);
          for (var e2 = this.toBBox, a4 = h(t2, 0, i2, e2), s2 = h(t2, n2 - i2, n2, e2), l2 = u3(a4) + u3(s2), f2 = i2; f2 < n2 - i2; f2++) {
            var m2 = t2.children[f2];
            o(a4, t2.leaf ? e2(m2) : m2), l2 += u3(a4);
          }
          for (var c14 = n2 - i2 - 1; c14 >= i2; c14--) {
            var p2 = t2.children[c14];
            o(s2, t2.leaf ? e2(p2) : p2), l2 += u3(s2);
          }
          return l2;
        }, r.prototype._adjustParentBBoxes = function(t2, i2, n2) {
          for (var r2 = n2; r2 >= 0; r2--)
            o(i2[r2], t2);
        }, r.prototype._condense = function(t2) {
          for (var i2 = t2.length - 1, n2 = void 0; i2 >= 0; i2--)
            0 === t2[i2].children.length ? i2 > 0 ? (n2 = t2[i2 - 1].children).splice(n2.indexOf(t2[i2]), 1) : this.clear() : a3(t2[i2], this.toBBox);
        }, r;
      });
    }
  });

  // node_modules/protobufjs/dist/minimal/protobuf.js
  var require_protobuf = __commonJS({
    "node_modules/protobufjs/dist/minimal/protobuf.js"(exports, module) {
      /*!
       * protobuf.js v7.2.5 (c) 2016, daniel wirtz
       * compiled tue, 22 aug 2023 00:04:28 utc
       * licensed under the bsd-3-clause license
       * see: https://github.com/dcodeio/protobuf.js for details
       */
      (function(undefined) {
        "use strict";
        (function prelude(modules, cache, entries) {
          function $require(name) {
            var $module = cache[name];
            if (!$module)
              modules[name][0].call($module = cache[name] = { exports: {} }, $require, $module, $module.exports);
            return $module.exports;
          }
          var protobuf3 = $require(entries[0]);
          protobuf3.util.global.protobuf = protobuf3;
          if (typeof define === "function" && define.amd)
            define(["long"], function(Long) {
              if (Long && Long.isLong) {
                protobuf3.util.Long = Long;
                protobuf3.configure();
              }
              return protobuf3;
            });
          if (typeof module === "object" && module && module.exports)
            module.exports = protobuf3;
        })({ 1: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = asPromise;
          function asPromise(fn, ctx) {
            var params = new Array(arguments.length - 1), offset2 = 0, index = 2, pending = true;
            while (index < arguments.length)
              params[offset2++] = arguments[index++];
            return new Promise(function executor(resolve2, reject) {
              params[offset2] = function callback(err) {
                if (pending) {
                  pending = false;
                  if (err)
                    reject(err);
                  else {
                    var params2 = new Array(arguments.length - 1), offset3 = 0;
                    while (offset3 < params2.length)
                      params2[offset3++] = arguments[offset3];
                    resolve2.apply(null, params2);
                  }
                }
              };
              try {
                fn.apply(ctx || null, params);
              } catch (err) {
                if (pending) {
                  pending = false;
                  reject(err);
                }
              }
            });
          }
        }, {}], 2: [function(require2, module2, exports2) {
          "use strict";
          var base64 = exports2;
          base64.length = function length3(string) {
            var p = string.length;
            if (!p)
              return 0;
            var n = 0;
            while (--p % 4 > 1 && string.charAt(p) === "=")
              ++n;
            return Math.ceil(string.length * 3) / 4 - n;
          };
          var b64 = new Array(64);
          var s64 = new Array(123);
          for (var i = 0; i < 64; )
            s64[b64[i] = i < 26 ? i + 65 : i < 52 ? i + 71 : i < 62 ? i - 4 : i - 59 | 43] = i++;
          base64.encode = function encode(buffer, start, end) {
            var parts = null, chunk = [];
            var i2 = 0, j = 0, t;
            while (start < end) {
              var b = buffer[start++];
              switch (j) {
                case 0:
                  chunk[i2++] = b64[b >> 2];
                  t = (b & 3) << 4;
                  j = 1;
                  break;
                case 1:
                  chunk[i2++] = b64[t | b >> 4];
                  t = (b & 15) << 2;
                  j = 2;
                  break;
                case 2:
                  chunk[i2++] = b64[t | b >> 6];
                  chunk[i2++] = b64[b & 63];
                  j = 0;
                  break;
              }
              if (i2 > 8191) {
                (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
                i2 = 0;
              }
            }
            if (j) {
              chunk[i2++] = b64[t];
              chunk[i2++] = 61;
              if (j === 1)
                chunk[i2++] = 61;
            }
            if (parts) {
              if (i2)
                parts.push(String.fromCharCode.apply(String, chunk.slice(0, i2)));
              return parts.join("");
            }
            return String.fromCharCode.apply(String, chunk.slice(0, i2));
          };
          var invalidEncoding = "invalid encoding";
          base64.decode = function decode(string, buffer, offset2) {
            var start = offset2;
            var j = 0, t;
            for (var i2 = 0; i2 < string.length; ) {
              var c = string.charCodeAt(i2++);
              if (c === 61 && j > 1)
                break;
              if ((c = s64[c]) === undefined)
                throw Error(invalidEncoding);
              switch (j) {
                case 0:
                  t = c;
                  j = 1;
                  break;
                case 1:
                  buffer[offset2++] = t << 2 | (c & 48) >> 4;
                  t = c;
                  j = 2;
                  break;
                case 2:
                  buffer[offset2++] = (t & 15) << 4 | (c & 60) >> 2;
                  t = c;
                  j = 3;
                  break;
                case 3:
                  buffer[offset2++] = (t & 3) << 6 | c;
                  j = 0;
                  break;
              }
            }
            if (j === 1)
              throw Error(invalidEncoding);
            return offset2 - start;
          };
          base64.test = function test(string) {
            return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(string);
          };
        }, {}], 3: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = EventEmitter;
          function EventEmitter() {
            this._listeners = {};
          }
          EventEmitter.prototype.on = function on(evt, fn, ctx) {
            (this._listeners[evt] || (this._listeners[evt] = [])).push({
              fn,
              ctx: ctx || this
            });
            return this;
          };
          EventEmitter.prototype.off = function off(evt, fn) {
            if (evt === undefined)
              this._listeners = {};
            else {
              if (fn === undefined)
                this._listeners[evt] = [];
              else {
                var listeners = this._listeners[evt];
                for (var i = 0; i < listeners.length; )
                  if (listeners[i].fn === fn)
                    listeners.splice(i, 1);
                  else
                    ++i;
              }
            }
            return this;
          };
          EventEmitter.prototype.emit = function emit(evt) {
            var listeners = this._listeners[evt];
            if (listeners) {
              var args = [], i = 1;
              for (; i < arguments.length; )
                args.push(arguments[i++]);
              for (i = 0; i < listeners.length; )
                listeners[i].fn.apply(listeners[i++].ctx, args);
            }
            return this;
          };
        }, {}], 4: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = factory(factory);
          function factory(exports3) {
            if (typeof Float32Array !== "undefined")
              (function() {
                var f32 = new Float32Array([-0]), f8b = new Uint8Array(f32.buffer), le = f8b[3] === 128;
                function writeFloat_f32_cpy(val, buf, pos) {
                  f32[0] = val;
                  buf[pos] = f8b[0];
                  buf[pos + 1] = f8b[1];
                  buf[pos + 2] = f8b[2];
                  buf[pos + 3] = f8b[3];
                }
                function writeFloat_f32_rev(val, buf, pos) {
                  f32[0] = val;
                  buf[pos] = f8b[3];
                  buf[pos + 1] = f8b[2];
                  buf[pos + 2] = f8b[1];
                  buf[pos + 3] = f8b[0];
                }
                exports3.writeFloatLE = le ? writeFloat_f32_cpy : writeFloat_f32_rev;
                exports3.writeFloatBE = le ? writeFloat_f32_rev : writeFloat_f32_cpy;
                function readFloat_f32_cpy(buf, pos) {
                  f8b[0] = buf[pos];
                  f8b[1] = buf[pos + 1];
                  f8b[2] = buf[pos + 2];
                  f8b[3] = buf[pos + 3];
                  return f32[0];
                }
                function readFloat_f32_rev(buf, pos) {
                  f8b[3] = buf[pos];
                  f8b[2] = buf[pos + 1];
                  f8b[1] = buf[pos + 2];
                  f8b[0] = buf[pos + 3];
                  return f32[0];
                }
                exports3.readFloatLE = le ? readFloat_f32_cpy : readFloat_f32_rev;
                exports3.readFloatBE = le ? readFloat_f32_rev : readFloat_f32_cpy;
              })();
            else
              (function() {
                function writeFloat_ieee754(writeUint, val, buf, pos) {
                  var sign2 = val < 0 ? 1 : 0;
                  if (sign2)
                    val = -val;
                  if (val === 0)
                    writeUint(1 / val > 0 ? 0 : 2147483648, buf, pos);
                  else if (isNaN(val))
                    writeUint(2143289344, buf, pos);
                  else if (val > 34028234663852886e22)
                    writeUint((sign2 << 31 | 2139095040) >>> 0, buf, pos);
                  else if (val < 11754943508222875e-54)
                    writeUint((sign2 << 31 | Math.round(val / 1401298464324817e-60)) >>> 0, buf, pos);
                  else {
                    var exponent = Math.floor(Math.log(val) / Math.LN2), mantissa = Math.round(val * Math.pow(2, -exponent) * 8388608) & 8388607;
                    writeUint((sign2 << 31 | exponent + 127 << 23 | mantissa) >>> 0, buf, pos);
                  }
                }
                exports3.writeFloatLE = writeFloat_ieee754.bind(null, writeUintLE);
                exports3.writeFloatBE = writeFloat_ieee754.bind(null, writeUintBE);
                function readFloat_ieee754(readUint, buf, pos) {
                  var uint = readUint(buf, pos), sign2 = (uint >> 31) * 2 + 1, exponent = uint >>> 23 & 255, mantissa = uint & 8388607;
                  return exponent === 255 ? mantissa ? NaN : sign2 * Infinity : exponent === 0 ? sign2 * 1401298464324817e-60 * mantissa : sign2 * Math.pow(2, exponent - 150) * (mantissa + 8388608);
                }
                exports3.readFloatLE = readFloat_ieee754.bind(null, readUintLE);
                exports3.readFloatBE = readFloat_ieee754.bind(null, readUintBE);
              })();
            if (typeof Float64Array !== "undefined")
              (function() {
                var f64 = new Float64Array([-0]), f8b = new Uint8Array(f64.buffer), le = f8b[7] === 128;
                function writeDouble_f64_cpy(val, buf, pos) {
                  f64[0] = val;
                  buf[pos] = f8b[0];
                  buf[pos + 1] = f8b[1];
                  buf[pos + 2] = f8b[2];
                  buf[pos + 3] = f8b[3];
                  buf[pos + 4] = f8b[4];
                  buf[pos + 5] = f8b[5];
                  buf[pos + 6] = f8b[6];
                  buf[pos + 7] = f8b[7];
                }
                function writeDouble_f64_rev(val, buf, pos) {
                  f64[0] = val;
                  buf[pos] = f8b[7];
                  buf[pos + 1] = f8b[6];
                  buf[pos + 2] = f8b[5];
                  buf[pos + 3] = f8b[4];
                  buf[pos + 4] = f8b[3];
                  buf[pos + 5] = f8b[2];
                  buf[pos + 6] = f8b[1];
                  buf[pos + 7] = f8b[0];
                }
                exports3.writeDoubleLE = le ? writeDouble_f64_cpy : writeDouble_f64_rev;
                exports3.writeDoubleBE = le ? writeDouble_f64_rev : writeDouble_f64_cpy;
                function readDouble_f64_cpy(buf, pos) {
                  f8b[0] = buf[pos];
                  f8b[1] = buf[pos + 1];
                  f8b[2] = buf[pos + 2];
                  f8b[3] = buf[pos + 3];
                  f8b[4] = buf[pos + 4];
                  f8b[5] = buf[pos + 5];
                  f8b[6] = buf[pos + 6];
                  f8b[7] = buf[pos + 7];
                  return f64[0];
                }
                function readDouble_f64_rev(buf, pos) {
                  f8b[7] = buf[pos];
                  f8b[6] = buf[pos + 1];
                  f8b[5] = buf[pos + 2];
                  f8b[4] = buf[pos + 3];
                  f8b[3] = buf[pos + 4];
                  f8b[2] = buf[pos + 5];
                  f8b[1] = buf[pos + 6];
                  f8b[0] = buf[pos + 7];
                  return f64[0];
                }
                exports3.readDoubleLE = le ? readDouble_f64_cpy : readDouble_f64_rev;
                exports3.readDoubleBE = le ? readDouble_f64_rev : readDouble_f64_cpy;
              })();
            else
              (function() {
                function writeDouble_ieee754(writeUint, off0, off1, val, buf, pos) {
                  var sign2 = val < 0 ? 1 : 0;
                  if (sign2)
                    val = -val;
                  if (val === 0) {
                    writeUint(0, buf, pos + off0);
                    writeUint(1 / val > 0 ? 0 : 2147483648, buf, pos + off1);
                  } else if (isNaN(val)) {
                    writeUint(0, buf, pos + off0);
                    writeUint(2146959360, buf, pos + off1);
                  } else if (val > 17976931348623157e292) {
                    writeUint(0, buf, pos + off0);
                    writeUint((sign2 << 31 | 2146435072) >>> 0, buf, pos + off1);
                  } else {
                    var mantissa;
                    if (val < 22250738585072014e-324) {
                      mantissa = val / 5e-324;
                      writeUint(mantissa >>> 0, buf, pos + off0);
                      writeUint((sign2 << 31 | mantissa / 4294967296) >>> 0, buf, pos + off1);
                    } else {
                      var exponent = Math.floor(Math.log(val) / Math.LN2);
                      if (exponent === 1024)
                        exponent = 1023;
                      mantissa = val * Math.pow(2, -exponent);
                      writeUint(mantissa * 4503599627370496 >>> 0, buf, pos + off0);
                      writeUint((sign2 << 31 | exponent + 1023 << 20 | mantissa * 1048576 & 1048575) >>> 0, buf, pos + off1);
                    }
                  }
                }
                exports3.writeDoubleLE = writeDouble_ieee754.bind(null, writeUintLE, 0, 4);
                exports3.writeDoubleBE = writeDouble_ieee754.bind(null, writeUintBE, 4, 0);
                function readDouble_ieee754(readUint, off0, off1, buf, pos) {
                  var lo = readUint(buf, pos + off0), hi = readUint(buf, pos + off1);
                  var sign2 = (hi >> 31) * 2 + 1, exponent = hi >>> 20 & 2047, mantissa = 4294967296 * (hi & 1048575) + lo;
                  return exponent === 2047 ? mantissa ? NaN : sign2 * Infinity : exponent === 0 ? sign2 * 5e-324 * mantissa : sign2 * Math.pow(2, exponent - 1075) * (mantissa + 4503599627370496);
                }
                exports3.readDoubleLE = readDouble_ieee754.bind(null, readUintLE, 0, 4);
                exports3.readDoubleBE = readDouble_ieee754.bind(null, readUintBE, 4, 0);
              })();
            return exports3;
          }
          function writeUintLE(val, buf, pos) {
            buf[pos] = val & 255;
            buf[pos + 1] = val >>> 8 & 255;
            buf[pos + 2] = val >>> 16 & 255;
            buf[pos + 3] = val >>> 24;
          }
          function writeUintBE(val, buf, pos) {
            buf[pos] = val >>> 24;
            buf[pos + 1] = val >>> 16 & 255;
            buf[pos + 2] = val >>> 8 & 255;
            buf[pos + 3] = val & 255;
          }
          function readUintLE(buf, pos) {
            return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16 | buf[pos + 3] << 24) >>> 0;
          }
          function readUintBE(buf, pos) {
            return (buf[pos] << 24 | buf[pos + 1] << 16 | buf[pos + 2] << 8 | buf[pos + 3]) >>> 0;
          }
        }, {}], 5: [function(require, module, exports) {
          "use strict";
          module.exports = inquire;
          function inquire(moduleName) {
            try {
              var mod = eval("quire".replace(/^/, "re"))(moduleName);
              if (mod && (mod.length || Object.keys(mod).length))
                return mod;
            } catch (e) {
            }
            return null;
          }
        }, {}], 6: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = pool2;
          function pool2(alloc, slice, size) {
            var SIZE = size || 8192;
            var MAX = SIZE >>> 1;
            var slab = null;
            var offset2 = SIZE;
            return function pool_alloc(size2) {
              if (size2 < 1 || size2 > MAX)
                return alloc(size2);
              if (offset2 + size2 > SIZE) {
                slab = alloc(SIZE);
                offset2 = 0;
              }
              var buf = slice.call(slab, offset2, offset2 += size2);
              if (offset2 & 7)
                offset2 = (offset2 | 7) + 1;
              return buf;
            };
          }
        }, {}], 7: [function(require2, module2, exports2) {
          "use strict";
          var utf8 = exports2;
          utf8.length = function utf8_length(string) {
            var len = 0, c = 0;
            for (var i = 0; i < string.length; ++i) {
              c = string.charCodeAt(i);
              if (c < 128)
                len += 1;
              else if (c < 2048)
                len += 2;
              else if ((c & 64512) === 55296 && (string.charCodeAt(i + 1) & 64512) === 56320) {
                ++i;
                len += 4;
              } else
                len += 3;
            }
            return len;
          };
          utf8.read = function utf8_read(buffer, start, end) {
            var len = end - start;
            if (len < 1)
              return "";
            var parts = null, chunk = [], i = 0, t;
            while (start < end) {
              t = buffer[start++];
              if (t < 128)
                chunk[i++] = t;
              else if (t > 191 && t < 224)
                chunk[i++] = (t & 31) << 6 | buffer[start++] & 63;
              else if (t > 239 && t < 365) {
                t = ((t & 7) << 18 | (buffer[start++] & 63) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63) - 65536;
                chunk[i++] = 55296 + (t >> 10);
                chunk[i++] = 56320 + (t & 1023);
              } else
                chunk[i++] = (t & 15) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63;
              if (i > 8191) {
                (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
                i = 0;
              }
            }
            if (parts) {
              if (i)
                parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
              return parts.join("");
            }
            return String.fromCharCode.apply(String, chunk.slice(0, i));
          };
          utf8.write = function utf8_write(string, buffer, offset2) {
            var start = offset2, c14, c22;
            for (var i = 0; i < string.length; ++i) {
              c14 = string.charCodeAt(i);
              if (c14 < 128) {
                buffer[offset2++] = c14;
              } else if (c14 < 2048) {
                buffer[offset2++] = c14 >> 6 | 192;
                buffer[offset2++] = c14 & 63 | 128;
              } else if ((c14 & 64512) === 55296 && ((c22 = string.charCodeAt(i + 1)) & 64512) === 56320) {
                c14 = 65536 + ((c14 & 1023) << 10) + (c22 & 1023);
                ++i;
                buffer[offset2++] = c14 >> 18 | 240;
                buffer[offset2++] = c14 >> 12 & 63 | 128;
                buffer[offset2++] = c14 >> 6 & 63 | 128;
                buffer[offset2++] = c14 & 63 | 128;
              } else {
                buffer[offset2++] = c14 >> 12 | 224;
                buffer[offset2++] = c14 >> 6 & 63 | 128;
                buffer[offset2++] = c14 & 63 | 128;
              }
            }
            return offset2 - start;
          };
        }, {}], 8: [function(require2, module2, exports2) {
          "use strict";
          var protobuf3 = exports2;
          protobuf3.build = "minimal";
          protobuf3.Writer = require2(16);
          protobuf3.BufferWriter = require2(17);
          protobuf3.Reader = require2(9);
          protobuf3.BufferReader = require2(10);
          protobuf3.util = require2(15);
          protobuf3.rpc = require2(12);
          protobuf3.roots = require2(11);
          protobuf3.configure = configure2;
          function configure2() {
            protobuf3.util._configure();
            protobuf3.Writer._configure(protobuf3.BufferWriter);
            protobuf3.Reader._configure(protobuf3.BufferReader);
          }
          configure2();
        }, { "10": 10, "11": 11, "12": 12, "15": 15, "16": 16, "17": 17, "9": 9 }], 9: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = Reader3;
          var util = require2(15);
          var BufferReader;
          var LongBits = util.LongBits, utf8 = util.utf8;
          function indexOutOfRange(reader, writeLength) {
            return RangeError("index out of range: " + reader.pos + " + " + (writeLength || 1) + " > " + reader.len);
          }
          function Reader3(buffer) {
            this.buf = buffer;
            this.pos = 0;
            this.len = buffer.length;
          }
          var create_array = typeof Uint8Array !== "undefined" ? function create_typed_array(buffer) {
            if (buffer instanceof Uint8Array || Array.isArray(buffer))
              return new Reader3(buffer);
            throw Error("illegal buffer");
          } : function create_array2(buffer) {
            if (Array.isArray(buffer))
              return new Reader3(buffer);
            throw Error("illegal buffer");
          };
          var create = function create2() {
            return util.Buffer ? function create_buffer_setup(buffer) {
              return (Reader3.create = function create_buffer(buffer2) {
                return util.Buffer.isBuffer(buffer2) ? new BufferReader(buffer2) : create_array(buffer2);
              })(buffer);
            } : create_array;
          };
          Reader3.create = create();
          Reader3.prototype._slice = util.Array.prototype.subarray || util.Array.prototype.slice;
          Reader3.prototype.uint32 = function read_uint32_setup() {
            var value = 4294967295;
            return function read_uint32() {
              value = (this.buf[this.pos] & 127) >>> 0;
              if (this.buf[this.pos++] < 128)
                return value;
              value = (value | (this.buf[this.pos] & 127) << 7) >>> 0;
              if (this.buf[this.pos++] < 128)
                return value;
              value = (value | (this.buf[this.pos] & 127) << 14) >>> 0;
              if (this.buf[this.pos++] < 128)
                return value;
              value = (value | (this.buf[this.pos] & 127) << 21) >>> 0;
              if (this.buf[this.pos++] < 128)
                return value;
              value = (value | (this.buf[this.pos] & 15) << 28) >>> 0;
              if (this.buf[this.pos++] < 128)
                return value;
              if ((this.pos += 5) > this.len) {
                this.pos = this.len;
                throw indexOutOfRange(this, 10);
              }
              return value;
            };
          }();
          Reader3.prototype.int32 = function read_int32() {
            return this.uint32() | 0;
          };
          Reader3.prototype.sint32 = function read_sint32() {
            var value = this.uint32();
            return value >>> 1 ^ -(value & 1) | 0;
          };
          function readLongVarint() {
            var bits = new LongBits(0, 0);
            var i = 0;
            if (this.len - this.pos > 4) {
              for (; i < 4; ++i) {
                bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
                if (this.buf[this.pos++] < 128)
                  return bits;
              }
              bits.lo = (bits.lo | (this.buf[this.pos] & 127) << 28) >>> 0;
              bits.hi = (bits.hi | (this.buf[this.pos] & 127) >> 4) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
              i = 0;
            } else {
              for (; i < 3; ++i) {
                if (this.pos >= this.len)
                  throw indexOutOfRange(this);
                bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
                if (this.buf[this.pos++] < 128)
                  return bits;
              }
              bits.lo = (bits.lo | (this.buf[this.pos++] & 127) << i * 7) >>> 0;
              return bits;
            }
            if (this.len - this.pos > 4) {
              for (; i < 5; ++i) {
                bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
                if (this.buf[this.pos++] < 128)
                  return bits;
              }
            } else {
              for (; i < 5; ++i) {
                if (this.pos >= this.len)
                  throw indexOutOfRange(this);
                bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
                if (this.buf[this.pos++] < 128)
                  return bits;
              }
            }
            throw Error("invalid varint encoding");
          }
          Reader3.prototype.bool = function read_bool() {
            return this.uint32() !== 0;
          };
          function readFixed32_end(buf, end) {
            return (buf[end - 4] | buf[end - 3] << 8 | buf[end - 2] << 16 | buf[end - 1] << 24) >>> 0;
          }
          Reader3.prototype.fixed32 = function read_fixed32() {
            if (this.pos + 4 > this.len)
              throw indexOutOfRange(this, 4);
            return readFixed32_end(this.buf, this.pos += 4);
          };
          Reader3.prototype.sfixed32 = function read_sfixed32() {
            if (this.pos + 4 > this.len)
              throw indexOutOfRange(this, 4);
            return readFixed32_end(this.buf, this.pos += 4) | 0;
          };
          function readFixed64() {
            if (this.pos + 8 > this.len)
              throw indexOutOfRange(this, 8);
            return new LongBits(readFixed32_end(this.buf, this.pos += 4), readFixed32_end(this.buf, this.pos += 4));
          }
          Reader3.prototype.float = function read_float() {
            if (this.pos + 4 > this.len)
              throw indexOutOfRange(this, 4);
            var value = util.float.readFloatLE(this.buf, this.pos);
            this.pos += 4;
            return value;
          };
          Reader3.prototype.double = function read_double() {
            if (this.pos + 8 > this.len)
              throw indexOutOfRange(this, 4);
            var value = util.float.readDoubleLE(this.buf, this.pos);
            this.pos += 8;
            return value;
          };
          Reader3.prototype.bytes = function read_bytes() {
            var length3 = this.uint32(), start = this.pos, end = this.pos + length3;
            if (end > this.len)
              throw indexOutOfRange(this, length3);
            this.pos += length3;
            if (Array.isArray(this.buf))
              return this.buf.slice(start, end);
            if (start === end) {
              var nativeBuffer = util.Buffer;
              return nativeBuffer ? nativeBuffer.alloc(0) : new this.buf.constructor(0);
            }
            return this._slice.call(this.buf, start, end);
          };
          Reader3.prototype.string = function read_string() {
            var bytes = this.bytes();
            return utf8.read(bytes, 0, bytes.length);
          };
          Reader3.prototype.skip = function skip(length3) {
            if (typeof length3 === "number") {
              if (this.pos + length3 > this.len)
                throw indexOutOfRange(this, length3);
              this.pos += length3;
            } else {
              do {
                if (this.pos >= this.len)
                  throw indexOutOfRange(this);
              } while (this.buf[this.pos++] & 128);
            }
            return this;
          };
          Reader3.prototype.skipType = function(wireType) {
            switch (wireType) {
              case 0:
                this.skip();
                break;
              case 1:
                this.skip(8);
                break;
              case 2:
                this.skip(this.uint32());
                break;
              case 3:
                while ((wireType = this.uint32() & 7) !== 4) {
                  this.skipType(wireType);
                }
                break;
              case 5:
                this.skip(4);
                break;
              default:
                throw Error("invalid wire type " + wireType + " at offset " + this.pos);
            }
            return this;
          };
          Reader3._configure = function(BufferReader_) {
            BufferReader = BufferReader_;
            Reader3.create = create();
            BufferReader._configure();
            var fn = util.Long ? "toLong" : "toNumber";
            util.merge(Reader3.prototype, {
              int64: function read_int64() {
                return readLongVarint.call(this)[fn](false);
              },
              uint64: function read_uint64() {
                return readLongVarint.call(this)[fn](true);
              },
              sint64: function read_sint64() {
                return readLongVarint.call(this).zzDecode()[fn](false);
              },
              fixed64: function read_fixed64() {
                return readFixed64.call(this)[fn](true);
              },
              sfixed64: function read_sfixed64() {
                return readFixed64.call(this)[fn](false);
              }
            });
          };
        }, { "15": 15 }], 10: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = BufferReader;
          var Reader3 = require2(9);
          (BufferReader.prototype = Object.create(Reader3.prototype)).constructor = BufferReader;
          var util = require2(15);
          function BufferReader(buffer) {
            Reader3.call(this, buffer);
          }
          BufferReader._configure = function() {
            if (util.Buffer)
              BufferReader.prototype._slice = util.Buffer.prototype.slice;
          };
          BufferReader.prototype.string = function read_string_buffer() {
            var len = this.uint32();
            return this.buf.utf8Slice ? this.buf.utf8Slice(this.pos, this.pos = Math.min(this.pos + len, this.len)) : this.buf.toString("utf-8", this.pos, this.pos = Math.min(this.pos + len, this.len));
          };
          BufferReader._configure();
        }, { "15": 15, "9": 9 }], 11: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = {};
        }, {}], 12: [function(require2, module2, exports2) {
          "use strict";
          var rpc = exports2;
          rpc.Service = require2(13);
        }, { "13": 13 }], 13: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = Service;
          var util = require2(15);
          (Service.prototype = Object.create(util.EventEmitter.prototype)).constructor = Service;
          function Service(rpcImpl, requestDelimited, responseDelimited) {
            if (typeof rpcImpl !== "function")
              throw TypeError("rpcImpl must be a function");
            util.EventEmitter.call(this);
            this.rpcImpl = rpcImpl;
            this.requestDelimited = Boolean(requestDelimited);
            this.responseDelimited = Boolean(responseDelimited);
          }
          Service.prototype.rpcCall = function rpcCall(method, requestCtor, responseCtor, request, callback) {
            if (!request)
              throw TypeError("request must be specified");
            var self2 = this;
            if (!callback)
              return util.asPromise(rpcCall, self2, method, requestCtor, responseCtor, request);
            if (!self2.rpcImpl) {
              setTimeout(function() {
                callback(Error("already ended"));
              }, 0);
              return undefined;
            }
            try {
              return self2.rpcImpl(
                method,
                requestCtor[self2.requestDelimited ? "encodeDelimited" : "encode"](request).finish(),
                function rpcCallback(err, response) {
                  if (err) {
                    self2.emit("error", err, method);
                    return callback(err);
                  }
                  if (response === null) {
                    self2.end(true);
                    return undefined;
                  }
                  if (!(response instanceof responseCtor)) {
                    try {
                      response = responseCtor[self2.responseDelimited ? "decodeDelimited" : "decode"](response);
                    } catch (err2) {
                      self2.emit("error", err2, method);
                      return callback(err2);
                    }
                  }
                  self2.emit("data", response, method);
                  return callback(null, response);
                }
              );
            } catch (err) {
              self2.emit("error", err, method);
              setTimeout(function() {
                callback(err);
              }, 0);
              return undefined;
            }
          };
          Service.prototype.end = function end(endedByRPC) {
            if (this.rpcImpl) {
              if (!endedByRPC)
                this.rpcImpl(null, null, null);
              this.rpcImpl = null;
              this.emit("end").off();
            }
            return this;
          };
        }, { "15": 15 }], 14: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = LongBits;
          var util = require2(15);
          function LongBits(lo, hi) {
            this.lo = lo >>> 0;
            this.hi = hi >>> 0;
          }
          var zero = LongBits.zero = new LongBits(0, 0);
          zero.toNumber = function() {
            return 0;
          };
          zero.zzEncode = zero.zzDecode = function() {
            return this;
          };
          zero.length = function() {
            return 1;
          };
          var zeroHash = LongBits.zeroHash = "\0\0\0\0\0\0\0\0";
          LongBits.fromNumber = function fromNumber(value) {
            if (value === 0)
              return zero;
            var sign2 = value < 0;
            if (sign2)
              value = -value;
            var lo = value >>> 0, hi = (value - lo) / 4294967296 >>> 0;
            if (sign2) {
              hi = ~hi >>> 0;
              lo = ~lo >>> 0;
              if (++lo > 4294967295) {
                lo = 0;
                if (++hi > 4294967295)
                  hi = 0;
              }
            }
            return new LongBits(lo, hi);
          };
          LongBits.from = function from(value) {
            if (typeof value === "number")
              return LongBits.fromNumber(value);
            if (util.isString(value)) {
              if (util.Long)
                value = util.Long.fromString(value);
              else
                return LongBits.fromNumber(parseInt(value, 10));
            }
            return value.low || value.high ? new LongBits(value.low >>> 0, value.high >>> 0) : zero;
          };
          LongBits.prototype.toNumber = function toNumber(unsigned) {
            if (!unsigned && this.hi >>> 31) {
              var lo = ~this.lo + 1 >>> 0, hi = ~this.hi >>> 0;
              if (!lo)
                hi = hi + 1 >>> 0;
              return -(lo + hi * 4294967296);
            }
            return this.lo + this.hi * 4294967296;
          };
          LongBits.prototype.toLong = function toLong(unsigned) {
            return util.Long ? new util.Long(this.lo | 0, this.hi | 0, Boolean(unsigned)) : { low: this.lo | 0, high: this.hi | 0, unsigned: Boolean(unsigned) };
          };
          var charCodeAt = String.prototype.charCodeAt;
          LongBits.fromHash = function fromHash(hash2) {
            if (hash2 === zeroHash)
              return zero;
            return new LongBits(
              (charCodeAt.call(hash2, 0) | charCodeAt.call(hash2, 1) << 8 | charCodeAt.call(hash2, 2) << 16 | charCodeAt.call(hash2, 3) << 24) >>> 0,
              (charCodeAt.call(hash2, 4) | charCodeAt.call(hash2, 5) << 8 | charCodeAt.call(hash2, 6) << 16 | charCodeAt.call(hash2, 7) << 24) >>> 0
            );
          };
          LongBits.prototype.toHash = function toHash() {
            return String.fromCharCode(
              this.lo & 255,
              this.lo >>> 8 & 255,
              this.lo >>> 16 & 255,
              this.lo >>> 24,
              this.hi & 255,
              this.hi >>> 8 & 255,
              this.hi >>> 16 & 255,
              this.hi >>> 24
            );
          };
          LongBits.prototype.zzEncode = function zzEncode() {
            var mask = this.hi >> 31;
            this.hi = ((this.hi << 1 | this.lo >>> 31) ^ mask) >>> 0;
            this.lo = (this.lo << 1 ^ mask) >>> 0;
            return this;
          };
          LongBits.prototype.zzDecode = function zzDecode() {
            var mask = -(this.lo & 1);
            this.lo = ((this.lo >>> 1 | this.hi << 31) ^ mask) >>> 0;
            this.hi = (this.hi >>> 1 ^ mask) >>> 0;
            return this;
          };
          LongBits.prototype.length = function length3() {
            var part0 = this.lo, part1 = (this.lo >>> 28 | this.hi << 4) >>> 0, part2 = this.hi >>> 24;
            return part2 === 0 ? part1 === 0 ? part0 < 16384 ? part0 < 128 ? 1 : 2 : part0 < 2097152 ? 3 : 4 : part1 < 16384 ? part1 < 128 ? 5 : 6 : part1 < 2097152 ? 7 : 8 : part2 < 128 ? 9 : 10;
          };
        }, { "15": 15 }], 15: [function(require2, module2, exports2) {
          "use strict";
          var util = exports2;
          util.asPromise = require2(1);
          util.base64 = require2(2);
          util.EventEmitter = require2(3);
          util.float = require2(4);
          util.inquire = require2(5);
          util.utf8 = require2(7);
          util.pool = require2(6);
          util.LongBits = require2(14);
          util.isNode = Boolean(typeof global !== "undefined" && global && global.process && global.process.versions && global.process.versions.node);
          util.global = util.isNode && global || typeof window !== "undefined" && window || typeof self !== "undefined" && self || this;
          util.emptyArray = Object.freeze ? Object.freeze([]) : [];
          util.emptyObject = Object.freeze ? Object.freeze({}) : {};
          util.isInteger = Number.isInteger || function isInteger(value) {
            return typeof value === "number" && isFinite(value) && Math.floor(value) === value;
          };
          util.isString = function isString(value) {
            return typeof value === "string" || value instanceof String;
          };
          util.isObject = function isObject(value) {
            return value && typeof value === "object";
          };
          util.isset = util.isSet = function isSet(obj, prop) {
            var value = obj[prop];
            if (value != null && obj.hasOwnProperty(prop))
              return typeof value !== "object" || (Array.isArray(value) ? value.length : Object.keys(value).length) > 0;
            return false;
          };
          util.Buffer = function() {
            try {
              var Buffer3 = util.inquire("buffer").Buffer;
              return Buffer3.prototype.utf8Write ? Buffer3 : null;
            } catch (e) {
              return null;
            }
          }();
          util._Buffer_from = null;
          util._Buffer_allocUnsafe = null;
          util.newBuffer = function newBuffer(sizeOrArray) {
            return typeof sizeOrArray === "number" ? util.Buffer ? util._Buffer_allocUnsafe(sizeOrArray) : new util.Array(sizeOrArray) : util.Buffer ? util._Buffer_from(sizeOrArray) : typeof Uint8Array === "undefined" ? sizeOrArray : new Uint8Array(sizeOrArray);
          };
          util.Array = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
          util.Long = util.global.dcodeIO && util.global.dcodeIO.Long || util.global.Long || util.inquire("long");
          util.key2Re = /^true|false|0|1$/;
          util.key32Re = /^-?(?:0|[1-9][0-9]*)$/;
          util.key64Re = /^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;
          util.longToHash = function longToHash(value) {
            return value ? util.LongBits.from(value).toHash() : util.LongBits.zeroHash;
          };
          util.longFromHash = function longFromHash(hash2, unsigned) {
            var bits = util.LongBits.fromHash(hash2);
            if (util.Long)
              return util.Long.fromBits(bits.lo, bits.hi, unsigned);
            return bits.toNumber(Boolean(unsigned));
          };
          function merge2(dst, src, ifNotSet) {
            for (var keys = Object.keys(src), i = 0; i < keys.length; ++i)
              if (dst[keys[i]] === undefined || !ifNotSet)
                dst[keys[i]] = src[keys[i]];
            return dst;
          }
          util.merge = merge2;
          util.lcFirst = function lcFirst(str) {
            return str.charAt(0).toLowerCase() + str.substring(1);
          };
          function newError(name) {
            function CustomError(message, properties) {
              if (!(this instanceof CustomError))
                return new CustomError(message, properties);
              Object.defineProperty(this, "message", { get: function() {
                return message;
              } });
              if (Error.captureStackTrace)
                Error.captureStackTrace(this, CustomError);
              else
                Object.defineProperty(this, "stack", { value: new Error().stack || "" });
              if (properties)
                merge2(this, properties);
            }
            CustomError.prototype = Object.create(Error.prototype, {
              constructor: {
                value: CustomError,
                writable: true,
                enumerable: false,
                configurable: true
              },
              name: {
                get: function get2() {
                  return name;
                },
                set: undefined,
                enumerable: false,
                configurable: true
              },
              toString: {
                value: function value() {
                  return this.name + ": " + this.message;
                },
                writable: true,
                enumerable: false,
                configurable: true
              }
            });
            return CustomError;
          }
          util.newError = newError;
          util.ProtocolError = newError("ProtocolError");
          util.oneOfGetter = function getOneOf(fieldNames) {
            var fieldMap = {};
            for (var i = 0; i < fieldNames.length; ++i)
              fieldMap[fieldNames[i]] = 1;
            return function() {
              for (var keys = Object.keys(this), i2 = keys.length - 1; i2 > -1; --i2)
                if (fieldMap[keys[i2]] === 1 && this[keys[i2]] !== undefined && this[keys[i2]] !== null)
                  return keys[i2];
            };
          };
          util.oneOfSetter = function setOneOf(fieldNames) {
            return function(name) {
              for (var i = 0; i < fieldNames.length; ++i)
                if (fieldNames[i] !== name)
                  delete this[fieldNames[i]];
            };
          };
          util.toJSONOptions = {
            longs: String,
            enums: String,
            bytes: String,
            json: true
          };
          util._configure = function() {
            var Buffer3 = util.Buffer;
            if (!Buffer3) {
              util._Buffer_from = util._Buffer_allocUnsafe = null;
              return;
            }
            util._Buffer_from = Buffer3.from !== Uint8Array.from && Buffer3.from || function Buffer_from(value, encoding) {
              return new Buffer3(value, encoding);
            };
            util._Buffer_allocUnsafe = Buffer3.allocUnsafe || function Buffer_allocUnsafe(size) {
              return new Buffer3(size);
            };
          };
        }, { "1": 1, "14": 14, "2": 2, "3": 3, "4": 4, "5": 5, "6": 6, "7": 7 }], 16: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = Writer2;
          var util = require2(15);
          var BufferWriter;
          var LongBits = util.LongBits, base64 = util.base64, utf8 = util.utf8;
          function Op(fn, len, val) {
            this.fn = fn;
            this.len = len;
            this.next = undefined;
            this.val = val;
          }
          function noop() {
          }
          function State(writer) {
            this.head = writer.head;
            this.tail = writer.tail;
            this.len = writer.len;
            this.next = writer.states;
          }
          function Writer2() {
            this.len = 0;
            this.head = new Op(noop, 0, 0);
            this.tail = this.head;
            this.states = null;
          }
          var create = function create2() {
            return util.Buffer ? function create_buffer_setup() {
              return (Writer2.create = function create_buffer() {
                return new BufferWriter();
              })();
            } : function create_array() {
              return new Writer2();
            };
          };
          Writer2.create = create();
          Writer2.alloc = function alloc(size) {
            return new util.Array(size);
          };
          if (util.Array !== Array)
            Writer2.alloc = util.pool(Writer2.alloc, util.Array.prototype.subarray);
          Writer2.prototype._push = function push(fn, len, val) {
            this.tail = this.tail.next = new Op(fn, len, val);
            this.len += len;
            return this;
          };
          function writeByte(val, buf, pos) {
            buf[pos] = val & 255;
          }
          function writeVarint32(val, buf, pos) {
            while (val > 127) {
              buf[pos++] = val & 127 | 128;
              val >>>= 7;
            }
            buf[pos] = val;
          }
          function VarintOp(len, val) {
            this.len = len;
            this.next = undefined;
            this.val = val;
          }
          VarintOp.prototype = Object.create(Op.prototype);
          VarintOp.prototype.fn = writeVarint32;
          Writer2.prototype.uint32 = function write_uint32(value) {
            this.len += (this.tail = this.tail.next = new VarintOp(
              (value = value >>> 0) < 128 ? 1 : value < 16384 ? 2 : value < 2097152 ? 3 : value < 268435456 ? 4 : 5,
              value
            )).len;
            return this;
          };
          Writer2.prototype.int32 = function write_int32(value) {
            return value < 0 ? this._push(writeVarint64, 10, LongBits.fromNumber(value)) : this.uint32(value);
          };
          Writer2.prototype.sint32 = function write_sint32(value) {
            return this.uint32((value << 1 ^ value >> 31) >>> 0);
          };
          function writeVarint64(val, buf, pos) {
            while (val.hi) {
              buf[pos++] = val.lo & 127 | 128;
              val.lo = (val.lo >>> 7 | val.hi << 25) >>> 0;
              val.hi >>>= 7;
            }
            while (val.lo > 127) {
              buf[pos++] = val.lo & 127 | 128;
              val.lo = val.lo >>> 7;
            }
            buf[pos++] = val.lo;
          }
          Writer2.prototype.uint64 = function write_uint64(value) {
            var bits = LongBits.from(value);
            return this._push(writeVarint64, bits.length(), bits);
          };
          Writer2.prototype.int64 = Writer2.prototype.uint64;
          Writer2.prototype.sint64 = function write_sint64(value) {
            var bits = LongBits.from(value).zzEncode();
            return this._push(writeVarint64, bits.length(), bits);
          };
          Writer2.prototype.bool = function write_bool(value) {
            return this._push(writeByte, 1, value ? 1 : 0);
          };
          function writeFixed32(val, buf, pos) {
            buf[pos] = val & 255;
            buf[pos + 1] = val >>> 8 & 255;
            buf[pos + 2] = val >>> 16 & 255;
            buf[pos + 3] = val >>> 24;
          }
          Writer2.prototype.fixed32 = function write_fixed32(value) {
            return this._push(writeFixed32, 4, value >>> 0);
          };
          Writer2.prototype.sfixed32 = Writer2.prototype.fixed32;
          Writer2.prototype.fixed64 = function write_fixed64(value) {
            var bits = LongBits.from(value);
            return this._push(writeFixed32, 4, bits.lo)._push(writeFixed32, 4, bits.hi);
          };
          Writer2.prototype.sfixed64 = Writer2.prototype.fixed64;
          Writer2.prototype.float = function write_float(value) {
            return this._push(util.float.writeFloatLE, 4, value);
          };
          Writer2.prototype.double = function write_double(value) {
            return this._push(util.float.writeDoubleLE, 8, value);
          };
          var writeBytes = util.Array.prototype.set ? function writeBytes_set(val, buf, pos) {
            buf.set(val, pos);
          } : function writeBytes_for(val, buf, pos) {
            for (var i = 0; i < val.length; ++i)
              buf[pos + i] = val[i];
          };
          Writer2.prototype.bytes = function write_bytes(value) {
            var len = value.length >>> 0;
            if (!len)
              return this._push(writeByte, 1, 0);
            if (util.isString(value)) {
              var buf = Writer2.alloc(len = base64.length(value));
              base64.decode(value, buf, 0);
              value = buf;
            }
            return this.uint32(len)._push(writeBytes, len, value);
          };
          Writer2.prototype.string = function write_string(value) {
            var len = utf8.length(value);
            return len ? this.uint32(len)._push(utf8.write, len, value) : this._push(writeByte, 1, 0);
          };
          Writer2.prototype.fork = function fork() {
            this.states = new State(this);
            this.head = this.tail = new Op(noop, 0, 0);
            this.len = 0;
            return this;
          };
          Writer2.prototype.reset = function reset() {
            if (this.states) {
              this.head = this.states.head;
              this.tail = this.states.tail;
              this.len = this.states.len;
              this.states = this.states.next;
            } else {
              this.head = this.tail = new Op(noop, 0, 0);
              this.len = 0;
            }
            return this;
          };
          Writer2.prototype.ldelim = function ldelim() {
            var head = this.head, tail = this.tail, len = this.len;
            this.reset().uint32(len);
            if (len) {
              this.tail.next = head.next;
              this.tail = tail;
              this.len += len;
            }
            return this;
          };
          Writer2.prototype.finish = function finish() {
            var head = this.head.next, buf = this.constructor.alloc(this.len), pos = 0;
            while (head) {
              head.fn(head.val, buf, pos);
              pos += head.len;
              head = head.next;
            }
            return buf;
          };
          Writer2._configure = function(BufferWriter_) {
            BufferWriter = BufferWriter_;
            Writer2.create = create();
            BufferWriter._configure();
          };
        }, { "15": 15 }], 17: [function(require2, module2, exports2) {
          "use strict";
          module2.exports = BufferWriter;
          var Writer2 = require2(16);
          (BufferWriter.prototype = Object.create(Writer2.prototype)).constructor = BufferWriter;
          var util = require2(15);
          function BufferWriter() {
            Writer2.call(this);
          }
          BufferWriter._configure = function() {
            BufferWriter.alloc = util._Buffer_allocUnsafe;
            BufferWriter.writeBytesBuffer = util.Buffer && util.Buffer.prototype instanceof Uint8Array && util.Buffer.prototype.set.name === "set" ? function writeBytesBuffer_set(val, buf, pos) {
              buf.set(val, pos);
            } : function writeBytesBuffer_copy(val, buf, pos) {
              if (val.copy)
                val.copy(buf, pos, 0, val.length);
              else
                for (var i = 0; i < val.length; )
                  buf[pos++] = val[i++];
            };
          };
          BufferWriter.prototype.bytes = function write_bytes_buffer(value) {
            if (util.isString(value))
              value = util._Buffer_from(value, "base64");
            var len = value.length >>> 0;
            this.uint32(len);
            if (len)
              this._push(BufferWriter.writeBytesBuffer, len, value);
            return this;
          };
          function writeStringBuffer(val, buf, pos) {
            if (val.length < 40)
              util.utf8.write(val, buf, pos);
            else if (buf.utf8Write)
              buf.utf8Write(val, pos);
            else
              buf.write(val, pos);
          }
          BufferWriter.prototype.string = function write_string_buffer(value) {
            var len = util.Buffer.byteLength(value);
            this.uint32(len);
            if (len)
              this._push(writeStringBuffer, len, value);
            return this;
          };
          BufferWriter._configure();
        }, { "15": 15, "16": 16 }] }, {}, [8]);
      })();
    }
  });

  // node_modules/lerc/LercDecode.js
  var require_LercDecode = __commonJS({
    "node_modules/lerc/LercDecode.js"(exports2, module2) {
      /* Copyright 2015-2018 Esri. Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 @preserve */
      (function() {
        var LercDecode = function() {
          var CntZImage = {};
          CntZImage.defaultNoDataValue = -34027999387901484e22;
          CntZImage.decode = function(input, options) {
            options = options || {};
            var skipMask = options.encodedMaskData || options.encodedMaskData === null;
            var parsedData = parse3(input, options.inputOffset || 0, skipMask);
            var noDataValue = options.noDataValue !== null ? options.noDataValue : CntZImage.defaultNoDataValue;
            var uncompressedData = uncompressPixelValues(
              parsedData,
              options.pixelType || Float32Array,
              options.encodedMaskData,
              noDataValue,
              options.returnMask
            );
            var result = {
              width: parsedData.width,
              height: parsedData.height,
              pixelData: uncompressedData.resultPixels,
              minValue: uncompressedData.minValue,
              maxValue: parsedData.pixels.maxValue,
              noDataValue
            };
            if (uncompressedData.resultMask) {
              result.maskData = uncompressedData.resultMask;
            }
            if (options.returnEncodedMask && parsedData.mask) {
              result.encodedMaskData = parsedData.mask.bitset ? parsedData.mask.bitset : null;
            }
            if (options.returnFileInfo) {
              result.fileInfo = formatFileInfo(parsedData);
              if (options.computeUsedBitDepths) {
                result.fileInfo.bitDepths = computeUsedBitDepths(parsedData);
              }
            }
            return result;
          };
          var uncompressPixelValues = function(data, TypedArrayClass, maskBitset, noDataValue, storeDecodedMask) {
            var blockIdx = 0;
            var numX = data.pixels.numBlocksX;
            var numY = data.pixels.numBlocksY;
            var blockWidth = Math.floor(data.width / numX);
            var blockHeight = Math.floor(data.height / numY);
            var scale = 2 * data.maxZError;
            var minValue = Number.MAX_VALUE, currentValue;
            maskBitset = maskBitset || (data.mask ? data.mask.bitset : null);
            var resultPixels, resultMask;
            resultPixels = new TypedArrayClass(data.width * data.height);
            if (storeDecodedMask && maskBitset) {
              resultMask = new Uint8Array(data.width * data.height);
            }
            var blockDataBuffer = new Float32Array(blockWidth * blockHeight);
            var xx, yy;
            for (var y = 0; y <= numY; y++) {
              var thisBlockHeight = y !== numY ? blockHeight : data.height % numY;
              if (thisBlockHeight === 0) {
                continue;
              }
              for (var x = 0; x <= numX; x++) {
                var thisBlockWidth = x !== numX ? blockWidth : data.width % numX;
                if (thisBlockWidth === 0) {
                  continue;
                }
                var outPtr = y * data.width * blockHeight + x * blockWidth;
                var outStride = data.width - thisBlockWidth;
                var block = data.pixels.blocks[blockIdx];
                var blockData, blockPtr, constValue;
                if (block.encoding < 2) {
                  if (block.encoding === 0) {
                    blockData = block.rawData;
                  } else {
                    unstuff(block.stuffedData, block.bitsPerPixel, block.numValidPixels, block.offset, scale, blockDataBuffer, data.pixels.maxValue);
                    blockData = blockDataBuffer;
                  }
                  blockPtr = 0;
                } else if (block.encoding === 2) {
                  constValue = 0;
                } else {
                  constValue = block.offset;
                }
                var maskByte;
                if (maskBitset) {
                  for (yy = 0; yy < thisBlockHeight; yy++) {
                    if (outPtr & 7) {
                      maskByte = maskBitset[outPtr >> 3];
                      maskByte <<= outPtr & 7;
                    }
                    for (xx = 0; xx < thisBlockWidth; xx++) {
                      if (!(outPtr & 7)) {
                        maskByte = maskBitset[outPtr >> 3];
                      }
                      if (maskByte & 128) {
                        if (resultMask) {
                          resultMask[outPtr] = 1;
                        }
                        currentValue = block.encoding < 2 ? blockData[blockPtr++] : constValue;
                        minValue = minValue > currentValue ? currentValue : minValue;
                        resultPixels[outPtr++] = currentValue;
                      } else {
                        if (resultMask) {
                          resultMask[outPtr] = 0;
                        }
                        resultPixels[outPtr++] = noDataValue;
                      }
                      maskByte <<= 1;
                    }
                    outPtr += outStride;
                  }
                } else {
                  if (block.encoding < 2) {
                    for (yy = 0; yy < thisBlockHeight; yy++) {
                      for (xx = 0; xx < thisBlockWidth; xx++) {
                        currentValue = blockData[blockPtr++];
                        minValue = minValue > currentValue ? currentValue : minValue;
                        resultPixels[outPtr++] = currentValue;
                      }
                      outPtr += outStride;
                    }
                  } else {
                    minValue = minValue > constValue ? constValue : minValue;
                    for (yy = 0; yy < thisBlockHeight; yy++) {
                      for (xx = 0; xx < thisBlockWidth; xx++) {
                        resultPixels[outPtr++] = constValue;
                      }
                      outPtr += outStride;
                    }
                  }
                }
                if (block.encoding === 1 && blockPtr !== block.numValidPixels) {
                  throw "Block and Mask do not match";
                }
                blockIdx++;
              }
            }
            return {
              resultPixels,
              resultMask,
              minValue
            };
          };
          var formatFileInfo = function(data) {
            return {
              "fileIdentifierString": data.fileIdentifierString,
              "fileVersion": data.fileVersion,
              "imageType": data.imageType,
              "height": data.height,
              "width": data.width,
              "maxZError": data.maxZError,
              "eofOffset": data.eofOffset,
              "mask": data.mask ? {
                "numBlocksX": data.mask.numBlocksX,
                "numBlocksY": data.mask.numBlocksY,
                "numBytes": data.mask.numBytes,
                "maxValue": data.mask.maxValue
              } : null,
              "pixels": {
                "numBlocksX": data.pixels.numBlocksX,
                "numBlocksY": data.pixels.numBlocksY,
                "numBytes": data.pixels.numBytes,
                "maxValue": data.pixels.maxValue,
                "noDataValue": data.noDataValue
              }
            };
          };
          var computeUsedBitDepths = function(data) {
            var numBlocks = data.pixels.numBlocksX * data.pixels.numBlocksY;
            var bitDepths = {};
            for (var i = 0; i < numBlocks; i++) {
              var block = data.pixels.blocks[i];
              if (block.encoding === 0) {
                bitDepths.float32 = true;
              } else if (block.encoding === 1) {
                bitDepths[block.bitsPerPixel] = true;
              } else {
                bitDepths[0] = true;
              }
            }
            return Object.keys(bitDepths);
          };
          var parse3 = function(input, fp, skipMask) {
            var data = {};
            var fileIdView = new Uint8Array(input, fp, 10);
            data.fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
            if (data.fileIdentifierString.trim() !== "CntZImage") {
              throw "Unexpected file identifier string: " + data.fileIdentifierString;
            }
            fp += 10;
            var view = new DataView(input, fp, 24);
            data.fileVersion = view.getInt32(0, true);
            data.imageType = view.getInt32(4, true);
            data.height = view.getUint32(8, true);
            data.width = view.getUint32(12, true);
            data.maxZError = view.getFloat64(16, true);
            fp += 24;
            if (!skipMask) {
              view = new DataView(input, fp, 16);
              data.mask = {};
              data.mask.numBlocksY = view.getUint32(0, true);
              data.mask.numBlocksX = view.getUint32(4, true);
              data.mask.numBytes = view.getUint32(8, true);
              data.mask.maxValue = view.getFloat32(12, true);
              fp += 16;
              if (data.mask.numBytes > 0) {
                var bitset = new Uint8Array(Math.ceil(data.width * data.height / 8));
                view = new DataView(input, fp, data.mask.numBytes);
                var cnt = view.getInt16(0, true);
                var ip = 2, op = 0;
                do {
                  if (cnt > 0) {
                    while (cnt--) {
                      bitset[op++] = view.getUint8(ip++);
                    }
                  } else {
                    var val = view.getUint8(ip++);
                    cnt = -cnt;
                    while (cnt--) {
                      bitset[op++] = val;
                    }
                  }
                  cnt = view.getInt16(ip, true);
                  ip += 2;
                } while (ip < data.mask.numBytes);
                if (cnt !== -32768 || op < bitset.length) {
                  throw "Unexpected end of mask RLE encoding";
                }
                data.mask.bitset = bitset;
                fp += data.mask.numBytes;
              } else if ((data.mask.numBytes | data.mask.numBlocksY | data.mask.maxValue) === 0) {
                data.mask.bitset = new Uint8Array(Math.ceil(data.width * data.height / 8));
              }
            }
            view = new DataView(input, fp, 16);
            data.pixels = {};
            data.pixels.numBlocksY = view.getUint32(0, true);
            data.pixels.numBlocksX = view.getUint32(4, true);
            data.pixels.numBytes = view.getUint32(8, true);
            data.pixels.maxValue = view.getFloat32(12, true);
            fp += 16;
            var numBlocksX = data.pixels.numBlocksX;
            var numBlocksY = data.pixels.numBlocksY;
            var actualNumBlocksX = numBlocksX + (data.width % numBlocksX > 0 ? 1 : 0);
            var actualNumBlocksY = numBlocksY + (data.height % numBlocksY > 0 ? 1 : 0);
            data.pixels.blocks = new Array(actualNumBlocksX * actualNumBlocksY);
            var blockI = 0;
            for (var blockY = 0; blockY < actualNumBlocksY; blockY++) {
              for (var blockX = 0; blockX < actualNumBlocksX; blockX++) {
                var size = 0;
                var bytesLeft = input.byteLength - fp;
                view = new DataView(input, fp, Math.min(10, bytesLeft));
                var block = {};
                data.pixels.blocks[blockI++] = block;
                var headerByte = view.getUint8(0);
                size++;
                block.encoding = headerByte & 63;
                if (block.encoding > 3) {
                  throw "Invalid block encoding (" + block.encoding + ")";
                }
                if (block.encoding === 2) {
                  fp++;
                  continue;
                }
                if (headerByte !== 0 && headerByte !== 2) {
                  headerByte >>= 6;
                  block.offsetType = headerByte;
                  if (headerByte === 2) {
                    block.offset = view.getInt8(1);
                    size++;
                  } else if (headerByte === 1) {
                    block.offset = view.getInt16(1, true);
                    size += 2;
                  } else if (headerByte === 0) {
                    block.offset = view.getFloat32(1, true);
                    size += 4;
                  } else {
                    throw "Invalid block offset type";
                  }
                  if (block.encoding === 1) {
                    headerByte = view.getUint8(size);
                    size++;
                    block.bitsPerPixel = headerByte & 63;
                    headerByte >>= 6;
                    block.numValidPixelsType = headerByte;
                    if (headerByte === 2) {
                      block.numValidPixels = view.getUint8(size);
                      size++;
                    } else if (headerByte === 1) {
                      block.numValidPixels = view.getUint16(size, true);
                      size += 2;
                    } else if (headerByte === 0) {
                      block.numValidPixels = view.getUint32(size, true);
                      size += 4;
                    } else {
                      throw "Invalid valid pixel count type";
                    }
                  }
                }
                fp += size;
                if (block.encoding === 3) {
                  continue;
                }
                var arrayBuf, store8;
                if (block.encoding === 0) {
                  var numPixels = (data.pixels.numBytes - 1) / 4;
                  if (numPixels !== Math.floor(numPixels)) {
                    throw "uncompressed block has invalid length";
                  }
                  arrayBuf = new ArrayBuffer(numPixels * 4);
                  store8 = new Uint8Array(arrayBuf);
                  store8.set(new Uint8Array(input, fp, numPixels * 4));
                  var rawData = new Float32Array(arrayBuf);
                  block.rawData = rawData;
                  fp += numPixels * 4;
                } else if (block.encoding === 1) {
                  var dataBytes = Math.ceil(block.numValidPixels * block.bitsPerPixel / 8);
                  var dataWords = Math.ceil(dataBytes / 4);
                  arrayBuf = new ArrayBuffer(dataWords * 4);
                  store8 = new Uint8Array(arrayBuf);
                  store8.set(new Uint8Array(input, fp, dataBytes));
                  block.stuffedData = new Uint32Array(arrayBuf);
                  fp += dataBytes;
                }
              }
            }
            data.eofOffset = fp;
            return data;
          };
          var unstuff = function(src, bitsPerPixel, numPixels, offset2, scale, dest, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0;
            var n, buffer;
            var nmax = Math.ceil((maxValue - offset2) / scale);
            var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
            src[src.length - 1] <<= 8 * numInvalidTailBytes;
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer = src[i++];
                bitsLeft = 32;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                bitsLeft -= bitsPerPixel;
              } else {
                var missingBits = bitsPerPixel - bitsLeft;
                n = (buffer & bitMask) << missingBits & bitMask;
                buffer = src[i++];
                bitsLeft = 32 - missingBits;
                n += buffer >>> bitsLeft;
              }
              dest[o] = n < nmax ? offset2 + n * scale : maxValue;
            }
            return dest;
          };
          return CntZImage;
        }();
        var Lerc2Decode = function() {
          "use strict";
          var BitStuffer = {
            unstuff: function(src, dest, bitsPerPixel, numPixels, lutArr, offset2, scale, maxValue) {
              var bitMask = (1 << bitsPerPixel) - 1;
              var i = 0, o;
              var bitsLeft = 0;
              var n, buffer, missingBits, nmax;
              var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
              src[src.length - 1] <<= 8 * numInvalidTailBytes;
              if (lutArr) {
                for (o = 0; o < numPixels; o++) {
                  if (bitsLeft === 0) {
                    buffer = src[i++];
                    bitsLeft = 32;
                  }
                  if (bitsLeft >= bitsPerPixel) {
                    n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                    bitsLeft -= bitsPerPixel;
                  } else {
                    missingBits = bitsPerPixel - bitsLeft;
                    n = (buffer & bitMask) << missingBits & bitMask;
                    buffer = src[i++];
                    bitsLeft = 32 - missingBits;
                    n += buffer >>> bitsLeft;
                  }
                  dest[o] = lutArr[n];
                }
              } else {
                nmax = Math.ceil((maxValue - offset2) / scale);
                for (o = 0; o < numPixels; o++) {
                  if (bitsLeft === 0) {
                    buffer = src[i++];
                    bitsLeft = 32;
                  }
                  if (bitsLeft >= bitsPerPixel) {
                    n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                    bitsLeft -= bitsPerPixel;
                  } else {
                    missingBits = bitsPerPixel - bitsLeft;
                    n = (buffer & bitMask) << missingBits & bitMask;
                    buffer = src[i++];
                    bitsLeft = 32 - missingBits;
                    n += buffer >>> bitsLeft;
                  }
                  dest[o] = n < nmax ? offset2 + n * scale : maxValue;
                }
              }
            },
            unstuffLUT: function(src, bitsPerPixel, numPixels, offset2, scale, maxValue) {
              var bitMask = (1 << bitsPerPixel) - 1;
              var i = 0, o = 0, missingBits = 0, bitsLeft = 0, n = 0;
              var buffer;
              var dest = [];
              var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
              src[src.length - 1] <<= 8 * numInvalidTailBytes;
              var nmax = Math.ceil((maxValue - offset2) / scale);
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer = src[i++];
                  bitsLeft = 32;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                  bitsLeft -= bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = (buffer & bitMask) << missingBits & bitMask;
                  buffer = src[i++];
                  bitsLeft = 32 - missingBits;
                  n += buffer >>> bitsLeft;
                }
                dest[o] = n < nmax ? offset2 + n * scale : maxValue;
              }
              dest.unshift(offset2);
              return dest;
            },
            unstuff2: function(src, dest, bitsPerPixel, numPixels, lutArr, offset2, scale, maxValue) {
              var bitMask = (1 << bitsPerPixel) - 1;
              var i = 0, o;
              var bitsLeft = 0, bitPos = 0;
              var n, buffer, missingBits;
              if (lutArr) {
                for (o = 0; o < numPixels; o++) {
                  if (bitsLeft === 0) {
                    buffer = src[i++];
                    bitsLeft = 32;
                    bitPos = 0;
                  }
                  if (bitsLeft >= bitsPerPixel) {
                    n = buffer >>> bitPos & bitMask;
                    bitsLeft -= bitsPerPixel;
                    bitPos += bitsPerPixel;
                  } else {
                    missingBits = bitsPerPixel - bitsLeft;
                    n = buffer >>> bitPos & bitMask;
                    buffer = src[i++];
                    bitsLeft = 32 - missingBits;
                    n |= (buffer & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                    bitPos = missingBits;
                  }
                  dest[o] = lutArr[n];
                }
              } else {
                var nmax = Math.ceil((maxValue - offset2) / scale);
                for (o = 0; o < numPixels; o++) {
                  if (bitsLeft === 0) {
                    buffer = src[i++];
                    bitsLeft = 32;
                    bitPos = 0;
                  }
                  if (bitsLeft >= bitsPerPixel) {
                    n = buffer >>> bitPos & bitMask;
                    bitsLeft -= bitsPerPixel;
                    bitPos += bitsPerPixel;
                  } else {
                    missingBits = bitsPerPixel - bitsLeft;
                    n = buffer >>> bitPos & bitMask;
                    buffer = src[i++];
                    bitsLeft = 32 - missingBits;
                    n |= (buffer & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                    bitPos = missingBits;
                  }
                  dest[o] = n < nmax ? offset2 + n * scale : maxValue;
                }
              }
              return dest;
            },
            unstuffLUT2: function(src, bitsPerPixel, numPixels, offset2, scale, maxValue) {
              var bitMask = (1 << bitsPerPixel) - 1;
              var i = 0, o = 0, missingBits = 0, bitsLeft = 0, n = 0, bitPos = 0;
              var buffer;
              var dest = [];
              var nmax = Math.ceil((maxValue - offset2) / scale);
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer = src[i++];
                  bitsLeft = 32;
                  bitPos = 0;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer >>> bitPos & bitMask;
                  bitsLeft -= bitsPerPixel;
                  bitPos += bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = buffer >>> bitPos & bitMask;
                  buffer = src[i++];
                  bitsLeft = 32 - missingBits;
                  n |= (buffer & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                  bitPos = missingBits;
                }
                dest[o] = n < nmax ? offset2 + n * scale : maxValue;
              }
              dest.unshift(offset2);
              return dest;
            },
            originalUnstuff: function(src, dest, bitsPerPixel, numPixels) {
              var bitMask = (1 << bitsPerPixel) - 1;
              var i = 0, o;
              var bitsLeft = 0;
              var n, buffer, missingBits;
              var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
              src[src.length - 1] <<= 8 * numInvalidTailBytes;
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer = src[i++];
                  bitsLeft = 32;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                  bitsLeft -= bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = (buffer & bitMask) << missingBits & bitMask;
                  buffer = src[i++];
                  bitsLeft = 32 - missingBits;
                  n += buffer >>> bitsLeft;
                }
                dest[o] = n;
              }
              return dest;
            },
            originalUnstuff2: function(src, dest, bitsPerPixel, numPixels) {
              var bitMask = (1 << bitsPerPixel) - 1;
              var i = 0, o;
              var bitsLeft = 0, bitPos = 0;
              var n, buffer, missingBits;
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer = src[i++];
                  bitsLeft = 32;
                  bitPos = 0;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer >>> bitPos & bitMask;
                  bitsLeft -= bitsPerPixel;
                  bitPos += bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = buffer >>> bitPos & bitMask;
                  buffer = src[i++];
                  bitsLeft = 32 - missingBits;
                  n |= (buffer & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                  bitPos = missingBits;
                }
                dest[o] = n;
              }
              return dest;
            }
          };
          var Lerc2Helpers = {
            HUFFMAN_LUT_BITS_MAX: 12,
            computeChecksumFletcher32: function(input) {
              var sum1 = 65535, sum2 = 65535;
              var len = input.length;
              var words = Math.floor(len / 2);
              var i = 0;
              while (words) {
                var tlen = words >= 359 ? 359 : words;
                words -= tlen;
                do {
                  sum1 += input[i++] << 8;
                  sum2 += sum1 += input[i++];
                } while (--tlen);
                sum1 = (sum1 & 65535) + (sum1 >>> 16);
                sum2 = (sum2 & 65535) + (sum2 >>> 16);
              }
              if (len & 1) {
                sum2 += sum1 += input[i] << 8;
              }
              sum1 = (sum1 & 65535) + (sum1 >>> 16);
              sum2 = (sum2 & 65535) + (sum2 >>> 16);
              return (sum2 << 16 | sum1) >>> 0;
            },
            readHeaderInfo: function(input, data) {
              var ptr = data.ptr;
              var fileIdView = new Uint8Array(input, ptr, 6);
              var headerInfo = {};
              headerInfo.fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
              if (headerInfo.fileIdentifierString.lastIndexOf("Lerc2", 0) !== 0) {
                throw "Unexpected file identifier string (expect Lerc2 ): " + headerInfo.fileIdentifierString;
              }
              ptr += 6;
              var view = new DataView(input, ptr, 8);
              var fileVersion = view.getInt32(0, true);
              headerInfo.fileVersion = fileVersion;
              ptr += 4;
              if (fileVersion >= 3) {
                headerInfo.checksum = view.getUint32(4, true);
                ptr += 4;
              }
              view = new DataView(input, ptr, 12);
              headerInfo.height = view.getUint32(0, true);
              headerInfo.width = view.getUint32(4, true);
              ptr += 8;
              if (fileVersion >= 4) {
                headerInfo.numDims = view.getUint32(8, true);
                ptr += 4;
              } else {
                headerInfo.numDims = 1;
              }
              view = new DataView(input, ptr, 40);
              headerInfo.numValidPixel = view.getUint32(0, true);
              headerInfo.microBlockSize = view.getInt32(4, true);
              headerInfo.blobSize = view.getInt32(8, true);
              headerInfo.imageType = view.getInt32(12, true);
              headerInfo.maxZError = view.getFloat64(16, true);
              headerInfo.zMin = view.getFloat64(24, true);
              headerInfo.zMax = view.getFloat64(32, true);
              ptr += 40;
              data.headerInfo = headerInfo;
              data.ptr = ptr;
              var checksum, keyLength;
              if (fileVersion >= 3) {
                keyLength = fileVersion >= 4 ? 52 : 48;
                checksum = this.computeChecksumFletcher32(new Uint8Array(input, ptr - keyLength, headerInfo.blobSize - 14));
                if (checksum !== headerInfo.checksum) {
                  throw "Checksum failed.";
                }
              }
              return true;
            },
            checkMinMaxRanges: function(input, data) {
              var headerInfo = data.headerInfo;
              var OutPixelTypeArray = this.getDataTypeArray(headerInfo.imageType);
              var rangeBytes = headerInfo.numDims * this.getDataTypeSize(headerInfo.imageType);
              var minValues = this.readSubArray(input, data.ptr, OutPixelTypeArray, rangeBytes);
              var maxValues = this.readSubArray(input, data.ptr + rangeBytes, OutPixelTypeArray, rangeBytes);
              data.ptr += 2 * rangeBytes;
              var i, equal = true;
              for (i = 0; i < headerInfo.numDims; i++) {
                if (minValues[i] !== maxValues[i]) {
                  equal = false;
                  break;
                }
              }
              headerInfo.minValues = minValues;
              headerInfo.maxValues = maxValues;
              return equal;
            },
            readSubArray: function(input, ptr, OutPixelTypeArray, numBytes) {
              var rawData;
              if (OutPixelTypeArray === Uint8Array) {
                rawData = new Uint8Array(input, ptr, numBytes);
              } else {
                var arrayBuf = new ArrayBuffer(numBytes);
                var store8 = new Uint8Array(arrayBuf);
                store8.set(new Uint8Array(input, ptr, numBytes));
                rawData = new OutPixelTypeArray(arrayBuf);
              }
              return rawData;
            },
            readMask: function(input, data) {
              var ptr = data.ptr;
              var headerInfo = data.headerInfo;
              var numPixels = headerInfo.width * headerInfo.height;
              var numValidPixel = headerInfo.numValidPixel;
              var view = new DataView(input, ptr, 4);
              var mask = {};
              mask.numBytes = view.getUint32(0, true);
              ptr += 4;
              if ((0 === numValidPixel || numPixels === numValidPixel) && 0 !== mask.numBytes) {
                throw "invalid mask";
              }
              var bitset, resultMask;
              if (numValidPixel === 0) {
                bitset = new Uint8Array(Math.ceil(numPixels / 8));
                mask.bitset = bitset;
                resultMask = new Uint8Array(numPixels);
                data.pixels.resultMask = resultMask;
                ptr += mask.numBytes;
              } else if (mask.numBytes > 0) {
                bitset = new Uint8Array(Math.ceil(numPixels / 8));
                view = new DataView(input, ptr, mask.numBytes);
                var cnt = view.getInt16(0, true);
                var ip = 2, op = 0, val = 0;
                do {
                  if (cnt > 0) {
                    while (cnt--) {
                      bitset[op++] = view.getUint8(ip++);
                    }
                  } else {
                    val = view.getUint8(ip++);
                    cnt = -cnt;
                    while (cnt--) {
                      bitset[op++] = val;
                    }
                  }
                  cnt = view.getInt16(ip, true);
                  ip += 2;
                } while (ip < mask.numBytes);
                if (cnt !== -32768 || op < bitset.length) {
                  throw "Unexpected end of mask RLE encoding";
                }
                resultMask = new Uint8Array(numPixels);
                var mb = 0, k = 0;
                for (k = 0; k < numPixels; k++) {
                  if (k & 7) {
                    mb = bitset[k >> 3];
                    mb <<= k & 7;
                  } else {
                    mb = bitset[k >> 3];
                  }
                  if (mb & 128) {
                    resultMask[k] = 1;
                  }
                }
                data.pixels.resultMask = resultMask;
                mask.bitset = bitset;
                ptr += mask.numBytes;
              }
              data.ptr = ptr;
              data.mask = mask;
              return true;
            },
            readDataOneSweep: function(input, data, OutPixelTypeArray) {
              var ptr = data.ptr;
              var headerInfo = data.headerInfo;
              var numDims = headerInfo.numDims;
              var numPixels = headerInfo.width * headerInfo.height;
              var imageType = headerInfo.imageType;
              var numBytes = headerInfo.numValidPixel * Lerc2Helpers.getDataTypeSize(imageType) * numDims;
              var rawData;
              var mask = data.pixels.resultMask;
              if (OutPixelTypeArray === Uint8Array) {
                rawData = new Uint8Array(input, ptr, numBytes);
              } else {
                var arrayBuf = new ArrayBuffer(numBytes);
                var store8 = new Uint8Array(arrayBuf);
                store8.set(new Uint8Array(input, ptr, numBytes));
                rawData = new OutPixelTypeArray(arrayBuf);
              }
              if (rawData.length === numPixels * numDims) {
                data.pixels.resultPixels = rawData;
              } else {
                data.pixels.resultPixels = new OutPixelTypeArray(numPixels * numDims);
                var z = 0, k = 0, i = 0, nStart = 0;
                if (numDims > 1) {
                  for (i = 0; i < numDims; i++) {
                    nStart = i * numPixels;
                    for (k = 0; k < numPixels; k++) {
                      if (mask[k]) {
                        data.pixels.resultPixels[nStart + k] = rawData[z++];
                      }
                    }
                  }
                } else {
                  for (k = 0; k < numPixels; k++) {
                    if (mask[k]) {
                      data.pixels.resultPixels[k] = rawData[z++];
                    }
                  }
                }
              }
              ptr += numBytes;
              data.ptr = ptr;
              return true;
            },
            readHuffmanTree: function(input, data) {
              var BITS_MAX = this.HUFFMAN_LUT_BITS_MAX;
              var view = new DataView(input, data.ptr, 16);
              data.ptr += 16;
              var version2 = view.getInt32(0, true);
              if (version2 < 2) {
                throw "unsupported Huffman version";
              }
              var size = view.getInt32(4, true);
              var i0 = view.getInt32(8, true);
              var i1 = view.getInt32(12, true);
              if (i0 >= i1) {
                return false;
              }
              var blockDataBuffer = new Uint32Array(i1 - i0);
              Lerc2Helpers.decodeBits(input, data, blockDataBuffer);
              var codeTable = [];
              var i, j, k, len;
              for (i = i0; i < i1; i++) {
                j = i - (i < size ? 0 : size);
                codeTable[j] = { first: blockDataBuffer[i - i0], second: null };
              }
              var dataBytes = input.byteLength - data.ptr;
              var dataWords = Math.ceil(dataBytes / 4);
              var arrayBuf = new ArrayBuffer(dataWords * 4);
              var store8 = new Uint8Array(arrayBuf);
              store8.set(new Uint8Array(input, data.ptr, dataBytes));
              var stuffedData = new Uint32Array(arrayBuf);
              var bitPos = 0, word, srcPtr = 0;
              word = stuffedData[0];
              for (i = i0; i < i1; i++) {
                j = i - (i < size ? 0 : size);
                len = codeTable[j].first;
                if (len > 0) {
                  codeTable[j].second = word << bitPos >>> 32 - len;
                  if (32 - bitPos >= len) {
                    bitPos += len;
                    if (bitPos === 32) {
                      bitPos = 0;
                      srcPtr++;
                      word = stuffedData[srcPtr];
                    }
                  } else {
                    bitPos += len - 32;
                    srcPtr++;
                    word = stuffedData[srcPtr];
                    codeTable[j].second |= word >>> 32 - bitPos;
                  }
                }
              }
              var numBitsLUT = 0, numBitsLUTQick = 0;
              var tree = new TreeNode();
              for (i = 0; i < codeTable.length; i++) {
                if (codeTable[i] !== void 0) {
                  numBitsLUT = Math.max(numBitsLUT, codeTable[i].first);
                }
              }
              if (numBitsLUT >= BITS_MAX) {
                numBitsLUTQick = BITS_MAX;
              } else {
                numBitsLUTQick = numBitsLUT;
              }
              if (numBitsLUT >= 30) {
                console.log("WARning, large NUM LUT BITS IS " + numBitsLUT);
              }
              var decodeLut = [], entry, code, numEntries, jj, currentBit, node;
              for (i = i0; i < i1; i++) {
                j = i - (i < size ? 0 : size);
                len = codeTable[j].first;
                if (len > 0) {
                  entry = [len, j];
                  if (len <= numBitsLUTQick) {
                    code = codeTable[j].second << numBitsLUTQick - len;
                    numEntries = 1 << numBitsLUTQick - len;
                    for (k = 0; k < numEntries; k++) {
                      decodeLut[code | k] = entry;
                    }
                  } else {
                    code = codeTable[j].second;
                    node = tree;
                    for (jj = len - 1; jj >= 0; jj--) {
                      currentBit = code >>> jj & 1;
                      if (currentBit) {
                        if (!node.right) {
                          node.right = new TreeNode();
                        }
                        node = node.right;
                      } else {
                        if (!node.left) {
                          node.left = new TreeNode();
                        }
                        node = node.left;
                      }
                      if (jj === 0 && !node.val) {
                        node.val = entry[1];
                      }
                    }
                  }
                }
              }
              return {
                decodeLut,
                numBitsLUTQick,
                numBitsLUT,
                tree,
                stuffedData,
                srcPtr,
                bitPos
              };
            },
            readHuffman: function(input, data, OutPixelTypeArray) {
              var headerInfo = data.headerInfo;
              var numDims = headerInfo.numDims;
              var height = data.headerInfo.height;
              var width = data.headerInfo.width;
              var numPixels = width * height;
              var huffmanInfo = this.readHuffmanTree(input, data);
              var decodeLut = huffmanInfo.decodeLut;
              var tree = huffmanInfo.tree;
              var stuffedData = huffmanInfo.stuffedData;
              var srcPtr = huffmanInfo.srcPtr;
              var bitPos = huffmanInfo.bitPos;
              var numBitsLUTQick = huffmanInfo.numBitsLUTQick;
              var numBitsLUT = huffmanInfo.numBitsLUT;
              var offset2 = data.headerInfo.imageType === 0 ? 128 : 0;
              var node, val, delta, mask = data.pixels.resultMask, valTmp, valTmpQuick, currentBit;
              var i, j, k, ii;
              var prevVal = 0;
              if (bitPos > 0) {
                srcPtr++;
                bitPos = 0;
              }
              var word = stuffedData[srcPtr];
              var deltaEncode = data.encodeMode === 1;
              var resultPixelsAllDim = new OutPixelTypeArray(numPixels * numDims);
              var resultPixels = resultPixelsAllDim;
              var iDim;
              for (iDim = 0; iDim < headerInfo.numDims; iDim++) {
                if (numDims > 1) {
                  resultPixels = new OutPixelTypeArray(resultPixelsAllDim.buffer, numPixels * iDim, numPixels);
                  prevVal = 0;
                }
                if (data.headerInfo.numValidPixel === width * height) {
                  for (k = 0, i = 0; i < height; i++) {
                    for (j = 0; j < width; j++, k++) {
                      val = 0;
                      valTmp = word << bitPos >>> 32 - numBitsLUTQick;
                      valTmpQuick = valTmp;
                      if (32 - bitPos < numBitsLUTQick) {
                        valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUTQick;
                        valTmpQuick = valTmp;
                      }
                      if (decodeLut[valTmpQuick]) {
                        val = decodeLut[valTmpQuick][1];
                        bitPos += decodeLut[valTmpQuick][0];
                      } else {
                        valTmp = word << bitPos >>> 32 - numBitsLUT;
                        valTmpQuick = valTmp;
                        if (32 - bitPos < numBitsLUT) {
                          valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUT;
                          valTmpQuick = valTmp;
                        }
                        node = tree;
                        for (ii = 0; ii < numBitsLUT; ii++) {
                          currentBit = valTmp >>> numBitsLUT - ii - 1 & 1;
                          node = currentBit ? node.right : node.left;
                          if (!(node.left || node.right)) {
                            val = node.val;
                            bitPos = bitPos + ii + 1;
                            break;
                          }
                        }
                      }
                      if (bitPos >= 32) {
                        bitPos -= 32;
                        srcPtr++;
                        word = stuffedData[srcPtr];
                      }
                      delta = val - offset2;
                      if (deltaEncode) {
                        if (j > 0) {
                          delta += prevVal;
                        } else if (i > 0) {
                          delta += resultPixels[k - width];
                        } else {
                          delta += prevVal;
                        }
                        delta &= 255;
                        resultPixels[k] = delta;
                        prevVal = delta;
                      } else {
                        resultPixels[k] = delta;
                      }
                    }
                  }
                } else {
                  for (k = 0, i = 0; i < height; i++) {
                    for (j = 0; j < width; j++, k++) {
                      if (mask[k]) {
                        val = 0;
                        valTmp = word << bitPos >>> 32 - numBitsLUTQick;
                        valTmpQuick = valTmp;
                        if (32 - bitPos < numBitsLUTQick) {
                          valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUTQick;
                          valTmpQuick = valTmp;
                        }
                        if (decodeLut[valTmpQuick]) {
                          val = decodeLut[valTmpQuick][1];
                          bitPos += decodeLut[valTmpQuick][0];
                        } else {
                          valTmp = word << bitPos >>> 32 - numBitsLUT;
                          valTmpQuick = valTmp;
                          if (32 - bitPos < numBitsLUT) {
                            valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUT;
                            valTmpQuick = valTmp;
                          }
                          node = tree;
                          for (ii = 0; ii < numBitsLUT; ii++) {
                            currentBit = valTmp >>> numBitsLUT - ii - 1 & 1;
                            node = currentBit ? node.right : node.left;
                            if (!(node.left || node.right)) {
                              val = node.val;
                              bitPos = bitPos + ii + 1;
                              break;
                            }
                          }
                        }
                        if (bitPos >= 32) {
                          bitPos -= 32;
                          srcPtr++;
                          word = stuffedData[srcPtr];
                        }
                        delta = val - offset2;
                        if (deltaEncode) {
                          if (j > 0 && mask[k - 1]) {
                            delta += prevVal;
                          } else if (i > 0 && mask[k - width]) {
                            delta += resultPixels[k - width];
                          } else {
                            delta += prevVal;
                          }
                          delta &= 255;
                          resultPixels[k] = delta;
                          prevVal = delta;
                        } else {
                          resultPixels[k] = delta;
                        }
                      }
                    }
                  }
                }
                data.ptr = data.ptr + (srcPtr + 1) * 4 + (bitPos > 0 ? 4 : 0);
              }
              data.pixels.resultPixels = resultPixelsAllDim;
            },
            decodeBits: function(input, data, blockDataBuffer, offset2, iDim) {
              {
                var headerInfo = data.headerInfo;
                var fileVersion = headerInfo.fileVersion;
                var blockPtr = 0;
                var view = new DataView(input, data.ptr, 5);
                var headerByte = view.getUint8(0);
                blockPtr++;
                var bits67 = headerByte >> 6;
                var n = bits67 === 0 ? 4 : 3 - bits67;
                var doLut = (headerByte & 32) > 0 ? true : false;
                var numBits = headerByte & 31;
                var numElements = 0;
                if (n === 1) {
                  numElements = view.getUint8(blockPtr);
                  blockPtr++;
                } else if (n === 2) {
                  numElements = view.getUint16(blockPtr, true);
                  blockPtr += 2;
                } else if (n === 4) {
                  numElements = view.getUint32(blockPtr, true);
                  blockPtr += 4;
                } else {
                  throw "Invalid valid pixel count type";
                }
                var scale = 2 * headerInfo.maxZError;
                var stuffedData, arrayBuf, store8, dataBytes, dataWords;
                var lutArr, lutData, lutBytes, lutBitsPerElement, bitsPerPixel;
                var zMax = headerInfo.numDims > 1 ? headerInfo.maxValues[iDim] : headerInfo.zMax;
                if (doLut) {
                  data.counter.lut++;
                  lutBytes = view.getUint8(blockPtr);
                  lutBitsPerElement = numBits;
                  blockPtr++;
                  dataBytes = Math.ceil((lutBytes - 1) * numBits / 8);
                  dataWords = Math.ceil(dataBytes / 4);
                  arrayBuf = new ArrayBuffer(dataWords * 4);
                  store8 = new Uint8Array(arrayBuf);
                  data.ptr += blockPtr;
                  store8.set(new Uint8Array(input, data.ptr, dataBytes));
                  lutData = new Uint32Array(arrayBuf);
                  data.ptr += dataBytes;
                  bitsPerPixel = 0;
                  while (lutBytes - 1 >>> bitsPerPixel) {
                    bitsPerPixel++;
                  }
                  dataBytes = Math.ceil(numElements * bitsPerPixel / 8);
                  dataWords = Math.ceil(dataBytes / 4);
                  arrayBuf = new ArrayBuffer(dataWords * 4);
                  store8 = new Uint8Array(arrayBuf);
                  store8.set(new Uint8Array(input, data.ptr, dataBytes));
                  stuffedData = new Uint32Array(arrayBuf);
                  data.ptr += dataBytes;
                  if (fileVersion >= 3) {
                    lutArr = BitStuffer.unstuffLUT2(lutData, numBits, lutBytes - 1, offset2, scale, zMax);
                  } else {
                    lutArr = BitStuffer.unstuffLUT(lutData, numBits, lutBytes - 1, offset2, scale, zMax);
                  }
                  if (fileVersion >= 3) {
                    BitStuffer.unstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements, lutArr);
                  } else {
                    BitStuffer.unstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements, lutArr);
                  }
                } else {
                  data.counter.bitstuffer++;
                  bitsPerPixel = numBits;
                  data.ptr += blockPtr;
                  if (bitsPerPixel > 0) {
                    dataBytes = Math.ceil(numElements * bitsPerPixel / 8);
                    dataWords = Math.ceil(dataBytes / 4);
                    arrayBuf = new ArrayBuffer(dataWords * 4);
                    store8 = new Uint8Array(arrayBuf);
                    store8.set(new Uint8Array(input, data.ptr, dataBytes));
                    stuffedData = new Uint32Array(arrayBuf);
                    data.ptr += dataBytes;
                    if (fileVersion >= 3) {
                      if (offset2 == null) {
                        BitStuffer.originalUnstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements);
                      } else {
                        BitStuffer.unstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements, false, offset2, scale, zMax);
                      }
                    } else {
                      if (offset2 == null) {
                        BitStuffer.originalUnstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements);
                      } else {
                        BitStuffer.unstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements, false, offset2, scale, zMax);
                      }
                    }
                  }
                }
              }
            },
            readTiles: function(input, data, OutPixelTypeArray) {
              var headerInfo = data.headerInfo;
              var width = headerInfo.width;
              var height = headerInfo.height;
              var microBlockSize = headerInfo.microBlockSize;
              var imageType = headerInfo.imageType;
              var dataTypeSize = Lerc2Helpers.getDataTypeSize(imageType);
              var numBlocksX = Math.ceil(width / microBlockSize);
              var numBlocksY = Math.ceil(height / microBlockSize);
              data.pixels.numBlocksY = numBlocksY;
              data.pixels.numBlocksX = numBlocksX;
              data.pixels.ptr = 0;
              var row = 0, col = 0, blockY = 0, blockX = 0, thisBlockHeight = 0, thisBlockWidth = 0, bytesLeft = 0, headerByte = 0, bits67 = 0, testCode = 0, outPtr = 0, outStride = 0, numBytes = 0, bytesleft = 0, z = 0, blockPtr = 0;
              var view, block, arrayBuf, store8, rawData;
              var blockEncoding;
              var blockDataBuffer = new OutPixelTypeArray(microBlockSize * microBlockSize);
              var lastBlockHeight = height % microBlockSize || microBlockSize;
              var lastBlockWidth = width % microBlockSize || microBlockSize;
              var offsetType, offset2;
              var numDims = headerInfo.numDims, iDim;
              var mask = data.pixels.resultMask;
              var resultPixels = data.pixels.resultPixels;
              for (blockY = 0; blockY < numBlocksY; blockY++) {
                thisBlockHeight = blockY !== numBlocksY - 1 ? microBlockSize : lastBlockHeight;
                for (blockX = 0; blockX < numBlocksX; blockX++) {
                  thisBlockWidth = blockX !== numBlocksX - 1 ? microBlockSize : lastBlockWidth;
                  outPtr = blockY * width * microBlockSize + blockX * microBlockSize;
                  outStride = width - thisBlockWidth;
                  for (iDim = 0; iDim < numDims; iDim++) {
                    if (numDims > 1) {
                      resultPixels = new OutPixelTypeArray(data.pixels.resultPixels.buffer, width * height * iDim * dataTypeSize, width * height);
                    }
                    bytesLeft = input.byteLength - data.ptr;
                    view = new DataView(input, data.ptr, Math.min(10, bytesLeft));
                    block = {};
                    blockPtr = 0;
                    headerByte = view.getUint8(0);
                    blockPtr++;
                    bits67 = headerByte >> 6 & 255;
                    testCode = headerByte >> 2 & 15;
                    if (testCode !== (blockX * microBlockSize >> 3 & 15)) {
                      throw "integrity issue";
                    }
                    blockEncoding = headerByte & 3;
                    if (blockEncoding > 3) {
                      data.ptr += blockPtr;
                      throw "Invalid block encoding (" + blockEncoding + ")";
                    } else if (blockEncoding === 2) {
                      data.counter.constant++;
                      data.ptr += blockPtr;
                      continue;
                    } else if (blockEncoding === 0) {
                      data.counter.uncompressed++;
                      data.ptr += blockPtr;
                      numBytes = thisBlockHeight * thisBlockWidth * dataTypeSize;
                      bytesleft = input.byteLength - data.ptr;
                      numBytes = numBytes < bytesleft ? numBytes : bytesleft;
                      arrayBuf = new ArrayBuffer(numBytes % dataTypeSize === 0 ? numBytes : numBytes + dataTypeSize - numBytes % dataTypeSize);
                      store8 = new Uint8Array(arrayBuf);
                      store8.set(new Uint8Array(input, data.ptr, numBytes));
                      rawData = new OutPixelTypeArray(arrayBuf);
                      z = 0;
                      if (mask) {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            if (mask[outPtr]) {
                              resultPixels[outPtr] = rawData[z++];
                            }
                            outPtr++;
                          }
                          outPtr += outStride;
                        }
                      } else {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            resultPixels[outPtr++] = rawData[z++];
                          }
                          outPtr += outStride;
                        }
                      }
                      data.ptr += z * dataTypeSize;
                    } else {
                      offsetType = Lerc2Helpers.getDataTypeUsed(imageType, bits67);
                      offset2 = Lerc2Helpers.getOnePixel(block, blockPtr, offsetType, view);
                      blockPtr += Lerc2Helpers.getDataTypeSize(offsetType);
                      if (blockEncoding === 3) {
                        data.ptr += blockPtr;
                        data.counter.constantoffset++;
                        if (mask) {
                          for (row = 0; row < thisBlockHeight; row++) {
                            for (col = 0; col < thisBlockWidth; col++) {
                              if (mask[outPtr]) {
                                resultPixels[outPtr] = offset2;
                              }
                              outPtr++;
                            }
                            outPtr += outStride;
                          }
                        } else {
                          for (row = 0; row < thisBlockHeight; row++) {
                            for (col = 0; col < thisBlockWidth; col++) {
                              resultPixels[outPtr++] = offset2;
                            }
                            outPtr += outStride;
                          }
                        }
                      } else {
                        data.ptr += blockPtr;
                        Lerc2Helpers.decodeBits(input, data, blockDataBuffer, offset2, iDim);
                        blockPtr = 0;
                        if (mask) {
                          for (row = 0; row < thisBlockHeight; row++) {
                            for (col = 0; col < thisBlockWidth; col++) {
                              if (mask[outPtr]) {
                                resultPixels[outPtr] = blockDataBuffer[blockPtr++];
                              }
                              outPtr++;
                            }
                            outPtr += outStride;
                          }
                        } else {
                          for (row = 0; row < thisBlockHeight; row++) {
                            for (col = 0; col < thisBlockWidth; col++) {
                              resultPixels[outPtr++] = blockDataBuffer[blockPtr++];
                            }
                            outPtr += outStride;
                          }
                        }
                      }
                    }
                  }
                }
              }
            },
            formatFileInfo: function(data) {
              return {
                "fileIdentifierString": data.headerInfo.fileIdentifierString,
                "fileVersion": data.headerInfo.fileVersion,
                "imageType": data.headerInfo.imageType,
                "height": data.headerInfo.height,
                "width": data.headerInfo.width,
                "numValidPixel": data.headerInfo.numValidPixel,
                "microBlockSize": data.headerInfo.microBlockSize,
                "blobSize": data.headerInfo.blobSize,
                "maxZError": data.headerInfo.maxZError,
                "pixelType": Lerc2Helpers.getPixelType(data.headerInfo.imageType),
                "eofOffset": data.eofOffset,
                "mask": data.mask ? {
                  "numBytes": data.mask.numBytes
                } : null,
                "pixels": {
                  "numBlocksX": data.pixels.numBlocksX,
                  "numBlocksY": data.pixels.numBlocksY,
                  "maxValue": data.headerInfo.zMax,
                  "minValue": data.headerInfo.zMin,
                  "noDataValue": data.noDataValue
                }
              };
            },
            constructConstantSurface: function(data) {
              var val = data.headerInfo.zMax;
              var numDims = data.headerInfo.numDims;
              var numPixels = data.headerInfo.height * data.headerInfo.width;
              var numPixelAllDims = numPixels * numDims;
              var i = 0, k = 0, nStart = 0;
              var mask = data.pixels.resultMask;
              if (mask) {
                if (numDims > 1) {
                  for (i = 0; i < numDims; i++) {
                    nStart = i * numPixels;
                    for (k = 0; k < numPixels; k++) {
                      if (mask[k]) {
                        data.pixels.resultPixels[nStart + k] = val;
                      }
                    }
                  }
                } else {
                  for (k = 0; k < numPixels; k++) {
                    if (mask[k]) {
                      data.pixels.resultPixels[k] = val;
                    }
                  }
                }
              } else {
                if (data.pixels.resultPixels.fill) {
                  data.pixels.resultPixels.fill(val);
                } else {
                  for (k = 0; k < numPixelAllDims; k++) {
                    data.pixels.resultPixels[k] = val;
                  }
                }
              }
              return;
            },
            getDataTypeArray: function(t) {
              var tp;
              switch (t) {
                case 0:
                  tp = Int8Array;
                  break;
                case 1:
                  tp = Uint8Array;
                  break;
                case 2:
                  tp = Int16Array;
                  break;
                case 3:
                  tp = Uint16Array;
                  break;
                case 4:
                  tp = Int32Array;
                  break;
                case 5:
                  tp = Uint32Array;
                  break;
                case 6:
                  tp = Float32Array;
                  break;
                case 7:
                  tp = Float64Array;
                  break;
                default:
                  tp = Float32Array;
              }
              return tp;
            },
            getPixelType: function(t) {
              var tp;
              switch (t) {
                case 0:
                  tp = "S8";
                  break;
                case 1:
                  tp = "U8";
                  break;
                case 2:
                  tp = "S16";
                  break;
                case 3:
                  tp = "U16";
                  break;
                case 4:
                  tp = "S32";
                  break;
                case 5:
                  tp = "U32";
                  break;
                case 6:
                  tp = "F32";
                  break;
                case 7:
                  tp = "F64";
                  break;
                default:
                  tp = "F32";
              }
              return tp;
            },
            isValidPixelValue: function(t, val) {
              if (val == null) {
                return false;
              }
              var isValid;
              switch (t) {
                case 0:
                  isValid = val >= -128 && val <= 127;
                  break;
                case 1:
                  isValid = val >= 0 && val <= 255;
                  break;
                case 2:
                  isValid = val >= -32768 && val <= 32767;
                  break;
                case 3:
                  isValid = val >= 0 && val <= 65536;
                  break;
                case 4:
                  isValid = val >= -2147483648 && val <= 2147483647;
                  break;
                case 5:
                  isValid = val >= 0 && val <= 4294967296;
                  break;
                case 6:
                  isValid = val >= -34027999387901484e22 && val <= 34027999387901484e22;
                  break;
                case 7:
                  isValid = val >= 5e-324 && val <= 17976931348623157e292;
                  break;
                default:
                  isValid = false;
              }
              return isValid;
            },
            getDataTypeSize: function(t) {
              var s = 0;
              switch (t) {
                case 0:
                case 1:
                  s = 1;
                  break;
                case 2:
                case 3:
                  s = 2;
                  break;
                case 4:
                case 5:
                case 6:
                  s = 4;
                  break;
                case 7:
                  s = 8;
                  break;
                default:
                  s = t;
              }
              return s;
            },
            getDataTypeUsed: function(dt, tc) {
              var t = dt;
              switch (dt) {
                case 2:
                case 4:
                  t = dt - tc;
                  break;
                case 3:
                case 5:
                  t = dt - 2 * tc;
                  break;
                case 6:
                  if (0 === tc) {
                    t = dt;
                  } else if (1 === tc) {
                    t = 2;
                  } else {
                    t = 1;
                  }
                  break;
                case 7:
                  if (0 === tc) {
                    t = dt;
                  } else {
                    t = dt - 2 * tc + 1;
                  }
                  break;
                default:
                  t = dt;
                  break;
              }
              return t;
            },
            getOnePixel: function(block, blockPtr, offsetType, view) {
              var temp = 0;
              switch (offsetType) {
                case 0:
                  temp = view.getInt8(blockPtr);
                  break;
                case 1:
                  temp = view.getUint8(blockPtr);
                  break;
                case 2:
                  temp = view.getInt16(blockPtr, true);
                  break;
                case 3:
                  temp = view.getUint16(blockPtr, true);
                  break;
                case 4:
                  temp = view.getInt32(blockPtr, true);
                  break;
                case 5:
                  temp = view.getUInt32(blockPtr, true);
                  break;
                case 6:
                  temp = view.getFloat32(blockPtr, true);
                  break;
                case 7:
                  temp = view.getFloat64(blockPtr, true);
                  break;
                default:
                  throw "the decoder does not understand this pixel type";
              }
              return temp;
            }
          };
          var TreeNode = function(val, left, right) {
            this.val = val;
            this.left = left;
            this.right = right;
          };
          var Lerc2Decode2 = {
            decode: function(input, options) {
              options = options || {};
              var noDataValue = options.noDataValue;
              var i = 0, data = {};
              data.ptr = options.inputOffset || 0;
              data.pixels = {};
              if (!Lerc2Helpers.readHeaderInfo(input, data)) {
                return;
              }
              var headerInfo = data.headerInfo;
              var fileVersion = headerInfo.fileVersion;
              var OutPixelTypeArray = Lerc2Helpers.getDataTypeArray(headerInfo.imageType);
              Lerc2Helpers.readMask(input, data);
              if (headerInfo.numValidPixel !== headerInfo.width * headerInfo.height && !data.pixels.resultMask) {
                data.pixels.resultMask = options.maskData;
              }
              var numPixels = headerInfo.width * headerInfo.height;
              data.pixels.resultPixels = new OutPixelTypeArray(numPixels * headerInfo.numDims);
              data.counter = {
                onesweep: 0,
                uncompressed: 0,
                lut: 0,
                bitstuffer: 0,
                constant: 0,
                constantoffset: 0
              };
              if (headerInfo.numValidPixel !== 0) {
                if (headerInfo.zMax === headerInfo.zMin) {
                  Lerc2Helpers.constructConstantSurface(data);
                } else if (fileVersion >= 4 && Lerc2Helpers.checkMinMaxRanges(input, data)) {
                  Lerc2Helpers.constructConstantSurface(data);
                } else {
                  var view = new DataView(input, data.ptr, 2);
                  var bReadDataOneSweep = view.getUint8(0);
                  data.ptr++;
                  if (bReadDataOneSweep) {
                    Lerc2Helpers.readDataOneSweep(input, data, OutPixelTypeArray);
                  } else {
                    if (fileVersion > 1 && headerInfo.imageType <= 1 && Math.abs(headerInfo.maxZError - 0.5) < 1e-5) {
                      var flagHuffman = view.getUint8(1);
                      data.ptr++;
                      data.encodeMode = flagHuffman;
                      if (flagHuffman > 2 || fileVersion < 4 && flagHuffman > 1) {
                        throw "Invalid Huffman flag " + flagHuffman;
                      }
                      if (flagHuffman) {
                        Lerc2Helpers.readHuffman(input, data, OutPixelTypeArray);
                      } else {
                        Lerc2Helpers.readTiles(input, data, OutPixelTypeArray);
                      }
                    } else {
                      Lerc2Helpers.readTiles(input, data, OutPixelTypeArray);
                    }
                  }
                }
              }
              data.eofOffset = data.ptr;
              var diff;
              if (options.inputOffset) {
                diff = data.headerInfo.blobSize + options.inputOffset - data.ptr;
                if (Math.abs(diff) >= 1) {
                  data.eofOffset = options.inputOffset + data.headerInfo.blobSize;
                }
              } else {
                diff = data.headerInfo.blobSize - data.ptr;
                if (Math.abs(diff) >= 1) {
                  data.eofOffset = data.headerInfo.blobSize;
                }
              }
              var result = {
                width: headerInfo.width,
                height: headerInfo.height,
                pixelData: data.pixels.resultPixels,
                minValue: headerInfo.zMin,
                maxValue: headerInfo.zMax,
                validPixelCount: headerInfo.numValidPixel,
                dimCount: headerInfo.numDims,
                dimStats: {
                  minValues: headerInfo.minValues,
                  maxValues: headerInfo.maxValues
                },
                maskData: data.pixels.resultMask
              };
              if (data.pixels.resultMask && Lerc2Helpers.isValidPixelValue(headerInfo.imageType, noDataValue)) {
                var mask = data.pixels.resultMask;
                for (i = 0; i < numPixels; i++) {
                  if (!mask[i]) {
                    result.pixelData[i] = noDataValue;
                  }
                }
                result.noDataValue = noDataValue;
              }
              data.noDataValue = noDataValue;
              if (options.returnFileInfo) {
                result.fileInfo = Lerc2Helpers.formatFileInfo(data);
              }
              return result;
            },
            getBandCount: function(input) {
              var count = 0;
              var i = 0;
              var temp = {};
              temp.ptr = 0;
              temp.pixels = {};
              while (i < input.byteLength - 58) {
                Lerc2Helpers.readHeaderInfo(input, temp);
                i += temp.headerInfo.blobSize;
                count++;
                temp.ptr = i;
              }
              return count;
            }
          };
          return Lerc2Decode2;
        }();
        var isPlatformLittleEndian = function() {
          var a3 = new ArrayBuffer(4);
          var b = new Uint8Array(a3);
          var c = new Uint32Array(a3);
          c[0] = 1;
          return b[0] === 1;
        }();
        var Lerc2 = {
          decode: function(encodedData, options) {
            if (!isPlatformLittleEndian) {
              throw "Big endian system is not supported.";
            }
            options = options || {};
            var inputOffset = options.inputOffset || 0;
            var fileIdView = new Uint8Array(encodedData, inputOffset, 10);
            var fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
            var lerc, majorVersion;
            if (fileIdentifierString.trim() === "CntZImage") {
              lerc = LercDecode;
              majorVersion = 1;
            } else if (fileIdentifierString.substring(0, 5) === "Lerc2") {
              lerc = Lerc2Decode;
              majorVersion = 2;
            } else {
              throw "Unexpected file identifier string: " + fileIdentifierString;
            }
            var iPlane = 0, eof = encodedData.byteLength - 10, encodedMaskData, bandMasks = [], bandMask, maskData;
            var decodedPixelBlock = {
              width: 0,
              height: 0,
              pixels: [],
              pixelType: options.pixelType,
              mask: null,
              statistics: []
            };
            while (inputOffset < eof) {
              var result = lerc.decode(encodedData, {
                inputOffset,
                encodedMaskData,
                maskData,
                returnMask: iPlane === 0 ? true : false,
                returnEncodedMask: iPlane === 0 ? true : false,
                returnFileInfo: true,
                pixelType: options.pixelType || null,
                noDataValue: options.noDataValue || null
              });
              inputOffset = result.fileInfo.eofOffset;
              if (iPlane === 0) {
                encodedMaskData = result.encodedMaskData;
                maskData = result.maskData;
                decodedPixelBlock.width = result.width;
                decodedPixelBlock.height = result.height;
                decodedPixelBlock.dimCount = result.dimCount || 1;
                decodedPixelBlock.pixelType = result.pixelType || result.fileInfo.pixelType;
                decodedPixelBlock.mask = result.maskData;
              }
              if (majorVersion > 1 && result.fileInfo.mask && result.fileInfo.mask.numBytes > 0) {
                bandMasks.push(result.maskData);
              }
              iPlane++;
              decodedPixelBlock.pixels.push(result.pixelData);
              decodedPixelBlock.statistics.push({
                minValue: result.minValue,
                maxValue: result.maxValue,
                noDataValue: result.noDataValue,
                dimStats: result.dimStats
              });
            }
            var i, j, numPixels;
            if (majorVersion > 1 && bandMasks.length > 1) {
              numPixels = decodedPixelBlock.width * decodedPixelBlock.height;
              decodedPixelBlock.bandMasks = bandMasks;
              maskData = new Uint8Array(numPixels);
              maskData.set(bandMasks[0]);
              for (i = 1; i < bandMasks.length; i++) {
                bandMask = bandMasks[i];
                for (j = 0; j < numPixels; j++) {
                  maskData[j] = maskData[j] & bandMask[j];
                }
              }
              decodedPixelBlock.maskData = maskData;
            }
            return decodedPixelBlock;
          }
        };
        if (typeof define === "function" && define.amd) {
          define([], function() {
            return Lerc2;
          });
        } else if (typeof module2 !== "undefined" && module2.exports) {
          module2.exports = Lerc2;
        } else {
          this.Lerc = Lerc2;
        }
      })();
    }
  });

  // node_modules/nosleep.js/src/media.js
  var require_media = __commonJS({
    "node_modules/nosleep.js/src/media.js"(exports2, module2) {
      module2.exports = {
        webm: "data:video/webm;base64,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",
        mp4: "data:video/mp4;base64,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"
      };
    }
  });

  // node_modules/nosleep.js/src/index.js
  var require_src = __commonJS({
    "node_modules/nosleep.js/src/index.js"(exports2, module2) {
      var { webm, mp4 } = require_media();
      var oldIOS = () => typeof navigator !== "undefined" && parseFloat(
        ("" + (/CPU.*OS ([0-9_]{3,4})[0-9_]{0,1}|(CPU like).*AppleWebKit.*Mobile/i.exec(
          navigator.userAgent
        ) || [0, ""])[1]).replace("undefined", "3_2").replace("_", ".").replace("_", "")
      ) < 10 && !window.MSStream;
      var nativeWakeLock = () => "wakeLock" in navigator;
      var NoSleep2 = class {
        constructor() {
          this.enabled = false;
          if (nativeWakeLock()) {
            this._wakeLock = null;
            const handleVisibilityChange = () => {
              if (this._wakeLock !== null && document.visibilityState === "visible") {
                this.enable();
              }
            };
            document.addEventListener("visibilitychange", handleVisibilityChange);
            document.addEventListener("fullscreenchange", handleVisibilityChange);
          } else if (oldIOS()) {
            this.noSleepTimer = null;
          } else {
            this.noSleepVideo = document.createElement("video");
            this.noSleepVideo.setAttribute("title", "No Sleep");
            this.noSleepVideo.setAttribute("playsinline", "");
            this._addSourceToVideo(this.noSleepVideo, "webm", webm);
            this._addSourceToVideo(this.noSleepVideo, "mp4", mp4);
            this.noSleepVideo.addEventListener("loadedmetadata", () => {
              if (this.noSleepVideo.duration <= 1) {
                this.noSleepVideo.setAttribute("loop", "");
              } else {
                this.noSleepVideo.addEventListener("timeupdate", () => {
                  if (this.noSleepVideo.currentTime > 0.5) {
                    this.noSleepVideo.currentTime = Math.random();
                  }
                });
              }
            });
          }
        }
        _addSourceToVideo(element, type, dataURI) {
          var source = document.createElement("source");
          source.src = dataURI;
          source.type = `video/${type}`;
          element.appendChild(source);
        }
        get isEnabled() {
          return this.enabled;
        }
        enable() {
          if (nativeWakeLock()) {
            return navigator.wakeLock.request("screen").then((wakeLock) => {
              this._wakeLock = wakeLock;
              this.enabled = true;
              console.log("Wake Lock active.");
              this._wakeLock.addEventListener("release", () => {
                console.log("Wake Lock released.");
              });
            }).catch((err) => {
              this.enabled = false;
              console.error(`${err.name}, ${err.message}`);
              throw err;
            });
          } else if (oldIOS()) {
            this.disable();
            console.warn(`
        NoSleep enabled for older iOS devices. This can interrupt
        active or long-running network requests from completing successfully.
        See https://github.com/richtr/NoSleep.js/issues/15 for more details.
      `);
            this.noSleepTimer = window.setInterval(() => {
              if (!document.hidden) {
                window.location.href = window.location.href.split("#")[0];
                window.setTimeout(window.stop, 0);
              }
            }, 15e3);
            this.enabled = true;
            return Promise.resolve();
          } else {
            let playPromise = this.noSleepVideo.play();
            return playPromise.then((res) => {
              this.enabled = true;
              return res;
            }).catch((err) => {
              this.enabled = false;
              throw err;
            });
          }
        }
        disable() {
          if (nativeWakeLock()) {
            if (this._wakeLock) {
              this._wakeLock.release();
            }
            this._wakeLock = null;
          } else if (oldIOS()) {
            if (this.noSleepTimer) {
              console.warn(`
          NoSleep now disabled for older iOS devices.
        `);
              window.clearInterval(this.noSleepTimer);
              this.noSleepTimer = null;
            }
          } else {
            this.noSleepVideo.pause();
          }
          this.enabled = false;
        }
      };
      module2.exports = NoSleep2;
    }
  });

  // Source/Cesium.js
  var Cesium_exports = {};
  __export(Cesium_exports, {
    AlphaMode: () => AlphaMode_default,
    AlphaPipelineStage: () => AlphaPipelineStage_default,
    Animation: () => Animation_default,
    AnimationViewModel: () => AnimationViewModel_default,
    Appearance: () => Appearance_default,
    ApproximateTerrainHeights: () => ApproximateTerrainHeights_default,
    ArcGISTiledElevationTerrainProvider: () => ArcGISTiledElevationTerrainProvider_default,
    ArcGisMapServerImageryProvider: () => ArcGisMapServerImageryProvider_default,
    ArcType: () => ArcType_default,
    ArticulationStageType: () => ArticulationStageType_default,
    AssociativeArray: () => AssociativeArray_default,
    AttributeCompression: () => AttributeCompression_default,
    AttributeType: () => AttributeType_default,
    AutoExposure: () => AutoExposure_default,
    AutomaticUniforms: () => AutomaticUniforms_default,
    Axis: () => Axis_default,
    AxisAlignedBoundingBox: () => AxisAlignedBoundingBox_default,
    B3dmLoader: () => B3dmLoader_default,
    B3dmParser: () => B3dmParser_default,
    BaseLayerPicker: () => BaseLayerPicker_default,
    BaseLayerPickerViewModel: () => BaseLayerPickerViewModel_default,
    BatchTable: () => BatchTable_default,
    BatchTableHierarchy: () => BatchTableHierarchy_default,
    BatchTexture: () => BatchTexture_default,
    BatchTexturePipelineStage: () => BatchTexturePipelineStage_default,
    Billboard: () => Billboard_default,
    BillboardCollection: () => BillboardCollection_default,
    BillboardGraphics: () => BillboardGraphics_default,
    BillboardVisualizer: () => BillboardVisualizer_default,
    BingMapsGeocoderService: () => BingMapsGeocoderService_default,
    BingMapsImageryProvider: () => BingMapsImageryProvider_default,
    BingMapsStyle: () => BingMapsStyle_default,
    BlendEquation: () => BlendEquation_default,
    BlendFunction: () => BlendFunction_default,
    BlendOption: () => BlendOption_default,
    BlendingState: () => BlendingState_default,
    BoundingRectangle: () => BoundingRectangle_default,
    BoundingSphere: () => BoundingSphere_default,
    BoundingSphereState: () => BoundingSphereState_default,
    BoxEmitter: () => BoxEmitter_default,
    BoxGeometry: () => BoxGeometry_default,
    BoxGeometryUpdater: () => BoxGeometryUpdater_default,
    BoxGraphics: () => BoxGraphics_default,
    BoxOutlineGeometry: () => BoxOutlineGeometry_default,
    BrdfLutGenerator: () => BrdfLutGenerator_default,
    Buffer: () => Buffer_default,
    BufferLoader: () => BufferLoader_default,
    BufferUsage: () => BufferUsage_default,
    CPUStylingPipelineStage: () => CPUStylingPipelineStage_default,
    CallbackProperty: () => CallbackProperty_default,
    Camera: () => Camera_default,
    CameraEventAggregator: () => CameraEventAggregator_default,
    CameraEventType: () => CameraEventType_default,
    CameraFlightPath: () => CameraFlightPath_default,
    Cartesian2: () => Cartesian2_default,
    Cartesian3: () => Cartesian3_default,
    Cartesian4: () => Cartesian4_default,
    Cartographic: () => Cartographic_default,
    CartographicGeocoderService: () => CartographicGeocoderService_default,
    CatmullRomSpline: () => CatmullRomSpline_default,
    Cesium3DContentGroup: () => Cesium3DContentGroup_default,
    Cesium3DTile: () => Cesium3DTile_default,
    Cesium3DTileBatchTable: () => Cesium3DTileBatchTable_default,
    Cesium3DTileColorBlendMode: () => Cesium3DTileColorBlendMode_default,
    Cesium3DTileContent: () => Cesium3DTileContent_default,
    Cesium3DTileContentFactory: () => Cesium3DTileContentFactory_default,
    Cesium3DTileContentState: () => Cesium3DTileContentState_default,
    Cesium3DTileContentType: () => Cesium3DTileContentType_default,
    Cesium3DTileFeature: () => Cesium3DTileFeature_default,
    Cesium3DTileFeatureTable: () => Cesium3DTileFeatureTable_default,
    Cesium3DTileOptimizationHint: () => Cesium3DTileOptimizationHint_default,
    Cesium3DTileOptimizations: () => Cesium3DTileOptimizations_default,
    Cesium3DTilePass: () => Cesium3DTilePass_default,
    Cesium3DTilePassState: () => Cesium3DTilePassState_default,
    Cesium3DTilePointFeature: () => Cesium3DTilePointFeature_default,
    Cesium3DTileRefine: () => Cesium3DTileRefine_default,
    Cesium3DTileStyle: () => Cesium3DTileStyle_default,
    Cesium3DTileStyleEngine: () => Cesium3DTileStyleEngine_default,
    Cesium3DTilesInspector: () => Cesium3DTilesInspector_default,
    Cesium3DTilesInspectorViewModel: () => Cesium3DTilesInspectorViewModel_default,
    Cesium3DTileset: () => Cesium3DTileset_default,
    Cesium3DTilesetCache: () => Cesium3DTilesetCache_default,
    Cesium3DTilesetGraphics: () => Cesium3DTilesetGraphics_default,
    Cesium3DTilesetHeatmap: () => Cesium3DTilesetHeatmap_default,
    Cesium3DTilesetMetadata: () => Cesium3DTilesetMetadata_default,
    Cesium3DTilesetMostDetailedTraversal: () => Cesium3DTilesetMostDetailedTraversal_default,
    Cesium3DTilesetStatistics: () => Cesium3DTilesetStatistics_default,
    Cesium3DTilesetTraversal: () => Cesium3DTilesetTraversal_default,
    Cesium3DTilesetVisualizer: () => Cesium3DTilesetVisualizer_default,
    CesiumInspector: () => CesiumInspector_default,
    CesiumInspectorViewModel: () => CesiumInspectorViewModel_default,
    CesiumTerrainProvider: () => CesiumTerrainProvider_default,
    CesiumWidget: () => CesiumWidget_default,
    Check: () => Check_default,
    CheckerboardMaterialProperty: () => CheckerboardMaterialProperty_default,
    CircleEmitter: () => CircleEmitter_default,
    CircleGeometry: () => CircleGeometry_default,
    CircleOutlineGeometry: () => CircleOutlineGeometry_default,
    ClassificationModelDrawCommand: () => ClassificationModelDrawCommand_default,
    ClassificationPipelineStage: () => ClassificationPipelineStage_default,
    ClassificationPrimitive: () => ClassificationPrimitive_default,
    ClassificationType: () => ClassificationType_default,
    ClearCommand: () => ClearCommand_default,
    ClippingPlane: () => ClippingPlane_default,
    ClippingPlaneCollection: () => ClippingPlaneCollection_default,
    Clock: () => Clock_default,
    ClockRange: () => ClockRange_default,
    ClockStep: () => ClockStep_default,
    ClockViewModel: () => ClockViewModel_default,
    CloudCollection: () => CloudCollection_default,
    CloudType: () => CloudType_default,
    Color: () => Color_default,
    ColorBlendMode: () => ColorBlendMode_default,
    ColorGeometryInstanceAttribute: () => ColorGeometryInstanceAttribute_default,
    ColorMaterialProperty: () => ColorMaterialProperty_default,
    Command: () => Command_default,
    ComponentDatatype: () => ComponentDatatype_default,
    Composite3DTileContent: () => Composite3DTileContent_default,
    CompositeEntityCollection: () => CompositeEntityCollection_default,
    CompositeMaterialProperty: () => CompositeMaterialProperty_default,
    CompositePositionProperty: () => CompositePositionProperty_default,
    CompositeProperty: () => CompositeProperty_default,
    CompressedTextureBuffer: () => CompressedTextureBuffer_default,
    ComputeCommand: () => ComputeCommand_default,
    ComputeEngine: () => ComputeEngine_default,
    ConditionsExpression: () => ConditionsExpression_default,
    ConeEmitter: () => ConeEmitter_default,
    ConstantPositionProperty: () => ConstantPositionProperty_default,
    ConstantProperty: () => ConstantProperty_default,
    ConstantSpline: () => ConstantSpline_default,
    ContentMetadata: () => ContentMetadata_default,
    Context: () => Context_default,
    ContextLimits: () => ContextLimits_default,
    CoplanarPolygonGeometry: () => CoplanarPolygonGeometry_default,
    CoplanarPolygonGeometryLibrary: () => CoplanarPolygonGeometryLibrary_default,
    CoplanarPolygonOutlineGeometry: () => CoplanarPolygonOutlineGeometry_default,
    CornerType: () => CornerType_default,
    CorridorGeometry: () => CorridorGeometry_default,
    CorridorGeometryLibrary: () => CorridorGeometryLibrary_default,
    CorridorGeometryUpdater: () => CorridorGeometryUpdater_default,
    CorridorGraphics: () => CorridorGraphics_default,
    CorridorOutlineGeometry: () => CorridorOutlineGeometry_default,
    Credit: () => Credit_default,
    CreditDisplay: () => CreditDisplay_default,
    CubeMap: () => CubeMap_default,
    CubeMapFace: () => CubeMapFace_default,
    CubicRealPolynomial: () => CubicRealPolynomial_default,
    CullFace: () => CullFace_default,
    CullingVolume: () => CullingVolume_default,
    CumulusCloud: () => CumulusCloud_default,
    CustomDataSource: () => CustomDataSource_default,
    CustomHeightmapTerrainProvider: () => CustomHeightmapTerrainProvider_default,
    CustomShader: () => CustomShader_default,
    CustomShaderMode: () => CustomShaderMode_default,
    CustomShaderPipelineStage: () => CustomShaderPipelineStage_default,
    CustomShaderTranslucencyMode: () => CustomShaderTranslucencyMode_default,
    CylinderGeometry: () => CylinderGeometry_default,
    CylinderGeometryLibrary: () => CylinderGeometryLibrary_default,
    CylinderGeometryUpdater: () => CylinderGeometryUpdater_default,
    CylinderGraphics: () => CylinderGraphics_default,
    CylinderOutlineGeometry: () => CylinderOutlineGeometry_default,
    CzmlDataSource: () => CzmlDataSource_default,
    DataSource: () => DataSource_default,
    DataSourceClock: () => DataSourceClock_default,
    DataSourceCollection: () => DataSourceCollection_default,
    DataSourceDisplay: () => DataSourceDisplay_default,
    DebugAppearance: () => DebugAppearance_default,
    DebugCameraPrimitive: () => DebugCameraPrimitive_default,
    DebugInspector: () => DebugInspector_default,
    DebugModelMatrixPrimitive: () => DebugModelMatrixPrimitive_default,
    DefaultProxy: () => DefaultProxy_default,
    DepthFunction: () => DepthFunction_default,
    DepthPlane: () => DepthPlane_default,
    DequantizationPipelineStage: () => DequantizationPipelineStage_default,
    DerivedCommand: () => DerivedCommand_default,
    DeveloperError: () => DeveloperError_default,
    DeviceOrientationCameraController: () => DeviceOrientationCameraController_default,
    DirectionalLight: () => DirectionalLight_default,
    DiscardEmptyTileImagePolicy: () => DiscardEmptyTileImagePolicy_default,
    DiscardMissingTileImagePolicy: () => DiscardMissingTileImagePolicy_default,
    DistanceDisplayCondition: () => DistanceDisplayCondition_default,
    DistanceDisplayConditionGeometryInstanceAttribute: () => DistanceDisplayConditionGeometryInstanceAttribute_default,
    DoubleEndedPriorityQueue: () => DoubleEndedPriorityQueue_default,
    DoublyLinkedList: () => DoublyLinkedList_default,
    DracoLoader: () => DracoLoader_default,
    DrawCommand: () => DrawCommand_default,
    DynamicGeometryBatch: () => DynamicGeometryBatch_default,
    DynamicGeometryUpdater: () => DynamicGeometryUpdater_default,
    EarthOrientationParameters: () => EarthOrientationParameters_default,
    EarthOrientationParametersSample: () => EarthOrientationParametersSample_default,
    EasingFunction: () => EasingFunction_default,
    EllipseGeometry: () => EllipseGeometry_default,
    EllipseGeometryLibrary: () => EllipseGeometryLibrary_default,
    EllipseGeometryUpdater: () => EllipseGeometryUpdater_default,
    EllipseGraphics: () => EllipseGraphics_default,
    EllipseOutlineGeometry: () => EllipseOutlineGeometry_default,
    Ellipsoid: () => Ellipsoid_default,
    EllipsoidGeodesic: () => EllipsoidGeodesic_default,
    EllipsoidGeometry: () => EllipsoidGeometry_default,
    EllipsoidGeometryUpdater: () => EllipsoidGeometryUpdater_default,
    EllipsoidGraphics: () => EllipsoidGraphics_default,
    EllipsoidOutlineGeometry: () => EllipsoidOutlineGeometry_default,
    EllipsoidPrimitive: () => EllipsoidPrimitive_default,
    EllipsoidRhumbLine: () => EllipsoidRhumbLine_default,
    EllipsoidSurfaceAppearance: () => EllipsoidSurfaceAppearance_default,
    EllipsoidTangentPlane: () => EllipsoidTangentPlane_default,
    EllipsoidTerrainProvider: () => EllipsoidTerrainProvider_default,
    EllipsoidalOccluder: () => EllipsoidalOccluder_default,
    Empty3DTileContent: () => Empty3DTileContent_default,
    EncodedCartesian3: () => EncodedCartesian3_default,
    Entity: () => Entity_default,
    EntityCluster: () => EntityCluster_default,
    EntityCollection: () => EntityCollection_default,
    EntityView: () => EntityView_default,
    Event: () => Event_default,
    EventHelper: () => EventHelper_default,
    Expression: () => Expression_default,
    ExpressionNodeType: () => ExpressionNodeType_default,
    ExtrapolationType: () => ExtrapolationType_default,
    FeatureDetection: () => FeatureDetection_default,
    FeatureIdPipelineStage: () => FeatureIdPipelineStage_default,
    Fog: () => Fog_default,
    ForEach: () => ForEach_default,
    FrameRateMonitor: () => FrameRateMonitor_default,
    FrameState: () => FrameState_default,
    Framebuffer: () => Framebuffer_default,
    FramebufferManager: () => FramebufferManager_default,
    FrustumCommands: () => FrustumCommands_default,
    FrustumGeometry: () => FrustumGeometry_default,
    FrustumOutlineGeometry: () => FrustumOutlineGeometry_default,
    Fullscreen: () => Fullscreen_default,
    FullscreenButton: () => FullscreenButton_default,
    FullscreenButtonViewModel: () => FullscreenButtonViewModel_default,
    GeoJsonDataSource: () => GeoJsonDataSource_default,
    GeoJsonLoader: () => GeoJsonLoader_default,
    GeocodeType: () => GeocodeType_default,
    Geocoder: () => Geocoder_default,
    GeocoderService: () => GeocoderService_default,
    GeocoderViewModel: () => GeocoderViewModel_default,
    GeographicProjection: () => GeographicProjection_default,
    GeographicTilingScheme: () => GeographicTilingScheme_default,
    Geometry: () => Geometry_default,
    Geometry3DTileContent: () => Geometry3DTileContent_default,
    GeometryAttribute: () => GeometryAttribute_default,
    GeometryAttributes: () => GeometryAttributes_default,
    GeometryFactory: () => GeometryFactory_default,
    GeometryInstance: () => GeometryInstance_default,
    GeometryInstanceAttribute: () => GeometryInstanceAttribute_default,
    GeometryOffsetAttribute: () => GeometryOffsetAttribute_default,
    GeometryPipeline: () => GeometryPipeline_default,
    GeometryPipelineStage: () => GeometryPipelineStage_default,
    GeometryType: () => GeometryType_default,
    GeometryUpdater: () => GeometryUpdater_default,
    GeometryVisualizer: () => GeometryVisualizer_default,
    GetFeatureInfoFormat: () => GetFeatureInfoFormat_default,
    Globe: () => Globe_default,
    GlobeDepth: () => GlobeDepth_default,
    GlobeSurfaceShaderSet: () => GlobeSurfaceShaderSet_default,
    GlobeSurfaceTile: () => GlobeSurfaceTile_default,
    GlobeSurfaceTileProvider: () => GlobeSurfaceTileProvider_default,
    GlobeTranslucency: () => GlobeTranslucency_default,
    GlobeTranslucencyFramebuffer: () => GlobeTranslucencyFramebuffer_default,
    GlobeTranslucencyState: () => GlobeTranslucencyState_default,
    GltfBufferViewLoader: () => GltfBufferViewLoader_default,
    GltfDracoLoader: () => GltfDracoLoader_default,
    GltfImageLoader: () => GltfImageLoader_default,
    GltfIndexBufferLoader: () => GltfIndexBufferLoader_default,
    GltfJsonLoader: () => GltfJsonLoader_default,
    GltfLoader: () => GltfLoader_default,
    GltfLoaderUtil: () => GltfLoaderUtil_default,
    GltfStructuralMetadataLoader: () => GltfStructuralMetadataLoader_default,
    GltfTextureLoader: () => GltfTextureLoader_default,
    GltfVertexBufferLoader: () => GltfVertexBufferLoader_default,
    GoogleEarthEnterpriseImageryProvider: () => GoogleEarthEnterpriseImageryProvider_default,
    GoogleEarthEnterpriseMapsProvider: () => GoogleEarthEnterpriseMapsProvider_default,
    GoogleEarthEnterpriseMetadata: () => GoogleEarthEnterpriseMetadata_default,
    GoogleEarthEnterpriseTerrainData: () => GoogleEarthEnterpriseTerrainData_default,
    GoogleEarthEnterpriseTerrainProvider: () => GoogleEarthEnterpriseTerrainProvider_default,
    GoogleEarthEnterpriseTileInformation: () => GoogleEarthEnterpriseTileInformation_default,
    GpxDataSource: () => GpxDataSource_default,
    GregorianDate: () => GregorianDate_default,
    GridImageryProvider: () => GridImageryProvider_default,
    GridMaterialProperty: () => GridMaterialProperty_default,
    GroundGeometryUpdater: () => GroundGeometryUpdater_default,
    GroundPolylineGeometry: () => GroundPolylineGeometry_default,
    GroundPolylinePrimitive: () => GroundPolylinePrimitive_default,
    GroundPrimitive: () => GroundPrimitive_default,
    GroupMetadata: () => GroupMetadata_default,
    HeadingPitchRange: () => HeadingPitchRange_default,
    HeadingPitchRoll: () => HeadingPitchRoll_default,
    Heap: () => Heap_default,
    HeightReference: () => HeightReference_default,
    HeightmapEncoding: () => HeightmapEncoding_default,
    HeightmapTerrainData: () => HeightmapTerrainData_default,
    HeightmapTessellator: () => HeightmapTessellator_default,
    HermitePolynomialApproximation: () => HermitePolynomialApproximation_default,
    HermiteSpline: () => HermiteSpline_default,
    HilbertOrder: () => HilbertOrder_default,
    HomeButton: () => HomeButton_default,
    HomeButtonViewModel: () => HomeButtonViewModel_default,
    HorizontalOrigin: () => HorizontalOrigin_default,
    I3SDataProvider: () => I3SDataProvider_default,
    I3SFeature: () => I3SFeature_default,
    I3SField: () => I3SField_default,
    I3SGeometry: () => I3SGeometry_default,
    I3SLayer: () => I3SLayer_default,
    I3SNode: () => I3SNode_default,
    I3dmLoader: () => I3dmLoader_default,
    I3dmParser: () => I3dmParser_default,
    Iau2000Orientation: () => Iau2000Orientation_default,
    Iau2006XysData: () => Iau2006XysData_default,
    Iau2006XysSample: () => Iau2006XysSample_default,
    IauOrientationAxes: () => IauOrientationAxes_default,
    IauOrientationParameters: () => IauOrientationParameters_default,
    ImageBasedLighting: () => ImageBasedLighting_default,
    ImageBasedLightingPipelineStage: () => ImageBasedLightingPipelineStage_default,
    ImageMaterialProperty: () => ImageMaterialProperty_default,
    Imagery: () => Imagery_default,
    ImageryLayer: () => ImageryLayer_default,
    ImageryLayerCollection: () => ImageryLayerCollection_default,
    ImageryLayerFeatureInfo: () => ImageryLayerFeatureInfo_default,
    ImageryProvider: () => ImageryProvider_default,
    ImageryState: () => ImageryState_default,
    Implicit3DTileContent: () => Implicit3DTileContent_default,
    ImplicitAvailabilityBitstream: () => ImplicitAvailabilityBitstream_default,
    ImplicitMetadataView: () => ImplicitMetadataView_default,
    ImplicitSubdivisionScheme: () => ImplicitSubdivisionScheme_default,
    ImplicitSubtree: () => ImplicitSubtree_default,
    ImplicitSubtreeMetadata: () => ImplicitSubtreeMetadata_default,
    ImplicitTileCoordinates: () => ImplicitTileCoordinates_default,
    ImplicitTileset: () => ImplicitTileset_default,
    IndexDatatype: () => IndexDatatype_default,
    InfoBox: () => InfoBox_default,
    InfoBoxViewModel: () => InfoBoxViewModel_default,
    InspectorShared: () => InspectorShared_default,
    InstanceAttributeSemantic: () => InstanceAttributeSemantic_default,
    InstancingPipelineStage: () => InstancingPipelineStage_default,
    InterpolationAlgorithm: () => InterpolationAlgorithm_default,
    InterpolationType: () => InterpolationType_default,
    Intersect: () => Intersect_default,
    IntersectionTests: () => IntersectionTests_default,
    Intersections2D: () => Intersections2D_default,
    Interval: () => Interval_default,
    InvertClassification: () => InvertClassification_default,
    Ion: () => Ion_default,
    IonGeocoderService: () => IonGeocoderService_default,
    IonImageryProvider: () => IonImageryProvider_default,
    IonResource: () => IonResource_default,
    IonWorldImageryStyle: () => IonWorldImageryStyle_default,
    Iso8601: () => Iso8601_default,
    JobScheduler: () => JobScheduler_default,
    JobType: () => JobType_default,
    JsonMetadataTable: () => JsonMetadataTable_default,
    JulianDate: () => JulianDate_default,
    KTX2Transcoder: () => KTX2Transcoder_default,
    KeyboardEventModifier: () => KeyboardEventModifier_default,
    KmlCamera: () => KmlCamera_default,
    KmlDataSource: () => KmlDataSource_default,
    KmlLookAt: () => KmlLookAt_default,
    KmlTour: () => KmlTour_default,
    KmlTourFlyTo: () => KmlTourFlyTo_default,
    KmlTourWait: () => KmlTourWait_default,
    Label: () => Label_default,
    LabelCollection: () => LabelCollection_default,
    LabelGraphics: () => LabelGraphics_default,
    LabelStyle: () => LabelStyle_default,
    LabelVisualizer: () => LabelVisualizer_default,
    LagrangePolynomialApproximation: () => LagrangePolynomialApproximation_default,
    LeapSecond: () => LeapSecond_default,
    Light: () => Light_default,
    LightingModel: () => LightingModel_default,
    LightingPipelineStage: () => LightingPipelineStage_default,
    LinearApproximation: () => LinearApproximation_default,
    LinearSpline: () => LinearSpline_default,
    ManagedArray: () => ManagedArray_default,
    MapMode2D: () => MapMode2D_default,
    MapProjection: () => MapProjection_default,
    MapboxImageryProvider: () => MapboxImageryProvider_default,
    MapboxStyleImageryProvider: () => MapboxStyleImageryProvider_default,
    Material: () => Material_default,
    MaterialAppearance: () => MaterialAppearance_default,
    MaterialPipelineStage: () => MaterialPipelineStage_default,
    MaterialProperty: () => MaterialProperty_default,
    Math: () => Math_default,
    Matrix2: () => Matrix2_default,
    Matrix3: () => Matrix3_default,
    Matrix4: () => Matrix4_default,
    MetadataClass: () => MetadataClass_default,
    MetadataClassProperty: () => MetadataClassProperty_default,
    MetadataComponentType: () => MetadataComponentType_default,
    MetadataEntity: () => MetadataEntity_default,
    MetadataEnum: () => MetadataEnum_default,
    MetadataEnumValue: () => MetadataEnumValue_default,
    MetadataPipelineStage: () => MetadataPipelineStage_default,
    MetadataSchema: () => MetadataSchema_default,
    MetadataSchemaLoader: () => MetadataSchemaLoader_default,
    MetadataSemantic: () => MetadataSemantic_default,
    MetadataTable: () => MetadataTable_default,
    MetadataTableProperty: () => MetadataTableProperty_default,
    MetadataType: () => MetadataType_default,
    MipmapHint: () => MipmapHint_default,
    Model: () => Model_default,
    Model3DTileContent: () => Model3DTileContent_default,
    ModelAlphaOptions: () => ModelAlphaOptions_default,
    ModelAnimation: () => ModelAnimation_default,
    ModelAnimationChannel: () => ModelAnimationChannel_default,
    ModelAnimationCollection: () => ModelAnimationCollection_default,
    ModelAnimationLoop: () => ModelAnimationLoop_default,
    ModelAnimationState: () => ModelAnimationState_default,
    ModelArticulation: () => ModelArticulation_default,
    ModelArticulationStage: () => ModelArticulationStage_default,
    ModelClippingPlanesPipelineStage: () => ModelClippingPlanesPipelineStage_default,
    ModelColorPipelineStage: () => ModelColorPipelineStage_default,
    ModelComponents: () => ModelComponents_default,
    ModelDrawCommand: () => ModelDrawCommand_default,
    ModelFeature: () => ModelFeature_default,
    ModelFeatureTable: () => ModelFeatureTable_default,
    ModelGraphics: () => ModelGraphics_default,
    ModelLightingOptions: () => ModelLightingOptions_default,
    ModelMatrixUpdateStage: () => ModelMatrixUpdateStage_default,
    ModelNode: () => ModelNode_default,
    ModelRenderResources: () => ModelRenderResources_default,
    ModelRuntimeNode: () => ModelRuntimeNode_default,
    ModelRuntimePrimitive: () => ModelRuntimePrimitive_default,
    ModelSceneGraph: () => ModelSceneGraph_default,
    ModelSilhouettePipelineStage: () => ModelSilhouettePipelineStage_default,
    ModelSkin: () => ModelSkin_default,
    ModelSplitterPipelineStage: () => ModelSplitterPipelineStage_default,
    ModelStatistics: () => ModelStatistics_default,
    ModelType: () => ModelType_default,
    ModelUtility: () => ModelUtility_default,
    ModelVisualizer: () => ModelVisualizer_default,
    Moon: () => Moon_default,
    MorphTargetsPipelineStage: () => MorphTargetsPipelineStage_default,
    MorphWeightSpline: () => MorphWeightSpline_default,
    MortonOrder: () => MortonOrder_default,
    Multiple3DTileContent: () => Multiple3DTileContent_default,
    MultisampleFramebuffer: () => MultisampleFramebuffer_default,
    NavigationHelpButton: () => NavigationHelpButton_default,
    NavigationHelpButtonViewModel: () => NavigationHelpButtonViewModel_default,
    NearFarScalar: () => NearFarScalar_default,
    NeverTileDiscardPolicy: () => NeverTileDiscardPolicy_default,
    NodeRenderResources: () => NodeRenderResources_default,
    NodeStatisticsPipelineStage: () => NodeStatisticsPipelineStage_default,
    NodeTransformationProperty: () => NodeTransformationProperty_default,
    OIT: () => OIT_default,
    Occluder: () => Occluder_default,
    OctahedralProjectedCubeMap: () => OctahedralProjectedCubeMap_default,
    OffsetGeometryInstanceAttribute: () => OffsetGeometryInstanceAttribute_default,
    OpenCageGeocoderService: () => OpenCageGeocoderService_default,
    OpenStreetMapImageryProvider: () => OpenStreetMapImageryProvider_default,
    OrderedGroundPrimitiveCollection: () => OrderedGroundPrimitiveCollection_default,
    OrientedBoundingBox: () => OrientedBoundingBox_default,
    OrthographicFrustum: () => OrthographicFrustum_default,
    OrthographicOffCenterFrustum: () => OrthographicOffCenterFrustum_default,
    Packable: () => Packable_default,
    PackableForInterpolation: () => PackableForInterpolation_default,
    Particle: () => Particle_default,
    ParticleBurst: () => ParticleBurst_default,
    ParticleEmitter: () => ParticleEmitter_default,
    ParticleSystem: () => ParticleSystem_default,
    Pass: () => Pass_default,
    PassState: () => PassState_default,
    PathGraphics: () => PathGraphics_default,
    PathVisualizer: () => PathVisualizer_default,
    PeliasGeocoderService: () => PeliasGeocoderService_default,
    PerInstanceColorAppearance: () => PerInstanceColorAppearance_default,
    PerformanceDisplay: () => PerformanceDisplay_default,
    PerformanceWatchdog: () => PerformanceWatchdog_default,
    PerformanceWatchdogViewModel: () => PerformanceWatchdogViewModel_default,
    PerspectiveFrustum: () => PerspectiveFrustum_default,
    PerspectiveOffCenterFrustum: () => PerspectiveOffCenterFrustum_default,
    PickDepth: () => PickDepth_default,
    PickDepthFramebuffer: () => PickDepthFramebuffer_default,
    PickFramebuffer: () => PickFramebuffer_default,
    Picking: () => Picking_default,
    PickingPipelineStage: () => PickingPipelineStage_default,
    PinBuilder: () => PinBuilder_default,
    PixelDatatype: () => PixelDatatype_default,
    PixelFormat: () => PixelFormat_default,
    Plane: () => Plane_default,
    PlaneGeometry: () => PlaneGeometry_default,
    PlaneGeometryUpdater: () => PlaneGeometryUpdater_default,
    PlaneGraphics: () => PlaneGraphics_default,
    PlaneOutlineGeometry: () => PlaneOutlineGeometry_default,
    PntsLoader: () => PntsLoader_default,
    PntsParser: () => PntsParser_default,
    PointCloud: () => PointCloud_default,
    PointCloudEyeDomeLighting: () => PointCloudEyeDomeLighting_default2,
    PointCloudShading: () => PointCloudShading_default,
    PointCloudStylingPipelineStage: () => PointCloudStylingPipelineStage_default,
    PointGraphics: () => PointGraphics_default,
    PointPrimitive: () => PointPrimitive_default,
    PointPrimitiveCollection: () => PointPrimitiveCollection_default,
    PointVisualizer: () => PointVisualizer_default,
    PolygonGeometry: () => PolygonGeometry_default,
    PolygonGeometryLibrary: () => PolygonGeometryLibrary_default,
    PolygonGeometryUpdater: () => PolygonGeometryUpdater_default,
    PolygonGraphics: () => PolygonGraphics_default,
    PolygonHierarchy: () => PolygonHierarchy_default,
    PolygonOutlineGeometry: () => PolygonOutlineGeometry_default,
    PolygonPipeline: () => PolygonPipeline_default,
    Polyline: () => Polyline_default,
    PolylineArrowMaterialProperty: () => PolylineArrowMaterialProperty_default,
    PolylineCollection: () => PolylineCollection_default,
    PolylineColorAppearance: () => PolylineColorAppearance_default,
    PolylineDashMaterialProperty: () => PolylineDashMaterialProperty_default,
    PolylineGeometry: () => PolylineGeometry_default,
    PolylineGeometryUpdater: () => PolylineGeometryUpdater_default,
    PolylineGlowMaterialProperty: () => PolylineGlowMaterialProperty_default,
    PolylineGraphics: () => PolylineGraphics_default,
    PolylineMaterialAppearance: () => PolylineMaterialAppearance_default,
    PolylineOutlineMaterialProperty: () => PolylineOutlineMaterialProperty_default,
    PolylinePipeline: () => PolylinePipeline_default,
    PolylineVisualizer: () => PolylineVisualizer_default,
    PolylineVolumeGeometry: () => PolylineVolumeGeometry_default,
    PolylineVolumeGeometryLibrary: () => PolylineVolumeGeometryLibrary_default,
    PolylineVolumeGeometryUpdater: () => PolylineVolumeGeometryUpdater_default,
    PolylineVolumeGraphics: () => PolylineVolumeGraphics_default,
    PolylineVolumeOutlineGeometry: () => PolylineVolumeOutlineGeometry_default,
    PositionProperty: () => PositionProperty_default,
    PositionPropertyArray: () => PositionPropertyArray_default,
    PostProcessStage: () => PostProcessStage_default,
    PostProcessStageCollection: () => PostProcessStageCollection_default,
    PostProcessStageComposite: () => PostProcessStageComposite_default,
    PostProcessStageLibrary: () => PostProcessStageLibrary_default,
    PostProcessStageSampleMode: () => PostProcessStageSampleMode_default,
    PostProcessStageTextureCache: () => PostProcessStageTextureCache_default,
    Primitive: () => Primitive_default,
    PrimitiveCollection: () => PrimitiveCollection_default,
    PrimitiveLoadPlan: () => PrimitiveLoadPlan_default,
    PrimitiveOutlineGenerator: () => PrimitiveOutlineGenerator_default,
    PrimitiveOutlinePipelineStage: () => PrimitiveOutlinePipelineStage_default,
    PrimitivePipeline: () => PrimitivePipeline_default,
    PrimitiveRenderResources: () => PrimitiveRenderResources_default,
    PrimitiveState: () => PrimitiveState_default,
    PrimitiveStatisticsPipelineStage: () => PrimitiveStatisticsPipelineStage_default,
    PrimitiveType: () => PrimitiveType_default,
    ProjectionPicker: () => ProjectionPicker_default,
    ProjectionPickerViewModel: () => ProjectionPickerViewModel_default,
    Property: () => Property_default,
    PropertyArray: () => PropertyArray_default,
    PropertyAttribute: () => PropertyAttribute_default,
    PropertyAttributeProperty: () => PropertyAttributeProperty_default,
    PropertyBag: () => PropertyBag_default,
    PropertyTable: () => PropertyTable_default,
    PropertyTexture: () => PropertyTexture_default,
    PropertyTextureProperty: () => PropertyTextureProperty_default,
    ProviderViewModel: () => ProviderViewModel_default,
    Proxy: () => Proxy_default,
    QuadraticRealPolynomial: () => QuadraticRealPolynomial_default,
    QuadtreeOccluders: () => QuadtreeOccluders_default,
    QuadtreePrimitive: () => QuadtreePrimitive_default,
    QuadtreeTile: () => QuadtreeTile_default,
    QuadtreeTileLoadState: () => QuadtreeTileLoadState_default,
    QuadtreeTileProvider: () => QuadtreeTileProvider_default,
    QuantizedMeshTerrainData: () => QuantizedMeshTerrainData_default,
    QuarticRealPolynomial: () => QuarticRealPolynomial_default,
    Quaternion: () => Quaternion_default,
    QuaternionSpline: () => QuaternionSpline_default,
    Queue: () => Queue_default,
    Ray: () => Ray_default,
    Rectangle: () => Rectangle_default,
    RectangleCollisionChecker: () => RectangleCollisionChecker_default,
    RectangleGeometry: () => RectangleGeometry_default,
    RectangleGeometryLibrary: () => RectangleGeometryLibrary_default,
    RectangleGeometryUpdater: () => RectangleGeometryUpdater_default,
    RectangleGraphics: () => RectangleGraphics_default,
    RectangleOutlineGeometry: () => RectangleOutlineGeometry_default,
    ReferenceFrame: () => ReferenceFrame_default,
    ReferenceProperty: () => ReferenceProperty_default,
    RenderState: () => RenderState_default,
    Renderbuffer: () => Renderbuffer_default,
    RenderbufferFormat: () => RenderbufferFormat_default,
    Request: () => Request_default,
    RequestErrorEvent: () => RequestErrorEvent_default,
    RequestScheduler: () => RequestScheduler_default,
    RequestState: () => RequestState_default,
    RequestType: () => RequestType_default,
    Resource: () => Resource_default,
    ResourceCache: () => ResourceCache_default,
    ResourceCacheKey: () => ResourceCacheKey_default,
    ResourceCacheStatistics: () => ResourceCacheStatistics_default,
    ResourceLoader: () => ResourceLoader_default,
    ResourceLoaderState: () => ResourceLoaderState_default,
    Rotation: () => Rotation_default,
    RuntimeError: () => RuntimeError_default,
    S2Cell: () => S2Cell_default,
    SDFSettings: () => SDFSettings_default,
    SampledPositionProperty: () => SampledPositionProperty_default,
    SampledProperty: () => SampledProperty_default,
    Sampler: () => Sampler_default,
    ScaledPositionProperty: () => ScaledPositionProperty_default,
    Scene: () => Scene_default,
    SceneFramebuffer: () => SceneFramebuffer_default,
    SceneMode: () => SceneMode_default,
    SceneMode2DPipelineStage: () => SceneMode2DPipelineStage_default,
    SceneModePicker: () => SceneModePicker_default,
    SceneModePickerViewModel: () => SceneModePickerViewModel_default,
    SceneTransforms: () => SceneTransforms_default,
    SceneTransitioner: () => SceneTransitioner_default,
    ScreenSpaceCameraController: () => ScreenSpaceCameraController_default,
    ScreenSpaceEventHandler: () => ScreenSpaceEventHandler_default,
    ScreenSpaceEventType: () => ScreenSpaceEventType_default,
    SelectedFeatureIdPipelineStage: () => SelectedFeatureIdPipelineStage_default,
    SelectionIndicator: () => SelectionIndicator_default,
    SelectionIndicatorViewModel: () => SelectionIndicatorViewModel_default,
    ShaderBuilder: () => ShaderBuilder_default,
    ShaderCache: () => ShaderCache_default,
    ShaderDestination: () => ShaderDestination_default,
    ShaderFunction: () => ShaderFunction_default,
    ShaderProgram: () => ShaderProgram_default,
    ShaderSource: () => ShaderSource_default,
    ShaderStruct: () => ShaderStruct_default,
    ShadowMap: () => ShadowMap_default,
    ShadowMapShader: () => ShadowMapShader_default,
    ShadowMode: () => ShadowMode_default,
    ShadowVolumeAppearance: () => ShadowVolumeAppearance_default,
    ShowGeometryInstanceAttribute: () => ShowGeometryInstanceAttribute_default,
    Simon1994PlanetaryPositions: () => Simon1994PlanetaryPositions_default,
    SimplePolylineGeometry: () => SimplePolylineGeometry_default,
    SingleTileImageryProvider: () => SingleTileImageryProvider_default,
    SkinningPipelineStage: () => SkinningPipelineStage_default,
    SkyAtmosphere: () => SkyAtmosphere_default,
    SkyBox: () => SkyBox_default,
    SphereEmitter: () => SphereEmitter_default,
    SphereGeometry: () => SphereGeometry_default,
    SphereOutlineGeometry: () => SphereOutlineGeometry_default,
    Spherical: () => Spherical_default,
    Spline: () => Spline_default,
    SplitDirection: () => SplitDirection_default,
    Splitter: () => Splitter_default,
    StaticGeometryColorBatch: () => StaticGeometryColorBatch_default,
    StaticGeometryPerMaterialBatch: () => StaticGeometryPerMaterialBatch_default,
    StaticGroundGeometryColorBatch: () => StaticGroundGeometryColorBatch_default,
    StaticGroundGeometryPerMaterialBatch: () => StaticGroundGeometryPerMaterialBatch_default,
    StaticGroundPolylinePerMaterialBatch: () => StaticGroundPolylinePerMaterialBatch_default,
    StaticOutlineGeometryBatch: () => StaticOutlineGeometryBatch_default,
    StencilConstants: () => StencilConstants_default,
    StencilFunction: () => StencilFunction_default,
    StencilOperation: () => StencilOperation_default,
    SteppedSpline: () => SteppedSpline_default,
    StripeMaterialProperty: () => StripeMaterialProperty_default,
    StripeOrientation: () => StripeOrientation_default,
    StructuralMetadata: () => StructuralMetadata_default,
    StyleCommandsNeeded: () => StyleCommandsNeeded_default,
    StyleExpression: () => StyleExpression_default,
    Sun: () => Sun_default,
    SunLight: () => SunLight_default,
    SunPostProcess: () => SunPostProcess_default,
    SupportedImageFormats: () => SupportedImageFormats_default,
    SvgPathBindingHandler: () => SvgPathBindingHandler_default,
    TaskProcessor: () => TaskProcessor_default,
    TerrainData: () => TerrainData_default,
    TerrainEncoding: () => TerrainEncoding_default,
    TerrainExaggeration: () => TerrainExaggeration_default,
    TerrainFillMesh: () => TerrainFillMesh_default,
    TerrainMesh: () => TerrainMesh_default,
    TerrainOffsetProperty: () => TerrainOffsetProperty_default,
    TerrainProvider: () => TerrainProvider_default,
    TerrainQuantization: () => TerrainQuantization_default,
    TerrainState: () => TerrainState_default,
    Texture: () => Texture_default,
    TextureAtlas: () => TextureAtlas_default,
    TextureCache: () => TextureCache_default,
    TextureMagnificationFilter: () => TextureMagnificationFilter_default,
    TextureManager: () => TextureManager_default,
    TextureMinificationFilter: () => TextureMinificationFilter_default,
    TextureUniform: () => TextureUniform_default,
    TextureWrap: () => TextureWrap_default,
    TileAvailability: () => TileAvailability_default,
    TileBoundingRegion: () => TileBoundingRegion_default,
    TileBoundingS2Cell: () => TileBoundingS2Cell_default,
    TileBoundingSphere: () => TileBoundingSphere_default,
    TileBoundingVolume: () => TileBoundingVolume_default,
    TileCoordinatesImageryProvider: () => TileCoordinatesImageryProvider_default,
    TileDiscardPolicy: () => TileDiscardPolicy_default,
    TileEdge: () => TileEdge_default,
    TileImagery: () => TileImagery_default,
    TileMapServiceImageryProvider: () => TileMapServiceImageryProvider_default,
    TileMetadata: () => TileMetadata_default,
    TileOrientedBoundingBox: () => TileOrientedBoundingBox_default,
    TileProviderError: () => TileProviderError_default,
    TileReplacementQueue: () => TileReplacementQueue_default,
    TileSelectionResult: () => TileSelectionResult_default,
    TileState: () => TileState_default,
    Tileset3DTileContent: () => Tileset3DTileContent_default,
    TilesetMetadata: () => TilesetMetadata_default,
    TilesetPipelineStage: () => TilesetPipelineStage_default,
    TilingScheme: () => TilingScheme_default,
    TimeConstants: () => TimeConstants_default,
    TimeDynamicImagery: () => TimeDynamicImagery_default,
    TimeDynamicPointCloud: () => TimeDynamicPointCloud_default,
    TimeInterval: () => TimeInterval_default,
    TimeIntervalCollection: () => TimeIntervalCollection_default,
    TimeIntervalCollectionPositionProperty: () => TimeIntervalCollectionPositionProperty_default,
    TimeIntervalCollectionProperty: () => TimeIntervalCollectionProperty_default,
    TimeStandard: () => TimeStandard_default,
    Timeline: () => Timeline_default,
    TimelineHighlightRange: () => TimelineHighlightRange_default,
    TimelineTrack: () => TimelineTrack_default,
    Tipsify: () => Tipsify_default,
    ToggleButtonViewModel: () => ToggleButtonViewModel_default,
    Tonemapper: () => Tonemapper_default,
    Transforms: () => Transforms_default,
    TranslationRotationScale: () => TranslationRotationScale_default,
    TranslucentTileClassification: () => TranslucentTileClassification_default,
    TridiagonalSystemSolver: () => TridiagonalSystemSolver_default,
    TrustedServers: () => TrustedServers_default,
    TweenCollection: () => TweenCollection_default,
    UniformState: () => UniformState_default,
    UniformType: () => UniformType_default,
    UrlTemplateImageryProvider: () => UrlTemplateImageryProvider_default,
    VERSION: () => VERSION,
    VRButton: () => VRButton_default,
    VRButtonViewModel: () => VRButtonViewModel_default,
    VRTheWorldTerrainProvider: () => VRTheWorldTerrainProvider_default,
    VaryingType: () => VaryingType_default,
    Vector3DTileBatch: () => Vector3DTileBatch_default,
    Vector3DTileClampedPolylines: () => Vector3DTileClampedPolylines_default,
    Vector3DTileContent: () => Vector3DTileContent_default,
    Vector3DTileGeometry: () => Vector3DTileGeometry_default,
    Vector3DTilePoints: () => Vector3DTilePoints_default,
    Vector3DTilePolygons: () => Vector3DTilePolygons_default,
    Vector3DTilePolylines: () => Vector3DTilePolylines_default,
    Vector3DTilePrimitive: () => Vector3DTilePrimitive_default,
    VelocityOrientationProperty: () => VelocityOrientationProperty_default,
    VelocityVectorProperty: () => VelocityVectorProperty_default,
    VertexArray: () => VertexArray_default,
    VertexArrayFacade: () => VertexArrayFacade_default,
    VertexAttributeSemantic: () => VertexAttributeSemantic_default,
    VertexFormat: () => VertexFormat_default,
    VerticalOrigin: () => VerticalOrigin_default,
    VideoSynchronizer: () => VideoSynchronizer_default,
    View: () => View_default,
    Viewer: () => Viewer_default,
    ViewportQuad: () => ViewportQuad_default,
    Visibility: () => Visibility_default,
    Visualizer: () => Visualizer_default,
    VulkanConstants: () => VulkanConstants_default,
    WallGeometry: () => WallGeometry_default,
    WallGeometryLibrary: () => WallGeometryLibrary_default,
    WallGeometryUpdater: () => WallGeometryUpdater_default,
    WallGraphics: () => WallGraphics_default,
    WallOutlineGeometry: () => WallOutlineGeometry_default,
    WebGLConstants: () => WebGLConstants_default,
    WebMapServiceImageryProvider: () => WebMapServiceImageryProvider_default,
    WebMapTileServiceImageryProvider: () => WebMapTileServiceImageryProvider_default,
    WebMercatorProjection: () => WebMercatorProjection_default,
    WebMercatorTilingScheme: () => WebMercatorTilingScheme_default,
    WindingOrder: () => WindingOrder_default,
    WireframeIndexGenerator: () => WireframeIndexGenerator_default,
    WireframePipelineStage: () => WireframePipelineStage_default,
    _shadersAcesTonemappingStage: () => AcesTonemappingStage_default,
    _shadersAdditiveBlend: () => AdditiveBlend_default,
    _shadersAdjustTranslucentFS: () => AdjustTranslucentFS_default,
    _shadersAllMaterialAppearanceFS: () => AllMaterialAppearanceFS_default,
    _shadersAllMaterialAppearanceVS: () => AllMaterialAppearanceVS_default,
    _shadersAmbientOcclusionGenerate: () => AmbientOcclusionGenerate_default,
    _shadersAmbientOcclusionModulate: () => AmbientOcclusionModulate_default,
    _shadersAspectRampMaterial: () => AspectRampMaterial_default,
    _shadersAtmosphereCommon: () => AtmosphereCommon_default,
    _shadersBasicMaterialAppearanceFS: () => BasicMaterialAppearanceFS_default,
    _shadersBasicMaterialAppearanceVS: () => BasicMaterialAppearanceVS_default,
    _shadersBillboardCollectionFS: () => BillboardCollectionFS_default,
    _shadersBillboardCollectionVS: () => BillboardCollectionVS_default,
    _shadersBlackAndWhite: () => BlackAndWhite_default,
    _shadersBloomComposite: () => BloomComposite_default,
    _shadersBrdfLutGeneratorFS: () => BrdfLutGeneratorFS_default,
    _shadersBrightPass: () => BrightPass_default,
    _shadersBrightness: () => Brightness_default,
    _shadersBumpMapMaterial: () => BumpMapMaterial_default,
    _shadersCPUStylingStageFS: () => CPUStylingStageFS_default,
    _shadersCPUStylingStageVS: () => CPUStylingStageVS_default,
    _shadersCheckerboardMaterial: () => CheckerboardMaterial_default,
    _shadersCloudCollectionFS: () => CloudCollectionFS_default,
    _shadersCloudCollectionVS: () => CloudCollectionVS_default,
    _shadersCloudNoiseFS: () => CloudNoiseFS_default,
    _shadersCloudNoiseVS: () => CloudNoiseVS_default,
    _shadersCompareAndPackTranslucentDepth: () => CompareAndPackTranslucentDepth_default,
    _shadersCompositeOITFS: () => CompositeOITFS_default,
    _shadersCompositeTranslucentClassification: () => CompositeTranslucentClassification_default,
    _shadersContrastBias: () => ContrastBias_default,
    _shadersCustomShaderStageFS: () => CustomShaderStageFS_default,
    _shadersCustomShaderStageVS: () => CustomShaderStageVS_default,
    _shadersCzmBuiltins: () => CzmBuiltins_default,
    _shadersDepthOfField: () => DepthOfField_default,
    _shadersDepthPlaneFS: () => DepthPlaneFS_default,
    _shadersDepthPlaneVS: () => DepthPlaneVS_default,
    _shadersDepthView: () => DepthView_default,
    _shadersDepthViewPacked: () => DepthViewPacked_default,
    _shadersDotMaterial: () => DotMaterial_default,
    _shadersEdgeDetection: () => EdgeDetection_default,
    _shadersElevationBandMaterial: () => ElevationBandMaterial_default,
    _shadersElevationContourMaterial: () => ElevationContourMaterial_default,
    _shadersElevationRampMaterial: () => ElevationRampMaterial_default,
    _shadersEllipsoidFS: () => EllipsoidFS_default,
    _shadersEllipsoidSurfaceAppearanceFS: () => EllipsoidSurfaceAppearanceFS_default,
    _shadersEllipsoidSurfaceAppearanceVS: () => EllipsoidSurfaceAppearanceVS_default,
    _shadersEllipsoidVS: () => EllipsoidVS_default,
    _shadersFXAA: () => FXAA_default,
    _shadersFXAA3_11: () => FXAA3_11_default,
    _shadersFadeMaterial: () => FadeMaterial_default,
    _shadersFeatureIdStageFS: () => FeatureIdStageFS_default,
    _shadersFeatureIdStageVS: () => FeatureIdStageVS_default,
    _shadersFilmicTonemapping: () => FilmicTonemapping_default,
    _shadersGaussianBlur1D: () => GaussianBlur1D_default,
    _shadersGeometryStageFS: () => GeometryStageFS_default,
    _shadersGeometryStageVS: () => GeometryStageVS_default,
    _shadersGlobeFS: () => GlobeFS_default,
    _shadersGlobeVS: () => GlobeVS_default,
    _shadersGridMaterial: () => GridMaterial_default,
    _shadersGroundAtmosphere: () => GroundAtmosphere_default,
    _shadersHSBToRGB: () => HSBToRGB_default,
    _shadersHSLToRGB: () => HSLToRGB_default,
    _shadersImageBasedLightingStageFS: () => ImageBasedLightingStageFS_default,
    _shadersInstancingStageCommon: () => InstancingStageCommon_default,
    _shadersInstancingStageVS: () => InstancingStageVS_default,
    _shadersLegacyInstancingStageVS: () => LegacyInstancingStageVS_default,
    _shadersLensFlare: () => LensFlare_default,
    _shadersLightingStageFS: () => LightingStageFS_default,
    _shadersMaterialStageFS: () => MaterialStageFS_default,
    _shadersMetadataStageFS: () => MetadataStageFS_default,
    _shadersMetadataStageVS: () => MetadataStageVS_default,
    _shadersModelClippingPlanesStageFS: () => ModelClippingPlanesStageFS_default,
    _shadersModelColorStageFS: () => ModelColorStageFS_default,
    _shadersModelFS: () => ModelFS_default,
    _shadersModelSilhouetteStageFS: () => ModelSilhouetteStageFS_default,
    _shadersModelSilhouetteStageVS: () => ModelSilhouetteStageVS_default,
    _shadersModelSplitterStageFS: () => ModelSplitterStageFS_default,
    _shadersModelVS: () => ModelVS_default,
    _shadersModifiedReinhardTonemapping: () => ModifiedReinhardTonemapping_default,
    _shadersMorphTargetsStageVS: () => MorphTargetsStageVS_default,
    _shadersNightVision: () => NightVision_default,
    _shadersNormalMapMaterial: () => NormalMapMaterial_default,
    _shadersOctahedralProjectionAtlasFS: () => OctahedralProjectionAtlasFS_default,
    _shadersOctahedralProjectionFS: () => OctahedralProjectionFS_default,
    _shadersOctahedralProjectionVS: () => OctahedralProjectionVS_default,
    _shadersPassThrough: () => PassThrough_default,
    _shadersPassThroughDepth: () => PassThroughDepth_default,
    _shadersPerInstanceColorAppearanceFS: () => PerInstanceColorAppearanceFS_default,
    _shadersPerInstanceColorAppearanceVS: () => PerInstanceColorAppearanceVS_default,
    _shadersPerInstanceFlatColorAppearanceFS: () => PerInstanceFlatColorAppearanceFS_default,
    _shadersPerInstanceFlatColorAppearanceVS: () => PerInstanceFlatColorAppearanceVS_default,
    _shadersPointCloudEyeDomeLighting: () => PointCloudEyeDomeLighting_default,
    _shadersPointCloudStylingStageVS: () => PointCloudStylingStageVS_default,
    _shadersPointPrimitiveCollectionFS: () => PointPrimitiveCollectionFS_default,
    _shadersPointPrimitiveCollectionVS: () => PointPrimitiveCollectionVS_default,
    _shadersPolylineArrowMaterial: () => PolylineArrowMaterial_default,
    _shadersPolylineColorAppearanceVS: () => PolylineColorAppearanceVS_default,
    _shadersPolylineCommon: () => PolylineCommon_default,
    _shadersPolylineDashMaterial: () => PolylineDashMaterial_default,
    _shadersPolylineFS: () => PolylineFS_default,
    _shadersPolylineGlowMaterial: () => PolylineGlowMaterial_default,
    _shadersPolylineMaterialAppearanceVS: () => PolylineMaterialAppearanceVS_default,
    _shadersPolylineOutlineMaterial: () => PolylineOutlineMaterial_default,
    _shadersPolylineShadowVolumeFS: () => PolylineShadowVolumeFS_default,
    _shadersPolylineShadowVolumeMorphFS: () => PolylineShadowVolumeMorphFS_default,
    _shadersPolylineShadowVolumeMorphVS: () => PolylineShadowVolumeMorphVS_default,
    _shadersPolylineShadowVolumeVS: () => PolylineShadowVolumeVS_default,
    _shadersPolylineVS: () => PolylineVS_default,
    _shadersPrimitiveOutlineStageFS: () => PrimitiveOutlineStageFS_default,
    _shadersPrimitiveOutlineStageVS: () => PrimitiveOutlineStageVS_default,
    _shadersRGBToHSB: () => RGBToHSB_default,
    _shadersRGBToHSL: () => RGBToHSL_default,
    _shadersRGBToXYZ: () => RGBToXYZ_default,
    _shadersReinhardTonemapping: () => ReinhardTonemapping_default,
    _shadersReprojectWebMercatorFS: () => ReprojectWebMercatorFS_default,
    _shadersReprojectWebMercatorVS: () => ReprojectWebMercatorVS_default,
    _shadersRimLightingMaterial: () => RimLightingMaterial_default,
    _shadersSelectedFeatureIdStageCommon: () => SelectedFeatureIdStageCommon_default,
    _shadersShadowVolumeAppearanceFS: () => ShadowVolumeAppearanceFS_default,
    _shadersShadowVolumeAppearanceVS: () => ShadowVolumeAppearanceVS_default,
    _shadersShadowVolumeFS: () => ShadowVolumeFS_default,
    _shadersSilhouette: () => Silhouette_default,
    _shadersSkinningStageVS: () => SkinningStageVS_default,
    _shadersSkyAtmosphereCommon: () => SkyAtmosphereCommon_default,
    _shadersSkyAtmosphereFS: () => SkyAtmosphereFS_default,
    _shadersSkyAtmosphereVS: () => SkyAtmosphereVS_default,
    _shadersSkyBoxFS: () => SkyBoxFS_default,
    _shadersSkyBoxVS: () => SkyBoxVS_default,
    _shadersSlopeRampMaterial: () => SlopeRampMaterial_default,
    _shadersStripeMaterial: () => StripeMaterial_default,
    _shadersSunFS: () => SunFS_default,
    _shadersSunTextureFS: () => SunTextureFS_default,
    _shadersSunVS: () => SunVS_default,
    _shadersTexturedMaterialAppearanceFS: () => TexturedMaterialAppearanceFS_default,
    _shadersTexturedMaterialAppearanceVS: () => TexturedMaterialAppearanceVS_default,
    _shadersVector3DTileClampedPolylinesFS: () => Vector3DTileClampedPolylinesFS_default,
    _shadersVector3DTileClampedPolylinesVS: () => Vector3DTileClampedPolylinesVS_default,
    _shadersVector3DTilePolylinesVS: () => Vector3DTilePolylinesVS_default,
    _shadersVectorTileVS: () => VectorTileVS_default,
    _shadersViewportQuadFS: () => ViewportQuadFS_default,
    _shadersViewportQuadVS: () => ViewportQuadVS_default,
    _shadersWater: () => Water_default,
    _shadersXYZToRGB: () => XYZToRGB_default,
    _shadersacesTonemapping: () => acesTonemapping_default,
    _shadersalphaWeight: () => alphaWeight_default,
    _shadersantialias: () => antialias_default,
    _shadersapproximateSphericalCoordinates: () => approximateSphericalCoordinates_default,
    _shadersbackFacing: () => backFacing_default,
    _shadersbranchFreeTernary: () => branchFreeTernary_default,
    _shaderscascadeColor: () => cascadeColor_default,
    _shaderscascadeDistance: () => cascadeDistance_default,
    _shaderscascadeMatrix: () => cascadeMatrix_default,
    _shaderscascadeWeights: () => cascadeWeights_default,
    _shaderscolumbusViewMorph: () => columbusViewMorph_default,
    _shaderscomputePosition: () => computePosition_default,
    _shaderscosineAndSine: () => cosineAndSine_default,
    _shadersdecompressTextureCoordinates: () => decompressTextureCoordinates_default,
    _shadersdefaultPbrMaterial: () => defaultPbrMaterial_default,
    _shadersdegreesPerRadian: () => degreesPerRadian_default,
    _shadersdepthClamp: () => depthClamp_default,
    _shadersdepthRange: () => depthRange_default,
    _shadersdepthRangeStruct: () => depthRangeStruct_default,
    _shaderseastNorthUpToEyeCoordinates: () => eastNorthUpToEyeCoordinates_default,
    _shadersellipsoidContainsPoint: () => ellipsoidContainsPoint_default,
    _shadersellipsoidWgs84TextureCoordinates: () => ellipsoidWgs84TextureCoordinates_default,
    _shadersepsilon1: () => epsilon1_default,
    _shadersepsilon2: () => epsilon2_default,
    _shadersepsilon3: () => epsilon3_default,
    _shadersepsilon4: () => epsilon4_default,
    _shadersepsilon5: () => epsilon5_default,
    _shadersepsilon6: () => epsilon6_default,
    _shadersepsilon7: () => epsilon7_default,
    _shadersequalsEpsilon: () => equalsEpsilon_default,
    _shaderseyeOffset: () => eyeOffset_default,
    _shaderseyeToWindowCoordinates: () => eyeToWindowCoordinates_default,
    _shadersfastApproximateAtan: () => fastApproximateAtan_default,
    _shadersfog: () => fog_default,
    _shadersgammaCorrect: () => gammaCorrect_default,
    _shadersgeodeticSurfaceNormal: () => geodeticSurfaceNormal_default,
    _shadersgetDefaultMaterial: () => getDefaultMaterial_default,
    _shadersgetLambertDiffuse: () => getLambertDiffuse_default,
    _shadersgetSpecular: () => getSpecular_default,
    _shadersgetWaterNoise: () => getWaterNoise_default,
    _shadershue: () => hue_default,
    _shadersinfinity: () => infinity_default,
    _shadersinverseGamma: () => inverseGamma_default,
    _shadersisEmpty: () => isEmpty_default,
    _shadersisFull: () => isFull_default,
    _shaderslatitudeToWebMercatorFraction: () => latitudeToWebMercatorFraction_default,
    _shaderslineDistance: () => lineDistance_default,
    _shaderslinearToSrgb: () => linearToSrgb_default,
    _shadersluminance: () => luminance_default,
    _shadersmaterial: () => material_default,
    _shadersmaterialInput: () => materialInput_default,
    _shadersmetersPerPixel: () => metersPerPixel_default,
    _shadersmodelMaterial: () => modelMaterial_default,
    _shadersmodelToWindowCoordinates: () => modelToWindowCoordinates_default,
    _shadersmodelVertexOutput: () => modelVertexOutput_default,
    _shadersmultiplyWithColorBalance: () => multiplyWithColorBalance_default,
    _shadersnearFarScalar: () => nearFarScalar_default,
    _shadersoctDecode: () => octDecode_default,
    _shadersoneOverPi: () => oneOverPi_default,
    _shadersoneOverTwoPi: () => oneOverTwoPi_default,
    _shaderspackDepth: () => packDepth_default,
    _shaderspassCesium3DTile: () => passCesium3DTile_default,
    _shaderspassCesium3DTileClassification: () => passCesium3DTileClassification_default,
    _shaderspassCesium3DTileClassificationIgnoreShow: () => passCesium3DTileClassificationIgnoreShow_default,
    _shaderspassClassification: () => passClassification_default,
    _shaderspassCompute: () => passCompute_default,
    _shaderspassEnvironment: () => passEnvironment_default,
    _shaderspassGlobe: () => passGlobe_default,
    _shaderspassOpaque: () => passOpaque_default,
    _shaderspassOverlay: () => passOverlay_default,
    _shaderspassTerrainClassification: () => passTerrainClassification_default,
    _shaderspassTranslucent: () => passTranslucent_default,
    _shaderspbrLighting: () => pbrLighting_default,
    _shaderspbrMetallicRoughnessMaterial: () => pbrMetallicRoughnessMaterial_default,
    _shaderspbrParameters: () => pbrParameters_default,
    _shaderspbrSpecularGlossinessMaterial: () => pbrSpecularGlossinessMaterial_default,
    _shadersphong: () => phong_default,
    _shaderspi: () => pi_default,
    _shaderspiOverFour: () => piOverFour_default,
    _shaderspiOverSix: () => piOverSix_default,
    _shaderspiOverThree: () => piOverThree_default,
    _shaderspiOverTwo: () => piOverTwo_default,
    _shadersplaneDistance: () => planeDistance_default,
    _shaderspointAlongRay: () => pointAlongRay_default,
    _shadersradiansPerDegree: () => radiansPerDegree_default,
    _shadersray: () => ray_default,
    _shadersrayEllipsoidIntersectionInterval: () => rayEllipsoidIntersectionInterval_default,
    _shadersraySegment: () => raySegment_default,
    _shadersraySphereIntersectionInterval: () => raySphereIntersectionInterval_default,
    _shadersreadDepth: () => readDepth_default,
    _shadersreadNonPerspective: () => readNonPerspective_default,
    _shadersreverseLogDepth: () => reverseLogDepth_default,
    _shadersround: () => round_default,
    _shaderssampleOctahedralProjection: () => sampleOctahedralProjection_default,
    _shaderssaturation: () => saturation_default,
    _shaderssceneMode2D: () => sceneMode2D_default,
    _shaderssceneMode3D: () => sceneMode3D_default,
    _shaderssceneModeColumbusView: () => sceneModeColumbusView_default,
    _shaderssceneModeMorphing: () => sceneModeMorphing_default,
    _shadersshadowDepthCompare: () => shadowDepthCompare_default,
    _shadersshadowParameters: () => shadowParameters_default,
    _shadersshadowVisibility: () => shadowVisibility_default,
    _shaderssignNotZero: () => signNotZero_default,
    _shaderssolarRadius: () => solarRadius_default,
    _shaderssphericalHarmonics: () => sphericalHarmonics_default,
    _shaderssrgbToLinear: () => srgbToLinear_default,
    _shaderstangentToEyeSpaceMatrix: () => tangentToEyeSpaceMatrix_default,
    _shadersthreePiOver2: () => threePiOver2_default,
    _shaderstransformPlane: () => transformPlane_default,
    _shaderstranslateRelativeToEye: () => translateRelativeToEye_default,
    _shaderstranslucentPhong: () => translucentPhong_default,
    _shaderstranspose: () => transpose_default,
    _shaderstwoPi: () => twoPi_default,
    _shadersunpackDepth: () => unpackDepth_default,
    _shadersunpackFloat: () => unpackFloat_default,
    _shadersunpackUint: () => unpackUint_default,
    _shadersvalueTransform: () => valueTransform_default,
    _shadersvertexLogDepth: () => vertexLogDepth_default,
    _shaderswebMercatorMaxLatitude: () => webMercatorMaxLatitude_default,
    _shaderswindowToEyeCoordinates: () => windowToEyeCoordinates_default,
    _shaderswriteDepthClamp: () => writeDepthClamp_default,
    _shaderswriteLogDepth: () => writeLogDepth_default,
    _shaderswriteNonPerspective: () => writeNonPerspective_default,
    addBuffer: () => addBuffer_default,
    addDefaults: () => addDefaults_default,
    addExtensionsRequired: () => addExtensionsRequired_default,
    addExtensionsUsed: () => addExtensionsUsed_default,
    addPipelineExtras: () => addPipelineExtras_default,
    addToArray: () => addToArray_default,
    appendForwardSlash: () => appendForwardSlash_default,
    arrayRemoveDuplicates: () => arrayRemoveDuplicates_default,
    barycentricCoordinates: () => barycentricCoordinates_default,
    binarySearch: () => binarySearch_default,
    buildDrawCommand: () => buildDrawCommand_default,
    buildModuleUrl: () => buildModuleUrl_default,
    clone: () => clone_default,
    combine: () => combine_default,
    computeFlyToLocationForRectangle: () => computeFlyToLocationForRectangle_default,
    createBillboardPointCallback: () => createBillboardPointCallback_default,
    createCommand: () => createCommand_default,
    createDefaultImageryProviderViewModels: () => createDefaultImageryProviderViewModels_default,
    createDefaultTerrainProviderViewModels: () => createDefaultTerrainProviderViewModels_default,
    createElevationBandMaterial: () => createElevationBandMaterial_default,
    createGuid: () => createGuid_default,
    createMaterialPropertyDescriptor: () => createMaterialPropertyDescriptor_default,
    createOsmBuildings: () => createOsmBuildings_default,
    createPropertyDescriptor: () => createPropertyDescriptor_default,
    createRawPropertyDescriptor: () => createRawPropertyDescriptor_default,
    createTangentSpaceDebugPrimitive: () => createTangentSpaceDebugPrimitive_default,
    createTaskProcessorWorker: () => createTaskProcessorWorker_default,
    createUniform: () => createUniform_default,
    createUniformArray: () => createUniformArray_default,
    createWorldImagery: () => createWorldImagery_default,
    createWorldTerrain: () => createWorldTerrain_default,
    decodeGoogleEarthEnterpriseData: () => decodeGoogleEarthEnterpriseData_default,
    decodeVectorPolylinePositions: () => decodeVectorPolylinePositions_default,
    defaultValue: () => defaultValue_default,
    defer: () => defer_default,
    defined: () => defined_default,
    deprecationWarning: () => deprecationWarning_default,
    destroyObject: () => destroyObject_default,
    exportKml: () => exportKml_default,
    findAccessorMinMax: () => findAccessorMinMax_default,
    findContentMetadata: () => findContentMetadata_default,
    findGroupMetadata: () => findGroupMetadata_default,
    findTileMetadata: () => findTileMetadata_default,
    forEachTextureInMaterial: () => forEachTextureInMaterial_default,
    formatError: () => formatError_default,
    freezeRenderState: () => freezeRenderState_default,
    getAbsoluteUri: () => getAbsoluteUri_default,
    getAccessorByteStride: () => getAccessorByteStride_default,
    getBaseUri: () => getBaseUri_default,
    getBinaryAccessor: () => getBinaryAccessor_default,
    getClipAndStyleCode: () => getClipAndStyleCode_default,
    getClippingFunction: () => getClippingFunction_default,
    getComponentReader: () => getComponentReader_default,
    getElement: () => getElement_default,
    getExtensionFromUri: () => getExtensionFromUri_default,
    getFilenameFromUri: () => getFilenameFromUri_default,
    getImageFromTypedArray: () => getImageFromTypedArray_default,
    getImagePixels: () => getImagePixels_default,
    getJsonFromTypedArray: () => getJsonFromTypedArray_default,
    getMagic: () => getMagic_default,
    getStringFromTypedArray: () => getStringFromTypedArray_default,
    getTimestamp: () => getTimestamp_default,
    hasExtension: () => hasExtension_default,
    heightReferenceOnEntityPropertyChanged: () => heightReferenceOnEntityPropertyChanged_default,
    isBitSet: () => isBitSet_default,
    isBlobUri: () => isBlobUri_default,
    isCrossOriginUrl: () => isCrossOriginUrl_default,
    isDataUri: () => isDataUri_default,
    isLeapYear: () => isLeapYear_default,
    knockout: () => knockout_default,
    knockout_3_5_1: () => knockout_3_5_1_default,
    knockout_es5: () => knockout_es5_default,
    loadAndExecuteScript: () => loadAndExecuteScript_default,
    loadCubeMap: () => loadCubeMap_default,
    loadImageFromTypedArray: () => loadImageFromTypedArray_default,
    loadKTX2: () => loadKTX2_default,
    mergeSort: () => mergeSort_default,
    modernizeShader: () => modernizeShader_default,
    moveTechniqueRenderStates: () => moveTechniqueRenderStates_default,
    moveTechniquesToExtension: () => moveTechniquesToExtension_default,
    numberOfComponentsForType: () => numberOfComponentsForType_default,
    objectToQuery: () => objectToQuery_default,
    oneTimeWarning: () => oneTimeWarning_default,
    parseBatchTable: () => parseBatchTable_default,
    parseBoundingVolumeSemantics: () => parseBoundingVolumeSemantics_default,
    parseFeatureMetadataLegacy: () => parseFeatureMetadataLegacy_default,
    parseGlb: () => parseGlb_default,
    parseResponseHeaders: () => parseResponseHeaders_default,
    parseStructuralMetadata: () => parseStructuralMetadata_default,
    pointInsideTriangle: () => pointInsideTriangle_default,
    preprocess3DTileContent: () => preprocess3DTileContent_default,
    queryToObject: () => queryToObject_default,
    readAccessorPacked: () => readAccessorPacked_default,
    removeExtension: () => removeExtension_default,
    removeExtensionsRequired: () => removeExtensionsRequired_default,
    removeExtensionsUsed: () => removeExtensionsUsed_default,
    removePipelineExtras: () => removePipelineExtras_default,
    removeUnusedElements: () => removeUnusedElements_default,
    resizeImageToNextPowerOfTwo: () => resizeImageToNextPowerOfTwo_default,
    sampleTerrain: () => sampleTerrain_default,
    sampleTerrainMostDetailed: () => sampleTerrainMostDetailed_default,
    scaleToGeodeticSurface: () => scaleToGeodeticSurface_default,
    subdivideArray: () => subdivideArray_default,
    subscribeAndEvaluate: () => subscribeAndEvaluate_default,
    updateAccessorComponentTypes: () => updateAccessorComponentTypes_default,
    updateVersion: () => updateVersion_default,
    usesExtension: () => usesExtension_default,
    viewerCesium3DTilesInspectorMixin: () => viewerCesium3DTilesInspectorMixin_default,
    viewerCesiumInspectorMixin: () => viewerCesiumInspectorMixin_default,
    viewerDragDropMixin: () => viewerDragDropMixin_default,
    viewerPerformanceWatchdogMixin: () => viewerPerformanceWatchdogMixin_default,
    webGLConstantToGlslType: () => webGLConstantToGlslType_default,
    wrapFunction: () => wrapFunction_default,
    writeTextToCanvas: () => writeTextToCanvas_default
  });

  // Source/Core/defined.js
  function defined(value) {
    return value !== void 0 && value !== null;
  }
  var defined_default = defined;

  // Source/Core/DeveloperError.js
  function DeveloperError(message) {
    this.name = "DeveloperError";
    this.message = message;
    let stack;
    try {
      throw new Error();
    } catch (e) {
      stack = e.stack;
    }
    this.stack = stack;
  }
  if (defined_default(Object.create)) {
    DeveloperError.prototype = Object.create(Error.prototype);
    DeveloperError.prototype.constructor = DeveloperError;
  }
  DeveloperError.prototype.toString = function() {
    let str = `${this.name}: ${this.message}`;
    if (defined_default(this.stack)) {
      str += `
${this.stack.toString()}`;
    }
    return str;
  };
  DeveloperError.throwInstantiationError = function() {
    throw new DeveloperError(
      "This function defines an interface and should not be called directly."
    );
  };
  var DeveloperError_default = DeveloperError;

  // Source/Core/Check.js
  var Check = {};
  Check.typeOf = {};
  function getUndefinedErrorMessage(name) {
    return `${name} is required, actual value was undefined`;
  }
  function getFailedTypeErrorMessage(actual, expected, name) {
    return `Expected ${name} to be typeof ${expected}, actual typeof was ${actual}`;
  }
  Check.defined = function(name, test) {
    if (!defined_default(test)) {
      throw new DeveloperError_default(getUndefinedErrorMessage(name));
    }
  };
  Check.typeOf.func = function(name, test) {
    if (typeof test !== "function") {
      throw new DeveloperError_default(
        getFailedTypeErrorMessage(typeof test, "function", name)
      );
    }
  };
  Check.typeOf.string = function(name, test) {
    if (typeof test !== "string") {
      throw new DeveloperError_default(
        getFailedTypeErrorMessage(typeof test, "string", name)
      );
    }
  };
  Check.typeOf.number = function(name, test) {
    if (typeof test !== "number") {
      throw new DeveloperError_default(
        getFailedTypeErrorMessage(typeof test, "number", name)
      );
    }
  };
  Check.typeOf.number.lessThan = function(name, test, limit) {
    Check.typeOf.number(name, test);
    if (test >= limit) {
      throw new DeveloperError_default(
        `Expected ${name} to be less than ${limit}, actual value was ${test}`
      );
    }
  };
  Check.typeOf.number.lessThanOrEquals = function(name, test, limit) {
    Check.typeOf.number(name, test);
    if (test > limit) {
      throw new DeveloperError_default(
        `Expected ${name} to be less than or equal to ${limit}, actual value was ${test}`
      );
    }
  };
  Check.typeOf.number.greaterThan = function(name, test, limit) {
    Check.typeOf.number(name, test);
    if (test <= limit) {
      throw new DeveloperError_default(
        `Expected ${name} to be greater than ${limit}, actual value was ${test}`
      );
    }
  };
  Check.typeOf.number.greaterThanOrEquals = function(name, test, limit) {
    Check.typeOf.number(name, test);
    if (test < limit) {
      throw new DeveloperError_default(
        `Expected ${name} to be greater than or equal to ${limit}, actual value was ${test}`
      );
    }
  };
  Check.typeOf.object = function(name, test) {
    if (typeof test !== "object") {
      throw new DeveloperError_default(
        getFailedTypeErrorMessage(typeof test, "object", name)
      );
    }
  };
  Check.typeOf.bool = function(name, test) {
    if (typeof test !== "boolean") {
      throw new DeveloperError_default(
        getFailedTypeErrorMessage(typeof test, "boolean", name)
      );
    }
  };
  Check.typeOf.bigint = function(name, test) {
    if (typeof test !== "bigint") {
      throw new DeveloperError_default(
        getFailedTypeErrorMessage(typeof test, "bigint", name)
      );
    }
  };
  Check.typeOf.number.equals = function(name1, name2, test1, test2) {
    Check.typeOf.number(name1, test1);
    Check.typeOf.number(name2, test2);
    if (test1 !== test2) {
      throw new DeveloperError_default(
        `${name1} must be equal to ${name2}, the actual values are ${test1} and ${test2}`
      );
    }
  };
  var Check_default = Check;

  // Source/Core/defaultValue.js
  function defaultValue(a3, b) {
    if (a3 !== void 0 && a3 !== null) {
      return a3;
    }
    return b;
  }
  defaultValue.EMPTY_OBJECT = Object.freeze({});
  var defaultValue_default = defaultValue;

  // Source/Core/Math.js
  var import_mersenne_twister = __toESM(require_mersenne_twister(), 1);
  var CesiumMath = {};
  CesiumMath.EPSILON1 = 0.1;
  CesiumMath.EPSILON2 = 0.01;
  CesiumMath.EPSILON3 = 1e-3;
  CesiumMath.EPSILON4 = 1e-4;
  CesiumMath.EPSILON5 = 1e-5;
  CesiumMath.EPSILON6 = 1e-6;
  CesiumMath.EPSILON7 = 1e-7;
  CesiumMath.EPSILON8 = 1e-8;
  CesiumMath.EPSILON9 = 1e-9;
  CesiumMath.EPSILON10 = 1e-10;
  CesiumMath.EPSILON11 = 1e-11;
  CesiumMath.EPSILON12 = 1e-12;
  CesiumMath.EPSILON13 = 1e-13;
  CesiumMath.EPSILON14 = 1e-14;
  CesiumMath.EPSILON15 = 1e-15;
  CesiumMath.EPSILON16 = 1e-16;
  CesiumMath.EPSILON17 = 1e-17;
  CesiumMath.EPSILON18 = 1e-18;
  CesiumMath.EPSILON19 = 1e-19;
  CesiumMath.EPSILON20 = 1e-20;
  CesiumMath.EPSILON21 = 1e-21;
  CesiumMath.GRAVITATIONALPARAMETER = 3986004418e5;
  CesiumMath.SOLAR_RADIUS = 6955e5;
  CesiumMath.LUNAR_RADIUS = 1737400;
  CesiumMath.SIXTY_FOUR_KILOBYTES = 64 * 1024;
  CesiumMath.FOUR_GIGABYTES = 4 * 1024 * 1024 * 1024;
  CesiumMath.sign = defaultValue_default(Math.sign, function sign(value) {
    value = +value;
    if (value === 0 || value !== value) {
      return value;
    }
    return value > 0 ? 1 : -1;
  });
  CesiumMath.signNotZero = function(value) {
    return value < 0 ? -1 : 1;
  };
  CesiumMath.toSNorm = function(value, rangeMaximum) {
    rangeMaximum = defaultValue_default(rangeMaximum, 255);
    return Math.round(
      (CesiumMath.clamp(value, -1, 1) * 0.5 + 0.5) * rangeMaximum
    );
  };
  CesiumMath.fromSNorm = function(value, rangeMaximum) {
    rangeMaximum = defaultValue_default(rangeMaximum, 255);
    return CesiumMath.clamp(value, 0, rangeMaximum) / rangeMaximum * 2 - 1;
  };
  CesiumMath.normalize = function(value, rangeMinimum, rangeMaximum) {
    rangeMaximum = Math.max(rangeMaximum - rangeMinimum, 0);
    return rangeMaximum === 0 ? 0 : CesiumMath.clamp((value - rangeMinimum) / rangeMaximum, 0, 1);
  };
  CesiumMath.sinh = defaultValue_default(Math.sinh, function sinh(value) {
    return (Math.exp(value) - Math.exp(-value)) / 2;
  });
  CesiumMath.cosh = defaultValue_default(Math.cosh, function cosh(value) {
    return (Math.exp(value) + Math.exp(-value)) / 2;
  });
  CesiumMath.lerp = function(p, q, time) {
    return (1 - time) * p + time * q;
  };
  CesiumMath.PI = Math.PI;
  CesiumMath.ONE_OVER_PI = 1 / Math.PI;
  CesiumMath.PI_OVER_TWO = Math.PI / 2;
  CesiumMath.PI_OVER_THREE = Math.PI / 3;
  CesiumMath.PI_OVER_FOUR = Math.PI / 4;
  CesiumMath.PI_OVER_SIX = Math.PI / 6;
  CesiumMath.THREE_PI_OVER_TWO = 3 * Math.PI / 2;
  CesiumMath.TWO_PI = 2 * Math.PI;
  CesiumMath.ONE_OVER_TWO_PI = 1 / (2 * Math.PI);
  CesiumMath.RADIANS_PER_DEGREE = Math.PI / 180;
  CesiumMath.DEGREES_PER_RADIAN = 180 / Math.PI;
  CesiumMath.RADIANS_PER_ARCSECOND = CesiumMath.RADIANS_PER_DEGREE / 3600;
  CesiumMath.toRadians = function(degrees) {
    if (!defined_default(degrees)) {
      throw new DeveloperError_default("degrees is required.");
    }
    return degrees * CesiumMath.RADIANS_PER_DEGREE;
  };
  CesiumMath.toDegrees = function(radians) {
    if (!defined_default(radians)) {
      throw new DeveloperError_default("radians is required.");
    }
    return radians * CesiumMath.DEGREES_PER_RADIAN;
  };
  CesiumMath.convertLongitudeRange = function(angle) {
    if (!defined_default(angle)) {
      throw new DeveloperError_default("angle is required.");
    }
    const twoPi = CesiumMath.TWO_PI;
    const simplified = angle - Math.floor(angle / twoPi) * twoPi;
    if (simplified < -Math.PI) {
      return simplified + twoPi;
    }
    if (simplified >= Math.PI) {
      return simplified - twoPi;
    }
    return simplified;
  };
  CesiumMath.clampToLatitudeRange = function(angle) {
    if (!defined_default(angle)) {
      throw new DeveloperError_default("angle is required.");
    }
    return CesiumMath.clamp(
      angle,
      -1 * CesiumMath.PI_OVER_TWO,
      CesiumMath.PI_OVER_TWO
    );
  };
  CesiumMath.negativePiToPi = function(angle) {
    if (!defined_default(angle)) {
      throw new DeveloperError_default("angle is required.");
    }
    if (angle >= -CesiumMath.PI && angle <= CesiumMath.PI) {
      return angle;
    }
    return CesiumMath.zeroToTwoPi(angle + CesiumMath.PI) - CesiumMath.PI;
  };
  CesiumMath.zeroToTwoPi = function(angle) {
    if (!defined_default(angle)) {
      throw new DeveloperError_default("angle is required.");
    }
    if (angle >= 0 && angle <= CesiumMath.TWO_PI) {
      return angle;
    }
    const mod2 = CesiumMath.mod(angle, CesiumMath.TWO_PI);
    if (Math.abs(mod2) < CesiumMath.EPSILON14 && Math.abs(angle) > CesiumMath.EPSILON14) {
      return CesiumMath.TWO_PI;
    }
    return mod2;
  };
  CesiumMath.mod = function(m, n) {
    if (!defined_default(m)) {
      throw new DeveloperError_default("m is required.");
    }
    if (!defined_default(n)) {
      throw new DeveloperError_default("n is required.");
    }
    if (n === 0) {
      throw new DeveloperError_default("divisor cannot be 0.");
    }
    if (CesiumMath.sign(m) === CesiumMath.sign(n) && Math.abs(m) < Math.abs(n)) {
      return m;
    }
    return (m % n + n) % n;
  };
  CesiumMath.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
    if (!defined_default(left)) {
      throw new DeveloperError_default("left is required.");
    }
    if (!defined_default(right)) {
      throw new DeveloperError_default("right is required.");
    }
    relativeEpsilon = defaultValue_default(relativeEpsilon, 0);
    absoluteEpsilon = defaultValue_default(absoluteEpsilon, relativeEpsilon);
    const absDiff = Math.abs(left - right);
    return absDiff <= absoluteEpsilon || absDiff <= relativeEpsilon * Math.max(Math.abs(left), Math.abs(right));
  };
  CesiumMath.lessThan = function(left, right, absoluteEpsilon) {
    if (!defined_default(left)) {
      throw new DeveloperError_default("first is required.");
    }
    if (!defined_default(right)) {
      throw new DeveloperError_default("second is required.");
    }
    if (!defined_default(absoluteEpsilon)) {
      throw new DeveloperError_default("absoluteEpsilon is required.");
    }
    return left - right < -absoluteEpsilon;
  };
  CesiumMath.lessThanOrEquals = function(left, right, absoluteEpsilon) {
    if (!defined_default(left)) {
      throw new DeveloperError_default("first is required.");
    }
    if (!defined_default(right)) {
      throw new DeveloperError_default("second is required.");
    }
    if (!defined_default(absoluteEpsilon)) {
      throw new DeveloperError_default("absoluteEpsilon is required.");
    }
    return left - right < absoluteEpsilon;
  };
  CesiumMath.greaterThan = function(left, right, absoluteEpsilon) {
    if (!defined_default(left)) {
      throw new DeveloperError_default("first is required.");
    }
    if (!defined_default(right)) {
      throw new DeveloperError_default("second is required.");
    }
    if (!defined_default(absoluteEpsilon)) {
      throw new DeveloperError_default("absoluteEpsilon is required.");
    }
    return left - right > absoluteEpsilon;
  };
  CesiumMath.greaterThanOrEquals = function(left, right, absoluteEpsilon) {
    if (!defined_default(left)) {
      throw new DeveloperError_default("first is required.");
    }
    if (!defined_default(right)) {
      throw new DeveloperError_default("second is required.");
    }
    if (!defined_default(absoluteEpsilon)) {
      throw new DeveloperError_default("absoluteEpsilon is required.");
    }
    return left - right > -absoluteEpsilon;
  };
  var factorials = [1];
  CesiumMath.factorial = function(n) {
    if (typeof n !== "number" || n < 0) {
      throw new DeveloperError_default(
        "A number greater than or equal to 0 is required."
      );
    }
    const length3 = factorials.length;
    if (n >= length3) {
      let sum = factorials[length3 - 1];
      for (let i = length3; i <= n; i++) {
        const next = sum * i;
        factorials.push(next);
        sum = next;
      }
    }
    return factorials[n];
  };
  CesiumMath.incrementWrap = function(n, maximumValue, minimumValue) {
    minimumValue = defaultValue_default(minimumValue, 0);
    if (!defined_default(n)) {
      throw new DeveloperError_default("n is required.");
    }
    if (maximumValue <= minimumValue) {
      throw new DeveloperError_default("maximumValue must be greater than minimumValue.");
    }
    ++n;
    if (n > maximumValue) {
      n = minimumValue;
    }
    return n;
  };
  CesiumMath.isPowerOfTwo = function(n) {
    if (typeof n !== "number" || n < 0 || n > 4294967295) {
      throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
    }
    return n !== 0 && (n & n - 1) === 0;
  };
  CesiumMath.nextPowerOfTwo = function(n) {
    if (typeof n !== "number" || n < 0 || n > 2147483648) {
      throw new DeveloperError_default("A number between 0 and 2^31 is required.");
    }
    --n;
    n |= n >> 1;
    n |= n >> 2;
    n |= n >> 4;
    n |= n >> 8;
    n |= n >> 16;
    ++n;
    return n;
  };
  CesiumMath.previousPowerOfTwo = function(n) {
    if (typeof n !== "number" || n < 0 || n > 4294967295) {
      throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
    }
    n |= n >> 1;
    n |= n >> 2;
    n |= n >> 4;
    n |= n >> 8;
    n |= n >> 16;
    n |= n >> 32;
    n = (n >>> 0) - (n >>> 1);
    return n;
  };
  CesiumMath.clamp = function(value, min3, max3) {
    Check_default.typeOf.number("value", value);
    Check_default.typeOf.number("min", min3);
    Check_default.typeOf.number("max", max3);
    return value < min3 ? min3 : value > max3 ? max3 : value;
  };
  var randomNumberGenerator = new import_mersenne_twister.default();
  CesiumMath.setRandomNumberSeed = function(seed) {
    if (!defined_default(seed)) {
      throw new DeveloperError_default("seed is required.");
    }
    randomNumberGenerator = new import_mersenne_twister.default(seed);
  };
  CesiumMath.nextRandomNumber = function() {
    return randomNumberGenerator.random();
  };
  CesiumMath.randomBetween = function(min3, max3) {
    return CesiumMath.nextRandomNumber() * (max3 - min3) + min3;
  };
  CesiumMath.acosClamped = function(value) {
    if (!defined_default(value)) {
      throw new DeveloperError_default("value is required.");
    }
    return Math.acos(CesiumMath.clamp(value, -1, 1));
  };
  CesiumMath.asinClamped = function(value) {
    if (!defined_default(value)) {
      throw new DeveloperError_default("value is required.");
    }
    return Math.asin(CesiumMath.clamp(value, -1, 1));
  };
  CesiumMath.chordLength = function(angle, radius) {
    if (!defined_default(angle)) {
      throw new DeveloperError_default("angle is required.");
    }
    if (!defined_default(radius)) {
      throw new DeveloperError_default("radius is required.");
    }
    return 2 * radius * Math.sin(angle * 0.5);
  };
  CesiumMath.logBase = function(number, base) {
    if (!defined_default(number)) {
      throw new DeveloperError_default("number is required.");
    }
    if (!defined_default(base)) {
      throw new DeveloperError_default("base is required.");
    }
    return Math.log(number) / Math.log(base);
  };
  CesiumMath.cbrt = defaultValue_default(Math.cbrt, function cbrt(number) {
    const result = Math.pow(Math.abs(number), 1 / 3);
    return number < 0 ? -result : result;
  });
  CesiumMath.log2 = defaultValue_default(Math.log2, function log2(number) {
    return Math.log(number) * Math.LOG2E;
  });
  CesiumMath.fog = function(distanceToCamera, density) {
    const scalar = distanceToCamera * density;
    return 1 - Math.exp(-(scalar * scalar));
  };
  CesiumMath.fastApproximateAtan = function(x) {
    Check_default.typeOf.number("x", x);
    return x * (-0.1784 * Math.abs(x) - 0.0663 * x * x + 1.0301);
  };
  CesiumMath.fastApproximateAtan2 = function(x, y) {
    Check_default.typeOf.number("x", x);
    Check_default.typeOf.number("y", y);
    let opposite;
    let t = Math.abs(x);
    opposite = Math.abs(y);
    const adjacent = Math.max(t, opposite);
    opposite = Math.min(t, opposite);
    const oppositeOverAdjacent = opposite / adjacent;
    if (isNaN(oppositeOverAdjacent)) {
      throw new DeveloperError_default("either x or y must be nonzero");
    }
    t = CesiumMath.fastApproximateAtan(oppositeOverAdjacent);
    t = Math.abs(y) > Math.abs(x) ? CesiumMath.PI_OVER_TWO - t : t;
    t = x < 0 ? CesiumMath.PI - t : t;
    t = y < 0 ? -t : t;
    return t;
  };
  var Math_default = CesiumMath;

  // Source/Core/Cartesian3.js
  function Cartesian3(x, y, z) {
    this.x = defaultValue_default(x, 0);
    this.y = defaultValue_default(y, 0);
    this.z = defaultValue_default(z, 0);
  }
  Cartesian3.fromSpherical = function(spherical, result) {
    Check_default.typeOf.object("spherical", spherical);
    if (!defined_default(result)) {
      result = new Cartesian3();
    }
    const clock = spherical.clock;
    const cone = spherical.cone;
    const magnitude = defaultValue_default(spherical.magnitude, 1);
    const radial = magnitude * Math.sin(cone);
    result.x = radial * Math.cos(clock);
    result.y = radial * Math.sin(clock);
    result.z = magnitude * Math.cos(cone);
    return result;
  };
  Cartesian3.fromElements = function(x, y, z, result) {
    if (!defined_default(result)) {
      return new Cartesian3(x, y, z);
    }
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  Cartesian3.clone = function(cartesian11, result) {
    if (!defined_default(cartesian11)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Cartesian3(cartesian11.x, cartesian11.y, cartesian11.z);
    }
    result.x = cartesian11.x;
    result.y = cartesian11.y;
    result.z = cartesian11.z;
    return result;
  };
  Cartesian3.fromCartesian4 = Cartesian3.clone;
  Cartesian3.packedLength = 3;
  Cartesian3.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value.x;
    array[startingIndex++] = value.y;
    array[startingIndex] = value.z;
    return array;
  };
  Cartesian3.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Cartesian3();
    }
    result.x = array[startingIndex++];
    result.y = array[startingIndex++];
    result.z = array[startingIndex];
    return result;
  };
  Cartesian3.packArray = function(array, result) {
    Check_default.defined("array", array);
    const length3 = array.length;
    const resultLength = length3 * 3;
    if (!defined_default(result)) {
      result = new Array(resultLength);
    } else if (!Array.isArray(result) && result.length !== resultLength) {
      throw new DeveloperError_default(
        "If result is a typed array, it must have exactly array.length * 3 elements"
      );
    } else if (result.length !== resultLength) {
      result.length = resultLength;
    }
    for (let i = 0; i < length3; ++i) {
      Cartesian3.pack(array[i], result, i * 3);
    }
    return result;
  };
  Cartesian3.unpackArray = function(array, result) {
    Check_default.defined("array", array);
    Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 3);
    if (array.length % 3 !== 0) {
      throw new DeveloperError_default("array length must be a multiple of 3.");
    }
    const length3 = array.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 3);
    } else {
      result.length = length3 / 3;
    }
    for (let i = 0; i < length3; i += 3) {
      const index = i / 3;
      result[index] = Cartesian3.unpack(array, i, result[index]);
    }
    return result;
  };
  Cartesian3.fromArray = Cartesian3.unpack;
  Cartesian3.maximumComponent = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return Math.max(cartesian11.x, cartesian11.y, cartesian11.z);
  };
  Cartesian3.minimumComponent = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return Math.min(cartesian11.x, cartesian11.y, cartesian11.z);
  };
  Cartesian3.minimumByComponent = function(first, second, result) {
    Check_default.typeOf.object("first", first);
    Check_default.typeOf.object("second", second);
    Check_default.typeOf.object("result", result);
    result.x = Math.min(first.x, second.x);
    result.y = Math.min(first.y, second.y);
    result.z = Math.min(first.z, second.z);
    return result;
  };
  Cartesian3.maximumByComponent = function(first, second, result) {
    Check_default.typeOf.object("first", first);
    Check_default.typeOf.object("second", second);
    Check_default.typeOf.object("result", result);
    result.x = Math.max(first.x, second.x);
    result.y = Math.max(first.y, second.y);
    result.z = Math.max(first.z, second.z);
    return result;
  };
  Cartesian3.clamp = function(value, min3, max3, result) {
    Check_default.typeOf.object("value", value);
    Check_default.typeOf.object("min", min3);
    Check_default.typeOf.object("max", max3);
    Check_default.typeOf.object("result", result);
    const x = Math_default.clamp(value.x, min3.x, max3.x);
    const y = Math_default.clamp(value.y, min3.y, max3.y);
    const z = Math_default.clamp(value.z, min3.z, max3.z);
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  Cartesian3.magnitudeSquared = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y + cartesian11.z * cartesian11.z;
  };
  Cartesian3.magnitude = function(cartesian11) {
    return Math.sqrt(Cartesian3.magnitudeSquared(cartesian11));
  };
  var distanceScratch = new Cartesian3();
  Cartesian3.distance = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Cartesian3.subtract(left, right, distanceScratch);
    return Cartesian3.magnitude(distanceScratch);
  };
  Cartesian3.distanceSquared = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Cartesian3.subtract(left, right, distanceScratch);
    return Cartesian3.magnitudeSquared(distanceScratch);
  };
  Cartesian3.normalize = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const magnitude = Cartesian3.magnitude(cartesian11);
    result.x = cartesian11.x / magnitude;
    result.y = cartesian11.y / magnitude;
    result.z = cartesian11.z / magnitude;
    if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z)) {
      throw new DeveloperError_default("normalized result is not a number");
    }
    return result;
  };
  Cartesian3.dot = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    return left.x * right.x + left.y * right.y + left.z * right.z;
  };
  Cartesian3.multiplyComponents = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x * right.x;
    result.y = left.y * right.y;
    result.z = left.z * right.z;
    return result;
  };
  Cartesian3.divideComponents = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x / right.x;
    result.y = left.y / right.y;
    result.z = left.z / right.z;
    return result;
  };
  Cartesian3.add = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x + right.x;
    result.y = left.y + right.y;
    result.z = left.z + right.z;
    return result;
  };
  Cartesian3.subtract = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x - right.x;
    result.y = left.y - right.y;
    result.z = left.z - right.z;
    return result;
  };
  Cartesian3.multiplyByScalar = function(cartesian11, scalar, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.x = cartesian11.x * scalar;
    result.y = cartesian11.y * scalar;
    result.z = cartesian11.z * scalar;
    return result;
  };
  Cartesian3.divideByScalar = function(cartesian11, scalar, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.x = cartesian11.x / scalar;
    result.y = cartesian11.y / scalar;
    result.z = cartesian11.z / scalar;
    return result;
  };
  Cartesian3.negate = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result.x = -cartesian11.x;
    result.y = -cartesian11.y;
    result.z = -cartesian11.z;
    return result;
  };
  Cartesian3.abs = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result.x = Math.abs(cartesian11.x);
    result.y = Math.abs(cartesian11.y);
    result.z = Math.abs(cartesian11.z);
    return result;
  };
  var lerpScratch = new Cartesian3();
  Cartesian3.lerp = function(start, end, t, result) {
    Check_default.typeOf.object("start", start);
    Check_default.typeOf.object("end", end);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    Cartesian3.multiplyByScalar(end, t, lerpScratch);
    result = Cartesian3.multiplyByScalar(start, 1 - t, result);
    return Cartesian3.add(lerpScratch, result, result);
  };
  var angleBetweenScratch = new Cartesian3();
  var angleBetweenScratch2 = new Cartesian3();
  Cartesian3.angleBetween = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Cartesian3.normalize(left, angleBetweenScratch);
    Cartesian3.normalize(right, angleBetweenScratch2);
    const cosine = Cartesian3.dot(angleBetweenScratch, angleBetweenScratch2);
    const sine = Cartesian3.magnitude(
      Cartesian3.cross(
        angleBetweenScratch,
        angleBetweenScratch2,
        angleBetweenScratch
      )
    );
    return Math.atan2(sine, cosine);
  };
  var mostOrthogonalAxisScratch = new Cartesian3();
  Cartesian3.mostOrthogonalAxis = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const f = Cartesian3.normalize(cartesian11, mostOrthogonalAxisScratch);
    Cartesian3.abs(f, f);
    if (f.x <= f.y) {
      if (f.x <= f.z) {
        result = Cartesian3.clone(Cartesian3.UNIT_X, result);
      } else {
        result = Cartesian3.clone(Cartesian3.UNIT_Z, result);
      }
    } else if (f.y <= f.z) {
      result = Cartesian3.clone(Cartesian3.UNIT_Y, result);
    } else {
      result = Cartesian3.clone(Cartesian3.UNIT_Z, result);
    }
    return result;
  };
  Cartesian3.projectVector = function(a3, b, result) {
    Check_default.defined("a", a3);
    Check_default.defined("b", b);
    Check_default.defined("result", result);
    const scalar = Cartesian3.dot(a3, b) / Cartesian3.dot(b, b);
    return Cartesian3.multiplyByScalar(b, scalar, result);
  };
  Cartesian3.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z;
  };
  Cartesian3.equalsArray = function(cartesian11, array, offset2) {
    return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1] && cartesian11.z === array[offset2 + 2];
  };
  Cartesian3.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
    return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
      left.x,
      right.x,
      relativeEpsilon,
      absoluteEpsilon
    ) && Math_default.equalsEpsilon(
      left.y,
      right.y,
      relativeEpsilon,
      absoluteEpsilon
    ) && Math_default.equalsEpsilon(
      left.z,
      right.z,
      relativeEpsilon,
      absoluteEpsilon
    );
  };
  Cartesian3.cross = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    const leftX = left.x;
    const leftY = left.y;
    const leftZ = left.z;
    const rightX = right.x;
    const rightY = right.y;
    const rightZ = right.z;
    const x = leftY * rightZ - leftZ * rightY;
    const y = leftZ * rightX - leftX * rightZ;
    const z = leftX * rightY - leftY * rightX;
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  Cartesian3.midpoint = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = (left.x + right.x) * 0.5;
    result.y = (left.y + right.y) * 0.5;
    result.z = (left.z + right.z) * 0.5;
    return result;
  };
  Cartesian3.fromDegrees = function(longitude, latitude, height, ellipsoid, result) {
    Check_default.typeOf.number("longitude", longitude);
    Check_default.typeOf.number("latitude", latitude);
    longitude = Math_default.toRadians(longitude);
    latitude = Math_default.toRadians(latitude);
    return Cartesian3.fromRadians(longitude, latitude, height, ellipsoid, result);
  };
  var scratchN = new Cartesian3();
  var scratchK = new Cartesian3();
  var wgs84RadiiSquared = new Cartesian3(
    6378137 * 6378137,
    6378137 * 6378137,
    6356752314245179e-9 * 6356752314245179e-9
  );
  Cartesian3.fromRadians = function(longitude, latitude, height, ellipsoid, result) {
    Check_default.typeOf.number("longitude", longitude);
    Check_default.typeOf.number("latitude", latitude);
    height = defaultValue_default(height, 0);
    const radiiSquared = defined_default(ellipsoid) ? ellipsoid.radiiSquared : wgs84RadiiSquared;
    const cosLatitude = Math.cos(latitude);
    scratchN.x = cosLatitude * Math.cos(longitude);
    scratchN.y = cosLatitude * Math.sin(longitude);
    scratchN.z = Math.sin(latitude);
    scratchN = Cartesian3.normalize(scratchN, scratchN);
    Cartesian3.multiplyComponents(radiiSquared, scratchN, scratchK);
    const gamma = Math.sqrt(Cartesian3.dot(scratchN, scratchK));
    scratchK = Cartesian3.divideByScalar(scratchK, gamma, scratchK);
    scratchN = Cartesian3.multiplyByScalar(scratchN, height, scratchN);
    if (!defined_default(result)) {
      result = new Cartesian3();
    }
    return Cartesian3.add(scratchK, scratchN, result);
  };
  Cartesian3.fromDegreesArray = function(coordinates, ellipsoid, result) {
    Check_default.defined("coordinates", coordinates);
    if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
      throw new DeveloperError_default(
        "the number of coordinates must be a multiple of 2 and at least 2"
      );
    }
    const length3 = coordinates.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 2);
    } else {
      result.length = length3 / 2;
    }
    for (let i = 0; i < length3; i += 2) {
      const longitude = coordinates[i];
      const latitude = coordinates[i + 1];
      const index = i / 2;
      result[index] = Cartesian3.fromDegrees(
        longitude,
        latitude,
        0,
        ellipsoid,
        result[index]
      );
    }
    return result;
  };
  Cartesian3.fromRadiansArray = function(coordinates, ellipsoid, result) {
    Check_default.defined("coordinates", coordinates);
    if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
      throw new DeveloperError_default(
        "the number of coordinates must be a multiple of 2 and at least 2"
      );
    }
    const length3 = coordinates.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 2);
    } else {
      result.length = length3 / 2;
    }
    for (let i = 0; i < length3; i += 2) {
      const longitude = coordinates[i];
      const latitude = coordinates[i + 1];
      const index = i / 2;
      result[index] = Cartesian3.fromRadians(
        longitude,
        latitude,
        0,
        ellipsoid,
        result[index]
      );
    }
    return result;
  };
  Cartesian3.fromDegreesArrayHeights = function(coordinates, ellipsoid, result) {
    Check_default.defined("coordinates", coordinates);
    if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
      throw new DeveloperError_default(
        "the number of coordinates must be a multiple of 3 and at least 3"
      );
    }
    const length3 = coordinates.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 3);
    } else {
      result.length = length3 / 3;
    }
    for (let i = 0; i < length3; i += 3) {
      const longitude = coordinates[i];
      const latitude = coordinates[i + 1];
      const height = coordinates[i + 2];
      const index = i / 3;
      result[index] = Cartesian3.fromDegrees(
        longitude,
        latitude,
        height,
        ellipsoid,
        result[index]
      );
    }
    return result;
  };
  Cartesian3.fromRadiansArrayHeights = function(coordinates, ellipsoid, result) {
    Check_default.defined("coordinates", coordinates);
    if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
      throw new DeveloperError_default(
        "the number of coordinates must be a multiple of 3 and at least 3"
      );
    }
    const length3 = coordinates.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 3);
    } else {
      result.length = length3 / 3;
    }
    for (let i = 0; i < length3; i += 3) {
      const longitude = coordinates[i];
      const latitude = coordinates[i + 1];
      const height = coordinates[i + 2];
      const index = i / 3;
      result[index] = Cartesian3.fromRadians(
        longitude,
        latitude,
        height,
        ellipsoid,
        result[index]
      );
    }
    return result;
  };
  Cartesian3.ZERO = Object.freeze(new Cartesian3(0, 0, 0));
  Cartesian3.ONE = Object.freeze(new Cartesian3(1, 1, 1));
  Cartesian3.UNIT_X = Object.freeze(new Cartesian3(1, 0, 0));
  Cartesian3.UNIT_Y = Object.freeze(new Cartesian3(0, 1, 0));
  Cartesian3.UNIT_Z = Object.freeze(new Cartesian3(0, 0, 1));
  Cartesian3.prototype.clone = function(result) {
    return Cartesian3.clone(this, result);
  };
  Cartesian3.prototype.equals = function(right) {
    return Cartesian3.equals(this, right);
  };
  Cartesian3.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
    return Cartesian3.equalsEpsilon(
      this,
      right,
      relativeEpsilon,
      absoluteEpsilon
    );
  };
  Cartesian3.prototype.toString = function() {
    return `(${this.x}, ${this.y}, ${this.z})`;
  };
  var Cartesian3_default = Cartesian3;

  // Source/Core/Cartesian4.js
  function Cartesian4(x, y, z, w) {
    this.x = defaultValue_default(x, 0);
    this.y = defaultValue_default(y, 0);
    this.z = defaultValue_default(z, 0);
    this.w = defaultValue_default(w, 0);
  }
  Cartesian4.fromElements = function(x, y, z, w, result) {
    if (!defined_default(result)) {
      return new Cartesian4(x, y, z, w);
    }
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  Cartesian4.fromColor = function(color, result) {
    Check_default.typeOf.object("color", color);
    if (!defined_default(result)) {
      return new Cartesian4(color.red, color.green, color.blue, color.alpha);
    }
    result.x = color.red;
    result.y = color.green;
    result.z = color.blue;
    result.w = color.alpha;
    return result;
  };
  Cartesian4.clone = function(cartesian11, result) {
    if (!defined_default(cartesian11)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Cartesian4(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
    }
    result.x = cartesian11.x;
    result.y = cartesian11.y;
    result.z = cartesian11.z;
    result.w = cartesian11.w;
    return result;
  };
  Cartesian4.packedLength = 4;
  Cartesian4.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value.x;
    array[startingIndex++] = value.y;
    array[startingIndex++] = value.z;
    array[startingIndex] = value.w;
    return array;
  };
  Cartesian4.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Cartesian4();
    }
    result.x = array[startingIndex++];
    result.y = array[startingIndex++];
    result.z = array[startingIndex++];
    result.w = array[startingIndex];
    return result;
  };
  Cartesian4.packArray = function(array, result) {
    Check_default.defined("array", array);
    const length3 = array.length;
    const resultLength = length3 * 4;
    if (!defined_default(result)) {
      result = new Array(resultLength);
    } else if (!Array.isArray(result) && result.length !== resultLength) {
      throw new DeveloperError_default(
        "If result is a typed array, it must have exactly array.length * 4 elements"
      );
    } else if (result.length !== resultLength) {
      result.length = resultLength;
    }
    for (let i = 0; i < length3; ++i) {
      Cartesian4.pack(array[i], result, i * 4);
    }
    return result;
  };
  Cartesian4.unpackArray = function(array, result) {
    Check_default.defined("array", array);
    Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 4);
    if (array.length % 4 !== 0) {
      throw new DeveloperError_default("array length must be a multiple of 4.");
    }
    const length3 = array.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 4);
    } else {
      result.length = length3 / 4;
    }
    for (let i = 0; i < length3; i += 4) {
      const index = i / 4;
      result[index] = Cartesian4.unpack(array, i, result[index]);
    }
    return result;
  };
  Cartesian4.fromArray = Cartesian4.unpack;
  Cartesian4.maximumComponent = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return Math.max(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
  };
  Cartesian4.minimumComponent = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return Math.min(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
  };
  Cartesian4.minimumByComponent = function(first, second, result) {
    Check_default.typeOf.object("first", first);
    Check_default.typeOf.object("second", second);
    Check_default.typeOf.object("result", result);
    result.x = Math.min(first.x, second.x);
    result.y = Math.min(first.y, second.y);
    result.z = Math.min(first.z, second.z);
    result.w = Math.min(first.w, second.w);
    return result;
  };
  Cartesian4.maximumByComponent = function(first, second, result) {
    Check_default.typeOf.object("first", first);
    Check_default.typeOf.object("second", second);
    Check_default.typeOf.object("result", result);
    result.x = Math.max(first.x, second.x);
    result.y = Math.max(first.y, second.y);
    result.z = Math.max(first.z, second.z);
    result.w = Math.max(first.w, second.w);
    return result;
  };
  Cartesian4.clamp = function(value, min3, max3, result) {
    Check_default.typeOf.object("value", value);
    Check_default.typeOf.object("min", min3);
    Check_default.typeOf.object("max", max3);
    Check_default.typeOf.object("result", result);
    const x = Math_default.clamp(value.x, min3.x, max3.x);
    const y = Math_default.clamp(value.y, min3.y, max3.y);
    const z = Math_default.clamp(value.z, min3.z, max3.z);
    const w = Math_default.clamp(value.w, min3.w, max3.w);
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  Cartesian4.magnitudeSquared = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y + cartesian11.z * cartesian11.z + cartesian11.w * cartesian11.w;
  };
  Cartesian4.magnitude = function(cartesian11) {
    return Math.sqrt(Cartesian4.magnitudeSquared(cartesian11));
  };
  var distanceScratch2 = new Cartesian4();
  Cartesian4.distance = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Cartesian4.subtract(left, right, distanceScratch2);
    return Cartesian4.magnitude(distanceScratch2);
  };
  Cartesian4.distanceSquared = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Cartesian4.subtract(left, right, distanceScratch2);
    return Cartesian4.magnitudeSquared(distanceScratch2);
  };
  Cartesian4.normalize = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const magnitude = Cartesian4.magnitude(cartesian11);
    result.x = cartesian11.x / magnitude;
    result.y = cartesian11.y / magnitude;
    result.z = cartesian11.z / magnitude;
    result.w = cartesian11.w / magnitude;
    if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z) || isNaN(result.w)) {
      throw new DeveloperError_default("normalized result is not a number");
    }
    return result;
  };
  Cartesian4.dot = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
  };
  Cartesian4.multiplyComponents = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x * right.x;
    result.y = left.y * right.y;
    result.z = left.z * right.z;
    result.w = left.w * right.w;
    return result;
  };
  Cartesian4.divideComponents = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x / right.x;
    result.y = left.y / right.y;
    result.z = left.z / right.z;
    result.w = left.w / right.w;
    return result;
  };
  Cartesian4.add = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x + right.x;
    result.y = left.y + right.y;
    result.z = left.z + right.z;
    result.w = left.w + right.w;
    return result;
  };
  Cartesian4.subtract = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x - right.x;
    result.y = left.y - right.y;
    result.z = left.z - right.z;
    result.w = left.w - right.w;
    return result;
  };
  Cartesian4.multiplyByScalar = function(cartesian11, scalar, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.x = cartesian11.x * scalar;
    result.y = cartesian11.y * scalar;
    result.z = cartesian11.z * scalar;
    result.w = cartesian11.w * scalar;
    return result;
  };
  Cartesian4.divideByScalar = function(cartesian11, scalar, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.x = cartesian11.x / scalar;
    result.y = cartesian11.y / scalar;
    result.z = cartesian11.z / scalar;
    result.w = cartesian11.w / scalar;
    return result;
  };
  Cartesian4.negate = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result.x = -cartesian11.x;
    result.y = -cartesian11.y;
    result.z = -cartesian11.z;
    result.w = -cartesian11.w;
    return result;
  };
  Cartesian4.abs = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result.x = Math.abs(cartesian11.x);
    result.y = Math.abs(cartesian11.y);
    result.z = Math.abs(cartesian11.z);
    result.w = Math.abs(cartesian11.w);
    return result;
  };
  var lerpScratch2 = new Cartesian4();
  Cartesian4.lerp = function(start, end, t, result) {
    Check_default.typeOf.object("start", start);
    Check_default.typeOf.object("end", end);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    Cartesian4.multiplyByScalar(end, t, lerpScratch2);
    result = Cartesian4.multiplyByScalar(start, 1 - t, result);
    return Cartesian4.add(lerpScratch2, result, result);
  };
  var mostOrthogonalAxisScratch2 = new Cartesian4();
  Cartesian4.mostOrthogonalAxis = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const f = Cartesian4.normalize(cartesian11, mostOrthogonalAxisScratch2);
    Cartesian4.abs(f, f);
    if (f.x <= f.y) {
      if (f.x <= f.z) {
        if (f.x <= f.w) {
          result = Cartesian4.clone(Cartesian4.UNIT_X, result);
        } else {
          result = Cartesian4.clone(Cartesian4.UNIT_W, result);
        }
      } else if (f.z <= f.w) {
        result = Cartesian4.clone(Cartesian4.UNIT_Z, result);
      } else {
        result = Cartesian4.clone(Cartesian4.UNIT_W, result);
      }
    } else if (f.y <= f.z) {
      if (f.y <= f.w) {
        result = Cartesian4.clone(Cartesian4.UNIT_Y, result);
      } else {
        result = Cartesian4.clone(Cartesian4.UNIT_W, result);
      }
    } else if (f.z <= f.w) {
      result = Cartesian4.clone(Cartesian4.UNIT_Z, result);
    } else {
      result = Cartesian4.clone(Cartesian4.UNIT_W, result);
    }
    return result;
  };
  Cartesian4.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z && left.w === right.w;
  };
  Cartesian4.equalsArray = function(cartesian11, array, offset2) {
    return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1] && cartesian11.z === array[offset2 + 2] && cartesian11.w === array[offset2 + 3];
  };
  Cartesian4.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
    return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
      left.x,
      right.x,
      relativeEpsilon,
      absoluteEpsilon
    ) && Math_default.equalsEpsilon(
      left.y,
      right.y,
      relativeEpsilon,
      absoluteEpsilon
    ) && Math_default.equalsEpsilon(
      left.z,
      right.z,
      relativeEpsilon,
      absoluteEpsilon
    ) && Math_default.equalsEpsilon(
      left.w,
      right.w,
      relativeEpsilon,
      absoluteEpsilon
    );
  };
  Cartesian4.ZERO = Object.freeze(new Cartesian4(0, 0, 0, 0));
  Cartesian4.ONE = Object.freeze(new Cartesian4(1, 1, 1, 1));
  Cartesian4.UNIT_X = Object.freeze(new Cartesian4(1, 0, 0, 0));
  Cartesian4.UNIT_Y = Object.freeze(new Cartesian4(0, 1, 0, 0));
  Cartesian4.UNIT_Z = Object.freeze(new Cartesian4(0, 0, 1, 0));
  Cartesian4.UNIT_W = Object.freeze(new Cartesian4(0, 0, 0, 1));
  Cartesian4.prototype.clone = function(result) {
    return Cartesian4.clone(this, result);
  };
  Cartesian4.prototype.equals = function(right) {
    return Cartesian4.equals(this, right);
  };
  Cartesian4.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
    return Cartesian4.equalsEpsilon(
      this,
      right,
      relativeEpsilon,
      absoluteEpsilon
    );
  };
  Cartesian4.prototype.toString = function() {
    return `(${this.x}, ${this.y}, ${this.z}, ${this.w})`;
  };
  var scratchF32Array = new Float32Array(1);
  var scratchU8Array = new Uint8Array(scratchF32Array.buffer);
  var testU32 = new Uint32Array([287454020]);
  var testU8 = new Uint8Array(testU32.buffer);
  var littleEndian = testU8[0] === 68;
  Cartesian4.packFloat = function(value, result) {
    Check_default.typeOf.number("value", value);
    if (!defined_default(result)) {
      result = new Cartesian4();
    }
    scratchF32Array[0] = value;
    if (littleEndian) {
      result.x = scratchU8Array[0];
      result.y = scratchU8Array[1];
      result.z = scratchU8Array[2];
      result.w = scratchU8Array[3];
    } else {
      result.x = scratchU8Array[3];
      result.y = scratchU8Array[2];
      result.z = scratchU8Array[1];
      result.w = scratchU8Array[0];
    }
    return result;
  };
  Cartesian4.unpackFloat = function(packedFloat) {
    Check_default.typeOf.object("packedFloat", packedFloat);
    if (littleEndian) {
      scratchU8Array[0] = packedFloat.x;
      scratchU8Array[1] = packedFloat.y;
      scratchU8Array[2] = packedFloat.z;
      scratchU8Array[3] = packedFloat.w;
    } else {
      scratchU8Array[0] = packedFloat.w;
      scratchU8Array[1] = packedFloat.z;
      scratchU8Array[2] = packedFloat.y;
      scratchU8Array[3] = packedFloat.x;
    }
    return scratchF32Array[0];
  };
  var Cartesian4_default = Cartesian4;

  // Source/Core/Matrix3.js
  function Matrix3(column0Row0, column1Row0, column2Row0, column0Row1, column1Row1, column2Row1, column0Row2, column1Row2, column2Row2) {
    this[0] = defaultValue_default(column0Row0, 0);
    this[1] = defaultValue_default(column0Row1, 0);
    this[2] = defaultValue_default(column0Row2, 0);
    this[3] = defaultValue_default(column1Row0, 0);
    this[4] = defaultValue_default(column1Row1, 0);
    this[5] = defaultValue_default(column1Row2, 0);
    this[6] = defaultValue_default(column2Row0, 0);
    this[7] = defaultValue_default(column2Row1, 0);
    this[8] = defaultValue_default(column2Row2, 0);
  }
  Matrix3.packedLength = 9;
  Matrix3.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value[0];
    array[startingIndex++] = value[1];
    array[startingIndex++] = value[2];
    array[startingIndex++] = value[3];
    array[startingIndex++] = value[4];
    array[startingIndex++] = value[5];
    array[startingIndex++] = value[6];
    array[startingIndex++] = value[7];
    array[startingIndex++] = value[8];
    return array;
  };
  Matrix3.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Matrix3();
    }
    result[0] = array[startingIndex++];
    result[1] = array[startingIndex++];
    result[2] = array[startingIndex++];
    result[3] = array[startingIndex++];
    result[4] = array[startingIndex++];
    result[5] = array[startingIndex++];
    result[6] = array[startingIndex++];
    result[7] = array[startingIndex++];
    result[8] = array[startingIndex++];
    return result;
  };
  Matrix3.packArray = function(array, result) {
    Check_default.defined("array", array);
    const length3 = array.length;
    const resultLength = length3 * 9;
    if (!defined_default(result)) {
      result = new Array(resultLength);
    } else if (!Array.isArray(result) && result.length !== resultLength) {
      throw new DeveloperError_default(
        "If result is a typed array, it must have exactly array.length * 9 elements"
      );
    } else if (result.length !== resultLength) {
      result.length = resultLength;
    }
    for (let i = 0; i < length3; ++i) {
      Matrix3.pack(array[i], result, i * 9);
    }
    return result;
  };
  Matrix3.unpackArray = function(array, result) {
    Check_default.defined("array", array);
    Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 9);
    if (array.length % 9 !== 0) {
      throw new DeveloperError_default("array length must be a multiple of 9.");
    }
    const length3 = array.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 9);
    } else {
      result.length = length3 / 9;
    }
    for (let i = 0; i < length3; i += 9) {
      const index = i / 9;
      result[index] = Matrix3.unpack(array, i, result[index]);
    }
    return result;
  };
  Matrix3.clone = function(matrix, result) {
    if (!defined_default(matrix)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Matrix3(
        matrix[0],
        matrix[3],
        matrix[6],
        matrix[1],
        matrix[4],
        matrix[7],
        matrix[2],
        matrix[5],
        matrix[8]
      );
    }
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[3];
    result[4] = matrix[4];
    result[5] = matrix[5];
    result[6] = matrix[6];
    result[7] = matrix[7];
    result[8] = matrix[8];
    return result;
  };
  Matrix3.fromArray = Matrix3.unpack;
  Matrix3.fromColumnMajorArray = function(values, result) {
    Check_default.defined("values", values);
    return Matrix3.clone(values, result);
  };
  Matrix3.fromRowMajorArray = function(values, result) {
    Check_default.defined("values", values);
    if (!defined_default(result)) {
      return new Matrix3(
        values[0],
        values[1],
        values[2],
        values[3],
        values[4],
        values[5],
        values[6],
        values[7],
        values[8]
      );
    }
    result[0] = values[0];
    result[1] = values[3];
    result[2] = values[6];
    result[3] = values[1];
    result[4] = values[4];
    result[5] = values[7];
    result[6] = values[2];
    result[7] = values[5];
    result[8] = values[8];
    return result;
  };
  Matrix3.fromQuaternion = function(quaternion, result) {
    Check_default.typeOf.object("quaternion", quaternion);
    const x2 = quaternion.x * quaternion.x;
    const xy = quaternion.x * quaternion.y;
    const xz = quaternion.x * quaternion.z;
    const xw = quaternion.x * quaternion.w;
    const y2 = quaternion.y * quaternion.y;
    const yz = quaternion.y * quaternion.z;
    const yw = quaternion.y * quaternion.w;
    const z2 = quaternion.z * quaternion.z;
    const zw = quaternion.z * quaternion.w;
    const w2 = quaternion.w * quaternion.w;
    const m00 = x2 - y2 - z2 + w2;
    const m01 = 2 * (xy - zw);
    const m02 = 2 * (xz + yw);
    const m10 = 2 * (xy + zw);
    const m11 = -x2 + y2 - z2 + w2;
    const m12 = 2 * (yz - xw);
    const m20 = 2 * (xz - yw);
    const m21 = 2 * (yz + xw);
    const m22 = -x2 - y2 + z2 + w2;
    if (!defined_default(result)) {
      return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }
    result[0] = m00;
    result[1] = m10;
    result[2] = m20;
    result[3] = m01;
    result[4] = m11;
    result[5] = m21;
    result[6] = m02;
    result[7] = m12;
    result[8] = m22;
    return result;
  };
  Matrix3.fromHeadingPitchRoll = function(headingPitchRoll, result) {
    Check_default.typeOf.object("headingPitchRoll", headingPitchRoll);
    const cosTheta = Math.cos(-headingPitchRoll.pitch);
    const cosPsi = Math.cos(-headingPitchRoll.heading);
    const cosPhi = Math.cos(headingPitchRoll.roll);
    const sinTheta = Math.sin(-headingPitchRoll.pitch);
    const sinPsi = Math.sin(-headingPitchRoll.heading);
    const sinPhi = Math.sin(headingPitchRoll.roll);
    const m00 = cosTheta * cosPsi;
    const m01 = -cosPhi * sinPsi + sinPhi * sinTheta * cosPsi;
    const m02 = sinPhi * sinPsi + cosPhi * sinTheta * cosPsi;
    const m10 = cosTheta * sinPsi;
    const m11 = cosPhi * cosPsi + sinPhi * sinTheta * sinPsi;
    const m12 = -sinPhi * cosPsi + cosPhi * sinTheta * sinPsi;
    const m20 = -sinTheta;
    const m21 = sinPhi * cosTheta;
    const m22 = cosPhi * cosTheta;
    if (!defined_default(result)) {
      return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }
    result[0] = m00;
    result[1] = m10;
    result[2] = m20;
    result[3] = m01;
    result[4] = m11;
    result[5] = m21;
    result[6] = m02;
    result[7] = m12;
    result[8] = m22;
    return result;
  };
  Matrix3.fromScale = function(scale, result) {
    Check_default.typeOf.object("scale", scale);
    if (!defined_default(result)) {
      return new Matrix3(scale.x, 0, 0, 0, scale.y, 0, 0, 0, scale.z);
    }
    result[0] = scale.x;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = scale.y;
    result[5] = 0;
    result[6] = 0;
    result[7] = 0;
    result[8] = scale.z;
    return result;
  };
  Matrix3.fromUniformScale = function(scale, result) {
    Check_default.typeOf.number("scale", scale);
    if (!defined_default(result)) {
      return new Matrix3(scale, 0, 0, 0, scale, 0, 0, 0, scale);
    }
    result[0] = scale;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = scale;
    result[5] = 0;
    result[6] = 0;
    result[7] = 0;
    result[8] = scale;
    return result;
  };
  Matrix3.fromCrossProduct = function(vector, result) {
    Check_default.typeOf.object("vector", vector);
    if (!defined_default(result)) {
      return new Matrix3(
        0,
        -vector.z,
        vector.y,
        vector.z,
        0,
        -vector.x,
        -vector.y,
        vector.x,
        0
      );
    }
    result[0] = 0;
    result[1] = vector.z;
    result[2] = -vector.y;
    result[3] = -vector.z;
    result[4] = 0;
    result[5] = vector.x;
    result[6] = vector.y;
    result[7] = -vector.x;
    result[8] = 0;
    return result;
  };
  Matrix3.fromRotationX = function(angle, result) {
    Check_default.typeOf.number("angle", angle);
    const cosAngle = Math.cos(angle);
    const sinAngle = Math.sin(angle);
    if (!defined_default(result)) {
      return new Matrix3(
        1,
        0,
        0,
        0,
        cosAngle,
        -sinAngle,
        0,
        sinAngle,
        cosAngle
      );
    }
    result[0] = 1;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = cosAngle;
    result[5] = sinAngle;
    result[6] = 0;
    result[7] = -sinAngle;
    result[8] = cosAngle;
    return result;
  };
  Matrix3.fromRotationY = function(angle, result) {
    Check_default.typeOf.number("angle", angle);
    const cosAngle = Math.cos(angle);
    const sinAngle = Math.sin(angle);
    if (!defined_default(result)) {
      return new Matrix3(
        cosAngle,
        0,
        sinAngle,
        0,
        1,
        0,
        -sinAngle,
        0,
        cosAngle
      );
    }
    result[0] = cosAngle;
    result[1] = 0;
    result[2] = -sinAngle;
    result[3] = 0;
    result[4] = 1;
    result[5] = 0;
    result[6] = sinAngle;
    result[7] = 0;
    result[8] = cosAngle;
    return result;
  };
  Matrix3.fromRotationZ = function(angle, result) {
    Check_default.typeOf.number("angle", angle);
    const cosAngle = Math.cos(angle);
    const sinAngle = Math.sin(angle);
    if (!defined_default(result)) {
      return new Matrix3(
        cosAngle,
        -sinAngle,
        0,
        sinAngle,
        cosAngle,
        0,
        0,
        0,
        1
      );
    }
    result[0] = cosAngle;
    result[1] = sinAngle;
    result[2] = 0;
    result[3] = -sinAngle;
    result[4] = cosAngle;
    result[5] = 0;
    result[6] = 0;
    result[7] = 0;
    result[8] = 1;
    return result;
  };
  Matrix3.toArray = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    if (!defined_default(result)) {
      return [
        matrix[0],
        matrix[1],
        matrix[2],
        matrix[3],
        matrix[4],
        matrix[5],
        matrix[6],
        matrix[7],
        matrix[8]
      ];
    }
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[3];
    result[4] = matrix[4];
    result[5] = matrix[5];
    result[6] = matrix[6];
    result[7] = matrix[7];
    result[8] = matrix[8];
    return result;
  };
  Matrix3.getElementIndex = function(column, row) {
    Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
    Check_default.typeOf.number.lessThanOrEquals("row", row, 2);
    Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
    Check_default.typeOf.number.lessThanOrEquals("column", column, 2);
    return column * 3 + row;
  };
  Matrix3.getColumn = function(matrix, index, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
    Check_default.typeOf.object("result", result);
    const startIndex = index * 3;
    const x = matrix[startIndex];
    const y = matrix[startIndex + 1];
    const z = matrix[startIndex + 2];
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  Matrix3.setColumn = function(matrix, index, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result = Matrix3.clone(matrix, result);
    const startIndex = index * 3;
    result[startIndex] = cartesian11.x;
    result[startIndex + 1] = cartesian11.y;
    result[startIndex + 2] = cartesian11.z;
    return result;
  };
  Matrix3.getRow = function(matrix, index, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
    Check_default.typeOf.object("result", result);
    const x = matrix[index];
    const y = matrix[index + 3];
    const z = matrix[index + 6];
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  Matrix3.setRow = function(matrix, index, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result = Matrix3.clone(matrix, result);
    result[index] = cartesian11.x;
    result[index + 3] = cartesian11.y;
    result[index + 6] = cartesian11.z;
    return result;
  };
  var scaleScratch1 = new Cartesian3_default();
  Matrix3.setScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("scale", scale);
    Check_default.typeOf.object("result", result);
    const existingScale = Matrix3.getScale(matrix, scaleScratch1);
    const scaleRatioX = scale.x / existingScale.x;
    const scaleRatioY = scale.y / existingScale.y;
    const scaleRatioZ = scale.z / existingScale.z;
    result[0] = matrix[0] * scaleRatioX;
    result[1] = matrix[1] * scaleRatioX;
    result[2] = matrix[2] * scaleRatioX;
    result[3] = matrix[3] * scaleRatioY;
    result[4] = matrix[4] * scaleRatioY;
    result[5] = matrix[5] * scaleRatioY;
    result[6] = matrix[6] * scaleRatioZ;
    result[7] = matrix[7] * scaleRatioZ;
    result[8] = matrix[8] * scaleRatioZ;
    return result;
  };
  var scaleScratch2 = new Cartesian3_default();
  Matrix3.setUniformScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scale", scale);
    Check_default.typeOf.object("result", result);
    const existingScale = Matrix3.getScale(matrix, scaleScratch2);
    const scaleRatioX = scale / existingScale.x;
    const scaleRatioY = scale / existingScale.y;
    const scaleRatioZ = scale / existingScale.z;
    result[0] = matrix[0] * scaleRatioX;
    result[1] = matrix[1] * scaleRatioX;
    result[2] = matrix[2] * scaleRatioX;
    result[3] = matrix[3] * scaleRatioY;
    result[4] = matrix[4] * scaleRatioY;
    result[5] = matrix[5] * scaleRatioY;
    result[6] = matrix[6] * scaleRatioZ;
    result[7] = matrix[7] * scaleRatioZ;
    result[8] = matrix[8] * scaleRatioZ;
    return result;
  };
  var scratchColumn = new Cartesian3_default();
  Matrix3.getScale = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result.x = Cartesian3_default.magnitude(
      Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn)
    );
    result.y = Cartesian3_default.magnitude(
      Cartesian3_default.fromElements(matrix[3], matrix[4], matrix[5], scratchColumn)
    );
    result.z = Cartesian3_default.magnitude(
      Cartesian3_default.fromElements(matrix[6], matrix[7], matrix[8], scratchColumn)
    );
    return result;
  };
  var scaleScratch3 = new Cartesian3_default();
  Matrix3.getMaximumScale = function(matrix) {
    Matrix3.getScale(matrix, scaleScratch3);
    return Cartesian3_default.maximumComponent(scaleScratch3);
  };
  var scaleScratch4 = new Cartesian3_default();
  Matrix3.setRotation = function(matrix, rotation, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const scale = Matrix3.getScale(matrix, scaleScratch4);
    result[0] = rotation[0] * scale.x;
    result[1] = rotation[1] * scale.x;
    result[2] = rotation[2] * scale.x;
    result[3] = rotation[3] * scale.y;
    result[4] = rotation[4] * scale.y;
    result[5] = rotation[5] * scale.y;
    result[6] = rotation[6] * scale.z;
    result[7] = rotation[7] * scale.z;
    result[8] = rotation[8] * scale.z;
    return result;
  };
  var scaleScratch5 = new Cartesian3_default();
  Matrix3.getRotation = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const scale = Matrix3.getScale(matrix, scaleScratch5);
    result[0] = matrix[0] / scale.x;
    result[1] = matrix[1] / scale.x;
    result[2] = matrix[2] / scale.x;
    result[3] = matrix[3] / scale.y;
    result[4] = matrix[4] / scale.y;
    result[5] = matrix[5] / scale.y;
    result[6] = matrix[6] / scale.z;
    result[7] = matrix[7] / scale.z;
    result[8] = matrix[8] / scale.z;
    return result;
  };
  Matrix3.multiply = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    const column0Row0 = left[0] * right[0] + left[3] * right[1] + left[6] * right[2];
    const column0Row1 = left[1] * right[0] + left[4] * right[1] + left[7] * right[2];
    const column0Row2 = left[2] * right[0] + left[5] * right[1] + left[8] * right[2];
    const column1Row0 = left[0] * right[3] + left[3] * right[4] + left[6] * right[5];
    const column1Row1 = left[1] * right[3] + left[4] * right[4] + left[7] * right[5];
    const column1Row2 = left[2] * right[3] + left[5] * right[4] + left[8] * right[5];
    const column2Row0 = left[0] * right[6] + left[3] * right[7] + left[6] * right[8];
    const column2Row1 = left[1] * right[6] + left[4] * right[7] + left[7] * right[8];
    const column2Row2 = left[2] * right[6] + left[5] * right[7] + left[8] * right[8];
    result[0] = column0Row0;
    result[1] = column0Row1;
    result[2] = column0Row2;
    result[3] = column1Row0;
    result[4] = column1Row1;
    result[5] = column1Row2;
    result[6] = column2Row0;
    result[7] = column2Row1;
    result[8] = column2Row2;
    return result;
  };
  Matrix3.add = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result[0] = left[0] + right[0];
    result[1] = left[1] + right[1];
    result[2] = left[2] + right[2];
    result[3] = left[3] + right[3];
    result[4] = left[4] + right[4];
    result[5] = left[5] + right[5];
    result[6] = left[6] + right[6];
    result[7] = left[7] + right[7];
    result[8] = left[8] + right[8];
    return result;
  };
  Matrix3.subtract = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result[0] = left[0] - right[0];
    result[1] = left[1] - right[1];
    result[2] = left[2] - right[2];
    result[3] = left[3] - right[3];
    result[4] = left[4] - right[4];
    result[5] = left[5] - right[5];
    result[6] = left[6] - right[6];
    result[7] = left[7] - right[7];
    result[8] = left[8] - right[8];
    return result;
  };
  Matrix3.multiplyByVector = function(matrix, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const vX = cartesian11.x;
    const vY = cartesian11.y;
    const vZ = cartesian11.z;
    const x = matrix[0] * vX + matrix[3] * vY + matrix[6] * vZ;
    const y = matrix[1] * vX + matrix[4] * vY + matrix[7] * vZ;
    const z = matrix[2] * vX + matrix[5] * vY + matrix[8] * vZ;
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  Matrix3.multiplyByScalar = function(matrix, scalar, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0] * scalar;
    result[1] = matrix[1] * scalar;
    result[2] = matrix[2] * scalar;
    result[3] = matrix[3] * scalar;
    result[4] = matrix[4] * scalar;
    result[5] = matrix[5] * scalar;
    result[6] = matrix[6] * scalar;
    result[7] = matrix[7] * scalar;
    result[8] = matrix[8] * scalar;
    return result;
  };
  Matrix3.multiplyByScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("scale", scale);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0] * scale.x;
    result[1] = matrix[1] * scale.x;
    result[2] = matrix[2] * scale.x;
    result[3] = matrix[3] * scale.y;
    result[4] = matrix[4] * scale.y;
    result[5] = matrix[5] * scale.y;
    result[6] = matrix[6] * scale.z;
    result[7] = matrix[7] * scale.z;
    result[8] = matrix[8] * scale.z;
    return result;
  };
  Matrix3.multiplyByUniformScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scale", scale);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0] * scale;
    result[1] = matrix[1] * scale;
    result[2] = matrix[2] * scale;
    result[3] = matrix[3] * scale;
    result[4] = matrix[4] * scale;
    result[5] = matrix[5] * scale;
    result[6] = matrix[6] * scale;
    result[7] = matrix[7] * scale;
    result[8] = matrix[8] * scale;
    return result;
  };
  Matrix3.negate = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result[0] = -matrix[0];
    result[1] = -matrix[1];
    result[2] = -matrix[2];
    result[3] = -matrix[3];
    result[4] = -matrix[4];
    result[5] = -matrix[5];
    result[6] = -matrix[6];
    result[7] = -matrix[7];
    result[8] = -matrix[8];
    return result;
  };
  Matrix3.transpose = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const column0Row0 = matrix[0];
    const column0Row1 = matrix[3];
    const column0Row2 = matrix[6];
    const column1Row0 = matrix[1];
    const column1Row1 = matrix[4];
    const column1Row2 = matrix[7];
    const column2Row0 = matrix[2];
    const column2Row1 = matrix[5];
    const column2Row2 = matrix[8];
    result[0] = column0Row0;
    result[1] = column0Row1;
    result[2] = column0Row2;
    result[3] = column1Row0;
    result[4] = column1Row1;
    result[5] = column1Row2;
    result[6] = column2Row0;
    result[7] = column2Row1;
    result[8] = column2Row2;
    return result;
  };
  function computeFrobeniusNorm(matrix) {
    let norm = 0;
    for (let i = 0; i < 9; ++i) {
      const temp = matrix[i];
      norm += temp * temp;
    }
    return Math.sqrt(norm);
  }
  var rowVal = [1, 0, 0];
  var colVal = [2, 2, 1];
  function offDiagonalFrobeniusNorm(matrix) {
    let norm = 0;
    for (let i = 0; i < 3; ++i) {
      const temp = matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])];
      norm += 2 * temp * temp;
    }
    return Math.sqrt(norm);
  }
  function shurDecomposition(matrix, result) {
    const tolerance = Math_default.EPSILON15;
    let maxDiagonal = 0;
    let rotAxis2 = 1;
    for (let i = 0; i < 3; ++i) {
      const temp = Math.abs(
        matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])]
      );
      if (temp > maxDiagonal) {
        rotAxis2 = i;
        maxDiagonal = temp;
      }
    }
    let c = 1;
    let s = 0;
    const p = rowVal[rotAxis2];
    const q = colVal[rotAxis2];
    if (Math.abs(matrix[Matrix3.getElementIndex(q, p)]) > tolerance) {
      const qq = matrix[Matrix3.getElementIndex(q, q)];
      const pp = matrix[Matrix3.getElementIndex(p, p)];
      const qp = matrix[Matrix3.getElementIndex(q, p)];
      const tau = (qq - pp) / 2 / qp;
      let t;
      if (tau < 0) {
        t = -1 / (-tau + Math.sqrt(1 + tau * tau));
      } else {
        t = 1 / (tau + Math.sqrt(1 + tau * tau));
      }
      c = 1 / Math.sqrt(1 + t * t);
      s = t * c;
    }
    result = Matrix3.clone(Matrix3.IDENTITY, result);
    result[Matrix3.getElementIndex(p, p)] = result[Matrix3.getElementIndex(q, q)] = c;
    result[Matrix3.getElementIndex(q, p)] = s;
    result[Matrix3.getElementIndex(p, q)] = -s;
    return result;
  }
  var jMatrix = new Matrix3();
  var jMatrixTranspose = new Matrix3();
  Matrix3.computeEigenDecomposition = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    const tolerance = Math_default.EPSILON20;
    const maxSweeps = 10;
    let count = 0;
    let sweep = 0;
    if (!defined_default(result)) {
      result = {};
    }
    const unitaryMatrix = result.unitary = Matrix3.clone(
      Matrix3.IDENTITY,
      result.unitary
    );
    const diagMatrix = result.diagonal = Matrix3.clone(matrix, result.diagonal);
    const epsilon = tolerance * computeFrobeniusNorm(diagMatrix);
    while (sweep < maxSweeps && offDiagonalFrobeniusNorm(diagMatrix) > epsilon) {
      shurDecomposition(diagMatrix, jMatrix);
      Matrix3.transpose(jMatrix, jMatrixTranspose);
      Matrix3.multiply(diagMatrix, jMatrix, diagMatrix);
      Matrix3.multiply(jMatrixTranspose, diagMatrix, diagMatrix);
      Matrix3.multiply(unitaryMatrix, jMatrix, unitaryMatrix);
      if (++count > 2) {
        ++sweep;
        count = 0;
      }
    }
    return result;
  };
  Matrix3.abs = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result[0] = Math.abs(matrix[0]);
    result[1] = Math.abs(matrix[1]);
    result[2] = Math.abs(matrix[2]);
    result[3] = Math.abs(matrix[3]);
    result[4] = Math.abs(matrix[4]);
    result[5] = Math.abs(matrix[5]);
    result[6] = Math.abs(matrix[6]);
    result[7] = Math.abs(matrix[7]);
    result[8] = Math.abs(matrix[8]);
    return result;
  };
  Matrix3.determinant = function(matrix) {
    Check_default.typeOf.object("matrix", matrix);
    const m11 = matrix[0];
    const m21 = matrix[3];
    const m31 = matrix[6];
    const m12 = matrix[1];
    const m22 = matrix[4];
    const m32 = matrix[7];
    const m13 = matrix[2];
    const m23 = matrix[5];
    const m33 = matrix[8];
    return m11 * (m22 * m33 - m23 * m32) + m12 * (m23 * m31 - m21 * m33) + m13 * (m21 * m32 - m22 * m31);
  };
  Matrix3.inverse = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const m11 = matrix[0];
    const m21 = matrix[1];
    const m31 = matrix[2];
    const m12 = matrix[3];
    const m22 = matrix[4];
    const m32 = matrix[5];
    const m13 = matrix[6];
    const m23 = matrix[7];
    const m33 = matrix[8];
    const determinant = Matrix3.determinant(matrix);
    if (Math.abs(determinant) <= Math_default.EPSILON15) {
      throw new DeveloperError_default("matrix is not invertible");
    }
    result[0] = m22 * m33 - m23 * m32;
    result[1] = m23 * m31 - m21 * m33;
    result[2] = m21 * m32 - m22 * m31;
    result[3] = m13 * m32 - m12 * m33;
    result[4] = m11 * m33 - m13 * m31;
    result[5] = m12 * m31 - m11 * m32;
    result[6] = m12 * m23 - m13 * m22;
    result[7] = m13 * m21 - m11 * m23;
    result[8] = m11 * m22 - m12 * m21;
    const scale = 1 / determinant;
    return Matrix3.multiplyByScalar(result, scale, result);
  };
  var scratchTransposeMatrix = new Matrix3();
  Matrix3.inverseTranspose = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    return Matrix3.inverse(
      Matrix3.transpose(matrix, scratchTransposeMatrix),
      result
    );
  };
  Matrix3.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[3] === right[3] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[7] === right[7] && left[8] === right[8];
  };
  Matrix3.equalsEpsilon = function(left, right, epsilon) {
    epsilon = defaultValue_default(epsilon, 0);
    return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon;
  };
  Matrix3.IDENTITY = Object.freeze(
    new Matrix3(1, 0, 0, 0, 1, 0, 0, 0, 1)
  );
  Matrix3.ZERO = Object.freeze(
    new Matrix3(0, 0, 0, 0, 0, 0, 0, 0, 0)
  );
  Matrix3.COLUMN0ROW0 = 0;
  Matrix3.COLUMN0ROW1 = 1;
  Matrix3.COLUMN0ROW2 = 2;
  Matrix3.COLUMN1ROW0 = 3;
  Matrix3.COLUMN1ROW1 = 4;
  Matrix3.COLUMN1ROW2 = 5;
  Matrix3.COLUMN2ROW0 = 6;
  Matrix3.COLUMN2ROW1 = 7;
  Matrix3.COLUMN2ROW2 = 8;
  Object.defineProperties(Matrix3.prototype, {
    length: {
      get: function() {
        return Matrix3.packedLength;
      }
    }
  });
  Matrix3.prototype.clone = function(result) {
    return Matrix3.clone(this, result);
  };
  Matrix3.prototype.equals = function(right) {
    return Matrix3.equals(this, right);
  };
  Matrix3.equalsArray = function(matrix, array, offset2) {
    return matrix[0] === array[offset2] && matrix[1] === array[offset2 + 1] && matrix[2] === array[offset2 + 2] && matrix[3] === array[offset2 + 3] && matrix[4] === array[offset2 + 4] && matrix[5] === array[offset2 + 5] && matrix[6] === array[offset2 + 6] && matrix[7] === array[offset2 + 7] && matrix[8] === array[offset2 + 8];
  };
  Matrix3.prototype.equalsEpsilon = function(right, epsilon) {
    return Matrix3.equalsEpsilon(this, right, epsilon);
  };
  Matrix3.prototype.toString = function() {
    return `(${this[0]}, ${this[3]}, ${this[6]})
(${this[1]}, ${this[4]}, ${this[7]})
(${this[2]}, ${this[5]}, ${this[8]})`;
  };
  var Matrix3_default = Matrix3;

  // Source/Core/RuntimeError.js
  function RuntimeError(message) {
    this.name = "RuntimeError";
    this.message = message;
    let stack;
    try {
      throw new Error();
    } catch (e) {
      stack = e.stack;
    }
    this.stack = stack;
  }
  if (defined_default(Object.create)) {
    RuntimeError.prototype = Object.create(Error.prototype);
    RuntimeError.prototype.constructor = RuntimeError;
  }
  RuntimeError.prototype.toString = function() {
    let str = `${this.name}: ${this.message}`;
    if (defined_default(this.stack)) {
      str += `
${this.stack.toString()}`;
    }
    return str;
  };
  var RuntimeError_default = RuntimeError;

  // Source/Core/Matrix4.js
  function Matrix4(column0Row0, column1Row0, column2Row0, column3Row0, column0Row1, column1Row1, column2Row1, column3Row1, column0Row2, column1Row2, column2Row2, column3Row2, column0Row3, column1Row3, column2Row3, column3Row3) {
    this[0] = defaultValue_default(column0Row0, 0);
    this[1] = defaultValue_default(column0Row1, 0);
    this[2] = defaultValue_default(column0Row2, 0);
    this[3] = defaultValue_default(column0Row3, 0);
    this[4] = defaultValue_default(column1Row0, 0);
    this[5] = defaultValue_default(column1Row1, 0);
    this[6] = defaultValue_default(column1Row2, 0);
    this[7] = defaultValue_default(column1Row3, 0);
    this[8] = defaultValue_default(column2Row0, 0);
    this[9] = defaultValue_default(column2Row1, 0);
    this[10] = defaultValue_default(column2Row2, 0);
    this[11] = defaultValue_default(column2Row3, 0);
    this[12] = defaultValue_default(column3Row0, 0);
    this[13] = defaultValue_default(column3Row1, 0);
    this[14] = defaultValue_default(column3Row2, 0);
    this[15] = defaultValue_default(column3Row3, 0);
  }
  Matrix4.packedLength = 16;
  Matrix4.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value[0];
    array[startingIndex++] = value[1];
    array[startingIndex++] = value[2];
    array[startingIndex++] = value[3];
    array[startingIndex++] = value[4];
    array[startingIndex++] = value[5];
    array[startingIndex++] = value[6];
    array[startingIndex++] = value[7];
    array[startingIndex++] = value[8];
    array[startingIndex++] = value[9];
    array[startingIndex++] = value[10];
    array[startingIndex++] = value[11];
    array[startingIndex++] = value[12];
    array[startingIndex++] = value[13];
    array[startingIndex++] = value[14];
    array[startingIndex] = value[15];
    return array;
  };
  Matrix4.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Matrix4();
    }
    result[0] = array[startingIndex++];
    result[1] = array[startingIndex++];
    result[2] = array[startingIndex++];
    result[3] = array[startingIndex++];
    result[4] = array[startingIndex++];
    result[5] = array[startingIndex++];
    result[6] = array[startingIndex++];
    result[7] = array[startingIndex++];
    result[8] = array[startingIndex++];
    result[9] = array[startingIndex++];
    result[10] = array[startingIndex++];
    result[11] = array[startingIndex++];
    result[12] = array[startingIndex++];
    result[13] = array[startingIndex++];
    result[14] = array[startingIndex++];
    result[15] = array[startingIndex];
    return result;
  };
  Matrix4.packArray = function(array, result) {
    Check_default.defined("array", array);
    const length3 = array.length;
    const resultLength = length3 * 16;
    if (!defined_default(result)) {
      result = new Array(resultLength);
    } else if (!Array.isArray(result) && result.length !== resultLength) {
      throw new DeveloperError_default(
        "If result is a typed array, it must have exactly array.length * 16 elements"
      );
    } else if (result.length !== resultLength) {
      result.length = resultLength;
    }
    for (let i = 0; i < length3; ++i) {
      Matrix4.pack(array[i], result, i * 16);
    }
    return result;
  };
  Matrix4.unpackArray = function(array, result) {
    Check_default.defined("array", array);
    Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 16);
    if (array.length % 16 !== 0) {
      throw new DeveloperError_default("array length must be a multiple of 16.");
    }
    const length3 = array.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 16);
    } else {
      result.length = length3 / 16;
    }
    for (let i = 0; i < length3; i += 16) {
      const index = i / 16;
      result[index] = Matrix4.unpack(array, i, result[index]);
    }
    return result;
  };
  Matrix4.clone = function(matrix, result) {
    if (!defined_default(matrix)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Matrix4(
        matrix[0],
        matrix[4],
        matrix[8],
        matrix[12],
        matrix[1],
        matrix[5],
        matrix[9],
        matrix[13],
        matrix[2],
        matrix[6],
        matrix[10],
        matrix[14],
        matrix[3],
        matrix[7],
        matrix[11],
        matrix[15]
      );
    }
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[3];
    result[4] = matrix[4];
    result[5] = matrix[5];
    result[6] = matrix[6];
    result[7] = matrix[7];
    result[8] = matrix[8];
    result[9] = matrix[9];
    result[10] = matrix[10];
    result[11] = matrix[11];
    result[12] = matrix[12];
    result[13] = matrix[13];
    result[14] = matrix[14];
    result[15] = matrix[15];
    return result;
  };
  Matrix4.fromArray = Matrix4.unpack;
  Matrix4.fromColumnMajorArray = function(values, result) {
    Check_default.defined("values", values);
    return Matrix4.clone(values, result);
  };
  Matrix4.fromRowMajorArray = function(values, result) {
    Check_default.defined("values", values);
    if (!defined_default(result)) {
      return new Matrix4(
        values[0],
        values[1],
        values[2],
        values[3],
        values[4],
        values[5],
        values[6],
        values[7],
        values[8],
        values[9],
        values[10],
        values[11],
        values[12],
        values[13],
        values[14],
        values[15]
      );
    }
    result[0] = values[0];
    result[1] = values[4];
    result[2] = values[8];
    result[3] = values[12];
    result[4] = values[1];
    result[5] = values[5];
    result[6] = values[9];
    result[7] = values[13];
    result[8] = values[2];
    result[9] = values[6];
    result[10] = values[10];
    result[11] = values[14];
    result[12] = values[3];
    result[13] = values[7];
    result[14] = values[11];
    result[15] = values[15];
    return result;
  };
  Matrix4.fromRotationTranslation = function(rotation, translation3, result) {
    Check_default.typeOf.object("rotation", rotation);
    translation3 = defaultValue_default(translation3, Cartesian3_default.ZERO);
    if (!defined_default(result)) {
      return new Matrix4(
        rotation[0],
        rotation[3],
        rotation[6],
        translation3.x,
        rotation[1],
        rotation[4],
        rotation[7],
        translation3.y,
        rotation[2],
        rotation[5],
        rotation[8],
        translation3.z,
        0,
        0,
        0,
        1
      );
    }
    result[0] = rotation[0];
    result[1] = rotation[1];
    result[2] = rotation[2];
    result[3] = 0;
    result[4] = rotation[3];
    result[5] = rotation[4];
    result[6] = rotation[5];
    result[7] = 0;
    result[8] = rotation[6];
    result[9] = rotation[7];
    result[10] = rotation[8];
    result[11] = 0;
    result[12] = translation3.x;
    result[13] = translation3.y;
    result[14] = translation3.z;
    result[15] = 1;
    return result;
  };
  Matrix4.fromTranslationQuaternionRotationScale = function(translation3, rotation, scale, result) {
    Check_default.typeOf.object("translation", translation3);
    Check_default.typeOf.object("rotation", rotation);
    Check_default.typeOf.object("scale", scale);
    if (!defined_default(result)) {
      result = new Matrix4();
    }
    const scaleX = scale.x;
    const scaleY = scale.y;
    const scaleZ = scale.z;
    const x2 = rotation.x * rotation.x;
    const xy = rotation.x * rotation.y;
    const xz = rotation.x * rotation.z;
    const xw = rotation.x * rotation.w;
    const y2 = rotation.y * rotation.y;
    const yz = rotation.y * rotation.z;
    const yw = rotation.y * rotation.w;
    const z2 = rotation.z * rotation.z;
    const zw = rotation.z * rotation.w;
    const w2 = rotation.w * rotation.w;
    const m00 = x2 - y2 - z2 + w2;
    const m01 = 2 * (xy - zw);
    const m02 = 2 * (xz + yw);
    const m10 = 2 * (xy + zw);
    const m11 = -x2 + y2 - z2 + w2;
    const m12 = 2 * (yz - xw);
    const m20 = 2 * (xz - yw);
    const m21 = 2 * (yz + xw);
    const m22 = -x2 - y2 + z2 + w2;
    result[0] = m00 * scaleX;
    result[1] = m10 * scaleX;
    result[2] = m20 * scaleX;
    result[3] = 0;
    result[4] = m01 * scaleY;
    result[5] = m11 * scaleY;
    result[6] = m21 * scaleY;
    result[7] = 0;
    result[8] = m02 * scaleZ;
    result[9] = m12 * scaleZ;
    result[10] = m22 * scaleZ;
    result[11] = 0;
    result[12] = translation3.x;
    result[13] = translation3.y;
    result[14] = translation3.z;
    result[15] = 1;
    return result;
  };
  Matrix4.fromTranslationRotationScale = function(translationRotationScale, result) {
    Check_default.typeOf.object("translationRotationScale", translationRotationScale);
    return Matrix4.fromTranslationQuaternionRotationScale(
      translationRotationScale.translation,
      translationRotationScale.rotation,
      translationRotationScale.scale,
      result
    );
  };
  Matrix4.fromTranslation = function(translation3, result) {
    Check_default.typeOf.object("translation", translation3);
    return Matrix4.fromRotationTranslation(Matrix3_default.IDENTITY, translation3, result);
  };
  Matrix4.fromScale = function(scale, result) {
    Check_default.typeOf.object("scale", scale);
    if (!defined_default(result)) {
      return new Matrix4(
        scale.x,
        0,
        0,
        0,
        0,
        scale.y,
        0,
        0,
        0,
        0,
        scale.z,
        0,
        0,
        0,
        0,
        1
      );
    }
    result[0] = scale.x;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = scale.y;
    result[6] = 0;
    result[7] = 0;
    result[8] = 0;
    result[9] = 0;
    result[10] = scale.z;
    result[11] = 0;
    result[12] = 0;
    result[13] = 0;
    result[14] = 0;
    result[15] = 1;
    return result;
  };
  Matrix4.fromUniformScale = function(scale, result) {
    Check_default.typeOf.number("scale", scale);
    if (!defined_default(result)) {
      return new Matrix4(
        scale,
        0,
        0,
        0,
        0,
        scale,
        0,
        0,
        0,
        0,
        scale,
        0,
        0,
        0,
        0,
        1
      );
    }
    result[0] = scale;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = scale;
    result[6] = 0;
    result[7] = 0;
    result[8] = 0;
    result[9] = 0;
    result[10] = scale;
    result[11] = 0;
    result[12] = 0;
    result[13] = 0;
    result[14] = 0;
    result[15] = 1;
    return result;
  };
  Matrix4.fromRotation = function(rotation, result) {
    Check_default.typeOf.object("rotation", rotation);
    if (!defined_default(result)) {
      result = new Matrix4();
    }
    result[0] = rotation[0];
    result[1] = rotation[1];
    result[2] = rotation[2];
    result[3] = 0;
    result[4] = rotation[3];
    result[5] = rotation[4];
    result[6] = rotation[5];
    result[7] = 0;
    result[8] = rotation[6];
    result[9] = rotation[7];
    result[10] = rotation[8];
    result[11] = 0;
    result[12] = 0;
    result[13] = 0;
    result[14] = 0;
    result[15] = 1;
    return result;
  };
  var fromCameraF = new Cartesian3_default();
  var fromCameraR = new Cartesian3_default();
  var fromCameraU = new Cartesian3_default();
  Matrix4.fromCamera = function(camera, result) {
    Check_default.typeOf.object("camera", camera);
    const position = camera.position;
    const direction2 = camera.direction;
    const up = camera.up;
    Check_default.typeOf.object("camera.position", position);
    Check_default.typeOf.object("camera.direction", direction2);
    Check_default.typeOf.object("camera.up", up);
    Cartesian3_default.normalize(direction2, fromCameraF);
    Cartesian3_default.normalize(
      Cartesian3_default.cross(fromCameraF, up, fromCameraR),
      fromCameraR
    );
    Cartesian3_default.normalize(
      Cartesian3_default.cross(fromCameraR, fromCameraF, fromCameraU),
      fromCameraU
    );
    const sX = fromCameraR.x;
    const sY = fromCameraR.y;
    const sZ = fromCameraR.z;
    const fX = fromCameraF.x;
    const fY = fromCameraF.y;
    const fZ = fromCameraF.z;
    const uX = fromCameraU.x;
    const uY = fromCameraU.y;
    const uZ = fromCameraU.z;
    const positionX = position.x;
    const positionY = position.y;
    const positionZ = position.z;
    const t0 = sX * -positionX + sY * -positionY + sZ * -positionZ;
    const t1 = uX * -positionX + uY * -positionY + uZ * -positionZ;
    const t2 = fX * positionX + fY * positionY + fZ * positionZ;
    if (!defined_default(result)) {
      return new Matrix4(
        sX,
        sY,
        sZ,
        t0,
        uX,
        uY,
        uZ,
        t1,
        -fX,
        -fY,
        -fZ,
        t2,
        0,
        0,
        0,
        1
      );
    }
    result[0] = sX;
    result[1] = uX;
    result[2] = -fX;
    result[3] = 0;
    result[4] = sY;
    result[5] = uY;
    result[6] = -fY;
    result[7] = 0;
    result[8] = sZ;
    result[9] = uZ;
    result[10] = -fZ;
    result[11] = 0;
    result[12] = t0;
    result[13] = t1;
    result[14] = t2;
    result[15] = 1;
    return result;
  };
  Matrix4.computePerspectiveFieldOfView = function(fovY, aspectRatio, near, far, result) {
    Check_default.typeOf.number.greaterThan("fovY", fovY, 0);
    Check_default.typeOf.number.lessThan("fovY", fovY, Math.PI);
    Check_default.typeOf.number.greaterThan("near", near, 0);
    Check_default.typeOf.number.greaterThan("far", far, 0);
    Check_default.typeOf.object("result", result);
    const bottom = Math.tan(fovY * 0.5);
    const column1Row1 = 1 / bottom;
    const column0Row0 = column1Row1 / aspectRatio;
    const column2Row2 = (far + near) / (near - far);
    const column3Row2 = 2 * far * near / (near - far);
    result[0] = column0Row0;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = column1Row1;
    result[6] = 0;
    result[7] = 0;
    result[8] = 0;
    result[9] = 0;
    result[10] = column2Row2;
    result[11] = -1;
    result[12] = 0;
    result[13] = 0;
    result[14] = column3Row2;
    result[15] = 0;
    return result;
  };
  Matrix4.computeOrthographicOffCenter = function(left, right, bottom, top, near, far, result) {
    Check_default.typeOf.number("left", left);
    Check_default.typeOf.number("right", right);
    Check_default.typeOf.number("bottom", bottom);
    Check_default.typeOf.number("top", top);
    Check_default.typeOf.number("near", near);
    Check_default.typeOf.number("far", far);
    Check_default.typeOf.object("result", result);
    let a3 = 1 / (right - left);
    let b = 1 / (top - bottom);
    let c = 1 / (far - near);
    const tx = -(right + left) * a3;
    const ty = -(top + bottom) * b;
    const tz = -(far + near) * c;
    a3 *= 2;
    b *= 2;
    c *= -2;
    result[0] = a3;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = b;
    result[6] = 0;
    result[7] = 0;
    result[8] = 0;
    result[9] = 0;
    result[10] = c;
    result[11] = 0;
    result[12] = tx;
    result[13] = ty;
    result[14] = tz;
    result[15] = 1;
    return result;
  };
  Matrix4.computePerspectiveOffCenter = function(left, right, bottom, top, near, far, result) {
    Check_default.typeOf.number("left", left);
    Check_default.typeOf.number("right", right);
    Check_default.typeOf.number("bottom", bottom);
    Check_default.typeOf.number("top", top);
    Check_default.typeOf.number("near", near);
    Check_default.typeOf.number("far", far);
    Check_default.typeOf.object("result", result);
    const column0Row0 = 2 * near / (right - left);
    const column1Row1 = 2 * near / (top - bottom);
    const column2Row0 = (right + left) / (right - left);
    const column2Row1 = (top + bottom) / (top - bottom);
    const column2Row2 = -(far + near) / (far - near);
    const column2Row3 = -1;
    const column3Row2 = -2 * far * near / (far - near);
    result[0] = column0Row0;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = column1Row1;
    result[6] = 0;
    result[7] = 0;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = column2Row3;
    result[12] = 0;
    result[13] = 0;
    result[14] = column3Row2;
    result[15] = 0;
    return result;
  };
  Matrix4.computeInfinitePerspectiveOffCenter = function(left, right, bottom, top, near, result) {
    Check_default.typeOf.number("left", left);
    Check_default.typeOf.number("right", right);
    Check_default.typeOf.number("bottom", bottom);
    Check_default.typeOf.number("top", top);
    Check_default.typeOf.number("near", near);
    Check_default.typeOf.object("result", result);
    const column0Row0 = 2 * near / (right - left);
    const column1Row1 = 2 * near / (top - bottom);
    const column2Row0 = (right + left) / (right - left);
    const column2Row1 = (top + bottom) / (top - bottom);
    const column2Row2 = -1;
    const column2Row3 = -1;
    const column3Row2 = -2 * near;
    result[0] = column0Row0;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = column1Row1;
    result[6] = 0;
    result[7] = 0;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = column2Row3;
    result[12] = 0;
    result[13] = 0;
    result[14] = column3Row2;
    result[15] = 0;
    return result;
  };
  Matrix4.computeViewportTransformation = function(viewport, nearDepthRange, farDepthRange, result) {
    if (!defined_default(result)) {
      result = new Matrix4();
    }
    viewport = defaultValue_default(viewport, defaultValue_default.EMPTY_OBJECT);
    const x = defaultValue_default(viewport.x, 0);
    const y = defaultValue_default(viewport.y, 0);
    const width = defaultValue_default(viewport.width, 0);
    const height = defaultValue_default(viewport.height, 0);
    nearDepthRange = defaultValue_default(nearDepthRange, 0);
    farDepthRange = defaultValue_default(farDepthRange, 1);
    const halfWidth = width * 0.5;
    const halfHeight = height * 0.5;
    const halfDepth = (farDepthRange - nearDepthRange) * 0.5;
    const column0Row0 = halfWidth;
    const column1Row1 = halfHeight;
    const column2Row2 = halfDepth;
    const column3Row0 = x + halfWidth;
    const column3Row1 = y + halfHeight;
    const column3Row2 = nearDepthRange + halfDepth;
    const column3Row3 = 1;
    result[0] = column0Row0;
    result[1] = 0;
    result[2] = 0;
    result[3] = 0;
    result[4] = 0;
    result[5] = column1Row1;
    result[6] = 0;
    result[7] = 0;
    result[8] = 0;
    result[9] = 0;
    result[10] = column2Row2;
    result[11] = 0;
    result[12] = column3Row0;
    result[13] = column3Row1;
    result[14] = column3Row2;
    result[15] = column3Row3;
    return result;
  };
  Matrix4.computeView = function(position, direction2, up, right, result) {
    Check_default.typeOf.object("position", position);
    Check_default.typeOf.object("direction", direction2);
    Check_default.typeOf.object("up", up);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result[0] = right.x;
    result[1] = up.x;
    result[2] = -direction2.x;
    result[3] = 0;
    result[4] = right.y;
    result[5] = up.y;
    result[6] = -direction2.y;
    result[7] = 0;
    result[8] = right.z;
    result[9] = up.z;
    result[10] = -direction2.z;
    result[11] = 0;
    result[12] = -Cartesian3_default.dot(right, position);
    result[13] = -Cartesian3_default.dot(up, position);
    result[14] = Cartesian3_default.dot(direction2, position);
    result[15] = 1;
    return result;
  };
  Matrix4.toArray = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    if (!defined_default(result)) {
      return [
        matrix[0],
        matrix[1],
        matrix[2],
        matrix[3],
        matrix[4],
        matrix[5],
        matrix[6],
        matrix[7],
        matrix[8],
        matrix[9],
        matrix[10],
        matrix[11],
        matrix[12],
        matrix[13],
        matrix[14],
        matrix[15]
      ];
    }
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[3];
    result[4] = matrix[4];
    result[5] = matrix[5];
    result[6] = matrix[6];
    result[7] = matrix[7];
    result[8] = matrix[8];
    result[9] = matrix[9];
    result[10] = matrix[10];
    result[11] = matrix[11];
    result[12] = matrix[12];
    result[13] = matrix[13];
    result[14] = matrix[14];
    result[15] = matrix[15];
    return result;
  };
  Matrix4.getElementIndex = function(column, row) {
    Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
    Check_default.typeOf.number.lessThanOrEquals("row", row, 3);
    Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
    Check_default.typeOf.number.lessThanOrEquals("column", column, 3);
    return column * 4 + row;
  };
  Matrix4.getColumn = function(matrix, index, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
    Check_default.typeOf.object("result", result);
    const startIndex = index * 4;
    const x = matrix[startIndex];
    const y = matrix[startIndex + 1];
    const z = matrix[startIndex + 2];
    const w = matrix[startIndex + 3];
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  Matrix4.setColumn = function(matrix, index, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result = Matrix4.clone(matrix, result);
    const startIndex = index * 4;
    result[startIndex] = cartesian11.x;
    result[startIndex + 1] = cartesian11.y;
    result[startIndex + 2] = cartesian11.z;
    result[startIndex + 3] = cartesian11.w;
    return result;
  };
  Matrix4.getRow = function(matrix, index, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
    Check_default.typeOf.object("result", result);
    const x = matrix[index];
    const y = matrix[index + 4];
    const z = matrix[index + 8];
    const w = matrix[index + 12];
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  Matrix4.setRow = function(matrix, index, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result = Matrix4.clone(matrix, result);
    result[index] = cartesian11.x;
    result[index + 4] = cartesian11.y;
    result[index + 8] = cartesian11.z;
    result[index + 12] = cartesian11.w;
    return result;
  };
  Matrix4.setTranslation = function(matrix, translation3, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("translation", translation3);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[3];
    result[4] = matrix[4];
    result[5] = matrix[5];
    result[6] = matrix[6];
    result[7] = matrix[7];
    result[8] = matrix[8];
    result[9] = matrix[9];
    result[10] = matrix[10];
    result[11] = matrix[11];
    result[12] = translation3.x;
    result[13] = translation3.y;
    result[14] = translation3.z;
    result[15] = matrix[15];
    return result;
  };
  var scaleScratch12 = new Cartesian3_default();
  Matrix4.setScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("scale", scale);
    Check_default.typeOf.object("result", result);
    const existingScale = Matrix4.getScale(matrix, scaleScratch12);
    const scaleRatioX = scale.x / existingScale.x;
    const scaleRatioY = scale.y / existingScale.y;
    const scaleRatioZ = scale.z / existingScale.z;
    result[0] = matrix[0] * scaleRatioX;
    result[1] = matrix[1] * scaleRatioX;
    result[2] = matrix[2] * scaleRatioX;
    result[3] = matrix[3];
    result[4] = matrix[4] * scaleRatioY;
    result[5] = matrix[5] * scaleRatioY;
    result[6] = matrix[6] * scaleRatioY;
    result[7] = matrix[7];
    result[8] = matrix[8] * scaleRatioZ;
    result[9] = matrix[9] * scaleRatioZ;
    result[10] = matrix[10] * scaleRatioZ;
    result[11] = matrix[11];
    result[12] = matrix[12];
    result[13] = matrix[13];
    result[14] = matrix[14];
    result[15] = matrix[15];
    return result;
  };
  var scaleScratch22 = new Cartesian3_default();
  Matrix4.setUniformScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scale", scale);
    Check_default.typeOf.object("result", result);
    const existingScale = Matrix4.getScale(matrix, scaleScratch22);
    const scaleRatioX = scale / existingScale.x;
    const scaleRatioY = scale / existingScale.y;
    const scaleRatioZ = scale / existingScale.z;
    result[0] = matrix[0] * scaleRatioX;
    result[1] = matrix[1] * scaleRatioX;
    result[2] = matrix[2] * scaleRatioX;
    result[3] = matrix[3];
    result[4] = matrix[4] * scaleRatioY;
    result[5] = matrix[5] * scaleRatioY;
    result[6] = matrix[6] * scaleRatioY;
    result[7] = matrix[7];
    result[8] = matrix[8] * scaleRatioZ;
    result[9] = matrix[9] * scaleRatioZ;
    result[10] = matrix[10] * scaleRatioZ;
    result[11] = matrix[11];
    result[12] = matrix[12];
    result[13] = matrix[13];
    result[14] = matrix[14];
    result[15] = matrix[15];
    return result;
  };
  var scratchColumn2 = new Cartesian3_default();
  Matrix4.getScale = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result.x = Cartesian3_default.magnitude(
      Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn2)
    );
    result.y = Cartesian3_default.magnitude(
      Cartesian3_default.fromElements(matrix[4], matrix[5], matrix[6], scratchColumn2)
    );
    result.z = Cartesian3_default.magnitude(
      Cartesian3_default.fromElements(matrix[8], matrix[9], matrix[10], scratchColumn2)
    );
    return result;
  };
  var scaleScratch32 = new Cartesian3_default();
  Matrix4.getMaximumScale = function(matrix) {
    Matrix4.getScale(matrix, scaleScratch32);
    return Cartesian3_default.maximumComponent(scaleScratch32);
  };
  var scaleScratch42 = new Cartesian3_default();
  Matrix4.setRotation = function(matrix, rotation, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const scale = Matrix4.getScale(matrix, scaleScratch42);
    result[0] = rotation[0] * scale.x;
    result[1] = rotation[1] * scale.x;
    result[2] = rotation[2] * scale.x;
    result[3] = matrix[3];
    result[4] = rotation[3] * scale.y;
    result[5] = rotation[4] * scale.y;
    result[6] = rotation[5] * scale.y;
    result[7] = matrix[7];
    result[8] = rotation[6] * scale.z;
    result[9] = rotation[7] * scale.z;
    result[10] = rotation[8] * scale.z;
    result[11] = matrix[11];
    result[12] = matrix[12];
    result[13] = matrix[13];
    result[14] = matrix[14];
    result[15] = matrix[15];
    return result;
  };
  var scaleScratch52 = new Cartesian3_default();
  Matrix4.getRotation = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const scale = Matrix4.getScale(matrix, scaleScratch52);
    result[0] = matrix[0] / scale.x;
    result[1] = matrix[1] / scale.x;
    result[2] = matrix[2] / scale.x;
    result[3] = matrix[4] / scale.y;
    result[4] = matrix[5] / scale.y;
    result[5] = matrix[6] / scale.y;
    result[6] = matrix[8] / scale.z;
    result[7] = matrix[9] / scale.z;
    result[8] = matrix[10] / scale.z;
    return result;
  };
  Matrix4.multiply = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    const left0 = left[0];
    const left1 = left[1];
    const left2 = left[2];
    const left3 = left[3];
    const left4 = left[4];
    const left5 = left[5];
    const left6 = left[6];
    const left7 = left[7];
    const left8 = left[8];
    const left9 = left[9];
    const left10 = left[10];
    const left11 = left[11];
    const left12 = left[12];
    const left13 = left[13];
    const left14 = left[14];
    const left15 = left[15];
    const right0 = right[0];
    const right1 = right[1];
    const right2 = right[2];
    const right3 = right[3];
    const right4 = right[4];
    const right5 = right[5];
    const right6 = right[6];
    const right7 = right[7];
    const right8 = right[8];
    const right9 = right[9];
    const right10 = right[10];
    const right11 = right[11];
    const right12 = right[12];
    const right13 = right[13];
    const right14 = right[14];
    const right15 = right[15];
    const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2 + left12 * right3;
    const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2 + left13 * right3;
    const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2 + left14 * right3;
    const column0Row3 = left3 * right0 + left7 * right1 + left11 * right2 + left15 * right3;
    const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6 + left12 * right7;
    const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6 + left13 * right7;
    const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6 + left14 * right7;
    const column1Row3 = left3 * right4 + left7 * right5 + left11 * right6 + left15 * right7;
    const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10 + left12 * right11;
    const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10 + left13 * right11;
    const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10 + left14 * right11;
    const column2Row3 = left3 * right8 + left7 * right9 + left11 * right10 + left15 * right11;
    const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12 * right15;
    const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13 * right15;
    const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14 * right15;
    const column3Row3 = left3 * right12 + left7 * right13 + left11 * right14 + left15 * right15;
    result[0] = column0Row0;
    result[1] = column0Row1;
    result[2] = column0Row2;
    result[3] = column0Row3;
    result[4] = column1Row0;
    result[5] = column1Row1;
    result[6] = column1Row2;
    result[7] = column1Row3;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = column2Row3;
    result[12] = column3Row0;
    result[13] = column3Row1;
    result[14] = column3Row2;
    result[15] = column3Row3;
    return result;
  };
  Matrix4.add = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result[0] = left[0] + right[0];
    result[1] = left[1] + right[1];
    result[2] = left[2] + right[2];
    result[3] = left[3] + right[3];
    result[4] = left[4] + right[4];
    result[5] = left[5] + right[5];
    result[6] = left[6] + right[6];
    result[7] = left[7] + right[7];
    result[8] = left[8] + right[8];
    result[9] = left[9] + right[9];
    result[10] = left[10] + right[10];
    result[11] = left[11] + right[11];
    result[12] = left[12] + right[12];
    result[13] = left[13] + right[13];
    result[14] = left[14] + right[14];
    result[15] = left[15] + right[15];
    return result;
  };
  Matrix4.subtract = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result[0] = left[0] - right[0];
    result[1] = left[1] - right[1];
    result[2] = left[2] - right[2];
    result[3] = left[3] - right[3];
    result[4] = left[4] - right[4];
    result[5] = left[5] - right[5];
    result[6] = left[6] - right[6];
    result[7] = left[7] - right[7];
    result[8] = left[8] - right[8];
    result[9] = left[9] - right[9];
    result[10] = left[10] - right[10];
    result[11] = left[11] - right[11];
    result[12] = left[12] - right[12];
    result[13] = left[13] - right[13];
    result[14] = left[14] - right[14];
    result[15] = left[15] - right[15];
    return result;
  };
  Matrix4.multiplyTransformation = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    const left0 = left[0];
    const left1 = left[1];
    const left2 = left[2];
    const left4 = left[4];
    const left5 = left[5];
    const left6 = left[6];
    const left8 = left[8];
    const left9 = left[9];
    const left10 = left[10];
    const left12 = left[12];
    const left13 = left[13];
    const left14 = left[14];
    const right0 = right[0];
    const right1 = right[1];
    const right2 = right[2];
    const right4 = right[4];
    const right5 = right[5];
    const right6 = right[6];
    const right8 = right[8];
    const right9 = right[9];
    const right10 = right[10];
    const right12 = right[12];
    const right13 = right[13];
    const right14 = right[14];
    const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
    const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
    const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
    const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
    const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
    const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
    const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
    const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
    const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
    const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12;
    const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13;
    const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14;
    result[0] = column0Row0;
    result[1] = column0Row1;
    result[2] = column0Row2;
    result[3] = 0;
    result[4] = column1Row0;
    result[5] = column1Row1;
    result[6] = column1Row2;
    result[7] = 0;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = 0;
    result[12] = column3Row0;
    result[13] = column3Row1;
    result[14] = column3Row2;
    result[15] = 1;
    return result;
  };
  Matrix4.multiplyByMatrix3 = function(matrix, rotation, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("rotation", rotation);
    Check_default.typeOf.object("result", result);
    const left0 = matrix[0];
    const left1 = matrix[1];
    const left2 = matrix[2];
    const left4 = matrix[4];
    const left5 = matrix[5];
    const left6 = matrix[6];
    const left8 = matrix[8];
    const left9 = matrix[9];
    const left10 = matrix[10];
    const right0 = rotation[0];
    const right1 = rotation[1];
    const right2 = rotation[2];
    const right4 = rotation[3];
    const right5 = rotation[4];
    const right6 = rotation[5];
    const right8 = rotation[6];
    const right9 = rotation[7];
    const right10 = rotation[8];
    const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
    const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
    const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
    const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
    const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
    const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
    const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
    const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
    const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
    result[0] = column0Row0;
    result[1] = column0Row1;
    result[2] = column0Row2;
    result[3] = 0;
    result[4] = column1Row0;
    result[5] = column1Row1;
    result[6] = column1Row2;
    result[7] = 0;
    result[8] = column2Row0;
    result[9] = column2Row1;
    result[10] = column2Row2;
    result[11] = 0;
    result[12] = matrix[12];
    result[13] = matrix[13];
    result[14] = matrix[14];
    result[15] = matrix[15];
    return result;
  };
  Matrix4.multiplyByTranslation = function(matrix, translation3, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("translation", translation3);
    Check_default.typeOf.object("result", result);
    const x = translation3.x;
    const y = translation3.y;
    const z = translation3.z;
    const tx = x * matrix[0] + y * matrix[4] + z * matrix[8] + matrix[12];
    const ty = x * matrix[1] + y * matrix[5] + z * matrix[9] + matrix[13];
    const tz = x * matrix[2] + y * matrix[6] + z * matrix[10] + matrix[14];
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[3];
    result[4] = matrix[4];
    result[5] = matrix[5];
    result[6] = matrix[6];
    result[7] = matrix[7];
    result[8] = matrix[8];
    result[9] = matrix[9];
    result[10] = matrix[10];
    result[11] = matrix[11];
    result[12] = tx;
    result[13] = ty;
    result[14] = tz;
    result[15] = matrix[15];
    return result;
  };
  Matrix4.multiplyByScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("scale", scale);
    Check_default.typeOf.object("result", result);
    const scaleX = scale.x;
    const scaleY = scale.y;
    const scaleZ = scale.z;
    if (scaleX === 1 && scaleY === 1 && scaleZ === 1) {
      return Matrix4.clone(matrix, result);
    }
    result[0] = scaleX * matrix[0];
    result[1] = scaleX * matrix[1];
    result[2] = scaleX * matrix[2];
    result[3] = matrix[3];
    result[4] = scaleY * matrix[4];
    result[5] = scaleY * matrix[5];
    result[6] = scaleY * matrix[6];
    result[7] = matrix[7];
    result[8] = scaleZ * matrix[8];
    result[9] = scaleZ * matrix[9];
    result[10] = scaleZ * matrix[10];
    result[11] = matrix[11];
    result[12] = matrix[12];
    result[13] = matrix[13];
    result[14] = matrix[14];
    result[15] = matrix[15];
    return result;
  };
  Matrix4.multiplyByUniformScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scale", scale);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0] * scale;
    result[1] = matrix[1] * scale;
    result[2] = matrix[2] * scale;
    result[3] = matrix[3];
    result[4] = matrix[4] * scale;
    result[5] = matrix[5] * scale;
    result[6] = matrix[6] * scale;
    result[7] = matrix[7];
    result[8] = matrix[8] * scale;
    result[9] = matrix[9] * scale;
    result[10] = matrix[10] * scale;
    result[11] = matrix[11];
    result[12] = matrix[12];
    result[13] = matrix[13];
    result[14] = matrix[14];
    result[15] = matrix[15];
    return result;
  };
  Matrix4.multiplyByVector = function(matrix, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const vX = cartesian11.x;
    const vY = cartesian11.y;
    const vZ = cartesian11.z;
    const vW = cartesian11.w;
    const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12] * vW;
    const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13] * vW;
    const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14] * vW;
    const w = matrix[3] * vX + matrix[7] * vY + matrix[11] * vZ + matrix[15] * vW;
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  Matrix4.multiplyByPointAsVector = function(matrix, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const vX = cartesian11.x;
    const vY = cartesian11.y;
    const vZ = cartesian11.z;
    const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ;
    const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ;
    const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ;
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  Matrix4.multiplyByPoint = function(matrix, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const vX = cartesian11.x;
    const vY = cartesian11.y;
    const vZ = cartesian11.z;
    const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12];
    const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13];
    const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14];
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  Matrix4.multiplyByScalar = function(matrix, scalar, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0] * scalar;
    result[1] = matrix[1] * scalar;
    result[2] = matrix[2] * scalar;
    result[3] = matrix[3] * scalar;
    result[4] = matrix[4] * scalar;
    result[5] = matrix[5] * scalar;
    result[6] = matrix[6] * scalar;
    result[7] = matrix[7] * scalar;
    result[8] = matrix[8] * scalar;
    result[9] = matrix[9] * scalar;
    result[10] = matrix[10] * scalar;
    result[11] = matrix[11] * scalar;
    result[12] = matrix[12] * scalar;
    result[13] = matrix[13] * scalar;
    result[14] = matrix[14] * scalar;
    result[15] = matrix[15] * scalar;
    return result;
  };
  Matrix4.negate = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result[0] = -matrix[0];
    result[1] = -matrix[1];
    result[2] = -matrix[2];
    result[3] = -matrix[3];
    result[4] = -matrix[4];
    result[5] = -matrix[5];
    result[6] = -matrix[6];
    result[7] = -matrix[7];
    result[8] = -matrix[8];
    result[9] = -matrix[9];
    result[10] = -matrix[10];
    result[11] = -matrix[11];
    result[12] = -matrix[12];
    result[13] = -matrix[13];
    result[14] = -matrix[14];
    result[15] = -matrix[15];
    return result;
  };
  Matrix4.transpose = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const matrix1 = matrix[1];
    const matrix2 = matrix[2];
    const matrix3 = matrix[3];
    const matrix6 = matrix[6];
    const matrix7 = matrix[7];
    const matrix11 = matrix[11];
    result[0] = matrix[0];
    result[1] = matrix[4];
    result[2] = matrix[8];
    result[3] = matrix[12];
    result[4] = matrix1;
    result[5] = matrix[5];
    result[6] = matrix[9];
    result[7] = matrix[13];
    result[8] = matrix2;
    result[9] = matrix6;
    result[10] = matrix[10];
    result[11] = matrix[14];
    result[12] = matrix3;
    result[13] = matrix7;
    result[14] = matrix11;
    result[15] = matrix[15];
    return result;
  };
  Matrix4.abs = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result[0] = Math.abs(matrix[0]);
    result[1] = Math.abs(matrix[1]);
    result[2] = Math.abs(matrix[2]);
    result[3] = Math.abs(matrix[3]);
    result[4] = Math.abs(matrix[4]);
    result[5] = Math.abs(matrix[5]);
    result[6] = Math.abs(matrix[6]);
    result[7] = Math.abs(matrix[7]);
    result[8] = Math.abs(matrix[8]);
    result[9] = Math.abs(matrix[9]);
    result[10] = Math.abs(matrix[10]);
    result[11] = Math.abs(matrix[11]);
    result[12] = Math.abs(matrix[12]);
    result[13] = Math.abs(matrix[13]);
    result[14] = Math.abs(matrix[14]);
    result[15] = Math.abs(matrix[15]);
    return result;
  };
  Matrix4.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left[12] === right[12] && left[13] === right[13] && left[14] === right[14] && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[8] === right[8] && left[9] === right[9] && left[10] === right[10] && left[3] === right[3] && left[7] === right[7] && left[11] === right[11] && left[15] === right[15];
  };
  Matrix4.equalsEpsilon = function(left, right, epsilon) {
    epsilon = defaultValue_default(epsilon, 0);
    return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon && Math.abs(left[9] - right[9]) <= epsilon && Math.abs(left[10] - right[10]) <= epsilon && Math.abs(left[11] - right[11]) <= epsilon && Math.abs(left[12] - right[12]) <= epsilon && Math.abs(left[13] - right[13]) <= epsilon && Math.abs(left[14] - right[14]) <= epsilon && Math.abs(left[15] - right[15]) <= epsilon;
  };
  Matrix4.getTranslation = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result.x = matrix[12];
    result.y = matrix[13];
    result.z = matrix[14];
    return result;
  };
  Matrix4.getMatrix3 = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[4];
    result[4] = matrix[5];
    result[5] = matrix[6];
    result[6] = matrix[8];
    result[7] = matrix[9];
    result[8] = matrix[10];
    return result;
  };
  var scratchInverseRotation = new Matrix3_default();
  var scratchMatrix3Zero = new Matrix3_default();
  var scratchBottomRow = new Cartesian4_default();
  var scratchExpectedBottomRow = new Cartesian4_default(0, 0, 0, 1);
  Matrix4.inverse = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const src0 = matrix[0];
    const src1 = matrix[4];
    const src2 = matrix[8];
    const src3 = matrix[12];
    const src4 = matrix[1];
    const src5 = matrix[5];
    const src6 = matrix[9];
    const src7 = matrix[13];
    const src8 = matrix[2];
    const src9 = matrix[6];
    const src10 = matrix[10];
    const src11 = matrix[14];
    const src12 = matrix[3];
    const src13 = matrix[7];
    const src14 = matrix[11];
    const src15 = matrix[15];
    let tmp0 = src10 * src15;
    let tmp1 = src11 * src14;
    let tmp2 = src9 * src15;
    let tmp3 = src11 * src13;
    let tmp4 = src9 * src14;
    let tmp5 = src10 * src13;
    let tmp6 = src8 * src15;
    let tmp7 = src11 * src12;
    let tmp8 = src8 * src14;
    let tmp9 = src10 * src12;
    let tmp10 = src8 * src13;
    let tmp11 = src9 * src12;
    const dst0 = tmp0 * src5 + tmp3 * src6 + tmp4 * src7 - (tmp1 * src5 + tmp2 * src6 + tmp5 * src7);
    const dst1 = tmp1 * src4 + tmp6 * src6 + tmp9 * src7 - (tmp0 * src4 + tmp7 * src6 + tmp8 * src7);
    const dst2 = tmp2 * src4 + tmp7 * src5 + tmp10 * src7 - (tmp3 * src4 + tmp6 * src5 + tmp11 * src7);
    const dst3 = tmp5 * src4 + tmp8 * src5 + tmp11 * src6 - (tmp4 * src4 + tmp9 * src5 + tmp10 * src6);
    const dst4 = tmp1 * src1 + tmp2 * src2 + tmp5 * src3 - (tmp0 * src1 + tmp3 * src2 + tmp4 * src3);
    const dst5 = tmp0 * src0 + tmp7 * src2 + tmp8 * src3 - (tmp1 * src0 + tmp6 * src2 + tmp9 * src3);
    const dst6 = tmp3 * src0 + tmp6 * src1 + tmp11 * src3 - (tmp2 * src0 + tmp7 * src1 + tmp10 * src3);
    const dst7 = tmp4 * src0 + tmp9 * src1 + tmp10 * src2 - (tmp5 * src0 + tmp8 * src1 + tmp11 * src2);
    tmp0 = src2 * src7;
    tmp1 = src3 * src6;
    tmp2 = src1 * src7;
    tmp3 = src3 * src5;
    tmp4 = src1 * src6;
    tmp5 = src2 * src5;
    tmp6 = src0 * src7;
    tmp7 = src3 * src4;
    tmp8 = src0 * src6;
    tmp9 = src2 * src4;
    tmp10 = src0 * src5;
    tmp11 = src1 * src4;
    const dst8 = tmp0 * src13 + tmp3 * src14 + tmp4 * src15 - (tmp1 * src13 + tmp2 * src14 + tmp5 * src15);
    const dst9 = tmp1 * src12 + tmp6 * src14 + tmp9 * src15 - (tmp0 * src12 + tmp7 * src14 + tmp8 * src15);
    const dst10 = tmp2 * src12 + tmp7 * src13 + tmp10 * src15 - (tmp3 * src12 + tmp6 * src13 + tmp11 * src15);
    const dst11 = tmp5 * src12 + tmp8 * src13 + tmp11 * src14 - (tmp4 * src12 + tmp9 * src13 + tmp10 * src14);
    const dst12 = tmp2 * src10 + tmp5 * src11 + tmp1 * src9 - (tmp4 * src11 + tmp0 * src9 + tmp3 * src10);
    const dst13 = tmp8 * src11 + tmp0 * src8 + tmp7 * src10 - (tmp6 * src10 + tmp9 * src11 + tmp1 * src8);
    const dst14 = tmp6 * src9 + tmp11 * src11 + tmp3 * src8 - (tmp10 * src11 + tmp2 * src8 + tmp7 * src9);
    const dst15 = tmp10 * src10 + tmp4 * src8 + tmp9 * src9 - (tmp8 * src9 + tmp11 * src10 + tmp5 * src8);
    let det = src0 * dst0 + src1 * dst1 + src2 * dst2 + src3 * dst3;
    if (Math.abs(det) < Math_default.EPSILON21) {
      if (Matrix3_default.equalsEpsilon(
        Matrix4.getMatrix3(matrix, scratchInverseRotation),
        scratchMatrix3Zero,
        Math_default.EPSILON7
      ) && Cartesian4_default.equals(
        Matrix4.getRow(matrix, 3, scratchBottomRow),
        scratchExpectedBottomRow
      )) {
        result[0] = 0;
        result[1] = 0;
        result[2] = 0;
        result[3] = 0;
        result[4] = 0;
        result[5] = 0;
        result[6] = 0;
        result[7] = 0;
        result[8] = 0;
        result[9] = 0;
        result[10] = 0;
        result[11] = 0;
        result[12] = -matrix[12];
        result[13] = -matrix[13];
        result[14] = -matrix[14];
        result[15] = 1;
        return result;
      }
      throw new RuntimeError_default(
        "matrix is not invertible because its determinate is zero."
      );
    }
    det = 1 / det;
    result[0] = dst0 * det;
    result[1] = dst1 * det;
    result[2] = dst2 * det;
    result[3] = dst3 * det;
    result[4] = dst4 * det;
    result[5] = dst5 * det;
    result[6] = dst6 * det;
    result[7] = dst7 * det;
    result[8] = dst8 * det;
    result[9] = dst9 * det;
    result[10] = dst10 * det;
    result[11] = dst11 * det;
    result[12] = dst12 * det;
    result[13] = dst13 * det;
    result[14] = dst14 * det;
    result[15] = dst15 * det;
    return result;
  };
  Matrix4.inverseTransformation = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const matrix0 = matrix[0];
    const matrix1 = matrix[1];
    const matrix2 = matrix[2];
    const matrix4 = matrix[4];
    const matrix5 = matrix[5];
    const matrix6 = matrix[6];
    const matrix8 = matrix[8];
    const matrix9 = matrix[9];
    const matrix10 = matrix[10];
    const vX = matrix[12];
    const vY = matrix[13];
    const vZ = matrix[14];
    const x = -matrix0 * vX - matrix1 * vY - matrix2 * vZ;
    const y = -matrix4 * vX - matrix5 * vY - matrix6 * vZ;
    const z = -matrix8 * vX - matrix9 * vY - matrix10 * vZ;
    result[0] = matrix0;
    result[1] = matrix4;
    result[2] = matrix8;
    result[3] = 0;
    result[4] = matrix1;
    result[5] = matrix5;
    result[6] = matrix9;
    result[7] = 0;
    result[8] = matrix2;
    result[9] = matrix6;
    result[10] = matrix10;
    result[11] = 0;
    result[12] = x;
    result[13] = y;
    result[14] = z;
    result[15] = 1;
    return result;
  };
  var scratchTransposeMatrix2 = new Matrix4();
  Matrix4.inverseTranspose = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    return Matrix4.inverse(
      Matrix4.transpose(matrix, scratchTransposeMatrix2),
      result
    );
  };
  Matrix4.IDENTITY = Object.freeze(
    new Matrix4(
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      0,
      0,
      0,
      0,
      1
    )
  );
  Matrix4.ZERO = Object.freeze(
    new Matrix4(
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0
    )
  );
  Matrix4.COLUMN0ROW0 = 0;
  Matrix4.COLUMN0ROW1 = 1;
  Matrix4.COLUMN0ROW2 = 2;
  Matrix4.COLUMN0ROW3 = 3;
  Matrix4.COLUMN1ROW0 = 4;
  Matrix4.COLUMN1ROW1 = 5;
  Matrix4.COLUMN1ROW2 = 6;
  Matrix4.COLUMN1ROW3 = 7;
  Matrix4.COLUMN2ROW0 = 8;
  Matrix4.COLUMN2ROW1 = 9;
  Matrix4.COLUMN2ROW2 = 10;
  Matrix4.COLUMN2ROW3 = 11;
  Matrix4.COLUMN3ROW0 = 12;
  Matrix4.COLUMN3ROW1 = 13;
  Matrix4.COLUMN3ROW2 = 14;
  Matrix4.COLUMN3ROW3 = 15;
  Object.defineProperties(Matrix4.prototype, {
    length: {
      get: function() {
        return Matrix4.packedLength;
      }
    }
  });
  Matrix4.prototype.clone = function(result) {
    return Matrix4.clone(this, result);
  };
  Matrix4.prototype.equals = function(right) {
    return Matrix4.equals(this, right);
  };
  Matrix4.equalsArray = function(matrix, array, offset2) {
    return matrix[0] === array[offset2] && matrix[1] === array[offset2 + 1] && matrix[2] === array[offset2 + 2] && matrix[3] === array[offset2 + 3] && matrix[4] === array[offset2 + 4] && matrix[5] === array[offset2 + 5] && matrix[6] === array[offset2 + 6] && matrix[7] === array[offset2 + 7] && matrix[8] === array[offset2 + 8] && matrix[9] === array[offset2 + 9] && matrix[10] === array[offset2 + 10] && matrix[11] === array[offset2 + 11] && matrix[12] === array[offset2 + 12] && matrix[13] === array[offset2 + 13] && matrix[14] === array[offset2 + 14] && matrix[15] === array[offset2 + 15];
  };
  Matrix4.prototype.equalsEpsilon = function(right, epsilon) {
    return Matrix4.equalsEpsilon(this, right, epsilon);
  };
  Matrix4.prototype.toString = function() {
    return `(${this[0]}, ${this[4]}, ${this[8]}, ${this[12]})
(${this[1]}, ${this[5]}, ${this[9]}, ${this[13]})
(${this[2]}, ${this[6]}, ${this[10]}, ${this[14]})
(${this[3]}, ${this[7]}, ${this[11]}, ${this[15]})`;
  };
  var Matrix4_default = Matrix4;

  // Source/Core/WebGLConstants.js
  var WebGLConstants = {
    DEPTH_BUFFER_BIT: 256,
    STENCIL_BUFFER_BIT: 1024,
    COLOR_BUFFER_BIT: 16384,
    POINTS: 0,
    LINES: 1,
    LINE_LOOP: 2,
    LINE_STRIP: 3,
    TRIANGLES: 4,
    TRIANGLE_STRIP: 5,
    TRIANGLE_FAN: 6,
    ZERO: 0,
    ONE: 1,
    SRC_COLOR: 768,
    ONE_MINUS_SRC_COLOR: 769,
    SRC_ALPHA: 770,
    ONE_MINUS_SRC_ALPHA: 771,
    DST_ALPHA: 772,
    ONE_MINUS_DST_ALPHA: 773,
    DST_COLOR: 774,
    ONE_MINUS_DST_COLOR: 775,
    SRC_ALPHA_SATURATE: 776,
    FUNC_ADD: 32774,
    BLEND_EQUATION: 32777,
    BLEND_EQUATION_RGB: 32777,
    BLEND_EQUATION_ALPHA: 34877,
    FUNC_SUBTRACT: 32778,
    FUNC_REVERSE_SUBTRACT: 32779,
    BLEND_DST_RGB: 32968,
    BLEND_SRC_RGB: 32969,
    BLEND_DST_ALPHA: 32970,
    BLEND_SRC_ALPHA: 32971,
    CONSTANT_COLOR: 32769,
    ONE_MINUS_CONSTANT_COLOR: 32770,
    CONSTANT_ALPHA: 32771,
    ONE_MINUS_CONSTANT_ALPHA: 32772,
    BLEND_COLOR: 32773,
    ARRAY_BUFFER: 34962,
    ELEMENT_ARRAY_BUFFER: 34963,
    ARRAY_BUFFER_BINDING: 34964,
    ELEMENT_ARRAY_BUFFER_BINDING: 34965,
    STREAM_DRAW: 35040,
    STATIC_DRAW: 35044,
    DYNAMIC_DRAW: 35048,
    BUFFER_SIZE: 34660,
    BUFFER_USAGE: 34661,
    CURRENT_VERTEX_ATTRIB: 34342,
    FRONT: 1028,
    BACK: 1029,
    FRONT_AND_BACK: 1032,
    CULL_FACE: 2884,
    BLEND: 3042,
    DITHER: 3024,
    STENCIL_TEST: 2960,
    DEPTH_TEST: 2929,
    SCISSOR_TEST: 3089,
    POLYGON_OFFSET_FILL: 32823,
    SAMPLE_ALPHA_TO_COVERAGE: 32926,
    SAMPLE_COVERAGE: 32928,
    NO_ERROR: 0,
    INVALID_ENUM: 1280,
    INVALID_VALUE: 1281,
    INVALID_OPERATION: 1282,
    OUT_OF_MEMORY: 1285,
    CW: 2304,
    CCW: 2305,
    LINE_WIDTH: 2849,
    ALIASED_POINT_SIZE_RANGE: 33901,
    ALIASED_LINE_WIDTH_RANGE: 33902,
    CULL_FACE_MODE: 2885,
    FRONT_FACE: 2886,
    DEPTH_RANGE: 2928,
    DEPTH_WRITEMASK: 2930,
    DEPTH_CLEAR_VALUE: 2931,
    DEPTH_FUNC: 2932,
    STENCIL_CLEAR_VALUE: 2961,
    STENCIL_FUNC: 2962,
    STENCIL_FAIL: 2964,
    STENCIL_PASS_DEPTH_FAIL: 2965,
    STENCIL_PASS_DEPTH_PASS: 2966,
    STENCIL_REF: 2967,
    STENCIL_VALUE_MASK: 2963,
    STENCIL_WRITEMASK: 2968,
    STENCIL_BACK_FUNC: 34816,
    STENCIL_BACK_FAIL: 34817,
    STENCIL_BACK_PASS_DEPTH_FAIL: 34818,
    STENCIL_BACK_PASS_DEPTH_PASS: 34819,
    STENCIL_BACK_REF: 36003,
    STENCIL_BACK_VALUE_MASK: 36004,
    STENCIL_BACK_WRITEMASK: 36005,
    VIEWPORT: 2978,
    SCISSOR_BOX: 3088,
    COLOR_CLEAR_VALUE: 3106,
    COLOR_WRITEMASK: 3107,
    UNPACK_ALIGNMENT: 3317,
    PACK_ALIGNMENT: 3333,
    MAX_TEXTURE_SIZE: 3379,
    MAX_VIEWPORT_DIMS: 3386,
    SUBPIXEL_BITS: 3408,
    RED_BITS: 3410,
    GREEN_BITS: 3411,
    BLUE_BITS: 3412,
    ALPHA_BITS: 3413,
    DEPTH_BITS: 3414,
    STENCIL_BITS: 3415,
    POLYGON_OFFSET_UNITS: 10752,
    POLYGON_OFFSET_FACTOR: 32824,
    TEXTURE_BINDING_2D: 32873,
    SAMPLE_BUFFERS: 32936,
    SAMPLES: 32937,
    SAMPLE_COVERAGE_VALUE: 32938,
    SAMPLE_COVERAGE_INVERT: 32939,
    COMPRESSED_TEXTURE_FORMATS: 34467,
    DONT_CARE: 4352,
    FASTEST: 4353,
    NICEST: 4354,
    GENERATE_MIPMAP_HINT: 33170,
    BYTE: 5120,
    UNSIGNED_BYTE: 5121,
    SHORT: 5122,
    UNSIGNED_SHORT: 5123,
    INT: 5124,
    UNSIGNED_INT: 5125,
    FLOAT: 5126,
    DEPTH_COMPONENT: 6402,
    ALPHA: 6406,
    RGB: 6407,
    RGBA: 6408,
    LUMINANCE: 6409,
    LUMINANCE_ALPHA: 6410,
    UNSIGNED_SHORT_4_4_4_4: 32819,
    UNSIGNED_SHORT_5_5_5_1: 32820,
    UNSIGNED_SHORT_5_6_5: 33635,
    FRAGMENT_SHADER: 35632,
    VERTEX_SHADER: 35633,
    MAX_VERTEX_ATTRIBS: 34921,
    MAX_VERTEX_UNIFORM_VECTORS: 36347,
    MAX_VARYING_VECTORS: 36348,
    MAX_COMBINED_TEXTURE_IMAGE_UNITS: 35661,
    MAX_VERTEX_TEXTURE_IMAGE_UNITS: 35660,
    MAX_TEXTURE_IMAGE_UNITS: 34930,
    MAX_FRAGMENT_UNIFORM_VECTORS: 36349,
    SHADER_TYPE: 35663,
    DELETE_STATUS: 35712,
    LINK_STATUS: 35714,
    VALIDATE_STATUS: 35715,
    ATTACHED_SHADERS: 35717,
    ACTIVE_UNIFORMS: 35718,
    ACTIVE_ATTRIBUTES: 35721,
    SHADING_LANGUAGE_VERSION: 35724,
    CURRENT_PROGRAM: 35725,
    NEVER: 512,
    LESS: 513,
    EQUAL: 514,
    LEQUAL: 515,
    GREATER: 516,
    NOTEQUAL: 517,
    GEQUAL: 518,
    ALWAYS: 519,
    KEEP: 7680,
    REPLACE: 7681,
    INCR: 7682,
    DECR: 7683,
    INVERT: 5386,
    INCR_WRAP: 34055,
    DECR_WRAP: 34056,
    VENDOR: 7936,
    RENDERER: 7937,
    VERSION: 7938,
    NEAREST: 9728,
    LINEAR: 9729,
    NEAREST_MIPMAP_NEAREST: 9984,
    LINEAR_MIPMAP_NEAREST: 9985,
    NEAREST_MIPMAP_LINEAR: 9986,
    LINEAR_MIPMAP_LINEAR: 9987,
    TEXTURE_MAG_FILTER: 10240,
    TEXTURE_MIN_FILTER: 10241,
    TEXTURE_WRAP_S: 10242,
    TEXTURE_WRAP_T: 10243,
    TEXTURE_2D: 3553,
    TEXTURE: 5890,
    TEXTURE_CUBE_MAP: 34067,
    TEXTURE_BINDING_CUBE_MAP: 34068,
    TEXTURE_CUBE_MAP_POSITIVE_X: 34069,
    TEXTURE_CUBE_MAP_NEGATIVE_X: 34070,
    TEXTURE_CUBE_MAP_POSITIVE_Y: 34071,
    TEXTURE_CUBE_MAP_NEGATIVE_Y: 34072,
    TEXTURE_CUBE_MAP_POSITIVE_Z: 34073,
    TEXTURE_CUBE_MAP_NEGATIVE_Z: 34074,
    MAX_CUBE_MAP_TEXTURE_SIZE: 34076,
    TEXTURE0: 33984,
    TEXTURE1: 33985,
    TEXTURE2: 33986,
    TEXTURE3: 33987,
    TEXTURE4: 33988,
    TEXTURE5: 33989,
    TEXTURE6: 33990,
    TEXTURE7: 33991,
    TEXTURE8: 33992,
    TEXTURE9: 33993,
    TEXTURE10: 33994,
    TEXTURE11: 33995,
    TEXTURE12: 33996,
    TEXTURE13: 33997,
    TEXTURE14: 33998,
    TEXTURE15: 33999,
    TEXTURE16: 34e3,
    TEXTURE17: 34001,
    TEXTURE18: 34002,
    TEXTURE19: 34003,
    TEXTURE20: 34004,
    TEXTURE21: 34005,
    TEXTURE22: 34006,
    TEXTURE23: 34007,
    TEXTURE24: 34008,
    TEXTURE25: 34009,
    TEXTURE26: 34010,
    TEXTURE27: 34011,
    TEXTURE28: 34012,
    TEXTURE29: 34013,
    TEXTURE30: 34014,
    TEXTURE31: 34015,
    ACTIVE_TEXTURE: 34016,
    REPEAT: 10497,
    CLAMP_TO_EDGE: 33071,
    MIRRORED_REPEAT: 33648,
    FLOAT_VEC2: 35664,
    FLOAT_VEC3: 35665,
    FLOAT_VEC4: 35666,
    INT_VEC2: 35667,
    INT_VEC3: 35668,
    INT_VEC4: 35669,
    BOOL: 35670,
    BOOL_VEC2: 35671,
    BOOL_VEC3: 35672,
    BOOL_VEC4: 35673,
    FLOAT_MAT2: 35674,
    FLOAT_MAT3: 35675,
    FLOAT_MAT4: 35676,
    SAMPLER_2D: 35678,
    SAMPLER_CUBE: 35680,
    VERTEX_ATTRIB_ARRAY_ENABLED: 34338,
    VERTEX_ATTRIB_ARRAY_SIZE: 34339,
    VERTEX_ATTRIB_ARRAY_STRIDE: 34340,
    VERTEX_ATTRIB_ARRAY_TYPE: 34341,
    VERTEX_ATTRIB_ARRAY_NORMALIZED: 34922,
    VERTEX_ATTRIB_ARRAY_POINTER: 34373,
    VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 34975,
    IMPLEMENTATION_COLOR_READ_TYPE: 35738,
    IMPLEMENTATION_COLOR_READ_FORMAT: 35739,
    COMPILE_STATUS: 35713,
    LOW_FLOAT: 36336,
    MEDIUM_FLOAT: 36337,
    HIGH_FLOAT: 36338,
    LOW_INT: 36339,
    MEDIUM_INT: 36340,
    HIGH_INT: 36341,
    FRAMEBUFFER: 36160,
    RENDERBUFFER: 36161,
    RGBA4: 32854,
    RGB5_A1: 32855,
    RGB565: 36194,
    DEPTH_COMPONENT16: 33189,
    STENCIL_INDEX: 6401,
    STENCIL_INDEX8: 36168,
    DEPTH_STENCIL: 34041,
    RENDERBUFFER_WIDTH: 36162,
    RENDERBUFFER_HEIGHT: 36163,
    RENDERBUFFER_INTERNAL_FORMAT: 36164,
    RENDERBUFFER_RED_SIZE: 36176,
    RENDERBUFFER_GREEN_SIZE: 36177,
    RENDERBUFFER_BLUE_SIZE: 36178,
    RENDERBUFFER_ALPHA_SIZE: 36179,
    RENDERBUFFER_DEPTH_SIZE: 36180,
    RENDERBUFFER_STENCIL_SIZE: 36181,
    FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 36048,
    FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 36049,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 36050,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 36051,
    COLOR_ATTACHMENT0: 36064,
    DEPTH_ATTACHMENT: 36096,
    STENCIL_ATTACHMENT: 36128,
    DEPTH_STENCIL_ATTACHMENT: 33306,
    NONE: 0,
    FRAMEBUFFER_COMPLETE: 36053,
    FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 36054,
    FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 36055,
    FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 36057,
    FRAMEBUFFER_UNSUPPORTED: 36061,
    FRAMEBUFFER_BINDING: 36006,
    RENDERBUFFER_BINDING: 36007,
    MAX_RENDERBUFFER_SIZE: 34024,
    INVALID_FRAMEBUFFER_OPERATION: 1286,
    UNPACK_FLIP_Y_WEBGL: 37440,
    UNPACK_PREMULTIPLY_ALPHA_WEBGL: 37441,
    CONTEXT_LOST_WEBGL: 37442,
    UNPACK_COLORSPACE_CONVERSION_WEBGL: 37443,
    BROWSER_DEFAULT_WEBGL: 37444,
    COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
    COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
    COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
    COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
    COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
    COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
    COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
    COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
    COMPRESSED_RGBA_ASTC_4x4_WEBGL: 37808,
    COMPRESSED_RGB_ETC1_WEBGL: 36196,
    COMPRESSED_RGBA_BPTC_UNORM: 36492,
    HALF_FLOAT_OES: 36193,
    DOUBLE: 5130,
    READ_BUFFER: 3074,
    UNPACK_ROW_LENGTH: 3314,
    UNPACK_SKIP_ROWS: 3315,
    UNPACK_SKIP_PIXELS: 3316,
    PACK_ROW_LENGTH: 3330,
    PACK_SKIP_ROWS: 3331,
    PACK_SKIP_PIXELS: 3332,
    COLOR: 6144,
    DEPTH: 6145,
    STENCIL: 6146,
    RED: 6403,
    RGB8: 32849,
    RGBA8: 32856,
    RGB10_A2: 32857,
    TEXTURE_BINDING_3D: 32874,
    UNPACK_SKIP_IMAGES: 32877,
    UNPACK_IMAGE_HEIGHT: 32878,
    TEXTURE_3D: 32879,
    TEXTURE_WRAP_R: 32882,
    MAX_3D_TEXTURE_SIZE: 32883,
    UNSIGNED_INT_2_10_10_10_REV: 33640,
    MAX_ELEMENTS_VERTICES: 33e3,
    MAX_ELEMENTS_INDICES: 33001,
    TEXTURE_MIN_LOD: 33082,
    TEXTURE_MAX_LOD: 33083,
    TEXTURE_BASE_LEVEL: 33084,
    TEXTURE_MAX_LEVEL: 33085,
    MIN: 32775,
    MAX: 32776,
    DEPTH_COMPONENT24: 33190,
    MAX_TEXTURE_LOD_BIAS: 34045,
    TEXTURE_COMPARE_MODE: 34892,
    TEXTURE_COMPARE_FUNC: 34893,
    CURRENT_QUERY: 34917,
    QUERY_RESULT: 34918,
    QUERY_RESULT_AVAILABLE: 34919,
    STREAM_READ: 35041,
    STREAM_COPY: 35042,
    STATIC_READ: 35045,
    STATIC_COPY: 35046,
    DYNAMIC_READ: 35049,
    DYNAMIC_COPY: 35050,
    MAX_DRAW_BUFFERS: 34852,
    DRAW_BUFFER0: 34853,
    DRAW_BUFFER1: 34854,
    DRAW_BUFFER2: 34855,
    DRAW_BUFFER3: 34856,
    DRAW_BUFFER4: 34857,
    DRAW_BUFFER5: 34858,
    DRAW_BUFFER6: 34859,
    DRAW_BUFFER7: 34860,
    DRAW_BUFFER8: 34861,
    DRAW_BUFFER9: 34862,
    DRAW_BUFFER10: 34863,
    DRAW_BUFFER11: 34864,
    DRAW_BUFFER12: 34865,
    DRAW_BUFFER13: 34866,
    DRAW_BUFFER14: 34867,
    DRAW_BUFFER15: 34868,
    MAX_FRAGMENT_UNIFORM_COMPONENTS: 35657,
    MAX_VERTEX_UNIFORM_COMPONENTS: 35658,
    SAMPLER_3D: 35679,
    SAMPLER_2D_SHADOW: 35682,
    FRAGMENT_SHADER_DERIVATIVE_HINT: 35723,
    PIXEL_PACK_BUFFER: 35051,
    PIXEL_UNPACK_BUFFER: 35052,
    PIXEL_PACK_BUFFER_BINDING: 35053,
    PIXEL_UNPACK_BUFFER_BINDING: 35055,
    FLOAT_MAT2x3: 35685,
    FLOAT_MAT2x4: 35686,
    FLOAT_MAT3x2: 35687,
    FLOAT_MAT3x4: 35688,
    FLOAT_MAT4x2: 35689,
    FLOAT_MAT4x3: 35690,
    SRGB: 35904,
    SRGB8: 35905,
    SRGB8_ALPHA8: 35907,
    COMPARE_REF_TO_TEXTURE: 34894,
    RGBA32F: 34836,
    RGB32F: 34837,
    RGBA16F: 34842,
    RGB16F: 34843,
    VERTEX_ATTRIB_ARRAY_INTEGER: 35069,
    MAX_ARRAY_TEXTURE_LAYERS: 35071,
    MIN_PROGRAM_TEXEL_OFFSET: 35076,
    MAX_PROGRAM_TEXEL_OFFSET: 35077,
    MAX_VARYING_COMPONENTS: 35659,
    TEXTURE_2D_ARRAY: 35866,
    TEXTURE_BINDING_2D_ARRAY: 35869,
    R11F_G11F_B10F: 35898,
    UNSIGNED_INT_10F_11F_11F_REV: 35899,
    RGB9_E5: 35901,
    UNSIGNED_INT_5_9_9_9_REV: 35902,
    TRANSFORM_FEEDBACK_BUFFER_MODE: 35967,
    MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 35968,
    TRANSFORM_FEEDBACK_VARYINGS: 35971,
    TRANSFORM_FEEDBACK_BUFFER_START: 35972,
    TRANSFORM_FEEDBACK_BUFFER_SIZE: 35973,
    TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 35976,
    RASTERIZER_DISCARD: 35977,
    MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 35978,
    MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 35979,
    INTERLEAVED_ATTRIBS: 35980,
    SEPARATE_ATTRIBS: 35981,
    TRANSFORM_FEEDBACK_BUFFER: 35982,
    TRANSFORM_FEEDBACK_BUFFER_BINDING: 35983,
    RGBA32UI: 36208,
    RGB32UI: 36209,
    RGBA16UI: 36214,
    RGB16UI: 36215,
    RGBA8UI: 36220,
    RGB8UI: 36221,
    RGBA32I: 36226,
    RGB32I: 36227,
    RGBA16I: 36232,
    RGB16I: 36233,
    RGBA8I: 36238,
    RGB8I: 36239,
    RED_INTEGER: 36244,
    RGB_INTEGER: 36248,
    RGBA_INTEGER: 36249,
    SAMPLER_2D_ARRAY: 36289,
    SAMPLER_2D_ARRAY_SHADOW: 36292,
    SAMPLER_CUBE_SHADOW: 36293,
    UNSIGNED_INT_VEC2: 36294,
    UNSIGNED_INT_VEC3: 36295,
    UNSIGNED_INT_VEC4: 36296,
    INT_SAMPLER_2D: 36298,
    INT_SAMPLER_3D: 36299,
    INT_SAMPLER_CUBE: 36300,
    INT_SAMPLER_2D_ARRAY: 36303,
    UNSIGNED_INT_SAMPLER_2D: 36306,
    UNSIGNED_INT_SAMPLER_3D: 36307,
    UNSIGNED_INT_SAMPLER_CUBE: 36308,
    UNSIGNED_INT_SAMPLER_2D_ARRAY: 36311,
    DEPTH_COMPONENT32F: 36012,
    DEPTH32F_STENCIL8: 36013,
    FLOAT_32_UNSIGNED_INT_24_8_REV: 36269,
    FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 33296,
    FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 33297,
    FRAMEBUFFER_ATTACHMENT_RED_SIZE: 33298,
    FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 33299,
    FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 33300,
    FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 33301,
    FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 33302,
    FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 33303,
    FRAMEBUFFER_DEFAULT: 33304,
    UNSIGNED_INT_24_8: 34042,
    DEPTH24_STENCIL8: 35056,
    UNSIGNED_NORMALIZED: 35863,
    DRAW_FRAMEBUFFER_BINDING: 36006,
    READ_FRAMEBUFFER: 36008,
    DRAW_FRAMEBUFFER: 36009,
    READ_FRAMEBUFFER_BINDING: 36010,
    RENDERBUFFER_SAMPLES: 36011,
    FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 36052,
    MAX_COLOR_ATTACHMENTS: 36063,
    COLOR_ATTACHMENT1: 36065,
    COLOR_ATTACHMENT2: 36066,
    COLOR_ATTACHMENT3: 36067,
    COLOR_ATTACHMENT4: 36068,
    COLOR_ATTACHMENT5: 36069,
    COLOR_ATTACHMENT6: 36070,
    COLOR_ATTACHMENT7: 36071,
    COLOR_ATTACHMENT8: 36072,
    COLOR_ATTACHMENT9: 36073,
    COLOR_ATTACHMENT10: 36074,
    COLOR_ATTACHMENT11: 36075,
    COLOR_ATTACHMENT12: 36076,
    COLOR_ATTACHMENT13: 36077,
    COLOR_ATTACHMENT14: 36078,
    COLOR_ATTACHMENT15: 36079,
    FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 36182,
    MAX_SAMPLES: 36183,
    HALF_FLOAT: 5131,
    RG: 33319,
    RG_INTEGER: 33320,
    R8: 33321,
    RG8: 33323,
    R16F: 33325,
    R32F: 33326,
    RG16F: 33327,
    RG32F: 33328,
    R8I: 33329,
    R8UI: 33330,
    R16I: 33331,
    R16UI: 33332,
    R32I: 33333,
    R32UI: 33334,
    RG8I: 33335,
    RG8UI: 33336,
    RG16I: 33337,
    RG16UI: 33338,
    RG32I: 33339,
    RG32UI: 33340,
    VERTEX_ARRAY_BINDING: 34229,
    R8_SNORM: 36756,
    RG8_SNORM: 36757,
    RGB8_SNORM: 36758,
    RGBA8_SNORM: 36759,
    SIGNED_NORMALIZED: 36764,
    COPY_READ_BUFFER: 36662,
    COPY_WRITE_BUFFER: 36663,
    COPY_READ_BUFFER_BINDING: 36662,
    COPY_WRITE_BUFFER_BINDING: 36663,
    UNIFORM_BUFFER: 35345,
    UNIFORM_BUFFER_BINDING: 35368,
    UNIFORM_BUFFER_START: 35369,
    UNIFORM_BUFFER_SIZE: 35370,
    MAX_VERTEX_UNIFORM_BLOCKS: 35371,
    MAX_FRAGMENT_UNIFORM_BLOCKS: 35373,
    MAX_COMBINED_UNIFORM_BLOCKS: 35374,
    MAX_UNIFORM_BUFFER_BINDINGS: 35375,
    MAX_UNIFORM_BLOCK_SIZE: 35376,
    MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 35377,
    MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 35379,
    UNIFORM_BUFFER_OFFSET_ALIGNMENT: 35380,
    ACTIVE_UNIFORM_BLOCKS: 35382,
    UNIFORM_TYPE: 35383,
    UNIFORM_SIZE: 35384,
    UNIFORM_BLOCK_INDEX: 35386,
    UNIFORM_OFFSET: 35387,
    UNIFORM_ARRAY_STRIDE: 35388,
    UNIFORM_MATRIX_STRIDE: 35389,
    UNIFORM_IS_ROW_MAJOR: 35390,
    UNIFORM_BLOCK_BINDING: 35391,
    UNIFORM_BLOCK_DATA_SIZE: 35392,
    UNIFORM_BLOCK_ACTIVE_UNIFORMS: 35394,
    UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 35395,
    UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 35396,
    UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 35398,
    INVALID_INDEX: 4294967295,
    MAX_VERTEX_OUTPUT_COMPONENTS: 37154,
    MAX_FRAGMENT_INPUT_COMPONENTS: 37157,
    MAX_SERVER_WAIT_TIMEOUT: 37137,
    OBJECT_TYPE: 37138,
    SYNC_CONDITION: 37139,
    SYNC_STATUS: 37140,
    SYNC_FLAGS: 37141,
    SYNC_FENCE: 37142,
    SYNC_GPU_COMMANDS_COMPLETE: 37143,
    UNSIGNALED: 37144,
    SIGNALED: 37145,
    ALREADY_SIGNALED: 37146,
    TIMEOUT_EXPIRED: 37147,
    CONDITION_SATISFIED: 37148,
    WAIT_FAILED: 37149,
    SYNC_FLUSH_COMMANDS_BIT: 1,
    VERTEX_ATTRIB_ARRAY_DIVISOR: 35070,
    ANY_SAMPLES_PASSED: 35887,
    ANY_SAMPLES_PASSED_CONSERVATIVE: 36202,
    SAMPLER_BINDING: 35097,
    RGB10_A2UI: 36975,
    INT_2_10_10_10_REV: 36255,
    TRANSFORM_FEEDBACK: 36386,
    TRANSFORM_FEEDBACK_PAUSED: 36387,
    TRANSFORM_FEEDBACK_ACTIVE: 36388,
    TRANSFORM_FEEDBACK_BINDING: 36389,
    COMPRESSED_R11_EAC: 37488,
    COMPRESSED_SIGNED_R11_EAC: 37489,
    COMPRESSED_RG11_EAC: 37490,
    COMPRESSED_SIGNED_RG11_EAC: 37491,
    COMPRESSED_RGB8_ETC2: 37492,
    COMPRESSED_SRGB8_ETC2: 37493,
    COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37494,
    COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37495,
    COMPRESSED_RGBA8_ETC2_EAC: 37496,
    COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37497,
    TEXTURE_IMMUTABLE_FORMAT: 37167,
    MAX_ELEMENT_INDEX: 36203,
    TEXTURE_IMMUTABLE_LEVELS: 33503,
    MAX_TEXTURE_MAX_ANISOTROPY_EXT: 34047
  };
  var WebGLConstants_default = Object.freeze(WebGLConstants);

  // Source/Renderer/AutomaticUniforms.js
  var viewerPositionWCScratch = new Cartesian3_default();
  function AutomaticUniform(options) {
    this._size = options.size;
    this._datatype = options.datatype;
    this.getValue = options.getValue;
  }
  var datatypeToGlsl = {};
  datatypeToGlsl[WebGLConstants_default.FLOAT] = "float";
  datatypeToGlsl[WebGLConstants_default.FLOAT_VEC2] = "vec2";
  datatypeToGlsl[WebGLConstants_default.FLOAT_VEC3] = "vec3";
  datatypeToGlsl[WebGLConstants_default.FLOAT_VEC4] = "vec4";
  datatypeToGlsl[WebGLConstants_default.INT] = "int";
  datatypeToGlsl[WebGLConstants_default.INT_VEC2] = "ivec2";
  datatypeToGlsl[WebGLConstants_default.INT_VEC3] = "ivec3";
  datatypeToGlsl[WebGLConstants_default.INT_VEC4] = "ivec4";
  datatypeToGlsl[WebGLConstants_default.BOOL] = "bool";
  datatypeToGlsl[WebGLConstants_default.BOOL_VEC2] = "bvec2";
  datatypeToGlsl[WebGLConstants_default.BOOL_VEC3] = "bvec3";
  datatypeToGlsl[WebGLConstants_default.BOOL_VEC4] = "bvec4";
  datatypeToGlsl[WebGLConstants_default.FLOAT_MAT2] = "mat2";
  datatypeToGlsl[WebGLConstants_default.FLOAT_MAT3] = "mat3";
  datatypeToGlsl[WebGLConstants_default.FLOAT_MAT4] = "mat4";
  datatypeToGlsl[WebGLConstants_default.SAMPLER_2D] = "sampler2D";
  datatypeToGlsl[WebGLConstants_default.SAMPLER_CUBE] = "samplerCube";
  AutomaticUniform.prototype.getDeclaration = function(name) {
    let declaration = `uniform ${datatypeToGlsl[this._datatype]} ${name}`;
    const size = this._size;
    if (size === 1) {
      declaration += ";";
    } else {
      declaration += `[${size.toString()}];`;
    }
    return declaration;
  };
  var AutomaticUniforms = {
    czm_viewport: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC4,
      getValue: function(uniformState) {
        return uniformState.viewportCartesian4;
      }
    }),
    czm_viewportOrthographic: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.viewportOrthographic;
      }
    }),
    czm_viewportTransformation: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.viewportTransformation;
      }
    }),
    czm_globeDepthTexture: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.SAMPLER_2D,
      getValue: function(uniformState) {
        return uniformState.globeDepthTexture;
      }
    }),
    czm_model: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.model;
      }
    }),
    czm_inverseModel: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.inverseModel;
      }
    }),
    czm_view: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.view;
      }
    }),
    czm_view3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.view3D;
      }
    }),
    czm_viewRotation: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.viewRotation;
      }
    }),
    czm_viewRotation3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.viewRotation3D;
      }
    }),
    czm_inverseView: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.inverseView;
      }
    }),
    czm_inverseView3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.inverseView3D;
      }
    }),
    czm_inverseViewRotation: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.inverseViewRotation;
      }
    }),
    czm_inverseViewRotation3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.inverseViewRotation3D;
      }
    }),
    czm_projection: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.projection;
      }
    }),
    czm_inverseProjection: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.inverseProjection;
      }
    }),
    czm_infiniteProjection: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.infiniteProjection;
      }
    }),
    czm_modelView: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.modelView;
      }
    }),
    czm_modelView3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.modelView3D;
      }
    }),
    czm_modelViewRelativeToEye: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.modelViewRelativeToEye;
      }
    }),
    czm_inverseModelView: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.inverseModelView;
      }
    }),
    czm_inverseModelView3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.inverseModelView3D;
      }
    }),
    czm_viewProjection: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.viewProjection;
      }
    }),
    czm_inverseViewProjection: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.inverseViewProjection;
      }
    }),
    czm_modelViewProjection: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.modelViewProjection;
      }
    }),
    czm_inverseModelViewProjection: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.inverseModelViewProjection;
      }
    }),
    czm_modelViewProjectionRelativeToEye: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.modelViewProjectionRelativeToEye;
      }
    }),
    czm_modelViewInfiniteProjection: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT4,
      getValue: function(uniformState) {
        return uniformState.modelViewInfiniteProjection;
      }
    }),
    czm_orthographicIn3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.orthographicIn3D ? 1 : 0;
      }
    }),
    czm_normal: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.normal;
      }
    }),
    czm_normal3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.normal3D;
      }
    }),
    czm_inverseNormal: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.inverseNormal;
      }
    }),
    czm_inverseNormal3D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.inverseNormal3D;
      }
    }),
    czm_eyeHeight: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.eyeHeight;
      }
    }),
    czm_eyeHeight2D: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC2,
      getValue: function(uniformState) {
        return uniformState.eyeHeight2D;
      }
    }),
    czm_entireFrustum: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC2,
      getValue: function(uniformState) {
        return uniformState.entireFrustum;
      }
    }),
    czm_currentFrustum: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC2,
      getValue: function(uniformState) {
        return uniformState.currentFrustum;
      }
    }),
    czm_frustumPlanes: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC4,
      getValue: function(uniformState) {
        return uniformState.frustumPlanes;
      }
    }),
    czm_farDepthFromNearPlusOne: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.farDepthFromNearPlusOne;
      }
    }),
    czm_log2FarDepthFromNearPlusOne: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.log2FarDepthFromNearPlusOne;
      }
    }),
    czm_oneOverLog2FarDepthFromNearPlusOne: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.oneOverLog2FarDepthFromNearPlusOne;
      }
    }),
    czm_sunPositionWC: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.sunPositionWC;
      }
    }),
    czm_sunPositionColumbusView: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.sunPositionColumbusView;
      }
    }),
    czm_sunDirectionEC: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.sunDirectionEC;
      }
    }),
    czm_sunDirectionWC: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.sunDirectionWC;
      }
    }),
    czm_moonDirectionEC: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.moonDirectionEC;
      }
    }),
    czm_lightDirectionEC: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.lightDirectionEC;
      }
    }),
    czm_lightDirectionWC: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.lightDirectionWC;
      }
    }),
    czm_lightColor: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.lightColor;
      }
    }),
    czm_lightColorHdr: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.lightColorHdr;
      }
    }),
    czm_encodedCameraPositionMCHigh: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.encodedCameraPositionMCHigh;
      }
    }),
    czm_encodedCameraPositionMCLow: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.encodedCameraPositionMCLow;
      }
    }),
    czm_viewerPositionWC: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return Matrix4_default.getTranslation(
          uniformState.inverseView,
          viewerPositionWCScratch
        );
      }
    }),
    czm_frameNumber: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.frameState.frameNumber;
      }
    }),
    czm_morphTime: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.frameState.morphTime;
      }
    }),
    czm_sceneMode: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.frameState.mode;
      }
    }),
    czm_pass: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.pass;
      }
    }),
    czm_backgroundColor: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC4,
      getValue: function(uniformState) {
        return uniformState.backgroundColor;
      }
    }),
    czm_brdfLut: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.SAMPLER_2D,
      getValue: function(uniformState) {
        return uniformState.brdfLut;
      }
    }),
    czm_environmentMap: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.SAMPLER_CUBE,
      getValue: function(uniformState) {
        return uniformState.environmentMap;
      }
    }),
    czm_specularEnvironmentMaps: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.SAMPLER_2D,
      getValue: function(uniformState) {
        return uniformState.specularEnvironmentMaps;
      }
    }),
    czm_specularEnvironmentMapSize: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC2,
      getValue: function(uniformState) {
        return uniformState.specularEnvironmentMapsDimensions;
      }
    }),
    czm_specularEnvironmentMapsMaximumLOD: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.specularEnvironmentMapsMaximumLOD;
      }
    }),
    czm_sphericalHarmonicCoefficients: new AutomaticUniform({
      size: 9,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.sphericalHarmonicCoefficients;
      }
    }),
    czm_temeToPseudoFixed: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_MAT3,
      getValue: function(uniformState) {
        return uniformState.temeToPseudoFixedMatrix;
      }
    }),
    czm_pixelRatio: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.pixelRatio;
      }
    }),
    czm_fogDensity: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.fogDensity;
      }
    }),
    czm_splitPosition: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.splitPosition;
      }
    }),
    czm_geometricToleranceOverMeter: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.geometricToleranceOverMeter;
      }
    }),
    czm_minimumDisableDepthTestDistance: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.minimumDisableDepthTestDistance;
      }
    }),
    czm_invertClassificationColor: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC4,
      getValue: function(uniformState) {
        return uniformState.invertClassificationColor;
      }
    }),
    czm_gamma: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT,
      getValue: function(uniformState) {
        return uniformState.gamma;
      }
    }),
    czm_ellipsoidRadii: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.ellipsoid.radii;
      }
    }),
    czm_ellipsoidInverseRadii: new AutomaticUniform({
      size: 1,
      datatype: WebGLConstants_default.FLOAT_VEC3,
      getValue: function(uniformState) {
        return uniformState.ellipsoid.oneOverRadii;
      }
    })
  };
  var AutomaticUniforms_default = AutomaticUniforms;

  // Source/Core/createGuid.js
  function createGuid() {
    return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c) {
      const r = Math.random() * 16 | 0;
      const v7 = c === "x" ? r : r & 3 | 8;
      return v7.toString(16);
    });
  }
  var createGuid_default = createGuid;

  // Source/Core/destroyObject.js
  function returnTrue() {
    return true;
  }
  function destroyObject(object2, message) {
    message = defaultValue_default(
      message,
      "This object was destroyed, i.e., destroy() was called."
    );
    function throwOnDestroyed() {
      throw new DeveloperError_default(message);
    }
    for (const key in object2) {
      if (typeof object2[key] === "function") {
        object2[key] = throwOnDestroyed;
      }
    }
    object2.isDestroyed = returnTrue;
    return void 0;
  }
  var destroyObject_default = destroyObject;

  // Source/Core/IndexDatatype.js
  var IndexDatatype = {
    UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
    UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
    UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT
  };
  IndexDatatype.getSizeInBytes = function(indexDatatype) {
    switch (indexDatatype) {
      case IndexDatatype.UNSIGNED_BYTE:
        return Uint8Array.BYTES_PER_ELEMENT;
      case IndexDatatype.UNSIGNED_SHORT:
        return Uint16Array.BYTES_PER_ELEMENT;
      case IndexDatatype.UNSIGNED_INT:
        return Uint32Array.BYTES_PER_ELEMENT;
    }
    throw new DeveloperError_default(
      "indexDatatype is required and must be a valid IndexDatatype constant."
    );
  };
  IndexDatatype.fromSizeInBytes = function(sizeInBytes) {
    switch (sizeInBytes) {
      case 2:
        return IndexDatatype.UNSIGNED_SHORT;
      case 4:
        return IndexDatatype.UNSIGNED_INT;
      case 1:
        return IndexDatatype.UNSIGNED_BYTE;
      default:
        throw new DeveloperError_default(
          "Size in bytes cannot be mapped to an IndexDatatype"
        );
    }
  };
  IndexDatatype.validate = function(indexDatatype) {
    return defined_default(indexDatatype) && (indexDatatype === IndexDatatype.UNSIGNED_BYTE || indexDatatype === IndexDatatype.UNSIGNED_SHORT || indexDatatype === IndexDatatype.UNSIGNED_INT);
  };
  IndexDatatype.createTypedArray = function(numberOfVertices, indicesLengthOrArray) {
    if (!defined_default(numberOfVertices)) {
      throw new DeveloperError_default("numberOfVertices is required.");
    }
    if (numberOfVertices >= Math_default.SIXTY_FOUR_KILOBYTES) {
      return new Uint32Array(indicesLengthOrArray);
    }
    return new Uint16Array(indicesLengthOrArray);
  };
  IndexDatatype.createTypedArrayFromArrayBuffer = function(numberOfVertices, sourceArray, byteOffset, length3) {
    if (!defined_default(numberOfVertices)) {
      throw new DeveloperError_default("numberOfVertices is required.");
    }
    if (!defined_default(sourceArray)) {
      throw new DeveloperError_default("sourceArray is required.");
    }
    if (!defined_default(byteOffset)) {
      throw new DeveloperError_default("byteOffset is required.");
    }
    if (numberOfVertices >= Math_default.SIXTY_FOUR_KILOBYTES) {
      return new Uint32Array(sourceArray, byteOffset, length3);
    }
    return new Uint16Array(sourceArray, byteOffset, length3);
  };
  IndexDatatype.fromTypedArray = function(array) {
    if (array instanceof Uint8Array) {
      return IndexDatatype.UNSIGNED_BYTE;
    }
    if (array instanceof Uint16Array) {
      return IndexDatatype.UNSIGNED_SHORT;
    }
    if (array instanceof Uint32Array) {
      return IndexDatatype.UNSIGNED_INT;
    }
    throw new DeveloperError_default(
      "array must be a Uint8Array, Uint16Array, or Uint32Array."
    );
  };
  var IndexDatatype_default = Object.freeze(IndexDatatype);

  // Source/Renderer/BufferUsage.js
  var BufferUsage = {
    STREAM_DRAW: WebGLConstants_default.STREAM_DRAW,
    STATIC_DRAW: WebGLConstants_default.STATIC_DRAW,
    DYNAMIC_DRAW: WebGLConstants_default.DYNAMIC_DRAW,
    validate: function(bufferUsage) {
      return bufferUsage === BufferUsage.STREAM_DRAW || bufferUsage === BufferUsage.STATIC_DRAW || bufferUsage === BufferUsage.DYNAMIC_DRAW;
    }
  };
  var BufferUsage_default = Object.freeze(BufferUsage);

  // Source/Renderer/Buffer.js
  function Buffer2(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    Check_default.defined("options.context", options.context);
    if (!defined_default(options.typedArray) && !defined_default(options.sizeInBytes)) {
      throw new DeveloperError_default(
        "Either options.sizeInBytes or options.typedArray is required."
      );
    }
    if (defined_default(options.typedArray) && defined_default(options.sizeInBytes)) {
      throw new DeveloperError_default(
        "Cannot pass in both options.sizeInBytes and options.typedArray."
      );
    }
    if (defined_default(options.typedArray)) {
      Check_default.typeOf.object("options.typedArray", options.typedArray);
      Check_default.typeOf.number(
        "options.typedArray.byteLength",
        options.typedArray.byteLength
      );
    }
    if (!BufferUsage_default.validate(options.usage)) {
      throw new DeveloperError_default("usage is invalid.");
    }
    const gl = options.context._gl;
    const bufferTarget = options.bufferTarget;
    const typedArray = options.typedArray;
    let sizeInBytes = options.sizeInBytes;
    const usage = options.usage;
    const hasArray = defined_default(typedArray);
    if (hasArray) {
      sizeInBytes = typedArray.byteLength;
    }
    Check_default.typeOf.number.greaterThan("sizeInBytes", sizeInBytes, 0);
    const buffer = gl.createBuffer();
    gl.bindBuffer(bufferTarget, buffer);
    gl.bufferData(bufferTarget, hasArray ? typedArray : sizeInBytes, usage);
    gl.bindBuffer(bufferTarget, null);
    this._id = createGuid_default();
    this._gl = gl;
    this._webgl2 = options.context._webgl2;
    this._bufferTarget = bufferTarget;
    this._sizeInBytes = sizeInBytes;
    this._usage = usage;
    this._buffer = buffer;
    this.vertexArrayDestroyable = true;
  }
  Buffer2.createVertexBuffer = function(options) {
    Check_default.defined("options.context", options.context);
    return new Buffer2({
      context: options.context,
      bufferTarget: WebGLConstants_default.ARRAY_BUFFER,
      typedArray: options.typedArray,
      sizeInBytes: options.sizeInBytes,
      usage: options.usage
    });
  };
  Buffer2.createIndexBuffer = function(options) {
    Check_default.defined("options.context", options.context);
    if (!IndexDatatype_default.validate(options.indexDatatype)) {
      throw new DeveloperError_default("Invalid indexDatatype.");
    }
    if (options.indexDatatype === IndexDatatype_default.UNSIGNED_INT && !options.context.elementIndexUint) {
      throw new DeveloperError_default(
        "IndexDatatype.UNSIGNED_INT requires OES_element_index_uint, which is not supported on this system.  Check context.elementIndexUint."
      );
    }
    const context = options.context;
    const indexDatatype = options.indexDatatype;
    const bytesPerIndex = IndexDatatype_default.getSizeInBytes(indexDatatype);
    const buffer = new Buffer2({
      context,
      bufferTarget: WebGLConstants_default.ELEMENT_ARRAY_BUFFER,
      typedArray: options.typedArray,
      sizeInBytes: options.sizeInBytes,
      usage: options.usage
    });
    const numberOfIndices = buffer.sizeInBytes / bytesPerIndex;
    Object.defineProperties(buffer, {
      indexDatatype: {
        get: function() {
          return indexDatatype;
        }
      },
      bytesPerIndex: {
        get: function() {
          return bytesPerIndex;
        }
      },
      numberOfIndices: {
        get: function() {
          return numberOfIndices;
        }
      }
    });
    return buffer;
  };
  Object.defineProperties(Buffer2.prototype, {
    sizeInBytes: {
      get: function() {
        return this._sizeInBytes;
      }
    },
    usage: {
      get: function() {
        return this._usage;
      }
    }
  });
  Buffer2.prototype._getBuffer = function() {
    return this._buffer;
  };
  Buffer2.prototype.copyFromArrayView = function(arrayView, offsetInBytes) {
    offsetInBytes = defaultValue_default(offsetInBytes, 0);
    Check_default.defined("arrayView", arrayView);
    Check_default.typeOf.number.lessThanOrEquals(
      "offsetInBytes + arrayView.byteLength",
      offsetInBytes + arrayView.byteLength,
      this._sizeInBytes
    );
    const gl = this._gl;
    const target = this._bufferTarget;
    gl.bindBuffer(target, this._buffer);
    gl.bufferSubData(target, offsetInBytes, arrayView);
    gl.bindBuffer(target, null);
  };
  Buffer2.prototype.copyFromBuffer = function(readBuffer, readOffset, writeOffset, sizeInBytes) {
    if (!this._webgl2) {
      throw new DeveloperError_default("A WebGL 2 context is required.");
    }
    if (!defined_default(readBuffer)) {
      throw new DeveloperError_default("readBuffer must be defined.");
    }
    if (!defined_default(sizeInBytes) || sizeInBytes <= 0) {
      throw new DeveloperError_default(
        "sizeInBytes must be defined and be greater than zero."
      );
    }
    if (!defined_default(readOffset) || readOffset < 0 || readOffset + sizeInBytes > readBuffer._sizeInBytes) {
      throw new DeveloperError_default(
        "readOffset must be greater than or equal to zero and readOffset + sizeInBytes must be less than of equal to readBuffer.sizeInBytes."
      );
    }
    if (!defined_default(writeOffset) || writeOffset < 0 || writeOffset + sizeInBytes > this._sizeInBytes) {
      throw new DeveloperError_default(
        "writeOffset must be greater than or equal to zero and writeOffset + sizeInBytes must be less than of equal to this.sizeInBytes."
      );
    }
    if (this._buffer === readBuffer._buffer && (writeOffset >= readOffset && writeOffset < readOffset + sizeInBytes || readOffset > writeOffset && readOffset < writeOffset + sizeInBytes)) {
      throw new DeveloperError_default(
        "When readBuffer is equal to this, the ranges [readOffset + sizeInBytes) and [writeOffset, writeOffset + sizeInBytes) must not overlap."
      );
    }
    if (this._bufferTarget === WebGLConstants_default.ELEMENT_ARRAY_BUFFER && readBuffer._bufferTarget !== WebGLConstants_default.ELEMENT_ARRAY_BUFFER || this._bufferTarget !== WebGLConstants_default.ELEMENT_ARRAY_BUFFER && readBuffer._bufferTarget === WebGLConstants_default.ELEMENT_ARRAY_BUFFER) {
      throw new DeveloperError_default(
        "Can not copy an index buffer into another buffer type."
      );
    }
    const readTarget = WebGLConstants_default.COPY_READ_BUFFER;
    const writeTarget = WebGLConstants_default.COPY_WRITE_BUFFER;
    const gl = this._gl;
    gl.bindBuffer(writeTarget, this._buffer);
    gl.bindBuffer(readTarget, readBuffer._buffer);
    gl.copyBufferSubData(
      readTarget,
      writeTarget,
      readOffset,
      writeOffset,
      sizeInBytes
    );
    gl.bindBuffer(writeTarget, null);
    gl.bindBuffer(readTarget, null);
  };
  Buffer2.prototype.getBufferData = function(arrayView, sourceOffset, destinationOffset, length3) {
    sourceOffset = defaultValue_default(sourceOffset, 0);
    destinationOffset = defaultValue_default(destinationOffset, 0);
    if (!this._webgl2) {
      throw new DeveloperError_default("A WebGL 2 context is required.");
    }
    if (!defined_default(arrayView)) {
      throw new DeveloperError_default("arrayView is required.");
    }
    let copyLength;
    let elementSize;
    let arrayLength = arrayView.byteLength;
    if (!defined_default(length3)) {
      if (defined_default(arrayLength)) {
        copyLength = arrayLength - destinationOffset;
        elementSize = 1;
      } else {
        arrayLength = arrayView.length;
        copyLength = arrayLength - destinationOffset;
        elementSize = arrayView.BYTES_PER_ELEMENT;
      }
    } else {
      copyLength = length3;
      if (defined_default(arrayLength)) {
        elementSize = 1;
      } else {
        arrayLength = arrayView.length;
        elementSize = arrayView.BYTES_PER_ELEMENT;
      }
    }
    if (destinationOffset < 0 || destinationOffset > arrayLength) {
      throw new DeveloperError_default(
        "destinationOffset must be greater than zero and less than the arrayView length."
      );
    }
    if (destinationOffset + copyLength > arrayLength) {
      throw new DeveloperError_default(
        "destinationOffset + length must be less than or equal to the arrayViewLength."
      );
    }
    if (sourceOffset < 0 || sourceOffset > this._sizeInBytes) {
      throw new DeveloperError_default(
        "sourceOffset must be greater than zero and less than the buffers size."
      );
    }
    if (sourceOffset + copyLength * elementSize > this._sizeInBytes) {
      throw new DeveloperError_default(
        "sourceOffset + length must be less than the buffers size."
      );
    }
    const gl = this._gl;
    const target = WebGLConstants_default.COPY_READ_BUFFER;
    gl.bindBuffer(target, this._buffer);
    gl.getBufferSubData(
      target,
      sourceOffset,
      arrayView,
      destinationOffset,
      length3
    );
    gl.bindBuffer(target, null);
  };
  Buffer2.prototype.isDestroyed = function() {
    return false;
  };
  Buffer2.prototype.destroy = function() {
    this._gl.deleteBuffer(this._buffer);
    return destroyObject_default(this);
  };
  var Buffer_default = Buffer2;

  // Source/Core/Fullscreen.js
  var _supportsFullscreen;
  var _names = {
    requestFullscreen: void 0,
    exitFullscreen: void 0,
    fullscreenEnabled: void 0,
    fullscreenElement: void 0,
    fullscreenchange: void 0,
    fullscreenerror: void 0
  };
  var Fullscreen = {};
  Object.defineProperties(Fullscreen, {
    element: {
      get: function() {
        if (!Fullscreen.supportsFullscreen()) {
          return void 0;
        }
        return document[_names.fullscreenElement];
      }
    },
    changeEventName: {
      get: function() {
        if (!Fullscreen.supportsFullscreen()) {
          return void 0;
        }
        return _names.fullscreenchange;
      }
    },
    errorEventName: {
      get: function() {
        if (!Fullscreen.supportsFullscreen()) {
          return void 0;
        }
        return _names.fullscreenerror;
      }
    },
    enabled: {
      get: function() {
        if (!Fullscreen.supportsFullscreen()) {
          return void 0;
        }
        return document[_names.fullscreenEnabled];
      }
    },
    fullscreen: {
      get: function() {
        if (!Fullscreen.supportsFullscreen()) {
          return void 0;
        }
        return Fullscreen.element !== null;
      }
    }
  });
  Fullscreen.supportsFullscreen = function() {
    if (defined_default(_supportsFullscreen)) {
      return _supportsFullscreen;
    }
    _supportsFullscreen = false;
    const body = document.body;
    if (typeof body.requestFullscreen === "function") {
      _names.requestFullscreen = "requestFullscreen";
      _names.exitFullscreen = "exitFullscreen";
      _names.fullscreenEnabled = "fullscreenEnabled";
      _names.fullscreenElement = "fullscreenElement";
      _names.fullscreenchange = "fullscreenchange";
      _names.fullscreenerror = "fullscreenerror";
      _supportsFullscreen = true;
      return _supportsFullscreen;
    }
    const prefixes = ["webkit", "moz", "o", "ms", "khtml"];
    let name;
    for (let i = 0, len = prefixes.length; i < len; ++i) {
      const prefix = prefixes[i];
      name = `${prefix}RequestFullscreen`;
      if (typeof body[name] === "function") {
        _names.requestFullscreen = name;
        _supportsFullscreen = true;
      } else {
        name = `${prefix}RequestFullScreen`;
        if (typeof body[name] === "function") {
          _names.requestFullscreen = name;
          _supportsFullscreen = true;
        }
      }
      name = `${prefix}ExitFullscreen`;
      if (typeof document[name] === "function") {
        _names.exitFullscreen = name;
      } else {
        name = `${prefix}CancelFullScreen`;
        if (typeof document[name] === "function") {
          _names.exitFullscreen = name;
        }
      }
      name = `${prefix}FullscreenEnabled`;
      if (document[name] !== void 0) {
        _names.fullscreenEnabled = name;
      } else {
        name = `${prefix}FullScreenEnabled`;
        if (document[name] !== void 0) {
          _names.fullscreenEnabled = name;
        }
      }
      name = `${prefix}FullscreenElement`;
      if (document[name] !== void 0) {
        _names.fullscreenElement = name;
      } else {
        name = `${prefix}FullScreenElement`;
        if (document[name] !== void 0) {
          _names.fullscreenElement = name;
        }
      }
      name = `${prefix}fullscreenchange`;
      if (document[`on${name}`] !== void 0) {
        if (prefix === "ms") {
          name = "MSFullscreenChange";
        }
        _names.fullscreenchange = name;
      }
      name = `${prefix}fullscreenerror`;
      if (document[`on${name}`] !== void 0) {
        if (prefix === "ms") {
          name = "MSFullscreenError";
        }
        _names.fullscreenerror = name;
      }
    }
    return _supportsFullscreen;
  };
  Fullscreen.requestFullscreen = function(element, vrDevice) {
    if (!Fullscreen.supportsFullscreen()) {
      return;
    }
    element[_names.requestFullscreen]({ vrDisplay: vrDevice });
  };
  Fullscreen.exitFullscreen = function() {
    if (!Fullscreen.supportsFullscreen()) {
      return;
    }
    document[_names.exitFullscreen]();
  };
  Fullscreen._names = _names;
  var Fullscreen_default = Fullscreen;

  // Source/Core/FeatureDetection.js
  var theNavigator;
  if (typeof navigator !== "undefined") {
    theNavigator = navigator;
  } else {
    theNavigator = {};
  }
  function extractVersion(versionString) {
    const parts = versionString.split(".");
    for (let i = 0, len = parts.length; i < len; ++i) {
      parts[i] = parseInt(parts[i], 10);
    }
    return parts;
  }
  var isChromeResult;
  var chromeVersionResult;
  function isChrome() {
    if (!defined_default(isChromeResult)) {
      isChromeResult = false;
      if (!isEdge()) {
        const fields = / Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent);
        if (fields !== null) {
          isChromeResult = true;
          chromeVersionResult = extractVersion(fields[1]);
        }
      }
    }
    return isChromeResult;
  }
  function chromeVersion() {
    return isChrome() && chromeVersionResult;
  }
  var isSafariResult;
  var safariVersionResult;
  function isSafari() {
    if (!defined_default(isSafariResult)) {
      isSafariResult = false;
      if (!isChrome() && !isEdge() && / Safari\/[\.0-9]+/.test(theNavigator.userAgent)) {
        const fields = / Version\/([\.0-9]+)/.exec(theNavigator.userAgent);
        if (fields !== null) {
          isSafariResult = true;
          safariVersionResult = extractVersion(fields[1]);
        }
      }
    }
    return isSafariResult;
  }
  function safariVersion() {
    return isSafari() && safariVersionResult;
  }
  var isWebkitResult;
  var webkitVersionResult;
  function isWebkit() {
    if (!defined_default(isWebkitResult)) {
      isWebkitResult = false;
      const fields = / AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isWebkitResult = true;
        webkitVersionResult = extractVersion(fields[1]);
        webkitVersionResult.isNightly = !!fields[2];
      }
    }
    return isWebkitResult;
  }
  function webkitVersion() {
    return isWebkit() && webkitVersionResult;
  }
  var isInternetExplorerResult;
  var internetExplorerVersionResult;
  function isInternetExplorer() {
    if (!defined_default(isInternetExplorerResult)) {
      isInternetExplorerResult = false;
      let fields;
      if (theNavigator.appName === "Microsoft Internet Explorer") {
        fields = /MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent);
        if (fields !== null) {
          isInternetExplorerResult = true;
          internetExplorerVersionResult = extractVersion(fields[1]);
        }
      } else if (theNavigator.appName === "Netscape") {
        fields = /Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(
          theNavigator.userAgent
        );
        if (fields !== null) {
          isInternetExplorerResult = true;
          internetExplorerVersionResult = extractVersion(fields[1]);
        }
      }
    }
    return isInternetExplorerResult;
  }
  function internetExplorerVersion() {
    return isInternetExplorer() && internetExplorerVersionResult;
  }
  var isEdgeResult;
  var edgeVersionResult;
  function isEdge() {
    if (!defined_default(isEdgeResult)) {
      isEdgeResult = false;
      const fields = / Edg\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isEdgeResult = true;
        edgeVersionResult = extractVersion(fields[1]);
      }
    }
    return isEdgeResult;
  }
  function edgeVersion() {
    return isEdge() && edgeVersionResult;
  }
  var isFirefoxResult;
  var firefoxVersionResult;
  function isFirefox() {
    if (!defined_default(isFirefoxResult)) {
      isFirefoxResult = false;
      const fields = /Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isFirefoxResult = true;
        firefoxVersionResult = extractVersion(fields[1]);
      }
    }
    return isFirefoxResult;
  }
  var isWindowsResult;
  function isWindows() {
    if (!defined_default(isWindowsResult)) {
      isWindowsResult = /Windows/i.test(theNavigator.appVersion);
    }
    return isWindowsResult;
  }
  var isIPadOrIOSResult;
  function isIPadOrIOS() {
    if (!defined_default(isIPadOrIOSResult)) {
      isIPadOrIOSResult = navigator.platform === "iPhone" || navigator.platform === "iPod" || navigator.platform === "iPad";
    }
    return isIPadOrIOSResult;
  }
  function firefoxVersion() {
    return isFirefox() && firefoxVersionResult;
  }
  var hasPointerEvents;
  function supportsPointerEvents() {
    if (!defined_default(hasPointerEvents)) {
      hasPointerEvents = !isFirefox() && typeof PointerEvent !== "undefined" && (!defined_default(theNavigator.pointerEnabled) || theNavigator.pointerEnabled);
    }
    return hasPointerEvents;
  }
  var imageRenderingValueResult;
  var supportsImageRenderingPixelatedResult;
  function supportsImageRenderingPixelated() {
    if (!defined_default(supportsImageRenderingPixelatedResult)) {
      const canvas = document.createElement("canvas");
      canvas.setAttribute(
        "style",
        "image-rendering: -moz-crisp-edges;image-rendering: pixelated;"
      );
      const tmp2 = canvas.style.imageRendering;
      supportsImageRenderingPixelatedResult = defined_default(tmp2) && tmp2 !== "";
      if (supportsImageRenderingPixelatedResult) {
        imageRenderingValueResult = tmp2;
      }
    }
    return supportsImageRenderingPixelatedResult;
  }
  function imageRenderingValue() {
    return supportsImageRenderingPixelated() ? imageRenderingValueResult : void 0;
  }
  function supportsWebP() {
    if (!supportsWebP.initialized) {
      throw new DeveloperError_default(
        "You must call FeatureDetection.supportsWebP.initialize and wait for the promise to resolve before calling FeatureDetection.supportsWebP"
      );
    }
    return supportsWebP._result;
  }
  supportsWebP._promise = void 0;
  supportsWebP._result = void 0;
  supportsWebP.initialize = function() {
    if (defined_default(supportsWebP._promise)) {
      return supportsWebP._promise;
    }
    supportsWebP._promise = new Promise((resolve2) => {
      const image = new Image();
      image.onload = function() {
        supportsWebP._result = image.width > 0 && image.height > 0;
        resolve2(supportsWebP._result);
      };
      image.onerror = function() {
        supportsWebP._result = false;
        resolve2(supportsWebP._result);
      };
      image.src = "data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA";
    });
    return supportsWebP._promise;
  };
  Object.defineProperties(supportsWebP, {
    initialized: {
      get: function() {
        return defined_default(supportsWebP._result);
      }
    }
  });
  var typedArrayTypes = [];
  if (typeof ArrayBuffer !== "undefined") {
    typedArrayTypes.push(
      Int8Array,
      Uint8Array,
      Int16Array,
      Uint16Array,
      Int32Array,
      Uint32Array,
      Float32Array,
      Float64Array
    );
    if (typeof Uint8ClampedArray !== "undefined") {
      typedArrayTypes.push(Uint8ClampedArray);
    }
    if (typeof Uint8ClampedArray !== "undefined") {
      typedArrayTypes.push(Uint8ClampedArray);
    }
    if (typeof BigInt64Array !== "undefined") {
      typedArrayTypes.push(BigInt64Array);
    }
    if (typeof BigUint64Array !== "undefined") {
      typedArrayTypes.push(BigUint64Array);
    }
  }
  var FeatureDetection = {
    isChrome,
    chromeVersion,
    isSafari,
    safariVersion,
    isWebkit,
    webkitVersion,
    isInternetExplorer,
    internetExplorerVersion,
    isEdge,
    edgeVersion,
    isFirefox,
    firefoxVersion,
    isWindows,
    isIPadOrIOS,
    hardwareConcurrency: defaultValue_default(theNavigator.hardwareConcurrency, 3),
    supportsPointerEvents,
    supportsImageRenderingPixelated,
    supportsWebP,
    imageRenderingValue,
    typedArrayTypes
  };
  FeatureDetection.supportsBasis = function(scene) {
    return FeatureDetection.supportsWebAssembly() && scene.context.supportsBasis;
  };
  FeatureDetection.supportsFullscreen = function() {
    return Fullscreen_default.supportsFullscreen();
  };
  FeatureDetection.supportsTypedArrays = function() {
    return typeof ArrayBuffer !== "undefined";
  };
  FeatureDetection.supportsBigInt64Array = function() {
    return typeof BigInt64Array !== "undefined";
  };
  FeatureDetection.supportsBigUint64Array = function() {
    return typeof BigUint64Array !== "undefined";
  };
  FeatureDetection.supportsBigInt = function() {
    return typeof BigInt !== "undefined";
  };
  FeatureDetection.supportsWebWorkers = function() {
    return typeof Worker !== "undefined";
  };
  FeatureDetection.supportsWebAssembly = function() {
    return typeof WebAssembly !== "undefined";
  };
  var FeatureDetection_default = FeatureDetection;

  // Source/Core/Color.js
  function hue2rgb(m1, m2, h) {
    if (h < 0) {
      h += 1;
    }
    if (h > 1) {
      h -= 1;
    }
    if (h * 6 < 1) {
      return m1 + (m2 - m1) * 6 * h;
    }
    if (h * 2 < 1) {
      return m2;
    }
    if (h * 3 < 2) {
      return m1 + (m2 - m1) * (2 / 3 - h) * 6;
    }
    return m1;
  }
  function Color(red, green, blue, alpha) {
    this.red = defaultValue_default(red, 1);
    this.green = defaultValue_default(green, 1);
    this.blue = defaultValue_default(blue, 1);
    this.alpha = defaultValue_default(alpha, 1);
  }
  Color.fromCartesian4 = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    if (!defined_default(result)) {
      return new Color(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
    }
    result.red = cartesian11.x;
    result.green = cartesian11.y;
    result.blue = cartesian11.z;
    result.alpha = cartesian11.w;
    return result;
  };
  Color.fromBytes = function(red, green, blue, alpha, result) {
    red = Color.byteToFloat(defaultValue_default(red, 255));
    green = Color.byteToFloat(defaultValue_default(green, 255));
    blue = Color.byteToFloat(defaultValue_default(blue, 255));
    alpha = Color.byteToFloat(defaultValue_default(alpha, 255));
    if (!defined_default(result)) {
      return new Color(red, green, blue, alpha);
    }
    result.red = red;
    result.green = green;
    result.blue = blue;
    result.alpha = alpha;
    return result;
  };
  Color.fromAlpha = function(color, alpha, result) {
    Check_default.typeOf.object("color", color);
    Check_default.typeOf.number("alpha", alpha);
    if (!defined_default(result)) {
      return new Color(color.red, color.green, color.blue, alpha);
    }
    result.red = color.red;
    result.green = color.green;
    result.blue = color.blue;
    result.alpha = alpha;
    return result;
  };
  var scratchArrayBuffer;
  var scratchUint32Array;
  var scratchUint8Array;
  if (FeatureDetection_default.supportsTypedArrays()) {
    scratchArrayBuffer = new ArrayBuffer(4);
    scratchUint32Array = new Uint32Array(scratchArrayBuffer);
    scratchUint8Array = new Uint8Array(scratchArrayBuffer);
  }
  Color.fromRgba = function(rgba, result) {
    scratchUint32Array[0] = rgba;
    return Color.fromBytes(
      scratchUint8Array[0],
      scratchUint8Array[1],
      scratchUint8Array[2],
      scratchUint8Array[3],
      result
    );
  };
  Color.fromHsl = function(hue, saturation, lightness, alpha, result) {
    hue = defaultValue_default(hue, 0) % 1;
    saturation = defaultValue_default(saturation, 0);
    lightness = defaultValue_default(lightness, 0);
    alpha = defaultValue_default(alpha, 1);
    let red = lightness;
    let green = lightness;
    let blue = lightness;
    if (saturation !== 0) {
      let m2;
      if (lightness < 0.5) {
        m2 = lightness * (1 + saturation);
      } else {
        m2 = lightness + saturation - lightness * saturation;
      }
      const m1 = 2 * lightness - m2;
      red = hue2rgb(m1, m2, hue + 1 / 3);
      green = hue2rgb(m1, m2, hue);
      blue = hue2rgb(m1, m2, hue - 1 / 3);
    }
    if (!defined_default(result)) {
      return new Color(red, green, blue, alpha);
    }
    result.red = red;
    result.green = green;
    result.blue = blue;
    result.alpha = alpha;
    return result;
  };
  Color.fromRandom = function(options, result) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    let red = options.red;
    if (!defined_default(red)) {
      const minimumRed = defaultValue_default(options.minimumRed, 0);
      const maximumRed = defaultValue_default(options.maximumRed, 1);
      Check_default.typeOf.number.lessThanOrEquals("minimumRed", minimumRed, maximumRed);
      red = minimumRed + Math_default.nextRandomNumber() * (maximumRed - minimumRed);
    }
    let green = options.green;
    if (!defined_default(green)) {
      const minimumGreen = defaultValue_default(options.minimumGreen, 0);
      const maximumGreen = defaultValue_default(options.maximumGreen, 1);
      Check_default.typeOf.number.lessThanOrEquals(
        "minimumGreen",
        minimumGreen,
        maximumGreen
      );
      green = minimumGreen + Math_default.nextRandomNumber() * (maximumGreen - minimumGreen);
    }
    let blue = options.blue;
    if (!defined_default(blue)) {
      const minimumBlue = defaultValue_default(options.minimumBlue, 0);
      const maximumBlue = defaultValue_default(options.maximumBlue, 1);
      Check_default.typeOf.number.lessThanOrEquals(
        "minimumBlue",
        minimumBlue,
        maximumBlue
      );
      blue = minimumBlue + Math_default.nextRandomNumber() * (maximumBlue - minimumBlue);
    }
    let alpha = options.alpha;
    if (!defined_default(alpha)) {
      const minimumAlpha = defaultValue_default(options.minimumAlpha, 0);
      const maximumAlpha = defaultValue_default(options.maximumAlpha, 1);
      Check_default.typeOf.number.lessThanOrEquals(
        "minumumAlpha",
        minimumAlpha,
        maximumAlpha
      );
      alpha = minimumAlpha + Math_default.nextRandomNumber() * (maximumAlpha - minimumAlpha);
    }
    if (!defined_default(result)) {
      return new Color(red, green, blue, alpha);
    }
    result.red = red;
    result.green = green;
    result.blue = blue;
    result.alpha = alpha;
    return result;
  };
  var rgbaMatcher = /^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i;
  var rrggbbaaMatcher = /^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i;
  var rgbParenthesesMatcher = /^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i;
  var hslParenthesesMatcher = /^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;
  Color.fromCssColorString = function(color, result) {
    Check_default.typeOf.string("color", color);
    if (!defined_default(result)) {
      result = new Color();
    }
    color = color.replace(/\s/g, "");
    const namedColor = Color[color.toUpperCase()];
    if (defined_default(namedColor)) {
      Color.clone(namedColor, result);
      return result;
    }
    let matches = rgbaMatcher.exec(color);
    if (matches !== null) {
      result.red = parseInt(matches[1], 16) / 15;
      result.green = parseInt(matches[2], 16) / 15;
      result.blue = parseInt(matches[3], 16) / 15;
      result.alpha = parseInt(defaultValue_default(matches[4], "f"), 16) / 15;
      return result;
    }
    matches = rrggbbaaMatcher.exec(color);
    if (matches !== null) {
      result.red = parseInt(matches[1], 16) / 255;
      result.green = parseInt(matches[2], 16) / 255;
      result.blue = parseInt(matches[3], 16) / 255;
      result.alpha = parseInt(defaultValue_default(matches[4], "ff"), 16) / 255;
      return result;
    }
    matches = rgbParenthesesMatcher.exec(color);
    if (matches !== null) {
      result.red = parseFloat(matches[1]) / ("%" === matches[1].substr(-1) ? 100 : 255);
      result.green = parseFloat(matches[2]) / ("%" === matches[2].substr(-1) ? 100 : 255);
      result.blue = parseFloat(matches[3]) / ("%" === matches[3].substr(-1) ? 100 : 255);
      result.alpha = parseFloat(defaultValue_default(matches[4], "1.0"));
      return result;
    }
    matches = hslParenthesesMatcher.exec(color);
    if (matches !== null) {
      return Color.fromHsl(
        parseFloat(matches[1]) / 360,
        parseFloat(matches[2]) / 100,
        parseFloat(matches[3]) / 100,
        parseFloat(defaultValue_default(matches[4], "1.0")),
        result
      );
    }
    result = void 0;
    return result;
  };
  Color.packedLength = 4;
  Color.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value.red;
    array[startingIndex++] = value.green;
    array[startingIndex++] = value.blue;
    array[startingIndex] = value.alpha;
    return array;
  };
  Color.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Color();
    }
    result.red = array[startingIndex++];
    result.green = array[startingIndex++];
    result.blue = array[startingIndex++];
    result.alpha = array[startingIndex];
    return result;
  };
  Color.byteToFloat = function(number) {
    return number / 255;
  };
  Color.floatToByte = function(number) {
    return number === 1 ? 255 : number * 256 | 0;
  };
  Color.clone = function(color, result) {
    if (!defined_default(color)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Color(color.red, color.green, color.blue, color.alpha);
    }
    result.red = color.red;
    result.green = color.green;
    result.blue = color.blue;
    result.alpha = color.alpha;
    return result;
  };
  Color.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.red === right.red && left.green === right.green && left.blue === right.blue && left.alpha === right.alpha;
  };
  Color.equalsArray = function(color, array, offset2) {
    return color.red === array[offset2] && color.green === array[offset2 + 1] && color.blue === array[offset2 + 2] && color.alpha === array[offset2 + 3];
  };
  Color.prototype.clone = function(result) {
    return Color.clone(this, result);
  };
  Color.prototype.equals = function(other) {
    return Color.equals(this, other);
  };
  Color.prototype.equalsEpsilon = function(other, epsilon) {
    return this === other || defined_default(other) && Math.abs(this.red - other.red) <= epsilon && Math.abs(this.green - other.green) <= epsilon && Math.abs(this.blue - other.blue) <= epsilon && Math.abs(this.alpha - other.alpha) <= epsilon;
  };
  Color.prototype.toString = function() {
    return `(${this.red}, ${this.green}, ${this.blue}, ${this.alpha})`;
  };
  Color.prototype.toCssColorString = function() {
    const red = Color.floatToByte(this.red);
    const green = Color.floatToByte(this.green);
    const blue = Color.floatToByte(this.blue);
    if (this.alpha === 1) {
      return `rgb(${red},${green},${blue})`;
    }
    return `rgba(${red},${green},${blue},${this.alpha})`;
  };
  Color.prototype.toCssHexString = function() {
    let r = Color.floatToByte(this.red).toString(16);
    if (r.length < 2) {
      r = `0${r}`;
    }
    let g = Color.floatToByte(this.green).toString(16);
    if (g.length < 2) {
      g = `0${g}`;
    }
    let b = Color.floatToByte(this.blue).toString(16);
    if (b.length < 2) {
      b = `0${b}`;
    }
    if (this.alpha < 1) {
      let hexAlpha = Color.floatToByte(this.alpha).toString(16);
      if (hexAlpha.length < 2) {
        hexAlpha = `0${hexAlpha}`;
      }
      return `#${r}${g}${b}${hexAlpha}`;
    }
    return `#${r}${g}${b}`;
  };
  Color.prototype.toBytes = function(result) {
    const red = Color.floatToByte(this.red);
    const green = Color.floatToByte(this.green);
    const blue = Color.floatToByte(this.blue);
    const alpha = Color.floatToByte(this.alpha);
    if (!defined_default(result)) {
      return [red, green, blue, alpha];
    }
    result[0] = red;
    result[1] = green;
    result[2] = blue;
    result[3] = alpha;
    return result;
  };
  Color.prototype.toRgba = function() {
    scratchUint8Array[0] = Color.floatToByte(this.red);
    scratchUint8Array[1] = Color.floatToByte(this.green);
    scratchUint8Array[2] = Color.floatToByte(this.blue);
    scratchUint8Array[3] = Color.floatToByte(this.alpha);
    return scratchUint32Array[0];
  };
  Color.prototype.brighten = function(magnitude, result) {
    Check_default.typeOf.number("magnitude", magnitude);
    Check_default.typeOf.number.greaterThanOrEquals("magnitude", magnitude, 0);
    Check_default.typeOf.object("result", result);
    magnitude = 1 - magnitude;
    result.red = 1 - (1 - this.red) * magnitude;
    result.green = 1 - (1 - this.green) * magnitude;
    result.blue = 1 - (1 - this.blue) * magnitude;
    result.alpha = this.alpha;
    return result;
  };
  Color.prototype.darken = function(magnitude, result) {
    Check_default.typeOf.number("magnitude", magnitude);
    Check_default.typeOf.number.greaterThanOrEquals("magnitude", magnitude, 0);
    Check_default.typeOf.object("result", result);
    magnitude = 1 - magnitude;
    result.red = this.red * magnitude;
    result.green = this.green * magnitude;
    result.blue = this.blue * magnitude;
    result.alpha = this.alpha;
    return result;
  };
  Color.prototype.withAlpha = function(alpha, result) {
    return Color.fromAlpha(this, alpha, result);
  };
  Color.add = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.red = left.red + right.red;
    result.green = left.green + right.green;
    result.blue = left.blue + right.blue;
    result.alpha = left.alpha + right.alpha;
    return result;
  };
  Color.subtract = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.red = left.red - right.red;
    result.green = left.green - right.green;
    result.blue = left.blue - right.blue;
    result.alpha = left.alpha - right.alpha;
    return result;
  };
  Color.multiply = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.red = left.red * right.red;
    result.green = left.green * right.green;
    result.blue = left.blue * right.blue;
    result.alpha = left.alpha * right.alpha;
    return result;
  };
  Color.divide = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.red = left.red / right.red;
    result.green = left.green / right.green;
    result.blue = left.blue / right.blue;
    result.alpha = left.alpha / right.alpha;
    return result;
  };
  Color.mod = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.red = left.red % right.red;
    result.green = left.green % right.green;
    result.blue = left.blue % right.blue;
    result.alpha = left.alpha % right.alpha;
    return result;
  };
  Color.lerp = function(start, end, t, result) {
    Check_default.typeOf.object("start", start);
    Check_default.typeOf.object("end", end);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    result.red = Math_default.lerp(start.red, end.red, t);
    result.green = Math_default.lerp(start.green, end.green, t);
    result.blue = Math_default.lerp(start.blue, end.blue, t);
    result.alpha = Math_default.lerp(start.alpha, end.alpha, t);
    return result;
  };
  Color.multiplyByScalar = function(color, scalar, result) {
    Check_default.typeOf.object("color", color);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.red = color.red * scalar;
    result.green = color.green * scalar;
    result.blue = color.blue * scalar;
    result.alpha = color.alpha * scalar;
    return result;
  };
  Color.divideByScalar = function(color, scalar, result) {
    Check_default.typeOf.object("color", color);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.red = color.red / scalar;
    result.green = color.green / scalar;
    result.blue = color.blue / scalar;
    result.alpha = color.alpha / scalar;
    return result;
  };
  Color.ALICEBLUE = Object.freeze(Color.fromCssColorString("#F0F8FF"));
  Color.ANTIQUEWHITE = Object.freeze(Color.fromCssColorString("#FAEBD7"));
  Color.AQUA = Object.freeze(Color.fromCssColorString("#00FFFF"));
  Color.AQUAMARINE = Object.freeze(Color.fromCssColorString("#7FFFD4"));
  Color.AZURE = Object.freeze(Color.fromCssColorString("#F0FFFF"));
  Color.BEIGE = Object.freeze(Color.fromCssColorString("#F5F5DC"));
  Color.BISQUE = Object.freeze(Color.fromCssColorString("#FFE4C4"));
  Color.BLACK = Object.freeze(Color.fromCssColorString("#000000"));
  Color.BLANCHEDALMOND = Object.freeze(Color.fromCssColorString("#FFEBCD"));
  Color.BLUE = Object.freeze(Color.fromCssColorString("#0000FF"));
  Color.BLUEVIOLET = Object.freeze(Color.fromCssColorString("#8A2BE2"));
  Color.BROWN = Object.freeze(Color.fromCssColorString("#A52A2A"));
  Color.BURLYWOOD = Object.freeze(Color.fromCssColorString("#DEB887"));
  Color.CADETBLUE = Object.freeze(Color.fromCssColorString("#5F9EA0"));
  Color.CHARTREUSE = Object.freeze(Color.fromCssColorString("#7FFF00"));
  Color.CHOCOLATE = Object.freeze(Color.fromCssColorString("#D2691E"));
  Color.CORAL = Object.freeze(Color.fromCssColorString("#FF7F50"));
  Color.CORNFLOWERBLUE = Object.freeze(Color.fromCssColorString("#6495ED"));
  Color.CORNSILK = Object.freeze(Color.fromCssColorString("#FFF8DC"));
  Color.CRIMSON = Object.freeze(Color.fromCssColorString("#DC143C"));
  Color.CYAN = Object.freeze(Color.fromCssColorString("#00FFFF"));
  Color.DARKBLUE = Object.freeze(Color.fromCssColorString("#00008B"));
  Color.DARKCYAN = Object.freeze(Color.fromCssColorString("#008B8B"));
  Color.DARKGOLDENROD = Object.freeze(Color.fromCssColorString("#B8860B"));
  Color.DARKGRAY = Object.freeze(Color.fromCssColorString("#A9A9A9"));
  Color.DARKGREEN = Object.freeze(Color.fromCssColorString("#006400"));
  Color.DARKGREY = Color.DARKGRAY;
  Color.DARKKHAKI = Object.freeze(Color.fromCssColorString("#BDB76B"));
  Color.DARKMAGENTA = Object.freeze(Color.fromCssColorString("#8B008B"));
  Color.DARKOLIVEGREEN = Object.freeze(Color.fromCssColorString("#556B2F"));
  Color.DARKORANGE = Object.freeze(Color.fromCssColorString("#FF8C00"));
  Color.DARKORCHID = Object.freeze(Color.fromCssColorString("#9932CC"));
  Color.DARKRED = Object.freeze(Color.fromCssColorString("#8B0000"));
  Color.DARKSALMON = Object.freeze(Color.fromCssColorString("#E9967A"));
  Color.DARKSEAGREEN = Object.freeze(Color.fromCssColorString("#8FBC8F"));
  Color.DARKSLATEBLUE = Object.freeze(Color.fromCssColorString("#483D8B"));
  Color.DARKSLATEGRAY = Object.freeze(Color.fromCssColorString("#2F4F4F"));
  Color.DARKSLATEGREY = Color.DARKSLATEGRAY;
  Color.DARKTURQUOISE = Object.freeze(Color.fromCssColorString("#00CED1"));
  Color.DARKVIOLET = Object.freeze(Color.fromCssColorString("#9400D3"));
  Color.DEEPPINK = Object.freeze(Color.fromCssColorString("#FF1493"));
  Color.DEEPSKYBLUE = Object.freeze(Color.fromCssColorString("#00BFFF"));
  Color.DIMGRAY = Object.freeze(Color.fromCssColorString("#696969"));
  Color.DIMGREY = Color.DIMGRAY;
  Color.DODGERBLUE = Object.freeze(Color.fromCssColorString("#1E90FF"));
  Color.FIREBRICK = Object.freeze(Color.fromCssColorString("#B22222"));
  Color.FLORALWHITE = Object.freeze(Color.fromCssColorString("#FFFAF0"));
  Color.FORESTGREEN = Object.freeze(Color.fromCssColorString("#228B22"));
  Color.FUCHSIA = Object.freeze(Color.fromCssColorString("#FF00FF"));
  Color.GAINSBORO = Object.freeze(Color.fromCssColorString("#DCDCDC"));
  Color.GHOSTWHITE = Object.freeze(Color.fromCssColorString("#F8F8FF"));
  Color.GOLD = Object.freeze(Color.fromCssColorString("#FFD700"));
  Color.GOLDENROD = Object.freeze(Color.fromCssColorString("#DAA520"));
  Color.GRAY = Object.freeze(Color.fromCssColorString("#808080"));
  Color.GREEN = Object.freeze(Color.fromCssColorString("#008000"));
  Color.GREENYELLOW = Object.freeze(Color.fromCssColorString("#ADFF2F"));
  Color.GREY = Color.GRAY;
  Color.HONEYDEW = Object.freeze(Color.fromCssColorString("#F0FFF0"));
  Color.HOTPINK = Object.freeze(Color.fromCssColorString("#FF69B4"));
  Color.INDIANRED = Object.freeze(Color.fromCssColorString("#CD5C5C"));
  Color.INDIGO = Object.freeze(Color.fromCssColorString("#4B0082"));
  Color.IVORY = Object.freeze(Color.fromCssColorString("#FFFFF0"));
  Color.KHAKI = Object.freeze(Color.fromCssColorString("#F0E68C"));
  Color.LAVENDER = Object.freeze(Color.fromCssColorString("#E6E6FA"));
  Color.LAVENDAR_BLUSH = Object.freeze(Color.fromCssColorString("#FFF0F5"));
  Color.LAWNGREEN = Object.freeze(Color.fromCssColorString("#7CFC00"));
  Color.LEMONCHIFFON = Object.freeze(Color.fromCssColorString("#FFFACD"));
  Color.LIGHTBLUE = Object.freeze(Color.fromCssColorString("#ADD8E6"));
  Color.LIGHTCORAL = Object.freeze(Color.fromCssColorString("#F08080"));
  Color.LIGHTCYAN = Object.freeze(Color.fromCssColorString("#E0FFFF"));
  Color.LIGHTGOLDENRODYELLOW = Object.freeze(Color.fromCssColorString("#FAFAD2"));
  Color.LIGHTGRAY = Object.freeze(Color.fromCssColorString("#D3D3D3"));
  Color.LIGHTGREEN = Object.freeze(Color.fromCssColorString("#90EE90"));
  Color.LIGHTGREY = Color.LIGHTGRAY;
  Color.LIGHTPINK = Object.freeze(Color.fromCssColorString("#FFB6C1"));
  Color.LIGHTSEAGREEN = Object.freeze(Color.fromCssColorString("#20B2AA"));
  Color.LIGHTSKYBLUE = Object.freeze(Color.fromCssColorString("#87CEFA"));
  Color.LIGHTSLATEGRAY = Object.freeze(Color.fromCssColorString("#778899"));
  Color.LIGHTSLATEGREY = Color.LIGHTSLATEGRAY;
  Color.LIGHTSTEELBLUE = Object.freeze(Color.fromCssColorString("#B0C4DE"));
  Color.LIGHTYELLOW = Object.freeze(Color.fromCssColorString("#FFFFE0"));
  Color.LIME = Object.freeze(Color.fromCssColorString("#00FF00"));
  Color.LIMEGREEN = Object.freeze(Color.fromCssColorString("#32CD32"));
  Color.LINEN = Object.freeze(Color.fromCssColorString("#FAF0E6"));
  Color.MAGENTA = Object.freeze(Color.fromCssColorString("#FF00FF"));
  Color.MAROON = Object.freeze(Color.fromCssColorString("#800000"));
  Color.MEDIUMAQUAMARINE = Object.freeze(Color.fromCssColorString("#66CDAA"));
  Color.MEDIUMBLUE = Object.freeze(Color.fromCssColorString("#0000CD"));
  Color.MEDIUMORCHID = Object.freeze(Color.fromCssColorString("#BA55D3"));
  Color.MEDIUMPURPLE = Object.freeze(Color.fromCssColorString("#9370DB"));
  Color.MEDIUMSEAGREEN = Object.freeze(Color.fromCssColorString("#3CB371"));
  Color.MEDIUMSLATEBLUE = Object.freeze(Color.fromCssColorString("#7B68EE"));
  Color.MEDIUMSPRINGGREEN = Object.freeze(Color.fromCssColorString("#00FA9A"));
  Color.MEDIUMTURQUOISE = Object.freeze(Color.fromCssColorString("#48D1CC"));
  Color.MEDIUMVIOLETRED = Object.freeze(Color.fromCssColorString("#C71585"));
  Color.MIDNIGHTBLUE = Object.freeze(Color.fromCssColorString("#191970"));
  Color.MINTCREAM = Object.freeze(Color.fromCssColorString("#F5FFFA"));
  Color.MISTYROSE = Object.freeze(Color.fromCssColorString("#FFE4E1"));
  Color.MOCCASIN = Object.freeze(Color.fromCssColorString("#FFE4B5"));
  Color.NAVAJOWHITE = Object.freeze(Color.fromCssColorString("#FFDEAD"));
  Color.NAVY = Object.freeze(Color.fromCssColorString("#000080"));
  Color.OLDLACE = Object.freeze(Color.fromCssColorString("#FDF5E6"));
  Color.OLIVE = Object.freeze(Color.fromCssColorString("#808000"));
  Color.OLIVEDRAB = Object.freeze(Color.fromCssColorString("#6B8E23"));
  Color.ORANGE = Object.freeze(Color.fromCssColorString("#FFA500"));
  Color.ORANGERED = Object.freeze(Color.fromCssColorString("#FF4500"));
  Color.ORCHID = Object.freeze(Color.fromCssColorString("#DA70D6"));
  Color.PALEGOLDENROD = Object.freeze(Color.fromCssColorString("#EEE8AA"));
  Color.PALEGREEN = Object.freeze(Color.fromCssColorString("#98FB98"));
  Color.PALETURQUOISE = Object.freeze(Color.fromCssColorString("#AFEEEE"));
  Color.PALEVIOLETRED = Object.freeze(Color.fromCssColorString("#DB7093"));
  Color.PAPAYAWHIP = Object.freeze(Color.fromCssColorString("#FFEFD5"));
  Color.PEACHPUFF = Object.freeze(Color.fromCssColorString("#FFDAB9"));
  Color.PERU = Object.freeze(Color.fromCssColorString("#CD853F"));
  Color.PINK = Object.freeze(Color.fromCssColorString("#FFC0CB"));
  Color.PLUM = Object.freeze(Color.fromCssColorString("#DDA0DD"));
  Color.POWDERBLUE = Object.freeze(Color.fromCssColorString("#B0E0E6"));
  Color.PURPLE = Object.freeze(Color.fromCssColorString("#800080"));
  Color.RED = Object.freeze(Color.fromCssColorString("#FF0000"));
  Color.ROSYBROWN = Object.freeze(Color.fromCssColorString("#BC8F8F"));
  Color.ROYALBLUE = Object.freeze(Color.fromCssColorString("#4169E1"));
  Color.SADDLEBROWN = Object.freeze(Color.fromCssColorString("#8B4513"));
  Color.SALMON = Object.freeze(Color.fromCssColorString("#FA8072"));
  Color.SANDYBROWN = Object.freeze(Color.fromCssColorString("#F4A460"));
  Color.SEAGREEN = Object.freeze(Color.fromCssColorString("#2E8B57"));
  Color.SEASHELL = Object.freeze(Color.fromCssColorString("#FFF5EE"));
  Color.SIENNA = Object.freeze(Color.fromCssColorString("#A0522D"));
  Color.SILVER = Object.freeze(Color.fromCssColorString("#C0C0C0"));
  Color.SKYBLUE = Object.freeze(Color.fromCssColorString("#87CEEB"));
  Color.SLATEBLUE = Object.freeze(Color.fromCssColorString("#6A5ACD"));
  Color.SLATEGRAY = Object.freeze(Color.fromCssColorString("#708090"));
  Color.SLATEGREY = Color.SLATEGRAY;
  Color.SNOW = Object.freeze(Color.fromCssColorString("#FFFAFA"));
  Color.SPRINGGREEN = Object.freeze(Color.fromCssColorString("#00FF7F"));
  Color.STEELBLUE = Object.freeze(Color.fromCssColorString("#4682B4"));
  Color.TAN = Object.freeze(Color.fromCssColorString("#D2B48C"));
  Color.TEAL = Object.freeze(Color.fromCssColorString("#008080"));
  Color.THISTLE = Object.freeze(Color.fromCssColorString("#D8BFD8"));
  Color.TOMATO = Object.freeze(Color.fromCssColorString("#FF6347"));
  Color.TURQUOISE = Object.freeze(Color.fromCssColorString("#40E0D0"));
  Color.VIOLET = Object.freeze(Color.fromCssColorString("#EE82EE"));
  Color.WHEAT = Object.freeze(Color.fromCssColorString("#F5DEB3"));
  Color.WHITE = Object.freeze(Color.fromCssColorString("#FFFFFF"));
  Color.WHITESMOKE = Object.freeze(Color.fromCssColorString("#F5F5F5"));
  Color.YELLOW = Object.freeze(Color.fromCssColorString("#FFFF00"));
  Color.YELLOWGREEN = Object.freeze(Color.fromCssColorString("#9ACD32"));
  Color.TRANSPARENT = Object.freeze(new Color(0, 0, 0, 0));
  var Color_default = Color;

  // Source/Renderer/ClearCommand.js
  function ClearCommand(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    this.color = options.color;
    this.depth = options.depth;
    this.stencil = options.stencil;
    this.renderState = options.renderState;
    this.framebuffer = options.framebuffer;
    this.owner = options.owner;
    this.pass = options.pass;
  }
  ClearCommand.ALL = Object.freeze(
    new ClearCommand({
      color: new Color_default(0, 0, 0, 0),
      depth: 1,
      stencil: 0
    })
  );
  ClearCommand.prototype.execute = function(context, passState) {
    context.clear(this, passState);
  };
  var ClearCommand_default = ClearCommand;

  // Source/Renderer/Pass.js
  var Pass = {
    ENVIRONMENT: 0,
    COMPUTE: 1,
    GLOBE: 2,
    TERRAIN_CLASSIFICATION: 3,
    CESIUM_3D_TILE: 4,
    CESIUM_3D_TILE_CLASSIFICATION: 5,
    CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW: 6,
    OPAQUE: 7,
    TRANSLUCENT: 8,
    OVERLAY: 9,
    NUMBER_OF_PASSES: 10
  };
  var Pass_default = Object.freeze(Pass);

  // Source/Renderer/ComputeCommand.js
  function ComputeCommand(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    this.vertexArray = options.vertexArray;
    this.fragmentShaderSource = options.fragmentShaderSource;
    this.shaderProgram = options.shaderProgram;
    this.uniformMap = options.uniformMap;
    this.outputTexture = options.outputTexture;
    this.preExecute = options.preExecute;
    this.postExecute = options.postExecute;
    this.canceled = options.canceled;
    this.persists = defaultValue_default(options.persists, false);
    this.pass = Pass_default.COMPUTE;
    this.owner = options.owner;
  }
  ComputeCommand.prototype.execute = function(computeEngine) {
    computeEngine.execute(this);
  };
  var ComputeCommand_default = ComputeCommand;

  // Source/Core/Cartesian2.js
  function Cartesian2(x, y) {
    this.x = defaultValue_default(x, 0);
    this.y = defaultValue_default(y, 0);
  }
  Cartesian2.fromElements = function(x, y, result) {
    if (!defined_default(result)) {
      return new Cartesian2(x, y);
    }
    result.x = x;
    result.y = y;
    return result;
  };
  Cartesian2.clone = function(cartesian11, result) {
    if (!defined_default(cartesian11)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Cartesian2(cartesian11.x, cartesian11.y);
    }
    result.x = cartesian11.x;
    result.y = cartesian11.y;
    return result;
  };
  Cartesian2.fromCartesian3 = Cartesian2.clone;
  Cartesian2.fromCartesian4 = Cartesian2.clone;
  Cartesian2.packedLength = 2;
  Cartesian2.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value.x;
    array[startingIndex] = value.y;
    return array;
  };
  Cartesian2.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Cartesian2();
    }
    result.x = array[startingIndex++];
    result.y = array[startingIndex];
    return result;
  };
  Cartesian2.packArray = function(array, result) {
    Check_default.defined("array", array);
    const length3 = array.length;
    const resultLength = length3 * 2;
    if (!defined_default(result)) {
      result = new Array(resultLength);
    } else if (!Array.isArray(result) && result.length !== resultLength) {
      throw new DeveloperError_default(
        "If result is a typed array, it must have exactly array.length * 2 elements"
      );
    } else if (result.length !== resultLength) {
      result.length = resultLength;
    }
    for (let i = 0; i < length3; ++i) {
      Cartesian2.pack(array[i], result, i * 2);
    }
    return result;
  };
  Cartesian2.unpackArray = function(array, result) {
    Check_default.defined("array", array);
    Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 2);
    if (array.length % 2 !== 0) {
      throw new DeveloperError_default("array length must be a multiple of 2.");
    }
    const length3 = array.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 2);
    } else {
      result.length = length3 / 2;
    }
    for (let i = 0; i < length3; i += 2) {
      const index = i / 2;
      result[index] = Cartesian2.unpack(array, i, result[index]);
    }
    return result;
  };
  Cartesian2.fromArray = Cartesian2.unpack;
  Cartesian2.maximumComponent = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return Math.max(cartesian11.x, cartesian11.y);
  };
  Cartesian2.minimumComponent = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return Math.min(cartesian11.x, cartesian11.y);
  };
  Cartesian2.minimumByComponent = function(first, second, result) {
    Check_default.typeOf.object("first", first);
    Check_default.typeOf.object("second", second);
    Check_default.typeOf.object("result", result);
    result.x = Math.min(first.x, second.x);
    result.y = Math.min(first.y, second.y);
    return result;
  };
  Cartesian2.maximumByComponent = function(first, second, result) {
    Check_default.typeOf.object("first", first);
    Check_default.typeOf.object("second", second);
    Check_default.typeOf.object("result", result);
    result.x = Math.max(first.x, second.x);
    result.y = Math.max(first.y, second.y);
    return result;
  };
  Cartesian2.clamp = function(value, min3, max3, result) {
    Check_default.typeOf.object("value", value);
    Check_default.typeOf.object("min", min3);
    Check_default.typeOf.object("max", max3);
    Check_default.typeOf.object("result", result);
    const x = Math_default.clamp(value.x, min3.x, max3.x);
    const y = Math_default.clamp(value.y, min3.y, max3.y);
    result.x = x;
    result.y = y;
    return result;
  };
  Cartesian2.magnitudeSquared = function(cartesian11) {
    Check_default.typeOf.object("cartesian", cartesian11);
    return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y;
  };
  Cartesian2.magnitude = function(cartesian11) {
    return Math.sqrt(Cartesian2.magnitudeSquared(cartesian11));
  };
  var distanceScratch3 = new Cartesian2();
  Cartesian2.distance = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Cartesian2.subtract(left, right, distanceScratch3);
    return Cartesian2.magnitude(distanceScratch3);
  };
  Cartesian2.distanceSquared = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Cartesian2.subtract(left, right, distanceScratch3);
    return Cartesian2.magnitudeSquared(distanceScratch3);
  };
  Cartesian2.normalize = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const magnitude = Cartesian2.magnitude(cartesian11);
    result.x = cartesian11.x / magnitude;
    result.y = cartesian11.y / magnitude;
    if (isNaN(result.x) || isNaN(result.y)) {
      throw new DeveloperError_default("normalized result is not a number");
    }
    return result;
  };
  Cartesian2.dot = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    return left.x * right.x + left.y * right.y;
  };
  Cartesian2.cross = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    return left.x * right.y - left.y * right.x;
  };
  Cartesian2.multiplyComponents = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x * right.x;
    result.y = left.y * right.y;
    return result;
  };
  Cartesian2.divideComponents = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x / right.x;
    result.y = left.y / right.y;
    return result;
  };
  Cartesian2.add = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x + right.x;
    result.y = left.y + right.y;
    return result;
  };
  Cartesian2.subtract = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x - right.x;
    result.y = left.y - right.y;
    return result;
  };
  Cartesian2.multiplyByScalar = function(cartesian11, scalar, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.x = cartesian11.x * scalar;
    result.y = cartesian11.y * scalar;
    return result;
  };
  Cartesian2.divideByScalar = function(cartesian11, scalar, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.x = cartesian11.x / scalar;
    result.y = cartesian11.y / scalar;
    return result;
  };
  Cartesian2.negate = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result.x = -cartesian11.x;
    result.y = -cartesian11.y;
    return result;
  };
  Cartesian2.abs = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result.x = Math.abs(cartesian11.x);
    result.y = Math.abs(cartesian11.y);
    return result;
  };
  var lerpScratch3 = new Cartesian2();
  Cartesian2.lerp = function(start, end, t, result) {
    Check_default.typeOf.object("start", start);
    Check_default.typeOf.object("end", end);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    Cartesian2.multiplyByScalar(end, t, lerpScratch3);
    result = Cartesian2.multiplyByScalar(start, 1 - t, result);
    return Cartesian2.add(lerpScratch3, result, result);
  };
  var angleBetweenScratch3 = new Cartesian2();
  var angleBetweenScratch22 = new Cartesian2();
  Cartesian2.angleBetween = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Cartesian2.normalize(left, angleBetweenScratch3);
    Cartesian2.normalize(right, angleBetweenScratch22);
    return Math_default.acosClamped(
      Cartesian2.dot(angleBetweenScratch3, angleBetweenScratch22)
    );
  };
  var mostOrthogonalAxisScratch3 = new Cartesian2();
  Cartesian2.mostOrthogonalAxis = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const f = Cartesian2.normalize(cartesian11, mostOrthogonalAxisScratch3);
    Cartesian2.abs(f, f);
    if (f.x <= f.y) {
      result = Cartesian2.clone(Cartesian2.UNIT_X, result);
    } else {
      result = Cartesian2.clone(Cartesian2.UNIT_Y, result);
    }
    return result;
  };
  Cartesian2.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y;
  };
  Cartesian2.equalsArray = function(cartesian11, array, offset2) {
    return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1];
  };
  Cartesian2.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
    return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
      left.x,
      right.x,
      relativeEpsilon,
      absoluteEpsilon
    ) && Math_default.equalsEpsilon(
      left.y,
      right.y,
      relativeEpsilon,
      absoluteEpsilon
    );
  };
  Cartesian2.ZERO = Object.freeze(new Cartesian2(0, 0));
  Cartesian2.ONE = Object.freeze(new Cartesian2(1, 1));
  Cartesian2.UNIT_X = Object.freeze(new Cartesian2(1, 0));
  Cartesian2.UNIT_Y = Object.freeze(new Cartesian2(0, 1));
  Cartesian2.prototype.clone = function(result) {
    return Cartesian2.clone(this, result);
  };
  Cartesian2.prototype.equals = function(right) {
    return Cartesian2.equals(this, right);
  };
  Cartesian2.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
    return Cartesian2.equalsEpsilon(
      this,
      right,
      relativeEpsilon,
      absoluteEpsilon
    );
  };
  Cartesian2.prototype.toString = function() {
    return `(${this.x}, ${this.y})`;
  };
  var Cartesian2_default = Cartesian2;

  // Source/Core/scaleToGeodeticSurface.js
  var scaleToGeodeticSurfaceIntersection = new Cartesian3_default();
  var scaleToGeodeticSurfaceGradient = new Cartesian3_default();
  function scaleToGeodeticSurface(cartesian11, oneOverRadii, oneOverRadiiSquared, centerToleranceSquared, result) {
    if (!defined_default(cartesian11)) {
      throw new DeveloperError_default("cartesian is required.");
    }
    if (!defined_default(oneOverRadii)) {
      throw new DeveloperError_default("oneOverRadii is required.");
    }
    if (!defined_default(oneOverRadiiSquared)) {
      throw new DeveloperError_default("oneOverRadiiSquared is required.");
    }
    if (!defined_default(centerToleranceSquared)) {
      throw new DeveloperError_default("centerToleranceSquared is required.");
    }
    const positionX = cartesian11.x;
    const positionY = cartesian11.y;
    const positionZ = cartesian11.z;
    const oneOverRadiiX = oneOverRadii.x;
    const oneOverRadiiY = oneOverRadii.y;
    const oneOverRadiiZ = oneOverRadii.z;
    const x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
    const y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
    const z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
    const squaredNorm = x2 + y2 + z2;
    const ratio = Math.sqrt(1 / squaredNorm);
    const intersection = Cartesian3_default.multiplyByScalar(
      cartesian11,
      ratio,
      scaleToGeodeticSurfaceIntersection
    );
    if (squaredNorm < centerToleranceSquared) {
      return !isFinite(ratio) ? void 0 : Cartesian3_default.clone(intersection, result);
    }
    const oneOverRadiiSquaredX = oneOverRadiiSquared.x;
    const oneOverRadiiSquaredY = oneOverRadiiSquared.y;
    const oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
    const gradient = scaleToGeodeticSurfaceGradient;
    gradient.x = intersection.x * oneOverRadiiSquaredX * 2;
    gradient.y = intersection.y * oneOverRadiiSquaredY * 2;
    gradient.z = intersection.z * oneOverRadiiSquaredZ * 2;
    let lambda = (1 - ratio) * Cartesian3_default.magnitude(cartesian11) / (0.5 * Cartesian3_default.magnitude(gradient));
    let correction = 0;
    let func;
    let denominator;
    let xMultiplier;
    let yMultiplier;
    let zMultiplier;
    let xMultiplier2;
    let yMultiplier2;
    let zMultiplier2;
    let xMultiplier3;
    let yMultiplier3;
    let zMultiplier3;
    do {
      lambda -= correction;
      xMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredX);
      yMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredY);
      zMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredZ);
      xMultiplier2 = xMultiplier * xMultiplier;
      yMultiplier2 = yMultiplier * yMultiplier;
      zMultiplier2 = zMultiplier * zMultiplier;
      xMultiplier3 = xMultiplier2 * xMultiplier;
      yMultiplier3 = yMultiplier2 * yMultiplier;
      zMultiplier3 = zMultiplier2 * zMultiplier;
      func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1;
      denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
      const derivative = -2 * denominator;
      correction = func / derivative;
    } while (Math.abs(func) > Math_default.EPSILON12);
    if (!defined_default(result)) {
      return new Cartesian3_default(
        positionX * xMultiplier,
        positionY * yMultiplier,
        positionZ * zMultiplier
      );
    }
    result.x = positionX * xMultiplier;
    result.y = positionY * yMultiplier;
    result.z = positionZ * zMultiplier;
    return result;
  }
  var scaleToGeodeticSurface_default = scaleToGeodeticSurface;

  // Source/Core/Cartographic.js
  function Cartographic(longitude, latitude, height) {
    this.longitude = defaultValue_default(longitude, 0);
    this.latitude = defaultValue_default(latitude, 0);
    this.height = defaultValue_default(height, 0);
  }
  Cartographic.fromRadians = function(longitude, latitude, height, result) {
    Check_default.typeOf.number("longitude", longitude);
    Check_default.typeOf.number("latitude", latitude);
    height = defaultValue_default(height, 0);
    if (!defined_default(result)) {
      return new Cartographic(longitude, latitude, height);
    }
    result.longitude = longitude;
    result.latitude = latitude;
    result.height = height;
    return result;
  };
  Cartographic.fromDegrees = function(longitude, latitude, height, result) {
    Check_default.typeOf.number("longitude", longitude);
    Check_default.typeOf.number("latitude", latitude);
    longitude = Math_default.toRadians(longitude);
    latitude = Math_default.toRadians(latitude);
    return Cartographic.fromRadians(longitude, latitude, height, result);
  };
  var cartesianToCartographicN = new Cartesian3_default();
  var cartesianToCartographicP = new Cartesian3_default();
  var cartesianToCartographicH = new Cartesian3_default();
  var wgs84OneOverRadii = new Cartesian3_default(
    1 / 6378137,
    1 / 6378137,
    1 / 6356752314245179e-9
  );
  var wgs84OneOverRadiiSquared = new Cartesian3_default(
    1 / (6378137 * 6378137),
    1 / (6378137 * 6378137),
    1 / (6356752314245179e-9 * 6356752314245179e-9)
  );
  var wgs84CenterToleranceSquared = Math_default.EPSILON1;
  Cartographic.fromCartesian = function(cartesian11, ellipsoid, result) {
    const oneOverRadii = defined_default(ellipsoid) ? ellipsoid.oneOverRadii : wgs84OneOverRadii;
    const oneOverRadiiSquared = defined_default(ellipsoid) ? ellipsoid.oneOverRadiiSquared : wgs84OneOverRadiiSquared;
    const centerToleranceSquared = defined_default(ellipsoid) ? ellipsoid._centerToleranceSquared : wgs84CenterToleranceSquared;
    const p = scaleToGeodeticSurface_default(
      cartesian11,
      oneOverRadii,
      oneOverRadiiSquared,
      centerToleranceSquared,
      cartesianToCartographicP
    );
    if (!defined_default(p)) {
      return void 0;
    }
    let n = Cartesian3_default.multiplyComponents(
      p,
      oneOverRadiiSquared,
      cartesianToCartographicN
    );
    n = Cartesian3_default.normalize(n, n);
    const h = Cartesian3_default.subtract(cartesian11, p, cartesianToCartographicH);
    const longitude = Math.atan2(n.y, n.x);
    const latitude = Math.asin(n.z);
    const height = Math_default.sign(Cartesian3_default.dot(h, cartesian11)) * Cartesian3_default.magnitude(h);
    if (!defined_default(result)) {
      return new Cartographic(longitude, latitude, height);
    }
    result.longitude = longitude;
    result.latitude = latitude;
    result.height = height;
    return result;
  };
  Cartographic.toCartesian = function(cartographic2, ellipsoid, result) {
    Check_default.defined("cartographic", cartographic2);
    return Cartesian3_default.fromRadians(
      cartographic2.longitude,
      cartographic2.latitude,
      cartographic2.height,
      ellipsoid,
      result
    );
  };
  Cartographic.clone = function(cartographic2, result) {
    if (!defined_default(cartographic2)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Cartographic(
        cartographic2.longitude,
        cartographic2.latitude,
        cartographic2.height
      );
    }
    result.longitude = cartographic2.longitude;
    result.latitude = cartographic2.latitude;
    result.height = cartographic2.height;
    return result;
  };
  Cartographic.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.longitude === right.longitude && left.latitude === right.latitude && left.height === right.height;
  };
  Cartographic.equalsEpsilon = function(left, right, epsilon) {
    epsilon = defaultValue_default(epsilon, 0);
    return left === right || defined_default(left) && defined_default(right) && Math.abs(left.longitude - right.longitude) <= epsilon && Math.abs(left.latitude - right.latitude) <= epsilon && Math.abs(left.height - right.height) <= epsilon;
  };
  Cartographic.ZERO = Object.freeze(new Cartographic(0, 0, 0));
  Cartographic.prototype.clone = function(result) {
    return Cartographic.clone(this, result);
  };
  Cartographic.prototype.equals = function(right) {
    return Cartographic.equals(this, right);
  };
  Cartographic.prototype.equalsEpsilon = function(right, epsilon) {
    return Cartographic.equalsEpsilon(this, right, epsilon);
  };
  Cartographic.prototype.toString = function() {
    return `(${this.longitude}, ${this.latitude}, ${this.height})`;
  };
  var Cartographic_default = Cartographic;

  // Source/Core/Ellipsoid.js
  function initialize(ellipsoid, x, y, z) {
    x = defaultValue_default(x, 0);
    y = defaultValue_default(y, 0);
    z = defaultValue_default(z, 0);
    Check_default.typeOf.number.greaterThanOrEquals("x", x, 0);
    Check_default.typeOf.number.greaterThanOrEquals("y", y, 0);
    Check_default.typeOf.number.greaterThanOrEquals("z", z, 0);
    ellipsoid._radii = new Cartesian3_default(x, y, z);
    ellipsoid._radiiSquared = new Cartesian3_default(x * x, y * y, z * z);
    ellipsoid._radiiToTheFourth = new Cartesian3_default(
      x * x * x * x,
      y * y * y * y,
      z * z * z * z
    );
    ellipsoid._oneOverRadii = new Cartesian3_default(
      x === 0 ? 0 : 1 / x,
      y === 0 ? 0 : 1 / y,
      z === 0 ? 0 : 1 / z
    );
    ellipsoid._oneOverRadiiSquared = new Cartesian3_default(
      x === 0 ? 0 : 1 / (x * x),
      y === 0 ? 0 : 1 / (y * y),
      z === 0 ? 0 : 1 / (z * z)
    );
    ellipsoid._minimumRadius = Math.min(x, y, z);
    ellipsoid._maximumRadius = Math.max(x, y, z);
    ellipsoid._centerToleranceSquared = Math_default.EPSILON1;
    if (ellipsoid._radiiSquared.z !== 0) {
      ellipsoid._squaredXOverSquaredZ = ellipsoid._radiiSquared.x / ellipsoid._radiiSquared.z;
    }
  }
  function Ellipsoid(x, y, z) {
    this._radii = void 0;
    this._radiiSquared = void 0;
    this._radiiToTheFourth = void 0;
    this._oneOverRadii = void 0;
    this._oneOverRadiiSquared = void 0;
    this._minimumRadius = void 0;
    this._maximumRadius = void 0;
    this._centerToleranceSquared = void 0;
    this._squaredXOverSquaredZ = void 0;
    initialize(this, x, y, z);
  }
  Object.defineProperties(Ellipsoid.prototype, {
    radii: {
      get: function() {
        return this._radii;
      }
    },
    radiiSquared: {
      get: function() {
        return this._radiiSquared;
      }
    },
    radiiToTheFourth: {
      get: function() {
        return this._radiiToTheFourth;
      }
    },
    oneOverRadii: {
      get: function() {
        return this._oneOverRadii;
      }
    },
    oneOverRadiiSquared: {
      get: function() {
        return this._oneOverRadiiSquared;
      }
    },
    minimumRadius: {
      get: function() {
        return this._minimumRadius;
      }
    },
    maximumRadius: {
      get: function() {
        return this._maximumRadius;
      }
    }
  });
  Ellipsoid.clone = function(ellipsoid, result) {
    if (!defined_default(ellipsoid)) {
      return void 0;
    }
    const radii = ellipsoid._radii;
    if (!defined_default(result)) {
      return new Ellipsoid(radii.x, radii.y, radii.z);
    }
    Cartesian3_default.clone(radii, result._radii);
    Cartesian3_default.clone(ellipsoid._radiiSquared, result._radiiSquared);
    Cartesian3_default.clone(ellipsoid._radiiToTheFourth, result._radiiToTheFourth);
    Cartesian3_default.clone(ellipsoid._oneOverRadii, result._oneOverRadii);
    Cartesian3_default.clone(ellipsoid._oneOverRadiiSquared, result._oneOverRadiiSquared);
    result._minimumRadius = ellipsoid._minimumRadius;
    result._maximumRadius = ellipsoid._maximumRadius;
    result._centerToleranceSquared = ellipsoid._centerToleranceSquared;
    return result;
  };
  Ellipsoid.fromCartesian3 = function(cartesian11, result) {
    if (!defined_default(result)) {
      result = new Ellipsoid();
    }
    if (!defined_default(cartesian11)) {
      return result;
    }
    initialize(result, cartesian11.x, cartesian11.y, cartesian11.z);
    return result;
  };
  Ellipsoid.WGS84 = Object.freeze(
    new Ellipsoid(6378137, 6378137, 6356752314245179e-9)
  );
  Ellipsoid.UNIT_SPHERE = Object.freeze(new Ellipsoid(1, 1, 1));
  Ellipsoid.MOON = Object.freeze(
    new Ellipsoid(
      Math_default.LUNAR_RADIUS,
      Math_default.LUNAR_RADIUS,
      Math_default.LUNAR_RADIUS
    )
  );
  Ellipsoid.prototype.clone = function(result) {
    return Ellipsoid.clone(this, result);
  };
  Ellipsoid.packedLength = Cartesian3_default.packedLength;
  Ellipsoid.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    Cartesian3_default.pack(value._radii, array, startingIndex);
    return array;
  };
  Ellipsoid.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    const radii = Cartesian3_default.unpack(array, startingIndex);
    return Ellipsoid.fromCartesian3(radii, result);
  };
  Ellipsoid.prototype.geocentricSurfaceNormal = Cartesian3_default.normalize;
  Ellipsoid.prototype.geodeticSurfaceNormalCartographic = function(cartographic2, result) {
    Check_default.typeOf.object("cartographic", cartographic2);
    const longitude = cartographic2.longitude;
    const latitude = cartographic2.latitude;
    const cosLatitude = Math.cos(latitude);
    const x = cosLatitude * Math.cos(longitude);
    const y = cosLatitude * Math.sin(longitude);
    const z = Math.sin(latitude);
    if (!defined_default(result)) {
      result = new Cartesian3_default();
    }
    result.x = x;
    result.y = y;
    result.z = z;
    return Cartesian3_default.normalize(result, result);
  };
  Ellipsoid.prototype.geodeticSurfaceNormal = function(cartesian11, result) {
    if (Cartesian3_default.equalsEpsilon(cartesian11, Cartesian3_default.ZERO, Math_default.EPSILON14)) {
      return void 0;
    }
    if (!defined_default(result)) {
      result = new Cartesian3_default();
    }
    result = Cartesian3_default.multiplyComponents(
      cartesian11,
      this._oneOverRadiiSquared,
      result
    );
    return Cartesian3_default.normalize(result, result);
  };
  var cartographicToCartesianNormal = new Cartesian3_default();
  var cartographicToCartesianK = new Cartesian3_default();
  Ellipsoid.prototype.cartographicToCartesian = function(cartographic2, result) {
    const n = cartographicToCartesianNormal;
    const k = cartographicToCartesianK;
    this.geodeticSurfaceNormalCartographic(cartographic2, n);
    Cartesian3_default.multiplyComponents(this._radiiSquared, n, k);
    const gamma = Math.sqrt(Cartesian3_default.dot(n, k));
    Cartesian3_default.divideByScalar(k, gamma, k);
    Cartesian3_default.multiplyByScalar(n, cartographic2.height, n);
    if (!defined_default(result)) {
      result = new Cartesian3_default();
    }
    return Cartesian3_default.add(k, n, result);
  };
  Ellipsoid.prototype.cartographicArrayToCartesianArray = function(cartographics, result) {
    Check_default.defined("cartographics", cartographics);
    const length3 = cartographics.length;
    if (!defined_default(result)) {
      result = new Array(length3);
    } else {
      result.length = length3;
    }
    for (let i = 0; i < length3; i++) {
      result[i] = this.cartographicToCartesian(cartographics[i], result[i]);
    }
    return result;
  };
  var cartesianToCartographicN2 = new Cartesian3_default();
  var cartesianToCartographicP2 = new Cartesian3_default();
  var cartesianToCartographicH2 = new Cartesian3_default();
  Ellipsoid.prototype.cartesianToCartographic = function(cartesian11, result) {
    const p = this.scaleToGeodeticSurface(cartesian11, cartesianToCartographicP2);
    if (!defined_default(p)) {
      return void 0;
    }
    const n = this.geodeticSurfaceNormal(p, cartesianToCartographicN2);
    const h = Cartesian3_default.subtract(cartesian11, p, cartesianToCartographicH2);
    const longitude = Math.atan2(n.y, n.x);
    const latitude = Math.asin(n.z);
    const height = Math_default.sign(Cartesian3_default.dot(h, cartesian11)) * Cartesian3_default.magnitude(h);
    if (!defined_default(result)) {
      return new Cartographic_default(longitude, latitude, height);
    }
    result.longitude = longitude;
    result.latitude = latitude;
    result.height = height;
    return result;
  };
  Ellipsoid.prototype.cartesianArrayToCartographicArray = function(cartesians, result) {
    Check_default.defined("cartesians", cartesians);
    const length3 = cartesians.length;
    if (!defined_default(result)) {
      result = new Array(length3);
    } else {
      result.length = length3;
    }
    for (let i = 0; i < length3; ++i) {
      result[i] = this.cartesianToCartographic(cartesians[i], result[i]);
    }
    return result;
  };
  Ellipsoid.prototype.scaleToGeodeticSurface = function(cartesian11, result) {
    return scaleToGeodeticSurface_default(
      cartesian11,
      this._oneOverRadii,
      this._oneOverRadiiSquared,
      this._centerToleranceSquared,
      result
    );
  };
  Ellipsoid.prototype.scaleToGeocentricSurface = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    if (!defined_default(result)) {
      result = new Cartesian3_default();
    }
    const positionX = cartesian11.x;
    const positionY = cartesian11.y;
    const positionZ = cartesian11.z;
    const oneOverRadiiSquared = this._oneOverRadiiSquared;
    const beta = 1 / Math.sqrt(
      positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z
    );
    return Cartesian3_default.multiplyByScalar(cartesian11, beta, result);
  };
  Ellipsoid.prototype.transformPositionToScaledSpace = function(position, result) {
    if (!defined_default(result)) {
      result = new Cartesian3_default();
    }
    return Cartesian3_default.multiplyComponents(position, this._oneOverRadii, result);
  };
  Ellipsoid.prototype.transformPositionFromScaledSpace = function(position, result) {
    if (!defined_default(result)) {
      result = new Cartesian3_default();
    }
    return Cartesian3_default.multiplyComponents(position, this._radii, result);
  };
  Ellipsoid.prototype.equals = function(right) {
    return this === right || defined_default(right) && Cartesian3_default.equals(this._radii, right._radii);
  };
  Ellipsoid.prototype.toString = function() {
    return this._radii.toString();
  };
  Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis = function(position, buffer, result) {
    Check_default.typeOf.object("position", position);
    if (!Math_default.equalsEpsilon(
      this._radii.x,
      this._radii.y,
      Math_default.EPSILON15
    )) {
      throw new DeveloperError_default(
        "Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)"
      );
    }
    Check_default.typeOf.number.greaterThan("Ellipsoid.radii.z", this._radii.z, 0);
    buffer = defaultValue_default(buffer, 0);
    const squaredXOverSquaredZ = this._squaredXOverSquaredZ;
    if (!defined_default(result)) {
      result = new Cartesian3_default();
    }
    result.x = 0;
    result.y = 0;
    result.z = position.z * (1 - squaredXOverSquaredZ);
    if (Math.abs(result.z) >= this._radii.z - buffer) {
      return void 0;
    }
    return result;
  };
  var abscissas = [
    0.14887433898163,
    0.43339539412925,
    0.67940956829902,
    0.86506336668898,
    0.97390652851717,
    0
  ];
  var weights = [
    0.29552422471475,
    0.26926671930999,
    0.21908636251598,
    0.14945134915058,
    0.066671344308684,
    0
  ];
  function gaussLegendreQuadrature(a3, b, func) {
    Check_default.typeOf.number("a", a3);
    Check_default.typeOf.number("b", b);
    Check_default.typeOf.func("func", func);
    const xMean = 0.5 * (b + a3);
    const xRange = 0.5 * (b - a3);
    let sum = 0;
    for (let i = 0; i < 5; i++) {
      const dx = xRange * abscissas[i];
      sum += weights[i] * (func(xMean + dx) + func(xMean - dx));
    }
    sum *= xRange;
    return sum;
  }
  Ellipsoid.prototype.surfaceArea = function(rectangle) {
    Check_default.typeOf.object("rectangle", rectangle);
    const minLongitude = rectangle.west;
    let maxLongitude = rectangle.east;
    const minLatitude = rectangle.south;
    const maxLatitude = rectangle.north;
    while (maxLongitude < minLongitude) {
      maxLongitude += Math_default.TWO_PI;
    }
    const radiiSquared = this._radiiSquared;
    const a22 = radiiSquared.x;
    const b2 = radiiSquared.y;
    const c22 = radiiSquared.z;
    const a2b2 = a22 * b2;
    return gaussLegendreQuadrature(minLatitude, maxLatitude, function(lat) {
      const sinPhi = Math.cos(lat);
      const cosPhi = Math.sin(lat);
      return Math.cos(lat) * gaussLegendreQuadrature(minLongitude, maxLongitude, function(lon) {
        const cosTheta = Math.cos(lon);
        const sinTheta = Math.sin(lon);
        return Math.sqrt(
          a2b2 * cosPhi * cosPhi + c22 * (b2 * cosTheta * cosTheta + a22 * sinTheta * sinTheta) * sinPhi * sinPhi
        );
      });
    });
  };
  var Ellipsoid_default = Ellipsoid;

  // Source/Core/GeographicProjection.js
  function GeographicProjection(ellipsoid) {
    this._ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
    this._semimajorAxis = this._ellipsoid.maximumRadius;
    this._oneOverSemimajorAxis = 1 / this._semimajorAxis;
  }
  Object.defineProperties(GeographicProjection.prototype, {
    ellipsoid: {
      get: function() {
        return this._ellipsoid;
      }
    }
  });
  GeographicProjection.prototype.project = function(cartographic2, result) {
    const semimajorAxis = this._semimajorAxis;
    const x = cartographic2.longitude * semimajorAxis;
    const y = cartographic2.latitude * semimajorAxis;
    const z = cartographic2.height;
    if (!defined_default(result)) {
      return new Cartesian3_default(x, y, z);
    }
    result.x = x;
    result.y = y;
    result.z = z;
    return result;
  };
  GeographicProjection.prototype.unproject = function(cartesian11, result) {
    if (!defined_default(cartesian11)) {
      throw new DeveloperError_default("cartesian is required");
    }
    const oneOverEarthSemimajorAxis = this._oneOverSemimajorAxis;
    const longitude = cartesian11.x * oneOverEarthSemimajorAxis;
    const latitude = cartesian11.y * oneOverEarthSemimajorAxis;
    const height = cartesian11.z;
    if (!defined_default(result)) {
      return new Cartographic_default(longitude, latitude, height);
    }
    result.longitude = longitude;
    result.latitude = latitude;
    result.height = height;
    return result;
  };
  var GeographicProjection_default = GeographicProjection;

  // Source/Core/Intersect.js
  var Intersect = {
    OUTSIDE: -1,
    INTERSECTING: 0,
    INSIDE: 1
  };
  var Intersect_default = Object.freeze(Intersect);

  // Source/Core/Rectangle.js
  function Rectangle(west, south, east, north) {
    this.west = defaultValue_default(west, 0);
    this.south = defaultValue_default(south, 0);
    this.east = defaultValue_default(east, 0);
    this.north = defaultValue_default(north, 0);
  }
  Object.defineProperties(Rectangle.prototype, {
    width: {
      get: function() {
        return Rectangle.computeWidth(this);
      }
    },
    height: {
      get: function() {
        return Rectangle.computeHeight(this);
      }
    }
  });
  Rectangle.packedLength = 4;
  Rectangle.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value.west;
    array[startingIndex++] = value.south;
    array[startingIndex++] = value.east;
    array[startingIndex] = value.north;
    return array;
  };
  Rectangle.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Rectangle();
    }
    result.west = array[startingIndex++];
    result.south = array[startingIndex++];
    result.east = array[startingIndex++];
    result.north = array[startingIndex];
    return result;
  };
  Rectangle.computeWidth = function(rectangle) {
    Check_default.typeOf.object("rectangle", rectangle);
    let east = rectangle.east;
    const west = rectangle.west;
    if (east < west) {
      east += Math_default.TWO_PI;
    }
    return east - west;
  };
  Rectangle.computeHeight = function(rectangle) {
    Check_default.typeOf.object("rectangle", rectangle);
    return rectangle.north - rectangle.south;
  };
  Rectangle.fromDegrees = function(west, south, east, north, result) {
    west = Math_default.toRadians(defaultValue_default(west, 0));
    south = Math_default.toRadians(defaultValue_default(south, 0));
    east = Math_default.toRadians(defaultValue_default(east, 0));
    north = Math_default.toRadians(defaultValue_default(north, 0));
    if (!defined_default(result)) {
      return new Rectangle(west, south, east, north);
    }
    result.west = west;
    result.south = south;
    result.east = east;
    result.north = north;
    return result;
  };
  Rectangle.fromRadians = function(west, south, east, north, result) {
    if (!defined_default(result)) {
      return new Rectangle(west, south, east, north);
    }
    result.west = defaultValue_default(west, 0);
    result.south = defaultValue_default(south, 0);
    result.east = defaultValue_default(east, 0);
    result.north = defaultValue_default(north, 0);
    return result;
  };
  Rectangle.fromCartographicArray = function(cartographics, result) {
    Check_default.defined("cartographics", cartographics);
    let west = Number.MAX_VALUE;
    let east = -Number.MAX_VALUE;
    let westOverIDL = Number.MAX_VALUE;
    let eastOverIDL = -Number.MAX_VALUE;
    let south = Number.MAX_VALUE;
    let north = -Number.MAX_VALUE;
    for (let i = 0, len = cartographics.length; i < len; i++) {
      const position = cartographics[i];
      west = Math.min(west, position.longitude);
      east = Math.max(east, position.longitude);
      south = Math.min(south, position.latitude);
      north = Math.max(north, position.latitude);
      const lonAdjusted = position.longitude >= 0 ? position.longitude : position.longitude + Math_default.TWO_PI;
      westOverIDL = Math.min(westOverIDL, lonAdjusted);
      eastOverIDL = Math.max(eastOverIDL, lonAdjusted);
    }
    if (east - west > eastOverIDL - westOverIDL) {
      west = westOverIDL;
      east = eastOverIDL;
      if (east > Math_default.PI) {
        east = east - Math_default.TWO_PI;
      }
      if (west > Math_default.PI) {
        west = west - Math_default.TWO_PI;
      }
    }
    if (!defined_default(result)) {
      return new Rectangle(west, south, east, north);
    }
    result.west = west;
    result.south = south;
    result.east = east;
    result.north = north;
    return result;
  };
  Rectangle.fromCartesianArray = function(cartesians, ellipsoid, result) {
    Check_default.defined("cartesians", cartesians);
    ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
    let west = Number.MAX_VALUE;
    let east = -Number.MAX_VALUE;
    let westOverIDL = Number.MAX_VALUE;
    let eastOverIDL = -Number.MAX_VALUE;
    let south = Number.MAX_VALUE;
    let north = -Number.MAX_VALUE;
    for (let i = 0, len = cartesians.length; i < len; i++) {
      const position = ellipsoid.cartesianToCartographic(cartesians[i]);
      west = Math.min(west, position.longitude);
      east = Math.max(east, position.longitude);
      south = Math.min(south, position.latitude);
      north = Math.max(north, position.latitude);
      const lonAdjusted = position.longitude >= 0 ? position.longitude : position.longitude + Math_default.TWO_PI;
      westOverIDL = Math.min(westOverIDL, lonAdjusted);
      eastOverIDL = Math.max(eastOverIDL, lonAdjusted);
    }
    if (east - west > eastOverIDL - westOverIDL) {
      west = westOverIDL;
      east = eastOverIDL;
      if (east > Math_default.PI) {
        east = east - Math_default.TWO_PI;
      }
      if (west > Math_default.PI) {
        west = west - Math_default.TWO_PI;
      }
    }
    if (!defined_default(result)) {
      return new Rectangle(west, south, east, north);
    }
    result.west = west;
    result.south = south;
    result.east = east;
    result.north = north;
    return result;
  };
  Rectangle.clone = function(rectangle, result) {
    if (!defined_default(rectangle)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Rectangle(
        rectangle.west,
        rectangle.south,
        rectangle.east,
        rectangle.north
      );
    }
    result.west = rectangle.west;
    result.south = rectangle.south;
    result.east = rectangle.east;
    result.north = rectangle.north;
    return result;
  };
  Rectangle.equalsEpsilon = function(left, right, absoluteEpsilon) {
    absoluteEpsilon = defaultValue_default(absoluteEpsilon, 0);
    return left === right || defined_default(left) && defined_default(right) && Math.abs(left.west - right.west) <= absoluteEpsilon && Math.abs(left.south - right.south) <= absoluteEpsilon && Math.abs(left.east - right.east) <= absoluteEpsilon && Math.abs(left.north - right.north) <= absoluteEpsilon;
  };
  Rectangle.prototype.clone = function(result) {
    return Rectangle.clone(this, result);
  };
  Rectangle.prototype.equals = function(other) {
    return Rectangle.equals(this, other);
  };
  Rectangle.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.west === right.west && left.south === right.south && left.east === right.east && left.north === right.north;
  };
  Rectangle.prototype.equalsEpsilon = function(other, epsilon) {
    return Rectangle.equalsEpsilon(this, other, epsilon);
  };
  Rectangle.validate = function(rectangle) {
    Check_default.typeOf.object("rectangle", rectangle);
    const north = rectangle.north;
    Check_default.typeOf.number.greaterThanOrEquals(
      "north",
      north,
      -Math_default.PI_OVER_TWO
    );
    Check_default.typeOf.number.lessThanOrEquals("north", north, Math_default.PI_OVER_TWO);
    const south = rectangle.south;
    Check_default.typeOf.number.greaterThanOrEquals(
      "south",
      south,
      -Math_default.PI_OVER_TWO
    );
    Check_default.typeOf.number.lessThanOrEquals("south", south, Math_default.PI_OVER_TWO);
    const west = rectangle.west;
    Check_default.typeOf.number.greaterThanOrEquals("west", west, -Math.PI);
    Check_default.typeOf.number.lessThanOrEquals("west", west, Math.PI);
    const east = rectangle.east;
    Check_default.typeOf.number.greaterThanOrEquals("east", east, -Math.PI);
    Check_default.typeOf.number.lessThanOrEquals("east", east, Math.PI);
  };
  Rectangle.southwest = function(rectangle, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    if (!defined_default(result)) {
      return new Cartographic_default(rectangle.west, rectangle.south);
    }
    result.longitude = rectangle.west;
    result.latitude = rectangle.south;
    result.height = 0;
    return result;
  };
  Rectangle.northwest = function(rectangle, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    if (!defined_default(result)) {
      return new Cartographic_default(rectangle.west, rectangle.north);
    }
    result.longitude = rectangle.west;
    result.latitude = rectangle.north;
    result.height = 0;
    return result;
  };
  Rectangle.northeast = function(rectangle, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    if (!defined_default(result)) {
      return new Cartographic_default(rectangle.east, rectangle.north);
    }
    result.longitude = rectangle.east;
    result.latitude = rectangle.north;
    result.height = 0;
    return result;
  };
  Rectangle.southeast = function(rectangle, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    if (!defined_default(result)) {
      return new Cartographic_default(rectangle.east, rectangle.south);
    }
    result.longitude = rectangle.east;
    result.latitude = rectangle.south;
    result.height = 0;
    return result;
  };
  Rectangle.center = function(rectangle, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    let east = rectangle.east;
    const west = rectangle.west;
    if (east < west) {
      east += Math_default.TWO_PI;
    }
    const longitude = Math_default.negativePiToPi((west + east) * 0.5);
    const latitude = (rectangle.south + rectangle.north) * 0.5;
    if (!defined_default(result)) {
      return new Cartographic_default(longitude, latitude);
    }
    result.longitude = longitude;
    result.latitude = latitude;
    result.height = 0;
    return result;
  };
  Rectangle.intersection = function(rectangle, otherRectangle, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    Check_default.typeOf.object("otherRectangle", otherRectangle);
    let rectangleEast = rectangle.east;
    let rectangleWest = rectangle.west;
    let otherRectangleEast = otherRectangle.east;
    let otherRectangleWest = otherRectangle.west;
    if (rectangleEast < rectangleWest && otherRectangleEast > 0) {
      rectangleEast += Math_default.TWO_PI;
    } else if (otherRectangleEast < otherRectangleWest && rectangleEast > 0) {
      otherRectangleEast += Math_default.TWO_PI;
    }
    if (rectangleEast < rectangleWest && otherRectangleWest < 0) {
      otherRectangleWest += Math_default.TWO_PI;
    } else if (otherRectangleEast < otherRectangleWest && rectangleWest < 0) {
      rectangleWest += Math_default.TWO_PI;
    }
    const west = Math_default.negativePiToPi(
      Math.max(rectangleWest, otherRectangleWest)
    );
    const east = Math_default.negativePiToPi(
      Math.min(rectangleEast, otherRectangleEast)
    );
    if ((rectangle.west < rectangle.east || otherRectangle.west < otherRectangle.east) && east <= west) {
      return void 0;
    }
    const south = Math.max(rectangle.south, otherRectangle.south);
    const north = Math.min(rectangle.north, otherRectangle.north);
    if (south >= north) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Rectangle(west, south, east, north);
    }
    result.west = west;
    result.south = south;
    result.east = east;
    result.north = north;
    return result;
  };
  Rectangle.simpleIntersection = function(rectangle, otherRectangle, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    Check_default.typeOf.object("otherRectangle", otherRectangle);
    const west = Math.max(rectangle.west, otherRectangle.west);
    const south = Math.max(rectangle.south, otherRectangle.south);
    const east = Math.min(rectangle.east, otherRectangle.east);
    const north = Math.min(rectangle.north, otherRectangle.north);
    if (south >= north || west >= east) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Rectangle(west, south, east, north);
    }
    result.west = west;
    result.south = south;
    result.east = east;
    result.north = north;
    return result;
  };
  Rectangle.union = function(rectangle, otherRectangle, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    Check_default.typeOf.object("otherRectangle", otherRectangle);
    if (!defined_default(result)) {
      result = new Rectangle();
    }
    let rectangleEast = rectangle.east;
    let rectangleWest = rectangle.west;
    let otherRectangleEast = otherRectangle.east;
    let otherRectangleWest = otherRectangle.west;
    if (rectangleEast < rectangleWest && otherRectangleEast > 0) {
      rectangleEast += Math_default.TWO_PI;
    } else if (otherRectangleEast < otherRectangleWest && rectangleEast > 0) {
      otherRectangleEast += Math_default.TWO_PI;
    }
    if (rectangleEast < rectangleWest && otherRectangleWest < 0) {
      otherRectangleWest += Math_default.TWO_PI;
    } else if (otherRectangleEast < otherRectangleWest && rectangleWest < 0) {
      rectangleWest += Math_default.TWO_PI;
    }
    const west = Math_default.negativePiToPi(
      Math.min(rectangleWest, otherRectangleWest)
    );
    const east = Math_default.negativePiToPi(
      Math.max(rectangleEast, otherRectangleEast)
    );
    result.west = west;
    result.south = Math.min(rectangle.south, otherRectangle.south);
    result.east = east;
    result.north = Math.max(rectangle.north, otherRectangle.north);
    return result;
  };
  Rectangle.expand = function(rectangle, cartographic2, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    Check_default.typeOf.object("cartographic", cartographic2);
    if (!defined_default(result)) {
      result = new Rectangle();
    }
    result.west = Math.min(rectangle.west, cartographic2.longitude);
    result.south = Math.min(rectangle.south, cartographic2.latitude);
    result.east = Math.max(rectangle.east, cartographic2.longitude);
    result.north = Math.max(rectangle.north, cartographic2.latitude);
    return result;
  };
  Rectangle.contains = function(rectangle, cartographic2) {
    Check_default.typeOf.object("rectangle", rectangle);
    Check_default.typeOf.object("cartographic", cartographic2);
    let longitude = cartographic2.longitude;
    const latitude = cartographic2.latitude;
    const west = rectangle.west;
    let east = rectangle.east;
    if (east < west) {
      east += Math_default.TWO_PI;
      if (longitude < 0) {
        longitude += Math_default.TWO_PI;
      }
    }
    return (longitude > west || Math_default.equalsEpsilon(longitude, west, Math_default.EPSILON14)) && (longitude < east || Math_default.equalsEpsilon(longitude, east, Math_default.EPSILON14)) && latitude >= rectangle.south && latitude <= rectangle.north;
  };
  var subsampleLlaScratch = new Cartographic_default();
  Rectangle.subsample = function(rectangle, ellipsoid, surfaceHeight, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
    surfaceHeight = defaultValue_default(surfaceHeight, 0);
    if (!defined_default(result)) {
      result = [];
    }
    let length3 = 0;
    const north = rectangle.north;
    const south = rectangle.south;
    const east = rectangle.east;
    const west = rectangle.west;
    const lla = subsampleLlaScratch;
    lla.height = surfaceHeight;
    lla.longitude = west;
    lla.latitude = north;
    result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
    length3++;
    lla.longitude = east;
    result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
    length3++;
    lla.latitude = south;
    result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
    length3++;
    lla.longitude = west;
    result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
    length3++;
    if (north < 0) {
      lla.latitude = north;
    } else if (south > 0) {
      lla.latitude = south;
    } else {
      lla.latitude = 0;
    }
    for (let i = 1; i < 8; ++i) {
      lla.longitude = -Math.PI + i * Math_default.PI_OVER_TWO;
      if (Rectangle.contains(rectangle, lla)) {
        result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
        length3++;
      }
    }
    if (lla.latitude === 0) {
      lla.longitude = west;
      result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
      length3++;
      lla.longitude = east;
      result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
      length3++;
    }
    result.length = length3;
    return result;
  };
  Rectangle.subsection = function(rectangle, westLerp, southLerp, eastLerp, northLerp, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    Check_default.typeOf.number.greaterThanOrEquals("westLerp", westLerp, 0);
    Check_default.typeOf.number.lessThanOrEquals("westLerp", westLerp, 1);
    Check_default.typeOf.number.greaterThanOrEquals("southLerp", southLerp, 0);
    Check_default.typeOf.number.lessThanOrEquals("southLerp", southLerp, 1);
    Check_default.typeOf.number.greaterThanOrEquals("eastLerp", eastLerp, 0);
    Check_default.typeOf.number.lessThanOrEquals("eastLerp", eastLerp, 1);
    Check_default.typeOf.number.greaterThanOrEquals("northLerp", northLerp, 0);
    Check_default.typeOf.number.lessThanOrEquals("northLerp", northLerp, 1);
    Check_default.typeOf.number.lessThanOrEquals("westLerp", westLerp, eastLerp);
    Check_default.typeOf.number.lessThanOrEquals("southLerp", southLerp, northLerp);
    if (!defined_default(result)) {
      result = new Rectangle();
    }
    if (rectangle.west <= rectangle.east) {
      const width = rectangle.east - rectangle.west;
      result.west = rectangle.west + westLerp * width;
      result.east = rectangle.west + eastLerp * width;
    } else {
      const width = Math_default.TWO_PI + rectangle.east - rectangle.west;
      result.west = Math_default.negativePiToPi(rectangle.west + westLerp * width);
      result.east = Math_default.negativePiToPi(rectangle.west + eastLerp * width);
    }
    const height = rectangle.north - rectangle.south;
    result.south = rectangle.south + southLerp * height;
    result.north = rectangle.south + northLerp * height;
    if (westLerp === 1) {
      result.west = rectangle.east;
    }
    if (eastLerp === 1) {
      result.east = rectangle.east;
    }
    if (southLerp === 1) {
      result.south = rectangle.north;
    }
    if (northLerp === 1) {
      result.north = rectangle.north;
    }
    return result;
  };
  Rectangle.MAX_VALUE = Object.freeze(
    new Rectangle(
      -Math.PI,
      -Math_default.PI_OVER_TWO,
      Math.PI,
      Math_default.PI_OVER_TWO
    )
  );
  var Rectangle_default = Rectangle;

  // Source/Core/BoundingRectangle.js
  function BoundingRectangle(x, y, width, height) {
    this.x = defaultValue_default(x, 0);
    this.y = defaultValue_default(y, 0);
    this.width = defaultValue_default(width, 0);
    this.height = defaultValue_default(height, 0);
  }
  BoundingRectangle.packedLength = 4;
  BoundingRectangle.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value.x;
    array[startingIndex++] = value.y;
    array[startingIndex++] = value.width;
    array[startingIndex] = value.height;
    return array;
  };
  BoundingRectangle.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new BoundingRectangle();
    }
    result.x = array[startingIndex++];
    result.y = array[startingIndex++];
    result.width = array[startingIndex++];
    result.height = array[startingIndex];
    return result;
  };
  BoundingRectangle.fromPoints = function(positions, result) {
    if (!defined_default(result)) {
      result = new BoundingRectangle();
    }
    if (!defined_default(positions) || positions.length === 0) {
      result.x = 0;
      result.y = 0;
      result.width = 0;
      result.height = 0;
      return result;
    }
    const length3 = positions.length;
    let minimumX = positions[0].x;
    let minimumY = positions[0].y;
    let maximumX = positions[0].x;
    let maximumY = positions[0].y;
    for (let i = 1; i < length3; i++) {
      const p = positions[i];
      const x = p.x;
      const y = p.y;
      minimumX = Math.min(x, minimumX);
      maximumX = Math.max(x, maximumX);
      minimumY = Math.min(y, minimumY);
      maximumY = Math.max(y, maximumY);
    }
    result.x = minimumX;
    result.y = minimumY;
    result.width = maximumX - minimumX;
    result.height = maximumY - minimumY;
    return result;
  };
  var defaultProjection = new GeographicProjection_default();
  var fromRectangleLowerLeft = new Cartographic_default();
  var fromRectangleUpperRight = new Cartographic_default();
  BoundingRectangle.fromRectangle = function(rectangle, projection, result) {
    if (!defined_default(result)) {
      result = new BoundingRectangle();
    }
    if (!defined_default(rectangle)) {
      result.x = 0;
      result.y = 0;
      result.width = 0;
      result.height = 0;
      return result;
    }
    projection = defaultValue_default(projection, defaultProjection);
    const lowerLeft = projection.project(
      Rectangle_default.southwest(rectangle, fromRectangleLowerLeft)
    );
    const upperRight = projection.project(
      Rectangle_default.northeast(rectangle, fromRectangleUpperRight)
    );
    Cartesian2_default.subtract(upperRight, lowerLeft, upperRight);
    result.x = lowerLeft.x;
    result.y = lowerLeft.y;
    result.width = upperRight.x;
    result.height = upperRight.y;
    return result;
  };
  BoundingRectangle.clone = function(rectangle, result) {
    if (!defined_default(rectangle)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new BoundingRectangle(
        rectangle.x,
        rectangle.y,
        rectangle.width,
        rectangle.height
      );
    }
    result.x = rectangle.x;
    result.y = rectangle.y;
    result.width = rectangle.width;
    result.height = rectangle.height;
    return result;
  };
  BoundingRectangle.union = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    if (!defined_default(result)) {
      result = new BoundingRectangle();
    }
    const lowerLeftX = Math.min(left.x, right.x);
    const lowerLeftY = Math.min(left.y, right.y);
    const upperRightX = Math.max(left.x + left.width, right.x + right.width);
    const upperRightY = Math.max(left.y + left.height, right.y + right.height);
    result.x = lowerLeftX;
    result.y = lowerLeftY;
    result.width = upperRightX - lowerLeftX;
    result.height = upperRightY - lowerLeftY;
    return result;
  };
  BoundingRectangle.expand = function(rectangle, point, result) {
    Check_default.typeOf.object("rectangle", rectangle);
    Check_default.typeOf.object("point", point);
    result = BoundingRectangle.clone(rectangle, result);
    const width = point.x - result.x;
    const height = point.y - result.y;
    if (width > result.width) {
      result.width = width;
    } else if (width < 0) {
      result.width -= width;
      result.x = point.x;
    }
    if (height > result.height) {
      result.height = height;
    } else if (height < 0) {
      result.height -= height;
      result.y = point.y;
    }
    return result;
  };
  BoundingRectangle.intersect = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    const leftX = left.x;
    const leftY = left.y;
    const rightX = right.x;
    const rightY = right.y;
    if (!(leftX > rightX + right.width || leftX + left.width < rightX || leftY + left.height < rightY || leftY > rightY + right.height)) {
      return Intersect_default.INTERSECTING;
    }
    return Intersect_default.OUTSIDE;
  };
  BoundingRectangle.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.width === right.width && left.height === right.height;
  };
  BoundingRectangle.prototype.clone = function(result) {
    return BoundingRectangle.clone(this, result);
  };
  BoundingRectangle.prototype.intersect = function(right) {
    return BoundingRectangle.intersect(this, right);
  };
  BoundingRectangle.prototype.equals = function(right) {
    return BoundingRectangle.equals(this, right);
  };
  var BoundingRectangle_default = BoundingRectangle;

  // Source/Core/PrimitiveType.js
  var PrimitiveType = {
    POINTS: WebGLConstants_default.POINTS,
    LINES: WebGLConstants_default.LINES,
    LINE_LOOP: WebGLConstants_default.LINE_LOOP,
    LINE_STRIP: WebGLConstants_default.LINE_STRIP,
    TRIANGLES: WebGLConstants_default.TRIANGLES,
    TRIANGLE_STRIP: WebGLConstants_default.TRIANGLE_STRIP,
    TRIANGLE_FAN: WebGLConstants_default.TRIANGLE_FAN
  };
  PrimitiveType.isLines = function(primitiveType) {
    return primitiveType === PrimitiveType.LINES || primitiveType === PrimitiveType.LINE_LOOP || primitiveType === PrimitiveType.LINE_STRIP;
  };
  PrimitiveType.isTriangles = function(primitiveType) {
    return primitiveType === PrimitiveType.TRIANGLES || primitiveType === PrimitiveType.TRIANGLE_STRIP || primitiveType === PrimitiveType.TRIANGLE_FAN;
  };
  PrimitiveType.validate = function(primitiveType) {
    return primitiveType === PrimitiveType.POINTS || primitiveType === PrimitiveType.LINES || primitiveType === PrimitiveType.LINE_LOOP || primitiveType === PrimitiveType.LINE_STRIP || primitiveType === PrimitiveType.TRIANGLES || primitiveType === PrimitiveType.TRIANGLE_STRIP || primitiveType === PrimitiveType.TRIANGLE_FAN;
  };
  var PrimitiveType_default = Object.freeze(PrimitiveType);

  // Source/Shaders/ViewportQuadVS.js
  var ViewportQuadVS_default = "attribute vec4 position;\nattribute vec2 textureCoordinates;\n\nvarying vec2 v_textureCoordinates;\n\nvoid main() \n{\n    gl_Position = position;\n    v_textureCoordinates = textureCoordinates;\n}\n";

  // Source/Renderer/DrawCommand.js
  var Flags = {
    CULL: 1,
    OCCLUDE: 2,
    EXECUTE_IN_CLOSEST_FRUSTUM: 4,
    DEBUG_SHOW_BOUNDING_VOLUME: 8,
    CAST_SHADOWS: 16,
    RECEIVE_SHADOWS: 32,
    PICK_ONLY: 64,
    DEPTH_FOR_TRANSLUCENT_CLASSIFICATION: 128
  };
  function DrawCommand(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    this._boundingVolume = options.boundingVolume;
    this._orientedBoundingBox = options.orientedBoundingBox;
    this._modelMatrix = options.modelMatrix;
    this._primitiveType = defaultValue_default(
      options.primitiveType,
      PrimitiveType_default.TRIANGLES
    );
    this._vertexArray = options.vertexArray;
    this._count = options.count;
    this._offset = defaultValue_default(options.offset, 0);
    this._instanceCount = defaultValue_default(options.instanceCount, 0);
    this._shaderProgram = options.shaderProgram;
    this._uniformMap = options.uniformMap;
    this._renderState = options.renderState;
    this._framebuffer = options.framebuffer;
    this._pass = options.pass;
    this._owner = options.owner;
    this._debugOverlappingFrustums = 0;
    this._pickId = options.pickId;
    this._flags = 0;
    this.cull = defaultValue_default(options.cull, true);
    this.occlude = defaultValue_default(options.occlude, true);
    this.executeInClosestFrustum = defaultValue_default(
      options.executeInClosestFrustum,
      false
    );
    this.debugShowBoundingVolume = defaultValue_default(
      options.debugShowBoundingVolume,
      false
    );
    this.castShadows = defaultValue_default(options.castShadows, false);
    this.receiveShadows = defaultValue_default(options.receiveShadows, false);
    this.pickOnly = defaultValue_default(options.pickOnly, false);
    this.depthForTranslucentClassification = defaultValue_default(
      options.depthForTranslucentClassification,
      false
    );
    this.dirty = true;
    this.lastDirtyTime = 0;
    this.derivedCommands = {};
  }
  function hasFlag(command, flag) {
    return (command._flags & flag) === flag;
  }
  function setFlag(command, flag, value) {
    if (value) {
      command._flags |= flag;
    } else {
      command._flags &= ~flag;
    }
  }
  Object.defineProperties(DrawCommand.prototype, {
    boundingVolume: {
      get: function() {
        return this._boundingVolume;
      },
      set: function(value) {
        if (this._boundingVolume !== value) {
          this._boundingVolume = value;
          this.dirty = true;
        }
      }
    },
    orientedBoundingBox: {
      get: function() {
        return this._orientedBoundingBox;
      },
      set: function(value) {
        if (this._orientedBoundingBox !== value) {
          this._orientedBoundingBox = value;
          this.dirty = true;
        }
      }
    },
    cull: {
      get: function() {
        return hasFlag(this, Flags.CULL);
      },
      set: function(value) {
        if (hasFlag(this, Flags.CULL) !== value) {
          setFlag(this, Flags.CULL, value);
          this.dirty = true;
        }
      }
    },
    occlude: {
      get: function() {
        return hasFlag(this, Flags.OCCLUDE);
      },
      set: function(value) {
        if (hasFlag(this, Flags.OCCLUDE) !== value) {
          setFlag(this, Flags.OCCLUDE, value);
          this.dirty = true;
        }
      }
    },
    modelMatrix: {
      get: function() {
        return this._modelMatrix;
      },
      set: function(value) {
        if (this._modelMatrix !== value) {
          this._modelMatrix = value;
          this.dirty = true;
        }
      }
    },
    primitiveType: {
      get: function() {
        return this._primitiveType;
      },
      set: function(value) {
        if (this._primitiveType !== value) {
          this._primitiveType = value;
          this.dirty = true;
        }
      }
    },
    vertexArray: {
      get: function() {
        return this._vertexArray;
      },
      set: function(value) {
        if (this._vertexArray !== value) {
          this._vertexArray = value;
          this.dirty = true;
        }
      }
    },
    count: {
      get: function() {
        return this._count;
      },
      set: function(value) {
        if (this._count !== value) {
          this._count = value;
          this.dirty = true;
        }
      }
    },
    offset: {
      get: function() {
        return this._offset;
      },
      set: function(value) {
        if (this._offset !== value) {
          this._offset = value;
          this.dirty = true;
        }
      }
    },
    instanceCount: {
      get: function() {
        return this._instanceCount;
      },
      set: function(value) {
        if (this._instanceCount !== value) {
          this._instanceCount = value;
          this.dirty = true;
        }
      }
    },
    shaderProgram: {
      get: function() {
        return this._shaderProgram;
      },
      set: function(value) {
        if (this._shaderProgram !== value) {
          this._shaderProgram = value;
          this.dirty = true;
        }
      }
    },
    castShadows: {
      get: function() {
        return hasFlag(this, Flags.CAST_SHADOWS);
      },
      set: function(value) {
        if (hasFlag(this, Flags.CAST_SHADOWS) !== value) {
          setFlag(this, Flags.CAST_SHADOWS, value);
          this.dirty = true;
        }
      }
    },
    receiveShadows: {
      get: function() {
        return hasFlag(this, Flags.RECEIVE_SHADOWS);
      },
      set: function(value) {
        if (hasFlag(this, Flags.RECEIVE_SHADOWS) !== value) {
          setFlag(this, Flags.RECEIVE_SHADOWS, value);
          this.dirty = true;
        }
      }
    },
    uniformMap: {
      get: function() {
        return this._uniformMap;
      },
      set: function(value) {
        if (this._uniformMap !== value) {
          this._uniformMap = value;
          this.dirty = true;
        }
      }
    },
    renderState: {
      get: function() {
        return this._renderState;
      },
      set: function(value) {
        if (this._renderState !== value) {
          this._renderState = value;
          this.dirty = true;
        }
      }
    },
    framebuffer: {
      get: function() {
        return this._framebuffer;
      },
      set: function(value) {
        if (this._framebuffer !== value) {
          this._framebuffer = value;
          this.dirty = true;
        }
      }
    },
    pass: {
      get: function() {
        return this._pass;
      },
      set: function(value) {
        if (this._pass !== value) {
          this._pass = value;
          this.dirty = true;
        }
      }
    },
    executeInClosestFrustum: {
      get: function() {
        return hasFlag(this, Flags.EXECUTE_IN_CLOSEST_FRUSTUM);
      },
      set: function(value) {
        if (hasFlag(this, Flags.EXECUTE_IN_CLOSEST_FRUSTUM) !== value) {
          setFlag(this, Flags.EXECUTE_IN_CLOSEST_FRUSTUM, value);
          this.dirty = true;
        }
      }
    },
    owner: {
      get: function() {
        return this._owner;
      },
      set: function(value) {
        if (this._owner !== value) {
          this._owner = value;
          this.dirty = true;
        }
      }
    },
    debugShowBoundingVolume: {
      get: function() {
        return hasFlag(this, Flags.DEBUG_SHOW_BOUNDING_VOLUME);
      },
      set: function(value) {
        if (hasFlag(this, Flags.DEBUG_SHOW_BOUNDING_VOLUME) !== value) {
          setFlag(this, Flags.DEBUG_SHOW_BOUNDING_VOLUME, value);
          this.dirty = true;
        }
      }
    },
    debugOverlappingFrustums: {
      get: function() {
        return this._debugOverlappingFrustums;
      },
      set: function(value) {
        if (this._debugOverlappingFrustums !== value) {
          this._debugOverlappingFrustums = value;
          this.dirty = true;
        }
      }
    },
    pickId: {
      get: function() {
        return this._pickId;
      },
      set: function(value) {
        if (this._pickId !== value) {
          this._pickId = value;
          this.dirty = true;
        }
      }
    },
    pickOnly: {
      get: function() {
        return hasFlag(this, Flags.PICK_ONLY);
      },
      set: function(value) {
        if (hasFlag(this, Flags.PICK_ONLY) !== value) {
          setFlag(this, Flags.PICK_ONLY, value);
          this.dirty = true;
        }
      }
    },
    depthForTranslucentClassification: {
      get: function() {
        return hasFlag(this, Flags.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION);
      },
      set: function(value) {
        if (hasFlag(this, Flags.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION) !== value) {
          setFlag(this, Flags.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION, value);
          this.dirty = true;
        }
      }
    }
  });
  DrawCommand.shallowClone = function(command, result) {
    if (!defined_default(command)) {
      return void 0;
    }
    if (!defined_default(result)) {
      result = new DrawCommand();
    }
    result._boundingVolume = command._boundingVolume;
    result._orientedBoundingBox = command._orientedBoundingBox;
    result._modelMatrix = command._modelMatrix;
    result._primitiveType = command._primitiveType;
    result._vertexArray = command._vertexArray;
    result._count = command._count;
    result._offset = command._offset;
    result._instanceCount = command._instanceCount;
    result._shaderProgram = command._shaderProgram;
    result._uniformMap = command._uniformMap;
    result._renderState = command._renderState;
    result._framebuffer = command._framebuffer;
    result._pass = command._pass;
    result._owner = command._owner;
    result._debugOverlappingFrustums = command._debugOverlappingFrustums;
    result._pickId = command._pickId;
    result._flags = command._flags;
    result.dirty = true;
    result.lastDirtyTime = 0;
    return result;
  };
  DrawCommand.prototype.execute = function(context, passState) {
    context.draw(this, passState);
  };
  var DrawCommand_default = DrawCommand;

  // Source/Renderer/PixelDatatype.js
  var PixelDatatype = {
    UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
    UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
    UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT,
    FLOAT: WebGLConstants_default.FLOAT,
    HALF_FLOAT: WebGLConstants_default.HALF_FLOAT_OES,
    UNSIGNED_INT_24_8: WebGLConstants_default.UNSIGNED_INT_24_8,
    UNSIGNED_SHORT_4_4_4_4: WebGLConstants_default.UNSIGNED_SHORT_4_4_4_4,
    UNSIGNED_SHORT_5_5_5_1: WebGLConstants_default.UNSIGNED_SHORT_5_5_5_1,
    UNSIGNED_SHORT_5_6_5: WebGLConstants_default.UNSIGNED_SHORT_5_6_5
  };
  PixelDatatype.toWebGLConstant = function(pixelDatatype, context) {
    switch (pixelDatatype) {
      case PixelDatatype.UNSIGNED_BYTE:
        return WebGLConstants_default.UNSIGNED_BYTE;
      case PixelDatatype.UNSIGNED_SHORT:
        return WebGLConstants_default.UNSIGNED_SHORT;
      case PixelDatatype.UNSIGNED_INT:
        return WebGLConstants_default.UNSIGNED_INT;
      case PixelDatatype.FLOAT:
        return WebGLConstants_default.FLOAT;
      case PixelDatatype.HALF_FLOAT:
        return context.webgl2 ? WebGLConstants_default.HALF_FLOAT : WebGLConstants_default.HALF_FLOAT_OES;
      case PixelDatatype.UNSIGNED_INT_24_8:
        return WebGLConstants_default.UNSIGNED_INT_24_8;
      case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:
        return WebGLConstants_default.UNSIGNED_SHORT_4_4_4_4;
      case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:
        return WebGLConstants_default.UNSIGNED_SHORT_5_5_5_1;
      case PixelDatatype.UNSIGNED_SHORT_5_6_5:
        return PixelDatatype.UNSIGNED_SHORT_5_6_5;
    }
  };
  PixelDatatype.isPacked = function(pixelDatatype) {
    return pixelDatatype === PixelDatatype.UNSIGNED_INT_24_8 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_4_4_4_4 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_5_5_5_1 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_5_6_5;
  };
  PixelDatatype.sizeInBytes = function(pixelDatatype) {
    switch (pixelDatatype) {
      case PixelDatatype.UNSIGNED_BYTE:
        return 1;
      case PixelDatatype.UNSIGNED_SHORT:
      case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:
      case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:
      case PixelDatatype.UNSIGNED_SHORT_5_6_5:
      case PixelDatatype.HALF_FLOAT:
        return 2;
      case PixelDatatype.UNSIGNED_INT:
      case PixelDatatype.FLOAT:
      case PixelDatatype.UNSIGNED_INT_24_8:
        return 4;
    }
  };
  PixelDatatype.validate = function(pixelDatatype) {
    return pixelDatatype === PixelDatatype.UNSIGNED_BYTE || pixelDatatype === PixelDatatype.UNSIGNED_SHORT || pixelDatatype === PixelDatatype.UNSIGNED_INT || pixelDatatype === PixelDatatype.FLOAT || pixelDatatype === PixelDatatype.HALF_FLOAT || pixelDatatype === PixelDatatype.UNSIGNED_INT_24_8 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_4_4_4_4 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_5_5_5_1 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_5_6_5;
  };
  var PixelDatatype_default = Object.freeze(PixelDatatype);

  // Source/Core/PixelFormat.js
  var PixelFormat = {
    DEPTH_COMPONENT: WebGLConstants_default.DEPTH_COMPONENT,
    DEPTH_STENCIL: WebGLConstants_default.DEPTH_STENCIL,
    ALPHA: WebGLConstants_default.ALPHA,
    RGB: WebGLConstants_default.RGB,
    RGBA: WebGLConstants_default.RGBA,
    LUMINANCE: WebGLConstants_default.LUMINANCE,
    LUMINANCE_ALPHA: WebGLConstants_default.LUMINANCE_ALPHA,
    RGB_DXT1: WebGLConstants_default.COMPRESSED_RGB_S3TC_DXT1_EXT,
    RGBA_DXT1: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT1_EXT,
    RGBA_DXT3: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT3_EXT,
    RGBA_DXT5: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT5_EXT,
    RGB_PVRTC_4BPPV1: WebGLConstants_default.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,
    RGB_PVRTC_2BPPV1: WebGLConstants_default.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,
    RGBA_PVRTC_4BPPV1: WebGLConstants_default.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,
    RGBA_PVRTC_2BPPV1: WebGLConstants_default.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,
    RGBA_ASTC: WebGLConstants_default.COMPRESSED_RGBA_ASTC_4x4_WEBGL,
    RGB_ETC1: WebGLConstants_default.COMPRESSED_RGB_ETC1_WEBGL,
    RGB8_ETC2: WebGLConstants_default.COMPRESSED_RGB8_ETC2,
    RGBA8_ETC2_EAC: WebGLConstants_default.COMPRESSED_RGBA8_ETC2_EAC,
    RGBA_BC7: WebGLConstants_default.COMPRESSED_RGBA_BPTC_UNORM
  };
  PixelFormat.componentsLength = function(pixelFormat) {
    switch (pixelFormat) {
      case PixelFormat.RGB:
        return 3;
      case PixelFormat.RGBA:
        return 4;
      case PixelFormat.LUMINANCE_ALPHA:
        return 2;
      case PixelFormat.ALPHA:
      case PixelFormat.LUMINANCE:
        return 1;
      default:
        return 1;
    }
  };
  PixelFormat.validate = function(pixelFormat) {
    return pixelFormat === PixelFormat.DEPTH_COMPONENT || pixelFormat === PixelFormat.DEPTH_STENCIL || pixelFormat === PixelFormat.ALPHA || pixelFormat === PixelFormat.RGB || pixelFormat === PixelFormat.RGBA || pixelFormat === PixelFormat.LUMINANCE || pixelFormat === PixelFormat.LUMINANCE_ALPHA || pixelFormat === PixelFormat.RGB_DXT1 || pixelFormat === PixelFormat.RGBA_DXT1 || pixelFormat === PixelFormat.RGBA_DXT3 || pixelFormat === PixelFormat.RGBA_DXT5 || pixelFormat === PixelFormat.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_ASTC || pixelFormat === PixelFormat.RGB_ETC1 || pixelFormat === PixelFormat.RGB8_ETC2 || pixelFormat === PixelFormat.RGBA8_ETC2_EAC || pixelFormat === PixelFormat.RGBA_BC7;
  };
  PixelFormat.isColorFormat = function(pixelFormat) {
    return pixelFormat === PixelFormat.ALPHA || pixelFormat === PixelFormat.RGB || pixelFormat === PixelFormat.RGBA || pixelFormat === PixelFormat.LUMINANCE || pixelFormat === PixelFormat.LUMINANCE_ALPHA;
  };
  PixelFormat.isDepthFormat = function(pixelFormat) {
    return pixelFormat === PixelFormat.DEPTH_COMPONENT || pixelFormat === PixelFormat.DEPTH_STENCIL;
  };
  PixelFormat.isCompressedFormat = function(pixelFormat) {
    return pixelFormat === PixelFormat.RGB_DXT1 || pixelFormat === PixelFormat.RGBA_DXT1 || pixelFormat === PixelFormat.RGBA_DXT3 || pixelFormat === PixelFormat.RGBA_DXT5 || pixelFormat === PixelFormat.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_ASTC || pixelFormat === PixelFormat.RGB_ETC1 || pixelFormat === PixelFormat.RGB8_ETC2 || pixelFormat === PixelFormat.RGBA8_ETC2_EAC || pixelFormat === PixelFormat.RGBA_BC7;
  };
  PixelFormat.isDXTFormat = function(pixelFormat) {
    return pixelFormat === PixelFormat.RGB_DXT1 || pixelFormat === PixelFormat.RGBA_DXT1 || pixelFormat === PixelFormat.RGBA_DXT3 || pixelFormat === PixelFormat.RGBA_DXT5;
  };
  PixelFormat.isPVRTCFormat = function(pixelFormat) {
    return pixelFormat === PixelFormat.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_2BPPV1;
  };
  PixelFormat.isASTCFormat = function(pixelFormat) {
    return pixelFormat === PixelFormat.RGBA_ASTC;
  };
  PixelFormat.isETC1Format = function(pixelFormat) {
    return pixelFormat === PixelFormat.RGB_ETC1;
  };
  PixelFormat.isETC2Format = function(pixelFormat) {
    return pixelFormat === PixelFormat.RGB8_ETC2 || pixelFormat === PixelFormat.RGBA8_ETC2_EAC;
  };
  PixelFormat.isBC7Format = function(pixelFormat) {
    return pixelFormat === PixelFormat.RGBA_BC7;
  };
  PixelFormat.compressedTextureSizeInBytes = function(pixelFormat, width, height) {
    switch (pixelFormat) {
      case PixelFormat.RGB_DXT1:
      case PixelFormat.RGBA_DXT1:
      case PixelFormat.RGB_ETC1:
      case PixelFormat.RGB8_ETC2:
        return Math.floor((width + 3) / 4) * Math.floor((height + 3) / 4) * 8;
      case PixelFormat.RGBA_DXT3:
      case PixelFormat.RGBA_DXT5:
      case PixelFormat.RGBA_ASTC:
      case PixelFormat.RGBA8_ETC2_EAC:
        return Math.floor((width + 3) / 4) * Math.floor((height + 3) / 4) * 16;
      case PixelFormat.RGB_PVRTC_4BPPV1:
      case PixelFormat.RGBA_PVRTC_4BPPV1:
        return Math.floor((Math.max(width, 8) * Math.max(height, 8) * 4 + 7) / 8);
      case PixelFormat.RGB_PVRTC_2BPPV1:
      case PixelFormat.RGBA_PVRTC_2BPPV1:
        return Math.floor(
          (Math.max(width, 16) * Math.max(height, 8) * 2 + 7) / 8
        );
      case PixelFormat.RGBA_BC7:
        return Math.ceil(width / 4) * Math.ceil(height / 4) * 16;
      default:
        return 0;
    }
  };
  PixelFormat.textureSizeInBytes = function(pixelFormat, pixelDatatype, width, height) {
    let componentsLength = PixelFormat.componentsLength(pixelFormat);
    if (PixelDatatype_default.isPacked(pixelDatatype)) {
      componentsLength = 1;
    }
    return componentsLength * PixelDatatype_default.sizeInBytes(pixelDatatype) * width * height;
  };
  PixelFormat.alignmentInBytes = function(pixelFormat, pixelDatatype, width) {
    const mod2 = PixelFormat.textureSizeInBytes(pixelFormat, pixelDatatype, width, 1) % 4;
    return mod2 === 0 ? 4 : mod2 === 2 ? 2 : 1;
  };
  PixelFormat.createTypedArray = function(pixelFormat, pixelDatatype, width, height) {
    let constructor;
    const sizeInBytes = PixelDatatype_default.sizeInBytes(pixelDatatype);
    if (sizeInBytes === Uint8Array.BYTES_PER_ELEMENT) {
      constructor = Uint8Array;
    } else if (sizeInBytes === Uint16Array.BYTES_PER_ELEMENT) {
      constructor = Uint16Array;
    } else if (sizeInBytes === Float32Array.BYTES_PER_ELEMENT && pixelDatatype === PixelDatatype_default.FLOAT) {
      constructor = Float32Array;
    } else {
      constructor = Uint32Array;
    }
    const size = PixelFormat.componentsLength(pixelFormat) * width * height;
    return new constructor(size);
  };
  PixelFormat.flipY = function(bufferView, pixelFormat, pixelDatatype, width, height) {
    if (height === 1) {
      return bufferView;
    }
    const flipped = PixelFormat.createTypedArray(
      pixelFormat,
      pixelDatatype,
      width,
      height
    );
    const numberOfComponents = PixelFormat.componentsLength(pixelFormat);
    const textureWidth = width * numberOfComponents;
    for (let i = 0; i < height; ++i) {
      const row = i * width * numberOfComponents;
      const flippedRow = (height - i - 1) * width * numberOfComponents;
      for (let j = 0; j < textureWidth; ++j) {
        flipped[flippedRow + j] = bufferView[row + j];
      }
    }
    return flipped;
  };
  PixelFormat.toInternalFormat = function(pixelFormat, pixelDatatype, context) {
    if (!context.webgl2) {
      return pixelFormat;
    }
    if (pixelFormat === PixelFormat.DEPTH_STENCIL) {
      return WebGLConstants_default.DEPTH24_STENCIL8;
    }
    if (pixelFormat === PixelFormat.DEPTH_COMPONENT) {
      if (pixelDatatype === PixelDatatype_default.UNSIGNED_SHORT) {
        return WebGLConstants_default.DEPTH_COMPONENT16;
      } else if (pixelDatatype === PixelDatatype_default.UNSIGNED_INT) {
        return WebGLConstants_default.DEPTH_COMPONENT24;
      }
    }
    if (pixelDatatype === PixelDatatype_default.FLOAT) {
      switch (pixelFormat) {
        case PixelFormat.RGBA:
          return WebGLConstants_default.RGBA32F;
        case PixelFormat.RGB:
          return WebGLConstants_default.RGB32F;
        case PixelFormat.RG:
          return WebGLConstants_default.RG32F;
        case PixelFormat.R:
          return WebGLConstants_default.R32F;
      }
    }
    if (pixelDatatype === PixelDatatype_default.HALF_FLOAT) {
      switch (pixelFormat) {
        case PixelFormat.RGBA:
          return WebGLConstants_default.RGBA16F;
        case PixelFormat.RGB:
          return WebGLConstants_default.RGB16F;
        case PixelFormat.RG:
          return WebGLConstants_default.RG16F;
        case PixelFormat.R:
          return WebGLConstants_default.R16F;
      }
    }
    return pixelFormat;
  };
  var PixelFormat_default = Object.freeze(PixelFormat);

  // Source/Renderer/ContextLimits.js
  var ContextLimits = {
    _maximumCombinedTextureImageUnits: 0,
    _maximumCubeMapSize: 0,
    _maximumFragmentUniformVectors: 0,
    _maximumTextureImageUnits: 0,
    _maximumRenderbufferSize: 0,
    _maximumTextureSize: 0,
    _maximumVaryingVectors: 0,
    _maximumVertexAttributes: 0,
    _maximumVertexTextureImageUnits: 0,
    _maximumVertexUniformVectors: 0,
    _minimumAliasedLineWidth: 0,
    _maximumAliasedLineWidth: 0,
    _minimumAliasedPointSize: 0,
    _maximumAliasedPointSize: 0,
    _maximumViewportWidth: 0,
    _maximumViewportHeight: 0,
    _maximumTextureFilterAnisotropy: 0,
    _maximumDrawBuffers: 0,
    _maximumColorAttachments: 0,
    _maximumSamples: 0,
    _highpFloatSupported: false,
    _highpIntSupported: false
  };
  Object.defineProperties(ContextLimits, {
    maximumCombinedTextureImageUnits: {
      get: function() {
        return ContextLimits._maximumCombinedTextureImageUnits;
      }
    },
    maximumCubeMapSize: {
      get: function() {
        return ContextLimits._maximumCubeMapSize;
      }
    },
    maximumFragmentUniformVectors: {
      get: function() {
        return ContextLimits._maximumFragmentUniformVectors;
      }
    },
    maximumTextureImageUnits: {
      get: function() {
        return ContextLimits._maximumTextureImageUnits;
      }
    },
    maximumRenderbufferSize: {
      get: function() {
        return ContextLimits._maximumRenderbufferSize;
      }
    },
    maximumTextureSize: {
      get: function() {
        return ContextLimits._maximumTextureSize;
      }
    },
    maximumVaryingVectors: {
      get: function() {
        return ContextLimits._maximumVaryingVectors;
      }
    },
    maximumVertexAttributes: {
      get: function() {
        return ContextLimits._maximumVertexAttributes;
      }
    },
    maximumVertexTextureImageUnits: {
      get: function() {
        return ContextLimits._maximumVertexTextureImageUnits;
      }
    },
    maximumVertexUniformVectors: {
      get: function() {
        return ContextLimits._maximumVertexUniformVectors;
      }
    },
    minimumAliasedLineWidth: {
      get: function() {
        return ContextLimits._minimumAliasedLineWidth;
      }
    },
    maximumAliasedLineWidth: {
      get: function() {
        return ContextLimits._maximumAliasedLineWidth;
      }
    },
    minimumAliasedPointSize: {
      get: function() {
        return ContextLimits._minimumAliasedPointSize;
      }
    },
    maximumAliasedPointSize: {
      get: function() {
        return ContextLimits._maximumAliasedPointSize;
      }
    },
    maximumViewportWidth: {
      get: function() {
        return ContextLimits._maximumViewportWidth;
      }
    },
    maximumViewportHeight: {
      get: function() {
        return ContextLimits._maximumViewportHeight;
      }
    },
    maximumTextureFilterAnisotropy: {
      get: function() {
        return ContextLimits._maximumTextureFilterAnisotropy;
      }
    },
    maximumDrawBuffers: {
      get: function() {
        return ContextLimits._maximumDrawBuffers;
      }
    },
    maximumColorAttachments: {
      get: function() {
        return ContextLimits._maximumColorAttachments;
      }
    },
    maximumSamples: {
      get: function() {
        return ContextLimits._maximumSamples;
      }
    },
    highpFloatSupported: {
      get: function() {
        return ContextLimits._highpFloatSupported;
      }
    },
    highpIntSupported: {
      get: function() {
        return ContextLimits._highpIntSupported;
      }
    }
  });
  var ContextLimits_default = ContextLimits;

  // Source/Renderer/Framebuffer.js
  function attachTexture(framebuffer, attachment, texture) {
    const gl = framebuffer._gl;
    gl.framebufferTexture2D(
      gl.FRAMEBUFFER,
      attachment,
      texture._target,
      texture._texture,
      0
    );
  }
  function attachRenderbuffer(framebuffer, attachment, renderbuffer) {
    const gl = framebuffer._gl;
    gl.framebufferRenderbuffer(
      gl.FRAMEBUFFER,
      attachment,
      gl.RENDERBUFFER,
      renderbuffer._getRenderbuffer()
    );
  }
  function Framebuffer(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    const context = options.context;
    Check_default.defined("options.context", context);
    const gl = context._gl;
    const maximumColorAttachments = ContextLimits_default.maximumColorAttachments;
    this._gl = gl;
    this._framebuffer = gl.createFramebuffer();
    this._colorTextures = [];
    this._colorRenderbuffers = [];
    this._activeColorAttachments = [];
    this._depthTexture = void 0;
    this._depthRenderbuffer = void 0;
    this._stencilRenderbuffer = void 0;
    this._depthStencilTexture = void 0;
    this._depthStencilRenderbuffer = void 0;
    this.destroyAttachments = defaultValue_default(options.destroyAttachments, true);
    if (defined_default(options.colorTextures) && defined_default(options.colorRenderbuffers)) {
      throw new DeveloperError_default(
        "Cannot have both color texture and color renderbuffer attachments."
      );
    }
    if (defined_default(options.depthTexture) && defined_default(options.depthRenderbuffer)) {
      throw new DeveloperError_default(
        "Cannot have both a depth texture and depth renderbuffer attachment."
      );
    }
    if (defined_default(options.depthStencilTexture) && defined_default(options.depthStencilRenderbuffer)) {
      throw new DeveloperError_default(
        "Cannot have both a depth-stencil texture and depth-stencil renderbuffer attachment."
      );
    }
    const depthAttachment = defined_default(options.depthTexture) || defined_default(options.depthRenderbuffer);
    const depthStencilAttachment = defined_default(options.depthStencilTexture) || defined_default(options.depthStencilRenderbuffer);
    if (depthAttachment && depthStencilAttachment) {
      throw new DeveloperError_default(
        "Cannot have both a depth and depth-stencil attachment."
      );
    }
    if (defined_default(options.stencilRenderbuffer) && depthStencilAttachment) {
      throw new DeveloperError_default(
        "Cannot have both a stencil and depth-stencil attachment."
      );
    }
    if (depthAttachment && defined_default(options.stencilRenderbuffer)) {
      throw new DeveloperError_default(
        "Cannot have both a depth and stencil attachment."
      );
    }
    this._bind();
    let texture;
    let renderbuffer;
    let i;
    let length3;
    let attachmentEnum;
    if (defined_default(options.colorTextures)) {
      const textures = options.colorTextures;
      length3 = this._colorTextures.length = this._activeColorAttachments.length = textures.length;
      if (length3 > maximumColorAttachments) {
        throw new DeveloperError_default(
          "The number of color attachments exceeds the number supported."
        );
      }
      for (i = 0; i < length3; ++i) {
        texture = textures[i];
        if (!PixelFormat_default.isColorFormat(texture.pixelFormat)) {
          throw new DeveloperError_default(
            "The color-texture pixel-format must be a color format."
          );
        }
        if (texture.pixelDatatype === PixelDatatype_default.FLOAT && !context.colorBufferFloat) {
          throw new DeveloperError_default(
            "The color texture pixel datatype is FLOAT and the WebGL implementation does not support the EXT_color_buffer_float or WEBGL_color_buffer_float extensions. See Context.colorBufferFloat."
          );
        }
        if (texture.pixelDatatype === PixelDatatype_default.HALF_FLOAT && !context.colorBufferHalfFloat) {
          throw new DeveloperError_default(
            "The color texture pixel datatype is HALF_FLOAT and the WebGL implementation does not support the EXT_color_buffer_half_float extension. See Context.colorBufferHalfFloat."
          );
        }
        attachmentEnum = this._gl.COLOR_ATTACHMENT0 + i;
        attachTexture(this, attachmentEnum, texture);
        this._activeColorAttachments[i] = attachmentEnum;
        this._colorTextures[i] = texture;
      }
    }
    if (defined_default(options.colorRenderbuffers)) {
      const renderbuffers = options.colorRenderbuffers;
      length3 = this._colorRenderbuffers.length = this._activeColorAttachments.length = renderbuffers.length;
      if (length3 > maximumColorAttachments) {
        throw new DeveloperError_default(
          "The number of color attachments exceeds the number supported."
        );
      }
      for (i = 0; i < length3; ++i) {
        renderbuffer = renderbuffers[i];
        attachmentEnum = this._gl.COLOR_ATTACHMENT0 + i;
        attachRenderbuffer(this, attachmentEnum, renderbuffer);
        this._activeColorAttachments[i] = attachmentEnum;
        this._colorRenderbuffers[i] = renderbuffer;
      }
    }
    if (defined_default(options.depthTexture)) {
      texture = options.depthTexture;
      if (texture.pixelFormat !== PixelFormat_default.DEPTH_COMPONENT) {
        throw new DeveloperError_default(
          "The depth-texture pixel-format must be DEPTH_COMPONENT."
        );
      }
      attachTexture(this, this._gl.DEPTH_ATTACHMENT, texture);
      this._depthTexture = texture;
    }
    if (defined_default(options.depthRenderbuffer)) {
      renderbuffer = options.depthRenderbuffer;
      attachRenderbuffer(this, this._gl.DEPTH_ATTACHMENT, renderbuffer);
      this._depthRenderbuffer = renderbuffer;
    }
    if (defined_default(options.stencilRenderbuffer)) {
      renderbuffer = options.stencilRenderbuffer;
      attachRenderbuffer(this, this._gl.STENCIL_ATTACHMENT, renderbuffer);
      this._stencilRenderbuffer = renderbuffer;
    }
    if (defined_default(options.depthStencilTexture)) {
      texture = options.depthStencilTexture;
      if (texture.pixelFormat !== PixelFormat_default.DEPTH_STENCIL) {
        throw new DeveloperError_default(
          "The depth-stencil pixel-format must be DEPTH_STENCIL."
        );
      }
      attachTexture(this, this._gl.DEPTH_STENCIL_ATTACHMENT, texture);
      this._depthStencilTexture = texture;
    }
    if (defined_default(options.depthStencilRenderbuffer)) {
      renderbuffer = options.depthStencilRenderbuffer;
      attachRenderbuffer(this, this._gl.DEPTH_STENCIL_ATTACHMENT, renderbuffer);
      this._depthStencilRenderbuffer = renderbuffer;
    }
    this._unBind();
  }
  Object.defineProperties(Framebuffer.prototype, {
    status: {
      get: function() {
        this._bind();
        const status = this._gl.checkFramebufferStatus(this._gl.FRAMEBUFFER);
        this._unBind();
        return status;
      }
    },
    numberOfColorAttachments: {
      get: function() {
        return this._activeColorAttachments.length;
      }
    },
    depthTexture: {
      get: function() {
        return this._depthTexture;
      }
    },
    depthRenderbuffer: {
      get: function() {
        return this._depthRenderbuffer;
      }
    },
    stencilRenderbuffer: {
      get: function() {
        return this._stencilRenderbuffer;
      }
    },
    depthStencilTexture: {
      get: function() {
        return this._depthStencilTexture;
      }
    },
    depthStencilRenderbuffer: {
      get: function() {
        return this._depthStencilRenderbuffer;
      }
    },
    hasDepthAttachment: {
      get: function() {
        return !!(this.depthTexture || this.depthRenderbuffer || this.depthStencilTexture || this.depthStencilRenderbuffer);
      }
    }
  });
  Framebuffer.prototype._bind = function() {
    const gl = this._gl;
    gl.bindFramebuffer(gl.FRAMEBUFFER, this._framebuffer);
  };
  Framebuffer.prototype._unBind = function() {
    const gl = this._gl;
    gl.bindFramebuffer(gl.FRAMEBUFFER, null);
  };
  Framebuffer.prototype.bindDraw = function() {
    const gl = this._gl;
    gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, this._framebuffer);
  };
  Framebuffer.prototype.bindRead = function() {
    const gl = this._gl;
    gl.bindFramebuffer(gl.READ_FRAMEBUFFER, this._framebuffer);
  };
  Framebuffer.prototype._getActiveColorAttachments = function() {
    return this._activeColorAttachments;
  };
  Framebuffer.prototype.getColorTexture = function(index) {
    if (!defined_default(index) || index < 0 || index >= this._colorTextures.length) {
      throw new DeveloperError_default(
        "index is required, must be greater than or equal to zero and must be less than the number of color attachments."
      );
    }
    return this._colorTextures[index];
  };
  Framebuffer.prototype.getColorRenderbuffer = function(index) {
    if (!defined_default(index) || index < 0 || index >= this._colorRenderbuffers.length) {
      throw new DeveloperError_default(
        "index is required, must be greater than or equal to zero and must be less than the number of color attachments."
      );
    }
    return this._colorRenderbuffers[index];
  };
  Framebuffer.prototype.isDestroyed = function() {
    return false;
  };
  Framebuffer.prototype.destroy = function() {
    if (this.destroyAttachments) {
      let i = 0;
      const textures = this._colorTextures;
      let length3 = textures.length;
      for (; i < length3; ++i) {
        const texture = textures[i];
        if (defined_default(texture)) {
          texture.destroy();
        }
      }
      const renderbuffers = this._colorRenderbuffers;
      length3 = renderbuffers.length;
      for (i = 0; i < length3; ++i) {
        const renderbuffer = renderbuffers[i];
        if (defined_default(renderbuffer)) {
          renderbuffer.destroy();
        }
      }
      this._depthTexture = this._depthTexture && this._depthTexture.destroy();
      this._depthRenderbuffer = this._depthRenderbuffer && this._depthRenderbuffer.destroy();
      this._stencilRenderbuffer = this._stencilRenderbuffer && this._stencilRenderbuffer.destroy();
      this._depthStencilTexture = this._depthStencilTexture && this._depthStencilTexture.destroy();
      this._depthStencilRenderbuffer = this._depthStencilRenderbuffer && this._depthStencilRenderbuffer.destroy();
    }
    this._gl.deleteFramebuffer(this._framebuffer);
    return destroyObject_default(this);
  };
  var Framebuffer_default = Framebuffer;

  // Source/Core/WindingOrder.js
  var WindingOrder = {
    CLOCKWISE: WebGLConstants_default.CW,
    COUNTER_CLOCKWISE: WebGLConstants_default.CCW
  };
  WindingOrder.validate = function(windingOrder) {
    return windingOrder === WindingOrder.CLOCKWISE || windingOrder === WindingOrder.COUNTER_CLOCKWISE;
  };
  var WindingOrder_default = Object.freeze(WindingOrder);

  // Source/Renderer/freezeRenderState.js
  function freezeRenderState(renderState) {
    if (typeof renderState !== "object" || renderState === null) {
      return renderState;
    }
    let propName;
    const propNames = Object.keys(renderState);
    for (let i = 0; i < propNames.length; i++) {
      propName = propNames[i];
      if (renderState.hasOwnProperty(propName) && propName !== "_applyFunctions") {
        renderState[propName] = freezeRenderState(renderState[propName]);
      }
    }
    return Object.freeze(renderState);
  }
  var freezeRenderState_default = freezeRenderState;

  // Source/Renderer/RenderState.js
  function validateBlendEquation(blendEquation) {
    return blendEquation === WebGLConstants_default.FUNC_ADD || blendEquation === WebGLConstants_default.FUNC_SUBTRACT || blendEquation === WebGLConstants_default.FUNC_REVERSE_SUBTRACT || blendEquation === WebGLConstants_default.MIN || blendEquation === WebGLConstants_default.MAX;
  }
  function validateBlendFunction(blendFunction) {
    return blendFunction === WebGLConstants_default.ZERO || blendFunction === WebGLConstants_default.ONE || blendFunction === WebGLConstants_default.SRC_COLOR || blendFunction === WebGLConstants_default.ONE_MINUS_SRC_COLOR || blendFunction === WebGLConstants_default.DST_COLOR || blendFunction === WebGLConstants_default.ONE_MINUS_DST_COLOR || blendFunction === WebGLConstants_default.SRC_ALPHA || blendFunction === WebGLConstants_default.ONE_MINUS_SRC_ALPHA || blendFunction === WebGLConstants_default.DST_ALPHA || blendFunction === WebGLConstants_default.ONE_MINUS_DST_ALPHA || blendFunction === WebGLConstants_default.CONSTANT_COLOR || blendFunction === WebGLConstants_default.ONE_MINUS_CONSTANT_COLOR || blendFunction === WebGLConstants_default.CONSTANT_ALPHA || blendFunction === WebGLConstants_default.ONE_MINUS_CONSTANT_ALPHA || blendFunction === WebGLConstants_default.SRC_ALPHA_SATURATE;
  }
  function validateCullFace(cullFace) {
    return cullFace === WebGLConstants_default.FRONT || cullFace === WebGLConstants_default.BACK || cullFace === WebGLConstants_default.FRONT_AND_BACK;
  }
  function validateDepthFunction(depthFunction) {
    return depthFunction === WebGLConstants_default.NEVER || depthFunction === WebGLConstants_default.LESS || depthFunction === WebGLConstants_default.EQUAL || depthFunction === WebGLConstants_default.LEQUAL || depthFunction === WebGLConstants_default.GREATER || depthFunction === WebGLConstants_default.NOTEQUAL || depthFunction === WebGLConstants_default.GEQUAL || depthFunction === WebGLConstants_default.ALWAYS;
  }
  function validateStencilFunction(stencilFunction) {
    return stencilFunction === WebGLConstants_default.NEVER || stencilFunction === WebGLConstants_default.LESS || stencilFunction === WebGLConstants_default.EQUAL || stencilFunction === WebGLConstants_default.LEQUAL || stencilFunction === WebGLConstants_default.GREATER || stencilFunction === WebGLConstants_default.NOTEQUAL || stencilFunction === WebGLConstants_default.GEQUAL || stencilFunction === WebGLConstants_default.ALWAYS;
  }
  function validateStencilOperation(stencilOperation) {
    return stencilOperation === WebGLConstants_default.ZERO || stencilOperation === WebGLConstants_default.KEEP || stencilOperation === WebGLConstants_default.REPLACE || stencilOperation === WebGLConstants_default.INCR || stencilOperation === WebGLConstants_default.DECR || stencilOperation === WebGLConstants_default.INVERT || stencilOperation === WebGLConstants_default.INCR_WRAP || stencilOperation === WebGLConstants_default.DECR_WRAP;
  }
  function RenderState(renderState) {
    const rs = defaultValue_default(renderState, defaultValue_default.EMPTY_OBJECT);
    const cull = defaultValue_default(rs.cull, defaultValue_default.EMPTY_OBJECT);
    const polygonOffset = defaultValue_default(
      rs.polygonOffset,
      defaultValue_default.EMPTY_OBJECT
    );
    const scissorTest = defaultValue_default(rs.scissorTest, defaultValue_default.EMPTY_OBJECT);
    const scissorTestRectangle = defaultValue_default(
      scissorTest.rectangle,
      defaultValue_default.EMPTY_OBJECT
    );
    const depthRange = defaultValue_default(rs.depthRange, defaultValue_default.EMPTY_OBJECT);
    const depthTest = defaultValue_default(rs.depthTest, defaultValue_default.EMPTY_OBJECT);
    const colorMask = defaultValue_default(rs.colorMask, defaultValue_default.EMPTY_OBJECT);
    const blending = defaultValue_default(rs.blending, defaultValue_default.EMPTY_OBJECT);
    const blendingColor = defaultValue_default(blending.color, defaultValue_default.EMPTY_OBJECT);
    const stencilTest = defaultValue_default(rs.stencilTest, defaultValue_default.EMPTY_OBJECT);
    const stencilTestFrontOperation = defaultValue_default(
      stencilTest.frontOperation,
      defaultValue_default.EMPTY_OBJECT
    );
    const stencilTestBackOperation = defaultValue_default(
      stencilTest.backOperation,
      defaultValue_default.EMPTY_OBJECT
    );
    const sampleCoverage = defaultValue_default(
      rs.sampleCoverage,
      defaultValue_default.EMPTY_OBJECT
    );
    const viewport = rs.viewport;
    this.frontFace = defaultValue_default(rs.frontFace, WindingOrder_default.COUNTER_CLOCKWISE);
    this.cull = {
      enabled: defaultValue_default(cull.enabled, false),
      face: defaultValue_default(cull.face, WebGLConstants_default.BACK)
    };
    this.lineWidth = defaultValue_default(rs.lineWidth, 1);
    this.polygonOffset = {
      enabled: defaultValue_default(polygonOffset.enabled, false),
      factor: defaultValue_default(polygonOffset.factor, 0),
      units: defaultValue_default(polygonOffset.units, 0)
    };
    this.scissorTest = {
      enabled: defaultValue_default(scissorTest.enabled, false),
      rectangle: BoundingRectangle_default.clone(scissorTestRectangle)
    };
    this.depthRange = {
      near: defaultValue_default(depthRange.near, 0),
      far: defaultValue_default(depthRange.far, 1)
    };
    this.depthTest = {
      enabled: defaultValue_default(depthTest.enabled, false),
      func: defaultValue_default(depthTest.func, WebGLConstants_default.LESS)
    };
    this.colorMask = {
      red: defaultValue_default(colorMask.red, true),
      green: defaultValue_default(colorMask.green, true),
      blue: defaultValue_default(colorMask.blue, true),
      alpha: defaultValue_default(colorMask.alpha, true)
    };
    this.depthMask = defaultValue_default(rs.depthMask, true);
    this.stencilMask = defaultValue_default(rs.stencilMask, ~0);
    this.blending = {
      enabled: defaultValue_default(blending.enabled, false),
      color: new Color_default(
        defaultValue_default(blendingColor.red, 0),
        defaultValue_default(blendingColor.green, 0),
        defaultValue_default(blendingColor.blue, 0),
        defaultValue_default(blendingColor.alpha, 0)
      ),
      equationRgb: defaultValue_default(blending.equationRgb, WebGLConstants_default.FUNC_ADD),
      equationAlpha: defaultValue_default(
        blending.equationAlpha,
        WebGLConstants_default.FUNC_ADD
      ),
      functionSourceRgb: defaultValue_default(
        blending.functionSourceRgb,
        WebGLConstants_default.ONE
      ),
      functionSourceAlpha: defaultValue_default(
        blending.functionSourceAlpha,
        WebGLConstants_default.ONE
      ),
      functionDestinationRgb: defaultValue_default(
        blending.functionDestinationRgb,
        WebGLConstants_default.ZERO
      ),
      functionDestinationAlpha: defaultValue_default(
        blending.functionDestinationAlpha,
        WebGLConstants_default.ZERO
      )
    };
    this.stencilTest = {
      enabled: defaultValue_default(stencilTest.enabled, false),
      frontFunction: defaultValue_default(
        stencilTest.frontFunction,
        WebGLConstants_default.ALWAYS
      ),
      backFunction: defaultValue_default(stencilTest.backFunction, WebGLConstants_default.ALWAYS),
      reference: defaultValue_default(stencilTest.reference, 0),
      mask: defaultValue_default(stencilTest.mask, ~0),
      frontOperation: {
        fail: defaultValue_default(stencilTestFrontOperation.fail, WebGLConstants_default.KEEP),
        zFail: defaultValue_default(stencilTestFrontOperation.zFail, WebGLConstants_default.KEEP),
        zPass: defaultValue_default(stencilTestFrontOperation.zPass, WebGLConstants_default.KEEP)
      },
      backOperation: {
        fail: defaultValue_default(stencilTestBackOperation.fail, WebGLConstants_default.KEEP),
        zFail: defaultValue_default(stencilTestBackOperation.zFail, WebGLConstants_default.KEEP),
        zPass: defaultValue_default(stencilTestBackOperation.zPass, WebGLConstants_default.KEEP)
      }
    };
    this.sampleCoverage = {
      enabled: defaultValue_default(sampleCoverage.enabled, false),
      value: defaultValue_default(sampleCoverage.value, 1),
      invert: defaultValue_default(sampleCoverage.invert, false)
    };
    this.viewport = defined_default(viewport) ? new BoundingRectangle_default(
      viewport.x,
      viewport.y,
      viewport.width,
      viewport.height
    ) : void 0;
    if (this.lineWidth < ContextLimits_default.minimumAliasedLineWidth || this.lineWidth > ContextLimits_default.maximumAliasedLineWidth) {
      throw new DeveloperError_default(
        "renderState.lineWidth is out of range.  Check minimumAliasedLineWidth and maximumAliasedLineWidth."
      );
    }
    if (!WindingOrder_default.validate(this.frontFace)) {
      throw new DeveloperError_default("Invalid renderState.frontFace.");
    }
    if (!validateCullFace(this.cull.face)) {
      throw new DeveloperError_default("Invalid renderState.cull.face.");
    }
    if (this.scissorTest.rectangle.width < 0 || this.scissorTest.rectangle.height < 0) {
      throw new DeveloperError_default(
        "renderState.scissorTest.rectangle.width and renderState.scissorTest.rectangle.height must be greater than or equal to zero."
      );
    }
    if (this.depthRange.near > this.depthRange.far) {
      throw new DeveloperError_default(
        "renderState.depthRange.near can not be greater than renderState.depthRange.far."
      );
    }
    if (this.depthRange.near < 0) {
      throw new DeveloperError_default(
        "renderState.depthRange.near must be greater than or equal to zero."
      );
    }
    if (this.depthRange.far > 1) {
      throw new DeveloperError_default(
        "renderState.depthRange.far must be less than or equal to one."
      );
    }
    if (!validateDepthFunction(this.depthTest.func)) {
      throw new DeveloperError_default("Invalid renderState.depthTest.func.");
    }
    if (this.blending.color.red < 0 || this.blending.color.red > 1 || this.blending.color.green < 0 || this.blending.color.green > 1 || this.blending.color.blue < 0 || this.blending.color.blue > 1 || this.blending.color.alpha < 0 || this.blending.color.alpha > 1) {
      throw new DeveloperError_default(
        "renderState.blending.color components must be greater than or equal to zero and less than or equal to one."
      );
    }
    if (!validateBlendEquation(this.blending.equationRgb)) {
      throw new DeveloperError_default("Invalid renderState.blending.equationRgb.");
    }
    if (!validateBlendEquation(this.blending.equationAlpha)) {
      throw new DeveloperError_default("Invalid renderState.blending.equationAlpha.");
    }
    if (!validateBlendFunction(this.blending.functionSourceRgb)) {
      throw new DeveloperError_default("Invalid renderState.blending.functionSourceRgb.");
    }
    if (!validateBlendFunction(this.blending.functionSourceAlpha)) {
      throw new DeveloperError_default(
        "Invalid renderState.blending.functionSourceAlpha."
      );
    }
    if (!validateBlendFunction(this.blending.functionDestinationRgb)) {
      throw new DeveloperError_default(
        "Invalid renderState.blending.functionDestinationRgb."
      );
    }
    if (!validateBlendFunction(this.blending.functionDestinationAlpha)) {
      throw new DeveloperError_default(
        "Invalid renderState.blending.functionDestinationAlpha."
      );
    }
    if (!validateStencilFunction(this.stencilTest.frontFunction)) {
      throw new DeveloperError_default("Invalid renderState.stencilTest.frontFunction.");
    }
    if (!validateStencilFunction(this.stencilTest.backFunction)) {
      throw new DeveloperError_default("Invalid renderState.stencilTest.backFunction.");
    }
    if (!validateStencilOperation(this.stencilTest.frontOperation.fail)) {
      throw new DeveloperError_default(
        "Invalid renderState.stencilTest.frontOperation.fail."
      );
    }
    if (!validateStencilOperation(this.stencilTest.frontOperation.zFail)) {
      throw new DeveloperError_default(
        "Invalid renderState.stencilTest.frontOperation.zFail."
      );
    }
    if (!validateStencilOperation(this.stencilTest.frontOperation.zPass)) {
      throw new DeveloperError_default(
        "Invalid renderState.stencilTest.frontOperation.zPass."
      );
    }
    if (!validateStencilOperation(this.stencilTest.backOperation.fail)) {
      throw new DeveloperError_default(
        "Invalid renderState.stencilTest.backOperation.fail."
      );
    }
    if (!validateStencilOperation(this.stencilTest.backOperation.zFail)) {
      throw new DeveloperError_default(
        "Invalid renderState.stencilTest.backOperation.zFail."
      );
    }
    if (!validateStencilOperation(this.stencilTest.backOperation.zPass)) {
      throw new DeveloperError_default(
        "Invalid renderState.stencilTest.backOperation.zPass."
      );
    }
    if (defined_default(this.viewport)) {
      if (this.viewport.width < 0) {
        throw new DeveloperError_default(
          "renderState.viewport.width must be greater than or equal to zero."
        );
      }
      if (this.viewport.height < 0) {
        throw new DeveloperError_default(
          "renderState.viewport.height must be greater than or equal to zero."
        );
      }
      if (this.viewport.width > ContextLimits_default.maximumViewportWidth) {
        throw new DeveloperError_default(
          `renderState.viewport.width must be less than or equal to the maximum viewport width (${ContextLimits_default.maximumViewportWidth.toString()}).  Check maximumViewportWidth.`
        );
      }
      if (this.viewport.height > ContextLimits_default.maximumViewportHeight) {
        throw new DeveloperError_default(
          `renderState.viewport.height must be less than or equal to the maximum viewport height (${ContextLimits_default.maximumViewportHeight.toString()}).  Check maximumViewportHeight.`
        );
      }
    }
    this.id = 0;
    this._applyFunctions = [];
  }
  var nextRenderStateId = 0;
  var renderStateCache = {};
  RenderState.fromCache = function(renderState) {
    const partialKey = JSON.stringify(renderState);
    let cachedState = renderStateCache[partialKey];
    if (defined_default(cachedState)) {
      ++cachedState.referenceCount;
      return cachedState.state;
    }
    let states = new RenderState(renderState);
    const fullKey = JSON.stringify(states);
    cachedState = renderStateCache[fullKey];
    if (!defined_default(cachedState)) {
      states.id = nextRenderStateId++;
      states = freezeRenderState_default(states);
      cachedState = {
        referenceCount: 0,
        state: states
      };
      renderStateCache[fullKey] = cachedState;
    }
    ++cachedState.referenceCount;
    renderStateCache[partialKey] = {
      referenceCount: 1,
      state: cachedState.state
    };
    return cachedState.state;
  };
  RenderState.removeFromCache = function(renderState) {
    const states = new RenderState(renderState);
    const fullKey = JSON.stringify(states);
    const fullCachedState = renderStateCache[fullKey];
    const partialKey = JSON.stringify(renderState);
    const cachedState = renderStateCache[partialKey];
    if (defined_default(cachedState)) {
      --cachedState.referenceCount;
      if (cachedState.referenceCount === 0) {
        delete renderStateCache[partialKey];
        if (defined_default(fullCachedState)) {
          --fullCachedState.referenceCount;
        }
      }
    }
    if (defined_default(fullCachedState) && fullCachedState.referenceCount === 0) {
      delete renderStateCache[fullKey];
    }
  };
  RenderState.getCache = function() {
    return renderStateCache;
  };
  RenderState.clearCache = function() {
    renderStateCache = {};
  };
  function enableOrDisable(gl, glEnum, enable) {
    if (enable) {
      gl.enable(glEnum);
    } else {
      gl.disable(glEnum);
    }
  }
  function applyFrontFace(gl, renderState) {
    gl.frontFace(renderState.frontFace);
  }
  function applyCull(gl, renderState) {
    const cull = renderState.cull;
    const enabled = cull.enabled;
    enableOrDisable(gl, gl.CULL_FACE, enabled);
    if (enabled) {
      gl.cullFace(cull.face);
    }
  }
  function applyLineWidth(gl, renderState) {
    gl.lineWidth(renderState.lineWidth);
  }
  function applyPolygonOffset(gl, renderState) {
    const polygonOffset = renderState.polygonOffset;
    const enabled = polygonOffset.enabled;
    enableOrDisable(gl, gl.POLYGON_OFFSET_FILL, enabled);
    if (enabled) {
      gl.polygonOffset(polygonOffset.factor, polygonOffset.units);
    }
  }
  function applyScissorTest(gl, renderState, passState) {
    const scissorTest = renderState.scissorTest;
    const enabled = defined_default(passState.scissorTest) ? passState.scissorTest.enabled : scissorTest.enabled;
    enableOrDisable(gl, gl.SCISSOR_TEST, enabled);
    if (enabled) {
      const rectangle = defined_default(passState.scissorTest) ? passState.scissorTest.rectangle : scissorTest.rectangle;
      gl.scissor(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
  }
  function applyDepthRange(gl, renderState) {
    const depthRange = renderState.depthRange;
    gl.depthRange(depthRange.near, depthRange.far);
  }
  function applyDepthTest(gl, renderState) {
    const depthTest = renderState.depthTest;
    const enabled = depthTest.enabled;
    enableOrDisable(gl, gl.DEPTH_TEST, enabled);
    if (enabled) {
      gl.depthFunc(depthTest.func);
    }
  }
  function applyColorMask(gl, renderState) {
    const colorMask = renderState.colorMask;
    gl.colorMask(colorMask.red, colorMask.green, colorMask.blue, colorMask.alpha);
  }
  function applyDepthMask(gl, renderState) {
    gl.depthMask(renderState.depthMask);
  }
  function applyStencilMask(gl, renderState) {
    gl.stencilMask(renderState.stencilMask);
  }
  function applyBlendingColor(gl, color) {
    gl.blendColor(color.red, color.green, color.blue, color.alpha);
  }
  function applyBlending(gl, renderState, passState) {
    const blending = renderState.blending;
    const enabled = defined_default(passState.blendingEnabled) ? passState.blendingEnabled : blending.enabled;
    enableOrDisable(gl, gl.BLEND, enabled);
    if (enabled) {
      applyBlendingColor(gl, blending.color);
      gl.blendEquationSeparate(blending.equationRgb, blending.equationAlpha);
      gl.blendFuncSeparate(
        blending.functionSourceRgb,
        blending.functionDestinationRgb,
        blending.functionSourceAlpha,
        blending.functionDestinationAlpha
      );
    }
  }
  function applyStencilTest(gl, renderState) {
    const stencilTest = renderState.stencilTest;
    const enabled = stencilTest.enabled;
    enableOrDisable(gl, gl.STENCIL_TEST, enabled);
    if (enabled) {
      const frontFunction = stencilTest.frontFunction;
      const backFunction = stencilTest.backFunction;
      const reference = stencilTest.reference;
      const mask = stencilTest.mask;
      gl.stencilFunc(frontFunction, reference, mask);
      gl.stencilFuncSeparate(gl.BACK, backFunction, reference, mask);
      gl.stencilFuncSeparate(gl.FRONT, frontFunction, reference, mask);
      const frontOperation = stencilTest.frontOperation;
      const frontOperationFail = frontOperation.fail;
      const frontOperationZFail = frontOperation.zFail;
      const frontOperationZPass = frontOperation.zPass;
      gl.stencilOpSeparate(
        gl.FRONT,
        frontOperationFail,
        frontOperationZFail,
        frontOperationZPass
      );
      const backOperation = stencilTest.backOperation;
      const backOperationFail = backOperation.fail;
      const backOperationZFail = backOperation.zFail;
      const backOperationZPass = backOperation.zPass;
      gl.stencilOpSeparate(
        gl.BACK,
        backOperationFail,
        backOperationZFail,
        backOperationZPass
      );
    }
  }
  function applySampleCoverage(gl, renderState) {
    const sampleCoverage = renderState.sampleCoverage;
    const enabled = sampleCoverage.enabled;
    enableOrDisable(gl, gl.SAMPLE_COVERAGE, enabled);
    if (enabled) {
      gl.sampleCoverage(sampleCoverage.value, sampleCoverage.invert);
    }
  }
  var scratchViewport = new BoundingRectangle_default();
  function applyViewport(gl, renderState, passState) {
    let viewport = defaultValue_default(renderState.viewport, passState.viewport);
    if (!defined_default(viewport)) {
      viewport = scratchViewport;
      viewport.width = passState.context.drawingBufferWidth;
      viewport.height = passState.context.drawingBufferHeight;
    }
    passState.context.uniformState.viewport = viewport;
    gl.viewport(viewport.x, viewport.y, viewport.width, viewport.height);
  }
  RenderState.apply = function(gl, renderState, passState) {
    applyFrontFace(gl, renderState);
    applyCull(gl, renderState);
    applyLineWidth(gl, renderState);
    applyPolygonOffset(gl, renderState);
    applyDepthRange(gl, renderState);
    applyDepthTest(gl, renderState);
    applyColorMask(gl, renderState);
    applyDepthMask(gl, renderState);
    applyStencilMask(gl, renderState);
    applyStencilTest(gl, renderState);
    applySampleCoverage(gl, renderState);
    applyScissorTest(gl, renderState, passState);
    applyBlending(gl, renderState, passState);
    applyViewport(gl, renderState, passState);
  };
  function createFuncs(previousState, nextState) {
    const funcs = [];
    if (previousState.frontFace !== nextState.frontFace) {
      funcs.push(applyFrontFace);
    }
    if (previousState.cull.enabled !== nextState.cull.enabled || previousState.cull.face !== nextState.cull.face) {
      funcs.push(applyCull);
    }
    if (previousState.lineWidth !== nextState.lineWidth) {
      funcs.push(applyLineWidth);
    }
    if (previousState.polygonOffset.enabled !== nextState.polygonOffset.enabled || previousState.polygonOffset.factor !== nextState.polygonOffset.factor || previousState.polygonOffset.units !== nextState.polygonOffset.units) {
      funcs.push(applyPolygonOffset);
    }
    if (previousState.depthRange.near !== nextState.depthRange.near || previousState.depthRange.far !== nextState.depthRange.far) {
      funcs.push(applyDepthRange);
    }
    if (previousState.depthTest.enabled !== nextState.depthTest.enabled || previousState.depthTest.func !== nextState.depthTest.func) {
      funcs.push(applyDepthTest);
    }
    if (previousState.colorMask.red !== nextState.colorMask.red || previousState.colorMask.green !== nextState.colorMask.green || previousState.colorMask.blue !== nextState.colorMask.blue || previousState.colorMask.alpha !== nextState.colorMask.alpha) {
      funcs.push(applyColorMask);
    }
    if (previousState.depthMask !== nextState.depthMask) {
      funcs.push(applyDepthMask);
    }
    if (previousState.stencilMask !== nextState.stencilMask) {
      funcs.push(applyStencilMask);
    }
    if (previousState.stencilTest.enabled !== nextState.stencilTest.enabled || previousState.stencilTest.frontFunction !== nextState.stencilTest.frontFunction || previousState.stencilTest.backFunction !== nextState.stencilTest.backFunction || previousState.stencilTest.reference !== nextState.stencilTest.reference || previousState.stencilTest.mask !== nextState.stencilTest.mask || previousState.stencilTest.frontOperation.fail !== nextState.stencilTest.frontOperation.fail || previousState.stencilTest.frontOperation.zFail !== nextState.stencilTest.frontOperation.zFail || previousState.stencilTest.backOperation.fail !== nextState.stencilTest.backOperation.fail || previousState.stencilTest.backOperation.zFail !== nextState.stencilTest.backOperation.zFail || previousState.stencilTest.backOperation.zPass !== nextState.stencilTest.backOperation.zPass) {
      funcs.push(applyStencilTest);
    }
    if (previousState.sampleCoverage.enabled !== nextState.sampleCoverage.enabled || previousState.sampleCoverage.value !== nextState.sampleCoverage.value || previousState.sampleCoverage.invert !== nextState.sampleCoverage.invert) {
      funcs.push(applySampleCoverage);
    }
    return funcs;
  }
  RenderState.partialApply = function(gl, previousRenderState, renderState, previousPassState, passState, clear2) {
    if (previousRenderState !== renderState) {
      let funcs = renderState._applyFunctions[previousRenderState.id];
      if (!defined_default(funcs)) {
        funcs = createFuncs(previousRenderState, renderState);
        renderState._applyFunctions[previousRenderState.id] = funcs;
      }
      const len = funcs.length;
      for (let i = 0; i < len; ++i) {
        funcs[i](gl, renderState);
      }
    }
    const previousScissorTest = defined_default(previousPassState.scissorTest) ? previousPassState.scissorTest : previousRenderState.scissorTest;
    const scissorTest = defined_default(passState.scissorTest) ? passState.scissorTest : renderState.scissorTest;
    if (previousScissorTest !== scissorTest || clear2) {
      applyScissorTest(gl, renderState, passState);
    }
    const previousBlendingEnabled = defined_default(previousPassState.blendingEnabled) ? previousPassState.blendingEnabled : previousRenderState.blending.enabled;
    const blendingEnabled = defined_default(passState.blendingEnabled) ? passState.blendingEnabled : renderState.blending.enabled;
    if (previousBlendingEnabled !== blendingEnabled || blendingEnabled && previousRenderState.blending !== renderState.blending) {
      applyBlending(gl, renderState, passState);
    }
    if (previousRenderState !== renderState || previousPassState !== passState || previousPassState.context !== passState.context) {
      applyViewport(gl, renderState, passState);
    }
  };
  RenderState.getState = function(renderState) {
    if (!defined_default(renderState)) {
      throw new DeveloperError_default("renderState is required.");
    }
    return {
      frontFace: renderState.frontFace,
      cull: {
        enabled: renderState.cull.enabled,
        face: renderState.cull.face
      },
      lineWidth: renderState.lineWidth,
      polygonOffset: {
        enabled: renderState.polygonOffset.enabled,
        factor: renderState.polygonOffset.factor,
        units: renderState.polygonOffset.units
      },
      scissorTest: {
        enabled: renderState.scissorTest.enabled,
        rectangle: BoundingRectangle_default.clone(renderState.scissorTest.rectangle)
      },
      depthRange: {
        near: renderState.depthRange.near,
        far: renderState.depthRange.far
      },
      depthTest: {
        enabled: renderState.depthTest.enabled,
        func: renderState.depthTest.func
      },
      colorMask: {
        red: renderState.colorMask.red,
        green: renderState.colorMask.green,
        blue: renderState.colorMask.blue,
        alpha: renderState.colorMask.alpha
      },
      depthMask: renderState.depthMask,
      stencilMask: renderState.stencilMask,
      blending: {
        enabled: renderState.blending.enabled,
        color: Color_default.clone(renderState.blending.color),
        equationRgb: renderState.blending.equationRgb,
        equationAlpha: renderState.blending.equationAlpha,
        functionSourceRgb: renderState.blending.functionSourceRgb,
        functionSourceAlpha: renderState.blending.functionSourceAlpha,
        functionDestinationRgb: renderState.blending.functionDestinationRgb,
        functionDestinationAlpha: renderState.blending.functionDestinationAlpha
      },
      stencilTest: {
        enabled: renderState.stencilTest.enabled,
        frontFunction: renderState.stencilTest.frontFunction,
        backFunction: renderState.stencilTest.backFunction,
        reference: renderState.stencilTest.reference,
        mask: renderState.stencilTest.mask,
        frontOperation: {
          fail: renderState.stencilTest.frontOperation.fail,
          zFail: renderState.stencilTest.frontOperation.zFail,
          zPass: renderState.stencilTest.frontOperation.zPass
        },
        backOperation: {
          fail: renderState.stencilTest.backOperation.fail,
          zFail: renderState.stencilTest.backOperation.zFail,
          zPass: renderState.stencilTest.backOperation.zPass
        }
      },
      sampleCoverage: {
        enabled: renderState.sampleCoverage.enabled,
        value: renderState.sampleCoverage.value,
        invert: renderState.sampleCoverage.invert
      },
      viewport: defined_default(renderState.viewport) ? BoundingRectangle_default.clone(renderState.viewport) : void 0
    };
  };
  var RenderState_default = RenderState;

  // Source/Core/Matrix2.js
  function Matrix2(column0Row0, column1Row0, column0Row1, column1Row1) {
    this[0] = defaultValue_default(column0Row0, 0);
    this[1] = defaultValue_default(column0Row1, 0);
    this[2] = defaultValue_default(column1Row0, 0);
    this[3] = defaultValue_default(column1Row1, 0);
  }
  Matrix2.packedLength = 4;
  Matrix2.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value[0];
    array[startingIndex++] = value[1];
    array[startingIndex++] = value[2];
    array[startingIndex++] = value[3];
    return array;
  };
  Matrix2.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Matrix2();
    }
    result[0] = array[startingIndex++];
    result[1] = array[startingIndex++];
    result[2] = array[startingIndex++];
    result[3] = array[startingIndex++];
    return result;
  };
  Matrix2.packArray = function(array, result) {
    Check_default.defined("array", array);
    const length3 = array.length;
    const resultLength = length3 * 4;
    if (!defined_default(result)) {
      result = new Array(resultLength);
    } else if (!Array.isArray(result) && result.length !== resultLength) {
      throw new DeveloperError_default(
        "If result is a typed array, it must have exactly array.length * 4 elements"
      );
    } else if (result.length !== resultLength) {
      result.length = resultLength;
    }
    for (let i = 0; i < length3; ++i) {
      Matrix2.pack(array[i], result, i * 4);
    }
    return result;
  };
  Matrix2.unpackArray = function(array, result) {
    Check_default.defined("array", array);
    Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 4);
    if (array.length % 4 !== 0) {
      throw new DeveloperError_default("array length must be a multiple of 4.");
    }
    const length3 = array.length;
    if (!defined_default(result)) {
      result = new Array(length3 / 4);
    } else {
      result.length = length3 / 4;
    }
    for (let i = 0; i < length3; i += 4) {
      const index = i / 4;
      result[index] = Matrix2.unpack(array, i, result[index]);
    }
    return result;
  };
  Matrix2.clone = function(matrix, result) {
    if (!defined_default(matrix)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Matrix2(matrix[0], matrix[2], matrix[1], matrix[3]);
    }
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[3];
    return result;
  };
  Matrix2.fromArray = Matrix2.unpack;
  Matrix2.fromColumnMajorArray = function(values, result) {
    Check_default.defined("values", values);
    return Matrix2.clone(values, result);
  };
  Matrix2.fromRowMajorArray = function(values, result) {
    Check_default.defined("values", values);
    if (!defined_default(result)) {
      return new Matrix2(values[0], values[1], values[2], values[3]);
    }
    result[0] = values[0];
    result[1] = values[2];
    result[2] = values[1];
    result[3] = values[3];
    return result;
  };
  Matrix2.fromScale = function(scale, result) {
    Check_default.typeOf.object("scale", scale);
    if (!defined_default(result)) {
      return new Matrix2(scale.x, 0, 0, scale.y);
    }
    result[0] = scale.x;
    result[1] = 0;
    result[2] = 0;
    result[3] = scale.y;
    return result;
  };
  Matrix2.fromUniformScale = function(scale, result) {
    Check_default.typeOf.number("scale", scale);
    if (!defined_default(result)) {
      return new Matrix2(scale, 0, 0, scale);
    }
    result[0] = scale;
    result[1] = 0;
    result[2] = 0;
    result[3] = scale;
    return result;
  };
  Matrix2.fromRotation = function(angle, result) {
    Check_default.typeOf.number("angle", angle);
    const cosAngle = Math.cos(angle);
    const sinAngle = Math.sin(angle);
    if (!defined_default(result)) {
      return new Matrix2(cosAngle, -sinAngle, sinAngle, cosAngle);
    }
    result[0] = cosAngle;
    result[1] = sinAngle;
    result[2] = -sinAngle;
    result[3] = cosAngle;
    return result;
  };
  Matrix2.toArray = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    if (!defined_default(result)) {
      return [matrix[0], matrix[1], matrix[2], matrix[3]];
    }
    result[0] = matrix[0];
    result[1] = matrix[1];
    result[2] = matrix[2];
    result[3] = matrix[3];
    return result;
  };
  Matrix2.getElementIndex = function(column, row) {
    Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
    Check_default.typeOf.number.lessThanOrEquals("row", row, 1);
    Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
    Check_default.typeOf.number.lessThanOrEquals("column", column, 1);
    return column * 2 + row;
  };
  Matrix2.getColumn = function(matrix, index, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 1);
    Check_default.typeOf.object("result", result);
    const startIndex = index * 2;
    const x = matrix[startIndex];
    const y = matrix[startIndex + 1];
    result.x = x;
    result.y = y;
    return result;
  };
  Matrix2.setColumn = function(matrix, index, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 1);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result = Matrix2.clone(matrix, result);
    const startIndex = index * 2;
    result[startIndex] = cartesian11.x;
    result[startIndex + 1] = cartesian11.y;
    return result;
  };
  Matrix2.getRow = function(matrix, index, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 1);
    Check_default.typeOf.object("result", result);
    const x = matrix[index];
    const y = matrix[index + 2];
    result.x = x;
    result.y = y;
    return result;
  };
  Matrix2.setRow = function(matrix, index, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
    Check_default.typeOf.number.lessThanOrEquals("index", index, 1);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    result = Matrix2.clone(matrix, result);
    result[index] = cartesian11.x;
    result[index + 2] = cartesian11.y;
    return result;
  };
  var scaleScratch13 = new Cartesian2_default();
  Matrix2.setScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("scale", scale);
    Check_default.typeOf.object("result", result);
    const existingScale = Matrix2.getScale(matrix, scaleScratch13);
    const scaleRatioX = scale.x / existingScale.x;
    const scaleRatioY = scale.y / existingScale.y;
    result[0] = matrix[0] * scaleRatioX;
    result[1] = matrix[1] * scaleRatioX;
    result[2] = matrix[2] * scaleRatioY;
    result[3] = matrix[3] * scaleRatioY;
    return result;
  };
  var scaleScratch23 = new Cartesian2_default();
  Matrix2.setUniformScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scale", scale);
    Check_default.typeOf.object("result", result);
    const existingScale = Matrix2.getScale(matrix, scaleScratch23);
    const scaleRatioX = scale / existingScale.x;
    const scaleRatioY = scale / existingScale.y;
    result[0] = matrix[0] * scaleRatioX;
    result[1] = matrix[1] * scaleRatioX;
    result[2] = matrix[2] * scaleRatioY;
    result[3] = matrix[3] * scaleRatioY;
    return result;
  };
  var scratchColumn3 = new Cartesian2_default();
  Matrix2.getScale = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result.x = Cartesian2_default.magnitude(
      Cartesian2_default.fromElements(matrix[0], matrix[1], scratchColumn3)
    );
    result.y = Cartesian2_default.magnitude(
      Cartesian2_default.fromElements(matrix[2], matrix[3], scratchColumn3)
    );
    return result;
  };
  var scaleScratch33 = new Cartesian2_default();
  Matrix2.getMaximumScale = function(matrix) {
    Matrix2.getScale(matrix, scaleScratch33);
    return Cartesian2_default.maximumComponent(scaleScratch33);
  };
  var scaleScratch43 = new Cartesian2_default();
  Matrix2.setRotation = function(matrix, rotation, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const scale = Matrix2.getScale(matrix, scaleScratch43);
    result[0] = rotation[0] * scale.x;
    result[1] = rotation[1] * scale.x;
    result[2] = rotation[2] * scale.y;
    result[3] = rotation[3] * scale.y;
    return result;
  };
  var scaleScratch53 = new Cartesian2_default();
  Matrix2.getRotation = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const scale = Matrix2.getScale(matrix, scaleScratch53);
    result[0] = matrix[0] / scale.x;
    result[1] = matrix[1] / scale.x;
    result[2] = matrix[2] / scale.y;
    result[3] = matrix[3] / scale.y;
    return result;
  };
  Matrix2.multiply = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    const column0Row0 = left[0] * right[0] + left[2] * right[1];
    const column1Row0 = left[0] * right[2] + left[2] * right[3];
    const column0Row1 = left[1] * right[0] + left[3] * right[1];
    const column1Row1 = left[1] * right[2] + left[3] * right[3];
    result[0] = column0Row0;
    result[1] = column0Row1;
    result[2] = column1Row0;
    result[3] = column1Row1;
    return result;
  };
  Matrix2.add = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result[0] = left[0] + right[0];
    result[1] = left[1] + right[1];
    result[2] = left[2] + right[2];
    result[3] = left[3] + right[3];
    return result;
  };
  Matrix2.subtract = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result[0] = left[0] - right[0];
    result[1] = left[1] - right[1];
    result[2] = left[2] - right[2];
    result[3] = left[3] - right[3];
    return result;
  };
  Matrix2.multiplyByVector = function(matrix, cartesian11, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const x = matrix[0] * cartesian11.x + matrix[2] * cartesian11.y;
    const y = matrix[1] * cartesian11.x + matrix[3] * cartesian11.y;
    result.x = x;
    result.y = y;
    return result;
  };
  Matrix2.multiplyByScalar = function(matrix, scalar, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0] * scalar;
    result[1] = matrix[1] * scalar;
    result[2] = matrix[2] * scalar;
    result[3] = matrix[3] * scalar;
    return result;
  };
  Matrix2.multiplyByScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("scale", scale);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0] * scale.x;
    result[1] = matrix[1] * scale.x;
    result[2] = matrix[2] * scale.y;
    result[3] = matrix[3] * scale.y;
    return result;
  };
  Matrix2.multiplyByUniformScale = function(matrix, scale, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.number("scale", scale);
    Check_default.typeOf.object("result", result);
    result[0] = matrix[0] * scale;
    result[1] = matrix[1] * scale;
    result[2] = matrix[2] * scale;
    result[3] = matrix[3] * scale;
    return result;
  };
  Matrix2.negate = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result[0] = -matrix[0];
    result[1] = -matrix[1];
    result[2] = -matrix[2];
    result[3] = -matrix[3];
    return result;
  };
  Matrix2.transpose = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    const column0Row0 = matrix[0];
    const column0Row1 = matrix[2];
    const column1Row0 = matrix[1];
    const column1Row1 = matrix[3];
    result[0] = column0Row0;
    result[1] = column0Row1;
    result[2] = column1Row0;
    result[3] = column1Row1;
    return result;
  };
  Matrix2.abs = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    Check_default.typeOf.object("result", result);
    result[0] = Math.abs(matrix[0]);
    result[1] = Math.abs(matrix[1]);
    result[2] = Math.abs(matrix[2]);
    result[3] = Math.abs(matrix[3]);
    return result;
  };
  Matrix2.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[3] === right[3];
  };
  Matrix2.equalsArray = function(matrix, array, offset2) {
    return matrix[0] === array[offset2] && matrix[1] === array[offset2 + 1] && matrix[2] === array[offset2 + 2] && matrix[3] === array[offset2 + 3];
  };
  Matrix2.equalsEpsilon = function(left, right, epsilon) {
    epsilon = defaultValue_default(epsilon, 0);
    return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon;
  };
  Matrix2.IDENTITY = Object.freeze(new Matrix2(1, 0, 0, 1));
  Matrix2.ZERO = Object.freeze(new Matrix2(0, 0, 0, 0));
  Matrix2.COLUMN0ROW0 = 0;
  Matrix2.COLUMN0ROW1 = 1;
  Matrix2.COLUMN1ROW0 = 2;
  Matrix2.COLUMN1ROW1 = 3;
  Object.defineProperties(Matrix2.prototype, {
    length: {
      get: function() {
        return Matrix2.packedLength;
      }
    }
  });
  Matrix2.prototype.clone = function(result) {
    return Matrix2.clone(this, result);
  };
  Matrix2.prototype.equals = function(right) {
    return Matrix2.equals(this, right);
  };
  Matrix2.prototype.equalsEpsilon = function(right, epsilon) {
    return Matrix2.equalsEpsilon(this, right, epsilon);
  };
  Matrix2.prototype.toString = function() {
    return `(${this[0]}, ${this[2]})
(${this[1]}, ${this[3]})`;
  };
  var Matrix2_default = Matrix2;

  // Source/Renderer/createUniform.js
  function createUniform(gl, activeUniform, uniformName, location2) {
    switch (activeUniform.type) {
      case gl.FLOAT:
        return new UniformFloat(gl, activeUniform, uniformName, location2);
      case gl.FLOAT_VEC2:
        return new UniformFloatVec2(gl, activeUniform, uniformName, location2);
      case gl.FLOAT_VEC3:
        return new UniformFloatVec3(gl, activeUniform, uniformName, location2);
      case gl.FLOAT_VEC4:
        return new UniformFloatVec4(gl, activeUniform, uniformName, location2);
      case gl.SAMPLER_2D:
      case gl.SAMPLER_CUBE:
        return new UniformSampler(gl, activeUniform, uniformName, location2);
      case gl.INT:
      case gl.BOOL:
        return new UniformInt(gl, activeUniform, uniformName, location2);
      case gl.INT_VEC2:
      case gl.BOOL_VEC2:
        return new UniformIntVec2(gl, activeUniform, uniformName, location2);
      case gl.INT_VEC3:
      case gl.BOOL_VEC3:
        return new UniformIntVec3(gl, activeUniform, uniformName, location2);
      case gl.INT_VEC4:
      case gl.BOOL_VEC4:
        return new UniformIntVec4(gl, activeUniform, uniformName, location2);
      case gl.FLOAT_MAT2:
        return new UniformMat2(gl, activeUniform, uniformName, location2);
      case gl.FLOAT_MAT3:
        return new UniformMat3(gl, activeUniform, uniformName, location2);
      case gl.FLOAT_MAT4:
        return new UniformMat4(gl, activeUniform, uniformName, location2);
      default:
        throw new RuntimeError_default(
          `Unrecognized uniform type: ${activeUniform.type} for uniform "${uniformName}".`
        );
    }
  }
  function UniformFloat(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = 0;
    this._gl = gl;
    this._location = location2;
  }
  UniformFloat.prototype.set = function() {
    if (this.value !== this._value) {
      this._value = this.value;
      this._gl.uniform1f(this._location, this.value);
    }
  };
  function UniformFloatVec2(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = new Cartesian2_default();
    this._gl = gl;
    this._location = location2;
  }
  UniformFloatVec2.prototype.set = function() {
    const v7 = this.value;
    if (!Cartesian2_default.equals(v7, this._value)) {
      Cartesian2_default.clone(v7, this._value);
      this._gl.uniform2f(this._location, v7.x, v7.y);
    }
  };
  function UniformFloatVec3(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = void 0;
    this._gl = gl;
    this._location = location2;
  }
  UniformFloatVec3.prototype.set = function() {
    const v7 = this.value;
    if (defined_default(v7.red)) {
      if (!Color_default.equals(v7, this._value)) {
        this._value = Color_default.clone(v7, this._value);
        this._gl.uniform3f(this._location, v7.red, v7.green, v7.blue);
      }
    } else if (defined_default(v7.x)) {
      if (!Cartesian3_default.equals(v7, this._value)) {
        this._value = Cartesian3_default.clone(v7, this._value);
        this._gl.uniform3f(this._location, v7.x, v7.y, v7.z);
      }
    } else {
      throw new DeveloperError_default(`Invalid vec3 value for uniform "${this.name}".`);
    }
  };
  function UniformFloatVec4(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = void 0;
    this._gl = gl;
    this._location = location2;
  }
  UniformFloatVec4.prototype.set = function() {
    const v7 = this.value;
    if (defined_default(v7.red)) {
      if (!Color_default.equals(v7, this._value)) {
        this._value = Color_default.clone(v7, this._value);
        this._gl.uniform4f(this._location, v7.red, v7.green, v7.blue, v7.alpha);
      }
    } else if (defined_default(v7.x)) {
      if (!Cartesian4_default.equals(v7, this._value)) {
        this._value = Cartesian4_default.clone(v7, this._value);
        this._gl.uniform4f(this._location, v7.x, v7.y, v7.z, v7.w);
      }
    } else {
      throw new DeveloperError_default(`Invalid vec4 value for uniform "${this.name}".`);
    }
  };
  function UniformSampler(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._gl = gl;
    this._location = location2;
    this.textureUnitIndex = void 0;
  }
  UniformSampler.prototype.set = function() {
    const gl = this._gl;
    gl.activeTexture(gl.TEXTURE0 + this.textureUnitIndex);
    const v7 = this.value;
    gl.bindTexture(v7._target, v7._texture);
  };
  UniformSampler.prototype._setSampler = function(textureUnitIndex) {
    this.textureUnitIndex = textureUnitIndex;
    this._gl.uniform1i(this._location, textureUnitIndex);
    return textureUnitIndex + 1;
  };
  function UniformInt(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = 0;
    this._gl = gl;
    this._location = location2;
  }
  UniformInt.prototype.set = function() {
    if (this.value !== this._value) {
      this._value = this.value;
      this._gl.uniform1i(this._location, this.value);
    }
  };
  function UniformIntVec2(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = new Cartesian2_default();
    this._gl = gl;
    this._location = location2;
  }
  UniformIntVec2.prototype.set = function() {
    const v7 = this.value;
    if (!Cartesian2_default.equals(v7, this._value)) {
      Cartesian2_default.clone(v7, this._value);
      this._gl.uniform2i(this._location, v7.x, v7.y);
    }
  };
  function UniformIntVec3(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = new Cartesian3_default();
    this._gl = gl;
    this._location = location2;
  }
  UniformIntVec3.prototype.set = function() {
    const v7 = this.value;
    if (!Cartesian3_default.equals(v7, this._value)) {
      Cartesian3_default.clone(v7, this._value);
      this._gl.uniform3i(this._location, v7.x, v7.y, v7.z);
    }
  };
  function UniformIntVec4(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = new Cartesian4_default();
    this._gl = gl;
    this._location = location2;
  }
  UniformIntVec4.prototype.set = function() {
    const v7 = this.value;
    if (!Cartesian4_default.equals(v7, this._value)) {
      Cartesian4_default.clone(v7, this._value);
      this._gl.uniform4i(this._location, v7.x, v7.y, v7.z, v7.w);
    }
  };
  var scratchUniformArray = new Float32Array(4);
  function UniformMat2(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = new Matrix2_default();
    this._gl = gl;
    this._location = location2;
  }
  UniformMat2.prototype.set = function() {
    if (!Matrix2_default.equalsArray(this.value, this._value, 0)) {
      Matrix2_default.clone(this.value, this._value);
      const array = Matrix2_default.toArray(this.value, scratchUniformArray);
      this._gl.uniformMatrix2fv(this._location, false, array);
    }
  };
  var scratchMat3Array = new Float32Array(9);
  function UniformMat3(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = new Matrix3_default();
    this._gl = gl;
    this._location = location2;
  }
  UniformMat3.prototype.set = function() {
    if (!Matrix3_default.equalsArray(this.value, this._value, 0)) {
      Matrix3_default.clone(this.value, this._value);
      const array = Matrix3_default.toArray(this.value, scratchMat3Array);
      this._gl.uniformMatrix3fv(this._location, false, array);
    }
  };
  var scratchMat4Array = new Float32Array(16);
  function UniformMat4(gl, activeUniform, uniformName, location2) {
    this.name = uniformName;
    this.value = void 0;
    this._value = new Matrix4_default();
    this._gl = gl;
    this._location = location2;
  }
  UniformMat4.prototype.set = function() {
    if (!Matrix4_default.equalsArray(this.value, this._value, 0)) {
      Matrix4_default.clone(this.value, this._value);
      const array = Matrix4_default.toArray(this.value, scratchMat4Array);
      this._gl.uniformMatrix4fv(this._location, false, array);
    }
  };
  var createUniform_default = createUniform;

  // Source/Renderer/createUniformArray.js
  function createUniformArray(gl, activeUniform, uniformName, locations) {
    switch (activeUniform.type) {
      case gl.FLOAT:
        return new UniformArrayFloat(gl, activeUniform, uniformName, locations);
      case gl.FLOAT_VEC2:
        return new UniformArrayFloatVec2(
          gl,
          activeUniform,
          uniformName,
          locations
        );
      case gl.FLOAT_VEC3:
        return new UniformArrayFloatVec3(
          gl,
          activeUniform,
          uniformName,
          locations
        );
      case gl.FLOAT_VEC4:
        return new UniformArrayFloatVec4(
          gl,
          activeUniform,
          uniformName,
          locations
        );
      case gl.SAMPLER_2D:
      case gl.SAMPLER_CUBE:
        return new UniformArraySampler(gl, activeUniform, uniformName, locations);
      case gl.INT:
      case gl.BOOL:
        return new UniformArrayInt(gl, activeUniform, uniformName, locations);
      case gl.INT_VEC2:
      case gl.BOOL_VEC2:
        return new UniformArrayIntVec2(gl, activeUniform, uniformName, locations);
      case gl.INT_VEC3:
      case gl.BOOL_VEC3:
        return new UniformArrayIntVec3(gl, activeUniform, uniformName, locations);
      case gl.INT_VEC4:
      case gl.BOOL_VEC4:
        return new UniformArrayIntVec4(gl, activeUniform, uniformName, locations);
      case gl.FLOAT_MAT2:
        return new UniformArrayMat2(gl, activeUniform, uniformName, locations);
      case gl.FLOAT_MAT3:
        return new UniformArrayMat3(gl, activeUniform, uniformName, locations);
      case gl.FLOAT_MAT4:
        return new UniformArrayMat4(gl, activeUniform, uniformName, locations);
      default:
        throw new RuntimeError_default(
          `Unrecognized uniform type: ${activeUniform.type} for uniform "${uniformName}".`
        );
    }
  }
  function UniformArrayFloat(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Float32Array(length3);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayFloat.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (v7 !== arraybuffer[i]) {
        arraybuffer[i] = v7;
        changed = true;
      }
    }
    if (changed) {
      this._gl.uniform1fv(this._location, arraybuffer);
    }
  };
  function UniformArrayFloatVec2(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Float32Array(length3 * 2);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayFloatVec2.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (!Cartesian2_default.equalsArray(v7, arraybuffer, j)) {
        Cartesian2_default.pack(v7, arraybuffer, j);
        changed = true;
      }
      j += 2;
    }
    if (changed) {
      this._gl.uniform2fv(this._location, arraybuffer);
    }
  };
  function UniformArrayFloatVec3(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Float32Array(length3 * 3);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayFloatVec3.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (defined_default(v7.red)) {
        if (v7.red !== arraybuffer[j] || v7.green !== arraybuffer[j + 1] || v7.blue !== arraybuffer[j + 2]) {
          arraybuffer[j] = v7.red;
          arraybuffer[j + 1] = v7.green;
          arraybuffer[j + 2] = v7.blue;
          changed = true;
        }
      } else if (defined_default(v7.x)) {
        if (!Cartesian3_default.equalsArray(v7, arraybuffer, j)) {
          Cartesian3_default.pack(v7, arraybuffer, j);
          changed = true;
        }
      } else {
        throw new DeveloperError_default("Invalid vec3 value.");
      }
      j += 3;
    }
    if (changed) {
      this._gl.uniform3fv(this._location, arraybuffer);
    }
  };
  function UniformArrayFloatVec4(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Float32Array(length3 * 4);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayFloatVec4.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (defined_default(v7.red)) {
        if (!Color_default.equalsArray(v7, arraybuffer, j)) {
          Color_default.pack(v7, arraybuffer, j);
          changed = true;
        }
      } else if (defined_default(v7.x)) {
        if (!Cartesian4_default.equalsArray(v7, arraybuffer, j)) {
          Cartesian4_default.pack(v7, arraybuffer, j);
          changed = true;
        }
      } else {
        throw new DeveloperError_default("Invalid vec4 value.");
      }
      j += 4;
    }
    if (changed) {
      this._gl.uniform4fv(this._location, arraybuffer);
    }
  };
  function UniformArraySampler(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Float32Array(length3);
    this._gl = gl;
    this._locations = locations;
    this.textureUnitIndex = void 0;
  }
  UniformArraySampler.prototype.set = function() {
    const gl = this._gl;
    const textureUnitIndex = gl.TEXTURE0 + this.textureUnitIndex;
    const value = this.value;
    const length3 = value.length;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      gl.activeTexture(textureUnitIndex + i);
      gl.bindTexture(v7._target, v7._texture);
    }
  };
  UniformArraySampler.prototype._setSampler = function(textureUnitIndex) {
    this.textureUnitIndex = textureUnitIndex;
    const locations = this._locations;
    const length3 = locations.length;
    for (let i = 0; i < length3; ++i) {
      const index = textureUnitIndex + i;
      this._gl.uniform1i(locations[i], index);
    }
    return textureUnitIndex + length3;
  };
  function UniformArrayInt(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Int32Array(length3);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayInt.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (v7 !== arraybuffer[i]) {
        arraybuffer[i] = v7;
        changed = true;
      }
    }
    if (changed) {
      this._gl.uniform1iv(this._location, arraybuffer);
    }
  };
  function UniformArrayIntVec2(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Int32Array(length3 * 2);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayIntVec2.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (!Cartesian2_default.equalsArray(v7, arraybuffer, j)) {
        Cartesian2_default.pack(v7, arraybuffer, j);
        changed = true;
      }
      j += 2;
    }
    if (changed) {
      this._gl.uniform2iv(this._location, arraybuffer);
    }
  };
  function UniformArrayIntVec3(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Int32Array(length3 * 3);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayIntVec3.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (!Cartesian3_default.equalsArray(v7, arraybuffer, j)) {
        Cartesian3_default.pack(v7, arraybuffer, j);
        changed = true;
      }
      j += 3;
    }
    if (changed) {
      this._gl.uniform3iv(this._location, arraybuffer);
    }
  };
  function UniformArrayIntVec4(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Int32Array(length3 * 4);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayIntVec4.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (!Cartesian4_default.equalsArray(v7, arraybuffer, j)) {
        Cartesian4_default.pack(v7, arraybuffer, j);
        changed = true;
      }
      j += 4;
    }
    if (changed) {
      this._gl.uniform4iv(this._location, arraybuffer);
    }
  };
  function UniformArrayMat2(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Float32Array(length3 * 4);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayMat2.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (!Matrix2_default.equalsArray(v7, arraybuffer, j)) {
        Matrix2_default.pack(v7, arraybuffer, j);
        changed = true;
      }
      j += 4;
    }
    if (changed) {
      this._gl.uniformMatrix2fv(this._location, false, arraybuffer);
    }
  };
  function UniformArrayMat3(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Float32Array(length3 * 9);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayMat3.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (!Matrix3_default.equalsArray(v7, arraybuffer, j)) {
        Matrix3_default.pack(v7, arraybuffer, j);
        changed = true;
      }
      j += 9;
    }
    if (changed) {
      this._gl.uniformMatrix3fv(this._location, false, arraybuffer);
    }
  };
  function UniformArrayMat4(gl, activeUniform, uniformName, locations) {
    const length3 = locations.length;
    this.name = uniformName;
    this.value = new Array(length3);
    this._value = new Float32Array(length3 * 16);
    this._gl = gl;
    this._location = locations[0];
  }
  UniformArrayMat4.prototype.set = function() {
    const value = this.value;
    const length3 = value.length;
    const arraybuffer = this._value;
    let changed = false;
    let j = 0;
    for (let i = 0; i < length3; ++i) {
      const v7 = value[i];
      if (!Matrix4_default.equalsArray(v7, arraybuffer, j)) {
        Matrix4_default.pack(v7, arraybuffer, j);
        changed = true;
      }
      j += 16;
    }
    if (changed) {
      this._gl.uniformMatrix4fv(this._location, false, arraybuffer);
    }
  };
  var createUniformArray_default = createUniformArray;

  // Source/Renderer/ShaderProgram.js
  var nextShaderProgramId = 0;
  function ShaderProgram(options) {
    let vertexShaderText = options.vertexShaderText;
    let fragmentShaderText = options.fragmentShaderText;
    if (typeof spector !== "undefined") {
      vertexShaderText = vertexShaderText.replace(/^#line/gm, "//#line");
      fragmentShaderText = fragmentShaderText.replace(/^#line/gm, "//#line");
    }
    const modifiedFS = handleUniformPrecisionMismatches(
      vertexShaderText,
      fragmentShaderText
    );
    this._gl = options.gl;
    this._logShaderCompilation = options.logShaderCompilation;
    this._debugShaders = options.debugShaders;
    this._attributeLocations = options.attributeLocations;
    this._program = void 0;
    this._numberOfVertexAttributes = void 0;
    this._vertexAttributes = void 0;
    this._uniformsByName = void 0;
    this._uniforms = void 0;
    this._automaticUniforms = void 0;
    this._manualUniforms = void 0;
    this._duplicateUniformNames = modifiedFS.duplicateUniformNames;
    this._cachedShader = void 0;
    this.maximumTextureUnitIndex = void 0;
    this._vertexShaderSource = options.vertexShaderSource;
    this._vertexShaderText = options.vertexShaderText;
    this._fragmentShaderSource = options.fragmentShaderSource;
    this._fragmentShaderText = modifiedFS.fragmentShaderText;
    this.id = nextShaderProgramId++;
  }
  ShaderProgram.fromCache = function(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    Check_default.defined("options.context", options.context);
    return options.context.shaderCache.getShaderProgram(options);
  };
  ShaderProgram.replaceCache = function(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    Check_default.defined("options.context", options.context);
    return options.context.shaderCache.replaceShaderProgram(options);
  };
  Object.defineProperties(ShaderProgram.prototype, {
    vertexShaderSource: {
      get: function() {
        return this._vertexShaderSource;
      }
    },
    fragmentShaderSource: {
      get: function() {
        return this._fragmentShaderSource;
      }
    },
    vertexAttributes: {
      get: function() {
        initialize2(this);
        return this._vertexAttributes;
      }
    },
    numberOfVertexAttributes: {
      get: function() {
        initialize2(this);
        return this._numberOfVertexAttributes;
      }
    },
    allUniforms: {
      get: function() {
        initialize2(this);
        return this._uniformsByName;
      }
    }
  });
  function extractUniforms(shaderText) {
    const uniformNames = [];
    const uniformLines = shaderText.match(/uniform.*?(?![^{]*})(?=[=\[;])/g);
    if (defined_default(uniformLines)) {
      const len = uniformLines.length;
      for (let i = 0; i < len; i++) {
        const line = uniformLines[i].trim();
        const name = line.slice(line.lastIndexOf(" ") + 1);
        uniformNames.push(name);
      }
    }
    return uniformNames;
  }
  function handleUniformPrecisionMismatches(vertexShaderText, fragmentShaderText) {
    const duplicateUniformNames = {};
    if (!ContextLimits_default.highpFloatSupported || !ContextLimits_default.highpIntSupported) {
      let i, j;
      let uniformName;
      let duplicateName;
      const vertexShaderUniforms = extractUniforms(vertexShaderText);
      const fragmentShaderUniforms = extractUniforms(fragmentShaderText);
      const vertexUniformsCount = vertexShaderUniforms.length;
      const fragmentUniformsCount = fragmentShaderUniforms.length;
      for (i = 0; i < vertexUniformsCount; i++) {
        for (j = 0; j < fragmentUniformsCount; j++) {
          if (vertexShaderUniforms[i] === fragmentShaderUniforms[j]) {
            uniformName = vertexShaderUniforms[i];
            duplicateName = `czm_mediump_${uniformName}`;
            const re = new RegExp(`${uniformName}\\b`, "g");
            fragmentShaderText = fragmentShaderText.replace(re, duplicateName);
            duplicateUniformNames[duplicateName] = uniformName;
          }
        }
      }
    }
    return {
      fragmentShaderText,
      duplicateUniformNames
    };
  }
  var consolePrefix = "[Cesium WebGL] ";
  function createAndLinkProgram(gl, shader) {
    const vsSource = shader._vertexShaderText;
    const fsSource = shader._fragmentShaderText;
    const vertexShader = gl.createShader(gl.VERTEX_SHADER);
    gl.shaderSource(vertexShader, vsSource);
    gl.compileShader(vertexShader);
    const fragmentShader = gl.createShader(gl.FRAGMENT_SHADER);
    gl.shaderSource(fragmentShader, fsSource);
    gl.compileShader(fragmentShader);
    const program = gl.createProgram();
    gl.attachShader(program, vertexShader);
    gl.attachShader(program, fragmentShader);
    const attributeLocations8 = shader._attributeLocations;
    if (defined_default(attributeLocations8)) {
      for (const attribute in attributeLocations8) {
        if (attributeLocations8.hasOwnProperty(attribute)) {
          gl.bindAttribLocation(
            program,
            attributeLocations8[attribute],
            attribute
          );
        }
      }
    }
    gl.linkProgram(program);
    let log;
    if (gl.getProgramParameter(program, gl.LINK_STATUS)) {
      if (shader._logShaderCompilation) {
        log = gl.getShaderInfoLog(vertexShader);
        if (defined_default(log) && log.length > 0) {
          console.log(`${consolePrefix}Vertex shader compile log: ${log}`);
        }
        log = gl.getShaderInfoLog(fragmentShader);
        if (defined_default(log) && log.length > 0) {
          console.log(`${consolePrefix}Fragment shader compile log: ${log}`);
        }
        log = gl.getProgramInfoLog(program);
        if (defined_default(log) && log.length > 0) {
          console.log(`${consolePrefix}Shader program link log: ${log}`);
        }
      }
      gl.deleteShader(vertexShader);
      gl.deleteShader(fragmentShader);
      return program;
    }
    let errorMessage;
    const debugShaders = shader._debugShaders;
    if (!gl.getShaderParameter(fragmentShader, gl.COMPILE_STATUS)) {
      log = gl.getShaderInfoLog(fragmentShader);
      console.error(`${consolePrefix}Fragment shader compile log: ${log}`);
      console.error(`${consolePrefix} Fragment shader source:
${fsSource}`);
      errorMessage = `Fragment shader failed to compile.  Compile log: ${log}`;
    } else if (!gl.getShaderParameter(vertexShader, gl.COMPILE_STATUS)) {
      log = gl.getShaderInfoLog(vertexShader);
      console.error(`${consolePrefix}Vertex shader compile log: ${log}`);
      console.error(`${consolePrefix} Vertex shader source:
${vsSource}`);
      errorMessage = `Vertex shader failed to compile.  Compile log: ${log}`;
    } else {
      log = gl.getProgramInfoLog(program);
      console.error(`${consolePrefix}Shader program link log: ${log}`);
      logTranslatedSource(vertexShader, "vertex");
      logTranslatedSource(fragmentShader, "fragment");
      errorMessage = `Program failed to link.  Link log: ${log}`;
    }
    gl.deleteShader(vertexShader);
    gl.deleteShader(fragmentShader);
    gl.deleteProgram(program);
    throw new RuntimeError_default(errorMessage);
    function logTranslatedSource(compiledShader, name) {
      if (!defined_default(debugShaders)) {
        return;
      }
      const translation3 = debugShaders.getTranslatedShaderSource(compiledShader);
      if (translation3 === "") {
        console.error(`${consolePrefix}${name} shader translation failed.`);
        return;
      }
      console.error(
        `${consolePrefix}Translated ${name} shaderSource:
${translation3}`
      );
    }
  }
  function findVertexAttributes(gl, program, numberOfAttributes2) {
    const attributes = {};
    for (let i = 0; i < numberOfAttributes2; ++i) {
      const attr = gl.getActiveAttrib(program, i);
      const location2 = gl.getAttribLocation(program, attr.name);
      attributes[attr.name] = {
        name: attr.name,
        type: attr.type,
        index: location2
      };
    }
    return attributes;
  }
  function findUniforms(gl, program) {
    const uniformsByName = {};
    const uniforms = [];
    const samplerUniforms = [];
    const numberOfUniforms = gl.getProgramParameter(program, gl.ACTIVE_UNIFORMS);
    for (let i = 0; i < numberOfUniforms; ++i) {
      const activeUniform = gl.getActiveUniform(program, i);
      const suffix = "[0]";
      const uniformName = activeUniform.name.indexOf(
        suffix,
        activeUniform.name.length - suffix.length
      ) !== -1 ? activeUniform.name.slice(0, activeUniform.name.length - 3) : activeUniform.name;
      if (uniformName.indexOf("gl_") !== 0) {
        if (activeUniform.name.indexOf("[") < 0) {
          const location2 = gl.getUniformLocation(program, uniformName);
          if (location2 !== null) {
            const uniform = createUniform_default(
              gl,
              activeUniform,
              uniformName,
              location2
            );
            uniformsByName[uniformName] = uniform;
            uniforms.push(uniform);
            if (uniform._setSampler) {
              samplerUniforms.push(uniform);
            }
          }
        } else {
          let uniformArray;
          let locations;
          let value;
          let loc;
          const indexOfBracket = uniformName.indexOf("[");
          if (indexOfBracket >= 0) {
            uniformArray = uniformsByName[uniformName.slice(0, indexOfBracket)];
            if (!defined_default(uniformArray)) {
              continue;
            }
            locations = uniformArray._locations;
            if (locations.length <= 1) {
              value = uniformArray.value;
              loc = gl.getUniformLocation(program, uniformName);
              if (loc !== null) {
                locations.push(loc);
                value.push(gl.getUniform(program, loc));
              }
            }
          } else {
            locations = [];
            for (let j = 0; j < activeUniform.size; ++j) {
              loc = gl.getUniformLocation(program, `${uniformName}[${j}]`);
              if (loc !== null) {
                locations.push(loc);
              }
            }
            uniformArray = createUniformArray_default(
              gl,
              activeUniform,
              uniformName,
              locations
            );
            uniformsByName[uniformName] = uniformArray;
            uniforms.push(uniformArray);
            if (uniformArray._setSampler) {
              samplerUniforms.push(uniformArray);
            }
          }
        }
      }
    }
    return {
      uniformsByName,
      uniforms,
      samplerUniforms
    };
  }
  function partitionUniforms(shader, uniforms) {
    const automaticUniforms = [];
    const manualUniforms = [];
    for (const uniform in uniforms) {
      if (uniforms.hasOwnProperty(uniform)) {
        const uniformObject = uniforms[uniform];
        let uniformName = uniform;
        const duplicateUniform = shader._duplicateUniformNames[uniformName];
        if (defined_default(duplicateUniform)) {
          uniformObject.name = duplicateUniform;
          uniformName = duplicateUniform;
        }
        const automaticUniform = AutomaticUniforms_default[uniformName];
        if (defined_default(automaticUniform)) {
          automaticUniforms.push({
            uniform: uniformObject,
            automaticUniform
          });
        } else {
          manualUniforms.push(uniformObject);
        }
      }
    }
    return {
      automaticUniforms,
      manualUniforms
    };
  }
  function setSamplerUniforms(gl, program, samplerUniforms) {
    gl.useProgram(program);
    let textureUnitIndex = 0;
    const length3 = samplerUniforms.length;
    for (let i = 0; i < length3; ++i) {
      textureUnitIndex = samplerUniforms[i]._setSampler(textureUnitIndex);
    }
    gl.useProgram(null);
    return textureUnitIndex;
  }
  function initialize2(shader) {
    if (defined_default(shader._program)) {
      return;
    }
    reinitialize(shader);
  }
  function reinitialize(shader) {
    const oldProgram = shader._program;
    const gl = shader._gl;
    const program = createAndLinkProgram(gl, shader, shader._debugShaders);
    const numberOfVertexAttributes = gl.getProgramParameter(
      program,
      gl.ACTIVE_ATTRIBUTES
    );
    const uniforms = findUniforms(gl, program);
    const partitionedUniforms = partitionUniforms(
      shader,
      uniforms.uniformsByName
    );
    shader._program = program;
    shader._numberOfVertexAttributes = numberOfVertexAttributes;
    shader._vertexAttributes = findVertexAttributes(
      gl,
      program,
      numberOfVertexAttributes
    );
    shader._uniformsByName = uniforms.uniformsByName;
    shader._uniforms = uniforms.uniforms;
    shader._automaticUniforms = partitionedUniforms.automaticUniforms;
    shader._manualUniforms = partitionedUniforms.manualUniforms;
    shader.maximumTextureUnitIndex = setSamplerUniforms(
      gl,
      program,
      uniforms.samplerUniforms
    );
    if (oldProgram) {
      shader._gl.deleteProgram(oldProgram);
    }
    if (typeof spector !== "undefined") {
      shader._program.__SPECTOR_rebuildProgram = function(vertexSourceCode, fragmentSourceCode, onCompiled, onError) {
        const originalVS = shader._vertexShaderText;
        const originalFS = shader._fragmentShaderText;
        const regex = / ! = /g;
        shader._vertexShaderText = vertexSourceCode.replace(regex, " != ");
        shader._fragmentShaderText = fragmentSourceCode.replace(regex, " != ");
        try {
          reinitialize(shader);
          onCompiled(shader._program);
        } catch (e) {
          shader._vertexShaderText = originalVS;
          shader._fragmentShaderText = originalFS;
          const errorMatcher = /(?:Compile|Link) error: ([^]*)/;
          const match = errorMatcher.exec(e.message);
          if (match) {
            onError(match[1]);
          } else {
            onError(e.message);
          }
        }
      };
    }
  }
  ShaderProgram.prototype._bind = function() {
    initialize2(this);
    this._gl.useProgram(this._program);
  };
  ShaderProgram.prototype._setUniforms = function(uniformMap2, uniformState, validate) {
    let len;
    let i;
    if (defined_default(uniformMap2)) {
      const manualUniforms = this._manualUniforms;
      len = manualUniforms.length;
      for (i = 0; i < len; ++i) {
        const mu = manualUniforms[i];
        mu.value = uniformMap2[mu.name]();
      }
    }
    const automaticUniforms = this._automaticUniforms;
    len = automaticUniforms.length;
    for (i = 0; i < len; ++i) {
      const au = automaticUniforms[i];
      au.uniform.value = au.automaticUniform.getValue(uniformState);
    }
    const uniforms = this._uniforms;
    len = uniforms.length;
    for (i = 0; i < len; ++i) {
      uniforms[i].set();
    }
    if (validate) {
      const gl = this._gl;
      const program = this._program;
      gl.validateProgram(program);
      if (!gl.getProgramParameter(program, gl.VALIDATE_STATUS)) {
        throw new DeveloperError_default(
          `Program validation failed.  Program info log: ${gl.getProgramInfoLog(
            program
          )}`
        );
      }
    }
  };
  ShaderProgram.prototype.isDestroyed = function() {
    return false;
  };
  ShaderProgram.prototype.destroy = function() {
    this._cachedShader.cache.releaseShaderProgram(this);
    return void 0;
  };
  ShaderProgram.prototype.finalDestroy = function() {
    this._gl.deleteProgram(this._program);
    return destroyObject_default(this);
  };
  var ShaderProgram_default = ShaderProgram;

  // Source/Renderer/ComputeEngine.js
  function ComputeEngine(context) {
    this._context = context;
  }
  var renderStateScratch;
  var drawCommandScratch = new DrawCommand_default({
    primitiveType: PrimitiveType_default.TRIANGLES
  });
  var clearCommandScratch = new ClearCommand_default({
    color: new Color_default(0, 0, 0, 0)
  });
  function createFramebuffer(context, outputTexture) {
    return new Framebuffer_default({
      context,
      colorTextures: [outputTexture],
      destroyAttachments: false
    });
  }
  function createViewportQuadShader(context, fragmentShaderSource) {
    return ShaderProgram_default.fromCache({
      context,
      vertexShaderSource: ViewportQuadVS_default,
      fragmentShaderSource,
      attributeLocations: {
        position: 0,
        textureCoordinates: 1
      }
    });
  }
  function createRenderState(width, height) {
    if (!defined_default(renderStateScratch) || renderStateScratch.viewport.width !== width || renderStateScratch.viewport.height !== height) {
      renderStateScratch = RenderState_default.fromCache({
        viewport: new BoundingRectangle_default(0, 0, width, height)
      });
    }
    return renderStateScratch;
  }
  ComputeEngine.prototype.execute = function(computeCommand) {
    Check_default.defined("computeCommand", computeCommand);
    if (defined_default(computeCommand.preExecute)) {
      computeCommand.preExecute(computeCommand);
    }
    if (!defined_default(computeCommand.fragmentShaderSource) && !defined_default(computeCommand.shaderProgram)) {
      throw new DeveloperError_default(
        "computeCommand.fragmentShaderSource or computeCommand.shaderProgram is required."
      );
    }
    Check_default.defined("computeCommand.outputTexture", computeCommand.outputTexture);
    const outputTexture = computeCommand.outputTexture;
    const width = outputTexture.width;
    const height = outputTexture.height;
    const context = this._context;
    const vertexArray = defined_default(computeCommand.vertexArray) ? computeCommand.vertexArray : context.getViewportQuadVertexArray();
    const shaderProgram = defined_default(computeCommand.shaderProgram) ? computeCommand.shaderProgram : createViewportQuadShader(context, computeCommand.fragmentShaderSource);
    const framebuffer = createFramebuffer(context, outputTexture);
    const renderState = createRenderState(width, height);
    const uniformMap2 = computeCommand.uniformMap;
    const clearCommand = clearCommandScratch;
    clearCommand.framebuffer = framebuffer;
    clearCommand.renderState = renderState;
    clearCommand.execute(context);
    const drawCommand = drawCommandScratch;
    drawCommand.vertexArray = vertexArray;
    drawCommand.renderState = renderState;
    drawCommand.shaderProgram = shaderProgram;
    drawCommand.uniformMap = uniformMap2;
    drawCommand.framebuffer = framebuffer;
    drawCommand.execute(context);
    framebuffer.destroy();
    if (!computeCommand.persists) {
      shaderProgram.destroy();
      if (defined_default(computeCommand.vertexArray)) {
        vertexArray.destroy();
      }
    }
    if (defined_default(computeCommand.postExecute)) {
      computeCommand.postExecute(outputTexture);
    }
  };
  ComputeEngine.prototype.isDestroyed = function() {
    return false;
  };
  ComputeEngine.prototype.destroy = function() {
    return destroyObject_default(this);
  };
  var ComputeEngine_default = ComputeEngine;

  // Source/Core/clone.js
  function clone(object2, deep) {
    if (object2 === null || typeof object2 !== "object") {
      return object2;
    }
    deep = defaultValue_default(deep, false);
    const result = new object2.constructor();
    for (const propertyName in object2) {
      if (object2.hasOwnProperty(propertyName)) {
        let value = object2[propertyName];
        if (deep) {
          value = clone(value, deep);
        }
        result[propertyName] = value;
      }
    }
    return result;
  }
  var clone_default = clone;

  // Source/Core/ComponentDatatype.js
  var ComponentDatatype = {
    BYTE: WebGLConstants_default.BYTE,
    UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
    SHORT: WebGLConstants_default.SHORT,
    UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
    INT: WebGLConstants_default.INT,
    UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT,
    FLOAT: WebGLConstants_default.FLOAT,
    DOUBLE: WebGLConstants_default.DOUBLE
  };
  ComponentDatatype.getSizeInBytes = function(componentDatatype) {
    if (!defined_default(componentDatatype)) {
      throw new DeveloperError_default("value is required.");
    }
    switch (componentDatatype) {
      case ComponentDatatype.BYTE:
        return Int8Array.BYTES_PER_ELEMENT;
      case ComponentDatatype.UNSIGNED_BYTE:
        return Uint8Array.BYTES_PER_ELEMENT;
      case ComponentDatatype.SHORT:
        return Int16Array.BYTES_PER_ELEMENT;
      case ComponentDatatype.UNSIGNED_SHORT:
        return Uint16Array.BYTES_PER_ELEMENT;
      case ComponentDatatype.INT:
        return Int32Array.BYTES_PER_ELEMENT;
      case ComponentDatatype.UNSIGNED_INT:
        return Uint32Array.BYTES_PER_ELEMENT;
      case ComponentDatatype.FLOAT:
        return Float32Array.BYTES_PER_ELEMENT;
      case ComponentDatatype.DOUBLE:
        return Float64Array.BYTES_PER_ELEMENT;
      default:
        throw new DeveloperError_default("componentDatatype is not a valid value.");
    }
  };
  ComponentDatatype.fromTypedArray = function(array) {
    if (array instanceof Int8Array) {
      return ComponentDatatype.BYTE;
    }
    if (array instanceof Uint8Array) {
      return ComponentDatatype.UNSIGNED_BYTE;
    }
    if (array instanceof Int16Array) {
      return ComponentDatatype.SHORT;
    }
    if (array instanceof Uint16Array) {
      return ComponentDatatype.UNSIGNED_SHORT;
    }
    if (array instanceof Int32Array) {
      return ComponentDatatype.INT;
    }
    if (array instanceof Uint32Array) {
      return ComponentDatatype.UNSIGNED_INT;
    }
    if (array instanceof Float32Array) {
      return ComponentDatatype.FLOAT;
    }
    if (array instanceof Float64Array) {
      return ComponentDatatype.DOUBLE;
    }
    throw new DeveloperError_default(
      "array must be an Int8Array, Uint8Array, Int16Array, Uint16Array, Int32Array, Uint32Array, Float32Array, or Float64Array."
    );
  };
  ComponentDatatype.validate = function(componentDatatype) {
    return defined_default(componentDatatype) && (componentDatatype === ComponentDatatype.BYTE || componentDatatype === ComponentDatatype.UNSIGNED_BYTE || componentDatatype === ComponentDatatype.SHORT || componentDatatype === ComponentDatatype.UNSIGNED_SHORT || componentDatatype === ComponentDatatype.INT || componentDatatype === ComponentDatatype.UNSIGNED_INT || componentDatatype === ComponentDatatype.FLOAT || componentDatatype === ComponentDatatype.DOUBLE);
  };
  ComponentDatatype.createTypedArray = function(componentDatatype, valuesOrLength) {
    if (!defined_default(componentDatatype)) {
      throw new DeveloperError_default("componentDatatype is required.");
    }
    if (!defined_default(valuesOrLength)) {
      throw new DeveloperError_default("valuesOrLength is required.");
    }
    switch (componentDatatype) {
      case ComponentDatatype.BYTE:
        return new Int8Array(valuesOrLength);
      case ComponentDatatype.UNSIGNED_BYTE:
        return new Uint8Array(valuesOrLength);
      case ComponentDatatype.SHORT:
        return new Int16Array(valuesOrLength);
      case ComponentDatatype.UNSIGNED_SHORT:
        return new Uint16Array(valuesOrLength);
      case ComponentDatatype.INT:
        return new Int32Array(valuesOrLength);
      case ComponentDatatype.UNSIGNED_INT:
        return new Uint32Array(valuesOrLength);
      case ComponentDatatype.FLOAT:
        return new Float32Array(valuesOrLength);
      case ComponentDatatype.DOUBLE:
        return new Float64Array(valuesOrLength);
      default:
        throw new DeveloperError_default("componentDatatype is not a valid value.");
    }
  };
  ComponentDatatype.createArrayBufferView = function(componentDatatype, buffer, byteOffset, length3) {
    if (!defined_default(componentDatatype)) {
      throw new DeveloperError_default("componentDatatype is required.");
    }
    if (!defined_default(buffer)) {
      throw new DeveloperError_default("buffer is required.");
    }
    byteOffset = defaultValue_default(byteOffset, 0);
    length3 = defaultValue_default(
      length3,
      (buffer.byteLength - byteOffset) / ComponentDatatype.getSizeInBytes(componentDatatype)
    );
    switch (componentDatatype) {
      case ComponentDatatype.BYTE:
        return new Int8Array(buffer, byteOffset, length3);
      case ComponentDatatype.UNSIGNED_BYTE:
        return new Uint8Array(buffer, byteOffset, length3);
      case ComponentDatatype.SHORT:
        return new Int16Array(buffer, byteOffset, length3);
      case ComponentDatatype.UNSIGNED_SHORT:
        return new Uint16Array(buffer, byteOffset, length3);
      case ComponentDatatype.INT:
        return new Int32Array(buffer, byteOffset, length3);
      case ComponentDatatype.UNSIGNED_INT:
        return new Uint32Array(buffer, byteOffset, length3);
      case ComponentDatatype.FLOAT:
        return new Float32Array(buffer, byteOffset, length3);
      case ComponentDatatype.DOUBLE:
        return new Float64Array(buffer, byteOffset, length3);
      default:
        throw new DeveloperError_default("componentDatatype is not a valid value.");
    }
  };
  ComponentDatatype.fromName = function(name) {
    switch (name) {
      case "BYTE":
        return ComponentDatatype.BYTE;
      case "UNSIGNED_BYTE":
        return ComponentDatatype.UNSIGNED_BYTE;
      case "SHORT":
        return ComponentDatatype.SHORT;
      case "UNSIGNED_SHORT":
        return ComponentDatatype.UNSIGNED_SHORT;
      case "INT":
        return ComponentDatatype.INT;
      case "UNSIGNED_INT":
        return ComponentDatatype.UNSIGNED_INT;
      case "FLOAT":
        return ComponentDatatype.FLOAT;
      case "DOUBLE":
        return ComponentDatatype.DOUBLE;
      default:
        throw new DeveloperError_default("name is not a valid value.");
    }
  };
  var ComponentDatatype_default = Object.freeze(ComponentDatatype);

  // Source/Core/GeometryType.js
  var GeometryType = {
    NONE: 0,
    TRIANGLES: 1,
    LINES: 2,
    POLYLINES: 3
  };
  var GeometryType_default = Object.freeze(GeometryType);

  // Source/Core/Quaternion.js
  function Quaternion(x, y, z, w) {
    this.x = defaultValue_default(x, 0);
    this.y = defaultValue_default(y, 0);
    this.z = defaultValue_default(z, 0);
    this.w = defaultValue_default(w, 0);
  }
  var fromAxisAngleScratch = new Cartesian3_default();
  Quaternion.fromAxisAngle = function(axis, angle, result) {
    Check_default.typeOf.object("axis", axis);
    Check_default.typeOf.number("angle", angle);
    const halfAngle = angle / 2;
    const s = Math.sin(halfAngle);
    fromAxisAngleScratch = Cartesian3_default.normalize(axis, fromAxisAngleScratch);
    const x = fromAxisAngleScratch.x * s;
    const y = fromAxisAngleScratch.y * s;
    const z = fromAxisAngleScratch.z * s;
    const w = Math.cos(halfAngle);
    if (!defined_default(result)) {
      return new Quaternion(x, y, z, w);
    }
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  var fromRotationMatrixNext = [1, 2, 0];
  var fromRotationMatrixQuat = new Array(3);
  Quaternion.fromRotationMatrix = function(matrix, result) {
    Check_default.typeOf.object("matrix", matrix);
    let root;
    let x;
    let y;
    let z;
    let w;
    const m00 = matrix[Matrix3_default.COLUMN0ROW0];
    const m11 = matrix[Matrix3_default.COLUMN1ROW1];
    const m22 = matrix[Matrix3_default.COLUMN2ROW2];
    const trace = m00 + m11 + m22;
    if (trace > 0) {
      root = Math.sqrt(trace + 1);
      w = 0.5 * root;
      root = 0.5 / root;
      x = (matrix[Matrix3_default.COLUMN1ROW2] - matrix[Matrix3_default.COLUMN2ROW1]) * root;
      y = (matrix[Matrix3_default.COLUMN2ROW0] - matrix[Matrix3_default.COLUMN0ROW2]) * root;
      z = (matrix[Matrix3_default.COLUMN0ROW1] - matrix[Matrix3_default.COLUMN1ROW0]) * root;
    } else {
      const next = fromRotationMatrixNext;
      let i = 0;
      if (m11 > m00) {
        i = 1;
      }
      if (m22 > m00 && m22 > m11) {
        i = 2;
      }
      const j = next[i];
      const k = next[j];
      root = Math.sqrt(
        matrix[Matrix3_default.getElementIndex(i, i)] - matrix[Matrix3_default.getElementIndex(j, j)] - matrix[Matrix3_default.getElementIndex(k, k)] + 1
      );
      const quat = fromRotationMatrixQuat;
      quat[i] = 0.5 * root;
      root = 0.5 / root;
      w = (matrix[Matrix3_default.getElementIndex(k, j)] - matrix[Matrix3_default.getElementIndex(j, k)]) * root;
      quat[j] = (matrix[Matrix3_default.getElementIndex(j, i)] + matrix[Matrix3_default.getElementIndex(i, j)]) * root;
      quat[k] = (matrix[Matrix3_default.getElementIndex(k, i)] + matrix[Matrix3_default.getElementIndex(i, k)]) * root;
      x = -quat[0];
      y = -quat[1];
      z = -quat[2];
    }
    if (!defined_default(result)) {
      return new Quaternion(x, y, z, w);
    }
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  var scratchHPRQuaternion = new Quaternion();
  var scratchHeadingQuaternion = new Quaternion();
  var scratchPitchQuaternion = new Quaternion();
  var scratchRollQuaternion = new Quaternion();
  Quaternion.fromHeadingPitchRoll = function(headingPitchRoll, result) {
    Check_default.typeOf.object("headingPitchRoll", headingPitchRoll);
    scratchRollQuaternion = Quaternion.fromAxisAngle(
      Cartesian3_default.UNIT_X,
      headingPitchRoll.roll,
      scratchHPRQuaternion
    );
    scratchPitchQuaternion = Quaternion.fromAxisAngle(
      Cartesian3_default.UNIT_Y,
      -headingPitchRoll.pitch,
      result
    );
    result = Quaternion.multiply(
      scratchPitchQuaternion,
      scratchRollQuaternion,
      scratchPitchQuaternion
    );
    scratchHeadingQuaternion = Quaternion.fromAxisAngle(
      Cartesian3_default.UNIT_Z,
      -headingPitchRoll.heading,
      scratchHPRQuaternion
    );
    return Quaternion.multiply(scratchHeadingQuaternion, result, result);
  };
  var sampledQuaternionAxis = new Cartesian3_default();
  var sampledQuaternionRotation = new Cartesian3_default();
  var sampledQuaternionTempQuaternion = new Quaternion();
  var sampledQuaternionQuaternion0 = new Quaternion();
  var sampledQuaternionQuaternion0Conjugate = new Quaternion();
  Quaternion.packedLength = 4;
  Quaternion.pack = function(value, array, startingIndex) {
    Check_default.typeOf.object("value", value);
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    array[startingIndex++] = value.x;
    array[startingIndex++] = value.y;
    array[startingIndex++] = value.z;
    array[startingIndex] = value.w;
    return array;
  };
  Quaternion.unpack = function(array, startingIndex, result) {
    Check_default.defined("array", array);
    startingIndex = defaultValue_default(startingIndex, 0);
    if (!defined_default(result)) {
      result = new Quaternion();
    }
    result.x = array[startingIndex];
    result.y = array[startingIndex + 1];
    result.z = array[startingIndex + 2];
    result.w = array[startingIndex + 3];
    return result;
  };
  Quaternion.packedInterpolationLength = 3;
  Quaternion.convertPackedArrayForInterpolation = function(packedArray, startingIndex, lastIndex, result) {
    Quaternion.unpack(
      packedArray,
      lastIndex * 4,
      sampledQuaternionQuaternion0Conjugate
    );
    Quaternion.conjugate(
      sampledQuaternionQuaternion0Conjugate,
      sampledQuaternionQuaternion0Conjugate
    );
    for (let i = 0, len = lastIndex - startingIndex + 1; i < len; i++) {
      const offset2 = i * 3;
      Quaternion.unpack(
        packedArray,
        (startingIndex + i) * 4,
        sampledQuaternionTempQuaternion
      );
      Quaternion.multiply(
        sampledQuaternionTempQuaternion,
        sampledQuaternionQuaternion0Conjugate,
        sampledQuaternionTempQuaternion
      );
      if (sampledQuaternionTempQuaternion.w < 0) {
        Quaternion.negate(
          sampledQuaternionTempQuaternion,
          sampledQuaternionTempQuaternion
        );
      }
      Quaternion.computeAxis(
        sampledQuaternionTempQuaternion,
        sampledQuaternionAxis
      );
      const angle = Quaternion.computeAngle(sampledQuaternionTempQuaternion);
      if (!defined_default(result)) {
        result = [];
      }
      result[offset2] = sampledQuaternionAxis.x * angle;
      result[offset2 + 1] = sampledQuaternionAxis.y * angle;
      result[offset2 + 2] = sampledQuaternionAxis.z * angle;
    }
  };
  Quaternion.unpackInterpolationResult = function(array, sourceArray, firstIndex, lastIndex, result) {
    if (!defined_default(result)) {
      result = new Quaternion();
    }
    Cartesian3_default.fromArray(array, 0, sampledQuaternionRotation);
    const magnitude = Cartesian3_default.magnitude(sampledQuaternionRotation);
    Quaternion.unpack(sourceArray, lastIndex * 4, sampledQuaternionQuaternion0);
    if (magnitude === 0) {
      Quaternion.clone(Quaternion.IDENTITY, sampledQuaternionTempQuaternion);
    } else {
      Quaternion.fromAxisAngle(
        sampledQuaternionRotation,
        magnitude,
        sampledQuaternionTempQuaternion
      );
    }
    return Quaternion.multiply(
      sampledQuaternionTempQuaternion,
      sampledQuaternionQuaternion0,
      result
    );
  };
  Quaternion.clone = function(quaternion, result) {
    if (!defined_default(quaternion)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new Quaternion(
        quaternion.x,
        quaternion.y,
        quaternion.z,
        quaternion.w
      );
    }
    result.x = quaternion.x;
    result.y = quaternion.y;
    result.z = quaternion.z;
    result.w = quaternion.w;
    return result;
  };
  Quaternion.conjugate = function(quaternion, result) {
    Check_default.typeOf.object("quaternion", quaternion);
    Check_default.typeOf.object("result", result);
    result.x = -quaternion.x;
    result.y = -quaternion.y;
    result.z = -quaternion.z;
    result.w = quaternion.w;
    return result;
  };
  Quaternion.magnitudeSquared = function(quaternion) {
    Check_default.typeOf.object("quaternion", quaternion);
    return quaternion.x * quaternion.x + quaternion.y * quaternion.y + quaternion.z * quaternion.z + quaternion.w * quaternion.w;
  };
  Quaternion.magnitude = function(quaternion) {
    return Math.sqrt(Quaternion.magnitudeSquared(quaternion));
  };
  Quaternion.normalize = function(quaternion, result) {
    Check_default.typeOf.object("result", result);
    const inverseMagnitude = 1 / Quaternion.magnitude(quaternion);
    const x = quaternion.x * inverseMagnitude;
    const y = quaternion.y * inverseMagnitude;
    const z = quaternion.z * inverseMagnitude;
    const w = quaternion.w * inverseMagnitude;
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  Quaternion.inverse = function(quaternion, result) {
    Check_default.typeOf.object("result", result);
    const magnitudeSquared = Quaternion.magnitudeSquared(quaternion);
    result = Quaternion.conjugate(quaternion, result);
    return Quaternion.multiplyByScalar(result, 1 / magnitudeSquared, result);
  };
  Quaternion.add = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x + right.x;
    result.y = left.y + right.y;
    result.z = left.z + right.z;
    result.w = left.w + right.w;
    return result;
  };
  Quaternion.subtract = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    result.x = left.x - right.x;
    result.y = left.y - right.y;
    result.z = left.z - right.z;
    result.w = left.w - right.w;
    return result;
  };
  Quaternion.negate = function(quaternion, result) {
    Check_default.typeOf.object("quaternion", quaternion);
    Check_default.typeOf.object("result", result);
    result.x = -quaternion.x;
    result.y = -quaternion.y;
    result.z = -quaternion.z;
    result.w = -quaternion.w;
    return result;
  };
  Quaternion.dot = function(left, right) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
  };
  Quaternion.multiply = function(left, right, result) {
    Check_default.typeOf.object("left", left);
    Check_default.typeOf.object("right", right);
    Check_default.typeOf.object("result", result);
    const leftX = left.x;
    const leftY = left.y;
    const leftZ = left.z;
    const leftW = left.w;
    const rightX = right.x;
    const rightY = right.y;
    const rightZ = right.z;
    const rightW = right.w;
    const x = leftW * rightX + leftX * rightW + leftY * rightZ - leftZ * rightY;
    const y = leftW * rightY - leftX * rightZ + leftY * rightW + leftZ * rightX;
    const z = leftW * rightZ + leftX * rightY - leftY * rightX + leftZ * rightW;
    const w = leftW * rightW - leftX * rightX - leftY * rightY - leftZ * rightZ;
    result.x = x;
    result.y = y;
    result.z = z;
    result.w = w;
    return result;
  };
  Quaternion.multiplyByScalar = function(quaternion, scalar, result) {
    Check_default.typeOf.object("quaternion", quaternion);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.x = quaternion.x * scalar;
    result.y = quaternion.y * scalar;
    result.z = quaternion.z * scalar;
    result.w = quaternion.w * scalar;
    return result;
  };
  Quaternion.divideByScalar = function(quaternion, scalar, result) {
    Check_default.typeOf.object("quaternion", quaternion);
    Check_default.typeOf.number("scalar", scalar);
    Check_default.typeOf.object("result", result);
    result.x = quaternion.x / scalar;
    result.y = quaternion.y / scalar;
    result.z = quaternion.z / scalar;
    result.w = quaternion.w / scalar;
    return result;
  };
  Quaternion.computeAxis = function(quaternion, result) {
    Check_default.typeOf.object("quaternion", quaternion);
    Check_default.typeOf.object("result", result);
    const w = quaternion.w;
    if (Math.abs(w - 1) < Math_default.EPSILON6) {
      result.x = result.y = result.z = 0;
      return result;
    }
    const scalar = 1 / Math.sqrt(1 - w * w);
    result.x = quaternion.x * scalar;
    result.y = quaternion.y * scalar;
    result.z = quaternion.z * scalar;
    return result;
  };
  Quaternion.computeAngle = function(quaternion) {
    Check_default.typeOf.object("quaternion", quaternion);
    if (Math.abs(quaternion.w - 1) < Math_default.EPSILON6) {
      return 0;
    }
    return 2 * Math.acos(quaternion.w);
  };
  var lerpScratch4 = new Quaternion();
  Quaternion.lerp = function(start, end, t, result) {
    Check_default.typeOf.object("start", start);
    Check_default.typeOf.object("end", end);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    lerpScratch4 = Quaternion.multiplyByScalar(end, t, lerpScratch4);
    result = Quaternion.multiplyByScalar(start, 1 - t, result);
    return Quaternion.add(lerpScratch4, result, result);
  };
  var slerpEndNegated = new Quaternion();
  var slerpScaledP = new Quaternion();
  var slerpScaledR = new Quaternion();
  Quaternion.slerp = function(start, end, t, result) {
    Check_default.typeOf.object("start", start);
    Check_default.typeOf.object("end", end);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    let dot2 = Quaternion.dot(start, end);
    let r = end;
    if (dot2 < 0) {
      dot2 = -dot2;
      r = slerpEndNegated = Quaternion.negate(end, slerpEndNegated);
    }
    if (1 - dot2 < Math_default.EPSILON6) {
      return Quaternion.lerp(start, r, t, result);
    }
    const theta = Math.acos(dot2);
    slerpScaledP = Quaternion.multiplyByScalar(
      start,
      Math.sin((1 - t) * theta),
      slerpScaledP
    );
    slerpScaledR = Quaternion.multiplyByScalar(
      r,
      Math.sin(t * theta),
      slerpScaledR
    );
    result = Quaternion.add(slerpScaledP, slerpScaledR, result);
    return Quaternion.multiplyByScalar(result, 1 / Math.sin(theta), result);
  };
  Quaternion.log = function(quaternion, result) {
    Check_default.typeOf.object("quaternion", quaternion);
    Check_default.typeOf.object("result", result);
    const theta = Math_default.acosClamped(quaternion.w);
    let thetaOverSinTheta = 0;
    if (theta !== 0) {
      thetaOverSinTheta = theta / Math.sin(theta);
    }
    return Cartesian3_default.multiplyByScalar(quaternion, thetaOverSinTheta, result);
  };
  Quaternion.exp = function(cartesian11, result) {
    Check_default.typeOf.object("cartesian", cartesian11);
    Check_default.typeOf.object("result", result);
    const theta = Cartesian3_default.magnitude(cartesian11);
    let sinThetaOverTheta = 0;
    if (theta !== 0) {
      sinThetaOverTheta = Math.sin(theta) / theta;
    }
    result.x = cartesian11.x * sinThetaOverTheta;
    result.y = cartesian11.y * sinThetaOverTheta;
    result.z = cartesian11.z * sinThetaOverTheta;
    result.w = Math.cos(theta);
    return result;
  };
  var squadScratchCartesian0 = new Cartesian3_default();
  var squadScratchCartesian1 = new Cartesian3_default();
  var squadScratchQuaternion0 = new Quaternion();
  var squadScratchQuaternion1 = new Quaternion();
  Quaternion.computeInnerQuadrangle = function(q0, q12, q22, result) {
    Check_default.typeOf.object("q0", q0);
    Check_default.typeOf.object("q1", q12);
    Check_default.typeOf.object("q2", q22);
    Check_default.typeOf.object("result", result);
    const qInv = Quaternion.conjugate(q12, squadScratchQuaternion0);
    Quaternion.multiply(qInv, q22, squadScratchQuaternion1);
    const cart0 = Quaternion.log(squadScratchQuaternion1, squadScratchCartesian0);
    Quaternion.multiply(qInv, q0, squadScratchQuaternion1);
    const cart1 = Quaternion.log(squadScratchQuaternion1, squadScratchCartesian1);
    Cartesian3_default.add(cart0, cart1, cart0);
    Cartesian3_default.multiplyByScalar(cart0, 0.25, cart0);
    Cartesian3_default.negate(cart0, cart0);
    Quaternion.exp(cart0, squadScratchQuaternion0);
    return Quaternion.multiply(q12, squadScratchQuaternion0, result);
  };
  Quaternion.squad = function(q0, q12, s0, s1, t, result) {
    Check_default.typeOf.object("q0", q0);
    Check_default.typeOf.object("q1", q12);
    Check_default.typeOf.object("s0", s0);
    Check_default.typeOf.object("s1", s1);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    const slerp0 = Quaternion.slerp(q0, q12, t, squadScratchQuaternion0);
    const slerp1 = Quaternion.slerp(s0, s1, t, squadScratchQuaternion1);
    return Quaternion.slerp(slerp0, slerp1, 2 * t * (1 - t), result);
  };
  var fastSlerpScratchQuaternion = new Quaternion();
  var opmu = 1.9011074535173003;
  var u = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
  var v = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
  var bT = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
  var bD = FeatureDetection_default.supportsTypedArrays() ? new Float32Array(8) : [];
  for (let i = 0; i < 7; ++i) {
    const s = i + 1;
    const t = 2 * s + 1;
    u[i] = 1 / (s * t);
    v[i] = s / t;
  }
  u[7] = opmu / (8 * 17);
  v[7] = opmu * 8 / 17;
  Quaternion.fastSlerp = function(start, end, t, result) {
    Check_default.typeOf.object("start", start);
    Check_default.typeOf.object("end", end);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    let x = Quaternion.dot(start, end);
    let sign2;
    if (x >= 0) {
      sign2 = 1;
    } else {
      sign2 = -1;
      x = -x;
    }
    const xm1 = x - 1;
    const d = 1 - t;
    const sqrT = t * t;
    const sqrD = d * d;
    for (let i = 7; i >= 0; --i) {
      bT[i] = (u[i] * sqrT - v[i]) * xm1;
      bD[i] = (u[i] * sqrD - v[i]) * xm1;
    }
    const cT = sign2 * t * (1 + bT[0] * (1 + bT[1] * (1 + bT[2] * (1 + bT[3] * (1 + bT[4] * (1 + bT[5] * (1 + bT[6] * (1 + bT[7]))))))));
    const cD = d * (1 + bD[0] * (1 + bD[1] * (1 + bD[2] * (1 + bD[3] * (1 + bD[4] * (1 + bD[5] * (1 + bD[6] * (1 + bD[7]))))))));
    const temp = Quaternion.multiplyByScalar(
      start,
      cD,
      fastSlerpScratchQuaternion
    );
    Quaternion.multiplyByScalar(end, cT, result);
    return Quaternion.add(temp, result, result);
  };
  Quaternion.fastSquad = function(q0, q12, s0, s1, t, result) {
    Check_default.typeOf.object("q0", q0);
    Check_default.typeOf.object("q1", q12);
    Check_default.typeOf.object("s0", s0);
    Check_default.typeOf.object("s1", s1);
    Check_default.typeOf.number("t", t);
    Check_default.typeOf.object("result", result);
    const slerp0 = Quaternion.fastSlerp(q0, q12, t, squadScratchQuaternion0);
    const slerp1 = Quaternion.fastSlerp(s0, s1, t, squadScratchQuaternion1);
    return Quaternion.fastSlerp(slerp0, slerp1, 2 * t * (1 - t), result);
  };
  Quaternion.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z && left.w === right.w;
  };
  Quaternion.equalsEpsilon = function(left, right, epsilon) {
    epsilon = defaultValue_default(epsilon, 0);
    return left === right || defined_default(left) && defined_default(right) && Math.abs(left.x - right.x) <= epsilon && Math.abs(left.y - right.y) <= epsilon && Math.abs(left.z - right.z) <= epsilon && Math.abs(left.w - right.w) <= epsilon;
  };
  Quaternion.ZERO = Object.freeze(new Quaternion(0, 0, 0, 0));
  Quaternion.IDENTITY = Object.freeze(new Quaternion(0, 0, 0, 1));
  Quaternion.prototype.clone = function(result) {
    return Quaternion.clone(this, result);
  };
  Quaternion.prototype.equals = function(right) {
    return Quaternion.equals(this, right);
  };
  Quaternion.prototype.equalsEpsilon = function(right, epsilon) {
    return Quaternion.equalsEpsilon(this, right, epsilon);
  };
  Quaternion.prototype.toString = function() {
    return `(${this.x}, ${this.y}, ${this.z}, ${this.w})`;
  };
  var Quaternion_default = Quaternion;

  // Source/Core/binarySearch.js
  function binarySearch(array, itemToFind, comparator) {
    Check_default.defined("array", array);
    Check_default.defined("itemToFind", itemToFind);
    Check_default.defined("comparator", comparator);
    let low = 0;
    let high = array.length - 1;
    let i;
    let comparison;
    while (low <= high) {
      i = ~~((low + high) / 2);
      comparison = comparator(array[i], itemToFind);
      if (comparison < 0) {
        low = i + 1;
        continue;
      }
      if (comparison > 0) {
        high = i - 1;
        continue;
      }
      return i;
    }
    return ~(high + 1);
  }
  var binarySearch_default = binarySearch;

  // Source/Core/EarthOrientationParametersSample.js
  function EarthOrientationParametersSample(xPoleWander, yPoleWander, xPoleOffset, yPoleOffset, ut1MinusUtc) {
    this.xPoleWander = xPoleWander;
    this.yPoleWander = yPoleWander;
    this.xPoleOffset = xPoleOffset;
    this.yPoleOffset = yPoleOffset;
    this.ut1MinusUtc = ut1MinusUtc;
  }
  var EarthOrientationParametersSample_default = EarthOrientationParametersSample;

  // Source/Core/GregorianDate.js
  function GregorianDate(year, month, day, hour, minute, second, millisecond, isLeapSecond) {
    this.year = year;
    this.month = month;
    this.day = day;
    this.hour = hour;
    this.minute = minute;
    this.second = second;
    this.millisecond = millisecond;
    this.isLeapSecond = isLeapSecond;
  }
  var GregorianDate_default = GregorianDate;

  // Source/Core/isLeapYear.js
  function isLeapYear(year) {
    if (year === null || isNaN(year)) {
      throw new DeveloperError_default("year is required and must be a number.");
    }
    return year % 4 === 0 && year % 100 !== 0 || year % 400 === 0;
  }
  var isLeapYear_default = isLeapYear;

  // Source/Core/LeapSecond.js
  function LeapSecond(date, offset2) {
    this.julianDate = date;
    this.offset = offset2;
  }
  var LeapSecond_default = LeapSecond;

  // Source/Core/TimeConstants.js
  var TimeConstants = {
    SECONDS_PER_MILLISECOND: 1e-3,
    SECONDS_PER_MINUTE: 60,
    MINUTES_PER_HOUR: 60,
    HOURS_PER_DAY: 24,
    SECONDS_PER_HOUR: 3600,
    MINUTES_PER_DAY: 1440,
    SECONDS_PER_DAY: 86400,
    DAYS_PER_JULIAN_CENTURY: 36525,
    PICOSECOND: 1e-9,
    MODIFIED_JULIAN_DATE_DIFFERENCE: 24000005e-1
  };
  var TimeConstants_default = Object.freeze(TimeConstants);

  // Source/Core/TimeStandard.js
  var TimeStandard = {
    UTC: 0,
    TAI: 1
  };
  var TimeStandard_default = Object.freeze(TimeStandard);

  // Source/Core/JulianDate.js
  var gregorianDateScratch = new GregorianDate_default();
  var daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
  var daysInLeapFeburary = 29;
  function compareLeapSecondDates(leapSecond, dateToFind) {
    return JulianDate.compare(leapSecond.julianDate, dateToFind.julianDate);
  }
  var binarySearchScratchLeapSecond = new LeapSecond_default();
  function convertUtcToTai(julianDate) {
    binarySearchScratchLeapSecond.julianDate = julianDate;
    const leapSeconds = JulianDate.leapSeconds;
    let index = binarySearch_default(
      leapSeconds,
      binarySearchScratchLeapSecond,
      compareLeapSecondDates
    );
    if (index < 0) {
      index = ~index;
    }
    if (index >= leapSeconds.length) {
      index = leapSeconds.length - 1;
    }
    let offset2 = leapSeconds[index].offset;
    if (index > 0) {
      const difference = JulianDate.secondsDifference(
        leapSeconds[index].julianDate,
        julianDate
      );
      if (difference > offset2) {
        index--;
        offset2 = leapSeconds[index].offset;
      }
    }
    JulianDate.addSeconds(julianDate, offset2, julianDate);
  }
  function convertTaiToUtc(julianDate, result) {
    binarySearchScratchLeapSecond.julianDate = julianDate;
    const leapSeconds = JulianDate.leapSeconds;
    let index = binarySearch_default(
      leapSeconds,
      binarySearchScratchLeapSecond,
      compareLeapSecondDates
    );
    if (index < 0) {
      index = ~index;
    }
    if (index === 0) {
      return JulianDate.addSeconds(julianDate, -leapSeconds[0].offset, result);
    }
    if (index >= leapSeconds.length) {
      return JulianDate.addSeconds(
        julianDate,
        -leapSeconds[index - 1].offset,
        result
      );
    }
    const difference = JulianDate.secondsDifference(
      leapSeconds[index].julianDate,
      julianDate
    );
    if (difference === 0) {
      return JulianDate.addSeconds(
        julianDate,
        -leapSeconds[index].offset,
        result
      );
    }
    if (difference <= 1) {
      return void 0;
    }
    return JulianDate.addSeconds(
      julianDate,
      -leapSeconds[--index].offset,
      result
    );
  }
  function setComponents(wholeDays, secondsOfDay, julianDate) {
    const extraDays = secondsOfDay / TimeConstants_default.SECONDS_PER_DAY | 0;
    wholeDays += extraDays;
    secondsOfDay -= TimeConstants_default.SECONDS_PER_DAY * extraDays;
    if (secondsOfDay < 0) {
      wholeDays--;
      secondsOfDay += TimeConstants_default.SECONDS_PER_DAY;
    }
    julianDate.dayNumber = wholeDays;
    julianDate.secondsOfDay = secondsOfDay;
    return julianDate;
  }
  function computeJulianDateComponents(year, month, day, hour, minute, second, millisecond) {
    const a3 = (month - 14) / 12 | 0;
    const b = year + 4800 + a3;
    let dayNumber = (1461 * b / 4 | 0) + (367 * (month - 2 - 12 * a3) / 12 | 0) - (3 * ((b + 100) / 100 | 0) / 4 | 0) + day - 32075;
    hour = hour - 12;
    if (hour < 0) {
      hour += 24;
    }
    const secondsOfDay = second + (hour * TimeConstants_default.SECONDS_PER_HOUR + minute * TimeConstants_default.SECONDS_PER_MINUTE + millisecond * TimeConstants_default.SECONDS_PER_MILLISECOND);
    if (secondsOfDay >= 43200) {
      dayNumber -= 1;
    }
    return [dayNumber, secondsOfDay];
  }
  var matchCalendarYear = /^(\d{4})$/;
  var matchCalendarMonth = /^(\d{4})-(\d{2})$/;
  var matchOrdinalDate = /^(\d{4})-?(\d{3})$/;
  var matchWeekDate = /^(\d{4})-?W(\d{2})-?(\d{1})?$/;
  var matchCalendarDate = /^(\d{4})-?(\d{2})-?(\d{2})$/;
  var utcOffset = /([Z+\-])?(\d{2})?:?(\d{2})?$/;
  var matchHours = /^(\d{2})(\.\d+)?/.source + utcOffset.source;
  var matchHoursMinutes = /^(\d{2}):?(\d{2})(\.\d+)?/.source + utcOffset.source;
  var matchHoursMinutesSeconds = /^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source + utcOffset.source;
  var iso8601ErrorMessage = "Invalid ISO 8601 date.";
  function JulianDate(julianDayNumber, secondsOfDay, timeStandard) {
    this.dayNumber = void 0;
    this.secondsOfDay = void 0;
    julianDayNumber = defaultValue_default(julianDayNumber, 0);
    secondsOfDay = defaultValue_default(secondsOfDay, 0);
    timeStandard = defaultValue_default(timeStandard, TimeStandard_default.UTC);
    const wholeDays = julianDayNumber | 0;
    secondsOfDay = secondsOfDay + (julianDayNumber - wholeDays) * TimeConstants_default.SECONDS_PER_DAY;
    setComponents(wholeDays, secondsOfDay, this);
    if (timeStandard === TimeStandard_default.UTC) {
      convertUtcToTai(this);
    }
  }
  JulianDate.fromGregorianDate = function(date, result) {
    if (!(date instanceof GregorianDate_default)) {
      throw new DeveloperError_default("date must be a valid GregorianDate.");
    }
    const components = computeJulianDateComponents(
      date.year,
      date.month,
      date.day,
      date.hour,
      date.minute,
      date.second,
      date.millisecond
    );
    if (!defined_default(result)) {
      return new JulianDate(components[0], components[1], TimeStandard_default.UTC);
    }
    setComponents(components[0], components[1], result);
    convertUtcToTai(result);
    return result;
  };
  JulianDate.fromDate = function(date, result) {
    if (!(date instanceof Date) || isNaN(date.getTime())) {
      throw new DeveloperError_default("date must be a valid JavaScript Date.");
    }
    const components = computeJulianDateComponents(
      date.getUTCFullYear(),
      date.getUTCMonth() + 1,
      date.getUTCDate(),
      date.getUTCHours(),
      date.getUTCMinutes(),
      date.getUTCSeconds(),
      date.getUTCMilliseconds()
    );
    if (!defined_default(result)) {
      return new JulianDate(components[0], components[1], TimeStandard_default.UTC);
    }
    setComponents(components[0], components[1], result);
    convertUtcToTai(result);
    return result;
  };
  JulianDate.fromIso8601 = function(iso8601String, result) {
    if (typeof iso8601String !== "string") {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    iso8601String = iso8601String.replace(",", ".");
    let tokens = iso8601String.split("T");
    let year;
    let month = 1;
    let day = 1;
    let hour = 0;
    let minute = 0;
    let second = 0;
    let millisecond = 0;
    const date = tokens[0];
    const time = tokens[1];
    let tmp2;
    let inLeapYear;
    if (!defined_default(date)) {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    let dashCount;
    tokens = date.match(matchCalendarDate);
    if (tokens !== null) {
      dashCount = date.split("-").length - 1;
      if (dashCount > 0 && dashCount !== 2) {
        throw new DeveloperError_default(iso8601ErrorMessage);
      }
      year = +tokens[1];
      month = +tokens[2];
      day = +tokens[3];
    } else {
      tokens = date.match(matchCalendarMonth);
      if (tokens !== null) {
        year = +tokens[1];
        month = +tokens[2];
      } else {
        tokens = date.match(matchCalendarYear);
        if (tokens !== null) {
          year = +tokens[1];
        } else {
          let dayOfYear;
          tokens = date.match(matchOrdinalDate);
          if (tokens !== null) {
            year = +tokens[1];
            dayOfYear = +tokens[2];
            inLeapYear = isLeapYear_default(year);
            if (dayOfYear < 1 || inLeapYear && dayOfYear > 366 || !inLeapYear && dayOfYear > 365) {
              throw new DeveloperError_default(iso8601ErrorMessage);
            }
          } else {
            tokens = date.match(matchWeekDate);
            if (tokens !== null) {
              year = +tokens[1];
              const weekNumber = +tokens[2];
              const dayOfWeek = +tokens[3] || 0;
              dashCount = date.split("-").length - 1;
              if (dashCount > 0 && (!defined_default(tokens[3]) && dashCount !== 1 || defined_default(tokens[3]) && dashCount !== 2)) {
                throw new DeveloperError_default(iso8601ErrorMessage);
              }
              const january4 = new Date(Date.UTC(year, 0, 4));
              dayOfYear = weekNumber * 7 + dayOfWeek - january4.getUTCDay() - 3;
            } else {
              throw new DeveloperError_default(iso8601ErrorMessage);
            }
          }
          tmp2 = new Date(Date.UTC(year, 0, 1));
          tmp2.setUTCDate(dayOfYear);
          month = tmp2.getUTCMonth() + 1;
          day = tmp2.getUTCDate();
        }
      }
    }
    inLeapYear = isLeapYear_default(year);
    if (month < 1 || month > 12 || day < 1 || (month !== 2 || !inLeapYear) && day > daysInMonth[month - 1] || inLeapYear && month === 2 && day > daysInLeapFeburary) {
      throw new DeveloperError_default(iso8601ErrorMessage);
    }
    let offsetIndex;
    if (defined_default(time)) {
      tokens = time.match(matchHoursMinutesSeconds);
      if (tokens !== null) {
        dashCount = time.split(":").length - 1;
        if (dashCount > 0 && dashCount !== 2 && dashCount !== 3) {
          throw new DeveloperError_default(iso8601ErrorMessage);
        }
        hour = +tokens[1];
        minute = +tokens[2];
        second = +tokens[3];
        millisecond = +(tokens[4] || 0) * 1e3;
        offsetIndex = 5;
      } else {
        tokens = time.match(matchHoursMinutes);
        if (tokens !== null) {
          dashCount = time.split(":").length - 1;
          if (dashCount > 2) {
            throw new DeveloperError_default(iso8601ErrorMessage);
          }
          hour = +tokens[1];
          minute = +tokens[2];
          second = +(tokens[3] || 0) * 60;
          offsetIndex = 4;
        } else {
          tokens = time.match(matchHours);
          if (tokens !== null) {
            hour = +tokens[1];
            minute = +(tokens[2] || 0) * 60;
            offsetIndex = 3;
          } else {
            throw new DeveloperError_default(iso8601ErrorMessage);
          }
        }
      }
      if (minute >= 60 || second >= 61 || hour > 24 || hour === 24 && (minute > 0 || second > 0 || millisecond > 0)) {
        throw new DeveloperError_default(iso8601ErrorMessage);
      }
      const offset2 = tokens[offsetIndex];
      const offsetHours = +tokens[offsetIndex + 1];
      const offsetMinutes = +(tokens[offsetIndex + 2] || 0);
      switch (offset2) {
        case "+":
          hour = hour - offsetHours;
          minute = minute - offsetMinutes;
          break;
        case "-":
          hour = hour + offsetHours;
          minute = minute + offsetMinutes;
          break;
        case "Z":
          break;
        default:
          minute = minute + new Date(
            Date.UTC(year, month - 1, day, hour, minute)
          ).getTimezoneOffset();
          break;
      }
    }
    const isLeapSecond = second === 60;
    if (isLeapSecond) {
      second--;
    }
    while (minute >= 60) {
      minute -= 60;
      hour++;
    }
    while (hour >= 24) {
      hour -= 24;
      day++;
    }
    tmp2 = inLeapYear && month === 2 ? daysInLeapFeburary : daysInMonth[month - 1];
    while (day > tmp2) {
      day -= tmp2;
      month++;
      if (month > 12) {
        month -= 12;
        year++;
      }
      tmp2 = inLeapYear && month === 2 ? daysInLeapFeburary : daysInMonth[month - 1];
    }
    while (minute < 0) {
      minute += 60;
      hour--;
    }
    while (hour < 0) {
      hour += 24;
      day--;
    }
    while (day < 1) {
      month--;
      if (month < 1) {
        month += 12;
        year--;
      }
      tmp2 = inLeapYear && month === 2 ? daysInLeapFeburary : daysInMonth[month - 1];
      day += tmp2;
    }
    const components = computeJulianDateComponents(
      year,
      month,
      day,
      hour,
      minute,
      second,
      millisecond
    );
    if (!defined_default(result)) {
      result = new JulianDate(components[0], components[1], TimeStandard_default.UTC);
    } else {
      setComponents(components[0], components[1], result);
      convertUtcToTai(result);
    }
    if (isLeapSecond) {
      JulianDate.addSeconds(result, 1, result);
    }
    return result;
  };
  JulianDate.now = function(result) {
    return JulianDate.fromDate(new Date(), result);
  };
  var toGregorianDateScratch = new JulianDate(0, 0, TimeStandard_default.TAI);
  JulianDate.toGregorianDate = function(julianDate, result) {
    if (!defined_default(julianDate)) {
      throw new DeveloperError_default("julianDate is required.");
    }
    let isLeapSecond = false;
    let thisUtc = convertTaiToUtc(julianDate, toGregorianDateScratch);
    if (!defined_default(thisUtc)) {
      JulianDate.addSeconds(julianDate, -1, toGregorianDateScratch);
      thisUtc = convertTaiToUtc(toGregorianDateScratch, toGregorianDateScratch);
      isLeapSecond = true;
    }
    let julianDayNumber = thisUtc.dayNumber;
    const secondsOfDay = thisUtc.secondsOfDay;
    if (secondsOfDay >= 43200) {
      julianDayNumber += 1;
    }
    let L = julianDayNumber + 68569 | 0;
    const N = 4 * L / 146097 | 0;
    L = L - ((146097 * N + 3) / 4 | 0) | 0;
    const I = 4e3 * (L + 1) / 1461001 | 0;
    L = L - (1461 * I / 4 | 0) + 31 | 0;
    const J = 80 * L / 2447 | 0;
    const day = L - (2447 * J / 80 | 0) | 0;
    L = J / 11 | 0;
    const month = J + 2 - 12 * L | 0;
    const year = 100 * (N - 49) + I + L | 0;
    let hour = secondsOfDay / TimeConstants_default.SECONDS_PER_HOUR | 0;
    let remainingSeconds = secondsOfDay - hour * TimeConstants_default.SECONDS_PER_HOUR;
    const minute = remainingSeconds / TimeConstants_default.SECONDS_PER_MINUTE | 0;
    remainingSeconds = remainingSeconds - minute * TimeConstants_default.SECONDS_PER_MINUTE;
    let second = remainingSeconds | 0;
    const millisecond = (remainingSeconds - second) / TimeConstants_default.SECONDS_PER_MILLISECOND;
    hour += 12;
    if (hour > 23) {
      hour -= 24;
    }
    if (isLeapSecond) {
      second += 1;
    }
    if (!defined_default(result)) {
      return new GregorianDate_default(
        year,
        month,
        day,
        hour,
        minute,
        second,
        millisecond,
        isLeapSecond
      );
    }
    result.year = year;
    result.month = month;
    result.day = day;
    result.hour = hour;
    result.minute = minute;
    result.second = second;
    result.millisecond = millisecond;
    result.isLeapSecond = isLeapSecond;
    return result;
  };
  JulianDate.toDate = function(julianDate) {
    if (!defined_default(julianDate)) {
      throw new DeveloperError_default("julianDate is required.");
    }
    const gDate = JulianDate.toGregorianDate(julianDate, gregorianDateScratch);
    let second = gDate.second;
    if (gDate.isLeapSecond) {
      second -= 1;
    }
    return new Date(
      Date.UTC(
        gDate.year,
        gDate.month - 1,
        gDate.day,
        gDate.hour,
        gDate.minute,
        second,
        gDate.millisecond
      )
    );
  };
  JulianDate.toIso8601 = function(julianDate, precision) {
    if (!defined_default(julianDate)) {
      throw new DeveloperError_default("julianDate is required.");
    }
    const gDate = JulianDate.toGregorianDate(julianDate, gregorianDateScratch);
    let year = gDate.year;
    let month = gDate.month;
    let day = gDate.day;
    let hour = gDate.hour;
    const minute = gDate.minute;
    const second = gDate.second;
    const millisecond = gDate.millisecond;
    if (year === 1e4 && month === 1 && day === 1 && hour === 0 && minute === 0 && second === 0 && millisecond === 0) {
      year = 9999;
      month = 12;
      day = 31;
      hour = 24;
    }
    let millisecondStr;
    if (!defined_default(precision) && millisecond !== 0) {
      millisecondStr = (millisecond * 0.01).toString().replace(".", "");
      return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}.${millisecondStr}Z`;
    }
    if (!defined_default(precision) || precision === 0) {
      return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}Z`;
    }
    millisecondStr = (millisecond * 0.01).toFixed(precision).replace(".", "").slice(0, precision);
    return `${year.toString().padStart(4, "0")}-${month.toString().padStart(2, "0")}-${day.toString().padStart(2, "0")}T${hour.toString().padStart(2, "0")}:${minute.toString().padStart(2, "0")}:${second.toString().padStart(2, "0")}.${millisecondStr}Z`;
  };
  JulianDate.clone = function(julianDate, result) {
    if (!defined_default(julianDate)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new JulianDate(
        julianDate.dayNumber,
        julianDate.secondsOfDay,
        TimeStandard_default.TAI
      );
    }
    result.dayNumber = julianDate.dayNumber;
    result.secondsOfDay = julianDate.secondsOfDay;
    return result;
  };
  JulianDate.compare = function(left, right) {
    if (!defined_default(left)) {
      throw new DeveloperError_default("left is required.");
    }
    if (!defined_default(right)) {
      throw new DeveloperError_default("right is required.");
    }
    const julianDayNumberDifference = left.dayNumber - right.dayNumber;
    if (julianDayNumberDifference !== 0) {
      return julianDayNumberDifference;
    }
    return left.secondsOfDay - right.secondsOfDay;
  };
  JulianDate.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.dayNumber === right.dayNumber && left.secondsOfDay === right.secondsOfDay;
  };
  JulianDate.equalsEpsilon = function(left, right, epsilon) {
    epsilon = defaultValue_default(epsilon, 0);
    return left === right || defined_default(left) && defined_default(right) && Math.abs(JulianDate.secondsDifference(left, right)) <= epsilon;
  };
  JulianDate.totalDays = function(julianDate) {
    if (!defined_default(julianDate)) {
      throw new DeveloperError_default("julianDate is required.");
    }
    return julianDate.dayNumber + julianDate.secondsOfDay / TimeConstants_default.SECONDS_PER_DAY;
  };
  JulianDate.secondsDifference = function(left, right) {
    if (!defined_default(left)) {
      throw new DeveloperError_default("left is required.");
    }
    if (!defined_default(right)) {
      throw new DeveloperError_default("right is required.");
    }
    const dayDifference = (left.dayNumber - right.dayNumber) * TimeConstants_default.SECONDS_PER_DAY;
    return dayDifference + (left.secondsOfDay - right.secondsOfDay);
  };
  JulianDate.daysDifference = function(left, right) {
    if (!defined_default(left)) {
      throw new DeveloperError_default("left is required.");
    }
    if (!defined_default(right)) {
      throw new DeveloperError_default("right is required.");
    }
    const dayDifference = left.dayNumber - right.dayNumber;
    const secondDifference = (left.secondsOfDay - right.secondsOfDay) / TimeConstants_default.SECONDS_PER_DAY;
    return dayDifference + secondDifference;
  };
  JulianDate.computeTaiMinusUtc = function(julianDate) {
    binarySearchScratchLeapSecond.julianDate = julianDate;
    const leapSeconds = JulianDate.leapSeconds;
    let index = binarySearch_default(
      leapSeconds,
      binarySearchScratchLeapSecond,
      compareLeapSecondDates
    );
    if (index < 0) {
      index = ~index;
      --index;
      if (index < 0) {
        index = 0;
      }
    }
    return leapSeconds[index].offset;
  };
  JulianDate.addSeconds = function(julianDate, seconds, result) {
    if (!defined_default(julianDate)) {
      throw new DeveloperError_default("julianDate is required.");
    }
    if (!defined_default(seconds)) {
      throw new DeveloperError_default("seconds is required.");
    }
    if (!defined_default(result)) {
      throw new DeveloperError_default("result is required.");
    }
    return setComponents(
      julianDate.dayNumber,
      julianDate.secondsOfDay + seconds,
      result
    );
  };
  JulianDate.addMinutes = function(julianDate, minutes, result) {
    if (!defined_default(julianDate)) {
      throw new DeveloperError_default("julianDate is required.");
    }
    if (!defined_default(minutes)) {
      throw new DeveloperError_default("minutes is required.");
    }
    if (!defined_default(result)) {
      throw new DeveloperError_default("result is required.");
    }
    const newSecondsOfDay = julianDate.secondsOfDay + minutes * TimeConstants_default.SECONDS_PER_MINUTE;
    return setComponents(julianDate.dayNumber, newSecondsOfDay, result);
  };
  JulianDate.addHours = function(julianDate, hours, result) {
    if (!defined_default(julianDate)) {
      throw new DeveloperError_default("julianDate is required.");
    }
    if (!defined_default(hours)) {
      throw new DeveloperError_default("hours is required.");
    }
    if (!defined_default(result)) {
      throw new DeveloperError_default("result is required.");
    }
    const newSecondsOfDay = julianDate.secondsOfDay + hours * TimeConstants_default.SECONDS_PER_HOUR;
    return setComponents(julianDate.dayNumber, newSecondsOfDay, result);
  };
  JulianDate.addDays = function(julianDate, days, result) {
    if (!defined_default(julianDate)) {
      throw new DeveloperError_default("julianDate is required.");
    }
    if (!defined_default(days)) {
      throw new DeveloperError_default("days is required.");
    }
    if (!defined_default(result)) {
      throw new DeveloperError_default("result is required.");
    }
    const newJulianDayNumber = julianDate.dayNumber + days;
    return setComponents(newJulianDayNumber, julianDate.secondsOfDay, result);
  };
  JulianDate.lessThan = function(left, right) {
    return JulianDate.compare(left, right) < 0;
  };
  JulianDate.lessThanOrEquals = function(left, right) {
    return JulianDate.compare(left, right) <= 0;
  };
  JulianDate.greaterThan = function(left, right) {
    return JulianDate.compare(left, right) > 0;
  };
  JulianDate.greaterThanOrEquals = function(left, right) {
    return JulianDate.compare(left, right) >= 0;
  };
  JulianDate.prototype.clone = function(result) {
    return JulianDate.clone(this, result);
  };
  JulianDate.prototype.equals = function(right) {
    return JulianDate.equals(this, right);
  };
  JulianDate.prototype.equalsEpsilon = function(right, epsilon) {
    return JulianDate.equalsEpsilon(this, right, epsilon);
  };
  JulianDate.prototype.toString = function() {
    return JulianDate.toIso8601(this);
  };
  JulianDate.leapSeconds = [
    new LeapSecond_default(new JulianDate(2441317, 43210, TimeStandard_default.TAI), 10),
    new LeapSecond_default(new JulianDate(2441499, 43211, TimeStandard_default.TAI), 11),
    new LeapSecond_default(new JulianDate(2441683, 43212, TimeStandard_default.TAI), 12),
    new LeapSecond_default(new JulianDate(2442048, 43213, TimeStandard_default.TAI), 13),
    new LeapSecond_default(new JulianDate(2442413, 43214, TimeStandard_default.TAI), 14),
    new LeapSecond_default(new JulianDate(2442778, 43215, TimeStandard_default.TAI), 15),
    new LeapSecond_default(new JulianDate(2443144, 43216, TimeStandard_default.TAI), 16),
    new LeapSecond_default(new JulianDate(2443509, 43217, TimeStandard_default.TAI), 17),
    new LeapSecond_default(new JulianDate(2443874, 43218, TimeStandard_default.TAI), 18),
    new LeapSecond_default(new JulianDate(2444239, 43219, TimeStandard_default.TAI), 19),
    new LeapSecond_default(new JulianDate(2444786, 43220, TimeStandard_default.TAI), 20),
    new LeapSecond_default(new JulianDate(2445151, 43221, TimeStandard_default.TAI), 21),
    new LeapSecond_default(new JulianDate(2445516, 43222, TimeStandard_default.TAI), 22),
    new LeapSecond_default(new JulianDate(2446247, 43223, TimeStandard_default.TAI), 23),
    new LeapSecond_default(new JulianDate(2447161, 43224, TimeStandard_default.TAI), 24),
    new LeapSecond_default(new JulianDate(2447892, 43225, TimeStandard_default.TAI), 25),
    new LeapSecond_default(new JulianDate(2448257, 43226, TimeStandard_default.TAI), 26),
    new LeapSecond_default(new JulianDate(2448804, 43227, TimeStandard_default.TAI), 27),
    new LeapSecond_default(new JulianDate(2449169, 43228, TimeStandard_default.TAI), 28),
    new LeapSecond_default(new JulianDate(2449534, 43229, TimeStandard_default.TAI), 29),
    new LeapSecond_default(new JulianDate(2450083, 43230, TimeStandard_default.TAI), 30),
    new LeapSecond_default(new JulianDate(2450630, 43231, TimeStandard_default.TAI), 31),
    new LeapSecond_default(new JulianDate(2451179, 43232, TimeStandard_default.TAI), 32),
    new LeapSecond_default(new JulianDate(2453736, 43233, TimeStandard_default.TAI), 33),
    new LeapSecond_default(new JulianDate(2454832, 43234, TimeStandard_default.TAI), 34),
    new LeapSecond_default(new JulianDate(2456109, 43235, TimeStandard_default.TAI), 35),
    new LeapSecond_default(new JulianDate(2457204, 43236, TimeStandard_default.TAI), 36),
    new LeapSecond_default(new JulianDate(2457754, 43237, TimeStandard_default.TAI), 37)
  ];
  var JulianDate_default = JulianDate;

  // Source/Core/Resource.js
  var import_urijs6 = __toESM(require_URI(), 1);

  // Source/Core/appendForwardSlash.js
  function appendForwardSlash(url2) {
    if (url2.length === 0 || url2[url2.length - 1] !== "/") {
      url2 = `${url2}/`;
    }
    return url2;
  }
  var appendForwardSlash_default = appendForwardSlash;

  // Source/Core/combine.js
  function combine(object1, object2, deep) {
    deep = defaultValue_default(deep, false);
    const result = {};
    const object1Defined = defined_default(object1);
    const object2Defined = defined_default(object2);
    let property;
    let object1Value;
    let object2Value;
    if (object1Defined) {
      for (property in object1) {
        if (object1.hasOwnProperty(property)) {
          object1Value = object1[property];
          if (object2Defined && deep && typeof object1Value === "object" && object2.hasOwnProperty(property)) {
            object2Value = object2[property];
            if (typeof object2Value === "object") {
              result[property] = combine(object1Value, object2Value, deep);
            } else {
              result[property] = object1Value;
            }
          } else {
            result[property] = object1Value;
          }
        }
      }
    }
    if (object2Defined) {
      for (property in object2) {
        if (object2.hasOwnProperty(property) && !result.hasOwnProperty(property)) {
          object2Value = object2[property];
          result[property] = object2Value;
        }
      }
    }
    return result;
  }
  var combine_default = combine;

  // Source/Core/defer.js
  function defer() {
    let resolve2;
    let reject;
    const promise = new Promise(function(res, rej) {
      resolve2 = res;
      reject = rej;
    });
    return {
      resolve: resolve2,
      reject,
      promise
    };
  }
  var defer_default = defer;

  // Source/Core/getAbsoluteUri.js
  var import_urijs = __toESM(require_URI(), 1);
  function getAbsoluteUri(relative, base) {
    let documentObject;
    if (typeof document !== "undefined") {
      documentObject = document;
    }
    return getAbsoluteUri._implementation(relative, base, documentObject);
  }
  getAbsoluteUri._implementation = function(relative, base, documentObject) {
    if (!defined_default(relative)) {
      throw new DeveloperError_default("relative uri is required.");
    }
    if (!defined_default(base)) {
      if (typeof documentObject === "undefined") {
        return relative;
      }
      base = defaultValue_default(documentObject.baseURI, documentObject.location.href);
    }
    const relativeUri = new import_urijs.default(relative);
    if (relativeUri.scheme() !== "") {
      return relativeUri.toString();
    }
    return relativeUri.absoluteTo(base).toString();
  };
  var getAbsoluteUri_default = getAbsoluteUri;

  // Source/Core/getBaseUri.js
  var import_urijs2 = __toESM(require_URI(), 1);
  function getBaseUri(uri, includeQuery) {
    if (!defined_default(uri)) {
      throw new DeveloperError_default("uri is required.");
    }
    let basePath = "";
    const i = uri.lastIndexOf("/");
    if (i !== -1) {
      basePath = uri.substring(0, i + 1);
    }
    if (!includeQuery) {
      return basePath;
    }
    uri = new import_urijs2.default(uri);
    if (uri.query().length !== 0) {
      basePath += `?${uri.query()}`;
    }
    if (uri.fragment().length !== 0) {
      basePath += `#${uri.fragment()}`;
    }
    return basePath;
  }
  var getBaseUri_default = getBaseUri;

  // Source/Core/getExtensionFromUri.js
  var import_urijs3 = __toESM(require_URI(), 1);
  function getExtensionFromUri(uri) {
    if (!defined_default(uri)) {
      throw new DeveloperError_default("uri is required.");
    }
    const uriObject = new import_urijs3.default(uri);
    uriObject.normalize();
    let path = uriObject.path();
    let index = path.lastIndexOf("/");
    if (index !== -1) {
      path = path.substr(index + 1);
    }
    index = path.lastIndexOf(".");
    if (index === -1) {
      path = "";
    } else {
      path = path.substr(index + 1);
    }
    return path;
  }
  var getExtensionFromUri_default = getExtensionFromUri;

  // Source/Core/getImagePixels.js
  var context2DsByWidthAndHeight = {};
  function getImagePixels(image, width, height) {
    if (!defined_default(width)) {
      width = image.width;
    }
    if (!defined_default(height)) {
      height = image.height;
    }
    let context2DsByHeight = context2DsByWidthAndHeight[width];
    if (!defined_default(context2DsByHeight)) {
      context2DsByHeight = {};
      context2DsByWidthAndHeight[width] = context2DsByHeight;
    }
    let context2d = context2DsByHeight[height];
    if (!defined_default(context2d)) {
      const canvas = document.createElement("canvas");
      canvas.width = width;
      canvas.height = height;
      context2d = canvas.getContext("2d");
      context2d.globalCompositeOperation = "copy";
      context2DsByHeight[height] = context2d;
    }
    context2d.drawImage(image, 0, 0, width, height);
    return context2d.getImageData(0, 0, width, height).data;
  }
  var getImagePixels_default = getImagePixels;

  // Source/Core/isBlobUri.js
  var blobUriRegex = /^blob:/i;
  function isBlobUri(uri) {
    Check_default.typeOf.string("uri", uri);
    return blobUriRegex.test(uri);
  }
  var isBlobUri_default = isBlobUri;

  // Source/Core/isCrossOriginUrl.js
  var a;
  function isCrossOriginUrl(url2) {
    if (!defined_default(a)) {
      a = document.createElement("a");
    }
    a.href = window.location.href;
    const host = a.host;
    const protocol = a.protocol;
    a.href = url2;
    a.href = a.href;
    return protocol !== a.protocol || host !== a.host;
  }
  var isCrossOriginUrl_default = isCrossOriginUrl;

  // Source/Core/isDataUri.js
  var dataUriRegex = /^data:/i;
  function isDataUri(uri) {
    Check_default.typeOf.string("uri", uri);
    return dataUriRegex.test(uri);
  }
  var isDataUri_default = isDataUri;

  // Source/Core/loadAndExecuteScript.js
  function loadAndExecuteScript(url2) {
    const script = document.createElement("script");
    script.async = true;
    script.src = url2;
    return new Promise((resolve2, reject) => {
      if (window.crossOriginIsolated) {
        script.setAttribute("crossorigin", "anonymous");
      }
      const head = document.getElementsByTagName("head")[0];
      script.onload = function() {
        script.onload = void 0;
        head.removeChild(script);
        resolve2();
      };
      script.onerror = function(e) {
        reject(e);
      };
      head.appendChild(script);
    });
  }
  var loadAndExecuteScript_default = loadAndExecuteScript;

  // Source/Core/objectToQuery.js
  function objectToQuery(obj) {
    if (!defined_default(obj)) {
      throw new DeveloperError_default("obj is required.");
    }
    let result = "";
    for (const propName in obj) {
      if (obj.hasOwnProperty(propName)) {
        const value = obj[propName];
        const part = `${encodeURIComponent(propName)}=`;
        if (Array.isArray(value)) {
          for (let i = 0, len = value.length; i < len; ++i) {
            result += `${part + encodeURIComponent(value[i])}&`;
          }
        } else {
          result += `${part + encodeURIComponent(value)}&`;
        }
      }
    }
    result = result.slice(0, -1);
    return result;
  }
  var objectToQuery_default = objectToQuery;

  // Source/Core/queryToObject.js
  function queryToObject(queryString) {
    if (!defined_default(queryString)) {
      throw new DeveloperError_default("queryString is required.");
    }
    const result = {};
    if (queryString === "") {
      return result;
    }
    const parts = queryString.replace(/\+/g, "%20").split(/[&;]/);
    for (let i = 0, len = parts.length; i < len; ++i) {
      const subparts = parts[i].split("=");
      const name = decodeURIComponent(subparts[0]);
      let value = subparts[1];
      if (defined_default(value)) {
        value = decodeURIComponent(value);
      } else {
        value = "";
      }
      const resultValue = result[name];
      if (typeof resultValue === "string") {
        result[name] = [resultValue, value];
      } else if (Array.isArray(resultValue)) {
        resultValue.push(value);
      } else {
        result[name] = value;
      }
    }
    return result;
  }
  var queryToObject_default = queryToObject;

  // Source/Core/RequestState.js
  var RequestState = {
    UNISSUED: 0,
    ISSUED: 1,
    ACTIVE: 2,
    RECEIVED: 3,
    CANCELLED: 4,
    FAILED: 5
  };
  var RequestState_default = Object.freeze(RequestState);

  // Source/Core/RequestType.js
  var RequestType = {
    TERRAIN: 0,
    IMAGERY: 1,
    TILES3D: 2,
    OTHER: 3
  };
  var RequestType_default = Object.freeze(RequestType);

  // Source/Core/Request.js
  function Request(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    const throttleByServer = defaultValue_default(options.throttleByServer, false);
    const throttle = defaultValue_default(options.throttle, false);
    this.url = options.url;
    this.requestFunction = options.requestFunction;
    this.cancelFunction = options.cancelFunction;
    this.priorityFunction = options.priorityFunction;
    this.priority = defaultValue_default(options.priority, 0);
    this.throttle = throttle;
    this.throttleByServer = throttleByServer;
    this.type = defaultValue_default(options.type, RequestType_default.OTHER);
    this.serverKey = void 0;
    this.state = RequestState_default.UNISSUED;
    this.deferred = void 0;
    this.cancelled = false;
  }
  Request.prototype.cancel = function() {
    this.cancelled = true;
  };
  Request.prototype.clone = function(result) {
    if (!defined_default(result)) {
      return new Request(this);
    }
    result.url = this.url;
    result.requestFunction = this.requestFunction;
    result.cancelFunction = this.cancelFunction;
    result.priorityFunction = this.priorityFunction;
    result.priority = this.priority;
    result.throttle = this.throttle;
    result.throttleByServer = this.throttleByServer;
    result.type = this.type;
    result.serverKey = this.serverKey;
    result.state = this.RequestState.UNISSUED;
    result.deferred = void 0;
    result.cancelled = false;
    return result;
  };
  var Request_default = Request;

  // Source/Core/parseResponseHeaders.js
  function parseResponseHeaders(headerString) {
    const headers = {};
    if (!headerString) {
      return headers;
    }
    const headerPairs = headerString.split("\r\n");
    for (let i = 0; i < headerPairs.length; ++i) {
      const headerPair = headerPairs[i];
      const index = headerPair.indexOf(": ");
      if (index > 0) {
        const key = headerPair.substring(0, index);
        const val = headerPair.substring(index + 2);
        headers[key] = val;
      }
    }
    return headers;
  }
  var parseResponseHeaders_default = parseResponseHeaders;

  // Source/Core/RequestErrorEvent.js
  function RequestErrorEvent(statusCode, response, responseHeaders) {
    this.statusCode = statusCode;
    this.response = response;
    this.responseHeaders = responseHeaders;
    if (typeof this.responseHeaders === "string") {
      this.responseHeaders = parseResponseHeaders_default(this.responseHeaders);
    }
  }
  RequestErrorEvent.prototype.toString = function() {
    let str = "Request has failed.";
    if (defined_default(this.statusCode)) {
      str += ` Status Code: ${this.statusCode}`;
    }
    return str;
  };
  var RequestErrorEvent_default = RequestErrorEvent;

  // Source/Core/RequestScheduler.js
  var import_urijs4 = __toESM(require_URI(), 1);

  // Source/Core/Event.js
  function Event() {
    this._listeners = [];
    this._scopes = [];
    this._toRemove = [];
    this._insideRaiseEvent = false;
  }
  Object.defineProperties(Event.prototype, {
    numberOfListeners: {
      get: function() {
        return this._listeners.length - this._toRemove.length;
      }
    }
  });
  Event.prototype.addEventListener = function(listener, scope) {
    Check_default.typeOf.func("listener", listener);
    this._listeners.push(listener);
    this._scopes.push(scope);
    const event = this;
    return function() {
      event.removeEventListener(listener, scope);
    };
  };
  Event.prototype.removeEventListener = function(listener, scope) {
    Check_default.typeOf.func("listener", listener);
    const listeners = this._listeners;
    const scopes = this._scopes;
    let index = -1;
    for (let i = 0; i < listeners.length; i++) {
      if (listeners[i] === listener && scopes[i] === scope) {
        index = i;
        break;
      }
    }
    if (index !== -1) {
      if (this._insideRaiseEvent) {
        this._toRemove.push(index);
        listeners[index] = void 0;
        scopes[index] = void 0;
      } else {
        listeners.splice(index, 1);
        scopes.splice(index, 1);
      }
      return true;
    }
    return false;
  };
  function compareNumber(a3, b) {
    return b - a3;
  }
  Event.prototype.raiseEvent = function() {
    this._insideRaiseEvent = true;
    let i;
    const listeners = this._listeners;
    const scopes = this._scopes;
    let length3 = listeners.length;
    for (i = 0; i < length3; i++) {
      const listener = listeners[i];
      if (defined_default(listener)) {
        listeners[i].apply(scopes[i], arguments);
      }
    }
    const toRemove = this._toRemove;
    length3 = toRemove.length;
    if (length3 > 0) {
      toRemove.sort(compareNumber);
      for (i = 0; i < length3; i++) {
        const index = toRemove[i];
        listeners.splice(index, 1);
        scopes.splice(index, 1);
      }
      toRemove.length = 0;
    }
    this._insideRaiseEvent = false;
  };
  var Event_default = Event;

  // Source/Core/Heap.js
  function Heap(options) {
    Check_default.typeOf.object("options", options);
    Check_default.defined("options.comparator", options.comparator);
    this._comparator = options.comparator;
    this._array = [];
    this._length = 0;
    this._maximumLength = void 0;
  }
  Object.defineProperties(Heap.prototype, {
    length: {
      get: function() {
        return this._length;
      }
    },
    internalArray: {
      get: function() {
        return this._array;
      }
    },
    maximumLength: {
      get: function() {
        return this._maximumLength;
      },
      set: function(value) {
        Check_default.typeOf.number.greaterThanOrEquals("maximumLength", value, 0);
        const originalLength = this._length;
        if (value < originalLength) {
          const array = this._array;
          for (let i = value; i < originalLength; ++i) {
            array[i] = void 0;
          }
          this._length = value;
          array.length = value;
        }
        this._maximumLength = value;
      }
    },
    comparator: {
      get: function() {
        return this._comparator;
      }
    }
  });
  function swap(array, a3, b) {
    const temp = array[a3];
    array[a3] = array[b];
    array[b] = temp;
  }
  Heap.prototype.reserve = function(length3) {
    length3 = defaultValue_default(length3, this._length);
    this._array.length = length3;
  };
  Heap.prototype.heapify = function(index) {
    index = defaultValue_default(index, 0);
    const length3 = this._length;
    const comparator = this._comparator;
    const array = this._array;
    let candidate = -1;
    let inserting = true;
    while (inserting) {
      const right = 2 * (index + 1);
      const left = right - 1;
      if (left < length3 && comparator(array[left], array[index]) < 0) {
        candidate = left;
      } else {
        candidate = index;
      }
      if (right < length3 && comparator(array[right], array[candidate]) < 0) {
        candidate = right;
      }
      if (candidate !== index) {
        swap(array, candidate, index);
        index = candidate;
      } else {
        inserting = false;
      }
    }
  };
  Heap.prototype.resort = function() {
    const length3 = this._length;
    for (let i = Math.ceil(length3 / 2); i >= 0; --i) {
      this.heapify(i);
    }
  };
  Heap.prototype.insert = function(element) {
    Check_default.defined("element", element);
    const array = this._array;
    const comparator = this._comparator;
    const maximumLength = this._maximumLength;
    let index = this._length++;
    if (index < array.length) {
      array[index] = element;
    } else {
      array.push(element);
    }
    while (index !== 0) {
      const parent = Math.floor((index - 1) / 2);
      if (comparator(array[index], array[parent]) < 0) {
        swap(array, index, parent);
        index = parent;
      } else {
        break;
      }
    }
    let removedElement;
    if (defined_default(maximumLength) && this._length > maximumLength) {
      removedElement = array[maximumLength];
      this._length = maximumLength;
    }
    return removedElement;
  };
  Heap.prototype.pop = function(index) {
    index = defaultValue_default(index, 0);
    if (this._length === 0) {
      return void 0;
    }
    Check_default.typeOf.number.lessThan("index", index, this._length);
    const array = this._array;
    const root = array[index];
    swap(array, index, --this._length);
    this.heapify(index);
    array[this._length] = void 0;
    return root;
  };
  var Heap_default = Heap;

  // Source/Core/RequestScheduler.js
  function sortRequests(a3, b) {
    return a3.priority - b.priority;
  }
  var statistics = {
    numberOfAttemptedRequests: 0,
    numberOfActiveRequests: 0,
    numberOfCancelledRequests: 0,
    numberOfCancelledActiveRequests: 0,
    numberOfFailedRequests: 0,
    numberOfActiveRequestsEver: 0,
    lastNumberOfActiveRequests: 0
  };
  var priorityHeapLength = 20;
  var requestHeap = new Heap_default({
    comparator: sortRequests
  });
  requestHeap.maximumLength = priorityHeapLength;
  requestHeap.reserve(priorityHeapLength);
  var activeRequests = [];
  var numberOfActiveRequestsByServer = {};
  var pageUri = typeof document !== "undefined" ? new import_urijs4.default(document.location.href) : new import_urijs4.default();
  var requestCompletedEvent = new Event_default();
  function RequestScheduler() {
  }
  RequestScheduler.maximumRequests = 50;
  RequestScheduler.maximumRequestsPerServer = 6;
  RequestScheduler.requestsByServer = {
    "api.cesium.com:443": 18,
    "assets.cesium.com:443": 18
  };
  RequestScheduler.throttleRequests = true;
  RequestScheduler.debugShowStatistics = false;
  RequestScheduler.requestCompletedEvent = requestCompletedEvent;
  Object.defineProperties(RequestScheduler, {
    statistics: {
      get: function() {
        return statistics;
      }
    },
    priorityHeapLength: {
      get: function() {
        return priorityHeapLength;
      },
      set: function(value) {
        if (value < priorityHeapLength) {
          while (requestHeap.length > value) {
            const request = requestHeap.pop();
            cancelRequest(request);
          }
        }
        priorityHeapLength = value;
        requestHeap.maximumLength = value;
        requestHeap.reserve(value);
      }
    }
  });
  function updatePriority(request) {
    if (defined_default(request.priorityFunction)) {
      request.priority = request.priorityFunction();
    }
  }
  RequestScheduler.serverHasOpenSlots = function(serverKey, desiredRequests) {
    desiredRequests = defaultValue_default(desiredRequests, 1);
    const maxRequests = defaultValue_default(
      RequestScheduler.requestsByServer[serverKey],
      RequestScheduler.maximumRequestsPerServer
    );
    const hasOpenSlotsServer = numberOfActiveRequestsByServer[serverKey] + desiredRequests <= maxRequests;
    return hasOpenSlotsServer;
  };
  RequestScheduler.heapHasOpenSlots = function(desiredRequests) {
    const hasOpenSlotsHeap = requestHeap.length + desiredRequests <= priorityHeapLength;
    return hasOpenSlotsHeap;
  };
  function issueRequest(request) {
    if (request.state === RequestState_default.UNISSUED) {
      request.state = RequestState_default.ISSUED;
      request.deferred = defer_default();
    }
    return request.deferred.promise;
  }
  function getRequestReceivedFunction(request) {
    return function(results) {
      if (request.state === RequestState_default.CANCELLED) {
        return;
      }
      const deferred = request.deferred;
      --statistics.numberOfActiveRequests;
      --numberOfActiveRequestsByServer[request.serverKey];
      requestCompletedEvent.raiseEvent();
      request.state = RequestState_default.RECEIVED;
      request.deferred = void 0;
      deferred.resolve(results);
    };
  }
  function getRequestFailedFunction(request) {
    return function(error) {
      if (request.state === RequestState_default.CANCELLED) {
        return;
      }
      ++statistics.numberOfFailedRequests;
      --statistics.numberOfActiveRequests;
      --numberOfActiveRequestsByServer[request.serverKey];
      requestCompletedEvent.raiseEvent(error);
      request.state = RequestState_default.FAILED;
      request.deferred.reject(error);
    };
  }
  function startRequest(request) {
    const promise = issueRequest(request);
    request.state = RequestState_default.ACTIVE;
    activeRequests.push(request);
    ++statistics.numberOfActiveRequests;
    ++statistics.numberOfActiveRequestsEver;
    ++numberOfActiveRequestsByServer[request.serverKey];
    request.requestFunction().then(getRequestReceivedFunction(request)).catch(getRequestFailedFunction(request));
    return promise;
  }
  function cancelRequest(request) {
    const active = request.state === RequestState_default.ACTIVE;
    request.state = RequestState_default.CANCELLED;
    ++statistics.numberOfCancelledRequests;
    if (defined_default(request.deferred)) {
      const deferred = request.deferred;
      request.deferred = void 0;
      deferred.reject();
    }
    if (active) {
      --statistics.numberOfActiveRequests;
      --numberOfActiveRequestsByServer[request.serverKey];
      ++statistics.numberOfCancelledActiveRequests;
    }
    if (defined_default(request.cancelFunction)) {
      request.cancelFunction();
    }
  }
  RequestScheduler.update = function() {
    let i;
    let request;
    let removeCount = 0;
    const activeLength = activeRequests.length;
    for (i = 0; i < activeLength; ++i) {
      request = activeRequests[i];
      if (request.cancelled) {
        cancelRequest(request);
      }
      if (request.state !== RequestState_default.ACTIVE) {
        ++removeCount;
        continue;
      }
      if (removeCount > 0) {
        activeRequests[i - removeCount] = request;
      }
    }
    activeRequests.length -= removeCount;
    const issuedRequests = requestHeap.internalArray;
    const issuedLength = requestHeap.length;
    for (i = 0; i < issuedLength; ++i) {
      updatePriority(issuedRequests[i]);
    }
    requestHeap.resort();
    const openSlots = Math.max(
      RequestScheduler.maximumRequests - activeRequests.length,
      0
    );
    let filledSlots = 0;
    while (filledSlots < openSlots && requestHeap.length > 0) {
      request = requestHeap.pop();
      if (request.cancelled) {
        cancelRequest(request);
        continue;
      }
      if (request.throttleByServer && !RequestScheduler.serverHasOpenSlots(request.serverKey)) {
        cancelRequest(request);
        continue;
      }
      startRequest(request);
      ++filledSlots;
    }
    updateStatistics();
  };
  RequestScheduler.getServerKey = function(url2) {
    Check_default.typeOf.string("url", url2);
    let uri = new import_urijs4.default(url2);
    if (uri.scheme() === "") {
      uri = new import_urijs4.default(url2).absoluteTo(pageUri);
      uri.normalize();
    }
    let serverKey = uri.authority();
    if (!/:/.test(serverKey)) {
      serverKey = `${serverKey}:${uri.scheme() === "https" ? "443" : "80"}`;
    }
    const length3 = numberOfActiveRequestsByServer[serverKey];
    if (!defined_default(length3)) {
      numberOfActiveRequestsByServer[serverKey] = 0;
    }
    return serverKey;
  };
  RequestScheduler.request = function(request) {
    Check_default.typeOf.object("request", request);
    Check_default.typeOf.string("request.url", request.url);
    Check_default.typeOf.func("request.requestFunction", request.requestFunction);
    if (isDataUri_default(request.url) || isBlobUri_default(request.url)) {
      requestCompletedEvent.raiseEvent();
      request.state = RequestState_default.RECEIVED;
      return request.requestFunction();
    }
    ++statistics.numberOfAttemptedRequests;
    if (!defined_default(request.serverKey)) {
      request.serverKey = RequestScheduler.getServerKey(request.url);
    }
    if (RequestScheduler.throttleRequests && request.throttleByServer && !RequestScheduler.serverHasOpenSlots(request.serverKey)) {
      return void 0;
    }
    if (!RequestScheduler.throttleRequests || !request.throttle) {
      return startRequest(request);
    }
    if (activeRequests.length >= RequestScheduler.maximumRequests) {
      return void 0;
    }
    updatePriority(request);
    const removedRequest = requestHeap.insert(request);
    if (defined_default(removedRequest)) {
      if (removedRequest === request) {
        return void 0;
      }
      cancelRequest(removedRequest);
    }
    return issueRequest(request);
  };
  function updateStatistics() {
    if (!RequestScheduler.debugShowStatistics) {
      return;
    }
    if (statistics.numberOfActiveRequests === 0 && statistics.lastNumberOfActiveRequests > 0) {
      if (statistics.numberOfAttemptedRequests > 0) {
        console.log(
          `Number of attempted requests: ${statistics.numberOfAttemptedRequests}`
        );
        statistics.numberOfAttemptedRequests = 0;
      }
      if (statistics.numberOfCancelledRequests > 0) {
        console.log(
          `Number of cancelled requests: ${statistics.numberOfCancelledRequests}`
        );
        statistics.numberOfCancelledRequests = 0;
      }
      if (statistics.numberOfCancelledActiveRequests > 0) {
        console.log(
          `Number of cancelled active requests: ${statistics.numberOfCancelledActiveRequests}`
        );
        statistics.numberOfCancelledActiveRequests = 0;
      }
      if (statistics.numberOfFailedRequests > 0) {
        console.log(
          `Number of failed requests: ${statistics.numberOfFailedRequests}`
        );
        statistics.numberOfFailedRequests = 0;
      }
    }
    statistics.lastNumberOfActiveRequests = statistics.numberOfActiveRequests;
  }
  RequestScheduler.clearForSpecs = function() {
    while (requestHeap.length > 0) {
      const request = requestHeap.pop();
      cancelRequest(request);
    }
    const length3 = activeRequests.length;
    for (let i = 0; i < length3; ++i) {
      cancelRequest(activeRequests[i]);
    }
    activeRequests.length = 0;
    numberOfActiveRequestsByServer = {};
    statistics.numberOfAttemptedRequests = 0;
    statistics.numberOfActiveRequests = 0;
    statistics.numberOfCancelledRequests = 0;
    statistics.numberOfCancelledActiveRequests = 0;
    statistics.numberOfFailedRequests = 0;
    statistics.numberOfActiveRequestsEver = 0;
    statistics.lastNumberOfActiveRequests = 0;
  };
  RequestScheduler.numberOfActiveRequestsByServer = function(serverKey) {
    return numberOfActiveRequestsByServer[serverKey];
  };
  RequestScheduler.requestHeap = requestHeap;
  var RequestScheduler_default = RequestScheduler;

  // Source/Core/TrustedServers.js
  var import_urijs5 = __toESM(require_URI(), 1);
  var TrustedServers = {};
  var _servers = {};
  TrustedServers.add = function(host, port) {
    if (!defined_default(host)) {
      throw new DeveloperError_default("host is required.");
    }
    if (!defined_default(port) || port <= 0) {
      throw new DeveloperError_default("port is required to be greater than 0.");
    }
    const authority = `${host.toLowerCase()}:${port}`;
    if (!defined_default(_servers[authority])) {
      _servers[authority] = true;
    }
  };
  TrustedServers.remove = function(host, port) {
    if (!defined_default(host)) {
      throw new DeveloperError_default("host is required.");
    }
    if (!defined_default(port) || port <= 0) {
      throw new DeveloperError_default("port is required to be greater than 0.");
    }
    const authority = `${host.toLowerCase()}:${port}`;
    if (defined_default(_servers[authority])) {
      delete _servers[authority];
    }
  };
  function getAuthority(url2) {
    const uri = new import_urijs5.default(url2);
    uri.normalize();
    let authority = uri.authority();
    if (authority.length === 0) {
      return void 0;
    }
    uri.authority(authority);
    if (authority.indexOf("@") !== -1) {
      const parts = authority.split("@");
      authority = parts[1];
    }
    if (authority.indexOf(":") === -1) {
      let scheme = uri.scheme();
      if (scheme.length === 0) {
        scheme = window.location.protocol;
        scheme = scheme.substring(0, scheme.length - 1);
      }
      if (scheme === "http") {
        authority += ":80";
      } else if (scheme === "https") {
        authority += ":443";
      } else {
        return void 0;
      }
    }
    return authority;
  }
  TrustedServers.contains = function(url2) {
    if (!defined_default(url2)) {
      throw new DeveloperError_default("url is required.");
    }
    const authority = getAuthority(url2);
    if (defined_default(authority) && defined_default(_servers[authority])) {
      return true;
    }
    return false;
  };
  TrustedServers.clear = function() {
    _servers = {};
  };
  var TrustedServers_default = TrustedServers;

  // Source/Core/Resource.js
  var xhrBlobSupported = function() {
    try {
      const xhr = new XMLHttpRequest();
      xhr.open("GET", "#", true);
      xhr.responseType = "blob";
      return xhr.responseType === "blob";
    } catch (e) {
      return false;
    }
  }();
  function parseQuery(uri, resource, merge2, preserveQueryParameters) {
    const queryString = uri.query();
    if (queryString.length === 0) {
      return {};
    }
    let query;
    if (queryString.indexOf("=") === -1) {
      const result = {};
      result[queryString] = void 0;
      query = result;
    } else {
      query = queryToObject_default(queryString);
    }
    if (merge2) {
      resource._queryParameters = combineQueryParameters(
        query,
        resource._queryParameters,
        preserveQueryParameters
      );
    } else {
      resource._queryParameters = query;
    }
    uri.search("");
  }
  function stringifyQuery(uri, resource) {
    const queryObject = resource._queryParameters;
    const keys = Object.keys(queryObject);
    if (keys.length === 1 && !defined_default(queryObject[keys[0]])) {
      uri.search(keys[0]);
    } else {
      uri.search(objectToQuery_default(queryObject));
    }
  }
  function defaultClone(val, defaultVal) {
    if (!defined_default(val)) {
      return defaultVal;
    }
    return defined_default(val.clone) ? val.clone() : clone_default(val);
  }
  function checkAndResetRequest(request) {
    if (request.state === RequestState_default.ISSUED || request.state === RequestState_default.ACTIVE) {
      throw new RuntimeError_default("The Resource is already being fetched.");
    }
    request.state = RequestState_default.UNISSUED;
    request.deferred = void 0;
  }
  function combineQueryParameters(q12, q22, preserveQueryParameters) {
    if (!preserveQueryParameters) {
      return combine_default(q12, q22);
    }
    const result = clone_default(q12, true);
    for (const param in q22) {
      if (q22.hasOwnProperty(param)) {
        let value = result[param];
        const q2Value = q22[param];
        if (defined_default(value)) {
          if (!Array.isArray(value)) {
            value = result[param] = [value];
          }
          result[param] = value.concat(q2Value);
        } else {
          result[param] = Array.isArray(q2Value) ? q2Value.slice() : q2Value;
        }
      }
    }
    return result;
  }
  function Resource(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    if (typeof options === "string") {
      options = {
        url: options
      };
    }
    Check_default.typeOf.string("options.url", options.url);
    this._url = void 0;
    this._templateValues = defaultClone(options.templateValues, {});
    this._queryParameters = defaultClone(options.queryParameters, {});
    this.headers = defaultClone(options.headers, {});
    this.request = defaultValue_default(options.request, new Request_default());
    this.proxy = options.proxy;
    this.retryCallback = options.retryCallback;
    this.retryAttempts = defaultValue_default(options.retryAttempts, 0);
    this._retryCount = 0;
    const uri = new import_urijs6.default(options.url);
    parseQuery(uri, this, true, true);
    uri.fragment("");
    this._url = uri.toString();
  }
  Resource.createIfNeeded = function(resource) {
    if (resource instanceof Resource) {
      return resource.getDerivedResource({
        request: resource.request
      });
    }
    if (typeof resource !== "string") {
      return resource;
    }
    return new Resource({
      url: resource
    });
  };
  var supportsImageBitmapOptionsPromise;
  Resource.supportsImageBitmapOptions = function() {
    if (defined_default(supportsImageBitmapOptionsPromise)) {
      return supportsImageBitmapOptionsPromise;
    }
    if (typeof createImageBitmap !== "function") {
      supportsImageBitmapOptionsPromise = Promise.resolve(false);
      return supportsImageBitmapOptionsPromise;
    }
    const imageDataUri = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAABGdBTUEAAE4g3rEiDgAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAADElEQVQI12Ng6GAAAAEUAIngE3ZiAAAAAElFTkSuQmCC";
    supportsImageBitmapOptionsPromise = Resource.fetchBlob({
      url: imageDataUri
    }).then(function(blob) {
      const imageBitmapOptions = {
        imageOrientation: "flipY",
        premultiplyAlpha: "none",
        colorSpaceConversion: "none"
      };
      return Promise.all([
        createImageBitmap(blob, imageBitmapOptions),
        createImageBitmap(blob)
      ]);
    }).then(function(imageBitmaps) {
      const colorWithOptions = getImagePixels_default(imageBitmaps[0]);
      const colorWithDefaults = getImagePixels_default(imageBitmaps[1]);
      return colorWithOptions[1] !== colorWithDefaults[1];
    }).catch(function() {
      return false;
    });
    return supportsImageBitmapOptionsPromise;
  };
  Object.defineProperties(Resource, {
    isBlobSupported: {
      get: function() {
        return xhrBlobSupported;
      }
    }
  });
  Object.defineProperties(Resource.prototype, {
    queryParameters: {
      get: function() {
        return this._queryParameters;
      }
    },
    templateValues: {
      get: function() {
        return this._templateValues;
      }
    },
    url: {
      get: function() {
        return this.getUrlComponent(true, true);
      },
      set: function(value) {
        const uri = new import_urijs6.default(value);
        parseQuery(uri, this, false);
        uri.fragment("");
        this._url = uri.toString();
      }
    },
    extension: {
      get: function() {
        return getExtensionFromUri_default(this._url);
      }
    },
    isDataUri: {
      get: function() {
        return isDataUri_default(this._url);
      }
    },
    isBlobUri: {
      get: function() {
        return isBlobUri_default(this._url);
      }
    },
    isCrossOriginUrl: {
      get: function() {
        return isCrossOriginUrl_default(this._url);
      }
    },
    hasHeaders: {
      get: function() {
        return Object.keys(this.headers).length > 0;
      }
    }
  });
  Resource.prototype.toString = function() {
    return this.getUrlComponent(true, true);
  };
  Resource.prototype.getUrlComponent = function(query, proxy) {
    if (this.isDataUri) {
      return this._url;
    }
    const uri = new import_urijs6.default(this._url);
    if (query) {
      stringifyQuery(uri, this);
    }
    let url2 = uri.toString().replace(/%7B/g, "{").replace(/%7D/g, "}");
    const templateValues = this._templateValues;
    url2 = url2.replace(/{(.*?)}/g, function(match, key) {
      const replacement = templateValues[key];
      if (defined_default(replacement)) {
        return encodeURIComponent(replacement);
      }
      return match;
    });
    if (proxy && defined_default(this.proxy)) {
      url2 = this.proxy.getURL(url2);
    }
    return url2;
  };
  Resource.prototype.setQueryParameters = function(params, useAsDefault) {
    if (useAsDefault) {
      this._queryParameters = combineQueryParameters(
        this._queryParameters,
        params,
        false
      );
    } else {
      this._queryParameters = combineQueryParameters(
        params,
        this._queryParameters,
        false
      );
    }
  };
  Resource.prototype.appendQueryParameters = function(params) {
    this._queryParameters = combineQueryParameters(
      params,
      this._queryParameters,
      true
    );
  };
  Resource.prototype.setTemplateValues = function(template, useAsDefault) {
    if (useAsDefault) {
      this._templateValues = combine_default(this._templateValues, template);
    } else {
      this._templateValues = combine_default(template, this._templateValues);
    }
  };
  Resource.prototype.getDerivedResource = function(options) {
    const resource = this.clone();
    resource._retryCount = 0;
    if (defined_default(options.url)) {
      const uri = new import_urijs6.default(options.url);
      const preserveQueryParameters = defaultValue_default(
        options.preserveQueryParameters,
        false
      );
      parseQuery(uri, resource, true, preserveQueryParameters);
      uri.fragment("");
      if (uri.scheme() !== "") {
        resource._url = uri.toString();
      } else {
        resource._url = uri.absoluteTo(new import_urijs6.default(getAbsoluteUri_default(this._url))).toString();
      }
    }
    if (defined_default(options.queryParameters)) {
      resource._queryParameters = combine_default(
        options.queryParameters,
        resource._queryParameters
      );
    }
    if (defined_default(options.templateValues)) {
      resource._templateValues = combine_default(
        options.templateValues,
        resource.templateValues
      );
    }
    if (defined_default(options.headers)) {
      resource.headers = combine_default(options.headers, resource.headers);
    }
    if (defined_default(options.proxy)) {
      resource.proxy = options.proxy;
    }
    if (defined_default(options.request)) {
      resource.request = options.request;
    }
    if (defined_default(options.retryCallback)) {
      resource.retryCallback = options.retryCallback;
    }
    if (defined_default(options.retryAttempts)) {
      resource.retryAttempts = options.retryAttempts;
    }
    return resource;
  };
  Resource.prototype.retryOnError = function(error) {
    const retryCallback2 = this.retryCallback;
    if (typeof retryCallback2 !== "function" || this._retryCount >= this.retryAttempts) {
      return Promise.resolve(false);
    }
    const that = this;
    return Promise.resolve(retryCallback2(this, error)).then(function(result) {
      ++that._retryCount;
      return result;
    });
  };
  Resource.prototype.clone = function(result) {
    if (!defined_default(result)) {
      result = new Resource({
        url: this._url
      });
    }
    result._url = this._url;
    result._queryParameters = clone_default(this._queryParameters);
    result._templateValues = clone_default(this._templateValues);
    result.headers = clone_default(this.headers);
    result.proxy = this.proxy;
    result.retryCallback = this.retryCallback;
    result.retryAttempts = this.retryAttempts;
    result._retryCount = 0;
    result.request = this.request.clone();
    return result;
  };
  Resource.prototype.getBaseUri = function(includeQuery) {
    return getBaseUri_default(this.getUrlComponent(includeQuery), includeQuery);
  };
  Resource.prototype.appendForwardSlash = function() {
    this._url = appendForwardSlash_default(this._url);
  };
  Resource.prototype.fetchArrayBuffer = function() {
    return this.fetch({
      responseType: "arraybuffer"
    });
  };
  Resource.fetchArrayBuffer = function(options) {
    const resource = new Resource(options);
    return resource.fetchArrayBuffer();
  };
  Resource.prototype.fetchBlob = function() {
    return this.fetch({
      responseType: "blob"
    });
  };
  Resource.fetchBlob = function(options) {
    const resource = new Resource(options);
    return resource.fetchBlob();
  };
  Resource.prototype.fetchImage = function(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    const preferImageBitmap = defaultValue_default(options.preferImageBitmap, false);
    const preferBlob = defaultValue_default(options.preferBlob, false);
    const flipY = defaultValue_default(options.flipY, false);
    const skipColorSpaceConversion = defaultValue_default(
      options.skipColorSpaceConversion,
      false
    );
    checkAndResetRequest(this.request);
    if (!xhrBlobSupported || this.isDataUri || this.isBlobUri || !this.hasHeaders && !preferBlob) {
      return fetchImage({
        resource: this,
        flipY,
        skipColorSpaceConversion,
        preferImageBitmap
      });
    }
    const blobPromise = this.fetchBlob();
    if (!defined_default(blobPromise)) {
      return;
    }
    let supportsImageBitmap;
    let useImageBitmap;
    let generatedBlobResource;
    let generatedBlob;
    return Resource.supportsImageBitmapOptions().then(function(result) {
      supportsImageBitmap = result;
      useImageBitmap = supportsImageBitmap && preferImageBitmap;
      return blobPromise;
    }).then(function(blob) {
      if (!defined_default(blob)) {
        return;
      }
      generatedBlob = blob;
      if (useImageBitmap) {
        return Resource.createImageBitmapFromBlob(blob, {
          flipY,
          premultiplyAlpha: false,
          skipColorSpaceConversion
        });
      }
      const blobUrl = window.URL.createObjectURL(blob);
      generatedBlobResource = new Resource({
        url: blobUrl
      });
      return fetchImage({
        resource: generatedBlobResource,
        flipY,
        skipColorSpaceConversion,
        preferImageBitmap: false
      });
    }).then(function(image) {
      if (!defined_default(image)) {
        return;
      }
      image.blob = generatedBlob;
      if (useImageBitmap) {
        return image;
      }
      window.URL.revokeObjectURL(generatedBlobResource.url);
      return image;
    }).catch(function(error) {
      if (defined_default(generatedBlobResource)) {
        window.URL.revokeObjectURL(generatedBlobResource.url);
      }
      error.blob = generatedBlob;
      return Promise.reject(error);
    });
  };
  function fetchImage(options) {
    const resource = options.resource;
    const flipY = options.flipY;
    const skipColorSpaceConversion = options.skipColorSpaceConversion;
    const preferImageBitmap = options.preferImageBitmap;
    const request = resource.request;
    request.url = resource.url;
    request.requestFunction = function() {
      let crossOrigin = false;
      if (!resource.isDataUri && !resource.isBlobUri) {
        crossOrigin = resource.isCrossOriginUrl;
      }
      const deferred = defer_default();
      Resource._Implementations.createImage(
        request,
        crossOrigin,
        deferred,
        flipY,
        skipColorSpaceConversion,
        preferImageBitmap
      );
      return deferred.promise;
    };
    const promise = RequestScheduler_default.request(request);
    if (!defined_default(promise)) {
      return;
    }
    return promise.catch(function(e) {
      if (request.state !== RequestState_default.FAILED) {
        return Promise.reject(e);
      }
      return resource.retryOnError(e).then(function(retry) {
        if (retry) {
          request.state = RequestState_default.UNISSUED;
          request.deferred = void 0;
          return fetchImage({
            resource,
            flipY,
            skipColorSpaceConversion,
            preferImageBitmap
          });
        }
        return Promise.reject(e);
      });
    });
  }
  Resource.fetchImage = function(options) {
    const resource = new Resource(options);
    return resource.fetchImage({
      flipY: options.flipY,
      skipColorSpaceConversion: options.skipColorSpaceConversion,
      preferBlob: options.preferBlob,
      preferImageBitmap: options.preferImageBitmap
    });
  };
  Resource.prototype.fetchText = function() {
    return this.fetch({
      responseType: "text"
    });
  };
  Resource.fetchText = function(options) {
    const resource = new Resource(options);
    return resource.fetchText();
  };
  Resource.prototype.fetchJson = function() {
    const promise = this.fetch({
      responseType: "text",
      headers: {
        Accept: "application/json,*/*;q=0.01"
      }
    });
    if (!defined_default(promise)) {
      return void 0;
    }
    return promise.then(function(value) {
      if (!defined_default(value)) {
        return;
      }
      return JSON.parse(value);
    });
  };
  Resource.fetchJson = function(options) {
    const resource = new Resource(options);
    return resource.fetchJson();
  };
  Resource.prototype.fetchXML = function() {
    return this.fetch({
      responseType: "document",
      overrideMimeType: "text/xml"
    });
  };
  Resource.fetchXML = function(options) {
    const resource = new Resource(options);
    return resource.fetchXML();
  };
  Resource.prototype.fetchJsonp = function(callbackParameterName) {
    callbackParameterName = defaultValue_default(callbackParameterName, "callback");
    checkAndResetRequest(this.request);
    let functionName;
    do {
      functionName = `loadJsonp${Math_default.nextRandomNumber().toString().substring(2, 8)}`;
    } while (defined_default(window[functionName]));
    return fetchJsonp(this, callbackParameterName, functionName);
  };
  function fetchJsonp(resource, callbackParameterName, functionName) {
    const callbackQuery = {};
    callbackQuery[callbackParameterName] = functionName;
    resource.setQueryParameters(callbackQuery);
    const request = resource.request;
    request.url = resource.url;
    request.requestFunction = function() {
      const deferred = defer_default();
      window[functionName] = function(data) {
        deferred.resolve(data);
        try {
          delete window[functionName];
        } catch (e) {
          window[functionName] = void 0;
        }
      };
      Resource._Implementations.loadAndExecuteScript(
        resource.url,
        functionName,
        deferred
      );
      return deferred.promise;
    };
    const promise = RequestScheduler_default.request(request);
    if (!defined_default(promise)) {
      return;
    }
    return promise.catch(function(e) {
      if (request.state !== RequestState_default.FAILED) {
        return Promise.reject(e);
      }
      return resource.retryOnError(e).then(function(retry) {
        if (retry) {
          request.state = RequestState_default.UNISSUED;
          request.deferred = void 0;
          return fetchJsonp(resource, callbackParameterName, functionName);
        }
        return Promise.reject(e);
      });
    });
  }
  Resource.fetchJsonp = function(options) {
    const resource = new Resource(options);
    return resource.fetchJsonp(options.callbackParameterName);
  };
  Resource.prototype._makeRequest = function(options) {
    const resource = this;
    checkAndResetRequest(resource.request);
    const request = resource.request;
    request.url = resource.url;
    request.requestFunction = function() {
      const responseType = options.responseType;
      const headers = combine_default(options.headers, resource.headers);
      const overrideMimeType = options.overrideMimeType;
      const method = options.method;
      const data = options.data;
      const deferred = defer_default();
      const xhr = Resource._Implementations.loadWithXhr(
        resource.url,
        responseType,
        method,
        data,
        headers,
        deferred,
        overrideMimeType
      );
      if (defined_default(xhr) && defined_default(xhr.abort)) {
        request.cancelFunction = function() {
          xhr.abort();
        };
      }
      return deferred.promise;
    };
    const promise = RequestScheduler_default.request(request);
    if (!defined_default(promise)) {
      return;
    }
    return promise.then(function(data) {
      request.cancelFunction = void 0;
      return data;
    }).catch(function(e) {
      request.cancelFunction = void 0;
      if (request.state !== RequestState_default.FAILED) {
        return Promise.reject(e);
      }
      return resource.retryOnError(e).then(function(retry) {
        if (retry) {
          request.state = RequestState_default.UNISSUED;
          request.deferred = void 0;
          return resource.fetch(options);
        }
        return Promise.reject(e);
      });
    });
  };
  var dataUriRegex2 = /^data:(.*?)(;base64)?,(.*)$/;
  function decodeDataUriText(isBase64, data) {
    const result = decodeURIComponent(data);
    if (isBase64) {
      return atob(result);
    }
    return result;
  }
  function decodeDataUriArrayBuffer(isBase64, data) {
    const byteString = decodeDataUriText(isBase64, data);
    const buffer = new ArrayBuffer(byteString.length);
    const view = new Uint8Array(buffer);
    for (let i = 0; i < byteString.length; i++) {
      view[i] = byteString.charCodeAt(i);
    }
    return buffer;
  }
  function decodeDataUri(dataUriRegexResult, responseType) {
    responseType = defaultValue_default(responseType, "");
    const mimeType = dataUriRegexResult[1];
    const isBase64 = !!dataUriRegexResult[2];
    const data = dataUriRegexResult[3];
    let buffer;
    let parser3;
    switch (responseType) {
      case "":
      case "text":
        return decodeDataUriText(isBase64, data);
      case "arraybuffer":
        return decodeDataUriArrayBuffer(isBase64, data);
      case "blob":
        buffer = decodeDataUriArrayBuffer(isBase64, data);
        return new Blob([buffer], {
          type: mimeType
        });
      case "document":
        parser3 = new DOMParser();
        return parser3.parseFromString(
          decodeDataUriText(isBase64, data),
          mimeType
        );
      case "json":
        return JSON.parse(decodeDataUriText(isBase64, data));
      default:
        throw new DeveloperError_default(`Unhandled responseType: ${responseType}`);
    }
  }
  Resource.prototype.fetch = function(options) {
    options = defaultClone(options, {});
    options.method = "GET";
    return this._makeRequest(options);
  };
  Resource.fetch = function(options) {
    const resource = new Resource(options);
    return resource.fetch({
      responseType: options.responseType,
      overrideMimeType: options.overrideMimeType
    });
  };
  Resource.prototype.delete = function(options) {
    options = defaultClone(options, {});
    options.method = "DELETE";
    return this._makeRequest(options);
  };
  Resource.delete = function(options) {
    const resource = new Resource(options);
    return resource.delete({
      responseType: options.responseType,
      overrideMimeType: options.overrideMimeType,
      data: options.data
    });
  };
  Resource.prototype.head = function(options) {
    options = defaultClone(options, {});
    options.method = "HEAD";
    return this._makeRequest(options);
  };
  Resource.head = function(options) {
    const resource = new Resource(options);
    return resource.head({
      responseType: options.responseType,
      overrideMimeType: options.overrideMimeType
    });
  };
  Resource.prototype.options = function(options) {
    options = defaultClone(options, {});
    options.method = "OPTIONS";
    return this._makeRequest(options);
  };
  Resource.options = function(options) {
    const resource = new Resource(options);
    return resource.options({
      responseType: options.responseType,
      overrideMimeType: options.overrideMimeType
    });
  };
  Resource.prototype.post = function(data, options) {
    Check_default.defined("data", data);
    options = defaultClone(options, {});
    options.method = "POST";
    options.data = data;
    return this._makeRequest(options);
  };
  Resource.post = function(options) {
    const resource = new Resource(options);
    return resource.post(options.data, {
      responseType: options.responseType,
      overrideMimeType: options.overrideMimeType
    });
  };
  Resource.prototype.put = function(data, options) {
    Check_default.defined("data", data);
    options = defaultClone(options, {});
    options.method = "PUT";
    options.data = data;
    return this._makeRequest(options);
  };
  Resource.put = function(options) {
    const resource = new Resource(options);
    return resource.put(options.data, {
      responseType: options.responseType,
      overrideMimeType: options.overrideMimeType
    });
  };
  Resource.prototype.patch = function(data, options) {
    Check_default.defined("data", data);
    options = defaultClone(options, {});
    options.method = "PATCH";
    options.data = data;
    return this._makeRequest(options);
  };
  Resource.patch = function(options) {
    const resource = new Resource(options);
    return resource.patch(options.data, {
      responseType: options.responseType,
      overrideMimeType: options.overrideMimeType
    });
  };
  Resource._Implementations = {};
  Resource._Implementations.loadImageElement = function(url2, crossOrigin, deferred) {
    const image = new Image();
    image.onload = function() {
      if (image.naturalWidth === 0 && image.naturalHeight === 0 && image.width === 0 && image.height === 0) {
        image.width = 300;
        image.height = 150;
      }
      deferred.resolve(image);
    };
    image.onerror = function(e) {
      deferred.reject(e);
    };
    if (crossOrigin) {
      if (TrustedServers_default.contains(url2)) {
        image.crossOrigin = "use-credentials";
      } else {
        image.crossOrigin = "";
      }
    }
    image.src = url2;
  };
  Resource._Implementations.createImage = function(request, crossOrigin, deferred, flipY, skipColorSpaceConversion, preferImageBitmap) {
    const url2 = request.url;
    Resource.supportsImageBitmapOptions().then(function(supportsImageBitmap) {
      if (!(supportsImageBitmap && preferImageBitmap)) {
        Resource._Implementations.loadImageElement(url2, crossOrigin, deferred);
        return;
      }
      const responseType = "blob";
      const method = "GET";
      const xhrDeferred = defer_default();
      const xhr = Resource._Implementations.loadWithXhr(
        url2,
        responseType,
        method,
        void 0,
        void 0,
        xhrDeferred,
        void 0,
        void 0,
        void 0
      );
      if (defined_default(xhr) && defined_default(xhr.abort)) {
        request.cancelFunction = function() {
          xhr.abort();
        };
      }
      return xhrDeferred.promise.then(function(blob) {
        if (!defined_default(blob)) {
          deferred.reject(
            new RuntimeError_default(
              `Successfully retrieved ${url2} but it contained no content.`
            )
          );
          return;
        }
        return Resource.createImageBitmapFromBlob(blob, {
          flipY,
          premultiplyAlpha: false,
          skipColorSpaceConversion
        });
      }).then(function(image) {
        deferred.resolve(image);
      });
    }).catch(function(e) {
      deferred.reject(e);
    });
  };
  Resource.createImageBitmapFromBlob = function(blob, options) {
    Check_default.defined("options", options);
    Check_default.typeOf.bool("options.flipY", options.flipY);
    Check_default.typeOf.bool("options.premultiplyAlpha", options.premultiplyAlpha);
    Check_default.typeOf.bool(
      "options.skipColorSpaceConversion",
      options.skipColorSpaceConversion
    );
    return createImageBitmap(blob, {
      imageOrientation: options.flipY ? "flipY" : "none",
      premultiplyAlpha: options.premultiplyAlpha ? "premultiply" : "none",
      colorSpaceConversion: options.skipColorSpaceConversion ? "none" : "default"
    });
  };
  function decodeResponse(loadWithHttpResponse, responseType) {
    switch (responseType) {
      case "text":
        return loadWithHttpResponse.toString("utf8");
      case "json":
        return JSON.parse(loadWithHttpResponse.toString("utf8"));
      default:
        return new Uint8Array(loadWithHttpResponse).buffer;
    }
  }
  function loadWithHttpRequest(url2, responseType, method, data, headers, deferred, overrideMimeType) {
    let URL2;
    let zlib;
    Promise.all([import("url"), import("zlib")]).then(([urlImport, zlibImport]) => {
      URL2 = urlImport.parse(url2);
      zlib = zlibImport;
      return URL2.protocol === "https:" ? import("https") : import("http");
    }).then((http) => {
      const options = {
        protocol: URL2.protocol,
        hostname: URL2.hostname,
        port: URL2.port,
        path: URL2.path,
        query: URL2.query,
        method,
        headers
      };
      http.request(options).on("response", function(res) {
        if (res.statusCode < 200 || res.statusCode >= 300) {
          deferred.reject(
            new RequestErrorEvent_default(res.statusCode, res, res.headers)
          );
          return;
        }
        const chunkArray = [];
        res.on("data", function(chunk) {
          chunkArray.push(chunk);
        });
        res.on("end", function() {
          const result = Buffer.concat(chunkArray);
          if (res.headers["content-encoding"] === "gzip") {
            zlib.gunzip(result, function(error, resultUnzipped) {
              if (error) {
                deferred.reject(
                  new RuntimeError_default("Error decompressing response.")
                );
              } else {
                deferred.resolve(
                  decodeResponse(resultUnzipped, responseType)
                );
              }
            });
          } else {
            deferred.resolve(decodeResponse(result, responseType));
          }
        });
      }).on("error", function(e) {
        deferred.reject(new RequestErrorEvent_default());
      }).end();
    });
  }
  var noXMLHttpRequest = typeof XMLHttpRequest === "undefined";
  Resource._Implementations.loadWithXhr = function(url2, responseType, method, data, headers, deferred, overrideMimeType) {
    const dataUriRegexResult = dataUriRegex2.exec(url2);
    if (dataUriRegexResult !== null) {
      deferred.resolve(decodeDataUri(dataUriRegexResult, responseType));
      return;
    }
    if (noXMLHttpRequest) {
      loadWithHttpRequest(
        url2,
        responseType,
        method,
        data,
        headers,
        deferred,
        overrideMimeType
      );
      return;
    }
    const xhr = new XMLHttpRequest();
    if (TrustedServers_default.contains(url2)) {
      xhr.withCredentials = true;
    }
    xhr.open(method, url2, true);
    if (defined_default(overrideMimeType) && defined_default(xhr.overrideMimeType)) {
      xhr.overrideMimeType(overrideMimeType);
    }
    if (defined_default(headers)) {
      for (const key in headers) {
        if (headers.hasOwnProperty(key)) {
          xhr.setRequestHeader(key, headers[key]);
        }
      }
    }
    if (defined_default(responseType)) {
      xhr.responseType = responseType;
    }
    let localFile = false;
    if (typeof url2 === "string") {
      localFile = url2.indexOf("file://") === 0 || typeof window !== "undefined" && window.location.origin === "file://";
    }
    xhr.onload = function() {
      if ((xhr.status < 200 || xhr.status >= 300) && !(localFile && xhr.status === 0)) {
        deferred.reject(
          new RequestErrorEvent_default(
            xhr.status,
            xhr.response,
            xhr.getAllResponseHeaders()
          )
        );
        return;
      }
      const response = xhr.response;
      const browserResponseType = xhr.responseType;
      if (method === "HEAD" || method === "OPTIONS") {
        const responseHeaderString = xhr.getAllResponseHeaders();
        const splitHeaders = responseHeaderString.trim().split(/[\r\n]+/);
        const responseHeaders = {};
        splitHeaders.forEach(function(line) {
          const parts = line.split(": ");
          const header = parts.shift();
          responseHeaders[header] = parts.join(": ");
        });
        deferred.resolve(responseHeaders);
        return;
      }
      if (xhr.status === 204) {
        deferred.resolve();
      } else if (defined_default(response) && (!defined_default(responseType) || browserResponseType === responseType)) {
        deferred.resolve(response);
      } else if (responseType === "json" && typeof response === "string") {
        try {
          deferred.resolve(JSON.parse(response));
        } catch (e) {
          deferred.reject(e);
        }
      } else if ((browserResponseType === "" || browserResponseType === "document") && defined_default(xhr.responseXML) && xhr.responseXML.hasChildNodes()) {
        deferred.resolve(xhr.responseXML);
      } else if ((browserResponseType === "" || browserResponseType === "text") && defined_default(xhr.responseText)) {
        deferred.resolve(xhr.responseText);
      } else {
        deferred.reject(
          new RuntimeError_default("Invalid XMLHttpRequest response type.")
        );
      }
    };
    xhr.onerror = function(e) {
      deferred.reject(new RequestErrorEvent_default());
    };
    xhr.send(data);
    return xhr;
  };
  Resource._Implementations.loadAndExecuteScript = function(url2, functionName, deferred) {
    return loadAndExecuteScript_default(url2, functionName).catch(function(e) {
      deferred.reject(e);
    });
  };
  Resource._DefaultImplementations = {};
  Resource._DefaultImplementations.createImage = Resource._Implementations.createImage;
  Resource._DefaultImplementations.loadWithXhr = Resource._Implementations.loadWithXhr;
  Resource._DefaultImplementations.loadAndExecuteScript = Resource._Implementations.loadAndExecuteScript;
  Resource.DEFAULT = Object.freeze(
    new Resource({
      url: typeof document === "undefined" ? "" : document.location.href.split("?")[0]
    })
  );
  var Resource_default = Resource;

  // Source/Core/EarthOrientationParameters.js
  function EarthOrientationParameters(options) {
    options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
    this._dates = void 0;
    this._samples = void 0;
    this._dateColumn = -1;
    this._xPoleWanderRadiansColumn = -1;
    this._yPoleWanderRadiansColumn = -1;
    this._ut1MinusUtcSecondsColumn = -1;
    this._xCelestialPoleOffsetRadiansColumn = -1;
    this._yCelestialPoleOffsetRadiansColumn = -1;
    this._taiMinusUtcSecondsColumn = -1;
    this._columnCount = 0;
    this._lastIndex = -1;
    this._downloadPromise = void 0;
    this._dataError = void 0;
    this._addNewLeapSeconds = defaultValue_default(options.addNewLeapSeconds, true);
    if (defined_default(options.data)) {
      onDataReady(this, options.data);
    } else if (defined_default(options.url)) {
      const resource = Resource_default.createIfNeeded(options.url);
      const that = this;
      this._downloadPromise = resource.fetchJson().then(function(eopData) {
        onDataReady(that, eopData);
      }).catch(function() {
        that._dataError = `An error occurred while retrieving the EOP data from the URL ${resource.url}.`;
      });
    } else {
      onDataReady(this, {
        columnNames: [
          "dateIso8601",
          "modifiedJulianDateUtc",
          "xPoleWanderRadians",
          "yPoleWanderRadians",
          "ut1MinusUtcSeconds",
          "lengthOfDayCorrectionSeconds",
          "xCelestialPoleOffsetRadians",
          "yCelestialPoleOffsetRadians",
          "taiMinusUtcSeconds"
        ],
        samples: []
      });
    }
  }
  EarthOrientationParameters.NONE = Object.freeze({
    getPromiseToLoad: function() {
      return Promise.resolve();
    },
    compute: function(date, result) {
      if (!defined_default(result)) {
        result = new EarthOrientationParametersSample_default(0, 0, 0, 0, 0);
      } else {
        result.xPoleWander = 0;
        result.yPoleWander = 0;
        result.xPoleOffset = 0;
        result.yPoleOffset = 0;
        result.ut1MinusUtc = 0;
      }
      return result;
    }
  });
  EarthOrientationParameters.prototype.getPromiseToLoad = function() {
    return Promise.resolve(this._downloadPromise);
  };
  EarthOrientationParameters.prototype.compute = function(date, result) {
    if (!defined_default(this._samples)) {
      if (defined_default(this._dataError)) {
        throw new RuntimeError_default(this._dataError);
      }
      return void 0;
    }
    if (!defined_default(result)) {
      result = new EarthOrientationParametersSample_default(0, 0, 0, 0, 0);
    }
    if (this._samples.length === 0) {
      result.xPoleWander = 0;
      result.yPoleWander = 0;
      result.xPoleOffset = 0;
      result.yPoleOffset = 0;
      result.ut1MinusUtc = 0;
      return result;
    }
    const dates = this._dates;
    const lastIndex = this._lastIndex;
    let before = 0;
    let after = 0;
    if (defined_default(lastIndex)) {
      const previousIndexDate = dates[lastIndex];
      const nextIndexDate = dates[lastIndex + 1];
      const isAfterPrevious = JulianDate_default.lessThanOrEquals(
        previousIndexDate,
        date
      );
      const isAfterLastSample = !defined_default(nextIndexDate);
      const isBeforeNext = isAfterLastSample || JulianDate_default.greaterThanOrEquals(nextIndexDate, date);
      if (isAfterPrevious && isBeforeNext) {
        before = lastIndex;
        if (!isAfterLastSample && nextIndexDate.equals(date)) {
          ++before;
        }
        after = before + 1;
        interpolate(this, dates, this._samples, date, before, after, result);
        return result;
      }
    }
    let index = binarySearch_default(dates, date, JulianDate_default.compare, this._dateColumn);
    if (index >= 0) {
      if (index < dates.length - 1 && dates[index + 1].equals(date)) {
        ++index;
      }
      before = index;
      after = index;
    } else {
      after = ~index;
      before = after - 1;
      if (before < 0) {
        before = 0;
      }
    }
    this._lastIndex = before;
    interpolate(this, dates, this._samples, date, before, after, result);
    return result;
  };
  function compareLeapSecondDates2(leapSecond, dateToFind) {
    return JulianDate_default.compare(leapSecond.julianDate, dateToFind);
  }
  function onDataReady(eop, eopData) {
    if (!defined_default(eopData.columnNames)) {
      eop._dataError = "Error in loaded EOP data: The columnNames property is required.";
      return;
    }
    if (!defined_default(eopData.samples)) {
      eop._dataError = "Error in loaded EOP data: The samples property is required.";
      return;
    }
    const dateColumn = eopData.columnNames.indexOf("modifiedJulianDateUtc");
    const xPoleWanderRadiansColumn = eopData.columnNames.indexOf(
      "xPoleWanderRadians"
    );
    const yPoleWanderRadiansColumn = eopData.columnNames.indexOf(
      "yPoleWanderRadians"
    );
    const ut1MinusUtcSecondsColumn = eopData.columnNames.indexOf(
      "ut1MinusUtcSeconds"
    );
    const xCelestialPoleOffsetRadiansColumn = eopData.columnNames.indexOf(
      "xCelestialPoleOffsetRadians"
    );
    const yCelestialPoleOffsetRadiansColumn = eopData.columnNames.indexOf(
      "yCelestialPoleOffsetRadians"
    );
    const taiMinusUtcSecondsColumn = eopData.columnNames.indexOf(
      "taiMinusUtcSeconds"
    );
    if (dateColumn < 0 || xPoleWanderRadiansColumn < 0 || yPoleWanderRadiansColumn < 0 || ut1MinusUtcSecondsColumn < 0 || xCelestialPoleOffsetRadiansColumn < 0 || yCelestialPoleOffsetRadiansColumn < 0 || taiMinusUtcSecondsColumn < 0) {
      eop._dataError = "Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";
      return;
    }
    const samples = eop._samples = eopData.samples;
    const dates = eop._dates = [];
    eop._dateColumn = dateColumn;
    eop._xPoleWanderRadiansColumn = xPoleWanderRadiansColumn;
    eop._yPoleWanderRadiansColumn = yPoleWanderRadiansColumn;
    eop._ut1MinusUtcSecondsColumn = ut1MinusUtcSecondsColumn;
    eop._xCelestialPoleOffsetRadiansColumn = xCelestialPoleOffsetRadiansColumn;
    eop._yCelestialPoleOffsetRadiansColumn = yCelestialPoleOffsetRadiansColumn;
    eop._taiMinusUtcSecondsColumn = taiMinusUtcSecondsColumn;
    eop._columnCount = eopData.columnNames.length;
    eop._lastIndex = void 0;
    let lastTaiMinusUtc;
    const addNewLeapSeconds = eop._addNewLeapSeconds;
    for (let i = 0, len = samples.length; i < len; i += eop._columnCount) {
      const mjd = samples[i + dateColumn];
      const taiMinusUtc = samples[i + taiMinusUtcSecondsColumn];
      const day = mjd + TimeConstants_default.MODIFIED_JULIAN_DATE_DIFFERENCE;
      const date = new JulianDate_default(day, taiMinusUtc, TimeStandard_default.TAI);
      dates.push(date);
      if (addNewLeapSeconds) {
        if (taiMinusUtc !== lastTaiMinusUtc && defined_default(lastTaiMinusUtc)) {
          const leapSeconds = JulianDate_default.leapSeconds;
          const leapSecondIndex = binarySearch_default(
            leapSeconds,
            date,
            compareLeapSecondDates2
          );
          if (leapSecondIndex < 0) {
            const leapSecond = new LeapSecond_default(date, taiMinusUtc);
            leapSeconds.splice(~leapSecondIndex, 0, leapSecond);
          }
        }
        lastTaiMinusUtc = taiMinusUtc;
      }
    }
  }
  function fillResultFromIndex(eop, samples, index, columnCount, result) {
    const start = index * columnCount;
    result.xPoleWander = samples[start + eop._xPoleWanderRadiansColumn];
    result.yPoleWander = samples[start + eop._yPoleWanderRadiansColumn];
    result.xPoleOffset = samples[start + eop._xCelestialPoleOffsetRadiansColumn];
    result.yPoleOffset = samples[start + eop._yCelestialPoleOffsetRadiansColumn];
    result.ut1MinusUtc = samples[start + eop._ut1MinusUtcSecondsColumn];
  }
  function linearInterp(dx, y1, y2) {
    return y1 + dx * (y2 - y1);
  }
  function interpolate(eop, dates, samples, date, before, after, result) {
    const columnCount = eop._columnCount;
    if (after > dates.length - 1) {
      result.xPoleWander = 0;
      result.yPoleWander = 0;
      result.xPoleOffset = 0;
      result.yPoleOffset = 0;
      result.ut1MinusUtc = 0;
      return result;
    }
    const beforeDate = dates[before];
    const afterDate = dates[after];
    if (beforeDate.equals(afterDate) || date.equals(beforeDate)) {
      fillResultFromIndex(eop, samples, before, columnCount, result);
      return result;
    } else if (date.equals(afterDate)) {
      fillResultFromIndex(eop, samples, after, columnCount, result);
      return result;
    }
    const factor2 = JulianDate_default.secondsDifference(date, beforeDate) / JulianDate_default.secondsDifference(afterDate, beforeDate);
    const startBefore = before * columnCount;
    const startAfter = after * columnCount;
    let beforeUt1MinusUtc = samples[startBefore + eop._ut1MinusUtcSecondsColumn];
    let afterUt1MinusUtc = samples[startAfter + eop._ut1MinusUtcSecondsColumn];
    const offsetDifference = afterUt1MinusUtc - beforeUt1MinusUtc;
    if (offsetDifference > 0.5 || offsetDifference < -0.5) {
      const beforeTaiMinusUtc = samples[startBefore + eop._taiMinusUtcSecondsColumn];
      const afterTaiMinusUtc = samples[startAfter + eop._taiMinusUtcSecondsColumn];
      if (beforeTaiMinusUtc !== afterTaiMinusUtc) {
        if (afterDate.equals(date)) {
          beforeUt1MinusUtc = afterUt1MinusUtc;
        } else {
          afterUt1MinusUtc -= afterTaiMinusUtc - beforeTaiMinusUtc;
        }
      }
    }
    result.xPoleWander = linearInterp(
      factor2,
      samples[startBefore + eop._xPoleWanderRadiansColumn],
      samples[startAfter + eop._xPoleWanderRadiansColumn]
    );
    result.yPoleWander = linearInterp(
      factor2,
      samples[startBefore + eop._yPoleWanderRadiansColumn],
      samples[startAfter + eop._yPoleWanderRadiansColumn]
    );
    result.xPoleOffset = linearInterp(
      factor2,
      samples[startBefore + eop._xCelestialPoleOffsetRadiansColumn],
      samples[startAfter + eop._xCelestialPoleOffsetRadiansColumn]
    );
    result.yPoleOffset = linearInterp(
      factor2,
      samples[startBefore + eop._yCelestialPoleOffsetRadiansColumn],
      samples[startAfter + eop._yCelestialPoleOffsetRadiansColumn]
    );
    result.ut1MinusUtc = linearInterp(
      factor2,
      beforeUt1MinusUtc,
      afterUt1MinusUtc
    );
    return result;
  }
  var EarthOrientationParameters_default = EarthOrientationParameters;

  // Source/Core/HeadingPitchRoll.js
  function HeadingPitchRoll(heading, pitch, roll) {
    this.heading = defaultValue_default(heading, 0);
    this.pitch = defaultValue_default(pitch, 0);
    this.roll = defaultValue_default(roll, 0);
  }
  HeadingPitchRoll.fromQuaternion = function(quaternion, result) {
    if (!defined_default(quaternion)) {
      throw new DeveloperError_default("quaternion is required");
    }
    if (!defined_default(result)) {
      result = new HeadingPitchRoll();
    }
    const test = 2 * (quaternion.w * quaternion.y - quaternion.z * quaternion.x);
    const denominatorRoll = 1 - 2 * (quaternion.x * quaternion.x + quaternion.y * quaternion.y);
    const numeratorRoll = 2 * (quaternion.w * quaternion.x + quaternion.y * quaternion.z);
    const denominatorHeading = 1 - 2 * (quaternion.y * quaternion.y + quaternion.z * quaternion.z);
    const numeratorHeading = 2 * (quaternion.w * quaternion.z + quaternion.x * quaternion.y);
    result.heading = -Math.atan2(numeratorHeading, denominatorHeading);
    result.roll = Math.atan2(numeratorRoll, denominatorRoll);
    result.pitch = -Math_default.asinClamped(test);
    return result;
  };
  HeadingPitchRoll.fromDegrees = function(heading, pitch, roll, result) {
    if (!defined_default(heading)) {
      throw new DeveloperError_default("heading is required");
    }
    if (!defined_default(pitch)) {
      throw new DeveloperError_default("pitch is required");
    }
    if (!defined_default(roll)) {
      throw new DeveloperError_default("roll is required");
    }
    if (!defined_default(result)) {
      result = new HeadingPitchRoll();
    }
    result.heading = heading * Math_default.RADIANS_PER_DEGREE;
    result.pitch = pitch * Math_default.RADIANS_PER_DEGREE;
    result.roll = roll * Math_default.RADIANS_PER_DEGREE;
    return result;
  };
  HeadingPitchRoll.clone = function(headingPitchRoll, result) {
    if (!defined_default(headingPitchRoll)) {
      return void 0;
    }
    if (!defined_default(result)) {
      return new HeadingPitchRoll(
        headingPitchRoll.heading,
        headingPitchRoll.pitch,
        headingPitchRoll.roll
      );
    }
    result.heading = headingPitchRoll.heading;
    result.pitch = headingPitchRoll.pitch;
    result.roll = headingPitchRoll.roll;
    return result;
  };
  HeadingPitchRoll.equals = function(left, right) {
    return left === right || defined_default(left) && defined_default(right) && left.heading === right.heading && left.pitch === right.pitch && left.roll === right.roll;
  };
  HeadingPitchRoll.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
    return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
      left.heading,
      right.heading,
      relativeEpsilon,
      absoluteEpsilon
    ) && Math_default.equalsEpsilon(
      left.pitch,
      right.pitch,
      relativeEpsilon,
      absoluteEpsilon
    ) && Math_default.equalsEpsilon(
      left.roll,
      right.roll,
      relativeEpsilon,
      absoluteEpsilon
    );
  };
  HeadingPitchRoll.prototype.clone = function(result) {
    return HeadingPitchRoll.clone(this, result);
  };
  HeadingPitchRoll.prototype.equals = function(right) {
    return HeadingPitchRoll.equals(this, right);
  };
  HeadingPitchRoll.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
    return HeadingPitchRoll.equalsEpsilon(
      this,
      right,
      relativeEpsilon,
      absoluteEpsilon
   