/**
 * @license
 * Cesium - https://github.com/CesiumGS/cesium
 * Version 1.99
 *
 * Copyright 2011-2022 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/main/LICENSE.md for full licensing details.
 */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod2) => function __require() {
  return mod2 || (0, cb[__getOwnPropNames(cb)[0]])((mod2 = { exports: {} }).exports, mod2), mod2.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod2, isNodeMode, target) => (target = mod2 != null ? __create(__getProtoOf(mod2)) : {}, __copyProps(
  isNodeMode || !mod2 || !mod2.__esModule ? __defProp(target, "default", { value: mod2, enumerable: true }) : target,
  mod2
));
var __toCommonJS = (mod2) => __copyProps(__defProp({}, "__esModule", { value: true }), mod2);

// node_modules/mersenne-twister/src/mersenne-twister.js
var require_mersenne_twister = __commonJS({
  "node_modules/mersenne-twister/src/mersenne-twister.js"(exports2, module2) {
    var MersenneTwister4 = function(seed) {
      if (seed == void 0) {
        seed = new Date().getTime();
      }
      this.N = 624;
      this.M = 397;
      this.MATRIX_A = 2567483615;
      this.UPPER_MASK = 2147483648;
      this.LOWER_MASK = 2147483647;
      this.mt = new Array(this.N);
      this.mti = this.N + 1;
      if (seed.constructor == Array) {
        this.init_by_array(seed, seed.length);
      } else {
        this.init_seed(seed);
      }
    };
    MersenneTwister4.prototype.init_seed = function(s) {
      this.mt[0] = s >>> 0;
      for (this.mti = 1; this.mti < this.N; this.mti++) {
        var s = this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30;
        this.mt[this.mti] = (((s & 4294901760) >>> 16) * 1812433253 << 16) + (s & 65535) * 1812433253 + this.mti;
        this.mt[this.mti] >>>= 0;
      }
    };
    MersenneTwister4.prototype.init_by_array = function(init_key, key_length) {
      var i, j, k;
      this.init_seed(19650218);
      i = 1;
      j = 0;
      k = this.N > key_length ? this.N : key_length;
      for (; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1664525 << 16) + (s & 65535) * 1664525) + init_key[j] + j;
        this.mt[i] >>>= 0;
        i++;
        j++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
        if (j >= key_length)
          j = 0;
      }
      for (k = this.N - 1; k; k--) {
        var s = this.mt[i - 1] ^ this.mt[i - 1] >>> 30;
        this.mt[i] = (this.mt[i] ^ (((s & 4294901760) >>> 16) * 1566083941 << 16) + (s & 65535) * 1566083941) - i;
        this.mt[i] >>>= 0;
        i++;
        if (i >= this.N) {
          this.mt[0] = this.mt[this.N - 1];
          i = 1;
        }
      }
      this.mt[0] = 2147483648;
    };
    MersenneTwister4.prototype.random_int = function() {
      var y;
      var mag01 = new Array(0, this.MATRIX_A);
      if (this.mti >= this.N) {
        var kk;
        if (this.mti == this.N + 1)
          this.init_seed(5489);
        for (kk = 0; kk < this.N - this.M; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + this.M] ^ y >>> 1 ^ mag01[y & 1];
        }
        for (; kk < this.N - 1; kk++) {
          y = this.mt[kk] & this.UPPER_MASK | this.mt[kk + 1] & this.LOWER_MASK;
          this.mt[kk] = this.mt[kk + (this.M - this.N)] ^ y >>> 1 ^ mag01[y & 1];
        }
        y = this.mt[this.N - 1] & this.UPPER_MASK | this.mt[0] & this.LOWER_MASK;
        this.mt[this.N - 1] = this.mt[this.M - 1] ^ y >>> 1 ^ mag01[y & 1];
        this.mti = 0;
      }
      y = this.mt[this.mti++];
      y ^= y >>> 11;
      y ^= y << 7 & 2636928640;
      y ^= y << 15 & 4022730752;
      y ^= y >>> 18;
      return y >>> 0;
    };
    MersenneTwister4.prototype.random_int31 = function() {
      return this.random_int() >>> 1;
    };
    MersenneTwister4.prototype.random_incl = function() {
      return this.random_int() * (1 / 4294967295);
    };
    MersenneTwister4.prototype.random = function() {
      return this.random_int() * (1 / 4294967296);
    };
    MersenneTwister4.prototype.random_excl = function() {
      return (this.random_int() + 0.5) * (1 / 4294967296);
    };
    MersenneTwister4.prototype.random_long = function() {
      var a3 = this.random_int() >>> 5, b = this.random_int() >>> 6;
      return (a3 * 67108864 + b) * (1 / 9007199254740992);
    };
    module2.exports = MersenneTwister4;
  }
});

// node_modules/urijs/src/punycode.js
var require_punycode = __commonJS({
  "node_modules/urijs/src/punycode.js"(exports2, module2) {
    /*! https://mths.be/punycode v1.4.0 by @mathias */
    (function(root) {
      var freeExports = typeof exports2 == "object" && exports2 && !exports2.nodeType && exports2;
      var freeModule = typeof module2 == "object" && module2 && !module2.nodeType && module2;
      var freeGlobal = typeof global == "object" && global;
      if (freeGlobal.global === freeGlobal || freeGlobal.window === freeGlobal || freeGlobal.self === freeGlobal) {
        root = freeGlobal;
      }
      var punycode, maxInt = 2147483647, base = 36, tMin = 1, tMax = 26, skew = 38, damp = 700, initialBias = 72, initialN = 128, delimiter = "-", regexPunycode = /^xn--/, regexNonASCII = /[^\x20-\x7E]/, regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, errors = {
        "overflow": "Overflow: input needs wider integers to process",
        "not-basic": "Illegal input >= 0x80 (not a basic code point)",
        "invalid-input": "Invalid input"
      }, baseMinusTMin = base - tMin, floor = Math.floor, stringFromCharCode = String.fromCharCode, key;
      function error(type) {
        throw new RangeError(errors[type]);
      }
      function map(array, fn) {
        var length3 = array.length;
        var result = [];
        while (length3--) {
          result[length3] = fn(array[length3]);
        }
        return result;
      }
      function mapDomain(string, fn) {
        var parts = string.split("@");
        var result = "";
        if (parts.length > 1) {
          result = parts[0] + "@";
          string = parts[1];
        }
        string = string.replace(regexSeparators, ".");
        var labels = string.split(".");
        var encoded = map(labels, fn).join(".");
        return result + encoded;
      }
      function ucs2decode(string) {
        var output = [], counter = 0, length3 = string.length, value, extra;
        while (counter < length3) {
          value = string.charCodeAt(counter++);
          if (value >= 55296 && value <= 56319 && counter < length3) {
            extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
            } else {
              output.push(value);
              counter--;
            }
          } else {
            output.push(value);
          }
        }
        return output;
      }
      function ucs2encode(array) {
        return map(array, function(value) {
          var output = "";
          if (value > 65535) {
            value -= 65536;
            output += stringFromCharCode(value >>> 10 & 1023 | 55296);
            value = 56320 | value & 1023;
          }
          output += stringFromCharCode(value);
          return output;
        }).join("");
      }
      function basicToDigit(codePoint) {
        if (codePoint - 48 < 10) {
          return codePoint - 22;
        }
        if (codePoint - 65 < 26) {
          return codePoint - 65;
        }
        if (codePoint - 97 < 26) {
          return codePoint - 97;
        }
        return base;
      }
      function digitToBasic(digit, flag) {
        return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
      }
      function adapt(delta, numPoints, firstTime) {
        var k = 0;
        delta = firstTime ? floor(delta / damp) : delta >> 1;
        delta += floor(delta / numPoints);
        for (; delta > baseMinusTMin * tMax >> 1; k += base) {
          delta = floor(delta / baseMinusTMin);
        }
        return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
      }
      function decode(input) {
        var output = [], inputLength = input.length, out, i = 0, n = initialN, bias = initialBias, basic, j, index, oldi, w, k, digit, t, baseMinusT;
        basic = input.lastIndexOf(delimiter);
        if (basic < 0) {
          basic = 0;
        }
        for (j = 0; j < basic; ++j) {
          if (input.charCodeAt(j) >= 128) {
            error("not-basic");
          }
          output.push(input.charCodeAt(j));
        }
        for (index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
          for (oldi = i, w = 1, k = base; ; k += base) {
            if (index >= inputLength) {
              error("invalid-input");
            }
            digit = basicToDigit(input.charCodeAt(index++));
            if (digit >= base || digit > floor((maxInt - i) / w)) {
              error("overflow");
            }
            i += digit * w;
            t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
            if (digit < t) {
              break;
            }
            baseMinusT = base - t;
            if (w > floor(maxInt / baseMinusT)) {
              error("overflow");
            }
            w *= baseMinusT;
          }
          out = output.length + 1;
          bias = adapt(i - oldi, out, oldi == 0);
          if (floor(i / out) > maxInt - n) {
            error("overflow");
          }
          n += floor(i / out);
          i %= out;
          output.splice(i++, 0, n);
        }
        return ucs2encode(output);
      }
      function encode(input) {
        var n, delta, handledCPCount, basicLength, bias, j, m, q, k, t, currentValue, output = [], inputLength, handledCPCountPlusOne, baseMinusT, qMinusT;
        input = ucs2decode(input);
        inputLength = input.length;
        n = initialN;
        delta = 0;
        bias = initialBias;
        for (j = 0; j < inputLength; ++j) {
          currentValue = input[j];
          if (currentValue < 128) {
            output.push(stringFromCharCode(currentValue));
          }
        }
        handledCPCount = basicLength = output.length;
        if (basicLength) {
          output.push(delimiter);
        }
        while (handledCPCount < inputLength) {
          for (m = maxInt, j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue >= n && currentValue < m) {
              m = currentValue;
            }
          }
          handledCPCountPlusOne = handledCPCount + 1;
          if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
            error("overflow");
          }
          delta += (m - n) * handledCPCountPlusOne;
          n = m;
          for (j = 0; j < inputLength; ++j) {
            currentValue = input[j];
            if (currentValue < n && ++delta > maxInt) {
              error("overflow");
            }
            if (currentValue == n) {
              for (q = delta, k = base; ; k += base) {
                t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                if (q < t) {
                  break;
                }
                qMinusT = q - t;
                baseMinusT = base - t;
                output.push(
                  stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
                );
                q = floor(qMinusT / baseMinusT);
              }
              output.push(stringFromCharCode(digitToBasic(q, 0)));
              bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
              delta = 0;
              ++handledCPCount;
            }
          }
          ++delta;
          ++n;
        }
        return output.join("");
      }
      function toUnicode(input) {
        return mapDomain(input, function(string) {
          return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
        });
      }
      function toASCII(input) {
        return mapDomain(input, function(string) {
          return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
        });
      }
      punycode = {
        "version": "1.3.2",
        "ucs2": {
          "decode": ucs2decode,
          "encode": ucs2encode
        },
        "decode": decode,
        "encode": encode,
        "toASCII": toASCII,
        "toUnicode": toUnicode
      };
      if (typeof define == "function" && typeof define.amd == "object" && define.amd) {
        define("punycode", function() {
          return punycode;
        });
      } else if (freeExports && freeModule) {
        if (module2.exports == freeExports) {
          freeModule.exports = punycode;
        } else {
          for (key in punycode) {
            punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
          }
        }
      } else {
        root.punycode = punycode;
      }
    })(exports2);
  }
});

// node_modules/urijs/src/IPv6.js
var require_IPv6 = __commonJS({
  "node_modules/urijs/src/IPv6.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     * IPv6 Support
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.IPv6 = factory(root);
      }
    })(exports2, function(root) {
      "use strict";
      var _IPv6 = root && root.IPv6;
      function bestPresentation(address) {
        var _address = address.toLowerCase();
        var segments = _address.split(":");
        var length3 = segments.length;
        var total = 8;
        if (segments[0] === "" && segments[1] === "" && segments[2] === "") {
          segments.shift();
          segments.shift();
        } else if (segments[0] === "" && segments[1] === "") {
          segments.shift();
        } else if (segments[length3 - 1] === "" && segments[length3 - 2] === "") {
          segments.pop();
        }
        length3 = segments.length;
        if (segments[length3 - 1].indexOf(".") !== -1) {
          total = 7;
        }
        var pos;
        for (pos = 0; pos < length3; pos++) {
          if (segments[pos] === "") {
            break;
          }
        }
        if (pos < total) {
          segments.splice(pos, 1, "0000");
          while (segments.length < total) {
            segments.splice(pos, 0, "0000");
          }
        }
        var _segments;
        for (var i = 0; i < total; i++) {
          _segments = segments[i].split("");
          for (var j = 0; j < 3; j++) {
            if (_segments[0] === "0" && _segments.length > 1) {
              _segments.splice(0, 1);
            } else {
              break;
            }
          }
          segments[i] = _segments.join("");
        }
        var best = -1;
        var _best = 0;
        var _current = 0;
        var current = -1;
        var inzeroes = false;
        for (i = 0; i < total; i++) {
          if (inzeroes) {
            if (segments[i] === "0") {
              _current += 1;
            } else {
              inzeroes = false;
              if (_current > _best) {
                best = current;
                _best = _current;
              }
            }
          } else {
            if (segments[i] === "0") {
              inzeroes = true;
              current = i;
              _current = 1;
            }
          }
        }
        if (_current > _best) {
          best = current;
          _best = _current;
        }
        if (_best > 1) {
          segments.splice(best, _best, "");
        }
        length3 = segments.length;
        var result = "";
        if (segments[0] === "") {
          result = ":";
        }
        for (i = 0; i < length3; i++) {
          result += segments[i];
          if (i === length3 - 1) {
            break;
          }
          result += ":";
        }
        if (segments[length3 - 1] === "") {
          result += ":";
        }
        return result;
      }
      function noConflict() {
        if (root.IPv6 === this) {
          root.IPv6 = _IPv6;
        }
        return this;
      }
      return {
        best: bestPresentation,
        noConflict
      };
    });
  }
});

// node_modules/urijs/src/SecondLevelDomains.js
var require_SecondLevelDomains = __commonJS({
  "node_modules/urijs/src/SecondLevelDomains.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     * Second Level Domain (SLD) Support
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory();
      } else if (typeof define === "function" && define.amd) {
        define(factory);
      } else {
        root.SecondLevelDomains = factory(root);
      }
    })(exports2, function(root) {
      "use strict";
      var _SecondLevelDomains = root && root.SecondLevelDomains;
      var SLD = {
        list: {
          "ac": " com gov mil net org ",
          "ae": " ac co gov mil name net org pro sch ",
          "af": " com edu gov net org ",
          "al": " com edu gov mil net org ",
          "ao": " co ed gv it og pb ",
          "ar": " com edu gob gov int mil net org tur ",
          "at": " ac co gv or ",
          "au": " asn com csiro edu gov id net org ",
          "ba": " co com edu gov mil net org rs unbi unmo unsa untz unze ",
          "bb": " biz co com edu gov info net org store tv ",
          "bh": " biz cc com edu gov info net org ",
          "bn": " com edu gov net org ",
          "bo": " com edu gob gov int mil net org tv ",
          "br": " adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",
          "bs": " com edu gov net org ",
          "bz": " du et om ov rg ",
          "ca": " ab bc mb nb nf nl ns nt nu on pe qc sk yk ",
          "ck": " biz co edu gen gov info net org ",
          "cn": " ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",
          "co": " com edu gov mil net nom org ",
          "cr": " ac c co ed fi go or sa ",
          "cy": " ac biz com ekloges gov ltd name net org parliament press pro tm ",
          "do": " art com edu gob gov mil net org sld web ",
          "dz": " art asso com edu gov net org pol ",
          "ec": " com edu fin gov info med mil net org pro ",
          "eg": " com edu eun gov mil name net org sci ",
          "er": " com edu gov ind mil net org rochest w ",
          "es": " com edu gob nom org ",
          "et": " biz com edu gov info name net org ",
          "fj": " ac biz com info mil name net org pro ",
          "fk": " ac co gov net nom org ",
          "fr": " asso com f gouv nom prd presse tm ",
          "gg": " co net org ",
          "gh": " com edu gov mil org ",
          "gn": " ac com gov net org ",
          "gr": " com edu gov mil net org ",
          "gt": " com edu gob ind mil net org ",
          "gu": " com edu gov net org ",
          "hk": " com edu gov idv net org ",
          "hu": " 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",
          "id": " ac co go mil net or sch web ",
          "il": " ac co gov idf k12 muni net org ",
          "in": " ac co edu ernet firm gen gov i ind mil net nic org res ",
          "iq": " com edu gov i mil net org ",
          "ir": " ac co dnssec gov i id net org sch ",
          "it": " edu gov ",
          "je": " co net org ",
          "jo": " com edu gov mil name net org sch ",
          "jp": " ac ad co ed go gr lg ne or ",
          "ke": " ac co go info me mobi ne or sc ",
          "kh": " com edu gov mil net org per ",
          "ki": " biz com de edu gov info mob net org tel ",
          "km": " asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",
          "kn": " edu gov net org ",
          "kr": " ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",
          "kw": " com edu gov net org ",
          "ky": " com edu gov net org ",
          "kz": " com edu gov mil net org ",
          "lb": " com edu gov net org ",
          "lk": " assn com edu gov grp hotel int ltd net ngo org sch soc web ",
          "lr": " com edu gov net org ",
          "lv": " asn com conf edu gov id mil net org ",
          "ly": " com edu gov id med net org plc sch ",
          "ma": " ac co gov m net org press ",
          "mc": " asso tm ",
          "me": " ac co edu gov its net org priv ",
          "mg": " com edu gov mil nom org prd tm ",
          "mk": " com edu gov inf name net org pro ",
          "ml": " com edu gov net org presse ",
          "mn": " edu gov org ",
          "mo": " com edu gov net org ",
          "mt": " com edu gov net org ",
          "mv": " aero biz com coop edu gov info int mil museum name net org pro ",
          "mw": " ac co com coop edu gov int museum net org ",
          "mx": " com edu gob net org ",
          "my": " com edu gov mil name net org sch ",
          "nf": " arts com firm info net other per rec store web ",
          "ng": " biz com edu gov mil mobi name net org sch ",
          "ni": " ac co com edu gob mil net nom org ",
          "np": " com edu gov mil net org ",
          "nr": " biz com edu gov info net org ",
          "om": " ac biz co com edu gov med mil museum net org pro sch ",
          "pe": " com edu gob mil net nom org sld ",
          "ph": " com edu gov i mil net ngo org ",
          "pk": " biz com edu fam gob gok gon gop gos gov net org web ",
          "pl": " art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",
          "pr": " ac biz com edu est gov info isla name net org pro prof ",
          "ps": " com edu gov net org plo sec ",
          "pw": " belau co ed go ne or ",
          "ro": " arts com firm info nom nt org rec store tm www ",
          "rs": " ac co edu gov in org ",
          "sb": " com edu gov net org ",
          "sc": " com edu gov net org ",
          "sh": " co com edu gov net nom org ",
          "sl": " com edu gov net org ",
          "st": " co com consulado edu embaixada gov mil net org principe saotome store ",
          "sv": " com edu gob org red ",
          "sz": " ac co org ",
          "tr": " av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",
          "tt": " aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",
          "tw": " club com ebiz edu game gov idv mil net org ",
          "mu": " ac co com gov net or org ",
          "mz": " ac co edu gov org ",
          "na": " co com ",
          "nz": " ac co cri geek gen govt health iwi maori mil net org parliament school ",
          "pa": " abo ac com edu gob ing med net nom org sld ",
          "pt": " com edu gov int net nome org publ ",
          "py": " com edu gov mil net org ",
          "qa": " com edu gov mil net org ",
          "re": " asso com nom ",
          "ru": " ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",
          "rw": " ac co com edu gouv gov int mil net ",
          "sa": " com edu gov med net org pub sch ",
          "sd": " com edu gov info med net org tv ",
          "se": " a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",
          "sg": " com edu gov idn net org per ",
          "sn": " art com edu gouv org perso univ ",
          "sy": " com edu gov mil net news org ",
          "th": " ac co go in mi net or ",
          "tj": " ac biz co com edu go gov info int mil name net nic org test web ",
          "tn": " agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",
          "tz": " ac co go ne or ",
          "ua": " biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",
          "ug": " ac co go ne or org sc ",
          "uk": " ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",
          "us": " dni fed isa kids nsn ",
          "uy": " com edu gub mil net org ",
          "ve": " co com edu gob info mil net org web ",
          "vi": " co com k12 net org ",
          "vn": " ac biz com edu gov health info int name net org pro ",
          "ye": " co com gov ltd me net org plc ",
          "yu": " ac co edu gov org ",
          "za": " ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",
          "zm": " ac co com edu gov net org sch ",
          "com": "ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",
          "net": "gb jp se uk ",
          "org": "ae",
          "de": "com "
        },
        has: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") >= 0;
        },
        is: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return false;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset >= 0) {
            return false;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return false;
          }
          return sldList.indexOf(" " + domain.slice(0, tldOffset) + " ") >= 0;
        },
        get: function(domain) {
          var tldOffset = domain.lastIndexOf(".");
          if (tldOffset <= 0 || tldOffset >= domain.length - 1) {
            return null;
          }
          var sldOffset = domain.lastIndexOf(".", tldOffset - 1);
          if (sldOffset <= 0 || sldOffset >= tldOffset - 1) {
            return null;
          }
          var sldList = SLD.list[domain.slice(tldOffset + 1)];
          if (!sldList) {
            return null;
          }
          if (sldList.indexOf(" " + domain.slice(sldOffset + 1, tldOffset) + " ") < 0) {
            return null;
          }
          return domain.slice(sldOffset + 1);
        },
        noConflict: function() {
          if (root.SecondLevelDomains === this) {
            root.SecondLevelDomains = _SecondLevelDomains;
          }
          return this;
        }
      };
      return SLD;
    });
  }
});

// node_modules/urijs/src/URI.js
var require_URI = __commonJS({
  "node_modules/urijs/src/URI.js"(exports2, module2) {
    /*!
     * URI.js - Mutating URLs
     *
     * Version: 1.19.11
     *
     * Author: Rodney Rehm
     * Web: http://medialize.github.io/URI.js/
     *
     * Licensed under
     *   MIT License http://www.opensource.org/licenses/mit-license
     *
     */
    (function(root, factory) {
      "use strict";
      if (typeof module2 === "object" && module2.exports) {
        module2.exports = factory(require_punycode(), require_IPv6(), require_SecondLevelDomains());
      } else if (typeof define === "function" && define.amd) {
        define(["./punycode", "./IPv6", "./SecondLevelDomains"], factory);
      } else {
        root.URI = factory(root.punycode, root.IPv6, root.SecondLevelDomains, root);
      }
    })(exports2, function(punycode, IPv6, SLD, root) {
      "use strict";
      var _URI = root && root.URI;
      function URI(url2, base) {
        var _urlSupplied = arguments.length >= 1;
        var _baseSupplied = arguments.length >= 2;
        if (!(this instanceof URI)) {
          if (_urlSupplied) {
            if (_baseSupplied) {
              return new URI(url2, base);
            }
            return new URI(url2);
          }
          return new URI();
        }
        if (url2 === void 0) {
          if (_urlSupplied) {
            throw new TypeError("undefined is not a valid argument for URI");
          }
          if (typeof location !== "undefined") {
            url2 = location.href + "";
          } else {
            url2 = "";
          }
        }
        if (url2 === null) {
          if (_urlSupplied) {
            throw new TypeError("null is not a valid argument for URI");
          }
        }
        this.href(url2);
        if (base !== void 0) {
          return this.absoluteTo(base);
        }
        return this;
      }
      function isInteger(value) {
        return /^[0-9]+$/.test(value);
      }
      URI.version = "1.19.11";
      var p = URI.prototype;
      var hasOwn = Object.prototype.hasOwnProperty;
      function escapeRegEx(string) {
        return string.replace(/([.*+?^=!:${}()|[\]\/\\])/g, "\\$1");
      }
      function getType(value) {
        if (value === void 0) {
          return "Undefined";
        }
        return String(Object.prototype.toString.call(value)).slice(8, -1);
      }
      function isArray(obj) {
        return getType(obj) === "Array";
      }
      function filterArrayValues(data, value) {
        var lookup = {};
        var i, length3;
        if (getType(value) === "RegExp") {
          lookup = null;
        } else if (isArray(value)) {
          for (i = 0, length3 = value.length; i < length3; i++) {
            lookup[value[i]] = true;
          }
        } else {
          lookup[value] = true;
        }
        for (i = 0, length3 = data.length; i < length3; i++) {
          var _match = lookup && lookup[data[i]] !== void 0 || !lookup && value.test(data[i]);
          if (_match) {
            data.splice(i, 1);
            length3--;
            i--;
          }
        }
        return data;
      }
      function arrayContains(list, value) {
        var i, length3;
        if (isArray(value)) {
          for (i = 0, length3 = value.length; i < length3; i++) {
            if (!arrayContains(list, value[i])) {
              return false;
            }
          }
          return true;
        }
        var _type = getType(value);
        for (i = 0, length3 = list.length; i < length3; i++) {
          if (_type === "RegExp") {
            if (typeof list[i] === "string" && list[i].match(value)) {
              return true;
            }
          } else if (list[i] === value) {
            return true;
          }
        }
        return false;
      }
      function arraysEqual(one, two) {
        if (!isArray(one) || !isArray(two)) {
          return false;
        }
        if (one.length !== two.length) {
          return false;
        }
        one.sort();
        two.sort();
        for (var i = 0, l = one.length; i < l; i++) {
          if (one[i] !== two[i]) {
            return false;
          }
        }
        return true;
      }
      function trimSlashes(text) {
        var trim_expression = /^\/+|\/+$/g;
        return text.replace(trim_expression, "");
      }
      URI._parts = function() {
        return {
          protocol: null,
          username: null,
          password: null,
          hostname: null,
          urn: null,
          port: null,
          path: null,
          query: null,
          fragment: null,
          preventInvalidHostname: URI.preventInvalidHostname,
          duplicateQueryParameters: URI.duplicateQueryParameters,
          escapeQuerySpace: URI.escapeQuerySpace
        };
      };
      URI.preventInvalidHostname = false;
      URI.duplicateQueryParameters = false;
      URI.escapeQuerySpace = true;
      URI.protocol_expression = /^[a-z][a-z0-9.+-]*$/i;
      URI.idn_expression = /[^a-z0-9\._-]/i;
      URI.punycode_expression = /(xn--)/i;
      URI.ip4_expression = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
      URI.ip6_expression = /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
      URI.find_uri_expression = /\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig;
      URI.findUri = {
        start: /\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,
        end: /[\s\r\n]|$/,
        trim: /[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,
        parens: /(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g
      };
      URI.leading_whitespace_expression = /^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/;
      URI.ascii_tab_whitespace = /[\u0009\u000A\u000D]+/g;
      URI.defaultPorts = {
        http: "80",
        https: "443",
        ftp: "21",
        gopher: "70",
        ws: "80",
        wss: "443"
      };
      URI.hostProtocols = [
        "http",
        "https"
      ];
      URI.invalid_hostname_characters = /[^a-zA-Z0-9\.\-:_]/;
      URI.domAttributes = {
        "a": "href",
        "blockquote": "cite",
        "link": "href",
        "base": "href",
        "script": "src",
        "form": "action",
        "img": "src",
        "area": "href",
        "iframe": "src",
        "embed": "src",
        "source": "src",
        "track": "src",
        "input": "src",
        "audio": "src",
        "video": "src"
      };
      URI.getDomAttribute = function(node) {
        if (!node || !node.nodeName) {
          return void 0;
        }
        var nodeName = node.nodeName.toLowerCase();
        if (nodeName === "input" && node.type !== "image") {
          return void 0;
        }
        return URI.domAttributes[nodeName];
      };
      function escapeForDumbFirefox36(value) {
        return escape(value);
      }
      function strictEncodeURIComponent(string) {
        return encodeURIComponent(string).replace(/[!'()*]/g, escapeForDumbFirefox36).replace(/\*/g, "%2A");
      }
      URI.encode = strictEncodeURIComponent;
      URI.decode = decodeURIComponent;
      URI.iso8859 = function() {
        URI.encode = escape;
        URI.decode = unescape;
      };
      URI.unicode = function() {
        URI.encode = strictEncodeURIComponent;
        URI.decode = decodeURIComponent;
      };
      URI.characters = {
        pathname: {
          encode: {
            expression: /%(24|26|2B|2C|3B|3D|3A|40)/ig,
            map: {
              "%24": "$",
              "%26": "&",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%3A": ":",
              "%40": "@"
            }
          },
          decode: {
            expression: /[\/\?#]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23"
            }
          }
        },
        reserved: {
          encode: {
            expression: /%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,
            map: {
              "%3A": ":",
              "%2F": "/",
              "%3F": "?",
              "%23": "#",
              "%5B": "[",
              "%5D": "]",
              "%40": "@",
              "%21": "!",
              "%24": "$",
              "%26": "&",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "="
            }
          }
        },
        urnpath: {
          encode: {
            expression: /%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,
            map: {
              "%21": "!",
              "%24": "$",
              "%27": "'",
              "%28": "(",
              "%29": ")",
              "%2A": "*",
              "%2B": "+",
              "%2C": ",",
              "%3B": ";",
              "%3D": "=",
              "%40": "@"
            }
          },
          decode: {
            expression: /[\/\?#:]/g,
            map: {
              "/": "%2F",
              "?": "%3F",
              "#": "%23",
              ":": "%3A"
            }
          }
        }
      };
      URI.encodeQuery = function(string, escapeQuerySpace) {
        var escaped = URI.encode(string + "");
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        return escapeQuerySpace ? escaped.replace(/%20/g, "+") : escaped;
      };
      URI.decodeQuery = function(string, escapeQuerySpace) {
        string += "";
        if (escapeQuerySpace === void 0) {
          escapeQuerySpace = URI.escapeQuerySpace;
        }
        try {
          return URI.decode(escapeQuerySpace ? string.replace(/\+/g, "%20") : string);
        } catch (e) {
          return string;
        }
      };
      var _parts = { "encode": "encode", "decode": "decode" };
      var _part;
      var generateAccessor = function(_group, _part2) {
        return function(string) {
          try {
            return URI[_part2](string + "").replace(URI.characters[_group][_part2].expression, function(c) {
              return URI.characters[_group][_part2].map[c];
            });
          } catch (e) {
            return string;
          }
        };
      };
      for (_part in _parts) {
        URI[_part + "PathSegment"] = generateAccessor("pathname", _parts[_part]);
        URI[_part + "UrnPathSegment"] = generateAccessor("urnpath", _parts[_part]);
      }
      var generateSegmentedPathFunction = function(_sep, _codingFuncName, _innerCodingFuncName) {
        return function(string) {
          var actualCodingFunc;
          if (!_innerCodingFuncName) {
            actualCodingFunc = URI[_codingFuncName];
          } else {
            actualCodingFunc = function(string2) {
              return URI[_codingFuncName](URI[_innerCodingFuncName](string2));
            };
          }
          var segments = (string + "").split(_sep);
          for (var i = 0, length3 = segments.length; i < length3; i++) {
            segments[i] = actualCodingFunc(segments[i]);
          }
          return segments.join(_sep);
        };
      };
      URI.decodePath = generateSegmentedPathFunction("/", "decodePathSegment");
      URI.decodeUrnPath = generateSegmentedPathFunction(":", "decodeUrnPathSegment");
      URI.recodePath = generateSegmentedPathFunction("/", "encodePathSegment", "decode");
      URI.recodeUrnPath = generateSegmentedPathFunction(":", "encodeUrnPathSegment", "decode");
      URI.encodeReserved = generateAccessor("reserved", "encode");
      URI.parse = function(string, parts) {
        var pos;
        if (!parts) {
          parts = {
            preventInvalidHostname: URI.preventInvalidHostname
          };
        }
        string = string.replace(URI.leading_whitespace_expression, "");
        string = string.replace(URI.ascii_tab_whitespace, "");
        pos = string.indexOf("#");
        if (pos > -1) {
          parts.fragment = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        pos = string.indexOf("?");
        if (pos > -1) {
          parts.query = string.substring(pos + 1) || null;
          string = string.substring(0, pos);
        }
        string = string.replace(/^(https?|ftp|wss?)?:+[/\\]*/i, "$1://");
        string = string.replace(/^[/\\]{2,}/i, "//");
        if (string.substring(0, 2) === "//") {
          parts.protocol = null;
          string = string.substring(2);
          string = URI.parseAuthority(string, parts);
        } else {
          pos = string.indexOf(":");
          if (pos > -1) {
            parts.protocol = string.substring(0, pos) || null;
            if (parts.protocol && !parts.protocol.match(URI.protocol_expression)) {
              parts.protocol = void 0;
            } else if (string.substring(pos + 1, pos + 3).replace(/\\/g, "/") === "//") {
              string = string.substring(pos + 3);
              string = URI.parseAuthority(string, parts);
            } else {
              string = string.substring(pos + 1);
              parts.urn = true;
            }
          }
        }
        parts.path = string;
        return parts;
      };
      URI.parseHost = function(string, parts) {
        if (!string) {
          string = "";
        }
        string = string.replace(/\\/g, "/");
        var pos = string.indexOf("/");
        var bracketPos;
        var t;
        if (pos === -1) {
          pos = string.length;
        }
        if (string.charAt(0) === "[") {
          bracketPos = string.indexOf("]");
          parts.hostname = string.substring(1, bracketPos) || null;
          parts.port = string.substring(bracketPos + 2, pos) || null;
          if (parts.port === "/") {
            parts.port = null;
          }
        } else {
          var firstColon = string.indexOf(":");
          var firstSlash = string.indexOf("/");
          var nextColon = string.indexOf(":", firstColon + 1);
          if (nextColon !== -1 && (firstSlash === -1 || nextColon < firstSlash)) {
            parts.hostname = string.substring(0, pos) || null;
            parts.port = null;
          } else {
            t = string.substring(0, pos).split(":");
            parts.hostname = t[0] || null;
            parts.port = t[1] || null;
          }
        }
        if (parts.hostname && string.substring(pos).charAt(0) !== "/") {
          pos++;
          string = "/" + string;
        }
        if (parts.preventInvalidHostname) {
          URI.ensureValidHostname(parts.hostname, parts.protocol);
        }
        if (parts.port) {
          URI.ensureValidPort(parts.port);
        }
        return string.substring(pos) || "/";
      };
      URI.parseAuthority = function(string, parts) {
        string = URI.parseUserinfo(string, parts);
        return URI.parseHost(string, parts);
      };
      URI.parseUserinfo = function(string, parts) {
        var _string = string;
        var firstBackSlash = string.indexOf("\\");
        if (firstBackSlash !== -1) {
          string = string.replace(/\\/g, "/");
        }
        var firstSlash = string.indexOf("/");
        var pos = string.lastIndexOf("@", firstSlash > -1 ? firstSlash : string.length - 1);
        var t;
        if (pos > -1 && (firstSlash === -1 || pos < firstSlash)) {
          t = string.substring(0, pos).split(":");
          parts.username = t[0] ? URI.decode(t[0]) : null;
          t.shift();
          parts.password = t[0] ? URI.decode(t.join(":")) : null;
          string = _string.substring(pos + 1);
        } else {
          parts.username = null;
          parts.password = null;
        }
        return string;
      };
      URI.parseQuery = function(string, escapeQuerySpace) {
        if (!string) {
          return {};
        }
        string = string.replace(/&+/g, "&").replace(/^\?*&*|&+$/g, "");
        if (!string) {
          return {};
        }
        var items = {};
        var splits = string.split("&");
        var length3 = splits.length;
        var v7, name, value;
        for (var i = 0; i < length3; i++) {
          v7 = splits[i].split("=");
          name = URI.decodeQuery(v7.shift(), escapeQuerySpace);
          value = v7.length ? URI.decodeQuery(v7.join("="), escapeQuerySpace) : null;
          if (name === "__proto__") {
            continue;
          } else if (hasOwn.call(items, name)) {
            if (typeof items[name] === "string" || items[name] === null) {
              items[name] = [items[name]];
            }
            items[name].push(value);
          } else {
            items[name] = value;
          }
        }
        return items;
      };
      URI.build = function(parts) {
        var t = "";
        var requireAbsolutePath = false;
        if (parts.protocol) {
          t += parts.protocol + ":";
        }
        if (!parts.urn && (t || parts.hostname)) {
          t += "//";
          requireAbsolutePath = true;
        }
        t += URI.buildAuthority(parts) || "";
        if (typeof parts.path === "string") {
          if (parts.path.charAt(0) !== "/" && requireAbsolutePath) {
            t += "/";
          }
          t += parts.path;
        }
        if (typeof parts.query === "string" && parts.query) {
          t += "?" + parts.query;
        }
        if (typeof parts.fragment === "string" && parts.fragment) {
          t += "#" + parts.fragment;
        }
        return t;
      };
      URI.buildHost = function(parts) {
        var t = "";
        if (!parts.hostname) {
          return "";
        } else if (URI.ip6_expression.test(parts.hostname)) {
          t += "[" + parts.hostname + "]";
        } else {
          t += parts.hostname;
        }
        if (parts.port) {
          t += ":" + parts.port;
        }
        return t;
      };
      URI.buildAuthority = function(parts) {
        return URI.buildUserinfo(parts) + URI.buildHost(parts);
      };
      URI.buildUserinfo = function(parts) {
        var t = "";
        if (parts.username) {
          t += URI.encode(parts.username);
        }
        if (parts.password) {
          t += ":" + URI.encode(parts.password);
        }
        if (t) {
          t += "@";
        }
        return t;
      };
      URI.buildQuery = function(data, duplicateQueryParameters, escapeQuerySpace) {
        var t = "";
        var unique, key, i, length3;
        for (key in data) {
          if (key === "__proto__") {
            continue;
          } else if (hasOwn.call(data, key)) {
            if (isArray(data[key])) {
              unique = {};
              for (i = 0, length3 = data[key].length; i < length3; i++) {
                if (data[key][i] !== void 0 && unique[data[key][i] + ""] === void 0) {
                  t += "&" + URI.buildQueryParameter(key, data[key][i], escapeQuerySpace);
                  if (duplicateQueryParameters !== true) {
                    unique[data[key][i] + ""] = true;
                  }
                }
              }
            } else if (data[key] !== void 0) {
              t += "&" + URI.buildQueryParameter(key, data[key], escapeQuerySpace);
            }
          }
        }
        return t.substring(1);
      };
      URI.buildQueryParameter = function(name, value, escapeQuerySpace) {
        return URI.encodeQuery(name, escapeQuerySpace) + (value !== null ? "=" + URI.encodeQuery(value, escapeQuerySpace) : "");
      };
      URI.addQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.addQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (data[name] === void 0) {
            data[name] = value;
            return;
          } else if (typeof data[name] === "string") {
            data[name] = [data[name]];
          }
          if (!isArray(value)) {
            value = [value];
          }
          data[name] = (data[name] || []).concat(value);
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
      };
      URI.setQuery = function(data, name, value) {
        if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              URI.setQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          data[name] = value === void 0 ? null : value;
        } else {
          throw new TypeError("URI.setQuery() accepts an object, string as the name parameter");
        }
      };
      URI.removeQuery = function(data, name, value) {
        var i, length3, key;
        if (isArray(name)) {
          for (i = 0, length3 = name.length; i < length3; i++) {
            data[name[i]] = void 0;
          }
        } else if (getType(name) === "RegExp") {
          for (key in data) {
            if (name.test(key)) {
              data[key] = void 0;
            }
          }
        } else if (typeof name === "object") {
          for (key in name) {
            if (hasOwn.call(name, key)) {
              URI.removeQuery(data, key, name[key]);
            }
          }
        } else if (typeof name === "string") {
          if (value !== void 0) {
            if (getType(value) === "RegExp") {
              if (!isArray(data[name]) && value.test(data[name])) {
                data[name] = void 0;
              } else {
                data[name] = filterArrayValues(data[name], value);
              }
            } else if (data[name] === String(value) && (!isArray(value) || value.length === 1)) {
              data[name] = void 0;
            } else if (isArray(data[name])) {
              data[name] = filterArrayValues(data[name], value);
            }
          } else {
            data[name] = void 0;
          }
        } else {
          throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter");
        }
      };
      URI.hasQuery = function(data, name, value, withinArray) {
        switch (getType(name)) {
          case "String":
            break;
          case "RegExp":
            for (var key in data) {
              if (hasOwn.call(data, key)) {
                if (name.test(key) && (value === void 0 || URI.hasQuery(data, key, value))) {
                  return true;
                }
              }
            }
            return false;
          case "Object":
            for (var _key in name) {
              if (hasOwn.call(name, _key)) {
                if (!URI.hasQuery(data, _key, name[_key])) {
                  return false;
                }
              }
            }
            return true;
          default:
            throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter");
        }
        switch (getType(value)) {
          case "Undefined":
            return name in data;
          case "Boolean":
            var _booly = Boolean(isArray(data[name]) ? data[name].length : data[name]);
            return value === _booly;
          case "Function":
            return !!value(data[name], name, data);
          case "Array":
            if (!isArray(data[name])) {
              return false;
            }
            var op = withinArray ? arrayContains : arraysEqual;
            return op(data[name], value);
          case "RegExp":
            if (!isArray(data[name])) {
              return Boolean(data[name] && data[name].match(value));
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          case "Number":
            value = String(value);
          case "String":
            if (!isArray(data[name])) {
              return data[name] === value;
            }
            if (!withinArray) {
              return false;
            }
            return arrayContains(data[name], value);
          default:
            throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter");
        }
      };
      URI.joinPaths = function() {
        var input = [];
        var segments = [];
        var nonEmptySegments = 0;
        for (var i = 0; i < arguments.length; i++) {
          var url2 = new URI(arguments[i]);
          input.push(url2);
          var _segments = url2.segment();
          for (var s = 0; s < _segments.length; s++) {
            if (typeof _segments[s] === "string") {
              segments.push(_segments[s]);
            }
            if (_segments[s]) {
              nonEmptySegments++;
            }
          }
        }
        if (!segments.length || !nonEmptySegments) {
          return new URI("");
        }
        var uri = new URI("").segment(segments);
        if (input[0].path() === "" || input[0].path().slice(0, 1) === "/") {
          uri.path("/" + uri.path());
        }
        return uri.normalize();
      };
      URI.commonPath = function(one, two) {
        var length3 = Math.min(one.length, two.length);
        var pos;
        for (pos = 0; pos < length3; pos++) {
          if (one.charAt(pos) !== two.charAt(pos)) {
            pos--;
            break;
          }
        }
        if (pos < 1) {
          return one.charAt(0) === two.charAt(0) && one.charAt(0) === "/" ? "/" : "";
        }
        if (one.charAt(pos) !== "/" || two.charAt(pos) !== "/") {
          pos = one.substring(0, pos).lastIndexOf("/");
        }
        return one.substring(0, pos + 1);
      };
      URI.withinString = function(string, callback, options) {
        options || (options = {});
        var _start = options.start || URI.findUri.start;
        var _end = options.end || URI.findUri.end;
        var _trim = options.trim || URI.findUri.trim;
        var _parens = options.parens || URI.findUri.parens;
        var _attributeOpen = /[a-z0-9-]=["']?$/i;
        _start.lastIndex = 0;
        while (true) {
          var match = _start.exec(string);
          if (!match) {
            break;
          }
          var start = match.index;
          if (options.ignoreHtml) {
            var attributeOpen = string.slice(Math.max(start - 3, 0), start);
            if (attributeOpen && _attributeOpen.test(attributeOpen)) {
              continue;
            }
          }
          var end = start + string.slice(start).search(_end);
          var slice = string.slice(start, end);
          var parensEnd = -1;
          while (true) {
            var parensMatch = _parens.exec(slice);
            if (!parensMatch) {
              break;
            }
            var parensMatchEnd = parensMatch.index + parensMatch[0].length;
            parensEnd = Math.max(parensEnd, parensMatchEnd);
          }
          if (parensEnd > -1) {
            slice = slice.slice(0, parensEnd) + slice.slice(parensEnd).replace(_trim, "");
          } else {
            slice = slice.replace(_trim, "");
          }
          if (slice.length <= match[0].length) {
            continue;
          }
          if (options.ignore && options.ignore.test(slice)) {
            continue;
          }
          end = start + slice.length;
          var result = callback(slice, start, end, string);
          if (result === void 0) {
            _start.lastIndex = end;
            continue;
          }
          result = String(result);
          string = string.slice(0, start) + result + string.slice(end);
          _start.lastIndex = start + result.length;
        }
        _start.lastIndex = 0;
        return string;
      };
      URI.ensureValidHostname = function(v7, protocol) {
        var hasHostname = !!v7;
        var hasProtocol = !!protocol;
        var rejectEmptyHostname = false;
        if (hasProtocol) {
          rejectEmptyHostname = arrayContains(URI.hostProtocols, protocol);
        }
        if (rejectEmptyHostname && !hasHostname) {
          throw new TypeError("Hostname cannot be empty, if protocol is " + protocol);
        } else if (v7 && v7.match(URI.invalid_hostname_characters)) {
          if (!punycode) {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');
          }
          if (punycode.toASCII(v7).match(URI.invalid_hostname_characters)) {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-:_]');
          }
        }
      };
      URI.ensureValidPort = function(v7) {
        if (!v7) {
          return;
        }
        var port = Number(v7);
        if (isInteger(port) && port > 0 && port < 65536) {
          return;
        }
        throw new TypeError('Port "' + v7 + '" is not a valid port');
      };
      URI.noConflict = function(removeAll) {
        if (removeAll) {
          var unconflicted = {
            URI: this.noConflict()
          };
          if (root.URITemplate && typeof root.URITemplate.noConflict === "function") {
            unconflicted.URITemplate = root.URITemplate.noConflict();
          }
          if (root.IPv6 && typeof root.IPv6.noConflict === "function") {
            unconflicted.IPv6 = root.IPv6.noConflict();
          }
          if (root.SecondLevelDomains && typeof root.SecondLevelDomains.noConflict === "function") {
            unconflicted.SecondLevelDomains = root.SecondLevelDomains.noConflict();
          }
          return unconflicted;
        } else if (root.URI === this) {
          root.URI = _URI;
        }
        return this;
      };
      p.build = function(deferBuild) {
        if (deferBuild === true) {
          this._deferred_build = true;
        } else if (deferBuild === void 0 || this._deferred_build) {
          this._string = URI.build(this._parts);
          this._deferred_build = false;
        }
        return this;
      };
      p.clone = function() {
        return new URI(this);
      };
      p.valueOf = p.toString = function() {
        return this.build(false)._string;
      };
      function generateSimpleAccessor(_part2) {
        return function(v7, build) {
          if (v7 === void 0) {
            return this._parts[_part2] || "";
          } else {
            this._parts[_part2] = v7 || null;
            this.build(!build);
            return this;
          }
        };
      }
      function generatePrefixAccessor(_part2, _key) {
        return function(v7, build) {
          if (v7 === void 0) {
            return this._parts[_part2] || "";
          } else {
            if (v7 !== null) {
              v7 = v7 + "";
              if (v7.charAt(0) === _key) {
                v7 = v7.substring(1);
              }
            }
            this._parts[_part2] = v7;
            this.build(!build);
            return this;
          }
        };
      }
      p.protocol = generateSimpleAccessor("protocol");
      p.username = generateSimpleAccessor("username");
      p.password = generateSimpleAccessor("password");
      p.hostname = generateSimpleAccessor("hostname");
      p.port = generateSimpleAccessor("port");
      p.query = generatePrefixAccessor("query", "?");
      p.fragment = generatePrefixAccessor("fragment", "#");
      p.search = function(v7, build) {
        var t = this.query(v7, build);
        return typeof t === "string" && t.length ? "?" + t : t;
      };
      p.hash = function(v7, build) {
        var t = this.fragment(v7, build);
        return typeof t === "string" && t.length ? "#" + t : t;
      };
      p.pathname = function(v7, build) {
        if (v7 === void 0 || v7 === true) {
          var res = this._parts.path || (this._parts.hostname ? "/" : "");
          return v7 ? (this._parts.urn ? URI.decodeUrnPath : URI.decodePath)(res) : res;
        } else {
          if (this._parts.urn) {
            this._parts.path = v7 ? URI.recodeUrnPath(v7) : "";
          } else {
            this._parts.path = v7 ? URI.recodePath(v7) : "/";
          }
          this.build(!build);
          return this;
        }
      };
      p.path = p.pathname;
      p.href = function(href, build) {
        var key;
        if (href === void 0) {
          return this.toString();
        }
        this._string = "";
        this._parts = URI._parts();
        var _URI2 = href instanceof URI;
        var _object = typeof href === "object" && (href.hostname || href.path || href.pathname);
        if (href.nodeName) {
          var attribute = URI.getDomAttribute(href);
          href = href[attribute] || "";
          _object = false;
        }
        if (!_URI2 && _object && href.pathname !== void 0) {
          href = href.toString();
        }
        if (typeof href === "string" || href instanceof String) {
          this._parts = URI.parse(String(href), this._parts);
        } else if (_URI2 || _object) {
          var src = _URI2 ? href._parts : href;
          for (key in src) {
            if (key === "query") {
              continue;
            }
            if (hasOwn.call(this._parts, key)) {
              this._parts[key] = src[key];
            }
          }
          if (src.query) {
            this.query(src.query, false);
          }
        } else {
          throw new TypeError("invalid input");
        }
        this.build(!build);
        return this;
      };
      p.is = function(what) {
        var ip = false;
        var ip4 = false;
        var ip6 = false;
        var name = false;
        var sld = false;
        var idn = false;
        var punycode2 = false;
        var relative = !this._parts.urn;
        if (this._parts.hostname) {
          relative = false;
          ip4 = URI.ip4_expression.test(this._parts.hostname);
          ip6 = URI.ip6_expression.test(this._parts.hostname);
          ip = ip4 || ip6;
          name = !ip;
          sld = name && SLD && SLD.has(this._parts.hostname);
          idn = name && URI.idn_expression.test(this._parts.hostname);
          punycode2 = name && URI.punycode_expression.test(this._parts.hostname);
        }
        switch (what.toLowerCase()) {
          case "relative":
            return relative;
          case "absolute":
            return !relative;
          case "domain":
          case "name":
            return name;
          case "sld":
            return sld;
          case "ip":
            return ip;
          case "ip4":
          case "ipv4":
          case "inet4":
            return ip4;
          case "ip6":
          case "ipv6":
          case "inet6":
            return ip6;
          case "idn":
            return idn;
          case "url":
            return !this._parts.urn;
          case "urn":
            return !!this._parts.urn;
          case "punycode":
            return punycode2;
        }
        return null;
      };
      var _protocol = p.protocol;
      var _port = p.port;
      var _hostname = p.hostname;
      p.protocol = function(v7, build) {
        if (v7) {
          v7 = v7.replace(/:(\/\/)?$/, "");
          if (!v7.match(URI.protocol_expression)) {
            throw new TypeError('Protocol "' + v7 + `" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);
          }
        }
        return _protocol.call(this, v7, build);
      };
      p.scheme = p.protocol;
      p.port = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 !== void 0) {
          if (v7 === 0) {
            v7 = null;
          }
          if (v7) {
            v7 += "";
            if (v7.charAt(0) === ":") {
              v7 = v7.substring(1);
            }
            URI.ensureValidPort(v7);
          }
        }
        return _port.call(this, v7, build);
      };
      p.hostname = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 !== void 0) {
          var x = { preventInvalidHostname: this._parts.preventInvalidHostname };
          var res = URI.parseHost(v7, x);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
          }
          v7 = x.hostname;
          if (this._parts.preventInvalidHostname) {
            URI.ensureValidHostname(v7, this._parts.protocol);
          }
        }
        return _hostname.call(this, v7, build);
      };
      p.origin = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          var protocol = this.protocol();
          var authority = this.authority();
          if (!authority) {
            return "";
          }
          return (protocol ? protocol + "://" : "") + this.authority();
        } else {
          var origin = URI(v7);
          this.protocol(origin.protocol()).authority(origin.authority()).build(!build);
          return this;
        }
      };
      p.host = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          return this._parts.hostname ? URI.buildHost(this._parts) : "";
        } else {
          var res = URI.parseHost(v7, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.authority = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          return this._parts.hostname ? URI.buildAuthority(this._parts) : "";
        } else {
          var res = URI.parseAuthority(v7, this._parts);
          if (res !== "/") {
            throw new TypeError('Hostname "' + v7 + '" contains characters other than [A-Z0-9.-]');
          }
          this.build(!build);
          return this;
        }
      };
      p.userinfo = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          var t = URI.buildUserinfo(this._parts);
          return t ? t.substring(0, t.length - 1) : t;
        } else {
          if (v7[v7.length - 1] !== "@") {
            v7 += "@";
          }
          URI.parseUserinfo(v7, this._parts);
          this.build(!build);
          return this;
        }
      };
      p.resource = function(v7, build) {
        var parts;
        if (v7 === void 0) {
          return this.path() + this.search() + this.hash();
        }
        parts = URI.parse(v7);
        this._parts.path = parts.path;
        this._parts.query = parts.query;
        this._parts.fragment = parts.fragment;
        this.build(!build);
        return this;
      };
      p.subdomain = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var end = this._parts.hostname.length - this.domain().length - 1;
          return this._parts.hostname.substring(0, end) || "";
        } else {
          var e = this._parts.hostname.length - this.domain().length;
          var sub = this._parts.hostname.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(sub));
          if (v7 && v7.charAt(v7.length - 1) !== ".") {
            v7 += ".";
          }
          if (v7.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          if (v7) {
            URI.ensureValidHostname(v7, this._parts.protocol);
          }
          this._parts.hostname = this._parts.hostname.replace(replace, v7);
          this.build(!build);
          return this;
        }
      };
      p.domain = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (typeof v7 === "boolean") {
          build = v7;
          v7 = void 0;
        }
        if (v7 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var t = this._parts.hostname.match(/\./g);
          if (t && t.length < 2) {
            return this._parts.hostname;
          }
          var end = this._parts.hostname.length - this.tld(build).length - 1;
          end = this._parts.hostname.lastIndexOf(".", end - 1) + 1;
          return this._parts.hostname.substring(end) || "";
        } else {
          if (!v7) {
            throw new TypeError("cannot set domain empty");
          }
          if (v7.indexOf(":") !== -1) {
            throw new TypeError("Domains cannot contain colons");
          }
          URI.ensureValidHostname(v7, this._parts.protocol);
          if (!this._parts.hostname || this.is("IP")) {
            this._parts.hostname = v7;
          } else {
            var replace = new RegExp(escapeRegEx(this.domain()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v7);
          }
          this.build(!build);
          return this;
        }
      };
      p.tld = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (typeof v7 === "boolean") {
          build = v7;
          v7 = void 0;
        }
        if (v7 === void 0) {
          if (!this._parts.hostname || this.is("IP")) {
            return "";
          }
          var pos = this._parts.hostname.lastIndexOf(".");
          var tld = this._parts.hostname.substring(pos + 1);
          if (build !== true && SLD && SLD.list[tld.toLowerCase()]) {
            return SLD.get(this._parts.hostname) || tld;
          }
          return tld;
        } else {
          var replace;
          if (!v7) {
            throw new TypeError("cannot set TLD empty");
          } else if (v7.match(/[^a-zA-Z0-9-]/)) {
            if (SLD && SLD.is(v7)) {
              replace = new RegExp(escapeRegEx(this.tld()) + "$");
              this._parts.hostname = this._parts.hostname.replace(replace, v7);
            } else {
              throw new TypeError('TLD "' + v7 + '" contains characters other than [A-Z0-9]');
            }
          } else if (!this._parts.hostname || this.is("IP")) {
            throw new ReferenceError("cannot set TLD on non-domain host");
          } else {
            replace = new RegExp(escapeRegEx(this.tld()) + "$");
            this._parts.hostname = this._parts.hostname.replace(replace, v7);
          }
          this.build(!build);
          return this;
        }
      };
      p.directory = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0 || v7 === true) {
          if (!this._parts.path && !this._parts.hostname) {
            return "";
          }
          if (this._parts.path === "/") {
            return "/";
          }
          var end = this._parts.path.length - this.filename().length - 1;
          var res = this._parts.path.substring(0, end) || (this._parts.hostname ? "/" : "");
          return v7 ? URI.decodePath(res) : res;
        } else {
          var e = this._parts.path.length - this.filename().length;
          var directory = this._parts.path.substring(0, e);
          var replace = new RegExp("^" + escapeRegEx(directory));
          if (!this.is("relative")) {
            if (!v7) {
              v7 = "/";
            }
            if (v7.charAt(0) !== "/") {
              v7 = "/" + v7;
            }
          }
          if (v7 && v7.charAt(v7.length - 1) !== "/") {
            v7 += "/";
          }
          v7 = URI.recodePath(v7);
          this._parts.path = this._parts.path.replace(replace, v7);
          this.build(!build);
          return this;
        }
      };
      p.filename = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (typeof v7 !== "string") {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var pos = this._parts.path.lastIndexOf("/");
          var res = this._parts.path.substring(pos + 1);
          return v7 ? URI.decodePathSegment(res) : res;
        } else {
          var mutatedDirectory = false;
          if (v7.charAt(0) === "/") {
            v7 = v7.substring(1);
          }
          if (v7.match(/\.?\//)) {
            mutatedDirectory = true;
          }
          var replace = new RegExp(escapeRegEx(this.filename()) + "$");
          v7 = URI.recodePath(v7);
          this._parts.path = this._parts.path.replace(replace, v7);
          if (mutatedDirectory) {
            this.normalizePath(build);
          } else {
            this.build(!build);
          }
          return this;
        }
      };
      p.suffix = function(v7, build) {
        if (this._parts.urn) {
          return v7 === void 0 ? "" : this;
        }
        if (v7 === void 0 || v7 === true) {
          if (!this._parts.path || this._parts.path === "/") {
            return "";
          }
          var filename = this.filename();
          var pos = filename.lastIndexOf(".");
          var s, res;
          if (pos === -1) {
            return "";
          }
          s = filename.substring(pos + 1);
          res = /^[a-z0-9%]+$/i.test(s) ? s : "";
          return v7 ? URI.decodePathSegment(res) : res;
        } else {
          if (v7.charAt(0) === ".") {
            v7 = v7.substring(1);
          }
          var suffix = this.suffix();
          var replace;
          if (!suffix) {
            if (!v7) {
              return this;
            }
            this._parts.path += "." + URI.recodePath(v7);
          } else if (!v7) {
            replace = new RegExp(escapeRegEx("." + suffix) + "$");
          } else {
            replace = new RegExp(escapeRegEx(suffix) + "$");
          }
          if (replace) {
            v7 = URI.recodePath(v7);
            this._parts.path = this._parts.path.replace(replace, v7);
          }
          this.build(!build);
          return this;
        }
      };
      p.segment = function(segment, v7, build) {
        var separator = this._parts.urn ? ":" : "/";
        var path = this.path();
        var absolute = path.substring(0, 1) === "/";
        var segments = path.split(separator);
        if (segment !== void 0 && typeof segment !== "number") {
          build = v7;
          v7 = segment;
          segment = void 0;
        }
        if (segment !== void 0 && typeof segment !== "number") {
          throw new Error('Bad segment "' + segment + '", must be 0-based integer');
        }
        if (absolute) {
          segments.shift();
        }
        if (segment < 0) {
          segment = Math.max(segments.length + segment, 0);
        }
        if (v7 === void 0) {
          return segment === void 0 ? segments : segments[segment];
        } else if (segment === null || segments[segment] === void 0) {
          if (isArray(v7)) {
            segments = [];
            for (var i = 0, l = v7.length; i < l; i++) {
              if (!v7[i].length && (!segments.length || !segments[segments.length - 1].length)) {
                continue;
              }
              if (segments.length && !segments[segments.length - 1].length) {
                segments.pop();
              }
              segments.push(trimSlashes(v7[i]));
            }
          } else if (v7 || typeof v7 === "string") {
            v7 = trimSlashes(v7);
            if (segments[segments.length - 1] === "") {
              segments[segments.length - 1] = v7;
            } else {
              segments.push(v7);
            }
          }
        } else {
          if (v7) {
            segments[segment] = trimSlashes(v7);
          } else {
            segments.splice(segment, 1);
          }
        }
        if (absolute) {
          segments.unshift("");
        }
        return this.path(segments.join(separator), build);
      };
      p.segmentCoded = function(segment, v7, build) {
        var segments, i, l;
        if (typeof segment !== "number") {
          build = v7;
          v7 = segment;
          segment = void 0;
        }
        if (v7 === void 0) {
          segments = this.segment(segment, v7, build);
          if (!isArray(segments)) {
            segments = segments !== void 0 ? URI.decode(segments) : void 0;
          } else {
            for (i = 0, l = segments.length; i < l; i++) {
              segments[i] = URI.decode(segments[i]);
            }
          }
          return segments;
        }
        if (!isArray(v7)) {
          v7 = typeof v7 === "string" || v7 instanceof String ? URI.encode(v7) : v7;
        } else {
          for (i = 0, l = v7.length; i < l; i++) {
            v7[i] = URI.encode(v7[i]);
          }
        }
        return this.segment(segment, v7, build);
      };
      var q = p.query;
      p.query = function(v7, build) {
        if (v7 === true) {
          return URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        } else if (typeof v7 === "function") {
          var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
          var result = v7.call(this, data);
          this._parts.query = URI.buildQuery(result || data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else if (v7 !== void 0 && typeof v7 !== "string") {
          this._parts.query = URI.buildQuery(v7, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
          this.build(!build);
          return this;
        } else {
          return q.call(this, v7, build);
        }
      };
      p.setQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        if (typeof name === "string" || name instanceof String) {
          data[name] = value !== void 0 ? value : null;
        } else if (typeof name === "object") {
          for (var key in name) {
            if (hasOwn.call(name, key)) {
              data[key] = name[key];
            }
          }
        } else {
          throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");
        }
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.addQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.addQuery(data, name, value === void 0 ? null : value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.removeQuery = function(name, value, build) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        URI.removeQuery(data, name, value);
        this._parts.query = URI.buildQuery(data, this._parts.duplicateQueryParameters, this._parts.escapeQuerySpace);
        if (typeof name !== "string") {
          build = value;
        }
        this.build(!build);
        return this;
      };
      p.hasQuery = function(name, value, withinArray) {
        var data = URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace);
        return URI.hasQuery(data, name, value, withinArray);
      };
      p.setSearch = p.setQuery;
      p.addSearch = p.addQuery;
      p.removeSearch = p.removeQuery;
      p.hasSearch = p.hasQuery;
      p.normalize = function() {
        if (this._parts.urn) {
          return this.normalizeProtocol(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
        }
        return this.normalizeProtocol(false).normalizeHostname(false).normalizePort(false).normalizePath(false).normalizeQuery(false).normalizeFragment(false).build();
      };
      p.normalizeProtocol = function(build) {
        if (typeof this._parts.protocol === "string") {
          this._parts.protocol = this._parts.protocol.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizeHostname = function(build) {
        if (this._parts.hostname) {
          if (this.is("IDN") && punycode) {
            this._parts.hostname = punycode.toASCII(this._parts.hostname);
          } else if (this.is("IPv6") && IPv6) {
            this._parts.hostname = IPv6.best(this._parts.hostname);
          }
          this._parts.hostname = this._parts.hostname.toLowerCase();
          this.build(!build);
        }
        return this;
      };
      p.normalizePort = function(build) {
        if (typeof this._parts.protocol === "string" && this._parts.port === URI.defaultPorts[this._parts.protocol]) {
          this._parts.port = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizePath = function(build) {
        var _path = this._parts.path;
        if (!_path) {
          return this;
        }
        if (this._parts.urn) {
          this._parts.path = URI.recodeUrnPath(this._parts.path);
          this.build(!build);
          return this;
        }
        if (this._parts.path === "/") {
          return this;
        }
        _path = URI.recodePath(_path);
        var _was_relative;
        var _leadingParents = "";
        var _parent, _pos;
        if (_path.charAt(0) !== "/") {
          _was_relative = true;
          _path = "/" + _path;
        }
        if (_path.slice(-3) === "/.." || _path.slice(-2) === "/.") {
          _path += "/";
        }
        _path = _path.replace(/(\/(\.\/)+)|(\/\.$)/g, "/").replace(/\/{2,}/g, "/");
        if (_was_relative) {
          _leadingParents = _path.substring(1).match(/^(\.\.\/)+/) || "";
          if (_leadingParents) {
            _leadingParents = _leadingParents[0];
          }
        }
        while (true) {
          _parent = _path.search(/\/\.\.(\/|$)/);
          if (_parent === -1) {
            break;
          } else if (_parent === 0) {
            _path = _path.substring(3);
            continue;
          }
          _pos = _path.substring(0, _parent).lastIndexOf("/");
          if (_pos === -1) {
            _pos = _parent;
          }
          _path = _path.substring(0, _pos) + _path.substring(_parent + 3);
        }
        if (_was_relative && this.is("relative")) {
          _path = _leadingParents + _path.substring(1);
        }
        this._parts.path = _path;
        this.build(!build);
        return this;
      };
      p.normalizePathname = p.normalizePath;
      p.normalizeQuery = function(build) {
        if (typeof this._parts.query === "string") {
          if (!this._parts.query.length) {
            this._parts.query = null;
          } else {
            this.query(URI.parseQuery(this._parts.query, this._parts.escapeQuerySpace));
          }
          this.build(!build);
        }
        return this;
      };
      p.normalizeFragment = function(build) {
        if (!this._parts.fragment) {
          this._parts.fragment = null;
          this.build(!build);
        }
        return this;
      };
      p.normalizeSearch = p.normalizeQuery;
      p.normalizeHash = p.normalizeFragment;
      p.iso8859 = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = escape;
        URI.decode = decodeURIComponent;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.unicode = function() {
        var e = URI.encode;
        var d = URI.decode;
        URI.encode = strictEncodeURIComponent;
        URI.decode = unescape;
        try {
          this.normalize();
        } finally {
          URI.encode = e;
          URI.decode = d;
        }
        return this;
      };
      p.readable = function() {
        var uri = this.clone();
        uri.username("").password("").normalize();
        var t = "";
        if (uri._parts.protocol) {
          t += uri._parts.protocol + "://";
        }
        if (uri._parts.hostname) {
          if (uri.is("punycode") && punycode) {
            t += punycode.toUnicode(uri._parts.hostname);
            if (uri._parts.port) {
              t += ":" + uri._parts.port;
            }
          } else {
            t += uri.host();
          }
        }
        if (uri._parts.hostname && uri._parts.path && uri._parts.path.charAt(0) !== "/") {
          t += "/";
        }
        t += uri.path(true);
        if (uri._parts.query) {
          var q3 = "";
          for (var i = 0, qp = uri._parts.query.split("&"), l = qp.length; i < l; i++) {
            var kv = (qp[i] || "").split("=");
            q3 += "&" + URI.decodeQuery(kv[0], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            if (kv[1] !== void 0) {
              q3 += "=" + URI.decodeQuery(kv[1], this._parts.escapeQuerySpace).replace(/&/g, "%26");
            }
          }
          t += "?" + q3.substring(1);
        }
        t += URI.decodeQuery(uri.hash(), true);
        return t;
      };
      p.absoluteTo = function(base) {
        var resolved = this.clone();
        var properties = ["protocol", "username", "password", "hostname", "port"];
        var basedir, i, p2;
        if (this._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        if (!(base instanceof URI)) {
          base = new URI(base);
        }
        if (resolved._parts.protocol) {
          return resolved;
        } else {
          resolved._parts.protocol = base._parts.protocol;
        }
        if (this._parts.hostname) {
          return resolved;
        }
        for (i = 0; p2 = properties[i]; i++) {
          resolved._parts[p2] = base._parts[p2];
        }
        if (!resolved._parts.path) {
          resolved._parts.path = base._parts.path;
          if (!resolved._parts.query) {
            resolved._parts.query = base._parts.query;
          }
        } else {
          if (resolved._parts.path.substring(-2) === "..") {
            resolved._parts.path += "/";
          }
          if (resolved.path().charAt(0) !== "/") {
            basedir = base.directory();
            basedir = basedir ? basedir : base.path().indexOf("/") === 0 ? "/" : "";
            resolved._parts.path = (basedir ? basedir + "/" : "") + resolved._parts.path;
            resolved.normalizePath();
          }
        }
        resolved.build();
        return resolved;
      };
      p.relativeTo = function(base) {
        var relative = this.clone().normalize();
        var relativeParts, baseParts, common, relativePath, basePath;
        if (relative._parts.urn) {
          throw new Error("URNs do not have any generally defined hierarchical components");
        }
        base = new URI(base).normalize();
        relativeParts = relative._parts;
        baseParts = base._parts;
        relativePath = relative.path();
        basePath = base.path();
        if (relativePath.charAt(0) !== "/") {
          throw new Error("URI is already relative");
        }
        if (basePath.charAt(0) !== "/") {
          throw new Error("Cannot calculate a URI relative to another relative URI");
        }
        if (relativeParts.protocol === baseParts.protocol) {
          relativeParts.protocol = null;
        }
        if (relativeParts.username !== baseParts.username || relativeParts.password !== baseParts.password) {
          return relative.build();
        }
        if (relativeParts.protocol !== null || relativeParts.username !== null || relativeParts.password !== null) {
          return relative.build();
        }
        if (relativeParts.hostname === baseParts.hostname && relativeParts.port === baseParts.port) {
          relativeParts.hostname = null;
          relativeParts.port = null;
        } else {
          return relative.build();
        }
        if (relativePath === basePath) {
          relativeParts.path = "";
          return relative.build();
        }
        common = URI.commonPath(relativePath, basePath);
        if (!common) {
          return relative.build();
        }
        var parents = baseParts.path.substring(common.length).replace(/[^\/]*$/, "").replace(/.*?\//g, "../");
        relativeParts.path = parents + relativeParts.path.substring(common.length) || "./";
        return relative.build();
      };
      p.equals = function(uri) {
        var one = this.clone();
        var two = new URI(uri);
        var one_map = {};
        var two_map = {};
        var checked = {};
        var one_query, two_query, key;
        one.normalize();
        two.normalize();
        if (one.toString() === two.toString()) {
          return true;
        }
        one_query = one.query();
        two_query = two.query();
        one.query("");
        two.query("");
        if (one.toString() !== two.toString()) {
          return false;
        }
        if (one_query.length !== two_query.length) {
          return false;
        }
        one_map = URI.parseQuery(one_query, this._parts.escapeQuerySpace);
        two_map = URI.parseQuery(two_query, this._parts.escapeQuerySpace);
        for (key in one_map) {
          if (hasOwn.call(one_map, key)) {
            if (!isArray(one_map[key])) {
              if (one_map[key] !== two_map[key]) {
                return false;
              }
            } else if (!arraysEqual(one_map[key], two_map[key])) {
              return false;
            }
            checked[key] = true;
          }
        }
        for (key in two_map) {
          if (hasOwn.call(two_map, key)) {
            if (!checked[key]) {
              return false;
            }
          }
        }
        return true;
      };
      p.preventInvalidHostname = function(v7) {
        this._parts.preventInvalidHostname = !!v7;
        return this;
      };
      p.duplicateQueryParameters = function(v7) {
        this._parts.duplicateQueryParameters = !!v7;
        return this;
      };
      p.escapeQuerySpace = function(v7) {
        this._parts.escapeQuerySpace = !!v7;
        return this;
      };
      return URI;
    });
  }
});

// node_modules/dompurify/dist/purify.cjs.js
var require_purify_cjs = __commonJS({
  "node_modules/dompurify/dist/purify.cjs.js"(exports2, module2) {
    "use strict";
    /*! @license DOMPurify 2.4.7 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/2.4.7/LICENSE */
    function _typeof(obj) {
      "@babel/helpers - typeof";
      return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
        return typeof obj2;
      } : function(obj2) {
        return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
      }, _typeof(obj);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    function _isNativeReflectConstruct() {
      if (typeof Reflect === "undefined" || !Reflect.construct)
        return false;
      if (Reflect.construct.sham)
        return false;
      if (typeof Proxy === "function")
        return true;
      try {
        Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
        }));
        return true;
      } catch (e) {
        return false;
      }
    }
    function _construct(Parent, args, Class) {
      if (_isNativeReflectConstruct()) {
        _construct = Reflect.construct;
      } else {
        _construct = function _construct2(Parent2, args2, Class2) {
          var a3 = [null];
          a3.push.apply(a3, args2);
          var Constructor = Function.bind.apply(Parent2, a3);
          var instance = new Constructor();
          if (Class2)
            _setPrototypeOf(instance, Class2.prototype);
          return instance;
        };
      }
      return _construct.apply(null, arguments);
    }
    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
    }
    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr))
        return _arrayLikeToArray(arr);
    }
    function _iterableToArray(iter) {
      if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null)
        return Array.from(iter);
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(o);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++)
        arr2[i] = arr[i];
      return arr2;
    }
    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    var hasOwnProperty = Object.hasOwnProperty;
    var setPrototypeOf = Object.setPrototypeOf;
    var isFrozen = Object.isFrozen;
    var getPrototypeOf = Object.getPrototypeOf;
    var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
    var freeze = Object.freeze;
    var seal = Object.seal;
    var create = Object.create;
    var _ref = typeof Reflect !== "undefined" && Reflect;
    var apply = _ref.apply;
    var construct = _ref.construct;
    if (!apply) {
      apply = function apply2(fun, thisValue, args) {
        return fun.apply(thisValue, args);
      };
    }
    if (!freeze) {
      freeze = function freeze2(x) {
        return x;
      };
    }
    if (!seal) {
      seal = function seal2(x) {
        return x;
      };
    }
    if (!construct) {
      construct = function construct2(Func, args) {
        return _construct(Func, _toConsumableArray(args));
      };
    }
    var arrayForEach = unapply(Array.prototype.forEach);
    var arrayPop = unapply(Array.prototype.pop);
    var arrayPush = unapply(Array.prototype.push);
    var stringToLowerCase = unapply(String.prototype.toLowerCase);
    var stringToString = unapply(String.prototype.toString);
    var stringMatch = unapply(String.prototype.match);
    var stringReplace = unapply(String.prototype.replace);
    var stringIndexOf = unapply(String.prototype.indexOf);
    var stringTrim = unapply(String.prototype.trim);
    var regExpTest = unapply(RegExp.prototype.test);
    var typeErrorCreate = unconstruct(TypeError);
    function unapply(func) {
      return function(thisArg) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }
        return apply(func, thisArg, args);
      };
    }
    function unconstruct(func) {
      return function() {
        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }
        return construct(func, args);
      };
    }
    function addToSet(set2, array, transformCaseFunc) {
      var _transformCaseFunc;
      transformCaseFunc = (_transformCaseFunc = transformCaseFunc) !== null && _transformCaseFunc !== void 0 ? _transformCaseFunc : stringToLowerCase;
      if (setPrototypeOf) {
        setPrototypeOf(set2, null);
      }
      var l = array.length;
      while (l--) {
        var element = array[l];
        if (typeof element === "string") {
          var lcElement = transformCaseFunc(element);
          if (lcElement !== element) {
            if (!isFrozen(array)) {
              array[l] = lcElement;
            }
            element = lcElement;
          }
        }
        set2[element] = true;
      }
      return set2;
    }
    function clone2(object) {
      var newObject = create(null);
      var property;
      for (property in object) {
        if (apply(hasOwnProperty, object, [property]) === true) {
          newObject[property] = object[property];
        }
      }
      return newObject;
    }
    function lookupGetter(object, prop) {
      while (object !== null) {
        var desc = getOwnPropertyDescriptor(object, prop);
        if (desc) {
          if (desc.get) {
            return unapply(desc.get);
          }
          if (typeof desc.value === "function") {
            return unapply(desc.value);
          }
        }
        object = getPrototypeOf(object);
      }
      function fallbackValue(element) {
        console.warn("fallback value for", element);
        return null;
      }
      return fallbackValue;
    }
    var html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
    var svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
    var svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
    var svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "fedropshadow", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
    var mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover"]);
    var mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
    var text = freeze(["#text"]);
    var html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
    var svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
    var mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
    var xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
    var MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
    var ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
    var TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
    var DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
    var ARIA_ATTR = seal(/^aria-[\-\w]+$/);
    var IS_ALLOWED_URI = seal(
      /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
    );
    var IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
    var ATTR_WHITESPACE = seal(
      /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
    );
    var DOCTYPE_NAME = seal(/^html$/i);
    var getGlobal = function getGlobal2() {
      return typeof window === "undefined" ? null : window;
    };
    var _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, document2) {
      if (_typeof(trustedTypes) !== "object" || typeof trustedTypes.createPolicy !== "function") {
        return null;
      }
      var suffix = null;
      var ATTR_NAME = "data-tt-policy-suffix";
      if (document2.currentScript && document2.currentScript.hasAttribute(ATTR_NAME)) {
        suffix = document2.currentScript.getAttribute(ATTR_NAME);
      }
      var policyName = "dompurify" + (suffix ? "#" + suffix : "");
      try {
        return trustedTypes.createPolicy(policyName, {
          createHTML: function createHTML(html2) {
            return html2;
          },
          createScriptURL: function createScriptURL(scriptUrl) {
            return scriptUrl;
          }
        });
      } catch (_) {
        console.warn("TrustedTypes policy " + policyName + " could not be created.");
        return null;
      }
    };
    function createDOMPurify() {
      var window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
      var DOMPurify2 = function DOMPurify3(root) {
        return createDOMPurify(root);
      };
      DOMPurify2.version = "2.4.7";
      DOMPurify2.removed = [];
      if (!window2 || !window2.document || window2.document.nodeType !== 9) {
        DOMPurify2.isSupported = false;
        return DOMPurify2;
      }
      var originalDocument = window2.document;
      var document2 = window2.document;
      var DocumentFragment2 = window2.DocumentFragment, HTMLTemplateElement = window2.HTMLTemplateElement, Node6 = window2.Node, Element2 = window2.Element, NodeFilter = window2.NodeFilter, _window$NamedNodeMap = window2.NamedNodeMap, NamedNodeMap = _window$NamedNodeMap === void 0 ? window2.NamedNodeMap || window2.MozNamedAttrMap : _window$NamedNodeMap, HTMLFormElement = window2.HTMLFormElement, DOMParser2 = window2.DOMParser, trustedTypes = window2.trustedTypes;
      var ElementPrototype = Element2.prototype;
      var cloneNode = lookupGetter(ElementPrototype, "cloneNode");
      var getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
      var getChildNodes = lookupGetter(ElementPrototype, "childNodes");
      var getParentNode = lookupGetter(ElementPrototype, "parentNode");
      if (typeof HTMLTemplateElement === "function") {
        var template = document2.createElement("template");
        if (template.content && template.content.ownerDocument) {
          document2 = template.content.ownerDocument;
        }
      }
      var trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, originalDocument);
      var emptyHTML = trustedTypesPolicy ? trustedTypesPolicy.createHTML("") : "";
      var _document = document2, implementation2 = _document.implementation, createNodeIterator = _document.createNodeIterator, createDocumentFragment = _document.createDocumentFragment, getElementsByTagName = _document.getElementsByTagName;
      var importNode = originalDocument.importNode;
      var documentMode = {};
      try {
        documentMode = clone2(document2).documentMode ? document2.documentMode : {};
      } catch (_) {
      }
      var hooks = {};
      DOMPurify2.isSupported = typeof getParentNode === "function" && implementation2 && implementation2.createHTMLDocument !== void 0 && documentMode !== 9;
      var MUSTACHE_EXPR$1 = MUSTACHE_EXPR, ERB_EXPR$1 = ERB_EXPR, TMPLIT_EXPR$1 = TMPLIT_EXPR, DATA_ATTR$1 = DATA_ATTR, ARIA_ATTR$1 = ARIA_ATTR, IS_SCRIPT_OR_DATA$1 = IS_SCRIPT_OR_DATA, ATTR_WHITESPACE$1 = ATTR_WHITESPACE;
      var IS_ALLOWED_URI$1 = IS_ALLOWED_URI;
      var ALLOWED_TAGS = null;
      var DEFAULT_ALLOWED_TAGS = addToSet({}, [].concat(_toConsumableArray(html$1), _toConsumableArray(svg$1), _toConsumableArray(svgFilters), _toConsumableArray(mathMl$1), _toConsumableArray(text)));
      var ALLOWED_ATTR = null;
      var DEFAULT_ALLOWED_ATTR = addToSet({}, [].concat(_toConsumableArray(html), _toConsumableArray(svg), _toConsumableArray(mathMl), _toConsumableArray(xml)));
      var CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
        tagNameCheck: {
          writable: true,
          configurable: false,
          enumerable: true,
          value: null
        },
        attributeNameCheck: {
          writable: true,
          configurable: false,
          enumerable: true,
          value: null
        },
        allowCustomizedBuiltInElements: {
          writable: true,
          configurable: false,
          enumerable: true,
          value: false
        }
      }));
      var FORBID_TAGS = null;
      var FORBID_ATTR = null;
      var ALLOW_ARIA_ATTR = true;
      var ALLOW_DATA_ATTR = true;
      var ALLOW_UNKNOWN_PROTOCOLS = false;
      var ALLOW_SELF_CLOSE_IN_ATTR = true;
      var SAFE_FOR_TEMPLATES = false;
      var WHOLE_DOCUMENT = false;
      var SET_CONFIG = false;
      var FORCE_BODY = false;
      var RETURN_DOM = false;
      var RETURN_DOM_FRAGMENT = false;
      var RETURN_TRUSTED_TYPE = false;
      var SANITIZE_DOM = true;
      var SANITIZE_NAMED_PROPS = false;
      var SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
      var KEEP_CONTENT = true;
      var IN_PLACE = false;
      var USE_PROFILES = {};
      var FORBID_CONTENTS = null;
      var DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
      var DATA_URI_TAGS = null;
      var DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
      var URI_SAFE_ATTRIBUTES = null;
      var DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
      var MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
      var SVG_NAMESPACE = "http://www.w3.org/2000/svg";
      var HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
      var NAMESPACE = HTML_NAMESPACE;
      var IS_EMPTY_INPUT = false;
      var ALLOWED_NAMESPACES = null;
      var DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
      var PARSER_MEDIA_TYPE;
      var SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
      var DEFAULT_PARSER_MEDIA_TYPE = "text/html";
      var transformCaseFunc;
      var CONFIG = null;
      var formElement = document2.createElement("form");
      var isRegexOrFunction = function isRegexOrFunction2(testValue) {
        return testValue instanceof RegExp || testValue instanceof Function;
      };
      var _parseConfig = function _parseConfig2(cfg) {
        if (CONFIG && CONFIG === cfg) {
          return;
        }
        if (!cfg || _typeof(cfg) !== "object") {
          cfg = {};
        }
        cfg = clone2(cfg);
        PARSER_MEDIA_TYPE = SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE;
        transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
        ALLOWED_TAGS = "ALLOWED_TAGS" in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
        ALLOWED_ATTR = "ALLOWED_ATTR" in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
        ALLOWED_NAMESPACES = "ALLOWED_NAMESPACES" in cfg ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
        URI_SAFE_ATTRIBUTES = "ADD_URI_SAFE_ATTR" in cfg ? addToSet(
          clone2(DEFAULT_URI_SAFE_ATTRIBUTES),
          cfg.ADD_URI_SAFE_ATTR,
          transformCaseFunc
        ) : DEFAULT_URI_SAFE_ATTRIBUTES;
        DATA_URI_TAGS = "ADD_DATA_URI_TAGS" in cfg ? addToSet(
          clone2(DEFAULT_DATA_URI_TAGS),
          cfg.ADD_DATA_URI_TAGS,
          transformCaseFunc
        ) : DEFAULT_DATA_URI_TAGS;
        FORBID_CONTENTS = "FORBID_CONTENTS" in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
        FORBID_TAGS = "FORBID_TAGS" in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
        FORBID_ATTR = "FORBID_ATTR" in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
        USE_PROFILES = "USE_PROFILES" in cfg ? cfg.USE_PROFILES : false;
        ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
        ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
        ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
        ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
        SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
        WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
        RETURN_DOM = cfg.RETURN_DOM || false;
        RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
        RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
        FORCE_BODY = cfg.FORCE_BODY || false;
        SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
        SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
        KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
        IN_PLACE = cfg.IN_PLACE || false;
        IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI$1;
        NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
        CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
        if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
          CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
        }
        if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
          CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
        }
        if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
          CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
        }
        if (SAFE_FOR_TEMPLATES) {
          ALLOW_DATA_ATTR = false;
        }
        if (RETURN_DOM_FRAGMENT) {
          RETURN_DOM = true;
        }
        if (USE_PROFILES) {
          ALLOWED_TAGS = addToSet({}, _toConsumableArray(text));
          ALLOWED_ATTR = [];
          if (USE_PROFILES.html === true) {
            addToSet(ALLOWED_TAGS, html$1);
            addToSet(ALLOWED_ATTR, html);
          }
          if (USE_PROFILES.svg === true) {
            addToSet(ALLOWED_TAGS, svg$1);
            addToSet(ALLOWED_ATTR, svg);
            addToSet(ALLOWED_ATTR, xml);
          }
          if (USE_PROFILES.svgFilters === true) {
            addToSet(ALLOWED_TAGS, svgFilters);
            addToSet(ALLOWED_ATTR, svg);
            addToSet(ALLOWED_ATTR, xml);
          }
          if (USE_PROFILES.mathMl === true) {
            addToSet(ALLOWED_TAGS, mathMl$1);
            addToSet(ALLOWED_ATTR, mathMl);
            addToSet(ALLOWED_ATTR, xml);
          }
        }
        if (cfg.ADD_TAGS) {
          if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
            ALLOWED_TAGS = clone2(ALLOWED_TAGS);
          }
          addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
        }
        if (cfg.ADD_ATTR) {
          if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
            ALLOWED_ATTR = clone2(ALLOWED_ATTR);
          }
          addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
        }
        if (cfg.ADD_URI_SAFE_ATTR) {
          addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
        }
        if (cfg.FORBID_CONTENTS) {
          if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
            FORBID_CONTENTS = clone2(FORBID_CONTENTS);
          }
          addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
        }
        if (KEEP_CONTENT) {
          ALLOWED_TAGS["#text"] = true;
        }
        if (WHOLE_DOCUMENT) {
          addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
        }
        if (ALLOWED_TAGS.table) {
          addToSet(ALLOWED_TAGS, ["tbody"]);
          delete FORBID_TAGS.tbody;
        }
        if (freeze) {
          freeze(cfg);
        }
        CONFIG = cfg;
      };
      var MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
      var HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
      var COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
      var ALL_SVG_TAGS = addToSet({}, svg$1);
      addToSet(ALL_SVG_TAGS, svgFilters);
      addToSet(ALL_SVG_TAGS, svgDisallowed);
      var ALL_MATHML_TAGS = addToSet({}, mathMl$1);
      addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
      var _checkValidNamespace = function _checkValidNamespace2(element) {
        var parent = getParentNode(element);
        if (!parent || !parent.tagName) {
          parent = {
            namespaceURI: NAMESPACE,
            tagName: "template"
          };
        }
        var tagName = stringToLowerCase(element.tagName);
        var parentTagName = stringToLowerCase(parent.tagName);
        if (!ALLOWED_NAMESPACES[element.namespaceURI]) {
          return false;
        }
        if (element.namespaceURI === SVG_NAMESPACE) {
          if (parent.namespaceURI === HTML_NAMESPACE) {
            return tagName === "svg";
          }
          if (parent.namespaceURI === MATHML_NAMESPACE) {
            return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
          }
          return Boolean(ALL_SVG_TAGS[tagName]);
        }
        if (element.namespaceURI === MATHML_NAMESPACE) {
          if (parent.namespaceURI === HTML_NAMESPACE) {
            return tagName === "math";
          }
          if (parent.namespaceURI === SVG_NAMESPACE) {
            return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
          }
          return Boolean(ALL_MATHML_TAGS[tagName]);
        }
        if (element.namespaceURI === HTML_NAMESPACE) {
          if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
            return false;
          }
          if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
            return false;
          }
          return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
        }
        if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element.namespaceURI]) {
          return true;
        }
        return false;
      };
      var _forceRemove = function _forceRemove2(node) {
        arrayPush(DOMPurify2.removed, {
          element: node
        });
        try {
          node.parentNode.removeChild(node);
        } catch (_) {
          try {
            node.outerHTML = emptyHTML;
          } catch (_2) {
            node.remove();
          }
        }
      };
      var _removeAttribute = function _removeAttribute2(name, node) {
        try {
          arrayPush(DOMPurify2.removed, {
            attribute: node.getAttributeNode(name),
            from: node
          });
        } catch (_) {
          arrayPush(DOMPurify2.removed, {
            attribute: null,
            from: node
          });
        }
        node.removeAttribute(name);
        if (name === "is" && !ALLOWED_ATTR[name]) {
          if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
            try {
              _forceRemove(node);
            } catch (_) {
            }
          } else {
            try {
              node.setAttribute(name, "");
            } catch (_) {
            }
          }
        }
      };
      var _initDocument = function _initDocument2(dirty) {
        var doc;
        var leadingWhitespace;
        if (FORCE_BODY) {
          dirty = "<remove></remove>" + dirty;
        } else {
          var matches = stringMatch(dirty, /^[\r\n\t ]+/);
          leadingWhitespace = matches && matches[0];
        }
        if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
          dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
        }
        var dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
        if (NAMESPACE === HTML_NAMESPACE) {
          try {
            doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
          } catch (_) {
          }
        }
        if (!doc || !doc.documentElement) {
          doc = implementation2.createDocument(NAMESPACE, "template", null);
          try {
            doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
          } catch (_) {
          }
        }
        var body = doc.body || doc.documentElement;
        if (dirty && leadingWhitespace) {
          body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
        }
        if (NAMESPACE === HTML_NAMESPACE) {
          return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
        }
        return WHOLE_DOCUMENT ? doc.documentElement : body;
      };
      var _createIterator = function _createIterator2(root) {
        return createNodeIterator.call(
          root.ownerDocument || root,
          root,
          NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT,
          null,
          false
        );
      };
      var _isClobbered = function _isClobbered2(elm) {
        return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
      };
      var _isNode = function _isNode2(object) {
        return _typeof(Node6) === "object" ? object instanceof Node6 : object && _typeof(object) === "object" && typeof object.nodeType === "number" && typeof object.nodeName === "string";
      };
      var _executeHook = function _executeHook2(entryPoint, currentNode, data) {
        if (!hooks[entryPoint]) {
          return;
        }
        arrayForEach(hooks[entryPoint], function(hook) {
          hook.call(DOMPurify2, currentNode, data, CONFIG);
        });
      };
      var _sanitizeElements = function _sanitizeElements2(currentNode) {
        var content;
        _executeHook("beforeSanitizeElements", currentNode, null);
        if (_isClobbered(currentNode)) {
          _forceRemove(currentNode);
          return true;
        }
        if (regExpTest(/[\u0080-\uFFFF]/, currentNode.nodeName)) {
          _forceRemove(currentNode);
          return true;
        }
        var tagName = transformCaseFunc(currentNode.nodeName);
        _executeHook("uponSanitizeElement", currentNode, {
          tagName,
          allowedTags: ALLOWED_TAGS
        });
        if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
          _forceRemove(currentNode);
          return true;
        }
        if (tagName === "select" && regExpTest(/<template/i, currentNode.innerHTML)) {
          _forceRemove(currentNode);
          return true;
        }
        if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
          if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
            if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName))
              return false;
            if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName))
              return false;
          }
          if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
            var parentNode = getParentNode(currentNode) || currentNode.parentNode;
            var childNodes = getChildNodes(currentNode) || currentNode.childNodes;
            if (childNodes && parentNode) {
              var childCount = childNodes.length;
              for (var i = childCount - 1; i >= 0; --i) {
                parentNode.insertBefore(cloneNode(childNodes[i], true), getNextSibling(currentNode));
              }
            }
          }
          _forceRemove(currentNode);
          return true;
        }
        if (currentNode instanceof Element2 && !_checkValidNamespace(currentNode)) {
          _forceRemove(currentNode);
          return true;
        }
        if ((tagName === "noscript" || tagName === "noembed" || tagName === "noframes") && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
          _forceRemove(currentNode);
          return true;
        }
        if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
          content = currentNode.textContent;
          content = stringReplace(content, MUSTACHE_EXPR$1, " ");
          content = stringReplace(content, ERB_EXPR$1, " ");
          content = stringReplace(content, TMPLIT_EXPR$1, " ");
          if (currentNode.textContent !== content) {
            arrayPush(DOMPurify2.removed, {
              element: currentNode.cloneNode()
            });
            currentNode.textContent = content;
          }
        }
        _executeHook("afterSanitizeElements", currentNode, null);
        return false;
      };
      var _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value) {
        if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value in document2 || value in formElement)) {
          return false;
        }
        if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR$1, lcName))
          ;
        else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR$1, lcName))
          ;
        else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
          if (_basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value)))
            ;
          else {
            return false;
          }
        } else if (URI_SAFE_ATTRIBUTES[lcName])
          ;
        else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE$1, "")))
          ;
        else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value, "data:") === 0 && DATA_URI_TAGS[lcTag])
          ;
        else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA$1, stringReplace(value, ATTR_WHITESPACE$1, "")))
          ;
        else if (value) {
          return false;
        } else
          ;
        return true;
      };
      var _basicCustomElementTest = function _basicCustomElementTest2(tagName) {
        return tagName.indexOf("-") > 0;
      };
      var _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
        var attr;
        var value;
        var lcName;
        var l;
        _executeHook("beforeSanitizeAttributes", currentNode, null);
        var attributes = currentNode.attributes;
        if (!attributes) {
          return;
        }
        var hookEvent = {
          attrName: "",
          attrValue: "",
          keepAttr: true,
          allowedAttributes: ALLOWED_ATTR
        };
        l = attributes.length;
        while (l--) {
          attr = attributes[l];
          var _attr = attr, name = _attr.name, namespaceURI = _attr.namespaceURI;
          value = name === "value" ? attr.value : stringTrim(attr.value);
          lcName = transformCaseFunc(name);
          hookEvent.attrName = lcName;
          hookEvent.attrValue = value;
          hookEvent.keepAttr = true;
          hookEvent.forceKeepAttr = void 0;
          _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
          value = hookEvent.attrValue;
          if (hookEvent.forceKeepAttr) {
            continue;
          }
          _removeAttribute(name, currentNode);
          if (!hookEvent.keepAttr) {
            continue;
          }
          if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value)) {
            _removeAttribute(name, currentNode);
            continue;
          }
          if (SAFE_FOR_TEMPLATES) {
            value = stringReplace(value, MUSTACHE_EXPR$1, " ");
            value = stringReplace(value, ERB_EXPR$1, " ");
            value = stringReplace(value, TMPLIT_EXPR$1, " ");
          }
          var lcTag = transformCaseFunc(currentNode.nodeName);
          if (!_isValidAttribute(lcTag, lcName, value)) {
            continue;
          }
          if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
            _removeAttribute(name, currentNode);
            value = SANITIZE_NAMED_PROPS_PREFIX + value;
          }
          if (trustedTypesPolicy && _typeof(trustedTypes) === "object" && typeof trustedTypes.getAttributeType === "function") {
            if (namespaceURI)
              ;
            else {
              switch (trustedTypes.getAttributeType(lcTag, lcName)) {
                case "TrustedHTML": {
                  value = trustedTypesPolicy.createHTML(value);
                  break;
                }
                case "TrustedScriptURL": {
                  value = trustedTypesPolicy.createScriptURL(value);
                  break;
                }
              }
            }
          }
          try {
            if (namespaceURI) {
              currentNode.setAttributeNS(namespaceURI, name, value);
            } else {
              currentNode.setAttribute(name, value);
            }
            arrayPop(DOMPurify2.removed);
          } catch (_) {
          }
        }
        _executeHook("afterSanitizeAttributes", currentNode, null);
      };
      var _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
        var shadowNode;
        var shadowIterator = _createIterator(fragment);
        _executeHook("beforeSanitizeShadowDOM", fragment, null);
        while (shadowNode = shadowIterator.nextNode()) {
          _executeHook("uponSanitizeShadowNode", shadowNode, null);
          if (_sanitizeElements(shadowNode)) {
            continue;
          }
          if (shadowNode.content instanceof DocumentFragment2) {
            _sanitizeShadowDOM2(shadowNode.content);
          }
          _sanitizeAttributes(shadowNode);
        }
        _executeHook("afterSanitizeShadowDOM", fragment, null);
      };
      DOMPurify2.sanitize = function(dirty) {
        var cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        var body;
        var importedNode;
        var currentNode;
        var oldNode;
        var returnNode;
        IS_EMPTY_INPUT = !dirty;
        if (IS_EMPTY_INPUT) {
          dirty = "<!-->";
        }
        if (typeof dirty !== "string" && !_isNode(dirty)) {
          if (typeof dirty.toString === "function") {
            dirty = dirty.toString();
            if (typeof dirty !== "string") {
              throw typeErrorCreate("dirty is not a string, aborting");
            }
          } else {
            throw typeErrorCreate("toString is not a function");
          }
        }
        if (!DOMPurify2.isSupported) {
          if (_typeof(window2.toStaticHTML) === "object" || typeof window2.toStaticHTML === "function") {
            if (typeof dirty === "string") {
              return window2.toStaticHTML(dirty);
            }
            if (_isNode(dirty)) {
              return window2.toStaticHTML(dirty.outerHTML);
            }
          }
          return dirty;
        }
        if (!SET_CONFIG) {
          _parseConfig(cfg);
        }
        DOMPurify2.removed = [];
        if (typeof dirty === "string") {
          IN_PLACE = false;
        }
        if (IN_PLACE) {
          if (dirty.nodeName) {
            var tagName = transformCaseFunc(dirty.nodeName);
            if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
              throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
            }
          }
        } else if (dirty instanceof Node6) {
          body = _initDocument("<!---->");
          importedNode = body.ownerDocument.importNode(dirty, true);
          if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
            body = importedNode;
          } else if (importedNode.nodeName === "HTML") {
            body = importedNode;
          } else {
            body.appendChild(importedNode);
          }
        } else {
          if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && dirty.indexOf("<") === -1) {
            return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
          }
          body = _initDocument(dirty);
          if (!body) {
            return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
          }
        }
        if (body && FORCE_BODY) {
          _forceRemove(body.firstChild);
        }
        var nodeIterator = _createIterator(IN_PLACE ? dirty : body);
        while (currentNode = nodeIterator.nextNode()) {
          if (currentNode.nodeType === 3 && currentNode === oldNode) {
            continue;
          }
          if (_sanitizeElements(currentNode)) {
            continue;
          }
          if (currentNode.content instanceof DocumentFragment2) {
            _sanitizeShadowDOM(currentNode.content);
          }
          _sanitizeAttributes(currentNode);
          oldNode = currentNode;
        }
        oldNode = null;
        if (IN_PLACE) {
          return dirty;
        }
        if (RETURN_DOM) {
          if (RETURN_DOM_FRAGMENT) {
            returnNode = createDocumentFragment.call(body.ownerDocument);
            while (body.firstChild) {
              returnNode.appendChild(body.firstChild);
            }
          } else {
            returnNode = body;
          }
          if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmod) {
            returnNode = importNode.call(originalDocument, returnNode, true);
          }
          return returnNode;
        }
        var serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
        if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
          serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
        }
        if (SAFE_FOR_TEMPLATES) {
          serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR$1, " ");
          serializedHTML = stringReplace(serializedHTML, ERB_EXPR$1, " ");
          serializedHTML = stringReplace(serializedHTML, TMPLIT_EXPR$1, " ");
        }
        return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
      };
      DOMPurify2.setConfig = function(cfg) {
        _parseConfig(cfg);
        SET_CONFIG = true;
      };
      DOMPurify2.clearConfig = function() {
        CONFIG = null;
        SET_CONFIG = false;
      };
      DOMPurify2.isValidAttribute = function(tag, attr, value) {
        if (!CONFIG) {
          _parseConfig({});
        }
        var lcTag = transformCaseFunc(tag);
        var lcName = transformCaseFunc(attr);
        return _isValidAttribute(lcTag, lcName, value);
      };
      DOMPurify2.addHook = function(entryPoint, hookFunction) {
        if (typeof hookFunction !== "function") {
          return;
        }
        hooks[entryPoint] = hooks[entryPoint] || [];
        arrayPush(hooks[entryPoint], hookFunction);
      };
      DOMPurify2.removeHook = function(entryPoint) {
        if (hooks[entryPoint]) {
          return arrayPop(hooks[entryPoint]);
        }
      };
      DOMPurify2.removeHooks = function(entryPoint) {
        if (hooks[entryPoint]) {
          hooks[entryPoint] = [];
        }
      };
      DOMPurify2.removeAllHooks = function() {
        hooks = {};
      };
      return DOMPurify2;
    }
    var purify = createDOMPurify();
    module2.exports = purify;
  }
});

// node_modules/jsep/build/jsep.js
var require_jsep = __commonJS({
  "node_modules/jsep/build/jsep.js"(exports2, module2) {
    (function(root) {
      "use strict";
      var COMPOUND = "Compound", IDENTIFIER = "Identifier", MEMBER_EXP = "MemberExpression", LITERAL = "Literal", THIS_EXP = "ThisExpression", CALL_EXP = "CallExpression", UNARY_EXP = "UnaryExpression", BINARY_EXP = "BinaryExpression", LOGICAL_EXP = "LogicalExpression", CONDITIONAL_EXP = "ConditionalExpression", ARRAY_EXP = "ArrayExpression", PERIOD_CODE = 46, COMMA_CODE = 44, SQUOTE_CODE = 39, DQUOTE_CODE = 34, OPAREN_CODE = 40, CPAREN_CODE = 41, OBRACK_CODE = 91, CBRACK_CODE = 93, QUMARK_CODE = 63, SEMCOL_CODE = 59, COLON_CODE = 58, throwError = function(message, index) {
        var error = new Error(message + " at character " + index);
        error.index = index;
        error.description = message;
        throw error;
      }, t = true, unary_ops = { "-": t, "!": t, "~": t, "+": t }, binary_ops = {
        "||": 1,
        "&&": 2,
        "|": 3,
        "^": 4,
        "&": 5,
        "==": 6,
        "!=": 6,
        "===": 6,
        "!==": 6,
        "<": 7,
        ">": 7,
        "<=": 7,
        ">=": 7,
        "<<": 8,
        ">>": 8,
        ">>>": 8,
        "+": 9,
        "-": 9,
        "*": 10,
        "/": 10,
        "%": 10
      }, getMaxKeyLen = function(obj) {
        var max_len = 0, len;
        for (var key in obj) {
          if ((len = key.length) > max_len && obj.hasOwnProperty(key)) {
            max_len = len;
          }
        }
        return max_len;
      }, max_unop_len = getMaxKeyLen(unary_ops), max_binop_len = getMaxKeyLen(binary_ops), literals = {
        "true": true,
        "false": false,
        "null": null
      }, this_str = "this", binaryPrecedence = function(op_val) {
        return binary_ops[op_val] || 0;
      }, createBinaryExpression = function(operator, left, right) {
        var type = operator === "||" || operator === "&&" ? LOGICAL_EXP : BINARY_EXP;
        return {
          type,
          operator,
          left,
          right
        };
      }, isDecimalDigit = function(ch) {
        return ch >= 48 && ch <= 57;
      }, isIdentifierStart = function(ch) {
        return ch === 36 || ch === 95 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 128 && !binary_ops[String.fromCharCode(ch)];
      }, isIdentifierPart = function(ch) {
        return ch === 36 || ch === 95 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ch >= 128 && !binary_ops[String.fromCharCode(ch)];
      }, jsep2 = function(expr) {
        var index = 0, charAtFunc = expr.charAt, charCodeAtFunc = expr.charCodeAt, exprI = function(i) {
          return charAtFunc.call(expr, i);
        }, exprICode = function(i) {
          return charCodeAtFunc.call(expr, i);
        }, length3 = expr.length, gobbleSpaces = function() {
          var ch = exprICode(index);
          while (ch === 32 || ch === 9 || ch === 10 || ch === 13) {
            ch = exprICode(++index);
          }
        }, gobbleExpression = function() {
          var test = gobbleBinaryExpression(), consequent, alternate;
          gobbleSpaces();
          if (exprICode(index) === QUMARK_CODE) {
            index++;
            consequent = gobbleExpression();
            if (!consequent) {
              throwError("Expected expression", index);
            }
            gobbleSpaces();
            if (exprICode(index) === COLON_CODE) {
              index++;
              alternate = gobbleExpression();
              if (!alternate) {
                throwError("Expected expression", index);
              }
              return {
                type: CONDITIONAL_EXP,
                test,
                consequent,
                alternate
              };
            } else {
              throwError("Expected :", index);
            }
          } else {
            return test;
          }
        }, gobbleBinaryOp = function() {
          gobbleSpaces();
          var biop, to_check = expr.substr(index, max_binop_len), tc_len = to_check.length;
          while (tc_len > 0) {
            if (binary_ops.hasOwnProperty(to_check) && (!isIdentifierStart(exprICode(index)) || index + to_check.length < expr.length && !isIdentifierPart(exprICode(index + to_check.length)))) {
              index += tc_len;
              return to_check;
            }
            to_check = to_check.substr(0, --tc_len);
          }
          return false;
        }, gobbleBinaryExpression = function() {
          var ch_i2, node2, biop, prec, stack, biop_info, left, right, i, cur_biop;
          left = gobbleToken();
          biop = gobbleBinaryOp();
          if (!biop) {
            return left;
          }
          biop_info = { value: biop, prec: binaryPrecedence(biop) };
          right = gobbleToken();
          if (!right) {
            throwError("Expected expression after " + biop, index);
          }
          stack = [left, biop_info, right];
          while (biop = gobbleBinaryOp()) {
            prec = binaryPrecedence(biop);
            if (prec === 0) {
              break;
            }
            biop_info = { value: biop, prec };
            cur_biop = biop;
            while (stack.length > 2 && prec <= stack[stack.length - 2].prec) {
              right = stack.pop();
              biop = stack.pop().value;
              left = stack.pop();
              node2 = createBinaryExpression(biop, left, right);
              stack.push(node2);
            }
            node2 = gobbleToken();
            if (!node2) {
              throwError("Expected expression after " + cur_biop, index);
            }
            stack.push(biop_info, node2);
          }
          i = stack.length - 1;
          node2 = stack[i];
          while (i > 1) {
            node2 = createBinaryExpression(stack[i - 1].value, stack[i - 2], node2);
            i -= 2;
          }
          return node2;
        }, gobbleToken = function() {
          var ch, to_check, tc_len;
          gobbleSpaces();
          ch = exprICode(index);
          if (isDecimalDigit(ch) || ch === PERIOD_CODE) {
            return gobbleNumericLiteral();
          } else if (ch === SQUOTE_CODE || ch === DQUOTE_CODE) {
            return gobbleStringLiteral();
          } else if (ch === OBRACK_CODE) {
            return gobbleArray();
          } else {
            to_check = expr.substr(index, max_unop_len);
            tc_len = to_check.length;
            while (tc_len > 0) {
              if (unary_ops.hasOwnProperty(to_check) && (!isIdentifierStart(exprICode(index)) || index + to_check.length < expr.length && !isIdentifierPart(exprICode(index + to_check.length)))) {
                index += tc_len;
                return {
                  type: UNARY_EXP,
                  operator: to_check,
                  argument: gobbleToken(),
                  prefix: true
                };
              }
              to_check = to_check.substr(0, --tc_len);
            }
            if (isIdentifierStart(ch) || ch === OPAREN_CODE) {
              return gobbleVariable();
            }
          }
          return false;
        }, gobbleNumericLiteral = function() {
          var number = "", ch, chCode;
          while (isDecimalDigit(exprICode(index))) {
            number += exprI(index++);
          }
          if (exprICode(index) === PERIOD_CODE) {
            number += exprI(index++);
            while (isDecimalDigit(exprICode(index))) {
              number += exprI(index++);
            }
          }
          ch = exprI(index);
          if (ch === "e" || ch === "E") {
            number += exprI(index++);
            ch = exprI(index);
            if (ch === "+" || ch === "-") {
              number += exprI(index++);
            }
            while (isDecimalDigit(exprICode(index))) {
              number += exprI(index++);
            }
            if (!isDecimalDigit(exprICode(index - 1))) {
              throwError("Expected exponent (" + number + exprI(index) + ")", index);
            }
          }
          chCode = exprICode(index);
          if (isIdentifierStart(chCode)) {
            throwError("Variable names cannot start with a number (" + number + exprI(index) + ")", index);
          } else if (chCode === PERIOD_CODE) {
            throwError("Unexpected period", index);
          }
          return {
            type: LITERAL,
            value: parseFloat(number),
            raw: number
          };
        }, gobbleStringLiteral = function() {
          var str = "", quote = exprI(index++), closed = false, ch;
          while (index < length3) {
            ch = exprI(index++);
            if (ch === quote) {
              closed = true;
              break;
            } else if (ch === "\\") {
              ch = exprI(index++);
              switch (ch) {
                case "n":
                  str += "\n";
                  break;
                case "r":
                  str += "\r";
                  break;
                case "t":
                  str += "	";
                  break;
                case "b":
                  str += "\b";
                  break;
                case "f":
                  str += "\f";
                  break;
                case "v":
                  str += "\v";
                  break;
                default:
                  str += ch;
              }
            } else {
              str += ch;
            }
          }
          if (!closed) {
            throwError('Unclosed quote after "' + str + '"', index);
          }
          return {
            type: LITERAL,
            value: str,
            raw: quote + str + quote
          };
        }, gobbleIdentifier = function() {
          var ch = exprICode(index), start = index, identifier;
          if (isIdentifierStart(ch)) {
            index++;
          } else {
            throwError("Unexpected " + exprI(index), index);
          }
          while (index < length3) {
            ch = exprICode(index);
            if (isIdentifierPart(ch)) {
              index++;
            } else {
              break;
            }
          }
          identifier = expr.slice(start, index);
          if (literals.hasOwnProperty(identifier)) {
            return {
              type: LITERAL,
              value: literals[identifier],
              raw: identifier
            };
          } else if (identifier === this_str) {
            return { type: THIS_EXP };
          } else {
            return {
              type: IDENTIFIER,
              name: identifier
            };
          }
        }, gobbleArguments = function(termination) {
          var ch_i2, args = [], node2, closed = false;
          var separator_count = 0;
          while (index < length3) {
            gobbleSpaces();
            ch_i2 = exprICode(index);
            if (ch_i2 === termination) {
              closed = true;
              index++;
              if (termination === CPAREN_CODE && separator_count && separator_count >= args.length) {
                throwError("Unexpected token " + String.fromCharCode(termination), index);
              }
              break;
            } else if (ch_i2 === COMMA_CODE) {
              index++;
              separator_count++;
              if (separator_count !== args.length) {
                if (termination === CPAREN_CODE) {
                  throwError("Unexpected token ,", index);
                } else if (termination === CBRACK_CODE) {
                  for (var arg = args.length; arg < separator_count; arg++) {
                    args.push(null);
                  }
                }
              }
            } else {
              node2 = gobbleExpression();
              if (!node2 || node2.type === COMPOUND) {
                throwError("Expected comma", index);
              }
              args.push(node2);
            }
          }
          if (!closed) {
            throwError("Expected " + String.fromCharCode(termination), index);
          }
          return args;
        }, gobbleVariable = function() {
          var ch_i2, node2;
          ch_i2 = exprICode(index);
          if (ch_i2 === OPAREN_CODE) {
            node2 = gobbleGroup();
          } else {
            node2 = gobbleIdentifier();
          }
          gobbleSpaces();
          ch_i2 = exprICode(index);
          while (ch_i2 === PERIOD_CODE || ch_i2 === OBRACK_CODE || ch_i2 === OPAREN_CODE) {
            index++;
            if (ch_i2 === PERIOD_CODE) {
              gobbleSpaces();
              node2 = {
                type: MEMBER_EXP,
                computed: false,
                object: node2,
                property: gobbleIdentifier()
              };
            } else if (ch_i2 === OBRACK_CODE) {
              node2 = {
                type: MEMBER_EXP,
                computed: true,
                object: node2,
                property: gobbleExpression()
              };
              gobbleSpaces();
              ch_i2 = exprICode(index);
              if (ch_i2 !== CBRACK_CODE) {
                throwError("Unclosed [", index);
              }
              index++;
            } else if (ch_i2 === OPAREN_CODE) {
              node2 = {
                type: CALL_EXP,
                "arguments": gobbleArguments(CPAREN_CODE),
                callee: node2
              };
            }
            gobbleSpaces();
            ch_i2 = exprICode(index);
          }
          return node2;
        }, gobbleGroup = function() {
          index++;
          var node2 = gobbleExpression();
          gobbleSpaces();
          if (exprICode(index) === CPAREN_CODE) {
            index++;
            return node2;
          } else {
            throwError("Unclosed (", index);
          }
        }, gobbleArray = function() {
          index++;
          return {
            type: ARRAY_EXP,
            elements: gobbleArguments(CBRACK_CODE)
          };
        }, nodes = [], ch_i, node;
        while (index < length3) {
          ch_i = exprICode(index);
          if (ch_i === SEMCOL_CODE || ch_i === COMMA_CODE) {
            index++;
          } else {
            if (node = gobbleExpression()) {
              nodes.push(node);
            } else if (index < length3) {
              throwError('Unexpected "' + exprI(index) + '"', index);
            }
          }
        }
        if (nodes.length === 1) {
          return nodes[0];
        } else {
          return {
            type: COMPOUND,
            body: nodes
          };
        }
      };
      jsep2.version = "0.3.5";
      jsep2.toString = function() {
        return "JavaScript Expression Parser (JSEP) v" + jsep2.version;
      };
      jsep2.addUnaryOp = function(op_name) {
        max_unop_len = Math.max(op_name.length, max_unop_len);
        unary_ops[op_name] = t;
        return this;
      };
      jsep2.addBinaryOp = function(op_name, precedence) {
        max_binop_len = Math.max(op_name.length, max_binop_len);
        binary_ops[op_name] = precedence;
        return this;
      };
      jsep2.addLiteral = function(literal_name, literal_value) {
        literals[literal_name] = literal_value;
        return this;
      };
      jsep2.removeUnaryOp = function(op_name) {
        delete unary_ops[op_name];
        if (op_name.length === max_unop_len) {
          max_unop_len = getMaxKeyLen(unary_ops);
        }
        return this;
      };
      jsep2.removeAllUnaryOps = function() {
        unary_ops = {};
        max_unop_len = 0;
        return this;
      };
      jsep2.removeBinaryOp = function(op_name) {
        delete binary_ops[op_name];
        if (op_name.length === max_binop_len) {
          max_binop_len = getMaxKeyLen(binary_ops);
        }
        return this;
      };
      jsep2.removeAllBinaryOps = function() {
        binary_ops = {};
        max_binop_len = 0;
        return this;
      };
      jsep2.removeLiteral = function(literal_name) {
        delete literals[literal_name];
        return this;
      };
      jsep2.removeAllLiterals = function() {
        literals = {};
        return this;
      };
      if (typeof exports2 === "undefined") {
        var old_jsep = root.jsep;
        root.jsep = jsep2;
        jsep2.noConflict = function() {
          if (root.jsep === jsep2) {
            root.jsep = old_jsep;
          }
          return jsep2;
        };
      } else {
        if (typeof module2 !== "undefined" && module2.exports) {
          exports2 = module2.exports = jsep2;
        } else {
          exports2.parse = jsep2;
        }
      }
    })(exports2);
  }
});

// node_modules/meshoptimizer/meshopt_encoder.js
var require_meshopt_encoder = __commonJS({
  "node_modules/meshoptimizer/meshopt_encoder.js"(exports2, module2) {
    var MeshoptEncoder = function() {
      "use strict";
      var wasm = "B9h79tEBBBENQ9gEUEU9gEUB9gBB9gVUUUUUEU9gDUUEU9gLUUUUEU9gVUUUUUB9gLUUUUB9gIUUUEU9gD99UE99I8ayDILEVLEVLOOOOORRVBWWBEdddLVE9wEIIVIEBEOWEUEC+g/KEKR/QIhO9tw9t9vv95DBh9f9f939h79t9f9j9h229f9jT9vv7BB8a9tw79o9v9wT9fw9u9j9v9kw9WwvTw949C919m9mwvBE8f9tw79o9v9wT9fw9u9j9v9kw9WwvTw949C919m9mwv9C9v919u9kBDe9tw79o9v9wT9fw9u9j9v9kw9WwvTw949Wwv79p9v9uBIy9tw79o9v9wT9fw9u9j9v9kw69u9kw949C919m9mwvBL8e9tw79o9v9wT9fw9u9j9v9kw69u9kw949C919m9mwv9C9v919u9kBV8a9tw79o9v9wT9fw9u9j9v9kw69u9kw949Wwv79p9v9uBOe9tw79o9v9wT9fw9u9j9v9kw69u9kw949Twg91w9u9jwBRA9tw79o9v9wT9fw9u9j9v9kw69u9kw949Twg91w9u9jw9C9v919u9kBWl9tw79o9v9wT9fw9u9j9v9kws9p2Twv9P9jTBdk9tw79o9v9wT9fw9u9j9v9kws9p2Twv9R919hTBQl9tw79o9v9wT9fw9u9j9v9kws9p2Twvt949wBKe9tw79o9v9wT9f9v9wT9p9t9p96w9WwvTw94j9h9j9owBpA9tw79o9v9wT9f9v9wT9p9t9p96w9WwvTw94j9h9j9ow9TTv9p9wBSA9tw79o9v9wT9f9v9wT9p9t9p96w9WwvTw94swT9j9o9Sw9t9h9wBZL79iv9rBhdWEBCEKDxcQ+1tyDBK/hKEyU8jJJJJBCJO9rGV8kJJJJBCBHODNALCEFAE0MBABCBrB+Q+KJJBC+gEv86BBAVCJDFCBCJDZ+TJJJB8aDNAItMBAVCJDFADALZmJJJB8aKABAEFHRABCEFHWAVALFCBCBCJDAL9rALCfE0eZ+TJJJB8aAVAVCJDFALZmJJJBHdCJ/ABAL9uHEDNDNALtMBAEC/wfBgGECJDAECJD6eHQCBHKINAKAI9PMEAdCJLFCBCJDZ+TJJJB8aAQAIAK9rAKAQFAI6eGXCSFGECL4CIFCD4HMADAKAL2FHpDNDNDNDNDNAEC9wgGStMBCBHZCEHhApHoAWHaXEKDNAXtMBCBHaCEHhApHcINAdAaFrBBHxAcHECBHOINAdCJLFAOFAErBBGqAx9rGxCETAxCkTCk91CR4786BBAEALFHEAqHxAOCEFGOAX9HMBKARAW9rAM6MIAWCBAMZ+TJJJBGEtMIAEAMFHWAcCEFHcAaCEFGaAL6HhAaAL9HMBXVKKARAW9rAM6MOAWCBAMZ+TJJJB8aCEHEINAWGxAMFHWALAEGOsMLDNARAW9rAM6MBAOCEFHEAWCBAMZ+TJJJB8aAxMEKKCBHWAOAL6MOXIKINDNAXtMBAdAZFrBBHxCBHEAoHOINAdCJLFAEFAOrBBGqAx9rGxCETAxCkTCk91CR4786BBAOALFHOAqHxAECEFGEAX9HMBKKARAa9rAM6MEARAaCBAMZ+TJJJBGlAMFGW9rCk6MDCBHkAdCJLFHcINAdCJLFAkFHyCWH8aCZHaCEHqINDNDNAqCE9HMBCUHOAyrBBMECBHODNINAOGECSsMEAECEFHOAcAEFCEFrBBtMBKKCUCBAECS6eHOXEKAqCETC/+fffEgHOCUAqTCU7CfEgHxCBHEINAOAxAcAEFrBB9NFHOAECEFGECZ9HMBKKAOAaAOAa6GEeHaAqA8aAEeH8aAqCETGqCW6MBKDNDNDNDNA8aCUFpDIEBKAlAkCO4FGEAErBBCDCIA8aCLseAkCI4COgTv86BBA8aCW9HMEAWAy8pBB83BBAWCWFAyCWF8pBB83BBAWCZFHWXDKAlAkCO4FGEAErBBCEAkCI4COgTv86BBKDNCWA8a9tGeMBINAWCB86BBAWCEFHWXBKKCUA8aTCU7HqCBH3AcH5INA5HEAeHxCBHOINAErBBGaAqAaAqCfEgGy6eAOCfEgA8aTvHOAECEFHEAxCUFGxMBKAWAO86BBA5AeFH5AWCEFHWA3AeFG3CZ6MBKCBHEINDNAcAEFrBBGOAy6MBAWAO86BBAWCEFHWKAECEFGECZ9HMBKKDNAkCZFGkAS9PMBAcCZFHcARAW9rCl0MEKKAkAS6MEAWtMEAoCEFHoAZCEFGZAL6HhAWHaAZALsMIXBKKCBHWAhCEgtMEXLKCBHWAhCEgMIKAdApAXCUFAL2FALZmJJJB8aAXAKFHKAWMBKCBHOXDKCBHOARAW9rCAALALCA6e6MEDNALC8f0MBAWCBCAAL9rGEZ+TJJJBAEFHWKAWAdCJDFALZmJJJBALFAB9rHOXEKCBHOKAVCJOF8kJJJJBAOK9HEEUAECAAECA0eABCJ/ABAE9uC/wfBgGDCJDADCJD6eGDFCUFAD9uAE2ADCL4CIFCD4ADv2FCEFKMBCBABbD+Q+KJJBK/YSE3U8jJJJJBC/AE9rGL8kJJJJBCBHVDNAICI9uGOChFAE0MBABCBYDn+KJJBGVC/gEv86BBALC/ABFCfECJEZ+TJJJB8aALCuFGR9CU83IBALC8wFGW9CU83IBALCYFGd9CU83IBALCAFGQ9CU83IBALCkFGK9CU83IBALCZFGX9CU83IBAL9CU83IWAL9CU83IBABAEFC9wFHMABCEFGpAOFHEDNAItMBCMCSAVCB9KGSeHZAVCE9IHhCBHoCBHaCBHcCBHxCBHqINDNAEAM9NMBCBHVXIKAqCUFHVADAcCDTFGOYDBHlAOCWFYDBHkAOCLFYDBHyCBH8aDNDNINALC/ABFAVCSgCITFGOYDLHeDNDNDNAOYDBGOAl9HMBAeAysMEKDNAOAy9HMBAeAk9HMBA8aCEFH8aXEKAOAk9HMEAeAl9HMEA8aCDFH8aKA8aC870MDAxCUFHVADA8aCIgCX2GOC+Y1JJBFYDBAcFCDTFYDBHeADAOCn1JJBFYDBAcFCDTFYDBHkADAOC+Q1JJBFYDBAcFCDTFYDBHlCBHODNINDNALAVCSgCDTFYDBAe9HMBAOHyXDKCUHyAVCUFHVAOCEFGOCZ9HMBKKAyCB9KAyAZ9IgGVCU7AeAosGOgH3DNDNDNDNDNAyCBCSAOeAVeGVCS9HMBAhMBAeAeAaAeCEFAasGVeGaCEFsMECMCSAVeHVKApAVA8aCDTC/wEgv86BBAVCS9HMEAeAa9rGVCETAVC8f917HVINAEAVCfB0CRTAVCfBgv86BBAECEFHEAVCJE6HOAVCR4HVAOtMBKAeHaXDKCpHVApA8aCDTCpv86BBAeHaKAVtMBAVAZ9IMEKALAxCDTFAebDBAxCEFCSgHxKAoA3FHoALC/ABFAqCITFGVAkbDLAVAebDBALC/ABFAqCEFCSgGVCITFGOAebDLAOAlbDBAVCEFHOXIKAVCUFHVA8aCLFG8aC/AB9HMBKKDNADCEAkAosCETAyAoseCX2GVC+Q1JJBFYDBAcFCDTFYDBGltADAVCn1JJBFYDBAcFCDTFYDBG8aCEsgADAVC+Y1JJBFYDBAcFCDTFYDBGyCDsgAoCB9HgASgG5CE9HMBAR9CU83IBAW9CU83IBAd9CU83IBAQ9CU83IBAK9CU83IBAX9CU83IBAL9CU83IWAL9CU83IBCBHoKCBHeAxCUFGVHODNINDNALAOCSgCDTFYDBA8a9HMBAeHkXDKCUHkAOCUFHOAeCEFGeCZ9HMBKKCBHODNINDNALAVCSgCDTFYDBAy9HMBAOHeXDKCUHeAVCUFHVAOCEFGOCZ9HMBKKAoAlAosG8eFH3DNDNAkCM0MBAkCEFHkXEKCBCSA8aA3sGVeHkA3AVFH3KDNDNAeCM0MBAeCEFHeXEKCBCSAyA3sGVeHeA3AVFH3KC9+CUA8eeH8fAeAkCLTvHOCBHVDNDNDNINAVCJ1JJBFrBBAOCfEgsMEAVCEFGVCZ9HMBXDKKAlAo9HAVCM0vA5vMBApAVC/wEv86BBXEKApA8f86BBAEAO86BBAECEFHEKDNA8eMBAlAa9rGVCETAVC8f917HVINAEAVCfB0GOCRTAVCfBgv86BBAVCR4HVAECEFHEAOMBKAlHaKDNAkCS9HMBA8aAa9rGVCETAVC8f917HVINAEAVCfB0GOCRTAVCfBgv86BBAVCR4HVAECEFHEAOMBKA8aHaKDNAeCS9HMBAyAa9rGVCETAVC8f917HVINAEAVCfB0GOCRTAVCfBgv86BBAVCR4HVAECEFHEAOMBKAyHaKALAxCDTFAlbDBAxCEFCSgHVDNDNAkpZBEEEEEEEEEEEEEEBEKALAVCDTFA8abDBAxCDFCSgHVKDNDNAepZBEEEEEEEEEEEEEEBEKALAVCDTFAybDBAVCEFCSgHVKALC/ABFAqCITFGOAlbDLAOA8abDBALC/ABFAqCEFCSgCITFGOA8abDLAOAybDBALC/ABFAqCDFCSgCITFGOAybDLAOAlbDBAqCIFHOAVHxA3HoKApCEFHpAOCSgHqAcCIFGcAI6MBKKCBHVAEAM0MBCBHVINAEAVFAVCJ1JJBFrBB86BBAVCEFGVCZ9HMBKAEAB9rAVFHVKALC/AEF8kJJJJBAVKzEEUCBHDDNINADCEFGDC8f0MECEADTAE6MBKKADCRFCfEgCR9uCI2CDFABCI9u2ChFKMBCBABbDn+KJJBK+cDEWU8jJJJJBCZ9rHLCBHVDNAICVFAE0MBCBHOABCBrBn+KJJBC/QEv86BBAL9CB83IWABCEFHRABAEFC98FHWDNAItMBCBHdINDNARAW6MBCBSKADAdCDTFYDBGQALCWFAOAQALCWFAOCDTFYDB9rGEAEC8f91GEFAE7C507GOCDTFGKYDB9rGEC8e91C9+gAECDT7AOvHEINARAECfB0GVCRTAECfBgv86BBAECR4HEARCEFHRAVMBKAKAQbDBAdCEFGdAI9HMBKKCBHVARAW0MBARCBbBBARAB9rCLFHVKAVKbEEUCBHDDNINADCEFGDC8f0MECEADTAE6MBKKADCWFCfEgCR9uAB2CVFK+DVLI99DUI99LUDNAEtMBCUADCETCUFTCU7+yHVDNDNCUAICUFTCU7+yGOjBBBzmGR+LjBBB9P9dtMBAR+oHWXEKCJJJJ94HWKCBHICBHdINALCLFiDBGRjBBBBjBBJzALiDBGQ+LAR+LmALCWFiDBGK+LmGR+VARjBBBB9beGRnHXAQARnHRALCXFiDBHQDNDNAKjBBBB9gtMBAXHKXEKjBBJzAR+L+TGKAK+MAXjBBBB9geHKjBBJzAX+L+TGXAX+MARjBBBB9geHRKDNDNAQjBBJ+/AQjBBJ+/9geGXjBBJzAXjBBJz9feAVnjBBBzjBBB+/AQjBBBB9gemGQ+LjBBB9P9dtMBAQ+oHMXEKCJJJJ94HMKDNDNAKjBBJ+/AKjBBJ+/9geGQjBBJzAQjBBJz9feAOnjBBBzjBBB+/AKjBBBB9gemGQ+LjBBB9P9dtMBAQ+oHpXEKCJJJJ94HpKDNDNARjBBJ+/ARjBBJ+/9geGQjBBJzAQjBBJz9feAOnjBBBzjBBB+/ARjBBBB9gemGR+LjBBB9P9dtMBAR+oHSXEKCJJJJ94HSKDNDNADCL9HMBABAdFGZAS86BBAZCIFAM86BBAZCDFAW86BBAZCEFAp86BBXEKABAIFGZAS87EBAZCOFAM87EBAZCLFAW87EBAZCDFAp87EBKALCZFHLAICWFHIAdCLFHdAECUFGEMBKKK/KLLD99EUD99EUDNAEtMBDNDNCUAICUFTCU7+yGVjBBBzmGO+LjBBB9P9dtMBAO+oHIXEKCJJJJ94HIKAIC/8fIgHRINABCOFCICDALCLFiDB+LALiDB+L9eGIALCWFiDB+LALAICDTFiDB+L9eeGIALCXFiDB+LALAICDTFiDB+L9eeGIARv87EBDNDNALAICEFCIgCDTFiDBj/zL+1znjBBJ+/jBBJzALAICDTFiDBjBBBB9deGOnGWjBBJ+/AWjBBJ+/9geGdjBBJzAdjBBJz9feAVnjBBBzjBBB+/AWjBBBB9gemGW+LjBBB9P9dtMBAW+oHQXEKCJJJJ94HQKABAQ87EBDNDNAOALAICDFCIgCDTFiDBj/zL+1znnGWjBBJ+/AWjBBJ+/9geGdjBBJzAdjBBJz9feAVnjBBBzjBBB+/AWjBBBB9gemGW+LjBBB9P9dtMBAW+oHQXEKCJJJJ94HQKABCDFAQ87EBDNDNAOALAICUFCIgCDTFiDBj/zL+1znnGOjBBJ+/AOjBBJ+/9geGWjBBJzAWjBBJz9feAVnjBBBzjBBB+/AOjBBBB9gemGO+LjBBB9P9dtMBAO+oHIXEKCJJJJ94HIKABCLFAI87EBABCWFHBALCZFHLAECUFGEMBKKK+7DDWUE998jJJJJBCZ9rGV8kJJJJBDNAEtMBADCL6MBCEAI9rHOADCD4GDCEADCE0eHRADCDTHWCBHdINC+cUHDALHIARHQINAIiDBAVCXFZ+XJJJB8aAVYDXGKADADAK9IeHDAICLFHIAQCUFGQMBKAOADFGICkTHKCBHDCBAI9rHXARHIINDNDNALADFiDBGMAXZ+WJJJBjBBBzjBBB+/AMjBBBB9gemGM+LjBBB9P9dtMBAM+oHQXEKCJJJJ94HQKABADFAQCfffRgAKvbDBADCLFHDAICUFGIMBKABAWFHBALAWFHLAdCEFGdAE9HMBKKAVCZF8kJJJJBK/tKDcUI998jJJJJBC+QD9rGV8kJJJJBAVC+oEFCBC/kBZ+TJJJB8aCBHODNADtMBCBHOAItMBDNABAE9HMBAVCUADCDTGOADCffffI0eCBYD1+KJJBhJJJJBBGEbD+oEAVCEbD1DAEABAOZmJJJB8aKAVC+YEFCWFCBbDBAV9CB83I+YEAVC+YEFAEADAIAVC+oEFZ+NJJJBCUAICDTGRAICffffI0eGWCBYD1+KJJBhJJJJBBHOAVC+oEFAVYD1DGdCDTFAObDBAVAdCEFGQbD1DAOAVYD+YEGKARZmJJJBHXAVC+oEFAQCDTFADCI9uGMCBYD1+KJJBhJJJJBBGObDBAVAdCDFGRbD1DAOCBAMZ+TJJJBHpAVC+oEFARCDTFAWCBYD1+KJJBhJJJJBBGSbDBAVAdCIFGQbD1DAXHOASHRINARALiDBALAOYDBGWCWAWCW6eCDTFC/EBFiDBmuDBAOCLFHOARCLFHRAICUFGIMBKAVC+oEFAQCDTFCUAMCDTADCffff970eCBYD1+KJJBhJJJJBBGQbDBAVAdCLFbD1DDNADCI6MBAMCEAMCE0eHIAEHOAQHRINARASAOYDBCDTFiDBASAOCLFYDBCDTFiDBmASAOCWFYDBCDTFiDBmuDBAOCXFHOARCLFHRAICUFGIMBKKAVC/MBFHZAVYD+cEHhAVYD+gEHoAVHOCBHWCBHRCBHaCEHcINAOHxCIHqAEARCI2GlCDTFGOCWFYDBHkAOYDBHDABAaCX2FGICLFAOCLFYDBGdbDBAIADbDBAICWFAkbDBApARFCE86BBAZAkbDWAZAdbDLAZADbDBAQARCDTFCBbDBDNAWtMBCIHqAxHIINDNAIYDBGOADsMBAOAdsMBAOAksMBAZAqCDTFAObDBAqCEFHqKAICLFHIAWCUFGWMBKKAaCEFHaAXADCDTFGOAOYDBCUFbDBAXAdCDTFGOAOYDBCUFbDBAXAkCDTFGOAOYDBCUFbDBCBHWINAoAhAEAWAlFCDTFYDBCDTGIFYDBCDTFGkHOAKAIFGdYDBGDHIDNADtMBDNINAOYDBARsMEAOCLFHOAICUFGItMDXBKKAOADCDTAkFC98FYDBbDBAdAdYDBCUFbDBKAWCEFGWCI9HMBKDNDNDNAqtMBCUHRjBBBBHyCBHOINASAZAOCDTFYDBCDTGIFGWiDBH8aAWALCBAOCEFGdAOCS0eCDTFiDBALAXAIFYDBGOCWAOCW6eCDTFC/EBFiDBmGeuDBDNAKAIFYDBGWtMBAeA8a+THeAoAhAIFYDBCDTFHOAWCDTHIINAQAOYDBGWCDTFGDAeADiDBmG8auDBA8aAyAyA8a9dGDeHyAWARADeHRAOCLFHOAIC98FGIMBKKAdHOAdAq9HMBKARCU9HMEKAcAM9PMEINDNApAcFrBBMBAcHRXDKAMAcCEFGc9HMBXDKKAqCZAqCZ6eHWAZHOAxHZARCU9HMEKKAVYD1DHOKAOCDTAVC+oEFFC98FHRDNINAOtMEARYDBCBYD+E+KJJBh+BJJJBBARC98FHRAOCUFHOXBKKAVC+QDF8kJJJJBK/uLEVUCUAICDTGVAICffffI0eGOCBYD1+KJJBhJJJJBBHRALALYD9gGWCDTFARbDBALAWCEFbD9gABARbDBAOCBYD1+KJJBhJJJJBBHRALALYD9gGOCDTFARbDBALAOCEFbD9gABARbDLCUADCDTADCffffI0eCBYD1+KJJBhJJJJBBHRALALYD9gGOCDTFARbDBALAOCEFbD9gABARbDWABYDBCBAVZ+TJJJB8aADCI9uHWDNADtMBABYDBHOAEHLADHRINAOALYDBCDTFGVAVYDBCEFbDBALCLFHLARCUFGRMBKKDNAItMBABYDBHLABYDLHRCBHVAIHOINARAVbDBARCLFHRALYDBAVFHVALCLFHLAOCUFGOMBKKDNADCI6MBAWCEAWCE0eHdABYDLHRABYDWHVCBHLINAECWFYDBHOAECLFYDBHDARAEYDBCDTFGWAWYDBGWCEFbDBAVAWCDTFALbDBARADCDTFGDADYDBGDCEFbDBAVADCDTFALbDBARAOCDTFGOAOYDBGOCEFbDBAVAOCDTFALbDBAECXFHEAdALCEFGL9HMBKKDNAItMBABYDLHEABYDBHLINAEAEYDBALYDB9rbDBALCLFHLAECLFHEAICUFGIMBKKKqBABAEADAIC+01JJBZ+MJJJBKqBABAEADAIC+c+JJJBZ+MJJJBK9dEEUABCfEAICDTZ+TJJJBHLCBHIDNADtMBINDNALAEYDBCDTFGBYDBCU9HMBABAIbDBAICEFHIKAECLFHEADCUFGDMBKKAIK9TEIUCBCBYD+M+KJJBGEABCIFC98gFGBbD+M+KJJBDNDNABzBCZTGD9NMBCUHIABAD9rCffIFCZ4NBCUsMEKAEHIKAIK/lEEEUDNDNAEABvCIgtMBABHIXEKDNDNADCZ9PMBABHIXEKABHIINAIAEYDBbDBAICLFAECLFYDBbDBAICWFAECWFYDBbDBAICXFAECXFYDBbDBAICZFHIAECZFHEADC9wFGDCS0MBKKADCL6MBINAIAEYDBbDBAECLFHEAICLFHIADC98FGDCI0MBKKDNADtMBINAIAErBB86BBAICEFHIAECEFHEADCUFGDMBKKABK/AEEDUDNDNABCIgtMBABHIXEKAECfEgC+B+C+EW2HLDNDNADCZ9PMBABHIXEKABHIINAIALbDBAICXFALbDBAICWFALbDBAICLFALbDBAICZFHIADC9wFGDCS0MBKKADCL6MBINAIALbDBAICLFHIADC98FGDCI0MBKKDNADtMBINAIAE86BBAICEFHIADCUFGDMBKKABK9TEIUCBCBYD+M+KJJBGEABCIFC98gFGBbD+M+KJJBDNDNABzBCZTGD9NMBCUHIABAD9rCffIFCZ4NBCUsMEKAEHIKAIK9+EIUzBHEDNDNCBYD+M+KJJBGDAECZTGI9NMBCUHEADAI9rCffIFCZ4NBCUsMEKADHEKCBABAE9rCIFC98gCBYD+M+KJJBFGDbD+M+KJJBDNADzBCZTGE9NMBADAE9rCffIFCZ4NB8aKKXBABAEZ+YJJJBK+BEEIUDNAB+8GDCl4GICfEgGLCfEsMBDNALMBDNABjBBBB9cMBAECBbDBABSKABjBBJ9fnAEZ+XJJJBHBAEAEYDBCNFbDBABSKAEAICfEgC+CUFbDBADCfff+D94gCJJJ/4Iv++HBKABK+gEBDNDNAECJE9IMBABjBBBUnHBDNAECfE9PMBAEC+BUFHEXDKABjBBBUnHBAECPDAECPD6eC+C9+FHEXEKAEC+BU9KMBABjBBJXnHBDNAEC+b9+9NMBAEC/mBFHEXEKABjBBJXnHBAEC+299AEC+2990eC/MEFHEKABAEClTCJJJ/8IF++nKK+eDDBCJWK+EDB4+H9W9n94+p+Gw+J9o+YE9pBBBBBBEBBBDBBBEBBBDBBBBBBBDBBBBBBBEBBBBBBB+L29Hz/69+9Kz/n/76z/RG97z/Z/O9Xz8j/b85z/+/U9Yz/B/K9hz+2/z9dz9E+L9Mz59a8kz+R/t3z+a+Zyz79ohz/J4++8++y+d9v8+BBBB9S+49+z8r+Hbz9m9m/m8+l/Z/O8+/8+pg89Q/X+j878r+Hq8++m+b/E87BBBBBBJzBBJzBBJz+e/v/n8++y+dSz9I/h/68+XD/r8+/H0838+/w+nOzBBBB+wv9o8+UF888+9I/h/68+9C9g/l89/N/M9M89/d8kO8+BBBBF+8Tz9M836zs+2azl/Zpzz818ez9E+LXz/u98f8+819e/68+BC+EQKXEBBBDBBBAwBB";
      var wasmpack = new Uint8Array([32, 0, 65, 2, 1, 106, 34, 33, 3, 128, 11, 4, 13, 64, 6, 253, 10, 7, 15, 116, 127, 5, 8, 12, 40, 16, 19, 54, 20, 9, 27, 255, 113, 17, 42, 67, 24, 23, 146, 148, 18, 14, 22, 45, 70, 69, 56, 114, 101, 21, 25, 63, 75, 136, 108, 28, 118, 29, 73, 115]);
      if (typeof WebAssembly !== "object") {
        return {
          supported: false
        };
      }
      var instance;
      var promise = WebAssembly.instantiate(unpack(wasm), {}).then(function(result) {
        instance = result.instance;
        instance.exports.__wasm_call_ctors();
        instance.exports.meshopt_encodeVertexVersion(0);
        instance.exports.meshopt_encodeIndexVersion(1);
      });
      function unpack(data) {
        var result = new Uint8Array(data.length);
        for (var i = 0; i < data.length; ++i) {
          var ch = data.charCodeAt(i);
          result[i] = ch > 96 ? ch - 71 : ch > 64 ? ch - 65 : ch > 47 ? ch + 4 : ch > 46 ? 63 : 62;
        }
        var write = 0;
        for (var i = 0; i < data.length; ++i) {
          result[write++] = result[i] < 60 ? wasmpack[result[i]] : (result[i] - 60) * 64 + result[++i];
        }
        return result.buffer.slice(0, write);
      }
      function assert(cond) {
        if (!cond) {
          throw new Error("Assertion failed");
        }
      }
      function bytes(view) {
        return new Uint8Array(view.buffer, view.byteOffset, view.byteLength);
      }
      function reorder(indices2, vertices, optf) {
        var sbrk = instance.exports.sbrk;
        var ip = sbrk(indices2.length * 4);
        var rp = sbrk(vertices * 4);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        var indices8 = bytes(indices2);
        heap.set(indices8, ip);
        if (optf) {
          optf(ip, ip, indices2.length, vertices);
        }
        var unique = instance.exports.meshopt_optimizeVertexFetchRemap(rp, ip, indices2.length, vertices);
        heap = new Uint8Array(instance.exports.memory.buffer);
        var remap = new Uint32Array(vertices);
        new Uint8Array(remap.buffer).set(heap.subarray(rp, rp + vertices * 4));
        indices8.set(heap.subarray(ip, ip + indices2.length * 4));
        sbrk(ip - sbrk(0));
        for (var i = 0; i < indices2.length; ++i)
          indices2[i] = remap[indices2[i]];
        return [remap, unique];
      }
      function encode(fun, bound, source, count, size) {
        var sbrk = instance.exports.sbrk;
        var tp = sbrk(bound);
        var sp = sbrk(count * size);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        heap.set(bytes(source), sp);
        var res = fun(tp, bound, sp, count, size);
        var target = new Uint8Array(res);
        target.set(heap.subarray(tp, tp + res));
        sbrk(tp - sbrk(0));
        return target;
      }
      function maxindex(source) {
        var result = 0;
        for (var i = 0; i < source.length; ++i) {
          var index = source[i];
          result = result < index ? index : result;
        }
        return result;
      }
      function index32(source, size) {
        assert(size == 2 || size == 4);
        if (size == 4) {
          return new Uint32Array(source.buffer, source.byteOffset, source.byteLength / 4);
        } else {
          var view = new Uint16Array(source.buffer, source.byteOffset, source.byteLength / 2);
          return new Uint32Array(view);
        }
      }
      function filter(fun, source, count, stride, bits, insize) {
        var sbrk = instance.exports.sbrk;
        var tp = sbrk(count * stride);
        var sp = sbrk(count * insize);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        heap.set(bytes(source), sp);
        fun(tp, count, stride, bits, sp);
        var target = new Uint8Array(count * stride);
        target.set(heap.subarray(tp, tp + count * stride));
        sbrk(tp - sbrk(0));
        return target;
      }
      return {
        ready: promise,
        supported: true,
        reorderMesh: function(indices2, triangles, optsize) {
          var optf = triangles ? optsize ? instance.exports.meshopt_optimizeVertexCacheStrip : instance.exports.meshopt_optimizeVertexCache : void 0;
          return reorder(indices2, maxindex(indices2) + 1, optf);
        },
        encodeVertexBuffer: function(source, count, size) {
          assert(size > 0 && size <= 256);
          assert(size % 4 == 0);
          var bound = instance.exports.meshopt_encodeVertexBufferBound(count, size);
          return encode(instance.exports.meshopt_encodeVertexBuffer, bound, source, count, size);
        },
        encodeIndexBuffer: function(source, count, size) {
          assert(size == 2 || size == 4);
          assert(count % 3 == 0);
          var indices2 = index32(source, size);
          var bound = instance.exports.meshopt_encodeIndexBufferBound(count, maxindex(indices2) + 1);
          return encode(instance.exports.meshopt_encodeIndexBuffer, bound, indices2, count, 4);
        },
        encodeIndexSequence: function(source, count, size) {
          assert(size == 2 || size == 4);
          var indices2 = index32(source, size);
          var bound = instance.exports.meshopt_encodeIndexSequenceBound(count, maxindex(indices2) + 1);
          return encode(instance.exports.meshopt_encodeIndexSequence, bound, indices2, count, 4);
        },
        encodeGltfBuffer: function(source, count, size, mode2) {
          var table2 = {
            ATTRIBUTES: this.encodeVertexBuffer,
            TRIANGLES: this.encodeIndexBuffer,
            INDICES: this.encodeIndexSequence
          };
          assert(table2[mode2]);
          return table2[mode2](source, count, size);
        },
        encodeFilterOct: function(source, count, stride, bits) {
          assert(stride == 4 || stride == 8);
          assert(bits >= 1 && bits <= 16);
          return filter(instance.exports.meshopt_encodeFilterOct, source, count, stride, bits, 16);
        },
        encodeFilterQuat: function(source, count, stride, bits) {
          assert(stride == 8);
          assert(bits >= 4 && bits <= 16);
          return filter(instance.exports.meshopt_encodeFilterQuat, source, count, stride, bits, 16);
        },
        encodeFilterExp: function(source, count, stride, bits) {
          assert(stride > 0 && stride % 4 == 0);
          assert(bits >= 1 && bits <= 24);
          return filter(instance.exports.meshopt_encodeFilterExp, source, count, stride, bits, stride);
        }
      };
    }();
    if (typeof exports2 === "object" && typeof module2 === "object")
      module2.exports = MeshoptEncoder;
    else if (typeof define === "function" && define["amd"])
      define([], function() {
        return MeshoptEncoder;
      });
    else if (typeof exports2 === "object")
      exports2["MeshoptEncoder"] = MeshoptEncoder;
    else
      (typeof self !== "undefined" ? self : exports2).MeshoptEncoder = MeshoptEncoder;
  }
});

// node_modules/meshoptimizer/meshopt_decoder.js
var require_meshopt_decoder = __commonJS({
  "node_modules/meshoptimizer/meshopt_decoder.js"(exports2, module2) {
    var MeshoptDecoder2 = function() {
      "use strict";
      var wasm_base = "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";
      var wasm_simd = "B9h79tEBBBEkL9gBB9gVUUUUUEU9gIUUUB9gEUEUIKQBBEBEEDDDILVE9wEEEVIEBEOWEUEC+Q/aEKR/LEdO9tw9t9vv95DBh9f9f939h79t9f9j9h229f9jT9vv7BB8a9tw79o9v9wT9f9kw9j9v9kw9WwvTw949C919m9mwvBDy9tw79o9v9wT9f9kw9j9v9kw69u9kw949C919m9mwvBLe9tw79o9v9wT9f9kw9j9v9kw69u9kw949Twg91w9u9jwBVl9tw79o9v9wT9f9kw9j9v9kws9p2Twv9P9jTBOk9tw79o9v9wT9f9kw9j9v9kws9p2Twv9R919hTBRl9tw79o9v9wT9f9kw9j9v9kws9p2Twvt949wBWL79iv9rBdQ/T9TQLBZIK9+EVU8jJJJJBCZ9rHBCBHEINCBHDCBHIINABCWFADFAICJUAEAD4CEgGLe86BBAIALFHIADCEFGDCW9HMBKAEC+Q+YJJBFAI86BBAECITC+Q1JJBFAB8pIW83IBAECEFGECJD9HMBKK/H8jLhUD97EUO978jJJJJBCJ/KB9rGV8kJJJJBC9+HODNADCEFAL0MBCUHOAIrBBC+gE9HMBAVAIALFGRAD9rAD/8QBBCJ/ABAD9uHOAICEFHLDNADtMBAOC/wfBgGOCJDAOCJD6eHWCBHdINAdAE9PMEAWAEAd9rAdAWFAE6eGQCSFGOC9wgGKCI2HXAKCETHMAOCL4CIFCD4HpABAdAD2FHSCBHZDNINCEHhALHoCBHaDNINARAo9rAp6MIAVCJ/CBFAaAK2FHcAoApFHLCBHIDNAKC/AB6MBARAL9rC/gB6MBCBHOINAcAOFHIDNDNDNDNDNAoAOCO4FrBBGxCIgpLBEDIBKAIPXBBBBBBBBBBBBBBBBPKLBXIKAIALPBBLALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlGqCDP+MEAqPMBZEhDoIaLcVxOqRlPXIIIIIIIIIIIIIIIIP9OGlPXIIIIIIIIIIIIIIIIP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBAkC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKLBALCLFAyPqBFAkC+Q+YJJBFrBBFHLXDKAIALPBBWALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlPXSSSSSSSSSSSSSSSSP9OGlPXSSSSSSSSSSSSSSSSP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBAkC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKLBALCWFAyPqBFAkC+Q+YJJBFrBBFHLXEKAIALPBBBPKLBALCZFHLKDNDNDNDNDNAxCD4CIgpLBEDIBKAIPXBBBBBBBBBBBBBBBBPKLZXIKAIALPBBLALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlGqCDP+MEAqPMBZEhDoIaLcVxOqRlPXIIIIIIIIIIIIIIIIP9OGlPXIIIIIIIIIIIIIIIIP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBAkC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKLZALCLFAyPqBFAkC+Q+YJJBFrBBFHLXDKAIALPBBWALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlPXSSSSSSSSSSSSSSSSP9OGlPXSSSSSSSSSSSSSSSSP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBAkC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKLZALCWFAyPqBFAkC+Q+YJJBFrBBFHLXEKAIALPBBBPKLZALCZFHLKDNDNDNDNDNAxCL4CIgpLBEDIBKAIPXBBBBBBBBBBBBBBBBPKLAXIKAIALPBBLALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlGqCDP+MEAqPMBZEhDoIaLcVxOqRlPXIIIIIIIIIIIIIIIIP9OGlPXIIIIIIIIIIIIIIIIP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBAkC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKLAALCLFAyPqBFAkC+Q+YJJBFrBBFHLXDKAIALPBBWALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlPXSSSSSSSSSSSSSSSSP9OGlPXSSSSSSSSSSSSSSSSP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBAkC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKLAALCWFAyPqBFAkC+Q+YJJBFrBBFHLXEKAIALPBBBPKLAALCZFHLKDNDNDNDNDNAxCO4pLBEDIBKAIPXBBBBBBBBBBBBBBBBPKL8wXIKAIALPBBLALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlGqCDP+MEAqPMBZEhDoIaLcVxOqRlPXIIIIIIIIIIIIIIIIP9OGlPXIIIIIIIIIIIIIIIIP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGxCITC+Q1JJBFPBIBAxC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGxCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKL8wALCLFAyPqBFAxC+Q+YJJBFrBBFHLXDKAIALPBBWALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlPXSSSSSSSSSSSSSSSSP9OGlPXSSSSSSSSSSSSSSSSP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGxCITC+Q1JJBFPBIBAxC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGxCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKL8wALCWFAyPqBFAxC+Q+YJJBFrBBFHLXEKAIALPBBBPKL8wALCZFHLKAOC/ABFHIAOCJEFAK0MEAIHOARAL9rC/fB0MBKKDNDNAIAK9PMBAICI4HOINARAL9rCk6MDAcAIFHxDNDNDNDNDNAoAICO4FrBBAOCOg4CIgpLBEDIBKAxPXBBBBBBBBBBBBBBBBPKLBXIKAxALPBBLALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlGqCDP+MEAqPMBZEhDoIaLcVxOqRlPXIIIIIIIIIIIIIIIIP9OGlPXIIIIIIIIIIIIIIIIP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBAkC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKLBALCLFAyPqBFAkC+Q+YJJBFrBBFHLXDKAxALPBBWALPBBBGqCLP+MEAqPMBZEhDoIaLcVxOqRlPXSSSSSSSSSSSSSSSSP9OGlPXSSSSSSSSSSSSSSSSP8jGqP5B9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBAkC+Q+YJJBFPBBBGyAyPMBBBBBBBBBBBBBBBBAqP5E9CJf/8/4/w/g/AB9+9Cu1+nGkCITC+Q1JJBFPBIBP9uPMBEDILVORZhoacxqlPpAlAqP9SPKLBALCWFAyPqBFAkC+Q+YJJBFrBBFHLXEKAxALPBBBPKLBALCZFHLKAOCDFHOAICZFGIAK6MBKKALtMBAaCI6HhALHoAaCEFGOHaAOCLsMDXEKKCBHLAhCEgMDKDNAKtMBAVCJDFAZFHIAVAZFPBDBHyCBHxINAIAVCJ/CBFAxFGOPBLBGlCEP9tAlPXEEEEEEEEEEEEEEEEGqP9OP9hP9RGlAOAKFPBLBG8aCEP9tA8aAqP9OP9hP9RG8aPMBZEhDoIaLcVxOqRlGeAOAMFPBLBG3CEP9tA3AqP9OP9hP9RG3AOAXFPBLBG5CEP9tA5AqP9OP9hP9RG5PMBZEhDoIaLcVxOqRlG8ePMBEZhDIoaLVcxORqlGqAqPMBEDIBEDIBEDIBEDIAyP9uGyP9aDBBAIADFGOAyAqAqPMLVORLVORLVORLVORP9uGyP9aDBBAOADFGOAyAqAqPMWdQKWdQKWdQKWdQKP9uGyP9aDBBAOADFGOAyAqAqPMXMpSXMpSXMpSXMpSP9uGyP9aDBBAOADFGOAyAeA8ePMWdkyQK8aeXM35pS8e8fGqAqPMBEDIBEDIBEDIBEDIP9uGyP9aDBBAOADFGOAyAqAqPMLVORLVORLVORLVORP9uGyP9aDBBAOADFGOAyAqAqPMWdQKWdQKWdQKWdQKP9uGyP9aDBBAOADFGOAyAqAqPMXMpSXMpSXMpSXMpSP9uGyP9aDBBAOADFGOAyAlA8aPMWkdyQ8aKeX3M5p8eS8fGlA3A5PMWkdyQ8aKeX3M5p8eS8fG8aPMBEZhDIoaLVcxORqlGqAqPMBEDIBEDIBEDIBEDIP9uGyP9aDBBAOADFGOAyAqAqPMLVORLVORLVORLVORP9uGyP9aDBBAOADFGOAyAqAqPMWdQKWdQKWdQKWdQKP9uGyP9aDBBAOADFGOAyAqAqPMXMpSXMpSXMpSXMpSP9uGyP9aDBBAOADFGOAyAlA8aPMWdkyQK8aeXM35pS8e8fGqAqPMBEDIBEDIBEDIBEDIP9uGyP9aDBBAOADFGOAyAqAqPMLVORLVORLVORLVORP9uGyP9aDBBAOADFGOAyAqAqPMWdQKWdQKWdQKWdQKP9uGyP9aDBBAOADFGOAyAqAqPMXMpSXMpSXMpSXMpSP9uGyP9aDBBAOADFHIAxCZFGxAK6MBKKAZCLFGZAD6MBKASAVCJDFAQAD2/8QBBAVAVCJDFAQCUFAD2FAD/8QBBAQAdFHdC9+HOALMEXIKKC9+HOXEKCBC99ARAL9rADCAADCA0eseHOKAVCJ/KBF8kJJJJBAOKWBZ+BJJJBK/UZEhU8jJJJJBC/AE9rGV8kJJJJBC9+HODNAECI9uGRChFAL0MBCUHOAIrBBGWC/wEgC/gE9HMBAWCSgGdCE0MBAVC/ABFCfECJE/8KBAVCuF9CU83IBAVC8wF9CU83IBAVCYF9CU83IBAVCAF9CU83IBAVCkF9CU83IBAVCZF9CU83IBAV9CU83IWAV9CU83IBAIALFC9wFHQAICEFGWARFHODNAEtMBCMCSAdCEseHKCBHXCBHMCBHdCBHICBHLINDNAOAQ9NMBC9+HOXIKDNDNAWrBBGRC/vE0MBAVC/ABFALARCL4CU7FCSgCITFGpYDLHSApYDBHZDNARCSgGpAK9PMBAVAIARCU7FCSgCDTFYDBAXApeHRAptHpDNDNADCD9HMBABAdCETFGhAZ87EBAhCDFAS87EBAhCLFAR87EBXEKABAdCDTFGhAZbDBAhCLFASbDBAhCWFARbDBKAXApFHXAVC/ABFALCITFGhARbDBAhASbDLAVAICDTFARbDBAVC/ABFALCEFCSgGLCITFGhAZbDBAhARbDLAIApFHIALCEFHLXDKDNDNApCSsMBAMApFApC987FCEFHMXEKAOCEFHRAO8sBBGpCfEgHhDNDNApCU9MMBARHOXEKAOCVFHOAhCfBgHhCRHpDNINAR8sBBGoCfBgApTAhvHhAoCU9KMEARCEFHRApCRFGpC8j9HMBXDKKARCEFHOKAhCE4CBAhCEg9r7AMFHMKDNDNADCD9HMBABAdCETFGRAZ87EBARCDFAS87EBARCLFAM87EBXEKABAdCDTFGRAZbDBARCLFASbDBARCWFAMbDBKAVC/ABFALCITFGRAMbDBARASbDLAVAICDTFAMbDBAVC/ABFALCEFCSgGLCITFGRAZbDBARAMbDLAICEFHIALCEFHLXEKDNARCPE0MBAXCEFGoAVAIAQARCSgFrBBGpCL49rCSgCDTFYDBApCZ6GheHRAVAIAp9rCSgCDTFYDBAoAhFGSApCSgGoeHpAotHoDNDNADCD9HMBABAdCETFGZAX87EBAZCDFAR87EBAZCLFAp87EBXEKABAdCDTFGZAXbDBAZCLFARbDBAZCWFApbDBKAVAICDTFAXbDBAVC/ABFALCITFGZARbDBAZAXbDLAVAICEFGICSgCDTFARbDBAVC/ABFALCEFCSgCITFGZApbDBAZARbDLAVAIAhFCSgGICDTFApbDBAVC/ABFALCDFCSgGLCITFGRAXbDBARApbDLALCEFHLAIAoFHIASAoFHXXEKAXCBAOrBBGZeGaARC/+EsGRFHSAZCSgHcAZCL4HxDNDNAZCS0MBASCEFHoXEKASHoAVAIAx9rCSgCDTFYDBHSKDNDNAcMBAoCEFHXXEKAoHXAVAIAZ9rCSgCDTFYDBHoKDNDNARtMBAOCEFHRXEKAOCDFHRAO8sBEGhCfEgHpDNAhCU9KMBAOCOFHaApCfBgHpCRHODNINAR8sBBGhCfBgAOTApvHpAhCU9KMEARCEFHRAOCRFGOC8j9HMBKAaHRXEKARCEFHRKApCE4CBApCEg9r7AMFGMHaKDNDNAxCSsMBARHpXEKARCEFHpAR8sBBGOCfEgHhDNAOCU9KMBARCVFHSAhCfBgHhCRHODNINAp8sBBGRCfBgAOTAhvHhARCU9KMEApCEFHpAOCRFGOC8j9HMBKASHpXEKApCEFHpKAhCE4CBAhCEg9r7AMFGMHSKDNDNAcCSsMBApHOXEKApCEFHOAp8sBBGRCfEgHhDNARCU9KMBApCVFHoAhCfBgHhCRHRDNINAO8sBBGpCfBgARTAhvHhApCU9KMEAOCEFHOARCRFGRC8j9HMBKAoHOXEKAOCEFHOKAhCE4CBAhCEg9r7AMFGMHoKDNDNADCD9HMBABAdCETFGRAa87EBARCDFAS87EBARCLFAo87EBXEKABAdCDTFGRAabDBARCLFASbDBARCWFAobDBKAVC/ABFALCITFGRASbDBARAabDLAVAICDTFAabDBAVC/ABFALCEFCSgCITFGRAobDBARASbDLAVAICEFGICSgCDTFASbDBAVC/ABFALCDFCSgCITFGRAabDBARAobDLAVAIAZCZ6AxCSsvFGICSgCDTFAobDBAIActAcCSsvFHIALCIFHLKAWCEFHWALCSgHLAICSgHIAdCIFGdAE6MBKKCBC99AOAQseHOKAVC/AEF8kJJJJBAOK+LLEVU8jJJJJBCZ9rHVC9+HODNAECVFAL0MBCUHOAIrBBC/+EgC/QE9HMBAV9CB83IWAICEFHRAIALFC98FHWDNAEtMBDNADCDsMBCBHdINDNARAW6MBC9+SKARCEFHOAR8sBBGLCfEgHIDNDNALCU9MMBAOHRXEKARCVFHRAICfBgHICRHLDNINAO8sBBGDCfBgALTAIvHIADCU9KMEAOCEFHOALCRFGLC8j9HMBXDKKAOCEFHRKABAdCDTFAICD4CBAICE4CEg9r7AVCWFAICEgCDTvGOYDBFGLbDBAOALbDBAdCEFGdAE9HMBXDKKCBHdINDNARAW6MBC9+SKARCEFHOAR8sBBGLCfEgHIDNDNALCU9MMBAOHRXEKARCVFHRAICfBgHICRHLDNINAO8sBBGDCfBgALTAIvHIADCU9KMEAOCEFHOALCRFGLC8j9HMBXDKKAOCEFHRKABAdCETFAICD4CBAICE4CEg9r7AVCWFAICEgCDTvGOYDBFGL87EBAOALbDBAdCEFGdAE9HMBKKCBC99ARAWseHOKAOK+epLIUO97EUE978jJJJJBCA9rHIDNDNADCL9HMBDNAEC98gGLtMBCBHVABHDINADADPBBBGOCkP+rECkP+sEP/6EGRAOCWP+rECkP+sEP/6EARP/gEAOCZP+rECkP+sEP/6EGWP/gEP/kEP/lEGdPXBBBBBBBBBBBBBBBBP+2EGQARPXBBBJBBBJBBBJBBBJGKP9OP9RP/kEGRPXBB/+9CBB/+9CBB/+9CBB/+9CARARP/mEAdAdP/mEAWAQAWAKP9OP9RP/kEGRARP/mEP/kEP/kEP/jEP/nEGWP/mEPXBBN0BBN0BBN0BBN0GQP/kEPXfBBBfBBBfBBBfBBBP9OAOPXBBBfBBBfBBBfBBBfP9OP9QARAWP/mEAQP/kECWP+rEPXBfBBBfBBBfBBBfBBP9OP9QAdAWP/mEAQP/kECZP+rEPXBBfBBBfBBBfBBBfBP9OP9QPKBBADCZFHDAVCLFGVAL6MBKKALAE9PMEAIAECIgGVCDTGDvCBCZAD9r/8KBAIABALCDTFGLAD/8QBBDNAVtMBAIAIPBLBGOCkP+rECkP+sEP/6EGRAOCWP+rECkP+sEP/6EARP/gEAOCZP+rECkP+sEP/6EGWP/gEP/kEP/lEGdPXBBBBBBBBBBBBBBBBP+2EGQARPXBBBJBBBJBBBJBBBJGKP9OP9RP/kEGRPXBB/+9CBB/+9CBB/+9CBB/+9CARARP/mEAdAdP/mEAWAQAWAKP9OP9RP/kEGRARP/mEP/kEP/kEP/jEP/nEGWP/mEPXBBN0BBN0BBN0BBN0GQP/kEPXfBBBfBBBfBBBfBBBP9OAOPXBBBfBBBfBBBfBBBfP9OP9QARAWP/mEAQP/kECWP+rEPXBfBBBfBBBfBBBfBBP9OP9QAdAWP/mEAQP/kECZP+rEPXBBfBBBfBBBfBBBfBP9OP9QPKLBKALAIAD/8QBBSKDNAEC98gGXtMBCBHVABHDINADCZFGLALPBBBGOPXBBBBBBffBBBBBBffGKP9OADPBBBGdAOPMLVORXMpScxql358e8fPXfUBBfUBBfUBBfUBBP9OP/6EAdAOPMBEDIWdQKZhoaky8aeGOCZP+sEP/6EGRP/gEAOCZP+rECZP+sEP/6EGWP/gEP/kEP/lEGOPXB/+fsB/+fsB/+fsB/+fsAWAOPXBBBBBBBBBBBBBBBBP+2EGQAWPXBBBJBBBJBBBJBBBJGMP9OP9RP/kEGWAWP/mEAOAOP/mEARAQARAMP9OP9RP/kEGOAOP/mEP/kEP/kEP/jEP/nEGRP/mEPXBBN0BBN0BBN0BBN0GQP/kECZP+rEAWARP/mEAQP/kEPXffBBffBBffBBffBBP9OP9QGWAOARP/mEAQP/kEPXffBBffBBffBBffBBP9OGOPMWdkyQK8aeXM35pS8e8fP9QPKBBADAdAKP9OAWAOPMBEZhDIoaLVcxORqlP9QPKBBADCAFHDAVCLFGVAX6MBKKAXAE9PMBAIAECIgGVCITGDFCBCAAD9r/8KBAIABAXCITFGLAD/8QBBDNAVtMBAIAIPBLZGOPXBBBBBBffBBBBBBffGKP9OAIPBLBGdAOPMLVORXMpScxql358e8fPXfUBBfUBBfUBBfUBBP9OP/6EAdAOPMBEDIWdQKZhoaky8aeGOCZP+sEP/6EGRP/gEAOCZP+rECZP+sEP/6EGWP/gEP/kEP/lEGOPXB/+fsB/+fsB/+fsB/+fsAWAOPXBBBBBBBBBBBBBBBBP+2EGQAWPXBBBJBBBJBBBJBBBJGMP9OP9RP/kEGWAWP/mEAOAOP/mEARAQARAMP9OP9RP/kEGOAOP/mEP/kEP/kEP/jEP/nEGRP/mEPXBBN0BBN0BBN0BBN0GQP/kECZP+rEAWARP/mEAQP/kEPXffBBffBBffBBffBBP9OP9QGWAOARP/mEAQP/kEPXffBBffBBffBBffBBP9OGOPMWdkyQK8aeXM35pS8e8fP9QPKLZAIAdAKP9OAWAOPMBEZhDIoaLVcxORqlP9QPKLBKALAIAD/8QBBKK/4WLLUE97EUV978jJJJJBC8w9rHIDNAEC98gGLtMBCBHVABHOINAIAOPBBBGRAOCZFGWPBBBGdPMLVORXMpScxql358e8fGQCZP+sEGKCLP+rEPKLBAOPXBBJzBBJzBBJzBBJzPX/zL81z/zL81z/zL81z/zL81zAKPXIBBBIBBBIBBBIBBBP9QP/6EP/nEGKARAdPMBEDIWdQKZhoaky8aeGRCZP+rECZP+sEP/6EP/mEGdAdP/mEAKARCZP+sEP/6EP/mEGXAXP/mEAKAQCZP+rECZP+sEP/6EP/mEGQAQP/mEP/kEP/kEP/lEPXBBBBBBBBBBBBBBBBP+4EP/jEPXB/+fsB/+fsB/+fsB/+fsGKP/mEPXBBN0BBN0BBN0BBN0GRP/kEPXffBBffBBffBBffBBGMP9OAXAKP/mEARP/kECZP+rEP9QGXAQAKP/mEARP/kECZP+rEAdAKP/mEARP/kEAMP9OP9QGKPMBEZhDIoaLVcxORqlGRP5BAIPBLBPeB+t+J83IBAOCWFARP5EAIPBLBPeE+t+J83IBAWAXAKPMWdkyQK8aeXM35pS8e8fGKP5BAIPBLBPeD+t+J83IBAOCkFAKP5EAIPBLBPeI+t+J83IBAOCAFHOAVCLFGVAL6MBKKDNALAE9PMBAIAECIgGVCITGOFCBCAAO9r/8KBAIABALCITFGWAO/8QBBDNAVtMBAIAIPBLBGRAIPBLZGdPMLVORXMpScxql358e8fGQCZP+sEGKCLP+rEPKLAAIPXBBJzBBJzBBJzBBJzPX/zL81z/zL81z/zL81z/zL81zAKPXIBBBIBBBIBBBIBBBP9QP/6EP/nEGKARAdPMBEDIWdQKZhoaky8aeGRCZP+rECZP+sEP/6EP/mEGdAdP/mEAKARCZP+sEP/6EP/mEGXAXP/mEAKAQCZP+rECZP+sEP/6EP/mEGQAQP/mEP/kEP/kEP/lEPXBBBBBBBBBBBBBBBBP+4EP/jEPXB/+fsB/+fsB/+fsB/+fsGKP/mEPXBBN0BBN0BBN0BBN0GRP/kEPXffBBffBBffBBffBBGMP9OAXAKP/mEARP/kECZP+rEP9QGXAQAKP/mEARP/kECZP+rEAdAKP/mEARP/kEAMP9OP9QGKPMBEZhDIoaLVcxORqlGRP5BAIPBLAPeB+t+J83IBAIARP5EAIPBLAPeE+t+J83IWAIAXAKPMWdkyQK8aeXM35pS8e8fGKP5BAIPBLAPeD+t+J83IZAIAKP5EAIPBLAPeI+t+J83IkKAWAIAO/8QBBKK+pDDIUE978jJJJJBC/AB9rHIDNADCD4AE2GLC98gGVtMBCBHDABHEINAEAEPBBBGOCWP+rECWP+sEP/6EAOCEP+sEPXBBJzBBJzBBJzBBJzP+uEPXBBJfBBJfBBJfBBJfP9OP/mEPKBBAECZFHEADCLFGDAV6MBKKDNAVAL9PMBAIALCIgGDCDTGEvCBC/ABAE9r/8KBAIABAVCDTFGVAE/8QBBDNADtMBAIAIPBLBGOCWP+rECWP+sEP/6EAOCEP+sEPXBBJzBBJzBBJzBBJzP+uEPXBBJfBBJfBBJfBBJfP9OP/mEPKLBKAVAIAE/8QBBKK9TEIUCBCBYDJ1JJBGEABCIFC98gFGBbDJ1JJBDNDNABzBCZTGD9NMBCUHIABAD9rCffIFCZ4NBCUsMEKAEHIKAIKKKEBCJWKLZ9tBB";
      var detector = new Uint8Array([0, 97, 115, 109, 1, 0, 0, 0, 1, 4, 1, 96, 0, 0, 3, 3, 2, 0, 0, 5, 3, 1, 0, 1, 12, 1, 0, 10, 22, 2, 12, 0, 65, 0, 65, 0, 65, 0, 252, 10, 0, 0, 11, 7, 0, 65, 0, 253, 15, 26, 11]);
      var wasmpack = new Uint8Array([32, 0, 65, 2, 1, 106, 34, 33, 3, 128, 11, 4, 13, 64, 6, 253, 10, 7, 15, 116, 127, 5, 8, 12, 40, 16, 19, 54, 20, 9, 27, 255, 113, 17, 42, 67, 24, 23, 146, 148, 18, 14, 22, 45, 70, 69, 56, 114, 101, 21, 25, 63, 75, 136, 108, 28, 118, 29, 73, 115]);
      if (typeof WebAssembly !== "object") {
        return {
          supported: false
        };
      }
      var wasm = wasm_base;
      if (WebAssembly.validate(detector)) {
        wasm = wasm_simd;
      }
      var instance;
      var promise = WebAssembly.instantiate(unpack(wasm), {}).then(function(result) {
        instance = result.instance;
        instance.exports.__wasm_call_ctors();
      });
      function unpack(data) {
        var result = new Uint8Array(data.length);
        for (var i = 0; i < data.length; ++i) {
          var ch = data.charCodeAt(i);
          result[i] = ch > 96 ? ch - 71 : ch > 64 ? ch - 65 : ch > 47 ? ch + 4 : ch > 46 ? 63 : 62;
        }
        var write = 0;
        for (var i = 0; i < data.length; ++i) {
          result[write++] = result[i] < 60 ? wasmpack[result[i]] : (result[i] - 60) * 64 + result[++i];
        }
        return result.buffer.slice(0, write);
      }
      function decode(fun, target, count, size, source, filter) {
        var sbrk = instance.exports.sbrk;
        var count4 = count + 3 & ~3;
        var tp = sbrk(count4 * size);
        var sp = sbrk(source.length);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        heap.set(source, sp);
        var res = fun(tp, count, size, sp, source.length);
        if (res == 0 && filter) {
          filter(tp, count4, size);
        }
        target.set(heap.subarray(tp, tp + count * size));
        sbrk(tp - sbrk(0));
        if (res != 0) {
          throw new Error("Malformed buffer data: " + res);
        }
      }
      ;
      var filters = {
        0: "",
        1: "meshopt_decodeFilterOct",
        2: "meshopt_decodeFilterQuat",
        3: "meshopt_decodeFilterExp",
        NONE: "",
        OCTAHEDRAL: "meshopt_decodeFilterOct",
        QUATERNION: "meshopt_decodeFilterQuat",
        EXPONENTIAL: "meshopt_decodeFilterExp"
      };
      var decoders = {
        0: "meshopt_decodeVertexBuffer",
        1: "meshopt_decodeIndexBuffer",
        2: "meshopt_decodeIndexSequence",
        ATTRIBUTES: "meshopt_decodeVertexBuffer",
        TRIANGLES: "meshopt_decodeIndexBuffer",
        INDICES: "meshopt_decodeIndexSequence"
      };
      return {
        ready: promise,
        supported: true,
        decodeVertexBuffer: function(target, count, size, source, filter) {
          decode(instance.exports.meshopt_decodeVertexBuffer, target, count, size, source, instance.exports[filters[filter]]);
        },
        decodeIndexBuffer: function(target, count, size, source) {
          decode(instance.exports.meshopt_decodeIndexBuffer, target, count, size, source);
        },
        decodeIndexSequence: function(target, count, size, source) {
          decode(instance.exports.meshopt_decodeIndexSequence, target, count, size, source);
        },
        decodeGltfBuffer: function(target, count, size, source, mode2, filter) {
          decode(instance.exports[decoders[mode2]], target, count, size, source, instance.exports[filters[filter]]);
        }
      };
    }();
    if (typeof exports2 === "object" && typeof module2 === "object")
      module2.exports = MeshoptDecoder2;
    else if (typeof define === "function" && define["amd"])
      define([], function() {
        return MeshoptDecoder2;
      });
    else if (typeof exports2 === "object")
      exports2["MeshoptDecoder"] = MeshoptDecoder2;
    else
      (typeof self !== "undefined" ? self : exports2).MeshoptDecoder = MeshoptDecoder2;
  }
});

// node_modules/meshoptimizer/meshopt_simplifier.js
var require_meshopt_simplifier = __commonJS({
  "node_modules/meshoptimizer/meshopt_simplifier.js"(exports2, module2) {
    var MeshoptSimplifier = function() {
      "use strict";
      var wasm = "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";
      var wasmpack = new Uint8Array([32, 0, 65, 2, 1, 106, 34, 33, 3, 128, 11, 4, 13, 64, 6, 253, 10, 7, 15, 116, 127, 5, 8, 12, 40, 16, 19, 54, 20, 9, 27, 255, 113, 17, 42, 67, 24, 23, 146, 148, 18, 14, 22, 45, 70, 69, 56, 114, 101, 21, 25, 63, 75, 136, 108, 28, 118, 29, 73, 115]);
      if (typeof WebAssembly !== "object") {
        return {
          supported: false
        };
      }
      var instance;
      var promise = WebAssembly.instantiate(unpack(wasm), {}).then(function(result) {
        instance = result.instance;
        instance.exports.__wasm_call_ctors();
      });
      function unpack(data) {
        var result = new Uint8Array(data.length);
        for (var i = 0; i < data.length; ++i) {
          var ch = data.charCodeAt(i);
          result[i] = ch > 96 ? ch - 71 : ch > 64 ? ch - 65 : ch > 47 ? ch + 4 : ch > 46 ? 63 : 62;
        }
        var write = 0;
        for (var i = 0; i < data.length; ++i) {
          result[write++] = result[i] < 60 ? wasmpack[result[i]] : (result[i] - 60) * 64 + result[++i];
        }
        return result.buffer.slice(0, write);
      }
      function assert(cond) {
        if (!cond) {
          throw new Error("Assertion failed");
        }
      }
      function bytes(view) {
        return new Uint8Array(view.buffer, view.byteOffset, view.byteLength);
      }
      function reorder(indices2, vertices) {
        var sbrk = instance.exports.sbrk;
        var ip = sbrk(indices2.length * 4);
        var rp = sbrk(vertices * 4);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        var indices8 = bytes(indices2);
        heap.set(indices8, ip);
        var unique = instance.exports.meshopt_optimizeVertexFetchRemap(rp, ip, indices2.length, vertices);
        heap = new Uint8Array(instance.exports.memory.buffer);
        var remap = new Uint32Array(vertices);
        new Uint8Array(remap.buffer).set(heap.subarray(rp, rp + vertices * 4));
        indices8.set(heap.subarray(ip, ip + indices2.length * 4));
        sbrk(ip - sbrk(0));
        for (var i = 0; i < indices2.length; ++i)
          indices2[i] = remap[indices2[i]];
        return [remap, unique];
      }
      function maxindex(source) {
        var result = 0;
        for (var i = 0; i < source.length; ++i) {
          var index = source[i];
          result = result < index ? index : result;
        }
        return result;
      }
      function simplify(fun, indices2, index_count, vertex_positions, vertex_count, vertex_positions_stride, target_index_count, target_error, options) {
        var sbrk = instance.exports.sbrk;
        var te = sbrk(4);
        var ti = sbrk(index_count * 4);
        var sp = sbrk(vertex_count * vertex_positions_stride);
        var si = sbrk(index_count * 4);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        heap.set(bytes(vertex_positions), sp);
        heap.set(bytes(indices2), si);
        var result = fun(ti, si, index_count, sp, vertex_count, vertex_positions_stride, target_index_count, target_error, options, te);
        heap = new Uint8Array(instance.exports.memory.buffer);
        var target = new Uint32Array(result);
        bytes(target).set(heap.subarray(ti, ti + result * 4));
        var error = new Float32Array(1);
        bytes(error).set(heap.subarray(te, te + 4));
        sbrk(te - sbrk(0));
        return [target, error[0]];
      }
      function simplifyScale(fun, vertex_positions, vertex_count, vertex_positions_stride) {
        var sbrk = instance.exports.sbrk;
        var sp = sbrk(vertex_count * vertex_positions_stride);
        var heap = new Uint8Array(instance.exports.memory.buffer);
        heap.set(bytes(vertex_positions), sp);
        var result = fun(sp, vertex_count, vertex_positions_stride);
        sbrk(sp - sbrk(0));
        return result;
      }
      var simplifyOptions = {
        LockBorder: 1
      };
      return {
        ready: promise,
        supported: true,
        compactMesh: function(indices2) {
          assert(indices2 instanceof Uint32Array || indices2 instanceof Int32Array || indices2 instanceof Uint16Array || indices2 instanceof Int16Array);
          assert(indices2.length % 3 == 0);
          var indices32 = indices2.BYTES_PER_ELEMENT == 4 ? indices2 : new Uint32Array(indices2);
          return reorder(indices32, maxindex(indices2) + 1);
        },
        simplify: function(indices2, vertex_positions, vertex_positions_stride, target_index_count, target_error, flags) {
          assert(indices2 instanceof Uint32Array || indices2 instanceof Int32Array || indices2 instanceof Uint16Array || indices2 instanceof Int16Array);
          assert(indices2.length % 3 == 0);
          assert(vertex_positions instanceof Float32Array);
          assert(vertex_positions.length % vertex_positions_stride == 0);
          assert(vertex_positions_stride >= 3);
          assert(target_index_count % 3 == 0);
          var options = 0;
          for (var i = 0; i < (flags ? flags.length : 0); ++i) {
            options |= simplifyOptions[flags[i]];
          }
          var indices32 = indices2.BYTES_PER_ELEMENT == 4 ? indices2 : new Uint32Array(indices2);
          var result = simplify(instance.exports.meshopt_simplify, indices32, indices2.length, vertex_positions, vertex_positions.length, vertex_positions_stride * 4, target_index_count, target_error, options);
          result[0] = indices2 instanceof Uint32Array ? result[0] : new indices2.constructor(result[0]);
          return result;
        },
        getScale: function(vertex_positions, vertex_positions_stride) {
          assert(vertex_positions instanceof Float32Array);
          assert(vertex_positions.length % vertex_positions_stride == 0);
          return simplifyScale(instance.exports.meshopt_simplifyScale, vertex_positions, vertex_positions.length, vertex_positions_stride * 4);
        }
      };
    }();
    if (typeof exports2 === "object" && typeof module2 === "object")
      module2.exports = MeshoptSimplifier;
    else if (typeof define === "function" && define["amd"])
      define([], function() {
        return MeshoptSimplifier;
      });
    else if (typeof exports2 === "object")
      exports2["MeshoptSimplifier"] = MeshoptSimplifier;
    else
      (typeof self !== "undefined" ? self : exports2).MeshoptSimplifier = MeshoptSimplifier;
  }
});

// node_modules/meshoptimizer/index.js
var require_meshoptimizer = __commonJS({
  "node_modules/meshoptimizer/index.js"(exports2, module2) {
    var MeshoptEncoder = require_meshopt_encoder();
    var MeshoptDecoder2 = require_meshopt_decoder();
    var MeshoptSimplifier = require_meshopt_simplifier();
    module2.exports = { MeshoptEncoder, MeshoptDecoder: MeshoptDecoder2, MeshoptSimplifier };
  }
});

// node_modules/bitmap-sdf/index.js
var require_bitmap_sdf = __commonJS({
  "node_modules/bitmap-sdf/index.js"(exports2, module2) {
    "use strict";
    module2.exports = calcSDF;
    var INF = 1e20;
    function calcSDF(src, options) {
      if (!options)
        options = {};
      var cutoff = options.cutoff == null ? 0.25 : options.cutoff;
      var radius = options.radius == null ? 8 : options.radius;
      var channel = options.channel || 0;
      var w, h, size, data, intData, stride, ctx, canvas, imgData, i, l;
      if (ArrayBuffer.isView(src) || Array.isArray(src)) {
        if (!options.width || !options.height)
          throw Error("For raw data width and height should be provided by options");
        w = options.width, h = options.height;
        data = src;
        if (!options.stride)
          stride = Math.floor(src.length / w / h);
        else
          stride = options.stride;
      } else {
        if (window.HTMLCanvasElement && src instanceof window.HTMLCanvasElement) {
          canvas = src;
          ctx = canvas.getContext("2d");
          w = canvas.width, h = canvas.height;
          imgData = ctx.getImageData(0, 0, w, h);
          data = imgData.data;
          stride = 4;
        } else if (window.CanvasRenderingContext2D && src instanceof window.CanvasRenderingContext2D) {
          canvas = src.canvas;
          ctx = src;
          w = canvas.width, h = canvas.height;
          imgData = ctx.getImageData(0, 0, w, h);
          data = imgData.data;
          stride = 4;
        } else if (window.ImageData && src instanceof window.ImageData) {
          imgData = src;
          w = src.width, h = src.height;
          data = imgData.data;
          stride = 4;
        }
      }
      size = Math.max(w, h);
      if (window.Uint8ClampedArray && data instanceof window.Uint8ClampedArray || window.Uint8Array && data instanceof window.Uint8Array) {
        intData = data;
        data = Array(w * h);
        for (i = 0, l = Math.floor(intData.length / stride); i < l; i++) {
          data[i] = intData[i * stride + channel] / 255;
        }
      } else {
        if (stride !== 1)
          throw Error("Raw data can have only 1 value per pixel");
      }
      var gridOuter = Array(w * h);
      var gridInner = Array(w * h);
      var f = Array(size);
      var d = Array(size);
      var z = Array(size + 1);
      var v7 = Array(size);
      for (i = 0, l = w * h; i < l; i++) {
        var a3 = data[i];
        gridOuter[i] = a3 === 1 ? 0 : a3 === 0 ? INF : Math.pow(Math.max(0, 0.5 - a3), 2);
        gridInner[i] = a3 === 1 ? INF : a3 === 0 ? 0 : Math.pow(Math.max(0, a3 - 0.5), 2);
      }
      edt(gridOuter, w, h, f, d, v7, z);
      edt(gridInner, w, h, f, d, v7, z);
      var dist = window.Float32Array ? new Float32Array(w * h) : new Array(w * h);
      for (i = 0, l = w * h; i < l; i++) {
        dist[i] = Math.min(Math.max(1 - ((gridOuter[i] - gridInner[i]) / radius + cutoff), 0), 1);
      }
      return dist;
    }
    function edt(data, width, height, f, d, v7, z) {
      for (var x = 0; x < width; x++) {
        for (var y = 0; y < height; y++) {
          f[y] = data[y * width + x];
        }
        edt1d(f, d, v7, z, height);
        for (y = 0; y < height; y++) {
          data[y * width + x] = d[y];
        }
      }
      for (y = 0; y < height; y++) {
        for (x = 0; x < width; x++) {
          f[x] = data[y * width + x];
        }
        edt1d(f, d, v7, z, width);
        for (x = 0; x < width; x++) {
          data[y * width + x] = Math.sqrt(d[x]);
        }
      }
    }
    function edt1d(f, d, v7, z, n) {
      v7[0] = 0;
      z[0] = -INF;
      z[1] = +INF;
      for (var q = 1, k = 0; q < n; q++) {
        var s = (f[q] + q * q - (f[v7[k]] + v7[k] * v7[k])) / (2 * q - 2 * v7[k]);
        while (s <= z[k]) {
          k--;
          s = (f[q] + q * q - (f[v7[k]] + v7[k] * v7[k])) / (2 * q - 2 * v7[k]);
        }
        k++;
        v7[k] = q;
        z[k] = s;
        z[k + 1] = +INF;
      }
      for (q = 0, k = 0; q < n; q++) {
        while (z[k + 1] < q)
          k++;
        d[q] = (q - v7[k]) * (q - v7[k]) + f[v7[k]];
      }
    }
  }
});

// node_modules/grapheme-splitter/index.js
var require_grapheme_splitter = __commonJS({
  "node_modules/grapheme-splitter/index.js"(exports2, module2) {
    function GraphemeSplitter2() {
      var CR = 0, LF = 1, Control = 2, Extend = 3, Regional_Indicator = 4, SpacingMark = 5, L = 6, V = 7, T = 8, LV = 9, LVT = 10, Other = 11, Prepend = 12, E_Base = 13, E_Modifier = 14, ZWJ = 15, Glue_After_Zwj = 16, E_Base_GAZ = 17;
      var NotBreak = 0, BreakStart = 1, Break = 2, BreakLastRegional = 3, BreakPenultimateRegional = 4;
      function isSurrogate(str, pos) {
        return 55296 <= str.charCodeAt(pos) && str.charCodeAt(pos) <= 56319 && 56320 <= str.charCodeAt(pos + 1) && str.charCodeAt(pos + 1) <= 57343;
      }
      function codePointAt(str, idx) {
        if (idx === void 0) {
          idx = 0;
        }
        var code = str.charCodeAt(idx);
        if (55296 <= code && code <= 56319 && idx < str.length - 1) {
          var hi = code;
          var low = str.charCodeAt(idx + 1);
          if (56320 <= low && low <= 57343) {
            return (hi - 55296) * 1024 + (low - 56320) + 65536;
          }
          return hi;
        }
        if (56320 <= code && code <= 57343 && idx >= 1) {
          var hi = str.charCodeAt(idx - 1);
          var low = code;
          if (55296 <= hi && hi <= 56319) {
            return (hi - 55296) * 1024 + (low - 56320) + 65536;
          }
          return low;
        }
        return code;
      }
      function shouldBreak(start, mid, end) {
        var all = [start].concat(mid).concat([end]);
        var previous = all[all.length - 2];
        var next = end;
        var eModifierIndex = all.lastIndexOf(E_Modifier);
        if (eModifierIndex > 1 && all.slice(1, eModifierIndex).every(function(c) {
          return c == Extend;
        }) && [Extend, E_Base, E_Base_GAZ].indexOf(start) == -1) {
          return Break;
        }
        var rIIndex = all.lastIndexOf(Regional_Indicator);
        if (rIIndex > 0 && all.slice(1, rIIndex).every(function(c) {
          return c == Regional_Indicator;
        }) && [Prepend, Regional_Indicator].indexOf(previous) == -1) {
          if (all.filter(function(c) {
            return c == Regional_Indicator;
          }).length % 2 == 1) {
            return BreakLastRegional;
          } else {
            return BreakPenultimateRegional;
          }
        }
        if (previous == CR && next == LF) {
          return NotBreak;
        } else if (previous == Control || previous == CR || previous == LF) {
          if (next == E_Modifier && mid.every(function(c) {
            return c == Extend;
          })) {
            return Break;
          } else {
            return BreakStart;
          }
        } else if (next == Control || next == CR || next == LF) {
          return BreakStart;
        } else if (previous == L && (next == L || next == V || next == LV || next == LVT)) {
          return NotBreak;
        } else if ((previous == LV || previous == V) && (next == V || next == T)) {
          return NotBreak;
        } else if ((previous == LVT || previous == T) && next == T) {
          return NotBreak;
        } else if (next == Extend || next == ZWJ) {
          return NotBreak;
        } else if (next == SpacingMark) {
          return NotBreak;
        } else if (previous == Prepend) {
          return NotBreak;
        }
        var previousNonExtendIndex = all.indexOf(Extend) != -1 ? all.lastIndexOf(Extend) - 1 : all.length - 2;
        if ([E_Base, E_Base_GAZ].indexOf(all[previousNonExtendIndex]) != -1 && all.slice(previousNonExtendIndex + 1, -1).every(function(c) {
          return c == Extend;
        }) && next == E_Modifier) {
          return NotBreak;
        }
        if (previous == ZWJ && [Glue_After_Zwj, E_Base_GAZ].indexOf(next) != -1) {
          return NotBreak;
        }
        if (mid.indexOf(Regional_Indicator) != -1) {
          return Break;
        }
        if (previous == Regional_Indicator && next == Regional_Indicator) {
          return NotBreak;
        }
        return BreakStart;
      }
      this.nextBreak = function(string, index) {
        if (index === void 0) {
          index = 0;
        }
        if (index < 0) {
          return 0;
        }
        if (index >= string.length - 1) {
          return string.length;
        }
        var prev = getGraphemeBreakProperty(codePointAt(string, index));
        var mid = [];
        for (var i = index + 1; i < string.length; i++) {
          if (isSurrogate(string, i - 1)) {
            continue;
          }
          var next = getGraphemeBreakProperty(codePointAt(string, i));
          if (shouldBreak(prev, mid, next)) {
            return i;
          }
          mid.push(next);
        }
        return string.length;
      };
      this.splitGraphemes = function(str) {
        var res = [];
        var index = 0;
        var brk;
        while ((brk = this.nextBreak(str, index)) < str.length) {
          res.push(str.slice(index, brk));
          index = brk;
        }
        if (index < str.length) {
          res.push(str.slice(index));
        }
        return res;
      };
      this.iterateGraphemes = function(str) {
        var index = 0;
        var res = {
          next: function() {
            var value;
            var brk;
            if ((brk = this.nextBreak(str, index)) < str.length) {
              value = str.slice(index, brk);
              index = brk;
              return { value, done: false };
            }
            if (index < str.length) {
              value = str.slice(index);
              index = str.length;
              return { value, done: false };
            }
            return { value: void 0, done: true };
          }.bind(this)
        };
        if (typeof Symbol !== "undefined" && Symbol.iterator) {
          res[Symbol.iterator] = function() {
            return res;
          };
        }
        return res;
      };
      this.countGraphemes = function(str) {
        var count = 0;
        var index = 0;
        var brk;
        while ((brk = this.nextBreak(str, index)) < str.length) {
          index = brk;
          count++;
        }
        if (index < str.length) {
          count++;
        }
        return count;
      };
      function getGraphemeBreakProperty(code) {
        if (1536 <= code && code <= 1541 || 1757 == code || 1807 == code || 2274 == code || 3406 == code || 69821 == code || 70082 <= code && code <= 70083 || 72250 == code || 72326 <= code && code <= 72329 || 73030 == code) {
          return Prepend;
        }
        if (13 == code) {
          return CR;
        }
        if (10 == code) {
          return LF;
        }
        if (0 <= code && code <= 9 || 11 <= code && code <= 12 || 14 <= code && code <= 31 || 127 <= code && code <= 159 || 173 == code || 1564 == code || 6158 == code || 8203 == code || 8206 <= code && code <= 8207 || 8232 == code || 8233 == code || 8234 <= code && code <= 8238 || 8288 <= code && code <= 8292 || 8293 == code || 8294 <= code && code <= 8303 || 55296 <= code && code <= 57343 || 65279 == code || 65520 <= code && code <= 65528 || 65529 <= code && code <= 65531 || 113824 <= code && code <= 113827 || 119155 <= code && code <= 119162 || 917504 == code || 917505 == code || 917506 <= code && code <= 917535 || 917632 <= code && code <= 917759 || 918e3 <= code && code <= 921599) {
          return Control;
        }
        if (768 <= code && code <= 879 || 1155 <= code && code <= 1159 || 1160 <= code && code <= 1161 || 1425 <= code && code <= 1469 || 1471 == code || 1473 <= code && code <= 1474 || 1476 <= code && code <= 1477 || 1479 == code || 1552 <= code && code <= 1562 || 1611 <= code && code <= 1631 || 1648 == code || 1750 <= code && code <= 1756 || 1759 <= code && code <= 1764 || 1767 <= code && code <= 1768 || 1770 <= code && code <= 1773 || 1809 == code || 1840 <= code && code <= 1866 || 1958 <= code && code <= 1968 || 2027 <= code && code <= 2035 || 2070 <= code && code <= 2073 || 2075 <= code && code <= 2083 || 2085 <= code && code <= 2087 || 2089 <= code && code <= 2093 || 2137 <= code && code <= 2139 || 2260 <= code && code <= 2273 || 2275 <= code && code <= 2306 || 2362 == code || 2364 == code || 2369 <= code && code <= 2376 || 2381 == code || 2385 <= code && code <= 2391 || 2402 <= code && code <= 2403 || 2433 == code || 2492 == code || 2494 == code || 2497 <= code && code <= 2500 || 2509 == code || 2519 == code || 2530 <= code && code <= 2531 || 2561 <= code && code <= 2562 || 2620 == code || 2625 <= code && code <= 2626 || 2631 <= code && code <= 2632 || 2635 <= code && code <= 2637 || 2641 == code || 2672 <= code && code <= 2673 || 2677 == code || 2689 <= code && code <= 2690 || 2748 == code || 2753 <= code && code <= 2757 || 2759 <= code && code <= 2760 || 2765 == code || 2786 <= code && code <= 2787 || 2810 <= code && code <= 2815 || 2817 == code || 2876 == code || 2878 == code || 2879 == code || 2881 <= code && code <= 2884 || 2893 == code || 2902 == code || 2903 == code || 2914 <= code && code <= 2915 || 2946 == code || 3006 == code || 3008 == code || 3021 == code || 3031 == code || 3072 == code || 3134 <= code && code <= 3136 || 3142 <= code && code <= 3144 || 3146 <= code && code <= 3149 || 3157 <= code && code <= 3158 || 3170 <= code && code <= 3171 || 3201 == code || 3260 == code || 3263 == code || 3266 == code || 3270 == code || 3276 <= code && code <= 3277 || 3285 <= code && code <= 3286 || 3298 <= code && code <= 3299 || 3328 <= code && code <= 3329 || 3387 <= code && code <= 3388 || 3390 == code || 3393 <= code && code <= 3396 || 3405 == code || 3415 == code || 3426 <= code && code <= 3427 || 3530 == code || 3535 == code || 3538 <= code && code <= 3540 || 3542 == code || 3551 == code || 3633 == code || 3636 <= code && code <= 3642 || 3655 <= code && code <= 3662 || 3761 == code || 3764 <= code && code <= 3769 || 3771 <= code && code <= 3772 || 3784 <= code && code <= 3789 || 3864 <= code && code <= 3865 || 3893 == code || 3895 == code || 3897 == code || 3953 <= code && code <= 3966 || 3968 <= code && code <= 3972 || 3974 <= code && code <= 3975 || 3981 <= code && code <= 3991 || 3993 <= code && code <= 4028 || 4038 == code || 4141 <= code && code <= 4144 || 4146 <= code && code <= 4151 || 4153 <= code && code <= 4154 || 4157 <= code && code <= 4158 || 4184 <= code && code <= 4185 || 4190 <= code && code <= 4192 || 4209 <= code && code <= 4212 || 4226 == code || 4229 <= code && code <= 4230 || 4237 == code || 4253 == code || 4957 <= code && code <= 4959 || 5906 <= code && code <= 5908 || 5938 <= code && code <= 5940 || 5970 <= code && code <= 5971 || 6002 <= code && code <= 6003 || 6068 <= code && code <= 6069 || 6071 <= code && code <= 6077 || 6086 == code || 6089 <= code && code <= 6099 || 6109 == code || 6155 <= code && code <= 6157 || 6277 <= code && code <= 6278 || 6313 == code || 6432 <= code && code <= 6434 || 6439 <= code && code <= 6440 || 6450 == code || 6457 <= code && code <= 6459 || 6679 <= code && code <= 6680 || 6683 == code || 6742 == code || 6744 <= code && code <= 6750 || 6752 == code || 6754 == code || 6757 <= code && code <= 6764 || 6771 <= code && code <= 6780 || 6783 == code || 6832 <= code && code <= 6845 || 6846 == code || 6912 <= code && code <= 6915 || 6964 == code || 6966 <= code && code <= 6970 || 6972 == code || 6978 == code || 7019 <= code && code <= 7027 || 7040 <= code && code <= 7041 || 7074 <= code && code <= 7077 || 7080 <= code && code <= 7081 || 7083 <= code && code <= 7085 || 7142 == code || 7144 <= code && code <= 7145 || 7149 == code || 7151 <= code && code <= 7153 || 7212 <= code && code <= 7219 || 7222 <= code && code <= 7223 || 7376 <= code && code <= 7378 || 7380 <= code && code <= 7392 || 7394 <= code && code <= 7400 || 7405 == code || 7412 == code || 7416 <= code && code <= 7417 || 7616 <= code && code <= 7673 || 7675 <= code && code <= 7679 || 8204 == code || 8400 <= code && code <= 8412 || 8413 <= code && code <= 8416 || 8417 == code || 8418 <= code && code <= 8420 || 8421 <= code && code <= 8432 || 11503 <= code && code <= 11505 || 11647 == code || 11744 <= code && code <= 11775 || 12330 <= code && code <= 12333 || 12334 <= code && code <= 12335 || 12441 <= code && code <= 12442 || 42607 == code || 42608 <= code && code <= 42610 || 42612 <= code && code <= 42621 || 42654 <= code && code <= 42655 || 42736 <= code && code <= 42737 || 43010 == code || 43014 == code || 43019 == code || 43045 <= code && code <= 43046 || 43204 <= code && code <= 43205 || 43232 <= code && code <= 43249 || 43302 <= code && code <= 43309 || 43335 <= code && code <= 43345 || 43392 <= code && code <= 43394 || 43443 == code || 43446 <= code && code <= 43449 || 43452 == code || 43493 == code || 43561 <= code && code <= 43566 || 43569 <= code && code <= 43570 || 43573 <= code && code <= 43574 || 43587 == code || 43596 == code || 43644 == code || 43696 == code || 43698 <= code && code <= 43700 || 43703 <= code && code <= 43704 || 43710 <= code && code <= 43711 || 43713 == code || 43756 <= code && code <= 43757 || 43766 == code || 44005 == code || 44008 == code || 44013 == code || 64286 == code || 65024 <= code && code <= 65039 || 65056 <= code && code <= 65071 || 65438 <= code && code <= 65439 || 66045 == code || 66272 == code || 66422 <= code && code <= 66426 || 68097 <= code && code <= 68099 || 68101 <= code && code <= 68102 || 68108 <= code && code <= 68111 || 68152 <= code && code <= 68154 || 68159 == code || 68325 <= code && code <= 68326 || 69633 == code || 69688 <= code && code <= 69702 || 69759 <= code && code <= 69761 || 69811 <= code && code <= 69814 || 69817 <= code && code <= 69818 || 69888 <= code && code <= 69890 || 69927 <= code && code <= 69931 || 69933 <= code && code <= 69940 || 70003 == code || 70016 <= code && code <= 70017 || 70070 <= code && code <= 70078 || 70090 <= code && code <= 70092 || 70191 <= code && code <= 70193 || 70196 == code || 70198 <= code && code <= 70199 || 70206 == code || 70367 == code || 70371 <= code && code <= 70378 || 70400 <= code && code <= 70401 || 70460 == code || 70462 == code || 70464 == code || 70487 == code || 70502 <= code && code <= 70508 || 70512 <= code && code <= 70516 || 70712 <= code && code <= 70719 || 70722 <= code && code <= 70724 || 70726 == code || 70832 == code || 70835 <= code && code <= 70840 || 70842 == code || 70845 == code || 70847 <= code && code <= 70848 || 70850 <= code && code <= 70851 || 71087 == code || 71090 <= code && code <= 71093 || 71100 <= code && code <= 71101 || 71103 <= code && code <= 71104 || 71132 <= code && code <= 71133 || 71219 <= code && code <= 71226 || 71229 == code || 71231 <= code && code <= 71232 || 71339 == code || 71341 == code || 71344 <= code && code <= 71349 || 71351 == code || 71453 <= code && code <= 71455 || 71458 <= code && code <= 71461 || 71463 <= code && code <= 71467 || 72193 <= code && code <= 72198 || 72201 <= code && code <= 72202 || 72243 <= code && code <= 72248 || 72251 <= code && code <= 72254 || 72263 == code || 72273 <= code && code <= 72278 || 72281 <= code && code <= 72283 || 72330 <= code && code <= 72342 || 72344 <= code && code <= 72345 || 72752 <= code && code <= 72758 || 72760 <= code && code <= 72765 || 72767 == code || 72850 <= code && code <= 72871 || 72874 <= code && code <= 72880 || 72882 <= code && code <= 72883 || 72885 <= code && code <= 72886 || 73009 <= code && code <= 73014 || 73018 == code || 73020 <= code && code <= 73021 || 73023 <= code && code <= 73029 || 73031 == code || 92912 <= code && code <= 92916 || 92976 <= code && code <= 92982 || 94095 <= code && code <= 94098 || 113821 <= code && code <= 113822 || 119141 == code || 119143 <= code && code <= 119145 || 119150 <= code && code <= 119154 || 119163 <= code && code <= 119170 || 119173 <= code && code <= 119179 || 119210 <= code && code <= 119213 || 119362 <= code && code <= 119364 || 121344 <= code && code <= 121398 || 121403 <= code && code <= 121452 || 121461 == code || 121476 == code || 121499 <= code && code <= 121503 || 121505 <= code && code <= 121519 || 122880 <= code && code <= 122886 || 122888 <= code && code <= 122904 || 122907 <= code && code <= 122913 || 122915 <= code && code <= 122916 || 122918 <= code && code <= 122922 || 125136 <= code && code <= 125142 || 125252 <= code && code <= 125258 || 917536 <= code && code <= 917631 || 917760 <= code && code <= 917999) {
          return Extend;
        }
        if (127462 <= code && code <= 127487) {
          return Regional_Indicator;
        }
        if (2307 == code || 2363 == code || 2366 <= code && code <= 2368 || 2377 <= code && code <= 2380 || 2382 <= code && code <= 2383 || 2434 <= code && code <= 2435 || 2495 <= code && code <= 2496 || 2503 <= code && code <= 2504 || 2507 <= code && code <= 2508 || 2563 == code || 2622 <= code && code <= 2624 || 2691 == code || 2750 <= code && code <= 2752 || 2761 == code || 2763 <= code && code <= 2764 || 2818 <= code && code <= 2819 || 2880 == code || 2887 <= code && code <= 2888 || 2891 <= code && code <= 2892 || 3007 == code || 3009 <= code && code <= 3010 || 3014 <= code && code <= 3016 || 3018 <= code && code <= 3020 || 3073 <= code && code <= 3075 || 3137 <= code && code <= 3140 || 3202 <= code && code <= 3203 || 3262 == code || 3264 <= code && code <= 3265 || 3267 <= code && code <= 3268 || 3271 <= code && code <= 3272 || 3274 <= code && code <= 3275 || 3330 <= code && code <= 3331 || 3391 <= code && code <= 3392 || 3398 <= code && code <= 3400 || 3402 <= code && code <= 3404 || 3458 <= code && code <= 3459 || 3536 <= code && code <= 3537 || 3544 <= code && code <= 3550 || 3570 <= code && code <= 3571 || 3635 == code || 3763 == code || 3902 <= code && code <= 3903 || 3967 == code || 4145 == code || 4155 <= code && code <= 4156 || 4182 <= code && code <= 4183 || 4228 == code || 6070 == code || 6078 <= code && code <= 6085 || 6087 <= code && code <= 6088 || 6435 <= code && code <= 6438 || 6441 <= code && code <= 6443 || 6448 <= code && code <= 6449 || 6451 <= code && code <= 6456 || 6681 <= code && code <= 6682 || 6741 == code || 6743 == code || 6765 <= code && code <= 6770 || 6916 == code || 6965 == code || 6971 == code || 6973 <= code && code <= 6977 || 6979 <= code && code <= 6980 || 7042 == code || 7073 == code || 7078 <= code && code <= 7079 || 7082 == code || 7143 == code || 7146 <= code && code <= 7148 || 7150 == code || 7154 <= code && code <= 7155 || 7204 <= code && code <= 7211 || 7220 <= code && code <= 7221 || 7393 == code || 7410 <= code && code <= 7411 || 7415 == code || 43043 <= code && code <= 43044 || 43047 == code || 43136 <= code && code <= 43137 || 43188 <= code && code <= 43203 || 43346 <= code && code <= 43347 || 43395 == code || 43444 <= code && code <= 43445 || 43450 <= code && code <= 43451 || 43453 <= code && code <= 43456 || 43567 <= code && code <= 43568 || 43571 <= code && code <= 43572 || 43597 == code || 43755 == code || 43758 <= code && code <= 43759 || 43765 == code || 44003 <= code && code <= 44004 || 44006 <= code && code <= 44007 || 44009 <= code && code <= 44010 || 44012 == code || 69632 == code || 69634 == code || 69762 == code || 69808 <= code && code <= 69810 || 69815 <= code && code <= 69816 || 69932 == code || 70018 == code || 70067 <= code && code <= 70069 || 70079 <= code && code <= 70080 || 70188 <= code && code <= 70190 || 70194 <= code && code <= 70195 || 70197 == code || 70368 <= code && code <= 70370 || 70402 <= code && code <= 70403 || 70463 == code || 70465 <= code && code <= 70468 || 70471 <= code && code <= 70472 || 70475 <= code && code <= 70477 || 70498 <= code && code <= 70499 || 70709 <= code && code <= 70711 || 70720 <= code && code <= 70721 || 70725 == code || 70833 <= code && code <= 70834 || 70841 == code || 70843 <= code && code <= 70844 || 70846 == code || 70849 == code || 71088 <= code && code <= 71089 || 71096 <= code && code <= 71099 || 71102 == code || 71216 <= code && code <= 71218 || 71227 <= code && code <= 71228 || 71230 == code || 71340 == code || 71342 <= code && code <= 71343 || 71350 == code || 71456 <= code && code <= 71457 || 71462 == code || 72199 <= code && code <= 72200 || 72249 == code || 72279 <= code && code <= 72280 || 72343 == code || 72751 == code || 72766 == code || 72873 == code || 72881 == code || 72884 == code || 94033 <= code && code <= 94078 || 119142 == code || 119149 == code) {
          return SpacingMark;
        }
        if (4352 <= code && code <= 4447 || 43360 <= code && code <= 43388) {
          return L;
        }
        if (4448 <= code && code <= 4519 || 55216 <= code && code <= 55238) {
          return V;
        }
        if (4520 <= code && code <= 4607 || 55243 <= code && code <= 55291) {
          return T;
        }
        if (44032 == code || 44060 == code || 44088 == code || 44116 == code || 44144 == code || 44172 == code || 44200 == code || 44228 == code || 44256 == code || 44284 == code || 44312 == code || 44340 == code || 44368 == code || 44396 == code || 44424 == code || 44452 == code || 44480 == code || 44508 == code || 44536 == code || 44564 == code || 44592 == code || 44620 == code || 44648 == code || 44676 == code || 44704 == code || 44732 == code || 44760 == code || 44788 == code || 44816 == code || 44844 == code || 44872 == code || 44900 == code || 44928 == code || 44956 == code || 44984 == code || 45012 == code || 45040 == code || 45068 == code || 45096 == code || 45124 == code || 45152 == code || 45180 == code || 45208 == code || 45236 == code || 45264 == code || 45292 == code || 45320 == code || 45348 == code || 45376 == code || 45404 == code || 45432 == code || 45460 == code || 45488 == code || 45516 == code || 45544 == code || 45572 == code || 45600 == code || 45628 == code || 45656 == code || 45684 == code || 45712 == code || 45740 == code || 45768 == code || 45796 == code || 45824 == code || 45852 == code || 45880 == code || 45908 == code || 45936 == code || 45964 == code || 45992 == code || 46020 == code || 46048 == code || 46076 == code || 46104 == code || 46132 == code || 46160 == code || 46188 == code || 46216 == code || 46244 == code || 46272 == code || 46300 == code || 46328 == code || 46356 == code || 46384 == code || 46412 == code || 46440 == code || 46468 == code || 46496 == code || 46524 == code || 46552 == code || 46580 == code || 46608 == code || 46636 == code || 46664 == code || 46692 == code || 46720 == code || 46748 == code || 46776 == code || 46804 == code || 46832 == code || 46860 == code || 46888 == code || 46916 == code || 46944 == code || 46972 == code || 47e3 == code || 47028 == code || 47056 == code || 47084 == code || 47112 == code || 47140 == code || 47168 == code || 47196 == code || 47224 == code || 47252 == code || 47280 == code || 47308 == code || 47336 == code || 47364 == code || 47392 == code || 47420 == code || 47448 == code || 47476 == code || 47504 == code || 47532 == code || 47560 == code || 47588 == code || 47616 == code || 47644 == code || 47672 == code || 47700 == code || 47728 == code || 47756 == code || 47784 == code || 47812 == code || 47840 == code || 47868 == code || 47896 == code || 47924 == code || 47952 == code || 47980 == code || 48008 == code || 48036 == code || 48064 == code || 48092 == code || 48120 == code || 48148 == code || 48176 == code || 48204 == code || 48232 == code || 48260 == code || 48288 == code || 48316 == code || 48344 == code || 48372 == code || 48400 == code || 48428 == code || 48456 == code || 48484 == code || 48512 == code || 48540 == code || 48568 == code || 48596 == code || 48624 == code || 48652 == code || 48680 == code || 48708 == code || 48736 == code || 48764 == code || 48792 == code || 48820 == code || 48848 == code || 48876 == code || 48904 == code || 48932 == code || 48960 == code || 48988 == code || 49016 == code || 49044 == code || 49072 == code || 49100 == code || 49128 == code || 49156 == code || 49184 == code || 49212 == code || 49240 == code || 49268 == code || 49296 == code || 49324 == code || 49352 == code || 49380 == code || 49408 == code || 49436 == code || 49464 == code || 49492 == code || 49520 == code || 49548 == code || 49576 == code || 49604 == code || 49632 == code || 49660 == code || 49688 == code || 49716 == code || 49744 == code || 49772 == code || 49800 == code || 49828 == code || 49856 == code || 49884 == code || 49912 == code || 49940 == code || 49968 == code || 49996 == code || 50024 == code || 50052 == code || 50080 == code || 50108 == code || 50136 == code || 50164 == code || 50192 == code || 50220 == code || 50248 == code || 50276 == code || 50304 == code || 50332 == code || 50360 == code || 50388 == code || 50416 == code || 50444 == code || 50472 == code || 50500 == code || 50528 == code || 50556 == code || 50584 == code || 50612 == code || 50640 == code || 50668 == code || 50696 == code || 50724 == code || 50752 == code || 50780 == code || 50808 == code || 50836 == code || 50864 == code || 50892 == code || 50920 == code || 50948 == code || 50976 == code || 51004 == code || 51032 == code || 51060 == code || 51088 == code || 51116 == code || 51144 == code || 51172 == code || 51200 == code || 51228 == code || 51256 == code || 51284 == code || 51312 == code || 51340 == code || 51368 == code || 51396 == code || 51424 == code || 51452 == code || 51480 == code || 51508 == code || 51536 == code || 51564 == code || 51592 == code || 51620 == code || 51648 == code || 51676 == code || 51704 == code || 51732 == code || 51760 == code || 51788 == code || 51816 == code || 51844 == code || 51872 == code || 51900 == code || 51928 == code || 51956 == code || 51984 == code || 52012 == code || 52040 == code || 52068 == code || 52096 == code || 52124 == code || 52152 == code || 52180 == code || 52208 == code || 52236 == code || 52264 == code || 52292 == code || 52320 == code || 52348 == code || 52376 == code || 52404 == code || 52432 == code || 52460 == code || 52488 == code || 52516 == code || 52544 == code || 52572 == code || 52600 == code || 52628 == code || 52656 == code || 52684 == code || 52712 == code || 52740 == code || 52768 == code || 52796 == code || 52824 == code || 52852 == code || 52880 == code || 52908 == code || 52936 == code || 52964 == code || 52992 == code || 53020 == code || 53048 == code || 53076 == code || 53104 == code || 53132 == code || 53160 == code || 53188 == code || 53216 == code || 53244 == code || 53272 == code || 53300 == code || 53328 == code || 53356 == code || 53384 == code || 53412 == code || 53440 == code || 53468 == code || 53496 == code || 53524 == code || 53552 == code || 53580 == code || 53608 == code || 53636 == code || 53664 == code || 53692 == code || 53720 == code || 53748 == code || 53776 == code || 53804 == code || 53832 == code || 53860 == code || 53888 == code || 53916 == code || 53944 == code || 53972 == code || 54e3 == code || 54028 == code || 54056 == code || 54084 == code || 54112 == code || 54140 == code || 54168 == code || 54196 == code || 54224 == code || 54252 == code || 54280 == code || 54308 == code || 54336 == code || 54364 == code || 54392 == code || 54420 == code || 54448 == code || 54476 == code || 54504 == code || 54532 == code || 54560 == code || 54588 == code || 54616 == code || 54644 == code || 54672 == code || 54700 == code || 54728 == code || 54756 == code || 54784 == code || 54812 == code || 54840 == code || 54868 == code || 54896 == code || 54924 == code || 54952 == code || 54980 == code || 55008 == code || 55036 == code || 55064 == code || 55092 == code || 55120 == code || 55148 == code || 55176 == code) {
          return LV;
        }
        if (44033 <= code && code <= 44059 || 44061 <= code && code <= 44087 || 44089 <= code && code <= 44115 || 44117 <= code && code <= 44143 || 44145 <= code && code <= 44171 || 44173 <= code && code <= 44199 || 44201 <= code && code <= 44227 || 44229 <= code && code <= 44255 || 44257 <= code && code <= 44283 || 44285 <= code && code <= 44311 || 44313 <= code && code <= 44339 || 44341 <= code && code <= 44367 || 44369 <= code && code <= 44395 || 44397 <= code && code <= 44423 || 44425 <= code && code <= 44451 || 44453 <= code && code <= 44479 || 44481 <= code && code <= 44507 || 44509 <= code && code <= 44535 || 44537 <= code && code <= 44563 || 44565 <= code && code <= 44591 || 44593 <= code && code <= 44619 || 44621 <= code && code <= 44647 || 44649 <= code && code <= 44675 || 44677 <= code && code <= 44703 || 44705 <= code && code <= 44731 || 44733 <= code && code <= 44759 || 44761 <= code && code <= 44787 || 44789 <= code && code <= 44815 || 44817 <= code && code <= 44843 || 44845 <= code && code <= 44871 || 44873 <= code && code <= 44899 || 44901 <= code && code <= 44927 || 44929 <= code && code <= 44955 || 44957 <= code && code <= 44983 || 44985 <= code && code <= 45011 || 45013 <= code && code <= 45039 || 45041 <= code && code <= 45067 || 45069 <= code && code <= 45095 || 45097 <= code && code <= 45123 || 45125 <= code && code <= 45151 || 45153 <= code && code <= 45179 || 45181 <= code && code <= 45207 || 45209 <= code && code <= 45235 || 45237 <= code && code <= 45263 || 45265 <= code && code <= 45291 || 45293 <= code && code <= 45319 || 45321 <= code && code <= 45347 || 45349 <= code && code <= 45375 || 45377 <= code && code <= 45403 || 45405 <= code && code <= 45431 || 45433 <= code && code <= 45459 || 45461 <= code && code <= 45487 || 45489 <= code && code <= 45515 || 45517 <= code && code <= 45543 || 45545 <= code && code <= 45571 || 45573 <= code && code <= 45599 || 45601 <= code && code <= 45627 || 45629 <= code && code <= 45655 || 45657 <= code && code <= 45683 || 45685 <= code && code <= 45711 || 45713 <= code && code <= 45739 || 45741 <= code && code <= 45767 || 45769 <= code && code <= 45795 || 45797 <= code && code <= 45823 || 45825 <= code && code <= 45851 || 45853 <= code && code <= 45879 || 45881 <= code && code <= 45907 || 45909 <= code && code <= 45935 || 45937 <= code && code <= 45963 || 45965 <= code && code <= 45991 || 45993 <= code && code <= 46019 || 46021 <= code && code <= 46047 || 46049 <= code && code <= 46075 || 46077 <= code && code <= 46103 || 46105 <= code && code <= 46131 || 46133 <= code && code <= 46159 || 46161 <= code && code <= 46187 || 46189 <= code && code <= 46215 || 46217 <= code && code <= 46243 || 46245 <= code && code <= 46271 || 46273 <= code && code <= 46299 || 46301 <= code && code <= 46327 || 46329 <= code && code <= 46355 || 46357 <= code && code <= 46383 || 46385 <= code && code <= 46411 || 46413 <= code && code <= 46439 || 46441 <= code && code <= 46467 || 46469 <= code && code <= 46495 || 46497 <= code && code <= 46523 || 46525 <= code && code <= 46551 || 46553 <= code && code <= 46579 || 46581 <= code && code <= 46607 || 46609 <= code && code <= 46635 || 46637 <= code && code <= 46663 || 46665 <= code && code <= 46691 || 46693 <= code && code <= 46719 || 46721 <= code && code <= 46747 || 46749 <= code && code <= 46775 || 46777 <= code && code <= 46803 || 46805 <= code && code <= 46831 || 46833 <= code && code <= 46859 || 46861 <= code && code <= 46887 || 46889 <= code && code <= 46915 || 46917 <= code && code <= 46943 || 46945 <= code && code <= 46971 || 46973 <= code && code <= 46999 || 47001 <= code && code <= 47027 || 47029 <= code && code <= 47055 || 47057 <= code && code <= 47083 || 47085 <= code && code <= 47111 || 47113 <= code && code <= 47139 || 47141 <= code && code <= 47167 || 47169 <= code && code <= 47195 || 47197 <= code && code <= 47223 || 47225 <= code && code <= 47251 || 47253 <= code && code <= 47279 || 47281 <= code && code <= 47307 || 47309 <= code && code <= 47335 || 47337 <= code && code <= 47363 || 47365 <= code && code <= 47391 || 47393 <= code && code <= 47419 || 47421 <= code && code <= 47447 || 47449 <= code && code <= 47475 || 47477 <= code && code <= 47503 || 47505 <= code && code <= 47531 || 47533 <= code && code <= 47559 || 47561 <= code && code <= 47587 || 47589 <= code && code <= 47615 || 47617 <= code && code <= 47643 || 47645 <= code && code <= 47671 || 47673 <= code && code <= 47699 || 47701 <= code && code <= 47727 || 47729 <= code && code <= 47755 || 47757 <= code && code <= 47783 || 47785 <= code && code <= 47811 || 47813 <= code && code <= 47839 || 47841 <= code && code <= 47867 || 47869 <= code && code <= 47895 || 47897 <= code && code <= 47923 || 47925 <= code && code <= 47951 || 47953 <= code && code <= 47979 || 47981 <= code && code <= 48007 || 48009 <= code && code <= 48035 || 48037 <= code && code <= 48063 || 48065 <= code && code <= 48091 || 48093 <= code && code <= 48119 || 48121 <= code && code <= 48147 || 48149 <= code && code <= 48175 || 48177 <= code && code <= 48203 || 48205 <= code && code <= 48231 || 48233 <= code && code <= 48259 || 48261 <= code && code <= 48287 || 48289 <= code && code <= 48315 || 48317 <= code && code <= 48343 || 48345 <= code && code <= 48371 || 48373 <= code && code <= 48399 || 48401 <= code && code <= 48427 || 48429 <= code && code <= 48455 || 48457 <= code && code <= 48483 || 48485 <= code && code <= 48511 || 48513 <= code && code <= 48539 || 48541 <= code && code <= 48567 || 48569 <= code && code <= 48595 || 48597 <= code && code <= 48623 || 48625 <= code && code <= 48651 || 48653 <= code && code <= 48679 || 48681 <= code && code <= 48707 || 48709 <= code && code <= 48735 || 48737 <= code && code <= 48763 || 48765 <= code && code <= 48791 || 48793 <= code && code <= 48819 || 48821 <= code && code <= 48847 || 48849 <= code && code <= 48875 || 48877 <= code && code <= 48903 || 48905 <= code && code <= 48931 || 48933 <= code && code <= 48959 || 48961 <= code && code <= 48987 || 48989 <= code && code <= 49015 || 49017 <= code && code <= 49043 || 49045 <= code && code <= 49071 || 49073 <= code && code <= 49099 || 49101 <= code && code <= 49127 || 49129 <= code && code <= 49155 || 49157 <= code && code <= 49183 || 49185 <= code && code <= 49211 || 49213 <= code && code <= 49239 || 49241 <= code && code <= 49267 || 49269 <= code && code <= 49295 || 49297 <= code && code <= 49323 || 49325 <= code && code <= 49351 || 49353 <= code && code <= 49379 || 49381 <= code && code <= 49407 || 49409 <= code && code <= 49435 || 49437 <= code && code <= 49463 || 49465 <= code && code <= 49491 || 49493 <= code && code <= 49519 || 49521 <= code && code <= 49547 || 49549 <= code && code <= 49575 || 49577 <= code && code <= 49603 || 49605 <= code && code <= 49631 || 49633 <= code && code <= 49659 || 49661 <= code && code <= 49687 || 49689 <= code && code <= 49715 || 49717 <= code && code <= 49743 || 49745 <= code && code <= 49771 || 49773 <= code && code <= 49799 || 49801 <= code && code <= 49827 || 49829 <= code && code <= 49855 || 49857 <= code && code <= 49883 || 49885 <= code && code <= 49911 || 49913 <= code && code <= 49939 || 49941 <= code && code <= 49967 || 49969 <= code && code <= 49995 || 49997 <= code && code <= 50023 || 50025 <= code && code <= 50051 || 50053 <= code && code <= 50079 || 50081 <= code && code <= 50107 || 50109 <= code && code <= 50135 || 50137 <= code && code <= 50163 || 50165 <= code && code <= 50191 || 50193 <= code && code <= 50219 || 50221 <= code && code <= 50247 || 50249 <= code && code <= 50275 || 50277 <= code && code <= 50303 || 50305 <= code && code <= 50331 || 50333 <= code && code <= 50359 || 50361 <= code && code <= 50387 || 50389 <= code && code <= 50415 || 50417 <= code && code <= 50443 || 50445 <= code && code <= 50471 || 50473 <= code && code <= 50499 || 50501 <= code && code <= 50527 || 50529 <= code && code <= 50555 || 50557 <= code && code <= 50583 || 50585 <= code && code <= 50611 || 50613 <= code && code <= 50639 || 50641 <= code && code <= 50667 || 50669 <= code && code <= 50695 || 50697 <= code && code <= 50723 || 50725 <= code && code <= 50751 || 50753 <= code && code <= 50779 || 50781 <= code && code <= 50807 || 50809 <= code && code <= 50835 || 50837 <= code && code <= 50863 || 50865 <= code && code <= 50891 || 50893 <= code && code <= 50919 || 50921 <= code && code <= 50947 || 50949 <= code && code <= 50975 || 50977 <= code && code <= 51003 || 51005 <= code && code <= 51031 || 51033 <= code && code <= 51059 || 51061 <= code && code <= 51087 || 51089 <= code && code <= 51115 || 51117 <= code && code <= 51143 || 51145 <= code && code <= 51171 || 51173 <= code && code <= 51199 || 51201 <= code && code <= 51227 || 51229 <= code && code <= 51255 || 51257 <= code && code <= 51283 || 51285 <= code && code <= 51311 || 51313 <= code && code <= 51339 || 51341 <= code && code <= 51367 || 51369 <= code && code <= 51395 || 51397 <= code && code <= 51423 || 51425 <= code && code <= 51451 || 51453 <= code && code <= 51479 || 51481 <= code && code <= 51507 || 51509 <= code && code <= 51535 || 51537 <= code && code <= 51563 || 51565 <= code && code <= 51591 || 51593 <= code && code <= 51619 || 51621 <= code && code <= 51647 || 51649 <= code && code <= 51675 || 51677 <= code && code <= 51703 || 51705 <= code && code <= 51731 || 51733 <= code && code <= 51759 || 51761 <= code && code <= 51787 || 51789 <= code && code <= 51815 || 51817 <= code && code <= 51843 || 51845 <= code && code <= 51871 || 51873 <= code && code <= 51899 || 51901 <= code && code <= 51927 || 51929 <= code && code <= 51955 || 51957 <= code && code <= 51983 || 51985 <= code && code <= 52011 || 52013 <= code && code <= 52039 || 52041 <= code && code <= 52067 || 52069 <= code && code <= 52095 || 52097 <= code && code <= 52123 || 52125 <= code && code <= 52151 || 52153 <= code && code <= 52179 || 52181 <= code && code <= 52207 || 52209 <= code && code <= 52235 || 52237 <= code && code <= 52263 || 52265 <= code && code <= 52291 || 52293 <= code && code <= 52319 || 52321 <= code && code <= 52347 || 52349 <= code && code <= 52375 || 52377 <= code && code <= 52403 || 52405 <= code && code <= 52431 || 52433 <= code && code <= 52459 || 52461 <= code && code <= 52487 || 52489 <= code && code <= 52515 || 52517 <= code && code <= 52543 || 52545 <= code && code <= 52571 || 52573 <= code && code <= 52599 || 52601 <= code && code <= 52627 || 52629 <= code && code <= 52655 || 52657 <= code && code <= 52683 || 52685 <= code && code <= 52711 || 52713 <= code && code <= 52739 || 52741 <= code && code <= 52767 || 52769 <= code && code <= 52795 || 52797 <= code && code <= 52823 || 52825 <= code && code <= 52851 || 52853 <= code && code <= 52879 || 52881 <= code && code <= 52907 || 52909 <= code && code <= 52935 || 52937 <= code && code <= 52963 || 52965 <= code && code <= 52991 || 52993 <= code && code <= 53019 || 53021 <= code && code <= 53047 || 53049 <= code && code <= 53075 || 53077 <= code && code <= 53103 || 53105 <= code && code <= 53131 || 53133 <= code && code <= 53159 || 53161 <= code && code <= 53187 || 53189 <= code && code <= 53215 || 53217 <= code && code <= 53243 || 53245 <= code && code <= 53271 || 53273 <= code && code <= 53299 || 53301 <= code && code <= 53327 || 53329 <= code && code <= 53355 || 53357 <= code && code <= 53383 || 53385 <= code && code <= 53411 || 53413 <= code && code <= 53439 || 53441 <= code && code <= 53467 || 53469 <= code && code <= 53495 || 53497 <= code && code <= 53523 || 53525 <= code && code <= 53551 || 53553 <= code && code <= 53579 || 53581 <= code && code <= 53607 || 53609 <= code && code <= 53635 || 53637 <= code && code <= 53663 || 53665 <= code && code <= 53691 || 53693 <= code && code <= 53719 || 53721 <= code && code <= 53747 || 53749 <= code && code <= 53775 || 53777 <= code && code <= 53803 || 53805 <= code && code <= 53831 || 53833 <= code && code <= 53859 || 53861 <= code && code <= 53887 || 53889 <= code && code <= 53915 || 53917 <= code && code <= 53943 || 53945 <= code && code <= 53971 || 53973 <= code && code <= 53999 || 54001 <= code && code <= 54027 || 54029 <= code && code <= 54055 || 54057 <= code && code <= 54083 || 54085 <= code && code <= 54111 || 54113 <= code && code <= 54139 || 54141 <= code && code <= 54167 || 54169 <= code && code <= 54195 || 54197 <= code && code <= 54223 || 54225 <= code && code <= 54251 || 54253 <= code && code <= 54279 || 54281 <= code && code <= 54307 || 54309 <= code && code <= 54335 || 54337 <= code && code <= 54363 || 54365 <= code && code <= 54391 || 54393 <= code && code <= 54419 || 54421 <= code && code <= 54447 || 54449 <= code && code <= 54475 || 54477 <= code && code <= 54503 || 54505 <= code && code <= 54531 || 54533 <= code && code <= 54559 || 54561 <= code && code <= 54587 || 54589 <= code && code <= 54615 || 54617 <= code && code <= 54643 || 54645 <= code && code <= 54671 || 54673 <= code && code <= 54699 || 54701 <= code && code <= 54727 || 54729 <= code && code <= 54755 || 54757 <= code && code <= 54783 || 54785 <= code && code <= 54811 || 54813 <= code && code <= 54839 || 54841 <= code && code <= 54867 || 54869 <= code && code <= 54895 || 54897 <= code && code <= 54923 || 54925 <= code && code <= 54951 || 54953 <= code && code <= 54979 || 54981 <= code && code <= 55007 || 55009 <= code && code <= 55035 || 55037 <= code && code <= 55063 || 55065 <= code && code <= 55091 || 55093 <= code && code <= 55119 || 55121 <= code && code <= 55147 || 55149 <= code && code <= 55175 || 55177 <= code && code <= 55203) {
          return LVT;
        }
        if (9757 == code || 9977 == code || 9994 <= code && code <= 9997 || 127877 == code || 127938 <= code && code <= 127940 || 127943 == code || 127946 <= code && code <= 127948 || 128066 <= code && code <= 128067 || 128070 <= code && code <= 128080 || 128110 == code || 128112 <= code && code <= 128120 || 128124 == code || 128129 <= code && code <= 128131 || 128133 <= code && code <= 128135 || 128170 == code || 128372 <= code && code <= 128373 || 128378 == code || 128400 == code || 128405 <= code && code <= 128406 || 128581 <= code && code <= 128583 || 128587 <= code && code <= 128591 || 128675 == code || 128692 <= code && code <= 128694 || 128704 == code || 128716 == code || 129304 <= code && code <= 129308 || 129310 <= code && code <= 129311 || 129318 == code || 129328 <= code && code <= 129337 || 129341 <= code && code <= 129342 || 129489 <= code && code <= 129501) {
          return E_Base;
        }
        if (127995 <= code && code <= 127999) {
          return E_Modifier;
        }
        if (8205 == code) {
          return ZWJ;
        }
        if (9792 == code || 9794 == code || 9877 <= code && code <= 9878 || 9992 == code || 10084 == code || 127752 == code || 127806 == code || 127859 == code || 127891 == code || 127908 == code || 127912 == code || 127979 == code || 127981 == code || 128139 == code || 128187 <= code && code <= 128188 || 128295 == code || 128300 == code || 128488 == code || 128640 == code || 128658 == code) {
          return Glue_After_Zwj;
        }
        if (128102 <= code && code <= 128105) {
          return E_Base_GAZ;
        }
        return Other;
      }
      return this;
    }
    if (typeof module2 != "undefined" && module2.exports) {
      module2.exports = GraphemeSplitter2;
    }
  }
});

// node_modules/earcut/src/earcut.js
var require_earcut = __commonJS({
  "node_modules/earcut/src/earcut.js"(exports2, module2) {
    "use strict";
    module2.exports = earcut2;
    module2.exports.default = earcut2;
    function earcut2(data, holeIndices, dim) {
      dim = dim || 2;
      var hasHoles = holeIndices && holeIndices.length, outerLen = hasHoles ? holeIndices[0] * dim : data.length, outerNode = linkedList(data, 0, outerLen, dim, true), triangles = [];
      if (!outerNode || outerNode.next === outerNode.prev)
        return triangles;
      var minX, minY, maxX, maxY, x, y, invSize;
      if (hasHoles)
        outerNode = eliminateHoles(data, holeIndices, outerNode, dim);
      if (data.length > 80 * dim) {
        minX = maxX = data[0];
        minY = maxY = data[1];
        for (var i = dim; i < outerLen; i += dim) {
          x = data[i];
          y = data[i + 1];
          if (x < minX)
            minX = x;
          if (y < minY)
            minY = y;
          if (x > maxX)
            maxX = x;
          if (y > maxY)
            maxY = y;
        }
        invSize = Math.max(maxX - minX, maxY - minY);
        invSize = invSize !== 0 ? 32767 / invSize : 0;
      }
      earcutLinked(outerNode, triangles, dim, minX, minY, invSize, 0);
      return triangles;
    }
    function linkedList(data, start, end, dim, clockwise) {
      var i, last;
      if (clockwise === signedArea(data, start, end, dim) > 0) {
        for (i = start; i < end; i += dim)
          last = insertNode(i, data[i], data[i + 1], last);
      } else {
        for (i = end - dim; i >= start; i -= dim)
          last = insertNode(i, data[i], data[i + 1], last);
      }
      if (last && equals(last, last.next)) {
        removeNode(last);
        last = last.next;
      }
      return last;
    }
    function filterPoints(start, end) {
      if (!start)
        return start;
      if (!end)
        end = start;
      var p = start, again;
      do {
        again = false;
        if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {
          removeNode(p);
          p = end = p.prev;
          if (p === p.next)
            break;
          again = true;
        } else {
          p = p.next;
        }
      } while (again || p !== end);
      return end;
    }
    function earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {
      if (!ear)
        return;
      if (!pass && invSize)
        indexCurve(ear, minX, minY, invSize);
      var stop2 = ear, prev, next;
      while (ear.prev !== ear.next) {
        prev = ear.prev;
        next = ear.next;
        if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {
          triangles.push(prev.i / dim | 0);
          triangles.push(ear.i / dim | 0);
          triangles.push(next.i / dim | 0);
          removeNode(ear);
          ear = next.next;
          stop2 = next.next;
          continue;
        }
        ear = next;
        if (ear === stop2) {
          if (!pass) {
            earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1);
          } else if (pass === 1) {
            ear = cureLocalIntersections(filterPoints(ear), triangles, dim);
            earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);
          } else if (pass === 2) {
            splitEarcut(ear, triangles, dim, minX, minY, invSize);
          }
          break;
        }
      }
    }
    function isEar(ear) {
      var a3 = ear.prev, b = ear, c = ear.next;
      if (area(a3, b, c) >= 0)
        return false;
      var ax = a3.x, bx = b.x, cx = c.x, ay = a3.y, by = b.y, cy = c.y;
      var x0 = ax < bx ? ax < cx ? ax : cx : bx < cx ? bx : cx, y0 = ay < by ? ay < cy ? ay : cy : by < cy ? by : cy, x1 = ax > bx ? ax > cx ? ax : cx : bx > cx ? bx : cx, y1 = ay > by ? ay > cy ? ay : cy : by > cy ? by : cy;
      var p = c.next;
      while (p !== a3) {
        if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
          return false;
        p = p.next;
      }
      return true;
    }
    function isEarHashed(ear, minX, minY, invSize) {
      var a3 = ear.prev, b = ear, c = ear.next;
      if (area(a3, b, c) >= 0)
        return false;
      var ax = a3.x, bx = b.x, cx = c.x, ay = a3.y, by = b.y, cy = c.y;
      var x0 = ax < bx ? ax < cx ? ax : cx : bx < cx ? bx : cx, y0 = ay < by ? ay < cy ? ay : cy : by < cy ? by : cy, x1 = ax > bx ? ax > cx ? ax : cx : bx > cx ? bx : cx, y1 = ay > by ? ay > cy ? ay : cy : by > cy ? by : cy;
      var minZ = zOrder(x0, y0, minX, minY, invSize), maxZ = zOrder(x1, y1, minX, minY, invSize);
      var p = ear.prevZ, n = ear.nextZ;
      while (p && p.z >= minZ && n && n.z <= maxZ) {
        if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a3 && p !== c && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
          return false;
        p = p.prevZ;
        if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a3 && n !== c && pointInTriangle(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0)
          return false;
        n = n.nextZ;
      }
      while (p && p.z >= minZ) {
        if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a3 && p !== c && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0)
          return false;
        p = p.prevZ;
      }
      while (n && n.z <= maxZ) {
        if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a3 && n !== c && pointInTriangle(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0)
          return false;
        n = n.nextZ;
      }
      return true;
    }
    function cureLocalIntersections(start, triangles, dim) {
      var p = start;
      do {
        var a3 = p.prev, b = p.next.next;
        if (!equals(a3, b) && intersects(a3, p, p.next, b) && locallyInside(a3, b) && locallyInside(b, a3)) {
          triangles.push(a3.i / dim | 0);
          triangles.push(p.i / dim | 0);
          triangles.push(b.i / dim | 0);
          removeNode(p);
          removeNode(p.next);
          p = start = b;
        }
        p = p.next;
      } while (p !== start);
      return filterPoints(p);
    }
    function splitEarcut(start, triangles, dim, minX, minY, invSize) {
      var a3 = start;
      do {
        var b = a3.next.next;
        while (b !== a3.prev) {
          if (a3.i !== b.i && isValidDiagonal(a3, b)) {
            var c = splitPolygon(a3, b);
            a3 = filterPoints(a3, a3.next);
            c = filterPoints(c, c.next);
            earcutLinked(a3, triangles, dim, minX, minY, invSize, 0);
            earcutLinked(c, triangles, dim, minX, minY, invSize, 0);
            return;
          }
          b = b.next;
        }
        a3 = a3.next;
      } while (a3 !== start);
    }
    function eliminateHoles(data, holeIndices, outerNode, dim) {
      var queue = [], i, len, start, end, list;
      for (i = 0, len = holeIndices.length; i < len; i++) {
        start = holeIndices[i] * dim;
        end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
        list = linkedList(data, start, end, dim, false);
        if (list === list.next)
          list.steiner = true;
        queue.push(getLeftmost(list));
      }
      queue.sort(compareX);
      for (i = 0; i < queue.length; i++) {
        outerNode = eliminateHole(queue[i], outerNode);
      }
      return outerNode;
    }
    function compareX(a3, b) {
      return a3.x - b.x;
    }
    function eliminateHole(hole, outerNode) {
      var bridge = findHoleBridge(hole, outerNode);
      if (!bridge) {
        return outerNode;
      }
      var bridgeReverse = splitPolygon(bridge, hole);
      filterPoints(bridgeReverse, bridgeReverse.next);
      return filterPoints(bridge, bridge.next);
    }
    function findHoleBridge(hole, outerNode) {
      var p = outerNode, hx = hole.x, hy = hole.y, qx = -Infinity, m;
      do {
        if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {
          var x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);
          if (x <= hx && x > qx) {
            qx = x;
            m = p.x < p.next.x ? p : p.next;
            if (x === hx)
              return m;
          }
        }
        p = p.next;
      } while (p !== outerNode);
      if (!m)
        return null;
      var stop2 = m, mx = m.x, my = m.y, tanMin = Infinity, tan;
      p = m;
      do {
        if (hx >= p.x && p.x >= mx && hx !== p.x && pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {
          tan = Math.abs(hy - p.y) / (hx - p.x);
          if (locallyInside(p, hole) && (tan < tanMin || tan === tanMin && (p.x > m.x || p.x === m.x && sectorContainsSector(m, p)))) {
            m = p;
            tanMin = tan;
          }
        }
        p = p.next;
      } while (p !== stop2);
      return m;
    }
    function sectorContainsSector(m, p) {
      return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;
    }
    function indexCurve(start, minX, minY, invSize) {
      var p = start;
      do {
        if (p.z === 0)
          p.z = zOrder(p.x, p.y, minX, minY, invSize);
        p.prevZ = p.prev;
        p.nextZ = p.next;
        p = p.next;
      } while (p !== start);
      p.prevZ.nextZ = null;
      p.prevZ = null;
      sortLinked(p);
    }
    function sortLinked(list) {
      var i, p, q, e, tail, numMerges, pSize, qSize, inSize = 1;
      do {
        p = list;
        list = null;
        tail = null;
        numMerges = 0;
        while (p) {
          numMerges++;
          q = p;
          pSize = 0;
          for (i = 0; i < inSize; i++) {
            pSize++;
            q = q.nextZ;
            if (!q)
              break;
          }
          qSize = inSize;
          while (pSize > 0 || qSize > 0 && q) {
            if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {
              e = p;
              p = p.nextZ;
              pSize--;
            } else {
              e = q;
              q = q.nextZ;
              qSize--;
            }
            if (tail)
              tail.nextZ = e;
            else
              list = e;
            e.prevZ = tail;
            tail = e;
          }
          p = q;
        }
        tail.nextZ = null;
        inSize *= 2;
      } while (numMerges > 1);
      return list;
    }
    function zOrder(x, y, minX, minY, invSize) {
      x = (x - minX) * invSize | 0;
      y = (y - minY) * invSize | 0;
      x = (x | x << 8) & 16711935;
      x = (x | x << 4) & 252645135;
      x = (x | x << 2) & 858993459;
      x = (x | x << 1) & 1431655765;
      y = (y | y << 8) & 16711935;
      y = (y | y << 4) & 252645135;
      y = (y | y << 2) & 858993459;
      y = (y | y << 1) & 1431655765;
      return x | y << 1;
    }
    function getLeftmost(start) {
      var p = start, leftmost = start;
      do {
        if (p.x < leftmost.x || p.x === leftmost.x && p.y < leftmost.y)
          leftmost = p;
        p = p.next;
      } while (p !== start);
      return leftmost;
    }
    function pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {
      return (cx - px) * (ay - py) >= (ax - px) * (cy - py) && (ax - px) * (by - py) >= (bx - px) * (ay - py) && (bx - px) * (cy - py) >= (cx - px) * (by - py);
    }
    function isValidDiagonal(a3, b) {
      return a3.next.i !== b.i && a3.prev.i !== b.i && !intersectsPolygon(a3, b) && (locallyInside(a3, b) && locallyInside(b, a3) && middleInside(a3, b) && (area(a3.prev, a3, b.prev) || area(a3, b.prev, b)) || equals(a3, b) && area(a3.prev, a3, a3.next) > 0 && area(b.prev, b, b.next) > 0);
    }
    function area(p, q, r) {
      return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
    }
    function equals(p1, p2) {
      return p1.x === p2.x && p1.y === p2.y;
    }
    function intersects(p1, q12, p2, q22) {
      var o1 = sign2(area(p1, q12, p2));
      var o2 = sign2(area(p1, q12, q22));
      var o3 = sign2(area(p2, q22, p1));
      var o4 = sign2(area(p2, q22, q12));
      if (o1 !== o2 && o3 !== o4)
        return true;
      if (o1 === 0 && onSegment(p1, p2, q12))
        return true;
      if (o2 === 0 && onSegment(p1, q22, q12))
        return true;
      if (o3 === 0 && onSegment(p2, p1, q22))
        return true;
      if (o4 === 0 && onSegment(p2, q12, q22))
        return true;
      return false;
    }
    function onSegment(p, q, r) {
      return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
    }
    function sign2(num) {
      return num > 0 ? 1 : num < 0 ? -1 : 0;
    }
    function intersectsPolygon(a3, b) {
      var p = a3;
      do {
        if (p.i !== a3.i && p.next.i !== a3.i && p.i !== b.i && p.next.i !== b.i && intersects(p, p.next, a3, b))
          return true;
        p = p.next;
      } while (p !== a3);
      return false;
    }
    function locallyInside(a3, b) {
      return area(a3.prev, a3, a3.next) < 0 ? area(a3, b, a3.next) >= 0 && area(a3, a3.prev, b) >= 0 : area(a3, b, a3.prev) < 0 || area(a3, a3.next, b) < 0;
    }
    function middleInside(a3, b) {
      var p = a3, inside = false, px = (a3.x + b.x) / 2, py = (a3.y + b.y) / 2;
      do {
        if (p.y > py !== p.next.y > py && p.next.y !== p.y && px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x)
          inside = !inside;
        p = p.next;
      } while (p !== a3);
      return inside;
    }
    function splitPolygon(a3, b) {
      var a22 = new Node6(a3.i, a3.x, a3.y), b2 = new Node6(b.i, b.x, b.y), an = a3.next, bp = b.prev;
      a3.next = b;
      b.prev = a3;
      a22.next = an;
      an.prev = a22;
      b2.next = a22;
      a22.prev = b2;
      bp.next = b2;
      b2.prev = bp;
      return b2;
    }
    function insertNode(i, x, y, last) {
      var p = new Node6(i, x, y);
      if (!last) {
        p.prev = p;
        p.next = p;
      } else {
        p.next = last.next;
        p.prev = last;
        last.next.prev = p;
        last.next = p;
      }
      return p;
    }
    function removeNode(p) {
      p.next.prev = p.prev;
      p.prev.next = p.next;
      if (p.prevZ)
        p.prevZ.nextZ = p.nextZ;
      if (p.nextZ)
        p.nextZ.prevZ = p.prevZ;
    }
    function Node6(i, x, y) {
      this.i = i;
      this.x = x;
      this.y = y;
      this.prev = null;
      this.next = null;
      this.z = 0;
      this.prevZ = null;
      this.nextZ = null;
      this.steiner = false;
    }
    earcut2.deviation = function(data, holeIndices, dim, triangles) {
      var hasHoles = holeIndices && holeIndices.length;
      var outerLen = hasHoles ? holeIndices[0] * dim : data.length;
      var polygonArea = Math.abs(signedArea(data, 0, outerLen, dim));
      if (hasHoles) {
        for (var i = 0, len = holeIndices.length; i < len; i++) {
          var start = holeIndices[i] * dim;
          var end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
          polygonArea -= Math.abs(signedArea(data, start, end, dim));
        }
      }
      var trianglesArea = 0;
      for (i = 0; i < triangles.length; i += 3) {
        var a3 = triangles[i] * dim;
        var b = triangles[i + 1] * dim;
        var c = triangles[i + 2] * dim;
        trianglesArea += Math.abs(
          (data[a3] - data[c]) * (data[b + 1] - data[a3 + 1]) - (data[a3] - data[b]) * (data[c + 1] - data[a3 + 1])
        );
      }
      return polygonArea === 0 && trianglesArea === 0 ? 0 : Math.abs((trianglesArea - polygonArea) / polygonArea);
    };
    function signedArea(data, start, end, dim) {
      var sum = 0;
      for (var i = start, j = end - dim; i < end; i += dim) {
        sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);
        j = i;
      }
      return sum;
    }
    earcut2.flatten = function(data) {
      var dim = data[0][0].length, result = { vertices: [], holes: [], dimensions: dim }, holeIndex = 0;
      for (var i = 0; i < data.length; i++) {
        for (var j = 0; j < data[i].length; j++) {
          for (var d = 0; d < dim; d++)
            result.vertices.push(data[i][j][d]);
        }
        if (i > 0) {
          holeIndex += data[i - 1].length;
          result.holes.push(holeIndex);
        }
      }
      return result;
    };
  }
});

// node_modules/kdbush/kdbush.js
var require_kdbush = __commonJS({
  "node_modules/kdbush/kdbush.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : global2.KDBush = factory();
    })(exports2, function() {
      "use strict";
      function sortKD(ids, coords, nodeSize, left, right, depth) {
        if (right - left <= nodeSize) {
          return;
        }
        var m = left + right >> 1;
        select(ids, coords, m, left, right, depth % 2);
        sortKD(ids, coords, nodeSize, left, m - 1, depth + 1);
        sortKD(ids, coords, nodeSize, m + 1, right, depth + 1);
      }
      function select(ids, coords, k, left, right, inc) {
        while (right > left) {
          if (right - left > 600) {
            var n = right - left + 1;
            var m = k - left + 1;
            var z = Math.log(n);
            var s = 0.5 * Math.exp(2 * z / 3);
            var sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
            var newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
            var newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
            select(ids, coords, k, newLeft, newRight, inc);
          }
          var t = coords[2 * k + inc];
          var i = left;
          var j = right;
          swapItem(ids, coords, left, k);
          if (coords[2 * right + inc] > t) {
            swapItem(ids, coords, left, right);
          }
          while (i < j) {
            swapItem(ids, coords, i, j);
            i++;
            j--;
            while (coords[2 * i + inc] < t) {
              i++;
            }
            while (coords[2 * j + inc] > t) {
              j--;
            }
          }
          if (coords[2 * left + inc] === t) {
            swapItem(ids, coords, left, j);
          } else {
            j++;
            swapItem(ids, coords, j, right);
          }
          if (j <= k) {
            left = j + 1;
          }
          if (k <= j) {
            right = j - 1;
          }
        }
      }
      function swapItem(ids, coords, i, j) {
        swap3(ids, i, j);
        swap3(coords, 2 * i, 2 * j);
        swap3(coords, 2 * i + 1, 2 * j + 1);
      }
      function swap3(arr, i, j) {
        var tmp2 = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp2;
      }
      function range(ids, coords, minX, minY, maxX, maxY, nodeSize) {
        var stack = [0, ids.length - 1, 0];
        var result = [];
        var x, y;
        while (stack.length) {
          var axis = stack.pop();
          var right = stack.pop();
          var left = stack.pop();
          if (right - left <= nodeSize) {
            for (var i = left; i <= right; i++) {
              x = coords[2 * i];
              y = coords[2 * i + 1];
              if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
                result.push(ids[i]);
              }
            }
            continue;
          }
          var m = Math.floor((left + right) / 2);
          x = coords[2 * m];
          y = coords[2 * m + 1];
          if (x >= minX && x <= maxX && y >= minY && y <= maxY) {
            result.push(ids[m]);
          }
          var nextAxis = (axis + 1) % 2;
          if (axis === 0 ? minX <= x : minY <= y) {
            stack.push(left);
            stack.push(m - 1);
            stack.push(nextAxis);
          }
          if (axis === 0 ? maxX >= x : maxY >= y) {
            stack.push(m + 1);
            stack.push(right);
            stack.push(nextAxis);
          }
        }
        return result;
      }
      function within(ids, coords, qx, qy, r, nodeSize) {
        var stack = [0, ids.length - 1, 0];
        var result = [];
        var r2 = r * r;
        while (stack.length) {
          var axis = stack.pop();
          var right = stack.pop();
          var left = stack.pop();
          if (right - left <= nodeSize) {
            for (var i = left; i <= right; i++) {
              if (sqDist(coords[2 * i], coords[2 * i + 1], qx, qy) <= r2) {
                result.push(ids[i]);
              }
            }
            continue;
          }
          var m = Math.floor((left + right) / 2);
          var x = coords[2 * m];
          var y = coords[2 * m + 1];
          if (sqDist(x, y, qx, qy) <= r2) {
            result.push(ids[m]);
          }
          var nextAxis = (axis + 1) % 2;
          if (axis === 0 ? qx - r <= x : qy - r <= y) {
            stack.push(left);
            stack.push(m - 1);
            stack.push(nextAxis);
          }
          if (axis === 0 ? qx + r >= x : qy + r >= y) {
            stack.push(m + 1);
            stack.push(right);
            stack.push(nextAxis);
          }
        }
        return result;
      }
      function sqDist(ax, ay, bx, by) {
        var dx = ax - bx;
        var dy = ay - by;
        return dx * dx + dy * dy;
      }
      var defaultGetX = function(p) {
        return p[0];
      };
      var defaultGetY = function(p) {
        return p[1];
      };
      var KDBush2 = function KDBush3(points, getX2, getY2, nodeSize, ArrayType) {
        if (getX2 === void 0)
          getX2 = defaultGetX;
        if (getY2 === void 0)
          getY2 = defaultGetY;
        if (nodeSize === void 0)
          nodeSize = 64;
        if (ArrayType === void 0)
          ArrayType = Float64Array;
        this.nodeSize = nodeSize;
        this.points = points;
        var IndexArrayType = points.length < 65536 ? Uint16Array : Uint32Array;
        var ids = this.ids = new IndexArrayType(points.length);
        var coords = this.coords = new ArrayType(points.length * 2);
        for (var i = 0; i < points.length; i++) {
          ids[i] = i;
          coords[2 * i] = getX2(points[i]);
          coords[2 * i + 1] = getY2(points[i]);
        }
        sortKD(ids, coords, nodeSize, 0, ids.length - 1, 0);
      };
      KDBush2.prototype.range = function range$1(minX, minY, maxX, maxY) {
        return range(this.ids, this.coords, minX, minY, maxX, maxY, this.nodeSize);
      };
      KDBush2.prototype.within = function within$1(x, y, r) {
        return within(this.ids, this.coords, x, y, r, this.nodeSize);
      };
      return KDBush2;
    });
  }
});

// node_modules/rbush/rbush.js
var require_rbush = __commonJS({
  "node_modules/rbush/rbush.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? module2.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = global2 || self, global2.RBush = factory());
    })(exports2, function() {
      "use strict";
      function quickselect(arr, k, left, right, compare) {
        quickselectStep(arr, k, left || 0, right || arr.length - 1, compare || defaultCompare);
      }
      function quickselectStep(arr, k, left, right, compare) {
        while (right > left) {
          if (right - left > 600) {
            var n = right - left + 1;
            var m = k - left + 1;
            var z = Math.log(n);
            var s = 0.5 * Math.exp(2 * z / 3);
            var sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
            var newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
            var newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
            quickselectStep(arr, k, newLeft, newRight, compare);
          }
          var t = arr[k];
          var i = left;
          var j = right;
          swap3(arr, left, k);
          if (compare(arr[right], t) > 0) {
            swap3(arr, left, right);
          }
          while (i < j) {
            swap3(arr, i, j);
            i++;
            j--;
            while (compare(arr[i], t) < 0) {
              i++;
            }
            while (compare(arr[j], t) > 0) {
              j--;
            }
          }
          if (compare(arr[left], t) === 0) {
            swap3(arr, left, j);
          } else {
            j++;
            swap3(arr, j, right);
          }
          if (j <= k) {
            left = j + 1;
          }
          if (k <= j) {
            right = j - 1;
          }
        }
      }
      function swap3(arr, i, j) {
        var tmp2 = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp2;
      }
      function defaultCompare(a3, b) {
        return a3 < b ? -1 : a3 > b ? 1 : 0;
      }
      var RBush2 = function RBush3(maxEntries) {
        if (maxEntries === void 0)
          maxEntries = 9;
        this._maxEntries = Math.max(4, maxEntries);
        this._minEntries = Math.max(2, Math.ceil(this._maxEntries * 0.4));
        this.clear();
      };
      RBush2.prototype.all = function all() {
        return this._all(this.data, []);
      };
      RBush2.prototype.search = function search(bbox) {
        var node = this.data;
        var result = [];
        if (!intersects(bbox, node)) {
          return result;
        }
        var toBBox = this.toBBox;
        var nodesToSearch = [];
        while (node) {
          for (var i = 0; i < node.children.length; i++) {
            var child = node.children[i];
            var childBBox = node.leaf ? toBBox(child) : child;
            if (intersects(bbox, childBBox)) {
              if (node.leaf) {
                result.push(child);
              } else if (contains2(bbox, childBBox)) {
                this._all(child, result);
              } else {
                nodesToSearch.push(child);
              }
            }
          }
          node = nodesToSearch.pop();
        }
        return result;
      };
      RBush2.prototype.collides = function collides(bbox) {
        var node = this.data;
        if (!intersects(bbox, node)) {
          return false;
        }
        var nodesToSearch = [];
        while (node) {
          for (var i = 0; i < node.children.length; i++) {
            var child = node.children[i];
            var childBBox = node.leaf ? this.toBBox(child) : child;
            if (intersects(bbox, childBBox)) {
              if (node.leaf || contains2(bbox, childBBox)) {
                return true;
              }
              nodesToSearch.push(child);
            }
          }
          node = nodesToSearch.pop();
        }
        return false;
      };
      RBush2.prototype.load = function load5(data) {
        if (!(data && data.length)) {
          return this;
        }
        if (data.length < this._minEntries) {
          for (var i = 0; i < data.length; i++) {
            this.insert(data[i]);
          }
          return this;
        }
        var node = this._build(data.slice(), 0, data.length - 1, 0);
        if (!this.data.children.length) {
          this.data = node;
        } else if (this.data.height === node.height) {
          this._splitRoot(this.data, node);
        } else {
          if (this.data.height < node.height) {
            var tmpNode = this.data;
            this.data = node;
            node = tmpNode;
          }
          this._insert(node, this.data.height - node.height - 1, true);
        }
        return this;
      };
      RBush2.prototype.insert = function insert(item) {
        if (item) {
          this._insert(item, this.data.height - 1);
        }
        return this;
      };
      RBush2.prototype.clear = function clear2() {
        this.data = createNode([]);
        return this;
      };
      RBush2.prototype.remove = function remove3(item, equalsFn) {
        if (!item) {
          return this;
        }
        var node = this.data;
        var bbox = this.toBBox(item);
        var path = [];
        var indexes = [];
        var i, parent, goingUp;
        while (node || path.length) {
          if (!node) {
            node = path.pop();
            parent = path[path.length - 1];
            i = indexes.pop();
            goingUp = true;
          }
          if (node.leaf) {
            var index = findItem(item, node.children, equalsFn);
            if (index !== -1) {
              node.children.splice(index, 1);
              path.push(node);
              this._condense(path);
              return this;
            }
          }
          if (!goingUp && !node.leaf && contains2(node, bbox)) {
            path.push(node);
            indexes.push(i);
            i = 0;
            parent = node;
            node = node.children[0];
          } else if (parent) {
            i++;
            node = parent.children[i];
            goingUp = false;
          } else {
            node = null;
          }
        }
        return this;
      };
      RBush2.prototype.toBBox = function toBBox(item) {
        return item;
      };
      RBush2.prototype.compareMinX = function compareMinX(a3, b) {
        return a3.minX - b.minX;
      };
      RBush2.prototype.compareMinY = function compareMinY(a3, b) {
        return a3.minY - b.minY;
      };
      RBush2.prototype.toJSON = function toJSON() {
        return this.data;
      };
      RBush2.prototype.fromJSON = function fromJSON(data) {
        this.data = data;
        return this;
      };
      RBush2.prototype._all = function _all(node, result) {
        var nodesToSearch = [];
        while (node) {
          if (node.leaf) {
            result.push.apply(result, node.children);
          } else {
            nodesToSearch.push.apply(nodesToSearch, node.children);
          }
          node = nodesToSearch.pop();
        }
        return result;
      };
      RBush2.prototype._build = function _build(items, left, right, height) {
        var N = right - left + 1;
        var M = this._maxEntries;
        var node;
        if (N <= M) {
          node = createNode(items.slice(left, right + 1));
          calcBBox(node, this.toBBox);
          return node;
        }
        if (!height) {
          height = Math.ceil(Math.log(N) / Math.log(M));
          M = Math.ceil(N / Math.pow(M, height - 1));
        }
        node = createNode([]);
        node.leaf = false;
        node.height = height;
        var N2 = Math.ceil(N / M);
        var N1 = N2 * Math.ceil(Math.sqrt(M));
        multiSelect(items, left, right, N1, this.compareMinX);
        for (var i = left; i <= right; i += N1) {
          var right2 = Math.min(i + N1 - 1, right);
          multiSelect(items, i, right2, N2, this.compareMinY);
          for (var j = i; j <= right2; j += N2) {
            var right3 = Math.min(j + N2 - 1, right2);
            node.children.push(this._build(items, j, right3, height - 1));
          }
        }
        calcBBox(node, this.toBBox);
        return node;
      };
      RBush2.prototype._chooseSubtree = function _chooseSubtree(bbox, node, level, path) {
        while (true) {
          path.push(node);
          if (node.leaf || path.length - 1 === level) {
            break;
          }
          var minArea = Infinity;
          var minEnlargement = Infinity;
          var targetNode = void 0;
          for (var i = 0; i < node.children.length; i++) {
            var child = node.children[i];
            var area = bboxArea(child);
            var enlargement = enlargedArea(bbox, child) - area;
            if (enlargement < minEnlargement) {
              minEnlargement = enlargement;
              minArea = area < minArea ? area : minArea;
              targetNode = child;
            } else if (enlargement === minEnlargement) {
              if (area < minArea) {
                minArea = area;
                targetNode = child;
              }
            }
          }
          node = targetNode || node.children[0];
        }
        return node;
      };
      RBush2.prototype._insert = function _insert(item, level, isNode) {
        var bbox = isNode ? item : this.toBBox(item);
        var insertPath = [];
        var node = this._chooseSubtree(bbox, this.data, level, insertPath);
        node.children.push(item);
        extend(node, bbox);
        while (level >= 0) {
          if (insertPath[level].children.length > this._maxEntries) {
            this._split(insertPath, level);
            level--;
          } else {
            break;
          }
        }
        this._adjustParentBBoxes(bbox, insertPath, level);
      };
      RBush2.prototype._split = function _split(insertPath, level) {
        var node = insertPath[level];
        var M = node.children.length;
        var m = this._minEntries;
        this._chooseSplitAxis(node, m, M);
        var splitIndex = this._chooseSplitIndex(node, m, M);
        var newNode = createNode(node.children.splice(splitIndex, node.children.length - splitIndex));
        newNode.height = node.height;
        newNode.leaf = node.leaf;
        calcBBox(node, this.toBBox);
        calcBBox(newNode, this.toBBox);
        if (level) {
          insertPath[level - 1].children.push(newNode);
        } else {
          this._splitRoot(node, newNode);
        }
      };
      RBush2.prototype._splitRoot = function _splitRoot(node, newNode) {
        this.data = createNode([node, newNode]);
        this.data.height = node.height + 1;
        this.data.leaf = false;
        calcBBox(this.data, this.toBBox);
      };
      RBush2.prototype._chooseSplitIndex = function _chooseSplitIndex(node, m, M) {
        var index;
        var minOverlap = Infinity;
        var minArea = Infinity;
        for (var i = m; i <= M - m; i++) {
          var bbox1 = distBBox(node, 0, i, this.toBBox);
          var bbox2 = distBBox(node, i, M, this.toBBox);
          var overlap = intersectionArea(bbox1, bbox2);
          var area = bboxArea(bbox1) + bboxArea(bbox2);
          if (overlap < minOverlap) {
            minOverlap = overlap;
            index = i;
            minArea = area < minArea ? area : minArea;
          } else if (overlap === minOverlap) {
            if (area < minArea) {
              minArea = area;
              index = i;
            }
          }
        }
        return index || M - m;
      };
      RBush2.prototype._chooseSplitAxis = function _chooseSplitAxis(node, m, M) {
        var compareMinX = node.leaf ? this.compareMinX : compareNodeMinX;
        var compareMinY = node.leaf ? this.compareMinY : compareNodeMinY;
        var xMargin = this._allDistMargin(node, m, M, compareMinX);
        var yMargin = this._allDistMargin(node, m, M, compareMinY);
        if (xMargin < yMargin) {
          node.children.sort(compareMinX);
        }
      };
      RBush2.prototype._allDistMargin = function _allDistMargin(node, m, M, compare) {
        node.children.sort(compare);
        var toBBox = this.toBBox;
        var leftBBox = distBBox(node, 0, m, toBBox);
        var rightBBox = distBBox(node, M - m, M, toBBox);
        var margin = bboxMargin(leftBBox) + bboxMargin(rightBBox);
        for (var i = m; i < M - m; i++) {
          var child = node.children[i];
          extend(leftBBox, node.leaf ? toBBox(child) : child);
          margin += bboxMargin(leftBBox);
        }
        for (var i$1 = M - m - 1; i$1 >= m; i$1--) {
          var child$1 = node.children[i$1];
          extend(rightBBox, node.leaf ? toBBox(child$1) : child$1);
          margin += bboxMargin(rightBBox);
        }
        return margin;
      };
      RBush2.prototype._adjustParentBBoxes = function _adjustParentBBoxes(bbox, path, level) {
        for (var i = level; i >= 0; i--) {
          extend(path[i], bbox);
        }
      };
      RBush2.prototype._condense = function _condense(path) {
        for (var i = path.length - 1, siblings = void 0; i >= 0; i--) {
          if (path[i].children.length === 0) {
            if (i > 0) {
              siblings = path[i - 1].children;
              siblings.splice(siblings.indexOf(path[i]), 1);
            } else {
              this.clear();
            }
          } else {
            calcBBox(path[i], this.toBBox);
          }
        }
      };
      function findItem(item, items, equalsFn) {
        if (!equalsFn) {
          return items.indexOf(item);
        }
        for (var i = 0; i < items.length; i++) {
          if (equalsFn(item, items[i])) {
            return i;
          }
        }
        return -1;
      }
      function calcBBox(node, toBBox) {
        distBBox(node, 0, node.children.length, toBBox, node);
      }
      function distBBox(node, k, p, toBBox, destNode) {
        if (!destNode) {
          destNode = createNode(null);
        }
        destNode.minX = Infinity;
        destNode.minY = Infinity;
        destNode.maxX = -Infinity;
        destNode.maxY = -Infinity;
        for (var i = k; i < p; i++) {
          var child = node.children[i];
          extend(destNode, node.leaf ? toBBox(child) : child);
        }
        return destNode;
      }
      function extend(a3, b) {
        a3.minX = Math.min(a3.minX, b.minX);
        a3.minY = Math.min(a3.minY, b.minY);
        a3.maxX = Math.max(a3.maxX, b.maxX);
        a3.maxY = Math.max(a3.maxY, b.maxY);
        return a3;
      }
      function compareNodeMinX(a3, b) {
        return a3.minX - b.minX;
      }
      function compareNodeMinY(a3, b) {
        return a3.minY - b.minY;
      }
      function bboxArea(a3) {
        return (a3.maxX - a3.minX) * (a3.maxY - a3.minY);
      }
      function bboxMargin(a3) {
        return a3.maxX - a3.minX + (a3.maxY - a3.minY);
      }
      function enlargedArea(a3, b) {
        return (Math.max(b.maxX, a3.maxX) - Math.min(b.minX, a3.minX)) * (Math.max(b.maxY, a3.maxY) - Math.min(b.minY, a3.minY));
      }
      function intersectionArea(a3, b) {
        var minX = Math.max(a3.minX, b.minX);
        var minY = Math.max(a3.minY, b.minY);
        var maxX = Math.min(a3.maxX, b.maxX);
        var maxY = Math.min(a3.maxY, b.maxY);
        return Math.max(0, maxX - minX) * Math.max(0, maxY - minY);
      }
      function contains2(a3, b) {
        return a3.minX <= b.minX && a3.minY <= b.minY && b.maxX <= a3.maxX && b.maxY <= a3.maxY;
      }
      function intersects(a3, b) {
        return b.minX <= a3.maxX && b.minY <= a3.maxY && b.maxX >= a3.minX && b.maxY >= a3.minY;
      }
      function createNode(children) {
        return {
          children,
          height: 1,
          leaf: true,
          minX: Infinity,
          minY: Infinity,
          maxX: -Infinity,
          maxY: -Infinity
        };
      }
      function multiSelect(arr, left, right, n, compare) {
        var stack = [left, right];
        while (stack.length) {
          right = stack.pop();
          left = stack.pop();
          if (right - left <= n) {
            continue;
          }
          var mid = left + Math.ceil((right - left) / n / 2) * n;
          quickselect(arr, mid, left, right, compare);
          stack.push(left, mid, mid, right);
        }
      }
      return RBush2;
    });
  }
});

// node_modules/topojson-client/dist/topojson-client.js
var require_topojson_client = __commonJS({
  "node_modules/topojson-client/dist/topojson-client.js"(exports2, module2) {
    (function(global2, factory) {
      typeof exports2 === "object" && typeof module2 !== "undefined" ? factory(exports2) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = global2 || self, factory(global2.topojson = global2.topojson || {}));
    })(exports2, function(exports3) {
      "use strict";
      function identity(x) {
        return x;
      }
      function transform3(transform4) {
        if (transform4 == null)
          return identity;
        var x0, y0, kx = transform4.scale[0], ky = transform4.scale[1], dx = transform4.translate[0], dy = transform4.translate[1];
        return function(input, i) {
          if (!i)
            x0 = y0 = 0;
          var j = 2, n = input.length, output = new Array(n);
          output[0] = (x0 += input[0]) * kx + dx;
          output[1] = (y0 += input[1]) * ky + dy;
          while (j < n)
            output[j] = input[j], ++j;
          return output;
        };
      }
      function bbox(topology) {
        var t = transform3(topology.transform), key, x0 = Infinity, y0 = x0, x1 = -x0, y1 = -x0;
        function bboxPoint(p) {
          p = t(p);
          if (p[0] < x0)
            x0 = p[0];
          if (p[0] > x1)
            x1 = p[0];
          if (p[1] < y0)
            y0 = p[1];
          if (p[1] > y1)
            y1 = p[1];
        }
        function bboxGeometry(o) {
          switch (o.type) {
            case "GeometryCollection":
              o.geometries.forEach(bboxGeometry);
              break;
            case "Point":
              bboxPoint(o.coordinates);
              break;
            case "MultiPoint":
              o.coordinates.forEach(bboxPoint);
              break;
          }
        }
        topology.arcs.forEach(function(arc) {
          var i = -1, n = arc.length, p;
          while (++i < n) {
            p = t(arc[i], i);
            if (p[0] < x0)
              x0 = p[0];
            if (p[0] > x1)
              x1 = p[0];
            if (p[1] < y0)
              y0 = p[1];
            if (p[1] > y1)
              y1 = p[1];
          }
        });
        for (key in topology.objects) {
          bboxGeometry(topology.objects[key]);
        }
        return [x0, y0, x1, y1];
      }
      function reverse(array, n) {
        var t, j = array.length, i = j - n;
        while (i < --j)
          t = array[i], array[i++] = array[j], array[j] = t;
      }
      function feature2(topology, o) {
        if (typeof o === "string")
          o = topology.objects[o];
        return o.type === "GeometryCollection" ? { type: "FeatureCollection", features: o.geometries.map(function(o2) {
          return feature$1(topology, o2);
        }) } : feature$1(topology, o);
      }
      function feature$1(topology, o) {
        var id = o.id, bbox2 = o.bbox, properties = o.properties == null ? {} : o.properties, geometry = object(topology, o);
        return id == null && bbox2 == null ? { type: "Feature", properties, geometry } : bbox2 == null ? { type: "Feature", id, properties, geometry } : { type: "Feature", id, bbox: bbox2, properties, geometry };
      }
      function object(topology, o) {
        var transformPoint2 = transform3(topology.transform), arcs = topology.arcs;
        function arc(i, points) {
          if (points.length)
            points.pop();
          for (var a3 = arcs[i < 0 ? ~i : i], k = 0, n = a3.length; k < n; ++k) {
            points.push(transformPoint2(a3[k], k));
          }
          if (i < 0)
            reverse(points, n);
        }
        function point(p) {
          return transformPoint2(p);
        }
        function line(arcs2) {
          var points = [];
          for (var i = 0, n = arcs2.length; i < n; ++i)
            arc(arcs2[i], points);
          if (points.length < 2)
            points.push(points[0]);
          return points;
        }
        function ring(arcs2) {
          var points = line(arcs2);
          while (points.length < 4)
            points.push(points[0]);
          return points;
        }
        function polygon(arcs2) {
          return arcs2.map(ring);
        }
        function geometry(o2) {
          var type = o2.type, coordinates;
          switch (type) {
            case "GeometryCollection":
              return { type, geometries: o2.geometries.map(geometry) };
            case "Point":
              coordinates = point(o2.coordinates);
              break;
            case "MultiPoint":
              coordinates = o2.coordinates.map(point);
              break;
            case "LineString":
              coordinates = line(o2.arcs);
              break;
            case "MultiLineString":
              coordinates = o2.arcs.map(line);
              break;
            case "Polygon":
              coordinates = polygon(o2.arcs);
              break;
            case "MultiPolygon":
              coordinates = o2.arcs.map(polygon);
              break;
            default:
              return null;
          }
          return { type, coordinates };
        }
        return geometry(o);
      }
      function stitch(topology, arcs) {
        var stitchedArcs = {}, fragmentByStart = {}, fragmentByEnd = {}, fragments = [], emptyIndex = -1;
        arcs.forEach(function(i, j) {
          var arc = topology.arcs[i < 0 ? ~i : i], t;
          if (arc.length < 3 && !arc[1][0] && !arc[1][1]) {
            t = arcs[++emptyIndex], arcs[emptyIndex] = i, arcs[j] = t;
          }
        });
        arcs.forEach(function(i) {
          var e = ends(i), start = e[0], end = e[1], f, g;
          if (f = fragmentByEnd[start]) {
            delete fragmentByEnd[f.end];
            f.push(i);
            f.end = end;
            if (g = fragmentByStart[end]) {
              delete fragmentByStart[g.start];
              var fg = g === f ? f : f.concat(g);
              fragmentByStart[fg.start = f.start] = fragmentByEnd[fg.end = g.end] = fg;
            } else {
              fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
            }
          } else if (f = fragmentByStart[end]) {
            delete fragmentByStart[f.start];
            f.unshift(i);
            f.start = start;
            if (g = fragmentByEnd[start]) {
              delete fragmentByEnd[g.end];
              var gf = g === f ? f : g.concat(f);
              fragmentByStart[gf.start = g.start] = fragmentByEnd[gf.end = f.end] = gf;
            } else {
              fragmentByStart[f.start] = fragmentByEnd[f.end] = f;
            }
          } else {
            f = [i];
            fragmentByStart[f.start = start] = fragmentByEnd[f.end = end] = f;
          }
        });
        function ends(i) {
          var arc = topology.arcs[i < 0 ? ~i : i], p0 = arc[0], p1;
          if (topology.transform)
            p1 = [0, 0], arc.forEach(function(dp) {
              p1[0] += dp[0], p1[1] += dp[1];
            });
          else
            p1 = arc[arc.length - 1];
          return i < 0 ? [p1, p0] : [p0, p1];
        }
        function flush(fragmentByEnd2, fragmentByStart2) {
          for (var k in fragmentByEnd2) {
            var f = fragmentByEnd2[k];
            delete fragmentByStart2[f.start];
            delete f.start;
            delete f.end;
            f.forEach(function(i) {
              stitchedArcs[i < 0 ? ~i : i] = 1;
            });
            fragments.push(f);
          }
        }
        flush(fragmentByEnd, fragmentByStart);
        flush(fragmentByStart, fragmentByEnd);
        arcs.forEach(function(i) {
          if (!stitchedArcs[i < 0 ? ~i : i])
            fragments.push([i]);
        });
        return fragments;
      }
      function mesh(topology) {
        return object(topology, meshArcs.apply(this, arguments));
      }
      function meshArcs(topology, object2, filter) {
        var arcs, i, n;
        if (arguments.length > 1)
          arcs = extractArcs(topology, object2, filter);
        else
          for (i = 0, arcs = new Array(n = topology.arcs.length); i < n; ++i)
            arcs[i] = i;
        return { type: "MultiLineString", arcs: stitch(topology, arcs) };
      }
      function extractArcs(topology, object2, filter) {
        var arcs = [], geomsByArc = [], geom;
        function extract0(i) {
          var j = i < 0 ? ~i : i;
          (geomsByArc[j] || (geomsByArc[j] = [])).push({ i, g: geom });
        }
        function extract1(arcs2) {
          arcs2.forEach(extract0);
        }
        function extract2(arcs2) {
          arcs2.forEach(extract1);
        }
        function extract3(arcs2) {
          arcs2.forEach(extract2);
        }
        function geometry(o) {
          switch (geom = o, o.type) {
            case "GeometryCollection":
              o.geometries.forEach(geometry);
              break;
            case "LineString":
              extract1(o.arcs);
              break;
            case "MultiLineString":
            case "Polygon":
              extract2(o.arcs);
              break;
            case "MultiPolygon":
              extract3(o.arcs);
              break;
          }
        }
        geometry(object2);
        geomsByArc.forEach(filter == null ? function(geoms) {
          arcs.push(geoms[0].i);
        } : function(geoms) {
          if (filter(geoms[0].g, geoms[geoms.length - 1].g))
            arcs.push(geoms[0].i);
        });
        return arcs;
      }
      function planarRingArea(ring) {
        var i = -1, n = ring.length, a3, b = ring[n - 1], area = 0;
        while (++i < n)
          a3 = b, b = ring[i], area += a3[0] * b[1] - a3[1] * b[0];
        return Math.abs(area);
      }
      function merge2(topology) {
        return object(topology, mergeArcs.apply(this, arguments));
      }
      function mergeArcs(topology, objects) {
        var polygonsByArc = {}, polygons = [], groups = [];
        objects.forEach(geometry);
        function geometry(o) {
          switch (o.type) {
            case "GeometryCollection":
              o.geometries.forEach(geometry);
              break;
            case "Polygon":
              extract(o.arcs);
              break;
            case "MultiPolygon":
              o.arcs.forEach(extract);
              break;
          }
        }
        function extract(polygon) {
          polygon.forEach(function(ring) {
            ring.forEach(function(arc) {
              (polygonsByArc[arc = arc < 0 ? ~arc : arc] || (polygonsByArc[arc] = [])).push(polygon);
            });
          });
          polygons.push(polygon);
        }
        function area(ring) {
          return planarRingArea(object(topology, { type: "Polygon", arcs: [ring] }).coordinates[0]);
        }
        polygons.forEach(function(polygon) {
          if (!polygon._) {
            var group = [], neighbors2 = [polygon];
            polygon._ = 1;
            groups.push(group);
            while (polygon = neighbors2.pop()) {
              group.push(polygon);
              polygon.forEach(function(ring) {
                ring.forEach(function(arc) {
                  polygonsByArc[arc < 0 ? ~arc : arc].forEach(function(polygon2) {
                    if (!polygon2._) {
                      polygon2._ = 1;
                      neighbors2.push(polygon2);
                    }
                  });
                });
              });
            }
          }
        });
        polygons.forEach(function(polygon) {
          delete polygon._;
        });
        return {
          type: "MultiPolygon",
          arcs: groups.map(function(polygons2) {
            var arcs = [], n;
            polygons2.forEach(function(polygon) {
              polygon.forEach(function(ring) {
                ring.forEach(function(arc) {
                  if (polygonsByArc[arc < 0 ? ~arc : arc].length < 2) {
                    arcs.push(arc);
                  }
                });
              });
            });
            arcs = stitch(topology, arcs);
            if ((n = arcs.length) > 1) {
              for (var i = 1, k = area(arcs[0]), ki, t; i < n; ++i) {
                if ((ki = area(arcs[i])) > k) {
                  t = arcs[0], arcs[0] = arcs[i], arcs[i] = t, k = ki;
                }
              }
            }
            return arcs;
          }).filter(function(arcs) {
            return arcs.length > 0;
          })
        };
      }
      function bisect(a3, x) {
        var lo = 0, hi = a3.length;
        while (lo < hi) {
          var mid = lo + hi >>> 1;
          if (a3[mid] < x)
            lo = mid + 1;
          else
            hi = mid;
        }
        return lo;
      }
      function neighbors(objects) {
        var indexesByArc = {}, neighbors2 = objects.map(function() {
          return [];
        });
        function line(arcs, i2) {
          arcs.forEach(function(a3) {
            if (a3 < 0)
              a3 = ~a3;
            var o = indexesByArc[a3];
            if (o)
              o.push(i2);
            else
              indexesByArc[a3] = [i2];
          });
        }
        function polygon(arcs, i2) {
          arcs.forEach(function(arc) {
            line(arc, i2);
          });
        }
        function geometry(o, i2) {
          if (o.type === "GeometryCollection")
            o.geometries.forEach(function(o2) {
              geometry(o2, i2);
            });
          else if (o.type in geometryType)
            geometryType[o.type](o.arcs, i2);
        }
        var geometryType = {
          LineString: line,
          MultiLineString: polygon,
          Polygon: polygon,
          MultiPolygon: function(arcs, i2) {
            arcs.forEach(function(arc) {
              polygon(arc, i2);
            });
          }
        };
        objects.forEach(geometry);
        for (var i in indexesByArc) {
          for (var indexes = indexesByArc[i], m = indexes.length, j = 0; j < m; ++j) {
            for (var k = j + 1; k < m; ++k) {
              var ij = indexes[j], ik = indexes[k], n;
              if ((n = neighbors2[ij])[i = bisect(n, ik)] !== ik)
                n.splice(i, 0, ik);
              if ((n = neighbors2[ik])[i = bisect(n, ij)] !== ij)
                n.splice(i, 0, ij);
            }
          }
        }
        return neighbors2;
      }
      function untransform(transform4) {
        if (transform4 == null)
          return identity;
        var x0, y0, kx = transform4.scale[0], ky = transform4.scale[1], dx = transform4.translate[0], dy = transform4.translate[1];
        return function(input, i) {
          if (!i)
            x0 = y0 = 0;
          var j = 2, n = input.length, output = new Array(n), x1 = Math.round((input[0] - dx) / kx), y1 = Math.round((input[1] - dy) / ky);
          output[0] = x1 - x0, x0 = x1;
          output[1] = y1 - y0, y0 = y1;
          while (j < n)
            output[j] = input[j], ++j;
          return output;
        };
      }
      function quantize(topology, transform4) {
        if (topology.transform)
          throw new Error("already quantized");
        if (!transform4 || !transform4.scale) {
          if (!((n = Math.floor(transform4)) >= 2))
            throw new Error("n must be \u22652");
          box = topology.bbox || bbox(topology);
          var x0 = box[0], y0 = box[1], x1 = box[2], y1 = box[3], n;
          transform4 = { scale: [x1 - x0 ? (x1 - x0) / (n - 1) : 1, y1 - y0 ? (y1 - y0) / (n - 1) : 1], translate: [x0, y0] };
        } else {
          box = topology.bbox;
        }
        var t = untransform(transform4), box, key, inputs = topology.objects, outputs = {};
        function quantizePoint(point) {
          return t(point);
        }
        function quantizeGeometry(input) {
          var output;
          switch (input.type) {
            case "GeometryCollection":
              output = { type: "GeometryCollection", geometries: input.geometries.map(quantizeGeometry) };
              break;
            case "Point":
              output = { type: "Point", coordinates: quantizePoint(input.coordinates) };
              break;
            case "MultiPoint":
              output = { type: "MultiPoint", coordinates: input.coordinates.map(quantizePoint) };
              break;
            default:
              return input;
          }
          if (input.id != null)
            output.id = input.id;
          if (input.bbox != null)
            output.bbox = input.bbox;
          if (input.properties != null)
            output.properties = input.properties;
          return output;
        }
        function quantizeArc(input) {
          var i = 0, j = 1, n2 = input.length, p, output = new Array(n2);
          output[0] = t(input[0], 0);
          while (++i < n2)
            if ((p = t(input[i], i))[0] || p[1])
              output[j++] = p;
          if (j === 1)
            output[j++] = [0, 0];
          output.length = j;
          return output;
        }
        for (key in inputs)
          outputs[key] = quantizeGeometry(inputs[key]);
        return {
          type: "Topology",
          bbox: box,
          transform: transform4,
          objects: outputs,
          arcs: topology.arcs.map(quantizeArc)
        };
      }
      exports3.bbox = bbox;
      exports3.feature = feature2;
      exports3.merge = merge2;
      exports3.mergeArcs = mergeArcs;
      exports3.mesh = mesh;
      exports3.meshArcs = meshArcs;
      exports3.neighbors = neighbors;
      exports3.quantize = quantize;
      exports3.transform = transform3;
      exports3.untransform = untransform;
      Object.defineProperty(exports3, "__esModule", { value: true });
    });
  }
});

// node_modules/autolinker/dist/commonjs/version.js
var require_version = __commonJS({
  "node_modules/autolinker/dist/commonjs/version.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.version = void 0;
    exports2.version = "3.16.2";
  }
});

// node_modules/autolinker/dist/commonjs/utils.js
var require_utils = __commonJS({
  "node_modules/autolinker/dist/commonjs/utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.throwUnhandledCaseError = exports2.splitAndCapture = exports2.remove = exports2.indexOf = exports2.ellipsis = exports2.defaults = void 0;
    function defaults(dest, src) {
      for (var prop in src) {
        if (src.hasOwnProperty(prop) && dest[prop] === void 0) {
          dest[prop] = src[prop];
        }
      }
      return dest;
    }
    exports2.defaults = defaults;
    function ellipsis(str, truncateLen, ellipsisChars) {
      var ellipsisLength;
      if (str.length > truncateLen) {
        if (ellipsisChars == null) {
          ellipsisChars = "&hellip;";
          ellipsisLength = 3;
        } else {
          ellipsisLength = ellipsisChars.length;
        }
        str = str.substring(0, truncateLen - ellipsisLength) + ellipsisChars;
      }
      return str;
    }
    exports2.ellipsis = ellipsis;
    function indexOf2(arr, element) {
      if (Array.prototype.indexOf) {
        return arr.indexOf(element);
      } else {
        for (var i = 0, len = arr.length; i < len; i++) {
          if (arr[i] === element)
            return i;
        }
        return -1;
      }
    }
    exports2.indexOf = indexOf2;
    function remove3(arr, fn) {
      for (var i = arr.length - 1; i >= 0; i--) {
        if (fn(arr[i]) === true) {
          arr.splice(i, 1);
        }
      }
    }
    exports2.remove = remove3;
    function splitAndCapture(str, splitRegex) {
      if (!splitRegex.global)
        throw new Error("`splitRegex` must have the 'g' flag set");
      var result = [], lastIdx = 0, match;
      while (match = splitRegex.exec(str)) {
        result.push(str.substring(lastIdx, match.index));
        result.push(match[0]);
        lastIdx = match.index + match[0].length;
      }
      result.push(str.substring(lastIdx));
      return result;
    }
    exports2.splitAndCapture = splitAndCapture;
    function throwUnhandledCaseError(theValue) {
      throw new Error("Unhandled case for value: '".concat(theValue, "'"));
    }
    exports2.throwUnhandledCaseError = throwUnhandledCaseError;
  }
});

// node_modules/autolinker/dist/commonjs/html-tag.js
var require_html_tag = __commonJS({
  "node_modules/autolinker/dist/commonjs/html-tag.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HtmlTag = void 0;
    var utils_1 = require_utils();
    var HtmlTag = function() {
      function HtmlTag2(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.tagName = "";
        this.attrs = {};
        this.innerHTML = "";
        this.whitespaceRegex = /\s+/;
        this.tagName = cfg.tagName || "";
        this.attrs = cfg.attrs || {};
        this.innerHTML = cfg.innerHtml || cfg.innerHTML || "";
      }
      HtmlTag2.prototype.setTagName = function(tagName) {
        this.tagName = tagName;
        return this;
      };
      HtmlTag2.prototype.getTagName = function() {
        return this.tagName || "";
      };
      HtmlTag2.prototype.setAttr = function(attrName, attrValue) {
        var tagAttrs = this.getAttrs();
        tagAttrs[attrName] = attrValue;
        return this;
      };
      HtmlTag2.prototype.getAttr = function(attrName) {
        return this.getAttrs()[attrName];
      };
      HtmlTag2.prototype.setAttrs = function(attrs) {
        Object.assign(this.getAttrs(), attrs);
        return this;
      };
      HtmlTag2.prototype.getAttrs = function() {
        return this.attrs || (this.attrs = {});
      };
      HtmlTag2.prototype.setClass = function(cssClass) {
        return this.setAttr("class", cssClass);
      };
      HtmlTag2.prototype.addClass = function(cssClass) {
        var classAttr = this.getClass(), whitespaceRegex = this.whitespaceRegex, classes = !classAttr ? [] : classAttr.split(whitespaceRegex), newClasses = cssClass.split(whitespaceRegex), newClass;
        while (newClass = newClasses.shift()) {
          if ((0, utils_1.indexOf)(classes, newClass) === -1) {
            classes.push(newClass);
          }
        }
        this.getAttrs()["class"] = classes.join(" ");
        return this;
      };
      HtmlTag2.prototype.removeClass = function(cssClass) {
        var classAttr = this.getClass(), whitespaceRegex = this.whitespaceRegex, classes = !classAttr ? [] : classAttr.split(whitespaceRegex), removeClasses = cssClass.split(whitespaceRegex), removeClass;
        while (classes.length && (removeClass = removeClasses.shift())) {
          var idx = (0, utils_1.indexOf)(classes, removeClass);
          if (idx !== -1) {
            classes.splice(idx, 1);
          }
        }
        this.getAttrs()["class"] = classes.join(" ");
        return this;
      };
      HtmlTag2.prototype.getClass = function() {
        return this.getAttrs()["class"] || "";
      };
      HtmlTag2.prototype.hasClass = function(cssClass) {
        return (" " + this.getClass() + " ").indexOf(" " + cssClass + " ") !== -1;
      };
      HtmlTag2.prototype.setInnerHTML = function(html) {
        this.innerHTML = html;
        return this;
      };
      HtmlTag2.prototype.setInnerHtml = function(html) {
        return this.setInnerHTML(html);
      };
      HtmlTag2.prototype.getInnerHTML = function() {
        return this.innerHTML || "";
      };
      HtmlTag2.prototype.getInnerHtml = function() {
        return this.getInnerHTML();
      };
      HtmlTag2.prototype.toAnchorString = function() {
        var tagName = this.getTagName(), attrsStr = this.buildAttrsStr();
        attrsStr = attrsStr ? " " + attrsStr : "";
        return ["<", tagName, attrsStr, ">", this.getInnerHtml(), "</", tagName, ">"].join("");
      };
      HtmlTag2.prototype.buildAttrsStr = function() {
        if (!this.attrs)
          return "";
        var attrs = this.getAttrs(), attrsArr = [];
        for (var prop in attrs) {
          if (attrs.hasOwnProperty(prop)) {
            attrsArr.push(prop + '="' + attrs[prop] + '"');
          }
        }
        return attrsArr.join(" ");
      };
      return HtmlTag2;
    }();
    exports2.HtmlTag = HtmlTag;
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-smart.js
var require_truncate_smart = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-smart.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateSmart = void 0;
    function truncateSmart(url2, truncateLen, ellipsisChars) {
      var ellipsisLengthBeforeParsing;
      var ellipsisLength;
      if (ellipsisChars == null) {
        ellipsisChars = "&hellip;";
        ellipsisLength = 3;
        ellipsisLengthBeforeParsing = 8;
      } else {
        ellipsisLength = ellipsisChars.length;
        ellipsisLengthBeforeParsing = ellipsisChars.length;
      }
      var parse_url = function(url3) {
        var urlObj2 = {};
        var urlSub = url3;
        var match = urlSub.match(/^([a-z]+):\/\//i);
        if (match) {
          urlObj2.scheme = match[1];
          urlSub = urlSub.substr(match[0].length);
        }
        match = urlSub.match(/^(.*?)(?=(\?|#|\/|$))/i);
        if (match) {
          urlObj2.host = match[1];
          urlSub = urlSub.substr(match[0].length);
        }
        match = urlSub.match(/^\/(.*?)(?=(\?|#|$))/i);
        if (match) {
          urlObj2.path = match[1];
          urlSub = urlSub.substr(match[0].length);
        }
        match = urlSub.match(/^\?(.*?)(?=(#|$))/i);
        if (match) {
          urlObj2.query = match[1];
          urlSub = urlSub.substr(match[0].length);
        }
        match = urlSub.match(/^#(.*?)$/i);
        if (match) {
          urlObj2.fragment = match[1];
        }
        return urlObj2;
      };
      var buildUrl = function(urlObj2) {
        var url3 = "";
        if (urlObj2.scheme && urlObj2.host) {
          url3 += urlObj2.scheme + "://";
        }
        if (urlObj2.host) {
          url3 += urlObj2.host;
        }
        if (urlObj2.path) {
          url3 += "/" + urlObj2.path;
        }
        if (urlObj2.query) {
          url3 += "?" + urlObj2.query;
        }
        if (urlObj2.fragment) {
          url3 += "#" + urlObj2.fragment;
        }
        return url3;
      };
      var buildSegment = function(segment, remainingAvailableLength3) {
        var remainingAvailableLengthHalf = remainingAvailableLength3 / 2, startOffset = Math.ceil(remainingAvailableLengthHalf), endOffset = -1 * Math.floor(remainingAvailableLengthHalf), end2 = "";
        if (endOffset < 0) {
          end2 = segment.substr(endOffset);
        }
        return segment.substr(0, startOffset) + ellipsisChars + end2;
      };
      if (url2.length <= truncateLen) {
        return url2;
      }
      var availableLength = truncateLen - ellipsisLength;
      var urlObj = parse_url(url2);
      if (urlObj.query) {
        var matchQuery = urlObj.query.match(/^(.*?)(?=(\?|\#))(.*?)$/i);
        if (matchQuery) {
          urlObj.query = urlObj.query.substr(0, matchQuery[1].length);
          url2 = buildUrl(urlObj);
        }
      }
      if (url2.length <= truncateLen) {
        return url2;
      }
      if (urlObj.host) {
        urlObj.host = urlObj.host.replace(/^www\./, "");
        url2 = buildUrl(urlObj);
      }
      if (url2.length <= truncateLen) {
        return url2;
      }
      var str = "";
      if (urlObj.host) {
        str += urlObj.host;
      }
      if (str.length >= availableLength) {
        if (urlObj.host.length == truncateLen) {
          return (urlObj.host.substr(0, truncateLen - ellipsisLength) + ellipsisChars).substr(0, availableLength + ellipsisLengthBeforeParsing);
        }
        return buildSegment(str, availableLength).substr(0, availableLength + ellipsisLengthBeforeParsing);
      }
      var pathAndQuery = "";
      if (urlObj.path) {
        pathAndQuery += "/" + urlObj.path;
      }
      if (urlObj.query) {
        pathAndQuery += "?" + urlObj.query;
      }
      if (pathAndQuery) {
        if ((str + pathAndQuery).length >= availableLength) {
          if ((str + pathAndQuery).length == truncateLen) {
            return (str + pathAndQuery).substr(0, truncateLen);
          }
          var remainingAvailableLength = availableLength - str.length;
          return (str + buildSegment(pathAndQuery, remainingAvailableLength)).substr(0, availableLength + ellipsisLengthBeforeParsing);
        } else {
          str += pathAndQuery;
        }
      }
      if (urlObj.fragment) {
        var fragment = "#" + urlObj.fragment;
        if ((str + fragment).length >= availableLength) {
          if ((str + fragment).length == truncateLen) {
            return (str + fragment).substr(0, truncateLen);
          }
          var remainingAvailableLength2 = availableLength - str.length;
          return (str + buildSegment(fragment, remainingAvailableLength2)).substr(0, availableLength + ellipsisLengthBeforeParsing);
        } else {
          str += fragment;
        }
      }
      if (urlObj.scheme && urlObj.host) {
        var scheme = urlObj.scheme + "://";
        if ((str + scheme).length < availableLength) {
          return (scheme + str).substr(0, truncateLen);
        }
      }
      if (str.length <= truncateLen) {
        return str;
      }
      var end = "";
      if (availableLength > 0) {
        end = str.substr(-1 * Math.floor(availableLength / 2));
      }
      return (str.substr(0, Math.ceil(availableLength / 2)) + ellipsisChars + end).substr(0, availableLength + ellipsisLengthBeforeParsing);
    }
    exports2.truncateSmart = truncateSmart;
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-middle.js
var require_truncate_middle = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-middle.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateMiddle = void 0;
    function truncateMiddle(url2, truncateLen, ellipsisChars) {
      if (url2.length <= truncateLen) {
        return url2;
      }
      var ellipsisLengthBeforeParsing;
      var ellipsisLength;
      if (ellipsisChars == null) {
        ellipsisChars = "&hellip;";
        ellipsisLengthBeforeParsing = 8;
        ellipsisLength = 3;
      } else {
        ellipsisLengthBeforeParsing = ellipsisChars.length;
        ellipsisLength = ellipsisChars.length;
      }
      var availableLength = truncateLen - ellipsisLength;
      var end = "";
      if (availableLength > 0) {
        end = url2.substr(-1 * Math.floor(availableLength / 2));
      }
      return (url2.substr(0, Math.ceil(availableLength / 2)) + ellipsisChars + end).substr(0, availableLength + ellipsisLengthBeforeParsing);
    }
    exports2.truncateMiddle = truncateMiddle;
  }
});

// node_modules/autolinker/dist/commonjs/truncate/truncate-end.js
var require_truncate_end = __commonJS({
  "node_modules/autolinker/dist/commonjs/truncate/truncate-end.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.truncateEnd = void 0;
    var utils_1 = require_utils();
    function truncateEnd(anchorText, truncateLen, ellipsisChars) {
      return (0, utils_1.ellipsis)(anchorText, truncateLen, ellipsisChars);
    }
    exports2.truncateEnd = truncateEnd;
  }
});

// node_modules/autolinker/dist/commonjs/anchor-tag-builder.js
var require_anchor_tag_builder = __commonJS({
  "node_modules/autolinker/dist/commonjs/anchor-tag-builder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AnchorTagBuilder = void 0;
    var html_tag_1 = require_html_tag();
    var truncate_smart_1 = require_truncate_smart();
    var truncate_middle_1 = require_truncate_middle();
    var truncate_end_1 = require_truncate_end();
    var AnchorTagBuilder = function() {
      function AnchorTagBuilder2(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.newWindow = false;
        this.truncate = {};
        this.className = "";
        this.newWindow = cfg.newWindow || false;
        this.truncate = cfg.truncate || {};
        this.className = cfg.className || "";
      }
      AnchorTagBuilder2.prototype.build = function(match) {
        return new html_tag_1.HtmlTag({
          tagName: "a",
          attrs: this.createAttrs(match),
          innerHtml: this.processAnchorText(match.getAnchorText())
        });
      };
      AnchorTagBuilder2.prototype.createAttrs = function(match) {
        var attrs = {
          href: match.getAnchorHref()
        };
        var cssClass = this.createCssClass(match);
        if (cssClass) {
          attrs["class"] = cssClass;
        }
        if (this.newWindow) {
          attrs["target"] = "_blank";
          attrs["rel"] = "noopener noreferrer";
        }
        if (this.truncate) {
          if (this.truncate.length && this.truncate.length < match.getAnchorText().length) {
            attrs["title"] = match.getAnchorHref();
          }
        }
        return attrs;
      };
      AnchorTagBuilder2.prototype.createCssClass = function(match) {
        var className = this.className;
        if (!className) {
          return "";
        } else {
          var returnClasses = [className], cssClassSuffixes = match.getCssClassSuffixes();
          for (var i = 0, len = cssClassSuffixes.length; i < len; i++) {
            returnClasses.push(className + "-" + cssClassSuffixes[i]);
          }
          return returnClasses.join(" ");
        }
      };
      AnchorTagBuilder2.prototype.processAnchorText = function(anchorText) {
        anchorText = this.doTruncate(anchorText);
        return anchorText;
      };
      AnchorTagBuilder2.prototype.doTruncate = function(anchorText) {
        var truncate = this.truncate;
        if (!truncate || !truncate.length)
          return anchorText;
        var truncateLength = truncate.length, truncateLocation = truncate.location;
        if (truncateLocation === "smart") {
          return (0, truncate_smart_1.truncateSmart)(anchorText, truncateLength);
        } else if (truncateLocation === "middle") {
          return (0, truncate_middle_1.truncateMiddle)(anchorText, truncateLength);
        } else {
          return (0, truncate_end_1.truncateEnd)(anchorText, truncateLength);
        }
      };
      return AnchorTagBuilder2;
    }();
    exports2.AnchorTagBuilder = AnchorTagBuilder;
  }
});

// node_modules/autolinker/dist/commonjs/match/match.js
var require_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Match = void 0;
    var Match = function() {
      function Match2(cfg) {
        this.__jsduckDummyDocProp = null;
        this.matchedText = "";
        this.offset = 0;
        this.tagBuilder = cfg.tagBuilder;
        this.matchedText = cfg.matchedText;
        this.offset = cfg.offset;
      }
      Match2.prototype.getMatchedText = function() {
        return this.matchedText;
      };
      Match2.prototype.setOffset = function(offset2) {
        this.offset = offset2;
      };
      Match2.prototype.getOffset = function() {
        return this.offset;
      };
      Match2.prototype.getCssClassSuffixes = function() {
        return [this.getType()];
      };
      Match2.prototype.buildTag = function() {
        return this.tagBuilder.build(this);
      };
      return Match2;
    }();
    exports2.Match = Match;
  }
});

// node_modules/tslib/tslib.js
var require_tslib = __commonJS({
  "node_modules/tslib/tslib.js"(exports2, module2) {
    var __extends;
    var __assign;
    var __rest;
    var __decorate;
    var __param;
    var __esDecorate;
    var __runInitializers;
    var __propKey;
    var __setFunctionName;
    var __metadata;
    var __awaiter;
    var __generator;
    var __exportStar;
    var __values;
    var __read;
    var __spread;
    var __spreadArrays;
    var __spreadArray;
    var __await;
    var __asyncGenerator;
    var __asyncDelegator;
    var __asyncValues;
    var __makeTemplateObject;
    var __importStar;
    var __importDefault;
    var __classPrivateFieldGet;
    var __classPrivateFieldSet;
    var __classPrivateFieldIn;
    var __createBinding;
    var __addDisposableResource;
    var __disposeResources;
    (function(factory) {
      var root = typeof global === "object" ? global : typeof self === "object" ? self : typeof this === "object" ? this : {};
      if (typeof define === "function" && define.amd) {
        define("tslib", ["exports"], function(exports3) {
          factory(createExporter(root, createExporter(exports3)));
        });
      } else if (typeof module2 === "object" && typeof module2.exports === "object") {
        factory(createExporter(root, createExporter(module2.exports)));
      } else {
        factory(createExporter(root));
      }
      function createExporter(exports3, previous) {
        if (exports3 !== root) {
          if (typeof Object.create === "function") {
            Object.defineProperty(exports3, "__esModule", { value: true });
          } else {
            exports3.__esModule = true;
          }
        }
        return function(id, v7) {
          return exports3[id] = previous ? previous(id, v7) : v7;
        };
      }
    })(function(exporter) {
      var extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d, b) {
        d.__proto__ = b;
      } || function(d, b) {
        for (var p in b)
          if (Object.prototype.hasOwnProperty.call(b, p))
            d[p] = b[p];
      };
      __extends = function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
      __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p))
              t[p] = s[p];
        }
        return t;
      };
      __rest = function(s, e) {
        var t = {};
        for (var p in s)
          if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
            t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
          for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
              t[p[i]] = s[p[i]];
          }
        return t;
      };
      __decorate = function(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
          r = Reflect.decorate(decorators, target, key, desc);
        else
          for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
              r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
      };
      __param = function(paramIndex, decorator) {
        return function(target, key) {
          decorator(target, key, paramIndex);
        };
      };
      __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
        function accept(f) {
          if (f !== void 0 && typeof f !== "function")
            throw new TypeError("Function expected");
          return f;
        }
        var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
        var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
        var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
        var _, done = false;
        for (var i = decorators.length - 1; i >= 0; i--) {
          var context = {};
          for (var p in contextIn)
            context[p] = p === "access" ? {} : contextIn[p];
          for (var p in contextIn.access)
            context.access[p] = contextIn.access[p];
          context.addInitializer = function(f) {
            if (done)
              throw new TypeError("Cannot add initializers after decoration has completed");
            extraInitializers.push(accept(f || null));
          };
          var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
          if (kind === "accessor") {
            if (result === void 0)
              continue;
            if (result === null || typeof result !== "object")
              throw new TypeError("Object expected");
            if (_ = accept(result.get))
              descriptor.get = _;
            if (_ = accept(result.set))
              descriptor.set = _;
            if (_ = accept(result.init))
              initializers.unshift(_);
          } else if (_ = accept(result)) {
            if (kind === "field")
              initializers.unshift(_);
            else
              descriptor[key] = _;
          }
        }
        if (target)
          Object.defineProperty(target, contextIn.name, descriptor);
        done = true;
      };
      __runInitializers = function(thisArg, initializers, value) {
        var useValue = arguments.length > 2;
        for (var i = 0; i < initializers.length; i++) {
          value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
        }
        return useValue ? value : void 0;
      };
      __propKey = function(x) {
        return typeof x === "symbol" ? x : "".concat(x);
      };
      __setFunctionName = function(f, name, prefix) {
        if (typeof name === "symbol")
          name = name.description ? "[".concat(name.description, "]") : "";
        return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
      };
      __metadata = function(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
          return Reflect.metadata(metadataKey, metadataValue);
      };
      __awaiter = function(thisArg, _arguments, P, generator) {
        function adopt(value) {
          return value instanceof P ? value : new P(function(resolve2) {
            resolve2(value);
          });
        }
        return new (P || (P = Promise))(function(resolve2, reject) {
          function fulfilled(value) {
            try {
              step2(generator.next(value));
            } catch (e) {
              reject(e);
            }
          }
          function rejected(value) {
            try {
              step2(generator["throw"](value));
            } catch (e) {
              reject(e);
            }
          }
          function step2(result) {
            result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
          }
          step2((generator = generator.apply(thisArg, _arguments || [])).next());
        });
      };
      __generator = function(thisArg, body) {
        var _ = { label: 0, sent: function() {
          if (t[0] & 1)
            throw t[1];
          return t[1];
        }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
          return this;
        }), g;
        function verb(n) {
          return function(v7) {
            return step2([n, v7]);
          };
        }
        function step2(op) {
          if (f)
            throw new TypeError("Generator is already executing.");
          while (g && (g = 0, op[0] && (_ = 0)), _)
            try {
              if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                return t;
              if (y = 0, t)
                op = [op[0] & 2, t.value];
              switch (op[0]) {
                case 0:
                case 1:
                  t = op;
                  break;
                case 4:
                  _.label++;
                  return { value: op[1], done: false };
                case 5:
                  _.label++;
                  y = op[1];
                  op = [0];
                  continue;
                case 7:
                  op = _.ops.pop();
                  _.trys.pop();
                  continue;
                default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                    _ = 0;
                    continue;
                  }
                  if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                    _.label = op[1];
                    break;
                  }
                  if (op[0] === 6 && _.label < t[1]) {
                    _.label = t[1];
                    t = op;
                    break;
                  }
                  if (t && _.label < t[2]) {
                    _.label = t[2];
                    _.ops.push(op);
                    break;
                  }
                  if (t[2])
                    _.ops.pop();
                  _.trys.pop();
                  continue;
              }
              op = body.call(thisArg, _);
            } catch (e) {
              op = [6, e];
              y = 0;
            } finally {
              f = t = 0;
            }
          if (op[0] & 5)
            throw op[1];
          return { value: op[0] ? op[1] : void 0, done: true };
        }
      };
      __exportStar = function(m, o) {
        for (var p in m)
          if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
            __createBinding(o, m, p);
      };
      __createBinding = Object.create ? function(o, m, k, k2) {
        if (k2 === void 0)
          k2 = k;
        var desc = Object.getOwnPropertyDescriptor(m, k);
        if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
          desc = { enumerable: true, get: function() {
            return m[k];
          } };
        }
        Object.defineProperty(o, k2, desc);
      } : function(o, m, k, k2) {
        if (k2 === void 0)
          k2 = k;
        o[k2] = m[k];
      };
      __values = function(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
          return m.call(o);
        if (o && typeof o.length === "number")
          return {
            next: function() {
              if (o && i >= o.length)
                o = void 0;
              return { value: o && o[i++], done: !o };
            }
          };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
      };
      __read = function(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
          return o;
        var i = m.call(o), r, ar = [], e;
        try {
          while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
            ar.push(r.value);
        } catch (error) {
          e = { error };
        } finally {
          try {
            if (r && !r.done && (m = i["return"]))
              m.call(i);
          } finally {
            if (e)
              throw e.error;
          }
        }
        return ar;
      };
      __spread = function() {
        for (var ar = [], i = 0; i < arguments.length; i++)
          ar = ar.concat(__read(arguments[i]));
        return ar;
      };
      __spreadArrays = function() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
          s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
          for (var a3 = arguments[i], j = 0, jl = a3.length; j < jl; j++, k++)
            r[k] = a3[j];
        return r;
      };
      __spreadArray = function(to, from, pack) {
        if (pack || arguments.length === 2)
          for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
              if (!ar)
                ar = Array.prototype.slice.call(from, 0, i);
              ar[i] = from[i];
            }
          }
        return to.concat(ar || Array.prototype.slice.call(from));
      };
      __await = function(v7) {
        return this instanceof __await ? (this.v = v7, this) : new __await(v7);
      };
      __asyncGenerator = function(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
          throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
          return this;
        }, i;
        function verb(n) {
          if (g[n])
            i[n] = function(v7) {
              return new Promise(function(a3, b) {
                q.push([n, v7, a3, b]) > 1 || resume(n, v7);
              });
            };
        }
        function resume(n, v7) {
          try {
            step2(g[n](v7));
          } catch (e) {
            settle(q[0][3], e);
          }
        }
        function step2(r) {
          r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
        }
        function fulfill(value) {
          resume("next", value);
        }
        function reject(value) {
          resume("throw", value);
        }
        function settle(f, v7) {
          if (f(v7), q.shift(), q.length)
            resume(q[0][0], q[0][1]);
        }
      };
      __asyncDelegator = function(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function(e) {
          throw e;
        }), verb("return"), i[Symbol.iterator] = function() {
          return this;
        }, i;
        function verb(n, f) {
          i[n] = o[n] ? function(v7) {
            return (p = !p) ? { value: __await(o[n](v7)), done: false } : f ? f(v7) : v7;
          } : f;
        }
      };
      __asyncValues = function(o) {
        if (!Symbol.asyncIterator)
          throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
          return this;
        }, i);
        function verb(n) {
          i[n] = o[n] && function(v7) {
            return new Promise(function(resolve2, reject) {
              v7 = o[n](v7), settle(resolve2, reject, v7.done, v7.value);
            });
          };
        }
        function settle(resolve2, reject, d, v7) {
          Promise.resolve(v7).then(function(v8) {
            resolve2({ value: v8, done: d });
          }, reject);
        }
      };
      __makeTemplateObject = function(cooked, raw) {
        if (Object.defineProperty) {
          Object.defineProperty(cooked, "raw", { value: raw });
        } else {
          cooked.raw = raw;
        }
        return cooked;
      };
      var __setModuleDefault = Object.create ? function(o, v7) {
        Object.defineProperty(o, "default", { enumerable: true, value: v7 });
      } : function(o, v7) {
        o["default"] = v7;
      };
      __importStar = function(mod2) {
        if (mod2 && mod2.__esModule)
          return mod2;
        var result = {};
        if (mod2 != null) {
          for (var k in mod2)
            if (k !== "default" && Object.prototype.hasOwnProperty.call(mod2, k))
              __createBinding(result, mod2, k);
        }
        __setModuleDefault(result, mod2);
        return result;
      };
      __importDefault = function(mod2) {
        return mod2 && mod2.__esModule ? mod2 : { "default": mod2 };
      };
      __classPrivateFieldGet = function(receiver, state, kind, f) {
        if (kind === "a" && !f)
          throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
          throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
      };
      __classPrivateFieldSet = function(receiver, state, value, kind, f) {
        if (kind === "m")
          throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
          throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
          throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
      };
      __classPrivateFieldIn = function(state, receiver) {
        if (receiver === null || typeof receiver !== "object" && typeof receiver !== "function")
          throw new TypeError("Cannot use 'in' operator on non-object");
        return typeof state === "function" ? receiver === state : state.has(receiver);
      };
      __addDisposableResource = function(env, value, async) {
        if (value !== null && value !== void 0) {
          if (typeof value !== "object" && typeof value !== "function")
            throw new TypeError("Object expected.");
          var dispose;
          if (async) {
            if (!Symbol.asyncDispose)
              throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
          }
          if (dispose === void 0) {
            if (!Symbol.dispose)
              throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
          }
          if (typeof dispose !== "function")
            throw new TypeError("Object not disposable.");
          env.stack.push({ value, dispose, async });
        } else if (async) {
          env.stack.push({ async: true });
        }
        return value;
      };
      var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function(error, suppressed, message) {
        var e = new Error(message);
        return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
      };
      __disposeResources = function(env) {
        function fail(e) {
          env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
          env.hasError = true;
        }
        function next() {
          while (env.stack.length) {
            var rec = env.stack.pop();
            try {
              var result = rec.dispose && rec.dispose.call(rec.value);
              if (rec.async)
                return Promise.resolve(result).then(next, function(e) {
                  fail(e);
                  return next();
                });
            } catch (e) {
              fail(e);
            }
          }
          if (env.hasError)
            throw env.error;
        }
        return next();
      };
      exporter("__extends", __extends);
      exporter("__assign", __assign);
      exporter("__rest", __rest);
      exporter("__decorate", __decorate);
      exporter("__param", __param);
      exporter("__esDecorate", __esDecorate);
      exporter("__runInitializers", __runInitializers);
      exporter("__propKey", __propKey);
      exporter("__setFunctionName", __setFunctionName);
      exporter("__metadata", __metadata);
      exporter("__awaiter", __awaiter);
      exporter("__generator", __generator);
      exporter("__exportStar", __exportStar);
      exporter("__createBinding", __createBinding);
      exporter("__values", __values);
      exporter("__read", __read);
      exporter("__spread", __spread);
      exporter("__spreadArrays", __spreadArrays);
      exporter("__spreadArray", __spreadArray);
      exporter("__await", __await);
      exporter("__asyncGenerator", __asyncGenerator);
      exporter("__asyncDelegator", __asyncDelegator);
      exporter("__asyncValues", __asyncValues);
      exporter("__makeTemplateObject", __makeTemplateObject);
      exporter("__importStar", __importStar);
      exporter("__importDefault", __importDefault);
      exporter("__classPrivateFieldGet", __classPrivateFieldGet);
      exporter("__classPrivateFieldSet", __classPrivateFieldSet);
      exporter("__classPrivateFieldIn", __classPrivateFieldIn);
      exporter("__addDisposableResource", __addDisposableResource);
      exporter("__disposeResources", __disposeResources);
    });
  }
});

// node_modules/autolinker/dist/commonjs/match/email-match.js
var require_email_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/email-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EmailMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var EmailMatch = function(_super) {
      (0, tslib_1.__extends)(EmailMatch2, _super);
      function EmailMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.email = "";
        _this.email = cfg.email;
        return _this;
      }
      EmailMatch2.prototype.getType = function() {
        return "email";
      };
      EmailMatch2.prototype.getEmail = function() {
        return this.email;
      };
      EmailMatch2.prototype.getAnchorHref = function() {
        return "mailto:" + this.email;
      };
      EmailMatch2.prototype.getAnchorText = function() {
        return this.email;
      };
      return EmailMatch2;
    }(match_1.Match);
    exports2.EmailMatch = EmailMatch;
  }
});

// node_modules/autolinker/dist/commonjs/match/hashtag-match.js
var require_hashtag_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/hashtag-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.HashtagMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var HashtagMatch = function(_super) {
      (0, tslib_1.__extends)(HashtagMatch2, _super);
      function HashtagMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.serviceName = "";
        _this.hashtag = "";
        _this.serviceName = cfg.serviceName;
        _this.hashtag = cfg.hashtag;
        return _this;
      }
      HashtagMatch2.prototype.getType = function() {
        return "hashtag";
      };
      HashtagMatch2.prototype.getServiceName = function() {
        return this.serviceName;
      };
      HashtagMatch2.prototype.getHashtag = function() {
        return this.hashtag;
      };
      HashtagMatch2.prototype.getAnchorHref = function() {
        var serviceName = this.serviceName, hashtag = this.hashtag;
        switch (serviceName) {
          case "twitter":
            return "https://twitter.com/hashtag/" + hashtag;
          case "facebook":
            return "https://www.facebook.com/hashtag/" + hashtag;
          case "instagram":
            return "https://instagram.com/explore/tags/" + hashtag;
          case "tiktok":
            return "https://www.tiktok.com/tag/" + hashtag;
          default:
            throw new Error("Unknown service name to point hashtag to: " + serviceName);
        }
      };
      HashtagMatch2.prototype.getAnchorText = function() {
        return "#" + this.hashtag;
      };
      return HashtagMatch2;
    }(match_1.Match);
    exports2.HashtagMatch = HashtagMatch;
  }
});

// node_modules/autolinker/dist/commonjs/match/mention-match.js
var require_mention_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/mention-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MentionMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var MentionMatch = function(_super) {
      (0, tslib_1.__extends)(MentionMatch2, _super);
      function MentionMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.serviceName = "twitter";
        _this.mention = "";
        _this.mention = cfg.mention;
        _this.serviceName = cfg.serviceName;
        return _this;
      }
      MentionMatch2.prototype.getType = function() {
        return "mention";
      };
      MentionMatch2.prototype.getMention = function() {
        return this.mention;
      };
      MentionMatch2.prototype.getServiceName = function() {
        return this.serviceName;
      };
      MentionMatch2.prototype.getAnchorHref = function() {
        switch (this.serviceName) {
          case "twitter":
            return "https://twitter.com/" + this.mention;
          case "instagram":
            return "https://instagram.com/" + this.mention;
          case "soundcloud":
            return "https://soundcloud.com/" + this.mention;
          case "tiktok":
            return "https://www.tiktok.com/@" + this.mention;
          default:
            throw new Error("Unknown service name to point mention to: " + this.serviceName);
        }
      };
      MentionMatch2.prototype.getAnchorText = function() {
        return "@" + this.mention;
      };
      MentionMatch2.prototype.getCssClassSuffixes = function() {
        var cssClassSuffixes = _super.prototype.getCssClassSuffixes.call(this), serviceName = this.getServiceName();
        if (serviceName) {
          cssClassSuffixes.push(serviceName);
        }
        return cssClassSuffixes;
      };
      return MentionMatch2;
    }(match_1.Match);
    exports2.MentionMatch = MentionMatch;
  }
});

// node_modules/autolinker/dist/commonjs/match/phone-match.js
var require_phone_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/phone-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PhoneMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var PhoneMatch = function(_super) {
      (0, tslib_1.__extends)(PhoneMatch2, _super);
      function PhoneMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.number = "";
        _this.plusSign = false;
        _this.number = cfg.number;
        _this.plusSign = cfg.plusSign;
        return _this;
      }
      PhoneMatch2.prototype.getType = function() {
        return "phone";
      };
      PhoneMatch2.prototype.getPhoneNumber = function() {
        return this.number;
      };
      PhoneMatch2.prototype.getNumber = function() {
        return this.getPhoneNumber();
      };
      PhoneMatch2.prototype.getAnchorHref = function() {
        return "tel:" + (this.plusSign ? "+" : "") + this.number;
      };
      PhoneMatch2.prototype.getAnchorText = function() {
        return this.matchedText;
      };
      return PhoneMatch2;
    }(match_1.Match);
    exports2.PhoneMatch = PhoneMatch;
  }
});

// node_modules/autolinker/dist/commonjs/match/url-match.js
var require_url_match = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/url-match.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UrlMatch = void 0;
    var tslib_1 = require_tslib();
    var match_1 = require_match();
    var UrlMatch = function(_super) {
      (0, tslib_1.__extends)(UrlMatch2, _super);
      function UrlMatch2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.url = "";
        _this.urlMatchType = "scheme";
        _this.protocolUrlMatch = false;
        _this.protocolRelativeMatch = false;
        _this.stripPrefix = {
          scheme: true,
          www: true
        };
        _this.stripTrailingSlash = true;
        _this.decodePercentEncoding = true;
        _this.schemePrefixRegex = /^(https?:\/\/)?/i;
        _this.wwwPrefixRegex = /^(https?:\/\/)?(www\.)?/i;
        _this.protocolRelativeRegex = /^\/\//;
        _this.protocolPrepended = false;
        _this.urlMatchType = cfg.urlMatchType;
        _this.url = cfg.url;
        _this.protocolUrlMatch = cfg.protocolUrlMatch;
        _this.protocolRelativeMatch = cfg.protocolRelativeMatch;
        _this.stripPrefix = cfg.stripPrefix;
        _this.stripTrailingSlash = cfg.stripTrailingSlash;
        _this.decodePercentEncoding = cfg.decodePercentEncoding;
        return _this;
      }
      UrlMatch2.prototype.getType = function() {
        return "url";
      };
      UrlMatch2.prototype.getUrlMatchType = function() {
        return this.urlMatchType;
      };
      UrlMatch2.prototype.getUrl = function() {
        var url2 = this.url;
        if (!this.protocolRelativeMatch && !this.protocolUrlMatch && !this.protocolPrepended) {
          url2 = this.url = "http://" + url2;
          this.protocolPrepended = true;
        }
        return url2;
      };
      UrlMatch2.prototype.getAnchorHref = function() {
        var url2 = this.getUrl();
        return url2.replace(/&amp;/g, "&");
      };
      UrlMatch2.prototype.getAnchorText = function() {
        var anchorText = this.getMatchedText();
        if (this.protocolRelativeMatch) {
          anchorText = this.stripProtocolRelativePrefix(anchorText);
        }
        if (this.stripPrefix.scheme) {
          anchorText = this.stripSchemePrefix(anchorText);
        }
        if (this.stripPrefix.www) {
          anchorText = this.stripWwwPrefix(anchorText);
        }
        if (this.stripTrailingSlash) {
          anchorText = this.removeTrailingSlash(anchorText);
        }
        if (this.decodePercentEncoding) {
          anchorText = this.removePercentEncoding(anchorText);
        }
        return anchorText;
      };
      UrlMatch2.prototype.stripSchemePrefix = function(url2) {
        return url2.replace(this.schemePrefixRegex, "");
      };
      UrlMatch2.prototype.stripWwwPrefix = function(url2) {
        return url2.replace(this.wwwPrefixRegex, "$1");
      };
      UrlMatch2.prototype.stripProtocolRelativePrefix = function(text) {
        return text.replace(this.protocolRelativeRegex, "");
      };
      UrlMatch2.prototype.removeTrailingSlash = function(anchorText) {
        if (anchorText.charAt(anchorText.length - 1) === "/") {
          anchorText = anchorText.slice(0, -1);
        }
        return anchorText;
      };
      UrlMatch2.prototype.removePercentEncoding = function(anchorText) {
        var preProcessedEntityAnchorText = anchorText.replace(/%22/gi, "&quot;").replace(/%26/gi, "&amp;").replace(/%27/gi, "&#39;").replace(/%3C/gi, "&lt;").replace(/%3E/gi, "&gt;");
        try {
          return decodeURIComponent(preProcessedEntityAnchorText);
        } catch (e) {
          return preProcessedEntityAnchorText;
        }
      };
      return UrlMatch2;
    }(match_1.Match);
    exports2.UrlMatch = UrlMatch;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/matcher.js
var require_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Matcher = void 0;
    var Matcher = function() {
      function Matcher2(cfg) {
        this.__jsduckDummyDocProp = null;
        this.tagBuilder = cfg.tagBuilder;
      }
      return Matcher2;
    }();
    exports2.Matcher = Matcher;
  }
});

// node_modules/autolinker/dist/commonjs/regex-lib.js
var require_regex_lib = __commonJS({
  "node_modules/autolinker/dist/commonjs/regex-lib.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.domainNameCharRegex = exports2.domainNameRegex = exports2.getDomainNameStr = exports2.alphaNumericAndMarksCharRe = exports2.alphaNumericAndMarksCharsStr = exports2.alphaNumericCharsStr = exports2.decimalNumbersStr = exports2.alphaCharsAndMarksStr = exports2.marksStr = exports2.emojiStr = exports2.alphaCharsStr = exports2.controlCharsRe = exports2.quoteRe = exports2.whitespaceRe = exports2.nonDigitRe = exports2.digitRe = exports2.letterRe = void 0;
    exports2.letterRe = /[A-Za-z]/;
    exports2.digitRe = /[\d]/;
    exports2.nonDigitRe = /[\D]/;
    exports2.whitespaceRe = /\s/;
    exports2.quoteRe = /['"]/;
    exports2.controlCharsRe = /[\x00-\x1F\x7F]/;
    exports2.alphaCharsStr = /A-Za-z\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0-\u08B4\u08B6-\u08BD\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16F1-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FD5\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC/.source;
    exports2.emojiStr = /\u2700-\u27bf\udde6-\uddff\ud800-\udbff\udc00-\udfff\ufe0e\ufe0f\u0300-\u036f\ufe20-\ufe23\u20d0-\u20f0\ud83c\udffb-\udfff\u200d\u3299\u3297\u303d\u3030\u24c2\ud83c\udd70-\udd71\udd7e-\udd7f\udd8e\udd91-\udd9a\udde6-\uddff\ude01-\ude02\ude1a\ude2f\ude32-\ude3a\ude50-\ude51\u203c\u2049\u25aa-\u25ab\u25b6\u25c0\u25fb-\u25fe\u00a9\u00ae\u2122\u2139\udc04\u2600-\u26FF\u2b05\u2b06\u2b07\u2b1b\u2b1c\u2b50\u2b55\u231a\u231b\u2328\u23cf\u23e9-\u23f3\u23f8-\u23fa\udccf\u2935\u2934\u2190-\u21ff/.source;
    exports2.marksStr = /\u0300-\u036F\u0483-\u0489\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711\u0730-\u074A\u07A6-\u07B0\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08D4-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A70\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B62\u0B63\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0C00-\u0C03\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0D01-\u0D03\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D82\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0EB1\u0EB4-\u0EB9\u0EBB\u0EBC\u0EC8-\u0ECD\u0F18\u0F19\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F\u109A-\u109D\u135D-\u135F\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u180B-\u180D\u1885\u1886\u18A9\u1920-\u192B\u1930-\u193B\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F\u1AB0-\u1ABE\u1B00-\u1B04\u1B34-\u1B44\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BE6-\u1BF3\u1C24-\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF2-\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF5\u1DFB-\u1DFF\u20D0-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F-\uA672\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA880\uA881\uA8B4-\uA8C5\uA8E0-\uA8F1\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9E5\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F/.source;
    exports2.alphaCharsAndMarksStr = exports2.alphaCharsStr + exports2.emojiStr + exports2.marksStr;
    exports2.decimalNumbersStr = /0-9\u0660-\u0669\u06F0-\u06F9\u07C0-\u07C9\u0966-\u096F\u09E6-\u09EF\u0A66-\u0A6F\u0AE6-\u0AEF\u0B66-\u0B6F\u0BE6-\u0BEF\u0C66-\u0C6F\u0CE6-\u0CEF\u0D66-\u0D6F\u0DE6-\u0DEF\u0E50-\u0E59\u0ED0-\u0ED9\u0F20-\u0F29\u1040-\u1049\u1090-\u1099\u17E0-\u17E9\u1810-\u1819\u1946-\u194F\u19D0-\u19D9\u1A80-\u1A89\u1A90-\u1A99\u1B50-\u1B59\u1BB0-\u1BB9\u1C40-\u1C49\u1C50-\u1C59\uA620-\uA629\uA8D0-\uA8D9\uA900-\uA909\uA9D0-\uA9D9\uA9F0-\uA9F9\uAA50-\uAA59\uABF0-\uABF9\uFF10-\uFF19/.source;
    exports2.alphaNumericCharsStr = exports2.alphaCharsAndMarksStr + exports2.decimalNumbersStr;
    exports2.alphaNumericAndMarksCharsStr = exports2.alphaCharsAndMarksStr + exports2.decimalNumbersStr;
    exports2.alphaNumericAndMarksCharRe = new RegExp("[".concat(exports2.alphaNumericAndMarksCharsStr, "]"));
    var ipStr = "(?:[" + exports2.decimalNumbersStr + "]{1,3}\\.){3}[" + exports2.decimalNumbersStr + "]{1,3}";
    var domainLabelStr = "[" + exports2.alphaNumericAndMarksCharsStr + "](?:[" + exports2.alphaNumericAndMarksCharsStr + "\\-_]{0,61}[" + exports2.alphaNumericAndMarksCharsStr + "])?";
    var getDomainLabelStr = function(group) {
      return "(?=(" + domainLabelStr + "))\\" + group;
    };
    var getDomainNameStr = function(group) {
      return "(?:" + getDomainLabelStr(group) + "(?:\\." + getDomainLabelStr(group + 1) + "){0,126}|" + ipStr + ")";
    };
    exports2.getDomainNameStr = getDomainNameStr;
    exports2.domainNameRegex = new RegExp("[" + exports2.alphaNumericAndMarksCharsStr + ".\\-]*[" + exports2.alphaNumericAndMarksCharsStr + "\\-]");
    exports2.domainNameCharRegex = exports2.alphaNumericAndMarksCharRe;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/tld-regex.js
var require_tld_regex = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/tld-regex.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tldRegex = void 0;
    exports2.tldRegex = /(?:xn--vermgensberatung-pwb|xn--vermgensberater-ctb|xn--clchc0ea0b2g2a9gcd|xn--w4r85el8fhu5dnra|northwesternmutual|travelersinsurance|vermögensberatung|xn--5su34j936bgsg|xn--bck1b9a5dre4c|xn--mgbah1a3hjkrd|xn--mgbai9azgqp6j|xn--mgberp4a5d4ar|xn--xkc2dl3a5ee0h|vermögensberater|xn--fzys8d69uvgm|xn--mgba7c0bbn0a|xn--mgbcpq6gpa1a|xn--xkc2al3hye2a|americanexpress|kerryproperties|sandvikcoromant|xn--i1b6b1a6a2e|xn--kcrx77d1x4a|xn--lgbbat1ad8j|xn--mgba3a4f16a|xn--mgbaakc7dvf|xn--mgbc0a9azcg|xn--nqv7fs00ema|americanfamily|bananarepublic|cancerresearch|cookingchannel|kerrylogistics|weatherchannel|xn--54b7fta0cc|xn--6qq986b3xl|xn--80aqecdr1a|xn--b4w605ferd|xn--fiq228c5hs|xn--h2breg3eve|xn--jlq480n2rg|xn--jlq61u9w7b|xn--mgba3a3ejt|xn--mgbaam7a8h|xn--mgbayh7gpa|xn--mgbbh1a71e|xn--mgbca7dzdo|xn--mgbi4ecexp|xn--mgbx4cd0ab|xn--rvc1e0am3e|international|lifeinsurance|travelchannel|wolterskluwer|xn--cckwcxetd|xn--eckvdtc9d|xn--fpcrj9c3d|xn--fzc2c9e2c|xn--h2brj9c8c|xn--tiq49xqyj|xn--yfro4i67o|xn--ygbi2ammx|construction|lplfinancial|scholarships|versicherung|xn--3e0b707e|xn--45br5cyl|xn--4dbrk0ce|xn--80adxhks|xn--80asehdb|xn--8y0a063a|xn--gckr3f0f|xn--mgb9awbf|xn--mgbab2bd|xn--mgbgu82a|xn--mgbpl2fh|xn--mgbt3dhd|xn--mk1bu44c|xn--ngbc5azd|xn--ngbe9e0a|xn--ogbpf8fl|xn--qcka1pmc|accountants|barclaycard|blackfriday|blockbuster|bridgestone|calvinklein|contractors|creditunion|engineering|enterprises|foodnetwork|investments|kerryhotels|lamborghini|motorcycles|olayangroup|photography|playstation|productions|progressive|redumbrella|williamhill|xn--11b4c3d|xn--1ck2e1b|xn--1qqw23a|xn--2scrj9c|xn--3bst00m|xn--3ds443g|xn--3hcrj9c|xn--42c2d9a|xn--45brj9c|xn--55qw42g|xn--6frz82g|xn--80ao21a|xn--9krt00a|xn--cck2b3b|xn--czr694b|xn--d1acj3b|xn--efvy88h|xn--fct429k|xn--fjq720a|xn--flw351e|xn--g2xx48c|xn--gecrj9c|xn--gk3at1e|xn--h2brj9c|xn--hxt814e|xn--imr513n|xn--j6w193g|xn--jvr189m|xn--kprw13d|xn--kpry57d|xn--mgbbh1a|xn--mgbtx2b|xn--mix891f|xn--nyqy26a|xn--otu796d|xn--pgbs0dh|xn--q9jyb4c|xn--rhqv96g|xn--rovu88b|xn--s9brj9c|xn--ses554g|xn--t60b56a|xn--vuq861b|xn--w4rs40l|xn--xhq521b|xn--zfr164b|சிங்கப்பூர்|accountant|apartments|associates|basketball|bnpparibas|boehringer|capitalone|consulting|creditcard|cuisinella|eurovision|extraspace|foundation|healthcare|immobilien|industries|management|mitsubishi|nextdirect|properties|protection|prudential|realestate|republican|restaurant|schaeffler|tatamotors|technology|university|vlaanderen|volkswagen|xn--30rr7y|xn--3pxu8k|xn--45q11c|xn--4gbrim|xn--55qx5d|xn--5tzm5g|xn--80aswg|xn--90a3ac|xn--9dbq2a|xn--9et52u|xn--c2br7g|xn--cg4bki|xn--czrs0t|xn--czru2d|xn--fiq64b|xn--fiqs8s|xn--fiqz9s|xn--io0a7i|xn--kput3i|xn--mxtq1m|xn--o3cw4h|xn--pssy2u|xn--q7ce6a|xn--unup4y|xn--wgbh1c|xn--wgbl6a|xn--y9a3aq|accenture|alfaromeo|allfinanz|amsterdam|analytics|aquarelle|barcelona|bloomberg|christmas|community|directory|education|equipment|fairwinds|financial|firestone|fresenius|frontdoor|furniture|goldpoint|hisamitsu|homedepot|homegoods|homesense|institute|insurance|kuokgroup|lancaster|landrover|lifestyle|marketing|marshalls|melbourne|microsoft|panasonic|passagens|pramerica|richardli|shangrila|solutions|statebank|statefarm|stockholm|travelers|vacations|xn--90ais|xn--c1avg|xn--d1alf|xn--e1a4c|xn--fhbei|xn--j1aef|xn--j1amh|xn--l1acc|xn--ngbrx|xn--nqv7f|xn--p1acf|xn--qxa6a|xn--tckwe|xn--vhquv|yodobashi|موريتانيا|abudhabi|airforce|allstate|attorney|barclays|barefoot|bargains|baseball|boutique|bradesco|broadway|brussels|builders|business|capetown|catering|catholic|cipriani|cityeats|cleaning|clinique|clothing|commbank|computer|delivery|deloitte|democrat|diamonds|discount|discover|download|engineer|ericsson|etisalat|exchange|feedback|fidelity|firmdale|football|frontier|goodyear|grainger|graphics|guardian|hdfcbank|helsinki|holdings|hospital|infiniti|ipiranga|istanbul|jpmorgan|lighting|lundbeck|marriott|maserati|mckinsey|memorial|merckmsd|mortgage|observer|partners|pharmacy|pictures|plumbing|property|redstone|reliance|saarland|samsclub|security|services|shopping|showtime|softbank|software|stcgroup|supplies|training|vanguard|ventures|verisign|woodside|xn--90ae|xn--node|xn--p1ai|xn--qxam|yokohama|السعودية|abogado|academy|agakhan|alibaba|android|athleta|auction|audible|auspost|avianca|banamex|bauhaus|bentley|bestbuy|booking|brother|bugatti|capital|caravan|careers|channel|charity|chintai|citadel|clubmed|college|cologne|comcast|company|compare|contact|cooking|corsica|country|coupons|courses|cricket|cruises|dentist|digital|domains|exposed|express|farmers|fashion|ferrari|ferrero|finance|fishing|fitness|flights|florist|flowers|forsale|frogans|fujitsu|gallery|genting|godaddy|grocery|guitars|hamburg|hangout|hitachi|holiday|hosting|hoteles|hotmail|hyundai|ismaili|jewelry|juniper|kitchen|komatsu|lacaixa|lanxess|lasalle|latrobe|leclerc|limited|lincoln|markets|monster|netbank|netflix|network|neustar|okinawa|oldnavy|organic|origins|philips|pioneer|politie|realtor|recipes|rentals|reviews|rexroth|samsung|sandvik|schmidt|schwarz|science|shiksha|singles|staples|storage|support|surgery|systems|temasek|theater|theatre|tickets|tiffany|toshiba|trading|walmart|wanggou|watches|weather|website|wedding|whoswho|windows|winners|xfinity|yamaxun|youtube|zuerich|католик|اتصالات|البحرين|الجزائر|العليان|پاکستان|كاثوليك|இந்தியா|abarth|abbott|abbvie|africa|agency|airbus|airtel|alipay|alsace|alstom|amazon|anquan|aramco|author|bayern|beauty|berlin|bharti|bostik|boston|broker|camera|career|casino|center|chanel|chrome|church|circle|claims|clinic|coffee|comsec|condos|coupon|credit|cruise|dating|datsun|dealer|degree|dental|design|direct|doctor|dunlop|dupont|durban|emerck|energy|estate|events|expert|family|flickr|futbol|gallup|garden|george|giving|global|google|gratis|health|hermes|hiphop|hockey|hotels|hughes|imamat|insure|intuit|jaguar|joburg|juegos|kaufen|kinder|kindle|kosher|lancia|latino|lawyer|lefrak|living|locker|london|luxury|madrid|maison|makeup|market|mattel|mobile|monash|mormon|moscow|museum|mutual|nagoya|natura|nissan|nissay|norton|nowruz|office|olayan|online|oracle|orange|otsuka|pfizer|photos|physio|pictet|quebec|racing|realty|reisen|repair|report|review|rocher|rogers|ryukyu|safety|sakura|sanofi|school|schule|search|secure|select|shouji|soccer|social|stream|studio|supply|suzuki|swatch|sydney|taipei|taobao|target|tattoo|tennis|tienda|tjmaxx|tkmaxx|toyota|travel|unicom|viajes|viking|villas|virgin|vision|voting|voyage|vuelos|walter|webcam|xihuan|yachts|yandex|zappos|москва|онлайн|ابوظبي|ارامكو|الاردن|المغرب|امارات|فلسطين|مليسيا|भारतम्|இலங்கை|ファッション|actor|adult|aetna|amfam|amica|apple|archi|audio|autos|azure|baidu|beats|bible|bingo|black|boats|bosch|build|canon|cards|chase|cheap|cisco|citic|click|cloud|coach|codes|crown|cymru|dabur|dance|deals|delta|drive|dubai|earth|edeka|email|epson|faith|fedex|final|forex|forum|gallo|games|gifts|gives|glass|globo|gmail|green|gripe|group|gucci|guide|homes|honda|horse|house|hyatt|ikano|irish|jetzt|koeln|kyoto|lamer|lease|legal|lexus|lilly|linde|lipsy|loans|locus|lotte|lotto|macys|mango|media|miami|money|movie|music|nexus|nikon|ninja|nokia|nowtv|omega|osaka|paris|parts|party|phone|photo|pizza|place|poker|praxi|press|prime|promo|quest|radio|rehab|reise|ricoh|rocks|rodeo|rugby|salon|sener|seven|sharp|shell|shoes|skype|sling|smart|smile|solar|space|sport|stada|store|study|style|sucks|swiss|tatar|tires|tirol|tmall|today|tokyo|tools|toray|total|tours|trade|trust|tunes|tushu|ubank|vegas|video|vodka|volvo|wales|watch|weber|weibo|works|world|xerox|yahoo|ישראל|ایران|بازار|بھارت|سودان|سورية|همراه|भारोत|संगठन|বাংলা|భారత్|ഭാരതം|嘉里大酒店|aarp|able|adac|aero|akdn|ally|amex|arab|army|arpa|arte|asda|asia|audi|auto|baby|band|bank|bbva|beer|best|bike|bing|blog|blue|bofa|bond|book|buzz|cafe|call|camp|care|cars|casa|case|cash|cbre|cern|chat|citi|city|club|cool|coop|cyou|data|date|dclk|deal|dell|desi|diet|dish|docs|dvag|erni|fage|fail|fans|farm|fast|fiat|fido|film|fire|fish|flir|food|ford|free|fund|game|gbiz|gent|ggee|gift|gmbh|gold|golf|goog|guge|guru|hair|haus|hdfc|help|here|hgtv|host|hsbc|icbc|ieee|imdb|immo|info|itau|java|jeep|jobs|jprs|kddi|kids|kiwi|kpmg|kred|land|lego|lgbt|lidl|life|like|limo|link|live|loan|loft|love|ltda|luxe|maif|meet|meme|menu|mini|mint|mobi|moda|moto|name|navy|news|next|nico|nike|ollo|open|page|pars|pccw|pics|ping|pink|play|plus|pohl|porn|post|prod|prof|qpon|read|reit|rent|rest|rich|room|rsvp|ruhr|safe|sale|sarl|save|saxo|scot|seat|seek|sexy|shaw|shia|shop|show|silk|sina|site|skin|sncf|sohu|song|sony|spot|star|surf|talk|taxi|team|tech|teva|tiaa|tips|town|toys|tube|vana|visa|viva|vivo|vote|voto|wang|weir|wien|wiki|wine|work|xbox|yoga|zara|zero|zone|дети|сайт|بارت|بيتك|ڀارت|تونس|شبكة|عراق|عمان|موقع|भारत|ভারত|ভাৰত|ਭਾਰਤ|ભારત|ଭାରତ|ಭಾರತ|ලංකා|アマゾン|グーグル|クラウド|ポイント|组织机构|電訊盈科|香格里拉|aaa|abb|abc|aco|ads|aeg|afl|aig|anz|aol|app|art|aws|axa|bar|bbc|bbt|bcg|bcn|bet|bid|bio|biz|bms|bmw|bom|boo|bot|box|buy|bzh|cab|cal|cam|car|cat|cba|cbn|cbs|ceo|cfa|cfd|com|cpa|crs|dad|day|dds|dev|dhl|diy|dnp|dog|dot|dtv|dvr|eat|eco|edu|esq|eus|fan|fit|fly|foo|fox|frl|ftr|fun|fyi|gal|gap|gay|gdn|gea|gle|gmo|gmx|goo|gop|got|gov|hbo|hiv|hkt|hot|how|ibm|ice|icu|ifm|inc|ing|ink|int|ist|itv|jcb|jio|jll|jmp|jnj|jot|joy|kfh|kia|kim|kpn|krd|lat|law|lds|llc|llp|lol|lpl|ltd|man|map|mba|med|men|mil|mit|mlb|mls|mma|moe|moi|mom|mov|msd|mtn|mtr|nab|nba|nec|net|new|nfl|ngo|nhk|now|nra|nrw|ntt|nyc|obi|one|ong|onl|ooo|org|ott|ovh|pay|pet|phd|pid|pin|pnc|pro|pru|pub|pwc|red|ren|ril|rio|rip|run|rwe|sap|sas|sbi|sbs|sca|scb|ses|sew|sex|sfr|ski|sky|soy|spa|srl|stc|tab|tax|tci|tdk|tel|thd|tjx|top|trv|tui|tvs|ubs|uno|uol|ups|vet|vig|vin|vip|wed|win|wme|wow|wtc|wtf|xin|xxx|xyz|you|yun|zip|бел|ком|қаз|мкд|мон|орг|рус|срб|укр|հայ|קום|عرب|قطر|كوم|مصر|कॉम|नेट|คอม|ไทย|ລາວ|ストア|セール|みんな|中文网|亚马逊|天主教|我爱你|新加坡|淡马锡|诺基亚|飞利浦|ac|ad|ae|af|ag|ai|al|am|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cu|cv|cw|cx|cy|cz|de|dj|dk|dm|do|dz|ec|ee|eg|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|ss|st|su|sv|sx|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|za|zm|zw|ελ|ευ|бг|ею|рф|გე|닷넷|닷컴|삼성|한국|コム|世界|中信|中国|中國|企业|佛山|信息|健康|八卦|公司|公益|台湾|台灣|商城|商店|商标|嘉里|在线|大拿|娱乐|家電|广东|微博|慈善|手机|招聘|政务|政府|新闻|时尚|書籍|机构|游戏|澳門|点看|移动|网址|网店|网站|网络|联通|谷歌|购物|通販|集团|食品|餐厅|香港)/;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/email-matcher.js
var require_email_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/email-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.EmailMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var regex_lib_1 = require_regex_lib();
    var email_match_1 = require_email_match();
    var utils_1 = require_utils();
    var tld_regex_1 = require_tld_regex();
    var localPartCharRegex = new RegExp("[".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "!#$%&'*+/=?^_`{|}~-]"));
    var strictTldRegex = new RegExp("^".concat(tld_regex_1.tldRegex.source, "$"));
    var EmailMatcher = function(_super) {
      (0, tslib_1.__extends)(EmailMatcher2, _super);
      function EmailMatcher2() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.localPartCharRegex = localPartCharRegex;
        _this.strictTldRegex = strictTldRegex;
        return _this;
      }
      EmailMatcher2.prototype.parseMatches = function(text) {
        var tagBuilder = this.tagBuilder, localPartCharRegex2 = this.localPartCharRegex, strictTldRegex2 = this.strictTldRegex, matches = [], len = text.length, noCurrentEmailMatch = new CurrentEmailMatch();
        var mailtoTransitions = {
          m: "a",
          a: "i",
          i: "l",
          l: "t",
          t: "o",
          o: ":"
        };
        var charIdx = 0, state = 0, currentEmailMatch = noCurrentEmailMatch;
        while (charIdx < len) {
          var char = text.charAt(charIdx);
          switch (state) {
            case 0:
              stateNonEmailAddress(char);
              break;
            case 1:
              stateMailTo(text.charAt(charIdx - 1), char);
              break;
            case 2:
              stateLocalPart(char);
              break;
            case 3:
              stateLocalPartDot(char);
              break;
            case 4:
              stateAtSign(char);
              break;
            case 5:
              stateDomainChar(char);
              break;
            case 6:
              stateDomainHyphen(char);
              break;
            case 7:
              stateDomainDot(char);
              break;
            default:
              (0, utils_1.throwUnhandledCaseError)(state);
          }
          charIdx++;
        }
        captureMatchIfValidAndReset();
        return matches;
        function stateNonEmailAddress(char2) {
          if (char2 === "m") {
            beginEmailMatch(1);
          } else if (localPartCharRegex2.test(char2)) {
            beginEmailMatch();
          } else {
          }
        }
        function stateMailTo(prevChar, char2) {
          if (prevChar === ":") {
            if (localPartCharRegex2.test(char2)) {
              state = 2;
              currentEmailMatch = new CurrentEmailMatch((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentEmailMatch), { hasMailtoPrefix: true }));
            } else {
              resetToNonEmailMatchState();
            }
          } else if (mailtoTransitions[prevChar] === char2) {
          } else if (localPartCharRegex2.test(char2)) {
            state = 2;
          } else if (char2 === ".") {
            state = 3;
          } else if (char2 === "@") {
            state = 4;
          } else {
            resetToNonEmailMatchState();
          }
        }
        function stateLocalPart(char2) {
          if (char2 === ".") {
            state = 3;
          } else if (char2 === "@") {
            state = 4;
          } else if (localPartCharRegex2.test(char2)) {
          } else {
            resetToNonEmailMatchState();
          }
        }
        function stateLocalPartDot(char2) {
          if (char2 === ".") {
            resetToNonEmailMatchState();
          } else if (char2 === "@") {
            resetToNonEmailMatchState();
          } else if (localPartCharRegex2.test(char2)) {
            state = 2;
          } else {
            resetToNonEmailMatchState();
          }
        }
        function stateAtSign(char2) {
          if (regex_lib_1.domainNameCharRegex.test(char2)) {
            state = 5;
          } else {
            resetToNonEmailMatchState();
          }
        }
        function stateDomainChar(char2) {
          if (char2 === ".") {
            state = 7;
          } else if (char2 === "-") {
            state = 6;
          } else if (regex_lib_1.domainNameCharRegex.test(char2)) {
          } else {
            captureMatchIfValidAndReset();
          }
        }
        function stateDomainHyphen(char2) {
          if (char2 === "-" || char2 === ".") {
            captureMatchIfValidAndReset();
          } else if (regex_lib_1.domainNameCharRegex.test(char2)) {
            state = 5;
          } else {
            captureMatchIfValidAndReset();
          }
        }
        function stateDomainDot(char2) {
          if (char2 === "." || char2 === "-") {
            captureMatchIfValidAndReset();
          } else if (regex_lib_1.domainNameCharRegex.test(char2)) {
            state = 5;
            currentEmailMatch = new CurrentEmailMatch((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentEmailMatch), { hasDomainDot: true }));
          } else {
            captureMatchIfValidAndReset();
          }
        }
        function beginEmailMatch(newState) {
          if (newState === void 0) {
            newState = 2;
          }
          state = newState;
          currentEmailMatch = new CurrentEmailMatch({ idx: charIdx });
        }
        function resetToNonEmailMatchState() {
          state = 0;
          currentEmailMatch = noCurrentEmailMatch;
        }
        function captureMatchIfValidAndReset() {
          if (currentEmailMatch.hasDomainDot) {
            var matchedText = text.slice(currentEmailMatch.idx, charIdx);
            if (/[-.]$/.test(matchedText)) {
              matchedText = matchedText.slice(0, -1);
            }
            var emailAddress = currentEmailMatch.hasMailtoPrefix ? matchedText.slice("mailto:".length) : matchedText;
            if (doesEmailHaveValidTld(emailAddress)) {
              matches.push(new email_match_1.EmailMatch({
                tagBuilder,
                matchedText,
                offset: currentEmailMatch.idx,
                email: emailAddress
              }));
            }
          }
          resetToNonEmailMatchState();
          function doesEmailHaveValidTld(emailAddress2) {
            var emailAddressTld = emailAddress2.split(".").pop() || "";
            var emailAddressNormalized = emailAddressTld.toLowerCase();
            var isValidTld = strictTldRegex2.test(emailAddressNormalized);
            return isValidTld;
          }
        }
      };
      return EmailMatcher2;
    }(matcher_1.Matcher);
    exports2.EmailMatcher = EmailMatcher;
    var CurrentEmailMatch = function() {
      function CurrentEmailMatch2(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.idx = cfg.idx !== void 0 ? cfg.idx : -1;
        this.hasMailtoPrefix = !!cfg.hasMailtoPrefix;
        this.hasDomainDot = !!cfg.hasDomainDot;
      }
      return CurrentEmailMatch2;
    }();
  }
});

// node_modules/autolinker/dist/commonjs/matcher/url-match-validator.js
var require_url_match_validator = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/url-match-validator.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UrlMatchValidator = void 0;
    var regex_lib_1 = require_regex_lib();
    var UrlMatchValidator = function() {
      function UrlMatchValidator2() {
      }
      UrlMatchValidator2.isValid = function(urlMatch, protocolUrlMatch) {
        if (protocolUrlMatch && !this.isValidUriScheme(protocolUrlMatch) || this.urlMatchDoesNotHaveProtocolOrDot(urlMatch, protocolUrlMatch) || this.urlMatchDoesNotHaveAtLeastOneWordChar(urlMatch, protocolUrlMatch) && !this.isValidIpAddress(urlMatch) || this.containsMultipleDots(urlMatch)) {
          return false;
        }
        return true;
      };
      UrlMatchValidator2.isValidIpAddress = function(uriSchemeMatch) {
        var newRegex = new RegExp(this.hasFullProtocolRegex.source + this.ipRegex.source);
        var uriScheme = uriSchemeMatch.match(newRegex);
        return uriScheme !== null;
      };
      UrlMatchValidator2.containsMultipleDots = function(urlMatch) {
        var stringBeforeSlash = urlMatch;
        if (this.hasFullProtocolRegex.test(urlMatch)) {
          stringBeforeSlash = urlMatch.split("://")[1];
        }
        return stringBeforeSlash.split("/")[0].indexOf("..") > -1;
      };
      UrlMatchValidator2.isValidUriScheme = function(uriSchemeMatch) {
        var uriSchemeMatchArr = uriSchemeMatch.match(this.uriSchemeRegex), uriScheme = uriSchemeMatchArr && uriSchemeMatchArr[0].toLowerCase();
        return uriScheme !== "javascript:" && uriScheme !== "vbscript:";
      };
      UrlMatchValidator2.urlMatchDoesNotHaveProtocolOrDot = function(urlMatch, protocolUrlMatch) {
        return !!urlMatch && (!protocolUrlMatch || !this.hasFullProtocolRegex.test(protocolUrlMatch)) && urlMatch.indexOf(".") === -1;
      };
      UrlMatchValidator2.urlMatchDoesNotHaveAtLeastOneWordChar = function(urlMatch, protocolUrlMatch) {
        if (urlMatch && protocolUrlMatch) {
          return !this.hasFullProtocolRegex.test(protocolUrlMatch) && !this.hasWordCharAfterProtocolRegex.test(urlMatch);
        } else {
          return false;
        }
      };
      UrlMatchValidator2.hasFullProtocolRegex = /^[A-Za-z][-.+A-Za-z0-9]*:\/\//;
      UrlMatchValidator2.uriSchemeRegex = /^[A-Za-z][-.+A-Za-z0-9]*:/;
      UrlMatchValidator2.hasWordCharAfterProtocolRegex = new RegExp(":[^\\s]*?[" + regex_lib_1.alphaCharsStr + "]");
      UrlMatchValidator2.ipRegex = /[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?\.[0-9][0-9]?[0-9]?(:[0-9]*)?\/?$/;
      return UrlMatchValidator2;
    }();
    exports2.UrlMatchValidator = UrlMatchValidator;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/url-matcher.js
var require_url_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/url-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.UrlMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var regex_lib_1 = require_regex_lib();
    var tld_regex_1 = require_tld_regex();
    var url_match_1 = require_url_match();
    var url_match_validator_1 = require_url_match_validator();
    var matcherRegex = function() {
      var schemeRegex = /(?:[A-Za-z][-.+A-Za-z0-9]{0,63}:(?![A-Za-z][-.+A-Za-z0-9]{0,63}:\/\/)(?!\d+\/?)(?:\/\/)?)/, wwwRegex = /(?:www\.)/, urlSuffixRegex = new RegExp("[/?#](?:[" + regex_lib_1.alphaNumericAndMarksCharsStr + "\\-+&@#/%=~_()|'$*\\[\\]{}?!:,.;^\u2713]*[" + regex_lib_1.alphaNumericAndMarksCharsStr + "\\-+&@#/%=~_()|'$*\\[\\]{}\u2713])?");
      return new RegExp([
        "(?:",
        "(",
        schemeRegex.source,
        (0, regex_lib_1.getDomainNameStr)(2),
        ")",
        "|",
        "(",
        "(//)?",
        wwwRegex.source,
        (0, regex_lib_1.getDomainNameStr)(6),
        ")",
        "|",
        "(",
        "(//)?",
        (0, regex_lib_1.getDomainNameStr)(10) + "\\.",
        tld_regex_1.tldRegex.source,
        "(?![-" + regex_lib_1.alphaNumericCharsStr + "])",
        ")",
        ")",
        "(?::[0-9]+)?",
        "(?:" + urlSuffixRegex.source + ")?"
      ].join(""), "gi");
    }();
    var wordCharRegExp = new RegExp("[" + regex_lib_1.alphaNumericAndMarksCharsStr + "]");
    var UrlMatcher = function(_super) {
      (0, tslib_1.__extends)(UrlMatcher2, _super);
      function UrlMatcher2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.stripPrefix = {
          scheme: true,
          www: true
        };
        _this.stripTrailingSlash = true;
        _this.decodePercentEncoding = true;
        _this.matcherRegex = matcherRegex;
        _this.wordCharRegExp = wordCharRegExp;
        _this.stripPrefix = cfg.stripPrefix;
        _this.stripTrailingSlash = cfg.stripTrailingSlash;
        _this.decodePercentEncoding = cfg.decodePercentEncoding;
        return _this;
      }
      UrlMatcher2.prototype.parseMatches = function(text) {
        var matcherRegex2 = this.matcherRegex, stripPrefix = this.stripPrefix, stripTrailingSlash = this.stripTrailingSlash, decodePercentEncoding = this.decodePercentEncoding, tagBuilder = this.tagBuilder, matches = [], match;
        var _loop_1 = function() {
          var matchStr = match[0], schemeUrlMatch = match[1], wwwUrlMatch = match[4], wwwProtocolRelativeMatch = match[5], tldProtocolRelativeMatch = match[9], offset2 = match.index, protocolRelativeMatch = wwwProtocolRelativeMatch || tldProtocolRelativeMatch, prevChar = text.charAt(offset2 - 1);
          if (!url_match_validator_1.UrlMatchValidator.isValid(matchStr, schemeUrlMatch)) {
            return "continue";
          }
          if (offset2 > 0 && prevChar === "@") {
            return "continue";
          }
          if (offset2 > 0 && protocolRelativeMatch && this_1.wordCharRegExp.test(prevChar)) {
            return "continue";
          }
          if (/\?$/.test(matchStr)) {
            matchStr = matchStr.substr(0, matchStr.length - 1);
          }
          if (this_1.matchHasUnbalancedClosingParen(matchStr)) {
            matchStr = matchStr.substr(0, matchStr.length - 1);
          } else {
            var pos = this_1.matchHasInvalidCharAfterTld(matchStr, schemeUrlMatch);
            if (pos > -1) {
              matchStr = matchStr.substr(0, pos);
            }
          }
          var foundCommonScheme = ["http://", "https://"].find(function(commonScheme) {
            return !!schemeUrlMatch && schemeUrlMatch.indexOf(commonScheme) !== -1;
          });
          if (foundCommonScheme) {
            var indexOfSchemeStart = matchStr.indexOf(foundCommonScheme);
            matchStr = matchStr.substr(indexOfSchemeStart);
            schemeUrlMatch = schemeUrlMatch.substr(indexOfSchemeStart);
            offset2 = offset2 + indexOfSchemeStart;
          }
          var urlMatchType = schemeUrlMatch ? "scheme" : wwwUrlMatch ? "www" : "tld", protocolUrlMatch = !!schemeUrlMatch;
          matches.push(new url_match_1.UrlMatch({
            tagBuilder,
            matchedText: matchStr,
            offset: offset2,
            urlMatchType,
            url: matchStr,
            protocolUrlMatch,
            protocolRelativeMatch: !!protocolRelativeMatch,
            stripPrefix,
            stripTrailingSlash,
            decodePercentEncoding
          }));
        };
        var this_1 = this;
        while ((match = matcherRegex2.exec(text)) !== null) {
          _loop_1();
        }
        return matches;
      };
      UrlMatcher2.prototype.matchHasUnbalancedClosingParen = function(matchStr) {
        var endChar = matchStr.charAt(matchStr.length - 1);
        var startChar;
        if (endChar === ")") {
          startChar = "(";
        } else if (endChar === "]") {
          startChar = "[";
        } else if (endChar === "}") {
          startChar = "{";
        } else {
          return false;
        }
        var numOpenBraces = 0;
        for (var i = 0, len = matchStr.length - 1; i < len; i++) {
          var char = matchStr.charAt(i);
          if (char === startChar) {
            numOpenBraces++;
          } else if (char === endChar) {
            numOpenBraces = Math.max(numOpenBraces - 1, 0);
          }
        }
        if (numOpenBraces === 0) {
          return true;
        }
        return false;
      };
      UrlMatcher2.prototype.matchHasInvalidCharAfterTld = function(urlMatch, schemeUrlMatch) {
        if (!urlMatch) {
          return -1;
        }
        var offset2 = 0;
        if (schemeUrlMatch) {
          offset2 = urlMatch.indexOf(":");
          urlMatch = urlMatch.slice(offset2);
        }
        var re = new RegExp("^((.?//)?[-." + regex_lib_1.alphaNumericAndMarksCharsStr + "]*[-" + regex_lib_1.alphaNumericAndMarksCharsStr + "]\\.[-" + regex_lib_1.alphaNumericAndMarksCharsStr + "]+)");
        var res = re.exec(urlMatch);
        if (res === null) {
          return -1;
        }
        offset2 += res[1].length;
        urlMatch = urlMatch.slice(res[1].length);
        if (/^[^-.A-Za-z0-9:\/?#]/.test(urlMatch)) {
          return offset2;
        }
        return -1;
      };
      return UrlMatcher2;
    }(matcher_1.Matcher);
    exports2.UrlMatcher = UrlMatcher;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/hashtag-matcher.js
var require_hashtag_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/hashtag-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.hashtagServices = exports2.HashtagMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var regex_lib_1 = require_regex_lib();
    var hashtag_match_1 = require_hashtag_match();
    var utils_1 = require_utils();
    var hashtagTextCharRe = new RegExp("[_".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]"));
    var HashtagMatcher = function(_super) {
      (0, tslib_1.__extends)(HashtagMatcher2, _super);
      function HashtagMatcher2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.serviceName = "twitter";
        _this.serviceName = cfg.serviceName;
        return _this;
      }
      HashtagMatcher2.prototype.parseMatches = function(text) {
        var tagBuilder = this.tagBuilder;
        var serviceName = this.serviceName;
        var matches = [];
        var len = text.length;
        var charIdx = 0, hashCharIdx = -1, state = 0;
        while (charIdx < len) {
          var char = text.charAt(charIdx);
          switch (state) {
            case 0:
              stateNone(char);
              break;
            case 1:
              stateNonHashtagWordChar(char);
              break;
            case 2:
              stateHashtagHashChar(char);
              break;
            case 3:
              stateHashtagTextChar(char);
              break;
            default:
              (0, utils_1.throwUnhandledCaseError)(state);
          }
          charIdx++;
        }
        captureMatchIfValid();
        return matches;
        function stateNone(char2) {
          if (char2 === "#") {
            state = 2;
            hashCharIdx = charIdx;
          } else if (regex_lib_1.alphaNumericAndMarksCharRe.test(char2)) {
            state = 1;
          } else {
          }
        }
        function stateNonHashtagWordChar(char2) {
          if (regex_lib_1.alphaNumericAndMarksCharRe.test(char2)) {
          } else {
            state = 0;
          }
        }
        function stateHashtagHashChar(char2) {
          if (hashtagTextCharRe.test(char2)) {
            state = 3;
          } else if (regex_lib_1.alphaNumericAndMarksCharRe.test(char2)) {
            state = 1;
          } else {
            state = 0;
          }
        }
        function stateHashtagTextChar(char2) {
          if (hashtagTextCharRe.test(char2)) {
          } else {
            captureMatchIfValid();
            hashCharIdx = -1;
            if (regex_lib_1.alphaNumericAndMarksCharRe.test(char2)) {
              state = 1;
            } else {
              state = 0;
            }
          }
        }
        function captureMatchIfValid() {
          if (hashCharIdx > -1 && charIdx - hashCharIdx <= 140) {
            var matchedText = text.slice(hashCharIdx, charIdx);
            var match = new hashtag_match_1.HashtagMatch({
              tagBuilder,
              matchedText,
              offset: hashCharIdx,
              serviceName,
              hashtag: matchedText.slice(1)
            });
            matches.push(match);
          }
        }
      };
      return HashtagMatcher2;
    }(matcher_1.Matcher);
    exports2.HashtagMatcher = HashtagMatcher;
    exports2.hashtagServices = ["twitter", "facebook", "instagram", "tiktok"];
  }
});

// node_modules/autolinker/dist/commonjs/matcher/phone-matcher.js
var require_phone_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/phone-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PhoneMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var phone_match_1 = require_phone_match();
    var regex_lib_1 = require_regex_lib();
    var mostPhoneNumbers = /(?:(?:(?:(\+)?\d{1,3}[-\040.]?)?\(?\d{3}\)?[-\040.]?\d{3}[-\040.]?\d{4})|(?:(\+)(?:9[976]\d|8[987530]\d|6[987]\d|5[90]\d|42\d|3[875]\d|2[98654321]\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)[-\040.]?(?:\d[-\040.]?){6,12}\d+))([,;]+[0-9]+#?)*/;
    var japanesePhoneRe = /(0([1-9]{1}-?[1-9]\d{3}|[1-9]{2}-?\d{3}|[1-9]{2}\d{1}-?\d{2}|[1-9]{2}\d{2}-?\d{1})-?\d{4}|0[789]0-?\d{4}-?\d{4}|050-?\d{4}-?\d{4})/;
    var phoneMatcherRegex = new RegExp("".concat(mostPhoneNumbers.source, "|").concat(japanesePhoneRe.source), "g");
    var PhoneMatcher = function(_super) {
      (0, tslib_1.__extends)(PhoneMatcher2, _super);
      function PhoneMatcher2() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.matcherRegex = phoneMatcherRegex;
        return _this;
      }
      PhoneMatcher2.prototype.parseMatches = function(text) {
        var matcherRegex = this.matcherRegex, tagBuilder = this.tagBuilder, matches = [], match;
        while ((match = matcherRegex.exec(text)) !== null) {
          var matchedText = match[0], cleanNumber = matchedText.replace(/[^0-9,;#]/g, ""), plusSign = !!(match[1] || match[2]), before = match.index == 0 ? "" : text.substr(match.index - 1, 1), after = text.substr(match.index + matchedText.length, 1), contextClear = !before.match(/\d/) && !after.match(/\d/);
          if (this.testMatch(match[3]) && this.testMatch(matchedText) && contextClear) {
            matches.push(new phone_match_1.PhoneMatch({
              tagBuilder,
              matchedText,
              offset: match.index,
              number: cleanNumber,
              plusSign
            }));
          }
        }
        return matches;
      };
      PhoneMatcher2.prototype.testMatch = function(text) {
        return regex_lib_1.nonDigitRe.test(text);
      };
      return PhoneMatcher2;
    }(matcher_1.Matcher);
    exports2.PhoneMatcher = PhoneMatcher;
  }
});

// node_modules/autolinker/dist/commonjs/matcher/mention-matcher.js
var require_mention_matcher = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/mention-matcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MentionMatcher = void 0;
    var tslib_1 = require_tslib();
    var matcher_1 = require_matcher();
    var regex_lib_1 = require_regex_lib();
    var mention_match_1 = require_mention_match();
    var twitterRegex = new RegExp("@[_".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,50}(?![_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var instagramRegex = new RegExp("@[_.".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,30}(?![_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var soundcloudRegex = new RegExp("@[-_.".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,50}(?![-_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var tiktokRegex = new RegExp("@[_.".concat(regex_lib_1.alphaNumericAndMarksCharsStr, "]{1,23}[_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "](?![_").concat(regex_lib_1.alphaNumericAndMarksCharsStr, "])"), "g");
    var nonWordCharRegex = new RegExp("[^" + regex_lib_1.alphaNumericAndMarksCharsStr + "]");
    var MentionMatcher = function(_super) {
      (0, tslib_1.__extends)(MentionMatcher2, _super);
      function MentionMatcher2(cfg) {
        var _this = _super.call(this, cfg) || this;
        _this.serviceName = "twitter";
        _this.matcherRegexes = {
          twitter: twitterRegex,
          instagram: instagramRegex,
          soundcloud: soundcloudRegex,
          tiktok: tiktokRegex
        };
        _this.nonWordCharRegex = nonWordCharRegex;
        _this.serviceName = cfg.serviceName;
        return _this;
      }
      MentionMatcher2.prototype.parseMatches = function(text) {
        var serviceName = this.serviceName, matcherRegex = this.matcherRegexes[this.serviceName], nonWordCharRegex2 = this.nonWordCharRegex, tagBuilder = this.tagBuilder, matches = [], match;
        if (!matcherRegex) {
          return matches;
        }
        while ((match = matcherRegex.exec(text)) !== null) {
          var offset2 = match.index, prevChar = text.charAt(offset2 - 1);
          if (offset2 === 0 || nonWordCharRegex2.test(prevChar)) {
            var matchedText = match[0].replace(/\.+$/g, ""), mention = matchedText.slice(1);
            matches.push(new mention_match_1.MentionMatch({
              tagBuilder,
              matchedText,
              offset: offset2,
              serviceName,
              mention
            }));
          }
        }
        return matches;
      };
      return MentionMatcher2;
    }(matcher_1.Matcher);
    exports2.MentionMatcher = MentionMatcher;
  }
});

// node_modules/autolinker/dist/commonjs/htmlParser/parse-html.js
var require_parse_html = __commonJS({
  "node_modules/autolinker/dist/commonjs/htmlParser/parse-html.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseHtml = void 0;
    var tslib_1 = require_tslib();
    var regex_lib_1 = require_regex_lib();
    var utils_1 = require_utils();
    function parseHtml(html, _a) {
      var onOpenTag = _a.onOpenTag, onCloseTag = _a.onCloseTag, onText = _a.onText, onComment = _a.onComment, onDoctype = _a.onDoctype;
      var noCurrentTag = new CurrentTag();
      var charIdx = 0, len = html.length, state = 0, currentDataIdx = 0, currentTag = noCurrentTag;
      while (charIdx < len) {
        var char = html.charAt(charIdx);
        switch (state) {
          case 0:
            stateData(char);
            break;
          case 1:
            stateTagOpen(char);
            break;
          case 2:
            stateEndTagOpen(char);
            break;
          case 3:
            stateTagName(char);
            break;
          case 4:
            stateBeforeAttributeName(char);
            break;
          case 5:
            stateAttributeName(char);
            break;
          case 6:
            stateAfterAttributeName(char);
            break;
          case 7:
            stateBeforeAttributeValue(char);
            break;
          case 8:
            stateAttributeValueDoubleQuoted(char);
            break;
          case 9:
            stateAttributeValueSingleQuoted(char);
            break;
          case 10:
            stateAttributeValueUnquoted(char);
            break;
          case 11:
            stateAfterAttributeValueQuoted(char);
            break;
          case 12:
            stateSelfClosingStartTag(char);
            break;
          case 13:
            stateMarkupDeclarationOpen(char);
            break;
          case 14:
            stateCommentStart(char);
            break;
          case 15:
            stateCommentStartDash(char);
            break;
          case 16:
            stateComment(char);
            break;
          case 17:
            stateCommentEndDash(char);
            break;
          case 18:
            stateCommentEnd(char);
            break;
          case 19:
            stateCommentEndBang(char);
            break;
          case 20:
            stateDoctype(char);
            break;
          default:
            (0, utils_1.throwUnhandledCaseError)(state);
        }
        charIdx++;
      }
      if (currentDataIdx < charIdx) {
        emitText();
      }
      function stateData(char2) {
        if (char2 === "<") {
          startNewTag();
        }
      }
      function stateTagOpen(char2) {
        if (char2 === "!") {
          state = 13;
        } else if (char2 === "/") {
          state = 2;
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { isClosing: true }));
        } else if (char2 === "<") {
          startNewTag();
        } else if (regex_lib_1.letterRe.test(char2)) {
          state = 3;
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { isOpening: true }));
        } else {
          state = 0;
          currentTag = noCurrentTag;
        }
      }
      function stateTagName(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { name: captureTagName() }));
          state = 4;
        } else if (char2 === "<") {
          startNewTag();
        } else if (char2 === "/") {
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { name: captureTagName() }));
          state = 12;
        } else if (char2 === ">") {
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { name: captureTagName() }));
          emitTagAndPreviousTextNode();
        } else if (!regex_lib_1.letterRe.test(char2) && !regex_lib_1.digitRe.test(char2) && char2 !== ":") {
          resetToDataState();
        } else {
        }
      }
      function stateEndTagOpen(char2) {
        if (char2 === ">") {
          resetToDataState();
        } else if (regex_lib_1.letterRe.test(char2)) {
          state = 3;
        } else {
          resetToDataState();
        }
      }
      function stateBeforeAttributeName(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
        } else if (char2 === "/") {
          state = 12;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else if (char2 === "=" || regex_lib_1.quoteRe.test(char2) || regex_lib_1.controlCharsRe.test(char2)) {
          resetToDataState();
        } else {
          state = 5;
        }
      }
      function stateAttributeName(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
          state = 6;
        } else if (char2 === "/") {
          state = 12;
        } else if (char2 === "=") {
          state = 7;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else if (regex_lib_1.quoteRe.test(char2)) {
          resetToDataState();
        } else {
        }
      }
      function stateAfterAttributeName(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
        } else if (char2 === "/") {
          state = 12;
        } else if (char2 === "=") {
          state = 7;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else if (regex_lib_1.quoteRe.test(char2)) {
          resetToDataState();
        } else {
          state = 5;
        }
      }
      function stateBeforeAttributeValue(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
        } else if (char2 === '"') {
          state = 8;
        } else if (char2 === "'") {
          state = 9;
        } else if (/[>=`]/.test(char2)) {
          resetToDataState();
        } else if (char2 === "<") {
          startNewTag();
        } else {
          state = 10;
        }
      }
      function stateAttributeValueDoubleQuoted(char2) {
        if (char2 === '"') {
          state = 11;
        } else {
        }
      }
      function stateAttributeValueSingleQuoted(char2) {
        if (char2 === "'") {
          state = 11;
        } else {
        }
      }
      function stateAttributeValueUnquoted(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
          state = 4;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else {
        }
      }
      function stateAfterAttributeValueQuoted(char2) {
        if (regex_lib_1.whitespaceRe.test(char2)) {
          state = 4;
        } else if (char2 === "/") {
          state = 12;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else {
          state = 4;
          reconsumeCurrentCharacter();
        }
      }
      function stateSelfClosingStartTag(char2) {
        if (char2 === ">") {
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { isClosing: true }));
          emitTagAndPreviousTextNode();
        } else {
          state = 4;
        }
      }
      function stateMarkupDeclarationOpen(char2) {
        if (html.substr(charIdx, 2) === "--") {
          charIdx += 2;
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { type: "comment" }));
          state = 14;
        } else if (html.substr(charIdx, 7).toUpperCase() === "DOCTYPE") {
          charIdx += 7;
          currentTag = new CurrentTag((0, tslib_1.__assign)((0, tslib_1.__assign)({}, currentTag), { type: "doctype" }));
          state = 20;
        } else {
          resetToDataState();
        }
      }
      function stateCommentStart(char2) {
        if (char2 === "-") {
          state = 15;
        } else if (char2 === ">") {
          resetToDataState();
        } else {
          state = 16;
        }
      }
      function stateCommentStartDash(char2) {
        if (char2 === "-") {
          state = 18;
        } else if (char2 === ">") {
          resetToDataState();
        } else {
          state = 16;
        }
      }
      function stateComment(char2) {
        if (char2 === "-") {
          state = 17;
        } else {
        }
      }
      function stateCommentEndDash(char2) {
        if (char2 === "-") {
          state = 18;
        } else {
          state = 16;
        }
      }
      function stateCommentEnd(char2) {
        if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "!") {
          state = 19;
        } else if (char2 === "-") {
        } else {
          state = 16;
        }
      }
      function stateCommentEndBang(char2) {
        if (char2 === "-") {
          state = 17;
        } else if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else {
          state = 16;
        }
      }
      function stateDoctype(char2) {
        if (char2 === ">") {
          emitTagAndPreviousTextNode();
        } else if (char2 === "<") {
          startNewTag();
        } else {
        }
      }
      function resetToDataState() {
        state = 0;
        currentTag = noCurrentTag;
      }
      function startNewTag() {
        state = 1;
        currentTag = new CurrentTag({ idx: charIdx });
      }
      function emitTagAndPreviousTextNode() {
        var textBeforeTag = html.slice(currentDataIdx, currentTag.idx);
        if (textBeforeTag) {
          onText(textBeforeTag, currentDataIdx);
        }
        if (currentTag.type === "comment") {
          onComment(currentTag.idx);
        } else if (currentTag.type === "doctype") {
          onDoctype(currentTag.idx);
        } else {
          if (currentTag.isOpening) {
            onOpenTag(currentTag.name, currentTag.idx);
          }
          if (currentTag.isClosing) {
            onCloseTag(currentTag.name, currentTag.idx);
          }
        }
        resetToDataState();
        currentDataIdx = charIdx + 1;
      }
      function emitText() {
        var text = html.slice(currentDataIdx, charIdx);
        onText(text, currentDataIdx);
        currentDataIdx = charIdx + 1;
      }
      function captureTagName() {
        var startIdx = currentTag.idx + (currentTag.isClosing ? 2 : 1);
        return html.slice(startIdx, charIdx).toLowerCase();
      }
      function reconsumeCurrentCharacter() {
        charIdx--;
      }
    }
    exports2.parseHtml = parseHtml;
    var CurrentTag = function() {
      function CurrentTag2(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.idx = cfg.idx !== void 0 ? cfg.idx : -1;
        this.type = cfg.type || "tag";
        this.name = cfg.name || "";
        this.isOpening = !!cfg.isOpening;
        this.isClosing = !!cfg.isClosing;
      }
      return CurrentTag2;
    }();
  }
});

// node_modules/autolinker/dist/commonjs/autolinker.js
var require_autolinker = __commonJS({
  "node_modules/autolinker/dist/commonjs/autolinker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var version_1 = require_version();
    var utils_1 = require_utils();
    var anchor_tag_builder_1 = require_anchor_tag_builder();
    var match_1 = require_match();
    var email_match_1 = require_email_match();
    var hashtag_match_1 = require_hashtag_match();
    var mention_match_1 = require_mention_match();
    var phone_match_1 = require_phone_match();
    var url_match_1 = require_url_match();
    var matcher_1 = require_matcher();
    var html_tag_1 = require_html_tag();
    var email_matcher_1 = require_email_matcher();
    var url_matcher_1 = require_url_matcher();
    var hashtag_matcher_1 = require_hashtag_matcher();
    var phone_matcher_1 = require_phone_matcher();
    var mention_matcher_1 = require_mention_matcher();
    var parse_html_1 = require_parse_html();
    var Autolinker3 = function() {
      function Autolinker4(cfg) {
        if (cfg === void 0) {
          cfg = {};
        }
        this.version = Autolinker4.version;
        this.urls = {};
        this.email = true;
        this.phone = true;
        this.hashtag = false;
        this.mention = false;
        this.newWindow = true;
        this.stripPrefix = {
          scheme: true,
          www: true
        };
        this.stripTrailingSlash = true;
        this.decodePercentEncoding = true;
        this.truncate = {
          length: 0,
          location: "end"
        };
        this.className = "";
        this.replaceFn = null;
        this.context = void 0;
        this.sanitizeHtml = false;
        this.matchers = null;
        this.tagBuilder = null;
        this.urls = this.normalizeUrlsCfg(cfg.urls);
        this.email = typeof cfg.email === "boolean" ? cfg.email : this.email;
        this.phone = typeof cfg.phone === "boolean" ? cfg.phone : this.phone;
        this.hashtag = cfg.hashtag || this.hashtag;
        this.mention = cfg.mention || this.mention;
        this.newWindow = typeof cfg.newWindow === "boolean" ? cfg.newWindow : this.newWindow;
        this.stripPrefix = this.normalizeStripPrefixCfg(cfg.stripPrefix);
        this.stripTrailingSlash = typeof cfg.stripTrailingSlash === "boolean" ? cfg.stripTrailingSlash : this.stripTrailingSlash;
        this.decodePercentEncoding = typeof cfg.decodePercentEncoding === "boolean" ? cfg.decodePercentEncoding : this.decodePercentEncoding;
        this.sanitizeHtml = cfg.sanitizeHtml || false;
        var mention = this.mention;
        if (mention !== false && ["twitter", "instagram", "soundcloud", "tiktok"].indexOf(mention) === -1) {
          throw new Error("invalid `mention` cfg '".concat(mention, "' - see docs"));
        }
        var hashtag = this.hashtag;
        if (hashtag !== false && hashtag_matcher_1.hashtagServices.indexOf(hashtag) === -1) {
          throw new Error("invalid `hashtag` cfg '".concat(hashtag, "' - see docs"));
        }
        this.truncate = this.normalizeTruncateCfg(cfg.truncate);
        this.className = cfg.className || this.className;
        this.replaceFn = cfg.replaceFn || this.replaceFn;
        this.context = cfg.context || this;
      }
      Autolinker4.link = function(textOrHtml, options) {
        var autolinker3 = new Autolinker4(options);
        return autolinker3.link(textOrHtml);
      };
      Autolinker4.parse = function(textOrHtml, options) {
        var autolinker3 = new Autolinker4(options);
        return autolinker3.parse(textOrHtml);
      };
      Autolinker4.prototype.normalizeUrlsCfg = function(urls) {
        if (urls == null)
          urls = true;
        if (typeof urls === "boolean") {
          return { schemeMatches: urls, wwwMatches: urls, tldMatches: urls };
        } else {
          return {
            schemeMatches: typeof urls.schemeMatches === "boolean" ? urls.schemeMatches : true,
            wwwMatches: typeof urls.wwwMatches === "boolean" ? urls.wwwMatches : true,
            tldMatches: typeof urls.tldMatches === "boolean" ? urls.tldMatches : true
          };
        }
      };
      Autolinker4.prototype.normalizeStripPrefixCfg = function(stripPrefix) {
        if (stripPrefix == null)
          stripPrefix = true;
        if (typeof stripPrefix === "boolean") {
          return { scheme: stripPrefix, www: stripPrefix };
        } else {
          return {
            scheme: typeof stripPrefix.scheme === "boolean" ? stripPrefix.scheme : true,
            www: typeof stripPrefix.www === "boolean" ? stripPrefix.www : true
          };
        }
      };
      Autolinker4.prototype.normalizeTruncateCfg = function(truncate) {
        if (typeof truncate === "number") {
          return { length: truncate, location: "end" };
        } else {
          return (0, utils_1.defaults)(truncate || {}, {
            length: Number.POSITIVE_INFINITY,
            location: "end"
          });
        }
      };
      Autolinker4.prototype.parse = function(textOrHtml) {
        var _this = this;
        var skipTagNames = ["a", "style", "script"], skipTagsStackCount = 0, matches = [];
        (0, parse_html_1.parseHtml)(textOrHtml, {
          onOpenTag: function(tagName) {
            if (skipTagNames.indexOf(tagName) >= 0) {
              skipTagsStackCount++;
            }
          },
          onText: function(text, offset2) {
            if (skipTagsStackCount === 0) {
              var htmlCharacterEntitiesRegex = /(&nbsp;|&#160;|&lt;|&#60;|&gt;|&#62;|&quot;|&#34;|&#39;)/gi;
              var textSplit = (0, utils_1.splitAndCapture)(text, htmlCharacterEntitiesRegex);
              var currentOffset_1 = offset2;
              textSplit.forEach(function(splitText, i) {
                if (i % 2 === 0) {
                  var textNodeMatches = _this.parseText(splitText, currentOffset_1);
                  matches.push.apply(matches, textNodeMatches);
                }
                currentOffset_1 += splitText.length;
              });
            }
          },
          onCloseTag: function(tagName) {
            if (skipTagNames.indexOf(tagName) >= 0) {
              skipTagsStackCount = Math.max(skipTagsStackCount - 1, 0);
            }
          },
          onComment: function(offset2) {
          },
          onDoctype: function(offset2) {
          }
        });
        matches = this.compactMatches(matches);
        matches = this.removeUnwantedMatches(matches);
        return matches;
      };
      Autolinker4.prototype.compactMatches = function(matches) {
        matches.sort(function(a3, b) {
          return a3.getOffset() - b.getOffset();
        });
        var i = 0;
        while (i < matches.length - 1) {
          var match = matches[i], offset2 = match.getOffset(), matchedTextLength = match.getMatchedText().length, endIdx = offset2 + matchedTextLength;
          if (i + 1 < matches.length) {
            if (matches[i + 1].getOffset() === offset2) {
              var removeIdx = matches[i + 1].getMatchedText().length > matchedTextLength ? i : i + 1;
              matches.splice(removeIdx, 1);
              continue;
            }
            if (matches[i + 1].getOffset() < endIdx) {
              matches.splice(i + 1, 1);
              continue;
            }
          }
          i++;
        }
        return matches;
      };
      Autolinker4.prototype.removeUnwantedMatches = function(matches) {
        if (!this.hashtag)
          (0, utils_1.remove)(matches, function(match) {
            return match.getType() === "hashtag";
          });
        if (!this.email)
          (0, utils_1.remove)(matches, function(match) {
            return match.getType() === "email";
          });
        if (!this.phone)
          (0, utils_1.remove)(matches, function(match) {
            return match.getType() === "phone";
          });
        if (!this.mention)
          (0, utils_1.remove)(matches, function(match) {
            return match.getType() === "mention";
          });
        if (!this.urls.schemeMatches) {
          (0, utils_1.remove)(matches, function(m) {
            return m.getType() === "url" && m.getUrlMatchType() === "scheme";
          });
        }
        if (!this.urls.wwwMatches) {
          (0, utils_1.remove)(matches, function(m) {
            return m.getType() === "url" && m.getUrlMatchType() === "www";
          });
        }
        if (!this.urls.tldMatches) {
          (0, utils_1.remove)(matches, function(m) {
            return m.getType() === "url" && m.getUrlMatchType() === "tld";
          });
        }
        return matches;
      };
      Autolinker4.prototype.parseText = function(text, offset2) {
        if (offset2 === void 0) {
          offset2 = 0;
        }
        offset2 = offset2 || 0;
        var matchers = this.getMatchers(), matches = [];
        for (var i = 0, numMatchers = matchers.length; i < numMatchers; i++) {
          var textMatches = matchers[i].parseMatches(text);
          for (var j = 0, numTextMatches = textMatches.length; j < numTextMatches; j++) {
            textMatches[j].setOffset(offset2 + textMatches[j].getOffset());
          }
          matches.push.apply(matches, textMatches);
        }
        return matches;
      };
      Autolinker4.prototype.link = function(textOrHtml) {
        if (!textOrHtml) {
          return "";
        }
        if (this.sanitizeHtml) {
          textOrHtml = textOrHtml.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        }
        var matches = this.parse(textOrHtml), newHtml = [], lastIndex = 0;
        for (var i = 0, len = matches.length; i < len; i++) {
          var match = matches[i];
          newHtml.push(textOrHtml.substring(lastIndex, match.getOffset()));
          newHtml.push(this.createMatchReturnVal(match));
          lastIndex = match.getOffset() + match.getMatchedText().length;
        }
        newHtml.push(textOrHtml.substring(lastIndex));
        return newHtml.join("");
      };
      Autolinker4.prototype.createMatchReturnVal = function(match) {
        var replaceFnResult;
        if (this.replaceFn) {
          replaceFnResult = this.replaceFn.call(this.context, match);
        }
        if (typeof replaceFnResult === "string") {
          return replaceFnResult;
        } else if (replaceFnResult === false) {
          return match.getMatchedText();
        } else if (replaceFnResult instanceof html_tag_1.HtmlTag) {
          return replaceFnResult.toAnchorString();
        } else {
          var anchorTag = match.buildTag();
          return anchorTag.toAnchorString();
        }
      };
      Autolinker4.prototype.getMatchers = function() {
        if (!this.matchers) {
          var tagBuilder = this.getTagBuilder();
          var matchers = [
            new hashtag_matcher_1.HashtagMatcher({
              tagBuilder,
              serviceName: this.hashtag
            }),
            new email_matcher_1.EmailMatcher({ tagBuilder }),
            new phone_matcher_1.PhoneMatcher({ tagBuilder }),
            new mention_matcher_1.MentionMatcher({
              tagBuilder,
              serviceName: this.mention
            }),
            new url_matcher_1.UrlMatcher({
              tagBuilder,
              stripPrefix: this.stripPrefix,
              stripTrailingSlash: this.stripTrailingSlash,
              decodePercentEncoding: this.decodePercentEncoding
            })
          ];
          return this.matchers = matchers;
        } else {
          return this.matchers;
        }
      };
      Autolinker4.prototype.getTagBuilder = function() {
        var tagBuilder = this.tagBuilder;
        if (!tagBuilder) {
          tagBuilder = this.tagBuilder = new anchor_tag_builder_1.AnchorTagBuilder({
            newWindow: this.newWindow,
            truncate: this.truncate,
            className: this.className
          });
        }
        return tagBuilder;
      };
      Autolinker4.version = version_1.version;
      Autolinker4.AnchorTagBuilder = anchor_tag_builder_1.AnchorTagBuilder;
      Autolinker4.HtmlTag = html_tag_1.HtmlTag;
      Autolinker4.matcher = {
        Email: email_matcher_1.EmailMatcher,
        Hashtag: hashtag_matcher_1.HashtagMatcher,
        Matcher: matcher_1.Matcher,
        Mention: mention_matcher_1.MentionMatcher,
        Phone: phone_matcher_1.PhoneMatcher,
        Url: url_matcher_1.UrlMatcher
      };
      Autolinker4.match = {
        Email: email_match_1.EmailMatch,
        Hashtag: hashtag_match_1.HashtagMatch,
        Match: match_1.Match,
        Mention: mention_match_1.MentionMatch,
        Phone: phone_match_1.PhoneMatch,
        Url: url_match_1.UrlMatch
      };
      return Autolinker4;
    }();
    exports2.default = Autolinker3;
  }
});

// node_modules/autolinker/dist/commonjs/match/index.js
var require_match2 = __commonJS({
  "node_modules/autolinker/dist/commonjs/match/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = require_tslib();
    (0, tslib_1.__exportStar)(require_email_match(), exports2);
    (0, tslib_1.__exportStar)(require_hashtag_match(), exports2);
    (0, tslib_1.__exportStar)(require_match(), exports2);
    (0, tslib_1.__exportStar)(require_mention_match(), exports2);
    (0, tslib_1.__exportStar)(require_phone_match(), exports2);
    (0, tslib_1.__exportStar)(require_url_match(), exports2);
  }
});

// node_modules/autolinker/dist/commonjs/matcher/index.js
var require_matcher2 = __commonJS({
  "node_modules/autolinker/dist/commonjs/matcher/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var tslib_1 = require_tslib();
    (0, tslib_1.__exportStar)(require_email_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_hashtag_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_mention_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_phone_matcher(), exports2);
    (0, tslib_1.__exportStar)(require_url_matcher(), exports2);
  }
});

// node_modules/autolinker/dist/commonjs/index.js
var require_commonjs = __commonJS({
  "node_modules/autolinker/dist/commonjs/index.js"(exports2, module2) {
    "use strict";
    exports2 = module2.exports = require_autolinker().default;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Autolinker = void 0;
    var tslib_1 = require_tslib();
    var autolinker_1 = (0, tslib_1.__importDefault)(require_autolinker());
    exports2.Autolinker = autolinker_1.default;
    exports2.default = autolinker_1.default;
    (0, tslib_1.__exportStar)(require_autolinker(), exports2);
    (0, tslib_1.__exportStar)(require_anchor_tag_builder(), exports2);
    (0, tslib_1.__exportStar)(require_html_tag(), exports2);
    (0, tslib_1.__exportStar)(require_match2(), exports2);
    (0, tslib_1.__exportStar)(require_matcher2(), exports2);
  }
});

// node_modules/@tweenjs/tween.js/dist/tween.cjs.js
var require_tween_cjs = __commonJS({
  "node_modules/@tweenjs/tween.js/dist/tween.cjs.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var Easing2 = {
      Linear: {
        None: function(amount) {
          return amount;
        }
      },
      Quadratic: {
        In: function(amount) {
          return amount * amount;
        },
        Out: function(amount) {
          return amount * (2 - amount);
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return 0.5 * amount * amount;
          }
          return -0.5 * (--amount * (amount - 2) - 1);
        }
      },
      Cubic: {
        In: function(amount) {
          return amount * amount * amount;
        },
        Out: function(amount) {
          return --amount * amount * amount + 1;
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return 0.5 * amount * amount * amount;
          }
          return 0.5 * ((amount -= 2) * amount * amount + 2);
        }
      },
      Quartic: {
        In: function(amount) {
          return amount * amount * amount * amount;
        },
        Out: function(amount) {
          return 1 - --amount * amount * amount * amount;
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return 0.5 * amount * amount * amount * amount;
          }
          return -0.5 * ((amount -= 2) * amount * amount * amount - 2);
        }
      },
      Quintic: {
        In: function(amount) {
          return amount * amount * amount * amount * amount;
        },
        Out: function(amount) {
          return --amount * amount * amount * amount * amount + 1;
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return 0.5 * amount * amount * amount * amount * amount;
          }
          return 0.5 * ((amount -= 2) * amount * amount * amount * amount + 2);
        }
      },
      Sinusoidal: {
        In: function(amount) {
          return 1 - Math.cos(amount * Math.PI / 2);
        },
        Out: function(amount) {
          return Math.sin(amount * Math.PI / 2);
        },
        InOut: function(amount) {
          return 0.5 * (1 - Math.cos(Math.PI * amount));
        }
      },
      Exponential: {
        In: function(amount) {
          return amount === 0 ? 0 : Math.pow(1024, amount - 1);
        },
        Out: function(amount) {
          return amount === 1 ? 1 : 1 - Math.pow(2, -10 * amount);
        },
        InOut: function(amount) {
          if (amount === 0) {
            return 0;
          }
          if (amount === 1) {
            return 1;
          }
          if ((amount *= 2) < 1) {
            return 0.5 * Math.pow(1024, amount - 1);
          }
          return 0.5 * (-Math.pow(2, -10 * (amount - 1)) + 2);
        }
      },
      Circular: {
        In: function(amount) {
          return 1 - Math.sqrt(1 - amount * amount);
        },
        Out: function(amount) {
          return Math.sqrt(1 - --amount * amount);
        },
        InOut: function(amount) {
          if ((amount *= 2) < 1) {
            return -0.5 * (Math.sqrt(1 - amount * amount) - 1);
          }
          return 0.5 * (Math.sqrt(1 - (amount -= 2) * amount) + 1);
        }
      },
      Elastic: {
        In: function(amount) {
          if (amount === 0) {
            return 0;
          }
          if (amount === 1) {
            return 1;
          }
          return -Math.pow(2, 10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI);
        },
        Out: function(amount) {
          if (amount === 0) {
            return 0;
          }
          if (amount === 1) {
            return 1;
          }
          return Math.pow(2, -10 * amount) * Math.sin((amount - 0.1) * 5 * Math.PI) + 1;
        },
        InOut: function(amount) {
          if (amount === 0) {
            return 0;
          }
          if (amount === 1) {
            return 1;
          }
          amount *= 2;
          if (amount < 1) {
            return -0.5 * Math.pow(2, 10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI);
          }
          return 0.5 * Math.pow(2, -10 * (amount - 1)) * Math.sin((amount - 1.1) * 5 * Math.PI) + 1;
        }
      },
      Back: {
        In: function(amount) {
          var s = 1.70158;
          return amount * amount * ((s + 1) * amount - s);
        },
        Out: function(amount) {
          var s = 1.70158;
          return --amount * amount * ((s + 1) * amount + s) + 1;
        },
        InOut: function(amount) {
          var s = 1.70158 * 1.525;
          if ((amount *= 2) < 1) {
            return 0.5 * (amount * amount * ((s + 1) * amount - s));
          }
          return 0.5 * ((amount -= 2) * amount * ((s + 1) * amount + s) + 2);
        }
      },
      Bounce: {
        In: function(amount) {
          return 1 - Easing2.Bounce.Out(1 - amount);
        },
        Out: function(amount) {
          if (amount < 1 / 2.75) {
            return 7.5625 * amount * amount;
          } else if (amount < 2 / 2.75) {
            return 7.5625 * (amount -= 1.5 / 2.75) * amount + 0.75;
          } else if (amount < 2.5 / 2.75) {
            return 7.5625 * (amount -= 2.25 / 2.75) * amount + 0.9375;
          } else {
            return 7.5625 * (amount -= 2.625 / 2.75) * amount + 0.984375;
          }
        },
        InOut: function(amount) {
          if (amount < 0.5) {
            return Easing2.Bounce.In(amount * 2) * 0.5;
          }
          return Easing2.Bounce.Out(amount * 2 - 1) * 0.5 + 0.5;
        }
      }
    };
    var now;
    if (typeof self === "undefined" && typeof process !== "undefined" && process.hrtime) {
      now = function() {
        var time = process.hrtime();
        return time[0] * 1e3 + time[1] / 1e6;
      };
    } else if (typeof self !== "undefined" && self.performance !== void 0 && self.performance.now !== void 0) {
      now = self.performance.now.bind(self.performance);
    } else if (Date.now !== void 0) {
      now = Date.now;
    } else {
      now = function() {
        return new Date().getTime();
      };
    }
    var now$1 = now;
    var Group = function() {
      function Group2() {
        this._tweens = {};
        this._tweensAddedDuringUpdate = {};
      }
      Group2.prototype.getAll = function() {
        var _this = this;
        return Object.keys(this._tweens).map(function(tweenId) {
          return _this._tweens[tweenId];
        });
      };
      Group2.prototype.removeAll = function() {
        this._tweens = {};
      };
      Group2.prototype.add = function(tween) {
        this._tweens[tween.getId()] = tween;
        this._tweensAddedDuringUpdate[tween.getId()] = tween;
      };
      Group2.prototype.remove = function(tween) {
        delete this._tweens[tween.getId()];
        delete this._tweensAddedDuringUpdate[tween.getId()];
      };
      Group2.prototype.update = function(time, preserve) {
        if (time === void 0) {
          time = now$1();
        }
        if (preserve === void 0) {
          preserve = false;
        }
        var tweenIds = Object.keys(this._tweens);
        if (tweenIds.length === 0) {
          return false;
        }
        while (tweenIds.length > 0) {
          this._tweensAddedDuringUpdate = {};
          for (var i = 0; i < tweenIds.length; i++) {
            var tween = this._tweens[tweenIds[i]];
            var autoStart = !preserve;
            if (tween && tween.update(time, autoStart) === false && !preserve) {
              delete this._tweens[tweenIds[i]];
            }
          }
          tweenIds = Object.keys(this._tweensAddedDuringUpdate);
        }
        return true;
      };
      return Group2;
    }();
    var Interpolation = {
      Linear: function(v7, k) {
        var m = v7.length - 1;
        var f = m * k;
        var i = Math.floor(f);
        var fn = Interpolation.Utils.Linear;
        if (k < 0) {
          return fn(v7[0], v7[1], f);
        }
        if (k > 1) {
          return fn(v7[m], v7[m - 1], m - f);
        }
        return fn(v7[i], v7[i + 1 > m ? m : i + 1], f - i);
      },
      Bezier: function(v7, k) {
        var b = 0;
        var n = v7.length - 1;
        var pw = Math.pow;
        var bn = Interpolation.Utils.Bernstein;
        for (var i = 0; i <= n; i++) {
          b += pw(1 - k, n - i) * pw(k, i) * v7[i] * bn(n, i);
        }
        return b;
      },
      CatmullRom: function(v7, k) {
        var m = v7.length - 1;
        var f = m * k;
        var i = Math.floor(f);
        var fn = Interpolation.Utils.CatmullRom;
        if (v7[0] === v7[m]) {
          if (k < 0) {
            i = Math.floor(f = m * (1 + k));
          }
          return fn(v7[(i - 1 + m) % m], v7[i], v7[(i + 1) % m], v7[(i + 2) % m], f - i);
        } else {
          if (k < 0) {
            return v7[0] - (fn(v7[0], v7[0], v7[1], v7[1], -f) - v7[0]);
          }
          if (k > 1) {
            return v7[m] - (fn(v7[m], v7[m], v7[m - 1], v7[m - 1], f - m) - v7[m]);
          }
          return fn(v7[i ? i - 1 : 0], v7[i], v7[m < i + 1 ? m : i + 1], v7[m < i + 2 ? m : i + 2], f - i);
        }
      },
      Utils: {
        Linear: function(p0, p1, t) {
          return (p1 - p0) * t + p0;
        },
        Bernstein: function(n, i) {
          var fc = Interpolation.Utils.Factorial;
          return fc(n) / fc(i) / fc(n - i);
        },
        Factorial: function() {
          var a3 = [1];
          return function(n) {
            var s = 1;
            if (a3[n]) {
              return a3[n];
            }
            for (var i = n; i > 1; i--) {
              s *= i;
            }
            a3[n] = s;
            return s;
          };
        }(),
        CatmullRom: function(p0, p1, p2, p3, t) {
          var v02 = (p2 - p0) * 0.5;
          var v13 = (p3 - p1) * 0.5;
          var t2 = t * t;
          var t3 = t * t2;
          return (2 * p1 - 2 * p2 + v02 + v13) * t3 + (-3 * p1 + 3 * p2 - 2 * v02 - v13) * t2 + v02 * t + p1;
        }
      }
    };
    var Sequence = function() {
      function Sequence2() {
      }
      Sequence2.nextId = function() {
        return Sequence2._nextId++;
      };
      Sequence2._nextId = 0;
      return Sequence2;
    }();
    var mainGroup = new Group();
    var Tween2 = function() {
      function Tween3(_object, _group) {
        if (_group === void 0) {
          _group = mainGroup;
        }
        this._object = _object;
        this._group = _group;
        this._isPaused = false;
        this._pauseStart = 0;
        this._valuesStart = {};
        this._valuesEnd = {};
        this._valuesStartRepeat = {};
        this._duration = 1e3;
        this._initialRepeat = 0;
        this._repeat = 0;
        this._yoyo = false;
        this._isPlaying = false;
        this._reversed = false;
        this._delayTime = 0;
        this._startTime = 0;
        this._easingFunction = Easing2.Linear.None;
        this._interpolationFunction = Interpolation.Linear;
        this._chainedTweens = [];
        this._onStartCallbackFired = false;
        this._id = Sequence.nextId();
        this._isChainStopped = false;
        this._goToEnd = false;
      }
      Tween3.prototype.getId = function() {
        return this._id;
      };
      Tween3.prototype.isPlaying = function() {
        return this._isPlaying;
      };
      Tween3.prototype.isPaused = function() {
        return this._isPaused;
      };
      Tween3.prototype.to = function(properties, duration) {
        this._valuesEnd = Object.create(properties);
        if (duration !== void 0) {
          this._duration = duration;
        }
        return this;
      };
      Tween3.prototype.duration = function(d) {
        this._duration = d;
        return this;
      };
      Tween3.prototype.start = function(time) {
        if (this._isPlaying) {
          return this;
        }
        this._group && this._group.add(this);
        this._repeat = this._initialRepeat;
        if (this._reversed) {
          this._reversed = false;
          for (var property in this._valuesStartRepeat) {
            this._swapEndStartRepeatValues(property);
            this._valuesStart[property] = this._valuesStartRepeat[property];
          }
        }
        this._isPlaying = true;
        this._isPaused = false;
        this._onStartCallbackFired = false;
        this._isChainStopped = false;
        this._startTime = time !== void 0 ? typeof time === "string" ? now$1() + parseFloat(time) : time : now$1();
        this._startTime += this._delayTime;
        this._setupProperties(this._object, this._valuesStart, this._valuesEnd, this._valuesStartRepeat);
        return this;
      };
      Tween3.prototype._setupProperties = function(_object, _valuesStart, _valuesEnd, _valuesStartRepeat) {
        for (var property in _valuesEnd) {
          var startValue = _object[property];
          var startValueIsArray = Array.isArray(startValue);
          var propType = startValueIsArray ? "array" : typeof startValue;
          var isInterpolationList = !startValueIsArray && Array.isArray(_valuesEnd[property]);
          if (propType === "undefined" || propType === "function") {
            continue;
          }
          if (isInterpolationList) {
            var endValues = _valuesEnd[property];
            if (endValues.length === 0) {
              continue;
            }
            endValues = endValues.map(this._handleRelativeValue.bind(this, startValue));
            _valuesEnd[property] = [startValue].concat(endValues);
          }
          if ((propType === "object" || startValueIsArray) && startValue && !isInterpolationList) {
            _valuesStart[property] = startValueIsArray ? [] : {};
            for (var prop in startValue) {
              _valuesStart[property][prop] = startValue[prop];
            }
            _valuesStartRepeat[property] = startValueIsArray ? [] : {};
            this._setupProperties(startValue, _valuesStart[property], _valuesEnd[property], _valuesStartRepeat[property]);
          } else {
            if (typeof _valuesStart[property] === "undefined") {
              _valuesStart[property] = startValue;
            }
            if (!startValueIsArray) {
              _valuesStart[property] *= 1;
            }
            if (isInterpolationList) {
              _valuesStartRepeat[property] = _valuesEnd[property].slice().reverse();
            } else {
              _valuesStartRepeat[property] = _valuesStart[property] || 0;
            }
          }
        }
      };
      Tween3.prototype.stop = function() {
        if (!this._isChainStopped) {
          this._isChainStopped = true;
          this.stopChainedTweens();
        }
        if (!this._isPlaying) {
          return this;
        }
        this._group && this._group.remove(this);
        this._isPlaying = false;
        this._isPaused = false;
        if (this._onStopCallback) {
          this._onStopCallback(this._object);
        }
        return this;
      };
      Tween3.prototype.end = function() {
        this._goToEnd = true;
        this.update(Infinity);
        return this;
      };
      Tween3.prototype.pause = function(time) {
        if (time === void 0) {
          time = now$1();
        }
        if (this._isPaused || !this._isPlaying) {
          return this;
        }
        this._isPaused = true;
        this._pauseStart = time;
        this._group && this._group.remove(this);
        return this;
      };
      Tween3.prototype.resume = function(time) {
        if (time === void 0) {
          time = now$1();
        }
        if (!this._isPaused || !this._isPlaying) {
          return this;
        }
        this._isPaused = false;
        this._startTime += time - this._pauseStart;
        this._pauseStart = 0;
        this._group && this._group.add(this);
        return this;
      };
      Tween3.prototype.stopChainedTweens = function() {
        for (var i = 0, numChainedTweens = this._chainedTweens.length; i < numChainedTweens; i++) {
          this._chainedTweens[i].stop();
        }
        return this;
      };
      Tween3.prototype.group = function(group) {
        this._group = group;
        return this;
      };
      Tween3.prototype.delay = function(amount) {
        this._delayTime = amount;
        return this;
      };
      Tween3.prototype.repeat = function(times) {
        this._initialRepeat = times;
        this._repeat = times;
        return this;
      };
      Tween3.prototype.repeatDelay = function(amount) {
        this._repeatDelayTime = amount;
        return this;
      };
      Tween3.prototype.yoyo = function(yoyo) {
        this._yoyo = yoyo;
        return this;
      };
      Tween3.prototype.easing = function(easingFunction) {
        this._easingFunction = easingFunction;
        return this;
      };
      Tween3.prototype.interpolation = function(interpolationFunction) {
        this._interpolationFunction = interpolationFunction;
        return this;
      };
      Tween3.prototype.chain = function() {
        var tweens = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          tweens[_i] = arguments[_i];
        }
        this._chainedTweens = tweens;
        return this;
      };
      Tween3.prototype.onStart = function(callback) {
        this._onStartCallback = callback;
        return this;
      };
      Tween3.prototype.onUpdate = function(callback) {
        this._onUpdateCallback = callback;
        return this;
      };
      Tween3.prototype.onRepeat = function(callback) {
        this._onRepeatCallback = callback;
        return this;
      };
      Tween3.prototype.onComplete = function(callback) {
        this._onCompleteCallback = callback;
        return this;
      };
      Tween3.prototype.onStop = function(callback) {
        this._onStopCallback = callback;
        return this;
      };
      Tween3.prototype.update = function(time, autoStart) {
        if (time === void 0) {
          time = now$1();
        }
        if (autoStart === void 0) {
          autoStart = true;
        }
        if (this._isPaused)
          return true;
        var property;
        var elapsed;
        var endTime = this._startTime + this._duration;
        if (!this._goToEnd && !this._isPlaying) {
          if (time > endTime)
            return false;
          if (autoStart)
            this.start(time);
        }
        this._goToEnd = false;
        if (time < this._startTime) {
          return true;
        }
        if (this._onStartCallbackFired === false) {
          if (this._onStartCallback) {
            this._onStartCallback(this._object);
          }
          this._onStartCallbackFired = true;
        }
        elapsed = (time - this._startTime) / this._duration;
        elapsed = this._duration === 0 || elapsed > 1 ? 1 : elapsed;
        var value = this._easingFunction(elapsed);
        this._updateProperties(this._object, this._valuesStart, this._valuesEnd, value);
        if (this._onUpdateCallback) {
          this._onUpdateCallback(this._object, elapsed);
        }
        if (elapsed === 1) {
          if (this._repeat > 0) {
            if (isFinite(this._repeat)) {
              this._repeat--;
            }
            for (property in this._valuesStartRepeat) {
              if (!this._yoyo && typeof this._valuesEnd[property] === "string") {
                this._valuesStartRepeat[property] = this._valuesStartRepeat[property] + parseFloat(this._valuesEnd[property]);
              }
              if (this._yoyo) {
                this._swapEndStartRepeatValues(property);
              }
              this._valuesStart[property] = this._valuesStartRepeat[property];
            }
            if (this._yoyo) {
              this._reversed = !this._reversed;
            }
            if (this._repeatDelayTime !== void 0) {
              this._startTime = time + this._repeatDelayTime;
            } else {
              this._startTime = time + this._delayTime;
            }
            if (this._onRepeatCallback) {
              this._onRepeatCallback(this._object);
            }
            return true;
          } else {
            if (this._onCompleteCallback) {
              this._onCompleteCallback(this._object);
            }
            for (var i = 0, numChainedTweens = this._chainedTweens.length; i < numChainedTweens; i++) {
              this._chainedTweens[i].start(this._startTime + this._duration);
            }
            this._isPlaying = false;
            return false;
          }
        }
        return true;
      };
      Tween3.prototype._updateProperties = function(_object, _valuesStart, _valuesEnd, value) {
        for (var property in _valuesEnd) {
          if (_valuesStart[property] === void 0) {
            continue;
          }
          var start = _valuesStart[property] || 0;
          var end = _valuesEnd[property];
          var startIsArray = Array.isArray(_object[property]);
          var endIsArray = Array.isArray(end);
          var isInterpolationList = !startIsArray && endIsArray;
          if (isInterpolationList) {
            _object[property] = this._interpolationFunction(end, value);
          } else if (typeof end === "object" && end) {
            this._updateProperties(_object[property], start, end, value);
          } else {
            end = this._handleRelativeValue(start, end);
            if (typeof end === "number") {
              _object[property] = start + (end - start) * value;
            }
          }
        }
      };
      Tween3.prototype._handleRelativeValue = function(start, end) {
        if (typeof end !== "string") {
          return end;
        }
        if (end.charAt(0) === "+" || end.charAt(0) === "-") {
          return start + parseFloat(end);
        } else {
          return parseFloat(end);
        }
      };
      Tween3.prototype._swapEndStartRepeatValues = function(property) {
        var tmp2 = this._valuesStartRepeat[property];
        var endValue = this._valuesEnd[property];
        if (typeof endValue === "string") {
          this._valuesStartRepeat[property] = this._valuesStartRepeat[property] + parseFloat(endValue);
        } else {
          this._valuesStartRepeat[property] = this._valuesEnd[property];
        }
        this._valuesEnd[property] = tmp2;
      };
      return Tween3;
    }();
    var VERSION2 = "18.6.4";
    var nextId = Sequence.nextId;
    var TWEEN = mainGroup;
    var getAll = TWEEN.getAll.bind(TWEEN);
    var removeAll = TWEEN.removeAll.bind(TWEEN);
    var add = TWEEN.add.bind(TWEEN);
    var remove3 = TWEEN.remove.bind(TWEEN);
    var update7 = TWEEN.update.bind(TWEEN);
    var exports$1 = {
      Easing: Easing2,
      Group,
      Interpolation,
      now: now$1,
      Sequence,
      nextId,
      Tween: Tween2,
      VERSION: VERSION2,
      getAll,
      removeAll,
      add,
      remove: remove3,
      update: update7
    };
    exports2.Easing = Easing2;
    exports2.Group = Group;
    exports2.Interpolation = Interpolation;
    exports2.Sequence = Sequence;
    exports2.Tween = Tween2;
    exports2.VERSION = VERSION2;
    exports2.add = add;
    exports2.default = exports$1;
    exports2.getAll = getAll;
    exports2.nextId = nextId;
    exports2.now = now$1;
    exports2.remove = remove3;
    exports2.removeAll = removeAll;
    exports2.update = update7;
  }
});

// node_modules/protobufjs/dist/minimal/protobuf.js
var require_protobuf = __commonJS({
  "node_modules/protobufjs/dist/minimal/protobuf.js"(exports, module) {
    /*!
     * protobuf.js v7.2.5 (c) 2016, daniel wirtz
     * compiled tue, 22 aug 2023 00:04:28 utc
     * licensed under the bsd-3-clause license
     * see: https://github.com/dcodeio/protobuf.js for details
     */
    (function(undefined) {
      "use strict";
      (function prelude(modules, cache, entries) {
        function $require(name) {
          var $module = cache[name];
          if (!$module)
            modules[name][0].call($module = cache[name] = { exports: {} }, $require, $module, $module.exports);
          return $module.exports;
        }
        var protobuf3 = $require(entries[0]);
        protobuf3.util.global.protobuf = protobuf3;
        if (typeof define === "function" && define.amd)
          define(["long"], function(Long) {
            if (Long && Long.isLong) {
              protobuf3.util.Long = Long;
              protobuf3.configure();
            }
            return protobuf3;
          });
        if (typeof module === "object" && module && module.exports)
          module.exports = protobuf3;
      })({ 1: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = asPromise;
        function asPromise(fn, ctx) {
          var params = new Array(arguments.length - 1), offset2 = 0, index = 2, pending = true;
          while (index < arguments.length)
            params[offset2++] = arguments[index++];
          return new Promise(function executor(resolve2, reject) {
            params[offset2] = function callback(err) {
              if (pending) {
                pending = false;
                if (err)
                  reject(err);
                else {
                  var params2 = new Array(arguments.length - 1), offset3 = 0;
                  while (offset3 < params2.length)
                    params2[offset3++] = arguments[offset3];
                  resolve2.apply(null, params2);
                }
              }
            };
            try {
              fn.apply(ctx || null, params);
            } catch (err) {
              if (pending) {
                pending = false;
                reject(err);
              }
            }
          });
        }
      }, {}], 2: [function(require2, module2, exports2) {
        "use strict";
        var base64 = exports2;
        base64.length = function length3(string) {
          var p = string.length;
          if (!p)
            return 0;
          var n = 0;
          while (--p % 4 > 1 && string.charAt(p) === "=")
            ++n;
          return Math.ceil(string.length * 3) / 4 - n;
        };
        var b64 = new Array(64);
        var s64 = new Array(123);
        for (var i = 0; i < 64; )
          s64[b64[i] = i < 26 ? i + 65 : i < 52 ? i + 71 : i < 62 ? i - 4 : i - 59 | 43] = i++;
        base64.encode = function encode(buffer, start, end) {
          var parts = null, chunk = [];
          var i2 = 0, j = 0, t;
          while (start < end) {
            var b = buffer[start++];
            switch (j) {
              case 0:
                chunk[i2++] = b64[b >> 2];
                t = (b & 3) << 4;
                j = 1;
                break;
              case 1:
                chunk[i2++] = b64[t | b >> 4];
                t = (b & 15) << 2;
                j = 2;
                break;
              case 2:
                chunk[i2++] = b64[t | b >> 6];
                chunk[i2++] = b64[b & 63];
                j = 0;
                break;
            }
            if (i2 > 8191) {
              (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
              i2 = 0;
            }
          }
          if (j) {
            chunk[i2++] = b64[t];
            chunk[i2++] = 61;
            if (j === 1)
              chunk[i2++] = 61;
          }
          if (parts) {
            if (i2)
              parts.push(String.fromCharCode.apply(String, chunk.slice(0, i2)));
            return parts.join("");
          }
          return String.fromCharCode.apply(String, chunk.slice(0, i2));
        };
        var invalidEncoding = "invalid encoding";
        base64.decode = function decode(string, buffer, offset2) {
          var start = offset2;
          var j = 0, t;
          for (var i2 = 0; i2 < string.length; ) {
            var c = string.charCodeAt(i2++);
            if (c === 61 && j > 1)
              break;
            if ((c = s64[c]) === undefined)
              throw Error(invalidEncoding);
            switch (j) {
              case 0:
                t = c;
                j = 1;
                break;
              case 1:
                buffer[offset2++] = t << 2 | (c & 48) >> 4;
                t = c;
                j = 2;
                break;
              case 2:
                buffer[offset2++] = (t & 15) << 4 | (c & 60) >> 2;
                t = c;
                j = 3;
                break;
              case 3:
                buffer[offset2++] = (t & 3) << 6 | c;
                j = 0;
                break;
            }
          }
          if (j === 1)
            throw Error(invalidEncoding);
          return offset2 - start;
        };
        base64.test = function test(string) {
          return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(string);
        };
      }, {}], 3: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = EventEmitter;
        function EventEmitter() {
          this._listeners = {};
        }
        EventEmitter.prototype.on = function on(evt, fn, ctx) {
          (this._listeners[evt] || (this._listeners[evt] = [])).push({
            fn,
            ctx: ctx || this
          });
          return this;
        };
        EventEmitter.prototype.off = function off(evt, fn) {
          if (evt === undefined)
            this._listeners = {};
          else {
            if (fn === undefined)
              this._listeners[evt] = [];
            else {
              var listeners = this._listeners[evt];
              for (var i = 0; i < listeners.length; )
                if (listeners[i].fn === fn)
                  listeners.splice(i, 1);
                else
                  ++i;
            }
          }
          return this;
        };
        EventEmitter.prototype.emit = function emit(evt) {
          var listeners = this._listeners[evt];
          if (listeners) {
            var args = [], i = 1;
            for (; i < arguments.length; )
              args.push(arguments[i++]);
            for (i = 0; i < listeners.length; )
              listeners[i].fn.apply(listeners[i++].ctx, args);
          }
          return this;
        };
      }, {}], 4: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = factory(factory);
        function factory(exports3) {
          if (typeof Float32Array !== "undefined")
            (function() {
              var f32 = new Float32Array([-0]), f8b = new Uint8Array(f32.buffer), le = f8b[3] === 128;
              function writeFloat_f32_cpy(val, buf, pos) {
                f32[0] = val;
                buf[pos] = f8b[0];
                buf[pos + 1] = f8b[1];
                buf[pos + 2] = f8b[2];
                buf[pos + 3] = f8b[3];
              }
              function writeFloat_f32_rev(val, buf, pos) {
                f32[0] = val;
                buf[pos] = f8b[3];
                buf[pos + 1] = f8b[2];
                buf[pos + 2] = f8b[1];
                buf[pos + 3] = f8b[0];
              }
              exports3.writeFloatLE = le ? writeFloat_f32_cpy : writeFloat_f32_rev;
              exports3.writeFloatBE = le ? writeFloat_f32_rev : writeFloat_f32_cpy;
              function readFloat_f32_cpy(buf, pos) {
                f8b[0] = buf[pos];
                f8b[1] = buf[pos + 1];
                f8b[2] = buf[pos + 2];
                f8b[3] = buf[pos + 3];
                return f32[0];
              }
              function readFloat_f32_rev(buf, pos) {
                f8b[3] = buf[pos];
                f8b[2] = buf[pos + 1];
                f8b[1] = buf[pos + 2];
                f8b[0] = buf[pos + 3];
                return f32[0];
              }
              exports3.readFloatLE = le ? readFloat_f32_cpy : readFloat_f32_rev;
              exports3.readFloatBE = le ? readFloat_f32_rev : readFloat_f32_cpy;
            })();
          else
            (function() {
              function writeFloat_ieee754(writeUint, val, buf, pos) {
                var sign2 = val < 0 ? 1 : 0;
                if (sign2)
                  val = -val;
                if (val === 0)
                  writeUint(1 / val > 0 ? 0 : 2147483648, buf, pos);
                else if (isNaN(val))
                  writeUint(2143289344, buf, pos);
                else if (val > 34028234663852886e22)
                  writeUint((sign2 << 31 | 2139095040) >>> 0, buf, pos);
                else if (val < 11754943508222875e-54)
                  writeUint((sign2 << 31 | Math.round(val / 1401298464324817e-60)) >>> 0, buf, pos);
                else {
                  var exponent = Math.floor(Math.log(val) / Math.LN2), mantissa = Math.round(val * Math.pow(2, -exponent) * 8388608) & 8388607;
                  writeUint((sign2 << 31 | exponent + 127 << 23 | mantissa) >>> 0, buf, pos);
                }
              }
              exports3.writeFloatLE = writeFloat_ieee754.bind(null, writeUintLE);
              exports3.writeFloatBE = writeFloat_ieee754.bind(null, writeUintBE);
              function readFloat_ieee754(readUint, buf, pos) {
                var uint = readUint(buf, pos), sign2 = (uint >> 31) * 2 + 1, exponent = uint >>> 23 & 255, mantissa = uint & 8388607;
                return exponent === 255 ? mantissa ? NaN : sign2 * Infinity : exponent === 0 ? sign2 * 1401298464324817e-60 * mantissa : sign2 * Math.pow(2, exponent - 150) * (mantissa + 8388608);
              }
              exports3.readFloatLE = readFloat_ieee754.bind(null, readUintLE);
              exports3.readFloatBE = readFloat_ieee754.bind(null, readUintBE);
            })();
          if (typeof Float64Array !== "undefined")
            (function() {
              var f64 = new Float64Array([-0]), f8b = new Uint8Array(f64.buffer), le = f8b[7] === 128;
              function writeDouble_f64_cpy(val, buf, pos) {
                f64[0] = val;
                buf[pos] = f8b[0];
                buf[pos + 1] = f8b[1];
                buf[pos + 2] = f8b[2];
                buf[pos + 3] = f8b[3];
                buf[pos + 4] = f8b[4];
                buf[pos + 5] = f8b[5];
                buf[pos + 6] = f8b[6];
                buf[pos + 7] = f8b[7];
              }
              function writeDouble_f64_rev(val, buf, pos) {
                f64[0] = val;
                buf[pos] = f8b[7];
                buf[pos + 1] = f8b[6];
                buf[pos + 2] = f8b[5];
                buf[pos + 3] = f8b[4];
                buf[pos + 4] = f8b[3];
                buf[pos + 5] = f8b[2];
                buf[pos + 6] = f8b[1];
                buf[pos + 7] = f8b[0];
              }
              exports3.writeDoubleLE = le ? writeDouble_f64_cpy : writeDouble_f64_rev;
              exports3.writeDoubleBE = le ? writeDouble_f64_rev : writeDouble_f64_cpy;
              function readDouble_f64_cpy(buf, pos) {
                f8b[0] = buf[pos];
                f8b[1] = buf[pos + 1];
                f8b[2] = buf[pos + 2];
                f8b[3] = buf[pos + 3];
                f8b[4] = buf[pos + 4];
                f8b[5] = buf[pos + 5];
                f8b[6] = buf[pos + 6];
                f8b[7] = buf[pos + 7];
                return f64[0];
              }
              function readDouble_f64_rev(buf, pos) {
                f8b[7] = buf[pos];
                f8b[6] = buf[pos + 1];
                f8b[5] = buf[pos + 2];
                f8b[4] = buf[pos + 3];
                f8b[3] = buf[pos + 4];
                f8b[2] = buf[pos + 5];
                f8b[1] = buf[pos + 6];
                f8b[0] = buf[pos + 7];
                return f64[0];
              }
              exports3.readDoubleLE = le ? readDouble_f64_cpy : readDouble_f64_rev;
              exports3.readDoubleBE = le ? readDouble_f64_rev : readDouble_f64_cpy;
            })();
          else
            (function() {
              function writeDouble_ieee754(writeUint, off0, off1, val, buf, pos) {
                var sign2 = val < 0 ? 1 : 0;
                if (sign2)
                  val = -val;
                if (val === 0) {
                  writeUint(0, buf, pos + off0);
                  writeUint(1 / val > 0 ? 0 : 2147483648, buf, pos + off1);
                } else if (isNaN(val)) {
                  writeUint(0, buf, pos + off0);
                  writeUint(2146959360, buf, pos + off1);
                } else if (val > 17976931348623157e292) {
                  writeUint(0, buf, pos + off0);
                  writeUint((sign2 << 31 | 2146435072) >>> 0, buf, pos + off1);
                } else {
                  var mantissa;
                  if (val < 22250738585072014e-324) {
                    mantissa = val / 5e-324;
                    writeUint(mantissa >>> 0, buf, pos + off0);
                    writeUint((sign2 << 31 | mantissa / 4294967296) >>> 0, buf, pos + off1);
                  } else {
                    var exponent = Math.floor(Math.log(val) / Math.LN2);
                    if (exponent === 1024)
                      exponent = 1023;
                    mantissa = val * Math.pow(2, -exponent);
                    writeUint(mantissa * 4503599627370496 >>> 0, buf, pos + off0);
                    writeUint((sign2 << 31 | exponent + 1023 << 20 | mantissa * 1048576 & 1048575) >>> 0, buf, pos + off1);
                  }
                }
              }
              exports3.writeDoubleLE = writeDouble_ieee754.bind(null, writeUintLE, 0, 4);
              exports3.writeDoubleBE = writeDouble_ieee754.bind(null, writeUintBE, 4, 0);
              function readDouble_ieee754(readUint, off0, off1, buf, pos) {
                var lo = readUint(buf, pos + off0), hi = readUint(buf, pos + off1);
                var sign2 = (hi >> 31) * 2 + 1, exponent = hi >>> 20 & 2047, mantissa = 4294967296 * (hi & 1048575) + lo;
                return exponent === 2047 ? mantissa ? NaN : sign2 * Infinity : exponent === 0 ? sign2 * 5e-324 * mantissa : sign2 * Math.pow(2, exponent - 1075) * (mantissa + 4503599627370496);
              }
              exports3.readDoubleLE = readDouble_ieee754.bind(null, readUintLE, 0, 4);
              exports3.readDoubleBE = readDouble_ieee754.bind(null, readUintBE, 4, 0);
            })();
          return exports3;
        }
        function writeUintLE(val, buf, pos) {
          buf[pos] = val & 255;
          buf[pos + 1] = val >>> 8 & 255;
          buf[pos + 2] = val >>> 16 & 255;
          buf[pos + 3] = val >>> 24;
        }
        function writeUintBE(val, buf, pos) {
          buf[pos] = val >>> 24;
          buf[pos + 1] = val >>> 16 & 255;
          buf[pos + 2] = val >>> 8 & 255;
          buf[pos + 3] = val & 255;
        }
        function readUintLE(buf, pos) {
          return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16 | buf[pos + 3] << 24) >>> 0;
        }
        function readUintBE(buf, pos) {
          return (buf[pos] << 24 | buf[pos + 1] << 16 | buf[pos + 2] << 8 | buf[pos + 3]) >>> 0;
        }
      }, {}], 5: [function(require, module, exports) {
        "use strict";
        module.exports = inquire;
        function inquire(moduleName) {
          try {
            var mod = eval("quire".replace(/^/, "re"))(moduleName);
            if (mod && (mod.length || Object.keys(mod).length))
              return mod;
          } catch (e) {
          }
          return null;
        }
      }, {}], 6: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = pool2;
        function pool2(alloc, slice, size) {
          var SIZE = size || 8192;
          var MAX = SIZE >>> 1;
          var slab = null;
          var offset2 = SIZE;
          return function pool_alloc(size2) {
            if (size2 < 1 || size2 > MAX)
              return alloc(size2);
            if (offset2 + size2 > SIZE) {
              slab = alloc(SIZE);
              offset2 = 0;
            }
            var buf = slice.call(slab, offset2, offset2 += size2);
            if (offset2 & 7)
              offset2 = (offset2 | 7) + 1;
            return buf;
          };
        }
      }, {}], 7: [function(require2, module2, exports2) {
        "use strict";
        var utf8 = exports2;
        utf8.length = function utf8_length(string) {
          var len = 0, c = 0;
          for (var i = 0; i < string.length; ++i) {
            c = string.charCodeAt(i);
            if (c < 128)
              len += 1;
            else if (c < 2048)
              len += 2;
            else if ((c & 64512) === 55296 && (string.charCodeAt(i + 1) & 64512) === 56320) {
              ++i;
              len += 4;
            } else
              len += 3;
          }
          return len;
        };
        utf8.read = function utf8_read(buffer, start, end) {
          var len = end - start;
          if (len < 1)
            return "";
          var parts = null, chunk = [], i = 0, t;
          while (start < end) {
            t = buffer[start++];
            if (t < 128)
              chunk[i++] = t;
            else if (t > 191 && t < 224)
              chunk[i++] = (t & 31) << 6 | buffer[start++] & 63;
            else if (t > 239 && t < 365) {
              t = ((t & 7) << 18 | (buffer[start++] & 63) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63) - 65536;
              chunk[i++] = 55296 + (t >> 10);
              chunk[i++] = 56320 + (t & 1023);
            } else
              chunk[i++] = (t & 15) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63;
            if (i > 8191) {
              (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
              i = 0;
            }
          }
          if (parts) {
            if (i)
              parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
            return parts.join("");
          }
          return String.fromCharCode.apply(String, chunk.slice(0, i));
        };
        utf8.write = function utf8_write(string, buffer, offset2) {
          var start = offset2, c14, c22;
          for (var i = 0; i < string.length; ++i) {
            c14 = string.charCodeAt(i);
            if (c14 < 128) {
              buffer[offset2++] = c14;
            } else if (c14 < 2048) {
              buffer[offset2++] = c14 >> 6 | 192;
              buffer[offset2++] = c14 & 63 | 128;
            } else if ((c14 & 64512) === 55296 && ((c22 = string.charCodeAt(i + 1)) & 64512) === 56320) {
              c14 = 65536 + ((c14 & 1023) << 10) + (c22 & 1023);
              ++i;
              buffer[offset2++] = c14 >> 18 | 240;
              buffer[offset2++] = c14 >> 12 & 63 | 128;
              buffer[offset2++] = c14 >> 6 & 63 | 128;
              buffer[offset2++] = c14 & 63 | 128;
            } else {
              buffer[offset2++] = c14 >> 12 | 224;
              buffer[offset2++] = c14 >> 6 & 63 | 128;
              buffer[offset2++] = c14 & 63 | 128;
            }
          }
          return offset2 - start;
        };
      }, {}], 8: [function(require2, module2, exports2) {
        "use strict";
        var protobuf3 = exports2;
        protobuf3.build = "minimal";
        protobuf3.Writer = require2(16);
        protobuf3.BufferWriter = require2(17);
        protobuf3.Reader = require2(9);
        protobuf3.BufferReader = require2(10);
        protobuf3.util = require2(15);
        protobuf3.rpc = require2(12);
        protobuf3.roots = require2(11);
        protobuf3.configure = configure2;
        function configure2() {
          protobuf3.util._configure();
          protobuf3.Writer._configure(protobuf3.BufferWriter);
          protobuf3.Reader._configure(protobuf3.BufferReader);
        }
        configure2();
      }, { "10": 10, "11": 11, "12": 12, "15": 15, "16": 16, "17": 17, "9": 9 }], 9: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Reader3;
        var util = require2(15);
        var BufferReader;
        var LongBits = util.LongBits, utf8 = util.utf8;
        function indexOutOfRange(reader, writeLength) {
          return RangeError("index out of range: " + reader.pos + " + " + (writeLength || 1) + " > " + reader.len);
        }
        function Reader3(buffer) {
          this.buf = buffer;
          this.pos = 0;
          this.len = buffer.length;
        }
        var create_array = typeof Uint8Array !== "undefined" ? function create_typed_array(buffer) {
          if (buffer instanceof Uint8Array || Array.isArray(buffer))
            return new Reader3(buffer);
          throw Error("illegal buffer");
        } : function create_array2(buffer) {
          if (Array.isArray(buffer))
            return new Reader3(buffer);
          throw Error("illegal buffer");
        };
        var create = function create2() {
          return util.Buffer ? function create_buffer_setup(buffer) {
            return (Reader3.create = function create_buffer(buffer2) {
              return util.Buffer.isBuffer(buffer2) ? new BufferReader(buffer2) : create_array(buffer2);
            })(buffer);
          } : create_array;
        };
        Reader3.create = create();
        Reader3.prototype._slice = util.Array.prototype.subarray || util.Array.prototype.slice;
        Reader3.prototype.uint32 = function read_uint32_setup() {
          var value = 4294967295;
          return function read_uint32() {
            value = (this.buf[this.pos] & 127) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            value = (value | (this.buf[this.pos] & 127) << 7) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            value = (value | (this.buf[this.pos] & 127) << 14) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            value = (value | (this.buf[this.pos] & 127) << 21) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            value = (value | (this.buf[this.pos] & 15) << 28) >>> 0;
            if (this.buf[this.pos++] < 128)
              return value;
            if ((this.pos += 5) > this.len) {
              this.pos = this.len;
              throw indexOutOfRange(this, 10);
            }
            return value;
          };
        }();
        Reader3.prototype.int32 = function read_int32() {
          return this.uint32() | 0;
        };
        Reader3.prototype.sint32 = function read_sint32() {
          var value = this.uint32();
          return value >>> 1 ^ -(value & 1) | 0;
        };
        function readLongVarint() {
          var bits = new LongBits(0, 0);
          var i = 0;
          if (this.len - this.pos > 4) {
            for (; i < 4; ++i) {
              bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
            bits.lo = (bits.lo | (this.buf[this.pos] & 127) << 28) >>> 0;
            bits.hi = (bits.hi | (this.buf[this.pos] & 127) >> 4) >>> 0;
            if (this.buf[this.pos++] < 128)
              return bits;
            i = 0;
          } else {
            for (; i < 3; ++i) {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
              bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
            bits.lo = (bits.lo | (this.buf[this.pos++] & 127) << i * 7) >>> 0;
            return bits;
          }
          if (this.len - this.pos > 4) {
            for (; i < 5; ++i) {
              bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
          } else {
            for (; i < 5; ++i) {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
              bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
              if (this.buf[this.pos++] < 128)
                return bits;
            }
          }
          throw Error("invalid varint encoding");
        }
        Reader3.prototype.bool = function read_bool() {
          return this.uint32() !== 0;
        };
        function readFixed32_end(buf, end) {
          return (buf[end - 4] | buf[end - 3] << 8 | buf[end - 2] << 16 | buf[end - 1] << 24) >>> 0;
        }
        Reader3.prototype.fixed32 = function read_fixed32() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          return readFixed32_end(this.buf, this.pos += 4);
        };
        Reader3.prototype.sfixed32 = function read_sfixed32() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          return readFixed32_end(this.buf, this.pos += 4) | 0;
        };
        function readFixed64() {
          if (this.pos + 8 > this.len)
            throw indexOutOfRange(this, 8);
          return new LongBits(readFixed32_end(this.buf, this.pos += 4), readFixed32_end(this.buf, this.pos += 4));
        }
        Reader3.prototype.float = function read_float() {
          if (this.pos + 4 > this.len)
            throw indexOutOfRange(this, 4);
          var value = util.float.readFloatLE(this.buf, this.pos);
          this.pos += 4;
          return value;
        };
        Reader3.prototype.double = function read_double() {
          if (this.pos + 8 > this.len)
            throw indexOutOfRange(this, 4);
          var value = util.float.readDoubleLE(this.buf, this.pos);
          this.pos += 8;
          return value;
        };
        Reader3.prototype.bytes = function read_bytes() {
          var length3 = this.uint32(), start = this.pos, end = this.pos + length3;
          if (end > this.len)
            throw indexOutOfRange(this, length3);
          this.pos += length3;
          if (Array.isArray(this.buf))
            return this.buf.slice(start, end);
          if (start === end) {
            var nativeBuffer = util.Buffer;
            return nativeBuffer ? nativeBuffer.alloc(0) : new this.buf.constructor(0);
          }
          return this._slice.call(this.buf, start, end);
        };
        Reader3.prototype.string = function read_string() {
          var bytes = this.bytes();
          return utf8.read(bytes, 0, bytes.length);
        };
        Reader3.prototype.skip = function skip(length3) {
          if (typeof length3 === "number") {
            if (this.pos + length3 > this.len)
              throw indexOutOfRange(this, length3);
            this.pos += length3;
          } else {
            do {
              if (this.pos >= this.len)
                throw indexOutOfRange(this);
            } while (this.buf[this.pos++] & 128);
          }
          return this;
        };
        Reader3.prototype.skipType = function(wireType) {
          switch (wireType) {
            case 0:
              this.skip();
              break;
            case 1:
              this.skip(8);
              break;
            case 2:
              this.skip(this.uint32());
              break;
            case 3:
              while ((wireType = this.uint32() & 7) !== 4) {
                this.skipType(wireType);
              }
              break;
            case 5:
              this.skip(4);
              break;
            default:
              throw Error("invalid wire type " + wireType + " at offset " + this.pos);
          }
          return this;
        };
        Reader3._configure = function(BufferReader_) {
          BufferReader = BufferReader_;
          Reader3.create = create();
          BufferReader._configure();
          var fn = util.Long ? "toLong" : "toNumber";
          util.merge(Reader3.prototype, {
            int64: function read_int64() {
              return readLongVarint.call(this)[fn](false);
            },
            uint64: function read_uint64() {
              return readLongVarint.call(this)[fn](true);
            },
            sint64: function read_sint64() {
              return readLongVarint.call(this).zzDecode()[fn](false);
            },
            fixed64: function read_fixed64() {
              return readFixed64.call(this)[fn](true);
            },
            sfixed64: function read_sfixed64() {
              return readFixed64.call(this)[fn](false);
            }
          });
        };
      }, { "15": 15 }], 10: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = BufferReader;
        var Reader3 = require2(9);
        (BufferReader.prototype = Object.create(Reader3.prototype)).constructor = BufferReader;
        var util = require2(15);
        function BufferReader(buffer) {
          Reader3.call(this, buffer);
        }
        BufferReader._configure = function() {
          if (util.Buffer)
            BufferReader.prototype._slice = util.Buffer.prototype.slice;
        };
        BufferReader.prototype.string = function read_string_buffer() {
          var len = this.uint32();
          return this.buf.utf8Slice ? this.buf.utf8Slice(this.pos, this.pos = Math.min(this.pos + len, this.len)) : this.buf.toString("utf-8", this.pos, this.pos = Math.min(this.pos + len, this.len));
        };
        BufferReader._configure();
      }, { "15": 15, "9": 9 }], 11: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = {};
      }, {}], 12: [function(require2, module2, exports2) {
        "use strict";
        var rpc = exports2;
        rpc.Service = require2(13);
      }, { "13": 13 }], 13: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Service;
        var util = require2(15);
        (Service.prototype = Object.create(util.EventEmitter.prototype)).constructor = Service;
        function Service(rpcImpl, requestDelimited, responseDelimited) {
          if (typeof rpcImpl !== "function")
            throw TypeError("rpcImpl must be a function");
          util.EventEmitter.call(this);
          this.rpcImpl = rpcImpl;
          this.requestDelimited = Boolean(requestDelimited);
          this.responseDelimited = Boolean(responseDelimited);
        }
        Service.prototype.rpcCall = function rpcCall(method, requestCtor, responseCtor, request, callback) {
          if (!request)
            throw TypeError("request must be specified");
          var self2 = this;
          if (!callback)
            return util.asPromise(rpcCall, self2, method, requestCtor, responseCtor, request);
          if (!self2.rpcImpl) {
            setTimeout(function() {
              callback(Error("already ended"));
            }, 0);
            return undefined;
          }
          try {
            return self2.rpcImpl(
              method,
              requestCtor[self2.requestDelimited ? "encodeDelimited" : "encode"](request).finish(),
              function rpcCallback(err, response) {
                if (err) {
                  self2.emit("error", err, method);
                  return callback(err);
                }
                if (response === null) {
                  self2.end(true);
                  return undefined;
                }
                if (!(response instanceof responseCtor)) {
                  try {
                    response = responseCtor[self2.responseDelimited ? "decodeDelimited" : "decode"](response);
                  } catch (err2) {
                    self2.emit("error", err2, method);
                    return callback(err2);
                  }
                }
                self2.emit("data", response, method);
                return callback(null, response);
              }
            );
          } catch (err) {
            self2.emit("error", err, method);
            setTimeout(function() {
              callback(err);
            }, 0);
            return undefined;
          }
        };
        Service.prototype.end = function end(endedByRPC) {
          if (this.rpcImpl) {
            if (!endedByRPC)
              this.rpcImpl(null, null, null);
            this.rpcImpl = null;
            this.emit("end").off();
          }
          return this;
        };
      }, { "15": 15 }], 14: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = LongBits;
        var util = require2(15);
        function LongBits(lo, hi) {
          this.lo = lo >>> 0;
          this.hi = hi >>> 0;
        }
        var zero = LongBits.zero = new LongBits(0, 0);
        zero.toNumber = function() {
          return 0;
        };
        zero.zzEncode = zero.zzDecode = function() {
          return this;
        };
        zero.length = function() {
          return 1;
        };
        var zeroHash = LongBits.zeroHash = "\0\0\0\0\0\0\0\0";
        LongBits.fromNumber = function fromNumber(value) {
          if (value === 0)
            return zero;
          var sign2 = value < 0;
          if (sign2)
            value = -value;
          var lo = value >>> 0, hi = (value - lo) / 4294967296 >>> 0;
          if (sign2) {
            hi = ~hi >>> 0;
            lo = ~lo >>> 0;
            if (++lo > 4294967295) {
              lo = 0;
              if (++hi > 4294967295)
                hi = 0;
            }
          }
          return new LongBits(lo, hi);
        };
        LongBits.from = function from(value) {
          if (typeof value === "number")
            return LongBits.fromNumber(value);
          if (util.isString(value)) {
            if (util.Long)
              value = util.Long.fromString(value);
            else
              return LongBits.fromNumber(parseInt(value, 10));
          }
          return value.low || value.high ? new LongBits(value.low >>> 0, value.high >>> 0) : zero;
        };
        LongBits.prototype.toNumber = function toNumber(unsigned) {
          if (!unsigned && this.hi >>> 31) {
            var lo = ~this.lo + 1 >>> 0, hi = ~this.hi >>> 0;
            if (!lo)
              hi = hi + 1 >>> 0;
            return -(lo + hi * 4294967296);
          }
          return this.lo + this.hi * 4294967296;
        };
        LongBits.prototype.toLong = function toLong(unsigned) {
          return util.Long ? new util.Long(this.lo | 0, this.hi | 0, Boolean(unsigned)) : { low: this.lo | 0, high: this.hi | 0, unsigned: Boolean(unsigned) };
        };
        var charCodeAt = String.prototype.charCodeAt;
        LongBits.fromHash = function fromHash(hash2) {
          if (hash2 === zeroHash)
            return zero;
          return new LongBits(
            (charCodeAt.call(hash2, 0) | charCodeAt.call(hash2, 1) << 8 | charCodeAt.call(hash2, 2) << 16 | charCodeAt.call(hash2, 3) << 24) >>> 0,
            (charCodeAt.call(hash2, 4) | charCodeAt.call(hash2, 5) << 8 | charCodeAt.call(hash2, 6) << 16 | charCodeAt.call(hash2, 7) << 24) >>> 0
          );
        };
        LongBits.prototype.toHash = function toHash() {
          return String.fromCharCode(
            this.lo & 255,
            this.lo >>> 8 & 255,
            this.lo >>> 16 & 255,
            this.lo >>> 24,
            this.hi & 255,
            this.hi >>> 8 & 255,
            this.hi >>> 16 & 255,
            this.hi >>> 24
          );
        };
        LongBits.prototype.zzEncode = function zzEncode() {
          var mask = this.hi >> 31;
          this.hi = ((this.hi << 1 | this.lo >>> 31) ^ mask) >>> 0;
          this.lo = (this.lo << 1 ^ mask) >>> 0;
          return this;
        };
        LongBits.prototype.zzDecode = function zzDecode() {
          var mask = -(this.lo & 1);
          this.lo = ((this.lo >>> 1 | this.hi << 31) ^ mask) >>> 0;
          this.hi = (this.hi >>> 1 ^ mask) >>> 0;
          return this;
        };
        LongBits.prototype.length = function length3() {
          var part0 = this.lo, part1 = (this.lo >>> 28 | this.hi << 4) >>> 0, part2 = this.hi >>> 24;
          return part2 === 0 ? part1 === 0 ? part0 < 16384 ? part0 < 128 ? 1 : 2 : part0 < 2097152 ? 3 : 4 : part1 < 16384 ? part1 < 128 ? 5 : 6 : part1 < 2097152 ? 7 : 8 : part2 < 128 ? 9 : 10;
        };
      }, { "15": 15 }], 15: [function(require2, module2, exports2) {
        "use strict";
        var util = exports2;
        util.asPromise = require2(1);
        util.base64 = require2(2);
        util.EventEmitter = require2(3);
        util.float = require2(4);
        util.inquire = require2(5);
        util.utf8 = require2(7);
        util.pool = require2(6);
        util.LongBits = require2(14);
        util.isNode = Boolean(typeof global !== "undefined" && global && global.process && global.process.versions && global.process.versions.node);
        util.global = util.isNode && global || typeof window !== "undefined" && window || typeof self !== "undefined" && self || this;
        util.emptyArray = Object.freeze ? Object.freeze([]) : [];
        util.emptyObject = Object.freeze ? Object.freeze({}) : {};
        util.isInteger = Number.isInteger || function isInteger(value) {
          return typeof value === "number" && isFinite(value) && Math.floor(value) === value;
        };
        util.isString = function isString(value) {
          return typeof value === "string" || value instanceof String;
        };
        util.isObject = function isObject(value) {
          return value && typeof value === "object";
        };
        util.isset = util.isSet = function isSet(obj, prop) {
          var value = obj[prop];
          if (value != null && obj.hasOwnProperty(prop))
            return typeof value !== "object" || (Array.isArray(value) ? value.length : Object.keys(value).length) > 0;
          return false;
        };
        util.Buffer = function() {
          try {
            var Buffer3 = util.inquire("buffer").Buffer;
            return Buffer3.prototype.utf8Write ? Buffer3 : null;
          } catch (e) {
            return null;
          }
        }();
        util._Buffer_from = null;
        util._Buffer_allocUnsafe = null;
        util.newBuffer = function newBuffer(sizeOrArray) {
          return typeof sizeOrArray === "number" ? util.Buffer ? util._Buffer_allocUnsafe(sizeOrArray) : new util.Array(sizeOrArray) : util.Buffer ? util._Buffer_from(sizeOrArray) : typeof Uint8Array === "undefined" ? sizeOrArray : new Uint8Array(sizeOrArray);
        };
        util.Array = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
        util.Long = util.global.dcodeIO && util.global.dcodeIO.Long || util.global.Long || util.inquire("long");
        util.key2Re = /^true|false|0|1$/;
        util.key32Re = /^-?(?:0|[1-9][0-9]*)$/;
        util.key64Re = /^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;
        util.longToHash = function longToHash(value) {
          return value ? util.LongBits.from(value).toHash() : util.LongBits.zeroHash;
        };
        util.longFromHash = function longFromHash(hash2, unsigned) {
          var bits = util.LongBits.fromHash(hash2);
          if (util.Long)
            return util.Long.fromBits(bits.lo, bits.hi, unsigned);
          return bits.toNumber(Boolean(unsigned));
        };
        function merge2(dst, src, ifNotSet) {
          for (var keys = Object.keys(src), i = 0; i < keys.length; ++i)
            if (dst[keys[i]] === undefined || !ifNotSet)
              dst[keys[i]] = src[keys[i]];
          return dst;
        }
        util.merge = merge2;
        util.lcFirst = function lcFirst(str) {
          return str.charAt(0).toLowerCase() + str.substring(1);
        };
        function newError(name) {
          function CustomError(message, properties) {
            if (!(this instanceof CustomError))
              return new CustomError(message, properties);
            Object.defineProperty(this, "message", { get: function() {
              return message;
            } });
            if (Error.captureStackTrace)
              Error.captureStackTrace(this, CustomError);
            else
              Object.defineProperty(this, "stack", { value: new Error().stack || "" });
            if (properties)
              merge2(this, properties);
          }
          CustomError.prototype = Object.create(Error.prototype, {
            constructor: {
              value: CustomError,
              writable: true,
              enumerable: false,
              configurable: true
            },
            name: {
              get: function get2() {
                return name;
              },
              set: undefined,
              enumerable: false,
              configurable: true
            },
            toString: {
              value: function value() {
                return this.name + ": " + this.message;
              },
              writable: true,
              enumerable: false,
              configurable: true
            }
          });
          return CustomError;
        }
        util.newError = newError;
        util.ProtocolError = newError("ProtocolError");
        util.oneOfGetter = function getOneOf(fieldNames) {
          var fieldMap = {};
          for (var i = 0; i < fieldNames.length; ++i)
            fieldMap[fieldNames[i]] = 1;
          return function() {
            for (var keys = Object.keys(this), i2 = keys.length - 1; i2 > -1; --i2)
              if (fieldMap[keys[i2]] === 1 && this[keys[i2]] !== undefined && this[keys[i2]] !== null)
                return keys[i2];
          };
        };
        util.oneOfSetter = function setOneOf(fieldNames) {
          return function(name) {
            for (var i = 0; i < fieldNames.length; ++i)
              if (fieldNames[i] !== name)
                delete this[fieldNames[i]];
          };
        };
        util.toJSONOptions = {
          longs: String,
          enums: String,
          bytes: String,
          json: true
        };
        util._configure = function() {
          var Buffer3 = util.Buffer;
          if (!Buffer3) {
            util._Buffer_from = util._Buffer_allocUnsafe = null;
            return;
          }
          util._Buffer_from = Buffer3.from !== Uint8Array.from && Buffer3.from || function Buffer_from(value, encoding) {
            return new Buffer3(value, encoding);
          };
          util._Buffer_allocUnsafe = Buffer3.allocUnsafe || function Buffer_allocUnsafe(size) {
            return new Buffer3(size);
          };
        };
      }, { "1": 1, "14": 14, "2": 2, "3": 3, "4": 4, "5": 5, "6": 6, "7": 7 }], 16: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = Writer2;
        var util = require2(15);
        var BufferWriter;
        var LongBits = util.LongBits, base64 = util.base64, utf8 = util.utf8;
        function Op(fn, len, val) {
          this.fn = fn;
          this.len = len;
          this.next = undefined;
          this.val = val;
        }
        function noop() {
        }
        function State(writer) {
          this.head = writer.head;
          this.tail = writer.tail;
          this.len = writer.len;
          this.next = writer.states;
        }
        function Writer2() {
          this.len = 0;
          this.head = new Op(noop, 0, 0);
          this.tail = this.head;
          this.states = null;
        }
        var create = function create2() {
          return util.Buffer ? function create_buffer_setup() {
            return (Writer2.create = function create_buffer() {
              return new BufferWriter();
            })();
          } : function create_array() {
            return new Writer2();
          };
        };
        Writer2.create = create();
        Writer2.alloc = function alloc(size) {
          return new util.Array(size);
        };
        if (util.Array !== Array)
          Writer2.alloc = util.pool(Writer2.alloc, util.Array.prototype.subarray);
        Writer2.prototype._push = function push(fn, len, val) {
          this.tail = this.tail.next = new Op(fn, len, val);
          this.len += len;
          return this;
        };
        function writeByte(val, buf, pos) {
          buf[pos] = val & 255;
        }
        function writeVarint32(val, buf, pos) {
          while (val > 127) {
            buf[pos++] = val & 127 | 128;
            val >>>= 7;
          }
          buf[pos] = val;
        }
        function VarintOp(len, val) {
          this.len = len;
          this.next = undefined;
          this.val = val;
        }
        VarintOp.prototype = Object.create(Op.prototype);
        VarintOp.prototype.fn = writeVarint32;
        Writer2.prototype.uint32 = function write_uint32(value) {
          this.len += (this.tail = this.tail.next = new VarintOp(
            (value = value >>> 0) < 128 ? 1 : value < 16384 ? 2 : value < 2097152 ? 3 : value < 268435456 ? 4 : 5,
            value
          )).len;
          return this;
        };
        Writer2.prototype.int32 = function write_int32(value) {
          return value < 0 ? this._push(writeVarint64, 10, LongBits.fromNumber(value)) : this.uint32(value);
        };
        Writer2.prototype.sint32 = function write_sint32(value) {
          return this.uint32((value << 1 ^ value >> 31) >>> 0);
        };
        function writeVarint64(val, buf, pos) {
          while (val.hi) {
            buf[pos++] = val.lo & 127 | 128;
            val.lo = (val.lo >>> 7 | val.hi << 25) >>> 0;
            val.hi >>>= 7;
          }
          while (val.lo > 127) {
            buf[pos++] = val.lo & 127 | 128;
            val.lo = val.lo >>> 7;
          }
          buf[pos++] = val.lo;
        }
        Writer2.prototype.uint64 = function write_uint64(value) {
          var bits = LongBits.from(value);
          return this._push(writeVarint64, bits.length(), bits);
        };
        Writer2.prototype.int64 = Writer2.prototype.uint64;
        Writer2.prototype.sint64 = function write_sint64(value) {
          var bits = LongBits.from(value).zzEncode();
          return this._push(writeVarint64, bits.length(), bits);
        };
        Writer2.prototype.bool = function write_bool(value) {
          return this._push(writeByte, 1, value ? 1 : 0);
        };
        function writeFixed32(val, buf, pos) {
          buf[pos] = val & 255;
          buf[pos + 1] = val >>> 8 & 255;
          buf[pos + 2] = val >>> 16 & 255;
          buf[pos + 3] = val >>> 24;
        }
        Writer2.prototype.fixed32 = function write_fixed32(value) {
          return this._push(writeFixed32, 4, value >>> 0);
        };
        Writer2.prototype.sfixed32 = Writer2.prototype.fixed32;
        Writer2.prototype.fixed64 = function write_fixed64(value) {
          var bits = LongBits.from(value);
          return this._push(writeFixed32, 4, bits.lo)._push(writeFixed32, 4, bits.hi);
        };
        Writer2.prototype.sfixed64 = Writer2.prototype.fixed64;
        Writer2.prototype.float = function write_float(value) {
          return this._push(util.float.writeFloatLE, 4, value);
        };
        Writer2.prototype.double = function write_double(value) {
          return this._push(util.float.writeDoubleLE, 8, value);
        };
        var writeBytes = util.Array.prototype.set ? function writeBytes_set(val, buf, pos) {
          buf.set(val, pos);
        } : function writeBytes_for(val, buf, pos) {
          for (var i = 0; i < val.length; ++i)
            buf[pos + i] = val[i];
        };
        Writer2.prototype.bytes = function write_bytes(value) {
          var len = value.length >>> 0;
          if (!len)
            return this._push(writeByte, 1, 0);
          if (util.isString(value)) {
            var buf = Writer2.alloc(len = base64.length(value));
            base64.decode(value, buf, 0);
            value = buf;
          }
          return this.uint32(len)._push(writeBytes, len, value);
        };
        Writer2.prototype.string = function write_string(value) {
          var len = utf8.length(value);
          return len ? this.uint32(len)._push(utf8.write, len, value) : this._push(writeByte, 1, 0);
        };
        Writer2.prototype.fork = function fork() {
          this.states = new State(this);
          this.head = this.tail = new Op(noop, 0, 0);
          this.len = 0;
          return this;
        };
        Writer2.prototype.reset = function reset() {
          if (this.states) {
            this.head = this.states.head;
            this.tail = this.states.tail;
            this.len = this.states.len;
            this.states = this.states.next;
          } else {
            this.head = this.tail = new Op(noop, 0, 0);
            this.len = 0;
          }
          return this;
        };
        Writer2.prototype.ldelim = function ldelim() {
          var head = this.head, tail = this.tail, len = this.len;
          this.reset().uint32(len);
          if (len) {
            this.tail.next = head.next;
            this.tail = tail;
            this.len += len;
          }
          return this;
        };
        Writer2.prototype.finish = function finish() {
          var head = this.head.next, buf = this.constructor.alloc(this.len), pos = 0;
          while (head) {
            head.fn(head.val, buf, pos);
            pos += head.len;
            head = head.next;
          }
          return buf;
        };
        Writer2._configure = function(BufferWriter_) {
          BufferWriter = BufferWriter_;
          Writer2.create = create();
          BufferWriter._configure();
        };
      }, { "15": 15 }], 17: [function(require2, module2, exports2) {
        "use strict";
        module2.exports = BufferWriter;
        var Writer2 = require2(16);
        (BufferWriter.prototype = Object.create(Writer2.prototype)).constructor = BufferWriter;
        var util = require2(15);
        function BufferWriter() {
          Writer2.call(this);
        }
        BufferWriter._configure = function() {
          BufferWriter.alloc = util._Buffer_allocUnsafe;
          BufferWriter.writeBytesBuffer = util.Buffer && util.Buffer.prototype instanceof Uint8Array && util.Buffer.prototype.set.name === "set" ? function writeBytesBuffer_set(val, buf, pos) {
            buf.set(val, pos);
          } : function writeBytesBuffer_copy(val, buf, pos) {
            if (val.copy)
              val.copy(buf, pos, 0, val.length);
            else
              for (var i = 0; i < val.length; )
                buf[pos++] = val[i++];
          };
        };
        BufferWriter.prototype.bytes = function write_bytes_buffer(value) {
          if (util.isString(value))
            value = util._Buffer_from(value, "base64");
          var len = value.length >>> 0;
          this.uint32(len);
          if (len)
            this._push(BufferWriter.writeBytesBuffer, len, value);
          return this;
        };
        function writeStringBuffer(val, buf, pos) {
          if (val.length < 40)
            util.utf8.write(val, buf, pos);
          else if (buf.utf8Write)
            buf.utf8Write(val, pos);
          else
            buf.write(val, pos);
        }
        BufferWriter.prototype.string = function write_string_buffer(value) {
          var len = util.Buffer.byteLength(value);
          this.uint32(len);
          if (len)
            this._push(writeStringBuffer, len, value);
          return this;
        };
        BufferWriter._configure();
      }, { "15": 15, "16": 16 }] }, {}, [8]);
    })();
  }
});

// node_modules/lerc/LercDecode.js
var require_LercDecode = __commonJS({
  "node_modules/lerc/LercDecode.js"(exports2, module2) {
    /* Copyright 2015-2018 Esri. Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 @preserve */
    (function() {
      var LercDecode = function() {
        var CntZImage = {};
        CntZImage.defaultNoDataValue = -34027999387901484e22;
        CntZImage.decode = function(input, options) {
          options = options || {};
          var skipMask = options.encodedMaskData || options.encodedMaskData === null;
          var parsedData = parse3(input, options.inputOffset || 0, skipMask);
          var noDataValue = options.noDataValue !== null ? options.noDataValue : CntZImage.defaultNoDataValue;
          var uncompressedData = uncompressPixelValues(
            parsedData,
            options.pixelType || Float32Array,
            options.encodedMaskData,
            noDataValue,
            options.returnMask
          );
          var result = {
            width: parsedData.width,
            height: parsedData.height,
            pixelData: uncompressedData.resultPixels,
            minValue: uncompressedData.minValue,
            maxValue: parsedData.pixels.maxValue,
            noDataValue
          };
          if (uncompressedData.resultMask) {
            result.maskData = uncompressedData.resultMask;
          }
          if (options.returnEncodedMask && parsedData.mask) {
            result.encodedMaskData = parsedData.mask.bitset ? parsedData.mask.bitset : null;
          }
          if (options.returnFileInfo) {
            result.fileInfo = formatFileInfo(parsedData);
            if (options.computeUsedBitDepths) {
              result.fileInfo.bitDepths = computeUsedBitDepths(parsedData);
            }
          }
          return result;
        };
        var uncompressPixelValues = function(data, TypedArrayClass, maskBitset, noDataValue, storeDecodedMask) {
          var blockIdx = 0;
          var numX = data.pixels.numBlocksX;
          var numY = data.pixels.numBlocksY;
          var blockWidth = Math.floor(data.width / numX);
          var blockHeight = Math.floor(data.height / numY);
          var scale = 2 * data.maxZError;
          var minValue = Number.MAX_VALUE, currentValue;
          maskBitset = maskBitset || (data.mask ? data.mask.bitset : null);
          var resultPixels, resultMask;
          resultPixels = new TypedArrayClass(data.width * data.height);
          if (storeDecodedMask && maskBitset) {
            resultMask = new Uint8Array(data.width * data.height);
          }
          var blockDataBuffer = new Float32Array(blockWidth * blockHeight);
          var xx, yy;
          for (var y = 0; y <= numY; y++) {
            var thisBlockHeight = y !== numY ? blockHeight : data.height % numY;
            if (thisBlockHeight === 0) {
              continue;
            }
            for (var x = 0; x <= numX; x++) {
              var thisBlockWidth = x !== numX ? blockWidth : data.width % numX;
              if (thisBlockWidth === 0) {
                continue;
              }
              var outPtr = y * data.width * blockHeight + x * blockWidth;
              var outStride = data.width - thisBlockWidth;
              var block = data.pixels.blocks[blockIdx];
              var blockData, blockPtr, constValue;
              if (block.encoding < 2) {
                if (block.encoding === 0) {
                  blockData = block.rawData;
                } else {
                  unstuff(block.stuffedData, block.bitsPerPixel, block.numValidPixels, block.offset, scale, blockDataBuffer, data.pixels.maxValue);
                  blockData = blockDataBuffer;
                }
                blockPtr = 0;
              } else if (block.encoding === 2) {
                constValue = 0;
              } else {
                constValue = block.offset;
              }
              var maskByte;
              if (maskBitset) {
                for (yy = 0; yy < thisBlockHeight; yy++) {
                  if (outPtr & 7) {
                    maskByte = maskBitset[outPtr >> 3];
                    maskByte <<= outPtr & 7;
                  }
                  for (xx = 0; xx < thisBlockWidth; xx++) {
                    if (!(outPtr & 7)) {
                      maskByte = maskBitset[outPtr >> 3];
                    }
                    if (maskByte & 128) {
                      if (resultMask) {
                        resultMask[outPtr] = 1;
                      }
                      currentValue = block.encoding < 2 ? blockData[blockPtr++] : constValue;
                      minValue = minValue > currentValue ? currentValue : minValue;
                      resultPixels[outPtr++] = currentValue;
                    } else {
                      if (resultMask) {
                        resultMask[outPtr] = 0;
                      }
                      resultPixels[outPtr++] = noDataValue;
                    }
                    maskByte <<= 1;
                  }
                  outPtr += outStride;
                }
              } else {
                if (block.encoding < 2) {
                  for (yy = 0; yy < thisBlockHeight; yy++) {
                    for (xx = 0; xx < thisBlockWidth; xx++) {
                      currentValue = blockData[blockPtr++];
                      minValue = minValue > currentValue ? currentValue : minValue;
                      resultPixels[outPtr++] = currentValue;
                    }
                    outPtr += outStride;
                  }
                } else {
                  minValue = minValue > constValue ? constValue : minValue;
                  for (yy = 0; yy < thisBlockHeight; yy++) {
                    for (xx = 0; xx < thisBlockWidth; xx++) {
                      resultPixels[outPtr++] = constValue;
                    }
                    outPtr += outStride;
                  }
                }
              }
              if (block.encoding === 1 && blockPtr !== block.numValidPixels) {
                throw "Block and Mask do not match";
              }
              blockIdx++;
            }
          }
          return {
            resultPixels,
            resultMask,
            minValue
          };
        };
        var formatFileInfo = function(data) {
          return {
            "fileIdentifierString": data.fileIdentifierString,
            "fileVersion": data.fileVersion,
            "imageType": data.imageType,
            "height": data.height,
            "width": data.width,
            "maxZError": data.maxZError,
            "eofOffset": data.eofOffset,
            "mask": data.mask ? {
              "numBlocksX": data.mask.numBlocksX,
              "numBlocksY": data.mask.numBlocksY,
              "numBytes": data.mask.numBytes,
              "maxValue": data.mask.maxValue
            } : null,
            "pixels": {
              "numBlocksX": data.pixels.numBlocksX,
              "numBlocksY": data.pixels.numBlocksY,
              "numBytes": data.pixels.numBytes,
              "maxValue": data.pixels.maxValue,
              "noDataValue": data.noDataValue
            }
          };
        };
        var computeUsedBitDepths = function(data) {
          var numBlocks = data.pixels.numBlocksX * data.pixels.numBlocksY;
          var bitDepths = {};
          for (var i = 0; i < numBlocks; i++) {
            var block = data.pixels.blocks[i];
            if (block.encoding === 0) {
              bitDepths.float32 = true;
            } else if (block.encoding === 1) {
              bitDepths[block.bitsPerPixel] = true;
            } else {
              bitDepths[0] = true;
            }
          }
          return Object.keys(bitDepths);
        };
        var parse3 = function(input, fp, skipMask) {
          var data = {};
          var fileIdView = new Uint8Array(input, fp, 10);
          data.fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
          if (data.fileIdentifierString.trim() !== "CntZImage") {
            throw "Unexpected file identifier string: " + data.fileIdentifierString;
          }
          fp += 10;
          var view = new DataView(input, fp, 24);
          data.fileVersion = view.getInt32(0, true);
          data.imageType = view.getInt32(4, true);
          data.height = view.getUint32(8, true);
          data.width = view.getUint32(12, true);
          data.maxZError = view.getFloat64(16, true);
          fp += 24;
          if (!skipMask) {
            view = new DataView(input, fp, 16);
            data.mask = {};
            data.mask.numBlocksY = view.getUint32(0, true);
            data.mask.numBlocksX = view.getUint32(4, true);
            data.mask.numBytes = view.getUint32(8, true);
            data.mask.maxValue = view.getFloat32(12, true);
            fp += 16;
            if (data.mask.numBytes > 0) {
              var bitset = new Uint8Array(Math.ceil(data.width * data.height / 8));
              view = new DataView(input, fp, data.mask.numBytes);
              var cnt = view.getInt16(0, true);
              var ip = 2, op = 0;
              do {
                if (cnt > 0) {
                  while (cnt--) {
                    bitset[op++] = view.getUint8(ip++);
                  }
                } else {
                  var val = view.getUint8(ip++);
                  cnt = -cnt;
                  while (cnt--) {
                    bitset[op++] = val;
                  }
                }
                cnt = view.getInt16(ip, true);
                ip += 2;
              } while (ip < data.mask.numBytes);
              if (cnt !== -32768 || op < bitset.length) {
                throw "Unexpected end of mask RLE encoding";
              }
              data.mask.bitset = bitset;
              fp += data.mask.numBytes;
            } else if ((data.mask.numBytes | data.mask.numBlocksY | data.mask.maxValue) === 0) {
              data.mask.bitset = new Uint8Array(Math.ceil(data.width * data.height / 8));
            }
          }
          view = new DataView(input, fp, 16);
          data.pixels = {};
          data.pixels.numBlocksY = view.getUint32(0, true);
          data.pixels.numBlocksX = view.getUint32(4, true);
          data.pixels.numBytes = view.getUint32(8, true);
          data.pixels.maxValue = view.getFloat32(12, true);
          fp += 16;
          var numBlocksX = data.pixels.numBlocksX;
          var numBlocksY = data.pixels.numBlocksY;
          var actualNumBlocksX = numBlocksX + (data.width % numBlocksX > 0 ? 1 : 0);
          var actualNumBlocksY = numBlocksY + (data.height % numBlocksY > 0 ? 1 : 0);
          data.pixels.blocks = new Array(actualNumBlocksX * actualNumBlocksY);
          var blockI = 0;
          for (var blockY = 0; blockY < actualNumBlocksY; blockY++) {
            for (var blockX = 0; blockX < actualNumBlocksX; blockX++) {
              var size = 0;
              var bytesLeft = input.byteLength - fp;
              view = new DataView(input, fp, Math.min(10, bytesLeft));
              var block = {};
              data.pixels.blocks[blockI++] = block;
              var headerByte = view.getUint8(0);
              size++;
              block.encoding = headerByte & 63;
              if (block.encoding > 3) {
                throw "Invalid block encoding (" + block.encoding + ")";
              }
              if (block.encoding === 2) {
                fp++;
                continue;
              }
              if (headerByte !== 0 && headerByte !== 2) {
                headerByte >>= 6;
                block.offsetType = headerByte;
                if (headerByte === 2) {
                  block.offset = view.getInt8(1);
                  size++;
                } else if (headerByte === 1) {
                  block.offset = view.getInt16(1, true);
                  size += 2;
                } else if (headerByte === 0) {
                  block.offset = view.getFloat32(1, true);
                  size += 4;
                } else {
                  throw "Invalid block offset type";
                }
                if (block.encoding === 1) {
                  headerByte = view.getUint8(size);
                  size++;
                  block.bitsPerPixel = headerByte & 63;
                  headerByte >>= 6;
                  block.numValidPixelsType = headerByte;
                  if (headerByte === 2) {
                    block.numValidPixels = view.getUint8(size);
                    size++;
                  } else if (headerByte === 1) {
                    block.numValidPixels = view.getUint16(size, true);
                    size += 2;
                  } else if (headerByte === 0) {
                    block.numValidPixels = view.getUint32(size, true);
                    size += 4;
                  } else {
                    throw "Invalid valid pixel count type";
                  }
                }
              }
              fp += size;
              if (block.encoding === 3) {
                continue;
              }
              var arrayBuf, store8;
              if (block.encoding === 0) {
                var numPixels = (data.pixels.numBytes - 1) / 4;
                if (numPixels !== Math.floor(numPixels)) {
                  throw "uncompressed block has invalid length";
                }
                arrayBuf = new ArrayBuffer(numPixels * 4);
                store8 = new Uint8Array(arrayBuf);
                store8.set(new Uint8Array(input, fp, numPixels * 4));
                var rawData = new Float32Array(arrayBuf);
                block.rawData = rawData;
                fp += numPixels * 4;
              } else if (block.encoding === 1) {
                var dataBytes = Math.ceil(block.numValidPixels * block.bitsPerPixel / 8);
                var dataWords = Math.ceil(dataBytes / 4);
                arrayBuf = new ArrayBuffer(dataWords * 4);
                store8 = new Uint8Array(arrayBuf);
                store8.set(new Uint8Array(input, fp, dataBytes));
                block.stuffedData = new Uint32Array(arrayBuf);
                fp += dataBytes;
              }
            }
          }
          data.eofOffset = fp;
          return data;
        };
        var unstuff = function(src, bitsPerPixel, numPixels, offset2, scale, dest, maxValue) {
          var bitMask = (1 << bitsPerPixel) - 1;
          var i = 0, o;
          var bitsLeft = 0;
          var n, buffer;
          var nmax = Math.ceil((maxValue - offset2) / scale);
          var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
          src[src.length - 1] <<= 8 * numInvalidTailBytes;
          for (o = 0; o < numPixels; o++) {
            if (bitsLeft === 0) {
              buffer = src[i++];
              bitsLeft = 32;
            }
            if (bitsLeft >= bitsPerPixel) {
              n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
              bitsLeft -= bitsPerPixel;
            } else {
              var missingBits = bitsPerPixel - bitsLeft;
              n = (buffer & bitMask) << missingBits & bitMask;
              buffer = src[i++];
              bitsLeft = 32 - missingBits;
              n += buffer >>> bitsLeft;
            }
            dest[o] = n < nmax ? offset2 + n * scale : maxValue;
          }
          return dest;
        };
        return CntZImage;
      }();
      var Lerc2Decode = function() {
        "use strict";
        var BitStuffer = {
          unstuff: function(src, dest, bitsPerPixel, numPixels, lutArr, offset2, scale, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0;
            var n, buffer, missingBits, nmax;
            var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
            src[src.length - 1] <<= 8 * numInvalidTailBytes;
            if (lutArr) {
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer = src[i++];
                  bitsLeft = 32;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                  bitsLeft -= bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = (buffer & bitMask) << missingBits & bitMask;
                  buffer = src[i++];
                  bitsLeft = 32 - missingBits;
                  n += buffer >>> bitsLeft;
                }
                dest[o] = lutArr[n];
              }
            } else {
              nmax = Math.ceil((maxValue - offset2) / scale);
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer = src[i++];
                  bitsLeft = 32;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                  bitsLeft -= bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = (buffer & bitMask) << missingBits & bitMask;
                  buffer = src[i++];
                  bitsLeft = 32 - missingBits;
                  n += buffer >>> bitsLeft;
                }
                dest[o] = n < nmax ? offset2 + n * scale : maxValue;
              }
            }
          },
          unstuffLUT: function(src, bitsPerPixel, numPixels, offset2, scale, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o = 0, missingBits = 0, bitsLeft = 0, n = 0;
            var buffer;
            var dest = [];
            var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
            src[src.length - 1] <<= 8 * numInvalidTailBytes;
            var nmax = Math.ceil((maxValue - offset2) / scale);
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer = src[i++];
                bitsLeft = 32;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                bitsLeft -= bitsPerPixel;
              } else {
                missingBits = bitsPerPixel - bitsLeft;
                n = (buffer & bitMask) << missingBits & bitMask;
                buffer = src[i++];
                bitsLeft = 32 - missingBits;
                n += buffer >>> bitsLeft;
              }
              dest[o] = n < nmax ? offset2 + n * scale : maxValue;
            }
            dest.unshift(offset2);
            return dest;
          },
          unstuff2: function(src, dest, bitsPerPixel, numPixels, lutArr, offset2, scale, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0, bitPos = 0;
            var n, buffer, missingBits;
            if (lutArr) {
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer = src[i++];
                  bitsLeft = 32;
                  bitPos = 0;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer >>> bitPos & bitMask;
                  bitsLeft -= bitsPerPixel;
                  bitPos += bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = buffer >>> bitPos & bitMask;
                  buffer = src[i++];
                  bitsLeft = 32 - missingBits;
                  n |= (buffer & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                  bitPos = missingBits;
                }
                dest[o] = lutArr[n];
              }
            } else {
              var nmax = Math.ceil((maxValue - offset2) / scale);
              for (o = 0; o < numPixels; o++) {
                if (bitsLeft === 0) {
                  buffer = src[i++];
                  bitsLeft = 32;
                  bitPos = 0;
                }
                if (bitsLeft >= bitsPerPixel) {
                  n = buffer >>> bitPos & bitMask;
                  bitsLeft -= bitsPerPixel;
                  bitPos += bitsPerPixel;
                } else {
                  missingBits = bitsPerPixel - bitsLeft;
                  n = buffer >>> bitPos & bitMask;
                  buffer = src[i++];
                  bitsLeft = 32 - missingBits;
                  n |= (buffer & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                  bitPos = missingBits;
                }
                dest[o] = n < nmax ? offset2 + n * scale : maxValue;
              }
            }
            return dest;
          },
          unstuffLUT2: function(src, bitsPerPixel, numPixels, offset2, scale, maxValue) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o = 0, missingBits = 0, bitsLeft = 0, n = 0, bitPos = 0;
            var buffer;
            var dest = [];
            var nmax = Math.ceil((maxValue - offset2) / scale);
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer = src[i++];
                bitsLeft = 32;
                bitPos = 0;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer >>> bitPos & bitMask;
                bitsLeft -= bitsPerPixel;
                bitPos += bitsPerPixel;
              } else {
                missingBits = bitsPerPixel - bitsLeft;
                n = buffer >>> bitPos & bitMask;
                buffer = src[i++];
                bitsLeft = 32 - missingBits;
                n |= (buffer & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                bitPos = missingBits;
              }
              dest[o] = n < nmax ? offset2 + n * scale : maxValue;
            }
            dest.unshift(offset2);
            return dest;
          },
          originalUnstuff: function(src, dest, bitsPerPixel, numPixels) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0;
            var n, buffer, missingBits;
            var numInvalidTailBytes = src.length * 4 - Math.ceil(bitsPerPixel * numPixels / 8);
            src[src.length - 1] <<= 8 * numInvalidTailBytes;
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer = src[i++];
                bitsLeft = 32;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer >>> bitsLeft - bitsPerPixel & bitMask;
                bitsLeft -= bitsPerPixel;
              } else {
                missingBits = bitsPerPixel - bitsLeft;
                n = (buffer & bitMask) << missingBits & bitMask;
                buffer = src[i++];
                bitsLeft = 32 - missingBits;
                n += buffer >>> bitsLeft;
              }
              dest[o] = n;
            }
            return dest;
          },
          originalUnstuff2: function(src, dest, bitsPerPixel, numPixels) {
            var bitMask = (1 << bitsPerPixel) - 1;
            var i = 0, o;
            var bitsLeft = 0, bitPos = 0;
            var n, buffer, missingBits;
            for (o = 0; o < numPixels; o++) {
              if (bitsLeft === 0) {
                buffer = src[i++];
                bitsLeft = 32;
                bitPos = 0;
              }
              if (bitsLeft >= bitsPerPixel) {
                n = buffer >>> bitPos & bitMask;
                bitsLeft -= bitsPerPixel;
                bitPos += bitsPerPixel;
              } else {
                missingBits = bitsPerPixel - bitsLeft;
                n = buffer >>> bitPos & bitMask;
                buffer = src[i++];
                bitsLeft = 32 - missingBits;
                n |= (buffer & (1 << missingBits) - 1) << bitsPerPixel - missingBits;
                bitPos = missingBits;
              }
              dest[o] = n;
            }
            return dest;
          }
        };
        var Lerc2Helpers = {
          HUFFMAN_LUT_BITS_MAX: 12,
          computeChecksumFletcher32: function(input) {
            var sum1 = 65535, sum2 = 65535;
            var len = input.length;
            var words = Math.floor(len / 2);
            var i = 0;
            while (words) {
              var tlen = words >= 359 ? 359 : words;
              words -= tlen;
              do {
                sum1 += input[i++] << 8;
                sum2 += sum1 += input[i++];
              } while (--tlen);
              sum1 = (sum1 & 65535) + (sum1 >>> 16);
              sum2 = (sum2 & 65535) + (sum2 >>> 16);
            }
            if (len & 1) {
              sum2 += sum1 += input[i] << 8;
            }
            sum1 = (sum1 & 65535) + (sum1 >>> 16);
            sum2 = (sum2 & 65535) + (sum2 >>> 16);
            return (sum2 << 16 | sum1) >>> 0;
          },
          readHeaderInfo: function(input, data) {
            var ptr = data.ptr;
            var fileIdView = new Uint8Array(input, ptr, 6);
            var headerInfo = {};
            headerInfo.fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
            if (headerInfo.fileIdentifierString.lastIndexOf("Lerc2", 0) !== 0) {
              throw "Unexpected file identifier string (expect Lerc2 ): " + headerInfo.fileIdentifierString;
            }
            ptr += 6;
            var view = new DataView(input, ptr, 8);
            var fileVersion = view.getInt32(0, true);
            headerInfo.fileVersion = fileVersion;
            ptr += 4;
            if (fileVersion >= 3) {
              headerInfo.checksum = view.getUint32(4, true);
              ptr += 4;
            }
            view = new DataView(input, ptr, 12);
            headerInfo.height = view.getUint32(0, true);
            headerInfo.width = view.getUint32(4, true);
            ptr += 8;
            if (fileVersion >= 4) {
              headerInfo.numDims = view.getUint32(8, true);
              ptr += 4;
            } else {
              headerInfo.numDims = 1;
            }
            view = new DataView(input, ptr, 40);
            headerInfo.numValidPixel = view.getUint32(0, true);
            headerInfo.microBlockSize = view.getInt32(4, true);
            headerInfo.blobSize = view.getInt32(8, true);
            headerInfo.imageType = view.getInt32(12, true);
            headerInfo.maxZError = view.getFloat64(16, true);
            headerInfo.zMin = view.getFloat64(24, true);
            headerInfo.zMax = view.getFloat64(32, true);
            ptr += 40;
            data.headerInfo = headerInfo;
            data.ptr = ptr;
            var checksum, keyLength;
            if (fileVersion >= 3) {
              keyLength = fileVersion >= 4 ? 52 : 48;
              checksum = this.computeChecksumFletcher32(new Uint8Array(input, ptr - keyLength, headerInfo.blobSize - 14));
              if (checksum !== headerInfo.checksum) {
                throw "Checksum failed.";
              }
            }
            return true;
          },
          checkMinMaxRanges: function(input, data) {
            var headerInfo = data.headerInfo;
            var OutPixelTypeArray = this.getDataTypeArray(headerInfo.imageType);
            var rangeBytes = headerInfo.numDims * this.getDataTypeSize(headerInfo.imageType);
            var minValues = this.readSubArray(input, data.ptr, OutPixelTypeArray, rangeBytes);
            var maxValues = this.readSubArray(input, data.ptr + rangeBytes, OutPixelTypeArray, rangeBytes);
            data.ptr += 2 * rangeBytes;
            var i, equal = true;
            for (i = 0; i < headerInfo.numDims; i++) {
              if (minValues[i] !== maxValues[i]) {
                equal = false;
                break;
              }
            }
            headerInfo.minValues = minValues;
            headerInfo.maxValues = maxValues;
            return equal;
          },
          readSubArray: function(input, ptr, OutPixelTypeArray, numBytes) {
            var rawData;
            if (OutPixelTypeArray === Uint8Array) {
              rawData = new Uint8Array(input, ptr, numBytes);
            } else {
              var arrayBuf = new ArrayBuffer(numBytes);
              var store8 = new Uint8Array(arrayBuf);
              store8.set(new Uint8Array(input, ptr, numBytes));
              rawData = new OutPixelTypeArray(arrayBuf);
            }
            return rawData;
          },
          readMask: function(input, data) {
            var ptr = data.ptr;
            var headerInfo = data.headerInfo;
            var numPixels = headerInfo.width * headerInfo.height;
            var numValidPixel = headerInfo.numValidPixel;
            var view = new DataView(input, ptr, 4);
            var mask = {};
            mask.numBytes = view.getUint32(0, true);
            ptr += 4;
            if ((0 === numValidPixel || numPixels === numValidPixel) && 0 !== mask.numBytes) {
              throw "invalid mask";
            }
            var bitset, resultMask;
            if (numValidPixel === 0) {
              bitset = new Uint8Array(Math.ceil(numPixels / 8));
              mask.bitset = bitset;
              resultMask = new Uint8Array(numPixels);
              data.pixels.resultMask = resultMask;
              ptr += mask.numBytes;
            } else if (mask.numBytes > 0) {
              bitset = new Uint8Array(Math.ceil(numPixels / 8));
              view = new DataView(input, ptr, mask.numBytes);
              var cnt = view.getInt16(0, true);
              var ip = 2, op = 0, val = 0;
              do {
                if (cnt > 0) {
                  while (cnt--) {
                    bitset[op++] = view.getUint8(ip++);
                  }
                } else {
                  val = view.getUint8(ip++);
                  cnt = -cnt;
                  while (cnt--) {
                    bitset[op++] = val;
                  }
                }
                cnt = view.getInt16(ip, true);
                ip += 2;
              } while (ip < mask.numBytes);
              if (cnt !== -32768 || op < bitset.length) {
                throw "Unexpected end of mask RLE encoding";
              }
              resultMask = new Uint8Array(numPixels);
              var mb = 0, k = 0;
              for (k = 0; k < numPixels; k++) {
                if (k & 7) {
                  mb = bitset[k >> 3];
                  mb <<= k & 7;
                } else {
                  mb = bitset[k >> 3];
                }
                if (mb & 128) {
                  resultMask[k] = 1;
                }
              }
              data.pixels.resultMask = resultMask;
              mask.bitset = bitset;
              ptr += mask.numBytes;
            }
            data.ptr = ptr;
            data.mask = mask;
            return true;
          },
          readDataOneSweep: function(input, data, OutPixelTypeArray) {
            var ptr = data.ptr;
            var headerInfo = data.headerInfo;
            var numDims = headerInfo.numDims;
            var numPixels = headerInfo.width * headerInfo.height;
            var imageType = headerInfo.imageType;
            var numBytes = headerInfo.numValidPixel * Lerc2Helpers.getDataTypeSize(imageType) * numDims;
            var rawData;
            var mask = data.pixels.resultMask;
            if (OutPixelTypeArray === Uint8Array) {
              rawData = new Uint8Array(input, ptr, numBytes);
            } else {
              var arrayBuf = new ArrayBuffer(numBytes);
              var store8 = new Uint8Array(arrayBuf);
              store8.set(new Uint8Array(input, ptr, numBytes));
              rawData = new OutPixelTypeArray(arrayBuf);
            }
            if (rawData.length === numPixels * numDims) {
              data.pixels.resultPixels = rawData;
            } else {
              data.pixels.resultPixels = new OutPixelTypeArray(numPixels * numDims);
              var z = 0, k = 0, i = 0, nStart = 0;
              if (numDims > 1) {
                for (i = 0; i < numDims; i++) {
                  nStart = i * numPixels;
                  for (k = 0; k < numPixels; k++) {
                    if (mask[k]) {
                      data.pixels.resultPixels[nStart + k] = rawData[z++];
                    }
                  }
                }
              } else {
                for (k = 0; k < numPixels; k++) {
                  if (mask[k]) {
                    data.pixels.resultPixels[k] = rawData[z++];
                  }
                }
              }
            }
            ptr += numBytes;
            data.ptr = ptr;
            return true;
          },
          readHuffmanTree: function(input, data) {
            var BITS_MAX = this.HUFFMAN_LUT_BITS_MAX;
            var view = new DataView(input, data.ptr, 16);
            data.ptr += 16;
            var version = view.getInt32(0, true);
            if (version < 2) {
              throw "unsupported Huffman version";
            }
            var size = view.getInt32(4, true);
            var i0 = view.getInt32(8, true);
            var i1 = view.getInt32(12, true);
            if (i0 >= i1) {
              return false;
            }
            var blockDataBuffer = new Uint32Array(i1 - i0);
            Lerc2Helpers.decodeBits(input, data, blockDataBuffer);
            var codeTable = [];
            var i, j, k, len;
            for (i = i0; i < i1; i++) {
              j = i - (i < size ? 0 : size);
              codeTable[j] = { first: blockDataBuffer[i - i0], second: null };
            }
            var dataBytes = input.byteLength - data.ptr;
            var dataWords = Math.ceil(dataBytes / 4);
            var arrayBuf = new ArrayBuffer(dataWords * 4);
            var store8 = new Uint8Array(arrayBuf);
            store8.set(new Uint8Array(input, data.ptr, dataBytes));
            var stuffedData = new Uint32Array(arrayBuf);
            var bitPos = 0, word, srcPtr = 0;
            word = stuffedData[0];
            for (i = i0; i < i1; i++) {
              j = i - (i < size ? 0 : size);
              len = codeTable[j].first;
              if (len > 0) {
                codeTable[j].second = word << bitPos >>> 32 - len;
                if (32 - bitPos >= len) {
                  bitPos += len;
                  if (bitPos === 32) {
                    bitPos = 0;
                    srcPtr++;
                    word = stuffedData[srcPtr];
                  }
                } else {
                  bitPos += len - 32;
                  srcPtr++;
                  word = stuffedData[srcPtr];
                  codeTable[j].second |= word >>> 32 - bitPos;
                }
              }
            }
            var numBitsLUT = 0, numBitsLUTQick = 0;
            var tree = new TreeNode();
            for (i = 0; i < codeTable.length; i++) {
              if (codeTable[i] !== void 0) {
                numBitsLUT = Math.max(numBitsLUT, codeTable[i].first);
              }
            }
            if (numBitsLUT >= BITS_MAX) {
              numBitsLUTQick = BITS_MAX;
            } else {
              numBitsLUTQick = numBitsLUT;
            }
            if (numBitsLUT >= 30) {
              console.log("WARning, large NUM LUT BITS IS " + numBitsLUT);
            }
            var decodeLut = [], entry, code, numEntries, jj, currentBit, node;
            for (i = i0; i < i1; i++) {
              j = i - (i < size ? 0 : size);
              len = codeTable[j].first;
              if (len > 0) {
                entry = [len, j];
                if (len <= numBitsLUTQick) {
                  code = codeTable[j].second << numBitsLUTQick - len;
                  numEntries = 1 << numBitsLUTQick - len;
                  for (k = 0; k < numEntries; k++) {
                    decodeLut[code | k] = entry;
                  }
                } else {
                  code = codeTable[j].second;
                  node = tree;
                  for (jj = len - 1; jj >= 0; jj--) {
                    currentBit = code >>> jj & 1;
                    if (currentBit) {
                      if (!node.right) {
                        node.right = new TreeNode();
                      }
                      node = node.right;
                    } else {
                      if (!node.left) {
                        node.left = new TreeNode();
                      }
                      node = node.left;
                    }
                    if (jj === 0 && !node.val) {
                      node.val = entry[1];
                    }
                  }
                }
              }
            }
            return {
              decodeLut,
              numBitsLUTQick,
              numBitsLUT,
              tree,
              stuffedData,
              srcPtr,
              bitPos
            };
          },
          readHuffman: function(input, data, OutPixelTypeArray) {
            var headerInfo = data.headerInfo;
            var numDims = headerInfo.numDims;
            var height = data.headerInfo.height;
            var width = data.headerInfo.width;
            var numPixels = width * height;
            var huffmanInfo = this.readHuffmanTree(input, data);
            var decodeLut = huffmanInfo.decodeLut;
            var tree = huffmanInfo.tree;
            var stuffedData = huffmanInfo.stuffedData;
            var srcPtr = huffmanInfo.srcPtr;
            var bitPos = huffmanInfo.bitPos;
            var numBitsLUTQick = huffmanInfo.numBitsLUTQick;
            var numBitsLUT = huffmanInfo.numBitsLUT;
            var offset2 = data.headerInfo.imageType === 0 ? 128 : 0;
            var node, val, delta, mask = data.pixels.resultMask, valTmp, valTmpQuick, currentBit;
            var i, j, k, ii;
            var prevVal = 0;
            if (bitPos > 0) {
              srcPtr++;
              bitPos = 0;
            }
            var word = stuffedData[srcPtr];
            var deltaEncode = data.encodeMode === 1;
            var resultPixelsAllDim = new OutPixelTypeArray(numPixels * numDims);
            var resultPixels = resultPixelsAllDim;
            var iDim;
            for (iDim = 0; iDim < headerInfo.numDims; iDim++) {
              if (numDims > 1) {
                resultPixels = new OutPixelTypeArray(resultPixelsAllDim.buffer, numPixels * iDim, numPixels);
                prevVal = 0;
              }
              if (data.headerInfo.numValidPixel === width * height) {
                for (k = 0, i = 0; i < height; i++) {
                  for (j = 0; j < width; j++, k++) {
                    val = 0;
                    valTmp = word << bitPos >>> 32 - numBitsLUTQick;
                    valTmpQuick = valTmp;
                    if (32 - bitPos < numBitsLUTQick) {
                      valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUTQick;
                      valTmpQuick = valTmp;
                    }
                    if (decodeLut[valTmpQuick]) {
                      val = decodeLut[valTmpQuick][1];
                      bitPos += decodeLut[valTmpQuick][0];
                    } else {
                      valTmp = word << bitPos >>> 32 - numBitsLUT;
                      valTmpQuick = valTmp;
                      if (32 - bitPos < numBitsLUT) {
                        valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUT;
                        valTmpQuick = valTmp;
                      }
                      node = tree;
                      for (ii = 0; ii < numBitsLUT; ii++) {
                        currentBit = valTmp >>> numBitsLUT - ii - 1 & 1;
                        node = currentBit ? node.right : node.left;
                        if (!(node.left || node.right)) {
                          val = node.val;
                          bitPos = bitPos + ii + 1;
                          break;
                        }
                      }
                    }
                    if (bitPos >= 32) {
                      bitPos -= 32;
                      srcPtr++;
                      word = stuffedData[srcPtr];
                    }
                    delta = val - offset2;
                    if (deltaEncode) {
                      if (j > 0) {
                        delta += prevVal;
                      } else if (i > 0) {
                        delta += resultPixels[k - width];
                      } else {
                        delta += prevVal;
                      }
                      delta &= 255;
                      resultPixels[k] = delta;
                      prevVal = delta;
                    } else {
                      resultPixels[k] = delta;
                    }
                  }
                }
              } else {
                for (k = 0, i = 0; i < height; i++) {
                  for (j = 0; j < width; j++, k++) {
                    if (mask[k]) {
                      val = 0;
                      valTmp = word << bitPos >>> 32 - numBitsLUTQick;
                      valTmpQuick = valTmp;
                      if (32 - bitPos < numBitsLUTQick) {
                        valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUTQick;
                        valTmpQuick = valTmp;
                      }
                      if (decodeLut[valTmpQuick]) {
                        val = decodeLut[valTmpQuick][1];
                        bitPos += decodeLut[valTmpQuick][0];
                      } else {
                        valTmp = word << bitPos >>> 32 - numBitsLUT;
                        valTmpQuick = valTmp;
                        if (32 - bitPos < numBitsLUT) {
                          valTmp |= stuffedData[srcPtr + 1] >>> 64 - bitPos - numBitsLUT;
                          valTmpQuick = valTmp;
                        }
                        node = tree;
                        for (ii = 0; ii < numBitsLUT; ii++) {
                          currentBit = valTmp >>> numBitsLUT - ii - 1 & 1;
                          node = currentBit ? node.right : node.left;
                          if (!(node.left || node.right)) {
                            val = node.val;
                            bitPos = bitPos + ii + 1;
                            break;
                          }
                        }
                      }
                      if (bitPos >= 32) {
                        bitPos -= 32;
                        srcPtr++;
                        word = stuffedData[srcPtr];
                      }
                      delta = val - offset2;
                      if (deltaEncode) {
                        if (j > 0 && mask[k - 1]) {
                          delta += prevVal;
                        } else if (i > 0 && mask[k - width]) {
                          delta += resultPixels[k - width];
                        } else {
                          delta += prevVal;
                        }
                        delta &= 255;
                        resultPixels[k] = delta;
                        prevVal = delta;
                      } else {
                        resultPixels[k] = delta;
                      }
                    }
                  }
                }
              }
              data.ptr = data.ptr + (srcPtr + 1) * 4 + (bitPos > 0 ? 4 : 0);
            }
            data.pixels.resultPixels = resultPixelsAllDim;
          },
          decodeBits: function(input, data, blockDataBuffer, offset2, iDim) {
            {
              var headerInfo = data.headerInfo;
              var fileVersion = headerInfo.fileVersion;
              var blockPtr = 0;
              var view = new DataView(input, data.ptr, 5);
              var headerByte = view.getUint8(0);
              blockPtr++;
              var bits67 = headerByte >> 6;
              var n = bits67 === 0 ? 4 : 3 - bits67;
              var doLut = (headerByte & 32) > 0 ? true : false;
              var numBits = headerByte & 31;
              var numElements = 0;
              if (n === 1) {
                numElements = view.getUint8(blockPtr);
                blockPtr++;
              } else if (n === 2) {
                numElements = view.getUint16(blockPtr, true);
                blockPtr += 2;
              } else if (n === 4) {
                numElements = view.getUint32(blockPtr, true);
                blockPtr += 4;
              } else {
                throw "Invalid valid pixel count type";
              }
              var scale = 2 * headerInfo.maxZError;
              var stuffedData, arrayBuf, store8, dataBytes, dataWords;
              var lutArr, lutData, lutBytes, lutBitsPerElement, bitsPerPixel;
              var zMax = headerInfo.numDims > 1 ? headerInfo.maxValues[iDim] : headerInfo.zMax;
              if (doLut) {
                data.counter.lut++;
                lutBytes = view.getUint8(blockPtr);
                lutBitsPerElement = numBits;
                blockPtr++;
                dataBytes = Math.ceil((lutBytes - 1) * numBits / 8);
                dataWords = Math.ceil(dataBytes / 4);
                arrayBuf = new ArrayBuffer(dataWords * 4);
                store8 = new Uint8Array(arrayBuf);
                data.ptr += blockPtr;
                store8.set(new Uint8Array(input, data.ptr, dataBytes));
                lutData = new Uint32Array(arrayBuf);
                data.ptr += dataBytes;
                bitsPerPixel = 0;
                while (lutBytes - 1 >>> bitsPerPixel) {
                  bitsPerPixel++;
                }
                dataBytes = Math.ceil(numElements * bitsPerPixel / 8);
                dataWords = Math.ceil(dataBytes / 4);
                arrayBuf = new ArrayBuffer(dataWords * 4);
                store8 = new Uint8Array(arrayBuf);
                store8.set(new Uint8Array(input, data.ptr, dataBytes));
                stuffedData = new Uint32Array(arrayBuf);
                data.ptr += dataBytes;
                if (fileVersion >= 3) {
                  lutArr = BitStuffer.unstuffLUT2(lutData, numBits, lutBytes - 1, offset2, scale, zMax);
                } else {
                  lutArr = BitStuffer.unstuffLUT(lutData, numBits, lutBytes - 1, offset2, scale, zMax);
                }
                if (fileVersion >= 3) {
                  BitStuffer.unstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements, lutArr);
                } else {
                  BitStuffer.unstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements, lutArr);
                }
              } else {
                data.counter.bitstuffer++;
                bitsPerPixel = numBits;
                data.ptr += blockPtr;
                if (bitsPerPixel > 0) {
                  dataBytes = Math.ceil(numElements * bitsPerPixel / 8);
                  dataWords = Math.ceil(dataBytes / 4);
                  arrayBuf = new ArrayBuffer(dataWords * 4);
                  store8 = new Uint8Array(arrayBuf);
                  store8.set(new Uint8Array(input, data.ptr, dataBytes));
                  stuffedData = new Uint32Array(arrayBuf);
                  data.ptr += dataBytes;
                  if (fileVersion >= 3) {
                    if (offset2 == null) {
                      BitStuffer.originalUnstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements);
                    } else {
                      BitStuffer.unstuff2(stuffedData, blockDataBuffer, bitsPerPixel, numElements, false, offset2, scale, zMax);
                    }
                  } else {
                    if (offset2 == null) {
                      BitStuffer.originalUnstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements);
                    } else {
                      BitStuffer.unstuff(stuffedData, blockDataBuffer, bitsPerPixel, numElements, false, offset2, scale, zMax);
                    }
                  }
                }
              }
            }
          },
          readTiles: function(input, data, OutPixelTypeArray) {
            var headerInfo = data.headerInfo;
            var width = headerInfo.width;
            var height = headerInfo.height;
            var microBlockSize = headerInfo.microBlockSize;
            var imageType = headerInfo.imageType;
            var dataTypeSize = Lerc2Helpers.getDataTypeSize(imageType);
            var numBlocksX = Math.ceil(width / microBlockSize);
            var numBlocksY = Math.ceil(height / microBlockSize);
            data.pixels.numBlocksY = numBlocksY;
            data.pixels.numBlocksX = numBlocksX;
            data.pixels.ptr = 0;
            var row = 0, col = 0, blockY = 0, blockX = 0, thisBlockHeight = 0, thisBlockWidth = 0, bytesLeft = 0, headerByte = 0, bits67 = 0, testCode = 0, outPtr = 0, outStride = 0, numBytes = 0, bytesleft = 0, z = 0, blockPtr = 0;
            var view, block, arrayBuf, store8, rawData;
            var blockEncoding;
            var blockDataBuffer = new OutPixelTypeArray(microBlockSize * microBlockSize);
            var lastBlockHeight = height % microBlockSize || microBlockSize;
            var lastBlockWidth = width % microBlockSize || microBlockSize;
            var offsetType, offset2;
            var numDims = headerInfo.numDims, iDim;
            var mask = data.pixels.resultMask;
            var resultPixels = data.pixels.resultPixels;
            for (blockY = 0; blockY < numBlocksY; blockY++) {
              thisBlockHeight = blockY !== numBlocksY - 1 ? microBlockSize : lastBlockHeight;
              for (blockX = 0; blockX < numBlocksX; blockX++) {
                thisBlockWidth = blockX !== numBlocksX - 1 ? microBlockSize : lastBlockWidth;
                outPtr = blockY * width * microBlockSize + blockX * microBlockSize;
                outStride = width - thisBlockWidth;
                for (iDim = 0; iDim < numDims; iDim++) {
                  if (numDims > 1) {
                    resultPixels = new OutPixelTypeArray(data.pixels.resultPixels.buffer, width * height * iDim * dataTypeSize, width * height);
                  }
                  bytesLeft = input.byteLength - data.ptr;
                  view = new DataView(input, data.ptr, Math.min(10, bytesLeft));
                  block = {};
                  blockPtr = 0;
                  headerByte = view.getUint8(0);
                  blockPtr++;
                  bits67 = headerByte >> 6 & 255;
                  testCode = headerByte >> 2 & 15;
                  if (testCode !== (blockX * microBlockSize >> 3 & 15)) {
                    throw "integrity issue";
                  }
                  blockEncoding = headerByte & 3;
                  if (blockEncoding > 3) {
                    data.ptr += blockPtr;
                    throw "Invalid block encoding (" + blockEncoding + ")";
                  } else if (blockEncoding === 2) {
                    data.counter.constant++;
                    data.ptr += blockPtr;
                    continue;
                  } else if (blockEncoding === 0) {
                    data.counter.uncompressed++;
                    data.ptr += blockPtr;
                    numBytes = thisBlockHeight * thisBlockWidth * dataTypeSize;
                    bytesleft = input.byteLength - data.ptr;
                    numBytes = numBytes < bytesleft ? numBytes : bytesleft;
                    arrayBuf = new ArrayBuffer(numBytes % dataTypeSize === 0 ? numBytes : numBytes + dataTypeSize - numBytes % dataTypeSize);
                    store8 = new Uint8Array(arrayBuf);
                    store8.set(new Uint8Array(input, data.ptr, numBytes));
                    rawData = new OutPixelTypeArray(arrayBuf);
                    z = 0;
                    if (mask) {
                      for (row = 0; row < thisBlockHeight; row++) {
                        for (col = 0; col < thisBlockWidth; col++) {
                          if (mask[outPtr]) {
                            resultPixels[outPtr] = rawData[z++];
                          }
                          outPtr++;
                        }
                        outPtr += outStride;
                      }
                    } else {
                      for (row = 0; row < thisBlockHeight; row++) {
                        for (col = 0; col < thisBlockWidth; col++) {
                          resultPixels[outPtr++] = rawData[z++];
                        }
                        outPtr += outStride;
                      }
                    }
                    data.ptr += z * dataTypeSize;
                  } else {
                    offsetType = Lerc2Helpers.getDataTypeUsed(imageType, bits67);
                    offset2 = Lerc2Helpers.getOnePixel(block, blockPtr, offsetType, view);
                    blockPtr += Lerc2Helpers.getDataTypeSize(offsetType);
                    if (blockEncoding === 3) {
                      data.ptr += blockPtr;
                      data.counter.constantoffset++;
                      if (mask) {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            if (mask[outPtr]) {
                              resultPixels[outPtr] = offset2;
                            }
                            outPtr++;
                          }
                          outPtr += outStride;
                        }
                      } else {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            resultPixels[outPtr++] = offset2;
                          }
                          outPtr += outStride;
                        }
                      }
                    } else {
                      data.ptr += blockPtr;
                      Lerc2Helpers.decodeBits(input, data, blockDataBuffer, offset2, iDim);
                      blockPtr = 0;
                      if (mask) {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            if (mask[outPtr]) {
                              resultPixels[outPtr] = blockDataBuffer[blockPtr++];
                            }
                            outPtr++;
                          }
                          outPtr += outStride;
                        }
                      } else {
                        for (row = 0; row < thisBlockHeight; row++) {
                          for (col = 0; col < thisBlockWidth; col++) {
                            resultPixels[outPtr++] = blockDataBuffer[blockPtr++];
                          }
                          outPtr += outStride;
                        }
                      }
                    }
                  }
                }
              }
            }
          },
          formatFileInfo: function(data) {
            return {
              "fileIdentifierString": data.headerInfo.fileIdentifierString,
              "fileVersion": data.headerInfo.fileVersion,
              "imageType": data.headerInfo.imageType,
              "height": data.headerInfo.height,
              "width": data.headerInfo.width,
              "numValidPixel": data.headerInfo.numValidPixel,
              "microBlockSize": data.headerInfo.microBlockSize,
              "blobSize": data.headerInfo.blobSize,
              "maxZError": data.headerInfo.maxZError,
              "pixelType": Lerc2Helpers.getPixelType(data.headerInfo.imageType),
              "eofOffset": data.eofOffset,
              "mask": data.mask ? {
                "numBytes": data.mask.numBytes
              } : null,
              "pixels": {
                "numBlocksX": data.pixels.numBlocksX,
                "numBlocksY": data.pixels.numBlocksY,
                "maxValue": data.headerInfo.zMax,
                "minValue": data.headerInfo.zMin,
                "noDataValue": data.noDataValue
              }
            };
          },
          constructConstantSurface: function(data) {
            var val = data.headerInfo.zMax;
            var numDims = data.headerInfo.numDims;
            var numPixels = data.headerInfo.height * data.headerInfo.width;
            var numPixelAllDims = numPixels * numDims;
            var i = 0, k = 0, nStart = 0;
            var mask = data.pixels.resultMask;
            if (mask) {
              if (numDims > 1) {
                for (i = 0; i < numDims; i++) {
                  nStart = i * numPixels;
                  for (k = 0; k < numPixels; k++) {
                    if (mask[k]) {
                      data.pixels.resultPixels[nStart + k] = val;
                    }
                  }
                }
              } else {
                for (k = 0; k < numPixels; k++) {
                  if (mask[k]) {
                    data.pixels.resultPixels[k] = val;
                  }
                }
              }
            } else {
              if (data.pixels.resultPixels.fill) {
                data.pixels.resultPixels.fill(val);
              } else {
                for (k = 0; k < numPixelAllDims; k++) {
                  data.pixels.resultPixels[k] = val;
                }
              }
            }
            return;
          },
          getDataTypeArray: function(t) {
            var tp;
            switch (t) {
              case 0:
                tp = Int8Array;
                break;
              case 1:
                tp = Uint8Array;
                break;
              case 2:
                tp = Int16Array;
                break;
              case 3:
                tp = Uint16Array;
                break;
              case 4:
                tp = Int32Array;
                break;
              case 5:
                tp = Uint32Array;
                break;
              case 6:
                tp = Float32Array;
                break;
              case 7:
                tp = Float64Array;
                break;
              default:
                tp = Float32Array;
            }
            return tp;
          },
          getPixelType: function(t) {
            var tp;
            switch (t) {
              case 0:
                tp = "S8";
                break;
              case 1:
                tp = "U8";
                break;
              case 2:
                tp = "S16";
                break;
              case 3:
                tp = "U16";
                break;
              case 4:
                tp = "S32";
                break;
              case 5:
                tp = "U32";
                break;
              case 6:
                tp = "F32";
                break;
              case 7:
                tp = "F64";
                break;
              default:
                tp = "F32";
            }
            return tp;
          },
          isValidPixelValue: function(t, val) {
            if (val == null) {
              return false;
            }
            var isValid;
            switch (t) {
              case 0:
                isValid = val >= -128 && val <= 127;
                break;
              case 1:
                isValid = val >= 0 && val <= 255;
                break;
              case 2:
                isValid = val >= -32768 && val <= 32767;
                break;
              case 3:
                isValid = val >= 0 && val <= 65536;
                break;
              case 4:
                isValid = val >= -2147483648 && val <= 2147483647;
                break;
              case 5:
                isValid = val >= 0 && val <= 4294967296;
                break;
              case 6:
                isValid = val >= -34027999387901484e22 && val <= 34027999387901484e22;
                break;
              case 7:
                isValid = val >= 5e-324 && val <= 17976931348623157e292;
                break;
              default:
                isValid = false;
            }
            return isValid;
          },
          getDataTypeSize: function(t) {
            var s = 0;
            switch (t) {
              case 0:
              case 1:
                s = 1;
                break;
              case 2:
              case 3:
                s = 2;
                break;
              case 4:
              case 5:
              case 6:
                s = 4;
                break;
              case 7:
                s = 8;
                break;
              default:
                s = t;
            }
            return s;
          },
          getDataTypeUsed: function(dt, tc) {
            var t = dt;
            switch (dt) {
              case 2:
              case 4:
                t = dt - tc;
                break;
              case 3:
              case 5:
                t = dt - 2 * tc;
                break;
              case 6:
                if (0 === tc) {
                  t = dt;
                } else if (1 === tc) {
                  t = 2;
                } else {
                  t = 1;
                }
                break;
              case 7:
                if (0 === tc) {
                  t = dt;
                } else {
                  t = dt - 2 * tc + 1;
                }
                break;
              default:
                t = dt;
                break;
            }
            return t;
          },
          getOnePixel: function(block, blockPtr, offsetType, view) {
            var temp = 0;
            switch (offsetType) {
              case 0:
                temp = view.getInt8(blockPtr);
                break;
              case 1:
                temp = view.getUint8(blockPtr);
                break;
              case 2:
                temp = view.getInt16(blockPtr, true);
                break;
              case 3:
                temp = view.getUint16(blockPtr, true);
                break;
              case 4:
                temp = view.getInt32(blockPtr, true);
                break;
              case 5:
                temp = view.getUInt32(blockPtr, true);
                break;
              case 6:
                temp = view.getFloat32(blockPtr, true);
                break;
              case 7:
                temp = view.getFloat64(blockPtr, true);
                break;
              default:
                throw "the decoder does not understand this pixel type";
            }
            return temp;
          }
        };
        var TreeNode = function(val, left, right) {
          this.val = val;
          this.left = left;
          this.right = right;
        };
        var Lerc2Decode2 = {
          decode: function(input, options) {
            options = options || {};
            var noDataValue = options.noDataValue;
            var i = 0, data = {};
            data.ptr = options.inputOffset || 0;
            data.pixels = {};
            if (!Lerc2Helpers.readHeaderInfo(input, data)) {
              return;
            }
            var headerInfo = data.headerInfo;
            var fileVersion = headerInfo.fileVersion;
            var OutPixelTypeArray = Lerc2Helpers.getDataTypeArray(headerInfo.imageType);
            Lerc2Helpers.readMask(input, data);
            if (headerInfo.numValidPixel !== headerInfo.width * headerInfo.height && !data.pixels.resultMask) {
              data.pixels.resultMask = options.maskData;
            }
            var numPixels = headerInfo.width * headerInfo.height;
            data.pixels.resultPixels = new OutPixelTypeArray(numPixels * headerInfo.numDims);
            data.counter = {
              onesweep: 0,
              uncompressed: 0,
              lut: 0,
              bitstuffer: 0,
              constant: 0,
              constantoffset: 0
            };
            if (headerInfo.numValidPixel !== 0) {
              if (headerInfo.zMax === headerInfo.zMin) {
                Lerc2Helpers.constructConstantSurface(data);
              } else if (fileVersion >= 4 && Lerc2Helpers.checkMinMaxRanges(input, data)) {
                Lerc2Helpers.constructConstantSurface(data);
              } else {
                var view = new DataView(input, data.ptr, 2);
                var bReadDataOneSweep = view.getUint8(0);
                data.ptr++;
                if (bReadDataOneSweep) {
                  Lerc2Helpers.readDataOneSweep(input, data, OutPixelTypeArray);
                } else {
                  if (fileVersion > 1 && headerInfo.imageType <= 1 && Math.abs(headerInfo.maxZError - 0.5) < 1e-5) {
                    var flagHuffman = view.getUint8(1);
                    data.ptr++;
                    data.encodeMode = flagHuffman;
                    if (flagHuffman > 2 || fileVersion < 4 && flagHuffman > 1) {
                      throw "Invalid Huffman flag " + flagHuffman;
                    }
                    if (flagHuffman) {
                      Lerc2Helpers.readHuffman(input, data, OutPixelTypeArray);
                    } else {
                      Lerc2Helpers.readTiles(input, data, OutPixelTypeArray);
                    }
                  } else {
                    Lerc2Helpers.readTiles(input, data, OutPixelTypeArray);
                  }
                }
              }
            }
            data.eofOffset = data.ptr;
            var diff;
            if (options.inputOffset) {
              diff = data.headerInfo.blobSize + options.inputOffset - data.ptr;
              if (Math.abs(diff) >= 1) {
                data.eofOffset = options.inputOffset + data.headerInfo.blobSize;
              }
            } else {
              diff = data.headerInfo.blobSize - data.ptr;
              if (Math.abs(diff) >= 1) {
                data.eofOffset = data.headerInfo.blobSize;
              }
            }
            var result = {
              width: headerInfo.width,
              height: headerInfo.height,
              pixelData: data.pixels.resultPixels,
              minValue: headerInfo.zMin,
              maxValue: headerInfo.zMax,
              validPixelCount: headerInfo.numValidPixel,
              dimCount: headerInfo.numDims,
              dimStats: {
                minValues: headerInfo.minValues,
                maxValues: headerInfo.maxValues
              },
              maskData: data.pixels.resultMask
            };
            if (data.pixels.resultMask && Lerc2Helpers.isValidPixelValue(headerInfo.imageType, noDataValue)) {
              var mask = data.pixels.resultMask;
              for (i = 0; i < numPixels; i++) {
                if (!mask[i]) {
                  result.pixelData[i] = noDataValue;
                }
              }
              result.noDataValue = noDataValue;
            }
            data.noDataValue = noDataValue;
            if (options.returnFileInfo) {
              result.fileInfo = Lerc2Helpers.formatFileInfo(data);
            }
            return result;
          },
          getBandCount: function(input) {
            var count = 0;
            var i = 0;
            var temp = {};
            temp.ptr = 0;
            temp.pixels = {};
            while (i < input.byteLength - 58) {
              Lerc2Helpers.readHeaderInfo(input, temp);
              i += temp.headerInfo.blobSize;
              count++;
              temp.ptr = i;
            }
            return count;
          }
        };
        return Lerc2Decode2;
      }();
      var isPlatformLittleEndian = function() {
        var a3 = new ArrayBuffer(4);
        var b = new Uint8Array(a3);
        var c = new Uint32Array(a3);
        c[0] = 1;
        return b[0] === 1;
      }();
      var Lerc2 = {
        decode: function(encodedData, options) {
          if (!isPlatformLittleEndian) {
            throw "Big endian system is not supported.";
          }
          options = options || {};
          var inputOffset = options.inputOffset || 0;
          var fileIdView = new Uint8Array(encodedData, inputOffset, 10);
          var fileIdentifierString = String.fromCharCode.apply(null, fileIdView);
          var lerc, majorVersion;
          if (fileIdentifierString.trim() === "CntZImage") {
            lerc = LercDecode;
            majorVersion = 1;
          } else if (fileIdentifierString.substring(0, 5) === "Lerc2") {
            lerc = Lerc2Decode;
            majorVersion = 2;
          } else {
            throw "Unexpected file identifier string: " + fileIdentifierString;
          }
          var iPlane = 0, eof = encodedData.byteLength - 10, encodedMaskData, bandMasks = [], bandMask, maskData;
          var decodedPixelBlock = {
            width: 0,
            height: 0,
            pixels: [],
            pixelType: options.pixelType,
            mask: null,
            statistics: []
          };
          while (inputOffset < eof) {
            var result = lerc.decode(encodedData, {
              inputOffset,
              encodedMaskData,
              maskData,
              returnMask: iPlane === 0 ? true : false,
              returnEncodedMask: iPlane === 0 ? true : false,
              returnFileInfo: true,
              pixelType: options.pixelType || null,
              noDataValue: options.noDataValue || null
            });
            inputOffset = result.fileInfo.eofOffset;
            if (iPlane === 0) {
              encodedMaskData = result.encodedMaskData;
              maskData = result.maskData;
              decodedPixelBlock.width = result.width;
              decodedPixelBlock.height = result.height;
              decodedPixelBlock.dimCount = result.dimCount || 1;
              decodedPixelBlock.pixelType = result.pixelType || result.fileInfo.pixelType;
              decodedPixelBlock.mask = result.maskData;
            }
            if (majorVersion > 1 && result.fileInfo.mask && result.fileInfo.mask.numBytes > 0) {
              bandMasks.push(result.maskData);
            }
            iPlane++;
            decodedPixelBlock.pixels.push(result.pixelData);
            decodedPixelBlock.statistics.push({
              minValue: result.minValue,
              maxValue: result.maxValue,
              noDataValue: result.noDataValue,
              dimStats: result.dimStats
            });
          }
          var i, j, numPixels;
          if (majorVersion > 1 && bandMasks.length > 1) {
            numPixels = decodedPixelBlock.width * decodedPixelBlock.height;
            decodedPixelBlock.bandMasks = bandMasks;
            maskData = new Uint8Array(numPixels);
            maskData.set(bandMasks[0]);
            for (i = 1; i < bandMasks.length; i++) {
              bandMask = bandMasks[i];
              for (j = 0; j < numPixels; j++) {
                maskData[j] = maskData[j] & bandMask[j];
              }
            }
            decodedPixelBlock.maskData = maskData;
          }
          return decodedPixelBlock;
        }
      };
      if (typeof define === "function" && define.amd) {
        define([], function() {
          return Lerc2;
        });
      } else if (typeof module2 !== "undefined" && module2.exports) {
        module2.exports = Lerc2;
      } else {
        this.Lerc = Lerc2;
      }
    })();
  }
});

// node_modules/nosleep.js/dist/NoSleep.min.js
var require_NoSleep_min = __commonJS({
  "node_modules/nosleep.js/dist/NoSleep.min.js"(exports2, module2) {
    /*! NoSleep.min.js v0.12.0 - git.io/vfn01 - Rich Tibbett - MIT license */
    !function(A, e) {
      "object" == typeof exports2 && "object" == typeof module2 ? module2.exports = e() : "function" == typeof define && define.amd ? define([], e) : "object" == typeof exports2 ? exports2.NoSleep = e() : A.NoSleep = e();
    }(exports2, function() {
      return function(A) {
        var e = {};
        function B(g) {
          if (e[g])
            return e[g].exports;
          var o = e[g] = { i: g, l: false, exports: {} };
          return A[g].call(o.exports, o, o.exports, B), o.l = true, o.exports;
        }
        return B.m = A, B.c = e, B.d = function(A2, e2, g) {
          B.o(A2, e2) || Object.defineProperty(A2, e2, { enumerable: true, get: g });
        }, B.r = function(A2) {
          "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(A2, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(A2, "__esModule", { value: true });
        }, B.t = function(A2, e2) {
          if (1 & e2 && (A2 = B(A2)), 8 & e2)
            return A2;
          if (4 & e2 && "object" == typeof A2 && A2 && A2.__esModule)
            return A2;
          var g = /* @__PURE__ */ Object.create(null);
          if (B.r(g), Object.defineProperty(g, "default", { enumerable: true, value: A2 }), 2 & e2 && "string" != typeof A2)
            for (var o in A2)
              B.d(g, o, function(e3) {
                return A2[e3];
              }.bind(null, o));
          return g;
        }, B.n = function(A2) {
          var e2 = A2 && A2.__esModule ? function() {
            return A2.default;
          } : function() {
            return A2;
          };
          return B.d(e2, "a", e2), e2;
        }, B.o = function(A2, e2) {
          return Object.prototype.hasOwnProperty.call(A2, e2);
        }, B.p = "", B(B.s = 0);
      }([function(A, e, B) {
        "use strict";
        var g = function() {
          function A2(A3, e2) {
            for (var B2 = 0; B2 < e2.length; B2++) {
              var g2 = e2[B2];
              g2.enumerable = g2.enumerable || false, g2.configurable = true, "value" in g2 && (g2.writable = true), Object.defineProperty(A3, g2.key, g2);
            }
          }
          return function(e2, B2, g2) {
            return B2 && A2(e2.prototype, B2), g2 && A2(e2, g2), e2;
          };
        }();
        var o = B(1), E = o.webm, n = o.mp4, C = function() {
          return "undefined" != typeof navigator && parseFloat(("" + (/CPU.*OS ([0-9_]{3,4})[0-9_]{0,1}|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent) || [0, ""])[1]).replace("undefined", "3_2").replace("_", ".").replace("_", "")) < 10 && !window.MSStream;
        }, Q = function() {
          return "wakeLock" in navigator;
        }, i = function() {
          function A2() {
            var e2 = this;
            if (function(A3, e3) {
              if (!(A3 instanceof e3))
                throw new TypeError("Cannot call a class as a function");
            }(this, A2), this.enabled = false, Q()) {
              this._wakeLock = null;
              var B2 = function() {
                null !== e2._wakeLock && "visible" === document.visibilityState && e2.enable();
              };
              document.addEventListener("visibilitychange", B2), document.addEventListener("fullscreenchange", B2);
            } else
              C() ? this.noSleepTimer = null : (this.noSleepVideo = document.createElement("video"), this.noSleepVideo.setAttribute("title", "No Sleep"), this.noSleepVideo.setAttribute("playsinline", ""), this._addSourceToVideo(this.noSleepVideo, "webm", E), this._addSourceToVideo(this.noSleepVideo, "mp4", n), this.noSleepVideo.addEventListener("loadedmetadata", function() {
                e2.noSleepVideo.duration <= 1 ? e2.noSleepVideo.setAttribute("loop", "") : e2.noSleepVideo.addEventListener("timeupdate", function() {
                  e2.noSleepVideo.currentTime > 0.5 && (e2.noSleepVideo.currentTime = Math.random());
                });
              }));
          }
          return g(A2, [{ key: "_addSourceToVideo", value: function(A3, e2, B2) {
            var g2 = document.createElement("source");
            g2.src = B2, g2.type = "video/" + e2, A3.appendChild(g2);
          } }, { key: "enable", value: function() {
            var A3 = this;
            return Q() ? navigator.wakeLock.request("screen").then(function(e2) {
              A3._wakeLock = e2, A3.enabled = true, console.log("Wake Lock active."), A3._wakeLock.addEventListener("release", function() {
                console.log("Wake Lock released.");
              });
            }).catch(function(e2) {
              throw A3.enabled = false, console.error(e2.name + ", " + e2.message), e2;
            }) : C() ? (this.disable(), console.warn("\n        NoSleep enabled for older iOS devices. This can interrupt\n        active or long-running network requests from completing successfully.\n        See https://github.com/richtr/NoSleep.js/issues/15 for more details.\n      "), this.noSleepTimer = window.setInterval(function() {
              document.hidden || (window.location.href = window.location.href.split("#")[0], window.setTimeout(window.stop, 0));
            }, 15e3), this.enabled = true, Promise.resolve()) : this.noSleepVideo.play().then(function(e2) {
              return A3.enabled = true, e2;
            }).catch(function(e2) {
              throw A3.enabled = false, e2;
            });
          } }, { key: "disable", value: function() {
            Q() ? (this._wakeLock && this._wakeLock.release(), this._wakeLock = null) : C() ? this.noSleepTimer && (console.warn("\n          NoSleep now disabled for older iOS devices.\n        "), window.clearInterval(this.noSleepTimer), this.noSleepTimer = null) : this.noSleepVideo.pause(), this.enabled = false;
          } }, { key: "isEnabled", get: function() {
            return this.enabled;
          } }]), A2;
        }();
        A.exports = i;
      }, function(A, e, B) {
        "use strict";
        A.exports = { webm: "data:video/webm;base64,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", mp4: "data:video/mp4;base64,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" };
      }]);
    });
  }
});

// Source/Cesium.js
var Cesium_exports = {};
__export(Cesium_exports, {
  AlphaMode: () => AlphaMode_default,
  AlphaPipelineStage: () => AlphaPipelineStage_default,
  Animation: () => Animation_default,
  AnimationViewModel: () => AnimationViewModel_default,
  Appearance: () => Appearance_default,
  ApproximateTerrainHeights: () => ApproximateTerrainHeights_default,
  ArcGISTiledElevationTerrainProvider: () => ArcGISTiledElevationTerrainProvider_default,
  ArcGisMapServerImageryProvider: () => ArcGisMapServerImageryProvider_default,
  ArcType: () => ArcType_default,
  ArticulationStageType: () => ArticulationStageType_default,
  AssociativeArray: () => AssociativeArray_default,
  AttributeCompression: () => AttributeCompression_default,
  AttributeType: () => AttributeType_default,
  AutoExposure: () => AutoExposure_default,
  AutomaticUniforms: () => AutomaticUniforms_default,
  Axis: () => Axis_default,
  AxisAlignedBoundingBox: () => AxisAlignedBoundingBox_default,
  B3dmLoader: () => B3dmLoader_default,
  B3dmParser: () => B3dmParser_default,
  BaseLayerPicker: () => BaseLayerPicker_default,
  BaseLayerPickerViewModel: () => BaseLayerPickerViewModel_default,
  BatchTable: () => BatchTable_default,
  BatchTableHierarchy: () => BatchTableHierarchy_default,
  BatchTexture: () => BatchTexture_default,
  BatchTexturePipelineStage: () => BatchTexturePipelineStage_default,
  Billboard: () => Billboard_default,
  BillboardCollection: () => BillboardCollection_default,
  BillboardGraphics: () => BillboardGraphics_default,
  BillboardVisualizer: () => BillboardVisualizer_default,
  BingMapsGeocoderService: () => BingMapsGeocoderService_default,
  BingMapsImageryProvider: () => BingMapsImageryProvider_default,
  BingMapsStyle: () => BingMapsStyle_default,
  BlendEquation: () => BlendEquation_default,
  BlendFunction: () => BlendFunction_default,
  BlendOption: () => BlendOption_default,
  BlendingState: () => BlendingState_default,
  BoundingRectangle: () => BoundingRectangle_default,
  BoundingSphere: () => BoundingSphere_default,
  BoundingSphereState: () => BoundingSphereState_default,
  BoxEmitter: () => BoxEmitter_default,
  BoxGeometry: () => BoxGeometry_default,
  BoxGeometryUpdater: () => BoxGeometryUpdater_default,
  BoxGraphics: () => BoxGraphics_default,
  BoxOutlineGeometry: () => BoxOutlineGeometry_default,
  BrdfLutGenerator: () => BrdfLutGenerator_default,
  Buffer: () => Buffer_default,
  BufferLoader: () => BufferLoader_default,
  BufferUsage: () => BufferUsage_default,
  CPUStylingPipelineStage: () => CPUStylingPipelineStage_default,
  CallbackProperty: () => CallbackProperty_default,
  Camera: () => Camera_default,
  CameraEventAggregator: () => CameraEventAggregator_default,
  CameraEventType: () => CameraEventType_default,
  CameraFlightPath: () => CameraFlightPath_default,
  Cartesian2: () => Cartesian2_default,
  Cartesian3: () => Cartesian3_default,
  Cartesian4: () => Cartesian4_default,
  Cartographic: () => Cartographic_default,
  CartographicGeocoderService: () => CartographicGeocoderService_default,
  CatmullRomSpline: () => CatmullRomSpline_default,
  Cesium3DContentGroup: () => Cesium3DContentGroup_default,
  Cesium3DTile: () => Cesium3DTile_default,
  Cesium3DTileBatchTable: () => Cesium3DTileBatchTable_default,
  Cesium3DTileColorBlendMode: () => Cesium3DTileColorBlendMode_default,
  Cesium3DTileContent: () => Cesium3DTileContent_default,
  Cesium3DTileContentFactory: () => Cesium3DTileContentFactory_default,
  Cesium3DTileContentState: () => Cesium3DTileContentState_default,
  Cesium3DTileContentType: () => Cesium3DTileContentType_default,
  Cesium3DTileFeature: () => Cesium3DTileFeature_default,
  Cesium3DTileFeatureTable: () => Cesium3DTileFeatureTable_default,
  Cesium3DTileOptimizationHint: () => Cesium3DTileOptimizationHint_default,
  Cesium3DTileOptimizations: () => Cesium3DTileOptimizations_default,
  Cesium3DTilePass: () => Cesium3DTilePass_default,
  Cesium3DTilePassState: () => Cesium3DTilePassState_default,
  Cesium3DTilePointFeature: () => Cesium3DTilePointFeature_default,
  Cesium3DTileRefine: () => Cesium3DTileRefine_default,
  Cesium3DTileStyle: () => Cesium3DTileStyle_default,
  Cesium3DTileStyleEngine: () => Cesium3DTileStyleEngine_default,
  Cesium3DTilesInspector: () => Cesium3DTilesInspector_default,
  Cesium3DTilesInspectorViewModel: () => Cesium3DTilesInspectorViewModel_default,
  Cesium3DTileset: () => Cesium3DTileset_default,
  Cesium3DTilesetCache: () => Cesium3DTilesetCache_default,
  Cesium3DTilesetGraphics: () => Cesium3DTilesetGraphics_default,
  Cesium3DTilesetHeatmap: () => Cesium3DTilesetHeatmap_default,
  Cesium3DTilesetMetadata: () => Cesium3DTilesetMetadata_default,
  Cesium3DTilesetMostDetailedTraversal: () => Cesium3DTilesetMostDetailedTraversal_default,
  Cesium3DTilesetStatistics: () => Cesium3DTilesetStatistics_default,
  Cesium3DTilesetTraversal: () => Cesium3DTilesetTraversal_default,
  Cesium3DTilesetVisualizer: () => Cesium3DTilesetVisualizer_default,
  CesiumInspector: () => CesiumInspector_default,
  CesiumInspectorViewModel: () => CesiumInspectorViewModel_default,
  CesiumTerrainProvider: () => CesiumTerrainProvider_default,
  CesiumWidget: () => CesiumWidget_default,
  Check: () => Check_default,
  CheckerboardMaterialProperty: () => CheckerboardMaterialProperty_default,
  CircleEmitter: () => CircleEmitter_default,
  CircleGeometry: () => CircleGeometry_default,
  CircleOutlineGeometry: () => CircleOutlineGeometry_default,
  ClassificationModelDrawCommand: () => ClassificationModelDrawCommand_default,
  ClassificationPipelineStage: () => ClassificationPipelineStage_default,
  ClassificationPrimitive: () => ClassificationPrimitive_default,
  ClassificationType: () => ClassificationType_default,
  ClearCommand: () => ClearCommand_default,
  ClippingPlane: () => ClippingPlane_default,
  ClippingPlaneCollection: () => ClippingPlaneCollection_default,
  Clock: () => Clock_default,
  ClockRange: () => ClockRange_default,
  ClockStep: () => ClockStep_default,
  ClockViewModel: () => ClockViewModel_default,
  CloudCollection: () => CloudCollection_default,
  CloudType: () => CloudType_default,
  Color: () => Color_default,
  ColorBlendMode: () => ColorBlendMode_default,
  ColorGeometryInstanceAttribute: () => ColorGeometryInstanceAttribute_default,
  ColorMaterialProperty: () => ColorMaterialProperty_default,
  Command: () => Command_default,
  ComponentDatatype: () => ComponentDatatype_default,
  Composite3DTileContent: () => Composite3DTileContent_default,
  CompositeEntityCollection: () => CompositeEntityCollection_default,
  CompositeMaterialProperty: () => CompositeMaterialProperty_default,
  CompositePositionProperty: () => CompositePositionProperty_default,
  CompositeProperty: () => CompositeProperty_default,
  CompressedTextureBuffer: () => CompressedTextureBuffer_default,
  ComputeCommand: () => ComputeCommand_default,
  ComputeEngine: () => ComputeEngine_default,
  ConditionsExpression: () => ConditionsExpression_default,
  ConeEmitter: () => ConeEmitter_default,
  ConstantPositionProperty: () => ConstantPositionProperty_default,
  ConstantProperty: () => ConstantProperty_default,
  ConstantSpline: () => ConstantSpline_default,
  ContentMetadata: () => ContentMetadata_default,
  Context: () => Context_default,
  ContextLimits: () => ContextLimits_default,
  CoplanarPolygonGeometry: () => CoplanarPolygonGeometry_default,
  CoplanarPolygonGeometryLibrary: () => CoplanarPolygonGeometryLibrary_default,
  CoplanarPolygonOutlineGeometry: () => CoplanarPolygonOutlineGeometry_default,
  CornerType: () => CornerType_default,
  CorridorGeometry: () => CorridorGeometry_default,
  CorridorGeometryLibrary: () => CorridorGeometryLibrary_default,
  CorridorGeometryUpdater: () => CorridorGeometryUpdater_default,
  CorridorGraphics: () => CorridorGraphics_default,
  CorridorOutlineGeometry: () => CorridorOutlineGeometry_default,
  Credit: () => Credit_default,
  CreditDisplay: () => CreditDisplay_default,
  CubeMap: () => CubeMap_default,
  CubeMapFace: () => CubeMapFace_default,
  CubicRealPolynomial: () => CubicRealPolynomial_default,
  CullFace: () => CullFace_default,
  CullingVolume: () => CullingVolume_default,
  CumulusCloud: () => CumulusCloud_default,
  CustomDataSource: () => CustomDataSource_default,
  CustomHeightmapTerrainProvider: () => CustomHeightmapTerrainProvider_default,
  CustomShader: () => CustomShader_default,
  CustomShaderMode: () => CustomShaderMode_default,
  CustomShaderPipelineStage: () => CustomShaderPipelineStage_default,
  CustomShaderTranslucencyMode: () => CustomShaderTranslucencyMode_default,
  CylinderGeometry: () => CylinderGeometry_default,
  CylinderGeometryLibrary: () => CylinderGeometryLibrary_default,
  CylinderGeometryUpdater: () => CylinderGeometryUpdater_default,
  CylinderGraphics: () => CylinderGraphics_default,
  CylinderOutlineGeometry: () => CylinderOutlineGeometry_default,
  CzmlDataSource: () => CzmlDataSource_default,
  DataSource: () => DataSource_default,
  DataSourceClock: () => DataSourceClock_default,
  DataSourceCollection: () => DataSourceCollection_default,
  DataSourceDisplay: () => DataSourceDisplay_default,
  DebugAppearance: () => DebugAppearance_default,
  DebugCameraPrimitive: () => DebugCameraPrimitive_default,
  DebugInspector: () => DebugInspector_default,
  DebugModelMatrixPrimitive: () => DebugModelMatrixPrimitive_default,
  DefaultProxy: () => DefaultProxy_default,
  DepthFunction: () => DepthFunction_default,
  DepthPlane: () => DepthPlane_default,
  DequantizationPipelineStage: () => DequantizationPipelineStage_default,
  DerivedCommand: () => DerivedCommand_default,
  DeveloperError: () => DeveloperError_default,
  DeviceOrientationCameraController: () => DeviceOrientationCameraController_default,
  DirectionalLight: () => DirectionalLight_default,
  DiscardEmptyTileImagePolicy: () => DiscardEmptyTileImagePolicy_default,
  DiscardMissingTileImagePolicy: () => DiscardMissingTileImagePolicy_default,
  DistanceDisplayCondition: () => DistanceDisplayCondition_default,
  DistanceDisplayConditionGeometryInstanceAttribute: () => DistanceDisplayConditionGeometryInstanceAttribute_default,
  DoubleEndedPriorityQueue: () => DoubleEndedPriorityQueue_default,
  DoublyLinkedList: () => DoublyLinkedList_default,
  DracoLoader: () => DracoLoader_default,
  DrawCommand: () => DrawCommand_default,
  DynamicGeometryBatch: () => DynamicGeometryBatch_default,
  DynamicGeometryUpdater: () => DynamicGeometryUpdater_default,
  EarthOrientationParameters: () => EarthOrientationParameters_default,
  EarthOrientationParametersSample: () => EarthOrientationParametersSample_default,
  EasingFunction: () => EasingFunction_default,
  EllipseGeometry: () => EllipseGeometry_default,
  EllipseGeometryLibrary: () => EllipseGeometryLibrary_default,
  EllipseGeometryUpdater: () => EllipseGeometryUpdater_default,
  EllipseGraphics: () => EllipseGraphics_default,
  EllipseOutlineGeometry: () => EllipseOutlineGeometry_default,
  Ellipsoid: () => Ellipsoid_default,
  EllipsoidGeodesic: () => EllipsoidGeodesic_default,
  EllipsoidGeometry: () => EllipsoidGeometry_default,
  EllipsoidGeometryUpdater: () => EllipsoidGeometryUpdater_default,
  EllipsoidGraphics: () => EllipsoidGraphics_default,
  EllipsoidOutlineGeometry: () => EllipsoidOutlineGeometry_default,
  EllipsoidPrimitive: () => EllipsoidPrimitive_default,
  EllipsoidRhumbLine: () => EllipsoidRhumbLine_default,
  EllipsoidSurfaceAppearance: () => EllipsoidSurfaceAppearance_default,
  EllipsoidTangentPlane: () => EllipsoidTangentPlane_default,
  EllipsoidTerrainProvider: () => EllipsoidTerrainProvider_default,
  EllipsoidalOccluder: () => EllipsoidalOccluder_default,
  Empty3DTileContent: () => Empty3DTileContent_default,
  EncodedCartesian3: () => EncodedCartesian3_default,
  Entity: () => Entity_default,
  EntityCluster: () => EntityCluster_default,
  EntityCollection: () => EntityCollection_default,
  EntityView: () => EntityView_default,
  Event: () => Event_default,
  EventHelper: () => EventHelper_default,
  Expression: () => Expression_default,
  ExpressionNodeType: () => ExpressionNodeType_default,
  ExtrapolationType: () => ExtrapolationType_default,
  FeatureDetection: () => FeatureDetection_default,
  FeatureIdPipelineStage: () => FeatureIdPipelineStage_default,
  Fog: () => Fog_default,
  ForEach: () => ForEach_default,
  FrameRateMonitor: () => FrameRateMonitor_default,
  FrameState: () => FrameState_default,
  Framebuffer: () => Framebuffer_default,
  FramebufferManager: () => FramebufferManager_default,
  FrustumCommands: () => FrustumCommands_default,
  FrustumGeometry: () => FrustumGeometry_default,
  FrustumOutlineGeometry: () => FrustumOutlineGeometry_default,
  Fullscreen: () => Fullscreen_default,
  FullscreenButton: () => FullscreenButton_default,
  FullscreenButtonViewModel: () => FullscreenButtonViewModel_default,
  GeoJsonDataSource: () => GeoJsonDataSource_default,
  GeoJsonLoader: () => GeoJsonLoader_default,
  GeocodeType: () => GeocodeType_default,
  Geocoder: () => Geocoder_default,
  GeocoderService: () => GeocoderService_default,
  GeocoderViewModel: () => GeocoderViewModel_default,
  GeographicProjection: () => GeographicProjection_default,
  GeographicTilingScheme: () => GeographicTilingScheme_default,
  Geometry: () => Geometry_default,
  Geometry3DTileContent: () => Geometry3DTileContent_default,
  GeometryAttribute: () => GeometryAttribute_default,
  GeometryAttributes: () => GeometryAttributes_default,
  GeometryFactory: () => GeometryFactory_default,
  GeometryInstance: () => GeometryInstance_default,
  GeometryInstanceAttribute: () => GeometryInstanceAttribute_default,
  GeometryOffsetAttribute: () => GeometryOffsetAttribute_default,
  GeometryPipeline: () => GeometryPipeline_default,
  GeometryPipelineStage: () => GeometryPipelineStage_default,
  GeometryType: () => GeometryType_default,
  GeometryUpdater: () => GeometryUpdater_default,
  GeometryVisualizer: () => GeometryVisualizer_default,
  GetFeatureInfoFormat: () => GetFeatureInfoFormat_default,
  Globe: () => Globe_default,
  GlobeDepth: () => GlobeDepth_default,
  GlobeSurfaceShaderSet: () => GlobeSurfaceShaderSet_default,
  GlobeSurfaceTile: () => GlobeSurfaceTile_default,
  GlobeSurfaceTileProvider: () => GlobeSurfaceTileProvider_default,
  GlobeTranslucency: () => GlobeTranslucency_default,
  GlobeTranslucencyFramebuffer: () => GlobeTranslucencyFramebuffer_default,
  GlobeTranslucencyState: () => GlobeTranslucencyState_default,
  GltfBufferViewLoader: () => GltfBufferViewLoader_default,
  GltfDracoLoader: () => GltfDracoLoader_default,
  GltfImageLoader: () => GltfImageLoader_default,
  GltfIndexBufferLoader: () => GltfIndexBufferLoader_default,
  GltfJsonLoader: () => GltfJsonLoader_default,
  GltfLoader: () => GltfLoader_default,
  GltfLoaderUtil: () => GltfLoaderUtil_default,
  GltfStructuralMetadataLoader: () => GltfStructuralMetadataLoader_default,
  GltfTextureLoader: () => GltfTextureLoader_default,
  GltfVertexBufferLoader: () => GltfVertexBufferLoader_default,
  GoogleEarthEnterpriseImageryProvider: () => GoogleEarthEnterpriseImageryProvider_default,
  GoogleEarthEnterpriseMapsProvider: () => GoogleEarthEnterpriseMapsProvider_default,
  GoogleEarthEnterpriseMetadata: () => GoogleEarthEnterpriseMetadata_default,
  GoogleEarthEnterpriseTerrainData: () => GoogleEarthEnterpriseTerrainData_default,
  GoogleEarthEnterpriseTerrainProvider: () => GoogleEarthEnterpriseTerrainProvider_default,
  GoogleEarthEnterpriseTileInformation: () => GoogleEarthEnterpriseTileInformation_default,
  GpxDataSource: () => GpxDataSource_default,
  GregorianDate: () => GregorianDate_default,
  GridImageryProvider: () => GridImageryProvider_default,
  GridMaterialProperty: () => GridMaterialProperty_default,
  GroundGeometryUpdater: () => GroundGeometryUpdater_default,
  GroundPolylineGeometry: () => GroundPolylineGeometry_default,
  GroundPolylinePrimitive: () => GroundPolylinePrimitive_default,
  GroundPrimitive: () => GroundPrimitive_default,
  GroupMetadata: () => GroupMetadata_default,
  HeadingPitchRange: () => HeadingPitchRange_default,
  HeadingPitchRoll: () => HeadingPitchRoll_default,
  Heap: () => Heap_default,
  HeightReference: () => HeightReference_default,
  HeightmapEncoding: () => HeightmapEncoding_default,
  HeightmapTerrainData: () => HeightmapTerrainData_default,
  HeightmapTessellator: () => HeightmapTessellator_default,
  HermitePolynomialApproximation: () => HermitePolynomialApproximation_default,
  HermiteSpline: () => HermiteSpline_default,
  HilbertOrder: () => HilbertOrder_default,
  HomeButton: () => HomeButton_default,
  HomeButtonViewModel: () => HomeButtonViewModel_default,
  HorizontalOrigin: () => HorizontalOrigin_default,
  I3SDataProvider: () => I3SDataProvider_default,
  I3SFeature: () => I3SFeature_default,
  I3SField: () => I3SField_default,
  I3SGeometry: () => I3SGeometry_default,
  I3SLayer: () => I3SLayer_default,
  I3SNode: () => I3SNode_default,
  I3dmLoader: () => I3dmLoader_default,
  I3dmParser: () => I3dmParser_default,
  Iau2000Orientation: () => Iau2000Orientation_default,
  Iau2006XysData: () => Iau2006XysData_default,
  Iau2006XysSample: () => Iau2006XysSample_default,
  IauOrientationAxes: () => IauOrientationAxes_default,
  IauOrientationParameters: () => IauOrientationParameters_default,
  ImageBasedLighting: () => ImageBasedLighting_default,
  ImageBasedLightingPipelineStage: () => ImageBasedLightingPipelineStage_default,
  ImageMaterialProperty: () => ImageMaterialProperty_default,
  Imagery: () => Imagery_default,
  ImageryLayer: () => ImageryLayer_default,
  ImageryLayerCollection: () => ImageryLayerCollection_default,
  ImageryLayerFeatureInfo: () => ImageryLayerFeatureInfo_default,
  ImageryProvider: () => ImageryProvider_default,
  ImageryState: () => ImageryState_default,
  Implicit3DTileContent: () => Implicit3DTileContent_default,
  ImplicitAvailabilityBitstream: () => ImplicitAvailabilityBitstream_default,
  ImplicitMetadataView: () => ImplicitMetadataView_default,
  ImplicitSubdivisionScheme: () => ImplicitSubdivisionScheme_default,
  ImplicitSubtree: () => ImplicitSubtree_default,
  ImplicitSubtreeMetadata: () => ImplicitSubtreeMetadata_default,
  ImplicitTileCoordinates: () => ImplicitTileCoordinates_default,
  ImplicitTileset: () => ImplicitTileset_default,
  IndexDatatype: () => IndexDatatype_default,
  InfoBox: () => InfoBox_default,
  InfoBoxViewModel: () => InfoBoxViewModel_default,
  InspectorShared: () => InspectorShared_default,
  InstanceAttributeSemantic: () => InstanceAttributeSemantic_default,
  InstancingPipelineStage: () => InstancingPipelineStage_default,
  InterpolationAlgorithm: () => InterpolationAlgorithm_default,
  InterpolationType: () => InterpolationType_default,
  Intersect: () => Intersect_default,
  IntersectionTests: () => IntersectionTests_default,
  Intersections2D: () => Intersections2D_default,
  Interval: () => Interval_default,
  InvertClassification: () => InvertClassification_default,
  Ion: () => Ion_default,
  IonGeocoderService: () => IonGeocoderService_default,
  IonImageryProvider: () => IonImageryProvider_default,
  IonResource: () => IonResource_default,
  IonWorldImageryStyle: () => IonWorldImageryStyle_default,
  Iso8601: () => Iso8601_default,
  JobScheduler: () => JobScheduler_default,
  JobType: () => JobType_default,
  JsonMetadataTable: () => JsonMetadataTable_default,
  JulianDate: () => JulianDate_default,
  KTX2Transcoder: () => KTX2Transcoder_default,
  KeyboardEventModifier: () => KeyboardEventModifier_default,
  KmlCamera: () => KmlCamera_default,
  KmlDataSource: () => KmlDataSource_default,
  KmlLookAt: () => KmlLookAt_default,
  KmlTour: () => KmlTour_default,
  KmlTourFlyTo: () => KmlTourFlyTo_default,
  KmlTourWait: () => KmlTourWait_default,
  Label: () => Label_default,
  LabelCollection: () => LabelCollection_default,
  LabelGraphics: () => LabelGraphics_default,
  LabelStyle: () => LabelStyle_default,
  LabelVisualizer: () => LabelVisualizer_default,
  LagrangePolynomialApproximation: () => LagrangePolynomialApproximation_default,
  LeapSecond: () => LeapSecond_default,
  Light: () => Light_default,
  LightingModel: () => LightingModel_default,
  LightingPipelineStage: () => LightingPipelineStage_default,
  LinearApproximation: () => LinearApproximation_default,
  LinearSpline: () => LinearSpline_default,
  ManagedArray: () => ManagedArray_default,
  MapMode2D: () => MapMode2D_default,
  MapProjection: () => MapProjection_default,
  MapboxImageryProvider: () => MapboxImageryProvider_default,
  MapboxStyleImageryProvider: () => MapboxStyleImageryProvider_default,
  Material: () => Material_default,
  MaterialAppearance: () => MaterialAppearance_default,
  MaterialPipelineStage: () => MaterialPipelineStage_default,
  MaterialProperty: () => MaterialProperty_default,
  Math: () => Math_default,
  Matrix2: () => Matrix2_default,
  Matrix3: () => Matrix3_default,
  Matrix4: () => Matrix4_default,
  MetadataClass: () => MetadataClass_default,
  MetadataClassProperty: () => MetadataClassProperty_default,
  MetadataComponentType: () => MetadataComponentType_default,
  MetadataEntity: () => MetadataEntity_default,
  MetadataEnum: () => MetadataEnum_default,
  MetadataEnumValue: () => MetadataEnumValue_default,
  MetadataPipelineStage: () => MetadataPipelineStage_default,
  MetadataSchema: () => MetadataSchema_default,
  MetadataSchemaLoader: () => MetadataSchemaLoader_default,
  MetadataSemantic: () => MetadataSemantic_default,
  MetadataTable: () => MetadataTable_default,
  MetadataTableProperty: () => MetadataTableProperty_default,
  MetadataType: () => MetadataType_default,
  MipmapHint: () => MipmapHint_default,
  Model: () => Model_default,
  Model3DTileContent: () => Model3DTileContent_default,
  ModelAlphaOptions: () => ModelAlphaOptions_default,
  ModelAnimation: () => ModelAnimation_default,
  ModelAnimationChannel: () => ModelAnimationChannel_default,
  ModelAnimationCollection: () => ModelAnimationCollection_default,
  ModelAnimationLoop: () => ModelAnimationLoop_default,
  ModelAnimationState: () => ModelAnimationState_default,
  ModelArticulation: () => ModelArticulation_default,
  ModelArticulationStage: () => ModelArticulationStage_default,
  ModelClippingPlanesPipelineStage: () => ModelClippingPlanesPipelineStage_default,
  ModelColorPipelineStage: () => ModelColorPipelineStage_default,
  ModelComponents: () => ModelComponents_default,
  ModelDrawCommand: () => ModelDrawCommand_default,
  ModelFeature: () => ModelFeature_default,
  ModelFeatureTable: () => ModelFeatureTable_default,
  ModelGraphics: () => ModelGraphics_default,
  ModelLightingOptions: () => ModelLightingOptions_default,
  ModelMatrixUpdateStage: () => ModelMatrixUpdateStage_default,
  ModelNode: () => ModelNode_default,
  ModelRenderResources: () => ModelRenderResources_default,
  ModelRuntimeNode: () => ModelRuntimeNode_default,
  ModelRuntimePrimitive: () => ModelRuntimePrimitive_default,
  ModelSceneGraph: () => ModelSceneGraph_default,
  ModelSilhouettePipelineStage: () => ModelSilhouettePipelineStage_default,
  ModelSkin: () => ModelSkin_default,
  ModelSplitterPipelineStage: () => ModelSplitterPipelineStage_default,
  ModelStatistics: () => ModelStatistics_default,
  ModelType: () => ModelType_default,
  ModelUtility: () => ModelUtility_default,
  ModelVisualizer: () => ModelVisualizer_default,
  Moon: () => Moon_default,
  MorphTargetsPipelineStage: () => MorphTargetsPipelineStage_default,
  MorphWeightSpline: () => MorphWeightSpline_default,
  MortonOrder: () => MortonOrder_default,
  Multiple3DTileContent: () => Multiple3DTileContent_default,
  MultisampleFramebuffer: () => MultisampleFramebuffer_default,
  NavigationHelpButton: () => NavigationHelpButton_default,
  NavigationHelpButtonViewModel: () => NavigationHelpButtonViewModel_default,
  NearFarScalar: () => NearFarScalar_default,
  NeverTileDiscardPolicy: () => NeverTileDiscardPolicy_default,
  NodeRenderResources: () => NodeRenderResources_default,
  NodeStatisticsPipelineStage: () => NodeStatisticsPipelineStage_default,
  NodeTransformationProperty: () => NodeTransformationProperty_default,
  OIT: () => OIT_default,
  Occluder: () => Occluder_default,
  OctahedralProjectedCubeMap: () => OctahedralProjectedCubeMap_default,
  OffsetGeometryInstanceAttribute: () => OffsetGeometryInstanceAttribute_default,
  OpenCageGeocoderService: () => OpenCageGeocoderService_default,
  OpenStreetMapImageryProvider: () => OpenStreetMapImageryProvider_default,
  OrderedGroundPrimitiveCollection: () => OrderedGroundPrimitiveCollection_default,
  OrientedBoundingBox: () => OrientedBoundingBox_default,
  OrthographicFrustum: () => OrthographicFrustum_default,
  OrthographicOffCenterFrustum: () => OrthographicOffCenterFrustum_default,
  Packable: () => Packable_default,
  PackableForInterpolation: () => PackableForInterpolation_default,
  Particle: () => Particle_default,
  ParticleBurst: () => ParticleBurst_default,
  ParticleEmitter: () => ParticleEmitter_default,
  ParticleSystem: () => ParticleSystem_default,
  Pass: () => Pass_default,
  PassState: () => PassState_default,
  PathGraphics: () => PathGraphics_default,
  PathVisualizer: () => PathVisualizer_default,
  PeliasGeocoderService: () => PeliasGeocoderService_default,
  PerInstanceColorAppearance: () => PerInstanceColorAppearance_default,
  PerformanceDisplay: () => PerformanceDisplay_default,
  PerformanceWatchdog: () => PerformanceWatchdog_default,
  PerformanceWatchdogViewModel: () => PerformanceWatchdogViewModel_default,
  PerspectiveFrustum: () => PerspectiveFrustum_default,
  PerspectiveOffCenterFrustum: () => PerspectiveOffCenterFrustum_default,
  PickDepth: () => PickDepth_default,
  PickDepthFramebuffer: () => PickDepthFramebuffer_default,
  PickFramebuffer: () => PickFramebuffer_default,
  Picking: () => Picking_default,
  PickingPipelineStage: () => PickingPipelineStage_default,
  PinBuilder: () => PinBuilder_default,
  PixelDatatype: () => PixelDatatype_default,
  PixelFormat: () => PixelFormat_default,
  Plane: () => Plane_default,
  PlaneGeometry: () => PlaneGeometry_default,
  PlaneGeometryUpdater: () => PlaneGeometryUpdater_default,
  PlaneGraphics: () => PlaneGraphics_default,
  PlaneOutlineGeometry: () => PlaneOutlineGeometry_default,
  PntsLoader: () => PntsLoader_default,
  PntsParser: () => PntsParser_default,
  PointCloud: () => PointCloud_default,
  PointCloudEyeDomeLighting: () => PointCloudEyeDomeLighting_default2,
  PointCloudShading: () => PointCloudShading_default,
  PointCloudStylingPipelineStage: () => PointCloudStylingPipelineStage_default,
  PointGraphics: () => PointGraphics_default,
  PointPrimitive: () => PointPrimitive_default,
  PointPrimitiveCollection: () => PointPrimitiveCollection_default,
  PointVisualizer: () => PointVisualizer_default,
  PolygonGeometry: () => PolygonGeometry_default,
  PolygonGeometryLibrary: () => PolygonGeometryLibrary_default,
  PolygonGeometryUpdater: () => PolygonGeometryUpdater_default,
  PolygonGraphics: () => PolygonGraphics_default,
  PolygonHierarchy: () => PolygonHierarchy_default,
  PolygonOutlineGeometry: () => PolygonOutlineGeometry_default,
  PolygonPipeline: () => PolygonPipeline_default,
  Polyline: () => Polyline_default,
  PolylineArrowMaterialProperty: () => PolylineArrowMaterialProperty_default,
  PolylineCollection: () => PolylineCollection_default,
  PolylineColorAppearance: () => PolylineColorAppearance_default,
  PolylineDashMaterialProperty: () => PolylineDashMaterialProperty_default,
  PolylineGeometry: () => PolylineGeometry_default,
  PolylineGeometryUpdater: () => PolylineGeometryUpdater_default,
  PolylineGlowMaterialProperty: () => PolylineGlowMaterialProperty_default,
  PolylineGraphics: () => PolylineGraphics_default,
  PolylineMaterialAppearance: () => PolylineMaterialAppearance_default,
  PolylineOutlineMaterialProperty: () => PolylineOutlineMaterialProperty_default,
  PolylinePipeline: () => PolylinePipeline_default,
  PolylineVisualizer: () => PolylineVisualizer_default,
  PolylineVolumeGeometry: () => PolylineVolumeGeometry_default,
  PolylineVolumeGeometryLibrary: () => PolylineVolumeGeometryLibrary_default,
  PolylineVolumeGeometryUpdater: () => PolylineVolumeGeometryUpdater_default,
  PolylineVolumeGraphics: () => PolylineVolumeGraphics_default,
  PolylineVolumeOutlineGeometry: () => PolylineVolumeOutlineGeometry_default,
  PositionProperty: () => PositionProperty_default,
  PositionPropertyArray: () => PositionPropertyArray_default,
  PostProcessStage: () => PostProcessStage_default,
  PostProcessStageCollection: () => PostProcessStageCollection_default,
  PostProcessStageComposite: () => PostProcessStageComposite_default,
  PostProcessStageLibrary: () => PostProcessStageLibrary_default,
  PostProcessStageSampleMode: () => PostProcessStageSampleMode_default,
  PostProcessStageTextureCache: () => PostProcessStageTextureCache_default,
  Primitive: () => Primitive_default,
  PrimitiveCollection: () => PrimitiveCollection_default,
  PrimitiveLoadPlan: () => PrimitiveLoadPlan_default,
  PrimitiveOutlineGenerator: () => PrimitiveOutlineGenerator_default,
  PrimitiveOutlinePipelineStage: () => PrimitiveOutlinePipelineStage_default,
  PrimitivePipeline: () => PrimitivePipeline_default,
  PrimitiveRenderResources: () => PrimitiveRenderResources_default,
  PrimitiveState: () => PrimitiveState_default,
  PrimitiveStatisticsPipelineStage: () => PrimitiveStatisticsPipelineStage_default,
  PrimitiveType: () => PrimitiveType_default,
  ProjectionPicker: () => ProjectionPicker_default,
  ProjectionPickerViewModel: () => ProjectionPickerViewModel_default,
  Property: () => Property_default,
  PropertyArray: () => PropertyArray_default,
  PropertyAttribute: () => PropertyAttribute_default,
  PropertyAttributeProperty: () => PropertyAttributeProperty_default,
  PropertyBag: () => PropertyBag_default,
  PropertyTable: () => PropertyTable_default,
  PropertyTexture: () => PropertyTexture_default,
  PropertyTextureProperty: () => PropertyTextureProperty_default,
  ProviderViewModel: () => ProviderViewModel_default,
  Proxy: () => Proxy_default,
  QuadraticRealPolynomial: () => QuadraticRealPolynomial_default,
  QuadtreeOccluders: () => QuadtreeOccluders_default,
  QuadtreePrimitive: () => QuadtreePrimitive_default,
  QuadtreeTile: () => QuadtreeTile_default,
  QuadtreeTileLoadState: () => QuadtreeTileLoadState_default,
  QuadtreeTileProvider: () => QuadtreeTileProvider_default,
  QuantizedMeshTerrainData: () => QuantizedMeshTerrainData_default,
  QuarticRealPolynomial: () => QuarticRealPolynomial_default,
  Quaternion: () => Quaternion_default,
  QuaternionSpline: () => QuaternionSpline_default,
  Queue: () => Queue_default,
  Ray: () => Ray_default,
  Rectangle: () => Rectangle_default,
  RectangleCollisionChecker: () => RectangleCollisionChecker_default,
  RectangleGeometry: () => RectangleGeometry_default,
  RectangleGeometryLibrary: () => RectangleGeometryLibrary_default,
  RectangleGeometryUpdater: () => RectangleGeometryUpdater_default,
  RectangleGraphics: () => RectangleGraphics_default,
  RectangleOutlineGeometry: () => RectangleOutlineGeometry_default,
  ReferenceFrame: () => ReferenceFrame_default,
  ReferenceProperty: () => ReferenceProperty_default,
  RenderState: () => RenderState_default,
  Renderbuffer: () => Renderbuffer_default,
  RenderbufferFormat: () => RenderbufferFormat_default,
  Request: () => Request_default,
  RequestErrorEvent: () => RequestErrorEvent_default,
  RequestScheduler: () => RequestScheduler_default,
  RequestState: () => RequestState_default,
  RequestType: () => RequestType_default,
  Resource: () => Resource_default,
  ResourceCache: () => ResourceCache_default,
  ResourceCacheKey: () => ResourceCacheKey_default,
  ResourceCacheStatistics: () => ResourceCacheStatistics_default,
  ResourceLoader: () => ResourceLoader_default,
  ResourceLoaderState: () => ResourceLoaderState_default,
  Rotation: () => Rotation_default,
  RuntimeError: () => RuntimeError_default,
  S2Cell: () => S2Cell_default,
  SDFSettings: () => SDFSettings_default,
  SampledPositionProperty: () => SampledPositionProperty_default,
  SampledProperty: () => SampledProperty_default,
  Sampler: () => Sampler_default,
  ScaledPositionProperty: () => ScaledPositionProperty_default,
  Scene: () => Scene_default,
  SceneFramebuffer: () => SceneFramebuffer_default,
  SceneMode: () => SceneMode_default,
  SceneMode2DPipelineStage: () => SceneMode2DPipelineStage_default,
  SceneModePicker: () => SceneModePicker_default,
  SceneModePickerViewModel: () => SceneModePickerViewModel_default,
  SceneTransforms: () => SceneTransforms_default,
  SceneTransitioner: () => SceneTransitioner_default,
  ScreenSpaceCameraController: () => ScreenSpaceCameraController_default,
  ScreenSpaceEventHandler: () => ScreenSpaceEventHandler_default,
  ScreenSpaceEventType: () => ScreenSpaceEventType_default,
  SelectedFeatureIdPipelineStage: () => SelectedFeatureIdPipelineStage_default,
  SelectionIndicator: () => SelectionIndicator_default,
  SelectionIndicatorViewModel: () => SelectionIndicatorViewModel_default,
  ShaderBuilder: () => ShaderBuilder_default,
  ShaderCache: () => ShaderCache_default,
  ShaderDestination: () => ShaderDestination_default,
  ShaderFunction: () => ShaderFunction_default,
  ShaderProgram: () => ShaderProgram_default,
  ShaderSource: () => ShaderSource_default,
  ShaderStruct: () => ShaderStruct_default,
  ShadowMap: () => ShadowMap_default,
  ShadowMapShader: () => ShadowMapShader_default,
  ShadowMode: () => ShadowMode_default,
  ShadowVolumeAppearance: () => ShadowVolumeAppearance_default,
  ShowGeometryInstanceAttribute: () => ShowGeometryInstanceAttribute_default,
  Simon1994PlanetaryPositions: () => Simon1994PlanetaryPositions_default,
  SimplePolylineGeometry: () => SimplePolylineGeometry_default,
  SingleTileImageryProvider: () => SingleTileImageryProvider_default,
  SkinningPipelineStage: () => SkinningPipelineStage_default,
  SkyAtmosphere: () => SkyAtmosphere_default,
  SkyBox: () => SkyBox_default,
  SphereEmitter: () => SphereEmitter_default,
  SphereGeometry: () => SphereGeometry_default,
  SphereOutlineGeometry: () => SphereOutlineGeometry_default,
  Spherical: () => Spherical_default,
  Spline: () => Spline_default,
  SplitDirection: () => SplitDirection_default,
  Splitter: () => Splitter_default,
  StaticGeometryColorBatch: () => StaticGeometryColorBatch_default,
  StaticGeometryPerMaterialBatch: () => StaticGeometryPerMaterialBatch_default,
  StaticGroundGeometryColorBatch: () => StaticGroundGeometryColorBatch_default,
  StaticGroundGeometryPerMaterialBatch: () => StaticGroundGeometryPerMaterialBatch_default,
  StaticGroundPolylinePerMaterialBatch: () => StaticGroundPolylinePerMaterialBatch_default,
  StaticOutlineGeometryBatch: () => StaticOutlineGeometryBatch_default,
  StencilConstants: () => StencilConstants_default,
  StencilFunction: () => StencilFunction_default,
  StencilOperation: () => StencilOperation_default,
  SteppedSpline: () => SteppedSpline_default,
  StripeMaterialProperty: () => StripeMaterialProperty_default,
  StripeOrientation: () => StripeOrientation_default,
  StructuralMetadata: () => StructuralMetadata_default,
  StyleCommandsNeeded: () => StyleCommandsNeeded_default,
  StyleExpression: () => StyleExpression_default,
  Sun: () => Sun_default,
  SunLight: () => SunLight_default,
  SunPostProcess: () => SunPostProcess_default,
  SupportedImageFormats: () => SupportedImageFormats_default,
  SvgPathBindingHandler: () => SvgPathBindingHandler_default,
  TaskProcessor: () => TaskProcessor_default,
  TerrainData: () => TerrainData_default,
  TerrainEncoding: () => TerrainEncoding_default,
  TerrainExaggeration: () => TerrainExaggeration_default,
  TerrainFillMesh: () => TerrainFillMesh_default,
  TerrainMesh: () => TerrainMesh_default,
  TerrainOffsetProperty: () => TerrainOffsetProperty_default,
  TerrainProvider: () => TerrainProvider_default,
  TerrainQuantization: () => TerrainQuantization_default,
  TerrainState: () => TerrainState_default,
  Texture: () => Texture_default,
  TextureAtlas: () => TextureAtlas_default,
  TextureCache: () => TextureCache_default,
  TextureMagnificationFilter: () => TextureMagnificationFilter_default,
  TextureManager: () => TextureManager_default,
  TextureMinificationFilter: () => TextureMinificationFilter_default,
  TextureUniform: () => TextureUniform_default,
  TextureWrap: () => TextureWrap_default,
  TileAvailability: () => TileAvailability_default,
  TileBoundingRegion: () => TileBoundingRegion_default,
  TileBoundingS2Cell: () => TileBoundingS2Cell_default,
  TileBoundingSphere: () => TileBoundingSphere_default,
  TileBoundingVolume: () => TileBoundingVolume_default,
  TileCoordinatesImageryProvider: () => TileCoordinatesImageryProvider_default,
  TileDiscardPolicy: () => TileDiscardPolicy_default,
  TileEdge: () => TileEdge_default,
  TileImagery: () => TileImagery_default,
  TileMapServiceImageryProvider: () => TileMapServiceImageryProvider_default,
  TileMetadata: () => TileMetadata_default,
  TileOrientedBoundingBox: () => TileOrientedBoundingBox_default,
  TileProviderError: () => TileProviderError_default,
  TileReplacementQueue: () => TileReplacementQueue_default,
  TileSelectionResult: () => TileSelectionResult_default,
  TileState: () => TileState_default,
  Tileset3DTileContent: () => Tileset3DTileContent_default,
  TilesetMetadata: () => TilesetMetadata_default,
  TilesetPipelineStage: () => TilesetPipelineStage_default,
  TilingScheme: () => TilingScheme_default,
  TimeConstants: () => TimeConstants_default,
  TimeDynamicImagery: () => TimeDynamicImagery_default,
  TimeDynamicPointCloud: () => TimeDynamicPointCloud_default,
  TimeInterval: () => TimeInterval_default,
  TimeIntervalCollection: () => TimeIntervalCollection_default,
  TimeIntervalCollectionPositionProperty: () => TimeIntervalCollectionPositionProperty_default,
  TimeIntervalCollectionProperty: () => TimeIntervalCollectionProperty_default,
  TimeStandard: () => TimeStandard_default,
  Timeline: () => Timeline_default,
  TimelineHighlightRange: () => TimelineHighlightRange_default,
  TimelineTrack: () => TimelineTrack_default,
  Tipsify: () => Tipsify_default,
  ToggleButtonViewModel: () => ToggleButtonViewModel_default,
  Tonemapper: () => Tonemapper_default,
  Transforms: () => Transforms_default,
  TranslationRotationScale: () => TranslationRotationScale_default,
  TranslucentTileClassification: () => TranslucentTileClassification_default,
  TridiagonalSystemSolver: () => TridiagonalSystemSolver_default,
  TrustedServers: () => TrustedServers_default,
  TweenCollection: () => TweenCollection_default,
  UniformState: () => UniformState_default,
  UniformType: () => UniformType_default,
  UrlTemplateImageryProvider: () => UrlTemplateImageryProvider_default,
  VERSION: () => VERSION,
  VRButton: () => VRButton_default,
  VRButtonViewModel: () => VRButtonViewModel_default,
  VRTheWorldTerrainProvider: () => VRTheWorldTerrainProvider_default,
  VaryingType: () => VaryingType_default,
  Vector3DTileBatch: () => Vector3DTileBatch_default,
  Vector3DTileClampedPolylines: () => Vector3DTileClampedPolylines_default,
  Vector3DTileContent: () => Vector3DTileContent_default,
  Vector3DTileGeometry: () => Vector3DTileGeometry_default,
  Vector3DTilePoints: () => Vector3DTilePoints_default,
  Vector3DTilePolygons: () => Vector3DTilePolygons_default,
  Vector3DTilePolylines: () => Vector3DTilePolylines_default,
  Vector3DTilePrimitive: () => Vector3DTilePrimitive_default,
  VelocityOrientationProperty: () => VelocityOrientationProperty_default,
  VelocityVectorProperty: () => VelocityVectorProperty_default,
  VertexArray: () => VertexArray_default,
  VertexArrayFacade: () => VertexArrayFacade_default,
  VertexAttributeSemantic: () => VertexAttributeSemantic_default,
  VertexFormat: () => VertexFormat_default,
  VerticalOrigin: () => VerticalOrigin_default,
  VideoSynchronizer: () => VideoSynchronizer_default,
  View: () => View_default,
  Viewer: () => Viewer_default,
  ViewportQuad: () => ViewportQuad_default,
  Visibility: () => Visibility_default,
  Visualizer: () => Visualizer_default,
  VulkanConstants: () => VulkanConstants_default,
  WallGeometry: () => WallGeometry_default,
  WallGeometryLibrary: () => WallGeometryLibrary_default,
  WallGeometryUpdater: () => WallGeometryUpdater_default,
  WallGraphics: () => WallGraphics_default,
  WallOutlineGeometry: () => WallOutlineGeometry_default,
  WebGLConstants: () => WebGLConstants_default,
  WebMapServiceImageryProvider: () => WebMapServiceImageryProvider_default,
  WebMapTileServiceImageryProvider: () => WebMapTileServiceImageryProvider_default,
  WebMercatorProjection: () => WebMercatorProjection_default,
  WebMercatorTilingScheme: () => WebMercatorTilingScheme_default,
  WindingOrder: () => WindingOrder_default,
  WireframeIndexGenerator: () => WireframeIndexGenerator_default,
  WireframePipelineStage: () => WireframePipelineStage_default,
  _shadersAcesTonemappingStage: () => AcesTonemappingStage_default,
  _shadersAdditiveBlend: () => AdditiveBlend_default,
  _shadersAdjustTranslucentFS: () => AdjustTranslucentFS_default,
  _shadersAllMaterialAppearanceFS: () => AllMaterialAppearanceFS_default,
  _shadersAllMaterialAppearanceVS: () => AllMaterialAppearanceVS_default,
  _shadersAmbientOcclusionGenerate: () => AmbientOcclusionGenerate_default,
  _shadersAmbientOcclusionModulate: () => AmbientOcclusionModulate_default,
  _shadersAspectRampMaterial: () => AspectRampMaterial_default,
  _shadersAtmosphereCommon: () => AtmosphereCommon_default,
  _shadersBasicMaterialAppearanceFS: () => BasicMaterialAppearanceFS_default,
  _shadersBasicMaterialAppearanceVS: () => BasicMaterialAppearanceVS_default,
  _shadersBillboardCollectionFS: () => BillboardCollectionFS_default,
  _shadersBillboardCollectionVS: () => BillboardCollectionVS_default,
  _shadersBlackAndWhite: () => BlackAndWhite_default,
  _shadersBloomComposite: () => BloomComposite_default,
  _shadersBrdfLutGeneratorFS: () => BrdfLutGeneratorFS_default,
  _shadersBrightPass: () => BrightPass_default,
  _shadersBrightness: () => Brightness_default,
  _shadersBumpMapMaterial: () => BumpMapMaterial_default,
  _shadersCPUStylingStageFS: () => CPUStylingStageFS_default,
  _shadersCPUStylingStageVS: () => CPUStylingStageVS_default,
  _shadersCheckerboardMaterial: () => CheckerboardMaterial_default,
  _shadersCloudCollectionFS: () => CloudCollectionFS_default,
  _shadersCloudCollectionVS: () => CloudCollectionVS_default,
  _shadersCloudNoiseFS: () => CloudNoiseFS_default,
  _shadersCloudNoiseVS: () => CloudNoiseVS_default,
  _shadersCompareAndPackTranslucentDepth: () => CompareAndPackTranslucentDepth_default,
  _shadersCompositeOITFS: () => CompositeOITFS_default,
  _shadersCompositeTranslucentClassification: () => CompositeTranslucentClassification_default,
  _shadersContrastBias: () => ContrastBias_default,
  _shadersCustomShaderStageFS: () => CustomShaderStageFS_default,
  _shadersCustomShaderStageVS: () => CustomShaderStageVS_default,
  _shadersCzmBuiltins: () => CzmBuiltins_default,
  _shadersDepthOfField: () => DepthOfField_default,
  _shadersDepthPlaneFS: () => DepthPlaneFS_default,
  _shadersDepthPlaneVS: () => DepthPlaneVS_default,
  _shadersDepthView: () => DepthView_default,
  _shadersDepthViewPacked: () => DepthViewPacked_default,
  _shadersDotMaterial: () => DotMaterial_default,
  _shadersEdgeDetection: () => EdgeDetection_default,
  _shadersElevationBandMaterial: () => ElevationBandMaterial_default,
  _shadersElevationContourMaterial: () => ElevationContourMaterial_default,
  _shadersElevationRampMaterial: () => ElevationRampMaterial_default,
  _shadersEllipsoidFS: () => EllipsoidFS_default,
  _shadersEllipsoidSurfaceAppearanceFS: () => EllipsoidSurfaceAppearanceFS_default,
  _shadersEllipsoidSurfaceAppearanceVS: () => EllipsoidSurfaceAppearanceVS_default,
  _shadersEllipsoidVS: () => EllipsoidVS_default,
  _shadersFXAA: () => FXAA_default,
  _shadersFXAA3_11: () => FXAA3_11_default,
  _shadersFadeMaterial: () => FadeMaterial_default,
  _shadersFeatureIdStageFS: () => FeatureIdStageFS_default,
  _shadersFeatureIdStageVS: () => FeatureIdStageVS_default,
  _shadersFilmicTonemapping: () => FilmicTonemapping_default,
  _shadersGaussianBlur1D: () => GaussianBlur1D_default,
  _shadersGeometryStageFS: () => GeometryStageFS_default,
  _shadersGeometryStageVS: () => GeometryStageVS_default,
  _shadersGlobeFS: () => GlobeFS_default,
  _shadersGlobeVS: () => GlobeVS_default,
  _shadersGridMaterial: () => GridMaterial_default,
  _shadersGroundAtmosphere: () => GroundAtmosphere_default,
  _shadersHSBToRGB: () => HSBToRGB_default,
  _shadersHSLToRGB: () => HSLToRGB_default,
  _shadersImageBasedLightingStageFS: () => ImageBasedLightingStageFS_default,
  _shadersInstancingStageCommon: () => InstancingStageCommon_default,
  _shadersInstancingStageVS: () => InstancingStageVS_default,
  _shadersLegacyInstancingStageVS: () => LegacyInstancingStageVS_default,
  _shadersLensFlare: () => LensFlare_default,
  _shadersLightingStageFS: () => LightingStageFS_default,
  _shadersMaterialStageFS: () => MaterialStageFS_default,
  _shadersMetadataStageFS: () => MetadataStageFS_default,
  _shadersMetadataStageVS: () => MetadataStageVS_default,
  _shadersModelClippingPlanesStageFS: () => ModelClippingPlanesStageFS_default,
  _shadersModelColorStageFS: () => ModelColorStageFS_default,
  _shadersModelFS: () => ModelFS_default,
  _shadersModelSilhouetteStageFS: () => ModelSilhouetteStageFS_default,
  _shadersModelSilhouetteStageVS: () => ModelSilhouetteStageVS_default,
  _shadersModelSplitterStageFS: () => ModelSplitterStageFS_default,
  _shadersModelVS: () => ModelVS_default,
  _shadersModifiedReinhardTonemapping: () => ModifiedReinhardTonemapping_default,
  _shadersMorphTargetsStageVS: () => MorphTargetsStageVS_default,
  _shadersNightVision: () => NightVision_default,
  _shadersNormalMapMaterial: () => NormalMapMaterial_default,
  _shadersOctahedralProjectionAtlasFS: () => OctahedralProjectionAtlasFS_default,
  _shadersOctahedralProjectionFS: () => OctahedralProjectionFS_default,
  _shadersOctahedralProjectionVS: () => OctahedralProjectionVS_default,
  _shadersPassThrough: () => PassThrough_default,
  _shadersPassThroughDepth: () => PassThroughDepth_default,
  _shadersPerInstanceColorAppearanceFS: () => PerInstanceColorAppearanceFS_default,
  _shadersPerInstanceColorAppearanceVS: () => PerInstanceColorAppearanceVS_default,
  _shadersPerInstanceFlatColorAppearanceFS: () => PerInstanceFlatColorAppearanceFS_default,
  _shadersPerInstanceFlatColorAppearanceVS: () => PerInstanceFlatColorAppearanceVS_default,
  _shadersPointCloudEyeDomeLighting: () => PointCloudEyeDomeLighting_default,
  _shadersPointCloudStylingStageVS: () => PointCloudStylingStageVS_default,
  _shadersPointPrimitiveCollectionFS: () => PointPrimitiveCollectionFS_default,
  _shadersPointPrimitiveCollectionVS: () => PointPrimitiveCollectionVS_default,
  _shadersPolylineArrowMaterial: () => PolylineArrowMaterial_default,
  _shadersPolylineColorAppearanceVS: () => PolylineColorAppearanceVS_default,
  _shadersPolylineCommon: () => PolylineCommon_default,
  _shadersPolylineDashMaterial: () => PolylineDashMaterial_default,
  _shadersPolylineFS: () => PolylineFS_default,
  _shadersPolylineGlowMaterial: () => PolylineGlowMaterial_default,
  _shadersPolylineMaterialAppearanceVS: () => PolylineMaterialAppearanceVS_default,
  _shadersPolylineOutlineMaterial: () => PolylineOutlineMaterial_default,
  _shadersPolylineShadowVolumeFS: () => PolylineShadowVolumeFS_default,
  _shadersPolylineShadowVolumeMorphFS: () => PolylineShadowVolumeMorphFS_default,
  _shadersPolylineShadowVolumeMorphVS: () => PolylineShadowVolumeMorphVS_default,
  _shadersPolylineShadowVolumeVS: () => PolylineShadowVolumeVS_default,
  _shadersPolylineVS: () => PolylineVS_default,
  _shadersPrimitiveOutlineStageFS: () => PrimitiveOutlineStageFS_default,
  _shadersPrimitiveOutlineStageVS: () => PrimitiveOutlineStageVS_default,
  _shadersRGBToHSB: () => RGBToHSB_default,
  _shadersRGBToHSL: () => RGBToHSL_default,
  _shadersRGBToXYZ: () => RGBToXYZ_default,
  _shadersReinhardTonemapping: () => ReinhardTonemapping_default,
  _shadersReprojectWebMercatorFS: () => ReprojectWebMercatorFS_default,
  _shadersReprojectWebMercatorVS: () => ReprojectWebMercatorVS_default,
  _shadersRimLightingMaterial: () => RimLightingMaterial_default,
  _shadersSelectedFeatureIdStageCommon: () => SelectedFeatureIdStageCommon_default,
  _shadersShadowVolumeAppearanceFS: () => ShadowVolumeAppearanceFS_default,
  _shadersShadowVolumeAppearanceVS: () => ShadowVolumeAppearanceVS_default,
  _shadersShadowVolumeFS: () => ShadowVolumeFS_default,
  _shadersSilhouette: () => Silhouette_default,
  _shadersSkinningStageVS: () => SkinningStageVS_default,
  _shadersSkyAtmosphereCommon: () => SkyAtmosphereCommon_default,
  _shadersSkyAtmosphereFS: () => SkyAtmosphereFS_default,
  _shadersSkyAtmosphereVS: () => SkyAtmosphereVS_default,
  _shadersSkyBoxFS: () => SkyBoxFS_default,
  _shadersSkyBoxVS: () => SkyBoxVS_default,
  _shadersSlopeRampMaterial: () => SlopeRampMaterial_default,
  _shadersStripeMaterial: () => StripeMaterial_default,
  _shadersSunFS: () => SunFS_default,
  _shadersSunTextureFS: () => SunTextureFS_default,
  _shadersSunVS: () => SunVS_default,
  _shadersTexturedMaterialAppearanceFS: () => TexturedMaterialAppearanceFS_default,
  _shadersTexturedMaterialAppearanceVS: () => TexturedMaterialAppearanceVS_default,
  _shadersVector3DTileClampedPolylinesFS: () => Vector3DTileClampedPolylinesFS_default,
  _shadersVector3DTileClampedPolylinesVS: () => Vector3DTileClampedPolylinesVS_default,
  _shadersVector3DTilePolylinesVS: () => Vector3DTilePolylinesVS_default,
  _shadersVectorTileVS: () => VectorTileVS_default,
  _shadersViewportQuadFS: () => ViewportQuadFS_default,
  _shadersViewportQuadVS: () => ViewportQuadVS_default,
  _shadersWater: () => Water_default,
  _shadersXYZToRGB: () => XYZToRGB_default,
  _shadersacesTonemapping: () => acesTonemapping_default,
  _shadersalphaWeight: () => alphaWeight_default,
  _shadersantialias: () => antialias_default,
  _shadersapproximateSphericalCoordinates: () => approximateSphericalCoordinates_default,
  _shadersbackFacing: () => backFacing_default,
  _shadersbranchFreeTernary: () => branchFreeTernary_default,
  _shaderscascadeColor: () => cascadeColor_default,
  _shaderscascadeDistance: () => cascadeDistance_default,
  _shaderscascadeMatrix: () => cascadeMatrix_default,
  _shaderscascadeWeights: () => cascadeWeights_default,
  _shaderscolumbusViewMorph: () => columbusViewMorph_default,
  _shaderscomputePosition: () => computePosition_default,
  _shaderscosineAndSine: () => cosineAndSine_default,
  _shadersdecompressTextureCoordinates: () => decompressTextureCoordinates_default,
  _shadersdefaultPbrMaterial: () => defaultPbrMaterial_default,
  _shadersdegreesPerRadian: () => degreesPerRadian_default,
  _shadersdepthClamp: () => depthClamp_default,
  _shadersdepthRange: () => depthRange_default,
  _shadersdepthRangeStruct: () => depthRangeStruct_default,
  _shaderseastNorthUpToEyeCoordinates: () => eastNorthUpToEyeCoordinates_default,
  _shadersellipsoidContainsPoint: () => ellipsoidContainsPoint_default,
  _shadersellipsoidWgs84TextureCoordinates: () => ellipsoidWgs84TextureCoordinates_default,
  _shadersepsilon1: () => epsilon1_default,
  _shadersepsilon2: () => epsilon2_default,
  _shadersepsilon3: () => epsilon3_default,
  _shadersepsilon4: () => epsilon4_default,
  _shadersepsilon5: () => epsilon5_default,
  _shadersepsilon6: () => epsilon6_default,
  _shadersepsilon7: () => epsilon7_default,
  _shadersequalsEpsilon: () => equalsEpsilon_default,
  _shaderseyeOffset: () => eyeOffset_default,
  _shaderseyeToWindowCoordinates: () => eyeToWindowCoordinates_default,
  _shadersfastApproximateAtan: () => fastApproximateAtan_default,
  _shadersfog: () => fog_default,
  _shadersgammaCorrect: () => gammaCorrect_default,
  _shadersgeodeticSurfaceNormal: () => geodeticSurfaceNormal_default,
  _shadersgetDefaultMaterial: () => getDefaultMaterial_default,
  _shadersgetLambertDiffuse: () => getLambertDiffuse_default,
  _shadersgetSpecular: () => getSpecular_default,
  _shadersgetWaterNoise: () => getWaterNoise_default,
  _shadershue: () => hue_default,
  _shadersinfinity: () => infinity_default,
  _shadersinverseGamma: () => inverseGamma_default,
  _shadersisEmpty: () => isEmpty_default,
  _shadersisFull: () => isFull_default,
  _shaderslatitudeToWebMercatorFraction: () => latitudeToWebMercatorFraction_default,
  _shaderslineDistance: () => lineDistance_default,
  _shaderslinearToSrgb: () => linearToSrgb_default,
  _shadersluminance: () => luminance_default,
  _shadersmaterial: () => material_default,
  _shadersmaterialInput: () => materialInput_default,
  _shadersmetersPerPixel: () => metersPerPixel_default,
  _shadersmodelMaterial: () => modelMaterial_default,
  _shadersmodelToWindowCoordinates: () => modelToWindowCoordinates_default,
  _shadersmodelVertexOutput: () => modelVertexOutput_default,
  _shadersmultiplyWithColorBalance: () => multiplyWithColorBalance_default,
  _shadersnearFarScalar: () => nearFarScalar_default,
  _shadersoctDecode: () => octDecode_default,
  _shadersoneOverPi: () => oneOverPi_default,
  _shadersoneOverTwoPi: () => oneOverTwoPi_default,
  _shaderspackDepth: () => packDepth_default,
  _shaderspassCesium3DTile: () => passCesium3DTile_default,
  _shaderspassCesium3DTileClassification: () => passCesium3DTileClassification_default,
  _shaderspassCesium3DTileClassificationIgnoreShow: () => passCesium3DTileClassificationIgnoreShow_default,
  _shaderspassClassification: () => passClassification_default,
  _shaderspassCompute: () => passCompute_default,
  _shaderspassEnvironment: () => passEnvironment_default,
  _shaderspassGlobe: () => passGlobe_default,
  _shaderspassOpaque: () => passOpaque_default,
  _shaderspassOverlay: () => passOverlay_default,
  _shaderspassTerrainClassification: () => passTerrainClassification_default,
  _shaderspassTranslucent: () => passTranslucent_default,
  _shaderspbrLighting: () => pbrLighting_default,
  _shaderspbrMetallicRoughnessMaterial: () => pbrMetallicRoughnessMaterial_default,
  _shaderspbrParameters: () => pbrParameters_default,
  _shaderspbrSpecularGlossinessMaterial: () => pbrSpecularGlossinessMaterial_default,
  _shadersphong: () => phong_default,
  _shaderspi: () => pi_default,
  _shaderspiOverFour: () => piOverFour_default,
  _shaderspiOverSix: () => piOverSix_default,
  _shaderspiOverThree: () => piOverThree_default,
  _shaderspiOverTwo: () => piOverTwo_default,
  _shadersplaneDistance: () => planeDistance_default,
  _shaderspointAlongRay: () => pointAlongRay_default,
  _shadersradiansPerDegree: () => radiansPerDegree_default,
  _shadersray: () => ray_default,
  _shadersrayEllipsoidIntersectionInterval: () => rayEllipsoidIntersectionInterval_default,
  _shadersraySegment: () => raySegment_default,
  _shadersraySphereIntersectionInterval: () => raySphereIntersectionInterval_default,
  _shadersreadDepth: () => readDepth_default,
  _shadersreadNonPerspective: () => readNonPerspective_default,
  _shadersreverseLogDepth: () => reverseLogDepth_default,
  _shadersround: () => round_default,
  _shaderssampleOctahedralProjection: () => sampleOctahedralProjection_default,
  _shaderssaturation: () => saturation_default,
  _shaderssceneMode2D: () => sceneMode2D_default,
  _shaderssceneMode3D: () => sceneMode3D_default,
  _shaderssceneModeColumbusView: () => sceneModeColumbusView_default,
  _shaderssceneModeMorphing: () => sceneModeMorphing_default,
  _shadersshadowDepthCompare: () => shadowDepthCompare_default,
  _shadersshadowParameters: () => shadowParameters_default,
  _shadersshadowVisibility: () => shadowVisibility_default,
  _shaderssignNotZero: () => signNotZero_default,
  _shaderssolarRadius: () => solarRadius_default,
  _shaderssphericalHarmonics: () => sphericalHarmonics_default,
  _shaderssrgbToLinear: () => srgbToLinear_default,
  _shaderstangentToEyeSpaceMatrix: () => tangentToEyeSpaceMatrix_default,
  _shadersthreePiOver2: () => threePiOver2_default,
  _shaderstransformPlane: () => transformPlane_default,
  _shaderstranslateRelativeToEye: () => translateRelativeToEye_default,
  _shaderstranslucentPhong: () => translucentPhong_default,
  _shaderstranspose: () => transpose_default,
  _shaderstwoPi: () => twoPi_default,
  _shadersunpackDepth: () => unpackDepth_default,
  _shadersunpackFloat: () => unpackFloat_default,
  _shadersunpackUint: () => unpackUint_default,
  _shadersvalueTransform: () => valueTransform_default,
  _shadersvertexLogDepth: () => vertexLogDepth_default,
  _shaderswebMercatorMaxLatitude: () => webMercatorMaxLatitude_default,
  _shaderswindowToEyeCoordinates: () => windowToEyeCoordinates_default,
  _shaderswriteDepthClamp: () => writeDepthClamp_default,
  _shaderswriteLogDepth: () => writeLogDepth_default,
  _shaderswriteNonPerspective: () => writeNonPerspective_default,
  addBuffer: () => addBuffer_default,
  addDefaults: () => addDefaults_default,
  addExtensionsRequired: () => addExtensionsRequired_default,
  addExtensionsUsed: () => addExtensionsUsed_default,
  addPipelineExtras: () => addPipelineExtras_default,
  addToArray: () => addToArray_default,
  appendForwardSlash: () => appendForwardSlash_default,
  arrayRemoveDuplicates: () => arrayRemoveDuplicates_default,
  barycentricCoordinates: () => barycentricCoordinates_default,
  binarySearch: () => binarySearch_default,
  buildDrawCommand: () => buildDrawCommand_default,
  buildModuleUrl: () => buildModuleUrl_default,
  clone: () => clone_default,
  combine: () => combine_default,
  computeFlyToLocationForRectangle: () => computeFlyToLocationForRectangle_default,
  createBillboardPointCallback: () => createBillboardPointCallback_default,
  createCommand: () => createCommand_default,
  createDefaultImageryProviderViewModels: () => createDefaultImageryProviderViewModels_default,
  createDefaultTerrainProviderViewModels: () => createDefaultTerrainProviderViewModels_default,
  createElevationBandMaterial: () => createElevationBandMaterial_default,
  createGuid: () => createGuid_default,
  createMaterialPropertyDescriptor: () => createMaterialPropertyDescriptor_default,
  createOsmBuildings: () => createOsmBuildings_default,
  createPropertyDescriptor: () => createPropertyDescriptor_default,
  createRawPropertyDescriptor: () => createRawPropertyDescriptor_default,
  createTangentSpaceDebugPrimitive: () => createTangentSpaceDebugPrimitive_default,
  createTaskProcessorWorker: () => createTaskProcessorWorker_default,
  createUniform: () => createUniform_default,
  createUniformArray: () => createUniformArray_default,
  createWorldImagery: () => createWorldImagery_default,
  createWorldTerrain: () => createWorldTerrain_default,
  decodeGoogleEarthEnterpriseData: () => decodeGoogleEarthEnterpriseData_default,
  decodeVectorPolylinePositions: () => decodeVectorPolylinePositions_default,
  defaultValue: () => defaultValue_default,
  defer: () => defer_default,
  defined: () => defined_default,
  deprecationWarning: () => deprecationWarning_default,
  destroyObject: () => destroyObject_default,
  exportKml: () => exportKml_default,
  findAccessorMinMax: () => findAccessorMinMax_default,
  findContentMetadata: () => findContentMetadata_default,
  findGroupMetadata: () => findGroupMetadata_default,
  findTileMetadata: () => findTileMetadata_default,
  forEachTextureInMaterial: () => forEachTextureInMaterial_default,
  formatError: () => formatError_default,
  freezeRenderState: () => freezeRenderState_default,
  getAbsoluteUri: () => getAbsoluteUri_default,
  getAccessorByteStride: () => getAccessorByteStride_default,
  getBaseUri: () => getBaseUri_default,
  getBinaryAccessor: () => getBinaryAccessor_default,
  getClipAndStyleCode: () => getClipAndStyleCode_default,
  getClippingFunction: () => getClippingFunction_default,
  getComponentReader: () => getComponentReader_default,
  getElement: () => getElement_default,
  getExtensionFromUri: () => getExtensionFromUri_default,
  getFilenameFromUri: () => getFilenameFromUri_default,
  getImageFromTypedArray: () => getImageFromTypedArray_default,
  getImagePixels: () => getImagePixels_default,
  getJsonFromTypedArray: () => getJsonFromTypedArray_default,
  getMagic: () => getMagic_default,
  getStringFromTypedArray: () => getStringFromTypedArray_default,
  getTimestamp: () => getTimestamp_default,
  hasExtension: () => hasExtension_default,
  heightReferenceOnEntityPropertyChanged: () => heightReferenceOnEntityPropertyChanged_default,
  isBitSet: () => isBitSet_default,
  isBlobUri: () => isBlobUri_default,
  isCrossOriginUrl: () => isCrossOriginUrl_default,
  isDataUri: () => isDataUri_default,
  isLeapYear: () => isLeapYear_default,
  knockout: () => knockout_default,
  knockout_3_5_1: () => knockout_3_5_1_default,
  knockout_es5: () => knockout_es5_default,
  loadAndExecuteScript: () => loadAndExecuteScript_default,
  loadCubeMap: () => loadCubeMap_default,
  loadImageFromTypedArray: () => loadImageFromTypedArray_default,
  loadKTX2: () => loadKTX2_default,
  mergeSort: () => mergeSort_default,
  modernizeShader: () => modernizeShader_default,
  moveTechniqueRenderStates: () => moveTechniqueRenderStates_default,
  moveTechniquesToExtension: () => moveTechniquesToExtension_default,
  numberOfComponentsForType: () => numberOfComponentsForType_default,
  objectToQuery: () => objectToQuery_default,
  oneTimeWarning: () => oneTimeWarning_default,
  parseBatchTable: () => parseBatchTable_default,
  parseBoundingVolumeSemantics: () => parseBoundingVolumeSemantics_default,
  parseFeatureMetadataLegacy: () => parseFeatureMetadataLegacy_default,
  parseGlb: () => parseGlb_default,
  parseResponseHeaders: () => parseResponseHeaders_default,
  parseStructuralMetadata: () => parseStructuralMetadata_default,
  pointInsideTriangle: () => pointInsideTriangle_default,
  preprocess3DTileContent: () => preprocess3DTileContent_default,
  queryToObject: () => queryToObject_default,
  readAccessorPacked: () => readAccessorPacked_default,
  removeExtension: () => removeExtension_default,
  removeExtensionsRequired: () => removeExtensionsRequired_default,
  removeExtensionsUsed: () => removeExtensionsUsed_default,
  removePipelineExtras: () => removePipelineExtras_default,
  removeUnusedElements: () => removeUnusedElements_default,
  resizeImageToNextPowerOfTwo: () => resizeImageToNextPowerOfTwo_default,
  sampleTerrain: () => sampleTerrain_default,
  sampleTerrainMostDetailed: () => sampleTerrainMostDetailed_default,
  scaleToGeodeticSurface: () => scaleToGeodeticSurface_default,
  subdivideArray: () => subdivideArray_default,
  subscribeAndEvaluate: () => subscribeAndEvaluate_default,
  updateAccessorComponentTypes: () => updateAccessorComponentTypes_default,
  updateVersion: () => updateVersion_default,
  usesExtension: () => usesExtension_default,
  viewerCesium3DTilesInspectorMixin: () => viewerCesium3DTilesInspectorMixin_default,
  viewerCesiumInspectorMixin: () => viewerCesiumInspectorMixin_default,
  viewerDragDropMixin: () => viewerDragDropMixin_default,
  viewerPerformanceWatchdogMixin: () => viewerPerformanceWatchdogMixin_default,
  webGLConstantToGlslType: () => webGLConstantToGlslType_default,
  wrapFunction: () => wrapFunction_default,
  writeTextToCanvas: () => writeTextToCanvas_default
});
module.exports = __toCommonJS(Cesium_exports);

// Source/Core/defined.js
function defined(value) {
  return value !== void 0 && value !== null;
}
var defined_default = defined;

// Source/Core/DeveloperError.js
function DeveloperError(message) {
  this.name = "DeveloperError";
  this.message = message;
  let stack;
  try {
    throw new Error();
  } catch (e) {
    stack = e.stack;
  }
  this.stack = stack;
}
if (defined_default(Object.create)) {
  DeveloperError.prototype = Object.create(Error.prototype);
  DeveloperError.prototype.constructor = DeveloperError;
}
DeveloperError.prototype.toString = function() {
  let str = `${this.name}: ${this.message}`;
  if (defined_default(this.stack)) {
    str += `
${this.stack.toString()}`;
  }
  return str;
};
DeveloperError.throwInstantiationError = function() {
  throw new DeveloperError(
    "This function defines an interface and should not be called directly."
  );
};
var DeveloperError_default = DeveloperError;

// Source/Core/Check.js
var Check = {};
Check.typeOf = {};
function getUndefinedErrorMessage(name) {
  return `${name} is required, actual value was undefined`;
}
function getFailedTypeErrorMessage(actual, expected, name) {
  return `Expected ${name} to be typeof ${expected}, actual typeof was ${actual}`;
}
Check.defined = function(name, test) {
  if (!defined_default(test)) {
    throw new DeveloperError_default(getUndefinedErrorMessage(name));
  }
};
Check.typeOf.func = function(name, test) {
  if (typeof test !== "function") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "function", name)
    );
  }
};
Check.typeOf.string = function(name, test) {
  if (typeof test !== "string") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "string", name)
    );
  }
};
Check.typeOf.number = function(name, test) {
  if (typeof test !== "number") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "number", name)
    );
  }
};
Check.typeOf.number.lessThan = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test >= limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be less than ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.lessThanOrEquals = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test > limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be less than or equal to ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.greaterThan = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test <= limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be greater than ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.number.greaterThanOrEquals = function(name, test, limit) {
  Check.typeOf.number(name, test);
  if (test < limit) {
    throw new DeveloperError_default(
      `Expected ${name} to be greater than or equal to ${limit}, actual value was ${test}`
    );
  }
};
Check.typeOf.object = function(name, test) {
  if (typeof test !== "object") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "object", name)
    );
  }
};
Check.typeOf.bool = function(name, test) {
  if (typeof test !== "boolean") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "boolean", name)
    );
  }
};
Check.typeOf.bigint = function(name, test) {
  if (typeof test !== "bigint") {
    throw new DeveloperError_default(
      getFailedTypeErrorMessage(typeof test, "bigint", name)
    );
  }
};
Check.typeOf.number.equals = function(name1, name2, test1, test2) {
  Check.typeOf.number(name1, test1);
  Check.typeOf.number(name2, test2);
  if (test1 !== test2) {
    throw new DeveloperError_default(
      `${name1} must be equal to ${name2}, the actual values are ${test1} and ${test2}`
    );
  }
};
var Check_default = Check;

// Source/Core/defaultValue.js
function defaultValue(a3, b) {
  if (a3 !== void 0 && a3 !== null) {
    return a3;
  }
  return b;
}
defaultValue.EMPTY_OBJECT = Object.freeze({});
var defaultValue_default = defaultValue;

// Source/Core/Math.js
var import_mersenne_twister = __toESM(require_mersenne_twister(), 1);
var CesiumMath = {};
CesiumMath.EPSILON1 = 0.1;
CesiumMath.EPSILON2 = 0.01;
CesiumMath.EPSILON3 = 1e-3;
CesiumMath.EPSILON4 = 1e-4;
CesiumMath.EPSILON5 = 1e-5;
CesiumMath.EPSILON6 = 1e-6;
CesiumMath.EPSILON7 = 1e-7;
CesiumMath.EPSILON8 = 1e-8;
CesiumMath.EPSILON9 = 1e-9;
CesiumMath.EPSILON10 = 1e-10;
CesiumMath.EPSILON11 = 1e-11;
CesiumMath.EPSILON12 = 1e-12;
CesiumMath.EPSILON13 = 1e-13;
CesiumMath.EPSILON14 = 1e-14;
CesiumMath.EPSILON15 = 1e-15;
CesiumMath.EPSILON16 = 1e-16;
CesiumMath.EPSILON17 = 1e-17;
CesiumMath.EPSILON18 = 1e-18;
CesiumMath.EPSILON19 = 1e-19;
CesiumMath.EPSILON20 = 1e-20;
CesiumMath.EPSILON21 = 1e-21;
CesiumMath.GRAVITATIONALPARAMETER = 3986004418e5;
CesiumMath.SOLAR_RADIUS = 6955e5;
CesiumMath.LUNAR_RADIUS = 1737400;
CesiumMath.SIXTY_FOUR_KILOBYTES = 64 * 1024;
CesiumMath.FOUR_GIGABYTES = 4 * 1024 * 1024 * 1024;
CesiumMath.sign = defaultValue_default(Math.sign, function sign(value) {
  value = +value;
  if (value === 0 || value !== value) {
    return value;
  }
  return value > 0 ? 1 : -1;
});
CesiumMath.signNotZero = function(value) {
  return value < 0 ? -1 : 1;
};
CesiumMath.toSNorm = function(value, rangeMaximum) {
  rangeMaximum = defaultValue_default(rangeMaximum, 255);
  return Math.round(
    (CesiumMath.clamp(value, -1, 1) * 0.5 + 0.5) * rangeMaximum
  );
};
CesiumMath.fromSNorm = function(value, rangeMaximum) {
  rangeMaximum = defaultValue_default(rangeMaximum, 255);
  return CesiumMath.clamp(value, 0, rangeMaximum) / rangeMaximum * 2 - 1;
};
CesiumMath.normalize = function(value, rangeMinimum, rangeMaximum) {
  rangeMaximum = Math.max(rangeMaximum - rangeMinimum, 0);
  return rangeMaximum === 0 ? 0 : CesiumMath.clamp((value - rangeMinimum) / rangeMaximum, 0, 1);
};
CesiumMath.sinh = defaultValue_default(Math.sinh, function sinh(value) {
  return (Math.exp(value) - Math.exp(-value)) / 2;
});
CesiumMath.cosh = defaultValue_default(Math.cosh, function cosh(value) {
  return (Math.exp(value) + Math.exp(-value)) / 2;
});
CesiumMath.lerp = function(p, q, time) {
  return (1 - time) * p + time * q;
};
CesiumMath.PI = Math.PI;
CesiumMath.ONE_OVER_PI = 1 / Math.PI;
CesiumMath.PI_OVER_TWO = Math.PI / 2;
CesiumMath.PI_OVER_THREE = Math.PI / 3;
CesiumMath.PI_OVER_FOUR = Math.PI / 4;
CesiumMath.PI_OVER_SIX = Math.PI / 6;
CesiumMath.THREE_PI_OVER_TWO = 3 * Math.PI / 2;
CesiumMath.TWO_PI = 2 * Math.PI;
CesiumMath.ONE_OVER_TWO_PI = 1 / (2 * Math.PI);
CesiumMath.RADIANS_PER_DEGREE = Math.PI / 180;
CesiumMath.DEGREES_PER_RADIAN = 180 / Math.PI;
CesiumMath.RADIANS_PER_ARCSECOND = CesiumMath.RADIANS_PER_DEGREE / 3600;
CesiumMath.toRadians = function(degrees) {
  if (!defined_default(degrees)) {
    throw new DeveloperError_default("degrees is required.");
  }
  return degrees * CesiumMath.RADIANS_PER_DEGREE;
};
CesiumMath.toDegrees = function(radians) {
  if (!defined_default(radians)) {
    throw new DeveloperError_default("radians is required.");
  }
  return radians * CesiumMath.DEGREES_PER_RADIAN;
};
CesiumMath.convertLongitudeRange = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  const twoPi = CesiumMath.TWO_PI;
  const simplified = angle - Math.floor(angle / twoPi) * twoPi;
  if (simplified < -Math.PI) {
    return simplified + twoPi;
  }
  if (simplified >= Math.PI) {
    return simplified - twoPi;
  }
  return simplified;
};
CesiumMath.clampToLatitudeRange = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  return CesiumMath.clamp(
    angle,
    -1 * CesiumMath.PI_OVER_TWO,
    CesiumMath.PI_OVER_TWO
  );
};
CesiumMath.negativePiToPi = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (angle >= -CesiumMath.PI && angle <= CesiumMath.PI) {
    return angle;
  }
  return CesiumMath.zeroToTwoPi(angle + CesiumMath.PI) - CesiumMath.PI;
};
CesiumMath.zeroToTwoPi = function(angle) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (angle >= 0 && angle <= CesiumMath.TWO_PI) {
    return angle;
  }
  const mod2 = CesiumMath.mod(angle, CesiumMath.TWO_PI);
  if (Math.abs(mod2) < CesiumMath.EPSILON14 && Math.abs(angle) > CesiumMath.EPSILON14) {
    return CesiumMath.TWO_PI;
  }
  return mod2;
};
CesiumMath.mod = function(m, n) {
  if (!defined_default(m)) {
    throw new DeveloperError_default("m is required.");
  }
  if (!defined_default(n)) {
    throw new DeveloperError_default("n is required.");
  }
  if (n === 0) {
    throw new DeveloperError_default("divisor cannot be 0.");
  }
  if (CesiumMath.sign(m) === CesiumMath.sign(n) && Math.abs(m) < Math.abs(n)) {
    return m;
  }
  return (m % n + n) % n;
};
CesiumMath.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("left is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("right is required.");
  }
  relativeEpsilon = defaultValue_default(relativeEpsilon, 0);
  absoluteEpsilon = defaultValue_default(absoluteEpsilon, relativeEpsilon);
  const absDiff = Math.abs(left - right);
  return absDiff <= absoluteEpsilon || absDiff <= relativeEpsilon * Math.max(Math.abs(left), Math.abs(right));
};
CesiumMath.lessThan = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right < -absoluteEpsilon;
};
CesiumMath.lessThanOrEquals = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right < absoluteEpsilon;
};
CesiumMath.greaterThan = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right > absoluteEpsilon;
};
CesiumMath.greaterThanOrEquals = function(left, right, absoluteEpsilon) {
  if (!defined_default(left)) {
    throw new DeveloperError_default("first is required.");
  }
  if (!defined_default(right)) {
    throw new DeveloperError_default("second is required.");
  }
  if (!defined_default(absoluteEpsilon)) {
    throw new DeveloperError_default("absoluteEpsilon is required.");
  }
  return left - right > -absoluteEpsilon;
};
var factorials = [1];
CesiumMath.factorial = function(n) {
  if (typeof n !== "number" || n < 0) {
    throw new DeveloperError_default(
      "A number greater than or equal to 0 is required."
    );
  }
  const length3 = factorials.length;
  if (n >= length3) {
    let sum = factorials[length3 - 1];
    for (let i = length3; i <= n; i++) {
      const next = sum * i;
      factorials.push(next);
      sum = next;
    }
  }
  return factorials[n];
};
CesiumMath.incrementWrap = function(n, maximumValue, minimumValue) {
  minimumValue = defaultValue_default(minimumValue, 0);
  if (!defined_default(n)) {
    throw new DeveloperError_default("n is required.");
  }
  if (maximumValue <= minimumValue) {
    throw new DeveloperError_default("maximumValue must be greater than minimumValue.");
  }
  ++n;
  if (n > maximumValue) {
    n = minimumValue;
  }
  return n;
};
CesiumMath.isPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 4294967295) {
    throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
  }
  return n !== 0 && (n & n - 1) === 0;
};
CesiumMath.nextPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 2147483648) {
    throw new DeveloperError_default("A number between 0 and 2^31 is required.");
  }
  --n;
  n |= n >> 1;
  n |= n >> 2;
  n |= n >> 4;
  n |= n >> 8;
  n |= n >> 16;
  ++n;
  return n;
};
CesiumMath.previousPowerOfTwo = function(n) {
  if (typeof n !== "number" || n < 0 || n > 4294967295) {
    throw new DeveloperError_default("A number between 0 and (2^32)-1 is required.");
  }
  n |= n >> 1;
  n |= n >> 2;
  n |= n >> 4;
  n |= n >> 8;
  n |= n >> 16;
  n |= n >> 32;
  n = (n >>> 0) - (n >>> 1);
  return n;
};
CesiumMath.clamp = function(value, min3, max3) {
  Check_default.typeOf.number("value", value);
  Check_default.typeOf.number("min", min3);
  Check_default.typeOf.number("max", max3);
  return value < min3 ? min3 : value > max3 ? max3 : value;
};
var randomNumberGenerator = new import_mersenne_twister.default();
CesiumMath.setRandomNumberSeed = function(seed) {
  if (!defined_default(seed)) {
    throw new DeveloperError_default("seed is required.");
  }
  randomNumberGenerator = new import_mersenne_twister.default(seed);
};
CesiumMath.nextRandomNumber = function() {
  return randomNumberGenerator.random();
};
CesiumMath.randomBetween = function(min3, max3) {
  return CesiumMath.nextRandomNumber() * (max3 - min3) + min3;
};
CesiumMath.acosClamped = function(value) {
  if (!defined_default(value)) {
    throw new DeveloperError_default("value is required.");
  }
  return Math.acos(CesiumMath.clamp(value, -1, 1));
};
CesiumMath.asinClamped = function(value) {
  if (!defined_default(value)) {
    throw new DeveloperError_default("value is required.");
  }
  return Math.asin(CesiumMath.clamp(value, -1, 1));
};
CesiumMath.chordLength = function(angle, radius) {
  if (!defined_default(angle)) {
    throw new DeveloperError_default("angle is required.");
  }
  if (!defined_default(radius)) {
    throw new DeveloperError_default("radius is required.");
  }
  return 2 * radius * Math.sin(angle * 0.5);
};
CesiumMath.logBase = function(number, base) {
  if (!defined_default(number)) {
    throw new DeveloperError_default("number is required.");
  }
  if (!defined_default(base)) {
    throw new DeveloperError_default("base is required.");
  }
  return Math.log(number) / Math.log(base);
};
CesiumMath.cbrt = defaultValue_default(Math.cbrt, function cbrt(number) {
  const result = Math.pow(Math.abs(number), 1 / 3);
  return number < 0 ? -result : result;
});
CesiumMath.log2 = defaultValue_default(Math.log2, function log2(number) {
  return Math.log(number) * Math.LOG2E;
});
CesiumMath.fog = function(distanceToCamera, density) {
  const scalar = distanceToCamera * density;
  return 1 - Math.exp(-(scalar * scalar));
};
CesiumMath.fastApproximateAtan = function(x) {
  Check_default.typeOf.number("x", x);
  return x * (-0.1784 * Math.abs(x) - 0.0663 * x * x + 1.0301);
};
CesiumMath.fastApproximateAtan2 = function(x, y) {
  Check_default.typeOf.number("x", x);
  Check_default.typeOf.number("y", y);
  let opposite;
  let t = Math.abs(x);
  opposite = Math.abs(y);
  const adjacent = Math.max(t, opposite);
  opposite = Math.min(t, opposite);
  const oppositeOverAdjacent = opposite / adjacent;
  if (isNaN(oppositeOverAdjacent)) {
    throw new DeveloperError_default("either x or y must be nonzero");
  }
  t = CesiumMath.fastApproximateAtan(oppositeOverAdjacent);
  t = Math.abs(y) > Math.abs(x) ? CesiumMath.PI_OVER_TWO - t : t;
  t = x < 0 ? CesiumMath.PI - t : t;
  t = y < 0 ? -t : t;
  return t;
};
var Math_default = CesiumMath;

// Source/Core/Cartesian3.js
function Cartesian3(x, y, z) {
  this.x = defaultValue_default(x, 0);
  this.y = defaultValue_default(y, 0);
  this.z = defaultValue_default(z, 0);
}
Cartesian3.fromSpherical = function(spherical, result) {
  Check_default.typeOf.object("spherical", spherical);
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  const clock = spherical.clock;
  const cone = spherical.cone;
  const magnitude = defaultValue_default(spherical.magnitude, 1);
  const radial = magnitude * Math.sin(cone);
  result.x = radial * Math.cos(clock);
  result.y = radial * Math.sin(clock);
  result.z = magnitude * Math.cos(cone);
  return result;
};
Cartesian3.fromElements = function(x, y, z, result) {
  if (!defined_default(result)) {
    return new Cartesian3(x, y, z);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian3(cartesian11.x, cartesian11.y, cartesian11.z);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  result.z = cartesian11.z;
  return result;
};
Cartesian3.fromCartesian4 = Cartesian3.clone;
Cartesian3.packedLength = 3;
Cartesian3.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex] = value.z;
  return array;
};
Cartesian3.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.z = array[startingIndex];
  return result;
};
Cartesian3.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 3;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 3 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Cartesian3.pack(array[i], result, i * 3);
  }
  return result;
};
Cartesian3.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 3);
  if (array.length % 3 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 3.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 3);
  } else {
    result.length = length3 / 3;
  }
  for (let i = 0; i < length3; i += 3) {
    const index = i / 3;
    result[index] = Cartesian3.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian3.fromArray = Cartesian3.unpack;
Cartesian3.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y, cartesian11.z);
};
Cartesian3.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y, cartesian11.z);
};
Cartesian3.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  result.z = Math.min(first.z, second.z);
  return result;
};
Cartesian3.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  result.z = Math.max(first.z, second.z);
  return result;
};
Cartesian3.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  const z = Math_default.clamp(value.z, min3.z, max3.z);
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y + cartesian11.z * cartesian11.z;
};
Cartesian3.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian3.magnitudeSquared(cartesian11));
};
var distanceScratch = new Cartesian3();
Cartesian3.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.subtract(left, right, distanceScratch);
  return Cartesian3.magnitude(distanceScratch);
};
Cartesian3.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.subtract(left, right, distanceScratch);
  return Cartesian3.magnitudeSquared(distanceScratch);
};
Cartesian3.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian3.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  result.z = cartesian11.z / magnitude;
  if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian3.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z;
};
Cartesian3.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  result.z = left.z * right.z;
  return result;
};
Cartesian3.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  result.z = left.z / right.z;
  return result;
};
Cartesian3.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  return result;
};
Cartesian3.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  return result;
};
Cartesian3.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  result.z = cartesian11.z * scalar;
  return result;
};
Cartesian3.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  result.z = cartesian11.z / scalar;
  return result;
};
Cartesian3.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  result.z = -cartesian11.z;
  return result;
};
Cartesian3.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  result.z = Math.abs(cartesian11.z);
  return result;
};
var lerpScratch = new Cartesian3();
Cartesian3.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian3.multiplyByScalar(end, t, lerpScratch);
  result = Cartesian3.multiplyByScalar(start, 1 - t, result);
  return Cartesian3.add(lerpScratch, result, result);
};
var angleBetweenScratch = new Cartesian3();
var angleBetweenScratch2 = new Cartesian3();
Cartesian3.angleBetween = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian3.normalize(left, angleBetweenScratch);
  Cartesian3.normalize(right, angleBetweenScratch2);
  const cosine = Cartesian3.dot(angleBetweenScratch, angleBetweenScratch2);
  const sine = Cartesian3.magnitude(
    Cartesian3.cross(
      angleBetweenScratch,
      angleBetweenScratch2,
      angleBetweenScratch
    )
  );
  return Math.atan2(sine, cosine);
};
var mostOrthogonalAxisScratch = new Cartesian3();
Cartesian3.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian3.normalize(cartesian11, mostOrthogonalAxisScratch);
  Cartesian3.abs(f, f);
  if (f.x <= f.y) {
    if (f.x <= f.z) {
      result = Cartesian3.clone(Cartesian3.UNIT_X, result);
    } else {
      result = Cartesian3.clone(Cartesian3.UNIT_Z, result);
    }
  } else if (f.y <= f.z) {
    result = Cartesian3.clone(Cartesian3.UNIT_Y, result);
  } else {
    result = Cartesian3.clone(Cartesian3.UNIT_Z, result);
  }
  return result;
};
Cartesian3.projectVector = function(a3, b, result) {
  Check_default.defined("a", a3);
  Check_default.defined("b", b);
  Check_default.defined("result", result);
  const scalar = Cartesian3.dot(a3, b) / Cartesian3.dot(b, b);
  return Cartesian3.multiplyByScalar(b, scalar, result);
};
Cartesian3.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z;
};
Cartesian3.equalsArray = function(cartesian11, array, offset2) {
  return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1] && cartesian11.z === array[offset2 + 2];
};
Cartesian3.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.z,
    right.z,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian3.cross = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const leftX = left.x;
  const leftY = left.y;
  const leftZ = left.z;
  const rightX = right.x;
  const rightY = right.y;
  const rightZ = right.z;
  const x = leftY * rightZ - leftZ * rightY;
  const y = leftZ * rightX - leftX * rightZ;
  const z = leftX * rightY - leftY * rightX;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Cartesian3.midpoint = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = (left.x + right.x) * 0.5;
  result.y = (left.y + right.y) * 0.5;
  result.z = (left.z + right.z) * 0.5;
  return result;
};
Cartesian3.fromDegrees = function(longitude, latitude, height, ellipsoid, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  longitude = Math_default.toRadians(longitude);
  latitude = Math_default.toRadians(latitude);
  return Cartesian3.fromRadians(longitude, latitude, height, ellipsoid, result);
};
var scratchN = new Cartesian3();
var scratchK = new Cartesian3();
var wgs84RadiiSquared = new Cartesian3(
  6378137 * 6378137,
  6378137 * 6378137,
  6356752314245179e-9 * 6356752314245179e-9
);
Cartesian3.fromRadians = function(longitude, latitude, height, ellipsoid, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  height = defaultValue_default(height, 0);
  const radiiSquared = defined_default(ellipsoid) ? ellipsoid.radiiSquared : wgs84RadiiSquared;
  const cosLatitude = Math.cos(latitude);
  scratchN.x = cosLatitude * Math.cos(longitude);
  scratchN.y = cosLatitude * Math.sin(longitude);
  scratchN.z = Math.sin(latitude);
  scratchN = Cartesian3.normalize(scratchN, scratchN);
  Cartesian3.multiplyComponents(radiiSquared, scratchN, scratchK);
  const gamma = Math.sqrt(Cartesian3.dot(scratchN, scratchK));
  scratchK = Cartesian3.divideByScalar(scratchK, gamma, scratchK);
  scratchN = Cartesian3.multiplyByScalar(scratchN, height, scratchN);
  if (!defined_default(result)) {
    result = new Cartesian3();
  }
  return Cartesian3.add(scratchK, scratchN, result);
};
Cartesian3.fromDegreesArray = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 2 and at least 2"
    );
  }
  const length3 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 2);
  } else {
    result.length = length3 / 2;
  }
  for (let i = 0; i < length3; i += 2) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const index = i / 2;
    result[index] = Cartesian3.fromDegrees(
      longitude,
      latitude,
      0,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromRadiansArray = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 2 || coordinates.length % 2 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 2 and at least 2"
    );
  }
  const length3 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 2);
  } else {
    result.length = length3 / 2;
  }
  for (let i = 0; i < length3; i += 2) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const index = i / 2;
    result[index] = Cartesian3.fromRadians(
      longitude,
      latitude,
      0,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromDegreesArrayHeights = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 3 and at least 3"
    );
  }
  const length3 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 3);
  } else {
    result.length = length3 / 3;
  }
  for (let i = 0; i < length3; i += 3) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const height = coordinates[i + 2];
    const index = i / 3;
    result[index] = Cartesian3.fromDegrees(
      longitude,
      latitude,
      height,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.fromRadiansArrayHeights = function(coordinates, ellipsoid, result) {
  Check_default.defined("coordinates", coordinates);
  if (coordinates.length < 3 || coordinates.length % 3 !== 0) {
    throw new DeveloperError_default(
      "the number of coordinates must be a multiple of 3 and at least 3"
    );
  }
  const length3 = coordinates.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 3);
  } else {
    result.length = length3 / 3;
  }
  for (let i = 0; i < length3; i += 3) {
    const longitude = coordinates[i];
    const latitude = coordinates[i + 1];
    const height = coordinates[i + 2];
    const index = i / 3;
    result[index] = Cartesian3.fromRadians(
      longitude,
      latitude,
      height,
      ellipsoid,
      result[index]
    );
  }
  return result;
};
Cartesian3.ZERO = Object.freeze(new Cartesian3(0, 0, 0));
Cartesian3.ONE = Object.freeze(new Cartesian3(1, 1, 1));
Cartesian3.UNIT_X = Object.freeze(new Cartesian3(1, 0, 0));
Cartesian3.UNIT_Y = Object.freeze(new Cartesian3(0, 1, 0));
Cartesian3.UNIT_Z = Object.freeze(new Cartesian3(0, 0, 1));
Cartesian3.prototype.clone = function(result) {
  return Cartesian3.clone(this, result);
};
Cartesian3.prototype.equals = function(right) {
  return Cartesian3.equals(this, right);
};
Cartesian3.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian3.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian3.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z})`;
};
var Cartesian3_default = Cartesian3;

// Source/Core/Cartesian4.js
function Cartesian4(x, y, z, w) {
  this.x = defaultValue_default(x, 0);
  this.y = defaultValue_default(y, 0);
  this.z = defaultValue_default(z, 0);
  this.w = defaultValue_default(w, 0);
}
Cartesian4.fromElements = function(x, y, z, w, result) {
  if (!defined_default(result)) {
    return new Cartesian4(x, y, z, w);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Cartesian4.fromColor = function(color, result) {
  Check_default.typeOf.object("color", color);
  if (!defined_default(result)) {
    return new Cartesian4(color.red, color.green, color.blue, color.alpha);
  }
  result.x = color.red;
  result.y = color.green;
  result.z = color.blue;
  result.w = color.alpha;
  return result;
};
Cartesian4.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian4(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  result.z = cartesian11.z;
  result.w = cartesian11.w;
  return result;
};
Cartesian4.packedLength = 4;
Cartesian4.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex++] = value.z;
  array[startingIndex] = value.w;
  return array;
};
Cartesian4.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Cartesian4();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.z = array[startingIndex++];
  result.w = array[startingIndex];
  return result;
};
Cartesian4.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 4;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 4 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Cartesian4.pack(array[i], result, i * 4);
  }
  return result;
};
Cartesian4.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 4);
  if (array.length % 4 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 4.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 4);
  } else {
    result.length = length3 / 4;
  }
  for (let i = 0; i < length3; i += 4) {
    const index = i / 4;
    result[index] = Cartesian4.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian4.fromArray = Cartesian4.unpack;
Cartesian4.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
};
Cartesian4.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
};
Cartesian4.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  result.z = Math.min(first.z, second.z);
  result.w = Math.min(first.w, second.w);
  return result;
};
Cartesian4.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  result.z = Math.max(first.z, second.z);
  result.w = Math.max(first.w, second.w);
  return result;
};
Cartesian4.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  const z = Math_default.clamp(value.z, min3.z, max3.z);
  const w = Math_default.clamp(value.w, min3.w, max3.w);
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Cartesian4.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y + cartesian11.z * cartesian11.z + cartesian11.w * cartesian11.w;
};
Cartesian4.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian4.magnitudeSquared(cartesian11));
};
var distanceScratch2 = new Cartesian4();
Cartesian4.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian4.subtract(left, right, distanceScratch2);
  return Cartesian4.magnitude(distanceScratch2);
};
Cartesian4.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian4.subtract(left, right, distanceScratch2);
  return Cartesian4.magnitudeSquared(distanceScratch2);
};
Cartesian4.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian4.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  result.z = cartesian11.z / magnitude;
  result.w = cartesian11.w / magnitude;
  if (isNaN(result.x) || isNaN(result.y) || isNaN(result.z) || isNaN(result.w)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian4.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
};
Cartesian4.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  result.z = left.z * right.z;
  result.w = left.w * right.w;
  return result;
};
Cartesian4.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  result.z = left.z / right.z;
  result.w = left.w / right.w;
  return result;
};
Cartesian4.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  result.z = left.z + right.z;
  result.w = left.w + right.w;
  return result;
};
Cartesian4.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  result.z = left.z - right.z;
  result.w = left.w - right.w;
  return result;
};
Cartesian4.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  result.z = cartesian11.z * scalar;
  result.w = cartesian11.w * scalar;
  return result;
};
Cartesian4.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  result.z = cartesian11.z / scalar;
  result.w = cartesian11.w / scalar;
  return result;
};
Cartesian4.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  result.z = -cartesian11.z;
  result.w = -cartesian11.w;
  return result;
};
Cartesian4.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  result.z = Math.abs(cartesian11.z);
  result.w = Math.abs(cartesian11.w);
  return result;
};
var lerpScratch2 = new Cartesian4();
Cartesian4.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian4.multiplyByScalar(end, t, lerpScratch2);
  result = Cartesian4.multiplyByScalar(start, 1 - t, result);
  return Cartesian4.add(lerpScratch2, result, result);
};
var mostOrthogonalAxisScratch2 = new Cartesian4();
Cartesian4.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian4.normalize(cartesian11, mostOrthogonalAxisScratch2);
  Cartesian4.abs(f, f);
  if (f.x <= f.y) {
    if (f.x <= f.z) {
      if (f.x <= f.w) {
        result = Cartesian4.clone(Cartesian4.UNIT_X, result);
      } else {
        result = Cartesian4.clone(Cartesian4.UNIT_W, result);
      }
    } else if (f.z <= f.w) {
      result = Cartesian4.clone(Cartesian4.UNIT_Z, result);
    } else {
      result = Cartesian4.clone(Cartesian4.UNIT_W, result);
    }
  } else if (f.y <= f.z) {
    if (f.y <= f.w) {
      result = Cartesian4.clone(Cartesian4.UNIT_Y, result);
    } else {
      result = Cartesian4.clone(Cartesian4.UNIT_W, result);
    }
  } else if (f.z <= f.w) {
    result = Cartesian4.clone(Cartesian4.UNIT_Z, result);
  } else {
    result = Cartesian4.clone(Cartesian4.UNIT_W, result);
  }
  return result;
};
Cartesian4.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.z === right.z && left.w === right.w;
};
Cartesian4.equalsArray = function(cartesian11, array, offset2) {
  return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1] && cartesian11.z === array[offset2 + 2] && cartesian11.w === array[offset2 + 3];
};
Cartesian4.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.z,
    right.z,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.w,
    right.w,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian4.ZERO = Object.freeze(new Cartesian4(0, 0, 0, 0));
Cartesian4.ONE = Object.freeze(new Cartesian4(1, 1, 1, 1));
Cartesian4.UNIT_X = Object.freeze(new Cartesian4(1, 0, 0, 0));
Cartesian4.UNIT_Y = Object.freeze(new Cartesian4(0, 1, 0, 0));
Cartesian4.UNIT_Z = Object.freeze(new Cartesian4(0, 0, 1, 0));
Cartesian4.UNIT_W = Object.freeze(new Cartesian4(0, 0, 0, 1));
Cartesian4.prototype.clone = function(result) {
  return Cartesian4.clone(this, result);
};
Cartesian4.prototype.equals = function(right) {
  return Cartesian4.equals(this, right);
};
Cartesian4.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian4.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian4.prototype.toString = function() {
  return `(${this.x}, ${this.y}, ${this.z}, ${this.w})`;
};
var scratchF32Array = new Float32Array(1);
var scratchU8Array = new Uint8Array(scratchF32Array.buffer);
var testU32 = new Uint32Array([287454020]);
var testU8 = new Uint8Array(testU32.buffer);
var littleEndian = testU8[0] === 68;
Cartesian4.packFloat = function(value, result) {
  Check_default.typeOf.number("value", value);
  if (!defined_default(result)) {
    result = new Cartesian4();
  }
  scratchF32Array[0] = value;
  if (littleEndian) {
    result.x = scratchU8Array[0];
    result.y = scratchU8Array[1];
    result.z = scratchU8Array[2];
    result.w = scratchU8Array[3];
  } else {
    result.x = scratchU8Array[3];
    result.y = scratchU8Array[2];
    result.z = scratchU8Array[1];
    result.w = scratchU8Array[0];
  }
  return result;
};
Cartesian4.unpackFloat = function(packedFloat) {
  Check_default.typeOf.object("packedFloat", packedFloat);
  if (littleEndian) {
    scratchU8Array[0] = packedFloat.x;
    scratchU8Array[1] = packedFloat.y;
    scratchU8Array[2] = packedFloat.z;
    scratchU8Array[3] = packedFloat.w;
  } else {
    scratchU8Array[0] = packedFloat.w;
    scratchU8Array[1] = packedFloat.z;
    scratchU8Array[2] = packedFloat.y;
    scratchU8Array[3] = packedFloat.x;
  }
  return scratchF32Array[0];
};
var Cartesian4_default = Cartesian4;

// Source/Core/Matrix3.js
function Matrix3(column0Row0, column1Row0, column2Row0, column0Row1, column1Row1, column2Row1, column0Row2, column1Row2, column2Row2) {
  this[0] = defaultValue_default(column0Row0, 0);
  this[1] = defaultValue_default(column0Row1, 0);
  this[2] = defaultValue_default(column0Row2, 0);
  this[3] = defaultValue_default(column1Row0, 0);
  this[4] = defaultValue_default(column1Row1, 0);
  this[5] = defaultValue_default(column1Row2, 0);
  this[6] = defaultValue_default(column2Row0, 0);
  this[7] = defaultValue_default(column2Row1, 0);
  this[8] = defaultValue_default(column2Row2, 0);
}
Matrix3.packedLength = 9;
Matrix3.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  array[startingIndex++] = value[4];
  array[startingIndex++] = value[5];
  array[startingIndex++] = value[6];
  array[startingIndex++] = value[7];
  array[startingIndex++] = value[8];
  return array;
};
Matrix3.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Matrix3();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  result[4] = array[startingIndex++];
  result[5] = array[startingIndex++];
  result[6] = array[startingIndex++];
  result[7] = array[startingIndex++];
  result[8] = array[startingIndex++];
  return result;
};
Matrix3.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 9;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 9 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Matrix3.pack(array[i], result, i * 9);
  }
  return result;
};
Matrix3.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 9);
  if (array.length % 9 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 9.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 9);
  } else {
    result.length = length3 / 9;
  }
  for (let i = 0; i < length3; i += 9) {
    const index = i / 9;
    result[index] = Matrix3.unpack(array, i, result[index]);
  }
  return result;
};
Matrix3.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix3(
      matrix[0],
      matrix[3],
      matrix[6],
      matrix[1],
      matrix[4],
      matrix[7],
      matrix[2],
      matrix[5],
      matrix[8]
    );
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  return result;
};
Matrix3.fromArray = Matrix3.unpack;
Matrix3.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix3.clone(values, result);
};
Matrix3.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix3(
      values[0],
      values[1],
      values[2],
      values[3],
      values[4],
      values[5],
      values[6],
      values[7],
      values[8]
    );
  }
  result[0] = values[0];
  result[1] = values[3];
  result[2] = values[6];
  result[3] = values[1];
  result[4] = values[4];
  result[5] = values[7];
  result[6] = values[2];
  result[7] = values[5];
  result[8] = values[8];
  return result;
};
Matrix3.fromQuaternion = function(quaternion, result) {
  Check_default.typeOf.object("quaternion", quaternion);
  const x2 = quaternion.x * quaternion.x;
  const xy = quaternion.x * quaternion.y;
  const xz = quaternion.x * quaternion.z;
  const xw = quaternion.x * quaternion.w;
  const y2 = quaternion.y * quaternion.y;
  const yz = quaternion.y * quaternion.z;
  const yw = quaternion.y * quaternion.w;
  const z2 = quaternion.z * quaternion.z;
  const zw = quaternion.z * quaternion.w;
  const w2 = quaternion.w * quaternion.w;
  const m00 = x2 - y2 - z2 + w2;
  const m01 = 2 * (xy - zw);
  const m02 = 2 * (xz + yw);
  const m10 = 2 * (xy + zw);
  const m11 = -x2 + y2 - z2 + w2;
  const m12 = 2 * (yz - xw);
  const m20 = 2 * (xz - yw);
  const m21 = 2 * (yz + xw);
  const m22 = -x2 - y2 + z2 + w2;
  if (!defined_default(result)) {
    return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
  }
  result[0] = m00;
  result[1] = m10;
  result[2] = m20;
  result[3] = m01;
  result[4] = m11;
  result[5] = m21;
  result[6] = m02;
  result[7] = m12;
  result[8] = m22;
  return result;
};
Matrix3.fromHeadingPitchRoll = function(headingPitchRoll, result) {
  Check_default.typeOf.object("headingPitchRoll", headingPitchRoll);
  const cosTheta = Math.cos(-headingPitchRoll.pitch);
  const cosPsi = Math.cos(-headingPitchRoll.heading);
  const cosPhi = Math.cos(headingPitchRoll.roll);
  const sinTheta = Math.sin(-headingPitchRoll.pitch);
  const sinPsi = Math.sin(-headingPitchRoll.heading);
  const sinPhi = Math.sin(headingPitchRoll.roll);
  const m00 = cosTheta * cosPsi;
  const m01 = -cosPhi * sinPsi + sinPhi * sinTheta * cosPsi;
  const m02 = sinPhi * sinPsi + cosPhi * sinTheta * cosPsi;
  const m10 = cosTheta * sinPsi;
  const m11 = cosPhi * cosPsi + sinPhi * sinTheta * sinPsi;
  const m12 = -sinPhi * cosPsi + cosPhi * sinTheta * sinPsi;
  const m20 = -sinTheta;
  const m21 = sinPhi * cosTheta;
  const m22 = cosPhi * cosTheta;
  if (!defined_default(result)) {
    return new Matrix3(m00, m01, m02, m10, m11, m12, m20, m21, m22);
  }
  result[0] = m00;
  result[1] = m10;
  result[2] = m20;
  result[3] = m01;
  result[4] = m11;
  result[5] = m21;
  result[6] = m02;
  result[7] = m12;
  result[8] = m22;
  return result;
};
Matrix3.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix3(scale.x, 0, 0, 0, scale.y, 0, 0, 0, scale.z);
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = scale.y;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = scale.z;
  return result;
};
Matrix3.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix3(scale, 0, 0, 0, scale, 0, 0, 0, scale);
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = scale;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = scale;
  return result;
};
Matrix3.fromCrossProduct = function(vector, result) {
  Check_default.typeOf.object("vector", vector);
  if (!defined_default(result)) {
    return new Matrix3(
      0,
      -vector.z,
      vector.y,
      vector.z,
      0,
      -vector.x,
      -vector.y,
      vector.x,
      0
    );
  }
  result[0] = 0;
  result[1] = vector.z;
  result[2] = -vector.y;
  result[3] = -vector.z;
  result[4] = 0;
  result[5] = vector.x;
  result[6] = vector.y;
  result[7] = -vector.x;
  result[8] = 0;
  return result;
};
Matrix3.fromRotationX = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      1,
      0,
      0,
      0,
      cosAngle,
      -sinAngle,
      0,
      sinAngle,
      cosAngle
    );
  }
  result[0] = 1;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = cosAngle;
  result[5] = sinAngle;
  result[6] = 0;
  result[7] = -sinAngle;
  result[8] = cosAngle;
  return result;
};
Matrix3.fromRotationY = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      cosAngle,
      0,
      sinAngle,
      0,
      1,
      0,
      -sinAngle,
      0,
      cosAngle
    );
  }
  result[0] = cosAngle;
  result[1] = 0;
  result[2] = -sinAngle;
  result[3] = 0;
  result[4] = 1;
  result[5] = 0;
  result[6] = sinAngle;
  result[7] = 0;
  result[8] = cosAngle;
  return result;
};
Matrix3.fromRotationZ = function(angle, result) {
  Check_default.typeOf.number("angle", angle);
  const cosAngle = Math.cos(angle);
  const sinAngle = Math.sin(angle);
  if (!defined_default(result)) {
    return new Matrix3(
      cosAngle,
      -sinAngle,
      0,
      sinAngle,
      cosAngle,
      0,
      0,
      0,
      1
    );
  }
  result[0] = cosAngle;
  result[1] = sinAngle;
  result[2] = 0;
  result[3] = -sinAngle;
  result[4] = cosAngle;
  result[5] = 0;
  result[6] = 0;
  result[7] = 0;
  result[8] = 1;
  return result;
};
Matrix3.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [
      matrix[0],
      matrix[1],
      matrix[2],
      matrix[3],
      matrix[4],
      matrix[5],
      matrix[6],
      matrix[7],
      matrix[8]
    ];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  return result;
};
Matrix3.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 2);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 2);
  return column * 3 + row;
};
Matrix3.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 3;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  const z = matrix[startIndex + 2];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.setColumn = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix3.clone(matrix, result);
  const startIndex = index * 3;
  result[startIndex] = cartesian11.x;
  result[startIndex + 1] = cartesian11.y;
  result[startIndex + 2] = cartesian11.z;
  return result;
};
Matrix3.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 3];
  const z = matrix[index + 6];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.setRow = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 2);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix3.clone(matrix, result);
  result[index] = cartesian11.x;
  result[index + 3] = cartesian11.y;
  result[index + 6] = cartesian11.z;
  return result;
};
var scaleScratch1 = new Cartesian3_default();
Matrix3.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix3.getScale(matrix, scaleScratch1);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  const scaleRatioZ = scale.z / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3] * scaleRatioY;
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioZ;
  result[7] = matrix[7] * scaleRatioZ;
  result[8] = matrix[8] * scaleRatioZ;
  return result;
};
var scaleScratch2 = new Cartesian3_default();
Matrix3.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix3.getScale(matrix, scaleScratch2);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  const scaleRatioZ = scale / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3] * scaleRatioY;
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioZ;
  result[7] = matrix[7] * scaleRatioZ;
  result[8] = matrix[8] * scaleRatioZ;
  return result;
};
var scratchColumn = new Cartesian3_default();
Matrix3.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn)
  );
  result.y = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[3], matrix[4], matrix[5], scratchColumn)
  );
  result.z = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[6], matrix[7], matrix[8], scratchColumn)
  );
  return result;
};
var scaleScratch3 = new Cartesian3_default();
Matrix3.getMaximumScale = function(matrix) {
  Matrix3.getScale(matrix, scaleScratch3);
  return Cartesian3_default.maximumComponent(scaleScratch3);
};
var scaleScratch4 = new Cartesian3_default();
Matrix3.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix3.getScale(matrix, scaleScratch4);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.x;
  result[3] = rotation[3] * scale.y;
  result[4] = rotation[4] * scale.y;
  result[5] = rotation[5] * scale.y;
  result[6] = rotation[6] * scale.z;
  result[7] = rotation[7] * scale.z;
  result[8] = rotation[8] * scale.z;
  return result;
};
var scaleScratch5 = new Cartesian3_default();
Matrix3.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix3.getScale(matrix, scaleScratch5);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.x;
  result[3] = matrix[3] / scale.y;
  result[4] = matrix[4] / scale.y;
  result[5] = matrix[5] / scale.y;
  result[6] = matrix[6] / scale.z;
  result[7] = matrix[7] / scale.z;
  result[8] = matrix[8] / scale.z;
  return result;
};
Matrix3.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const column0Row0 = left[0] * right[0] + left[3] * right[1] + left[6] * right[2];
  const column0Row1 = left[1] * right[0] + left[4] * right[1] + left[7] * right[2];
  const column0Row2 = left[2] * right[0] + left[5] * right[1] + left[8] * right[2];
  const column1Row0 = left[0] * right[3] + left[3] * right[4] + left[6] * right[5];
  const column1Row1 = left[1] * right[3] + left[4] * right[4] + left[7] * right[5];
  const column1Row2 = left[2] * right[3] + left[5] * right[4] + left[8] * right[5];
  const column2Row0 = left[0] * right[6] + left[3] * right[7] + left[6] * right[8];
  const column2Row1 = left[1] * right[6] + left[4] * right[7] + left[7] * right[8];
  const column2Row2 = left[2] * right[6] + left[5] * right[7] + left[8] * right[8];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column1Row0;
  result[4] = column1Row1;
  result[5] = column1Row2;
  result[6] = column2Row0;
  result[7] = column2Row1;
  result[8] = column2Row2;
  return result;
};
Matrix3.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  result[4] = left[4] + right[4];
  result[5] = left[5] + right[5];
  result[6] = left[6] + right[6];
  result[7] = left[7] + right[7];
  result[8] = left[8] + right[8];
  return result;
};
Matrix3.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  result[4] = left[4] - right[4];
  result[5] = left[5] - right[5];
  result[6] = left[6] - right[6];
  result[7] = left[7] - right[7];
  result[8] = left[8] - right[8];
  return result;
};
Matrix3.multiplyByVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[3] * vY + matrix[6] * vZ;
  const y = matrix[1] * vX + matrix[4] * vY + matrix[7] * vZ;
  const z = matrix[2] * vX + matrix[5] * vY + matrix[8] * vZ;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix3.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  result[4] = matrix[4] * scalar;
  result[5] = matrix[5] * scalar;
  result[6] = matrix[6] * scalar;
  result[7] = matrix[7] * scalar;
  result[8] = matrix[8] * scalar;
  return result;
};
Matrix3.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale.x;
  result[1] = matrix[1] * scale.x;
  result[2] = matrix[2] * scale.x;
  result[3] = matrix[3] * scale.y;
  result[4] = matrix[4] * scale.y;
  result[5] = matrix[5] * scale.y;
  result[6] = matrix[6] * scale.z;
  result[7] = matrix[7] * scale.z;
  result[8] = matrix[8] * scale.z;
  return result;
};
Matrix3.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3] * scale;
  result[4] = matrix[4] * scale;
  result[5] = matrix[5] * scale;
  result[6] = matrix[6] * scale;
  result[7] = matrix[7] * scale;
  result[8] = matrix[8] * scale;
  return result;
};
Matrix3.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  result[4] = -matrix[4];
  result[5] = -matrix[5];
  result[6] = -matrix[6];
  result[7] = -matrix[7];
  result[8] = -matrix[8];
  return result;
};
Matrix3.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const column0Row0 = matrix[0];
  const column0Row1 = matrix[3];
  const column0Row2 = matrix[6];
  const column1Row0 = matrix[1];
  const column1Row1 = matrix[4];
  const column1Row2 = matrix[7];
  const column2Row0 = matrix[2];
  const column2Row1 = matrix[5];
  const column2Row2 = matrix[8];
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column1Row0;
  result[4] = column1Row1;
  result[5] = column1Row2;
  result[6] = column2Row0;
  result[7] = column2Row1;
  result[8] = column2Row2;
  return result;
};
function computeFrobeniusNorm(matrix) {
  let norm = 0;
  for (let i = 0; i < 9; ++i) {
    const temp = matrix[i];
    norm += temp * temp;
  }
  return Math.sqrt(norm);
}
var rowVal = [1, 0, 0];
var colVal = [2, 2, 1];
function offDiagonalFrobeniusNorm(matrix) {
  let norm = 0;
  for (let i = 0; i < 3; ++i) {
    const temp = matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])];
    norm += 2 * temp * temp;
  }
  return Math.sqrt(norm);
}
function shurDecomposition(matrix, result) {
  const tolerance = Math_default.EPSILON15;
  let maxDiagonal = 0;
  let rotAxis2 = 1;
  for (let i = 0; i < 3; ++i) {
    const temp = Math.abs(
      matrix[Matrix3.getElementIndex(colVal[i], rowVal[i])]
    );
    if (temp > maxDiagonal) {
      rotAxis2 = i;
      maxDiagonal = temp;
    }
  }
  let c = 1;
  let s = 0;
  const p = rowVal[rotAxis2];
  const q = colVal[rotAxis2];
  if (Math.abs(matrix[Matrix3.getElementIndex(q, p)]) > tolerance) {
    const qq = matrix[Matrix3.getElementIndex(q, q)];
    const pp = matrix[Matrix3.getElementIndex(p, p)];
    const qp = matrix[Matrix3.getElementIndex(q, p)];
    const tau = (qq - pp) / 2 / qp;
    let t;
    if (tau < 0) {
      t = -1 / (-tau + Math.sqrt(1 + tau * tau));
    } else {
      t = 1 / (tau + Math.sqrt(1 + tau * tau));
    }
    c = 1 / Math.sqrt(1 + t * t);
    s = t * c;
  }
  result = Matrix3.clone(Matrix3.IDENTITY, result);
  result[Matrix3.getElementIndex(p, p)] = result[Matrix3.getElementIndex(q, q)] = c;
  result[Matrix3.getElementIndex(q, p)] = s;
  result[Matrix3.getElementIndex(p, q)] = -s;
  return result;
}
var jMatrix = new Matrix3();
var jMatrixTranspose = new Matrix3();
Matrix3.computeEigenDecomposition = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  const tolerance = Math_default.EPSILON20;
  const maxSweeps = 10;
  let count = 0;
  let sweep = 0;
  if (!defined_default(result)) {
    result = {};
  }
  const unitaryMatrix = result.unitary = Matrix3.clone(
    Matrix3.IDENTITY,
    result.unitary
  );
  const diagMatrix = result.diagonal = Matrix3.clone(matrix, result.diagonal);
  const epsilon = tolerance * computeFrobeniusNorm(diagMatrix);
  while (sweep < maxSweeps && offDiagonalFrobeniusNorm(diagMatrix) > epsilon) {
    shurDecomposition(diagMatrix, jMatrix);
    Matrix3.transpose(jMatrix, jMatrixTranspose);
    Matrix3.multiply(diagMatrix, jMatrix, diagMatrix);
    Matrix3.multiply(jMatrixTranspose, diagMatrix, diagMatrix);
    Matrix3.multiply(unitaryMatrix, jMatrix, unitaryMatrix);
    if (++count > 2) {
      ++sweep;
      count = 0;
    }
  }
  return result;
};
Matrix3.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  result[4] = Math.abs(matrix[4]);
  result[5] = Math.abs(matrix[5]);
  result[6] = Math.abs(matrix[6]);
  result[7] = Math.abs(matrix[7]);
  result[8] = Math.abs(matrix[8]);
  return result;
};
Matrix3.determinant = function(matrix) {
  Check_default.typeOf.object("matrix", matrix);
  const m11 = matrix[0];
  const m21 = matrix[3];
  const m31 = matrix[6];
  const m12 = matrix[1];
  const m22 = matrix[4];
  const m32 = matrix[7];
  const m13 = matrix[2];
  const m23 = matrix[5];
  const m33 = matrix[8];
  return m11 * (m22 * m33 - m23 * m32) + m12 * (m23 * m31 - m21 * m33) + m13 * (m21 * m32 - m22 * m31);
};
Matrix3.inverse = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const m11 = matrix[0];
  const m21 = matrix[1];
  const m31 = matrix[2];
  const m12 = matrix[3];
  const m22 = matrix[4];
  const m32 = matrix[5];
  const m13 = matrix[6];
  const m23 = matrix[7];
  const m33 = matrix[8];
  const determinant = Matrix3.determinant(matrix);
  if (Math.abs(determinant) <= Math_default.EPSILON15) {
    throw new DeveloperError_default("matrix is not invertible");
  }
  result[0] = m22 * m33 - m23 * m32;
  result[1] = m23 * m31 - m21 * m33;
  result[2] = m21 * m32 - m22 * m31;
  result[3] = m13 * m32 - m12 * m33;
  result[4] = m11 * m33 - m13 * m31;
  result[5] = m12 * m31 - m11 * m32;
  result[6] = m12 * m23 - m13 * m22;
  result[7] = m13 * m21 - m11 * m23;
  result[8] = m11 * m22 - m12 * m21;
  const scale = 1 / determinant;
  return Matrix3.multiplyByScalar(result, scale, result);
};
var scratchTransposeMatrix = new Matrix3();
Matrix3.inverseTranspose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  return Matrix3.inverse(
    Matrix3.transpose(matrix, scratchTransposeMatrix),
    result
  );
};
Matrix3.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[3] === right[3] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[7] === right[7] && left[8] === right[8];
};
Matrix3.equalsEpsilon = function(left, right, epsilon) {
  epsilon = defaultValue_default(epsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon;
};
Matrix3.IDENTITY = Object.freeze(
  new Matrix3(1, 0, 0, 0, 1, 0, 0, 0, 1)
);
Matrix3.ZERO = Object.freeze(
  new Matrix3(0, 0, 0, 0, 0, 0, 0, 0, 0)
);
Matrix3.COLUMN0ROW0 = 0;
Matrix3.COLUMN0ROW1 = 1;
Matrix3.COLUMN0ROW2 = 2;
Matrix3.COLUMN1ROW0 = 3;
Matrix3.COLUMN1ROW1 = 4;
Matrix3.COLUMN1ROW2 = 5;
Matrix3.COLUMN2ROW0 = 6;
Matrix3.COLUMN2ROW1 = 7;
Matrix3.COLUMN2ROW2 = 8;
Object.defineProperties(Matrix3.prototype, {
  length: {
    get: function() {
      return Matrix3.packedLength;
    }
  }
});
Matrix3.prototype.clone = function(result) {
  return Matrix3.clone(this, result);
};
Matrix3.prototype.equals = function(right) {
  return Matrix3.equals(this, right);
};
Matrix3.equalsArray = function(matrix, array, offset2) {
  return matrix[0] === array[offset2] && matrix[1] === array[offset2 + 1] && matrix[2] === array[offset2 + 2] && matrix[3] === array[offset2 + 3] && matrix[4] === array[offset2 + 4] && matrix[5] === array[offset2 + 5] && matrix[6] === array[offset2 + 6] && matrix[7] === array[offset2 + 7] && matrix[8] === array[offset2 + 8];
};
Matrix3.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix3.equalsEpsilon(this, right, epsilon);
};
Matrix3.prototype.toString = function() {
  return `(${this[0]}, ${this[3]}, ${this[6]})
(${this[1]}, ${this[4]}, ${this[7]})
(${this[2]}, ${this[5]}, ${this[8]})`;
};
var Matrix3_default = Matrix3;

// Source/Core/RuntimeError.js
function RuntimeError(message) {
  this.name = "RuntimeError";
  this.message = message;
  let stack;
  try {
    throw new Error();
  } catch (e) {
    stack = e.stack;
  }
  this.stack = stack;
}
if (defined_default(Object.create)) {
  RuntimeError.prototype = Object.create(Error.prototype);
  RuntimeError.prototype.constructor = RuntimeError;
}
RuntimeError.prototype.toString = function() {
  let str = `${this.name}: ${this.message}`;
  if (defined_default(this.stack)) {
    str += `
${this.stack.toString()}`;
  }
  return str;
};
var RuntimeError_default = RuntimeError;

// Source/Core/Matrix4.js
function Matrix4(column0Row0, column1Row0, column2Row0, column3Row0, column0Row1, column1Row1, column2Row1, column3Row1, column0Row2, column1Row2, column2Row2, column3Row2, column0Row3, column1Row3, column2Row3, column3Row3) {
  this[0] = defaultValue_default(column0Row0, 0);
  this[1] = defaultValue_default(column0Row1, 0);
  this[2] = defaultValue_default(column0Row2, 0);
  this[3] = defaultValue_default(column0Row3, 0);
  this[4] = defaultValue_default(column1Row0, 0);
  this[5] = defaultValue_default(column1Row1, 0);
  this[6] = defaultValue_default(column1Row2, 0);
  this[7] = defaultValue_default(column1Row3, 0);
  this[8] = defaultValue_default(column2Row0, 0);
  this[9] = defaultValue_default(column2Row1, 0);
  this[10] = defaultValue_default(column2Row2, 0);
  this[11] = defaultValue_default(column2Row3, 0);
  this[12] = defaultValue_default(column3Row0, 0);
  this[13] = defaultValue_default(column3Row1, 0);
  this[14] = defaultValue_default(column3Row2, 0);
  this[15] = defaultValue_default(column3Row3, 0);
}
Matrix4.packedLength = 16;
Matrix4.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value[0];
  array[startingIndex++] = value[1];
  array[startingIndex++] = value[2];
  array[startingIndex++] = value[3];
  array[startingIndex++] = value[4];
  array[startingIndex++] = value[5];
  array[startingIndex++] = value[6];
  array[startingIndex++] = value[7];
  array[startingIndex++] = value[8];
  array[startingIndex++] = value[9];
  array[startingIndex++] = value[10];
  array[startingIndex++] = value[11];
  array[startingIndex++] = value[12];
  array[startingIndex++] = value[13];
  array[startingIndex++] = value[14];
  array[startingIndex] = value[15];
  return array;
};
Matrix4.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  result[0] = array[startingIndex++];
  result[1] = array[startingIndex++];
  result[2] = array[startingIndex++];
  result[3] = array[startingIndex++];
  result[4] = array[startingIndex++];
  result[5] = array[startingIndex++];
  result[6] = array[startingIndex++];
  result[7] = array[startingIndex++];
  result[8] = array[startingIndex++];
  result[9] = array[startingIndex++];
  result[10] = array[startingIndex++];
  result[11] = array[startingIndex++];
  result[12] = array[startingIndex++];
  result[13] = array[startingIndex++];
  result[14] = array[startingIndex++];
  result[15] = array[startingIndex];
  return result;
};
Matrix4.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 16;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 16 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Matrix4.pack(array[i], result, i * 16);
  }
  return result;
};
Matrix4.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 16);
  if (array.length % 16 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 16.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 16);
  } else {
    result.length = length3 / 16;
  }
  for (let i = 0; i < length3; i += 16) {
    const index = i / 16;
    result[index] = Matrix4.unpack(array, i, result[index]);
  }
  return result;
};
Matrix4.clone = function(matrix, result) {
  if (!defined_default(matrix)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Matrix4(
      matrix[0],
      matrix[4],
      matrix[8],
      matrix[12],
      matrix[1],
      matrix[5],
      matrix[9],
      matrix[13],
      matrix[2],
      matrix[6],
      matrix[10],
      matrix[14],
      matrix[3],
      matrix[7],
      matrix[11],
      matrix[15]
    );
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.fromArray = Matrix4.unpack;
Matrix4.fromColumnMajorArray = function(values, result) {
  Check_default.defined("values", values);
  return Matrix4.clone(values, result);
};
Matrix4.fromRowMajorArray = function(values, result) {
  Check_default.defined("values", values);
  if (!defined_default(result)) {
    return new Matrix4(
      values[0],
      values[1],
      values[2],
      values[3],
      values[4],
      values[5],
      values[6],
      values[7],
      values[8],
      values[9],
      values[10],
      values[11],
      values[12],
      values[13],
      values[14],
      values[15]
    );
  }
  result[0] = values[0];
  result[1] = values[4];
  result[2] = values[8];
  result[3] = values[12];
  result[4] = values[1];
  result[5] = values[5];
  result[6] = values[9];
  result[7] = values[13];
  result[8] = values[2];
  result[9] = values[6];
  result[10] = values[10];
  result[11] = values[14];
  result[12] = values[3];
  result[13] = values[7];
  result[14] = values[11];
  result[15] = values[15];
  return result;
};
Matrix4.fromRotationTranslation = function(rotation, translation3, result) {
  Check_default.typeOf.object("rotation", rotation);
  translation3 = defaultValue_default(translation3, Cartesian3_default.ZERO);
  if (!defined_default(result)) {
    return new Matrix4(
      rotation[0],
      rotation[3],
      rotation[6],
      translation3.x,
      rotation[1],
      rotation[4],
      rotation[7],
      translation3.y,
      rotation[2],
      rotation[5],
      rotation[8],
      translation3.z,
      0,
      0,
      0,
      1
    );
  }
  result[0] = rotation[0];
  result[1] = rotation[1];
  result[2] = rotation[2];
  result[3] = 0;
  result[4] = rotation[3];
  result[5] = rotation[4];
  result[6] = rotation[5];
  result[7] = 0;
  result[8] = rotation[6];
  result[9] = rotation[7];
  result[10] = rotation[8];
  result[11] = 0;
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = 1;
  return result;
};
Matrix4.fromTranslationQuaternionRotationScale = function(translation3, rotation, scale, result) {
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("rotation", rotation);
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  const scaleX = scale.x;
  const scaleY = scale.y;
  const scaleZ = scale.z;
  const x2 = rotation.x * rotation.x;
  const xy = rotation.x * rotation.y;
  const xz = rotation.x * rotation.z;
  const xw = rotation.x * rotation.w;
  const y2 = rotation.y * rotation.y;
  const yz = rotation.y * rotation.z;
  const yw = rotation.y * rotation.w;
  const z2 = rotation.z * rotation.z;
  const zw = rotation.z * rotation.w;
  const w2 = rotation.w * rotation.w;
  const m00 = x2 - y2 - z2 + w2;
  const m01 = 2 * (xy - zw);
  const m02 = 2 * (xz + yw);
  const m10 = 2 * (xy + zw);
  const m11 = -x2 + y2 - z2 + w2;
  const m12 = 2 * (yz - xw);
  const m20 = 2 * (xz - yw);
  const m21 = 2 * (yz + xw);
  const m22 = -x2 - y2 + z2 + w2;
  result[0] = m00 * scaleX;
  result[1] = m10 * scaleX;
  result[2] = m20 * scaleX;
  result[3] = 0;
  result[4] = m01 * scaleY;
  result[5] = m11 * scaleY;
  result[6] = m21 * scaleY;
  result[7] = 0;
  result[8] = m02 * scaleZ;
  result[9] = m12 * scaleZ;
  result[10] = m22 * scaleZ;
  result[11] = 0;
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = 1;
  return result;
};
Matrix4.fromTranslationRotationScale = function(translationRotationScale, result) {
  Check_default.typeOf.object("translationRotationScale", translationRotationScale);
  return Matrix4.fromTranslationQuaternionRotationScale(
    translationRotationScale.translation,
    translationRotationScale.rotation,
    translationRotationScale.scale,
    result
  );
};
Matrix4.fromTranslation = function(translation3, result) {
  Check_default.typeOf.object("translation", translation3);
  return Matrix4.fromRotationTranslation(Matrix3_default.IDENTITY, translation3, result);
};
Matrix4.fromScale = function(scale, result) {
  Check_default.typeOf.object("scale", scale);
  if (!defined_default(result)) {
    return new Matrix4(
      scale.x,
      0,
      0,
      0,
      0,
      scale.y,
      0,
      0,
      0,
      0,
      scale.z,
      0,
      0,
      0,
      0,
      1
    );
  }
  result[0] = scale.x;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = scale.y;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = scale.z;
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
Matrix4.fromUniformScale = function(scale, result) {
  Check_default.typeOf.number("scale", scale);
  if (!defined_default(result)) {
    return new Matrix4(
      scale,
      0,
      0,
      0,
      0,
      scale,
      0,
      0,
      0,
      0,
      scale,
      0,
      0,
      0,
      0,
      1
    );
  }
  result[0] = scale;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = scale;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = scale;
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
Matrix4.fromRotation = function(rotation, result) {
  Check_default.typeOf.object("rotation", rotation);
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  result[0] = rotation[0];
  result[1] = rotation[1];
  result[2] = rotation[2];
  result[3] = 0;
  result[4] = rotation[3];
  result[5] = rotation[4];
  result[6] = rotation[5];
  result[7] = 0;
  result[8] = rotation[6];
  result[9] = rotation[7];
  result[10] = rotation[8];
  result[11] = 0;
  result[12] = 0;
  result[13] = 0;
  result[14] = 0;
  result[15] = 1;
  return result;
};
var fromCameraF = new Cartesian3_default();
var fromCameraR = new Cartesian3_default();
var fromCameraU = new Cartesian3_default();
Matrix4.fromCamera = function(camera, result) {
  Check_default.typeOf.object("camera", camera);
  const position = camera.position;
  const direction2 = camera.direction;
  const up = camera.up;
  Check_default.typeOf.object("camera.position", position);
  Check_default.typeOf.object("camera.direction", direction2);
  Check_default.typeOf.object("camera.up", up);
  Cartesian3_default.normalize(direction2, fromCameraF);
  Cartesian3_default.normalize(
    Cartesian3_default.cross(fromCameraF, up, fromCameraR),
    fromCameraR
  );
  Cartesian3_default.normalize(
    Cartesian3_default.cross(fromCameraR, fromCameraF, fromCameraU),
    fromCameraU
  );
  const sX = fromCameraR.x;
  const sY = fromCameraR.y;
  const sZ = fromCameraR.z;
  const fX = fromCameraF.x;
  const fY = fromCameraF.y;
  const fZ = fromCameraF.z;
  const uX = fromCameraU.x;
  const uY = fromCameraU.y;
  const uZ = fromCameraU.z;
  const positionX = position.x;
  const positionY = position.y;
  const positionZ = position.z;
  const t0 = sX * -positionX + sY * -positionY + sZ * -positionZ;
  const t1 = uX * -positionX + uY * -positionY + uZ * -positionZ;
  const t2 = fX * positionX + fY * positionY + fZ * positionZ;
  if (!defined_default(result)) {
    return new Matrix4(
      sX,
      sY,
      sZ,
      t0,
      uX,
      uY,
      uZ,
      t1,
      -fX,
      -fY,
      -fZ,
      t2,
      0,
      0,
      0,
      1
    );
  }
  result[0] = sX;
  result[1] = uX;
  result[2] = -fX;
  result[3] = 0;
  result[4] = sY;
  result[5] = uY;
  result[6] = -fY;
  result[7] = 0;
  result[8] = sZ;
  result[9] = uZ;
  result[10] = -fZ;
  result[11] = 0;
  result[12] = t0;
  result[13] = t1;
  result[14] = t2;
  result[15] = 1;
  return result;
};
Matrix4.computePerspectiveFieldOfView = function(fovY, aspectRatio, near, far, result) {
  Check_default.typeOf.number.greaterThan("fovY", fovY, 0);
  Check_default.typeOf.number.lessThan("fovY", fovY, Math.PI);
  Check_default.typeOf.number.greaterThan("near", near, 0);
  Check_default.typeOf.number.greaterThan("far", far, 0);
  Check_default.typeOf.object("result", result);
  const bottom = Math.tan(fovY * 0.5);
  const column1Row1 = 1 / bottom;
  const column0Row0 = column1Row1 / aspectRatio;
  const column2Row2 = (far + near) / (near - far);
  const column3Row2 = 2 * far * near / (near - far);
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = column2Row2;
  result[11] = -1;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeOrthographicOffCenter = function(left, right, bottom, top, near, far, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.number("far", far);
  Check_default.typeOf.object("result", result);
  let a3 = 1 / (right - left);
  let b = 1 / (top - bottom);
  let c = 1 / (far - near);
  const tx = -(right + left) * a3;
  const ty = -(top + bottom) * b;
  const tz = -(far + near) * c;
  a3 *= 2;
  b *= 2;
  c *= -2;
  result[0] = a3;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = b;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = c;
  result[11] = 0;
  result[12] = tx;
  result[13] = ty;
  result[14] = tz;
  result[15] = 1;
  return result;
};
Matrix4.computePerspectiveOffCenter = function(left, right, bottom, top, near, far, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.number("far", far);
  Check_default.typeOf.object("result", result);
  const column0Row0 = 2 * near / (right - left);
  const column1Row1 = 2 * near / (top - bottom);
  const column2Row0 = (right + left) / (right - left);
  const column2Row1 = (top + bottom) / (top - bottom);
  const column2Row2 = -(far + near) / (far - near);
  const column2Row3 = -1;
  const column3Row2 = -2 * far * near / (far - near);
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeInfinitePerspectiveOffCenter = function(left, right, bottom, top, near, result) {
  Check_default.typeOf.number("left", left);
  Check_default.typeOf.number("right", right);
  Check_default.typeOf.number("bottom", bottom);
  Check_default.typeOf.number("top", top);
  Check_default.typeOf.number("near", near);
  Check_default.typeOf.object("result", result);
  const column0Row0 = 2 * near / (right - left);
  const column1Row1 = 2 * near / (top - bottom);
  const column2Row0 = (right + left) / (right - left);
  const column2Row1 = (top + bottom) / (top - bottom);
  const column2Row2 = -1;
  const column2Row3 = -1;
  const column3Row2 = -2 * near;
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = 0;
  result[13] = 0;
  result[14] = column3Row2;
  result[15] = 0;
  return result;
};
Matrix4.computeViewportTransformation = function(viewport, nearDepthRange, farDepthRange, result) {
  if (!defined_default(result)) {
    result = new Matrix4();
  }
  viewport = defaultValue_default(viewport, defaultValue_default.EMPTY_OBJECT);
  const x = defaultValue_default(viewport.x, 0);
  const y = defaultValue_default(viewport.y, 0);
  const width = defaultValue_default(viewport.width, 0);
  const height = defaultValue_default(viewport.height, 0);
  nearDepthRange = defaultValue_default(nearDepthRange, 0);
  farDepthRange = defaultValue_default(farDepthRange, 1);
  const halfWidth = width * 0.5;
  const halfHeight = height * 0.5;
  const halfDepth = (farDepthRange - nearDepthRange) * 0.5;
  const column0Row0 = halfWidth;
  const column1Row1 = halfHeight;
  const column2Row2 = halfDepth;
  const column3Row0 = x + halfWidth;
  const column3Row1 = y + halfHeight;
  const column3Row2 = nearDepthRange + halfDepth;
  const column3Row3 = 1;
  result[0] = column0Row0;
  result[1] = 0;
  result[2] = 0;
  result[3] = 0;
  result[4] = 0;
  result[5] = column1Row1;
  result[6] = 0;
  result[7] = 0;
  result[8] = 0;
  result[9] = 0;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = column3Row3;
  return result;
};
Matrix4.computeView = function(position, direction2, up, right, result) {
  Check_default.typeOf.object("position", position);
  Check_default.typeOf.object("direction", direction2);
  Check_default.typeOf.object("up", up);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = right.x;
  result[1] = up.x;
  result[2] = -direction2.x;
  result[3] = 0;
  result[4] = right.y;
  result[5] = up.y;
  result[6] = -direction2.y;
  result[7] = 0;
  result[8] = right.z;
  result[9] = up.z;
  result[10] = -direction2.z;
  result[11] = 0;
  result[12] = -Cartesian3_default.dot(right, position);
  result[13] = -Cartesian3_default.dot(up, position);
  result[14] = Cartesian3_default.dot(direction2, position);
  result[15] = 1;
  return result;
};
Matrix4.toArray = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  if (!defined_default(result)) {
    return [
      matrix[0],
      matrix[1],
      matrix[2],
      matrix[3],
      matrix[4],
      matrix[5],
      matrix[6],
      matrix[7],
      matrix[8],
      matrix[9],
      matrix[10],
      matrix[11],
      matrix[12],
      matrix[13],
      matrix[14],
      matrix[15]
    ];
  }
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.getElementIndex = function(column, row) {
  Check_default.typeOf.number.greaterThanOrEquals("row", row, 0);
  Check_default.typeOf.number.lessThanOrEquals("row", row, 3);
  Check_default.typeOf.number.greaterThanOrEquals("column", column, 0);
  Check_default.typeOf.number.lessThanOrEquals("column", column, 3);
  return column * 4 + row;
};
Matrix4.getColumn = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("result", result);
  const startIndex = index * 4;
  const x = matrix[startIndex];
  const y = matrix[startIndex + 1];
  const z = matrix[startIndex + 2];
  const w = matrix[startIndex + 3];
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.setColumn = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix4.clone(matrix, result);
  const startIndex = index * 4;
  result[startIndex] = cartesian11.x;
  result[startIndex + 1] = cartesian11.y;
  result[startIndex + 2] = cartesian11.z;
  result[startIndex + 3] = cartesian11.w;
  return result;
};
Matrix4.getRow = function(matrix, index, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("result", result);
  const x = matrix[index];
  const y = matrix[index + 4];
  const z = matrix[index + 8];
  const w = matrix[index + 12];
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.setRow = function(matrix, index, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number.greaterThanOrEquals("index", index, 0);
  Check_default.typeOf.number.lessThanOrEquals("index", index, 3);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result = Matrix4.clone(matrix, result);
  result[index] = cartesian11.x;
  result[index + 4] = cartesian11.y;
  result[index + 8] = cartesian11.z;
  result[index + 12] = cartesian11.w;
  return result;
};
Matrix4.setTranslation = function(matrix, translation3, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = translation3.x;
  result[13] = translation3.y;
  result[14] = translation3.z;
  result[15] = matrix[15];
  return result;
};
var scaleScratch12 = new Cartesian3_default();
Matrix4.setScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix4.getScale(matrix, scaleScratch12);
  const scaleRatioX = scale.x / existingScale.x;
  const scaleRatioY = scale.y / existingScale.y;
  const scaleRatioZ = scale.z / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3];
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioY;
  result[7] = matrix[7];
  result[8] = matrix[8] * scaleRatioZ;
  result[9] = matrix[9] * scaleRatioZ;
  result[10] = matrix[10] * scaleRatioZ;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scaleScratch22 = new Cartesian3_default();
Matrix4.setUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  const existingScale = Matrix4.getScale(matrix, scaleScratch22);
  const scaleRatioX = scale / existingScale.x;
  const scaleRatioY = scale / existingScale.y;
  const scaleRatioZ = scale / existingScale.z;
  result[0] = matrix[0] * scaleRatioX;
  result[1] = matrix[1] * scaleRatioX;
  result[2] = matrix[2] * scaleRatioX;
  result[3] = matrix[3];
  result[4] = matrix[4] * scaleRatioY;
  result[5] = matrix[5] * scaleRatioY;
  result[6] = matrix[6] * scaleRatioY;
  result[7] = matrix[7];
  result[8] = matrix[8] * scaleRatioZ;
  result[9] = matrix[9] * scaleRatioZ;
  result[10] = matrix[10] * scaleRatioZ;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scratchColumn2 = new Cartesian3_default();
Matrix4.getScale = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[0], matrix[1], matrix[2], scratchColumn2)
  );
  result.y = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[4], matrix[5], matrix[6], scratchColumn2)
  );
  result.z = Cartesian3_default.magnitude(
    Cartesian3_default.fromElements(matrix[8], matrix[9], matrix[10], scratchColumn2)
  );
  return result;
};
var scaleScratch32 = new Cartesian3_default();
Matrix4.getMaximumScale = function(matrix) {
  Matrix4.getScale(matrix, scaleScratch32);
  return Cartesian3_default.maximumComponent(scaleScratch32);
};
var scaleScratch42 = new Cartesian3_default();
Matrix4.setRotation = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix4.getScale(matrix, scaleScratch42);
  result[0] = rotation[0] * scale.x;
  result[1] = rotation[1] * scale.x;
  result[2] = rotation[2] * scale.x;
  result[3] = matrix[3];
  result[4] = rotation[3] * scale.y;
  result[5] = rotation[4] * scale.y;
  result[6] = rotation[5] * scale.y;
  result[7] = matrix[7];
  result[8] = rotation[6] * scale.z;
  result[9] = rotation[7] * scale.z;
  result[10] = rotation[8] * scale.z;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
var scaleScratch52 = new Cartesian3_default();
Matrix4.getRotation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const scale = Matrix4.getScale(matrix, scaleScratch52);
  result[0] = matrix[0] / scale.x;
  result[1] = matrix[1] / scale.x;
  result[2] = matrix[2] / scale.x;
  result[3] = matrix[4] / scale.y;
  result[4] = matrix[5] / scale.y;
  result[5] = matrix[6] / scale.y;
  result[6] = matrix[8] / scale.z;
  result[7] = matrix[9] / scale.z;
  result[8] = matrix[10] / scale.z;
  return result;
};
Matrix4.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const left0 = left[0];
  const left1 = left[1];
  const left2 = left[2];
  const left3 = left[3];
  const left4 = left[4];
  const left5 = left[5];
  const left6 = left[6];
  const left7 = left[7];
  const left8 = left[8];
  const left9 = left[9];
  const left10 = left[10];
  const left11 = left[11];
  const left12 = left[12];
  const left13 = left[13];
  const left14 = left[14];
  const left15 = left[15];
  const right0 = right[0];
  const right1 = right[1];
  const right2 = right[2];
  const right3 = right[3];
  const right4 = right[4];
  const right5 = right[5];
  const right6 = right[6];
  const right7 = right[7];
  const right8 = right[8];
  const right9 = right[9];
  const right10 = right[10];
  const right11 = right[11];
  const right12 = right[12];
  const right13 = right[13];
  const right14 = right[14];
  const right15 = right[15];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2 + left12 * right3;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2 + left13 * right3;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2 + left14 * right3;
  const column0Row3 = left3 * right0 + left7 * right1 + left11 * right2 + left15 * right3;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6 + left12 * right7;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6 + left13 * right7;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6 + left14 * right7;
  const column1Row3 = left3 * right4 + left7 * right5 + left11 * right6 + left15 * right7;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10 + left12 * right11;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10 + left13 * right11;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10 + left14 * right11;
  const column2Row3 = left3 * right8 + left7 * right9 + left11 * right10 + left15 * right11;
  const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12 * right15;
  const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13 * right15;
  const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14 * right15;
  const column3Row3 = left3 * right12 + left7 * right13 + left11 * right14 + left15 * right15;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = column0Row3;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = column1Row3;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = column2Row3;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = column3Row3;
  return result;
};
Matrix4.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] + right[0];
  result[1] = left[1] + right[1];
  result[2] = left[2] + right[2];
  result[3] = left[3] + right[3];
  result[4] = left[4] + right[4];
  result[5] = left[5] + right[5];
  result[6] = left[6] + right[6];
  result[7] = left[7] + right[7];
  result[8] = left[8] + right[8];
  result[9] = left[9] + right[9];
  result[10] = left[10] + right[10];
  result[11] = left[11] + right[11];
  result[12] = left[12] + right[12];
  result[13] = left[13] + right[13];
  result[14] = left[14] + right[14];
  result[15] = left[15] + right[15];
  return result;
};
Matrix4.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result[0] = left[0] - right[0];
  result[1] = left[1] - right[1];
  result[2] = left[2] - right[2];
  result[3] = left[3] - right[3];
  result[4] = left[4] - right[4];
  result[5] = left[5] - right[5];
  result[6] = left[6] - right[6];
  result[7] = left[7] - right[7];
  result[8] = left[8] - right[8];
  result[9] = left[9] - right[9];
  result[10] = left[10] - right[10];
  result[11] = left[11] - right[11];
  result[12] = left[12] - right[12];
  result[13] = left[13] - right[13];
  result[14] = left[14] - right[14];
  result[15] = left[15] - right[15];
  return result;
};
Matrix4.multiplyTransformation = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  const left0 = left[0];
  const left1 = left[1];
  const left2 = left[2];
  const left4 = left[4];
  const left5 = left[5];
  const left6 = left[6];
  const left8 = left[8];
  const left9 = left[9];
  const left10 = left[10];
  const left12 = left[12];
  const left13 = left[13];
  const left14 = left[14];
  const right0 = right[0];
  const right1 = right[1];
  const right2 = right[2];
  const right4 = right[4];
  const right5 = right[5];
  const right6 = right[6];
  const right8 = right[8];
  const right9 = right[9];
  const right10 = right[10];
  const right12 = right[12];
  const right13 = right[13];
  const right14 = right[14];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
  const column3Row0 = left0 * right12 + left4 * right13 + left8 * right14 + left12;
  const column3Row1 = left1 * right12 + left5 * right13 + left9 * right14 + left13;
  const column3Row2 = left2 * right12 + left6 * right13 + left10 * right14 + left14;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = 0;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = column3Row0;
  result[13] = column3Row1;
  result[14] = column3Row2;
  result[15] = 1;
  return result;
};
Matrix4.multiplyByMatrix3 = function(matrix, rotation, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("rotation", rotation);
  Check_default.typeOf.object("result", result);
  const left0 = matrix[0];
  const left1 = matrix[1];
  const left2 = matrix[2];
  const left4 = matrix[4];
  const left5 = matrix[5];
  const left6 = matrix[6];
  const left8 = matrix[8];
  const left9 = matrix[9];
  const left10 = matrix[10];
  const right0 = rotation[0];
  const right1 = rotation[1];
  const right2 = rotation[2];
  const right4 = rotation[3];
  const right5 = rotation[4];
  const right6 = rotation[5];
  const right8 = rotation[6];
  const right9 = rotation[7];
  const right10 = rotation[8];
  const column0Row0 = left0 * right0 + left4 * right1 + left8 * right2;
  const column0Row1 = left1 * right0 + left5 * right1 + left9 * right2;
  const column0Row2 = left2 * right0 + left6 * right1 + left10 * right2;
  const column1Row0 = left0 * right4 + left4 * right5 + left8 * right6;
  const column1Row1 = left1 * right4 + left5 * right5 + left9 * right6;
  const column1Row2 = left2 * right4 + left6 * right5 + left10 * right6;
  const column2Row0 = left0 * right8 + left4 * right9 + left8 * right10;
  const column2Row1 = left1 * right8 + left5 * right9 + left9 * right10;
  const column2Row2 = left2 * right8 + left6 * right9 + left10 * right10;
  result[0] = column0Row0;
  result[1] = column0Row1;
  result[2] = column0Row2;
  result[3] = 0;
  result[4] = column1Row0;
  result[5] = column1Row1;
  result[6] = column1Row2;
  result[7] = 0;
  result[8] = column2Row0;
  result[9] = column2Row1;
  result[10] = column2Row2;
  result[11] = 0;
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByTranslation = function(matrix, translation3, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("translation", translation3);
  Check_default.typeOf.object("result", result);
  const x = translation3.x;
  const y = translation3.y;
  const z = translation3.z;
  const tx = x * matrix[0] + y * matrix[4] + z * matrix[8] + matrix[12];
  const ty = x * matrix[1] + y * matrix[5] + z * matrix[9] + matrix[13];
  const tz = x * matrix[2] + y * matrix[6] + z * matrix[10] + matrix[14];
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[3];
  result[4] = matrix[4];
  result[5] = matrix[5];
  result[6] = matrix[6];
  result[7] = matrix[7];
  result[8] = matrix[8];
  result[9] = matrix[9];
  result[10] = matrix[10];
  result[11] = matrix[11];
  result[12] = tx;
  result[13] = ty;
  result[14] = tz;
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("scale", scale);
  Check_default.typeOf.object("result", result);
  const scaleX = scale.x;
  const scaleY = scale.y;
  const scaleZ = scale.z;
  if (scaleX === 1 && scaleY === 1 && scaleZ === 1) {
    return Matrix4.clone(matrix, result);
  }
  result[0] = scaleX * matrix[0];
  result[1] = scaleX * matrix[1];
  result[2] = scaleX * matrix[2];
  result[3] = matrix[3];
  result[4] = scaleY * matrix[4];
  result[5] = scaleY * matrix[5];
  result[6] = scaleY * matrix[6];
  result[7] = matrix[7];
  result[8] = scaleZ * matrix[8];
  result[9] = scaleZ * matrix[9];
  result[10] = scaleZ * matrix[10];
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByUniformScale = function(matrix, scale, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scale", scale);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scale;
  result[1] = matrix[1] * scale;
  result[2] = matrix[2] * scale;
  result[3] = matrix[3];
  result[4] = matrix[4] * scale;
  result[5] = matrix[5] * scale;
  result[6] = matrix[6] * scale;
  result[7] = matrix[7];
  result[8] = matrix[8] * scale;
  result[9] = matrix[9] * scale;
  result[10] = matrix[10] * scale;
  result[11] = matrix[11];
  result[12] = matrix[12];
  result[13] = matrix[13];
  result[14] = matrix[14];
  result[15] = matrix[15];
  return result;
};
Matrix4.multiplyByVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const vW = cartesian11.w;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12] * vW;
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13] * vW;
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14] * vW;
  const w = matrix[3] * vX + matrix[7] * vY + matrix[11] * vZ + matrix[15] * vW;
  result.x = x;
  result.y = y;
  result.z = z;
  result.w = w;
  return result;
};
Matrix4.multiplyByPointAsVector = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ;
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ;
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ;
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix4.multiplyByPoint = function(matrix, cartesian11, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const vX = cartesian11.x;
  const vY = cartesian11.y;
  const vZ = cartesian11.z;
  const x = matrix[0] * vX + matrix[4] * vY + matrix[8] * vZ + matrix[12];
  const y = matrix[1] * vX + matrix[5] * vY + matrix[9] * vZ + matrix[13];
  const z = matrix[2] * vX + matrix[6] * vY + matrix[10] * vZ + matrix[14];
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
Matrix4.multiplyByScalar = function(matrix, scalar, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0] * scalar;
  result[1] = matrix[1] * scalar;
  result[2] = matrix[2] * scalar;
  result[3] = matrix[3] * scalar;
  result[4] = matrix[4] * scalar;
  result[5] = matrix[5] * scalar;
  result[6] = matrix[6] * scalar;
  result[7] = matrix[7] * scalar;
  result[8] = matrix[8] * scalar;
  result[9] = matrix[9] * scalar;
  result[10] = matrix[10] * scalar;
  result[11] = matrix[11] * scalar;
  result[12] = matrix[12] * scalar;
  result[13] = matrix[13] * scalar;
  result[14] = matrix[14] * scalar;
  result[15] = matrix[15] * scalar;
  return result;
};
Matrix4.negate = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = -matrix[0];
  result[1] = -matrix[1];
  result[2] = -matrix[2];
  result[3] = -matrix[3];
  result[4] = -matrix[4];
  result[5] = -matrix[5];
  result[6] = -matrix[6];
  result[7] = -matrix[7];
  result[8] = -matrix[8];
  result[9] = -matrix[9];
  result[10] = -matrix[10];
  result[11] = -matrix[11];
  result[12] = -matrix[12];
  result[13] = -matrix[13];
  result[14] = -matrix[14];
  result[15] = -matrix[15];
  return result;
};
Matrix4.transpose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const matrix1 = matrix[1];
  const matrix2 = matrix[2];
  const matrix3 = matrix[3];
  const matrix6 = matrix[6];
  const matrix7 = matrix[7];
  const matrix11 = matrix[11];
  result[0] = matrix[0];
  result[1] = matrix[4];
  result[2] = matrix[8];
  result[3] = matrix[12];
  result[4] = matrix1;
  result[5] = matrix[5];
  result[6] = matrix[9];
  result[7] = matrix[13];
  result[8] = matrix2;
  result[9] = matrix6;
  result[10] = matrix[10];
  result[11] = matrix[14];
  result[12] = matrix3;
  result[13] = matrix7;
  result[14] = matrix11;
  result[15] = matrix[15];
  return result;
};
Matrix4.abs = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = Math.abs(matrix[0]);
  result[1] = Math.abs(matrix[1]);
  result[2] = Math.abs(matrix[2]);
  result[3] = Math.abs(matrix[3]);
  result[4] = Math.abs(matrix[4]);
  result[5] = Math.abs(matrix[5]);
  result[6] = Math.abs(matrix[6]);
  result[7] = Math.abs(matrix[7]);
  result[8] = Math.abs(matrix[8]);
  result[9] = Math.abs(matrix[9]);
  result[10] = Math.abs(matrix[10]);
  result[11] = Math.abs(matrix[11]);
  result[12] = Math.abs(matrix[12]);
  result[13] = Math.abs(matrix[13]);
  result[14] = Math.abs(matrix[14]);
  result[15] = Math.abs(matrix[15]);
  return result;
};
Matrix4.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left[12] === right[12] && left[13] === right[13] && left[14] === right[14] && left[0] === right[0] && left[1] === right[1] && left[2] === right[2] && left[4] === right[4] && left[5] === right[5] && left[6] === right[6] && left[8] === right[8] && left[9] === right[9] && left[10] === right[10] && left[3] === right[3] && left[7] === right[7] && left[11] === right[11] && left[15] === right[15];
};
Matrix4.equalsEpsilon = function(left, right, epsilon) {
  epsilon = defaultValue_default(epsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left[0] - right[0]) <= epsilon && Math.abs(left[1] - right[1]) <= epsilon && Math.abs(left[2] - right[2]) <= epsilon && Math.abs(left[3] - right[3]) <= epsilon && Math.abs(left[4] - right[4]) <= epsilon && Math.abs(left[5] - right[5]) <= epsilon && Math.abs(left[6] - right[6]) <= epsilon && Math.abs(left[7] - right[7]) <= epsilon && Math.abs(left[8] - right[8]) <= epsilon && Math.abs(left[9] - right[9]) <= epsilon && Math.abs(left[10] - right[10]) <= epsilon && Math.abs(left[11] - right[11]) <= epsilon && Math.abs(left[12] - right[12]) <= epsilon && Math.abs(left[13] - right[13]) <= epsilon && Math.abs(left[14] - right[14]) <= epsilon && Math.abs(left[15] - right[15]) <= epsilon;
};
Matrix4.getTranslation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result.x = matrix[12];
  result.y = matrix[13];
  result.z = matrix[14];
  return result;
};
Matrix4.getMatrix3 = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  result[0] = matrix[0];
  result[1] = matrix[1];
  result[2] = matrix[2];
  result[3] = matrix[4];
  result[4] = matrix[5];
  result[5] = matrix[6];
  result[6] = matrix[8];
  result[7] = matrix[9];
  result[8] = matrix[10];
  return result;
};
var scratchInverseRotation = new Matrix3_default();
var scratchMatrix3Zero = new Matrix3_default();
var scratchBottomRow = new Cartesian4_default();
var scratchExpectedBottomRow = new Cartesian4_default(0, 0, 0, 1);
Matrix4.inverse = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const src0 = matrix[0];
  const src1 = matrix[4];
  const src2 = matrix[8];
  const src3 = matrix[12];
  const src4 = matrix[1];
  const src5 = matrix[5];
  const src6 = matrix[9];
  const src7 = matrix[13];
  const src8 = matrix[2];
  const src9 = matrix[6];
  const src10 = matrix[10];
  const src11 = matrix[14];
  const src12 = matrix[3];
  const src13 = matrix[7];
  const src14 = matrix[11];
  const src15 = matrix[15];
  let tmp0 = src10 * src15;
  let tmp1 = src11 * src14;
  let tmp2 = src9 * src15;
  let tmp3 = src11 * src13;
  let tmp4 = src9 * src14;
  let tmp5 = src10 * src13;
  let tmp6 = src8 * src15;
  let tmp7 = src11 * src12;
  let tmp8 = src8 * src14;
  let tmp9 = src10 * src12;
  let tmp10 = src8 * src13;
  let tmp11 = src9 * src12;
  const dst0 = tmp0 * src5 + tmp3 * src6 + tmp4 * src7 - (tmp1 * src5 + tmp2 * src6 + tmp5 * src7);
  const dst1 = tmp1 * src4 + tmp6 * src6 + tmp9 * src7 - (tmp0 * src4 + tmp7 * src6 + tmp8 * src7);
  const dst2 = tmp2 * src4 + tmp7 * src5 + tmp10 * src7 - (tmp3 * src4 + tmp6 * src5 + tmp11 * src7);
  const dst3 = tmp5 * src4 + tmp8 * src5 + tmp11 * src6 - (tmp4 * src4 + tmp9 * src5 + tmp10 * src6);
  const dst4 = tmp1 * src1 + tmp2 * src2 + tmp5 * src3 - (tmp0 * src1 + tmp3 * src2 + tmp4 * src3);
  const dst5 = tmp0 * src0 + tmp7 * src2 + tmp8 * src3 - (tmp1 * src0 + tmp6 * src2 + tmp9 * src3);
  const dst6 = tmp3 * src0 + tmp6 * src1 + tmp11 * src3 - (tmp2 * src0 + tmp7 * src1 + tmp10 * src3);
  const dst7 = tmp4 * src0 + tmp9 * src1 + tmp10 * src2 - (tmp5 * src0 + tmp8 * src1 + tmp11 * src2);
  tmp0 = src2 * src7;
  tmp1 = src3 * src6;
  tmp2 = src1 * src7;
  tmp3 = src3 * src5;
  tmp4 = src1 * src6;
  tmp5 = src2 * src5;
  tmp6 = src0 * src7;
  tmp7 = src3 * src4;
  tmp8 = src0 * src6;
  tmp9 = src2 * src4;
  tmp10 = src0 * src5;
  tmp11 = src1 * src4;
  const dst8 = tmp0 * src13 + tmp3 * src14 + tmp4 * src15 - (tmp1 * src13 + tmp2 * src14 + tmp5 * src15);
  const dst9 = tmp1 * src12 + tmp6 * src14 + tmp9 * src15 - (tmp0 * src12 + tmp7 * src14 + tmp8 * src15);
  const dst10 = tmp2 * src12 + tmp7 * src13 + tmp10 * src15 - (tmp3 * src12 + tmp6 * src13 + tmp11 * src15);
  const dst11 = tmp5 * src12 + tmp8 * src13 + tmp11 * src14 - (tmp4 * src12 + tmp9 * src13 + tmp10 * src14);
  const dst12 = tmp2 * src10 + tmp5 * src11 + tmp1 * src9 - (tmp4 * src11 + tmp0 * src9 + tmp3 * src10);
  const dst13 = tmp8 * src11 + tmp0 * src8 + tmp7 * src10 - (tmp6 * src10 + tmp9 * src11 + tmp1 * src8);
  const dst14 = tmp6 * src9 + tmp11 * src11 + tmp3 * src8 - (tmp10 * src11 + tmp2 * src8 + tmp7 * src9);
  const dst15 = tmp10 * src10 + tmp4 * src8 + tmp9 * src9 - (tmp8 * src9 + tmp11 * src10 + tmp5 * src8);
  let det = src0 * dst0 + src1 * dst1 + src2 * dst2 + src3 * dst3;
  if (Math.abs(det) < Math_default.EPSILON21) {
    if (Matrix3_default.equalsEpsilon(
      Matrix4.getMatrix3(matrix, scratchInverseRotation),
      scratchMatrix3Zero,
      Math_default.EPSILON7
    ) && Cartesian4_default.equals(
      Matrix4.getRow(matrix, 3, scratchBottomRow),
      scratchExpectedBottomRow
    )) {
      result[0] = 0;
      result[1] = 0;
      result[2] = 0;
      result[3] = 0;
      result[4] = 0;
      result[5] = 0;
      result[6] = 0;
      result[7] = 0;
      result[8] = 0;
      result[9] = 0;
      result[10] = 0;
      result[11] = 0;
      result[12] = -matrix[12];
      result[13] = -matrix[13];
      result[14] = -matrix[14];
      result[15] = 1;
      return result;
    }
    throw new RuntimeError_default(
      "matrix is not invertible because its determinate is zero."
    );
  }
  det = 1 / det;
  result[0] = dst0 * det;
  result[1] = dst1 * det;
  result[2] = dst2 * det;
  result[3] = dst3 * det;
  result[4] = dst4 * det;
  result[5] = dst5 * det;
  result[6] = dst6 * det;
  result[7] = dst7 * det;
  result[8] = dst8 * det;
  result[9] = dst9 * det;
  result[10] = dst10 * det;
  result[11] = dst11 * det;
  result[12] = dst12 * det;
  result[13] = dst13 * det;
  result[14] = dst14 * det;
  result[15] = dst15 * det;
  return result;
};
Matrix4.inverseTransformation = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  const matrix0 = matrix[0];
  const matrix1 = matrix[1];
  const matrix2 = matrix[2];
  const matrix4 = matrix[4];
  const matrix5 = matrix[5];
  const matrix6 = matrix[6];
  const matrix8 = matrix[8];
  const matrix9 = matrix[9];
  const matrix10 = matrix[10];
  const vX = matrix[12];
  const vY = matrix[13];
  const vZ = matrix[14];
  const x = -matrix0 * vX - matrix1 * vY - matrix2 * vZ;
  const y = -matrix4 * vX - matrix5 * vY - matrix6 * vZ;
  const z = -matrix8 * vX - matrix9 * vY - matrix10 * vZ;
  result[0] = matrix0;
  result[1] = matrix4;
  result[2] = matrix8;
  result[3] = 0;
  result[4] = matrix1;
  result[5] = matrix5;
  result[6] = matrix9;
  result[7] = 0;
  result[8] = matrix2;
  result[9] = matrix6;
  result[10] = matrix10;
  result[11] = 0;
  result[12] = x;
  result[13] = y;
  result[14] = z;
  result[15] = 1;
  return result;
};
var scratchTransposeMatrix2 = new Matrix4();
Matrix4.inverseTranspose = function(matrix, result) {
  Check_default.typeOf.object("matrix", matrix);
  Check_default.typeOf.object("result", result);
  return Matrix4.inverse(
    Matrix4.transpose(matrix, scratchTransposeMatrix2),
    result
  );
};
Matrix4.IDENTITY = Object.freeze(
  new Matrix4(
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1
  )
);
Matrix4.ZERO = Object.freeze(
  new Matrix4(
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0
  )
);
Matrix4.COLUMN0ROW0 = 0;
Matrix4.COLUMN0ROW1 = 1;
Matrix4.COLUMN0ROW2 = 2;
Matrix4.COLUMN0ROW3 = 3;
Matrix4.COLUMN1ROW0 = 4;
Matrix4.COLUMN1ROW1 = 5;
Matrix4.COLUMN1ROW2 = 6;
Matrix4.COLUMN1ROW3 = 7;
Matrix4.COLUMN2ROW0 = 8;
Matrix4.COLUMN2ROW1 = 9;
Matrix4.COLUMN2ROW2 = 10;
Matrix4.COLUMN2ROW3 = 11;
Matrix4.COLUMN3ROW0 = 12;
Matrix4.COLUMN3ROW1 = 13;
Matrix4.COLUMN3ROW2 = 14;
Matrix4.COLUMN3ROW3 = 15;
Object.defineProperties(Matrix4.prototype, {
  length: {
    get: function() {
      return Matrix4.packedLength;
    }
  }
});
Matrix4.prototype.clone = function(result) {
  return Matrix4.clone(this, result);
};
Matrix4.prototype.equals = function(right) {
  return Matrix4.equals(this, right);
};
Matrix4.equalsArray = function(matrix, array, offset2) {
  return matrix[0] === array[offset2] && matrix[1] === array[offset2 + 1] && matrix[2] === array[offset2 + 2] && matrix[3] === array[offset2 + 3] && matrix[4] === array[offset2 + 4] && matrix[5] === array[offset2 + 5] && matrix[6] === array[offset2 + 6] && matrix[7] === array[offset2 + 7] && matrix[8] === array[offset2 + 8] && matrix[9] === array[offset2 + 9] && matrix[10] === array[offset2 + 10] && matrix[11] === array[offset2 + 11] && matrix[12] === array[offset2 + 12] && matrix[13] === array[offset2 + 13] && matrix[14] === array[offset2 + 14] && matrix[15] === array[offset2 + 15];
};
Matrix4.prototype.equalsEpsilon = function(right, epsilon) {
  return Matrix4.equalsEpsilon(this, right, epsilon);
};
Matrix4.prototype.toString = function() {
  return `(${this[0]}, ${this[4]}, ${this[8]}, ${this[12]})
(${this[1]}, ${this[5]}, ${this[9]}, ${this[13]})
(${this[2]}, ${this[6]}, ${this[10]}, ${this[14]})
(${this[3]}, ${this[7]}, ${this[11]}, ${this[15]})`;
};
var Matrix4_default = Matrix4;

// Source/Core/WebGLConstants.js
var WebGLConstants = {
  DEPTH_BUFFER_BIT: 256,
  STENCIL_BUFFER_BIT: 1024,
  COLOR_BUFFER_BIT: 16384,
  POINTS: 0,
  LINES: 1,
  LINE_LOOP: 2,
  LINE_STRIP: 3,
  TRIANGLES: 4,
  TRIANGLE_STRIP: 5,
  TRIANGLE_FAN: 6,
  ZERO: 0,
  ONE: 1,
  SRC_COLOR: 768,
  ONE_MINUS_SRC_COLOR: 769,
  SRC_ALPHA: 770,
  ONE_MINUS_SRC_ALPHA: 771,
  DST_ALPHA: 772,
  ONE_MINUS_DST_ALPHA: 773,
  DST_COLOR: 774,
  ONE_MINUS_DST_COLOR: 775,
  SRC_ALPHA_SATURATE: 776,
  FUNC_ADD: 32774,
  BLEND_EQUATION: 32777,
  BLEND_EQUATION_RGB: 32777,
  BLEND_EQUATION_ALPHA: 34877,
  FUNC_SUBTRACT: 32778,
  FUNC_REVERSE_SUBTRACT: 32779,
  BLEND_DST_RGB: 32968,
  BLEND_SRC_RGB: 32969,
  BLEND_DST_ALPHA: 32970,
  BLEND_SRC_ALPHA: 32971,
  CONSTANT_COLOR: 32769,
  ONE_MINUS_CONSTANT_COLOR: 32770,
  CONSTANT_ALPHA: 32771,
  ONE_MINUS_CONSTANT_ALPHA: 32772,
  BLEND_COLOR: 32773,
  ARRAY_BUFFER: 34962,
  ELEMENT_ARRAY_BUFFER: 34963,
  ARRAY_BUFFER_BINDING: 34964,
  ELEMENT_ARRAY_BUFFER_BINDING: 34965,
  STREAM_DRAW: 35040,
  STATIC_DRAW: 35044,
  DYNAMIC_DRAW: 35048,
  BUFFER_SIZE: 34660,
  BUFFER_USAGE: 34661,
  CURRENT_VERTEX_ATTRIB: 34342,
  FRONT: 1028,
  BACK: 1029,
  FRONT_AND_BACK: 1032,
  CULL_FACE: 2884,
  BLEND: 3042,
  DITHER: 3024,
  STENCIL_TEST: 2960,
  DEPTH_TEST: 2929,
  SCISSOR_TEST: 3089,
  POLYGON_OFFSET_FILL: 32823,
  SAMPLE_ALPHA_TO_COVERAGE: 32926,
  SAMPLE_COVERAGE: 32928,
  NO_ERROR: 0,
  INVALID_ENUM: 1280,
  INVALID_VALUE: 1281,
  INVALID_OPERATION: 1282,
  OUT_OF_MEMORY: 1285,
  CW: 2304,
  CCW: 2305,
  LINE_WIDTH: 2849,
  ALIASED_POINT_SIZE_RANGE: 33901,
  ALIASED_LINE_WIDTH_RANGE: 33902,
  CULL_FACE_MODE: 2885,
  FRONT_FACE: 2886,
  DEPTH_RANGE: 2928,
  DEPTH_WRITEMASK: 2930,
  DEPTH_CLEAR_VALUE: 2931,
  DEPTH_FUNC: 2932,
  STENCIL_CLEAR_VALUE: 2961,
  STENCIL_FUNC: 2962,
  STENCIL_FAIL: 2964,
  STENCIL_PASS_DEPTH_FAIL: 2965,
  STENCIL_PASS_DEPTH_PASS: 2966,
  STENCIL_REF: 2967,
  STENCIL_VALUE_MASK: 2963,
  STENCIL_WRITEMASK: 2968,
  STENCIL_BACK_FUNC: 34816,
  STENCIL_BACK_FAIL: 34817,
  STENCIL_BACK_PASS_DEPTH_FAIL: 34818,
  STENCIL_BACK_PASS_DEPTH_PASS: 34819,
  STENCIL_BACK_REF: 36003,
  STENCIL_BACK_VALUE_MASK: 36004,
  STENCIL_BACK_WRITEMASK: 36005,
  VIEWPORT: 2978,
  SCISSOR_BOX: 3088,
  COLOR_CLEAR_VALUE: 3106,
  COLOR_WRITEMASK: 3107,
  UNPACK_ALIGNMENT: 3317,
  PACK_ALIGNMENT: 3333,
  MAX_TEXTURE_SIZE: 3379,
  MAX_VIEWPORT_DIMS: 3386,
  SUBPIXEL_BITS: 3408,
  RED_BITS: 3410,
  GREEN_BITS: 3411,
  BLUE_BITS: 3412,
  ALPHA_BITS: 3413,
  DEPTH_BITS: 3414,
  STENCIL_BITS: 3415,
  POLYGON_OFFSET_UNITS: 10752,
  POLYGON_OFFSET_FACTOR: 32824,
  TEXTURE_BINDING_2D: 32873,
  SAMPLE_BUFFERS: 32936,
  SAMPLES: 32937,
  SAMPLE_COVERAGE_VALUE: 32938,
  SAMPLE_COVERAGE_INVERT: 32939,
  COMPRESSED_TEXTURE_FORMATS: 34467,
  DONT_CARE: 4352,
  FASTEST: 4353,
  NICEST: 4354,
  GENERATE_MIPMAP_HINT: 33170,
  BYTE: 5120,
  UNSIGNED_BYTE: 5121,
  SHORT: 5122,
  UNSIGNED_SHORT: 5123,
  INT: 5124,
  UNSIGNED_INT: 5125,
  FLOAT: 5126,
  DEPTH_COMPONENT: 6402,
  ALPHA: 6406,
  RGB: 6407,
  RGBA: 6408,
  LUMINANCE: 6409,
  LUMINANCE_ALPHA: 6410,
  UNSIGNED_SHORT_4_4_4_4: 32819,
  UNSIGNED_SHORT_5_5_5_1: 32820,
  UNSIGNED_SHORT_5_6_5: 33635,
  FRAGMENT_SHADER: 35632,
  VERTEX_SHADER: 35633,
  MAX_VERTEX_ATTRIBS: 34921,
  MAX_VERTEX_UNIFORM_VECTORS: 36347,
  MAX_VARYING_VECTORS: 36348,
  MAX_COMBINED_TEXTURE_IMAGE_UNITS: 35661,
  MAX_VERTEX_TEXTURE_IMAGE_UNITS: 35660,
  MAX_TEXTURE_IMAGE_UNITS: 34930,
  MAX_FRAGMENT_UNIFORM_VECTORS: 36349,
  SHADER_TYPE: 35663,
  DELETE_STATUS: 35712,
  LINK_STATUS: 35714,
  VALIDATE_STATUS: 35715,
  ATTACHED_SHADERS: 35717,
  ACTIVE_UNIFORMS: 35718,
  ACTIVE_ATTRIBUTES: 35721,
  SHADING_LANGUAGE_VERSION: 35724,
  CURRENT_PROGRAM: 35725,
  NEVER: 512,
  LESS: 513,
  EQUAL: 514,
  LEQUAL: 515,
  GREATER: 516,
  NOTEQUAL: 517,
  GEQUAL: 518,
  ALWAYS: 519,
  KEEP: 7680,
  REPLACE: 7681,
  INCR: 7682,
  DECR: 7683,
  INVERT: 5386,
  INCR_WRAP: 34055,
  DECR_WRAP: 34056,
  VENDOR: 7936,
  RENDERER: 7937,
  VERSION: 7938,
  NEAREST: 9728,
  LINEAR: 9729,
  NEAREST_MIPMAP_NEAREST: 9984,
  LINEAR_MIPMAP_NEAREST: 9985,
  NEAREST_MIPMAP_LINEAR: 9986,
  LINEAR_MIPMAP_LINEAR: 9987,
  TEXTURE_MAG_FILTER: 10240,
  TEXTURE_MIN_FILTER: 10241,
  TEXTURE_WRAP_S: 10242,
  TEXTURE_WRAP_T: 10243,
  TEXTURE_2D: 3553,
  TEXTURE: 5890,
  TEXTURE_CUBE_MAP: 34067,
  TEXTURE_BINDING_CUBE_MAP: 34068,
  TEXTURE_CUBE_MAP_POSITIVE_X: 34069,
  TEXTURE_CUBE_MAP_NEGATIVE_X: 34070,
  TEXTURE_CUBE_MAP_POSITIVE_Y: 34071,
  TEXTURE_CUBE_MAP_NEGATIVE_Y: 34072,
  TEXTURE_CUBE_MAP_POSITIVE_Z: 34073,
  TEXTURE_CUBE_MAP_NEGATIVE_Z: 34074,
  MAX_CUBE_MAP_TEXTURE_SIZE: 34076,
  TEXTURE0: 33984,
  TEXTURE1: 33985,
  TEXTURE2: 33986,
  TEXTURE3: 33987,
  TEXTURE4: 33988,
  TEXTURE5: 33989,
  TEXTURE6: 33990,
  TEXTURE7: 33991,
  TEXTURE8: 33992,
  TEXTURE9: 33993,
  TEXTURE10: 33994,
  TEXTURE11: 33995,
  TEXTURE12: 33996,
  TEXTURE13: 33997,
  TEXTURE14: 33998,
  TEXTURE15: 33999,
  TEXTURE16: 34e3,
  TEXTURE17: 34001,
  TEXTURE18: 34002,
  TEXTURE19: 34003,
  TEXTURE20: 34004,
  TEXTURE21: 34005,
  TEXTURE22: 34006,
  TEXTURE23: 34007,
  TEXTURE24: 34008,
  TEXTURE25: 34009,
  TEXTURE26: 34010,
  TEXTURE27: 34011,
  TEXTURE28: 34012,
  TEXTURE29: 34013,
  TEXTURE30: 34014,
  TEXTURE31: 34015,
  ACTIVE_TEXTURE: 34016,
  REPEAT: 10497,
  CLAMP_TO_EDGE: 33071,
  MIRRORED_REPEAT: 33648,
  FLOAT_VEC2: 35664,
  FLOAT_VEC3: 35665,
  FLOAT_VEC4: 35666,
  INT_VEC2: 35667,
  INT_VEC3: 35668,
  INT_VEC4: 35669,
  BOOL: 35670,
  BOOL_VEC2: 35671,
  BOOL_VEC3: 35672,
  BOOL_VEC4: 35673,
  FLOAT_MAT2: 35674,
  FLOAT_MAT3: 35675,
  FLOAT_MAT4: 35676,
  SAMPLER_2D: 35678,
  SAMPLER_CUBE: 35680,
  VERTEX_ATTRIB_ARRAY_ENABLED: 34338,
  VERTEX_ATTRIB_ARRAY_SIZE: 34339,
  VERTEX_ATTRIB_ARRAY_STRIDE: 34340,
  VERTEX_ATTRIB_ARRAY_TYPE: 34341,
  VERTEX_ATTRIB_ARRAY_NORMALIZED: 34922,
  VERTEX_ATTRIB_ARRAY_POINTER: 34373,
  VERTEX_ATTRIB_ARRAY_BUFFER_BINDING: 34975,
  IMPLEMENTATION_COLOR_READ_TYPE: 35738,
  IMPLEMENTATION_COLOR_READ_FORMAT: 35739,
  COMPILE_STATUS: 35713,
  LOW_FLOAT: 36336,
  MEDIUM_FLOAT: 36337,
  HIGH_FLOAT: 36338,
  LOW_INT: 36339,
  MEDIUM_INT: 36340,
  HIGH_INT: 36341,
  FRAMEBUFFER: 36160,
  RENDERBUFFER: 36161,
  RGBA4: 32854,
  RGB5_A1: 32855,
  RGB565: 36194,
  DEPTH_COMPONENT16: 33189,
  STENCIL_INDEX: 6401,
  STENCIL_INDEX8: 36168,
  DEPTH_STENCIL: 34041,
  RENDERBUFFER_WIDTH: 36162,
  RENDERBUFFER_HEIGHT: 36163,
  RENDERBUFFER_INTERNAL_FORMAT: 36164,
  RENDERBUFFER_RED_SIZE: 36176,
  RENDERBUFFER_GREEN_SIZE: 36177,
  RENDERBUFFER_BLUE_SIZE: 36178,
  RENDERBUFFER_ALPHA_SIZE: 36179,
  RENDERBUFFER_DEPTH_SIZE: 36180,
  RENDERBUFFER_STENCIL_SIZE: 36181,
  FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE: 36048,
  FRAMEBUFFER_ATTACHMENT_OBJECT_NAME: 36049,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL: 36050,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE: 36051,
  COLOR_ATTACHMENT0: 36064,
  DEPTH_ATTACHMENT: 36096,
  STENCIL_ATTACHMENT: 36128,
  DEPTH_STENCIL_ATTACHMENT: 33306,
  NONE: 0,
  FRAMEBUFFER_COMPLETE: 36053,
  FRAMEBUFFER_INCOMPLETE_ATTACHMENT: 36054,
  FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT: 36055,
  FRAMEBUFFER_INCOMPLETE_DIMENSIONS: 36057,
  FRAMEBUFFER_UNSUPPORTED: 36061,
  FRAMEBUFFER_BINDING: 36006,
  RENDERBUFFER_BINDING: 36007,
  MAX_RENDERBUFFER_SIZE: 34024,
  INVALID_FRAMEBUFFER_OPERATION: 1286,
  UNPACK_FLIP_Y_WEBGL: 37440,
  UNPACK_PREMULTIPLY_ALPHA_WEBGL: 37441,
  CONTEXT_LOST_WEBGL: 37442,
  UNPACK_COLORSPACE_CONVERSION_WEBGL: 37443,
  BROWSER_DEFAULT_WEBGL: 37444,
  COMPRESSED_RGB_S3TC_DXT1_EXT: 33776,
  COMPRESSED_RGBA_S3TC_DXT1_EXT: 33777,
  COMPRESSED_RGBA_S3TC_DXT3_EXT: 33778,
  COMPRESSED_RGBA_S3TC_DXT5_EXT: 33779,
  COMPRESSED_RGB_PVRTC_4BPPV1_IMG: 35840,
  COMPRESSED_RGB_PVRTC_2BPPV1_IMG: 35841,
  COMPRESSED_RGBA_PVRTC_4BPPV1_IMG: 35842,
  COMPRESSED_RGBA_PVRTC_2BPPV1_IMG: 35843,
  COMPRESSED_RGBA_ASTC_4x4_WEBGL: 37808,
  COMPRESSED_RGB_ETC1_WEBGL: 36196,
  COMPRESSED_RGBA_BPTC_UNORM: 36492,
  HALF_FLOAT_OES: 36193,
  DOUBLE: 5130,
  READ_BUFFER: 3074,
  UNPACK_ROW_LENGTH: 3314,
  UNPACK_SKIP_ROWS: 3315,
  UNPACK_SKIP_PIXELS: 3316,
  PACK_ROW_LENGTH: 3330,
  PACK_SKIP_ROWS: 3331,
  PACK_SKIP_PIXELS: 3332,
  COLOR: 6144,
  DEPTH: 6145,
  STENCIL: 6146,
  RED: 6403,
  RGB8: 32849,
  RGBA8: 32856,
  RGB10_A2: 32857,
  TEXTURE_BINDING_3D: 32874,
  UNPACK_SKIP_IMAGES: 32877,
  UNPACK_IMAGE_HEIGHT: 32878,
  TEXTURE_3D: 32879,
  TEXTURE_WRAP_R: 32882,
  MAX_3D_TEXTURE_SIZE: 32883,
  UNSIGNED_INT_2_10_10_10_REV: 33640,
  MAX_ELEMENTS_VERTICES: 33e3,
  MAX_ELEMENTS_INDICES: 33001,
  TEXTURE_MIN_LOD: 33082,
  TEXTURE_MAX_LOD: 33083,
  TEXTURE_BASE_LEVEL: 33084,
  TEXTURE_MAX_LEVEL: 33085,
  MIN: 32775,
  MAX: 32776,
  DEPTH_COMPONENT24: 33190,
  MAX_TEXTURE_LOD_BIAS: 34045,
  TEXTURE_COMPARE_MODE: 34892,
  TEXTURE_COMPARE_FUNC: 34893,
  CURRENT_QUERY: 34917,
  QUERY_RESULT: 34918,
  QUERY_RESULT_AVAILABLE: 34919,
  STREAM_READ: 35041,
  STREAM_COPY: 35042,
  STATIC_READ: 35045,
  STATIC_COPY: 35046,
  DYNAMIC_READ: 35049,
  DYNAMIC_COPY: 35050,
  MAX_DRAW_BUFFERS: 34852,
  DRAW_BUFFER0: 34853,
  DRAW_BUFFER1: 34854,
  DRAW_BUFFER2: 34855,
  DRAW_BUFFER3: 34856,
  DRAW_BUFFER4: 34857,
  DRAW_BUFFER5: 34858,
  DRAW_BUFFER6: 34859,
  DRAW_BUFFER7: 34860,
  DRAW_BUFFER8: 34861,
  DRAW_BUFFER9: 34862,
  DRAW_BUFFER10: 34863,
  DRAW_BUFFER11: 34864,
  DRAW_BUFFER12: 34865,
  DRAW_BUFFER13: 34866,
  DRAW_BUFFER14: 34867,
  DRAW_BUFFER15: 34868,
  MAX_FRAGMENT_UNIFORM_COMPONENTS: 35657,
  MAX_VERTEX_UNIFORM_COMPONENTS: 35658,
  SAMPLER_3D: 35679,
  SAMPLER_2D_SHADOW: 35682,
  FRAGMENT_SHADER_DERIVATIVE_HINT: 35723,
  PIXEL_PACK_BUFFER: 35051,
  PIXEL_UNPACK_BUFFER: 35052,
  PIXEL_PACK_BUFFER_BINDING: 35053,
  PIXEL_UNPACK_BUFFER_BINDING: 35055,
  FLOAT_MAT2x3: 35685,
  FLOAT_MAT2x4: 35686,
  FLOAT_MAT3x2: 35687,
  FLOAT_MAT3x4: 35688,
  FLOAT_MAT4x2: 35689,
  FLOAT_MAT4x3: 35690,
  SRGB: 35904,
  SRGB8: 35905,
  SRGB8_ALPHA8: 35907,
  COMPARE_REF_TO_TEXTURE: 34894,
  RGBA32F: 34836,
  RGB32F: 34837,
  RGBA16F: 34842,
  RGB16F: 34843,
  VERTEX_ATTRIB_ARRAY_INTEGER: 35069,
  MAX_ARRAY_TEXTURE_LAYERS: 35071,
  MIN_PROGRAM_TEXEL_OFFSET: 35076,
  MAX_PROGRAM_TEXEL_OFFSET: 35077,
  MAX_VARYING_COMPONENTS: 35659,
  TEXTURE_2D_ARRAY: 35866,
  TEXTURE_BINDING_2D_ARRAY: 35869,
  R11F_G11F_B10F: 35898,
  UNSIGNED_INT_10F_11F_11F_REV: 35899,
  RGB9_E5: 35901,
  UNSIGNED_INT_5_9_9_9_REV: 35902,
  TRANSFORM_FEEDBACK_BUFFER_MODE: 35967,
  MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS: 35968,
  TRANSFORM_FEEDBACK_VARYINGS: 35971,
  TRANSFORM_FEEDBACK_BUFFER_START: 35972,
  TRANSFORM_FEEDBACK_BUFFER_SIZE: 35973,
  TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN: 35976,
  RASTERIZER_DISCARD: 35977,
  MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS: 35978,
  MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS: 35979,
  INTERLEAVED_ATTRIBS: 35980,
  SEPARATE_ATTRIBS: 35981,
  TRANSFORM_FEEDBACK_BUFFER: 35982,
  TRANSFORM_FEEDBACK_BUFFER_BINDING: 35983,
  RGBA32UI: 36208,
  RGB32UI: 36209,
  RGBA16UI: 36214,
  RGB16UI: 36215,
  RGBA8UI: 36220,
  RGB8UI: 36221,
  RGBA32I: 36226,
  RGB32I: 36227,
  RGBA16I: 36232,
  RGB16I: 36233,
  RGBA8I: 36238,
  RGB8I: 36239,
  RED_INTEGER: 36244,
  RGB_INTEGER: 36248,
  RGBA_INTEGER: 36249,
  SAMPLER_2D_ARRAY: 36289,
  SAMPLER_2D_ARRAY_SHADOW: 36292,
  SAMPLER_CUBE_SHADOW: 36293,
  UNSIGNED_INT_VEC2: 36294,
  UNSIGNED_INT_VEC3: 36295,
  UNSIGNED_INT_VEC4: 36296,
  INT_SAMPLER_2D: 36298,
  INT_SAMPLER_3D: 36299,
  INT_SAMPLER_CUBE: 36300,
  INT_SAMPLER_2D_ARRAY: 36303,
  UNSIGNED_INT_SAMPLER_2D: 36306,
  UNSIGNED_INT_SAMPLER_3D: 36307,
  UNSIGNED_INT_SAMPLER_CUBE: 36308,
  UNSIGNED_INT_SAMPLER_2D_ARRAY: 36311,
  DEPTH_COMPONENT32F: 36012,
  DEPTH32F_STENCIL8: 36013,
  FLOAT_32_UNSIGNED_INT_24_8_REV: 36269,
  FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING: 33296,
  FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE: 33297,
  FRAMEBUFFER_ATTACHMENT_RED_SIZE: 33298,
  FRAMEBUFFER_ATTACHMENT_GREEN_SIZE: 33299,
  FRAMEBUFFER_ATTACHMENT_BLUE_SIZE: 33300,
  FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE: 33301,
  FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE: 33302,
  FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE: 33303,
  FRAMEBUFFER_DEFAULT: 33304,
  UNSIGNED_INT_24_8: 34042,
  DEPTH24_STENCIL8: 35056,
  UNSIGNED_NORMALIZED: 35863,
  DRAW_FRAMEBUFFER_BINDING: 36006,
  READ_FRAMEBUFFER: 36008,
  DRAW_FRAMEBUFFER: 36009,
  READ_FRAMEBUFFER_BINDING: 36010,
  RENDERBUFFER_SAMPLES: 36011,
  FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER: 36052,
  MAX_COLOR_ATTACHMENTS: 36063,
  COLOR_ATTACHMENT1: 36065,
  COLOR_ATTACHMENT2: 36066,
  COLOR_ATTACHMENT3: 36067,
  COLOR_ATTACHMENT4: 36068,
  COLOR_ATTACHMENT5: 36069,
  COLOR_ATTACHMENT6: 36070,
  COLOR_ATTACHMENT7: 36071,
  COLOR_ATTACHMENT8: 36072,
  COLOR_ATTACHMENT9: 36073,
  COLOR_ATTACHMENT10: 36074,
  COLOR_ATTACHMENT11: 36075,
  COLOR_ATTACHMENT12: 36076,
  COLOR_ATTACHMENT13: 36077,
  COLOR_ATTACHMENT14: 36078,
  COLOR_ATTACHMENT15: 36079,
  FRAMEBUFFER_INCOMPLETE_MULTISAMPLE: 36182,
  MAX_SAMPLES: 36183,
  HALF_FLOAT: 5131,
  RG: 33319,
  RG_INTEGER: 33320,
  R8: 33321,
  RG8: 33323,
  R16F: 33325,
  R32F: 33326,
  RG16F: 33327,
  RG32F: 33328,
  R8I: 33329,
  R8UI: 33330,
  R16I: 33331,
  R16UI: 33332,
  R32I: 33333,
  R32UI: 33334,
  RG8I: 33335,
  RG8UI: 33336,
  RG16I: 33337,
  RG16UI: 33338,
  RG32I: 33339,
  RG32UI: 33340,
  VERTEX_ARRAY_BINDING: 34229,
  R8_SNORM: 36756,
  RG8_SNORM: 36757,
  RGB8_SNORM: 36758,
  RGBA8_SNORM: 36759,
  SIGNED_NORMALIZED: 36764,
  COPY_READ_BUFFER: 36662,
  COPY_WRITE_BUFFER: 36663,
  COPY_READ_BUFFER_BINDING: 36662,
  COPY_WRITE_BUFFER_BINDING: 36663,
  UNIFORM_BUFFER: 35345,
  UNIFORM_BUFFER_BINDING: 35368,
  UNIFORM_BUFFER_START: 35369,
  UNIFORM_BUFFER_SIZE: 35370,
  MAX_VERTEX_UNIFORM_BLOCKS: 35371,
  MAX_FRAGMENT_UNIFORM_BLOCKS: 35373,
  MAX_COMBINED_UNIFORM_BLOCKS: 35374,
  MAX_UNIFORM_BUFFER_BINDINGS: 35375,
  MAX_UNIFORM_BLOCK_SIZE: 35376,
  MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS: 35377,
  MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS: 35379,
  UNIFORM_BUFFER_OFFSET_ALIGNMENT: 35380,
  ACTIVE_UNIFORM_BLOCKS: 35382,
  UNIFORM_TYPE: 35383,
  UNIFORM_SIZE: 35384,
  UNIFORM_BLOCK_INDEX: 35386,
  UNIFORM_OFFSET: 35387,
  UNIFORM_ARRAY_STRIDE: 35388,
  UNIFORM_MATRIX_STRIDE: 35389,
  UNIFORM_IS_ROW_MAJOR: 35390,
  UNIFORM_BLOCK_BINDING: 35391,
  UNIFORM_BLOCK_DATA_SIZE: 35392,
  UNIFORM_BLOCK_ACTIVE_UNIFORMS: 35394,
  UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES: 35395,
  UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER: 35396,
  UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER: 35398,
  INVALID_INDEX: 4294967295,
  MAX_VERTEX_OUTPUT_COMPONENTS: 37154,
  MAX_FRAGMENT_INPUT_COMPONENTS: 37157,
  MAX_SERVER_WAIT_TIMEOUT: 37137,
  OBJECT_TYPE: 37138,
  SYNC_CONDITION: 37139,
  SYNC_STATUS: 37140,
  SYNC_FLAGS: 37141,
  SYNC_FENCE: 37142,
  SYNC_GPU_COMMANDS_COMPLETE: 37143,
  UNSIGNALED: 37144,
  SIGNALED: 37145,
  ALREADY_SIGNALED: 37146,
  TIMEOUT_EXPIRED: 37147,
  CONDITION_SATISFIED: 37148,
  WAIT_FAILED: 37149,
  SYNC_FLUSH_COMMANDS_BIT: 1,
  VERTEX_ATTRIB_ARRAY_DIVISOR: 35070,
  ANY_SAMPLES_PASSED: 35887,
  ANY_SAMPLES_PASSED_CONSERVATIVE: 36202,
  SAMPLER_BINDING: 35097,
  RGB10_A2UI: 36975,
  INT_2_10_10_10_REV: 36255,
  TRANSFORM_FEEDBACK: 36386,
  TRANSFORM_FEEDBACK_PAUSED: 36387,
  TRANSFORM_FEEDBACK_ACTIVE: 36388,
  TRANSFORM_FEEDBACK_BINDING: 36389,
  COMPRESSED_R11_EAC: 37488,
  COMPRESSED_SIGNED_R11_EAC: 37489,
  COMPRESSED_RG11_EAC: 37490,
  COMPRESSED_SIGNED_RG11_EAC: 37491,
  COMPRESSED_RGB8_ETC2: 37492,
  COMPRESSED_SRGB8_ETC2: 37493,
  COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37494,
  COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2: 37495,
  COMPRESSED_RGBA8_ETC2_EAC: 37496,
  COMPRESSED_SRGB8_ALPHA8_ETC2_EAC: 37497,
  TEXTURE_IMMUTABLE_FORMAT: 37167,
  MAX_ELEMENT_INDEX: 36203,
  TEXTURE_IMMUTABLE_LEVELS: 33503,
  MAX_TEXTURE_MAX_ANISOTROPY_EXT: 34047
};
var WebGLConstants_default = Object.freeze(WebGLConstants);

// Source/Renderer/AutomaticUniforms.js
var viewerPositionWCScratch = new Cartesian3_default();
function AutomaticUniform(options) {
  this._size = options.size;
  this._datatype = options.datatype;
  this.getValue = options.getValue;
}
var datatypeToGlsl = {};
datatypeToGlsl[WebGLConstants_default.FLOAT] = "float";
datatypeToGlsl[WebGLConstants_default.FLOAT_VEC2] = "vec2";
datatypeToGlsl[WebGLConstants_default.FLOAT_VEC3] = "vec3";
datatypeToGlsl[WebGLConstants_default.FLOAT_VEC4] = "vec4";
datatypeToGlsl[WebGLConstants_default.INT] = "int";
datatypeToGlsl[WebGLConstants_default.INT_VEC2] = "ivec2";
datatypeToGlsl[WebGLConstants_default.INT_VEC3] = "ivec3";
datatypeToGlsl[WebGLConstants_default.INT_VEC4] = "ivec4";
datatypeToGlsl[WebGLConstants_default.BOOL] = "bool";
datatypeToGlsl[WebGLConstants_default.BOOL_VEC2] = "bvec2";
datatypeToGlsl[WebGLConstants_default.BOOL_VEC3] = "bvec3";
datatypeToGlsl[WebGLConstants_default.BOOL_VEC4] = "bvec4";
datatypeToGlsl[WebGLConstants_default.FLOAT_MAT2] = "mat2";
datatypeToGlsl[WebGLConstants_default.FLOAT_MAT3] = "mat3";
datatypeToGlsl[WebGLConstants_default.FLOAT_MAT4] = "mat4";
datatypeToGlsl[WebGLConstants_default.SAMPLER_2D] = "sampler2D";
datatypeToGlsl[WebGLConstants_default.SAMPLER_CUBE] = "samplerCube";
AutomaticUniform.prototype.getDeclaration = function(name) {
  let declaration = `uniform ${datatypeToGlsl[this._datatype]} ${name}`;
  const size = this._size;
  if (size === 1) {
    declaration += ";";
  } else {
    declaration += `[${size.toString()}];`;
  }
  return declaration;
};
var AutomaticUniforms = {
  czm_viewport: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC4,
    getValue: function(uniformState) {
      return uniformState.viewportCartesian4;
    }
  }),
  czm_viewportOrthographic: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.viewportOrthographic;
    }
  }),
  czm_viewportTransformation: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.viewportTransformation;
    }
  }),
  czm_globeDepthTexture: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_2D,
    getValue: function(uniformState) {
      return uniformState.globeDepthTexture;
    }
  }),
  czm_model: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.model;
    }
  }),
  czm_inverseModel: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseModel;
    }
  }),
  czm_view: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.view;
    }
  }),
  czm_view3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.view3D;
    }
  }),
  czm_viewRotation: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.viewRotation;
    }
  }),
  czm_viewRotation3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.viewRotation3D;
    }
  }),
  czm_inverseView: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseView;
    }
  }),
  czm_inverseView3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseView3D;
    }
  }),
  czm_inverseViewRotation: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.inverseViewRotation;
    }
  }),
  czm_inverseViewRotation3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.inverseViewRotation3D;
    }
  }),
  czm_projection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.projection;
    }
  }),
  czm_inverseProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseProjection;
    }
  }),
  czm_infiniteProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.infiniteProjection;
    }
  }),
  czm_modelView: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelView;
    }
  }),
  czm_modelView3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelView3D;
    }
  }),
  czm_modelViewRelativeToEye: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelViewRelativeToEye;
    }
  }),
  czm_inverseModelView: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseModelView;
    }
  }),
  czm_inverseModelView3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseModelView3D;
    }
  }),
  czm_viewProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.viewProjection;
    }
  }),
  czm_inverseViewProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseViewProjection;
    }
  }),
  czm_modelViewProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelViewProjection;
    }
  }),
  czm_inverseModelViewProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.inverseModelViewProjection;
    }
  }),
  czm_modelViewProjectionRelativeToEye: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelViewProjectionRelativeToEye;
    }
  }),
  czm_modelViewInfiniteProjection: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT4,
    getValue: function(uniformState) {
      return uniformState.modelViewInfiniteProjection;
    }
  }),
  czm_orthographicIn3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.orthographicIn3D ? 1 : 0;
    }
  }),
  czm_normal: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.normal;
    }
  }),
  czm_normal3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.normal3D;
    }
  }),
  czm_inverseNormal: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.inverseNormal;
    }
  }),
  czm_inverseNormal3D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.inverseNormal3D;
    }
  }),
  czm_eyeHeight: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.eyeHeight;
    }
  }),
  czm_eyeHeight2D: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC2,
    getValue: function(uniformState) {
      return uniformState.eyeHeight2D;
    }
  }),
  czm_entireFrustum: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC2,
    getValue: function(uniformState) {
      return uniformState.entireFrustum;
    }
  }),
  czm_currentFrustum: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC2,
    getValue: function(uniformState) {
      return uniformState.currentFrustum;
    }
  }),
  czm_frustumPlanes: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC4,
    getValue: function(uniformState) {
      return uniformState.frustumPlanes;
    }
  }),
  czm_farDepthFromNearPlusOne: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.farDepthFromNearPlusOne;
    }
  }),
  czm_log2FarDepthFromNearPlusOne: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.log2FarDepthFromNearPlusOne;
    }
  }),
  czm_oneOverLog2FarDepthFromNearPlusOne: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.oneOverLog2FarDepthFromNearPlusOne;
    }
  }),
  czm_sunPositionWC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sunPositionWC;
    }
  }),
  czm_sunPositionColumbusView: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sunPositionColumbusView;
    }
  }),
  czm_sunDirectionEC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sunDirectionEC;
    }
  }),
  czm_sunDirectionWC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sunDirectionWC;
    }
  }),
  czm_moonDirectionEC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.moonDirectionEC;
    }
  }),
  czm_lightDirectionEC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.lightDirectionEC;
    }
  }),
  czm_lightDirectionWC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.lightDirectionWC;
    }
  }),
  czm_lightColor: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.lightColor;
    }
  }),
  czm_lightColorHdr: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.lightColorHdr;
    }
  }),
  czm_encodedCameraPositionMCHigh: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.encodedCameraPositionMCHigh;
    }
  }),
  czm_encodedCameraPositionMCLow: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.encodedCameraPositionMCLow;
    }
  }),
  czm_viewerPositionWC: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return Matrix4_default.getTranslation(
        uniformState.inverseView,
        viewerPositionWCScratch
      );
    }
  }),
  czm_frameNumber: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.frameState.frameNumber;
    }
  }),
  czm_morphTime: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.frameState.morphTime;
    }
  }),
  czm_sceneMode: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.frameState.mode;
    }
  }),
  czm_pass: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.pass;
    }
  }),
  czm_backgroundColor: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC4,
    getValue: function(uniformState) {
      return uniformState.backgroundColor;
    }
  }),
  czm_brdfLut: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_2D,
    getValue: function(uniformState) {
      return uniformState.brdfLut;
    }
  }),
  czm_environmentMap: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_CUBE,
    getValue: function(uniformState) {
      return uniformState.environmentMap;
    }
  }),
  czm_specularEnvironmentMaps: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.SAMPLER_2D,
    getValue: function(uniformState) {
      return uniformState.specularEnvironmentMaps;
    }
  }),
  czm_specularEnvironmentMapSize: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC2,
    getValue: function(uniformState) {
      return uniformState.specularEnvironmentMapsDimensions;
    }
  }),
  czm_specularEnvironmentMapsMaximumLOD: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.specularEnvironmentMapsMaximumLOD;
    }
  }),
  czm_sphericalHarmonicCoefficients: new AutomaticUniform({
    size: 9,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.sphericalHarmonicCoefficients;
    }
  }),
  czm_temeToPseudoFixed: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_MAT3,
    getValue: function(uniformState) {
      return uniformState.temeToPseudoFixedMatrix;
    }
  }),
  czm_pixelRatio: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.pixelRatio;
    }
  }),
  czm_fogDensity: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.fogDensity;
    }
  }),
  czm_splitPosition: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.splitPosition;
    }
  }),
  czm_geometricToleranceOverMeter: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.geometricToleranceOverMeter;
    }
  }),
  czm_minimumDisableDepthTestDistance: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.minimumDisableDepthTestDistance;
    }
  }),
  czm_invertClassificationColor: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC4,
    getValue: function(uniformState) {
      return uniformState.invertClassificationColor;
    }
  }),
  czm_gamma: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT,
    getValue: function(uniformState) {
      return uniformState.gamma;
    }
  }),
  czm_ellipsoidRadii: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.ellipsoid.radii;
    }
  }),
  czm_ellipsoidInverseRadii: new AutomaticUniform({
    size: 1,
    datatype: WebGLConstants_default.FLOAT_VEC3,
    getValue: function(uniformState) {
      return uniformState.ellipsoid.oneOverRadii;
    }
  })
};
var AutomaticUniforms_default = AutomaticUniforms;

// Source/Core/createGuid.js
function createGuid() {
  return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c) {
    const r = Math.random() * 16 | 0;
    const v7 = c === "x" ? r : r & 3 | 8;
    return v7.toString(16);
  });
}
var createGuid_default = createGuid;

// Source/Core/destroyObject.js
function returnTrue() {
  return true;
}
function destroyObject(object, message) {
  message = defaultValue_default(
    message,
    "This object was destroyed, i.e., destroy() was called."
  );
  function throwOnDestroyed() {
    throw new DeveloperError_default(message);
  }
  for (const key in object) {
    if (typeof object[key] === "function") {
      object[key] = throwOnDestroyed;
    }
  }
  object.isDestroyed = returnTrue;
  return void 0;
}
var destroyObject_default = destroyObject;

// Source/Core/IndexDatatype.js
var IndexDatatype = {
  UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
  UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
  UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT
};
IndexDatatype.getSizeInBytes = function(indexDatatype) {
  switch (indexDatatype) {
    case IndexDatatype.UNSIGNED_BYTE:
      return Uint8Array.BYTES_PER_ELEMENT;
    case IndexDatatype.UNSIGNED_SHORT:
      return Uint16Array.BYTES_PER_ELEMENT;
    case IndexDatatype.UNSIGNED_INT:
      return Uint32Array.BYTES_PER_ELEMENT;
  }
  throw new DeveloperError_default(
    "indexDatatype is required and must be a valid IndexDatatype constant."
  );
};
IndexDatatype.fromSizeInBytes = function(sizeInBytes) {
  switch (sizeInBytes) {
    case 2:
      return IndexDatatype.UNSIGNED_SHORT;
    case 4:
      return IndexDatatype.UNSIGNED_INT;
    case 1:
      return IndexDatatype.UNSIGNED_BYTE;
    default:
      throw new DeveloperError_default(
        "Size in bytes cannot be mapped to an IndexDatatype"
      );
  }
};
IndexDatatype.validate = function(indexDatatype) {
  return defined_default(indexDatatype) && (indexDatatype === IndexDatatype.UNSIGNED_BYTE || indexDatatype === IndexDatatype.UNSIGNED_SHORT || indexDatatype === IndexDatatype.UNSIGNED_INT);
};
IndexDatatype.createTypedArray = function(numberOfVertices, indicesLengthOrArray) {
  if (!defined_default(numberOfVertices)) {
    throw new DeveloperError_default("numberOfVertices is required.");
  }
  if (numberOfVertices >= Math_default.SIXTY_FOUR_KILOBYTES) {
    return new Uint32Array(indicesLengthOrArray);
  }
  return new Uint16Array(indicesLengthOrArray);
};
IndexDatatype.createTypedArrayFromArrayBuffer = function(numberOfVertices, sourceArray, byteOffset, length3) {
  if (!defined_default(numberOfVertices)) {
    throw new DeveloperError_default("numberOfVertices is required.");
  }
  if (!defined_default(sourceArray)) {
    throw new DeveloperError_default("sourceArray is required.");
  }
  if (!defined_default(byteOffset)) {
    throw new DeveloperError_default("byteOffset is required.");
  }
  if (numberOfVertices >= Math_default.SIXTY_FOUR_KILOBYTES) {
    return new Uint32Array(sourceArray, byteOffset, length3);
  }
  return new Uint16Array(sourceArray, byteOffset, length3);
};
IndexDatatype.fromTypedArray = function(array) {
  if (array instanceof Uint8Array) {
    return IndexDatatype.UNSIGNED_BYTE;
  }
  if (array instanceof Uint16Array) {
    return IndexDatatype.UNSIGNED_SHORT;
  }
  if (array instanceof Uint32Array) {
    return IndexDatatype.UNSIGNED_INT;
  }
  throw new DeveloperError_default(
    "array must be a Uint8Array, Uint16Array, or Uint32Array."
  );
};
var IndexDatatype_default = Object.freeze(IndexDatatype);

// Source/Renderer/BufferUsage.js
var BufferUsage = {
  STREAM_DRAW: WebGLConstants_default.STREAM_DRAW,
  STATIC_DRAW: WebGLConstants_default.STATIC_DRAW,
  DYNAMIC_DRAW: WebGLConstants_default.DYNAMIC_DRAW,
  validate: function(bufferUsage) {
    return bufferUsage === BufferUsage.STREAM_DRAW || bufferUsage === BufferUsage.STATIC_DRAW || bufferUsage === BufferUsage.DYNAMIC_DRAW;
  }
};
var BufferUsage_default = Object.freeze(BufferUsage);

// Source/Renderer/Buffer.js
function Buffer2(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  Check_default.defined("options.context", options.context);
  if (!defined_default(options.typedArray) && !defined_default(options.sizeInBytes)) {
    throw new DeveloperError_default(
      "Either options.sizeInBytes or options.typedArray is required."
    );
  }
  if (defined_default(options.typedArray) && defined_default(options.sizeInBytes)) {
    throw new DeveloperError_default(
      "Cannot pass in both options.sizeInBytes and options.typedArray."
    );
  }
  if (defined_default(options.typedArray)) {
    Check_default.typeOf.object("options.typedArray", options.typedArray);
    Check_default.typeOf.number(
      "options.typedArray.byteLength",
      options.typedArray.byteLength
    );
  }
  if (!BufferUsage_default.validate(options.usage)) {
    throw new DeveloperError_default("usage is invalid.");
  }
  const gl = options.context._gl;
  const bufferTarget = options.bufferTarget;
  const typedArray = options.typedArray;
  let sizeInBytes = options.sizeInBytes;
  const usage = options.usage;
  const hasArray = defined_default(typedArray);
  if (hasArray) {
    sizeInBytes = typedArray.byteLength;
  }
  Check_default.typeOf.number.greaterThan("sizeInBytes", sizeInBytes, 0);
  const buffer = gl.createBuffer();
  gl.bindBuffer(bufferTarget, buffer);
  gl.bufferData(bufferTarget, hasArray ? typedArray : sizeInBytes, usage);
  gl.bindBuffer(bufferTarget, null);
  this._id = createGuid_default();
  this._gl = gl;
  this._webgl2 = options.context._webgl2;
  this._bufferTarget = bufferTarget;
  this._sizeInBytes = sizeInBytes;
  this._usage = usage;
  this._buffer = buffer;
  this.vertexArrayDestroyable = true;
}
Buffer2.createVertexBuffer = function(options) {
  Check_default.defined("options.context", options.context);
  return new Buffer2({
    context: options.context,
    bufferTarget: WebGLConstants_default.ARRAY_BUFFER,
    typedArray: options.typedArray,
    sizeInBytes: options.sizeInBytes,
    usage: options.usage
  });
};
Buffer2.createIndexBuffer = function(options) {
  Check_default.defined("options.context", options.context);
  if (!IndexDatatype_default.validate(options.indexDatatype)) {
    throw new DeveloperError_default("Invalid indexDatatype.");
  }
  if (options.indexDatatype === IndexDatatype_default.UNSIGNED_INT && !options.context.elementIndexUint) {
    throw new DeveloperError_default(
      "IndexDatatype.UNSIGNED_INT requires OES_element_index_uint, which is not supported on this system.  Check context.elementIndexUint."
    );
  }
  const context = options.context;
  const indexDatatype = options.indexDatatype;
  const bytesPerIndex = IndexDatatype_default.getSizeInBytes(indexDatatype);
  const buffer = new Buffer2({
    context,
    bufferTarget: WebGLConstants_default.ELEMENT_ARRAY_BUFFER,
    typedArray: options.typedArray,
    sizeInBytes: options.sizeInBytes,
    usage: options.usage
  });
  const numberOfIndices = buffer.sizeInBytes / bytesPerIndex;
  Object.defineProperties(buffer, {
    indexDatatype: {
      get: function() {
        return indexDatatype;
      }
    },
    bytesPerIndex: {
      get: function() {
        return bytesPerIndex;
      }
    },
    numberOfIndices: {
      get: function() {
        return numberOfIndices;
      }
    }
  });
  return buffer;
};
Object.defineProperties(Buffer2.prototype, {
  sizeInBytes: {
    get: function() {
      return this._sizeInBytes;
    }
  },
  usage: {
    get: function() {
      return this._usage;
    }
  }
});
Buffer2.prototype._getBuffer = function() {
  return this._buffer;
};
Buffer2.prototype.copyFromArrayView = function(arrayView, offsetInBytes) {
  offsetInBytes = defaultValue_default(offsetInBytes, 0);
  Check_default.defined("arrayView", arrayView);
  Check_default.typeOf.number.lessThanOrEquals(
    "offsetInBytes + arrayView.byteLength",
    offsetInBytes + arrayView.byteLength,
    this._sizeInBytes
  );
  const gl = this._gl;
  const target = this._bufferTarget;
  gl.bindBuffer(target, this._buffer);
  gl.bufferSubData(target, offsetInBytes, arrayView);
  gl.bindBuffer(target, null);
};
Buffer2.prototype.copyFromBuffer = function(readBuffer, readOffset, writeOffset, sizeInBytes) {
  if (!this._webgl2) {
    throw new DeveloperError_default("A WebGL 2 context is required.");
  }
  if (!defined_default(readBuffer)) {
    throw new DeveloperError_default("readBuffer must be defined.");
  }
  if (!defined_default(sizeInBytes) || sizeInBytes <= 0) {
    throw new DeveloperError_default(
      "sizeInBytes must be defined and be greater than zero."
    );
  }
  if (!defined_default(readOffset) || readOffset < 0 || readOffset + sizeInBytes > readBuffer._sizeInBytes) {
    throw new DeveloperError_default(
      "readOffset must be greater than or equal to zero and readOffset + sizeInBytes must be less than of equal to readBuffer.sizeInBytes."
    );
  }
  if (!defined_default(writeOffset) || writeOffset < 0 || writeOffset + sizeInBytes > this._sizeInBytes) {
    throw new DeveloperError_default(
      "writeOffset must be greater than or equal to zero and writeOffset + sizeInBytes must be less than of equal to this.sizeInBytes."
    );
  }
  if (this._buffer === readBuffer._buffer && (writeOffset >= readOffset && writeOffset < readOffset + sizeInBytes || readOffset > writeOffset && readOffset < writeOffset + sizeInBytes)) {
    throw new DeveloperError_default(
      "When readBuffer is equal to this, the ranges [readOffset + sizeInBytes) and [writeOffset, writeOffset + sizeInBytes) must not overlap."
    );
  }
  if (this._bufferTarget === WebGLConstants_default.ELEMENT_ARRAY_BUFFER && readBuffer._bufferTarget !== WebGLConstants_default.ELEMENT_ARRAY_BUFFER || this._bufferTarget !== WebGLConstants_default.ELEMENT_ARRAY_BUFFER && readBuffer._bufferTarget === WebGLConstants_default.ELEMENT_ARRAY_BUFFER) {
    throw new DeveloperError_default(
      "Can not copy an index buffer into another buffer type."
    );
  }
  const readTarget = WebGLConstants_default.COPY_READ_BUFFER;
  const writeTarget = WebGLConstants_default.COPY_WRITE_BUFFER;
  const gl = this._gl;
  gl.bindBuffer(writeTarget, this._buffer);
  gl.bindBuffer(readTarget, readBuffer._buffer);
  gl.copyBufferSubData(
    readTarget,
    writeTarget,
    readOffset,
    writeOffset,
    sizeInBytes
  );
  gl.bindBuffer(writeTarget, null);
  gl.bindBuffer(readTarget, null);
};
Buffer2.prototype.getBufferData = function(arrayView, sourceOffset, destinationOffset, length3) {
  sourceOffset = defaultValue_default(sourceOffset, 0);
  destinationOffset = defaultValue_default(destinationOffset, 0);
  if (!this._webgl2) {
    throw new DeveloperError_default("A WebGL 2 context is required.");
  }
  if (!defined_default(arrayView)) {
    throw new DeveloperError_default("arrayView is required.");
  }
  let copyLength;
  let elementSize;
  let arrayLength = arrayView.byteLength;
  if (!defined_default(length3)) {
    if (defined_default(arrayLength)) {
      copyLength = arrayLength - destinationOffset;
      elementSize = 1;
    } else {
      arrayLength = arrayView.length;
      copyLength = arrayLength - destinationOffset;
      elementSize = arrayView.BYTES_PER_ELEMENT;
    }
  } else {
    copyLength = length3;
    if (defined_default(arrayLength)) {
      elementSize = 1;
    } else {
      arrayLength = arrayView.length;
      elementSize = arrayView.BYTES_PER_ELEMENT;
    }
  }
  if (destinationOffset < 0 || destinationOffset > arrayLength) {
    throw new DeveloperError_default(
      "destinationOffset must be greater than zero and less than the arrayView length."
    );
  }
  if (destinationOffset + copyLength > arrayLength) {
    throw new DeveloperError_default(
      "destinationOffset + length must be less than or equal to the arrayViewLength."
    );
  }
  if (sourceOffset < 0 || sourceOffset > this._sizeInBytes) {
    throw new DeveloperError_default(
      "sourceOffset must be greater than zero and less than the buffers size."
    );
  }
  if (sourceOffset + copyLength * elementSize > this._sizeInBytes) {
    throw new DeveloperError_default(
      "sourceOffset + length must be less than the buffers size."
    );
  }
  const gl = this._gl;
  const target = WebGLConstants_default.COPY_READ_BUFFER;
  gl.bindBuffer(target, this._buffer);
  gl.getBufferSubData(
    target,
    sourceOffset,
    arrayView,
    destinationOffset,
    length3
  );
  gl.bindBuffer(target, null);
};
Buffer2.prototype.isDestroyed = function() {
  return false;
};
Buffer2.prototype.destroy = function() {
  this._gl.deleteBuffer(this._buffer);
  return destroyObject_default(this);
};
var Buffer_default = Buffer2;

// Source/Core/Fullscreen.js
var _supportsFullscreen;
var _names = {
  requestFullscreen: void 0,
  exitFullscreen: void 0,
  fullscreenEnabled: void 0,
  fullscreenElement: void 0,
  fullscreenchange: void 0,
  fullscreenerror: void 0
};
var Fullscreen = {};
Object.defineProperties(Fullscreen, {
  element: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return document[_names.fullscreenElement];
    }
  },
  changeEventName: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return _names.fullscreenchange;
    }
  },
  errorEventName: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return _names.fullscreenerror;
    }
  },
  enabled: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return document[_names.fullscreenEnabled];
    }
  },
  fullscreen: {
    get: function() {
      if (!Fullscreen.supportsFullscreen()) {
        return void 0;
      }
      return Fullscreen.element !== null;
    }
  }
});
Fullscreen.supportsFullscreen = function() {
  if (defined_default(_supportsFullscreen)) {
    return _supportsFullscreen;
  }
  _supportsFullscreen = false;
  const body = document.body;
  if (typeof body.requestFullscreen === "function") {
    _names.requestFullscreen = "requestFullscreen";
    _names.exitFullscreen = "exitFullscreen";
    _names.fullscreenEnabled = "fullscreenEnabled";
    _names.fullscreenElement = "fullscreenElement";
    _names.fullscreenchange = "fullscreenchange";
    _names.fullscreenerror = "fullscreenerror";
    _supportsFullscreen = true;
    return _supportsFullscreen;
  }
  const prefixes = ["webkit", "moz", "o", "ms", "khtml"];
  let name;
  for (let i = 0, len = prefixes.length; i < len; ++i) {
    const prefix = prefixes[i];
    name = `${prefix}RequestFullscreen`;
    if (typeof body[name] === "function") {
      _names.requestFullscreen = name;
      _supportsFullscreen = true;
    } else {
      name = `${prefix}RequestFullScreen`;
      if (typeof body[name] === "function") {
        _names.requestFullscreen = name;
        _supportsFullscreen = true;
      }
    }
    name = `${prefix}ExitFullscreen`;
    if (typeof document[name] === "function") {
      _names.exitFullscreen = name;
    } else {
      name = `${prefix}CancelFullScreen`;
      if (typeof document[name] === "function") {
        _names.exitFullscreen = name;
      }
    }
    name = `${prefix}FullscreenEnabled`;
    if (document[name] !== void 0) {
      _names.fullscreenEnabled = name;
    } else {
      name = `${prefix}FullScreenEnabled`;
      if (document[name] !== void 0) {
        _names.fullscreenEnabled = name;
      }
    }
    name = `${prefix}FullscreenElement`;
    if (document[name] !== void 0) {
      _names.fullscreenElement = name;
    } else {
      name = `${prefix}FullScreenElement`;
      if (document[name] !== void 0) {
        _names.fullscreenElement = name;
      }
    }
    name = `${prefix}fullscreenchange`;
    if (document[`on${name}`] !== void 0) {
      if (prefix === "ms") {
        name = "MSFullscreenChange";
      }
      _names.fullscreenchange = name;
    }
    name = `${prefix}fullscreenerror`;
    if (document[`on${name}`] !== void 0) {
      if (prefix === "ms") {
        name = "MSFullscreenError";
      }
      _names.fullscreenerror = name;
    }
  }
  return _supportsFullscreen;
};
Fullscreen.requestFullscreen = function(element, vrDevice) {
  if (!Fullscreen.supportsFullscreen()) {
    return;
  }
  element[_names.requestFullscreen]({ vrDisplay: vrDevice });
};
Fullscreen.exitFullscreen = function() {
  if (!Fullscreen.supportsFullscreen()) {
    return;
  }
  document[_names.exitFullscreen]();
};
Fullscreen._names = _names;
var Fullscreen_default = Fullscreen;

// Source/Core/FeatureDetection.js
var theNavigator;
if (typeof navigator !== "undefined") {
  theNavigator = navigator;
} else {
  theNavigator = {};
}
function extractVersion(versionString) {
  const parts = versionString.split(".");
  for (let i = 0, len = parts.length; i < len; ++i) {
    parts[i] = parseInt(parts[i], 10);
  }
  return parts;
}
var isChromeResult;
var chromeVersionResult;
function isChrome() {
  if (!defined_default(isChromeResult)) {
    isChromeResult = false;
    if (!isEdge()) {
      const fields = / Chrome\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isChromeResult = true;
        chromeVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isChromeResult;
}
function chromeVersion() {
  return isChrome() && chromeVersionResult;
}
var isSafariResult;
var safariVersionResult;
function isSafari() {
  if (!defined_default(isSafariResult)) {
    isSafariResult = false;
    if (!isChrome() && !isEdge() && / Safari\/[\.0-9]+/.test(theNavigator.userAgent)) {
      const fields = / Version\/([\.0-9]+)/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isSafariResult = true;
        safariVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isSafariResult;
}
function safariVersion() {
  return isSafari() && safariVersionResult;
}
var isWebkitResult;
var webkitVersionResult;
function isWebkit() {
  if (!defined_default(isWebkitResult)) {
    isWebkitResult = false;
    const fields = / AppleWebKit\/([\.0-9]+)(\+?)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isWebkitResult = true;
      webkitVersionResult = extractVersion(fields[1]);
      webkitVersionResult.isNightly = !!fields[2];
    }
  }
  return isWebkitResult;
}
function webkitVersion() {
  return isWebkit() && webkitVersionResult;
}
var isInternetExplorerResult;
var internetExplorerVersionResult;
function isInternetExplorer() {
  if (!defined_default(isInternetExplorerResult)) {
    isInternetExplorerResult = false;
    let fields;
    if (theNavigator.appName === "Microsoft Internet Explorer") {
      fields = /MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(theNavigator.userAgent);
      if (fields !== null) {
        isInternetExplorerResult = true;
        internetExplorerVersionResult = extractVersion(fields[1]);
      }
    } else if (theNavigator.appName === "Netscape") {
      fields = /Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(
        theNavigator.userAgent
      );
      if (fields !== null) {
        isInternetExplorerResult = true;
        internetExplorerVersionResult = extractVersion(fields[1]);
      }
    }
  }
  return isInternetExplorerResult;
}
function internetExplorerVersion() {
  return isInternetExplorer() && internetExplorerVersionResult;
}
var isEdgeResult;
var edgeVersionResult;
function isEdge() {
  if (!defined_default(isEdgeResult)) {
    isEdgeResult = false;
    const fields = / Edg\/([\.0-9]+)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isEdgeResult = true;
      edgeVersionResult = extractVersion(fields[1]);
    }
  }
  return isEdgeResult;
}
function edgeVersion() {
  return isEdge() && edgeVersionResult;
}
var isFirefoxResult;
var firefoxVersionResult;
function isFirefox() {
  if (!defined_default(isFirefoxResult)) {
    isFirefoxResult = false;
    const fields = /Firefox\/([\.0-9]+)/.exec(theNavigator.userAgent);
    if (fields !== null) {
      isFirefoxResult = true;
      firefoxVersionResult = extractVersion(fields[1]);
    }
  }
  return isFirefoxResult;
}
var isWindowsResult;
function isWindows() {
  if (!defined_default(isWindowsResult)) {
    isWindowsResult = /Windows/i.test(theNavigator.appVersion);
  }
  return isWindowsResult;
}
var isIPadOrIOSResult;
function isIPadOrIOS() {
  if (!defined_default(isIPadOrIOSResult)) {
    isIPadOrIOSResult = navigator.platform === "iPhone" || navigator.platform === "iPod" || navigator.platform === "iPad";
  }
  return isIPadOrIOSResult;
}
function firefoxVersion() {
  return isFirefox() && firefoxVersionResult;
}
var hasPointerEvents;
function supportsPointerEvents() {
  if (!defined_default(hasPointerEvents)) {
    hasPointerEvents = !isFirefox() && typeof PointerEvent !== "undefined" && (!defined_default(theNavigator.pointerEnabled) || theNavigator.pointerEnabled);
  }
  return hasPointerEvents;
}
var imageRenderingValueResult;
var supportsImageRenderingPixelatedResult;
function supportsImageRenderingPixelated() {
  if (!defined_default(supportsImageRenderingPixelatedResult)) {
    const canvas = document.createElement("canvas");
    canvas.setAttribute(
      "style",
      "image-rendering: -moz-crisp-edges;image-rendering: pixelated;"
    );
    const tmp2 = canvas.style.imageRendering;
    supportsImageRenderingPixelatedResult = defined_default(tmp2) && tmp2 !== "";
    if (supportsImageRenderingPixelatedResult) {
      imageRenderingValueResult = tmp2;
    }
  }
  return supportsImageRenderingPixelatedResult;
}
function imageRenderingValue() {
  return supportsImageRenderingPixelated() ? imageRenderingValueResult : void 0;
}
function supportsWebP() {
  if (!supportsWebP.initialized) {
    throw new DeveloperError_default(
      "You must call FeatureDetection.supportsWebP.initialize and wait for the promise to resolve before calling FeatureDetection.supportsWebP"
    );
  }
  return supportsWebP._result;
}
supportsWebP._promise = void 0;
supportsWebP._result = void 0;
supportsWebP.initialize = function() {
  if (defined_default(supportsWebP._promise)) {
    return supportsWebP._promise;
  }
  supportsWebP._promise = new Promise((resolve2) => {
    const image = new Image();
    image.onload = function() {
      supportsWebP._result = image.width > 0 && image.height > 0;
      resolve2(supportsWebP._result);
    };
    image.onerror = function() {
      supportsWebP._result = false;
      resolve2(supportsWebP._result);
    };
    image.src = "data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA";
  });
  return supportsWebP._promise;
};
Object.defineProperties(supportsWebP, {
  initialized: {
    get: function() {
      return defined_default(supportsWebP._result);
    }
  }
});
var typedArrayTypes = [];
if (typeof ArrayBuffer !== "undefined") {
  typedArrayTypes.push(
    Int8Array,
    Uint8Array,
    Int16Array,
    Uint16Array,
    Int32Array,
    Uint32Array,
    Float32Array,
    Float64Array
  );
  if (typeof Uint8ClampedArray !== "undefined") {
    typedArrayTypes.push(Uint8ClampedArray);
  }
  if (typeof Uint8ClampedArray !== "undefined") {
    typedArrayTypes.push(Uint8ClampedArray);
  }
  if (typeof BigInt64Array !== "undefined") {
    typedArrayTypes.push(BigInt64Array);
  }
  if (typeof BigUint64Array !== "undefined") {
    typedArrayTypes.push(BigUint64Array);
  }
}
var FeatureDetection = {
  isChrome,
  chromeVersion,
  isSafari,
  safariVersion,
  isWebkit,
  webkitVersion,
  isInternetExplorer,
  internetExplorerVersion,
  isEdge,
  edgeVersion,
  isFirefox,
  firefoxVersion,
  isWindows,
  isIPadOrIOS,
  hardwareConcurrency: defaultValue_default(theNavigator.hardwareConcurrency, 3),
  supportsPointerEvents,
  supportsImageRenderingPixelated,
  supportsWebP,
  imageRenderingValue,
  typedArrayTypes
};
FeatureDetection.supportsBasis = function(scene) {
  return FeatureDetection.supportsWebAssembly() && scene.context.supportsBasis;
};
FeatureDetection.supportsFullscreen = function() {
  return Fullscreen_default.supportsFullscreen();
};
FeatureDetection.supportsTypedArrays = function() {
  return typeof ArrayBuffer !== "undefined";
};
FeatureDetection.supportsBigInt64Array = function() {
  return typeof BigInt64Array !== "undefined";
};
FeatureDetection.supportsBigUint64Array = function() {
  return typeof BigUint64Array !== "undefined";
};
FeatureDetection.supportsBigInt = function() {
  return typeof BigInt !== "undefined";
};
FeatureDetection.supportsWebWorkers = function() {
  return typeof Worker !== "undefined";
};
FeatureDetection.supportsWebAssembly = function() {
  return typeof WebAssembly !== "undefined";
};
var FeatureDetection_default = FeatureDetection;

// Source/Core/Color.js
function hue2rgb(m1, m2, h) {
  if (h < 0) {
    h += 1;
  }
  if (h > 1) {
    h -= 1;
  }
  if (h * 6 < 1) {
    return m1 + (m2 - m1) * 6 * h;
  }
  if (h * 2 < 1) {
    return m2;
  }
  if (h * 3 < 2) {
    return m1 + (m2 - m1) * (2 / 3 - h) * 6;
  }
  return m1;
}
function Color(red, green, blue, alpha) {
  this.red = defaultValue_default(red, 1);
  this.green = defaultValue_default(green, 1);
  this.blue = defaultValue_default(blue, 1);
  this.alpha = defaultValue_default(alpha, 1);
}
Color.fromCartesian4 = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  if (!defined_default(result)) {
    return new Color(cartesian11.x, cartesian11.y, cartesian11.z, cartesian11.w);
  }
  result.red = cartesian11.x;
  result.green = cartesian11.y;
  result.blue = cartesian11.z;
  result.alpha = cartesian11.w;
  return result;
};
Color.fromBytes = function(red, green, blue, alpha, result) {
  red = Color.byteToFloat(defaultValue_default(red, 255));
  green = Color.byteToFloat(defaultValue_default(green, 255));
  blue = Color.byteToFloat(defaultValue_default(blue, 255));
  alpha = Color.byteToFloat(defaultValue_default(alpha, 255));
  if (!defined_default(result)) {
    return new Color(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
Color.fromAlpha = function(color, alpha, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("alpha", alpha);
  if (!defined_default(result)) {
    return new Color(color.red, color.green, color.blue, alpha);
  }
  result.red = color.red;
  result.green = color.green;
  result.blue = color.blue;
  result.alpha = alpha;
  return result;
};
var scratchArrayBuffer;
var scratchUint32Array;
var scratchUint8Array;
if (FeatureDetection_default.supportsTypedArrays()) {
  scratchArrayBuffer = new ArrayBuffer(4);
  scratchUint32Array = new Uint32Array(scratchArrayBuffer);
  scratchUint8Array = new Uint8Array(scratchArrayBuffer);
}
Color.fromRgba = function(rgba, result) {
  scratchUint32Array[0] = rgba;
  return Color.fromBytes(
    scratchUint8Array[0],
    scratchUint8Array[1],
    scratchUint8Array[2],
    scratchUint8Array[3],
    result
  );
};
Color.fromHsl = function(hue, saturation, lightness, alpha, result) {
  hue = defaultValue_default(hue, 0) % 1;
  saturation = defaultValue_default(saturation, 0);
  lightness = defaultValue_default(lightness, 0);
  alpha = defaultValue_default(alpha, 1);
  let red = lightness;
  let green = lightness;
  let blue = lightness;
  if (saturation !== 0) {
    let m2;
    if (lightness < 0.5) {
      m2 = lightness * (1 + saturation);
    } else {
      m2 = lightness + saturation - lightness * saturation;
    }
    const m1 = 2 * lightness - m2;
    red = hue2rgb(m1, m2, hue + 1 / 3);
    green = hue2rgb(m1, m2, hue);
    blue = hue2rgb(m1, m2, hue - 1 / 3);
  }
  if (!defined_default(result)) {
    return new Color(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
Color.fromRandom = function(options, result) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  let red = options.red;
  if (!defined_default(red)) {
    const minimumRed = defaultValue_default(options.minimumRed, 0);
    const maximumRed = defaultValue_default(options.maximumRed, 1);
    Check_default.typeOf.number.lessThanOrEquals("minimumRed", minimumRed, maximumRed);
    red = minimumRed + Math_default.nextRandomNumber() * (maximumRed - minimumRed);
  }
  let green = options.green;
  if (!defined_default(green)) {
    const minimumGreen = defaultValue_default(options.minimumGreen, 0);
    const maximumGreen = defaultValue_default(options.maximumGreen, 1);
    Check_default.typeOf.number.lessThanOrEquals(
      "minimumGreen",
      minimumGreen,
      maximumGreen
    );
    green = minimumGreen + Math_default.nextRandomNumber() * (maximumGreen - minimumGreen);
  }
  let blue = options.blue;
  if (!defined_default(blue)) {
    const minimumBlue = defaultValue_default(options.minimumBlue, 0);
    const maximumBlue = defaultValue_default(options.maximumBlue, 1);
    Check_default.typeOf.number.lessThanOrEquals(
      "minimumBlue",
      minimumBlue,
      maximumBlue
    );
    blue = minimumBlue + Math_default.nextRandomNumber() * (maximumBlue - minimumBlue);
  }
  let alpha = options.alpha;
  if (!defined_default(alpha)) {
    const minimumAlpha = defaultValue_default(options.minimumAlpha, 0);
    const maximumAlpha = defaultValue_default(options.maximumAlpha, 1);
    Check_default.typeOf.number.lessThanOrEquals(
      "minumumAlpha",
      minimumAlpha,
      maximumAlpha
    );
    alpha = minimumAlpha + Math_default.nextRandomNumber() * (maximumAlpha - minimumAlpha);
  }
  if (!defined_default(result)) {
    return new Color(red, green, blue, alpha);
  }
  result.red = red;
  result.green = green;
  result.blue = blue;
  result.alpha = alpha;
  return result;
};
var rgbaMatcher = /^#([0-9a-f])([0-9a-f])([0-9a-f])([0-9a-f])?$/i;
var rrggbbaaMatcher = /^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i;
var rgbParenthesesMatcher = /^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i;
var hslParenthesesMatcher = /^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;
Color.fromCssColorString = function(color, result) {
  Check_default.typeOf.string("color", color);
  if (!defined_default(result)) {
    result = new Color();
  }
  color = color.replace(/\s/g, "");
  const namedColor = Color[color.toUpperCase()];
  if (defined_default(namedColor)) {
    Color.clone(namedColor, result);
    return result;
  }
  let matches = rgbaMatcher.exec(color);
  if (matches !== null) {
    result.red = parseInt(matches[1], 16) / 15;
    result.green = parseInt(matches[2], 16) / 15;
    result.blue = parseInt(matches[3], 16) / 15;
    result.alpha = parseInt(defaultValue_default(matches[4], "f"), 16) / 15;
    return result;
  }
  matches = rrggbbaaMatcher.exec(color);
  if (matches !== null) {
    result.red = parseInt(matches[1], 16) / 255;
    result.green = parseInt(matches[2], 16) / 255;
    result.blue = parseInt(matches[3], 16) / 255;
    result.alpha = parseInt(defaultValue_default(matches[4], "ff"), 16) / 255;
    return result;
  }
  matches = rgbParenthesesMatcher.exec(color);
  if (matches !== null) {
    result.red = parseFloat(matches[1]) / ("%" === matches[1].substr(-1) ? 100 : 255);
    result.green = parseFloat(matches[2]) / ("%" === matches[2].substr(-1) ? 100 : 255);
    result.blue = parseFloat(matches[3]) / ("%" === matches[3].substr(-1) ? 100 : 255);
    result.alpha = parseFloat(defaultValue_default(matches[4], "1.0"));
    return result;
  }
  matches = hslParenthesesMatcher.exec(color);
  if (matches !== null) {
    return Color.fromHsl(
      parseFloat(matches[1]) / 360,
      parseFloat(matches[2]) / 100,
      parseFloat(matches[3]) / 100,
      parseFloat(defaultValue_default(matches[4], "1.0")),
      result
    );
  }
  result = void 0;
  return result;
};
Color.packedLength = 4;
Color.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.red;
  array[startingIndex++] = value.green;
  array[startingIndex++] = value.blue;
  array[startingIndex] = value.alpha;
  return array;
};
Color.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Color();
  }
  result.red = array[startingIndex++];
  result.green = array[startingIndex++];
  result.blue = array[startingIndex++];
  result.alpha = array[startingIndex];
  return result;
};
Color.byteToFloat = function(number) {
  return number / 255;
};
Color.floatToByte = function(number) {
  return number === 1 ? 255 : number * 256 | 0;
};
Color.clone = function(color, result) {
  if (!defined_default(color)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Color(color.red, color.green, color.blue, color.alpha);
  }
  result.red = color.red;
  result.green = color.green;
  result.blue = color.blue;
  result.alpha = color.alpha;
  return result;
};
Color.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.red === right.red && left.green === right.green && left.blue === right.blue && left.alpha === right.alpha;
};
Color.equalsArray = function(color, array, offset2) {
  return color.red === array[offset2] && color.green === array[offset2 + 1] && color.blue === array[offset2 + 2] && color.alpha === array[offset2 + 3];
};
Color.prototype.clone = function(result) {
  return Color.clone(this, result);
};
Color.prototype.equals = function(other) {
  return Color.equals(this, other);
};
Color.prototype.equalsEpsilon = function(other, epsilon) {
  return this === other || defined_default(other) && Math.abs(this.red - other.red) <= epsilon && Math.abs(this.green - other.green) <= epsilon && Math.abs(this.blue - other.blue) <= epsilon && Math.abs(this.alpha - other.alpha) <= epsilon;
};
Color.prototype.toString = function() {
  return `(${this.red}, ${this.green}, ${this.blue}, ${this.alpha})`;
};
Color.prototype.toCssColorString = function() {
  const red = Color.floatToByte(this.red);
  const green = Color.floatToByte(this.green);
  const blue = Color.floatToByte(this.blue);
  if (this.alpha === 1) {
    return `rgb(${red},${green},${blue})`;
  }
  return `rgba(${red},${green},${blue},${this.alpha})`;
};
Color.prototype.toCssHexString = function() {
  let r = Color.floatToByte(this.red).toString(16);
  if (r.length < 2) {
    r = `0${r}`;
  }
  let g = Color.floatToByte(this.green).toString(16);
  if (g.length < 2) {
    g = `0${g}`;
  }
  let b = Color.floatToByte(this.blue).toString(16);
  if (b.length < 2) {
    b = `0${b}`;
  }
  if (this.alpha < 1) {
    let hexAlpha = Color.floatToByte(this.alpha).toString(16);
    if (hexAlpha.length < 2) {
      hexAlpha = `0${hexAlpha}`;
    }
    return `#${r}${g}${b}${hexAlpha}`;
  }
  return `#${r}${g}${b}`;
};
Color.prototype.toBytes = function(result) {
  const red = Color.floatToByte(this.red);
  const green = Color.floatToByte(this.green);
  const blue = Color.floatToByte(this.blue);
  const alpha = Color.floatToByte(this.alpha);
  if (!defined_default(result)) {
    return [red, green, blue, alpha];
  }
  result[0] = red;
  result[1] = green;
  result[2] = blue;
  result[3] = alpha;
  return result;
};
Color.prototype.toRgba = function() {
  scratchUint8Array[0] = Color.floatToByte(this.red);
  scratchUint8Array[1] = Color.floatToByte(this.green);
  scratchUint8Array[2] = Color.floatToByte(this.blue);
  scratchUint8Array[3] = Color.floatToByte(this.alpha);
  return scratchUint32Array[0];
};
Color.prototype.brighten = function(magnitude, result) {
  Check_default.typeOf.number("magnitude", magnitude);
  Check_default.typeOf.number.greaterThanOrEquals("magnitude", magnitude, 0);
  Check_default.typeOf.object("result", result);
  magnitude = 1 - magnitude;
  result.red = 1 - (1 - this.red) * magnitude;
  result.green = 1 - (1 - this.green) * magnitude;
  result.blue = 1 - (1 - this.blue) * magnitude;
  result.alpha = this.alpha;
  return result;
};
Color.prototype.darken = function(magnitude, result) {
  Check_default.typeOf.number("magnitude", magnitude);
  Check_default.typeOf.number.greaterThanOrEquals("magnitude", magnitude, 0);
  Check_default.typeOf.object("result", result);
  magnitude = 1 - magnitude;
  result.red = this.red * magnitude;
  result.green = this.green * magnitude;
  result.blue = this.blue * magnitude;
  result.alpha = this.alpha;
  return result;
};
Color.prototype.withAlpha = function(alpha, result) {
  return Color.fromAlpha(this, alpha, result);
};
Color.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red + right.red;
  result.green = left.green + right.green;
  result.blue = left.blue + right.blue;
  result.alpha = left.alpha + right.alpha;
  return result;
};
Color.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red - right.red;
  result.green = left.green - right.green;
  result.blue = left.blue - right.blue;
  result.alpha = left.alpha - right.alpha;
  return result;
};
Color.multiply = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red * right.red;
  result.green = left.green * right.green;
  result.blue = left.blue * right.blue;
  result.alpha = left.alpha * right.alpha;
  return result;
};
Color.divide = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red / right.red;
  result.green = left.green / right.green;
  result.blue = left.blue / right.blue;
  result.alpha = left.alpha / right.alpha;
  return result;
};
Color.mod = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.red = left.red % right.red;
  result.green = left.green % right.green;
  result.blue = left.blue % right.blue;
  result.alpha = left.alpha % right.alpha;
  return result;
};
Color.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  result.red = Math_default.lerp(start.red, end.red, t);
  result.green = Math_default.lerp(start.green, end.green, t);
  result.blue = Math_default.lerp(start.blue, end.blue, t);
  result.alpha = Math_default.lerp(start.alpha, end.alpha, t);
  return result;
};
Color.multiplyByScalar = function(color, scalar, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.red = color.red * scalar;
  result.green = color.green * scalar;
  result.blue = color.blue * scalar;
  result.alpha = color.alpha * scalar;
  return result;
};
Color.divideByScalar = function(color, scalar, result) {
  Check_default.typeOf.object("color", color);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.red = color.red / scalar;
  result.green = color.green / scalar;
  result.blue = color.blue / scalar;
  result.alpha = color.alpha / scalar;
  return result;
};
Color.ALICEBLUE = Object.freeze(Color.fromCssColorString("#F0F8FF"));
Color.ANTIQUEWHITE = Object.freeze(Color.fromCssColorString("#FAEBD7"));
Color.AQUA = Object.freeze(Color.fromCssColorString("#00FFFF"));
Color.AQUAMARINE = Object.freeze(Color.fromCssColorString("#7FFFD4"));
Color.AZURE = Object.freeze(Color.fromCssColorString("#F0FFFF"));
Color.BEIGE = Object.freeze(Color.fromCssColorString("#F5F5DC"));
Color.BISQUE = Object.freeze(Color.fromCssColorString("#FFE4C4"));
Color.BLACK = Object.freeze(Color.fromCssColorString("#000000"));
Color.BLANCHEDALMOND = Object.freeze(Color.fromCssColorString("#FFEBCD"));
Color.BLUE = Object.freeze(Color.fromCssColorString("#0000FF"));
Color.BLUEVIOLET = Object.freeze(Color.fromCssColorString("#8A2BE2"));
Color.BROWN = Object.freeze(Color.fromCssColorString("#A52A2A"));
Color.BURLYWOOD = Object.freeze(Color.fromCssColorString("#DEB887"));
Color.CADETBLUE = Object.freeze(Color.fromCssColorString("#5F9EA0"));
Color.CHARTREUSE = Object.freeze(Color.fromCssColorString("#7FFF00"));
Color.CHOCOLATE = Object.freeze(Color.fromCssColorString("#D2691E"));
Color.CORAL = Object.freeze(Color.fromCssColorString("#FF7F50"));
Color.CORNFLOWERBLUE = Object.freeze(Color.fromCssColorString("#6495ED"));
Color.CORNSILK = Object.freeze(Color.fromCssColorString("#FFF8DC"));
Color.CRIMSON = Object.freeze(Color.fromCssColorString("#DC143C"));
Color.CYAN = Object.freeze(Color.fromCssColorString("#00FFFF"));
Color.DARKBLUE = Object.freeze(Color.fromCssColorString("#00008B"));
Color.DARKCYAN = Object.freeze(Color.fromCssColorString("#008B8B"));
Color.DARKGOLDENROD = Object.freeze(Color.fromCssColorString("#B8860B"));
Color.DARKGRAY = Object.freeze(Color.fromCssColorString("#A9A9A9"));
Color.DARKGREEN = Object.freeze(Color.fromCssColorString("#006400"));
Color.DARKGREY = Color.DARKGRAY;
Color.DARKKHAKI = Object.freeze(Color.fromCssColorString("#BDB76B"));
Color.DARKMAGENTA = Object.freeze(Color.fromCssColorString("#8B008B"));
Color.DARKOLIVEGREEN = Object.freeze(Color.fromCssColorString("#556B2F"));
Color.DARKORANGE = Object.freeze(Color.fromCssColorString("#FF8C00"));
Color.DARKORCHID = Object.freeze(Color.fromCssColorString("#9932CC"));
Color.DARKRED = Object.freeze(Color.fromCssColorString("#8B0000"));
Color.DARKSALMON = Object.freeze(Color.fromCssColorString("#E9967A"));
Color.DARKSEAGREEN = Object.freeze(Color.fromCssColorString("#8FBC8F"));
Color.DARKSLATEBLUE = Object.freeze(Color.fromCssColorString("#483D8B"));
Color.DARKSLATEGRAY = Object.freeze(Color.fromCssColorString("#2F4F4F"));
Color.DARKSLATEGREY = Color.DARKSLATEGRAY;
Color.DARKTURQUOISE = Object.freeze(Color.fromCssColorString("#00CED1"));
Color.DARKVIOLET = Object.freeze(Color.fromCssColorString("#9400D3"));
Color.DEEPPINK = Object.freeze(Color.fromCssColorString("#FF1493"));
Color.DEEPSKYBLUE = Object.freeze(Color.fromCssColorString("#00BFFF"));
Color.DIMGRAY = Object.freeze(Color.fromCssColorString("#696969"));
Color.DIMGREY = Color.DIMGRAY;
Color.DODGERBLUE = Object.freeze(Color.fromCssColorString("#1E90FF"));
Color.FIREBRICK = Object.freeze(Color.fromCssColorString("#B22222"));
Color.FLORALWHITE = Object.freeze(Color.fromCssColorString("#FFFAF0"));
Color.FORESTGREEN = Object.freeze(Color.fromCssColorString("#228B22"));
Color.FUCHSIA = Object.freeze(Color.fromCssColorString("#FF00FF"));
Color.GAINSBORO = Object.freeze(Color.fromCssColorString("#DCDCDC"));
Color.GHOSTWHITE = Object.freeze(Color.fromCssColorString("#F8F8FF"));
Color.GOLD = Object.freeze(Color.fromCssColorString("#FFD700"));
Color.GOLDENROD = Object.freeze(Color.fromCssColorString("#DAA520"));
Color.GRAY = Object.freeze(Color.fromCssColorString("#808080"));
Color.GREEN = Object.freeze(Color.fromCssColorString("#008000"));
Color.GREENYELLOW = Object.freeze(Color.fromCssColorString("#ADFF2F"));
Color.GREY = Color.GRAY;
Color.HONEYDEW = Object.freeze(Color.fromCssColorString("#F0FFF0"));
Color.HOTPINK = Object.freeze(Color.fromCssColorString("#FF69B4"));
Color.INDIANRED = Object.freeze(Color.fromCssColorString("#CD5C5C"));
Color.INDIGO = Object.freeze(Color.fromCssColorString("#4B0082"));
Color.IVORY = Object.freeze(Color.fromCssColorString("#FFFFF0"));
Color.KHAKI = Object.freeze(Color.fromCssColorString("#F0E68C"));
Color.LAVENDER = Object.freeze(Color.fromCssColorString("#E6E6FA"));
Color.LAVENDAR_BLUSH = Object.freeze(Color.fromCssColorString("#FFF0F5"));
Color.LAWNGREEN = Object.freeze(Color.fromCssColorString("#7CFC00"));
Color.LEMONCHIFFON = Object.freeze(Color.fromCssColorString("#FFFACD"));
Color.LIGHTBLUE = Object.freeze(Color.fromCssColorString("#ADD8E6"));
Color.LIGHTCORAL = Object.freeze(Color.fromCssColorString("#F08080"));
Color.LIGHTCYAN = Object.freeze(Color.fromCssColorString("#E0FFFF"));
Color.LIGHTGOLDENRODYELLOW = Object.freeze(Color.fromCssColorString("#FAFAD2"));
Color.LIGHTGRAY = Object.freeze(Color.fromCssColorString("#D3D3D3"));
Color.LIGHTGREEN = Object.freeze(Color.fromCssColorString("#90EE90"));
Color.LIGHTGREY = Color.LIGHTGRAY;
Color.LIGHTPINK = Object.freeze(Color.fromCssColorString("#FFB6C1"));
Color.LIGHTSEAGREEN = Object.freeze(Color.fromCssColorString("#20B2AA"));
Color.LIGHTSKYBLUE = Object.freeze(Color.fromCssColorString("#87CEFA"));
Color.LIGHTSLATEGRAY = Object.freeze(Color.fromCssColorString("#778899"));
Color.LIGHTSLATEGREY = Color.LIGHTSLATEGRAY;
Color.LIGHTSTEELBLUE = Object.freeze(Color.fromCssColorString("#B0C4DE"));
Color.LIGHTYELLOW = Object.freeze(Color.fromCssColorString("#FFFFE0"));
Color.LIME = Object.freeze(Color.fromCssColorString("#00FF00"));
Color.LIMEGREEN = Object.freeze(Color.fromCssColorString("#32CD32"));
Color.LINEN = Object.freeze(Color.fromCssColorString("#FAF0E6"));
Color.MAGENTA = Object.freeze(Color.fromCssColorString("#FF00FF"));
Color.MAROON = Object.freeze(Color.fromCssColorString("#800000"));
Color.MEDIUMAQUAMARINE = Object.freeze(Color.fromCssColorString("#66CDAA"));
Color.MEDIUMBLUE = Object.freeze(Color.fromCssColorString("#0000CD"));
Color.MEDIUMORCHID = Object.freeze(Color.fromCssColorString("#BA55D3"));
Color.MEDIUMPURPLE = Object.freeze(Color.fromCssColorString("#9370DB"));
Color.MEDIUMSEAGREEN = Object.freeze(Color.fromCssColorString("#3CB371"));
Color.MEDIUMSLATEBLUE = Object.freeze(Color.fromCssColorString("#7B68EE"));
Color.MEDIUMSPRINGGREEN = Object.freeze(Color.fromCssColorString("#00FA9A"));
Color.MEDIUMTURQUOISE = Object.freeze(Color.fromCssColorString("#48D1CC"));
Color.MEDIUMVIOLETRED = Object.freeze(Color.fromCssColorString("#C71585"));
Color.MIDNIGHTBLUE = Object.freeze(Color.fromCssColorString("#191970"));
Color.MINTCREAM = Object.freeze(Color.fromCssColorString("#F5FFFA"));
Color.MISTYROSE = Object.freeze(Color.fromCssColorString("#FFE4E1"));
Color.MOCCASIN = Object.freeze(Color.fromCssColorString("#FFE4B5"));
Color.NAVAJOWHITE = Object.freeze(Color.fromCssColorString("#FFDEAD"));
Color.NAVY = Object.freeze(Color.fromCssColorString("#000080"));
Color.OLDLACE = Object.freeze(Color.fromCssColorString("#FDF5E6"));
Color.OLIVE = Object.freeze(Color.fromCssColorString("#808000"));
Color.OLIVEDRAB = Object.freeze(Color.fromCssColorString("#6B8E23"));
Color.ORANGE = Object.freeze(Color.fromCssColorString("#FFA500"));
Color.ORANGERED = Object.freeze(Color.fromCssColorString("#FF4500"));
Color.ORCHID = Object.freeze(Color.fromCssColorString("#DA70D6"));
Color.PALEGOLDENROD = Object.freeze(Color.fromCssColorString("#EEE8AA"));
Color.PALEGREEN = Object.freeze(Color.fromCssColorString("#98FB98"));
Color.PALETURQUOISE = Object.freeze(Color.fromCssColorString("#AFEEEE"));
Color.PALEVIOLETRED = Object.freeze(Color.fromCssColorString("#DB7093"));
Color.PAPAYAWHIP = Object.freeze(Color.fromCssColorString("#FFEFD5"));
Color.PEACHPUFF = Object.freeze(Color.fromCssColorString("#FFDAB9"));
Color.PERU = Object.freeze(Color.fromCssColorString("#CD853F"));
Color.PINK = Object.freeze(Color.fromCssColorString("#FFC0CB"));
Color.PLUM = Object.freeze(Color.fromCssColorString("#DDA0DD"));
Color.POWDERBLUE = Object.freeze(Color.fromCssColorString("#B0E0E6"));
Color.PURPLE = Object.freeze(Color.fromCssColorString("#800080"));
Color.RED = Object.freeze(Color.fromCssColorString("#FF0000"));
Color.ROSYBROWN = Object.freeze(Color.fromCssColorString("#BC8F8F"));
Color.ROYALBLUE = Object.freeze(Color.fromCssColorString("#4169E1"));
Color.SADDLEBROWN = Object.freeze(Color.fromCssColorString("#8B4513"));
Color.SALMON = Object.freeze(Color.fromCssColorString("#FA8072"));
Color.SANDYBROWN = Object.freeze(Color.fromCssColorString("#F4A460"));
Color.SEAGREEN = Object.freeze(Color.fromCssColorString("#2E8B57"));
Color.SEASHELL = Object.freeze(Color.fromCssColorString("#FFF5EE"));
Color.SIENNA = Object.freeze(Color.fromCssColorString("#A0522D"));
Color.SILVER = Object.freeze(Color.fromCssColorString("#C0C0C0"));
Color.SKYBLUE = Object.freeze(Color.fromCssColorString("#87CEEB"));
Color.SLATEBLUE = Object.freeze(Color.fromCssColorString("#6A5ACD"));
Color.SLATEGRAY = Object.freeze(Color.fromCssColorString("#708090"));
Color.SLATEGREY = Color.SLATEGRAY;
Color.SNOW = Object.freeze(Color.fromCssColorString("#FFFAFA"));
Color.SPRINGGREEN = Object.freeze(Color.fromCssColorString("#00FF7F"));
Color.STEELBLUE = Object.freeze(Color.fromCssColorString("#4682B4"));
Color.TAN = Object.freeze(Color.fromCssColorString("#D2B48C"));
Color.TEAL = Object.freeze(Color.fromCssColorString("#008080"));
Color.THISTLE = Object.freeze(Color.fromCssColorString("#D8BFD8"));
Color.TOMATO = Object.freeze(Color.fromCssColorString("#FF6347"));
Color.TURQUOISE = Object.freeze(Color.fromCssColorString("#40E0D0"));
Color.VIOLET = Object.freeze(Color.fromCssColorString("#EE82EE"));
Color.WHEAT = Object.freeze(Color.fromCssColorString("#F5DEB3"));
Color.WHITE = Object.freeze(Color.fromCssColorString("#FFFFFF"));
Color.WHITESMOKE = Object.freeze(Color.fromCssColorString("#F5F5F5"));
Color.YELLOW = Object.freeze(Color.fromCssColorString("#FFFF00"));
Color.YELLOWGREEN = Object.freeze(Color.fromCssColorString("#9ACD32"));
Color.TRANSPARENT = Object.freeze(new Color(0, 0, 0, 0));
var Color_default = Color;

// Source/Renderer/ClearCommand.js
function ClearCommand(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  this.color = options.color;
  this.depth = options.depth;
  this.stencil = options.stencil;
  this.renderState = options.renderState;
  this.framebuffer = options.framebuffer;
  this.owner = options.owner;
  this.pass = options.pass;
}
ClearCommand.ALL = Object.freeze(
  new ClearCommand({
    color: new Color_default(0, 0, 0, 0),
    depth: 1,
    stencil: 0
  })
);
ClearCommand.prototype.execute = function(context, passState) {
  context.clear(this, passState);
};
var ClearCommand_default = ClearCommand;

// Source/Renderer/Pass.js
var Pass = {
  ENVIRONMENT: 0,
  COMPUTE: 1,
  GLOBE: 2,
  TERRAIN_CLASSIFICATION: 3,
  CESIUM_3D_TILE: 4,
  CESIUM_3D_TILE_CLASSIFICATION: 5,
  CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW: 6,
  OPAQUE: 7,
  TRANSLUCENT: 8,
  OVERLAY: 9,
  NUMBER_OF_PASSES: 10
};
var Pass_default = Object.freeze(Pass);

// Source/Renderer/ComputeCommand.js
function ComputeCommand(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  this.vertexArray = options.vertexArray;
  this.fragmentShaderSource = options.fragmentShaderSource;
  this.shaderProgram = options.shaderProgram;
  this.uniformMap = options.uniformMap;
  this.outputTexture = options.outputTexture;
  this.preExecute = options.preExecute;
  this.postExecute = options.postExecute;
  this.canceled = options.canceled;
  this.persists = defaultValue_default(options.persists, false);
  this.pass = Pass_default.COMPUTE;
  this.owner = options.owner;
}
ComputeCommand.prototype.execute = function(computeEngine) {
  computeEngine.execute(this);
};
var ComputeCommand_default = ComputeCommand;

// Source/Core/Cartesian2.js
function Cartesian2(x, y) {
  this.x = defaultValue_default(x, 0);
  this.y = defaultValue_default(y, 0);
}
Cartesian2.fromElements = function(x, y, result) {
  if (!defined_default(result)) {
    return new Cartesian2(x, y);
  }
  result.x = x;
  result.y = y;
  return result;
};
Cartesian2.clone = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartesian2(cartesian11.x, cartesian11.y);
  }
  result.x = cartesian11.x;
  result.y = cartesian11.y;
  return result;
};
Cartesian2.fromCartesian3 = Cartesian2.clone;
Cartesian2.fromCartesian4 = Cartesian2.clone;
Cartesian2.packedLength = 2;
Cartesian2.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.x;
  array[startingIndex] = value.y;
  return array;
};
Cartesian2.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Cartesian2();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex];
  return result;
};
Cartesian2.packArray = function(array, result) {
  Check_default.defined("array", array);
  const length3 = array.length;
  const resultLength = length3 * 2;
  if (!defined_default(result)) {
    result = new Array(resultLength);
  } else if (!Array.isArray(result) && result.length !== resultLength) {
    throw new DeveloperError_default(
      "If result is a typed array, it must have exactly array.length * 2 elements"
    );
  } else if (result.length !== resultLength) {
    result.length = resultLength;
  }
  for (let i = 0; i < length3; ++i) {
    Cartesian2.pack(array[i], result, i * 2);
  }
  return result;
};
Cartesian2.unpackArray = function(array, result) {
  Check_default.defined("array", array);
  Check_default.typeOf.number.greaterThanOrEquals("array.length", array.length, 2);
  if (array.length % 2 !== 0) {
    throw new DeveloperError_default("array length must be a multiple of 2.");
  }
  const length3 = array.length;
  if (!defined_default(result)) {
    result = new Array(length3 / 2);
  } else {
    result.length = length3 / 2;
  }
  for (let i = 0; i < length3; i += 2) {
    const index = i / 2;
    result[index] = Cartesian2.unpack(array, i, result[index]);
  }
  return result;
};
Cartesian2.fromArray = Cartesian2.unpack;
Cartesian2.maximumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.max(cartesian11.x, cartesian11.y);
};
Cartesian2.minimumComponent = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return Math.min(cartesian11.x, cartesian11.y);
};
Cartesian2.minimumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.min(first.x, second.x);
  result.y = Math.min(first.y, second.y);
  return result;
};
Cartesian2.maximumByComponent = function(first, second, result) {
  Check_default.typeOf.object("first", first);
  Check_default.typeOf.object("second", second);
  Check_default.typeOf.object("result", result);
  result.x = Math.max(first.x, second.x);
  result.y = Math.max(first.y, second.y);
  return result;
};
Cartesian2.clamp = function(value, min3, max3, result) {
  Check_default.typeOf.object("value", value);
  Check_default.typeOf.object("min", min3);
  Check_default.typeOf.object("max", max3);
  Check_default.typeOf.object("result", result);
  const x = Math_default.clamp(value.x, min3.x, max3.x);
  const y = Math_default.clamp(value.y, min3.y, max3.y);
  result.x = x;
  result.y = y;
  return result;
};
Cartesian2.magnitudeSquared = function(cartesian11) {
  Check_default.typeOf.object("cartesian", cartesian11);
  return cartesian11.x * cartesian11.x + cartesian11.y * cartesian11.y;
};
Cartesian2.magnitude = function(cartesian11) {
  return Math.sqrt(Cartesian2.magnitudeSquared(cartesian11));
};
var distanceScratch3 = new Cartesian2();
Cartesian2.distance = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.subtract(left, right, distanceScratch3);
  return Cartesian2.magnitude(distanceScratch3);
};
Cartesian2.distanceSquared = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.subtract(left, right, distanceScratch3);
  return Cartesian2.magnitudeSquared(distanceScratch3);
};
Cartesian2.normalize = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const magnitude = Cartesian2.magnitude(cartesian11);
  result.x = cartesian11.x / magnitude;
  result.y = cartesian11.y / magnitude;
  if (isNaN(result.x) || isNaN(result.y)) {
    throw new DeveloperError_default("normalized result is not a number");
  }
  return result;
};
Cartesian2.dot = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.x + left.y * right.y;
};
Cartesian2.cross = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  return left.x * right.y - left.y * right.x;
};
Cartesian2.multiplyComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x * right.x;
  result.y = left.y * right.y;
  return result;
};
Cartesian2.divideComponents = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x / right.x;
  result.y = left.y / right.y;
  return result;
};
Cartesian2.add = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x + right.x;
  result.y = left.y + right.y;
  return result;
};
Cartesian2.subtract = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Check_default.typeOf.object("result", result);
  result.x = left.x - right.x;
  result.y = left.y - right.y;
  return result;
};
Cartesian2.multiplyByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x * scalar;
  result.y = cartesian11.y * scalar;
  return result;
};
Cartesian2.divideByScalar = function(cartesian11, scalar, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.number("scalar", scalar);
  Check_default.typeOf.object("result", result);
  result.x = cartesian11.x / scalar;
  result.y = cartesian11.y / scalar;
  return result;
};
Cartesian2.negate = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = -cartesian11.x;
  result.y = -cartesian11.y;
  return result;
};
Cartesian2.abs = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  result.x = Math.abs(cartesian11.x);
  result.y = Math.abs(cartesian11.y);
  return result;
};
var lerpScratch3 = new Cartesian2();
Cartesian2.lerp = function(start, end, t, result) {
  Check_default.typeOf.object("start", start);
  Check_default.typeOf.object("end", end);
  Check_default.typeOf.number("t", t);
  Check_default.typeOf.object("result", result);
  Cartesian2.multiplyByScalar(end, t, lerpScratch3);
  result = Cartesian2.multiplyByScalar(start, 1 - t, result);
  return Cartesian2.add(lerpScratch3, result, result);
};
var angleBetweenScratch3 = new Cartesian2();
var angleBetweenScratch22 = new Cartesian2();
Cartesian2.angleBetween = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  Cartesian2.normalize(left, angleBetweenScratch3);
  Cartesian2.normalize(right, angleBetweenScratch22);
  return Math_default.acosClamped(
    Cartesian2.dot(angleBetweenScratch3, angleBetweenScratch22)
  );
};
var mostOrthogonalAxisScratch3 = new Cartesian2();
Cartesian2.mostOrthogonalAxis = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  Check_default.typeOf.object("result", result);
  const f = Cartesian2.normalize(cartesian11, mostOrthogonalAxisScratch3);
  Cartesian2.abs(f, f);
  if (f.x <= f.y) {
    result = Cartesian2.clone(Cartesian2.UNIT_X, result);
  } else {
    result = Cartesian2.clone(Cartesian2.UNIT_Y, result);
  }
  return result;
};
Cartesian2.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y;
};
Cartesian2.equalsArray = function(cartesian11, array, offset2) {
  return cartesian11.x === array[offset2] && cartesian11.y === array[offset2 + 1];
};
Cartesian2.equalsEpsilon = function(left, right, relativeEpsilon, absoluteEpsilon) {
  return left === right || defined_default(left) && defined_default(right) && Math_default.equalsEpsilon(
    left.x,
    right.x,
    relativeEpsilon,
    absoluteEpsilon
  ) && Math_default.equalsEpsilon(
    left.y,
    right.y,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian2.ZERO = Object.freeze(new Cartesian2(0, 0));
Cartesian2.ONE = Object.freeze(new Cartesian2(1, 1));
Cartesian2.UNIT_X = Object.freeze(new Cartesian2(1, 0));
Cartesian2.UNIT_Y = Object.freeze(new Cartesian2(0, 1));
Cartesian2.prototype.clone = function(result) {
  return Cartesian2.clone(this, result);
};
Cartesian2.prototype.equals = function(right) {
  return Cartesian2.equals(this, right);
};
Cartesian2.prototype.equalsEpsilon = function(right, relativeEpsilon, absoluteEpsilon) {
  return Cartesian2.equalsEpsilon(
    this,
    right,
    relativeEpsilon,
    absoluteEpsilon
  );
};
Cartesian2.prototype.toString = function() {
  return `(${this.x}, ${this.y})`;
};
var Cartesian2_default = Cartesian2;

// Source/Core/scaleToGeodeticSurface.js
var scaleToGeodeticSurfaceIntersection = new Cartesian3_default();
var scaleToGeodeticSurfaceGradient = new Cartesian3_default();
function scaleToGeodeticSurface(cartesian11, oneOverRadii, oneOverRadiiSquared, centerToleranceSquared, result) {
  if (!defined_default(cartesian11)) {
    throw new DeveloperError_default("cartesian is required.");
  }
  if (!defined_default(oneOverRadii)) {
    throw new DeveloperError_default("oneOverRadii is required.");
  }
  if (!defined_default(oneOverRadiiSquared)) {
    throw new DeveloperError_default("oneOverRadiiSquared is required.");
  }
  if (!defined_default(centerToleranceSquared)) {
    throw new DeveloperError_default("centerToleranceSquared is required.");
  }
  const positionX = cartesian11.x;
  const positionY = cartesian11.y;
  const positionZ = cartesian11.z;
  const oneOverRadiiX = oneOverRadii.x;
  const oneOverRadiiY = oneOverRadii.y;
  const oneOverRadiiZ = oneOverRadii.z;
  const x2 = positionX * positionX * oneOverRadiiX * oneOverRadiiX;
  const y2 = positionY * positionY * oneOverRadiiY * oneOverRadiiY;
  const z2 = positionZ * positionZ * oneOverRadiiZ * oneOverRadiiZ;
  const squaredNorm = x2 + y2 + z2;
  const ratio = Math.sqrt(1 / squaredNorm);
  const intersection = Cartesian3_default.multiplyByScalar(
    cartesian11,
    ratio,
    scaleToGeodeticSurfaceIntersection
  );
  if (squaredNorm < centerToleranceSquared) {
    return !isFinite(ratio) ? void 0 : Cartesian3_default.clone(intersection, result);
  }
  const oneOverRadiiSquaredX = oneOverRadiiSquared.x;
  const oneOverRadiiSquaredY = oneOverRadiiSquared.y;
  const oneOverRadiiSquaredZ = oneOverRadiiSquared.z;
  const gradient = scaleToGeodeticSurfaceGradient;
  gradient.x = intersection.x * oneOverRadiiSquaredX * 2;
  gradient.y = intersection.y * oneOverRadiiSquaredY * 2;
  gradient.z = intersection.z * oneOverRadiiSquaredZ * 2;
  let lambda = (1 - ratio) * Cartesian3_default.magnitude(cartesian11) / (0.5 * Cartesian3_default.magnitude(gradient));
  let correction = 0;
  let func;
  let denominator;
  let xMultiplier;
  let yMultiplier;
  let zMultiplier;
  let xMultiplier2;
  let yMultiplier2;
  let zMultiplier2;
  let xMultiplier3;
  let yMultiplier3;
  let zMultiplier3;
  do {
    lambda -= correction;
    xMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredX);
    yMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredY);
    zMultiplier = 1 / (1 + lambda * oneOverRadiiSquaredZ);
    xMultiplier2 = xMultiplier * xMultiplier;
    yMultiplier2 = yMultiplier * yMultiplier;
    zMultiplier2 = zMultiplier * zMultiplier;
    xMultiplier3 = xMultiplier2 * xMultiplier;
    yMultiplier3 = yMultiplier2 * yMultiplier;
    zMultiplier3 = zMultiplier2 * zMultiplier;
    func = x2 * xMultiplier2 + y2 * yMultiplier2 + z2 * zMultiplier2 - 1;
    denominator = x2 * xMultiplier3 * oneOverRadiiSquaredX + y2 * yMultiplier3 * oneOverRadiiSquaredY + z2 * zMultiplier3 * oneOverRadiiSquaredZ;
    const derivative = -2 * denominator;
    correction = func / derivative;
  } while (Math.abs(func) > Math_default.EPSILON12);
  if (!defined_default(result)) {
    return new Cartesian3_default(
      positionX * xMultiplier,
      positionY * yMultiplier,
      positionZ * zMultiplier
    );
  }
  result.x = positionX * xMultiplier;
  result.y = positionY * yMultiplier;
  result.z = positionZ * zMultiplier;
  return result;
}
var scaleToGeodeticSurface_default = scaleToGeodeticSurface;

// Source/Core/Cartographic.js
function Cartographic(longitude, latitude, height) {
  this.longitude = defaultValue_default(longitude, 0);
  this.latitude = defaultValue_default(latitude, 0);
  this.height = defaultValue_default(height, 0);
}
Cartographic.fromRadians = function(longitude, latitude, height, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  height = defaultValue_default(height, 0);
  if (!defined_default(result)) {
    return new Cartographic(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Cartographic.fromDegrees = function(longitude, latitude, height, result) {
  Check_default.typeOf.number("longitude", longitude);
  Check_default.typeOf.number("latitude", latitude);
  longitude = Math_default.toRadians(longitude);
  latitude = Math_default.toRadians(latitude);
  return Cartographic.fromRadians(longitude, latitude, height, result);
};
var cartesianToCartographicN = new Cartesian3_default();
var cartesianToCartographicP = new Cartesian3_default();
var cartesianToCartographicH = new Cartesian3_default();
var wgs84OneOverRadii = new Cartesian3_default(
  1 / 6378137,
  1 / 6378137,
  1 / 6356752314245179e-9
);
var wgs84OneOverRadiiSquared = new Cartesian3_default(
  1 / (6378137 * 6378137),
  1 / (6378137 * 6378137),
  1 / (6356752314245179e-9 * 6356752314245179e-9)
);
var wgs84CenterToleranceSquared = Math_default.EPSILON1;
Cartographic.fromCartesian = function(cartesian11, ellipsoid, result) {
  const oneOverRadii = defined_default(ellipsoid) ? ellipsoid.oneOverRadii : wgs84OneOverRadii;
  const oneOverRadiiSquared = defined_default(ellipsoid) ? ellipsoid.oneOverRadiiSquared : wgs84OneOverRadiiSquared;
  const centerToleranceSquared = defined_default(ellipsoid) ? ellipsoid._centerToleranceSquared : wgs84CenterToleranceSquared;
  const p = scaleToGeodeticSurface_default(
    cartesian11,
    oneOverRadii,
    oneOverRadiiSquared,
    centerToleranceSquared,
    cartesianToCartographicP
  );
  if (!defined_default(p)) {
    return void 0;
  }
  let n = Cartesian3_default.multiplyComponents(
    p,
    oneOverRadiiSquared,
    cartesianToCartographicN
  );
  n = Cartesian3_default.normalize(n, n);
  const h = Cartesian3_default.subtract(cartesian11, p, cartesianToCartographicH);
  const longitude = Math.atan2(n.y, n.x);
  const latitude = Math.asin(n.z);
  const height = Math_default.sign(Cartesian3_default.dot(h, cartesian11)) * Cartesian3_default.magnitude(h);
  if (!defined_default(result)) {
    return new Cartographic(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Cartographic.toCartesian = function(cartographic2, ellipsoid, result) {
  Check_default.defined("cartographic", cartographic2);
  return Cartesian3_default.fromRadians(
    cartographic2.longitude,
    cartographic2.latitude,
    cartographic2.height,
    ellipsoid,
    result
  );
};
Cartographic.clone = function(cartographic2, result) {
  if (!defined_default(cartographic2)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Cartographic(
      cartographic2.longitude,
      cartographic2.latitude,
      cartographic2.height
    );
  }
  result.longitude = cartographic2.longitude;
  result.latitude = cartographic2.latitude;
  result.height = cartographic2.height;
  return result;
};
Cartographic.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.longitude === right.longitude && left.latitude === right.latitude && left.height === right.height;
};
Cartographic.equalsEpsilon = function(left, right, epsilon) {
  epsilon = defaultValue_default(epsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.longitude - right.longitude) <= epsilon && Math.abs(left.latitude - right.latitude) <= epsilon && Math.abs(left.height - right.height) <= epsilon;
};
Cartographic.ZERO = Object.freeze(new Cartographic(0, 0, 0));
Cartographic.prototype.clone = function(result) {
  return Cartographic.clone(this, result);
};
Cartographic.prototype.equals = function(right) {
  return Cartographic.equals(this, right);
};
Cartographic.prototype.equalsEpsilon = function(right, epsilon) {
  return Cartographic.equalsEpsilon(this, right, epsilon);
};
Cartographic.prototype.toString = function() {
  return `(${this.longitude}, ${this.latitude}, ${this.height})`;
};
var Cartographic_default = Cartographic;

// Source/Core/Ellipsoid.js
function initialize(ellipsoid, x, y, z) {
  x = defaultValue_default(x, 0);
  y = defaultValue_default(y, 0);
  z = defaultValue_default(z, 0);
  Check_default.typeOf.number.greaterThanOrEquals("x", x, 0);
  Check_default.typeOf.number.greaterThanOrEquals("y", y, 0);
  Check_default.typeOf.number.greaterThanOrEquals("z", z, 0);
  ellipsoid._radii = new Cartesian3_default(x, y, z);
  ellipsoid._radiiSquared = new Cartesian3_default(x * x, y * y, z * z);
  ellipsoid._radiiToTheFourth = new Cartesian3_default(
    x * x * x * x,
    y * y * y * y,
    z * z * z * z
  );
  ellipsoid._oneOverRadii = new Cartesian3_default(
    x === 0 ? 0 : 1 / x,
    y === 0 ? 0 : 1 / y,
    z === 0 ? 0 : 1 / z
  );
  ellipsoid._oneOverRadiiSquared = new Cartesian3_default(
    x === 0 ? 0 : 1 / (x * x),
    y === 0 ? 0 : 1 / (y * y),
    z === 0 ? 0 : 1 / (z * z)
  );
  ellipsoid._minimumRadius = Math.min(x, y, z);
  ellipsoid._maximumRadius = Math.max(x, y, z);
  ellipsoid._centerToleranceSquared = Math_default.EPSILON1;
  if (ellipsoid._radiiSquared.z !== 0) {
    ellipsoid._squaredXOverSquaredZ = ellipsoid._radiiSquared.x / ellipsoid._radiiSquared.z;
  }
}
function Ellipsoid(x, y, z) {
  this._radii = void 0;
  this._radiiSquared = void 0;
  this._radiiToTheFourth = void 0;
  this._oneOverRadii = void 0;
  this._oneOverRadiiSquared = void 0;
  this._minimumRadius = void 0;
  this._maximumRadius = void 0;
  this._centerToleranceSquared = void 0;
  this._squaredXOverSquaredZ = void 0;
  initialize(this, x, y, z);
}
Object.defineProperties(Ellipsoid.prototype, {
  radii: {
    get: function() {
      return this._radii;
    }
  },
  radiiSquared: {
    get: function() {
      return this._radiiSquared;
    }
  },
  radiiToTheFourth: {
    get: function() {
      return this._radiiToTheFourth;
    }
  },
  oneOverRadii: {
    get: function() {
      return this._oneOverRadii;
    }
  },
  oneOverRadiiSquared: {
    get: function() {
      return this._oneOverRadiiSquared;
    }
  },
  minimumRadius: {
    get: function() {
      return this._minimumRadius;
    }
  },
  maximumRadius: {
    get: function() {
      return this._maximumRadius;
    }
  }
});
Ellipsoid.clone = function(ellipsoid, result) {
  if (!defined_default(ellipsoid)) {
    return void 0;
  }
  const radii = ellipsoid._radii;
  if (!defined_default(result)) {
    return new Ellipsoid(radii.x, radii.y, radii.z);
  }
  Cartesian3_default.clone(radii, result._radii);
  Cartesian3_default.clone(ellipsoid._radiiSquared, result._radiiSquared);
  Cartesian3_default.clone(ellipsoid._radiiToTheFourth, result._radiiToTheFourth);
  Cartesian3_default.clone(ellipsoid._oneOverRadii, result._oneOverRadii);
  Cartesian3_default.clone(ellipsoid._oneOverRadiiSquared, result._oneOverRadiiSquared);
  result._minimumRadius = ellipsoid._minimumRadius;
  result._maximumRadius = ellipsoid._maximumRadius;
  result._centerToleranceSquared = ellipsoid._centerToleranceSquared;
  return result;
};
Ellipsoid.fromCartesian3 = function(cartesian11, result) {
  if (!defined_default(result)) {
    result = new Ellipsoid();
  }
  if (!defined_default(cartesian11)) {
    return result;
  }
  initialize(result, cartesian11.x, cartesian11.y, cartesian11.z);
  return result;
};
Ellipsoid.WGS84 = Object.freeze(
  new Ellipsoid(6378137, 6378137, 6356752314245179e-9)
);
Ellipsoid.UNIT_SPHERE = Object.freeze(new Ellipsoid(1, 1, 1));
Ellipsoid.MOON = Object.freeze(
  new Ellipsoid(
    Math_default.LUNAR_RADIUS,
    Math_default.LUNAR_RADIUS,
    Math_default.LUNAR_RADIUS
  )
);
Ellipsoid.prototype.clone = function(result) {
  return Ellipsoid.clone(this, result);
};
Ellipsoid.packedLength = Cartesian3_default.packedLength;
Ellipsoid.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  Cartesian3_default.pack(value._radii, array, startingIndex);
  return array;
};
Ellipsoid.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  const radii = Cartesian3_default.unpack(array, startingIndex);
  return Ellipsoid.fromCartesian3(radii, result);
};
Ellipsoid.prototype.geocentricSurfaceNormal = Cartesian3_default.normalize;
Ellipsoid.prototype.geodeticSurfaceNormalCartographic = function(cartographic2, result) {
  Check_default.typeOf.object("cartographic", cartographic2);
  const longitude = cartographic2.longitude;
  const latitude = cartographic2.latitude;
  const cosLatitude = Math.cos(latitude);
  const x = cosLatitude * Math.cos(longitude);
  const y = cosLatitude * Math.sin(longitude);
  const z = Math.sin(latitude);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return Cartesian3_default.normalize(result, result);
};
Ellipsoid.prototype.geodeticSurfaceNormal = function(cartesian11, result) {
  if (Cartesian3_default.equalsEpsilon(cartesian11, Cartesian3_default.ZERO, Math_default.EPSILON14)) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result = Cartesian3_default.multiplyComponents(
    cartesian11,
    this._oneOverRadiiSquared,
    result
  );
  return Cartesian3_default.normalize(result, result);
};
var cartographicToCartesianNormal = new Cartesian3_default();
var cartographicToCartesianK = new Cartesian3_default();
Ellipsoid.prototype.cartographicToCartesian = function(cartographic2, result) {
  const n = cartographicToCartesianNormal;
  const k = cartographicToCartesianK;
  this.geodeticSurfaceNormalCartographic(cartographic2, n);
  Cartesian3_default.multiplyComponents(this._radiiSquared, n, k);
  const gamma = Math.sqrt(Cartesian3_default.dot(n, k));
  Cartesian3_default.divideByScalar(k, gamma, k);
  Cartesian3_default.multiplyByScalar(n, cartographic2.height, n);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.add(k, n, result);
};
Ellipsoid.prototype.cartographicArrayToCartesianArray = function(cartographics, result) {
  Check_default.defined("cartographics", cartographics);
  const length3 = cartographics.length;
  if (!defined_default(result)) {
    result = new Array(length3);
  } else {
    result.length = length3;
  }
  for (let i = 0; i < length3; i++) {
    result[i] = this.cartographicToCartesian(cartographics[i], result[i]);
  }
  return result;
};
var cartesianToCartographicN2 = new Cartesian3_default();
var cartesianToCartographicP2 = new Cartesian3_default();
var cartesianToCartographicH2 = new Cartesian3_default();
Ellipsoid.prototype.cartesianToCartographic = function(cartesian11, result) {
  const p = this.scaleToGeodeticSurface(cartesian11, cartesianToCartographicP2);
  if (!defined_default(p)) {
    return void 0;
  }
  const n = this.geodeticSurfaceNormal(p, cartesianToCartographicN2);
  const h = Cartesian3_default.subtract(cartesian11, p, cartesianToCartographicH2);
  const longitude = Math.atan2(n.y, n.x);
  const latitude = Math.asin(n.z);
  const height = Math_default.sign(Cartesian3_default.dot(h, cartesian11)) * Cartesian3_default.magnitude(h);
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
Ellipsoid.prototype.cartesianArrayToCartographicArray = function(cartesians, result) {
  Check_default.defined("cartesians", cartesians);
  const length3 = cartesians.length;
  if (!defined_default(result)) {
    result = new Array(length3);
  } else {
    result.length = length3;
  }
  for (let i = 0; i < length3; ++i) {
    result[i] = this.cartesianToCartographic(cartesians[i], result[i]);
  }
  return result;
};
Ellipsoid.prototype.scaleToGeodeticSurface = function(cartesian11, result) {
  return scaleToGeodeticSurface_default(
    cartesian11,
    this._oneOverRadii,
    this._oneOverRadiiSquared,
    this._centerToleranceSquared,
    result
  );
};
Ellipsoid.prototype.scaleToGeocentricSurface = function(cartesian11, result) {
  Check_default.typeOf.object("cartesian", cartesian11);
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  const positionX = cartesian11.x;
  const positionY = cartesian11.y;
  const positionZ = cartesian11.z;
  const oneOverRadiiSquared = this._oneOverRadiiSquared;
  const beta = 1 / Math.sqrt(
    positionX * positionX * oneOverRadiiSquared.x + positionY * positionY * oneOverRadiiSquared.y + positionZ * positionZ * oneOverRadiiSquared.z
  );
  return Cartesian3_default.multiplyByScalar(cartesian11, beta, result);
};
Ellipsoid.prototype.transformPositionToScaledSpace = function(position, result) {
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.multiplyComponents(position, this._oneOverRadii, result);
};
Ellipsoid.prototype.transformPositionFromScaledSpace = function(position, result) {
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  return Cartesian3_default.multiplyComponents(position, this._radii, result);
};
Ellipsoid.prototype.equals = function(right) {
  return this === right || defined_default(right) && Cartesian3_default.equals(this._radii, right._radii);
};
Ellipsoid.prototype.toString = function() {
  return this._radii.toString();
};
Ellipsoid.prototype.getSurfaceNormalIntersectionWithZAxis = function(position, buffer, result) {
  Check_default.typeOf.object("position", position);
  if (!Math_default.equalsEpsilon(
    this._radii.x,
    this._radii.y,
    Math_default.EPSILON15
  )) {
    throw new DeveloperError_default(
      "Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)"
    );
  }
  Check_default.typeOf.number.greaterThan("Ellipsoid.radii.z", this._radii.z, 0);
  buffer = defaultValue_default(buffer, 0);
  const squaredXOverSquaredZ = this._squaredXOverSquaredZ;
  if (!defined_default(result)) {
    result = new Cartesian3_default();
  }
  result.x = 0;
  result.y = 0;
  result.z = position.z * (1 - squaredXOverSquaredZ);
  if (Math.abs(result.z) >= this._radii.z - buffer) {
    return void 0;
  }
  return result;
};
var abscissas = [
  0.14887433898163,
  0.43339539412925,
  0.67940956829902,
  0.86506336668898,
  0.97390652851717,
  0
];
var weights = [
  0.29552422471475,
  0.26926671930999,
  0.21908636251598,
  0.14945134915058,
  0.066671344308684,
  0
];
function gaussLegendreQuadrature(a3, b, func) {
  Check_default.typeOf.number("a", a3);
  Check_default.typeOf.number("b", b);
  Check_default.typeOf.func("func", func);
  const xMean = 0.5 * (b + a3);
  const xRange = 0.5 * (b - a3);
  let sum = 0;
  for (let i = 0; i < 5; i++) {
    const dx = xRange * abscissas[i];
    sum += weights[i] * (func(xMean + dx) + func(xMean - dx));
  }
  sum *= xRange;
  return sum;
}
Ellipsoid.prototype.surfaceArea = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  const minLongitude = rectangle.west;
  let maxLongitude = rectangle.east;
  const minLatitude = rectangle.south;
  const maxLatitude = rectangle.north;
  while (maxLongitude < minLongitude) {
    maxLongitude += Math_default.TWO_PI;
  }
  const radiiSquared = this._radiiSquared;
  const a22 = radiiSquared.x;
  const b2 = radiiSquared.y;
  const c22 = radiiSquared.z;
  const a2b2 = a22 * b2;
  return gaussLegendreQuadrature(minLatitude, maxLatitude, function(lat) {
    const sinPhi = Math.cos(lat);
    const cosPhi = Math.sin(lat);
    return Math.cos(lat) * gaussLegendreQuadrature(minLongitude, maxLongitude, function(lon) {
      const cosTheta = Math.cos(lon);
      const sinTheta = Math.sin(lon);
      return Math.sqrt(
        a2b2 * cosPhi * cosPhi + c22 * (b2 * cosTheta * cosTheta + a22 * sinTheta * sinTheta) * sinPhi * sinPhi
      );
    });
  });
};
var Ellipsoid_default = Ellipsoid;

// Source/Core/GeographicProjection.js
function GeographicProjection(ellipsoid) {
  this._ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  this._semimajorAxis = this._ellipsoid.maximumRadius;
  this._oneOverSemimajorAxis = 1 / this._semimajorAxis;
}
Object.defineProperties(GeographicProjection.prototype, {
  ellipsoid: {
    get: function() {
      return this._ellipsoid;
    }
  }
});
GeographicProjection.prototype.project = function(cartographic2, result) {
  const semimajorAxis = this._semimajorAxis;
  const x = cartographic2.longitude * semimajorAxis;
  const y = cartographic2.latitude * semimajorAxis;
  const z = cartographic2.height;
  if (!defined_default(result)) {
    return new Cartesian3_default(x, y, z);
  }
  result.x = x;
  result.y = y;
  result.z = z;
  return result;
};
GeographicProjection.prototype.unproject = function(cartesian11, result) {
  if (!defined_default(cartesian11)) {
    throw new DeveloperError_default("cartesian is required");
  }
  const oneOverEarthSemimajorAxis = this._oneOverSemimajorAxis;
  const longitude = cartesian11.x * oneOverEarthSemimajorAxis;
  const latitude = cartesian11.y * oneOverEarthSemimajorAxis;
  const height = cartesian11.z;
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude, height);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = height;
  return result;
};
var GeographicProjection_default = GeographicProjection;

// Source/Core/Intersect.js
var Intersect = {
  OUTSIDE: -1,
  INTERSECTING: 0,
  INSIDE: 1
};
var Intersect_default = Object.freeze(Intersect);

// Source/Core/Rectangle.js
function Rectangle(west, south, east, north) {
  this.west = defaultValue_default(west, 0);
  this.south = defaultValue_default(south, 0);
  this.east = defaultValue_default(east, 0);
  this.north = defaultValue_default(north, 0);
}
Object.defineProperties(Rectangle.prototype, {
  width: {
    get: function() {
      return Rectangle.computeWidth(this);
    }
  },
  height: {
    get: function() {
      return Rectangle.computeHeight(this);
    }
  }
});
Rectangle.packedLength = 4;
Rectangle.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.west;
  array[startingIndex++] = value.south;
  array[startingIndex++] = value.east;
  array[startingIndex] = value.north;
  return array;
};
Rectangle.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  result.west = array[startingIndex++];
  result.south = array[startingIndex++];
  result.east = array[startingIndex++];
  result.north = array[startingIndex];
  return result;
};
Rectangle.computeWidth = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  let east = rectangle.east;
  const west = rectangle.west;
  if (east < west) {
    east += Math_default.TWO_PI;
  }
  return east - west;
};
Rectangle.computeHeight = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  return rectangle.north - rectangle.south;
};
Rectangle.fromDegrees = function(west, south, east, north, result) {
  west = Math_default.toRadians(defaultValue_default(west, 0));
  south = Math_default.toRadians(defaultValue_default(south, 0));
  east = Math_default.toRadians(defaultValue_default(east, 0));
  north = Math_default.toRadians(defaultValue_default(north, 0));
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.fromRadians = function(west, south, east, north, result) {
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = defaultValue_default(west, 0);
  result.south = defaultValue_default(south, 0);
  result.east = defaultValue_default(east, 0);
  result.north = defaultValue_default(north, 0);
  return result;
};
Rectangle.fromCartographicArray = function(cartographics, result) {
  Check_default.defined("cartographics", cartographics);
  let west = Number.MAX_VALUE;
  let east = -Number.MAX_VALUE;
  let westOverIDL = Number.MAX_VALUE;
  let eastOverIDL = -Number.MAX_VALUE;
  let south = Number.MAX_VALUE;
  let north = -Number.MAX_VALUE;
  for (let i = 0, len = cartographics.length; i < len; i++) {
    const position = cartographics[i];
    west = Math.min(west, position.longitude);
    east = Math.max(east, position.longitude);
    south = Math.min(south, position.latitude);
    north = Math.max(north, position.latitude);
    const lonAdjusted = position.longitude >= 0 ? position.longitude : position.longitude + Math_default.TWO_PI;
    westOverIDL = Math.min(westOverIDL, lonAdjusted);
    eastOverIDL = Math.max(eastOverIDL, lonAdjusted);
  }
  if (east - west > eastOverIDL - westOverIDL) {
    west = westOverIDL;
    east = eastOverIDL;
    if (east > Math_default.PI) {
      east = east - Math_default.TWO_PI;
    }
    if (west > Math_default.PI) {
      west = west - Math_default.TWO_PI;
    }
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.fromCartesianArray = function(cartesians, ellipsoid, result) {
  Check_default.defined("cartesians", cartesians);
  ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  let west = Number.MAX_VALUE;
  let east = -Number.MAX_VALUE;
  let westOverIDL = Number.MAX_VALUE;
  let eastOverIDL = -Number.MAX_VALUE;
  let south = Number.MAX_VALUE;
  let north = -Number.MAX_VALUE;
  for (let i = 0, len = cartesians.length; i < len; i++) {
    const position = ellipsoid.cartesianToCartographic(cartesians[i]);
    west = Math.min(west, position.longitude);
    east = Math.max(east, position.longitude);
    south = Math.min(south, position.latitude);
    north = Math.max(north, position.latitude);
    const lonAdjusted = position.longitude >= 0 ? position.longitude : position.longitude + Math_default.TWO_PI;
    westOverIDL = Math.min(westOverIDL, lonAdjusted);
    eastOverIDL = Math.max(eastOverIDL, lonAdjusted);
  }
  if (east - west > eastOverIDL - westOverIDL) {
    west = westOverIDL;
    east = eastOverIDL;
    if (east > Math_default.PI) {
      east = east - Math_default.TWO_PI;
    }
    if (west > Math_default.PI) {
      west = west - Math_default.TWO_PI;
    }
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.clone = function(rectangle, result) {
  if (!defined_default(rectangle)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(
      rectangle.west,
      rectangle.south,
      rectangle.east,
      rectangle.north
    );
  }
  result.west = rectangle.west;
  result.south = rectangle.south;
  result.east = rectangle.east;
  result.north = rectangle.north;
  return result;
};
Rectangle.equalsEpsilon = function(left, right, absoluteEpsilon) {
  absoluteEpsilon = defaultValue_default(absoluteEpsilon, 0);
  return left === right || defined_default(left) && defined_default(right) && Math.abs(left.west - right.west) <= absoluteEpsilon && Math.abs(left.south - right.south) <= absoluteEpsilon && Math.abs(left.east - right.east) <= absoluteEpsilon && Math.abs(left.north - right.north) <= absoluteEpsilon;
};
Rectangle.prototype.clone = function(result) {
  return Rectangle.clone(this, result);
};
Rectangle.prototype.equals = function(other) {
  return Rectangle.equals(this, other);
};
Rectangle.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.west === right.west && left.south === right.south && left.east === right.east && left.north === right.north;
};
Rectangle.prototype.equalsEpsilon = function(other, epsilon) {
  return Rectangle.equalsEpsilon(this, other, epsilon);
};
Rectangle.validate = function(rectangle) {
  Check_default.typeOf.object("rectangle", rectangle);
  const north = rectangle.north;
  Check_default.typeOf.number.greaterThanOrEquals(
    "north",
    north,
    -Math_default.PI_OVER_TWO
  );
  Check_default.typeOf.number.lessThanOrEquals("north", north, Math_default.PI_OVER_TWO);
  const south = rectangle.south;
  Check_default.typeOf.number.greaterThanOrEquals(
    "south",
    south,
    -Math_default.PI_OVER_TWO
  );
  Check_default.typeOf.number.lessThanOrEquals("south", south, Math_default.PI_OVER_TWO);
  const west = rectangle.west;
  Check_default.typeOf.number.greaterThanOrEquals("west", west, -Math.PI);
  Check_default.typeOf.number.lessThanOrEquals("west", west, Math.PI);
  const east = rectangle.east;
  Check_default.typeOf.number.greaterThanOrEquals("east", east, -Math.PI);
  Check_default.typeOf.number.lessThanOrEquals("east", east, Math.PI);
};
Rectangle.southwest = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.west, rectangle.south);
  }
  result.longitude = rectangle.west;
  result.latitude = rectangle.south;
  result.height = 0;
  return result;
};
Rectangle.northwest = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.west, rectangle.north);
  }
  result.longitude = rectangle.west;
  result.latitude = rectangle.north;
  result.height = 0;
  return result;
};
Rectangle.northeast = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.east, rectangle.north);
  }
  result.longitude = rectangle.east;
  result.latitude = rectangle.north;
  result.height = 0;
  return result;
};
Rectangle.southeast = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  if (!defined_default(result)) {
    return new Cartographic_default(rectangle.east, rectangle.south);
  }
  result.longitude = rectangle.east;
  result.latitude = rectangle.south;
  result.height = 0;
  return result;
};
Rectangle.center = function(rectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  let east = rectangle.east;
  const west = rectangle.west;
  if (east < west) {
    east += Math_default.TWO_PI;
  }
  const longitude = Math_default.negativePiToPi((west + east) * 0.5);
  const latitude = (rectangle.south + rectangle.north) * 0.5;
  if (!defined_default(result)) {
    return new Cartographic_default(longitude, latitude);
  }
  result.longitude = longitude;
  result.latitude = latitude;
  result.height = 0;
  return result;
};
Rectangle.intersection = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  let rectangleEast = rectangle.east;
  let rectangleWest = rectangle.west;
  let otherRectangleEast = otherRectangle.east;
  let otherRectangleWest = otherRectangle.west;
  if (rectangleEast < rectangleWest && otherRectangleEast > 0) {
    rectangleEast += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleEast > 0) {
    otherRectangleEast += Math_default.TWO_PI;
  }
  if (rectangleEast < rectangleWest && otherRectangleWest < 0) {
    otherRectangleWest += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleWest < 0) {
    rectangleWest += Math_default.TWO_PI;
  }
  const west = Math_default.negativePiToPi(
    Math.max(rectangleWest, otherRectangleWest)
  );
  const east = Math_default.negativePiToPi(
    Math.min(rectangleEast, otherRectangleEast)
  );
  if ((rectangle.west < rectangle.east || otherRectangle.west < otherRectangle.east) && east <= west) {
    return void 0;
  }
  const south = Math.max(rectangle.south, otherRectangle.south);
  const north = Math.min(rectangle.north, otherRectangle.north);
  if (south >= north) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.simpleIntersection = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  const west = Math.max(rectangle.west, otherRectangle.west);
  const south = Math.max(rectangle.south, otherRectangle.south);
  const east = Math.min(rectangle.east, otherRectangle.east);
  const north = Math.min(rectangle.north, otherRectangle.north);
  if (south >= north || west >= east) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new Rectangle(west, south, east, north);
  }
  result.west = west;
  result.south = south;
  result.east = east;
  result.north = north;
  return result;
};
Rectangle.union = function(rectangle, otherRectangle, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("otherRectangle", otherRectangle);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  let rectangleEast = rectangle.east;
  let rectangleWest = rectangle.west;
  let otherRectangleEast = otherRectangle.east;
  let otherRectangleWest = otherRectangle.west;
  if (rectangleEast < rectangleWest && otherRectangleEast > 0) {
    rectangleEast += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleEast > 0) {
    otherRectangleEast += Math_default.TWO_PI;
  }
  if (rectangleEast < rectangleWest && otherRectangleWest < 0) {
    otherRectangleWest += Math_default.TWO_PI;
  } else if (otherRectangleEast < otherRectangleWest && rectangleWest < 0) {
    rectangleWest += Math_default.TWO_PI;
  }
  const west = Math_default.negativePiToPi(
    Math.min(rectangleWest, otherRectangleWest)
  );
  const east = Math_default.negativePiToPi(
    Math.max(rectangleEast, otherRectangleEast)
  );
  result.west = west;
  result.south = Math.min(rectangle.south, otherRectangle.south);
  result.east = east;
  result.north = Math.max(rectangle.north, otherRectangle.north);
  return result;
};
Rectangle.expand = function(rectangle, cartographic2, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("cartographic", cartographic2);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  result.west = Math.min(rectangle.west, cartographic2.longitude);
  result.south = Math.min(rectangle.south, cartographic2.latitude);
  result.east = Math.max(rectangle.east, cartographic2.longitude);
  result.north = Math.max(rectangle.north, cartographic2.latitude);
  return result;
};
Rectangle.contains = function(rectangle, cartographic2) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("cartographic", cartographic2);
  let longitude = cartographic2.longitude;
  const latitude = cartographic2.latitude;
  const west = rectangle.west;
  let east = rectangle.east;
  if (east < west) {
    east += Math_default.TWO_PI;
    if (longitude < 0) {
      longitude += Math_default.TWO_PI;
    }
  }
  return (longitude > west || Math_default.equalsEpsilon(longitude, west, Math_default.EPSILON14)) && (longitude < east || Math_default.equalsEpsilon(longitude, east, Math_default.EPSILON14)) && latitude >= rectangle.south && latitude <= rectangle.north;
};
var subsampleLlaScratch = new Cartographic_default();
Rectangle.subsample = function(rectangle, ellipsoid, surfaceHeight, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  ellipsoid = defaultValue_default(ellipsoid, Ellipsoid_default.WGS84);
  surfaceHeight = defaultValue_default(surfaceHeight, 0);
  if (!defined_default(result)) {
    result = [];
  }
  let length3 = 0;
  const north = rectangle.north;
  const south = rectangle.south;
  const east = rectangle.east;
  const west = rectangle.west;
  const lla = subsampleLlaScratch;
  lla.height = surfaceHeight;
  lla.longitude = west;
  lla.latitude = north;
  result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
  length3++;
  lla.longitude = east;
  result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
  length3++;
  lla.latitude = south;
  result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
  length3++;
  lla.longitude = west;
  result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
  length3++;
  if (north < 0) {
    lla.latitude = north;
  } else if (south > 0) {
    lla.latitude = south;
  } else {
    lla.latitude = 0;
  }
  for (let i = 1; i < 8; ++i) {
    lla.longitude = -Math.PI + i * Math_default.PI_OVER_TWO;
    if (Rectangle.contains(rectangle, lla)) {
      result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
      length3++;
    }
  }
  if (lla.latitude === 0) {
    lla.longitude = west;
    result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
    length3++;
    lla.longitude = east;
    result[length3] = ellipsoid.cartographicToCartesian(lla, result[length3]);
    length3++;
  }
  result.length = length3;
  return result;
};
Rectangle.subsection = function(rectangle, westLerp, southLerp, eastLerp, northLerp, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.number.greaterThanOrEquals("westLerp", westLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("westLerp", westLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("southLerp", southLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("southLerp", southLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("eastLerp", eastLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("eastLerp", eastLerp, 1);
  Check_default.typeOf.number.greaterThanOrEquals("northLerp", northLerp, 0);
  Check_default.typeOf.number.lessThanOrEquals("northLerp", northLerp, 1);
  Check_default.typeOf.number.lessThanOrEquals("westLerp", westLerp, eastLerp);
  Check_default.typeOf.number.lessThanOrEquals("southLerp", southLerp, northLerp);
  if (!defined_default(result)) {
    result = new Rectangle();
  }
  if (rectangle.west <= rectangle.east) {
    const width = rectangle.east - rectangle.west;
    result.west = rectangle.west + westLerp * width;
    result.east = rectangle.west + eastLerp * width;
  } else {
    const width = Math_default.TWO_PI + rectangle.east - rectangle.west;
    result.west = Math_default.negativePiToPi(rectangle.west + westLerp * width);
    result.east = Math_default.negativePiToPi(rectangle.west + eastLerp * width);
  }
  const height = rectangle.north - rectangle.south;
  result.south = rectangle.south + southLerp * height;
  result.north = rectangle.south + northLerp * height;
  if (westLerp === 1) {
    result.west = rectangle.east;
  }
  if (eastLerp === 1) {
    result.east = rectangle.east;
  }
  if (southLerp === 1) {
    result.south = rectangle.north;
  }
  if (northLerp === 1) {
    result.north = rectangle.north;
  }
  return result;
};
Rectangle.MAX_VALUE = Object.freeze(
  new Rectangle(
    -Math.PI,
    -Math_default.PI_OVER_TWO,
    Math.PI,
    Math_default.PI_OVER_TWO
  )
);
var Rectangle_default = Rectangle;

// Source/Core/BoundingRectangle.js
function BoundingRectangle(x, y, width, height) {
  this.x = defaultValue_default(x, 0);
  this.y = defaultValue_default(y, 0);
  this.width = defaultValue_default(width, 0);
  this.height = defaultValue_default(height, 0);
}
BoundingRectangle.packedLength = 4;
BoundingRectangle.pack = function(value, array, startingIndex) {
  Check_default.typeOf.object("value", value);
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  array[startingIndex++] = value.x;
  array[startingIndex++] = value.y;
  array[startingIndex++] = value.width;
  array[startingIndex] = value.height;
  return array;
};
BoundingRectangle.unpack = function(array, startingIndex, result) {
  Check_default.defined("array", array);
  startingIndex = defaultValue_default(startingIndex, 0);
  if (!defined_default(result)) {
    result = new BoundingRectangle();
  }
  result.x = array[startingIndex++];
  result.y = array[startingIndex++];
  result.width = array[startingIndex++];
  result.height = array[startingIndex];
  return result;
};
BoundingRectangle.fromPoints = function(positions, result) {
  if (!defined_default(result)) {
    result = new BoundingRectangle();
  }
  if (!defined_default(positions) || positions.length === 0) {
    result.x = 0;
    result.y = 0;
    result.width = 0;
    result.height = 0;
    return result;
  }
  const length3 = positions.length;
  let minimumX = positions[0].x;
  let minimumY = positions[0].y;
  let maximumX = positions[0].x;
  let maximumY = positions[0].y;
  for (let i = 1; i < length3; i++) {
    const p = positions[i];
    const x = p.x;
    const y = p.y;
    minimumX = Math.min(x, minimumX);
    maximumX = Math.max(x, maximumX);
    minimumY = Math.min(y, minimumY);
    maximumY = Math.max(y, maximumY);
  }
  result.x = minimumX;
  result.y = minimumY;
  result.width = maximumX - minimumX;
  result.height = maximumY - minimumY;
  return result;
};
var defaultProjection = new GeographicProjection_default();
var fromRectangleLowerLeft = new Cartographic_default();
var fromRectangleUpperRight = new Cartographic_default();
BoundingRectangle.fromRectangle = function(rectangle, projection, result) {
  if (!defined_default(result)) {
    result = new BoundingRectangle();
  }
  if (!defined_default(rectangle)) {
    result.x = 0;
    result.y = 0;
    result.width = 0;
    result.height = 0;
    return result;
  }
  projection = defaultValue_default(projection, defaultProjection);
  const lowerLeft = projection.project(
    Rectangle_default.southwest(rectangle, fromRectangleLowerLeft)
  );
  const upperRight = projection.project(
    Rectangle_default.northeast(rectangle, fromRectangleUpperRight)
  );
  Cartesian2_default.subtract(upperRight, lowerLeft, upperRight);
  result.x = lowerLeft.x;
  result.y = lowerLeft.y;
  result.width = upperRight.x;
  result.height = upperRight.y;
  return result;
};
BoundingRectangle.clone = function(rectangle, result) {
  if (!defined_default(rectangle)) {
    return void 0;
  }
  if (!defined_default(result)) {
    return new BoundingRectangle(
      rectangle.x,
      rectangle.y,
      rectangle.width,
      rectangle.height
    );
  }
  result.x = rectangle.x;
  result.y = rectangle.y;
  result.width = rectangle.width;
  result.height = rectangle.height;
  return result;
};
BoundingRectangle.union = function(left, right, result) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  if (!defined_default(result)) {
    result = new BoundingRectangle();
  }
  const lowerLeftX = Math.min(left.x, right.x);
  const lowerLeftY = Math.min(left.y, right.y);
  const upperRightX = Math.max(left.x + left.width, right.x + right.width);
  const upperRightY = Math.max(left.y + left.height, right.y + right.height);
  result.x = lowerLeftX;
  result.y = lowerLeftY;
  result.width = upperRightX - lowerLeftX;
  result.height = upperRightY - lowerLeftY;
  return result;
};
BoundingRectangle.expand = function(rectangle, point, result) {
  Check_default.typeOf.object("rectangle", rectangle);
  Check_default.typeOf.object("point", point);
  result = BoundingRectangle.clone(rectangle, result);
  const width = point.x - result.x;
  const height = point.y - result.y;
  if (width > result.width) {
    result.width = width;
  } else if (width < 0) {
    result.width -= width;
    result.x = point.x;
  }
  if (height > result.height) {
    result.height = height;
  } else if (height < 0) {
    result.height -= height;
    result.y = point.y;
  }
  return result;
};
BoundingRectangle.intersect = function(left, right) {
  Check_default.typeOf.object("left", left);
  Check_default.typeOf.object("right", right);
  const leftX = left.x;
  const leftY = left.y;
  const rightX = right.x;
  const rightY = right.y;
  if (!(leftX > rightX + right.width || leftX + left.width < rightX || leftY + left.height < rightY || leftY > rightY + right.height)) {
    return Intersect_default.INTERSECTING;
  }
  return Intersect_default.OUTSIDE;
};
BoundingRectangle.equals = function(left, right) {
  return left === right || defined_default(left) && defined_default(right) && left.x === right.x && left.y === right.y && left.width === right.width && left.height === right.height;
};
BoundingRectangle.prototype.clone = function(result) {
  return BoundingRectangle.clone(this, result);
};
BoundingRectangle.prototype.intersect = function(right) {
  return BoundingRectangle.intersect(this, right);
};
BoundingRectangle.prototype.equals = function(right) {
  return BoundingRectangle.equals(this, right);
};
var BoundingRectangle_default = BoundingRectangle;

// Source/Core/PrimitiveType.js
var PrimitiveType = {
  POINTS: WebGLConstants_default.POINTS,
  LINES: WebGLConstants_default.LINES,
  LINE_LOOP: WebGLConstants_default.LINE_LOOP,
  LINE_STRIP: WebGLConstants_default.LINE_STRIP,
  TRIANGLES: WebGLConstants_default.TRIANGLES,
  TRIANGLE_STRIP: WebGLConstants_default.TRIANGLE_STRIP,
  TRIANGLE_FAN: WebGLConstants_default.TRIANGLE_FAN
};
PrimitiveType.isLines = function(primitiveType) {
  return primitiveType === PrimitiveType.LINES || primitiveType === PrimitiveType.LINE_LOOP || primitiveType === PrimitiveType.LINE_STRIP;
};
PrimitiveType.isTriangles = function(primitiveType) {
  return primitiveType === PrimitiveType.TRIANGLES || primitiveType === PrimitiveType.TRIANGLE_STRIP || primitiveType === PrimitiveType.TRIANGLE_FAN;
};
PrimitiveType.validate = function(primitiveType) {
  return primitiveType === PrimitiveType.POINTS || primitiveType === PrimitiveType.LINES || primitiveType === PrimitiveType.LINE_LOOP || primitiveType === PrimitiveType.LINE_STRIP || primitiveType === PrimitiveType.TRIANGLES || primitiveType === PrimitiveType.TRIANGLE_STRIP || primitiveType === PrimitiveType.TRIANGLE_FAN;
};
var PrimitiveType_default = Object.freeze(PrimitiveType);

// Source/Shaders/ViewportQuadVS.js
var ViewportQuadVS_default = "attribute vec4 position;\nattribute vec2 textureCoordinates;\n\nvarying vec2 v_textureCoordinates;\n\nvoid main() \n{\n    gl_Position = position;\n    v_textureCoordinates = textureCoordinates;\n}\n";

// Source/Renderer/DrawCommand.js
var Flags = {
  CULL: 1,
  OCCLUDE: 2,
  EXECUTE_IN_CLOSEST_FRUSTUM: 4,
  DEBUG_SHOW_BOUNDING_VOLUME: 8,
  CAST_SHADOWS: 16,
  RECEIVE_SHADOWS: 32,
  PICK_ONLY: 64,
  DEPTH_FOR_TRANSLUCENT_CLASSIFICATION: 128
};
function DrawCommand(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  this._boundingVolume = options.boundingVolume;
  this._orientedBoundingBox = options.orientedBoundingBox;
  this._modelMatrix = options.modelMatrix;
  this._primitiveType = defaultValue_default(
    options.primitiveType,
    PrimitiveType_default.TRIANGLES
  );
  this._vertexArray = options.vertexArray;
  this._count = options.count;
  this._offset = defaultValue_default(options.offset, 0);
  this._instanceCount = defaultValue_default(options.instanceCount, 0);
  this._shaderProgram = options.shaderProgram;
  this._uniformMap = options.uniformMap;
  this._renderState = options.renderState;
  this._framebuffer = options.framebuffer;
  this._pass = options.pass;
  this._owner = options.owner;
  this._debugOverlappingFrustums = 0;
  this._pickId = options.pickId;
  this._flags = 0;
  this.cull = defaultValue_default(options.cull, true);
  this.occlude = defaultValue_default(options.occlude, true);
  this.executeInClosestFrustum = defaultValue_default(
    options.executeInClosestFrustum,
    false
  );
  this.debugShowBoundingVolume = defaultValue_default(
    options.debugShowBoundingVolume,
    false
  );
  this.castShadows = defaultValue_default(options.castShadows, false);
  this.receiveShadows = defaultValue_default(options.receiveShadows, false);
  this.pickOnly = defaultValue_default(options.pickOnly, false);
  this.depthForTranslucentClassification = defaultValue_default(
    options.depthForTranslucentClassification,
    false
  );
  this.dirty = true;
  this.lastDirtyTime = 0;
  this.derivedCommands = {};
}
function hasFlag(command, flag) {
  return (command._flags & flag) === flag;
}
function setFlag(command, flag, value) {
  if (value) {
    command._flags |= flag;
  } else {
    command._flags &= ~flag;
  }
}
Object.defineProperties(DrawCommand.prototype, {
  boundingVolume: {
    get: function() {
      return this._boundingVolume;
    },
    set: function(value) {
      if (this._boundingVolume !== value) {
        this._boundingVolume = value;
        this.dirty = true;
      }
    }
  },
  orientedBoundingBox: {
    get: function() {
      return this._orientedBoundingBox;
    },
    set: function(value) {
      if (this._orientedBoundingBox !== value) {
        this._orientedBoundingBox = value;
        this.dirty = true;
      }
    }
  },
  cull: {
    get: function() {
      return hasFlag(this, Flags.CULL);
    },
    set: function(value) {
      if (hasFlag(this, Flags.CULL) !== value) {
        setFlag(this, Flags.CULL, value);
        this.dirty = true;
      }
    }
  },
  occlude: {
    get: function() {
      return hasFlag(this, Flags.OCCLUDE);
    },
    set: function(value) {
      if (hasFlag(this, Flags.OCCLUDE) !== value) {
        setFlag(this, Flags.OCCLUDE, value);
        this.dirty = true;
      }
    }
  },
  modelMatrix: {
    get: function() {
      return this._modelMatrix;
    },
    set: function(value) {
      if (this._modelMatrix !== value) {
        this._modelMatrix = value;
        this.dirty = true;
      }
    }
  },
  primitiveType: {
    get: function() {
      return this._primitiveType;
    },
    set: function(value) {
      if (this._primitiveType !== value) {
        this._primitiveType = value;
        this.dirty = true;
      }
    }
  },
  vertexArray: {
    get: function() {
      return this._vertexArray;
    },
    set: function(value) {
      if (this._vertexArray !== value) {
        this._vertexArray = value;
        this.dirty = true;
      }
    }
  },
  count: {
    get: function() {
      return this._count;
    },
    set: function(value) {
      if (this._count !== value) {
        this._count = value;
        this.dirty = true;
      }
    }
  },
  offset: {
    get: function() {
      return this._offset;
    },
    set: function(value) {
      if (this._offset !== value) {
        this._offset = value;
        this.dirty = true;
      }
    }
  },
  instanceCount: {
    get: function() {
      return this._instanceCount;
    },
    set: function(value) {
      if (this._instanceCount !== value) {
        this._instanceCount = value;
        this.dirty = true;
      }
    }
  },
  shaderProgram: {
    get: function() {
      return this._shaderProgram;
    },
    set: function(value) {
      if (this._shaderProgram !== value) {
        this._shaderProgram = value;
        this.dirty = true;
      }
    }
  },
  castShadows: {
    get: function() {
      return hasFlag(this, Flags.CAST_SHADOWS);
    },
    set: function(value) {
      if (hasFlag(this, Flags.CAST_SHADOWS) !== value) {
        setFlag(this, Flags.CAST_SHADOWS, value);
        this.dirty = true;
      }
    }
  },
  receiveShadows: {
    get: function() {
      return hasFlag(this, Flags.RECEIVE_SHADOWS);
    },
    set: function(value) {
      if (hasFlag(this, Flags.RECEIVE_SHADOWS) !== value) {
        setFlag(this, Flags.RECEIVE_SHADOWS, value);
        this.dirty = true;
      }
    }
  },
  uniformMap: {
    get: function() {
      return this._uniformMap;
    },
    set: function(value) {
      if (this._uniformMap !== value) {
        this._uniformMap = value;
        this.dirty = true;
      }
    }
  },
  renderState: {
    get: function() {
      return this._renderState;
    },
    set: function(value) {
      if (this._renderState !== value) {
        this._renderState = value;
        this.dirty = true;
      }
    }
  },
  framebuffer: {
    get: function() {
      return this._framebuffer;
    },
    set: function(value) {
      if (this._framebuffer !== value) {
        this._framebuffer = value;
        this.dirty = true;
      }
    }
  },
  pass: {
    get: function() {
      return this._pass;
    },
    set: function(value) {
      if (this._pass !== value) {
        this._pass = value;
        this.dirty = true;
      }
    }
  },
  executeInClosestFrustum: {
    get: function() {
      return hasFlag(this, Flags.EXECUTE_IN_CLOSEST_FRUSTUM);
    },
    set: function(value) {
      if (hasFlag(this, Flags.EXECUTE_IN_CLOSEST_FRUSTUM) !== value) {
        setFlag(this, Flags.EXECUTE_IN_CLOSEST_FRUSTUM, value);
        this.dirty = true;
      }
    }
  },
  owner: {
    get: function() {
      return this._owner;
    },
    set: function(value) {
      if (this._owner !== value) {
        this._owner = value;
        this.dirty = true;
      }
    }
  },
  debugShowBoundingVolume: {
    get: function() {
      return hasFlag(this, Flags.DEBUG_SHOW_BOUNDING_VOLUME);
    },
    set: function(value) {
      if (hasFlag(this, Flags.DEBUG_SHOW_BOUNDING_VOLUME) !== value) {
        setFlag(this, Flags.DEBUG_SHOW_BOUNDING_VOLUME, value);
        this.dirty = true;
      }
    }
  },
  debugOverlappingFrustums: {
    get: function() {
      return this._debugOverlappingFrustums;
    },
    set: function(value) {
      if (this._debugOverlappingFrustums !== value) {
        this._debugOverlappingFrustums = value;
        this.dirty = true;
      }
    }
  },
  pickId: {
    get: function() {
      return this._pickId;
    },
    set: function(value) {
      if (this._pickId !== value) {
        this._pickId = value;
        this.dirty = true;
      }
    }
  },
  pickOnly: {
    get: function() {
      return hasFlag(this, Flags.PICK_ONLY);
    },
    set: function(value) {
      if (hasFlag(this, Flags.PICK_ONLY) !== value) {
        setFlag(this, Flags.PICK_ONLY, value);
        this.dirty = true;
      }
    }
  },
  depthForTranslucentClassification: {
    get: function() {
      return hasFlag(this, Flags.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION);
    },
    set: function(value) {
      if (hasFlag(this, Flags.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION) !== value) {
        setFlag(this, Flags.DEPTH_FOR_TRANSLUCENT_CLASSIFICATION, value);
        this.dirty = true;
      }
    }
  }
});
DrawCommand.shallowClone = function(command, result) {
  if (!defined_default(command)) {
    return void 0;
  }
  if (!defined_default(result)) {
    result = new DrawCommand();
  }
  result._boundingVolume = command._boundingVolume;
  result._orientedBoundingBox = command._orientedBoundingBox;
  result._modelMatrix = command._modelMatrix;
  result._primitiveType = command._primitiveType;
  result._vertexArray = command._vertexArray;
  result._count = command._count;
  result._offset = command._offset;
  result._instanceCount = command._instanceCount;
  result._shaderProgram = command._shaderProgram;
  result._uniformMap = command._uniformMap;
  result._renderState = command._renderState;
  result._framebuffer = command._framebuffer;
  result._pass = command._pass;
  result._owner = command._owner;
  result._debugOverlappingFrustums = command._debugOverlappingFrustums;
  result._pickId = command._pickId;
  result._flags = command._flags;
  result.dirty = true;
  result.lastDirtyTime = 0;
  return result;
};
DrawCommand.prototype.execute = function(context, passState) {
  context.draw(this, passState);
};
var DrawCommand_default = DrawCommand;

// Source/Renderer/PixelDatatype.js
var PixelDatatype = {
  UNSIGNED_BYTE: WebGLConstants_default.UNSIGNED_BYTE,
  UNSIGNED_SHORT: WebGLConstants_default.UNSIGNED_SHORT,
  UNSIGNED_INT: WebGLConstants_default.UNSIGNED_INT,
  FLOAT: WebGLConstants_default.FLOAT,
  HALF_FLOAT: WebGLConstants_default.HALF_FLOAT_OES,
  UNSIGNED_INT_24_8: WebGLConstants_default.UNSIGNED_INT_24_8,
  UNSIGNED_SHORT_4_4_4_4: WebGLConstants_default.UNSIGNED_SHORT_4_4_4_4,
  UNSIGNED_SHORT_5_5_5_1: WebGLConstants_default.UNSIGNED_SHORT_5_5_5_1,
  UNSIGNED_SHORT_5_6_5: WebGLConstants_default.UNSIGNED_SHORT_5_6_5
};
PixelDatatype.toWebGLConstant = function(pixelDatatype, context) {
  switch (pixelDatatype) {
    case PixelDatatype.UNSIGNED_BYTE:
      return WebGLConstants_default.UNSIGNED_BYTE;
    case PixelDatatype.UNSIGNED_SHORT:
      return WebGLConstants_default.UNSIGNED_SHORT;
    case PixelDatatype.UNSIGNED_INT:
      return WebGLConstants_default.UNSIGNED_INT;
    case PixelDatatype.FLOAT:
      return WebGLConstants_default.FLOAT;
    case PixelDatatype.HALF_FLOAT:
      return context.webgl2 ? WebGLConstants_default.HALF_FLOAT : WebGLConstants_default.HALF_FLOAT_OES;
    case PixelDatatype.UNSIGNED_INT_24_8:
      return WebGLConstants_default.UNSIGNED_INT_24_8;
    case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:
      return WebGLConstants_default.UNSIGNED_SHORT_4_4_4_4;
    case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:
      return WebGLConstants_default.UNSIGNED_SHORT_5_5_5_1;
    case PixelDatatype.UNSIGNED_SHORT_5_6_5:
      return PixelDatatype.UNSIGNED_SHORT_5_6_5;
  }
};
PixelDatatype.isPacked = function(pixelDatatype) {
  return pixelDatatype === PixelDatatype.UNSIGNED_INT_24_8 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_4_4_4_4 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_5_5_5_1 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_5_6_5;
};
PixelDatatype.sizeInBytes = function(pixelDatatype) {
  switch (pixelDatatype) {
    case PixelDatatype.UNSIGNED_BYTE:
      return 1;
    case PixelDatatype.UNSIGNED_SHORT:
    case PixelDatatype.UNSIGNED_SHORT_4_4_4_4:
    case PixelDatatype.UNSIGNED_SHORT_5_5_5_1:
    case PixelDatatype.UNSIGNED_SHORT_5_6_5:
    case PixelDatatype.HALF_FLOAT:
      return 2;
    case PixelDatatype.UNSIGNED_INT:
    case PixelDatatype.FLOAT:
    case PixelDatatype.UNSIGNED_INT_24_8:
      return 4;
  }
};
PixelDatatype.validate = function(pixelDatatype) {
  return pixelDatatype === PixelDatatype.UNSIGNED_BYTE || pixelDatatype === PixelDatatype.UNSIGNED_SHORT || pixelDatatype === PixelDatatype.UNSIGNED_INT || pixelDatatype === PixelDatatype.FLOAT || pixelDatatype === PixelDatatype.HALF_FLOAT || pixelDatatype === PixelDatatype.UNSIGNED_INT_24_8 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_4_4_4_4 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_5_5_5_1 || pixelDatatype === PixelDatatype.UNSIGNED_SHORT_5_6_5;
};
var PixelDatatype_default = Object.freeze(PixelDatatype);

// Source/Core/PixelFormat.js
var PixelFormat = {
  DEPTH_COMPONENT: WebGLConstants_default.DEPTH_COMPONENT,
  DEPTH_STENCIL: WebGLConstants_default.DEPTH_STENCIL,
  ALPHA: WebGLConstants_default.ALPHA,
  RGB: WebGLConstants_default.RGB,
  RGBA: WebGLConstants_default.RGBA,
  LUMINANCE: WebGLConstants_default.LUMINANCE,
  LUMINANCE_ALPHA: WebGLConstants_default.LUMINANCE_ALPHA,
  RGB_DXT1: WebGLConstants_default.COMPRESSED_RGB_S3TC_DXT1_EXT,
  RGBA_DXT1: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT1_EXT,
  RGBA_DXT3: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT3_EXT,
  RGBA_DXT5: WebGLConstants_default.COMPRESSED_RGBA_S3TC_DXT5_EXT,
  RGB_PVRTC_4BPPV1: WebGLConstants_default.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,
  RGB_PVRTC_2BPPV1: WebGLConstants_default.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,
  RGBA_PVRTC_4BPPV1: WebGLConstants_default.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,
  RGBA_PVRTC_2BPPV1: WebGLConstants_default.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,
  RGBA_ASTC: WebGLConstants_default.COMPRESSED_RGBA_ASTC_4x4_WEBGL,
  RGB_ETC1: WebGLConstants_default.COMPRESSED_RGB_ETC1_WEBGL,
  RGB8_ETC2: WebGLConstants_default.COMPRESSED_RGB8_ETC2,
  RGBA8_ETC2_EAC: WebGLConstants_default.COMPRESSED_RGBA8_ETC2_EAC,
  RGBA_BC7: WebGLConstants_default.COMPRESSED_RGBA_BPTC_UNORM
};
PixelFormat.componentsLength = function(pixelFormat) {
  switch (pixelFormat) {
    case PixelFormat.RGB:
      return 3;
    case PixelFormat.RGBA:
      return 4;
    case PixelFormat.LUMINANCE_ALPHA:
      return 2;
    case PixelFormat.ALPHA:
    case PixelFormat.LUMINANCE:
      return 1;
    default:
      return 1;
  }
};
PixelFormat.validate = function(pixelFormat) {
  return pixelFormat === PixelFormat.DEPTH_COMPONENT || pixelFormat === PixelFormat.DEPTH_STENCIL || pixelFormat === PixelFormat.ALPHA || pixelFormat === PixelFormat.RGB || pixelFormat === PixelFormat.RGBA || pixelFormat === PixelFormat.LUMINANCE || pixelFormat === PixelFormat.LUMINANCE_ALPHA || pixelFormat === PixelFormat.RGB_DXT1 || pixelFormat === PixelFormat.RGBA_DXT1 || pixelFormat === PixelFormat.RGBA_DXT3 || pixelFormat === PixelFormat.RGBA_DXT5 || pixelFormat === PixelFormat.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_ASTC || pixelFormat === PixelFormat.RGB_ETC1 || pixelFormat === PixelFormat.RGB8_ETC2 || pixelFormat === PixelFormat.RGBA8_ETC2_EAC || pixelFormat === PixelFormat.RGBA_BC7;
};
PixelFormat.isColorFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat.ALPHA || pixelFormat === PixelFormat.RGB || pixelFormat === PixelFormat.RGBA || pixelFormat === PixelFormat.LUMINANCE || pixelFormat === PixelFormat.LUMINANCE_ALPHA;
};
PixelFormat.isDepthFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat.DEPTH_COMPONENT || pixelFormat === PixelFormat.DEPTH_STENCIL;
};
PixelFormat.isCompressedFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat.RGB_DXT1 || pixelFormat === PixelFormat.RGBA_DXT1 || pixelFormat === PixelFormat.RGBA_DXT3 || pixelFormat === PixelFormat.RGBA_DXT5 || pixelFormat === PixelFormat.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_ASTC || pixelFormat === PixelFormat.RGB_ETC1 || pixelFormat === PixelFormat.RGB8_ETC2 || pixelFormat === PixelFormat.RGBA8_ETC2_EAC || pixelFormat === PixelFormat.RGBA_BC7;
};
PixelFormat.isDXTFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat.RGB_DXT1 || pixelFormat === PixelFormat.RGBA_DXT1 || pixelFormat === PixelFormat.RGBA_DXT3 || pixelFormat === PixelFormat.RGBA_DXT5;
};
PixelFormat.isPVRTCFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat.RGB_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGB_PVRTC_2BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_4BPPV1 || pixelFormat === PixelFormat.RGBA_PVRTC_2BPPV1;
};
PixelFormat.isASTCFormat = function(pixelFormat) {
  return pixelFormat === PixelFormat.RGBA_ASTC;
};
PixelFormat.isETC1Format = function(pixelFormat) {
  return pixelFormat === PixelFormat.RGB_ETC1;
};
PixelFormat.isETC2Format = function(pixelFormat) {
  return pixelFormat === PixelFormat.RGB8_ETC2 || pixelFormat === PixelFormat.RGBA8_ETC2_EAC;
};
PixelFormat.isBC7Format = function(pixelFormat) {
  return pixelFormat === PixelFormat.RGBA_BC7;
};
PixelFormat.compressedTextureSizeInBytes = function(pixelFormat, width, height) {
  switch (pixelFormat) {
    case PixelFormat.RGB_DXT1:
    case PixelFormat.RGBA_DXT1:
    case PixelFormat.RGB_ETC1:
    case PixelFormat.RGB8_ETC2:
      return Math.floor((width + 3) / 4) * Math.floor((height + 3) / 4) * 8;
    case PixelFormat.RGBA_DXT3:
    case PixelFormat.RGBA_DXT5:
    case PixelFormat.RGBA_ASTC:
    case PixelFormat.RGBA8_ETC2_EAC:
      return Math.floor((width + 3) / 4) * Math.floor((height + 3) / 4) * 16;
    case PixelFormat.RGB_PVRTC_4BPPV1:
    case PixelFormat.RGBA_PVRTC_4BPPV1:
      return Math.floor((Math.max(width, 8) * Math.max(height, 8) * 4 + 7) / 8);
    case PixelFormat.RGB_PVRTC_2BPPV1:
    case PixelFormat.RGBA_PVRTC_2BPPV1:
      return Math.floor(
        (Math.max(width, 16) * Math.max(height, 8) * 2 + 7) / 8
      );
    case PixelFormat.RGBA_BC7:
      return Math.ceil(width / 4) * Math.ceil(height / 4) * 16;
    default:
      return 0;
  }
};
PixelFormat.textureSizeInBytes = function(pixelFormat, pixelDatatype, width, height) {
  let componentsLength = PixelFormat.componentsLength(pixelFormat);
  if (PixelDatatype_default.isPacked(pixelDatatype)) {
    componentsLength = 1;
  }
  return componentsLength * PixelDatatype_default.sizeInBytes(pixelDatatype) * width * height;
};
PixelFormat.alignmentInBytes = function(pixelFormat, pixelDatatype, width) {
  const mod2 = PixelFormat.textureSizeInBytes(pixelFormat, pixelDatatype, width, 1) % 4;
  return mod2 === 0 ? 4 : mod2 === 2 ? 2 : 1;
};
PixelFormat.createTypedArray = function(pixelFormat, pixelDatatype, width, height) {
  let constructor;
  const sizeInBytes = PixelDatatype_default.sizeInBytes(pixelDatatype);
  if (sizeInBytes === Uint8Array.BYTES_PER_ELEMENT) {
    constructor = Uint8Array;
  } else if (sizeInBytes === Uint16Array.BYTES_PER_ELEMENT) {
    constructor = Uint16Array;
  } else if (sizeInBytes === Float32Array.BYTES_PER_ELEMENT && pixelDatatype === PixelDatatype_default.FLOAT) {
    constructor = Float32Array;
  } else {
    constructor = Uint32Array;
  }
  const size = PixelFormat.componentsLength(pixelFormat) * width * height;
  return new constructor(size);
};
PixelFormat.flipY = function(bufferView, pixelFormat, pixelDatatype, width, height) {
  if (height === 1) {
    return bufferView;
  }
  const flipped = PixelFormat.createTypedArray(
    pixelFormat,
    pixelDatatype,
    width,
    height
  );
  const numberOfComponents = PixelFormat.componentsLength(pixelFormat);
  const textureWidth = width * numberOfComponents;
  for (let i = 0; i < height; ++i) {
    const row = i * width * numberOfComponents;
    const flippedRow = (height - i - 1) * width * numberOfComponents;
    for (let j = 0; j < textureWidth; ++j) {
      flipped[flippedRow + j] = bufferView[row + j];
    }
  }
  return flipped;
};
PixelFormat.toInternalFormat = function(pixelFormat, pixelDatatype, context) {
  if (!context.webgl2) {
    return pixelFormat;
  }
  if (pixelFormat === PixelFormat.DEPTH_STENCIL) {
    return WebGLConstants_default.DEPTH24_STENCIL8;
  }
  if (pixelFormat === PixelFormat.DEPTH_COMPONENT) {
    if (pixelDatatype === PixelDatatype_default.UNSIGNED_SHORT) {
      return WebGLConstants_default.DEPTH_COMPONENT16;
    } else if (pixelDatatype === PixelDatatype_default.UNSIGNED_INT) {
      return WebGLConstants_default.DEPTH_COMPONENT24;
    }
  }
  if (pixelDatatype === PixelDatatype_default.FLOAT) {
    switch (pixelFormat) {
      case PixelFormat.RGBA:
        return WebGLConstants_default.RGBA32F;
      case PixelFormat.RGB:
        return WebGLConstants_default.RGB32F;
      case PixelFormat.RG:
        return WebGLConstants_default.RG32F;
      case PixelFormat.R:
        return WebGLConstants_default.R32F;
    }
  }
  if (pixelDatatype === PixelDatatype_default.HALF_FLOAT) {
    switch (pixelFormat) {
      case PixelFormat.RGBA:
        return WebGLConstants_default.RGBA16F;
      case PixelFormat.RGB:
        return WebGLConstants_default.RGB16F;
      case PixelFormat.RG:
        return WebGLConstants_default.RG16F;
      case PixelFormat.R:
        return WebGLConstants_default.R16F;
    }
  }
  return pixelFormat;
};
var PixelFormat_default = Object.freeze(PixelFormat);

// Source/Renderer/ContextLimits.js
var ContextLimits = {
  _maximumCombinedTextureImageUnits: 0,
  _maximumCubeMapSize: 0,
  _maximumFragmentUniformVectors: 0,
  _maximumTextureImageUnits: 0,
  _maximumRenderbufferSize: 0,
  _maximumTextureSize: 0,
  _maximumVaryingVectors: 0,
  _maximumVertexAttributes: 0,
  _maximumVertexTextureImageUnits: 0,
  _maximumVertexUniformVectors: 0,
  _minimumAliasedLineWidth: 0,
  _maximumAliasedLineWidth: 0,
  _minimumAliasedPointSize: 0,
  _maximumAliasedPointSize: 0,
  _maximumViewportWidth: 0,
  _maximumViewportHeight: 0,
  _maximumTextureFilterAnisotropy: 0,
  _maximumDrawBuffers: 0,
  _maximumColorAttachments: 0,
  _maximumSamples: 0,
  _highpFloatSupported: false,
  _highpIntSupported: false
};
Object.defineProperties(ContextLimits, {
  maximumCombinedTextureImageUnits: {
    get: function() {
      return ContextLimits._maximumCombinedTextureImageUnits;
    }
  },
  maximumCubeMapSize: {
    get: function() {
      return ContextLimits._maximumCubeMapSize;
    }
  },
  maximumFragmentUniformVectors: {
    get: function() {
      return ContextLimits._maximumFragmentUniformVectors;
    }
  },
  maximumTextureImageUnits: {
    get: function() {
      return ContextLimits._maximumTextureImageUnits;
    }
  },
  maximumRenderbufferSize: {
    get: function() {
      return ContextLimits._maximumRenderbufferSize;
    }
  },
  maximumTextureSize: {
    get: function() {
      return ContextLimits._maximumTextureSize;
    }
  },
  maximumVaryingVectors: {
    get: function() {
      return ContextLimits._maximumVaryingVectors;
    }
  },
  maximumVertexAttributes: {
    get: function() {
      return ContextLimits._maximumVertexAttributes;
    }
  },
  maximumVertexTextureImageUnits: {
    get: function() {
      return ContextLimits._maximumVertexTextureImageUnits;
    }
  },
  maximumVertexUniformVectors: {
    get: function() {
      return ContextLimits._maximumVertexUniformVectors;
    }
  },
  minimumAliasedLineWidth: {
    get: function() {
      return ContextLimits._minimumAliasedLineWidth;
    }
  },
  maximumAliasedLineWidth: {
    get: function() {
      return ContextLimits._maximumAliasedLineWidth;
    }
  },
  minimumAliasedPointSize: {
    get: function() {
      return ContextLimits._minimumAliasedPointSize;
    }
  },
  maximumAliasedPointSize: {
    get: function() {
      return ContextLimits._maximumAliasedPointSize;
    }
  },
  maximumViewportWidth: {
    get: function() {
      return ContextLimits._maximumViewportWidth;
    }
  },
  maximumViewportHeight: {
    get: function() {
      return ContextLimits._maximumViewportHeight;
    }
  },
  maximumTextureFilterAnisotropy: {
    get: function() {
      return ContextLimits._maximumTextureFilterAnisotropy;
    }
  },
  maximumDrawBuffers: {
    get: function() {
      return ContextLimits._maximumDrawBuffers;
    }
  },
  maximumColorAttachments: {
    get: function() {
      return ContextLimits._maximumColorAttachments;
    }
  },
  maximumSamples: {
    get: function() {
      return ContextLimits._maximumSamples;
    }
  },
  highpFloatSupported: {
    get: function() {
      return ContextLimits._highpFloatSupported;
    }
  },
  highpIntSupported: {
    get: function() {
      return ContextLimits._highpIntSupported;
    }
  }
});
var ContextLimits_default = ContextLimits;

// Source/Renderer/Framebuffer.js
function attachTexture(framebuffer, attachment, texture) {
  const gl = framebuffer._gl;
  gl.framebufferTexture2D(
    gl.FRAMEBUFFER,
    attachment,
    texture._target,
    texture._texture,
    0
  );
}
function attachRenderbuffer(framebuffer, attachment, renderbuffer) {
  const gl = framebuffer._gl;
  gl.framebufferRenderbuffer(
    gl.FRAMEBUFFER,
    attachment,
    gl.RENDERBUFFER,
    renderbuffer._getRenderbuffer()
  );
}
function Framebuffer(options) {
  options = defaultValue_default(options, defaultValue_default.EMPTY_OBJECT);
  const context = options.context;
  Check_default.defined("options.context", context);
  const gl = context._gl;
  const maximumColorAttachments = ContextLimits_default.maximumColorAttachments;
  this._gl = gl;
  this._framebuffer = gl.createFramebuffer();
  this._colorTextures = [];
  this._colorRenderbuffers = [];
  this._activeColorAttachments = [];
  this._depthTexture = void 0;
  this._depthRenderbuffer = void 0;
  this._stencilRenderbuffer = void 0;
  this._depthStencilTexture = void 0;
  this._depthStencilRenderbuffer = void 0;
  this.destroyAttachments = defaultValue_default(options.destroyAttachments, true);
  if (defined_default(options.colorTextures) && defined_default(options.colorRenderbuffers)) {
    throw new DeveloperError_default(
      "Cannot have both color texture and color renderbuffer attachments."
    );
  }
  if (defined_default(options.depthTexture) && defined_default(options.depthRenderbuffer)) {
    throw new DeveloperError_default(
      "Cannot have both a depth texture and depth renderbuffer attachment."
    );
  }
  if (defined_default(options.depthStencilTexture) && defined_default(options.depthStencilRenderbuffer)) {
    throw new DeveloperError_default(
      "Cannot have both a depth-stencil texture and depth-stencil renderbuffer attachment."
    );
  }
  const depthAttachment = defined_default(options.depthTexture) || defined_default(options.depthRenderbuffer);
  const depthStencilAttachment = defined_default(options.depthStencilTexture) || defined_default(options.depthStencilRenderbuffer);
  if (depthAttachment && depthStencilAttachment) {
    throw new DeveloperError_default(
      "Cannot have both a depth and depth-stencil attachment."
    );
  }
  if (defined_default(options.stencilRenderbuffer) && depthStencilAttachment) {
    throw new DeveloperError_default(
      "Cannot have both a stencil and depth-stencil attachment."
    );
  }
  if (depthAttachment && defined_default(options.stencilRenderbuffer)) {
    throw new DeveloperError_default(
      "Cannot have both a depth and stencil attachment."
    );
  }
  this._bind();
  let texture;
  let renderbuffer;
  let i;
  let length3;
  let attachmentEnum;
  if (defined_default(options.colorTextures)) {
    const textures = options.colorTextures;
    length3 = this._colorTextures.length = this._activeColorAttachments.length = textures.length;
    if (length3 > maximumColorAttachments) {
      throw new DeveloperError_default(
        "The number of color attachments exceeds the number supported."
      );
    }
    for (i = 0; i < length3; ++i) {
      texture = textures[i];
      if (!PixelFormat_default.isColorFormat(texture.pixelFormat)) {
        throw new DeveloperError_default(
          "The color-texture pixel-format must be a color format."
        );
      }
      if (texture.pixelDatatype === PixelDatatype_default.FLOAT && !context.colorBufferFloat) {
        throw new DeveloperError_default(
          "The color texture pixel datatype is FLOAT and the WebGL implementation does not support the EXT_color_buffer_float or WEBGL_color_buffer_float extensions. See Context.colorBufferFloat."
        );
      }
      if (texture.pixelDatatype === PixelDatatype_default.HALF_FLOAT && !context.colorBufferHalfFloat) {
        throw new DeveloperError_default(
          "The color texture pixel datatype is HALF_FLOAT and the WebGL implementation does not support the EXT_color_buffer_half_float extension. See Context.colorBufferHalfFloat."
        );
      }
      attachmentEnum = this._gl.COLOR_ATTACHMENT0 + i;
      attachTexture(this, attachmentEnum, texture);
      this._activeColorAttachments[i] = attachmentEnum;
      this._colorTextures[i] = texture;
    }
  }
  if (defined_default(options.colorRenderbuffers)) {
    const renderbuffers = options.colorRenderbuffers;
    length3 = this._colorRenderbuffers.length = this._activeColorAttachments.length = renderbuffers.length;
    if (length3 > maximumColorAttachments) {
      throw new DeveloperError_default(
        "The number of color attachments exceeds the number supported."
      );
    }
    for (i = 0; i < length3; ++i) {
      renderbuffer = renderbuffers[i];
      attachmentEnum = this._gl.COLOR_ATTACHMENT0 + i;
      attachRenderbuffer(this, attachmentEnum, renderbuffer);
      this._activeColorAttachments[i] = attachmentEnum;
      this._colorRenderbuffers[i] = renderbuffer;
    }
  }
  if (defined_default(options.depthTexture)) {
    texture = options.depthTexture;
    if (texture.pixelFormat !== PixelFormat_default.DEPTH_COMPONENT) {
      throw new DeveloperError_default(
        "The depth-texture pixel-format must be DEPTH_COMPONENT."
      );
    }
    attachTexture(this, this._gl.DEPTH_ATTACHMENT, texture);
    this._depthTexture = texture;
  }
  if (defined_default(options.depthRenderbuffer)) {
    renderbuffer = options.depthRenderbuffer;
    attachRenderbuffer(this, this._gl.DEPTH_ATTACHMENT, renderbuffer);
    this._depthRenderbuffer = renderbuffer;
  }
  if (defined_default(options.stencilRenderbuffer)) {
    renderbuffer = options.stencilRenderbuffer;
    attachRenderbuffer(this, this._gl.STENCIL_ATTACHMENT, renderbuffer);
    this._stencilRenderbuffer = renderbuffer;
  }
  if (defined_default(options.depthStencilTexture)) {
    texture = options.depthStencilTexture;
    if (texture.pixelFormat !== PixelFormat_default.DEPTH_STENCIL) {
      throw new DeveloperError_default(
        "The depth-stencil pixel-format must be DEPTH_STENCIL."
      );
    }
    attachTexture(this, this._gl.DEPTH_STENCIL_ATTACHMENT, texture);
    this._depthStencilTexture = texture;
  }
  if (defined_default(options.depthStencilRenderbuffer)) {
    renderbuffer = options.depthStencilRenderbuffer;
    attachRenderbuffer(this, this._gl.DEPTH_STENCIL_ATTACHMENT, renderbuffer);
    this._depthStencilRenderbuffer = renderbuffer;
  }
  this._unBind();
}
Object.defineProperties(Framebuffer.prototype, {
  status: {
    get: function() {
      this._bind();
      const status = this._gl.checkFramebufferStatus(this._gl.FRAMEBUFFER);
      this._unBind();
      return status;
    }
  },
  numberOfColorAttachments: {
    get: function() {
      return this._activeColorAttachments.length;
    }
  },
  depthTexture: {
    get: function() {
      return this._depthTexture;
    }
  },
  depthRenderbuffer: {
    get: function() {
      return this._depthRenderbuffer;
    }
  },
  stencilRenderbuffer: {
    get: function() {
      return this._stencilRenderbuffer;
    }
  },
  depthStencilTexture: {
    get: function() {
      return this._depthStencilTexture;
    }
  },
  depthStencilRenderbuffer: {
    get: function() {
      return this._depthStencilRenderbuffer;
    }
  },
  hasDepthAttachment: {
    get: function() {
      return !!(this.depthTexture || this.depthRenderbuffer || this.depthStencilTexture || this.depthStencilRenderbuffer);
    }
  }
});
Framebuffer.prototype._bind = function() {
  const gl = this._gl;
  gl.bindFramebuffer(gl.FRAMEBUFFER, this._framebuffer);
};
Framebuffer.prototype._unBind = function() {
  const gl = this._gl;
  gl.bindFramebuffer(gl.FRAMEBUFFER, null);
};
Framebuffer.prototype.bindDraw = function() {
  const gl = this._gl;
  gl.bindFramebuffer(gl.DRAW_FRAMEBUFFER, this._framebuffer);
};
Framebuffer.prototype.bindRead = function() {
  const gl = this._gl;
  gl.bindFramebuffer(gl.READ_FRAMEBUFFER, this._framebuffer);
};
Framebuffer.prototype._getActiveColorAttachments = function() {
  return this._activeColorAttachments;
};
Framebuffer.prototype.getColorTexture = function(index) {
  if (!defined_default(index) || index < 0 || index >= this._colorTextures.length) {
    throw new DeveloperError_default(
      "index is required, must be greater than or equal to zero and must be less than the number of color attachments."
    );
  }
  return this._colorTextures[index];
};
Framebuffer.prototype.getColorRenderbuffer = function(index) {
  if (!defined_default(index) || index < 0 || index >= this._colorRenderbuffers.length) {
    throw new DeveloperError_default(
      "index is required, must be greater than or equal to zero and must be less than the number of color attachments."
    );
  }
  return this._colorRenderbuffers[index];
};
Framebuffer.prototype.isDestroyed = function() {
  return false;
};
Framebuffer.prototype.destroy = function() {
  if (this.destroyAttachments) {
    let i = 0;
    const textures = this._colorTextures;
    let length3 = textures.length;
    for (; i < length3; ++i) {
      const texture = textures[i];
      if (defined_default(texture)) {
        texture.destroy();
      }
    }
    const renderbuffers = this._colorRenderbuffers;
    length3 = renderbuffers.length;
    for (i = 0; i < length3; ++i) {
      const renderbuffer = renderbuffers[i];
      if (defined_default(renderbuffer)) {
        renderbuffer.destroy();
      }
    }
    this._depthTexture = this._depthTexture && this._depthTexture.destroy();
    this._depthRenderbuffer = this._depthRenderbuffer && this._depthRenderbuffer.destroy();
    this._stencilRenderbuffer = this._stencilRenderbuffer && this._stencilRenderbuffer.destroy();
    this._depthStencilTexture = this._depthStencilTexture && this._depthStencilTexture.destroy();
    this._depthStencilRenderbuffer = this._depthStencilRenderbuffer && this._depthStencilRenderbuffer.destroy();
  }
  this._gl.deleteFramebuffer(this._framebuffer);
  return destroyObject_default(this);
};
var Framebuffer_default = Framebuffer;

// Source/Core/WindingOrder.js
var WindingOrder = {
  CLOCKWISE: WebGLConstants_default.CW,
  COUNTER_CLOCKWISE: WebGLConstants_default.CCW
};
WindingOrder.validate = function(windingOrder) {
  return windingOrder === WindingOrder.CLOCKWISE || windingOrder === WindingOrder.COUNTER_CLOCKWISE;
};
var WindingOrder_default = Object.freeze(WindingOrder);

// Source/Renderer/freezeRenderState.js
function freezeRenderState(renderState) {
  if (typeof renderState !== "object" || renderState === null) {
    return renderState;
  }
  let propName;
  const propNames = Object.keys(renderState);
  for (let i = 0; i < propNames.length; i++) {
    propName = propNames[i];
    if (renderState.hasOwnProperty(propName) && propName !== "_applyFunctions") {
      renderState[propName] = freezeRenderState(renderState[propName]);
    }
  }
  return Object.freeze(renderState);
}
var freezeRenderState_default = freezeRenderState;

// Source/Renderer/RenderState.js
function validateBlendEquation(blendEquation) {
  return blendEquation === WebGLConstants_default.FUNC_ADD || blendEquation === WebGLConstants_default.FUNC_SUBTRACT || blendEquation === WebGLConstants_default.FUNC_REVERSE_SUBTRACT || blendEquation === WebGLConstants_default.MIN || blendEquation === WebGLConstants_default.MAX;
}
function validateBlendFunction(blendFunction) {
  return blendFunction === WebGLConstants_default.ZERO || blendFunction === WebGLConstants_default.ONE || blendFunction === WebGLConstants_default.SRC_COLOR || blendFunction === WebGLConstants_default.ONE_MINUS_SRC_COLOR || blendFunction === WebGLConstants_default.DST_COLOR || blendFunction === WebGLConstants_default.ONE_MINUS_DST_COLOR || blendFunction === WebGLConstants_default.SRC_ALPHA || blendFunction === WebGLConstants_default.ONE_MINUS_SRC_ALPHA || blendFunction === WebGLConstants_default.DST_ALPHA || blendFunction === WebGLConstants_default.ONE_MINUS_DST_ALPHA || blendFunction === WebGLConstants_default.CONSTANT_COLOR || blendFunction === WebGLConstants_default.ONE_MINUS_CONSTANT_COLOR || blendFunction === WebGLConstants_default.CONSTANT_ALPHA || blendFunction === WebGLConstants_default.ONE_MINUS_CONSTANT_ALPHA || blendFunction === WebGLConstants_default.SRC_ALPHA_SATURATE;
}
function validateCullFace(cullFace) {
  return cullFace === WebGLConstants_default.FRONT || cullFace === WebGLConstants_default.BACK || cullFace === WebGLConstants_default.FRONT_AND_BACK;
}
function validateDepthFunction(depthFunction) {
  return depthFunction === WebGLConstants_default.NEVER || depthFunction === WebGLConstants_default.LESS || depthFunction === WebGLConstants_default.EQUAL || depthFunction === WebGLConstants_default.LEQUAL || depthFunction === WebGLConstants_default.GREATER || depthFunction === WebGLConstants_default.NOTEQUAL || depthFunction === WebGLConstants_default.GEQUAL || depthFunction === WebGLConstants_default.ALWAYS;
}
function validateStencilFunction(stencilFunction) {
  return stencilFunction === WebGLConstants_default.NEVER || stencilFunction === WebGLConstants_default.LESS || stencilFunction === WebGLConstants_default.EQUAL || stencilFunction === WebGLConstants_default.LEQUAL || stencilFunction === WebGLConstants_default.GREATER || stencilFunction === WebGLConstants_default.NOTEQUAL || stencilFunction === WebGLConstants_default.GEQUAL || stencilFunction === WebGLConstants_default.ALWAYS;
}
function validateStencilOperation(stencilOperation) {
  return stencilOperation === WebGLConstants_default.ZERO || stencilOperation === WebGLConstants_default.KEEP || stencilOperation === WebGLConstants_default.REPLACE || stencilOperation === WebGLConstants_default.INCR || stencilOperation === WebGLConstants_default.DECR || stencilOperation === WebGLConstants_default.INVERT || stencilOperation === WebGLConstants_default.INCR_WRAP || stencilOperation === WebGLConstants_default.DECR_WRAP;
}
function RenderState(renderState) {
  const rs = defaultValue_default(renderState, defaultValue_default.EMPTY_OBJECT);
  const cull = defaultValue_default(rs.cull, defaultValue_default.EMPTY_OBJECT);
  const polygonOffset = defaultValue_default(
    rs.polygonOffset,
    defaultValue_default.EMPTY_OBJECT
  );
  const scissorTest = defaultValue_default(rs.scissorTest, defaultValue_default.EMPTY_OBJECT);
  const scissorTestRectangle = defaultValue_default(
    scissorTest.rectangle,
    defaultValue_default.EMPTY_OBJECT
  );
  const depthRange = defaultValue_default(rs.depthRange, defaultValue_default.EMPTY_OBJECT);
  const depthTest = defaultValue_default(rs.depthTest, defaultValue_default.EMPTY_OBJECT);
  const colorMask = defaultValue_default(rs.colorMask, defaultValue_default.EMPTY_OBJECT);
  const blending = defaultValue_default(rs.blending, defaultValue_default.EMPTY_OBJECT);
  const blendingColor = defaultValue_default(blending.color, defaultValue_default.EMPTY_OBJECT);
  const stencilTest = defaultValue_default(rs.stencilTest, defaultValue_default.EMPTY_OBJECT);
  const stencilTestFrontOperation = defaultValue_default(
    stencilTest.frontOperation,
    defaultValue_default.EMPTY_OBJECT
  );
  const stencilTestBackOperation = defaultValue_default(
    stencilTest.backOperation,
    defaultValue_default.EMPTY_OBJECT
  );
  const sampleCoverage = defaultValue_default(
    rs.sampleCoverage,
    defaultValue_default.EMPTY_OBJECT
  );
  const viewport = rs.viewport;
  this.frontFace = defaultValue_default(rs.frontFace, WindingOrder_default.COUNTER_CLOCKWISE);
  this.cull = {
    enabled: defaultValue_default(cull.enabled, false),
    face: defaultValue_default(cull.face, WebGLConstants_default.BACK)
  };
  this.lineWidth = defaultValue_default(rs.lineWidth, 1);
  this.polygonOffset = {
    enabled: defaultValue_default(polygonOffset.enabled, false),
    factor: defaultValue_default(polygonOffset.factor, 0),
    units: defaultValue_default(polygonOffset.units, 0)
  };
  this.scissorTest = {
    enabled: defaultValue_default(scissorTest.enabled, false),
    rectangle: BoundingRectangle_default.clone(scissorTestRectangle)
  };
  this.depthRange = {
    near: defaultValue_default(depthRange.near, 0),
    far: defaultValue_default(depthRange.far, 1)
  };
  this.depthTest = {
    enabled: defaultValue_default(depthTest.enabled, false),
    func: defaultValue_default(depthTest.func, WebGLConstants_default.LESS)
  };
  this.colorMask = {
    red: defaultValue_default(colorMask.red, true),
    green: defaultValue_default(colorMask.green, true),
    blue: defaultValue_default(colorMask.blue, true),
    alpha: defaultValue_default(colorMask.alpha, true)
  };
  this.depthMask = defaultValue_default(rs.depthMask, true);
  this.stencilMask = defaultValue_default(rs.stencilMask, ~0);
  this.blending = {
    enabled: defaultValue_default(blending.enabled, false),
    color: new Color_default(
      defaultValue_default(blendingColor.red, 0),
      defaultValue_default(blendingColor.green, 0),
      defaultValue_default(blendingColor.blue, 0),
      defaultValue_default(blendingColor.alpha, 0)
    ),
    equationRgb: defaultValue_default(blending.equationRgb, WebGLConstants_default.FUNC_ADD),
    equationAlpha: defaultValue_default(
      blending.equationAlpha,
      WebGLConstants_default.FUNC_ADD
    ),
    functionSourceRgb: defaultValue_default(
      blending.functionSourceRgb,
      WebGLConstants_default.ONE
    ),
    functionSourceAlpha: defaultValue_default(
      blending.functionSourceAlpha,
      WebGLConstants_default.ONE
    ),
    functionDestinationRgb: defaultValue_default(
      blending.functionDestinationRgb,
      WebGLConstants_default.ZERO
    ),
    functionDestinationAlpha: defaultValue_default(
      blending.functionDestinationAlpha,
      WebGLConstants_default.ZERO
    )
  };
  this.stencilTest = {
    enabled: defaultValue_default(stencilTest.enabled, false),
    frontFunction: defaultValue_default(
      stencilTest.frontFunction,
      WebGLConstants_default.ALWAYS
    ),
    backFunction: defaultValue_default(stencilTest.backFunction, WebGLConstants_default.ALWAYS),
    reference: defaultValue_default(stencilTest.reference, 0),
    mask: defaultValue_default(stencilTest.mask, ~0),
    frontOperation: {
      fail: defaultValue_default(stencilTestFrontOperation.fail, WebGLConstants_default.KEEP),
      zFail: defaultValue_default(stencilTestFrontOperation.zFail, WebGLConstants_default.KEEP),
      zPass: defaultValue_default(stencilTestFrontOperation.zPass, WebGLConstants_default.KEEP)
    },
    backOperation: {
      fail: defaultValue_default(stencilTestBackOperation.fail, WebGLConstants_default.KEEP),
      zFail: defaultValue_default(stencilTestBackOperation.zFail, WebGLConstants_default.KEEP),
      zPass: defaultValue_default(stencilTestBackOperation.zPass, WebGLConstants_default.KEEP)
    }
  };
  this.sampleCoverage = {
    enabled: defaultValue_default(sampleCoverage.enabled, false),
    value: defaultValue_default(sampleCoverage.value, 1),
    invert: defaultValue_default(sampleCoverage.invert, false)
  };
  this.viewport = defined_default(viewport) ? new BoundingRectangle_default(
    viewport.x,
    viewport.y,
    viewport.width,
    viewport.height
  ) : void 0;
  if (this.lineWidth < ContextLimits_default.minimumAliasedLineWidth || this.lineWidth > ContextLimits_default.maximumAliasedLineWidth) {
    throw new DeveloperError_default(
      "renderState.lineWidth is out of range.  Check minimumAliasedLineWidth and maximumAliasedLineWidth."
    );
  }
  if (!WindingOrder_default.validate(this.frontFace)) {
    throw new DeveloperError_default("Invalid renderState.frontFace.");
  }
  if (!validateCullFace(this.cull.face)) {
    throw new DeveloperError_default("Invalid renderState.cull.face.");
  }
  if (this.scissorTest.rectangle.width < 0 || this.scissorTest.rectangle.height < 0) {
    throw new DeveloperError_default(
      "renderState.scissorTest.rectangle.width and renderState.scissorTest.rectangle.height must be greater than or equal to zero."
    );
  }
  if (this.depthRange.near > this.depthRange.far) {
    throw new DeveloperError_default(
      "renderState.depthRange.near can not be greater than renderState.depthRange.far."
    );
  }
  if (this.depthRange.near < 0) {
    throw new DeveloperError_default(
      "renderState.depthRange.near must be greater than or equal to zero."
    );
  }
  if (this.depthRange.far > 1) {
    throw new DeveloperError_default(
      "renderState.depthRange.far must be less than or equal to one."
    );
  }
  if (!validateDepthFunction(this.depthTest.func)) {
    throw new DeveloperError_default("Invalid renderState.depthTest.func.");
  }
  if (this.blending.color.red < 0 || this.blending.color.red > 1 || this.blending.color.green < 0 || this.blending.color.green > 1 || this.blending.color.blue < 0 || this.blending.color.blue > 1 || this.blending.color.alpha < 0 || this.blending.color.alpha > 1) {
    throw new DeveloperError_default(
      "renderState.blending.color components must be greater than or equal to zero and less than or equal to one."
    );
  }
  if (!validateBlendEquation(this.blending.equationRgb)) {
    throw new DeveloperError_default("Invalid renderState.blending.equationRgb.");
  }
  if (!validateBlendEquation(this.blending.equationAlpha)) {
    throw new DeveloperError_default("Invalid renderState.blending.equationAlpha.");
  }
  if (!validateBlendFunction(this.blending.functionSourceRgb)) {
    throw new DeveloperError_default("Invalid renderState.blending.functionSourceRgb.");
  }
  if (!validateBlendFunction(this.blending.functionSourceAlpha)) {
    throw new DeveloperError_default(
      "Invalid renderState.blending.functionSourceAlpha."
    );
  }
  if (!validateBlendFunction(this.blending.functionDestinationRgb)) {
    throw new DeveloperError_default(
      "Invalid renderState.blending.functionDestinationRgb."
    );
  }
  if (!validateBlendFunction(this.blending.functionDestinationAlpha)) {
    throw new DeveloperError_default(
      "Invalid renderState.blending.functionDestinationAlpha."
    );
  }
  if (!validateStencilFunction(this.stencilTest.frontFunction)) {
    throw new DeveloperError_default("Invalid renderState.stencilTest.frontFunction.");
  }
  if (!validateStencilFunction(this.stencilTest.backFunction)) {
    throw new DeveloperError_default("Invalid renderState.stencilTest.backFunction.");
  }
  if (!validateStencilOperation(this.stencilTest.frontOperation.fail)) {
    throw new DeveloperError_default(
      "Invalid renderState.stencilTest.frontOperation.fail."
    );
  }
  if (!validateStencilOperation(this.stencilTest.frontOperation.zFail)) {
    throw new DeveloperError_default(
      "Invalid renderState.stencilTest.frontOperation.zFail."
    );
  }
  if (!validateStencilOperation(this.stencilTest.frontOperation.zPass)) {
    throw new DeveloperError_default(
      "Invalid renderState.stencilTest.frontOperation.zPass."
    );
  }
  if (!validateStencilOperation(this.stencilTest.backOperation.fail)) {
    throw new DeveloperError_default(
      "Invalid renderState.stencilTest.backOperation.fail."
    );
  }
  if (!validateStencilOperation(this.stencilTest.backOperation.zFail)) {
    throw new DeveloperError_default(
      "Invalid renderState.stencilTest.backOperation.zFail."
    );
  }
  if (!validateStencilOperation(this.stencilTest.backOperation.zPass)) {
    throw new DeveloperError_default(
      "Invalid renderState.stencilTest.backOperation.zPass."
    );
  }
  if (defined_default(this.viewport)) {
    if (this.viewport.width < 0) {
      throw new DeveloperError_default(
        "renderState.viewport.width must be greater than or equal to zero."
      );
    }
    if (this.viewport.height < 0) {
      throw new DeveloperError_default(
        "renderState.viewport.height must be greater than or equal to zero."
      );
    }
    if (this.viewport.width > ContextLimits_default.maximumViewportWidth) {
      throw new DeveloperError_default(
        `renderState.viewport.width must be less than or equal to the maximum viewport width (${ContextLimits_default.maximumViewportWidth.toString()}).  Check maximumViewportWidth.`
      );
    }
    if (this.viewport.height > ContextLimits_default.maximumViewportHeight) {
      throw new DeveloperError_default(
        `renderState.viewport.height must be less than or equal to the maximum viewport height (${ContextLimits_default.maximumViewportHeight.toString()}).  Check maximumViewportHeight.`
      );
    }
  }
  this.id = 0;
  this._applyFunctions = [];
}
var nextRenderStateId = 0;
var renderStateCache = {};
RenderState.fromCache = function(renderState) {
  const partialKey = JSON.stringify(renderState);
  let cachedState = renderStateCache[partialKey];
  if (defined_default(cachedState)) {
    ++cachedState.referenceCount;
    return cachedState.state;
  }
  let states = new RenderState(renderState);
  const fullKey = JSON.stringify(states);
  cachedState = renderStateCache[fullKey];
  if (!defined_default(cachedState)) {
    states.id = nextRenderStateId++;
    states = freezeRenderState_default(states);
    cachedState = {
      referenceCount: 0,
      state: states
    };
    renderStateCache[fullKey] = cachedState;
  }
  ++cachedState.referenceCount;
  renderStateCache[partialKey] = {
    referenceCount: 1,
    state: cachedState.state
  };
  return cachedState.state;
};
RenderState.removeFromCache = function(renderState) {
  const states = new RenderState(renderState);
  const fullKey = JSON.stringify(states);
  const fullCachedState = renderStateCache[fullKey];
  const partialKey = JSON.stringify(renderState);
  const cachedState = renderStateCache[partialKey];
  if (defined_default(cachedState)) {
    --cachedState.referenceCount;
    if (cachedState.referenceCount === 0) {
      delete renderStateCache[partialKey];
      if (defined_default(fullCachedState)) {
        --fullCachedState.referenceCount;
      }
    }
  }
  if (defined_default(fullCachedState) && fullCachedState.referenceCount === 0) {
    delete renderStateCache[fullKey];
  }
};
RenderState.getCache = function() {
  return renderStateCache;
};
RenderState.clearCache = function() {
  renderStateCache = {};
};
function enableOrDisable(gl, glEnum, enable) {
  if (enable) {
    gl.enable(glEnum);
  } else {
    gl.disable(glEnum);
  }
}
function applyFrontFace(gl, renderState) {
  gl.frontFace(renderState.frontFace);
}
function applyCull(gl, renderState) {
  const cull = renderState.cull;
  const enabled = cull.enabled;
  enableOrDisable(gl, gl.CULL_FACE, enabled);
  if (enabled) {
    gl.cullFace(cull.face);
  }
}
function applyLineWidth(gl, renderState) {
  gl.lineWidth(renderState.lineWidth);
}
function applyPolygonOffset(gl, renderState) {
  const polygonOffset = renderState.polygonOffset;
  const enabled = polygonOffset.enabled;
  enableOrDisable(gl, gl.POLYGON_OFFSET_FILL, enabled);
  if (enabled) {
    gl.polygonOffset(polygonOffset.factor, polygonOffset.units);
  }
}
function applyScissorTest(gl, renderState, passState) {
  const scissorTest = renderState.scissorTest;
  const enabled = defined_default(passState.scissorTest) ? passState.scissorTest.enabled : scissorTest.enabled;
  enableOrDisable(gl, gl.SCISSOR_TEST, enabled);
  if (enabled) {
    const rectangle = defined_default(passState.scissorTest) ? passState.scissorTest.rectangle : scissorTest.rectangle;
    gl.scissor(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
  }
}
function applyDepthRange(gl, renderState) {
  const depthRange = renderState.depthRange;
  gl.depthRange(depthRange.near, depthRange.far);
}
function applyDepthTest(gl, renderState) {
  const depthTest = renderState.depthTest;
  const enabled = depthTest.enabled;
  enableOrDisable(gl, gl.DEPTH_TEST, enabled);
  if (enabled) {
    gl.depthFunc(depthTest.func);
  }
}
function applyColorMask(gl, renderState) {
  const colorMask = renderState.colorMask;
  gl.colorMask(colorMask.red, colorMask.green, colorMask.blue, colorMask.alpha);
}
function applyDepthMask(gl, renderState) {
  gl.depthMask(renderState.depthMask);
}
function applyStencilMask(gl, renderState) {
  gl.stencilMask(renderState.stencilMask);
}
function applyBlendingColor(gl, color) {
  gl.blendColor(color.red, color.green, color.blue, color.alpha);
}
function applyBlending(gl, renderState, passState) {
  const blending = renderState.blending;
  const enabled = defined_default(passState.blendingEnabled) ? passState.blendingEnabled : blending.enabled;
  enableOrDisable(gl, gl.BLEND, enabled);
  if (enabled) {
    applyBlendingColor(gl, blending.color);
    gl.blendEquationSeparate(blending.equationRgb, blending.equationAlpha);
    gl.blendFuncSeparate(
      blending.functionSourceRgb,
      blending.functionDestinationRgb,
      blending.functionSourceAlpha,
      blending.functionDestinationAlpha
    );
  }
}
function applyStencilTest(gl, renderState) {
  const stencilTest = renderState.stencilTest;
  const enabled = stencilTest.enabled;
  enableOrDisable(gl, gl.STENCIL_TEST, enabled);
  if (enabled) {
    const frontFunction = stencilTest.frontFunction;
    const backFunction = stencilTest.backFunction;
    const reference = stencilTest.reference;
    const mask = stencilTest.mask;
    gl.stencilFunc(frontFunction, reference, mask);
    gl.stencilFuncSeparate(gl.BACK, backFunction, reference, mask);
    gl.stencilFuncSeparate(gl.FRONT, frontFunction, reference, mask);
    const frontOperation = st