import * as Cesium from 'cesium'

export function change(viewer, divisionCount) {
    for (let i = 0; i < divisionCount; i++) {
      const angle = (360 / divisionCount) * i;
      const startLongitude = angle - 180;
      const endLongitude = startLongitude + 10; 

      viewer.entities.add({
        polyline: {
          positions: Cesium.Cartesian3.fromDegreesArrayHeights([
            startLongitude, 0, 100000, 
            endLongitude, 0, 100000 
          ]),
          width: 2,
          material: Cesium.Color.PINK,
        }
      });

      viewer.entities.add({
        position: Cesium.Cartesian3.fromDegrees(startLongitude + 5, 0, 0),
        label: {
          text: `${startLongitude}°`,
          font: '16px Helvetica',
          fillColor: Cesium.Color.WHITE,
          pixelOffset: new Cesium.Cartesian2(0, -10),
          scale: 0.5,
        }
      });
    }
}
  
