import * as Cesium from "cesium";
import JulianDate from "cesium/Source/Core/JulianDate";

/**
 * @class 传感器类
 * @classdesc 该类用于在Cesium场景中创建传感器
 */
class Sensor {
  /**
   * 传感器构造函数
   * @param {Object} viewer - viewer对象
   * @param {String} parentId - 绑定对象ID
   * @param {String} [id] - 传感器ID
   * @param {String} [sensorType='simpleConic'] - 传感器类型 simpleConic-简单锥体;rectangular-矩形视场;halfPower-半功率;complexConic-复杂锥体
   * @param {Number} [radius=40000000] - 传感器距离
   * @param {Boolean} [visible=true] - 传感器显隐性
   * @param {Number} [coneHalfAngle=30] - 简单锥体传感器半角大小
   * @param {Number} [xHalfAngle=30] - 矩形视场传感器水平半角大小
   * @param {Number} [yHalfAngle=45] - 矩形视场传感器垂直半角大小
   * @param {Number} [innerHalfAngle=10] - 复杂锥体传感器内部半角
   * @param {Number} [outerHalfAngle=45] - 复杂锥体传感器外部半角
   * @param {Number} [minClockAngle=0] - 复杂锥体传感器竖直最小时钟角
   * @param {Number} [maxClockAngle=360] - 复杂锥体传感器竖直最大时钟角
   * @param {String} [color='rgb(255,0,0)'] - 传感器颜色
   * @param {Number} [alpha=1] - 传感器透明度
   * @param {String} [lineColor='rgb(255,0,0)'] - 线颜色
   * @param {Number} [lineAlpha=1] - 线不透明度
   * @param {Number} [lineWidth] - 线宽度
   * @param {Number} [heading=0] - 方位角
   * @param {Number} [pitch=90] - 俯仰角
   * @param {Number} [roll=0] - 滚动角
   * @param {Boolean} [showPause=false] - 脉冲显隐性
   * @param {Number} [speed=1] - 脉冲速度
   * @param {Number} [waveSpreadDistance=10000] - 脉冲宽度
   * @param {Boolean} [waveDirection=true] - 脉冲方向
   * @param {Number} [maxAlpha=0.5] - 脉冲间隙最大透明度
   * @param {Number} [minAlpha=0.5] - 脉冲间隙最小透明度
   * @param {Boolean} [gridVisible] - 传感器网格显隐性
   * @param {Number} [gridAlpha] - 传感器网格透明度
   */
  constructor(viewer,options={}) {
    const viewer = map
    this.entityCollection = viewer.entities; 
    const SENSOR = {
      parentId: null,
      id: null,
      sensorType: 'simpleConic',
      radius: 40000000,
      visible: true,
      coneHalfAngle: 30,
      xHalfAngle:30,
      yHalfAngle: 45,
      innerHalfAngle: 10,
      outerHalfAngle: 45,
      minClockAngle: 0,
      maxClockAngle: 360,
      color: 'rgb(255,0,0)',
      lineAlpha: 1,
      lineWidth: 5,
      heading: 0,
      pitch: 90,
      roll: 0,
      showPause: false,
      speed: 1,
      waveSpreadDistance: 10000,
      waveDirection: true,
      maxAlpha : 0.5,
      minAlpha: 0.5,
      gridVisible:null,
      gridAlpha:null,
    };
    const finalOptions = { ...SENSOR, ...options };
    const { position, id, ...sensorOptions } = finalOptions;
    this.entity = viewer.entities.add({
      id: id,
      position: position,
      ellipsoid: {
        radii:sensorOptions.radius,
        innerRadii: [1,1,1],
        minimumClock: ,
        maximumClock: ,
        minimumCone: ,
        maximumCone: ,
        material: {
          color:
        },
        outline: ,
        outlineColor: ,
        outlineWidth: ,
        stackPartitions: ,
        slicePartitions: ,
        subdivisions: ,
        distanceDisplayCondition: ,
      }
    })

  }

  /**
   * 绑定设备
   * @param {String} id - 传感器所属设备 
   */
  bindObject(id) {}

  /**
   * 查询某一时间下的传感器位置
   * @param {JulianDate} time - 查询时间
   */
  getPosition(time) {}

  /**
   * 获取传感器显隐性
   * @returns {Boolean} true-显示;false-隐藏
   */
  getVisible() {}

  /**
   * 设置传感器的属性
   */
  setProperty() {}

  /**
   * 设置传感器在指定时段内的显隐性
   * @param {Array} times - 时间区间
   */
  setVisibleTimes(times) {}

  /**
   * 从场景中移除该传感器
   */
  removeFromScene() {}
}
export default Sensor;