
import { PRIVILEGE } from '@/types/privilege';

const home = {
  path: '/home',
  name: 'index-page',
  component: () => import('../views/home/home.vue'),
  meta: {
    // privileges: [PRIVILEGE.USER_MNG, PRIVILEGE.USER_LIST],

    CName: '首页',
  },
};
const MonitorState = {
  path: '/MonitorState',
  name: 'MonitorState',
  component: () => import('../views/MonitorState/MonitorState.vue'),
  meta: {
    CName: '监控状态',
    parentCName: '实时监控',
  },
};
const detail = {
  path: '/detail',
  name: 'detail',
  component: () => import('../views/detail/detail.vue'),
  meta: {
    CName: '参数详情',
    parentCName: '实时监控',
  },
};
const AlarmRecord = {
  path: '/AlarmRecord',
  name: 'AlarmRecord',
  component: () => import('../views/AlarmRecord/AlarmRecord.vue'),
  meta: {
    CName: '报警记录',
    parentCName: '报警提醒',
  },
};
const alarm = {
  path: '/alarm',
  name: 'alarm',
  component: () => import('../views/alarm/alarm.vue'),
  meta: {
    CName: '巡检提醒',
    parentCName: '报警提醒',
  },
};
const delay = {
  path: '/delay',
  name: 'delay',
  component: () => import('../views/delay/delay.vue'),
  meta: {
    CName: '巡检延误提醒',
    parentCName: '报警提醒',
  },
};
// 按顺序 用于菜单的排列
const indexChildren = [
  home,
  MonitorState,
  detail,
  AlarmRecord,
  alarm,
  delay,
];

export const routes = [
  {
    path: '/login',
    name: 'login',
    component: () => import('../views/login.vue'),
    meta: { authDisabled: true },
  },
  {
    path: '/',
    name: 'index',
    redirect: 'index-page',
    component: () => import('../views/main/index.vue'),
    children: [
      ...indexChildren,
      {
        path: '*',
        name: '404_child',
        component: () => import('../component/page404.vue'),
        meta: { authDisabled: true },
      },
    ],
  },
  {
    path: '*',
    name: '404',
    component: () => import('../component/page404.vue'),
    meta: { authDisabled: true },
  },
];
