from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QWidget, QTabWidget

from pages.widget_example.basic_example import BasicExample
from pages.widget_example.custom_example import CustomExample
from pages.widget_example.table_example import TableExample


class Index(QTabWidget):

    def __init__(self, parent=None):
        super(Index, self).__init__(parent=parent)

        self.__init_widget()
        self.__init_slot()
        self.__init_qss()

    def __init_widget(self):
        self.addTab(BasicExample(), "基础组件")
        self.addTab(TableExample(), "表格")
        self.addTab(CustomExample(), "自定义组件")

    def __init_slot(self):
        pass

    def __init_qss(self):
        self.setAttribute(Qt.WA_StyledBackground, True)