from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QScrollArea, QWidget, QGridLayout, QLabel

from kit.component.kit_button import KitButton
from kit.component.kit_drawer import KitDrawer
from kit.component.kit_popup import KitModal


class CustomExample(QScrollArea):

    def __init__(self, parent=None):
        super(CustomExample, self).__init__(parent=parent)

        self.__init_widget()
        self.__init_slot()
        self.__init_qss()

    def __init_widget(self):
        self.main_widget = QWidget()
        self.setWidget(self.main_widget)

        self.layout = QGridLayout()
        self.main_widget.setLayout(self.layout)

        # 弹窗
        label1 = QLabel("弹窗")
        label1.setObjectName("title")
        self.layout.addWidget(label1, 0, 0)

        modal_notice = KitButton("提示弹窗")
        self.layout.addWidget(modal_notice, 1, 0)
        modal_notice.clicked.connect(lambda: KitModal.setModalNotice("提示", "这是一个提示弹窗"))

        modal_dialog = KitButton("对话弹窗")
        self.layout.addWidget(modal_dialog, 1, 1)
        modal_dialog.clicked.connect(lambda: KitModal.setModalDialog("对话", "这是一个对话弹窗", lambda: print("点击了确定按钮"), lambda: print("点击了取消按钮")))

        # 抽屉
        label2 = QLabel("抽屉")
        label2.setObjectName("title")
        self.layout.addWidget(label2, 2, 0)

        button_1 = KitButton("左侧抽屉")
        drawer_left = KitDrawer(KitDrawer.Left)
        button_1.clicked.connect(lambda: drawer_left.open())
        self.layout.addWidget(button_1, 3, 0)

        button_2 = KitButton("右侧抽屉")
        drawer_right = KitDrawer(KitDrawer.Right)
        button_2.clicked.connect(lambda: drawer_right.open())
        self.layout.addWidget(button_2, 3, 1)

        button_3 = KitButton("顶部抽屉")
        drawer_top = KitDrawer(KitDrawer.Top)
        button_3.clicked.connect(lambda: drawer_top.open())
        self.layout.addWidget(button_3, 3, 2)

        button_4 = KitButton("底部抽屉")
        drawer_bottom = KitDrawer(KitDrawer.Bottom)
        button_4.clicked.connect(lambda: drawer_bottom.open())
        self.layout.addWidget(button_4, 3, 3)



        self.main_widget.adjustSize()

    def __init_slot(self):
        pass

    def __init_qss(self):
        self.setAttribute(Qt.WA_StyledBackground, True)
