import sys

from PyQt5.QtCore import Qt, QSize
from PyQt5.QtGui import QFontDatabase, QPixmap, QIcon
from PyQt5.QtWidgets import QLabel, QApplication, QWidget, QVBoxLayout, QSizePolicy

import config


class KitIcon(QLabel):
    def __init__(self, icon_str: str = None, parent=None):
        super().__init__(parent=parent)
        self.icon = icon_str

        self.setAlignment(Qt.AlignCenter)
        self.setContentsMargins(0, 0, 0, 0)
        self.setSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed)
        self.setIcon(self.icon)

    # 转换为QIcon
    def toIcon(self) -> QIcon:
        img = self.grab().toImage()
        pixmap = QPixmap.fromImage(img)

        return QIcon(pixmap)

    def toPixmap(self) -> QPixmap:
        img = self.grab().toImage()
        pixmap = QPixmap.fromImage(img)

        return pixmap

    def setIcon(self, icon_str):
        self.icon = icon_str
        self.setText(icon_str)

    def sizeHint(self) -> QSize:
        return QSize(20, 20)


if __name__ == "__main__":
    QApplication.setHighDpiScaleFactorRoundingPolicy(Qt.HighDpiScaleFactorRoundingPolicy.PassThrough)
    QApplication.setAttribute(Qt.AA_EnableHighDpiScaling)
    QApplication.setAttribute(Qt.AA_UseHighDpiPixmaps)

    app = QApplication(sys.argv)
    qss = config.init_qss()
    app.setStyleSheet(qss)

    fontId = QFontDatabase.addApplicationFont("assets/font/iconfont.ttf")
    fontName = QFontDatabase.applicationFontFamilies(fontId)[0]

    main = QWidget()
    main.setLayout(QVBoxLayout())
    icon = KitIcon("\ue6b8")
    icon.setProperty('type', 'primary')
    main.layout().addWidget(icon)
    label = QLabel("123")
    main.layout().addWidget(label)

    main.show()
    sys.exit(app.exec_())
