/**
 * Copyright © 2016-2023 The Thingsboard Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.thingsboard.server.common.data;

public class CacheConstants {
    public static final String DEVICE_CREDENTIALS_CACHE = "deviceCredentials";
    public static final String RELATIONS_CACHE = "relations";
    public static final String DEVICE_CACHE = "devices";
    public static final String SESSIONS_CACHE = "sessions";
    public static final String ASSET_CACHE = "assets";
    public static final String ENTITY_VIEW_CACHE = "entityViews";
    public static final String EDGE_CACHE = "edges";
    public static final String CLAIM_DEVICES_CACHE = "claimDevices";
    public static final String SECURITY_SETTINGS_CACHE = "securitySettings";
    public static final String TENANT_PROFILE_CACHE = "tenantProfiles";
    public static final String TENANTS_CACHE = "tenants";
    public static final String TENANTS_EXIST_CACHE = "tenantsExist";
    public static final String DEVICE_PROFILE_CACHE = "deviceProfiles";
    public static final String NOTIFICATION_SETTINGS_CACHE = "notificationSettings";
    public static final String SENT_NOTIFICATIONS_CACHE = "sentNotifications";

    public static final String ASSET_PROFILE_CACHE = "assetProfiles";
    public static final String ATTRIBUTES_CACHE = "attributes";
    public static final String USERS_SESSION_INVALIDATION_CACHE = "userSessionsInvalidation";
    public static final String OTA_PACKAGE_CACHE = "otaPackages";
    public static final String OTA_PACKAGE_DATA_CACHE = "otaPackagesData";
    public static final String REPOSITORY_SETTINGS_CACHE = "repositorySettings";
    public static final String AUTO_COMMIT_SETTINGS_CACHE = "autoCommitSettings";
    public static final String TWO_FA_VERIFICATION_CODES_CACHE = "twoFaVerificationCodes";
    public static final String VERSION_CONTROL_TASK_CACHE = "versionControlTask";
    public static final String USER_SETTINGS_CACHE = "userSettings";
    public static final String DASHBOARD_TITLES_CACHE = "dashboardTitles";
    public static final String ENTITY_COUNT_CACHE = "entityCount";
    public static final String RESOURCE_INFO_CACHE = "resourceInfo";
    public static final String ALARM_TYPES_CACHE = "alarmTypes";
}
