import {GO} from './GOJSKit'
import go from 'gojs'

export var linkSelectionAdornmentTemplate =
GO(go.Adornment, "Link",
  GO(go.Shape,
    // isPanelMain declares that this Shape shares the Link.geometry
    { isPanelMain: true, fill: null, stroke: "deepskyblue", strokeWidth: 1 },
  )  // use selection object's strokeWidth
 );


export function MultiArrowLink(this:go.Link) {
    go.Link.call(this);
}
go.Diagram.inherit(MultiArrowLink, go.Link);
MultiArrowLink.prototype.makeGeometry = function() {
    // get the Geometry created by the standard behavior
    let geo = go.Link.prototype.makeGeometry.call(this);
    if (geo.type !== go.Geometry.Path || geo.figures.length === 0) return geo;
    let mainFigure = geo.figures.elt(0);  // assume there's just one PathFigure
    let pathSegments = mainFigure.segments;
    let arrowLen = 8;  // length for each arrowhead
    let arrowWid = 3;  // actually half-width of each arrowhead
    let fx = mainFigure.startX;
    let fy = mainFigure.startY;
    for (let i = 0; i < pathSegments.length; i++) {
        let a = pathSegments.elt(i);
        // assume each arrowhead is a simple triangle
        let ax = a.endX;
        let ay = a.endY;
        let bx = ax;
        let by = ay;
        let cx = ax;
        let cy = ay;
        if (fx < ax - arrowLen) {
            bx -= arrowLen; by += arrowWid;
            cx -= arrowLen; cy -= arrowWid;
        } else if (fx > ax + arrowLen) {
            bx += arrowLen; by += arrowWid;
            cx += arrowLen; cy -= arrowWid;
        } else if (fy < ay - arrowLen) {
            bx -= arrowWid; by -= arrowLen;
            cx += arrowWid; cy -= arrowLen;
        } else if (fy > ay + arrowLen) {
            bx -= arrowWid; by += arrowLen;
            cx += arrowWid; cy += arrowLen;
        }
        geo.add(new go.PathFigure(ax, ay, true)
            .add(new go.PathSegment(go.PathSegment.Line, bx, by))
            .add(new go.PathSegment(go.PathSegment.Line, cx, cy).close()));
        fx = ax;
        fy = ay;
    }
    return geo;
};

export var FlowLink =
    GO(go.Link,{
            routing: go.Link.AvoidsNodes,
            curve: go.Link.JumpGap,
            corner: 5,
            toShortLength: 4,
            relinkableFrom: true,
            relinkableTo: true,
            reshapable: true,
            // resegmentable: true,
        },
        new go.Binding("points", "points").makeTwoWay(),
        GO(go.Shape, { isPanelMain:true, strokeWidth: 5, stroke: 'red'}),
        GO(go.Shape, { isPanelMain:true, strokeWidth: 5, stroke: 'green',name:"FLOW", strokeDashArray: [10, 10]}),
        GO(go.Shape, { toArrow: "Standard", stroke: null })
    );

export function animateFlow(myDiagram:go.Diagram){
    // if (myAnimation) myAnimation.stop();
    // Animate the flow in the pipes
    let myAnimation = new go.Animation();
    myAnimation.easing = go.Animation.EaseLinear;
    myDiagram.links.each(link =>{
            let shape = link.findObject("FLOW")
            if (shape instanceof go.GraphObject){
                myAnimation.add(shape, "strokeDashOffset", 20, 0)
            }
        }
    );
    // Run indefinitely
    myAnimation.runCount = Infinity;
    myAnimation.start();
}