import {GO} from './GOJSKit'
import go from 'gojs'

export var linkSelectionAdornmentTemplate =
GO(go.Adornment, "Link",
  GO(go.Shape,
    // isPanelMain declares that this Shape shares the Link.geometry
    { isPanelMain: true, fill: null, stroke: "deepskyblue", strokeWidth: 1 },
      new go.Binding("stroke").makeTwoWay()
  )  // use selection object's strokeWidth
 );


export function MultiArrowLink() {
    go.Link.call(this);
}
go.Diagram.inherit(MultiArrowLink, go.Link);
MultiArrowLink.prototype.makeGeometry = function() {
    // get the Geometry created by the standard behavior
    let geo = go.Link.prototype.makeGeometry.call(this);
    if (geo.type !== go.Geometry.Path || geo.figures.length === 0) return geo;
    let mainfig = geo.figures.elt(0);  // assume there's just one PathFigure
    let mainsegs = mainfig.segments;
    let arrowLen = 8;  // length for each arrowhead
    let arrowWid = 3;  // actually half-width of each arrowhead
    let fx = mainfig.startX;
    let fy = mainfig.startY;
    for (let i = 0; i < mainsegs.length; i++) {
        let a = mainsegs.elt(i);
        // assume each arrowhead is a simple triangle
        let ax = a.endX;
        let ay = a.endY;
        let bx = ax;
        let by = ay;
        let cx = ax;
        let cy = ay;
        if (fx < ax - arrowLen) {
            bx -= arrowLen; by += arrowWid;
            cx -= arrowLen; cy -= arrowWid;
        } else if (fx > ax + arrowLen) {
            bx += arrowLen; by += arrowWid;
            cx += arrowLen; cy -= arrowWid;
        } else if (fy < ay - arrowLen) {
            bx -= arrowWid; by -= arrowLen;
            cx += arrowWid; cy -= arrowLen;
        } else if (fy > ay + arrowLen) {
            bx -= arrowWid; by += arrowLen;
            cx += arrowWid; cy += arrowLen;
        }
        geo.add(new go.PathFigure(ax, ay, true)
            .add(new go.PathSegment(go.PathSegment.Line, bx, by))
            .add(new go.PathSegment(go.PathSegment.Line, cx, cy).close()));
        fx = ax;
        fy = ay;
    }
    return geo;
};