import go from 'gojs';

export var GO = go.GraphObject.make;

 /**
  * 用于连接的锚点效果
  * @param {String} name 锚点名称
  * @param {Spot} spot 锚点位置
  * @param {Boolean} output 是否可以从此锚点连接出去
  * @param {Boolean} input 是否可以连接到此锚点
  */
export function makePort(name:any, spot:any, output:any, input:any) {
    return GO(go.Shape, "Circle",
             {
        fill: null,
        stroke: null,
        desiredSize: new go.Size(10, 10),
        alignment: spot,
        alignmentFocus: spot,
        portId: name,
        fromSpot: spot, toSpot: spot,
        fromLinkable: output, toLinkable: input,
        cursor: "pointer"
    });
}
 /**
  * 展示连接锚点
  * @param {Node} node 节点
  * @param {Boolean} show 是否展示
  */
export function showSmallPorts(node:any, show:any) {
    node.ports.each(function(port:any) {
        if (port.portId !== "") {  // don't change the default port, which is the big shape
            port.fill = show ? "rgba(0,0,0,.3)" : null;
        }
    });
}

