/**
 * 源节点模型分类
 * @type {{key: string; name: string; type: string}[]}
 * key: 节点类别
 * name: 节点类别名称
 * type: 节点类别类型, svg: 图片, geometry: 路径绘制, shape: gojs内置形状
 */
export const SourceNodeCategory: { key: string; name: string; type: string }[] = [
    {key:"valve",name:"阀门", type:"svg"},
    {key:"pump",name:"泵", type:"svg"},
    // {key:"computer",name:"计算机", type:"svg"},
    {key:"ammonia", name:"氨气合成装置", type:"svg"},
    {key:"pipe", name:"管道", type:"geometry"},
    // {key:"shape", name:"形状", type:"shape"},
]

export const SourceNodeModel = [
    //{name: 节点名称, nodeCollection: 节点分类, img: 节点图片路径, geometry: 节点形状, ports: 端口, category: 节点类型}
    //svg
    //computer
    { name: "电脑", nodeCollection: "computer", img: "src/assets/models/computer/电脑.svg", category:'svg'},
    //valve
    { name: "阀-2", nodeCollection: "valve", img: "src/assets/models/valve/阀-2.svg", category:'svg'},
    { name: "阀", nodeCollection: "valve", img: "src/assets/models/valve/阀.svg",  category:'svg'},
    { name: "阀门-01", nodeCollection: "valve", img: "src/assets/models/valve/阀门-01.svg",  category:'svg'},
    { name: "阀门2-01", nodeCollection: "valve", img: "src/assets/models/valve/阀门2-01.svg",  category:'svg'},
    //pump
    {name: "立式泵", nodeCollection: "pump", img: "src/assets/models/pump/立式泵.svg",  category:'svg'},
    {name: "卧式泵", nodeCollection: "pump", img: "src/assets/models/pump/卧式泵.svg",  category:'svg'},
    {name: "旋转泵", nodeCollection: "pump", img: "src/assets/models/pump/旋转泵.svg",  category:'svg'},
    {name: "油池泵", nodeCollection: "pump", img: "src/assets/models/pump/油池泵.svg",  category:'svg'},
    //ammonia
    {name:"氨分离罐", nodeCollection:"ammonia", img:"src/assets/models/ammonia/氨分离罐.svg",  category:'svg'},
    {name:"合成塔", nodeCollection:"ammonia", img:"src/assets/models/ammonia/合成塔.svg",  category:'svg'},
    {name:"换热器", nodeCollection:"ammonia", img:"src/assets/models/ammonia/换热器.svg",  category:'svg'},
    {name:"开工炉", nodeCollection:"ammonia", img:"src/assets/models/ammonia/开工炉.svg",  category:'svg'},
    {name:"冷却器", nodeCollection:"ammonia", img:"src/assets/models/ammonia/冷却器.svg",  category:'svg'},
    {name:"冷却器-2", nodeCollection:"ammonia", img:"src/assets/models/ammonia/冷却器-2.svg",  category:'svg'},
    {name:"压缩机", nodeCollection:"ammonia", img:"src/assets/models/ammonia/压缩机.svg",  category:'svg'},

    //shape
    {name:"矩形", nodeCollection: "shape", shape: "Rectangle", fill: "white", stroke:"black", category: 'shape'},

    //geometry
    {name:"弯头", nodeCollection: "pipe", geometry: "F1 M0 40 L0 30 Q0 0 30 0 L40 0 40 20 30 20 Q20 20 20 30 L20 40z", fill: "rgba(128, 128, 128, 0.5)", category: 'geometry',
        portArray:[
            {"name":"端口1","portId":"7b1d1bec-3674-4960-9bd1-901c28940f34","alignment":"1 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0"},
            {"name":"端口2","portId":"4062f627-9bee-4ca5-b00d-cc6b39c566d9","alignment":"0.25 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0"}
        ]
    },
    {name:"三头", nodeCollection: "pipe", geometry: "F1 M0 0 L60 0 60 20 50 20 Q40 20 40 30 L40 40 20 40 20 30 Q20 20 10 20 L0 20z", fill: "rgba(128, 128, 128, 0.5)", category: 'geometry',
        portArray:[
            {"name":"端口1","portId":"854f9c8e-0652-44aa-9705-95dc825ad577","alignment":"0 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},
            {"name":"端口2","portId":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","alignment":"1 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},
            {"name":"端口3","portId":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false},
        ]
    },
    {
        name: "四头",
        nodeCollection: "pipe",
        geometry: "F1 M0 0 L20 0 20 20 0 20z",
        fill: "rgba(128, 128, 128, 0.5)",
        category: 'geometry',
        portArray:[
            {"name":"端口1","portId":"f0438186-a2ab-43cc-b365-9a7e6dfcdfde","alignment":"0 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},
            {"name":"端口2","portId":"5ebe28be-db70-4b3b-873d-0a24211de76a","alignment":"0.5 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false},
            {"name":"端口3","portId":"a82cf436-c76d-4643-be62-6215c831abc2","alignment":"1 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},
            {"name":"端口4","portId":"630c547b-eb8c-4907-97c1-f7721c58a4df","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false}
        ]
    }
]


export const diagramModelData = {
    diagramData:{
        "class": "GraphLinksModel",
        "copiesArrays": true,
        "copiesArrayObjects": true,
        "linkKeyProperty": "key",
        "linkFromPortIdProperty": "fromPort",
        "linkToPortIdProperty": "toPort",
        "nodeDataArray": [
            {"name":"氨分离罐","nodeCollection":"ammonia","img":"src/assets/models/ammonia/氨分离罐.svg","category":"svg","key":"2e1c41ef-f5bd-4365-a9b9-988e3f13b8e7","loc":"-450 -399.99999999999994","size":"100 209.94475138121547","portArray":[{"name":"端口1","portId":"11c8ba71-e7cc-41ee-b7d3-cd2814e26f0f","alignment":"0.7939024142622645 0.4946518480722313 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"256b782d-5870-4e05-94ff-34f130c5060e","alignment":"0.5 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false},{"name":"端口3","portId":"dcd15cc2-ec1b-4a35-b861-377b6f75d0b9","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0"}]},
            {"name":"冷却器","nodeCollection":"ammonia","img":"src/assets/models/ammonia/冷却器.svg","category":"svg","key":"f78b6be4-4cc2-4812-96e1-aa065118398a","loc":"-250 -330","size":"97.77777777777777 40","portArray":[{"name":"端口1","portId":"51b9d16b-8eea-4c4e-92a2-5bb9d99d294f","alignment":"0 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"a8e9572b-53fb-4791-a173-e272c28bc8af","alignment":"1 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false}]},
            {"name":"压缩机","nodeCollection":"ammonia","img":"src/assets/models/ammonia/压缩机.svg","category":"svg","key":"c768e62d-251e-4eb6-bcd0-b80310bcca97","loc":"-457.5 -60","size":"80 65.625","portArray":[{"name":"端口1","portId":"55950fe5-ebe1-4d75-b6b4-30da5e97af17","alignment":"0 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":"0","toMaxLinks":"1","fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"4226d10a-0eb2-4c7a-b839-287003f573ff","alignment":"0.5200892857142833 0.09365079365079423 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false},{"name":"端口3","portId":"3f0de33c-e4c4-4187-b7bf-d8192b0708d9","alignment":"1 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false}]},
            {"name":"冷却器-2","nodeCollection":"ammonia","img":"src/assets/models/ammonia/冷却器-2.svg","category":"svg","key":"f188844a-ad0e-42bc-9112-6a1c3126bb81","loc":"-263 -70.3125","size":"100 40","portArray":[{"name":"端口1","portId":"0be6a460-df3a-423f-be3d-b38a4adead36","alignment":"0.11857314993877253 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false},{"name":"端口2","portId":"0d7b8599-993d-4474-9fb7-a1f1425cbe32","alignment":"0.11857314993877253 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0"}]},
            {"name":"三头","nodeCollection":"pipe","geometry":"F1 M0 0 L60 0 60 20 50 20 Q40 20 40 30 L40 40 20 40 20 30 Q20 20 10 20 L0 20z","fill":"rgba(128, 128, 128, 0.5)","category":"geometry","portArray":[{"name":"端口1","portId":"854f9c8e-0652-44aa-9705-95dc825ad577","alignment":"0 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","alignment":"1 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},{"name":"端口3","portId":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false}],"key":"df1e7ada-0f3f-4d9e-a3f5-e20ff03674f5","loc":"-180 -200","angle":180},
            {"name":"换热器","nodeCollection":"ammonia","img":"src/assets/models/ammonia/换热器.svg","category":"svg","key":"989dd43f-e522-446a-9983-bb0652f82606","loc":"20 -100","size":"135.51724137931035 30.000000000000004","portArray":[{"name":"端口1","portId":"e8cd7aef-9139-480c-ade2-1ef79cc4261d","alignment":"0 0.47043270833333206 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"fdc201ee-d40d-4d87-bd11-df445f3f976d","alignment":"0.4984260146753545 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false},{"name":"端口3","portId":"17fac662-e52f-43de-8c27-d24452d9ed2a","alignment":"1 0.4299158333333329 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},{"name":"端口4","portId":"2b860c7b-eafc-49b2-90ba-d32d007a2e7b","alignment":"0.4984260146753545 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0"}]},
            {"name":"换热器","nodeCollection":"ammonia","img":"src/assets/models/ammonia/换热器.svg","category":"svg","key":"140db11d-8c76-4b77-9513-d08927e9a898","loc":"20 10","size":"135.51724137931035 30.000000000000004","portArray":[{"name":"端口2","portId":"fdc201ee-d40d-4d87-bd11-df445f3f976d","alignment":"0.5 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false},{"name":"端口3","portId":"17fac662-e52f-43de-8c27-d24452d9ed2a","alignment":"1 0.5301687499999994 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false}]},
            {"name":"冷却器","nodeCollection":"ammonia","img":"src/assets/models/ammonia/冷却器.svg","category":"svg","key":"518ecc34-5089-45b6-85fa-6347bcf6c3b0","loc":"250 100","portArray":[{"name":"端口1","portId":"d5501d1f-5fa8-4d71-8a77-37c64482de72","alignment":"0.5 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false},{"name":"端口2","portId":"d17eb676-1f01-43f1-b658-b16fde8e4159","alignment":"0 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0"},{"name":"端口3","portId":"96dee2d1-babb-4b4d-b5cb-0bafad3131d9","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":"1","toMaxLinks":"0","fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false}]},
            {"name":"冷却器-2","nodeCollection":"ammonia","img":"src/assets/models/ammonia/冷却器-2.svg","category":"svg","key":"ebd9e84e-03cb-446c-8a01-45b0c72cd28b","loc":"20 -400","portArray":[{"name":"端口1","portId":"16d8e009-b1b1-45c2-a94f-1a90943ee090","alignment":"1 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0"},{"name":"端口2","portId":"ba564564-2ac8-48da-a430-3af06ea4997d","alignment":"0.5 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0"}],"angle":90},
            {"name":"合成塔","nodeCollection":"ammonia","img":"src/assets/models/ammonia/合成塔.svg","category":"svg","key":"875e1fd3-4e77-4def-86cb-aba8b62285c4","loc":"220 -460","portArray":[{"name":"端口1","portId":"415f271d-1dd7-415f-ab4f-d5a7221b095a","alignment":"0.9735206395348852 0.9054140969669111 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"ab215031-702e-4d22-9663-8c4f631c19ed","alignment":"0.8675171875000016 0.23956692325367507 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},{"name":"端口3","portId":"ec58dcb4-39fb-400e-bb0e-018ecee51d56","alignment":"0.5 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false}]},
            {"name":"开工炉","nodeCollection":"ammonia","img":"src/assets/models/ammonia/开工炉.svg","category":"svg","key":"fe4eae7d-50ed-431d-a37a-3b21d6bc4d58","loc":"470 -441.25","portArray":[{"name":"端口1","portId":"3a24769a-5f3a-49e6-953d-a5e1fce7e8be","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0"},{"name":"端口2","portId":"58c1fc66-36b0-4e21-af4f-85e52828ac76","alignment":"0.19673376572327342 0.33276178892215375 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0"}]},
            {"name":"三头","nodeCollection":"pipe","geometry":"F1 M0 0 L60 0 60 20 50 20 Q40 20 40 30 L40 40 20 40 20 30 Q20 20 10 20 L0 20z","fill":"rgba(128, 128, 128, 0.5)","category":"geometry","portArray":[{"name":"端口1","portId":"854f9c8e-0652-44aa-9705-95dc825ad577","alignment":"0 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","alignment":"1 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},{"name":"端口3","portId":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false}],"key":"92578a96-c463-4233-a1c8-f2909365828d","loc":"470 -114.5625","angle":180},
            {"name":"三头","nodeCollection":"pipe","geometry":"F1 M0 0 L60 0 60 20 50 20 Q40 20 40 30 L40 40 20 40 20 30 Q20 20 10 20 L0 20z","fill":"rgba(128, 128, 128, 0.5)","category":"geometry","portArray":[{"name":"端口1","portId":"854f9c8e-0652-44aa-9705-95dc825ad577","alignment":"0 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","alignment":"1 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},{"name":"端口3","portId":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false}],"key":"0b219174-ad9c-4e57-bd52-a1b8981c4d05","loc":"680 -240","angle":90},
            {"name":"三头","nodeCollection":"pipe","geometry":"F1 M0 0 L60 0 60 20 50 20 Q40 20 40 30 L40 40 20 40 20 30 Q20 20 10 20 L0 20z","fill":"rgba(128, 128, 128, 0.5)","category":"geometry","portArray":[{"name":"端口1","portId":"854f9c8e-0652-44aa-9705-95dc825ad577","alignment":"0 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},{"name":"端口2","portId":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","alignment":"1 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},{"name":"端口3","portId":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999,"toMaxLinks":999,"fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false}],"key":"b3f1e722-12cc-47b0-a612-bf148b7e0844","loc":"357.5 -620","angle":0}
        ],
        "linkDataArray": [
            {"key":"4a76dc14-276a-4c31-8ed5-26bb673d163d","from":"f78b6be4-4cc2-4812-96e1-aa065118398a","to":"2e1c41ef-f5bd-4365-a9b9-988e3f13b8e7","fromPort":"51b9d16b-8eea-4c4e-92a2-5bb9d99d294f","toPort":"11c8ba71-e7cc-41ee-b7d3-cd2814e26f0f","points":[-301.3888888888889,-330,-311.3888888888889,-330,-311.3888888888889,-330,-311.3888888888889,-401.1228164268244,-408.10975857377355,-401.1228164268244,-418.10975857377355,-401.1228164268244],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"c892d490-b8c6-4419-a119-890ade12e00e","from":"2e1c41ef-f5bd-4365-a9b9-988e3f13b8e7","fromPort":"256b782d-5870-4e05-94ff-34f130c5060e","toPort":"","points":[-450,-507.47237569060775,-450,-517.4723756906078,-450,-547.6190476190478,-588.0952380952383,-547.6190476190478,-588.0952380952383,-547.6190476190478,-598.0952380952383,-547.6190476190478],"from_text":"","middle_text":"","to_text":"燃料气","category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"bba68221-f36d-407b-8092-638688122a5d","from":"2e1c41ef-f5bd-4365-a9b9-988e3f13b8e7","fromPort":"dcd15cc2-ec1b-4a35-b861-377b6f75d0b9","toPort":"","points":[-450,-292.5276243093923,-450,-282.5276243093923,-450,-248.57142857142867,-588.0952380952383,-248.57142857142867,-588.0952380952383,-248.57142857142867,-598.0952380952383,-248.57142857142867],"from_text":"","middle_text":"","to_text":"氨产品","category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"fc015221-552a-4524-8dc7-67088046eaec","from":"c768e62d-251e-4eb6-bcd0-b80310bcca97","to":"f188844a-ad0e-42bc-9112-6a1c3126bb81","fromPort":"3f0de33c-e4c4-4187-b7bf-d8192b0708d9","toPort":"0be6a460-df3a-423f-be3d-b38a4adead36","points":[-415,-60,-405,-60,-370,-60,-370,-102.8125,-301.14268500612275,-102.8125,-301.14268500612275,-92.8125],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"e905f3b0-480d-45b2-b922-f978995e3106","from":"df1e7ada-0f3f-4d9e-a3f5-e20ff03674f5","to":"f78b6be4-4cc2-4812-96e1-aa065118398a","fromPort":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","toPort":"a8e9572b-53fb-4791-a173-e272c28bc8af","points":[-180,-221.75,-180,-231.75,-180,-330,-188.61111111111114,-330,-188.61111111111114,-330,-198.61111111111114,-330],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"83744eca-100d-4458-9406-1fb5efcd345e","to":"c768e62d-251e-4eb6-bcd0-b80310bcca97","fromPort":"","toPort":"55950fe5-ebe1-4d75-b6b4-30da5e97af17","points":[-603.1746031746034,-58.95691609977325,-593.1746031746034,-58.95691609977325,-560,-58.95691609977325,-560,-60,-510,-60,-500,-60],"from_text":"原料气","middle_text":"","to_text":"","category":"Arrow","highlightColor":"red","color":"black","adjusting":"End"},
            {"key":"fccb1002-adab-4624-9564-450c9168c82c","from":"f188844a-ad0e-42bc-9112-6a1c3126bb81","to":"518ecc34-5089-45b6-85fa-6347bcf6c3b0","fromPort":"0d7b8599-993d-4474-9fb7-a1f1425cbe32","toPort":"d17eb676-1f01-43f1-b658-b16fde8e4159","points":[-301.14268500612275,-47.8125,-301.14268500612275,-37.8125,-301.14268500612275,100,172.75,100,172.75,100,182.75,100],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"9dc2f55f-574d-49d8-8858-3b1a9d9f9cc3","from":"518ecc34-5089-45b6-85fa-6347bcf6c3b0","to":"140db11d-8c76-4b77-9513-d08927e9a898","fromPort":"d5501d1f-5fa8-4d71-8a77-37c64482de72","toPort":"17fac662-e52f-43de-8c27-d24452d9ed2a","points":[251.25,70.5,251.25,60.5,251.25,12.155062499999984,99.00862068965517,12.155062499999984,99.00862068965517,12.155062499999984,89.00862068965517,12.155062499999984],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"4e31a0bc-34b4-4a85-99b6-b87322620410","from":"518ecc34-5089-45b6-85fa-6347bcf6c3b0","fromPort":"96dee2d1-babb-4b4d-b5cb-0bafad3131d9","toPort":"","points":[251.25,129.5,251.25,139.5,251.25,208.17973750000021,251.60979375000034,208.17973750000021,251.60979375000034,276.85947500000043,251.60979375000034,286.85947500000043],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"a795b94a-93ab-4e59-b0c2-e6c33f9820b3","from":"989dd43f-e522-446a-9983-bb0652f82606","to":"df1e7ada-0f3f-4d9e-a3f5-e20ff03674f5","fromPort":"e8cd7aef-9139-480c-ade2-1ef79cc4261d","toPort":"854f9c8e-0652-44aa-9705-95dc825ad577","points":[-50.258620689655174,-100.88701875000004,-60.258620689655174,-100.88701875000004,-98.62931034482759,-100.88701875000004,-98.62931034482759,-188.5,-137,-188.5,-147,-188.5],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"efe3745c-23b2-41b9-a08c-1a08ab23c0ef","from":"140db11d-8c76-4b77-9513-d08927e9a898","to":"989dd43f-e522-446a-9983-bb0652f82606","fromPort":"fdc201ee-d40d-4d87-bd11-df445f3f976d","toPort":"2b860c7b-eafc-49b2-90ba-d32d007a2e7b","points":[18.75,-6.25,18.75,-16.25,18.75,-44.375,19.786697850832525,-44.375,19.786697850832525,-72.5,19.786697850832525,-82.5],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"97b97604-8d4b-400f-968f-bc872835548d","from":"ebd9e84e-03cb-446c-8a01-45b0c72cd28b","to":"989dd43f-e522-446a-9983-bb0652f82606","fromPort":"16d8e009-b1b1-45c2-a94f-1a90943ee090","toPort":"fdc201ee-d40d-4d87-bd11-df445f3f976d","points":[18.75,-316.75,18.75,-306.75,18.75,-217.125,19.786697850832525,-217.125,19.786697850832525,-127.5,19.786697850832525,-117.5],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"da9b8c04-edfb-4def-823c-d073ae591a30","from":"989dd43f-e522-446a-9983-bb0652f82606","to":"92578a96-c463-4233-a1c8-f2909365828d","fromPort":"17fac662-e52f-43de-8c27-d24452d9ed2a","toPort":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","points":[90.25862068965517,-102.10252500000001,100.25862068965517,-102.10252500000001,263.62931034482756,-102.10252500000001,263.62931034482756,-103.0625,427,-103.0625,437,-103.0625],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"87fc47be-0a0f-454d-b81a-bbf94043927b","from":"0b219174-ad9c-4e57-bd52-a1b8981c4d05","to":"875e1fd3-4e77-4def-86cb-aba8b62285c4","fromPort":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","toPort":"415f271d-1dd7-415f-ab4f-d5a7221b095a","points":[658.25,-240,648.25,-240,481.0977750000001,-240,481.0977750000001,-238.20473125000035,313.94555000000025,-238.20473125000035,303.94555000000025,-238.20473125000035],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"83ff62ba-92cf-41ce-86dc-8b626f6df1d0","from":"fe4eae7d-50ed-431d-a37a-3b21d6bc4d58","to":"b3f1e722-12cc-47b0-a612-bf148b7e0844","fromPort":"58c1fc66-36b0-4e21-af4f-85e52828ac76","toPort":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","points":[419.2806687500005,-498.35756250000065,409.2806687500005,-498.35756250000065,412,-498.35756250000065,412,-498.35756250000065,357.5,-498.35756250000065,357.5,-588.25,357.5,-598.25],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"b86e2225-a5b4-4678-9150-df63e61075b3","from":"b3f1e722-12cc-47b0-a612-bf148b7e0844","to":"875e1fd3-4e77-4def-86cb-aba8b62285c4","fromPort":"854f9c8e-0652-44aa-9705-95dc825ad577","toPort":"ab215031-702e-4d22-9663-8c4f631c19ed","points":[324.5,-631.5,314.5,-631.5,314.5,-631.5,314.5,-600.4255937500008,295.7129562500003,-600.4255937500008,285.7129562500003,-600.4255937500008],"category":"Arrow","highlightColor":"red","color":"black"},
            {"key":"9b61f83c-6340-4f5b-b290-49c0c1a92d1b","from":"875e1fd3-4e77-4def-86cb-aba8b62285c4","to":"ebd9e84e-03cb-446c-8a01-45b0c72cd28b","fromPort":"ec58dcb4-39fb-400e-bb0e-018ecee51d56","toPort":"ba564564-2ac8-48da-a430-3af06ea4997d","category":"Arrow","highlightColor":"red","color":"black","points":[220,-733.25,220,-743.25,92.125,-743.25,92.125,-401.25,58.25,-401.25,48.25,-401.25]},
            {"from":"df1e7ada-0f3f-4d9e-a3f5-e20ff03674f5","to":"c768e62d-251e-4eb6-bcd0-b80310bcca97","fromPort":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","toPort":"4226d10a-0eb2-4c7a-b839-287003f573ff","key":-21,"category":"Arrow","highlight":false,"highlightColor":"red","color":"black","points":[-213,-188.5,-223,-188.5,-455.89285714285734,-188.5,-455.89285714285734,-143.83333333333331,-455.89285714285734,-99.16666666666663,-455.89285714285734,-89.16666666666663]},
            {"from":"92578a96-c463-4233-a1c8-f2909365828d","to":"0b219174-ad9c-4e57-bd52-a1b8981c4d05","fromPort":"854f9c8e-0652-44aa-9705-95dc825ad577","toPort":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","key":-22,"category":"Arrow","highlight":false,"highlightColor":"red","color":"black","points":[503,-103.0625,513,-103.0625,691.5,-103.0625,691.5,-150.03125,691.5,-197,691.5,-207]},
            {"from":"0b219174-ad9c-4e57-bd52-a1b8981c4d05","to":"b3f1e722-12cc-47b0-a612-bf148b7e0844","fromPort":"854f9c8e-0652-44aa-9705-95dc825ad577","toPort":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","key":-23,"category":"Arrow","highlight":false,"highlightColor":"red","color":"black","points":[691.5,-273,691.5,-283,691.5,-631.5,546,-631.5,400.5,-631.5,390.5,-631.5]},
            {"from":"92578a96-c463-4233-a1c8-f2909365828d","to":"fe4eae7d-50ed-431d-a37a-3b21d6bc4d58","fromPort":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","toPort":"3a24769a-5f3a-49e6-953d-a5e1fce7e8be","key":-24,"category":"Arrow","highlight":false,"highlightColor":"red","color":"black","points":[470,-136.3125,470,-146.3125,470,-204.65625,470,-204.65625,470,-263,470,-273]}
        ]
    },
    ruleData:[
        {
            id:"51b9d16b-8eea-4c4e-92a2-5bb9d99d298t",
            name:"测试脚本",
            inputs:[{
                "key": "f78b6be4-4cc2-4812-96e1-aa065118398a",
                "valueKey": "failurePossibility"
            }],
            func:'function a(data) {if(data<0.1)alert("测试小于0.1"+data)}',
            enable:true,
            description:"测试小于0.1",
        },
        {
            id:"51b9d15b-8eea-4c4e-92a2-5bb9d99d298t",
            name:"测试脚本",
            inputs:[{
                "key": "f78b6be4-4cc2-4812-96e1-aa065118398a",
                "valueKey": "failurePossibility"
            }],
            func:'function a(data) {if(data ===0);alert("测试等于零"+data)}',
            enable:true,
            description:"测试等于零",
        },
        {
            id:"51b9d16b-8eea-4c4e-92a2-5bb9599d298t",
            name:"测试脚本",
            inputs:[{
                "key": "f78b6be4-4cc2-4812-96e1-aa065118398a",
                "valueKey": "failurePossibility"
            }],
            func:'function a(data) {if(data < 0)alert("测试小于零"+data)}',
            enable:true,
            description:"测试<0",
        },
    ]
}
