import {uuid} from "vue3-uuid";
import {diagramModelData} from "../ModelData.ts";

export const rules :Record<string, any>[]= diagramModelData['ruleData']

/**
 * 添加规则
 * @param name  规则名称
 * @param inputs 输入参数 [{key:-1 ,valueKey:'thick',testData:""}]  key表示节点在diagram中的唯一id，valueKey表示节点的属性key
 * @param func  规则函数
 */
export function addRule(name:string, inputs:any[], func:Function){
    rules.push({
        id: uuid.v4(),
        name: name,
        inputs: inputs,
        func: func,
        enable:false,
    })
}

/**
 * 更新规则
 * @param id    规则id
 * @param name  规则名称
 * @param inputs 输入参数
 * @param func  规则函数
 */
export function updateRule(id:string, name:string, inputs:[], func:Function){
    let ruleIndex = rules.findIndex((item:any) => item.id == id)
    if (ruleIndex !== -1){
        rules[ruleIndex].name = name
        rules[ruleIndex].inputs = inputs
        rules[ruleIndex].func = func
    }
}

/**
 * 删除规则
 * @param id
 */
export function deleteRuleById(id:string){
    rules.splice(rules.findIndex((item:any) => item.id == id), 1)
}


/**
 * 运行规则
 * @param rule 规则
 * @param deviceMap 设备数据
 */
export function runRule(rule:any, deviceMap:Record<string, any>){
    let inputData = []
    let runFunc = null
    if (rule){
        for (let input of rule.inputs){
            inputData.push(deviceMap[input.key][input.valueKey])
        }
        runFunc = new Function( "return " + rule.func)
        try {
            runFunc()(...inputData)
        }catch (e){
            alert(e)
        }
    }
}


export function runAllEnableRule(deviceMap:Record<string, any>){
    rules.forEach((item:any) => {
        if(item['enabled']) runRule(item, deviceMap)
    })
}
export function runRuleById(id:string, deviceMap:Record<string, any>){
    let rule = rules.find((item:any) => item.id == id)
    runRule(rule, deviceMap)
}

export function testRule(rule:any){
    let inputData = []
    let runFunc = null
    if (rule){
        for (let input of rule.inputs){
            inputData.push(input['testData'])
        }
        runFunc = new Function( "return " + rule.func)
        try {
            runFunc()(...inputData)
        }catch (e){
            alert(e)
        }
    }
}

export function testRuleById(id:string){
    let rule = rules.find((item:any) => item.id == id)
    testRule(rule)
}