import {DeviceType} from "./DeviceData.ts";

/**
 * 源节点模型分类
 * @type {{key: string; name: string; type: string}[]}
 * key: 节点类别
 * name: 节点类别名称
 * type: 节点类别类型, svg: 图片, geometry: 路径绘制, shape: gojs内置形状, go: gojs内置对象
 */
export const SourceNodeCategory: { key: string; name: string; type: string }[] = [
    {key:"valve",name:"阀门", type:"svg"},
    {key:"pump",name:"泵", type:"svg"},
    {key:"pipeline", name:"管道线", type:"svg"},
    {key:"container", name:"容器", type:"svg"},
    // {key:"shape", name:"形状", type:"geometry"},
]

export const SourceNodeModel = [
    //{name: 节点名称, nodeCollection: 节点分类, img: 节点图片路径, geometry: 节点形状, ports: 端口, category: 节点类型}
    //geometry
    //valve
    {
        name:"闸阀",
        nodeCollection: "valve",
        geometry:"XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
        stroke:'black',
        fill:'white',
        category: 'geometry',
        deviceType:DeviceType.GateValve,
        portArray:[
            {"name": "端口1", "portId": "510331ce-31ba-475b-a085-60ddc0294346", "alignment": "0 0.5 0 0", "fromLinkable": true, "toLinkable": true, "fromMaxLinks": 999, "toMaxLinks": 999, "fromSpot": "0 0.5 0 0", "toSpot": "0 0.5 0 0", "isHighlighted": false},
            {"name": "端口2", "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221", "alignment": "1 0.5 0 0", "fromLinkable": true, "toLinkable": true, "fromMaxLinks": 999, "toMaxLinks": 999, "fromSpot": "1 0.5 0 0", "toSpot": "1 0.5 0 0", "isHighlighted": false}
        ]
    },
    {
        name:"截止阀",
        nodeCollection: "valve",
        geometry:'XM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z  XM 70 30 B0 360 50 30 20 19.2 XFM 70 30 B0 360 50 30 20 19.2',
        fill:'black',
        stroke:'black',
        category: 'geometry',
        deviceType:DeviceType.GlobeValve,
        portArray:[
            {
                "name": "端口1",
                "portId": "08bb41f6-0562-45f6-8e7d-98aa35618635",
                "alignment": "0 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0"
            },
            {
                "name": "端口2",
                "portId": "7fbf4d78-02af-489f-8a77-4001e945678e",
                "alignment": "1 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]
    },
    {
        name:"止回阀",
        nodeCollection: "valve",
        geometry:'XFM 0 0 L 0 60 M 100 0 L 100 60 M 5 3 L 95 57 XFM 89.25 48.9 L 95.7 57.3 L 85 55.68 Z  ',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.CheckValve,
        portArray: [
            {
                "name": "端口1",
                "portId": "99F3CE4C-44A2-C847-6F17-17DEE2B21BE8",
                "alignment": "0 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0"
            },
            {
                "name": "端口2",
                "portId": "71C574A1-C8D9-9AC0-21CF-64FBBE7139E3",
                "alignment": "1 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]
    },
    {
        name:"球阀",
        nodeCollection: "valve",
        geometry:'XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z  XFM 70 30 B0 360 50 30 20 19.2 XFM 70 30 B0 360 50 30 20 19.2',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.BallValve,
        portArray: [
            {
                "name": "端口1",
                "portId": "255F3BFC-2E61-33A2-7631-7AACB0841175",
                "alignment": "0 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0"
            },
            {
                "name": "端口2",
                "portId": "FFBE13DD-E2CF-4C62-C4DB-38000DC2D8FD",
                "alignment": "1 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]},
    {
        name:"安全阀",
        nodeCollection: "valve",
        geometry:'XFM 50 60 L 100 30 L 100 90 Z M 50 60 L 80 110 L 20 110 Z XM 50 60 Q 50 60 50 0 XM 30 20 Q 30 20 70 20 XM 30 30 Q 30 30 70 30 ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.SafetyValve,
        portArray:[
            {
                "name": "端口1",
                "portId": "200182c3-6b87-4244-b2d4-75878cc27926",
                "alignment": "0.3765432098765432 0.02252252252252252 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 0 0 0",
                "toSpot": "0.5 0 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口2",
                "portId": "fe615891-9212-476c-b4e5-69707de8fafb",
                "alignment": "0.9691358024691358 0.545045045045045 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口3",
                "portId": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                "alignment": "0.3765432098765432 0.9684684684684685 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 1 0 0",
                "toSpot": "0.5 1 0 0"
            }
        ]
    },
    {
        name:"安全阀-2",
        nodeCollection: "valve",
        geometry:'XFM 50 60 L 80 110 L 20 110Z XFM50 60 L0 30 0 90z XM 50 60 Q 50 60 50 0 XM 30 20 Q 30 20 70 20 XM 30 30 Q 30 30 70 30 ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.SafetyValve,
        portArray:[
            {
                "name": "端口1",
                "portId": "200182c3-6b87-4244-b2d4-75878cc27926",
                "alignment": "0.6234567901234568 0.04054054054054054 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 0 0 0",
                "toSpot": "0.5 0 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口2",
                "portId": "fe615891-9212-476c-b4e5-69707de8fafb",
                "alignment": "0.030766239872685185 0.545045045045045 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口3",
                "portId": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                "alignment": "0.6234078112943673 0.9684684684684685 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 1 0 0",
                "toSpot": "0.5 1 0 0"
            }
        ]
    },

    //pump
    {
        name:"机泵",
        nodeCollection: "pump",
        geometry:' XM 0.5 34.3 0.5 0 XM 24.4 34.1 58.6 34.1 XB 0 360 24.4 34.1 24 24 XM34.5 55L46.2 71.3 2.7 71.3 14 55.5',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.CentrifugalPump,
        portArray: [
            {
                "name": "端口1",
                "portId": "2323f85f-d437-4007-85a0-4b1dd9005a38",
                "alignment": "0.21 0.18 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 0 0 0",
                "toSpot": "0.5 0 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口2",
                "portId": "7cdbcc3f-cf6d-4302-845f-6611c3199478",
                "alignment": "0.77 0.51 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口3",
                "portId": "566e7122-492f-4d10-b589-344e08ffebc4",
                "alignment": "0.63 0.37 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口4",
                "portId": "66a3bf3d-0e45-4051-8a40-1b8038756c3f",
                "alignment": "0.63 0.64 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0",
                "isHighlighted": false
            }
        ]
    },

    //pipeline
    // {name:"新旧管道交界", nodeCollection: "pipeline", img:"src/assets/models/pipeline/新旧管道交界.svg", category: 'svg'},
    {
        name:"管道变径",
        nodeCollection: "pipeline",
        geometry:'XFM 0 0 L 20 5 L 20 15 L 0 20 Z  ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.DifferentDiameterPipe,
        portArray: [
            {
                "name": "端口1",
                "portId": "15720110-de3b-4764-84ed-0d47c43b6534",
                "alignment": "0 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0"
            },
            {
                "name": "端口2",
                "portId": "43acaa78-98ce-4d32-9228-1a4630560ec9",
                "alignment": "1 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]
    },
    {
        name:"物料流向",
        nodeCollection: "pipeline",
        geometry:'XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        portArray: [
            {
                "name": "端口1",
                "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                "alignment": "0.05392156862745098 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口2",
                "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                "alignment": "0.9509803921568627 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]
    },
    {
        name:"漏斗",
        nodeCollection: "pipeline",
        geometry:'XM 30 30 Q 30 30 60 0 XM 30 30 Q 30 30 0 0 XM 30 60 Q 30 60 30 30 XM 0 75 L 6.84 54.49 Q 10 45 18 51 L 42 69 Q 50 75 53.16 65.51 L 60 45  ',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.Funnel,
        portArray: [
            {
                "name": "端口1",
                "portId": "66a23c89-77c9-4f4b-96fa-bf07c34e30f7",
                "alignment": "0.5 0.32 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 0 0 0",
                "toSpot": "0.5 0 0 0"
            }
        ]
    },
    {
        name:"8字盲板(开)",
        nodeCollection: "pipeline",
        geometry:'XM 9.9 40 Q 9.9 40 9.9 30 XM -0.1 40 Q -0.1 40 -0.1 30 XM 4.95 40 Q 4.95 40 5 20  XFM 10 5 B0 360 5 5 5 5 XM 10 15 B0 360 5 15 5 5',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.SpectacleBlind,
        portArray:[
            {
                "name": "端口1",
                "portId": "c1d6b849-16ca-4ec8-903e-20d8cf5724d9",
                "alignment": "0 0.8615603011973831 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口2",
                "portId": "700c9caf-1d25-4f95-b146-731a45804933",
                "alignment": "0.9748876669591049 0.8615603011973831 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]
    },
    {
        name:"8字盲板(关)",
        nodeCollection: "pipeline",
        geometry:'XM 5 40 Q 5 40 5 20 XM 10 40 Q 10 40 10 30 XM 5 40 Q 5 40 5 20 XM 0 40 Q 0 40 0 30  XFM 10 15 B0 360 5 15 5 5 XM 10 5 B0 360 5 5 5 5',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.SpectacleBlind,
        portArray:[
            {
                "name": "端口1",
                "portId": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                "alignment": "0 0.8703703703703703 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口2",
                "portId": "2A4DA1C2-D9FD-D1C9-192E-C1230D467F61",
                "alignment": "1 0.8703703703703703 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]
    },
    {
        name:"管道等级分界",
        nodeCollection: "pipeline",
        geometry:'XM 0 20 Q 0 20 39.88 20 XFM 48.88 20 L 39.88 23 L 39.88 17 Z XM 100 20 Q 100 20 60.12 20 XFM 51.12 20 L 60.12 17 L 60.12 23 Z XM 50 30 Q 50 30 50 0  ',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
    },
    {
        name:"s型接口",
        nodeCollection: "pipeline",
        deviceType:DeviceType.SInterface,
        geometry:'XM 10 0 Q 5 5 10 10 T 10 20',
        fill:'none',
        stroke: 'black',
        category: 'geometry',
        portArray: [
            {
                "name": "端口1",
                "portId": "67d8aea2-71e2-4510-be97-980c25f144c7",
                "alignment": "0.5 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
            }
        ]
    },
    {
        name:"管道过滤器",
        nodeCollection: "pipeline",
        geometry:'XM 0 14.71 L 70 14.71 M 70 0 L 70 29.41 M 0 0 L 0 29.41 M 35 14.71 L 63 44.12 M 56 50 L 70 37.5',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.PipeFilter,
        portArray: [
            {
                "name": "端口1",
                "portId": "2abed163-f9ac-495e-bb16-7664bf07eb65",
                "alignment": "0 0.30392156862745096 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口2",
                "portId": "cf21eda8-8426-4e93-8bad-ebc1d6b238b1",
                "alignment": "1 0.30392156862745096 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口3",
                "portId": "767c6e19-038d-4b34-90e5-94c0202af552",
                "alignment": "0.8802816901408451 0.8725490196078431 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 1 0 0",
                "toSpot": "0.5 1 0 0"
            }
        ]
    },
    {
        name:"管道混合器",
        nodeCollection: "pipeline",
        geometry:'XFM 30 20 L 70 20 L 80 30 L 70 40 L 30 40 L 20 30 Z XM 100 25 Q 100 25 100 35 XM 80 30 Q 80 30 100 30 XM 0 30 Q 0 30 20 30 XM 0 25 Q 0 25 0 35 XM 50 0 Q 50 0 50 20 XM 40 0 Q 40 0 60 0 ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.PipeMixer,
        portArray:[
            {
                "name": "端口1",
                "portId": "13482418-68c3-4d92-b4b3-97f48844088b",
                "alignment": "0 0.7439024390243902 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0"
            },
            {
                "name": "端口2",
                "portId": "1fa8ff3f-c5e5-40a7-8a44-937118702049",
                "alignment": "0.5 0.06097560975609756 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 0 0 0",
                "toSpot": "0.5 0 0 0"
            },
            {
                "name": "端口3",
                "portId": "37ca507a-de1a-4307-b131-3724aa2a5168",
                "alignment": "1 0.7439024390243902 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]
    },
    {
        name:"四接口",
        nodeCollection: "pipeline",
        geometry:'XM 0 20 Q 0 20 40 20 XM 20 40 Q 20 40 20 0 ',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        portArray: [
            {
                "name": "端口1",
                "portId": "cdfbaba7-f7f5-4eb2-ac28-6fb059ae0926",
                "alignment": "0 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0"
            },
            {
                "name": "端口2",
                "portId": "7cd95ab0-50d6-431a-9020-6e5a8f42c76c",
                "alignment": "0.5 0 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 0 0 0",
                "toSpot": "0.5 0 0 0"
            },
            {
                "name": "端口3",
                "portId": "dcad1c07-b3f9-41f9-801e-c4b09ccdf3b1",
                "alignment": "1 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            },
            {
                "name": "端口4",
                "portId": "7ddf76ec-f6e4-4a87-893d-b50e6a198565",
                "alignment": "0.5 1 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 1 0 0",
                "toSpot": "0.5 1 0 0"
            }
        ]
    },
    {
        name:"三接口",
        nodeCollection: "pipeline",
        geometry:'XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        portArray:[
            {
                "name": "端口1",
                "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口2",
                "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "alignment": "0.9146341463414634 0.9642857142857143 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            },
            {
                "name": "端口3",
                "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "alignment": "0.5 0.16666666666666666 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0.5 0 0 0",
                "toSpot": "0.5 0 0 0"
            }
        ]
    },
    {
        name: "孔板",
        geometry:'XM 20 30 L 20 0 XM 10 25 L 10 5 XM 0 30 L 0 0',
        nodeCollection:'pipeline',
        fill:'black',
        stroke: 'black',
        category: 'geometry',
        portArray: [
            {
                "name": "端口1",
                "portId": "1948eeae-c9bd-42d3-94cd-ee30ab3e2342",
                "alignment": "0 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "0 0.5 0 0",
                "toSpot": "0 0.5 0 0",
                "isHighlighted": false
            },
            {
                "name": "端口1",
                "portId": "0a531509-6b2c-4bff-96c2-2223045e2e31",
                "alignment": "1 0.5 0 0",
                "fromLinkable": true,
                "toLinkable": true,
                "fromMaxLinks": 999,
                "toMaxLinks": 999,
                "fromSpot": "1 0.5 0 0",
                "toSpot": "1 0.5 0 0"
            }
        ]
    },
    //container
    {
        name:"换热器",
        nodeCollection: "container",
        geometry:'XFM6,17h112c9.9,0,18,8.1,18,18s-8.1,18-18,18H6z XM 20 4 20 17 XM 20 67 20 54 XM 49 67 49 54 XM 81 4 81 17 XM 26.5 3.5 13.5 3.5 XM 13.5 67.5 26.5 67.5 XM 42.5 67.5 55.5 67.5 XM 87.5 3.5 74.5 3.5 XM 35 6 35 64 XM 5 6 5 64 XM 99 6 99 64',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.HeatExchanger,
    },
    {
        name:"脱硫塔",
        nodeCollection: "container",
        geometry:'XFM51,23.1c0-4.2-8.6-7.6-19.1-7.6s-19.1,3.4-19.1,7.6v30.6l3.1,9.2h32.1l3.1-9.2V23.1z XFM15.9,225.5c0,5,7.2,9,16,9s16-4,16-9 XM13.4,32.2h37c0.1,0,0.1,0,0.1,0.1c0,0,0,0.1-0.1,0.1l-37,11.9c-0.1,0-0.1,0.1-0.1,0.1      c0,0,0.1,0.1,0.1,0.1h37c0.1,0,0.1,0,0.1-0.1c0,0,0-0.1-0.1-0.1l-37-11.9C13.3,32.4,13.3,32.4,13.4,32.2 C13.3,32.3,13.4,32.2,13.4,32.2z  XFM15.8 62.9 H 47.900000000000006 V 224.9 H 15.8 z  XM 12.8 23.1 51 23.1 XM 12.8 53.1 51 53.1 XM 31.8 15.5 31.8 1.5 XM 15.5 88.7 1.5 88.7 XM 15.5 203.7 1.5 203.7 XM 47 191.7 61 191.7 XM 31.8 234 31.8 248 XM 24.8 0.5 38.8 0.5 XM 0.5 95.7 0.5 81.7 XM 0.5 210.7 0.5 196.7 XM 62 184.7 62 198.7 XM 38.8 249 24.8 249 XM16.2 104.2 L 47.9 104.2 16.2 175.1 47.9 175.1 16.2 104.2',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.DesulfurizationTower,
    },
    {
        name:"精脱硫罐",
        nodeCollection: "container",
        geometry:'XFM0,187.4c0,8.1,11.6,14.6,26,14.6s26-6.5,26-14.6 XFM0,39c0-8.1,11.6-14.6,26-14.6S52,30.9,52,39 XM11 9.4 H 41 V 15.4 H 11 z  XM 26 9.3 26 0.4 XM 36 25.3 36 16.4 XM 16 25.3 16 15.4 XM 52.4 144.6 67.2 144.6 XM 27.1 202 27.1 215.8 XM 21.6 0.5 30.5 0.5 XM 67.2 137.2 67.2 152.1 XM 34.5 215.8 19.6 215.8  XFM 0.1 187.8L0.1 38.8 52.1 38.8 52.1 187.8 XM0.3 72.1 L51.2 72.1 0.3 146 51.2 146 0.3 72.1',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.DesulfurizationTank,
    },
    {
        name:"胺液回收罐",
        nodeCollection: "container",
        geometry:'XFM39.7,23.9L39.7,23.9c13.8,0,25,11.2,25,25v124c0,13.8-11.2,25-25,25l0,0c-13.8,0-25-11.2-25-25v-124C14.7,35,25.9,23.9,39.7,23.9z   XM 8.7 50.5 71.4 50.5 XM 32.7 0.5 47.2 0.5 XM 49.2 221.2 34.7 221.2 XM 0.5 88.2 0.5 73.7 XM 39.9 0.3 39.9 24.7 XM 41.9 221.5 41.9 197 XM 0.3 80.9 14.7 80.9 XM 14.7 173.5 64.4 173.5 XM 8.7 56.5 71.4 56.5 ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.AmineRecoveryTank,
    },
    {
        name:"筒式过滤器",
        nodeCollection: "container",
        geometry:'XFM40,21.4L40,21.4c13.8,0,25,11.2,25,25v124c0,13.8-11.2,25-25,25l0,0c-13.8,0-25-11.2-25-25v-124C15,32.6,26.2,21.4,40,21.4z XM32.6 75.4 H 64.6 V 146.4 H 32.6 z  XM 15 42.1 64.7 42.1 XM 15 174.1 64.7 174.1 XM 48.6 74.4 48.6 147.4 XM 39 75.8 32.4 85.8 XM 43.5 75.8 32.4 93.8 XM 37.4 75.8 48.5 93.8 XM 42.4 75.8 48.5 85.8 XM 48.5 134.8 41.6 146.6 XM 48.5 125.8 35.9 146.6 XM 48.5 75.8 32.4 102.3 XM 32.4 75.8 48.5 102.3 XM 32.4 84.8 48.5 111.3 XM 32.4 93.8 48.5 120.3 XM 32.4 102.8 48.5 129.3 XM 32.4 111.8 48.5 138.3 XM 32.4 127.8 43.5 146.6 XM 32.4 135.8 39 146.6 XM 32.4 119.8 48.5 146.3 XM 48.5 84.8 32.4 110.9 XM 48.5 92.8 32.4 118.9 XM 48.5 101.8 32.4 127.9 XM 48.5 109.8 32.4 135.9 XM 48.5 117.8 32.4 143.9 XM 39.9 1.4 39.9 21.6 XM 40.7 215.1 40.7 195 XM 78.1 117.9 64 117.9 XM 1.4 61.7 15.6 61.7 XM 31.4 0.5 48.1 0.5 XM 49.1 216.1 32.4 216.1 XM 79.1 109.4 79.1 126.1 XM 0.5 70.1 0.5 53.4 ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.DrumFilter,
    },
    {
        name:"卧式容器",
        nodeCollection: "container",
        geometry:'XFM 6.3 30 L 93.7 30 C 97.18 30 100 23.28 100 15 C 100 6.72 97.18 0 93.7 0 L 6.3 0 C 2.82 0 0 6.72 0 15 C 0 23.28 2.82 30 6.3 30 Z M 6.3 0 L 6.3 30 M 93.7 0 L 93.7 30 XFM 60 45 Q 60 50 65 50 Q 70 50 70 45 XFM60 30 H 70 V 45 H 60 z ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType:DeviceType.HorizontalVessel
    },
    {
        name:"立式容器",
        nodeCollection: "container",
        geometry:'XFM40,21.4L40,21.4c13.8,0,25,11.2,25,25v124c0,13.8-11.2,25-25,25l0,0c-13.8,0-25-11.2-25-25      v-124C15,32.6,26.2,21.4,40,21.4z   XM 15 42.1 64.7 42.1 XM 39.9 1.4 39.9 21.6 XM 40.7 215.1 40.7 195 XM 78.1 117.9 64 117.9 XM 1.4 61.7 15.6 61.7 XM 31.4 0.5 48.1 0.5 XM 49.1 216.1 32.4 216.1 XM 79.1 109.4 79.1 126.1 XM 0.5 70.1 0.5 53.4 ',
        fill:'white',
        stroke: 'black',
        category: 'geometry',
        deviceType: DeviceType.VerticalVessel
    },
    //shape
    // {name:"矩形", nodeCollection: "shape", shape: "Rectangle", fill: "white", stroke:"black", category: 'shape'},

    //geometry
    //pipe
    // {name:"弯头", nodeCollection: "valve-g", geometry: "F1 M0 40 L0 30 Q0 0 30 0 L40 0 40 20 30 20 Q20 20 20 30 L20 40z", fill: null, category: 'geometry'},
]


export const diagramModelData = {
    diagramData:{
        "class": "GraphLinksModel",
        "copiesArrays": true,
        "copiesArrayObjects": true,
        "linkKeyProperty": "key",
        "linkFromPortIdProperty": "fromPort",
        "linkToPortIdProperty": "toPort",
        "nodeDataArray": [
            {
                "name": "脱硫塔",
                "nodeCollection": "container",
                "geometry": "XFM51,23.1c0-4.2-8.6-7.6-19.1-7.6s-19.1,3.4-19.1,7.6v30.6l3.1,9.2h32.1l3.1-9.2V23.1z XFM15.9,225.5c0,5,7.2,9,16,9s16-4,16-9 XM13.4,32.2h37c0.1,0,0.1,0,0.1,0.1c0,0,0,0.1-0.1,0.1l-37,11.9c-0.1,0-0.1,0.1-0.1,0.1      c0,0,0.1,0.1,0.1,0.1h37c0.1,0,0.1,0,0.1-0.1c0,0,0-0.1-0.1-0.1l-37-11.9C13.3,32.4,13.3,32.4,13.4,32.2 C13.3,32.3,13.4,32.2,13.4,32.2z  XFM15.8 62.9 H 47.900000000000006 V 224.9 H 15.8 z  XM 12.8 23.1 51 23.1 XM 12.8 53.1 51 53.1 XM 31.8 15.5 31.8 1.5 XM 15.5 88.7 1.5 88.7 XM 15.5 203.7 1.5 203.7 XM 47 191.7 61 191.7 XM 31.8 234 31.8 248 XM 24.8 0.5 38.8 0.5 XM 0.5 95.7 0.5 81.7 XM 0.5 210.7 0.5 196.7 XM 62 184.7 62 198.7 XM 38.8 249 24.8 249 XM16.2 104.2 L 47.9 104.2 16.2 175.1 47.9 175.1 16.2 104.2",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "desulfurization_tower",
                    "params": {}
                },
                "key": -2,
                "loc": "-52 -63",
                "size": "160 646.5040650406504",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "409d5df0-b569-4c8e-8910-aaf28b23b217",
                        "alignment": "0.5124223602484472 0.9984977885689892 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 1 0 0",
                        "toSpot": "0.5 1 0 0",
                        "visible": true,
                        "isHighlighted": false
                    },
                    {
                        "name": "端口2",
                        "portId": "9c7b39db-5cbd-4a09-9756-1d7de1f3d6d2",
                        "alignment": "0.984472049689441 0.7683591739073115 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true,
                        "isHighlighted": false
                    },
                    {
                        "name": "端口3",
                        "portId": "fe76f3a2-3af2-4873-b4ac-f21e75eb7c88",
                        "alignment": "0.2515527950310559 0.5212564781273935 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true,
                        "isHighlighted": false
                    },
                    {
                        "name": "端口4",
                        "portId": "46d0ee08-32ff-40ac-9935-01f3c3edd215",
                        "alignment": "0.7670807453416149 0.5212564781273935 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true,
                        "isHighlighted": false
                    },
                    {
                        "name": "端口5",
                        "portId": "f234300d-c9db-4782-b11f-1b2fe011d7c5",
                        "alignment": "0.7732919254658385 0.2895977008337205 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true,
                        "isHighlighted": false
                    },
                    {
                        "name": "端口6",
                        "portId": "0f1bc43c-a832-43ca-bd58-4a7ccb5b4fd1",
                        "alignment": "0.7608695652173914 0.07338284202629236 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true,
                        "isHighlighted": false
                    },
                    {
                        "name": "端口7",
                        "portId": "7af46c73-39c3-4acd-bb01-395a4bf70571",
                        "alignment": "0.5124223602484472 0.005429600686814944 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true,
                        "isHighlighted": false
                    },
                    {
                        "name": "端口8",
                        "portId": "cf976731-bb91-4fad-8a64-202712d48641",
                        "alignment": "0.015527950310559006 0.817779713063295 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true
                    }
                ]
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -1,
                "loc": "-50 315",
                "size": "50 30",
                "angle": 270
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -3,
                "loc": "-100 315",
                "size": "50 30",
                "angle": 270
            },
            {
                "name": "漏斗",
                "nodeCollection": "pipeline",
                "geometry": "XM 30 30 Q 30 30 60 0 XM 30 30 Q 30 30 0 0 XM 30 60 Q 30 60 30 30 XM 0 75 L 6.84 54.49 Q 10 45 18 51 L 42 69 Q 50 75 53.16 65.51 L 60 45  ",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "funnel",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "66a23c89-77c9-4f4b-96fa-bf07c34e30f7",
                        "alignment": "0.5 0.32 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -4,
                "loc": "-100 382",
                "size": "40 50"
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9390243902439024 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -11,
                "loc": "87 119",
                "angle": 180
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -7,
                "loc": "287 210",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -8,
                "loc": "287 110",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": true,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -9,
                "loc": "362 110",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -10,
                "loc": "227 169",
                "size": "50 30",
                "angle": 270
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -12,
                "loc": "158 110",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -13,
                "loc": "227 119",
                "angle": 180,
                "size": "40 20"
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -14,
                "loc": "419 119",
                "angle": 180,
                "size": "40 20"
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -15,
                "loc": "532 -191",
                "angle": 180,
                "size": "40 20"
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -16,
                "loc": "400 -191",
                "angle": 180,
                "size": "40 20"
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -17,
                "loc": "271 -200",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -18,
                "loc": "400 -141",
                "size": "50 30",
                "angle": 270
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": true,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -19,
                "loc": "475 -200",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -20,
                "loc": "340 -200",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -21,
                "loc": "400 -100",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9642857142857143 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -22,
                "loc": "200 -191",
                "angle": 180
            },
            {
                "name": "s型接口",
                "nodeCollection": "pipeline",
                "deviceType": {
                    "name": "s_interface",
                    "params": {}
                },
                "geometry": "XM 10 0 Q 5 5 10 10 T 10 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "67d8aea2-71e2-4510-be97-980c25f144c7",
                        "alignment": "0.5 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "visible": true
                    }
                ],
                "key": -23,
                "loc": "20 -50"
            },
            {
                "name": "s型接口",
                "nodeCollection": "pipeline",
                "deviceType": {
                    "name": "s_interface",
                    "params": {}
                },
                "geometry": "XM 10 0 Q 5 5 10 10 T 10 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "67d8aea2-71e2-4510-be97-980c25f144c7",
                        "alignment": "0.5 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "visible": true,
                        "isHighlighted": false
                    }
                ],
                "key": -24,
                "loc": "-120 -50"
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": false,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -25,
                "loc": "500 175",
                "size": "50 30",
                "angle": 270
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9642857142857143 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -27,
                "loc": "500 119",
                "angle": 180
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -29,
                "loc": "45 -200",
                "size": "50 30"
            },
            {
                "name": "止回阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 0 60 M 100 0 L 100 60 M 5 3 L 95 57 XFM 89.25 48.9 L 95.7 57.3 L 85 55.68 Z  ",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "check_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "99F3CE4C-44A2-C847-6F17-17DEE2B21BE8",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71C574A1-C8D9-9AC0-21CF-64FBBE7139E3",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -30,
                "loc": "125 -200",
                "size": "50 30"
            },
            {
                "name": "孔板",
                "geometry": "XM 20 30 L 20 0 XM 10 25 L 10 5 XM 0 30 L 0 0 ",
                "nodeCollection": "pipeline",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "1948eeae-c9bd-42d3-94cd-ee30ab3e2342",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "0a531509-6b2c-4bff-96c2-2223045e2e31",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": false,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -31,
                "loc": "615 -200"
            },
            {
                "name": "安全阀",
                "nodeCollection": "valve",
                "geometry": "XFM 50 60 L 100 30 L 100 90 Z M 50 60 L 80 110 L 20 110 Z XM 50 60 Q 50 60 50 0 XM 30 20 Q 30 20 70 20 XM 30 30 Q 30 30 70 30 ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "safety_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "200182c3-6b87-4244-b2d4-75878cc27926",
                        "alignment": "0.3765432098765432 0.02252252252252252 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "fe615891-9212-476c-b4e5-69707de8fafb",
                        "alignment": "0.9509803921568627 0.5528431657463919 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                        "alignment": "0.38235294117647056 0.9521214763150239 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 1 0 0",
                        "toSpot": "0.5 1 0 0",
                        "visible": true
                    }
                ],
                "key": -33,
                "loc": "-4 -504",
                "size": "50 68.75",
                "flip": "FlipBoth"
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -35,
                "loc": "65 -500",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -36,
                "loc": "195 -500",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -37,
                "loc": "-10 -425",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -38,
                "loc": "130 -425",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -39,
                "loc": "270 -425",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "四接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 0 20 Q 0 20 40 20 XM 20 40 Q 20 40 20 0 ",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "cdfbaba7-f7f5-4eb2-ac28-6fb059ae0926",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "7cd95ab0-50d6-431a-9020-6e5a8f42c76c",
                        "alignment": "0.5 0 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "dcad1c07-b3f9-41f9-801e-c4b09ccdf3b1",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口4",
                        "portId": "7ddf76ec-f6e4-4a87-893d-b50e6a198565",
                        "alignment": "0.5 1 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 1 0 0",
                        "toSpot": "0.5 1 0 0",
                        "visible": true
                    }
                ],
                "key": -40,
                "loc": "130 -500"
            },
            {
                "name": "安全阀-2",
                "nodeCollection": "valve",
                "geometry": "XFM 50 60 L 80 110 L 20 110Z XFM50 60 L0 30 0 90z XM 50 60 Q 50 60 50 0 XM 30 20 Q 30 20 70 20 XM 30 30 Q 30 30 70 30 ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "safety_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "200182c3-6b87-4244-b2d4-75878cc27926",
                        "alignment": "0.6234567901234568 0.04054054054054054 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                        "alignment": "0.6568627450980392 0.9587813620071685 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 1 0 0",
                        "toSpot": "0.5 1 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "bc2328de-0295-4be2-ac49-8da1a0d8fc6f",
                        "alignment": "0.049019607843137254 0.5451661338758109 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -6,
                "loc": "262 -503",
                "size": "50 68.75"
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": false,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -51,
                "loc": "186 -1009"
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -52,
                "loc": "-225 430",
                "angle": 180
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -53,
                "loc": "775 110"
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -54,
                "loc": "775 220",
                "angle": 180
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -55,
                "loc": "775 -200",
                "angle": 180
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -50,
                "loc": "776 -1000",
                "angle": 180
            },
            {
                "name": "胺液回收罐",
                "nodeCollection": "container",
                "geometry": "XFM39.7,23.9L39.7,23.9c13.8,0,25,11.2,25,25v124c0,13.8-11.2,25-25,25l0,0      c-13.8,0-25-11.2-25-25v-124C14.7,35,25.9,23.9,39.7,23.9z   XM 8.7 50.5 71.4 50.5 XM 32.7 0.5 47.2 0.5 XM 49.2 221.2 34.7 221.2 XM 0.5 88.2 0.5 73.7 XM 39.9 0.3 39.9 24.7 XM 41.9 221.5 41.9 197 XM 0.3 80.9 14.7 80.9 XM 14.7 173.5 64.4 173.5 XM 8.7 56.5 71.4 56.5 ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "amine_recovery_tank",
                    "params": {}
                },
                "key": -57,
                "loc": "-667 -489",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "ce16488b-a4d3-42c1-971a-0c7d043e268e",
                        "alignment": "0.8744798890429949 0.1804680468046806 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "e27d6abf-2814-4490-afc6-34cc70ac95e8",
                        "alignment": "0.555478502080443 0.013951395139514055 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true,
                        "isHighlighted": false
                    },
                    {
                        "name": "端口3",
                        "portId": "fe284bae-8ef6-482a-8e3a-ed7a404643d2",
                        "alignment": "0.042302357836337776 0.3604860486048606 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口4",
                        "portId": "4ee121ca-0d03-43c7-b4b2-5a43e879bb5d",
                        "alignment": "0.5970873786407759 0.9815481548154817 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 1 0 0",
                        "toSpot": "0.5 1 0 0",
                        "visible": true
                    }
                ]
            },
            {
                "name": "安全阀-2",
                "nodeCollection": "valve",
                "geometry": "XFM 50 60 L 80 110 L 20 110Z XFM50 60 L0 30 0 90z XM 50 60 Q 50 60 50 0 XM 30 20 Q 30 20 70 20 XM 30 30 Q 30 30 70 30 ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "safety_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "200182c3-6b87-4244-b2d4-75878cc27926",
                        "alignment": "0.6234567901234568 0.04054054054054054 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                        "alignment": "0.6568627450980392 0.9587813620071685 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 1 0 0",
                        "toSpot": "0.5 1 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "bc2328de-0295-4be2-ac49-8da1a0d8fc6f",
                        "alignment": "0.049019607843137254 0.5451661338758109 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -44,
                "loc": "-341 -704",
                "size": "50 68.75"
            },
            {
                "name": "四接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 0 20 Q 0 20 40 20 XM 20 40 Q 20 40 20 0 ",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "cdfbaba7-f7f5-4eb2-ac28-6fb059ae0926",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "7cd95ab0-50d6-431a-9020-6e5a8f42c76c",
                        "alignment": "0.5 0 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "dcad1c07-b3f9-41f9-801e-c4b09ccdf3b1",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口4",
                        "portId": "7ddf76ec-f6e4-4a87-893d-b50e6a198565",
                        "alignment": "0.5 1 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 1 0 0",
                        "toSpot": "0.5 1 0 0",
                        "visible": true
                    }
                ],
                "key": -45,
                "loc": "-473 -701"
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -46,
                "loc": "-333 -626",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -47,
                "loc": "-473 -626",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -48,
                "loc": "-613 -626",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -49,
                "loc": "-408 -701",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -58,
                "loc": "-538 -701",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "安全阀",
                "nodeCollection": "valve",
                "geometry": "XFM 50 60 L 100 30 L 100 90 Z M 50 60 L 80 110 L 20 110 Z XM 50 60 Q 50 60 50 0 XM 30 20 Q 30 20 70 20 XM 30 30 Q 30 30 70 30 ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "safety_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "200182c3-6b87-4244-b2d4-75878cc27926",
                        "alignment": "0.3765432098765432 0.02252252252252252 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "fe615891-9212-476c-b4e5-69707de8fafb",
                        "alignment": "0.9509803921568627 0.5528431657463919 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                        "alignment": "0.38235294117647056 0.9521214763150239 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 1 0 0",
                        "toSpot": "0.5 1 0 0",
                        "visible": true
                    }
                ],
                "key": -59,
                "loc": "-607 -705",
                "size": "50 68.75",
                "flip": "FlipBoth"
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9642857142857143 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -60,
                "loc": "-413 -1009"
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -61,
                "loc": "-663 -775",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.9146341463414634 0.9642857142857143 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -62,
                "loc": "-672 -850",
                "angle": 270
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -63,
                "loc": "-738 -850",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -64,
                "loc": "-758 -730",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -65,
                "loc": "-788 -615",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -66,
                "loc": "-813 -685",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -68,
                "loc": "-1575 -730"
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -69,
                "loc": "-1575 -1000",
                "angle": 180
            },
            {
                "name": "8字盲板(关)",
                "nodeCollection": "pipeline",
                "geometry": "XM 5 40 Q 5 40 5 20 XM 10 40 Q 10 40 10 30 XM 5 40 Q 5 40 5 20 XM 0 40 Q 0 40 0 30  XFM 10 15 B0 360 5 15 5 5 XM 10 5 B0 360 5 5 5 5",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "spectacle_blind",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                        "alignment": "0 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "2A4DA1C2-D9FD-D1C9-192E-C1230D467F61",
                        "alignment": "1 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -5,
                "loc": "-848 -630"
            },
            {
                "name": "止回阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 0 60 M 100 0 L 100 60 M 5 3 L 95 57 XFM 89.25 48.9 L 95.7 57.3 L 85 55.68 Z  ",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "check_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "99F3CE4C-44A2-C847-6F17-17DEE2B21BE8",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71C574A1-C8D9-9AC0-21CF-64FBBE7139E3",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -67,
                "loc": "-895 -615",
                "size": "50 30"
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -70,
                "loc": "-1113 -615",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -71,
                "loc": "-1574 -550",
                "angle": 180
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -72,
                "loc": "-788 -520",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.15853658536585366 0.9763764880952381 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.8902439024390244 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -73,
                "loc": "-1033 -529"
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -74,
                "loc": "-1575 -520",
                "angle": 180
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -75,
                "loc": "-700 -315",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -76,
                "loc": "-660 -315",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -77,
                "loc": "-618 -315",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "漏斗",
                "nodeCollection": "pipeline",
                "geometry": "XM 30 30 Q 30 30 60 0 XM 30 30 Q 30 30 0 0 XM 30 60 Q 30 60 30 30 XM 0 75 L 6.84 54.49 Q 10 45 18 51 L 42 69 Q 50 75 53.16 65.51 L 60 45  ",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "funnel",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "66a23c89-77c9-4f4b-96fa-bf07c34e30f7",
                        "alignment": "0.5 0.32 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -78,
                "loc": "-700 -254",
                "size": "30 37.5"
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -79,
                "loc": "-660 -156.5",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.8658536585365854 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -80,
                "loc": "-669 -214",
                "angle": 270
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -82,
                "loc": "-660 -75",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -81,
                "loc": "-715 -115",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -83,
                "loc": "-770 -95",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "三接口",
                "nodeCollection": "pipeline",
                "geometry": "XM 20 20 Q 20 20 20 0 XM 0 20 Q 0 20 40 20",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                        "alignment": "0.09146341463414634 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                        "alignment": "0.8658536585365854 0.9761904761904762 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口3",
                        "portId": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                        "alignment": "0.5 0.16666666666666666 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0.5 0 0 0",
                        "toSpot": "0.5 0 0 0",
                        "visible": true
                    }
                ],
                "key": -84,
                "loc": "-669 -9",
                "angle": 270
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -86,
                "loc": "-175 142",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "止回阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 0 60 M 100 0 L 100 60 M 5 3 L 95 57 XFM 89.25 48.9 L 95.7 57.3 L 85 55.68 Z  ",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "check_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "99F3CE4C-44A2-C847-6F17-17DEE2B21BE8",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71C574A1-C8D9-9AC0-21CF-64FBBE7139E3",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -85,
                "loc": "-248 142",
                "size": "50 30"
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -87,
                "loc": "-896 142",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -88,
                "loc": "-1060 -60",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -89,
                "loc": "-1060 277",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -90,
                "loc": "-1250 91",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -91,
                "loc": "-1325 142",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -92,
                "loc": "-1428 142",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "8字盲板(开)",
                "nodeCollection": "pipeline",
                "geometry": "XM 9.9 40 Q 9.9 40 9.9 30 XM -0.1 40 Q -0.1 40 -0.1 30 XM 4.95 40 Q 4.95 40 5 20  XFM 10 5 B0 360 5 5 5 5 XM 10 15 B0 360 5 15 5 5",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "spectacle_blind",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "c1d6b849-16ca-4ec8-903e-20d8cf5724d9",
                        "alignment": "0 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "700c9caf-1d25-4f95-b146-731a45804933",
                        "alignment": "1 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -93,
                "loc": "-1375 127"
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -94,
                "loc": "-1575 142"
            },
            {
                "name": "8字盲板(关)",
                "nodeCollection": "pipeline",
                "geometry": "XM 5 40 Q 5 40 5 20 XM 10 40 Q 10 40 10 30 XM 5 40 Q 5 40 5 20 XM 0 40 Q 0 40 0 30  XFM 10 15 B0 360 5 15 5 5 XM 10 5 B0 360 5 5 5 5",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "spectacle_blind",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                        "alignment": "0 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "2A4DA1C2-D9FD-D1C9-192E-C1230D467F61",
                        "alignment": "1 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -95,
                "loc": "-1265 42",
                "angle": 270
            },
            {
                "name": "8字盲板(关)",
                "nodeCollection": "pipeline",
                "geometry": "XM 5 40 Q 5 40 5 20 XM 10 40 Q 10 40 10 30 XM 5 40 Q 5 40 5 20 XM 0 40 Q 0 40 0 30  XFM 10 15 B0 360 5 15 5 5 XM 10 5 B0 360 5 5 5 5",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "spectacle_blind",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                        "alignment": "0 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "2A4DA1C2-D9FD-D1C9-192E-C1230D467F61",
                        "alignment": "1 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -96,
                "loc": "-1045 379",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -97,
                "loc": "-1060 430",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -98,
                "loc": "-1100 375",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "8字盲板(关)",
                "nodeCollection": "pipeline",
                "geometry": "XM 5 40 Q 5 40 5 20 XM 10 40 Q 10 40 10 30 XM 5 40 Q 5 40 5 20 XM 0 40 Q 0 40 0 30  XFM 10 15 B0 360 5 15 5 5 XM 10 5 B0 360 5 5 5 5",
                "fill": "black",
                "stroke": "black",
                "category": "geometry",
                "deviceType": {
                    "name": "spectacle_blind",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                        "alignment": "0 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "2A4DA1C2-D9FD-D1C9-192E-C1230D467F61",
                        "alignment": "1 0.8658536585365854 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -99,
                "loc": "-1222 311",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -100,
                "loc": "-1317 326",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -101,
                "loc": "-1175 326",
                "size": "50 30",
                "angle": 0
            },
            {
                "name": "闸阀",
                "nodeCollection": "valve",
                "geometry": "XFM 0 0 L 50 30 L 0 60 Z M 100 0 L 50 30 L 100 60 Z",
                "stroke": "black",
                "fill": "white",
                "category": "geometry",
                "deviceType": {
                    "name": "gate_valve",
                    "params": {}
                },
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "510331ce-31ba-475b-a085-60ddc0294346",
                        "alignment": "0 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                        "alignment": "1 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    }
                ],
                "key": -102,
                "loc": "-1250 374",
                "size": "50 30",
                "angle": 90
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.06862745098039216 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -103,
                "loc": "-1575 326",
                "angle": 180
            },
            {
                "name": "物料流向",
                "nodeCollection": "pipeline",
                "geometry": "XFM 0 5.3 L 30.13 5.3 L 30.13 0 L 50 10 L 30.13 20 L 30.13 14.7 L 0 14.7 L 0 10 Z ",
                "fill": "white",
                "stroke": "black",
                "category": "geometry",
                "portArray": [
                    {
                        "name": "端口1",
                        "portId": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                        "alignment": "0.05392156862745098 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "0 0.5 0 0",
                        "toSpot": "0 0.5 0 0",
                        "isHighlighted": false,
                        "visible": true
                    },
                    {
                        "name": "端口2",
                        "portId": "71228f4c-b92e-4068-9868-2960309c18c8",
                        "alignment": "0.9509803921568627 0.5 0 0",
                        "fromLinkable": true,
                        "toLinkable": true,
                        "fromMaxLinks": 999,
                        "toMaxLinks": 999,
                        "fromSpot": "1 0.5 0 0",
                        "toSpot": "1 0.5 0 0",
                        "visible": true
                    }
                ],
                "key": -104,
                "loc": "-1574 500",
                "angle": 180
            }
        ],
        "linkDataArray": [
            {
                "from": -2,
                "to": -3,
                "fromPort": "409d5df0-b569-4c8e-8910-aaf28b23b217",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -1,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -50,
                    261.5156885162602,
                    -50,
                    271.5156885162602,
                    -50,
                    274.2578442581301,
                    -100,
                    274.2578442581301,
                    -100,
                    277,
                    -100,
                    287
                ]
            },
            {
                "from": -2,
                "to": -1,
                "fromPort": "409d5df0-b569-4c8e-8910-aaf28b23b217",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -2,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -50,
                    261.5156885162602,
                    -50,
                    271.5156885162602,
                    -50,
                    274.2578442581301,
                    -50,
                    274.2578442581301,
                    -50,
                    277,
                    -50,
                    287
                ]
            },
            {
                "from": -3,
                "to": -4,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "66a23c89-77c9-4f4b-96fa-bf07c34e30f7",
                "key": -3,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -100,
                    343,
                    -100,
                    353,
                    -100,
                    356.65999999999997,
                    -100,
                    356.65999999999997,
                    -100,
                    360.32,
                    -100,
                    370.32
                ]
            },
            {
                "from": -13,
                "to": -8,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -5,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    246.25,
                    110,
                    256.25,
                    110,
                    256.25,
                    110,
                    249,
                    110,
                    249,
                    110,
                    259,
                    110
                ]
            },
            {
                "from": -11,
                "to": -12,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -6,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    106.25,
                    110,
                    116.25,
                    110,
                    118.125,
                    110,
                    118.125,
                    110,
                    120,
                    110,
                    130,
                    110
                ]
            },
            {
                "from": -12,
                "to": -13,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -7,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    186,
                    110,
                    196,
                    110,
                    196.75,
                    110,
                    196.75,
                    110,
                    197.5,
                    110,
                    207.5,
                    110
                ]
            },
            {
                "from": -8,
                "to": -9,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -8,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    315,
                    110,
                    325,
                    110,
                    325,
                    110,
                    324,
                    110,
                    324,
                    110,
                    334,
                    110
                ]
            },
            {
                "from": -13,
                "to": -10,
                "fromPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -9,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    227,
                    129.5,
                    227,
                    139.5,
                    227,
                    139.5,
                    227,
                    131,
                    227,
                    131,
                    227,
                    141
                ]
            },
            {
                "from": -11,
                "to": -7,
                "fromPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -10,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    87,
                    129.5,
                    87,
                    139.5,
                    87,
                    210,
                    168,
                    210,
                    249,
                    210,
                    259,
                    210
                ]
            },
            {
                "from": -9,
                "to": -14,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -11,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    390,
                    110,
                    400,
                    110,
                    400,
                    110,
                    389.5,
                    110,
                    389.5,
                    110,
                    399.5,
                    110
                ]
            },
            {
                "from": -7,
                "to": -14,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "key": -12,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    315,
                    210,
                    325,
                    210,
                    419,
                    210,
                    419,
                    174.75,
                    419,
                    139.5,
                    419,
                    129.5
                ]
            },
            {
                "from": -2,
                "to": -11,
                "fromPort": "9c7b39db-5cbd-4a09-9756-1d7de1f3d6d2",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -21,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    28.5,
                    110,
                    38.5,
                    110,
                    47.5,
                    110,
                    47.5,
                    110,
                    56.5,
                    110,
                    66.5,
                    110
                ]
            },
            {
                "from": -24,
                "to": -2,
                "fromPort": "67d8aea2-71e2-4510-be97-980c25f144c7",
                "toPort": "fe76f3a2-3af2-4873-b4ac-f21e75eb7c88",
                "key": -23,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -117.5,
                    -50,
                    -107.5,
                    -50,
                    -106,
                    -50,
                    -106,
                    -50,
                    -104.5,
                    -50,
                    -94.5,
                    -50
                ]
            },
            {
                "from": -14,
                "to": -27,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -24,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    438.25,
                    110,
                    448.25,
                    110,
                    459.375,
                    110,
                    459.375,
                    110.25,
                    470.5,
                    110.25,
                    480.5,
                    110.25
                ]
            },
            {
                "from": -27,
                "to": -23,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "67d8aea2-71e2-4510-be97-980c25f144c7",
                "key": -28,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    519.25,
                    110,
                    529.25,
                    110,
                    529.25,
                    -50,
                    280.875,
                    -50,
                    32.5,
                    -50,
                    22.5,
                    -50
                ]
            },
            {
                "from": -31,
                "to": -15,
                "fromPort": "1948eeae-c9bd-42d3-94cd-ee30ab3e2342",
                "toPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "key": -35,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    602,
                    -200,
                    592,
                    -200,
                    576.625,
                    -200,
                    576.625,
                    -200,
                    561.25,
                    -200,
                    551.25,
                    -200
                ]
            },
            {
                "from": -25,
                "to": -27,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "key": -37,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    500,
                    147,
                    500,
                    137,
                    500,
                    137,
                    500,
                    139.5,
                    500,
                    139.5,
                    500,
                    129.5
                ]
            },
            {
                "from": -15,
                "to": -19,
                "fromPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -25,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    512.5,
                    -200,
                    502.5,
                    -200,
                    502.5,
                    -200,
                    513,
                    -200,
                    513,
                    -200,
                    503,
                    -200
                ]
            },
            {
                "from": -19,
                "to": -16,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "key": -29,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    447,
                    -200,
                    437,
                    -200,
                    433.125,
                    -200,
                    433.125,
                    -200,
                    429.25,
                    -200,
                    419.25,
                    -200
                ]
            },
            {
                "from": -16,
                "to": -18,
                "fromPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -30,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    400,
                    -180.5,
                    400,
                    -170.5,
                    400,
                    -170.5,
                    400,
                    -179,
                    400,
                    -179,
                    400,
                    -169
                ]
            },
            {
                "from": -15,
                "to": -21,
                "fromPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -31,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    532,
                    -180.5,
                    532,
                    -170.5,
                    532,
                    -100,
                    485,
                    -100,
                    438,
                    -100,
                    428,
                    -100
                ]
            },
            {
                "from": -21,
                "to": -22,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "key": -32,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    372,
                    -100,
                    362,
                    -100,
                    200,
                    -100,
                    200,
                    -135.25,
                    200,
                    -170.5,
                    200,
                    -180.5
                ]
            },
            {
                "from": -20,
                "to": -17,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -33,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    312,
                    -200,
                    302,
                    -200,
                    302,
                    -200,
                    309,
                    -200,
                    309,
                    -200,
                    299,
                    -200
                ]
            },
            {
                "from": -17,
                "to": -22,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "key": -36,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    243,
                    -200,
                    233,
                    -200,
                    231.125,
                    -200,
                    231.125,
                    -200,
                    229.25,
                    -200,
                    219.25,
                    -200
                ]
            },
            {
                "from": -22,
                "to": -30,
                "fromPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "toPort": "71C574A1-C8D9-9AC0-21CF-64FBBE7139E3",
                "key": -38,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    180.5,
                    -199.75,
                    170.5,
                    -199.75,
                    166.75,
                    -199.75,
                    166.75,
                    -200,
                    163,
                    -200,
                    153,
                    -200
                ]
            },
            {
                "from": -30,
                "to": -29,
                "fromPort": "99F3CE4C-44A2-C847-6F17-17DEE2B21BE8",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -39,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    97,
                    -200,
                    87,
                    -200,
                    85,
                    -200,
                    85,
                    -200,
                    83,
                    -200,
                    73,
                    -200
                ]
            },
            {
                "from": -29,
                "to": -2,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "f234300d-c9db-4782-b11f-1b2fe011d7c5",
                "key": -40,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    17,
                    -200,
                    7,
                    -200,
                    5.75,
                    -200,
                    5.75,
                    -200,
                    4.5,
                    -200,
                    -5.5,
                    -200
                ]
            },
            {
                "from": -38,
                "to": -40,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "7ddf76ec-f6e4-4a87-893d-b50e6a198565",
                "key": -46,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    130,
                    -453,
                    130,
                    -463,
                    130,
                    -465,
                    130,
                    -465,
                    130,
                    -467,
                    130,
                    -477
                ]
            },
            {
                "from": -33,
                "to": -35,
                "fromPort": "fe615891-9212-476c-b4e5-69707de8fafb",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -55,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    21.5,
                    -499.8496621621621,
                    31.5,
                    -499.8496621621621,
                    31.5,
                    -500,
                    27,
                    -500,
                    27,
                    -500,
                    37,
                    -500
                ]
            },
            {
                "from": -6,
                "to": -36,
                "fromPort": "bc2328de-0295-4be2-ac49-8da1a0d8fc6f",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -41,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    236.5,
                    -499.8496621621622,
                    226.5,
                    -499.8496621621622,
                    226.5,
                    -500,
                    233,
                    -500,
                    233,
                    -500,
                    223,
                    -500
                ]
            },
            {
                "from": -35,
                "to": -40,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "cdfbaba7-f7f5-4eb2-ac28-6fb059ae0926",
                "key": -54,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    93,
                    -500,
                    103,
                    -500,
                    103,
                    -500,
                    97,
                    -500,
                    97,
                    -500,
                    107,
                    -500
                ]
            },
            {
                "from": -37,
                "to": -33,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                "key": -47,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -10,
                    -453,
                    -10,
                    -463,
                    -10,
                    -463,
                    -10,
                    -459.5,
                    -10,
                    -459.5,
                    -10,
                    -469.5
                ]
            },
            {
                "from": -39,
                "to": -6,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                "key": -52,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    270,
                    -453,
                    270,
                    -463,
                    270,
                    -463,
                    270,
                    -458.5,
                    270,
                    -458.5,
                    270,
                    -468.5
                ]
            },
            {
                "from": -2,
                "to": -37,
                "fromPort": "0f1bc43c-a832-43ca-bd58-4a7ccb5b4fd1",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -51,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -9.999999999999986,
                    -342.5,
                    -9.999999999999986,
                    -352.5,
                    -9.999999999999986,
                    -369.75,
                    -10,
                    -369.75,
                    -10,
                    -387,
                    -10,
                    -397
                ]
            },
            {
                "from": -2,
                "to": -38,
                "fromPort": "0f1bc43c-a832-43ca-bd58-4a7ccb5b4fd1",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -56,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -9.999999999999986,
                    -342.5,
                    -9.999999999999986,
                    -352.5,
                    -9.999999999999986,
                    -356,
                    130,
                    -356,
                    130,
                    -387,
                    130,
                    -397
                ]
            },
            {
                "from": -2,
                "to": -39,
                "fromPort": "0f1bc43c-a832-43ca-bd58-4a7ccb5b4fd1",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -57,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -9.999999999999986,
                    -342.5,
                    -9.999999999999986,
                    -352.5,
                    -9.999999999999986,
                    -356,
                    270,
                    -356,
                    270,
                    -387,
                    270,
                    -397
                ]
            },
            {
                "from": -36,
                "to": -40,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "dcad1c07-b3f9-41f9-801e-c4b09ccdf3b1",
                "key": -53,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    167,
                    -500,
                    157,
                    -500,
                    157,
                    -500,
                    163,
                    -500,
                    163,
                    -500,
                    153,
                    -500
                ]
            },
            {
                "from": -1,
                "to": -52,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                "key": -59,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -50,
                    343,
                    -50,
                    353,
                    -50,
                    430,
                    -119.875,
                    430,
                    -189.75,
                    430,
                    -199.75,
                    430
                ],
                "from_text": "",
                "middle_text": "",
                "to_text": "富液"
            },
            {
                "from": -27,
                "to": -53,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                "key": -60,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    519.25,
                    110,
                    529.25,
                    110,
                    609.5,
                    110,
                    609.5,
                    110,
                    739.75,
                    110,
                    749.75,
                    110
                ],
                "from_text": "",
                "middle_text": "",
                "to_text": "富液"
            },
            {
                "from": -54,
                "to": -25,
                "fromPort": "71228f4c-b92e-4068-9868-2960309c18c8",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -61,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    749.5,
                    220,
                    739.5,
                    220,
                    500,
                    220,
                    500,
                    213,
                    500,
                    213,
                    500,
                    203
                ],
                "from_text": "富液",
                "middle_text": "",
                "to_text": ""
            },
            {
                "from": -55,
                "to": -31,
                "fromPort": "71228f4c-b92e-4068-9868-2960309c18c8",
                "toPort": "0a531509-6b2c-4bff-96c2-2223045e2e31",
                "key": -62,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    749.5,
                    -200,
                    739.5,
                    -200,
                    688.75,
                    -200,
                    688.75,
                    -200,
                    638,
                    -200,
                    628,
                    -200
                ],
                "from_text": "贫液",
                "middle_text": "",
                "to_text": ""
            },
            {
                "from": -49,
                "to": -45,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "dcad1c07-b3f9-41f9-801e-c4b09ccdf3b1",
                "key": -44,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -436,
                    -701,
                    -446,
                    -701,
                    -446,
                    -701,
                    -440,
                    -701,
                    -440,
                    -701,
                    -450,
                    -701
                ]
            },
            {
                "from": -46,
                "to": -44,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                "key": -45,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -333,
                    -654,
                    -333,
                    -664,
                    -333,
                    -664,
                    -333,
                    -659.5,
                    -333,
                    -659.5,
                    -333,
                    -669.5
                ]
            },
            {
                "from": -48,
                "to": -59,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "ef8ae603-9326-45b1-b954-063d7c1189f3",
                "key": -48,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -613,
                    -654,
                    -613,
                    -664,
                    -613,
                    -664,
                    -613,
                    -660.5000000000001,
                    -613,
                    -660.5000000000001,
                    -613,
                    -670.5000000000001
                ]
            },
            {
                "from": -58,
                "to": -45,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "cdfbaba7-f7f5-4eb2-ac28-6fb059ae0926",
                "key": -49,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -510,
                    -701,
                    -500,
                    -701,
                    -500,
                    -701,
                    -506,
                    -701,
                    -506,
                    -701,
                    -496,
                    -701
                ]
            },
            {
                "from": -44,
                "to": -49,
                "fromPort": "bc2328de-0295-4be2-ac49-8da1a0d8fc6f",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -50,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -366.5,
                    -700.8496621621622,
                    -376.5,
                    -700.8496621621622,
                    -376.5,
                    -700.924831081081,
                    -370,
                    -700.924831081081,
                    -370,
                    -701,
                    -380,
                    -701
                ]
            },
            {
                "from": -59,
                "to": -58,
                "fromPort": "fe615891-9212-476c-b4e5-69707de8fafb",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -63,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -581.5,
                    -700.8496621621622,
                    -571.5,
                    -700.8496621621622,
                    -571.5,
                    -701,
                    -576,
                    -701,
                    -576,
                    -701,
                    -566,
                    -701
                ]
            },
            {
                "from": -47,
                "to": -45,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "7ddf76ec-f6e4-4a87-893d-b50e6a198565",
                "key": -64,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -473,
                    -654,
                    -473,
                    -664,
                    -473,
                    -666,
                    -473,
                    -666,
                    -473,
                    -668,
                    -473,
                    -678
                ]
            },
            {
                "from": -57,
                "to": -48,
                "fromPort": "ce16488b-a4d3-42c1-971a-0c7d043e268e",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -65,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -637.5,
                    -560,
                    -627.5,
                    -560,
                    -628,
                    -560,
                    -628,
                    -560,
                    -613,
                    -560,
                    -613,
                    -588,
                    -613,
                    -598
                ]
            },
            {
                "from": -57,
                "to": -47,
                "fromPort": "ce16488b-a4d3-42c1-971a-0c7d043e268e",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -66,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -637.5,
                    -560,
                    -627.5,
                    -560,
                    -473,
                    -560,
                    -473,
                    -588,
                    -473,
                    -588,
                    -473,
                    -598
                ]
            },
            {
                "from": -57,
                "to": -46,
                "fromPort": "ce16488b-a4d3-42c1-971a-0c7d043e268e",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -67,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -637.5,
                    -560,
                    -627.5,
                    -560,
                    -628,
                    -560,
                    -628,
                    -559.9999999999999,
                    -333,
                    -559.9999999999999,
                    -333,
                    -588,
                    -333,
                    -598
                ]
            },
            {
                "from": -51,
                "to": -60,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -68,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    166.75,
                    -1000,
                    156.75,
                    -1000,
                    -99.875,
                    -1000,
                    -99.875,
                    -1000.25,
                    -383.5,
                    -1000.25,
                    -393.5,
                    -1000.25
                ]
            },
            {
                "from": -45,
                "to": -60,
                "fromPort": "7cd95ab0-50d6-431a-9020-6e5a8f42c76c",
                "toPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "key": -71,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -473,
                    -724,
                    -473,
                    -734,
                    -473,
                    -1029.5,
                    -413,
                    -1029.5,
                    -413,
                    -1029.5,
                    -413,
                    -1019.5
                ]
            },
            {
                "from": -62,
                "to": -61,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -73,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -663,
                    -830.75,
                    -663,
                    -820.75,
                    -663,
                    -816.875,
                    -663,
                    -816.875,
                    -663,
                    -813,
                    -663,
                    -803
                ]
            },
            {
                "from": -61,
                "to": -57,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "e27d6abf-2814-4490-afc6-34cc70ac95e8",
                "key": -74,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -663,
                    -747,
                    -663,
                    -737,
                    -663,
                    -673.25,
                    -663,
                    -673.25,
                    -663,
                    -609.5,
                    -663,
                    -599.5
                ]
            },
            {
                "from": -62,
                "to": -63,
                "fromPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -75,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -682.5,
                    -850,
                    -692.5,
                    -850,
                    -696.25,
                    -850,
                    -696.25,
                    -850,
                    -700,
                    -850,
                    -710,
                    -850
                ]
            },
            {
                "from": -60,
                "to": -69,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                "key": -69,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -432.25,
                    -1000,
                    -442.25,
                    -1000,
                    -872.5,
                    -1000,
                    -872.5,
                    -1000,
                    -1539.75,
                    -1000,
                    -1549.75,
                    -1000
                ],
                "from_text": "",
                "middle_text": "",
                "to_text": "烃类"
            },
            {
                "from": -66,
                "to": -64,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -76,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -813,
                    -713,
                    -813,
                    -723,
                    -813,
                    -730,
                    -796,
                    -730,
                    -796,
                    -730,
                    -786,
                    -730
                ]
            },
            {
                "from": -64,
                "to": -61,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -77,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -730,
                    -730,
                    -720,
                    -730,
                    -663,
                    -730,
                    -663,
                    -737,
                    -663,
                    -737,
                    -663,
                    -747
                ]
            },
            {
                "from": -68,
                "to": -64,
                "fromPort": "71228f4c-b92e-4068-9868-2960309c18c8",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -78,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1549.5,
                    -730,
                    -1539.5,
                    -730,
                    -1049.25,
                    -730,
                    -1049.25,
                    -730,
                    -796,
                    -730,
                    -786,
                    -730
                ],
                "from_text": "液化石油气",
                "middle_text": "",
                "to_text": ""
            },
            {
                "from": -61,
                "to": -65,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -79,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -663,
                    -747,
                    -663,
                    -737,
                    -663,
                    -615,
                    -750,
                    -615,
                    -750,
                    -615,
                    -760,
                    -615
                ]
            },
            {
                "from": -65,
                "to": -5,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "2A4DA1C2-D9FD-D1C9-192E-C1230D467F61",
                "key": -80,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -816,
                    -615,
                    -826,
                    -615,
                    -828,
                    -615,
                    -828,
                    -615,
                    -830,
                    -615,
                    -840,
                    -615
                ]
            },
            {
                "from": -5,
                "to": -67,
                "fromPort": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                "toPort": "71C574A1-C8D9-9AC0-21CF-64FBBE7139E3",
                "key": -81,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -856,
                    -615,
                    -866,
                    -615,
                    -866,
                    -615,
                    -857,
                    -615,
                    -857,
                    -615,
                    -867,
                    -615
                ]
            },
            {
                "from": -67,
                "to": -70,
                "fromPort": "99F3CE4C-44A2-C847-6F17-17DEE2B21BE8",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -82,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -923,
                    -615,
                    -933,
                    -615,
                    -1004,
                    -615,
                    -1004,
                    -615,
                    -1075,
                    -615,
                    -1085,
                    -615
                ]
            },
            {
                "from": -67,
                "to": -71,
                "fromPort": "99F3CE4C-44A2-C847-6F17-17DEE2B21BE8",
                "toPort": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                "key": -83,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -923,
                    -615,
                    -933,
                    -615,
                    -933,
                    -615,
                    -933,
                    -550,
                    -1538.75,
                    -550,
                    -1548.75,
                    -550
                ],
                "from_text": "",
                "middle_text": "",
                "to_text": "新鲜水"
            },
            {
                "from": -57,
                "to": -72,
                "fromPort": "fe284bae-8ef6-482a-8e3a-ed7a404643d2",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -84,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -702.5,
                    -520,
                    -712.5,
                    -520,
                    -731.25,
                    -520,
                    -731.25,
                    -520,
                    -750,
                    -520,
                    -760,
                    -520
                ]
            },
            {
                "from": -63,
                "to": -73,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "key": -85,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -766,
                    -850,
                    -776,
                    -850,
                    -1033,
                    -850,
                    -1033,
                    -549.501953125,
                    -1033,
                    -549.501953125,
                    -1033,
                    -539.501953125
                ]
            },
            {
                "from": -72,
                "to": -73,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -86,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -816,
                    -520,
                    -826,
                    -520,
                    -915.25,
                    -520,
                    -915.25,
                    -520.001953125,
                    -1004.5,
                    -520.001953125,
                    -1014.5,
                    -520.001953125
                ]
            },
            {
                "from": -73,
                "to": -74,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                "key": -87,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1049.5,
                    -519.998046875,
                    -1059.5,
                    -519.998046875,
                    -1182.5,
                    -519.998046875,
                    -1182.5,
                    -520,
                    -1539.75,
                    -520,
                    -1549.75,
                    -520
                ],
                "from_text": "",
                "middle_text": "",
                "to_text": "液化石油气"
            },
            {
                "from": -2,
                "to": -62,
                "fromPort": "7af46c73-39c3-4acd-bb01-395a4bf70571",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -88,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -50,
                    -386.5,
                    -50,
                    -396.5,
                    -50,
                    -396,
                    -50,
                    -396,
                    -50,
                    -876,
                    -663.25,
                    -876,
                    -663.25,
                    -879.5,
                    -663.25,
                    -869.5
                ]
            },
            {
                "from": -40,
                "to": -51,
                "fromPort": "7cd95ab0-50d6-431a-9020-6e5a8f42c76c",
                "toPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "key": -89,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    130,
                    -523,
                    130,
                    -533,
                    130,
                    -1029.5,
                    158,
                    -1029.5,
                    186,
                    -1029.5,
                    186,
                    -1019.5
                ]
            },
            {
                "from": -57,
                "to": -76,
                "fromPort": "4ee121ca-0d03-43c7-b4b2-5a43e879bb5d",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -90,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    -379.5,
                    -660,
                    -369.5,
                    -660,
                    -369.5,
                    -660,
                    -369.5,
                    -660,
                    -353,
                    -660,
                    -343
                ]
            },
            {
                "from": -57,
                "to": -77,
                "fromPort": "4ee121ca-0d03-43c7-b4b2-5a43e879bb5d",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -91,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    -379.5,
                    -660,
                    -369.5,
                    -660,
                    -369.5,
                    -618,
                    -369.5,
                    -618,
                    -353,
                    -618,
                    -343
                ]
            },
            {
                "from": -57,
                "to": -75,
                "fromPort": "4ee121ca-0d03-43c7-b4b2-5a43e879bb5d",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -92,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    -379.5,
                    -660,
                    -369.5,
                    -660,
                    -369.5,
                    -700,
                    -369.5,
                    -700,
                    -353,
                    -700,
                    -343
                ]
            },
            {
                "from": -75,
                "to": -78,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "66a23c89-77c9-4f4b-96fa-bf07c34e30f7",
                "key": -93,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -700,
                    -287,
                    -700,
                    -277,
                    -700,
                    -275.21500000000003,
                    -700,
                    -275.21500000000003,
                    -700,
                    -273.43,
                    -700,
                    -263.43
                ]
            },
            {
                "from": -76,
                "to": -80,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -94,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    -287,
                    -660,
                    -277,
                    -660,
                    -257.78716527706797,
                    -660,
                    -257.78716527706797,
                    -660,
                    -241.5,
                    -660,
                    -231.5
                ]
            },
            {
                "from": -80,
                "to": -79,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -95,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    -194.75,
                    -660,
                    -184.75,
                    -660,
                    -184.75,
                    -660,
                    -194.5,
                    -660,
                    -194.5,
                    -660,
                    -184.5
                ]
            },
            {
                "from": -79,
                "to": -82,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -96,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    -128.5,
                    -660,
                    -118.5,
                    -660,
                    -115.75,
                    -660,
                    -115.75,
                    -660,
                    -113,
                    -660,
                    -103
                ]
            },
            {
                "from": -79,
                "to": -81,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -97,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    -128.5,
                    -660,
                    -118.5,
                    -660,
                    -115,
                    -668.5,
                    -115,
                    -677,
                    -115,
                    -687,
                    -115
                ]
            },
            {
                "from": -80,
                "to": -83,
                "fromPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -98,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -679.5,
                    -214,
                    -689.5,
                    -214,
                    -770,
                    -214,
                    -770,
                    -173.5,
                    -770,
                    -133,
                    -770,
                    -123
                ]
            },
            {
                "from": -82,
                "to": -84,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -99,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    -47,
                    -660,
                    -37,
                    -660,
                    -36.75,
                    -660,
                    -36.75,
                    -660,
                    -36.5,
                    -660,
                    -26.5
                ]
            },
            {
                "from": -83,
                "to": -84,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "d2b9bab5-8be5-4772-892a-12f889b6baac",
                "key": -100,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -770,
                    -67,
                    -770,
                    -57,
                    -770,
                    -9,
                    -729.75,
                    -9,
                    -689.5,
                    -9,
                    -679.5,
                    -9
                ]
            },
            {
                "from": -23,
                "to": -2,
                "fromPort": "67d8aea2-71e2-4510-be97-980c25f144c7",
                "toPort": "46d0ee08-32ff-40ac-9935-01f3c3edd215",
                "key": -101,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    17.5,
                    -50,
                    7.5,
                    -50,
                    5.499999999999993,
                    -50,
                    5.499999999999993,
                    -50,
                    3.499999999999986,
                    -50,
                    -6.500000000000014,
                    -50
                ]
            },
            {
                "from": -84,
                "to": -24,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "67d8aea2-71e2-4510-be97-980c25f144c7",
                "key": -102,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -660,
                    10.25,
                    -660,
                    20.25,
                    -660,
                    18.09523809523813,
                    -635.2380952380954,
                    18.09523809523813,
                    -635.2380952380954,
                    -50,
                    -132.5,
                    -50,
                    -122.5,
                    -50
                ]
            },
            {
                "from": -86,
                "to": -2,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "cf976731-bb91-4fad-8a64-202712d48641",
                "key": -103,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -147,
                    142,
                    -137,
                    142,
                    -137,
                    142,
                    -142.5,
                    142,
                    -142.5,
                    142,
                    -132.5,
                    142
                ]
            },
            {
                "from": -85,
                "to": -86,
                "fromPort": "71C574A1-C8D9-9AC0-21CF-64FBBE7139E3",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -104,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -220,
                    142,
                    -210,
                    142,
                    -210,
                    142,
                    -213,
                    142,
                    -213,
                    142,
                    -203,
                    142
                ]
            },
            {
                "from": -87,
                "to": -85,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "99F3CE4C-44A2-C847-6F17-17DEE2B21BE8",
                "key": -105,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -868,
                    142,
                    -858,
                    142,
                    -574,
                    142,
                    -574,
                    142,
                    -286,
                    142,
                    -276,
                    142
                ]
            },
            {
                "from": -73,
                "to": -88,
                "fromPort": "986b50c0-cd51-43d4-a0b2-dad2ec218568",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -106,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1049.5,
                    -519.998046875,
                    -1059.5,
                    -519.998046875,
                    -1060,
                    -519.998046875,
                    -1060,
                    -308.9990234375,
                    -1060,
                    -98,
                    -1060,
                    -88
                ]
            },
            {
                "from": -89,
                "to": -87,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -107,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1060,
                    249,
                    -1060,
                    239,
                    -1060,
                    142,
                    -934,
                    142,
                    -934,
                    142,
                    -924,
                    142
                ]
            },
            {
                "from": -91,
                "to": -87,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -108,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1297,
                    142,
                    -1287,
                    142,
                    -1110.5,
                    142,
                    -1110.5,
                    142,
                    -934,
                    142,
                    -924,
                    142
                ]
            },
            {
                "from": -91,
                "to": -90,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -109,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1297,
                    142,
                    -1287,
                    142,
                    -1250,
                    142,
                    -1250,
                    135.5,
                    -1250,
                    129,
                    -1250,
                    119
                ]
            },
            {
                "from": -93,
                "to": -91,
                "fromPort": "700c9caf-1d25-4f95-b146-731a45804933",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -110,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1366.95,
                    142,
                    -1356.95,
                    142,
                    -1356.95,
                    142,
                    -1363,
                    142,
                    -1363,
                    142,
                    -1353,
                    142
                ]
            },
            {
                "from": -92,
                "to": -93,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "c1d6b849-16ca-4ec8-903e-20d8cf5724d9",
                "key": -111,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1400,
                    142,
                    -1390,
                    142,
                    -1390,
                    142,
                    -1393.05,
                    142,
                    -1393.05,
                    142,
                    -1383.05,
                    142
                ]
            },
            {
                "from": -90,
                "to": -95,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                "key": -113,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1250,
                    63,
                    -1250,
                    53,
                    -1250,
                    53,
                    -1250,
                    60,
                    -1250,
                    60,
                    -1250,
                    50
                ]
            },
            {
                "from": -88,
                "to": -89,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -114,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1060,
                    -32,
                    -1060,
                    -22,
                    -1060,
                    108.5,
                    -1060,
                    108.5,
                    -1060,
                    239,
                    -1060,
                    249
                ]
            },
            {
                "from": -89,
                "to": -96,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                "key": -115,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1060,
                    305,
                    -1060,
                    315,
                    -1060,
                    338,
                    -1060,
                    338,
                    -1060,
                    361,
                    -1060,
                    371
                ]
            },
            {
                "from": -96,
                "to": -97,
                "fromPort": "2A4DA1C2-D9FD-D1C9-192E-C1230D467F61",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -116,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1060,
                    387,
                    -1060,
                    397,
                    -1060,
                    397,
                    -1060,
                    392,
                    -1060,
                    392,
                    -1060,
                    402
                ]
            },
            {
                "from": -89,
                "to": -98,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -117,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1060,
                    305,
                    -1060,
                    315,
                    -1060,
                    326,
                    -1100,
                    326,
                    -1100,
                    337,
                    -1100,
                    347
                ]
            },
            {
                "from": -89,
                "to": -101,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -118,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1060,
                    305,
                    -1060,
                    315,
                    -1060,
                    326,
                    -1098.5,
                    326,
                    -1137,
                    326,
                    -1147,
                    326
                ]
            },
            {
                "from": -101,
                "to": -99,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "2A4DA1C2-D9FD-D1C9-192E-C1230D467F61",
                "key": -119,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1203,
                    326,
                    -1213,
                    326,
                    -1213,
                    326,
                    -1204,
                    326,
                    -1204,
                    326,
                    -1214,
                    326
                ]
            },
            {
                "from": -99,
                "to": -102,
                "fromPort": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -120,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1230,
                    326,
                    -1240,
                    326,
                    -1250,
                    326,
                    -1250,
                    331,
                    -1250,
                    336,
                    -1250,
                    346
                ]
            },
            {
                "from": -99,
                "to": -100,
                "fromPort": "E5AD2202-0A90-370B-9CA6-1D500A4BFE59",
                "toPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "key": -121,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1230,
                    326,
                    -1240,
                    326,
                    -1259.5,
                    326,
                    -1259.5,
                    326,
                    -1279,
                    326,
                    -1289,
                    326
                ]
            },
            {
                "from": -97,
                "to": -104,
                "fromPort": "3861fadc-6be3-4ff9-bac5-c4ae4545d221",
                "toPort": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                "key": -122,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1060,
                    458,
                    -1060,
                    468,
                    -1060,
                    500,
                    -1538.75,
                    500,
                    -1538.75,
                    500,
                    -1548.75,
                    500
                ],
                "from_text": "",
                "middle_text": "",
                "to_text": "焦化液化气"
            },
            {
                "from": -100,
                "to": -103,
                "fromPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "toPort": "159b0340-fb7f-4e7f-bcf3-450364a02704",
                "key": -123,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1345,
                    326,
                    -1355,
                    326,
                    -1414.875,
                    326,
                    -1414.875,
                    326,
                    -1540.5,
                    326,
                    -1550.5,
                    326
                ],
                "from_text": "",
                "middle_text": "",
                "to_text": "液化石油气"
            },
            {
                "from": -94,
                "to": -92,
                "fromPort": "71228f4c-b92e-4068-9868-2960309c18c8",
                "toPort": "510331ce-31ba-475b-a085-60ddc0294346",
                "key": -112,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    -1549.5,
                    142,
                    -1539.5,
                    142,
                    -1502.75,
                    142,
                    -1502.75,
                    142,
                    -1466,
                    142,
                    -1456,
                    142
                ],
                "from_text": "液化石油气",
                "middle_text": "",
                "to_text": ""
            },
            {
                "from": -50,
                "to": -51,
                "fromPort": "71228f4c-b92e-4068-9868-2960309c18c8",
                "toPort": "056e301c-3cce-4d9c-a6dd-9409e65e650c",
                "key": -124,
                "category": "Arrow",
                "highlight": false,
                "highlightColor": "red",
                "color": "black",
                "points": [
                    750.5,
                    -1000,
                    740.5,
                    -1000,
                    740.5,
                    -1000,
                    740.5,
                    -1000,
                    215.5,
                    -1000,
                    205.5,
                    -1000
                ],
                "from_text": "烃类",
                "middle_text": "",
                "to_text": ""
            }
        ]
    },
    ruleData:[

    ]
}
