/**
 * 源节点模型分类
 * @type {{key: string; name: string; type: string}[]}
 * key: 节点类别
 * name: 节点类别名称
 * type: 节点类别类型, svg: 图片, geometry: 路径绘制, shape: gojs内置形状
 */
export const SourceNodeCategory: { key: string; name: string; type: string }[] = [
    {key:"valve",name:"阀门", type:"svg"},
    {key:"pump",name:"泵", type:"svg"},
    // {key:"computer",name:"计算机", type:"svg"},
    {key:"ammonia", name:"氨气合成装置", type:"svg"},
    {key:"pipe", name:"管道", type:"geometry"},
    // {key:"shape", name:"形状", type:"shape"},
]

export const SourceNodeModel = [
    //{name: 节点名称, nodeCollection: 节点分类, img: 节点图片路径, geometry: 节点形状, ports: 端口, category: 节点类型}
    //svg
    //computer
    { name: "电脑", nodeCollection: "computer", img: "src/assets/models/computer/电脑.svg", category:'svg'},
    //valve
    { name: "阀-2", nodeCollection: "valve", img: "src/assets/models/valve/阀-2.svg", category:'svg'},
    { name: "阀", nodeCollection: "valve", img: "src/assets/models/valve/阀.svg",  category:'svg'},
    { name: "阀门-01", nodeCollection: "valve", img: "src/assets/models/valve/阀门-01.svg",  category:'svg'},
    { name: "阀门2-01", nodeCollection: "valve", img: "src/assets/models/valve/阀门2-01.svg",  category:'svg'},
    //pump
    {name: "立式泵", nodeCollection: "pump", img: "src/assets/models/pump/立式泵.svg",  category:'svg'},
    {name: "卧式泵", nodeCollection: "pump", img: "src/assets/models/pump/卧式泵.svg",  category:'svg'},
    {name: "旋转泵", nodeCollection: "pump", img: "src/assets/models/pump/旋转泵.svg",  category:'svg'},
    {name: "油池泵", nodeCollection: "pump", img: "src/assets/models/pump/油池泵.svg",  category:'svg'},
    //ammonia
    {name:"氨分离罐", nodeCollection:"ammonia", img:"src/assets/models/ammonia/氨分离罐.svg",  category:'svg'},
    {name:"合成塔", nodeCollection:"ammonia", img:"src/assets/models/ammonia/合成塔.svg",  category:'svg'},
    {name:"换热器", nodeCollection:"ammonia", img:"src/assets/models/ammonia/换热器.svg",  category:'svg'},
    {name:"开工炉", nodeCollection:"ammonia", img:"src/assets/models/ammonia/开工炉.svg",  category:'svg'},
    {name:"冷却器", nodeCollection:"ammonia", img:"src/assets/models/ammonia/冷却器.svg",  category:'svg'},
    {name:"冷却器-2", nodeCollection:"ammonia", img:"src/assets/models/ammonia/冷却器-2.svg",  category:'svg'},
    {name:"压缩机", nodeCollection:"ammonia", img:"src/assets/models/ammonia/压缩机.svg",  category:'svg'},

    //shape
    {name:"矩形", nodeCollection: "shape", shape: "Rectangle", fill: "white", stroke:"black", category: 'shape'},

    //geometry
    {name:"弯头", nodeCollection: "pipe", geometry: "F1 M0 40 L0 30 Q0 0 30 0 L40 0 40 20 30 20 Q20 20 20 30 L20 40z", fill: "rgba(128, 128, 128, 0.5)", category: 'geometry',
        portArray:[
            {"name":"端口1","portId":"7b1d1bec-3674-4960-9bd1-901c28940f34","alignment":"1 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0"},
            {"name":"端口2","portId":"4062f627-9bee-4ca5-b00d-cc6b39c566d9","alignment":"0.25 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0"}
        ]
    },
    {name:"三头", nodeCollection: "pipe", geometry: "F1 M0 0 L60 0 60 20 50 20 Q40 20 40 30 L40 40 20 40 20 30 Q20 20 10 20 L0 20z", fill: "rgba(128, 128, 128, 0.5)", category: 'geometry',
        portArray:[
            {"name":"端口1","portId":"854f9c8e-0652-44aa-9705-95dc825ad577","alignment":"0 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},
            {"name":"端口2","portId":"9c6c8565-d1f4-46fa-b67b-db673fd127aa","alignment":"1 0.25 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},
            {"name":"端口3","portId":"d88aaad3-7e10-47ab-81ec-0040f3c21cf7","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false},
        ]
    },
    {
        name: "四头",
        nodeCollection: "pipe",
        geometry: "F1 M0 0 L20 0 20 20 0 20z",
        fill: "rgba(128, 128, 128, 0.5)",
        category: 'geometry',
        portArray:[
            {"name":"端口1","portId":"f0438186-a2ab-43cc-b365-9a7e6dfcdfde","alignment":"0 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0 0.5 0 0","toSpot":"0 0.5 0 0","isHighlighted":false},
            {"name":"端口2","portId":"5ebe28be-db70-4b3b-873d-0a24211de76a","alignment":"0.5 0 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0.5 0 0 0","toSpot":"0.5 0 0 0","isHighlighted":false},
            {"name":"端口3","portId":"a82cf436-c76d-4643-be62-6215c831abc2","alignment":"1 0.5 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"1 0.5 0 0","toSpot":"1 0.5 0 0","isHighlighted":false},
            {"name":"端口4","portId":"630c547b-eb8c-4907-97c1-f7721c58a4df","alignment":"0.5 1 0 0","fromLinkable":true,"toLinkable":true,"fromMaxLinks":999, "toMaxLinks":999, "fromSpot":"0.5 1 0 0","toSpot":"0.5 1 0 0","isHighlighted":false}
        ]
    }
]
