import { createApp } from 'vue'
import App from './App.vue'
import gojs from 'gojs'
import ElementUI from 'element-plus';
import * as ElementPlusIconsVue from '@element-plus/icons-vue'
import "element-plus/theme-chalk/index.css"
import 'virtual:uno.css'
import './assets/iconfont/iconfont.css'

let app = createApp(App, {go: gojs})
app.use(ElementUI)

// 注册element-plus的图标
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
    app.component(key, component)
}

app.mount('#app')
