import {GO, makePort, showSmallPorts} from './GOJSKit.js';
import go from 'gojs';

// 节点选中时的边框效果
export var nodeSelectionAdornmentTemplate =
GO(go.Adornment, "Auto",
  GO(go.Shape, { fill: null, stroke: "deepskyblue", strokeWidth: 1.5, strokeDashArray: [4, 2] }),
  GO(go.Placeholder)
 );

// 表示节点旋转的锚点效果
export const makeKitTopRotatingTool = () => (
    class KitTopRotatingTool extends go.RotatingTool {
        updateAdornments(part: any) {
            go.RotatingTool.prototype.updateAdornments.call(this, part)
            const adornment = part.findAdornment('Rotating');
            if (adornment !== null) {
                adornment.location = part.rotateObject.getDocumentPoint(new go.Spot(0.5, 0, 0, -30))  // above middle top
            }
        }
    }
)
export var nodeRotateAdornmentTemplate =
GO(go.Adornment,
  { locationSpot: go.Spot.Center, locationObjectName: "CIRCLE" },
  GO(go.Shape, "Circle", { name: "CIRCLE", cursor: "pointer", desiredSize: new go.Size(7, 7), fill: "lightblue", stroke: "deepskyblue" }),
  GO(go.Shape, { geometryString: "M3.5 7 L3.5 30", isGeometryPositioned: true, stroke: "deepskyblue", strokeWidth: 1.5, strokeDashArray: [4, 2] })
);

// 可以调整节点大小的锚点效果
export var nodeResizeAdornmentTemplate =
GO(go.Adornment, "Spot",
  { locationSpot: go.Spot.Right },
  GO(go.Placeholder),
  GO(go.Shape, { alignment: go.Spot.TopLeft, cursor: "nw-resize", desiredSize: new go.Size(6, 6), fill: "lightblue", stroke: "deepskyblue" }),
  GO(go.Shape, { alignment: go.Spot.Top, cursor: "n-resize", desiredSize: new go.Size(6, 6), fill: "lightblue", stroke: "deepskyblue" }),
  GO(go.Shape, { alignment: go.Spot.TopRight, cursor: "ne-resize", desiredSize: new go.Size(6, 6), fill: "lightblue", stroke: "deepskyblue" }),
  GO(go.Shape, { alignment: go.Spot.Left, cursor: "w-resize", desiredSize: new go.Size(6, 6), fill: "lightblue", stroke: "deepskyblue" }),
  GO(go.Shape, { alignment: go.Spot.Right, cursor: "e-resize", desiredSize: new go.Size(6, 6), fill: "lightblue", stroke: "deepskyblue" }),
  GO(go.Shape, { alignment: go.Spot.BottomLeft, cursor: "se-resize", desiredSize: new go.Size(6, 6), fill: "lightblue", stroke: "deepskyblue" }),
  GO(go.Shape, { alignment: go.Spot.Bottom, cursor: "s-resize", desiredSize: new go.Size(6, 6), fill: "lightblue", stroke: "deepskyblue" }),
  GO(go.Shape, { alignment: go.Spot.BottomRight, cursor: "sw-resize", desiredSize: new go.Size(6, 6), fill: "lightblue", stroke: "deepskyblue" })
);

export var SourcePictureNodeTemplate =
GO(go.Node, "Vertical",
    GO(go.Picture,
        { width:80,height:80},
        new go.Binding("source", "img")
        ),
    GO(go.TextBlock,
        { margin: 8 ,text: "123"},
        new go.Binding("text", "name"))
)

export var DiagramPictureNodeTemplate = GO(go.Node, "Spot",
    new go.Binding('location', "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
    {selectable: true, selectionAdornmentTemplate: nodeSelectionAdornmentTemplate},
    { resizable: true, resizeObjectName: "PANEL", resizeAdornmentTemplate: nodeResizeAdornmentTemplate },
    { rotatable: true, rotateAdornmentTemplate: nodeRotateAdornmentTemplate, locationSpot:go.Spot.Center },
    {resizable: true, resizeObjectName: "view"},
    new go.Binding('angle').makeTwoWay(),
    GO(go.Panel, "Vertical",
        {name:"PANEL", cursor: "pointer", background: "lightblue"},
        GO(go.Panel, "Viewbox",{name:"view", viewboxStretch: go.GraphObject.Uniform},
            new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
            GO(go.Picture, new go.Binding("source", "img")),
        ),
        GO(go.TextBlock, {margin: 4, text:"", editable:true, background:"green", alignment:go.Spot.Bottom, alignmentFocus:go.Spot.Top}, new go.Binding("text", "name").makeTwoWay()),
    ),
    // four small named ports, one on each side:
    makePort("T", go.Spot.Top, true, true),
    makePort("L", go.Spot.Left, true, true),
    makePort("R", go.Spot.Right, true, true),
    makePort("B", go.Spot.Bottom, true, true),
    { // handle mouse enter/leave events to show/hide the ports
        mouseEnter: function(_e, node) { showSmallPorts(node, true);},
        mouseLeave: function(_e, node) { showSmallPorts(node, false); }
    }
);

