import {GO} from "./GOJSKit";
import go from "gojs";
import "./extensions/Figures.ts"

// 源节点图片或形状大小

// 源节点的模板--type: svg
/*
* size: 节点大小 例如: 40 undefined 表示使用原始大小
 */
export function makeSVGNode (stretch: typeof go.GraphObject.Fill = go.GraphObject.Fill, size?:number) {
    return GO(go.Picture,
        {name:"view", width:size, height:size, imageStretch: stretch},
        new go.Binding("source", "img"),
        new go.Binding('desiredSize', "size", go.Size.parse).makeTwoWay(go.Size.stringify),
    )
}


// 源节点的模板--type: geometry
export function makeGeometryNode(stretch: typeof go.GraphObject.Fill = go.GraphObject.Fill, size?:number){
    return GO(go.Shape,
        {name:"view", width:size,height:size, geometryStretch: stretch},
        new go.Binding("geometryString", "geometry"),
        // new go.Binding("geometry", "geometry", go.Geometry.parse),
        new go.Binding("fill", "fill"),
        new go.Binding("stroke", "stroke"),
        new go.Binding('desiredSize', "size", go.Size.parse).makeTwoWay(go.Size.stringify),
    )
}

// 源节点的模板--type: shape
export function makeShapeNode (stretch: typeof go.GraphObject.Fill = go.GraphObject.Fill, size?:number){
    return GO(go.Shape,
        {name: "view", width: size, height: size, geometryStretch: stretch},
        new go.Binding("figure", "shape"),
        new go.Binding("fill", "fill"),
        new go.Binding("stroke", "stroke"),
        new go.Binding('desiredSize', "size", go.Size.parse).makeTwoWay(go.Size.stringify),
    )
}

/*
* 不同类型返回不同的节点模板
*/
export function makeNodeTemplate(type:string, stretch=go.GraphObject.Fill, size?:number){
    switch (type) {
        case 'svg':
            return makeSVGNode(stretch, size)
        case 'geometry':
            return makeGeometryNode(stretch, size)
        case 'shape':
            return makeShapeNode(stretch, size)
        default:
            return GO(go.Shape)
    }
}

/*
* 创建节点模板，相比于 makeNodeTemplate 外面套了一层公共部分，方便整体修改
 */
export function makeDiagramNodeTemplate(type:string, stretch=go.GraphObject.Fill,  size?:number){
    return GO(go.Node, "Spot",
        {selectable: true, selectionAdornmentTemplate: nodeSelectionAdornment},
        {resizable: true,  resizeAdornmentTemplate: nodeResizeAdornment, resizeObjectName: "view"},
        {rotatable: true, rotateAdornmentTemplate: nodeRotateAdornment, locationSpot: go.Spot.Center},
        {itemTemplate: nodePortTemplate},
        new go.Binding('location', "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
        new go.Binding('angle').makeTwoWay(),
        new go.Binding("itemArray", "portArray"),
        GO(go.Panel, "Spot",
            makeNodeTemplate(type, stretch, size),
            // GO(go.TextBlock, {stroke:"red"},
            //     new go.Binding("text", "location").ofObject(),
            //     new go.Binding("angle", 'angle', v=>-v)
            // ),
        )
    )
}

export function makeSourcePanelNodeTemplate(nodeType:string, stretch=go.GraphObject.Fill, size:number){
    return GO(go.Node, "Auto",
        {selectionAdornmentTemplate:GO(go.Adornment)},
        {width:40, height:40 },
        {
            mouseEnter: function (_e, node:any){
                node.findObject("SHAPE").fill = "rgba(0, 0, 0, 0.1)"
            },
            mouseLeave: function (_e, node:any){
                node.findObject("SHAPE").fill = null
            }
        },
        GO(go.Shape, "RoundedRectangle",
            {width:40, height:40,stroke:null, fill:null, name:"SHAPE"},
        ),
        makeNodeTemplate(nodeType, stretch, size),
        {
            toolTip: GO('ToolTip', {width:100},
                GO(go.Panel, "Vertical",
                    makeNodeTemplate(nodeType, go.GraphObject.Uniform, size*3),
                    GO(go.Shape,  {figure:"LineH", width:100,height:10}),
                    GO(go.TextBlock, {margin:5 }, new go.Binding("text", "name"))
                )
            )
        }
    )
}

// 重写旋转工具
export const createRotatingTool = () => (
    class KitTopRotatingTool extends go.RotatingTool {
        updateAdornments(part: any) {
            go.RotatingTool.prototype.updateAdornments.call(this, part)
            const adornment = part.findAdornment('Rotating');
            if (adornment !== null) {
                adornment.location = part.rotateObject.getDocumentPoint(new go.Spot(0.5, 0, 0, -20))  // above middle top
            }
        }
    }
)

// 节点旋转装饰器
export var nodeRotateAdornment = GO(go.Adornment,
    { locationSpot: go.Spot.Center, locationObjectName: "Rotate" },
    GO(go.Shape, {name: "Rotate", cursor: "grab", desiredSize: new go.Size(12, 12), fill: "deepskyblue", stroke: "deepskyblue", geometryString:"M928 704h-192c-17.066667 0-32 14.933333-32 32s14.933333 32 32 32h136.533333c-76.8 100.266667-196.266667 160-326.4 160-228.266667 0-413.866667-185.6-413.866666-416 0-17.066667-14.933333-32-32-32s-32 14.933333-32 32c0 264.533333 213.333333 480 477.866666 480 134.4 0 260.266667-57.6 349.866667-153.6v89.6c0 17.066667 14.933333 32 32 32s32-14.933333 32-32v-192c0-17.066667-14.933333-32-32-32zM546.133333 32C407.466667 32 281.6 91.733333 192 189.866667V96C192 78.933333 177.066667 64 160 64S128 78.933333 128 96v192c0 17.066667 14.933333 32 32 32h192c17.066667 0 32-14.933333 32-32s-14.933333-32-32-32h-132.266667c76.8-100.266667 196.266667-160 326.4-160C774.4 96 960 281.6 960 512c0 17.066667 14.933333 32 32 32S1024 529.066667 1024 512C1024 247.466667 810.666667 32 546.133333 32z" }),
);

// 节点选中效果 装饰器
export var nodeSelectionAdornment = GO(go.Adornment, "Auto",
    GO(go.Shape, { fill: null, stroke: "deepskyblue", strokeWidth: 1.5, strokeDashArray: [4, 2] }),
    GO(go.Placeholder)
);


// 节点调整大小装饰器
export var nodeResizeAdornment = GO(go.Adornment, "Spot",
    { locationSpot: go.Spot.Right },
    GO(go.Placeholder),
    //上下左右的点容易挡住端口
    GO(go.Shape, { alignment: go.Spot.TopLeft, cursor: "nw-resize", desiredSize: new go.Size(6, 6), fill: "white", stroke: "deepskyblue" }),
    GO(go.Shape, { alignment: go.Spot.Top, cursor: "n-resize", desiredSize: new go.Size(6, 6), fill: "white", stroke: "deepskyblue" }),
    GO(go.Shape, { alignment: go.Spot.TopRight, cursor: "ne-resize", desiredSize: new go.Size(6, 6), fill: "white", stroke: "deepskyblue" }),
    GO(go.Shape, { alignment: go.Spot.Left, cursor: "w-resize", desiredSize: new go.Size(6, 6), fill: "white", stroke: "deepskyblue" }),
    GO(go.Shape, { alignment: go.Spot.Right, cursor: "e-resize", desiredSize: new go.Size(6, 6), fill: "white", stroke: "deepskyblue" }),
    GO(go.Shape, { alignment: go.Spot.BottomLeft, cursor: "se-resize", desiredSize: new go.Size(6, 6), fill: "white", stroke: "deepskyblue" }),
    GO(go.Shape, { alignment: go.Spot.Bottom, cursor: "s-resize", desiredSize: new go.Size(6, 6), fill: "white", stroke: "deepskyblue" }),
    GO(go.Shape, { alignment: go.Spot.BottomRight, cursor: "sw-resize", desiredSize: new go.Size(6, 6), fill: "white", stroke: "deepskyblue" })
);

export var nodePortTemplate = GO(go.Panel, "Spot",
    {background: "green", desiredSize: new go.Size(5, 5), cursor:"pointer"},
    new go.Binding("portId", "portId"),
    new go.Binding("alignment", "alignment", go.Spot.parse).makeTwoWay(go.Spot.stringify),
    new go.Binding("fromLinkable", "fromLinkable"),
    new go.Binding("toLinkable", "toLinkable"),
    new go.Binding("fromSpot", "fromSpot", go.Spot.parse).makeTwoWay(go.Spot.stringify),
    new go.Binding("toSpot", "toSpot", go.Spot.parse).makeTwoWay(go.Spot.stringify),
    new go.Binding('fromMaxLinks', 'fromMaxLinks'),
    new go.Binding('toMaxLinks', 'toMaxLinks'),
    new go.Binding('background', '', (data)=>{
        return data['isHighlighted']? 'red': 'green'
    }),
    new go.Binding('background', 'visible', v=>{
        return v? 'green': 'transparent'
    }),
    // {
    //     toolTip: GO('ToolTip',
    //         GO(go.Panel, "Vertical",
    //             GO(go.TextBlock, { margin: 4 }, new go.Binding('text', 'alignment')),
    //             GO(go.TextBlock, { margin: 4 }, new go.Binding('text', 'location').ofObject()),
    //         )
    //     )
    // }
)