
/**
 * 函数“loadLocalXML”使用 XMLHttpRequest 加载 XML 或 SVG 文件并将其作为 Document 对象返回。
 * @returns XML 文档对象。
 */
// 虽然是load XML 但也可以读取 SVG。
export function loadLocalSVG(svgUrl:string = '') {
    if (XMLHttpRequest) {
        let xmlReq = new XMLHttpRequest
        try{
            xmlReq.open("GET", svgUrl, false)
            xmlReq.send(null)
            return xmlReq.responseXML
        }
        catch (e) {
            console.log(e)
        }
    }
}

export function convertSVGPathToGeometry(paths:any):string {
    let geometryList = []
    for (let i = 0; i < paths.length; i++) {
        const path = paths[i];
        let prefix = ''

        let stroke = path.getAttribute("stroke");
        if (typeof stroke === "string" && stroke !== "none") {
        } else {
            continue
        }
        let fill = path.getAttribute("fill");
        if (typeof fill === "string" && fill !== "none") {
            prefix = 'F'
        }else{
            prefix=''
        }

        // convert the path data string into a go.Geometry
        let data = path.getAttribute("d");
        if (typeof data === "string") geometryList.push('X'+prefix+data)
    }
    return geometryList.join(' ')
}

export function convertSVGRectToGeometry(rects:any):string{
    let geometryList = []
    let prefix = ''

    for (let i = 0; i < rects.length; i++) {
        // represent each SVG path by a Shape of type Path with its own fill and stroke
        let rect = rects[i];

        let stroke = rect.getAttribute("stroke");
        if (typeof stroke === "string" && stroke !== "none") {
        } else {
            continue
        }

        let fill = rect.getAttribute("fill");
        if (typeof fill === "string" && fill !== "none") {
            prefix = 'F'
        }else{
            prefix = ''
        }

        // convert the path data string into a go.Geometry
        let x = rect.getAttribute("x");
        let y = rect.getAttribute("y");
        let width = rect.getAttribute("width");
        let height = rect.getAttribute("height");
        if (typeof x === 'string'){
            let rect_right = Number(x) + Number(width)
            let rect_bottom = Number(y) + Number(height)
            let data = 'X'+prefix+'M' + x+ ' ' + y +' ' +'H ' + rect_right + ' ' +'V '+ rect_bottom + ' ' + 'H ' + x + ' z'
            geometryList.push(data)
        }
    }
    return geometryList.join(' ')
}

export function convertSVGEllipseToGeometry(ellipses:any):string{
    let geometryList = []
    let prefix = ''
    for (let i = 0; i < ellipses.length; i++) {
        // represent each SVG path by a Shape of type Path with its own fill and stroke
        let ellipse = ellipses[i];

        let stroke = ellipse.getAttribute("stroke");
        if (typeof stroke === "string" && stroke !== "none") {
        } else {
        }


        let fill = ellipse.getAttribute("fill");
        if (typeof fill === "string" && fill !== "none") {
            prefix = 'F'
        }else{
            prefix = ''
        }

        // convert the path data string into a go.Geometry
        let cx = ellipse.getAttribute("cx");
        let cy = ellipse.getAttribute("cy");
        let rx = ellipse.getAttribute("rx");
        let ry = ellipse.getAttribute("ry");
        if (typeof cx==='string' && typeof cy==='string' && typeof ry === 'string' && typeof rx === 'string'){
            let start = Number(cx) + Number(rx)
            let data = 'X'+prefix+'M '+start+' '+cy+' '+'B0 360 '+cx+' '+cy+' '+rx+' '+ry
            geometryList.push(data)
        }
    }
    return geometryList.join(' ')
}

export function convertSVGLineToGeometry(lines:any):string{
    let geometryList = []
    for (let i = 0; i < lines.length; i++) {
        const line = lines[i];
        let prefix = ''

        let stroke = line.getAttribute("stroke");
        if (typeof stroke === "string" && stroke !== "none") {
        } else {
            continue
        }
        let fill = line.getAttribute("fill");
        if (typeof fill === "string" && fill !== "none") {
            prefix = 'F'
        }else{
            prefix=''
        }

        // convert the path data string into a go.Geometry
        let x1 = line.getAttribute("x1");
        let y1 = line.getAttribute("y1");
        let x2 = line.getAttribute("x2");
        let y2 = line.getAttribute("y2");
        if (typeof x1 === "string" && typeof y1 === 'string' && typeof x2 === 'string' && typeof y2 === 'string'){
            geometryList.push('X'+prefix+ 'M '+x1 + " " +y1+' '+ x2 + ' ' + y2)
        }
    }
    return geometryList.join(' ')
}

export function convertSVGCircleToGeometry(circles:any):string{
    let geometryList = []
    for (let i = 0; i < circles.length; i++) {
        const circle = circles[i];
        let prefix = ''

        let stroke = circle.getAttribute("stroke");
        if (typeof stroke === "string" && stroke !== "none") {
        } else {
            continue
        }
        let fill = circle.getAttribute("fill");
        if (typeof fill === "string" && fill !== "none") {
            prefix = 'F'
        }else{
            prefix=''
        }

        // convert the path data string into a go.Geometry
        let cx = circle.getAttribute("cx");
        let cy = circle.getAttribute("cy");
        let r = circle.getAttribute("r");
        if (typeof cx === "string" && typeof cy === 'string' && typeof r === 'string') {
            geometryList.push('X'+prefix+'B 0 360 '+ cx+' '+cy+' '+r+' '+r)
        }
    }
    return geometryList.join(' ')
}

export function convertSVGPolylineToGeometry(polylines:any):string{
    let geometryList = []
    for (let i = 0; i < polylines.length; i++) {
        const polyline = polylines[i];
        let prefix = ''

        let stroke = polyline.getAttribute("stroke");
        if (typeof stroke === "string" && stroke !== "none") {
        } else {
            continue
        }
        let fill = polyline.getAttribute("fill");
        if (typeof fill === "string" && fill !== "none") {
            prefix = 'F'
        }else{
            prefix=''
        }

        // convert the path data string into a go.Geometry
        let points = polyline.getAttribute("points");
        // 以 空格 和 , 进行分割
        let pointsList = points.split(/ |,/)
        if (pointsList.length > 0){
           let path = 'XM'+prefix+' ' + pointsList.slice(0,2).join(' ') +
               'L' + pointsList.slice(2).join(' ');
           geometryList.push(path)
        }
    }
    return geometryList.join(' ')
}
export function convertSVGToGeometry(svgUrl:string=''){
    let xmldoc = loadLocalSVG(svgUrl)
    if (xmldoc === null || xmldoc==undefined) {
        return
    }
    let paths = xmldoc.getElementsByTagName("path")
    let pathGeometry = convertSVGPathToGeometry(paths)

    let rects = xmldoc.getElementsByTagName('rect')
    let rectGeometry = convertSVGRectToGeometry(rects)

    let ellipses = xmldoc.getElementsByTagName("ellipse")
    let ellipseGeometry = convertSVGEllipseToGeometry(ellipses)

    let lines = xmldoc.getElementsByTagName('line')
    let lineGeometry = convertSVGLineToGeometry(lines)

    let circles = xmldoc.getElementsByTagName('circle')
    let circleGeometry = convertSVGCircleToGeometry(circles)

    let polylines = xmldoc.getElementsByTagName('polyline')
    let polylineGeometry = convertSVGPolylineToGeometry(polylines)

    return pathGeometry + ' ' + rectGeometry + ' ' + ellipseGeometry + ' ' + lineGeometry + ' '+ circleGeometry+' '+ polylineGeometry
}