/**
 * 源节点模型分类
 * @type {{key: string; name: string; type: string}[]}
 * key: 节点类别
 * name: 节点类别名称
 * type: 节点类别类型, svg: 图片, geometry: 路径绘制, shape: gojs内置形状
 */
export const SourceNodeCategory: { key: string; name: string; type: string }[] = [
    {key:"valve",name:"阀门", type:"svg"},
    {key:"pump",name:"泵", type:"svg"},
    {key:"computer",name:"计算机", type:"svg"},
    {key:"ammonia", name:"氨气合成装置", type:"svg"},
    {key:"pipe", name:"管道", type:"geometry"},
    {key:"shape", name:"形状", type:"shape"},
]

export const SourceNodeModel = [
    //{name: 节点名称, nodeCollection: 节点类别, img: 节点图片路径, geometry: 节点形状, ports: 端口}
    //svg
    //computer
    { name: "电脑", nodeCollection: "computer", img: "src/assets/models/computer/电脑.svg", category:'svg'},
    //valve
    { name: "阀-2", nodeCollection: "valve", img: "src/assets/models/valve/阀-2.svg", category:'svg'},
    { name: "阀", nodeCollection: "valve", img: "src/assets/models/valve/阀.svg",  category:'svg'},
    { name: "阀门-01", nodeCollection: "valve", img: "src/assets/models/valve/阀门-01.svg",  category:'svg'},
    { name: "阀门2-01", nodeCollection: "valve", img: "src/assets/models/valve/阀门2-01.svg",  category:'svg'},
    //pump
    {name: "立式泵", nodeCollection: "pump", img: "src/assets/models/pump/立式泵.svg",  category:'svg'},
    {name: "卧式泵", nodeCollection: "pump", img: "src/assets/models/pump/卧式泵.svg",  category:'svg'},
    {name: "旋转泵", nodeCollection: "pump", img: "src/assets/models/pump/旋转泵.svg",  category:'svg'},
    {name: "油池泵", nodeCollection: "pump", img: "src/assets/models/pump/油池泵.svg",  category:'svg'},
    //ammonia
    {name:"氨分离罐", nodeCollection:"ammonia", img:"src/assets/models/ammonia/氨分离罐.svg",  category:'svg'},
    {name:"合成塔", nodeCollection:"ammonia", img:"src/assets/models/ammonia/合成塔.svg",  category:'svg'},
    {name:"换热器", nodeCollection:"ammonia", img:"src/assets/models/ammonia/换热器.svg",  category:'svg'},
    {name:"开工炉", nodeCollection:"ammonia", img:"src/assets/models/ammonia/开工炉.svg",  category:'svg'},
    {name:"冷却器", nodeCollection:"ammonia", img:"src/assets/models/ammonia/冷却器.svg",  category:'svg'},
    {name:"冷却器-2", nodeCollection:"ammonia", img:"src/assets/models/ammonia/冷却器-2.svg",  category:'svg'},
    {name:"压缩机", nodeCollection:"ammonia", img:"src/assets/models/ammonia/压缩机.svg",  category:'svg'},

    //shape
    {name:"矩形", nodeCollection: "shape", shape: "Rectangle", fill: "white", stroke:"black", category: 'shape'},

    //geometry
    {name:"弯头", nodeCollection: "pipe", geometry: "F1 M0 40 L0 30 Q0 0 30 0 L40 0 40 20 30 20 Q20 20 20 30 L20 40z", fill: "rgba(128, 128, 128, 0.5)", category: 'geometry'},
]
