﻿using System;

namespace Mqtt_AGI
{
    enum systemID { 
        SERVER=1,UI,DEVICE,AGI,OAM
    }
    enum AGI_Module {CACL_TLE=1,CACL_REPORT }
    enum Server_Module { CACL_TLE = 1, CACL_REPORT }
    //分解string类型的主题  工具类 暂时用不到
    class ParseUid
    {
        public static uint getlevel1(string topic)
        {
            return (Convert.ToUInt32(topic) & 0xf0000000) >> 28;
        }
        public static uint getlevel2(string topic)
        {
            return (Convert.ToUInt32(topic) & 0x0f000000) >> 24;
        }
        public static uint getlevel3(string topic)
        {
            return (Convert.ToUInt32(topic) & 0x00f00000) >> 20;
        }
        public static uint getsystem(string topic)
        {
            return (Convert.ToUInt32(topic) & 0x000f0000) >> 16;
        }
        public static uint getsymodule(string topic)
        {
            return (Convert.ToUInt32(topic) & 0x0000f000) >> 12;
        }
    }

    //生成主题的类
    class SerializeUid
    {
        //生成对应系统 模块序列号
         public static  string SerilizeString(uint level1, uint level2, uint level3)
        {
            uint numtopic = 0;
            numtopic = numtopic | (level1 << 28) | (level2 << 24) | (level3 << 20);
            return Convert.ToString(numtopic, 2).PadLeft(32, '0');//uint转string 32位  前面补0
        }

        //由level id生成system id 和 module id
        public static string SerilizeString(string level_uid, systemID system, uint module)
        {
            return Convert.ToString((Convert.ToUInt32(level_uid) | ((uint)system << 16) | (((uint)module) << 12)), 2).PadLeft(32, '0');
        }

        //指定module id
        public static string SerilizeString(string level_system_uid, uint module) {
            return Convert.ToString( (Convert.ToUInt32(level_system_uid) |(((uint)module)<<12)) ,2).PadLeft(32,'0');
        }
        


    }
}
