﻿using System;

namespace Mqtt_AGI
{
    enum systemID { 
        SERVER=1,UI,DEVICE,AGI,OAM
    }
    //分解string类型的主题  工具类 暂时用不到
    class ParseUid
    {
        public static uint getlevel1(string topic)
        {
            return (Convert.ToUInt32(topic,2) & 0xf0000000) >> 28;
        }
        public static uint getlevel2(string topic)
        {
            return (Convert.ToUInt32(topic,2) & 0x0f000000) >> 24;
        }
        public static uint getlevel3(string topic)
        {
            return (Convert.ToUInt32(topic,2) & 0x00f00000) >> 20;
        }
        public static uint getsystem(string topic)
        {
            return (Convert.ToUInt32(topic,2) & 0x000f0000) >> 16;
        }
    }

    //生成主题的类
    class SerializeUid
    {
        //生成对应系统 模块序列号
         public static  string SerilizeString(uint level1, uint level2, uint level3)
        {
            uint numtopic = 0;
            numtopic = numtopic | (level1 << 28) | (level2 << 24) | (level3 << 20);
            return Convert.ToString(numtopic, 2).PadLeft(32, '0');//uint转string 32位  前面补0
        }

        //由level_uid生成level_system_uid 和
        public static string SerilizeTopic(string level_uid, systemID system)
        {
            return level_uid +"/" +((int)system).ToString();
            //return Convert.ToString((Convert.ToUInt32(level_uid,2) | (((uint)system) << 16) ), 2).PadLeft(32, '0');
        }
        public static string SerilizeUid(string level_uid, systemID system)
        {
            //return level_uid + "/" + ((int)system).ToString();
            return Convert.ToString((Convert.ToUInt32(level_uid,2) | (((uint)system) << 16) ), 2).PadLeft(32, '0');
        }
    }
}
