
import { PRIVILEGE } from '@/types/privilege';

const demo1 = {
  path: '/demo1',
  name: 'index-page',
  component: () => import('../views/demo1/demo1.vue'),
  meta: {
    // privileges: [PRIVILEGE.USER_MNG, PRIVILEGE.USER_LIST],
    CName: 'Demo1-subtitle',
    parentCName: 'Demo1',
  },
};
const demo2 = {
  path: '/demo2',
  name: 'demo2',
  component: () => import('../views/demo2/demo2.vue'),
  meta: {
    CName: 'Demo2-subtitle',
    parentCName: 'Demo2',
  },
};

// 按顺序 用于菜单的排列
const indexChildren = [
  demo1,
  demo2,
];

export const routes = [
  {
    path: '/login',
    name: 'login',
    component: () => import('../views/login.vue'),
    meta: { authDisabled: true },
  },
  {
    path: '/',
    name: 'index',
    redirect: 'index-page',
    component: () => import('../views/main/index.vue'),
    children: [
      ...indexChildren,
      {
        path: '*',
        name: '404_child',
        component: () => import('../component/page404.vue'),
        meta: { authDisabled: true },
      },
    ],
  },
  {
    path: '*',
    name: '404',
    component: () => import('../component/page404.vue'),
    meta: { authDisabled: true },
  },
];
