import Vue from 'vue';
import App from './App.vue';

// 加载所用组件，含core
import './plugin';
import { axiosIntercept, routeIntercept, buildMenu} from 'web-toolkit/src/case-main';
// 主菜单
export const mainMenuTitles = [
  // 如果没有子导航，直接在这指定CName一样的值
  'Demo1', 'icon-monitor',
  'Demo2', 'icon-dashboard',
  'Demo3', 'icon-dashboard',
];
export const loginTitle1 = process.env.VUE_APP_LOGIN_TITLE1;
export const loginTitle2 = process.env.VUE_APP_LOGIN_TITLE2;
export const loginLogo = process.env.VUE_APP_LOGIN_LG;
export const titleLogo = process.env.VUE_APP_TITLE_LG;
export const schema = process.env.VUE_APP_LOGIN_SCHEMA;

import './scss/common.scss';
import { routes } from './router/routes';
import { genRouter } from 'web-toolkit/src/case-main/router';
export const router = genRouter(routes);
buildMenu(routes, mainMenuTitles);
routeIntercept(router);
axiosIntercept(router);

const vm = new Vue({
  router,
  render: (h) => h(App),
});
// 可用于延迟加载
vm.$mount('#app');
