import {ComponentName, registerComponent} from 'web-toolkit/src/components/use';

// scss
import 'web-toolkit/src/scss/common.scss';
import 'web-toolkit/src/scss/vivify.scss';
// 注意加载顺序
import 'web-toolkit/src/plugins';
import 'web-toolkit/src/case-main';
import 'web-toolkit/src/filter/date-time';
// 重载
import {AxiosInterceptConfig, RouteInterceptConfig} from 'web-toolkit/src/case-main';
import Qs from 'qs';
import {storeUserInfo, submitErrChanel} from 'web-toolkit/src/case-main/store/index';
// import {DepartmentAdmin} from "@/model/department";
// @ts-ignore
import NProgress from 'nprogress';
import {Route} from "vue-router";

registerComponent(ComponentName.Table);
registerComponent(ComponentName.DatePicker);
registerComponent(ComponentName.DialogSimple);
registerComponent(ComponentName.Tip);
registerComponent(ComponentName.ErrChannel);
registerComponent(ComponentName.Empty);

RouteInterceptConfig.beforePartFunc = async function (to: Route, from: Route, next: any) {
  if (to.name !== from.name) {
    NProgress.start();
  }
  to.meta.from = from.path
  // 初始化err-msg-channel
  submitErrChanel('');
  next();
}