
// 接收刷新Config配置文件指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/cache`, params)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/cache/detail`)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/cache/config/flush`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 集成应用文件编辑.
// POST
export async function onlyofficeActionUpdateFile (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/${params.fileId}/update/file`, params)
    return data.data
}

    
// 创建文档.
// POST
export async function onlyofficeActionListPaging (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 流程平台或者内容管理创建在线编辑文档.
// POST
export async function onlyofficeActionUpload (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/upload`, params)
    return data.data
}

    
// 删除文档.
// flag: String: 文档id
// POST
export async function onlyofficeActionPreview (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/preview`, params)
    return data.data
}

    
// 获取文件编辑配置内容
// flag: String: 文档id
// GET
export async function onlyofficeActionGetMarkFile (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/markfile/${params.flag}/${params.version}`)
    return data.data
}

    
// 获取正文文件
// flag: String: 文档id
// version: String: 文档版本
// POST
export async function onlyofficeActionAppFileEdit (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/app/file/edit`, params)
    return data.data
}

    
// 获取文件信息
// flag: String: 文档id
// POST
export async function onlyofficeActionCreateForO2 (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/create/for/o2`, params)
    return data.data
}

    
// 获取加水印的文件正文内容
// flag: String: 文档id
// version: String: 文档版本
// POST
export async function onlyofficeActionToken (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/token`, params)
    return data.data
}

    
// 获取文件编辑配置内容按版本
// flag: String: 文档id
// version: String: 文档版号
// GET
export async function onlyofficeActionGetInfo (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/${params.flag}/info`)
    return data.data
}

    
// 文档列表分页显示
// page: Integer: 
// size: Integer: 
// GET
export async function onlyofficeActionGet (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/${params.flag}`)
    return data.data
}

    
// 集成应用文件预览.
// POST
export async function onlyofficeActionUrl (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/url`, params)
    return data.data
}

    
// 根据传入内容生成only office的token
// DELETE
export async function onlyofficeActionDelete (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/delete/${params.flag}`, params)
    return data.data
}

    
// 更新文档附件
// fileId: String: 文档id
// GET
export async function onlyofficeActionGetFile (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/file/${params.flag}/${params.version}`)
    return data.data
}

    
// 上传文件并自动转换
// POST
export async function onlyofficeActionCreate (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/create`, params)
    return data.data
}

    
// 获取url预览.
// GET
export async function onlyofficeActionGetVersion (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyoffice/${params.flag}/${params.version}`)
    return data.data
}

    
// 获取配置信息
// POST
export async function onlyofficeConfigActionSaveConfig (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficeconfig/save`, params)
    return data.data
}

    
// 刷新配置信息
// GET
export async function onlyofficeConfigActionGetConfig (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficeconfig/get`)
    return data.data
}

    
// 保存配置数据
// GET
export async function onlyofficeConfigActionRefresh (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficeconfig/refresh`)
    return data.data
}

    
// 获取文件正文内容
// flag: String: 文档id
// version: Integer: 文档版本(0待办最新版本)
// GET
export async function onlyofficeFileActionGetFileDiff (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/diff/${params.flag}/${params.version}`)
    return data.data
}

    
// 获取文件正文内容的changes.zip
// flag: String: 文档id
// version: Integer: 文档版本
// GET
export async function onlyofficeFileActionGetFileDiffWithName (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/diff/${params.flag}/${params.version}/changes.zip`)
    return data.data
}

    
// 获取文件正文内容的diff.zip
// flag: String: 文档id
// version: Integer: 文档版本
// token: String: 文档访问token
// GET
export async function onlyofficeFileActionGetFileDiffToken (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/diff/${params.flag}/${params.version}/${params.token}`)
    return data.data
}

    
// 获取文件正文内容的changes.zip
// flag: String: 文档id
// version: Integer: 文档版本
// GET
export async function onlyofficeFileActionGetFileToken (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/${params.flag}/${params.version}/${params.token}`)
    return data.data
}

    
// 获取文件正文内容
// flag: String: 文档id
// version: Integer: 文档版本
// token: String: 文档访问token
// GET
export async function onlyofficeFileActionGetFile (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficefile/file/${params.flag}/${params.version}`)
    return data.data
}

    
// 获取文档访问token
// flag: String: 文档id
// POST
export async function onlyofficeTokenActionCreateToken (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/onlyofficetoken/createtoken/${params.flag}`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/openapi`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_onlyofficefile_assemble_control/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    