
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/cache`, params)
    return data.data
}

    
// 删除指定名称的Custom数据.
// name: String: 名称
// PUT
export async function customActionManagerUpdate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/manager/person/${params.person}/name/${params.name}`, params)
    return data.data
}

    
// 删除指定名称的Custom数据(Mock delete to get).
// name: String: 名称
// GET
export async function customActionManagerGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/manager/person/${params.person}/name/${params.name}`)
    return data.data
}

    
// 根据当前的访问用户获取Custom数据.
// name: String: 名称
// POST
export async function customActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.name}/mockputtopost`, params)
    return data.data
}

    
// 获取指定用户的Custom数据.
// person: String: 用户
// name: String: 名称
// POST
export async function customActionManagerUpdateMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/manager/person/${params.person}/name/${params.name}/mockputtopost`, params)
    return data.data
}

    
// 管理员更新指定用户指定名称的Custom数据.
// person: String: 用户
// name: String: 定义名称
// GET
export async function customActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.name}/mockdeletetoget`)
    return data.data
}

    
// 管理员更新指定用户指定名称的Custom数据(Mock put to post).
// person: String: 用户
// name: String: 定义名称
// GET
export async function customActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.name}`)
    return data.data
}

    
// 更新指定名称的Custom.
// name: String: 名称
// PUT
export async function customActionUpdate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.name}`, params)
    return data.data
}

    
// 更新指定名称的Custom数据(Mock put to post).
// name: String: 名称
// DELETE
export async function customActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/custom/${params.name}`, params)
    return data.data
}

    
// 删除指定名称的Definition.
// name: String: 名称
// POST
export async function definitionActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.name}/mockputtopost`, params)
    return data.data
}

    
// 删除指定名称的Definition MockDeleteToGet.
// name: String: 名称
// GET
export async function definitionActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.name}/mockdeletetoget`)
    return data.data
}

    
// 访问当前用户指定名称的自定义数据.
// name: String: 名称
// GET
export async function definitionActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.name}`)
    return data.data
}

    
// 更新指定名称的Definition.
// name: String: 名称
// PUT
export async function definitionActionUpdate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.name}`, params)
    return data.data
}

    
// 更新指定名称的Definition MockPutToPost.
// name: String: 名称
// DELETE
export async function definitionActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/definition/${params.name}`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/echo`)
    return data.data
}

    
// 创建授权.
// GET
export async function empowerActionEnable (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.id}/enable`)
    return data.data
}

    
// 删除授权
// id: String: 标识
// GET
export async function empowerActionDisable (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.id}/disable`)
    return data.data
}

    
// 删除授权 MockDeleteToGet
// id: String: 标识
// GET
export async function empowerActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/person/${params.flag}`)
    return data.data
}

    
// 禁用授权
// id: String: 标识
// PUT
export async function empowerActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.id}`, params)
    return data.data
}

    
// 更新授权.
// id: String: 标识
// POST
export async function empowerActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.id}/mockputtopost`, params)
    return data.data
}

    
// 更新授权(Mock put to post).
// id: String: 标识
// GET
export async function empowerActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 启用授权
// id: String: 标识
// GET
export async function empowerActionListTo (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/to`)
    return data.data
}

    
// 获取用户授权对象.
// id: String: 标识
// PUT
export async function empowerActionManagerEdit (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/${params.id}`, params)
    return data.data
}

    
// 管理员列示授权对象,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function empowerActionListToEnable (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/to/enable`)
    return data.data
}

    
// 管理员列示授权对象,上一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function empowerActionManagerCreate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager`, params)
    return data.data
}

    
// 获取当前人员的被授权.
// GET
export async function empowerActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 获取当前人员的生效的被授权.
// DELETE
export async function empowerActionManagerDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/${params.id}`, params)
    return data.data
}

    
// 获取当前人员的授权.
// POST
export async function empowerActionManagerlistPaging (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取当前人员生效的授权.
// GET
export async function empowerActionListWithCurrentPersonEnable (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/currentperson/enable`)
    return data.data
}

    
// 查询指定人员的授权.
// flag: String: 人员
// GET
export async function empowerActionListWithCurrentPerson (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/list/currentperson`)
    return data.data
}

    
// 管理员创建授权.
// POST
export async function empowerActionManagerEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/${params.id}/mockputtopost`, params)
    return data.data
}

    
// 管理员删除授权
// id: String: 标识
// GET
export async function empowerActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 管理员删除授权 MockDeleteToGet
// id: String: 标识
// GET
export async function empowerActionManagerDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/manager/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 管理员更新授权.
// id: String: 标识
// GET
export async function empowerActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.id}`)
    return data.data
}

    
// 管理员更新授权(Mock put to post).
// id: String: 标识
// DELETE
export async function empowerActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower/${params.id}`, params)
    return data.data
}

    
// 管理员根据条件查询授权记录.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function empowerActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empower`, params)
    return data.data
}

    
// 删除授权日志.
// id: String: 标识
// GET
export async function empowerLogActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 删除授权日志 MockDeleteToGet
// id: String: 标识
// GET
export async function empowerLogActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 管理员列示授权日志对象,下一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function empowerLogActionManagerlistPaging (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/manager/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 管理员列示授权日志对象,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function empowerLogActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 获取当前人员的被授权日志.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function empowerLogActionListWithCurrentPersonPaging (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/list/currentperson/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取当前人员的授权日志.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function empowerLogActionListToCurrentPersonPaging (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/list/to/currentperson/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 管理员根据条件查询授权日志.
// page: Integer: 分页
// size: Integer: 数量
// DELETE
export async function empowerLogActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/empowerlog/${params.id}`, params)
    return data.data
}

    
// 接收腾讯企业邮回调POST方法.
// GET
export async function exmailActionSso (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail/sso`)
    return data.data
}

    
// 接收腾讯企业邮回调GET方法.
// GET
export async function exmailActionListTitlePassive (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail/list/title/passive`)
    return data.data
}

    
// 列示当前用户腾讯企业邮标题,读取通过回调写入PersonAttribute的值.
// GET
export async function exmailActionNewCountPassive (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail/new/count/passive`)
    return data.data
}

    
// 获取当前用户的exmail邮件数量,即时访问腾讯企业邮获取.
// GET
export async function exmailActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail`)
    return data.data
}

    
// 获取当前用户的exmail邮件数量,读取通过回调写入PersonAttribute的值.
// GET
export async function exmailActionNewCount (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail/new/count`)
    return data.data
}

    
// 获取当前用户邮件单点登录地址.
// POST
export async function exmailActionCallback (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/exmail`, params)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 获取个人头像.
// person: String: 应用标识
// GET
export async function iconActionGetIcon (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/icon/${params.person}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/openapi`)
    return data.data
}

    
// 修改密码.
// PUT
export async function passwordActionChangePassword (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/password`, params)
    return data.data
}

    
// 修改密码 MockPutToPost.
// POST
export async function passwordActionChangePasswordMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/password/mockputtopost`, params)
    return data.data
}

    
// 更新个人的信息,不更新superior和controllerList
// PUT
export async function personActionSetPassword (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/password`, params)
    return data.data
}

    
// 更新个人的信息,不更新superior和controllerList MockPutToPost
// GET
export async function personActionGetIcon (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/icon`)
    return data.data
}

    
// 获取个人可以自己的内容
// PUT
export async function personActionSetIcon (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/icon`, params)
    return data.data
}

    
// 获取个人头像.
// PUT
export async function personActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person`, params)
    return data.data
}

    
// 设置个人的头像.
// POST
export async function personActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/mockputtopost`, params)
    return data.data
}

    
// 设置个人的头像 MockPutToPost.
// POST
export async function personActionSetIconMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/icon/mockputtopost`, params)
    return data.data
}

    
// 更新指定个人的密码.
// POST
export async function personActionUploadPostOctetStream (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/icon`, params)
    return data.data
}

    
// 更新指定个人的密码 MockPutToPost.
// POST
export async function personActionSetPasswordMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person/password/mockputtopost`, params)
    return data.data
}

    
// 设置头像.为了兼容前台增加的POST方法.
// GET
export async function personActionGet (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/person`)
    return data.data
}

    
// 生成一个captcha
// width: Integer: 图像宽度
// height: Integer: 图像高度
// GET
export async function registActionCaptcha (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/captcha/width/${params.width}/height/${params.height}`)
    return data.data
}

    
// 校验mobile是否已经存在
// mobile: String: 电话号码
// GET
export async function registActionCheckMobile (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/check/mobile/${params.mobile}`)
    return data.data
}

    
// 校验name是否已经存在
// name: String: 用户名
// GET
export async function registActionCheckPassword (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/check/password/${params.password}`)
    return data.data
}

    
// 校验password密码等级.
// password: String: 密码
// GET
export async function registActionCheckName (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/check/name/${params.name}`)
    return data.data
}

    
// 生成一个code
// mobile: String: 电话号码
// GET
export async function registActionMode (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/mode`)
    return data.data
}

    
// 注册人员
// POST
export async function registActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist`, params)
    return data.data
}

    
// 当前允许的注册模式,disable,captcha,code
// GET
export async function registActionCode (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/regist/code/mobile/${params.mobile}`)
    return data.data
}

    
// 验证人员是否存在.
// credential: String: 用户标识
// GET
export async function resetActionCheckCredential (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/check/credential/${params.credential}`)
    return data.data
}

    
// 验证密码强度等级.
// password: String: 密码
// POST
export async function resetActionResetMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/mockputtopost`, params)
    return data.data
}

    
// 获取短信验证码
// credential: String: 用户标识
// GET
export async function resetActionCheckPassword (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/check/password/${params.password}`)
    return data.data
}

    
// 重置密码.
// POST
export async function resetActionSetPasswordAnonymous (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/password/anonymous`, params)
    return data.data
}

    
// 重置密码MockPutToPost.
// PUT
export async function resetActionReset (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset`, params)
    return data.data
}

    
// 匿名更新个人的密码.
// GET
export async function resetActionCode (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/reset/code/credential/${params.credential}`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_organization_assemble_personal/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    