
// 获取指定人员的待阅数量,没有权限限制.
// credential: String: 个人标识
// GET
export async function anonymousActionTaskCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/anonymous/task/count/${params.credential}`)
    return data.data
}

    
// 获取指定人员的待办数量,没有权限限制.
// credential: String: 个人标识
// GET
export async function anonymousActionReadCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/anonymous/read/count/${params.credential}`)
    return data.data
}

    
// 获取指定的应用信息,并附带其操作权限.
// flag: String: 应用标识
// GET
export async function applicationActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/${params.flag}`)
    return data.data
}

    
// 仅获取指定Application的Icon,没有权限限制.
// flag: String: 应用标识
// GET
export async function applicationActionGetIcon (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/${params.flag}/icon`)
    return data.data
}

    
// 校验当前用户是否是指定应用的管理员.
// flag: String: 应用标识
// GET
export async function applicationActionListWithPersonLike (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list/key/${params.key}`)
    return data.data
}

    
// 获取可见的应用,同时判断应用下有启动的流程.
// GET
export async function applicationActionIsManager (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/${params.flag}/is/manager`)
    return data.data
}

    
// 根据当前用户所有可见的Application,并绑定其可启动终端的Process.
// terminal: String: 流程启动终端：client(pc端可启动)、mobile(手机端可启动)
// GET
export async function applicationActionListWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list`)
    return data.data
}

    
// 根据当前用户所有可见的Application,并绑定其启动的Process.
// GET
export async function applicationActionManageListWithPersonComplex (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list/complex/manage/${params.person}`)
    return data.data
}

    
// 获取可见的应用,同时判断应用下有启动的流程,并进行流程的名称匹配.
// key: String: 关键字
// GET
export async function applicationActionListWithPersonComplex (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list/complex`)
    return data.data
}

    
// 根据传入用户，获取可见的Application,并绑定其启动的Process.
// person: String: 用户
// GET
export async function applicationActionListWithPersonAndTerminal (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/application/list/terminal/${params.terminal}`)
    return data.data
}

    
// 指定应用根据一级路径添加数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// GET
export async function applicationDictActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}`)
    return data.data
}

    
// 指定应用根据二级路径添加数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 0级路径
// GET
export async function applicationDictActionGetData (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/data`)
    return data.data
}

    
// 指定应用根据三级路径添加数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// GET
export async function applicationDictActionGetDataPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/data`)
    return data.data
}

    
// 指定应用根据四级路径添加数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// PUT
export async function applicationDictActionUpdateDataPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/data`, params)
    return data.data
}

    
// 根据字典ID和路径添加Application下的新的局部数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// PUT
export async function applicationDictActionUpdateDataPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/data`, params)
    return data.data
}

    
// 指定应用根据六级路径添加数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// PUT
export async function applicationDictActionUpdateDataPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/data`, params)
    return data.data
}

    
// 指定应用根据七级路径添加数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// PUT
export async function applicationDictActionUpdateDataPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/data`, params)
    return data.data
}

    
// 指定应用根据八级路径添加数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// PUT
export async function applicationDictActionUpdateDataPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/data`, params)
    return data.data
}

    
// 指定应用根据一级路径删除数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// GET
export async function applicationDictActionGetDataPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/data`)
    return data.data
}

    
// 指定应用根据一级路径删除数据字典数据(mock delete to get).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// PUT
export async function applicationDictActionUpdateDataPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/data`, params)
    return data.data
}

    
// 指定应用根据一级路径删除数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// POST
export async function applicationDictActionCreateDataPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/data`, params)
    return data.data
}

    
// 指定应用根据二级路径删除数据字典数据(mock delete to get).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// GET
export async function applicationDictActionGetDataPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/data`)
    return data.data
}

    
// 指定应用根据三级路径删除数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// POST
export async function applicationDictActionCreateDataPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/data`, params)
    return data.data
}

    
// 指定应用根据三级路径删除数据字典数据(mock delete to get).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// POST
export async function applicationDictActionCreateDataPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/data`, params)
    return data.data
}

    
// 指定应用根据四级路径删除数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// PUT
export async function applicationDictActionUpdateDataPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/data`, params)
    return data.data
}

    
// 指定应用根据四级路径删除数据字典数据(mock delete to get).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// GET
export async function applicationDictActionGetDataPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/data`)
    return data.data
}

    
// 指定应用根据五级路径删除数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// GET
export async function applicationDictActionGetDataPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/data`)
    return data.data
}

    
// 指定应用根据五级路径删除数据字典数据(mock delete to get).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// GET
export async function applicationDictActionGetDataPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/data`)
    return data.data
}

    
// 指定应用根据六级路径删除数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// PUT
export async function applicationDictActionUpdateDataPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/data`, params)
    return data.data
}

    
// 指定应用根据六级路径删除数据字典数据(mock delete to get).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// GET
export async function applicationDictActionGetDataPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/data`)
    return data.data
}

    
// 指定应用根据七级路径删除数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// GET
export async function applicationDictActionGetDataPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/data`)
    return data.data
}

    
// 指定应用根据七级路径删除数据字典数据(mock delete to get).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// POST
export async function applicationDictActionCreateDataPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/data`, params)
    return data.data
}

    
// 指定应用根据八级路径删除数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// DELETE
export async function applicationDictActionDeleteDataPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/data`, params)
    return data.data
}

    
// 指定应用根据八级路径删除数据字典数据(mock delete to get).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// DELETE
export async function applicationDictActionDeleteDataPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/data`, params)
    return data.data
}

    
// 获取单个数据字典以及数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// DELETE
export async function applicationDictActionDeleteDataPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/data`, params)
    return data.data
}

    
// 指定应用获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// DELETE
export async function applicationDictActionDeleteDataPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/data`, params)
    return data.data
}

    
// 指定应用根据一级路径获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// DELETE
export async function applicationDictActionDeleteDataPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/data`, params)
    return data.data
}

    
// 指定应用根据二级路径获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// DELETE
export async function applicationDictActionDeleteDataPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/data`, params)
    return data.data
}

    
// 指定应用根据三级路径获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// DELETE
export async function applicationDictActionDeleteDataPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/data`, params)
    return data.data
}

    
// 指定应用根据四级路径获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// POST
export async function applicationDictActionCreateDataPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/data`, params)
    return data.data
}

    
// 指定应用根据五级路径获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// DELETE
export async function applicationDictActionDeleteDataPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/data`, params)
    return data.data
}

    
// 指定应用根据六级路径获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// POST
export async function applicationDictActionCreateDataPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/data`, params)
    return data.data
}

    
// 指定应用根据七级路径获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// POST
export async function applicationDictActionCreateDataPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/data`, params)
    return data.data
}

    
// 指定应用根据八级路径获取数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// POST
export async function applicationDictActionCreateDataPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/data`, params)
    return data.data
}

    
// 获取指定应用的数据字典列表.
// applicationFlag: String: 应用标识
// GET
export async function applicationDictActionDeleteDataPath5MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/data/mockdeletetoget`)
    return data.data
}

    
// 指定应用根据一级路径更新数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// GET
export async function applicationDictActionDeleteDataPath2MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/data/mockdeletetoget`)
    return data.data
}

    
// 指定应用根据一级路径更新数据字典数据(mock put to post).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// POST
export async function applicationDictActionUpdateDataPath0MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据二级路径更新数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// GET
export async function applicationDictActionDeleteDataPath0MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/data/mockdeletetoget`)
    return data.data
}

    
// 指定应用根据二级路径更新数据字典数据(mock put to post).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// GET
export async function applicationDictActionDeleteDataPath6MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/data/mockdeletetoget`)
    return data.data
}

    
// 指定应用根据三级路径更新数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// POST
export async function applicationDictActionUpdateDataPath1MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据三级路径更新数据字典数据(mock put to post).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// DELETE
export async function applicationDictActionDeleteDataPath3MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/data/mockdeletetoget`, params)
    return data.data
}

    
// 指定应用根据四级路径更新数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// POST
export async function applicationDictActionUpdateDataPath2MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据四级路径更新数据字典数据(mock put to post).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// GET
export async function applicationDictActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/list/application/${params.applicationFlag}`)
    return data.data
}

    
// 指定应用根据五级路径更新数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// POST
export async function applicationDictActionUpdateDataPath4MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据五级路径更新数据字典数据(mock put to post).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// GET
export async function applicationDictActionDeleteDataPath4MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/data/mockdeletetoget`)
    return data.data
}

    
// 指定应用根据六级路径更新数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// POST
export async function applicationDictActionUpdateDataPath3MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据六级路径更新数据字典数据(mock put to post).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// POST
export async function applicationDictActionUpdateDataPath5MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据七级路径更新数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// POST
export async function applicationDictActionUpdateDataPath7MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据七级路径更新数据字典数据(mock put to post).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// GET
export async function applicationDictActionDeleteDataPath7MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/data/mockdeletetoget`)
    return data.data
}

    
// 指定应用根据八级路径更新数据字典数据.
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// POST
export async function applicationDictActionUpdateDataPath6MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据八级路径更新数据字典数据(mock put to post).
// applicationDictFlag: String: 数据字典标识
// applicationFlag: String: 应用标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// GET
export async function applicationDictActionDeleteDataPath1MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/applicationdict/${params.applicationDictFlag}/application/${params.applicationFlag}/${params.path0}/${params.path1}/data/mockdeletetoget`)
    return data.data
}

    
// 判断文件是否存在.
// id: String: 附件标识
// PUT
export async function attachmentActionUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/${params.id}/work/${params.workId}`, params)
    return data.data
}

    
// 根据工作标识或已完成工作标识批量下载附件并压缩.
// workId: String: *Work或WorkCompleted的工作标识
// site: String: *附件框分类,多值~隔开,(0)表示全部
// DELETE
export async function attachmentActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}`, params)
    return data.data
}

    
// 根据工作标识或已完成工作标识批量下载附件并压缩,设定使用stream输出.
// workId: String: *Work或WorkCompleted的工作标识
// site: String: *附件框分类,多值~隔开,(0)表示全部
// GET
export async function attachmentActionAvailable (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/available`)
    return data.data
}

    
// 更新指定附件标识的附件排序号.
// id: String: 附件标识
// workId: String: 工作标识
// orderNumber: Integer: 排序号
// GET
export async function attachmentActionGetText (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/work/${params.workId}/text`)
    return data.data
}

    
// 更新指定附件标识的附件位置信息.
// id: String: 附件标识
// workId: String: 工作标识
// site: String: 位置
// POST
export async function attachmentActionUpload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/work/${params.workId}`, params)
    return data.data
}

    
// 由工作标识指定的工作拷贝附件.
// workId: String: 工作标识
// GET
export async function attachmentActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}`)
    return data.data
}

    
// 由已完成工作标识指定的工作拷贝附件.
// workCompletedId: String: 已完成工作标识
// GET
export async function attachmentActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/list/work/${params.workId}`)
    return data.data
}

    
// 由已完成工作标识指定的工作软拷贝附件(不拷贝真实存储附件，共用附件，此接口拷贝的附件删除时只删除记录不删附件).
// workCompletedId: String: 已完成工作标识
// POST
export async function attachmentActionEditMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/edit/${params.id}/work/${params.workId}/mockputtopost`, params)
    return data.data
}

    
// 由工作标识指定的工作软拷贝附件(不拷贝真实存储附件，共用附件，此接口拷贝的附件删除时只删除记录不删附件).
// workId: String: 工作标识
// PUT
export async function attachmentActionEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/edit/${params.id}/work/${params.workId}`, params)
    return data.data
}

    
// 删除指定标识的附件.
// id: String: 附件标识
// GET
export async function attachmentActionChangeSite (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/work/${params.workId}/change/site/${params.site}`)
    return data.data
}

    
// 删除指定标识的附件(mock delete to get).
// id: String: 附件标识
// GET
export async function attachmentActionPreviewImageResult (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/preview/image/${params.flag}/result`)
    return data.data
}

    
// 根据工作标识和附件标识删除附件.
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionCopyToWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/copy/work/${params.workId}`, params)
    return data.data
}

    
// 根据已完成工作标识和附件标识删除附件. 
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识
// PUT
export async function attachmentActionUploadWorkInfo (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/work/${params.workId}/save/as/${params.flag}`, params)
    return data.data
}

    
// 根据已完成工作标识和附件标识删除附件(mock delete to get).
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识
// GET
export async function attachmentActionDownloadWorkInfo (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/work/${params.workId}/att/${params.flag}`)
    return data.data
}

    
// 根据工作标识和附件标识删除附件(mock delete to get).
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionManageBatchUpload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/upload/manage`, params)
    return data.data
}

    
// 获取指定工作标识的工作,将html版式公文转换成成Word文件并添加在附件中.
// workId: String: 工作标识
// DELETE
export async function attachmentActionDeleteWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/work/${params.workId}`, params)
    return data.data
}

    
// 获取指定工作标识或已完成工作标识,将html版式公文转换成成Word文件并添加在附件中.
// workOrWorkCompleted: String: 工作已完成工作标识
// GET
export async function attachmentActionDownloadWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/work/${params.workId}`)
    return data.data
}

    
// 下载指定标识的附件.
// id: String: 附件标识
// POST
export async function attachmentActionDownloadBaseList (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/downloadBaseList`, params)
    return data.data
}

    
// 下载指定标识的图片，以 base64 编码输出.
// id: String: 附件标识
// GET
export async function attachmentActionDownloadBase (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/downloadBase/${params.id}`)
    return data.data
}

    
// 下载指定标识的图片，以 base64 编码输出.
// PUT
export async function attachmentActionUpdateContent (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/content/${params.id}/work/${params.workId}`, params)
    return data.data
}

    
// 下载指定标识的附件,设定使用流输出.
// id: String: 附件标识
// POST
export async function attachmentActionCopyToWorkSoft (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/copy/work/${params.workId}/soft`, params)
    return data.data
}

    
// html转pdf工具类,下载转换后的附件.
// flag: String: *转换后附件id
// GET
export async function attachmentActionChangeOrderNumber (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/work/${params.workId}/change/ordernumber/${params.orderNumber}`)
    return data.data
}

    
// 根据工作标识和附件标识下载附件.
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionDocToWord (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/doc/to/word/work/${params.workId}`, params)
    return data.data
}

    
// 根据已完成工作标识和附件标识下载附件.
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识
// PUT
export async function attachmentActionExitText (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/edit/${params.id}/work/${params.workId}/text`, params)
    return data.data
}

    
// 根据已完成工作标识和附件标识下载附件,设定使用流输出.
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识
// GET
export async function attachmentActionPreviewPdf (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/preview/pdf`)
    return data.data
}

    
// 根据已完成工作标识和附件标识以指定的名称下载附件,设定使用流输出.
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识
// GET
export async function attachmentActionPreviewPdfResult (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/preview/pdf/${params.flag}/result`)
    return data.data
}

    
// 根据已完成工作标识和附件标识以指定的名称下载附件.
// id: String: 附件标识
// workCompletedId: String: 已完成工作标识
// GET
export async function attachmentActionPreviewImage (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/preview/image/page/${params.page}`)
    return data.data
}

    
// 根据工作标识和附件标识以指定的名称下载附件,设定使用流输出.
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionUpdatePost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/${params.id}/work/${params.workId}`, params)
    return data.data
}

    
// 根据工作标识和附件标识以指定的名称下载附件,设定使用流输出.
// id: String: 附件标识
// workId: String: 工作标识
// GET
export async function attachmentActionDownloadStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/stream`)
    return data.data
}

    
// 根据工作标识和附件标识以指定的名称下载附件.
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionUploadCallback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/work/${params.workId}/callback/${params.callback}`, params)
    return data.data
}

    
// 下载工单的表单,审批记录等html信息.
// workId: String: *Work或WorkCompleted的工作标识
// flag: String: *通过uploadWorkInfo上传返回的附件id
// POST
export async function attachmentActionUpdateCallback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/${params.id}/work/${params.workId}/callback/${params.callback}`, params)
    return data.data
}

    
// 更新指定附件标识的附件信息.
// id: String: 附件标识
// workId: String: 工作标识
// GET
export async function attachmentActionGetWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/work/${params.workId}`)
    return data.data
}

    
// M更新指定附件标识的附件信息(mock put to post).
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionManageBatchDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/delete/manage`, params)
    return data.data
}

    
// 更新指定附件标识的附件的文本识别内容.
// id: String: 附件标识
// workId: String: 工作标识
// GET
export async function attachmentActionManageDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/manage`)
    return data.data
}

    
// 更新指定附件标识的附件的文本识别内容(mock put to post).
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionHtmlToPdf (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/html/to/pdf`, params)
    return data.data
}

    
// 获取指定附件的在线编辑信息.
// id: String: 附件标识
// POST
export async function attachmentActionManageBatchUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/update/manage`, params)
    return data.data
}

    
// 获取指定附件标识的附件的文本识别内容.
// id: String: 附件标识
// workId: String: 工作标识
// GET
export async function attachmentActionDownloadTransfer (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/transfer/flag/${params.flag}`)
    return data.data
}

    
// 根据工作标识和附件标识获取附件信息.
// workId: String: 工作标识
// id: String: 附件标识
// POST
export async function attachmentActionUploadWithUrl (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/with/url`, params)
    return data.data
}

    
// 根据WorkCompleted和附件Id获取单个附件信息
// workCompletedId: String: 已完成工作标识
// id: String: 附件标识
// POST
export async function attachmentActionHtmlToImage (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/html/to/image`, params)
    return data.data
}

    
// 根据工作标识或者已完成工作标识和附件标识获取附件信息.
// workOrWorkCompleted: String: 工作或已完成工作标识
// id: String: 附件标识
// GET
export async function attachmentActionGetOnlineInfo (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/online/info`)
    return data.data
}

    
// html转图片工具类，通过微软playwright工具以截图方式生成图片，转换后如果工作不为空通过downloadWithWork接口下载，为空downloadTransfer接口下载.
// GET
export async function attachmentActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/list/job/${params.job}`)
    return data.data
}

    
// html转pdf工具类,转换后通过downloadTransfer接口下载.
// GET
export async function attachmentActionDownloadWithWorkCompletedStreamWithExtension (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/workcompleted/${params.workCompletedId}/stream/${params.fileName}.${params.extension}`)
    return data.data
}

    
// 根据任务标识获取附件列表.
// job: String: 工作的job
// GET
export async function attachmentActionDownloadWithWorkCompletedWithExtension (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/workcompleted/${params.workCompletedId}/${params.fileName}.${params.extension}`)
    return data.data
}

    
// 根据工作标识列示附件.
// workId: String: 工作标识
// GET
export async function attachmentActionDownloadWithWorkStreamWithExtension (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/work/${params.workId}/stream/${params.fileName}.${params.extension}`)
    return data.data
}

    
// 根据已完成工作标识列示附件.
// workCompletedId: String: 已完成工作标识
// GET
export async function attachmentActionDeleteWithWorkCompletedMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/workcompleted/${params.workCompletedId}/mockdeletetoget`)
    return data.data
}

    
// 根据工作或已完成工作标识获取附件列表.
// workOrWorkCompleted: String: 工作或已完成工作标识
// GET
export async function attachmentActionBatchDownloadWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/download/work/${params.workId}/site/${params.site}`)
    return data.data
}

    
// 管理员批量删除附件.
// GET
export async function attachmentActionBatchDownloadWithWorkOrWorkCompletedStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/batch/download/work/${params.workId}/site/${params.site}/stream`)
    return data.data
}

    
// 管理员批量替换附件.
// GET
export async function attachmentActionListWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/list/workcompleted/${params.workCompletedId}`)
    return data.data
}

    
// 管理员批量上传附件.
// GET
export async function attachmentActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/list/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 指定附件标识,管理员下载附件.
// id: String: 附件标识
// GET
export async function attachmentActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 指定附件标识,管理员下载附件,设定使用stream输出.
// id: String: 附件标识
// GET
export async function attachmentActionGetWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/workcompleted/${params.workCompletedId}`)
    return data.data
}

    
// 获取指定附件标识返回图片格式预览文件信息,支持doc,docx.
// id: String: 附件标识
// page: Integer: 页数
// GET
export async function attachmentActionGetWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 获取指定附件标识返回图片格式预览文件,支持doc,docx.
// flag: String: 标识
// GET
export async function attachmentActionDownloadWithWorkWithExtension (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/work/${params.workId}/${params.fileName}.${params.extension}`)
    return data.data
}

    
// 获取指定附件标识返回pdf格式预览文件信息,支持doc,docx.
// id: String: 附件标识
// GET
export async function attachmentActionDownloadWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/workcompleted/${params.workCompletedId}`)
    return data.data
}

    
// 获取指定附件标识返回pdf格式预览文件,支持doc,docx.
// flag: String: 标识
// GET
export async function attachmentActionDownloadWithWorkCompletedStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/workcompleted/${params.workCompletedId}/stream`)
    return data.data
}

    
// 根据工作标识更新附件内容.
// id: String: 附件标识
// workId: String: 工作标识
// GET
export async function attachmentActionDownloadWithWorkStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/work/${params.workId}/stream`)
    return data.data
}

    
// 根据附件标识和工作标识更新附件,回调jsonp.
// id: String: 附件标识
// workId: String: 工作标识
// callback: String: 回调函数名
// GET
export async function attachmentActionDeleteWithWorkMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/work/${params.workId}/mockdeletetoget`)
    return data.data
}

    
// 根据附件标识和工作标识更新附件信息.
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionCopyToWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/copy/workcompleted/${params.workCompletedId}`, params)
    return data.data
}

    
// 根据附件标识和工作标识更新附件信息(mock put to post).
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionCopyToWorkCompletedSoft (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/copy/workcompleted/${params.workCompletedId}/soft`, params)
    return data.data
}

    
// 根据工作标识更新附件内容(mock put to post).
// id: String: 附件标识
// workId: String: 工作标识
// POST
export async function attachmentActionUploadWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/workcompleted/${params.workCompletedId}`, params)
    return data.data
}

    
// 根据附件标识和工作标识更新附件,与update方法同,为了兼容ntko对于附件上传只能设置post方法.
// id: String: 附件标识
// workId: String: 工作标识
// DELETE
export async function attachmentActionDeleteWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/${params.id}/workcompleted/${params.workCompletedId}`, params)
    return data.data
}

    
// 上传附件.
// workId: String: 工作标识
// POST
export async function attachmentActionUpdateContentMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/content/${params.id}/work/${params.workId}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识上传附件,回调jsonp.
// workId: String: 工作标识
// callback: String: 回调函数名
// POST
export async function attachmentActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/update/${params.id}/work/${params.workId}/mockputtopost`, params)
    return data.data
}

    
// 上传附件
// POST
export async function attachmentActionDocToWordWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/doc/to/word/workorworkcompleted/${params.workOrWorkCompleted}`, params)
    return data.data
}

    
// 上传附件.
// workCompletedId: String: 已完成工作标识
// GET
export async function attachmentActionManageDownloadStream (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/download/${params.id}/manage/stream`)
    return data.data
}

    
// 上传工单的表单、审批记录等html信息到缓存.
// workId: String: Work或WorkCompleted的工作标识
// flag: String: 另存为格式：(0)表示不转换|pdf表示转为pdf|word表示转为word
// POST
export async function attachmentActionExitTextMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/edit/${params.id}/work/${params.workId}/text/mockputtopost`, params)
    return data.data
}

    
// 上传工单的表单,审批记录等html信息到打包下载附件(mock put to post).
// workId: String: Work或WorkCompleted的工作标识
// flag: String: 另存为格式：(0)表示不转换|pdf表示转为pdf|word表示转为word
// POST
export async function attachmentActionUploadWorkInfoMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/upload/work/${params.workId}/save/as/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// V2根据工作标识或已完成工作标识上传附件,如果同名附件存在则替换.
// workOrWorkCompleted: String: 工作或已完成工作标识
// POST
export async function attachmentActionV2UploadWorkOrWorkCompletedBase64 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/v2/upload/workorworkcompleted/${params.workOrWorkCompleted}/base64`, params)
    return data.data
}

    
// V2根据工作标识或已完成工作标识上传附件,上传文件内容经过base64编码后的文本,如果同名附件存在则替换.
// workOrWorkCompleted: String: 工作或已完成工作标识
// POST
export async function attachmentActionV2UploadWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/attachment/v2/upload/workorworkcompleted/${params.workOrWorkCompleted}`, params)
    return data.data
}

    
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/cache`, params)
    return data.data
}

    
// 根据工作标识或完成工作标识获取权限.
// workOrWorkCompleted: String: 工作或已完成工作标识
// GET
export async function controlActionGetWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/control/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 根据任务标识创建关联内容.
// job: String: 任务标识
// POST
export async function correlationActionCreateWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/correlation/job/${params.job}`, params)
    return data.data
}

    
// 删除关联内容.
// job: String: 任务标识
// POST
export async function correlationActionDeleteWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/correlation/job/${params.job}/delete`, params)
    return data.data
}

    
// 根据任务标识列示关联内容.
// job: String: 任务标识
// GET
export async function correlationActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/correlation/list/job/${params.job}`)
    return data.data
}

    
// 根据任务标识关联内容框标识列示关联内容.
// job: String: 任务标识
// site: String: 关联内容框标识
// GET
export async function correlationActionListWithJobWithSite (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/correlation/list/job/${params.job}/site/${params.site}`)
    return data.data
}

    
// 根据工作标识更新业务数据.
// id: String: 工作标识
// DELETE
export async function dataActionDeleteWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}`, params)
    return data.data
}

    
// 对指定的work添加局部data数据.
// id: String: 工作标识
// path0: String: 0级路径
// GET
export async function dataActionGetWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}`)
    return data.data
}

    
// 对指定的work添加局部data数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// PUT
export async function dataActionUpdateWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}`, params)
    return data.data
}

    
// 对指定的work添加局部data数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// GET
export async function dataActionGetWithWorkPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}`)
    return data.data
}

    
// 对指定的work添加局部data数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// GET
export async function dataActionGetWithJobPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}`)
    return data.data
}

    
// 对指定的work添加局部data数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// GET
export async function dataActionGetWithJobPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}`)
    return data.data
}

    
// 对指定的work添加局部data数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// GET
export async function dataActionGetWithWorkPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}`)
    return data.data
}

    
// 对指定的work添加局部data数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// GET
export async function dataActionGetWithWorkPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}`)
    return data.data
}

    
// 对指定的work添加局部data数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// GET
export async function dataActionGetWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}`)
    return data.data
}

    
// 根据工作标识删除业务数据.
// id: String: 工作标识
// GET
export async function dataActionGetWithJobPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}`)
    return data.data
}

    
// 根据工作标识删除业务数据(mock delete to get).
// id: String: 工作标识
// GET
export async function dataActionGetWithJobPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}`)
    return data.data
}

    
// 根据工作标识和一级路径删除业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// GET
export async function dataActionGetWithJobPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}`)
    return data.data
}

    
// 根据工作标识和一级路径删除业务数据(mock delete to get).
// id: String: 工作标识
// path0: String: 0级路径
// GET
export async function dataActionGetWithWorkPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}`)
    return data.data
}

    
// 根据工作标识和二级路径删除业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// GET
export async function dataActionGetWithWorkPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}`)
    return data.data
}

    
// 根据工作标识和二级路径删除业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// PUT
export async function dataActionUpdateWithJobPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}`, params)
    return data.data
}

    
// 根据工作标识和三级路径删除业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// POST
export async function dataActionFetchWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/fetch/job/${params.job}`, params)
    return data.data
}

    
// 根据工作标识和三级路径删除业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// GET
export async function dataActionGetWithWorkPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}`)
    return data.data
}

    
// 根据工作标识和四级路径删除业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// POST
export async function dataActionCreateWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}`, params)
    return data.data
}

    
// 根据工作标识和四级路径删除业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// PUT
export async function dataActionUpdateWithJobPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}`, params)
    return data.data
}

    
// 根据工作标识和五级路径删除业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// PUT
export async function dataActionUpdateWithJobPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}`, params)
    return data.data
}

    
// 根据工作标识和五级路径删除业务数据(mock delete to get).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// GET
export async function dataActionGetWithJobPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}`)
    return data.data
}

    
// 根据工作标识和六级路径删除业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// GET
export async function dataActionGetWithJobPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}`)
    return data.data
}

    
// 根据工作标识和六级路径删除业务数据(mock delete to get).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// PUT
export async function dataActionUpdateWithJobPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}`, params)
    return data.data
}

    
// 根据工作标识和七级路径删除业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// GET
export async function dataActionGetWithWorkPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}`)
    return data.data
}

    
// 根据工作标识和七级路径删除业务数据(mock delete to get).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// PUT
export async function dataActionUpdateWithJobPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}`, params)
    return data.data
}

    
// 根据工作标识和八级路径删除业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// PUT
export async function dataActionUpdateWithJobPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}`, params)
    return data.data
}

    
// 根据工作标识和八级路径删除业务数据(mock delete to get).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// PUT
export async function dataActionUpdateWithJobPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}`, params)
    return data.data
}

    
// 根据任务标识获取指定路径的部分业务数据.
// job: String: job标识
// GET
export async function dataActionGetWithWorkPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}`)
    return data.data
}

    
// 根据任务标识获取业务数据.
// job: String: job标识
// GET
export async function dataActionGetWithJobPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}`)
    return data.data
}

    
// 根据任务标识和一级路径获取业务数据.
// job: String: 标识
// path0: String: 0级路径
// PUT
export async function dataActionUpdateWithJobPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}`, params)
    return data.data
}

    
// 根据任务标识和二级路径获取业务数据.
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// PUT
export async function dataActionUpdateWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}`, params)
    return data.data
}

    
// 根据任务标识和三级路径获取业务数据.
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// GET
export async function dataActionDeleteWithWorkPath5MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/mockdeletetoget`)
    return data.data
}

    
// 根据任务标识和四级路径获取业务数据.
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// DELETE
export async function dataActionDeleteWithWorkPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}`, params)
    return data.data
}

    
// 根据任务标识和五级路径获取业务数据.
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// GET
export async function dataActionDeleteWithWorkPath6MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/mockdeletetoget`)
    return data.data
}

    
// 根据任务标识和六级路径获取业务数据.
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// DELETE
export async function dataActionDeleteWithWorkPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}`, params)
    return data.data
}

    
// 根据任务标识和七级路径获取业务数据.
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// GET
export async function dataActionDeleteWithWorkPath7MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/mockdeletetoget`)
    return data.data
}

    
// 根据任务标识和八级路径获取业务数据.
// job: String: 标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// GET
export async function dataActionGetWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}`)
    return data.data
}

    
// 根据工作标识获取业务数据.
// id: String: 工作标识
// GET
export async function dataActionDeleteWithWorkMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 根据已完成工作标识获取业务数据.
// id: String: 已完成工作标识
// POST
export async function dataActionUpdateWithWorkCompletedPath3MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/mockputtopost`, params)
    return data.data
}

    
// 从data中获取workCompleted的data数据.
// id: String: 已完成工作标识
// POST
export async function dataActionUpdateWithWorkCompletedPath6MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/mockputtopost`, params)
    return data.data
}

    
// 从item中获取已完成工作的业务数据.
// id: String: 已完成工作标识
// POST
export async function dataActionUpdateWithWorkCompletedPath0MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/mockputtopost`, params)
    return data.data
}

    
// 根据已完成工作标识和一级路径获取业务数据.
// id: String: 已完成工作标识
// path0: String: 0级路径
// POST
export async function dataActionUpdateWithWorkCompletedMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/mockputtopost`, params)
    return data.data
}

    
// 根据已完成工作标识和二级路径获取业务数据.
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// POST
export async function dataActionUpdateWithWorkCompletedPath5MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/mockputtopost`, params)
    return data.data
}

    
// 根据已完成工作标识和三级路径获取业务数据.
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// POST
export async function dataActionUpdateWithWorkCompletedPath2MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/mockputtopost`, params)
    return data.data
}

    
// 根据已完成工作标识和四级路径获取业务数据.
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// POST
export async function dataActionUpdateWithWorkCompletedPath1MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/mockputtopost`, params)
    return data.data
}

    
// 根据已完成工作标识和五级路径获取业务数据.
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// POST
export async function dataActionUpdateWithWorkCompletedPath7MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/mockputtopost`, params)
    return data.data
}

    
// 根据路径获取指定workCompleted的data数据.
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// POST
export async function dataActionUpdateWithWorkCompletedPath4MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/mockputtopost`, params)
    return data.data
}

    
// 根据路径获取指定workCompleted的data数据.
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// PUT
export async function dataActionUpdateWithWorkCompletedPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}`, params)
    return data.data
}

    
// 根据路径获取指定workCompleted的data数据.
// id: String: 已完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// POST
export async function dataActionCreateWithWorkPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}`, params)
    return data.data
}

    
// 根据工作标识和一级路径获取业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// PUT
export async function dataActionUpdateWithWorkCompletedPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}`, params)
    return data.data
}

    
// 根据工作标识和二级路径获取业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// POST
export async function dataActionUpdateWithWorkPath2MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/mockputtopost`, params)
    return data.data
}

    
// 根据路径获取指定work的data数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// POST
export async function dataActionCreateWithWorkPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}`, params)
    return data.data
}

    
// 根据工作标识和四级路径获取业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// PUT
export async function dataActionUpdateWithWorkPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}`, params)
    return data.data
}

    
// 根据工作标识和五级路径获取业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// PUT
export async function dataActionUpdateWithWorkCompletedPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}`, params)
    return data.data
}

    
// 根据工作标识和六级路径获取业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// DELETE
export async function dataActionDeleteWithWorkPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}`, params)
    return data.data
}

    
// 根据工作标识和七级路径获取业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// POST
export async function dataActionUpdateWithWorkPath6MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和八级路径获取业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// GET
export async function dataActionDeleteWithWorkPath3MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/mockdeletetoget`)
    return data.data
}

    
// 根据任务标识更新业务数据.
// job: String: job标识
// DELETE
export async function dataActionDeleteWithWorkPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}`, params)
    return data.data
}

    
// 根据任务标识更新业务数据(mock put to post).
// job: String: job标识
// DELETE
export async function dataActionDeleteWithWorkPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}`, params)
    return data.data
}

    
// 根据任务标识和一级路径更新业务数据.
// job: String: job标识
// path0: String: 0级路径
// GET
export async function dataActionDeleteWithWorkPath1MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/mockdeletetoget`)
    return data.data
}

    
// 根据任务标识和一级路径更新业务数据(mock put to post).
// job: String: job标识
// path0: String: 0级路径
// PUT
export async function dataActionUpdateWithWorkPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}`, params)
    return data.data
}

    
// 根据任务标识和二级路径更新业务数据.
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// PUT
export async function dataActionUpdateWithWorkPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}`, params)
    return data.data
}

    
// 根据任务标识和二级路径更新业务数据(mock put to post).
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// PUT
export async function dataActionUpdateWithWorkPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}`, params)
    return data.data
}

    
// 根据任务标识和三级路径更新业务数据.
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// POST
export async function dataActionUpdateWithWorkPath3MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/mockputtopost`, params)
    return data.data
}

    
// 根据任务标识和三级路径更新业务数据(mock put to post).
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// POST
export async function dataActionUpdateWithWorkPath7MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/mockputtopost`, params)
    return data.data
}

    
// 根据任务标识和四级路径更新业务数据.
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// PUT
export async function dataActionUpdateWithWorkCompletedPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}`, params)
    return data.data
}

    
// 根据任务标识和四级路径更新业务数据(mock put to post).
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// POST
export async function dataActionCreateWithWorkPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}`, params)
    return data.data
}

    
// 根据任务标识和五级路径更新业务数据.
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// POST
export async function dataActionCreateWithWorkPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}`, params)
    return data.data
}

    
// 根据任务标识和五级路径更新业务数据(mock put to post).
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// PUT
export async function dataActionUpdateWithWorkPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}`, params)
    return data.data
}

    
// 根据任务标识和六级路径更新业务数据.
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// GET
export async function dataActionDeleteWithWorkPath4MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/mockdeletetoget`)
    return data.data
}

    
// 根据任务标识和六级路径更新业务数据(mock put to post).
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// DELETE
export async function dataActionDeleteWithWorkPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}`, params)
    return data.data
}

    
// 根据任务标识和七级路径更新业务数据.
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// DELETE
export async function dataActionDeleteWithWorkPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}`, params)
    return data.data
}

    
// 根据任务标识和七级路径更新业务数据(mock put to post).
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// PUT
export async function dataActionUpdateWithWorkCompletedPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}`, params)
    return data.data
}

    
// 根据任务标识和八级路径更新业务数据.
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// POST
export async function dataActionCreateWithWorkPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}`, params)
    return data.data
}

    
// 根据任务标识和八级路径更新业务数据(mock put to post).
// job: String: job标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// POST
export async function dataActionUpdateWithWorkPath4MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识更新业务数据.
// id: String: 工作标识
// POST
export async function dataActionCreateWithWorkPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}`, params)
    return data.data
}

    
// 根据已完成工作标识更新业务数据.
// id: String: 完成工作标识
// DELETE
export async function dataActionDeleteWithWorkPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}`, params)
    return data.data
}

    
// 根据已完成工作标识更新业务数据(mock put to post).
// id: String: 完成工作标识
// POST
export async function dataActionUpdateWithWorkPath5MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/mockputtopost`, params)
    return data.data
}

    
// 根据已完成工作标识和一级路径更新业务数据.
// id: String: 完成工作标识
// path0: String: 0级路径
// PUT
export async function dataActionUpdateWithWorkCompletedPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}`, params)
    return data.data
}

    
// 根据已完成工作标识和一级路径更新业务数据(mock put to post).
// id: String: 完成工作标识
// path0: String: 0级路径
// PUT
export async function dataActionUpdateWithWorkCompletedPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}`, params)
    return data.data
}

    
// 根据已完成工作标识和二级路径更新业务数据.
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// POST
export async function dataActionCreateWithWorkPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}`, params)
    return data.data
}

    
// 根据已完成工作标识和二级路径更新业务数据(mock put to post).
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// PUT
export async function dataActionUpdateWithWorkPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}`, params)
    return data.data
}

    
// 根据已完成工作标识和三级路径更新业务数据.
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// GET
export async function dataActionDeleteWithWorkPath0MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/mockdeletetoget`)
    return data.data
}

    
// 根据已完成工作标识和三级路径更新业务数据(mock put to post).
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// GET
export async function dataActionDeleteWithWorkPath2MockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/${params.path2}/mockdeletetoget`)
    return data.data
}

    
// 根据已完成工作标识和四级路径更新业务数据.
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// POST
export async function dataActionCreateWithWorkPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}`, params)
    return data.data
}

    
// 根据已完成工作标识和四级路径更新业务数据(mock put to post).
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// PUT
export async function dataActionUpdateWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}`, params)
    return data.data
}

    
// 根据已完成工作标识和五级路径更新业务数据.
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// PUT
export async function dataActionUpdateWithWorkCompletedPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}`, params)
    return data.data
}

    
// 根据已完成工作标识和五级路径更新业务数据(mock put to post).
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// GET
export async function dataActionGetWithWorkCompletedFromData (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/from/data`)
    return data.data
}

    
// 根据已完成工作标识和六级路径更新业务数据.
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// GET
export async function dataActionGetWithWorkCompletedFromItem (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/from/item`)
    return data.data
}

    
// 根据已完成工作标识和六级路径更新业务数据mock put to post).
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// POST
export async function dataActionUpdateWithJobPath4MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/mockputtopost`, params)
    return data.data
}

    
// 根据已完成工作标识和七级路径更新业务数据.
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// GET
export async function dataActionGetWithWorkCompletedPath6 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}`)
    return data.data
}

    
// 根据已完成工作标识和七级路径更新业务数据(mock put to post).
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// PUT
export async function dataActionUpdateWithWorkPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}`, params)
    return data.data
}

    
// 根据已完成工作标识和八级路径更新业务数据.
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// POST
export async function dataActionUpdateWithJobPath0MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/mockputtopost`, params)
    return data.data
}

    
// 根据已完成工作标识和八级路径更新业务数据(mock put to post).
// id: String: 完成工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// GET
export async function dataActionGetWithWorkCompletedPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}`)
    return data.data
}

    
// 根据工作标识更新业务数据(mock put to post).
// id: String: 工作标识
// POST
export async function dataActionUpdateWithJobPath1MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和一级路径更新业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// POST
export async function dataActionUpdateWithJobPath5MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和一级路径更新业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// GET
export async function dataActionGetWithWorkCompletedPath0 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}`)
    return data.data
}

    
// 根据工作标识和二级路径更新业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// GET
export async function dataActionGetWithWorkCompletedPath2 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}`)
    return data.data
}

    
// 根据工作标识和二级路径更新业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// GET
export async function dataActionGetWithWorkCompletedPath5 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}`)
    return data.data
}

    
// 根据工作标识和三级路径更新业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// GET
export async function dataActionGetWithWorkCompletedPath4 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}`)
    return data.data
}

    
// 根据工作标识和三级路径更新业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// GET
export async function dataActionGetWithWorkCompletedPath7 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}`)
    return data.data
}

    
// 根据工作标识和四级路径更新业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// POST
export async function dataActionUpdateWithJobMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和四级路径更新业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// POST
export async function dataActionUpdateWithJobPath7MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/${params.path7}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和五级路径更新业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// POST
export async function dataActionUpdateWithJobPath6MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/${params.path4}/${params.path5}/${params.path6}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和五级路径更新业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// POST
export async function dataActionUpdateWithJobPath2MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和六级路径更新业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// POST
export async function dataActionUpdateWithJobPath3MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/job/${params.job}/${params.path0}/${params.path1}/${params.path2}/${params.path3}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和六级路径更新业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// POST
export async function dataActionUpdateWithWorkMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和七级路径更新业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// POST
export async function dataActionUpdateWithWorkPath0MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/mockputtopost`, params)
    return data.data
}

    
// 根据工作标识和七级路径更新业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// GET
export async function dataActionGetWithWorkCompletedPath3 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/workcompleted/${params.id}/${params.path0}/${params.path1}/${params.path2}/${params.path3}`)
    return data.data
}

    
// 根据工作标识和八级路径更新业务数据.
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// PUT
export async function dataActionUpdateWithWorkPath1 (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}`, params)
    return data.data
}

    
// 根据工作标识和八级路径更新业务数据(mock put to post).
// id: String: 工作标识
// path0: String: 0级路径
// path1: String: 1级路径
// path2: String: 2级路径
// path3: String: 3级路径
// path4: String: 4级路径
// path5: String: 5级路径
// path6: String: 6级路径
// path7: String: 7级路径
// PUT
export async function dataActionUpdateWithWorkPath1MockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/data/work/${params.id}/${params.path0}/${params.path1}/mockputtopost`, params)
    return data.data
}

    
// 根据任务标识和业务字段获取数据变更记录.
// job: String: 工作的job
// path: String: 字段path
// GET
export async function dataRecordActionGetWithJobPath (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/datarecord/get/job/${params.job}/path/${params.path}`)
    return data.data
}

    
// 根据任务标识获取业务数据变更记录.
// job: String: 工作的job
// GET
export async function dataRecordActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/datarecord/list/job/${params.job}`)
    return data.data
}

    
// 指定工作标识创建版式文件版本.
// work: String: 标识
// GET
export async function documentVersionActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/${params.id}`)
    return data.data
}

    
// 根据版式文件历史版本标识获取内容.
// id: String: 标识
// POST
export async function documentVersionActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/work/${params.work}`, params)
    return data.data
}

    
// 列示指定任务标识的版式文件历史版本.
// job: String: 标识
// GET
export async function documentVersionActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/list/job/${params.job}`)
    return data.data
}

    
// 列示指定任务标识以及类型的版式文件历史版本.
// job: String: 标识
// category: String: 类型
// GET
export async function documentVersionActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/list/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 列示指定工作或已完成工作的版式文件历史版本.
// workOrWorkCompleted: String: 标识
// GET
export async function documentVersionActionListWithWorkOrWorkCompletedCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/list/workorworkcompleted/${params.workOrWorkCompleted}/category/${params.category}`)
    return data.data
}

    
// 列示指定工作或已完成工作以及类型的版式文件历史版本.
// workOrWorkCompleted: String: 标识
// category: String: 类型
// GET
export async function documentVersionActionListWithJobCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/documentversion/list/job/${params.job}/category/${params.category}`)
    return data.data
}

    
// 指定草稿标识,删除草稿.
// id: String: 草稿标识
// GET
export async function draftActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/${params.id}`)
    return data.data
}

    
// 指定草稿标识,删除草稿(mock delete to get).
// id: String: 草稿标识
// DELETE
export async function draftActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/${params.id}`, params)
    return data.data
}

    
// 指定流程标识,创建草稿.
// processFlag: String: 流程标识
// GET
export async function draftActionStart (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/${params.id}/start`)
    return data.data
}

    
// 指定草稿标识,获取草稿内容.
// id: String: 草稿标识
// PUT
export async function draftActionSave (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft`, params)
    return data.data
}

    
// 分页列示当前用户创建的草稿.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function draftActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/list/my/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 翻页列示当前用户创建的草稿,下一页.
// id: String: 草稿标识
// count: Integer: 数量
// GET
export async function draftActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 翻页列示当前用户创建的草稿,上一页.
// id: String: 草稿标识
// count: Integer: 数量
// POST
export async function draftActionDraw (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/process/${params.processFlag}`, params)
    return data.data
}

    
// 保存草稿内容.
// POST
export async function draftActionSaveMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/mockputtopost`, params)
    return data.data
}

    
// M保存草稿内容(mock put to post).
// GET
export async function draftActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 指定草稿标识,将草稿启动成为工作.
// id: String: 草稿标识
// GET
export async function draftActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/draft/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/echo`)
    return data.data
}

    
// 根据应用标识和文件标识访问文件内容.
// flag: String: 标识
// applicationFlag: String: 应用标识
// GET
export async function fileActionContent (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/file/${params.flag}/application/${params.applicationFlag}/content`)
    return data.data
}

    
// 根据应用标识和文件标识访问文件内容,设定使用流输出.
// flag: String: 标识
// applicationFlag: String: 应用标识
// GET
export async function fileActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/file/${params.flag}/application/${params.applicationFlag}/download`)
    return data.data
}

    
// 列示指定应用标识下所有可见的文件.
// applicationFlag: String: 标识
// GET
export async function fileActionListWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/file/list/application/${params.applicationFlag}`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 根据表单标识获取表单.
// id: String: 标识
// GET
export async function formActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/${params.flag}`)
    return data.data
}

    
// 根据表单标识获取移动表单.
// id: String: 标识
// GET
export async function formActionGetMobile (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/${params.flag}/mobile`)
    return data.data
}

    
// 查询表单,如果有表单那么返回表单标识,如果表单不存在且是已完成工作,那么返回储存表单.
// workOrWorkCompleted: String: 工作或已完成工作标识
// GET
export async function formActionV2GetMobile (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/v2/${params.id}/mobile`)
    return data.data
}

    
// 查询表单,如果有表单那么返回表单id,如果表单不存在且是已完成工作,那么返回storeFormMobile.
// workOrWorkCompleted: String: 工作或已完成工作标识
// GET
export async function formActionV2Get (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/v2/${params.id}`)
    return data.data
}

    
// 获取表单内容.
// flag: String: 表单标识
// GET
export async function formActionGetWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/${params.flag}/application/${params.applicationFlag}`)
    return data.data
}

    
// 获取移动端表单内容.
// flag: String: 表单标识
// GET
export async function formActionGetWithApplicationMobile (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/${params.flag}/application/${params.applicationFlag}/mobile`)
    return data.data
}

    
// 根据标识和应用标识获取表单.
// flag: String: 表单标识
// applicationFlag: String: 应用标识
// GET
export async function formActionV2LookupWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/v2/lookup/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 根据标识和应用标识获取移动端表单.
// flag: String: 表单标识
// applicationFlag: String: 应用标识
// GET
export async function formActionV2LookupWorkOrWorkCompletedMobile (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/form/v2/lookup/workorworkcompleted/${params.workOrWorkCompleted}/mobile`)
    return data.data
}

    
// 返回指定job是否allowVisit.
// job: String: 标识
// person: String: 标识
// GET
export async function jobActionV2Projection (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/job/v2/${params.job}/projection`)
    return data.data
}

    
// 根据任务标识查找属于这个工作和已完成工作.
// job: String: 任务标识
// GET
export async function jobActionLatestWorkWorkCompletedWithSerial (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/job/latest/work/workcompleted/serial/${params.serial}`)
    return data.data
}

    
// 根据问号查找工作或已完成工作,并返回最新创建的一个工作或已完成工作.
// serial: String: 编号
// GET
export async function jobActionFindWorkWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/job/${params.job}/find/work/workcompleted`)
    return data.data
}

    
// 根据给定的任务标识立即执行字段映射.
// job: String: 标识
// GET
export async function jobActionAllowVisitWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/job/${params.job}/allow/visit/person/${params.person}`)
    return data.data
}

    
// 使用当前用户身份锁定工作.
// PUT
export async function keyLockActionLock (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/keylock/lock`, params)
    return data.data
}

    
// Mock Post To Put.
// POST
export async function keyLockActionLockMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/keylock/lock/mockputtopost`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/openapi`)
    return data.data
}

    
// 根据流程标识查询流程简要信息.
// GET
export async function processActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/${params.flag}`)
    return data.data
}

    
// 根据流程标识获取流程.
// flag: String: 流程标识
// GET
export async function processActionGetAllowRerouteTo (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/${params.flag}/allowrerouteto`)
    return data.data
}

    
// 根据活动标识和活动类型获取流程节点信息.
// activity: String: 流程节点标志
// activityType: String: 流程节点类型
// GET
export async function processActionGetActivity (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/activity/${params.activity}/activityType/${params.activityType}`)
    return data.data
}

    
// 根据流程标识获取指定流程可调度到的节点.
// flag: String: 流程标识
// POST
export async function processActionListWithIds (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/ids`, params)
    return data.data
}

    
// 获取流程内容,附带所有的活动节点信息.
// flag: String: 流程标识
// GET
export async function processActionGetComplex (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/${params.flag}/complex`)
    return data.data
}

    
// 根据应用标识和流程标识获取流程.
// flag: String: 流程标识
// applicationFlag: String: 应用标识
// GET
export async function processActionGetWithProcessWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/${params.flag}/application/${params.applicationFlag}`)
    return data.data
}

    
// 获取当前用户在指定流程中可启动流程的身份.
// flag: String: 流程标识
// GET
export async function processActionListWithPersonWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/application/${params.applicationFlag}`)
    return data.data
}

    
// 根据指定应用标识获取可管理的流程.
// applicationFlag: String: 应用标识
// GET
export async function processActionListControllableWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/controllable/application/${params.applicationFlag}`)
    return data.data
}

    
// 根据指定应用标识获取可启动的流程.
// applicationFlag: String: 应用标识
// GET
export async function processActionListAvailableIdentityWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/available/identity/process/${params.flag}`)
    return data.data
}

    
// 根据指定应用标识和指定条件过滤可启动的流程.
// applicationFlag: String: 应用标识
// POST
export async function processActionListWithPersonWithApplicationFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/process/list/application/${params.applicationFlag}/filter`, params)
    return data.data
}

    
// 统计待阅数量.
// GET
export async function readActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}`)
    return data.data
}

    
// 列示待阅.
// GET
export async function readActionReference (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/reference`)
    return data.data
}

    
// 列示当前用户创建的工作的待阅,下一页.
// id: String: 待办标识
// count: Integer: 数量
// GET
export async function readActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/work/${params.work}`)
    return data.data
}

    
// 列示当前用户创建的工作的待阅,分页.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function readActionCountWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/count/filter`, params)
    return data.data
}

    
// 列示当前用户创建的工作的待阅,上一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function readActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/my/filter/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 列示当前用户的待阅,下一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function readActionEditMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/mockputtopost`, params)
    return data.data
}

    
// 列示当前用户的待阅,分页.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function readActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 列示当前用户的待阅,上一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function readActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/create/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 获取指定人员在指定范围内的待阅数量没有权限限制.
// GET
export async function readActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/my/paging/${params.page}/size/${params.size}`)
    return data.data
}

    
// 获取制定人员的待阅数量,没有权限限制.
// credential: String: 个人标识
// POST
export async function readActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list`, params)
    return data.data
}

    
// 根据work创建待阅.
// workId: String: 工作标识
// POST
export async function readActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/count`, params)
    return data.data
}

    
// 根据workCompleted创建待阅.
// workCompletedId: String: 已完成工作标识
// GET
export async function readActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/filter/attribute`)
    return data.data
}

    
// 更新待阅内容,仅更新待阅意见.
// id: String: 待阅标识
// GET
export async function readActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/count/${params.credential}`)
    return data.data
}

    
// Mock Post To Put.
// id: String: 待阅标识
// POST
export async function readActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.id}/next/${params.count}/filter`, params)
    return data.data
}

    
// 获取可用与filter的分类值
// PUT
export async function readActionManageOpinion (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/opinion/manage`, params)
    return data.data
}

    
// 获取可用与filter的分类值,通过输入值进行范围限制.
// PUT
export async function readActionEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}`, params)
    return data.data
}

    
// 获取待阅内容,
// id: String: 待阅标识
// PUT
export async function readActionManageProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/processing/manage`, params)
    return data.data
}

    
// 统计当前用户在指定应用下的待阅，按应用分类.
// DELETE
export async function readActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/manage`, params)
    return data.data
}

    
// 统计当前用户在指定应用下的待阅，按流程分类.
// applicationFlag: String: 应用标识
// POST
export async function readActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/create/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 按条件对当前用户待阅分页显示.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function readActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.id}/prev/${params.count}/filter`, params)
    return data.data
}

    
// 列示当前用户的待阅,分页.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function readActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/create/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示当前用户的Read对象,下一页.
// id: String: 待阅标识
// count: Integer: 数量
// GET
export async function readActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示指定应用当前用户的Read对象,下一页.
// id: String: 待阅标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function readActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 列示当前用户过滤的Read,下一页.
// id: String: 待阅标识
// count: Integer: 数量
// POST
export async function readActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/v2/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示指定流程当前用户的Read对象,下一页.
// id: String: 待阅标识
// count: Integer: 数量
// processFlag: String: 流程标识
// POST
export async function readActionCreateWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/work/${params.workId}`, params)
    return data.data
}

    
// 列示当前用户的Read对象,上一页.
// id: String: 待阅标识
// count: Integer: 数量
// PUT
export async function readActionManageResetRead (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/reset/manage`, params)
    return data.data
}

    
// 列示指定应用当前用户的Read对象,上一页.
// id: String: 待阅标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function readActionManageListWithDate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/date/${params.date}/manage`)
    return data.data
}

    
// 列示当前用户过滤的Read,上一页.
// id: String: 待阅标识
// count: Integer: 数量
// GET
export async function readActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 列示指定流程当前用户的Read对象,上一页.
// id: String: 待阅标识
// count: Integer: 数量
// processFlag: String: 流程标识
// POST
export async function readActionProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/processing`, params)
    return data.data
}

    
// 根据job获取待阅.
// job: String: 任务标识
// GET
export async function readActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/job/${params.job}`)
    return data.data
}

    
// 根据work获取待阅.
// work: String: 工作标识
// POST
export async function readActionManageProcessingMockPostToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/processing/manage/mockputtopost`, params)
    return data.data
}

    
// 根据工作或完成工作获取待阅.
// workOrWorkCompleted: String: 工作或完成工作标识
// POST
export async function readActionManageResetReadMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/reset/manage/mockputtopost`, params)
    return data.data
}

    
// 管理删除待阅.
// id: String: 待阅标识
// POST
export async function readActionCreateWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/workcompleted/${params.workCompletedId}`, params)
    return data.data
}

    
// 管理删除待阅.
// id: String: 待阅标识
// GET
export async function readActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.id}/prev/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 按条件对待阅分页显示.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function readActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/count/application/${params.applicationFlag}/process`)
    return data.data
}

    
// 按创建时间查询指定时间段内当前所有待阅.
// date: String: 日期（如:2020-09-11）
// GET
export async function readActionListCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/count/application`)
    return data.data
}

    
// 获取指定用户当前所有待阅.
// person: String: 用户
// POST
export async function readActionManageOpinionMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/opinion/manage/mockputtopost`, params)
    return data.data
}

    
// 管理修改意见.
// id: String: 待阅标识
// GET
export async function readActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/${params.id}/manage/mockdeletetoget`)
    return data.data
}

    
// Mock Post To Put.
// id: String: 待阅标识
// GET
export async function readActionManageListWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/person/${params.person}/manage`)
    return data.data
}

    
// 管理待阅转已阅.
// id: String: 待阅标识
// POST
export async function readActionFilterAttributeFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/filter/attribute/filter`, params)
    return data.data
}

    
// Mock Post To Put.
// id: String: 待阅标识
// POST
export async function readActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/filter/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 重置待阅,将之前的待办转为已办,opinion:办理意见,identityList:新的待阅人.
// id: String: 待阅标识
// GET
export async function readActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// Mock Post To Put.
// id: String: 待阅标识
// GET
export async function readActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.id}/next/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 保存待阅并创建已阅.
// id: String: 待阅标识
// GET
export async function readActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 列示指定待阅后续的所有Work和WorkCompleted.
// id: String: 待阅标识
// GET
export async function readActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/read/list/${params.id}/next/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 统计已阅数量.
// GET
export async function readCompletedActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.id}`)
    return data.data
}

    
// 列示已阅.
// GET
export async function readCompletedActionGetReference (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.id}/reference`)
    return data.data
}

    
// 翻页列示当前用户创建的工作的已阅,下一页.
// id: String: 待办标识
// count: Integer: 数量
// GET
export async function readCompletedActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/work/${params.work}`)
    return data.data
}

    
// 分页列示当前用户创建工作的已阅.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function readCompletedActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/my/filter/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 翻页列示当前用户创建的工作的已阅,上一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function readCompletedActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 翻页列示当前用户的已阅,下一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function readCompletedActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/create/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 翻页列示当前用户的已阅.
// page: Integer: 分页
// size: Integer: 每页数量
// GET
export async function readCompletedActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/my/paging/${params.page}/size/${params.size}`)
    return data.data
}

    
// 翻页列示当前用户的已阅,上一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function readCompletedActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list`, params)
    return data.data
}

    
// 获取指定人员的已办数量,没有权限限制.
// credential: String: 个人标识
// POST
export async function readCompletedActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/count`, params)
    return data.data
}

    
// 获取可用与过滤的分类值.
// GET
export async function readCompletedActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/filter/attribute`)
    return data.data
}

    
// 获取可用与过滤的分类值,通过输入值进行范围限制.
// GET
export async function readCompletedActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/count/${params.credential}`)
    return data.data
}

    
// 根据标识获取已阅内容.
// id: String: 已阅标识
// POST
export async function readCompletedActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.id}/next/${params.count}/filter`, params)
    return data.data
}

    
// 列示指定已阅后续的所有工作和已完成工作.
// id: String: 已阅标识
// DELETE
export async function readCompletedActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.id}/manage`, params)
    return data.data
}

    
// 统计当前用户按应用分类的已阅.
// POST
export async function readCompletedActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/create/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 统计当前用户指定应用标识按流程分类的已阅.
// applicationFlag: String: 应用标识
// POST
export async function readCompletedActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.id}/prev/${params.count}/filter`, params)
    return data.data
}

    
// 分页列示按过滤条件过滤当前用户的已阅.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function readCompletedActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/create/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 分页列示当前用户的已阅.
// page: Integer: 分页
// size: Integer: 每页数量
// GET
export async function readCompletedActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 翻页列示当前用户的已阅,下一页.
// id: String: 已阅标识
// count: Integer: 数量
// POST
export async function readCompletedActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 翻页列示当前用户指定应用标识的已阅,下一页.
// id: String: 已阅标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function readCompletedActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/v2/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 翻页列示按过滤条件过滤的已阅,下一页.
// id: String: 已阅标识
// count: Integer: 数量
// POST
export async function readCompletedActionManageUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.id}/opinion/manage`, params)
    return data.data
}

    
// 翻页列示当前用户指定流程标识的已阅,下一页.
// id: String: 已阅标识
// count: Integer: 数量
// processFlag: String: 流程标识
// GET
export async function readCompletedActionManageListWithDate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/date/${params.date}/manage`)
    return data.data
}

    
// 翻页列示当前用户的已阅,上一页.
// id: String: 已阅标识
// count: Integer: 数量
// GET
export async function readCompletedActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 翻页列示当前用户指定应用标识的已阅,上一页.
// id: String: 已阅标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function readCompletedActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/job/${params.job}`)
    return data.data
}

    
// 翻页列示按过滤条件过滤的已阅,上一页.
// id: String: 已阅标识
// count: Integer: 数量
// GET
export async function readCompletedActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.id}/prev/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 翻页列示当前用户指定流程标识的已阅,上一页.
// id: String: 已阅标识
// count: Integer: 数量
// processFlag: String: 流程标识
// GET
export async function readCompletedActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/count/application/${params.applicationFlag}/process`)
    return data.data
}

    
// 根据任务标识获取已阅.
// job: String: 任务标识
// GET
export async function readCompletedActionListCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/count/application`)
    return data.data
}

    
// 根据工作标识获取已阅.
// work: String: 工作标识
// GET
export async function readCompletedActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/${params.id}/manage/mockdeletetoget`)
    return data.data
}

    
// 根据工作标识或完成工作标识获取已阅.
// workOrWorkCompleted: String: 工作或完成工作标识
// POST
export async function readCompletedActionFilterAttributeFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/filter/attribute/filter`, params)
    return data.data
}

    
// 根据已阅标识删除已阅,需要管理权限.
// id: String: 已阅标识
// POST
export async function readCompletedActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/filter/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 根据已阅标识删除已阅,需要管理权限(mock delete to get).
// id: String: 已阅标识
// GET
export async function readCompletedActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 分页列示按过滤条件过滤的已阅,需要管理权限.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function readCompletedActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.id}/next/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 按创建时间查询指定时间段内当前所有已阅,需要管理权限.
// date: String: 日期（如:2020-09-11）
// GET
export async function readCompletedActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 根据已阅标识修改意见,需要管理权限.
// id: String: 已阅标识
// GET
export async function readCompletedActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readcompleted/list/${params.id}/next/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 根据任务标识获取阅读记录.
// job: String: 工作的job
// GET
export async function readRecordActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readrecord/list/job/${params.job}`)
    return data.data
}

    
// 根据工作或完成工作标识获取阅读记录.
// workOrWorkCompleted: String: 工作或完成工作标识
// GET
export async function readRecordActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/readrecord/list/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 根据任务标识获取记录.
// job: String: 工作的job
// DELETE
export async function recordActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/${params.id}/manage`, params)
    return data.data
}

    
// 分页列示根据任务标识获取的记录.
// job: String: 工作的job
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function recordActionListWithJobPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/list/job/${params.job}/paging/${params.page}/size/${params.size}`)
    return data.data
}

    
// 根据工作或完成工作标识获取记录.
// workOrWorkCompleted: String: 工作或完成工作标识
// PUT
export async function recordActionManageEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/${params.id}/manage`, params)
    return data.data
}

    
// 分页列示根据工作或完成工作标识获取的记录.
// workOrWorkCompleted: String: 工作或完成工作标识
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function recordActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/list/job/${params.job}`)
    return data.data
}

    
// 根据任务标识创建记录,需要管理权限.
// job: String: 标识
// GET
export async function recordActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/${params.id}/manage/mockdeletetoget`)
    return data.data
}

    
// 根据记录标识删除记录,需要管理权限.
// id: String: 标识
// GET
export async function recordActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/list/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 根据记录标识删除记录,需要管理权限(mock delete to get).
// id: String: 标识
// POST
export async function recordActionManageCreateWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/job/${params.job}/manage`, params)
    return data.data
}

    
// 根据记录标识修改记录,需要管理权限.
// id: String: 标识
// POST
export async function recordActionManageEditMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/${params.id}/manage/mockputtopost`, params)
    return data.data
}

    
// 根据记录标识修改记录,需要管理权限(mock put to post).
// id: String: 标识
// GET
export async function recordActionListWithWorkOrWorkCompletedPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/record/list/workorworkcompleted/${params.workOrWorkCompleted}/paging/${params.page}/size/${params.size}`)
    return data.data
}

    
// 统计参阅数量.
// GET
export async function reviewActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/${params.id}`)
    return data.data
}

    
// 列示参阅.
// POST
export async function reviewActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 列示当前用户创建的工作的参阅,下一页.
// id: String: 参阅标识
// count: Integer: 数量
// POST
export async function reviewActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/create/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 列示当前用户创建的工作的参阅,分页.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function reviewActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list`, params)
    return data.data
}

    
// 列示当前用户创建的工作的参阅,上一页.
// id: String: 参阅标识
// count: Integer: 数量
// POST
export async function reviewActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/count`, params)
    return data.data
}

    
// 列示当前用户的参阅,下一页.
// id: String: 参阅标识
// count: Integer: 数量
// POST
export async function reviewActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/filter/attribute`, params)
    return data.data
}

    
// 列示当前用户的参阅,分页.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function reviewActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/count/person/${params.credential}`, params)
    return data.data
}

    
// 列示当前用户的参阅,上一页.
// id: String: 参阅标识
// count: Integer: 数量
// DELETE
export async function reviewActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/${params.id}/application/${params.applicationFlag}/manage`, params)
    return data.data
}

    
// 管理员分页查询参阅.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function reviewActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/create/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取当前人员的参阅数量按应用分类.
// POST
export async function reviewActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/create/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 获取人员的参阅数量,没有权限限制.
// credential: String: 个人标识
// POST
export async function reviewActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 根据workId创建一个review.
// POST
export async function reviewActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 根据workCompleted创建一个review.
// POST
export async function reviewActionCreateWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/create/work`, params)
    return data.data
}

    
// 获取可用与filter的分类值
// POST
export async function reviewActionV2Search (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/search`, params)
    return data.data
}

    
// 获取参阅内容,
// id: String: 参阅标识
// POST
export async function reviewActionV2ManageListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/v2/list/paging/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 根据工作或完成工作标识获取参阅.
// workOrWorkCompleted: String: 工作或完成工作标识
// GET
export async function reviewActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/list/job/${params.job}`)
    return data.data
}

    
// 根据job获取参阅.
// job: String: 任务标识
// POST
export async function reviewActionCreateWithWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/create/workcompleted`, params)
    return data.data
}

    
// 管理删除参阅.
// id: String: 参阅标识
// applicationFlag: String: 应用标识
// POST
export async function reviewActionCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/count/application`, params)
    return data.data
}

    
// Mock Get To Delete.
// id: String: 参阅标识
// applicationFlag: String: 应用标识
// GET
export async function reviewActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/${params.id}/application/${params.applicationFlag}/manage/mockdeletetoget`)
    return data.data
}

    
// 搜索.
// GET
export async function reviewActionGetWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/review/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 获取路由.
// id: String: 任务标识
// GET
export async function routeActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/route/${params.id}`)
    return data.data
}

    
// 获取选择人员配置.
// id: String: 任务标识
// PUT
export async function routeActionList (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/route/list`, params)
    return data.data
}

    
// 批量获取路由.
// POST
export async function routeActionListMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/route/list/mockputtopost`, params)
    return data.data
}

    
// Mock Post To Put.
// GET
export async function routeActionGetSelectConfig (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/route/${params.id}/selectconfig`)
    return data.data
}

    
// GET方法获取Script以及依赖脚本内容,POST无法缓存,GET方法不过滤已经导入的脚本.
// flag: String: 脚本标识
// applicationFlag: String: 应用标识
// POST
export async function scriptActionLoad (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/script/${params.flag}/application/${params.applicationFlag}`, params)
    return data.data
}

    
// 获取Script以及依赖脚本内容。
// flag: String: 脚本标识
// applicationFlag: String: 应用标识
// GET
export async function scriptActionGetImported (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/script/${params.flag}/application/${params.applicationFlag}/imported`)
    return data.data
}

    
// 创建SerialNumber内容.
// GET
export async function serialNumberActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.id}`)
    return data.data
}

    
// 删除SerialNumber内容.
// id: String: 标识
// PUT
export async function serialNumberActionUpdate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.id}`, params)
    return data.data
}

    
// Mock Get To Delete.
// id: String: 标识
// GET
export async function serialNumberActionList (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/list/application/${params.applicationFlag}`)
    return data.data
}

    
// 获取SerialNumber内容,
// id: String: 标识
// DELETE
export async function serialNumberActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.id}`, params)
    return data.data
}

    
// 列示指定应用的所有SerialNumber对象.
// applicationFlag: String: 应用标识
// POST
export async function serialNumberActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber`, params)
    return data.data
}

    
// 更新SerialNumber内容.
// id: String: 标识
// GET
export async function serialNumberActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.id}/mockdeletetoget`)
    return data.data
}

    
// Mock Post To Put.
// id: String: 标识
// POST
export async function serialNumberActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/serialnumber/${params.id}/mockputtopost`, params)
    return data.data
}

    
// 访问服务.
// id: String: 工作标识
// PUT
export async function serviceActionTouch (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/service/work/${params.id}/touch`, params)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// POST
export async function serviceActionTouchMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/service/work/${params.id}/touch/mockputtopost`, params)
    return data.data
}

    
// 删除签批
// id: String: 标识
// GET
export async function signActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/${params.id}`)
    return data.data
}

    
// 根据task删除签批
// taskId: String: 待办标识
// DELETE
export async function signActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/${params.id}`, params)
    return data.data
}

    
// 根据task删除签批mockdeletetoget
// taskId: String: 待办标识
// POST
export async function signActionSave (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/save/task/${params.taskId}`, params)
    return data.data
}

    
// 删除签批
// id: String: 标识
// GET
export async function signActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/download/${params.scrawlId}`)
    return data.data
}

    
// 下载签批涂鸦附件
// scrawlId: String: 签批涂鸦附件标志
// DELETE
export async function signActionDeleteByTask (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/task/${params.taskId}`, params)
    return data.data
}

    
// 获取签批信息.
// id: String: 标识
// GET
export async function signActionGetByTask (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/task/${params.taskId}`)
    return data.data
}

    
// 根据task获取签批信息.
// taskId: String: 任务ID
// GET
export async function signActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/list/job/${params.job}`)
    return data.data
}

    
// 根据工作的job获取签批列表.
// job: String: 工作的job
// GET
export async function signActionDeleteMockGet2Delete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 保存签批.
// taskId: String: 待办ID
// GET
export async function signActionDeleteByTaskMockGet2Delete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sign/task/${params.taskId}/mockdeletetoget`)
    return data.data
}

    
// 删除快照
// id: String: 标识
// GET
export async function snapActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.id}`)
    return data.data
}

    
// 删除快照
// id: String: 标识
// DELETE
export async function snapActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.id}`, params)
    return data.data
}

    
// 导出快照.
// id: String: 标识
// POST
export async function snapActionUpload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/upload`, params)
    return data.data
}

    
// 获取快照对象.
// id: String: 标识
// GET
export async function snapActionDownload (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.id}/download`)
    return data.data
}

    
// 按条件对当前用户快照分页显示.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function snapActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/my/filter/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 列示当前用户的快照,分页.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function snapActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/my/paging/${params.page}/size/${params.size}`)
    return data.data
}

    
// 列示当前用户创建的快照对象,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function snapActionManageListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/prev/${params.count}/manage`)
    return data.data
}

    
// 列示指定应用当前用户的快照对象,下一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function snapActionManageListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/next/${params.count}/manage`)
    return data.data
}

    
// 列示指定流程当前用户的快照对象,下一页.
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识
// GET
export async function snapActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示当前用户创建的快照对象,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function snapActionTypeSuspend (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/work/${params.workId}/type/suspend`)
    return data.data
}

    
// 列示指定应用当前用户的快照对象,上一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function snapActionTypeAbandoned (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/work/${params.workId}/type/abandoned`)
    return data.data
}

    
// 列示指定流程当前用户的快照对象,上一页.
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识
// GET
export async function snapActionRestore (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.id}/restore`)
    return data.data
}

    
// 按条件对快照分页显示.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function snapActionTypeSnap (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/work/${params.workId}/type/snap`)
    return data.data
}

    
// 列示所有创建的快照对象,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function snapActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 获取指定条件的快照,下一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function snapActionManageListWithApplicationPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/paging/${params.page}/size/${params.size}/application/${params.applicationFlag}/filter/manage`, params)
    return data.data
}

    
// 列示所有创建的快照对象,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function snapActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/prev/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 获取指定条件的快照,上一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function snapActionManageListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/prev/${params.count}/filter/manage`, params)
    return data.data
}

    
// 分页列示指定应用下根据过滤条件的snap.
// page: Integer: 分页
// size: Integer: 每页数量
// applicationFlag: String: 应用标识
// POST
export async function snapActionManageListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/next/${params.count}/filter/manage`, params)
    return data.data
}

    
// 恢复快照
// id: String: 标识
// POST
export async function snapActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/filter/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 对工作进行快照,并标记为废弃.
// workId: String: 工作标识
// GET
export async function snapActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/next/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 对已完成工作进行快照,并标记为废弃.
// workCompletedId: String: 工作标识
// GET
export async function snapActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 对工作进行快照.
// workId: String: 工作标识
// GET
export async function snapActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/list/${params.id}/next/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 对已完成工作进行快照.
// workCompletedId: String: 工作标识
// GET
export async function snapActionDeleteMockGet2Delete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 挂起工作
// workId: String: 工作标识
// GET
export async function snapActionTypeAbandonedWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/workcompleted/${params.workCompletedId}/type/abandonedworkcompleted`)
    return data.data
}

    
// 导入快照.
// GET
export async function snapActionTypeSnapWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/snap/workcompleted/${params.workCompletedId}/type/snapworkcompleted`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 在指定待办位置新增处理人.
// id: String: 标识
// GET
export async function taskActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}`)
    return data.data
}

    
// 按条件过滤统计待办数量.
// PUT
export async function taskActionReset (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/reset`, params)
    return data.data
}

    
// 按条件过滤的当前用户待办.
// GET
export async function taskActionGetReference (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/reference`)
    return data.data
}

    
// 翻页显示当前用户创建工作的待办,下一页.
// id: String: 待办标识
// count: Integer: 数量
// GET
export async function taskActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/work/${params.work}`)
    return data.data
}

    
// 分页显示当前用户创建工作的待办.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function taskActionCountWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/count/filter`, params)
    return data.data
}

    
// 翻页显示当前用户创建工作的待办,上一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function taskActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/my/filter/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 翻页显示按条件过滤的当前用户待办,下一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function taskActionEditMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/mockputtopost`, params)
    return data.data
}

    
// 分页显示按条件过滤的当前用户待办.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function taskActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 翻页显示按条件过滤的当前用户待办,上一页.
// id: String: 待办标识
// count: Integer: 数量
// POST
export async function taskActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/create/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
// id: String: 标识
// GET
export async function taskActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/my/paging/${params.page}/size/${params.size}`)
    return data.data
}

    
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人(MockPutToPost)
// id: String: 标识
// POST
export async function taskActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list`, params)
    return data.data
}

    
// 获取指定人员,应用,流程在指定范围内的待办数量,没有权限限制.
// POST
export async function taskActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/count`, params)
    return data.data
}

    
// 获取指定人员的待办数量,没有权限限制.
// credential: String: 个人标识
// GET
export async function taskActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/filter/attribute`)
    return data.data
}

    
// 更新指定待办的选择的路由及意见.
// id: String: 标识
// GET
export async function taskActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/count/${params.credential}`)
    return data.data
}

    
// 更新指定待办的选择的路由及意见(MockPutToPost).
// id: String: 标识
// POST
export async function taskActionV2Add (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.id}/add`, params)
    return data.data
}

    
// 获取可用与过滤的的待办分类值.
// POST
export async function taskActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/next/${params.count}/filter`, params)
    return data.data
}

    
// 根据输入的分类过滤值,获取可用与过滤的的待办分类值.
// POST
export async function taskActionResetMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/reset/mockputtopost`, params)
    return data.data
}

    
// 根据标识获取待办内容.
// id: String: 待办标识
// PUT
export async function taskActionManageOpinion (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/opinion/manage`, params)
    return data.data
}

    
// 取得复合的待办信息,包括:待办对象,工作对象,附件对象,已完成工作对象和工作日志对象.
// id: String: 标识
// GET
export async function taskActionManageListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/prev/${params.count}/manage`)
    return data.data
}

    
// 统计当前用户按应用分类待办数量.
// PUT
export async function taskActionEdit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}`, params)
    return data.data
}

    
// 统计当前用户指定应用中按流程分类待办数量.
// applicationFlag: String: 应用标识
// PUT
export async function taskActionManageProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/processing/manage`, params)
    return data.data
}

    
// 分页显示根据条件过滤当前用户待办,可选条件:应用,流程,开始时间,结束时间,创建组织,创建年月,活动名称,过期时间,催办时间,是否包含草稿,关键字.
// page: Integer: 分页
// size: Integer: 数量
// DELETE
export async function taskActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/manage`, params)
    return data.data
}

    
// 分页显示当前用户的待办.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function taskActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/create/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 翻页列示当前用户的待办对象,下一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function taskActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/prev/${params.count}/filter`, params)
    return data.data
}

    
// 翻页显示当前用户指定应用的待办,下一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function taskActionManageListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/next/${params.count}/manage`)
    return data.data
}

    
// 翻页显示当前用户待办,通过输入过滤值进行范围限制,下一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function taskActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/create/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 翻页显示当前用户指定流程的待办,下一页.
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识
// GET
export async function taskActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 翻页列示当前用户的待办对象,上一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function taskActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 翻页显示当前用户指定应用的待办,上一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function taskActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 翻页显示当前用户待办,通过输入过滤值进行范围限制,上一页.
// id: String: 标识
// count: Integer: 数量
// PUT
export async function taskActionV2Reset (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.id}/reset`, params)
    return data.data
}

    
// 列示指定流程当前用户的待办对象,上一页.
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识
// POST
export async function taskActionProcessingNeural (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/processing/neural`, params)
    return data.data
}

    
// 根据指定的job列示待办.
// job: String: 任务标识
// GET
export async function taskActionWill (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/will`)
    return data.data
}

    
// 根据工作获取待办.
// work: String: 工作标识
// GET
export async function taskActionManagePress (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/press/manage`)
    return data.data
}

    
// 管理维护接口:删除待办,需要管理权限.
// id: String: 标识
// PUT
export async function taskActionManageReset (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/reset/manage`, params)
    return data.data
}

    
// 管理维护接口:删除待办,需要管理权限.MockGetToDelete.
// id: String: 标识
// GET
export async function taskActionV2Pause (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.id}/pause`)
    return data.data
}

    
// 管理维护接口:翻页显示按条件过滤待办.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function taskActionV2Resume (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.id}/resume`)
    return data.data
}

    
// 管理维护接口:翻页显示所有待办,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function taskActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 管理维护接口:获取指定过滤条件过滤的待办,下一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function taskActionProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/processing`, params)
    return data.data
}

    
// 管理维护接口:翻页显示所有待办,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function taskActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/job/${params.job}`)
    return data.data
}

    
// 管理维护接口:获取指定过滤条件过滤的待办,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function taskActionManageListWithDateHour (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/date/${params.date}/hour/${params.hour}/exclude/draft/${params.isExcludeDraft}/manage`)
    return data.data
}

    
// 管理维护接口:按创建时间查询指定时间段内当前所有待办.
// date: String: 日期（如:2020-09-11）
// hour: Integer: 小时（0-23）
// isExcludeDraft: Boolean: 是否排除草稿待办：false(不排除)|true
// GET
export async function taskActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/prev/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 管理维护接口:列示指定人员的待办.
// person: String: 用户
// isExcludeDraft: Boolean: 是否排除草稿待办：false(不排除)|true
// POST
export async function taskActionManageResetMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/reset/manage/mockputtopost`, params)
    return data.data
}

    
// 管理维护接口:管理修改意见,需要管理权限.
// id: String: 待办标识
// GET
export async function taskActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/count/application/${params.applicationFlag}/process`)
    return data.data
}

    
// 管理维护接口:管理修改意见,需要管理权限(MockPostToPut).
// id: String: 待办标识
// GET
export async function taskActionListCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/count/application`)
    return data.data
}

    
// 管理维护接口:待办提醒.
// id: String: 标识
// POST
export async function taskActionManageOpinionMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/opinion/manage/mockputtopost`, params)
    return data.data
}

    
// 管理维护接口:待办转已办,需要管理权限.
// id: String: 待办标识
// GET
export async function taskActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/manage/mockdeletetoget`)
    return data.data
}

    
// 管理维护接口:待办转已办,需要管理权限(MockPostToPut).
// id: String: 待办标识
// GET
export async function taskActionManageListWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/person/${params.person}/exclude/draft/${params.isExcludeDraft}/manage`)
    return data.data
}

    
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
// id: String: 标识
// POST
export async function taskActionManageListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/prev/${params.count}/filter/manage`, params)
    return data.data
}

    
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
// id: String: 标识
// POST
export async function taskActionManageProcessingMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/${params.id}/processing/manage/mockputtopost`, params)
    return data.data
}

    
// 保存待办意见并继续流转.返回流转记录.
// id: String: 标识
// POST
export async function taskActionFilterAttributeFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/filter/attribute/filter`, params)
    return data.data
}

    
// 使用神经网络自动进行处理
// id: String: 标识
// POST
export async function taskActionManageListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/next/${params.count}/filter/manage`, params)
    return data.data
}

    
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
// id: String: 标识
// POST
export async function taskActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/filter/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 重置待办,将之前的待办转为已办,opinion:办理意见,routeName:选择路由,identityList:新的办理人.
// id: String: 标识
// POST
export async function taskActionV2ResetMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/v2/${params.id}/reset/mockputtopost`, params)
    return data.data
}

    
// 挂起待办,暂停待办处理计时.
// id: String: 标识
// GET
export async function taskActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/next/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 取消挂起待办,恢复待办处理计时.
// id: String: 标识
// GET
export async function taskActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 预计下一活动处理状态及处理人.
// id: String: 标识
// GET
export async function taskActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/task/list/${params.id}/next/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 统计已办数量.
// GET
export async function taskCompletedActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.id}`)
    return data.data
}

    
// 列示已办.
// GET
export async function taskCompletedActionGetReference (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.id}/reference`)
    return data.data
}

    
// 列示当前用户创建的工作的已办,下一页.
// id: String: 已办标识
// count: Integer: 数量
// GET
export async function taskCompletedActionListWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/work/${params.work}`)
    return data.data
}

    
// 列示当前用户创建的工作的已办,分页.
// page: Integer: 分页
// size: Integer: 每页数量
// POST
export async function taskCompletedActionListMyFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/my/filter/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 列示当前用户创建的工作的已办,上一页.
// id: String: 已办标识
// count: Integer: 数量
// POST
export async function taskCompletedActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 列示当前用户的已办,下一页.
// id: String: 已办标识
// count: Integer: 数量
// POST
export async function taskCompletedActionV2ListCreatePrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/create/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 列示当前用户的已办,分页.
// page: Integer: 分页
// size: Integer: 每页数量
// GET
export async function taskCompletedActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/my/paging/${params.page}/size/${params.size}`)
    return data.data
}

    
// 列示当前用户的已办,上一页.
// id: String: 已办标识
// count: Integer: 数量
// POST
export async function taskCompletedActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list`, params)
    return data.data
}

    
// 获取指定人员的已办数量,没有权限限制.
// credential: String: 个人标识
// POST
export async function taskCompletedActionV2Count (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/count`, params)
    return data.data
}

    
// 获取可用与filter的分类值.
// GET
export async function taskCompletedActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/filter/attribute`)
    return data.data
}

    
// 获取可用与filter的分类值,通过输入值进行范围限制.
// GET
export async function taskCompletedActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/count/${params.credential}`)
    return data.data
}

    
// 获取已办内容,
// id: String: 参阅标识
// POST
export async function taskCompletedActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.id}/next/${params.count}/filter`, params)
    return data.data
}

    
// 列示指定已办后续的所有Work和WorkCompleted.
// id: String: 标识
// PUT
export async function taskCompletedActionManageOpinion (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.id}/opinion/manage`, params)
    return data.data
}

    
// 统计当前用户按应用分类的已办.
// DELETE
export async function taskCompletedActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.id}/manage`, params)
    return data.data
}

    
// 统计当前用户在指定应用下的已办,按流程分类.
// applicationFlag: String: 应用标识
// POST
export async function taskCompletedActionV2ListCreatePaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/create/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 按条件对当前用户已办分页显示.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function taskCompletedActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.id}/prev/${params.count}/filter`, params)
    return data.data
}

    
// 列示当前用户的已办,分页.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function taskCompletedActionV2ListCreateNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/create/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示当前用户的已办对象,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function taskCompletedActionListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示指定应用当前用户的已办对象,下一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function taskCompletedActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取用户对已办的过滤信息,下一页.
// id: String: 标识
// count: Integer: 数量
// POST
export async function taskCompletedActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/v2/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示指定流程当前用户的已办对象,下一页.
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识
// GET
export async function taskCompletedActionReferenceControl (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.id}/reference/control`)
    return data.data
}

    
// 列示当前用户的已办对象,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function taskCompletedActionPress (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/press/work/${params.work}`)
    return data.data
}

    
// 根据待办或者已办取得上一人工活动已办.
// flag: String: 待办或已办标识
// GET
export async function taskCompletedActionListPrevManual (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/prev/manual/${params.flag}`)
    return data.data
}

    
// 列示指定应用当前用户的已办对象,上一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function taskCompletedActionListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 获取用户对已办的过滤信息,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function taskCompletedActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/job/${params.job}`)
    return data.data
}

    
// 列示指定流程当前用户的已办对象,上一页.
// id: String: 标识
// count: Integer: 数量
// processFlag: String: 流程标识
// GET
export async function taskCompletedActionManageListWithDateHour (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/date/${params.date}/hour/${params.hour}/manage`)
    return data.data
}

    
// 根据job获取已办.
// job: String: 任务标识
// GET
export async function taskCompletedActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.id}/prev/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 根据work获取已办.
// work: String: 工作标识
// GET
export async function taskCompletedActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/count/application/${params.applicationFlag}/process`)
    return data.data
}

    
// 根据工作或完成工作获取已办,
// workOrWorkCompleted: String: 工作或完成工作标识
// GET
export async function taskCompletedActionListCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/count/application`)
    return data.data
}

    
// 管理删除已办.
// id: String: 标识
// POST
export async function taskCompletedActionManageOpinionMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.id}/opinion/manage/mockputtopost`, params)
    return data.data
}

    
// Mock Get To Delete.
// id: String: 标识
// GET
export async function taskCompletedActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/${params.id}/manage/mockdeletetoget`)
    return data.data
}

    
// 按条件对已办分页显示.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function taskCompletedActionFilterAttributeFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/filter/attribute/filter`, params)
    return data.data
}

    
// 按创建时间查询指定时间段内当前所有已办.
// date: String: 日期（如:2020-09-11）
// hour: Integer: 小时（0-23）
// POST
export async function taskCompletedActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/filter/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 管理修改意见.
// id: String: 已办标识
// GET
export async function taskCompletedActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// Mock Post To Put.
// id: String: 已办标识
// GET
export async function taskCompletedActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.id}/next/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 提醒.
// work: String: 工作标识
// GET
export async function taskCompletedActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 列示指定已办后续的所有Work和WorkCompleted的简单内容和权限.
// id: String: 标识
// GET
export async function taskCompletedActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/taskcompleted/list/${params.id}/next/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 对指定的工作添加待办身份.
// id: String: 工作标识
// GET
export async function workActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}`)
    return data.data
}

    
// V2_增加一个会签分支
// id: String: 工作标识
// DELETE
export async function workActionDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}`, params)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// POST
export async function workActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/process/${params.processFlag}`, params)
    return data.data
}

    
// V2_根据Work或workCompleted取得内容.
// workOrWorkCompleted: String: 工作标识
// PUT
export async function workActionRollback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/rollback`, params)
    return data.data
}

    
// 按条件过滤的当前用户创建的待办.
// POST
export async function workActionV2ListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 按条件过滤的当前用户创建的待办.
// id: String: 工作标识
// POST
export async function workActionListMyPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/my/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 翻页显示按条件过滤的当前用户创建的工作,下一页.
// id: String: 工作标识
// count: Integer: 数量
// POST
export async function workActionV2List (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list`, params)
    return data.data
}

    
// 分页显示按条件过滤的当前用户创建的工作.
// page: Integer: 分页
// size: Integer: 每页数量
// GET
export async function workActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/filter/attribute/application/${params.applicationFlag}`)
    return data.data
}

    
// 翻页显示按条件过滤的当前用户创建的工作,上一页.
// id: String: 工作标识
// count: Integer: 数量
// GET
export async function workActionCountWithPerson (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/count/${params.credential}`)
    return data.data
}

    
// 管理员替代person操作工作召回。
// id: String: 工作标识
// person: String: 召回工作已办人员（根据流转记录确认）
// POST
export async function workActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/next/${params.count}/application/${params.applicationFlag}/filter`, params)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// person: String: 召回工作已办人员（根据流转记录确认）
// GET
export async function workActionManageListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}/manage`)
    return data.data
}

    
// V2_工作调度.
// id: String: 工作标识
// POST
export async function workActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}/filter`, params)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// GET
export async function workActionManageListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/next/${params.count}/application/${params.applicationFlag}/manage`)
    return data.data
}

    
// V2_工作召回。
// id: String: 工作标识
// POST
export async function workActionV2ListPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// POST
export async function workActionV2ListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// V2_回滚工作.
// id: String: 工作标识
// GET
export async function workActionProjection (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/projection`)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// PUT
export async function workActionV2Retract (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/retract`, params)
    return data.data
}

    
// 增加一个会签分支
// id: String: 工作标识
// PUT
export async function workActionV2ManageRetract (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/person/${params.person}/retract/manage`, params)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// PUT
export async function workActionRetract (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/retract`, params)
    return data.data
}

    
// 完成工作关闭时候的检查,1.检查是否要删除处于草稿状态的工作,没有保存过任何数据将被认为是草稿.2.检查是否需要释放抢办.
// id: String: 工作标识
// GET
export async function workActionRefer (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/refer`)
    return data.data
}

    
// 完成工作关闭时候的检查,1.检查是否要删除处于草稿状态的工作,没有保存过任何数据将被认为是草稿.2.检查是否需要释放抢办.为了支持信标方法(Navigator.sendBeacon())单独增加的方法.
// id: String: 工作标识
// POST
export async function workActionCreateForce (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/process/${params.processFlag}/force`, params)
    return data.data
}

    
// 统计当前用户创建的Work，按应用分类.
// GET
export async function workActionCloseCheck (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/close/check`)
    return data.data
}

    
// 获取指定人员的Task,TaskCompleted,Read,ReadCompleted,Review.没有权限限制
// credential: String: 个人标识
// GET
export async function workActionManageListRelative (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/relative/manage`)
    return data.data
}

    
// 获取指定人员在指定应用的Task,TaskCompleted,Read,ReadCompleted,Review.没有权限限制
// credential: String: 个人标识
// appId: String: 应用标志
// PUT
export async function workActionV2Rollback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/rollback`, params)
    return data.data
}

    
// 创建工作（创建启动版本的流程）.
// processFlag: String: 流程标识
// PUT
export async function workActionV2AddSplit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/add/split`, params)
    return data.data
}

    
// 创建工作（强制创建存在的流程）.
// processFlag: String: 流程标识
// GET
export async function workActionManageGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/manage`)
    return data.data
}

    
// 创建工作（创建启动版本的流程）.
// applicationFlag: String: 应用标识
// processFlag: String: 流程标识
// PUT
export async function workActionAddSplit (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/add/split`, params)
    return data.data
}

    
// 创建工作（强制创建存在的流程）.
// applicationFlag: String: 应用标识
// processFlag: String: 流程标识
// PUT
export async function workActionV2Reroute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/reroute`, params)
    return data.data
}

    
// 删除工作，需要应用管理权限或者是工作的创建者。
// id: String: 工作标识
// POST
export async function workActionCloseCheckPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/close/check`, params)
    return data.data
}

    
// Mock Get To Delete.
// id: String: 工作标识
// PUT
export async function workActionReroute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/reroute/activity/${params.activityId}/activitytype/${params.activityType}`, params)
    return data.data
}

    
// 获取用于过滤的可选属性值,限定范围为我创建的工作
// applicationFlag: String: 应用标识
// PUT
export async function workActionProcessing (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/processing`, params)
    return data.data
}

    
// 根据id获取工作.
// id: String: 工作标识
// POST
export async function workActionV2RerouteMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/reroute/mockputtopost`, params)
    return data.data
}

    
// 获取工作或者已完成工作内容.
// workOrWorkCompleted: String: 工作或已完成工作标识
// POST
export async function workActionManageListWithApplicationPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/paging/${params.page}/size/${params.size}/application/${params.applicationFlag}/filter/manage`, params)
    return data.data
}

    
// 统计当前用户在指定应用下的待办，按流程分类.
// applicationFlag: String: 应用标识
// POST
export async function workActionV2AddSplitMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/add/split/mockputtopost`, params)
    return data.data
}

    
// 列示当前用户创建的工作,可以根据条件过滤,分页.
// page: Integer: 分页
// size: Integer: 数量
// DELETE
export async function workActionManageDeleteSingleWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/single/manage`, params)
    return data.data
}

    
// 列示当前用户创建的Work对象,下一页.
// id: String: 工作标识
// count: Integer: 数量
// GET
export async function workActionManageGetAssignment (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/assignment/manage`)
    return data.data
}

    
// 列示根据过滤条件的我创建的工作,下一页
// id: String: 工作标识
// count: Integer: 数量
// POST
export async function workActionListPrevCreatorWithCurrentFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/prev/${params.count}/creator/current/filter`, params)
    return data.data
}

    
// 列示指定应用当前用户创建的Work对象,下一页.
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function workActionV2ManageRetractMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/person/${params.person}/retract/manage/mockputtopost`, params)
    return data.data
}

    
// 列示根据过滤条件的Work,下一页,限定范围为我创建的工作以及应用.
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function workActionManageFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/filter/attribute/application/${params.applicationFlag}/manage`)
    return data.data
}

    
// 列示指定流程当前用户创建的Work对象,下一页.
// id: String: 工作标识
// count: Integer: 数量
// processFlag: String: 流程标识
// GET
export async function workActionListPrevCreatorWithCurrent (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/prev/${params.count}/creator/current`)
    return data.data
}

    
// 列示当前用户创建的Work对象,上一页.
// id: String: 工作标识
// count: Integer: 数量
// POST
export async function workActionRetractMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/retract/mockputtopost`, params)
    return data.data
}

    
// 列示根据过滤条件的我创建的工作,上一页.
// id: String: 工作标识
// count: Integer: 数量
// POST
export async function workActionRollbackMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/rollback/mockputtopost`, params)
    return data.data
}

    
// 列示指定应用当前用户创建的Work对象,上一页.
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function workActionRerouteMockPost2Put (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/reroute/activity/${params.activityId}/activitytype/${params.activityType}/mockputtopost`, params)
    return data.data
}

    
// 列示根据过滤条件的Work,上一页,限定范围为我创建的工作以及应用.
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function workActionV2ListActivityGoBack (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/list/${params.id}/activity/goback`)
    return data.data
}

    
// 列示指定流程当前用户创建的Work对象,上一页.
// id: String: 工作标识
// count: Integer: 数量
// processFlag: String: 应用标识
// POST
export async function workActionV2RetractMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/retract/mockputtopost`, params)
    return data.data
}

    
// 删除所有相关联的工作.
// id: String: 工作标识
// POST
export async function workActionV2AddManualTaskIdentityMatrix (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/add/manual/task/identity/matrix`, params)
    return data.data
}

    
// Mock Get To Delete.
// id: String: 工作标识
// POST
export async function workActionAddSplitMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/add/split/mockputtopost`, params)
    return data.data
}

    
// 删除单个工作.
// id: String: 工作标识
// GET
export async function workActionManageListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/count/application/${params.applicationFlag}/process/manage`)
    return data.data
}

    
// Mock Get To Delete.
// id: String: 工作标识
// DELETE
export async function workActionManageDeleteRelativeWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/relative/manage`, params)
    return data.data
}

    
// 获取用于过滤的可选属性值
// applicationFlag: String: 应用标识
// POST
export async function workActionV2RollbackMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/${params.id}/rollback/mockputtopost`, params)
    return data.data
}

    
// 获取工作内容.
// id: String: 工作标识
// POST
export async function workActionListNextCreatorWithCurrentFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/next/${params.count}/creator/current/filter`, params)
    return data.data
}

    
// 列示指定Work下所有的待办已办,待阅已阅和参阅.
// id: String: 工作标识
// GET
export async function workActionV2GetWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/v2/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 列示指定application下根据porcess分类的work数量.
// applicationFlag: String: 应用标识
// GET
export async function workActionCountWithPersonAndApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/count/${params.credential}/application/${params.appId}`)
    return data.data
}

    
// 按条件对Work分页显示.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function workActionProcessingMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/processing/mockputtopost`, params)
    return data.data
}

    
// 列示指定应用不带权限区分的所有Work,下一页.
// id: String: 最后一个Work的ID
// count: Integer: 返回数量
// applicationFlag: String: 应用标识
// POST
export async function workActionCreateWithApplicationProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/application/${params.applicationFlag}/process/${params.processFlag}`, params)
    return data.data
}

    
// 列示根据过滤条件的Work,下一页.
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function workActionCreateWithApplicationProcessForce (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/application/${params.applicationFlag}/process/${params.processFlag}/force`, params)
    return data.data
}

    
// 列示指定应用不带权限区分的所有Work,上一页.
// id: String: 最后一个Work的ID
// count: Integer: 返回数量
// applicationFlag: String: 应用标识
// GET
export async function workActionListNextCreatorWithCurrent (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/next/${params.count}/creator/current`)
    return data.data
}

    
// 列示根据过滤条件的Work,上一页.
// id: String: 工作标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function workActionCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/count/application`)
    return data.data
}

    
// 列示关联的Work对象.
// id: String: 工作标识
// GET
export async function workActionListPrevWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/prev/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 分页列示指定应用下根据过滤条件的Work.
// page: Integer: 分页
// size: Integer: 每页数量
// applicationFlag: String: 应用标识
// GET
export async function workActionListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/count/application/${params.applicationFlag}/process`)
    return data.data
}

    
// 尝试流转一个Work.
// id: String: 工作标识
// POST
export async function workActionManageListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}/filter/manage`, params)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// POST
export async function workActionManageListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/next/${params.count}/application/${params.applicationFlag}/filter/manage`, params)
    return data.data
}

    
// 指定Work运行映射.
// id: String: 工作标识
// POST
export async function workActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/filter/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 取得指定work当前人员所有的task,taskCompleted,read,readCompleted,review
// id: String: 标识
// GET
export async function workActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/mockdeletetoget`)
    return data.data
}

    
// 将工作调度。
// id: String: 工作标识
// activityId: String: 活动标识
// activityType: ActivityType: 活动类型
// GET
export async function workActionGetWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 将工作调度。
// id: String: 工作标识
// activityId: String: 活动标识
// activityType: ActivityType: 活动类型
// GET
export async function workActionManageDeleteRelativeWorkMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/relative/manage/mockdeletetoget`)
    return data.data
}

    
// 将工作召回。
// id: String: 工作标识
// GET
export async function workActionManageDeleteSingleWorkMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/${params.id}/single/manage/mockdeletetoget`)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// GET
export async function workActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/next/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 回滚工作到指定的workLog
// id: String: 工作标识
// GET
export async function workActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// Mock Post To Put.
// id: String: 工作标识
// GET
export async function workActionListNextWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/work/list/${params.id}/next/${params.count}/process/${params.processFlag}`)
    return data.data
}

    
// 统计当前用户创建的WorkCompleted，按应用分类.
// GET
export async function workCompletedActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.id}`)
    return data.data
}

    
// 统计当前用户在指定应用下的WorkCompleted，按流程分类.
// applicationFlag: String: 应用标识
// POST
export async function workCompletedActionCreate (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/process/${params.processFlag}`, params)
    return data.data
}

    
// 创建已完成工作.
// processFlag: String: 流程标识
// PUT
export async function workCompletedActionRollback (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.flag}/rollback`, params)
    return data.data
}

    
// 获取用于过滤的可选属性值
// applicationFlag: String: 应用标识
// GET
export async function workCompletedActionFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/filter/attribute/application/${params.applicationFlag}`)
    return data.data
}

    
// 获取WorkCompleted.
// id: String: 标识
// POST
export async function workCompletedActionListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.id}/next/${params.count}/application/${params.applicationFlag}/filter`, params)
    return data.data
}

    
// 列示当前用户在指定的application下创建的WorkCompleted对象,下一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function workCompletedActionManageListPrev (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}/manage`)
    return data.data
}

    
// 根据过滤属性列示WorkCompleted,下一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// DELETE
export async function workCompletedActionManageDelete (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.id}/delete/manage`, params)
    return data.data
}

    
// 列示当前用户在指定的application下创建的WorkCompleted对象,上一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function workCompletedActionListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}/filter`, params)
    return data.data
}

    
// 根据过滤属性列示WorkCompleted,上一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function workCompletedActionManageListNext (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.id}/next/${params.count}/application/${params.applicationFlag}/manage`)
    return data.data
}

    
// 删除所有相关数据.
// id: String: 标识
// GET
export async function workCompletedActionManageGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.id}/manage`)
    return data.data
}

    
// Mock Get To Delete.
// id: String: 标识
// GET
export async function workCompletedActionCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/count/application/${params.applicationFlag}/process`)
    return data.data
}

    
// 获取用于过滤的可选属性值
// applicationFlag: String: 应用标识
// POST
export async function workCompletedActionManageListWithApplicationPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/paging/${params.page}/size/${params.size}/application/${params.applicationFlag}/filter/manage`, params)
    return data.data
}

    
// 获取工作内容.
// id: String: 标识
// GET
export async function workCompletedActionManageGetAssignment (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.id}/assignment/manage`)
    return data.data
}

    
// 列示指定Work下所有的待办已办,待阅已阅和参阅.
// id: String: 标识
// GET
export async function workCompletedActionManageFilterAttribute (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/filter/attribute/application/${params.applicationFlag}/manage`)
    return data.data
}

    
// 列示指定application下根据porcess分类的workCompleted数量.
// applicationFlag: String: 应用标识
// POST
export async function workCompletedActionRollbackMockPutToPost (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.flag}/rollback/mockputtopost`, params)
    return data.data
}

    
// 按条件对WorkCompleted分页显示.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function workCompletedActionManageListCountWithProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/count/application/${params.applicationFlag}/process/manage`)
    return data.data
}

    
// 如果是xadmin或者是ProcessPlatformManager或Manager角色那么显示这个应用下的所有WorkCompleted,如果是Process的管理员,那么显示Process下的WorkCompleted.下一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function workCompletedActionCountWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/count/application`)
    return data.data
}

    
// 列示根据过滤条件的WorkCompleted,下一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// GET
export async function workCompletedActionManageDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/${params.id}/delete/manage/mockdeletetoget`)
    return data.data
}

    
// 列示当前用户创建的WorkCompleted对象,上一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function workCompletedActionManageListPrevWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/filter/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}`, params)
    return data.data
}

    
// 列示根据过滤条件的WorkCompleted,上一页.
// id: String: 标识
// count: Integer: 数量
// applicationFlag: String: 应用标识
// POST
export async function workCompletedActionManageListNextWithFilter (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.id}/next/${params.count}/application/${params.applicationFlag}/filter/manage`, params)
    return data.data
}

    
// 分页列示指定应用下根据过滤条件的WorkCompleted.
// page: Integer: 分页
// size: Integer: 每页数量
// applicationFlag: String: 应用标识
// POST
export async function workCompletedActionManageListFilterPaging (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/filter/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 完成工作重新回滚.
// flag: String: 流程标识
// GET
export async function workCompletedActionListNextWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.id}/next/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// Mock Post To Put.
// flag: String: 流程标识
// GET
export async function workCompletedActionListPrevWithApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/workcompleted/list/${params.id}/prev/${params.count}/application/${params.applicationFlag}`)
    return data.data
}

    
// 获取工作或完成工作可回滚的工作日志.
// workId: String: 工作标识
// GET
export async function workLogActionListWithJob (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/worklog/list/job/${params.job}`)
    return data.data
}

    
// 获取工作或完成工作可回滚的工作日志.
// workOrWorkCompleted: String: 工作或已完成工作标识
// GET
export async function workLogActionListWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/worklog/list/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 根据指定job获取工作日志.
// job: String: 任务标识
// GET
export async function workLogActionListRollbackWithWorkOrWorkCompleted (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/worklog/list/rollback/workorworkcompleted/${params.workOrWorkCompleted}`)
    return data.data
}

    
// 根据指定Work或者WorkCompleted获取工作日志.
// workOrWorkCompleted: String: 工作或已完成工作标识
// GET
export async function workLogActionListAddSplitWithWork (params) {
    const {data} = await request(`/x_processplatform_assemble_surface/jaxrs/worklog/list/add/split/work/${params.workId}`)
    return data.data
}

    