
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/cache/config/flush`)
    return data.data
}

    
// 全平台设计搜索.
// POST
export async function designActionSearch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/design/search`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 目录中索引数量,category,type,key为空统计search目录数量.
// POST
export async function indexActionDirectoryDocumentCount (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/index/directory/document/count`, params)
    return data.data
}

    
// 创建用于学习的数据集.
// modelFlag: String: 模型标识
// GET
export async function neuralActionListCalculateWithWork (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/list/calculate/model/${params.modelFlag}/work/${params.workId}`)
    return data.data
}

    
// 学习.
// modelFlag: String: 模型标识
// GET
export async function neuralActionLearn (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/learn/model/${params.modelFlag}`)
    return data.data
}

    
// 计算输入工作ID进行计算.
// modelFlag: String: 模型标识
// workId: String: 工作标识
// GET
export async function neuralActionStopLearning (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/stop/learning/model/${params.modelFlag}`)
    return data.data
}

    
// 停止数据生成.
// modelFlag: String: 项目标识
// GET
export async function neuralActionStopGenerating (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/stop/generating/model/${params.modelFlag}`)
    return data.data
}

    
// 停止学习.
// modelFlag: String: 模型标识
// GET
export async function neuralActionGenerate (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/neural/generate/model/${params.modelFlag}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/openapi`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 指定表中插入行.
// flag: String: 标识
// GET
export async function tableActionReloadDynamic (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/table/reload/dynamic`)
    return data.data
}

    
// 在服务器重新编译dynamicEntity之后需要重新初始化EntityManagerContainerFactory.
// POST
export async function tableActionUpdateWithBundle (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/table/${params.flag}/update/${params.bundle}`, params)
    return data.data
}

    
// 更新指定表中的行.
// flag: String: 标识
// bundle: String: 数据行标识
// POST
export async function tableActionInsert (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/table/${params.flag}/insert`, params)
    return data.data
}

    
// 重置文档高频索引定时任务状态,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionHighFreqDocumentTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/document/node/${params.node}/touch`)
    return data.data
}

    
// 执行文档高频索引,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionLowFreqWorkCompletedTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/workcompleted/node/${params.node}/touch`)
    return data.data
}

    
// 重置已完成工作高频索引定时任务状态,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionHighFreqWorkCompletedTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/workcompleted/node/${params.node}/touch`)
    return data.data
}

    
// 执行已完成工作高频索引,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionHighFreqWorkCompletedReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/workcompleted/node/${params.node}/reset`)
    return data.data
}

    
// 重置在流转工作高频索引定时任务状态,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionLowFreqWorkCompletedReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/workcompleted/node/${params.node}/reset`)
    return data.data
}

    
// 执行在流转工作高频索引,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionHighFreqDocumentReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/document/node/${params.node}/reset`)
    return data.data
}

    
// 重置文档低频索引定时任务状态,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionLowFreqDocumentTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/document/node/${params.node}/touch`)
    return data.data
}

    
// 执行文档低频索引,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionLowFreqDocumentReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/document/node/${params.node}/reset`)
    return data.data
}

    
// 重置已完成工作低频索引定时任务状态,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionOptimizeIndex (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/optimize/index/${params.node}/touch`)
    return data.data
}

    
// 执行已完成工作低频索引,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionHighFreqWorkReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/work/node/${params.node}/reset`)
    return data.data
}

    
// 重置在流转工作低频索引定时任务状态,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionLowFreqWorkTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/work/node/${params.node}/touch`)
    return data.data
}

    
// 执行在流转工作低频索引,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionHighFreqWorkTouch (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/high/freq/work/node/${params.node}/touch`)
    return data.data
}

    
// 执行优化索引,(0)表示在所有节点上执行.
// node: String: 节点
// GET
export async function touchActionLowFreqWorkReset (params) {
    const {data} = await request(`/x_query_service_processing/jaxrs/touch/low/freq/work/node/${params.node}/reset`)
    return data.data
}

    