import os
import json


def lower_first_letter(text):
    """
    将字符串第一个字母小写
    """
    return text[0].lower() + text[1:]


def capitalize_first_letter(text):
    """
    将字符串第一个字母大写
    """
    return text[0].upper() + text[1:]

dir_path = "json"
json_data = {}
for subdir in os.listdir(dir_path):
    subdir_path = os.path.join(dir_path, subdir)
    
    api_json_path = os.path.join(subdir_path, "api.json")
    describe_json_path = os.path.join(subdir_path, "describe.json")
    
    with open(api_json_path, 'r', encoding='utf-8') as f:
        api_json = json.load(f)
        
    with open(describe_json_path, 'r', encoding='utf-8') as f: 
        describe_json = json.load(f)
        
    json_data = {
        "name": subdir,
        "api": api_json,
        "describe": describe_json
    }
    
    with open(f'./js/{subdir}.js', 'w', encoding='utf-8') as f:
        for (index_i, jaxr) in enumerate(json_data["api"]["jaxrs"]):
            # print(jaxr["name"])
            jaxr_name = jaxr["name"]
            for (index_j, method) in enumerate(jaxr["methods"]):
                # print(method["name"])
                method_name = method["name"]
                method_method: str = method["method"]

                function_name = lower_first_letter(jaxr_name) + capitalize_first_letter(method_name)
                # print(function_name)
                uri = method["uri"].replace("{", "${params.").replace("}", "}")

                describe = json_data["describe"]["jaxrs"][index_i]["methods"][index_j]
                parmeters = ""
                parmeters += f"// {describe['description']}"
                for parameter in describe["pathParameters"]:
                    parmeters += f"\n// {parameter['name']}: {parameter['type']}: {parameter['description']}"

                content = """
{parameters}
// {method_method}
export async function {function_name} (params) {{
    const {{data}} = await request({url}{params})
    return data.data
}}

    """.format(parameters=parmeters,
            method_method=method_method,
            function_name=function_name, 
            data="params", 
            url=f"`/{subdir}/{uri}`", 
            params="" if method_method.upper() == "GET" else ", params")

                f.write(content)

