
// 流程结束后回填数据.
// id: String: 申诉数据ID
// POST
export async function appealInfoActionManagerListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/list/manager/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 申诉数据获取.
// id: String: 申诉数据ID
// POST
export async function appealInfoActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 分页查询当前用户的申诉数据列表.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function appealInfoActionManagerSetNormal (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.id}/manager/status`)
    return data.data
}

    
// 管理员查询申诉数据列表.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function appealInfoActionStartCheck (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.id}/start/check`)
    return data.data
}

    
// 管理员处理异常数据为正常.
// id: String: 申诉数据ID
// POST
export async function appealInfoActionStartProcess (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.id}/start/process`, params)
    return data.data
}

    
// 还原数据状态，清除流程关联.
// id: String: 申诉数据ID
// GET
export async function appealInfoActionResetStatus (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.id}/reset/status`)
    return data.data
}

    
// 检查是否能够申诉.
// id: String: 申诉数据ID
// POST
export async function appealInfoActionEndProcess (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.id}/end/process`, params)
    return data.data
}

    
// 启动流程后修改状态.
// id: String: 申诉数据ID
// GET
export async function appealInfoActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/appeal/${params.id}`)
    return data.data
}

    
// 根据ID删除考勤管理员信息
// id: String: 考勤管理员配置信息ID
// POST
export async function attendanceAdminActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceadmin`, params)
    return data.data
}

    
// 根据ID获取指定的考勤管理员信息
// id: String: 考勤管理员配置信息ID
// GET
export async function attendanceAdminActionListAllAttendanceAdmin (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceadmin/list/all`)
    return data.data
}

    
// 获取所有的考勤管理员信息
// GET
export async function attendanceAdminActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceadmin/${params.id}`)
    return data.data
}

    
// 新建或者更新考勤管理员信息
// DELETE
export async function attendanceAdminActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceadmin/${params.id}`, params)
    return data.data
}

    
// 根据ID对考勤申诉信息进行归档
// id: String: 考勤申诉信息ID
// PUT
export async function attendanceAppealInfoActionAudit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/audit`, params)
    return data.data
}

    
// 根据ID列表对考勤申诉信息进行审核操作, 参数：ids(申诉ID列表)，opinion(审核意见)， status(审核状态:1-通过;2-需要进行复核;-1-不通过)
// GET
export async function attendanceAppealInfoActionArchive (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/archive/${params.id}`)
    return data.data
}

    
// 根据ID列表对考勤申诉信息进行复核操作, 参数：ids(申诉ID列表)，opinion2(审核意见)， status(审核状态:1-通过;-1-不通过)
// PUT
export async function attendanceAppealInfoActionListNextWithFilterWithManager (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/manager/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 根据ID对考勤结果申诉信息提起申诉
// id: String: 考勤申诉信息ID
// PUT
export async function attendanceAppealInfoActionListNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/filter/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 根据ID对考勤结果申诉信息提起申诉流程
// id: String: 考勤打卡记录ID
// PUT
export async function attendanceAppealInfoActionListPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/filter/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 根据ID删除考勤结果申诉信息
// id: String: 考勤申诉信息ID
// PUT
export async function attendanceAppealInfoActionSyncWithWork (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/workflow/sync`, params)
    return data.data
}

    
// 根据ID获取考勤结果申诉信息
// id: String: 考勤申诉信息ID
// PUT
export async function attendanceAppealInfoActionCreateWithWorkFlow (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/workflow/appeal/${params.id}`, params)
    return data.data
}

    
// 根据根据过滤条件对考勤申诉信息进行下一页查询
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量
// GET
export async function attendanceAppealInfoActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/${params.id}`)
    return data.data
}

    
// 根据根据过滤条件对考勤申诉信息进行下一页查询(带权限)
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量
// DELETE
export async function attendanceAppealInfoActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/${params.id}`, params)
    return data.data
}

    
// 根据根据过滤条件对考勤申诉信息进行上一页查询
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量
// PUT
export async function attendanceAppealInfoActionCheck (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/check `, params)
    return data.data
}

    
// 根据考勤申诉ID，更新申诉审核流程的审批信息以及最终审核状态
// PUT
export async function attendanceAppealInfoActionCreate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceappealInfo/appeal/${params.id}`, params)
    return data.data
}

    
// 分析打卡数据
// id: String: 移动考勤打卡信息ID
// GET
export async function attendanceDetailActionListAttendanceDetailByBatchName (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/list/${params.file_id}`)
    return data.data
}

    
// 分析打卡数据
// startDate: String: 开始日期
// endDate: String: 结束日期
// PUT
export async function attendanceDetailActionListUserAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/user`, params)
    return data.data
}

    
// 分析打卡数据（指定人员）
// PUT
export async function attendanceDetailActionListUnitAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/unit`, params)
    return data.data
}

    
// 将指定的打卡记录归档
// id: String: 移动考勤打卡信息ID
// PUT
export async function attendanceDetailActionListTopUnitAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/topUnit`, params)
    return data.data
}

    
// 根据周期的年份月份，以及需要考勤人员的名单，检查人员在周期内每天的考核数据是否存在，如果不存在，则进行补齐
// cycleYear: String: 统计周期年份
// cycleMonth: String: 统计周期月份
// GET
export async function attendanceDetailActionAnalyseAttendanceDetails (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/analyse/${params.startDate}/${params.endDate}`)
    return data.data
}

    
// 根据ID删除打卡信息记录
// id: String: 移动考勤打卡信息ID
// POST
export async function attendanceDetailActionAnalyseAttendanceDetailsForce (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/analyse`, params)
    return data.data
}

    
// 根据ID获取考勤打卡信息
// id: String: 移动考勤打卡信息ID
// GET
export async function attendanceDetailActionArchiveAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/archive/${params.id}`)
    return data.data
}

    
// 获取指定年月的打卡数据列表
// PUT
export async function attendanceDetailActionListNeedSignPersons (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/list/persons/nonesign`, params)
    return data.data
}

    
// 获取数据库中指定导入文件名称的数据列表
// file_id: String: 导入文件信息ID
// GET
export async function attendanceDetailActionCheckDetailWithPersonByCycle (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/checkDetailWithPersonByCycle/${params.cycleYear}/${params.cycleMonth}`)
    return data.data
}

    
// 列示在截止时间仍未打卡的员工列表
// PUT
export async function attendanceDetailActionListAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list`, params)
    return data.data
}

    
// 列示符合过滤条件的打卡记录归档
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量
// GET
export async function attendanceDetailActionAnalyseAttendanceDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/analyse/id/${params.id}`)
    return data.data
}

    
// 列示符合过滤条件的打卡记录归档
// id: String: 最后一条信息ID
// count: Integer: 每页显示的条目数量
// PUT
export async function attendanceDetailActionListNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 获取顶层组织指定年月的打卡数据列表
// PUT
export async function attendanceDetailActionListPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/filter/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 获取组织指定年月的打卡数据列表
// POST
export async function attendanceDetailActionReciveSingle (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/reciveSingle`, params)
    return data.data
}

    
// 获取用户指定年月的打卡数据列表
// POST
export async function attendanceDetailActionRecive (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/recive`, params)
    return data.data
}

    
// 重新分析指定年月的打卡数据
// PUT
export async function attendanceDetailActionReAnalyseDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/analyse/redo`, params)
    return data.data
}

    
// 接入完整的打卡信息记录，接入完成后直接分析
// GET
export async function attendanceDetailActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/${params.id}`)
    return data.data
}

    
// 部分更新打卡记录，接入完成后直接分析
// DELETE
export async function attendanceDetailActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/${params.id}`, params)
    return data.data
}

    
// 获取指定导入文件的操作状态
// file_id: String: 导入文件信息ID
// GET
export async function attendanceDetailFileImportActionGetStatus (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/fileimport/getStatus/${params.file_id}`)
    return data.data
}

    
// 获取系统的导入文件操作状态
// GET
export async function attendanceDetailFileImportActionGetStatusDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/fileimport/getStatus/${params.file_id}/detail`)
    return data.data
}

    
// 获取指定导入文件的操作状态，包括检查数据列表
// file_id: String: 导入文件信息ID
// GET
export async function attendanceDetailFileImportActionGetStatusAll (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/fileimport/getStatus/all`)
    return data.data
}

    
// 根据ID删除移动打卡信息
// id: String: 移动考勤打卡信息ID
// PUT
export async function attendanceDetailMobileActionListDataForMobile (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/filter/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 根据ID获取移动打卡信息记录
// id: String: 移动考勤打卡信息ID
// GET
export async function attendanceDetailMobileActionMobilePreview (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/mobilepreview`)
    return data.data
}

    
// 移动打卡信息记录明细查询
// page: Integer: 需要显示的页码
// count: Integer: 每页需要显示的条目数量
// POST
export async function attendanceDetailMobileActionReciveForMobile (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/recive`, params)
    return data.data
}

    
// 查询登录者当天的所有移动打卡信息记录
// GET
export async function attendanceDetailMobileActionListMyRecords (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/my`)
    return data.data
}

    
// 预打卡，根据当前人以及对应的排班设置，给出打卡的预判断
// GET
export async function attendanceDetailMobileActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/${params.id}`)
    return data.data
}

    
// 移动打卡信息接入，移动端特点，会多次接入，部分接入，一次接入的信息不完整，接入完成后不直接进行分析
// DELETE
export async function attendanceDetailMobileActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancedetail/mobile/${params.id}`, params)
    return data.data
}

    
// 根据ID删除考勤人员配置信息
// id: String: 考勤人员配置信息ID
// POST
export async function attendanceEmployeeConfigActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceemployeeconfig`, params)
    return data.data
}

    
// 根据ID获取考勤人员配置信息
// id: String: 考勤人员配置信息ID
// GET
export async function attendanceEmployeeConfigActionListAllAttendanceEmployeeConfig (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceemployeeconfig/list/all`)
    return data.data
}

    
// 获取所有考勤人员配置信息
// GET
export async function attendanceEmployeeConfigActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceemployeeconfig/${params.id}`)
    return data.data
}

    
// 新建或者更新考勤人员配置信息
// DELETE
export async function attendanceEmployeeConfigActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceemployeeconfig/${params.id}`, params)
    return data.data
}

    
// 根据ID删除已经上传成功的文件以及文件信息
// id: String: 导入文件信息ID
// GET
export async function attendanceImportFileInfoActionListAllAttendanceImportFileInfo (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceimportfileinfo/list/all`)
    return data.data
}

    
// 根据ID获取已经上传成功的文件信息
// id: String: 导入文件信息ID
// GET
export async function attendanceImportFileInfoActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceimportfileinfo/${params.id}`)
    return data.data
}

    
// 获取所有已经上传成功的文件列表
// DELETE
export async function attendanceImportFileInfoActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceimportfileinfo/${params.id}`, params)
    return data.data
}

    
// 根据ID删除考勤时间配置信息
// id: String: 考勤时间配置信息ID
// POST
export async function attendanceScheduleSettingActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting`, params)
    return data.data
}

    
// 根据ID获取考勤时间配置信息
// id: String: 考勤时间配置信息ID
// GET
export async function attendanceScheduleSettingActionListAllAttendanceScheduleSetting (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/list/all`)
    return data.data
}

    
// 获取所有考勤时间配置信息列表
// GET
export async function attendanceScheduleSettingActionListAttendanceScheduleSettingByTopUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/list/topUnit/${params.name}`)
    return data.data
}

    
// 根据顶层组织名称获取所有考勤时间配置信息列表
// name: String: 顶层组织名称
// GET
export async function attendanceScheduleSettingActionListAttendanceScheduleSettingByUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/list/unit/${params.name}`)
    return data.data
}

    
// 根据组织名称获取所有考勤时间配置信息
// name: String: 组织名称
// GET
export async function attendanceScheduleSettingActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/${params.id}`)
    return data.data
}

    
// 新建或者更新考勤时间配置信息
// DELETE
export async function attendanceScheduleSettingActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceschedulesetting/${params.id}`, params)
    return data.data
}

    
// 根据ID删除员工休假申请信息信息
// id: String: 员工请假信息ID
// POST
export async function attendanceSelfHolidayActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday`, params)
    return data.data
}

    
// 获取所有员工休假申请信息信息
// GET
export async function attendanceSelfHolidayActionListAllAttendanceSelfHoliday (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday/list/all`)
    return data.data
}

    
// 列示满足过滤条件员工休假申请信息信息，下一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示的条目数量
// PUT
export async function attendanceSelfHolidayActionListNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday/filter/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示满足过滤条件员工休假申请信息信息，上一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示的条目数量
// PUT
export async function attendanceSelfHolidayActionListPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday/filter/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 新建或者更新员工休假申请信息
// DELETE
export async function attendanceSelfHolidayActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceselfholiday/${params.id}`, params)
    return data.data
}

    
// 根据流程文档ID删除员工休假申请数据对象
// docId: String: 文档标识
// POST
export async function attendanceSelfHolidaySimpleActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/selfholidaysimple`, params)
    return data.data
}

    
// 新建或者更新员工休假申请信息
// DELETE
export async function attendanceSelfHolidaySimpleActionDeleteByWfDocId (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/selfholidaysimple/docId/${params.docId}`, params)
    return data.data
}

    
// 根据ID删除系统配置信息
// id: String: 系统配置信息ID
// GET
export async function attendanceSettingActionListAllAttendanceSetting (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/list/all`)
    return data.data
}

    
// 是否启用钉钉考勤或企业微信考勤
// GET
export async function attendanceSettingActionEnableType (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/enable/type`)
    return data.data
}

    
// 根据ID获取系统配置信息
// id: String: 系统配置信息ID
// GET
export async function attendanceSettingActionGetWithCode (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/code/${params.code}`)
    return data.data
}

    
// 根据Code获取系统配置信息
// code: String: 系统配置信息编码
// GET
export async function attendanceSettingActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/${params.id}`)
    return data.data
}

    
// 获取所有系统配置信息列表
// DELETE
export async function attendanceSettingActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting/${params.id}`, params)
    return data.data
}

    
// 新建或者更新系统配置信息
// POST
export async function attendanceSettingActionSave (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancesetting`, params)
    return data.data
}

    
// 驱动系统主动进行一次数据统计
// GET
export async function attendanceStatisticActionDoStatistic (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statistic/do`)
    return data.data
}

    
// 根据ID删除考勤统计需求信息
// id: String: 统计需求信息ID
// POST
export async function attendanceStatisticRequireLogActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticrequirelog`, params)
    return data.data
}

    
// 根据ID获取考勤统计需求信息
// id: String: 统计需求信息ID
// GET
export async function attendanceStatisticRequireLogActionListAllAttendanceStatisticRequireLog (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticrequirelog/list/all`)
    return data.data
}

    
// 获取所有考勤统计需求信息
// GET
export async function attendanceStatisticRequireLogActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticrequirelog/${params.id}`)
    return data.data
}

    
// 新建或者更新考勤统计需求信息
// DELETE
export async function attendanceStatisticRequireLogActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticrequirelog/${params.id}`, params)
    return data.data
}

    
// 列示根据过滤条件的顶层组织每日统计数据,下一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// PUT
export async function attendanceStatisticShowActionListStmForPersonPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/personMonth/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 列示根据过滤条件的顶层组织每日统计数据,上一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// PUT
export async function attendanceStatisticShowActionListStdForUnitNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/unitDay/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示根据过滤条件的组织每日统计数据,下一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// GET
export async function attendanceStatisticShowActionShowStForUnitInTopUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/topUnit/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 列示根据过滤条件的组织每日统计数据,上一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// GET
export async function attendanceStatisticShowActionShowStForPersonInUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/persons/unit/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 列示根据过滤条件的个人月份统计数据,下一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// GET
export async function attendanceStatisticShowActionShowStmForUnitSubnested (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/subnested/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 列示根据过滤条件的个人月份统计数据,上一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// GET
export async function attendanceStatisticShowActionShowStdForUnitInTopUnitWithDate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/day/topUnit/${params.name}/${params.date}`)
    return data.data
}

    
// 列示根据过滤条件的顶层组织月份统计数据,下一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// PUT
export async function attendanceStatisticShowActionListStmForPersonNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/personMonth/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示根据过滤条件的顶层组织月份统计数据,上一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// PUT
export async function attendanceStatisticShowActionListStmForUnitNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/unitMonth/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示根据过滤条件的组织月份统计数据,下一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// PUT
export async function attendanceStatisticShowActionListStmForTopUnitNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/topUnitMonth/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 列示根据过滤条件的组织月份统计数据,上一页
// id: String: 上一页最后一条信息ID
// count: Integer: 每页显示信息条目数量
// PUT
export async function attendanceStatisticShowActionListStdForUnitPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/unitDay/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 查询指定组织所有员工指定月份的统计数据
// name: String: 统计员工姓名
// year: String: 统计周期年份
// month: String: 统计周期月份
// GET
export async function attendanceStatisticShowActionShowStForPersonInUnitSubNested (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/persons/unit/subnested/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 查询指定组织所有员工指定月份的统计数据，包括下级组织
// name: String: 统计员工姓名
// year: String: 统计周期年份
// month: String: 统计周期月份
// GET
export async function attendanceStatisticShowActionShowStdForUnitWithDate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/day/${params.name}/${params.date}`)
    return data.data
}

    
// 查询顶层组织指定月份的统计数据
// name: String: 统计顶层组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// PUT
export async function attendanceStatisticShowActionListStmForTopUnitPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/topUnitMonth/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 查询顶层组织指定月份每日的统计数据
// name: String: 统计顶层组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// PUT
export async function attendanceStatisticShowActionListStdForTopUnitNextWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/topUnitDay/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 查询组织指定月份每日的统计数据
// name: String: 统计组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// PUT
export async function attendanceStatisticShowActionListStdForTopUnitPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/topUnitDay/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 查询组织指定日期的统计数据
// name: String: 统计组织名称
// date: String: 统计日期
// PUT
export async function attendanceStatisticShowActionListStmForUnitPrevWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/filter/unitMonth/list/${params.id}/prev/${params.count}`, params)
    return data.data
}

    
// 查询组织指定日期的统计数据
// name: String: 统计组织名称
// date: String: 统计日期
// GET
export async function attendanceStatisticShowActionShowStdForUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/day/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 查询员工指定月份的统计数据
// name: String: 统计员工姓名
// year: String: 统计周期年份
// month: String: 统计周期月份
// GET
export async function attendanceStatisticShowActionShowStmForPerson (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/person/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 查询顶层组织指定月份的统计数据
// name: String: 统计顶层组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// GET
export async function attendanceStatisticShowActionShowStmForUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 查询组织指定月份的统计数据
// name: String: 统计组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// GET
export async function attendanceStatisticShowActionSumUnitStatistic (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/unit/sum/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 查询组织指定月份的统计数据
// name: String: 统计组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// GET
export async function attendanceStatisticShowActionShowStmForTopUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/topUnit/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 查询组织指定月份的统计数据
// name: String: 统计组织名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// GET
export async function attendanceStatisticShowActionShowStdForTopUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/statisticshow/topUnit/day/${params.name}/${params.year}/${params.month}`)
    return data.data
}

    
// 根据登录的用户查询合适的考勤统计周期信息
// year: String: 统计年份
// month: String: 统计月份
// POST
export async function attendanceStatisticalCycleActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle`, params)
    return data.data
}

    
// 根据ID删除考勤统计周期信息
// id: String: 统计周期信息ID
// GET
export async function attendanceStatisticalCycleActionListAllAttendanceStatisticalCycle (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle/list/all`)
    return data.data
}

    
// 根据ID获取考勤统计周期信息
// id: String: 统计周期信息ID
// GET
export async function attendanceStatisticalCycleActionCycleDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle/cycleDetail/${params.year}/${params.month}`)
    return data.data
}

    
// 获取所有考勤统计周期信息
// GET
export async function attendanceStatisticalCycleActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle/${params.id}`)
    return data.data
}

    
// 新建或者更新考勤统计周期信息
// DELETE
export async function attendanceStatisticalCycleActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendancestatisticalcycle/${params.id}`, params)
    return data.data
}

    
// 根据ID删除节假日配置信息
// id: String: 节假日配置信息ID
// POST
export async function attendanceWorkDayConfigActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig`, params)
    return data.data
}

    
// 根据ID获取节假日配置信息
// id: String: 节假日配置信息ID
// GET
export async function attendanceWorkDayConfigActionListAllAttendanceWorkDayConfig (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig/list/all`)
    return data.data
}

    
// 获取所有节假日配置列表信息
// PUT
export async function attendanceWorkDayConfigActionListWithFilter (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig/filter`, params)
    return data.data
}

    
// 根据条件获取节假日配置列表
// GET
export async function attendanceWorkDayConfigActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig/${params.id}`)
    return data.data
}

    
// 新建或者更新节假日配置信息
// DELETE
export async function attendanceWorkDayConfigActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/attendanceworkdayconfig/${params.id}`, params)
    return data.data
}

    
// 根据ID删除指定工作区域信息
// id: String: 工作区域配置信息ID
// POST
export async function attendanceWorkPlaceActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/workplace`, params)
    return data.data
}

    
// 根据ID获取指定工作区域信息
// id: String: 工作区域配置信息ID
// GET
export async function attendanceWorkPlaceActionListAllAttendanceWorkPlace (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/workplace/list/all`)
    return data.data
}

    
// 获取所有工作区域信息列表
// GET
export async function attendanceWorkPlaceActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/workplace/${params.id}`)
    return data.data
}

    
// 新建或者更新工作区域信息
// DELETE
export async function attendanceWorkPlaceActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/workplace/${params.id}`, params)
    return data.data
}

    
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/cache/config/flush`)
    return data.data
}

    
// 配置信息.
// POST
export async function configActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/config`, params)
    return data.data
}

    
// 个人配置信息.
// GET
export async function configActionGetPersonConfig (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/config/person`)
    return data.data
}

    
// 保存配置信息.
// POST
export async function configActionPostPersonConfig (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/config/person`, params)
    return data.data
}

    
// 保存个人配置信息.
// GET
export async function configActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/config`)
    return data.data
}

    
// 分页查询考勤信息列表.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function detailActionRecordList (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/statistic/${params.detailId}/list/record`)
    return data.data
}

    
// 重新生成考勤信息，人员: 人员DN，日期: yyyy-MM-dd.
// person: String: 人员
// date: String: 日期：yyyy-MM-dd
// POST
export async function detailActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 根据统计id查询相关的打卡记录列表.
// detailId: String: detail 统计 id
// GET
export async function detailActionStatisticExport (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/statistic/export/filter/${params.filter}/start/${params.start}/end/${params.end}`)
    return data.data
}

    
// 统计查询.
// GET
export async function detailActionRebuild (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/rebuild/person/${params.person}/date/${params.date}/`)
    return data.data
}

    
// 统计导出.
// filter: String: 人员或组织的DN，组织会递归下面所有的人员，如xxx@xxx@P、xxx@xxx@U
// start: String: 开始日期：yyyy-MM-dd
// end: String: 结束日期：yyyy-MM-dd
// POST
export async function detailActionStatistic (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/detail/statistic/filter`, params)
    return data.data
}

    
// 删除所有打卡数据
// PUT
export async function dingdingAttendanceActionListNextDingdingAttendance (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/attendance/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 查询钉钉同步记录信息
// GET
export async function dingdingAttendanceActionListDingdingSyncRecord (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/sync/list`)
    return data.data
}

    
// 查询钉钉打卡结果
// id: String: 最后一条数据ID
// count: Integer: 每页显示的条目数量
// DELETE
export async function dingdingAttendanceActionDeleteAllData (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/all`, params)
    return data.data
}

    
// 钉钉考勤全部个人数据统计
// year: String: 年份: yyyy
// month: String: 月份: MM
// GET
export async function dingdingAttendanceActionSyncData (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/sync/from/${params.dateFrom}/to/${params.dateTo}/start`)
    return data.data
}

    
// 钉钉考勤全部组织数据统计
// year: String: 年份: yyyy
// month: String: 月份: MM
// day: String: 日期: dd
// GET
export async function dingdingAttendanceActionStatisticPerson (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/statistic/person/year/${params.year}/month/${params.month}`)
    return data.data
}

    
// 同步钉钉考勤结果
// dateFrom: String: 开始时间: yyyy-MM-dd
// dateTo: String: 结束时间: yyyy-MM-dd
// GET
export async function dingdingAttendanceActionStatisticUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingding/statistic/unit/year/${params.year}/month/${params.month}/day/${params.day}`)
    return data.data
}

    
// 人员月份统计查询
// person: String: 人员
// year: String: 年份: yyyy
// month: String: 月份: MM
// GET
export async function dingdingAttendanceStatisticActionPersonMonthWithUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingdingstatistic/person/unit/${params.unit}/${params.year}/${params.month}`)
    return data.data
}

    
// 根据部门查询人员月份统计
// unit: String: 部门
// year: String: 年份: yyyy
// month: String: 月份: MM
// GET
export async function dingdingAttendanceStatisticActionPersonMonth (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingdingstatistic/person/${params.person}/${params.year}/${params.month}`)
    return data.data
}

    
// 部门月份统计查询
// unit: String: 部门
// year: String: 年份: yyyy
// month: String: 月份: MM
// GET
export async function dingdingAttendanceStatisticActionUnitMonth (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/dingdingstatistic/unit/${params.unit}/${params.year}/${params.month}`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/echo`)
    return data.data
}

    
// 按指定月份导出非正常打卡数据,设定是否使用stream输出
// year: String: 年份
// month: String: 月份
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// POST
export async function fileImportExportActionUpload (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/upload`, params)
    return data.data
}

    
// 导出符合过滤条件的打卡记录明细
// q_topUnitName: String: 公司,为空时输入0
// q_unitName: String: 部门,为空时输入0
// q_empName: String: 员工,为空时输入0
// cycleYear: String: 统计周期年份,为空时输入0
// cycleMonth: String: 统计周期月份,为空时输入0
// q_date: String: 统计具体日期,为空时输入0
// isAbsent: String: 是否缺勤,为空时输入0
// isLackOfTime: String: 是否工时不足,为空时输入0
// isLate: String: 是否迟到,为空时输入0
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function fileImportExportActionTopunitStatisticExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/topunit/${params.name}/${params.year}/${params.month}/stream/${params.stream}`)
    return data.data
}

    
// 导出原始打卡记录
// cycleYear: String: 统计周期年份,为空时输入0
// cycleMonth: String: 统计周期月份,为空时输入0
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function fileImportExportActionSelfHolidayExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/selfholiday/${params.startdate}/${params.enddate}/stream/${params.stream}`)
    return data.data
}

    
// 根据文件ID下载附件,设定是否使用stream输出
// id: String: 文件标识
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function fileImportExportActionUnitStatisticExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/unit/${params.name}/${params.year}/${params.month}/stream/${params.stream}`)
    return data.data
}

    
// 导出个人出勤率统计记录,设定是否使用stream输出
// name: String: 统计员工姓名
// year: String: 统计周期年份
// month: String: 统计周期月份
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function fileImportExportActionPersonStatisticExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/person/${params.name}/${params.year}/${params.month}/stream/${params.stream}`)
    return data.data
}

    
// 按时间区间导出请假数据,设定是否使用stream输出
// startdate: String: 开始时间
// enddate: String: 结束时间
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function fileImportExportActionDetailsSourceExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/source/${params.cycleYear}/${params.cycleMonth}/stream/${params.stream}`)
    return data.data
}

    
// 导出公司出勤率统计记录,设定是否使用stream输出
// name: String: 统计公司名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function fileImportExportActionAbnormalDetailsExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/abnormaldetails/year/${params.year}/month/${params.month}/stream/${params.stream}`)
    return data.data
}

    
// 导出部门出勤率统计记录,设定是否使用stream输出
// name: String: 统计部门名称
// year: String: 统计周期年份
// month: String: 统计周期月份
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function fileImportExportActionDetailsExportStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/export/filter/${params.q_topUnitName}/${params.q_unitName}/${params.q_empName}/${params.cycleYear}/${params.cycleMonth}/${params.q_date}/${params.isAbsent}/${params.isLackOfTime}/${params.isLate}/stream/${params.stream}`)
    return data.data
}

    
// 上传需要导入的数据文件XLS
// GET
export async function fileImportExportActionFileDownloadStream (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/file/download/${params.id}/stream/${params.stream}`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 创建或更新考勤组信息.
// GET
export async function groupActionRebuildDetail (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/rebuild/detail/group/${params.groupId}/date/${params.date}`)
    return data.data
}

    
// 删除考勤组.
// id: String: 考勤组ID
// GET
export async function groupActionRefreshParticipate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/${params.id}/refresh/participate`)
    return data.data
}

    
// 获取考勤组对象.
// id: String: 考勤组ID
// POST
export async function groupActionCreateOrUpdate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group`, params)
    return data.data
}

    
// 分页查询考勤组列表.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function groupActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 当前考勤组重新生成某一天的考勤数据.
// groupId: String: 考勤组ID
// date: String: 日期: yyyy-MM-dd
// GET
export async function groupActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/${params.id}`)
    return data.data
}

    
// 刷新考勤组.
// id: String: 考勤组ID
// GET
export async function groupActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/group/${params.id}/delete`)
    return data.data
}

    
// 删除请假数据信息.
// id: String: 请假数据Id
// GET
export async function leaveActionGetResult (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/import/result/flag/${params.flag}`)
    return data.data
}

    
// 获取导入人员结果.
// flag: String: 导入文件返回的结果标记
// GET
export async function leaveActionTemplate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/template`)
    return data.data
}

    
// 上传Excel导入请假数据.
// POST
export async function leaveActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave`, params)
    return data.data
}

    
// 分页查询请假数据列表.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function leaveActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 保存请假数据信息.
// GET
export async function leaveActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/delete/${params.id}`)
    return data.data
}

    
// 获取导入请假数据的模版.
// POST
export async function leaveActionInput (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/leave/import`, params)
    return data.data
}

    
// 打卡.
// GET
export async function mobileActionPreCheckIn (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/mobile/check/pre`)
    return data.data
}

    
// 打卡前获取打卡需要信息的请求.
// POST
export async function mobileActionCheckIn (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/mobile/check`, params)
    return data.data
}

    
// 是否是休息日.
// POST
export async function myActionCheckIsMyRestDay (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/my/rest/date/check`, params)
    return data.data
}

    
// 根据日期查询我的考勤数据.
// POST
export async function myActionListDetailWithDate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/my/detail/list`, params)
    return data.data
}

    
// 根据日期查询我的考勤统计.
// GET
export async function myActionVersionCheck (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/my/version`)
    return data.data
}

    
// 考勤版本查询.
// POST
export async function myActionStatistic (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/my/statistic`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/openapi`)
    return data.data
}

    
// 删除所有打卡数据
// PUT
export async function qywxAttendanceActionListDingdingAttendance (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywx/attendance/list/${params.id}/next/${params.count}`, params)
    return data.data
}

    
// 查询企业微信打卡结果
// id: String: 最后一条数据ID
// count: Integer: 每页显示的条目数量
// GET
export async function qywxAttendanceActionListDingdingSyncRecord (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywx/sync/list`)
    return data.data
}

    
// 查询企业微信同步记录信息
// DELETE
export async function qywxAttendanceActionDeleteAllData (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywx/all`, params)
    return data.data
}

    
// 同步企业微信考勤结果
// dateFrom: String: 开始时间: yyyy-MM-dd
// dateTo: String: 结束时间: yyyy-MM-dd
// GET
export async function qywxAttendanceActionSyncData (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywx/sync/from/${params.dateFrom}/to/${params.dateTo}/start`)
    return data.data
}

    
// 人员月份统计查询
// person: String: 人员
// year: String: 年份: yyyy
// month: String: 月份: MM
// GET
export async function qywxAttendanceStatisticActionPersonMonthWithUnit (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywxstatistic/person/unit/${params.unit}/${params.year}/${params.month}`)
    return data.data
}

    
// 根据部门查询人员月份统计
// unit: String: 部门
// year: String: 年份: yyyy
// month: String: 月份: MM
// GET
export async function qywxAttendanceStatisticActionPersonMonth (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywxstatistic/person/${params.person}/${params.year}/${params.month}`)
    return data.data
}

    
// 部门月份统计查询
// unit: String: 部门
// year: String: 年份: yyyy
// month: String: 月份: MM
// GET
export async function qywxAttendanceStatisticActionUnitMonth (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/qywxstatistic/unit/${params.unit}/${params.year}/${params.month}`)
    return data.data
}

    
// 根据人员和日期删除打卡记录.
// people: String: 人员 DN
// date: String: 日期 yyyy-MM-dd
// GET
export async function recordActionTemplate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/template`)
    return data.data
}

    
// 获取打卡记录对象.
// id: String: 打卡记录ID
// POST
export async function recordActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 上传Excel导入打卡记录数据.
// GET
export async function recordActionDeleteByDate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/delete/people/${params.people}/date/${params.date}`)
    return data.data
}

    
// 导入某一天的打卡记录.
// POST
export async function recordActionInputDailyRecord (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/import/daily`, params)
    return data.data
}

    
// 分页查询班次列表.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function recordActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/${params.id}`)
    return data.data
}

    
// 获取导入打卡记录数据的模版.
// POST
export async function recordActionInput (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/record/import`, params)
    return data.data
}

    
// 删除班次.
// id: String: 班次ID
// POST
export async function shiftActionShiftUpdate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/update`, params)
    return data.data
}

    
// 获取班次.
// id: String: 班次ID
// POST
export async function shiftActionListByPaging (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 分页查询班次列表.
// page: Integer: 分页
// size: Integer: 数量
// POST
export async function shiftActionShiftCreate (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/create`, params)
    return data.data
}

    
// 创建班次信息.
// GET
export async function shiftActionGet (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/${params.id}`)
    return data.data
}

    
// 修改班次信息.
// GET
export async function shiftActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/shift/delete/${params.id}`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 删除工作地点.
// id: String: 班次ID
// POST
export async function workPlaceV2ActionPost (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/workplace`, params)
    return data.data
}

    
// 全部的工作地点列表.
// GET
export async function workPlaceV2ActionListAll (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/workplace/list/all`)
    return data.data
}

    
// 根据id列表
// POST
export async function workPlaceV2ActionListWithWorkPlaceObject (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/workplace/list/ids`, params)
    return data.data
}

    
// 新建或者更新工作地点信息
// DELETE
export async function workPlaceV2ActionDelete (params) {
    const {data} = await request(`/x_attendance_assemble_control/jaxrs/v2/workplace/${params.id}`, params)
    return data.data
}

    