
// 删除指定subject下指定的附件.
// id: String: 附件标识
// POST
export async function attachmentActionUpload (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/upload/subject/${params.subjectId}`, params)
    return data.data
}

    
// 根据ID下载指定附件
// id: String: 附件标识
// GET
export async function attachmentActionDownloadWithSubject (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/download/${params.id}`)
    return data.data
}

    
// 根据Work下载附件,设定是否使用stream输出
// id: String: 附件标识
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function attachmentActionDownloadWithSubjectStream (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/download/${params.id}/stream/${params.stream}`)
    return data.data
}

    
// 根据附件Id获取单个附件信息.
// id: String: 附件ID
// POST
export async function attachmentActionUploadCallback (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/upload/subject/${params.subjectId}/callback/${params.callback}`, params)
    return data.data
}

    
// 根据Subject获取Attachment列表.
// subjectId: String: 贴子ID
// GET
export async function attachmentActionListWithSubjectId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/list/subject/${params.subjectId}`)
    return data.data
}

    
// 上传附件.
// subjectId: String: 主贴ID
// GET
export async function attachmentActionGetWithId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/${params.id}`)
    return data.data
}

    
// 上传附件(带回调).
// subjectId: String: 主贴ID
// callback: String: 回调函数名
// DELETE
export async function attachmentActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/attachment/${params.id}`, params)
    return data.data
}

    
// 根据ID获取论坛设置对象.
// id: String: 配置信息ID
// GET
export async function bBSConfigSettingActionListAll (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/setting/all`)
    return data.data
}

    
// 根据编码获取论坛设置对象.
// PUT
export async function bBSConfigSettingActionGetByCode (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/setting/code`, params)
    return data.data
}

    
// 获取所有论坛设置信息列表.
// GET
export async function bBSConfigSettingActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/setting/${params.id}`)
    return data.data
}

    
// 更新论坛设置对象, 配置信息不允许新建和删除操作.
// PUT
export async function bBSConfigSettingActionUpdate (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/setting`, params)
    return data.data
}

    
// 获取BBS系统名称配置的论坛设置对象.
// GET
export async function bBSConfigSettingAnonymousActionGetBBSName (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/setting/bbsName`)
    return data.data
}

    
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/cache/config/flush`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 根据指定ID获取论坛信息.
// id: String: 表单ID
// GET
export async function forumInfoActionViewAllWithMyPermission (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/forum/view/all`)
    return data.data
}

    
// 获取登录者可以访问到的所有ForumInfo的信息列表.
// GET
export async function forumInfoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/forum/${params.id}`)
    return data.data
}

    
// 根据ID删除指定的论坛信息，如果论坛里有版块或者贴子，则不允许删除.
// id: String: 表单ID
// POST
export async function forumInfoManagerUserActionPost (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/forum`, params)
    return data.data
}

    
// 获取所有论坛信息列表.
// GET
export async function forumInfoManagerUserActionListAll (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/forum/all`)
    return data.data
}

    
// 创建新的论坛信息或者更新论坛信息.
// DELETE
export async function forumInfoManagerUserActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/forum/${params.id}`, params)
    return data.data
}

    
// 将URL指向的图片转换成base64String.
// POST
export async function imageBase64ActionConvert (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/image/encode/base64`, params)
    return data.data
}

    
// 用户进入系统，获取并且更新用户权限角色信息.
// POST
export async function loginActionLogin (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/login`, params)
    return data.data
}

    
// 退出系统.
// POST
export async function logoutActionLogin (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/logout`, params)
    return data.data
}

    
// 获取登录者可以访问到的所有ForumInfo的信息列表.
// GET
export async function mobileIndexActionViewAllWithMyPermission (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/mobile/view/all`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/openapi`)
    return data.data
}

    
// 查询用户在指定板块中的所有操作权限.
// sectionId: String: 版块ID
// GET
export async function permissionInfoActionSubjectPublishable (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission/subjectPublishable/${params.sectionId}`)
    return data.data
}

    
// 查询用户对指定主题的所有操作权限.
// subjectId: String: 主贴ID
// GET
export async function permissionInfoActionGetUserPermission (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission`)
    return data.data
}

    
// 查询当前用户的操作权限.
// GET
export async function permissionInfoActionReplyPublishable (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission/replyPublishable/${params.subjectId}`)
    return data.data
}

    
// 查询用户是否可以对指定主题进行回复.
// subjectId: String: 主贴ID
// GET
export async function permissionInfoActionGetSectionOperationPermissoin (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission/section/${params.sectionId}`)
    return data.data
}

    
// 查询用户对指定主题的所有操作权限.
// sectionId: String: 版块ID
// GET
export async function permissionInfoActionGetSubjectOperationPermissoin (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/permission/subject/${params.subjectId}`)
    return data.data
}

    
// 获取指定的论坛绑定的所有PermissionInfo的信息列表.
// forumId: String: 论坛ID
// GET
export async function permissionInfoAdminActionListPermissionByRoleCode (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/permission/role/${params.roleCode}`)
    return data.data
}

    
// 获取指定的角色Code绑定的所有PermissionInfo的信息列表.
// roleCode: String: 角色编码
// GET
export async function permissionInfoAdminActionListPermissionBySection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/permission/section/${params.sectionId}`)
    return data.data
}

    
// 获取指定的版块绑定的所有PermissionInfo的信息列表.
// sectionId: String: 版块ID
// GET
export async function permissionInfoAdminActionListPermissionByForumId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/permission/forum/${params.forumId}`)
    return data.data
}

    
// 将图片转为base64编码，并且进行尺寸转换.
// size: Integer: 尺寸大小
// POST
export async function pictureActionSectionIconUpdate (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/picture/section/${params.id}/icon`, params)
    return data.data
}

    
// 更新版块图标.
// id: String: 版块ID
// POST
export async function pictureActionPictureEncode (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/picture/encode/base64/size/${params.size}`, params)
    return data.data
}

    
// 根据指定ID获取回贴信息.
// id: String: 回复信息ID
// PUT
export async function replyInfoActionListWithSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/reply/filter/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 根据回复内容ID 查询 针对该回帖的回复内容的列表.
// id: String: 回复信息ID
// GET
export async function replyInfoActionListSubRepliesWithReply (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/reply/list/sub/${params.id}`)
    return data.data
}

    
// 列示根据过滤条件的ReplyInfo, 下一页.
// page: Integer: 页码
// count: Integer: 每页显示条目数量
// GET
export async function replyInfoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/reply/${params.id}`)
    return data.data
}

    
// 采纳回复信息.
// PUT
export async function replyInfoManagerUserActionListMyReplyForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/reply/my/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 根据ID删除指定的回贴信息.
// id: String: 回复信息ID
// DELETE
export async function replyInfoManagerUserActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/reply/${params.id}`, params)
    return data.data
}

    
// 列示我发表的回贴,下一页.
// page: Integer: 前一页最后一条记录ID
// count: Integer: 每页显示条目数量
// PUT
export async function replyInfoManagerUserActionAccept (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/reply/accept`, params)
    return data.data
}

    
// 创建新的回贴信息或者更新回贴信息.
// POST
export async function replyInfoManagerUserActionSave (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/reply`, params)
    return data.data
}

    
// 把一个或者多个角色CODE绑定到一个对象（对象名称#对象类型）上.
// POST
export async function roleInfoActionPost (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role`, params)
    return data.data
}

    
// 把一个或者多个对象（对象名称#对象类型）绑定到一个角色CODE上.
// GET
export async function roleInfoActionListAll (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/all`)
    return data.data
}

    
// 根据ID删除指定的角色信息.
// id: String: 角色ID
// PUT
export async function roleInfoActionListByForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/forum/${params.forumId}`, params)
    return data.data
}

    
// 根据论坛角色ID查询论角色信息.
// id: String: 角色ID
// PUT
export async function roleInfoActionListSelectedRoleByUnit (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/unit/selected`, params)
    return data.data
}

    
// 获取所有角色信息列表.
// PUT
export async function roleInfoActionListSelectedRoleByUser (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/user/selected`, params)
    return data.data
}

    
// 根据角色编码查询绑定的对象列表.
// PUT
export async function roleInfoActionListBindObjectByRoleCode (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/rolecode/selected`, params)
    return data.data
}

    
// 根据论坛ID查询论坛的角色列表.
// PUT
export async function roleInfoActionBindRoleToUser (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/bind/object`, params)
    return data.data
}

    
// 根据版块ID查询版块的角色列表.
// PUT
export async function roleInfoActionBindUserToRole (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/bind/role`, params)
    return data.data
}

    
// 根据组织名称查询角色列表.
// PUT
export async function roleInfoActionListBySection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/section/${params.sectionId}`, params)
    return data.data
}

    
// 根据用户姓名查询角色列表.
// GET
export async function roleInfoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/${params.id}`)
    return data.data
}

    
// 创建新的角色信息或者更新角色信息.
// DELETE
export async function roleInfoActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/role/${params.id}`, params)
    return data.data
}

    
// 根据指定ID获取版块信息.
// id: String: 版块信息ID
// GET
export async function sectionInfoActionViewWithForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/section/viewforum/${params.forumId}`)
    return data.data
}

    
// 根据主版块ID查询所有的子版块信息列表.
// sectionId: String: 主版块信息ID
// GET
export async function sectionInfoActionSyn (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/section/syn`)
    return data.data
}

    
// 从应用市场同步所有的应用名称，存入论坛板块应用市场字段subjectTypeList.
// GET
export async function sectionInfoActionListSubSectionByMainSectionId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/section/viewsub/${params.sectionId}`)
    return data.data
}

    
// 根据论坛ID获取所有版块的信息列表.
// forumId: String: 论坛信息ID
// GET
export async function sectionInfoActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/section/${params.id}`)
    return data.data
}

    
// 根据ID删除指定的版块信息，如果版块里有贴子，则不允许删除.
// id: String: 版块信息ID
// POST
export async function sectionInfoManagerUserActionPost (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section`, params)
    return data.data
}

    
// 根据ID删除指定的版块信息，如果版块里有贴子，则全部删除.
// id: String: 版块信息ID
// DELETE
export async function sectionInfoManagerUserActionDeleteForce (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/force/${params.id}`, params)
    return data.data
}

    
// 获取所有版块的信息列表.
// GET
export async function sectionInfoManagerUserActionListAllSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/all`)
    return data.data
}

    
// 根据主版块ID查询所有的子版块信息列表(管理).
// sectionId: String: 主版块信息ID
// GET
export async function sectionInfoManagerUserActionListWithForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/forum/${params.forumId}`)
    return data.data
}

    
// 根据论坛ID获取所有主版块的信息列表(管理).
// forumId: String: 论坛信息ID
// GET
export async function sectionInfoManagerUserActionListAllSubSectionByMainSectionId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/sub/${params.sectionId}`)
    return data.data
}

    
// 创建新的版块信息或者更新版块信息.
// DELETE
export async function sectionInfoManagerUserActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/section/${params.id}`, params)
    return data.data
}

    
// 解除禁言
// id: String: 标识
// GET
export async function shutupActionGetShutup (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/shutup/get/shutup`)
    return data.data
}

    
// 查询当前用户是否被禁言，返回被禁言信息.
// POST
export async function shutupActionListPaging (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/shutup/list/paging/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 分页查询.
// page: Integer: 分页
// size: Integer: 每页数量
// DELETE
export async function shutupActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/shutup/${params.id}`, params)
    return data.data
}

    
// 保存.
// POST
export async function shutupActionSave (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/shutup/save`, params)
    return data.data
}

    
// 根据ID删除BBSSubjectAttachment数据对象.
// id: String: 附件信息ID
// GET
export async function subjectAttachmentActionListBySubjectId (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subjectattach/list/subject/${params.id}`)
    return data.data
}

    
// 根据指定ID获取附件信息.
// id: String: 附件信息ID
// GET
export async function subjectAttachmentActionImageToBase64 (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subjectattach/${params.id}/binary/base64/${params.size}`)
    return data.data
}

    
// 将图片附件转为base64编码.
// id: String: 图片文件ID
// size: String: 最大高宽值
// GET
export async function subjectAttachmentActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subjectattach/${params.id}`)
    return data.data
}

    
// 根据主题ID获取BBSSubjectAttachment列表.
// id: String: 主贴信息ID
// DELETE
export async function subjectAttachmentActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subjectattach/${params.id}`, params)
    return data.data
}

    
// 列示根据过滤条件的精华主题列表.
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量
// GET
export async function subjectInfoActionListTopSubject (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/top/${params.sectionId}`)
    return data.data
}

    
// 获取所有推荐到BBS首页的主题列表.
// count: Integer: 查询的最大条目数量
// GET
export async function subjectInfoActionStatSubjectGrade (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/statgrade/sectionName/${params.sectionName}/subjectType/${params.subjectType}`)
    return data.data
}

    
// 列示根据过滤条件的推荐主题列表.
// page: Integer: 展示页码
// count: Integer: 每页显示条目数量
// GET
export async function subjectInfoActionViewSubject (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/view/${params.id}`)
    return data.data
}

    
// 列示根据过滤条件的SubjectInfo,为首页准备的服务.
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量
// PUT
export async function subjectInfoActionListSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/filter/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 列示根据过滤条件的SubjectInfo,下一页.
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量
// PUT
export async function subjectInfoActionListSubjectForBBSIndex (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/index/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 列示根据过滤条件(版块名称，标题类别)的SubjectInfo,下一页.
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量
// PUT
export async function subjectInfoActionSearchSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/search/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 获取所有可以取到的置顶贴列表.
// sectionId: String: 版块信息ID
// PUT
export async function subjectInfoActionListRecommendedSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/recommended/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 列示根据过滤条件的SubjectInfo,下一页.
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量
// PUT
export async function subjectInfoActionListCreamedSubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/creamed/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 统计根据过滤条件(版块名称，标题类别)的SubjectInfo的评分
// sectionName: String: 版块名称
// subjectType: String: 主题类别
// GET
export async function subjectInfoActionListRecommendedSubjectForBBSIndex (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/recommended/index/${params.count}`)
    return data.data
}

    
// 根据指定ID查看主贴具体信息，需要记录查询次数和热度的.
// id: String: 主贴信息ID
// POST
export async function subjectInfoActionListSubjectWithSubjectTypeForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/subject/filter/listsubjectinfo/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 问题贴采纳回复
// id: String: 主贴信息ID
// replyId: String: 回帖信息ID
// GET
export async function subjectInfoManagerUserActionUnComplete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/uncomplete/${params.id}`)
    return data.data
}

    
// 将指定ID的主贴转移到其他的版块中.
// GET
export async function subjectInfoManagerUserActionUnAcceptReply (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/unacceptreply/${params.id}`)
    return data.data
}

    
// 完成主题: 属性isCompleted = true
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionNonOriginal (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonOriginal/${params.id}`)
    return data.data
}

    
// 根据ID删除指定的主题信息.
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionAcceptReply (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/acceptreply/${params.id}/${params.replyId}`)
    return data.data
}

    
// 根据指定ID获取主题具体信息.
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionTopToSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/topToSection/${params.id}`)
    return data.data
}

    
// 列示我发布的主题.
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量
// GET
export async function subjectInfoManagerUserActionNonTopToSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonTopToSection/${params.id}`)
    return data.data
}

    
// 列示投票记录.
// page: Integer: 显示页码
// count: Integer: 每页显示条目数量
// GET
export async function subjectInfoManagerUserActionTopToMainSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/topToMainSection/${params.id}`)
    return data.data
}

    
// 锁定主题: 状态修改为'已锁定', 属性stopReply = true
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionTopToForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/topToForum/${params.id}`)
    return data.data
}

    
// 取消精华主题.
// id: String: 主贴信息ID
// PUT
export async function subjectInfoManagerUserActionChangeSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/change/section`, params)
    return data.data
}

    
// 取消原创主题.
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionNonTopToForum (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonTopToForum/${params.id}`)
    return data.data
}

    
// 取消推荐到BBS首页.
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionTopToBBS (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/topToBBS/${params.id}`)
    return data.data
}

    
// 取消全局置顶.
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionNonTopToBBS (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonTopToBBS/${params.id}`)
    return data.data
}

    
// 取消论坛置顶.
// id: String: 主贴信息ID
// PUT
export async function subjectInfoManagerUserActionVoteSubmit (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/vote/submit`, params)
    return data.data
}

    
// 取消主版块置顶
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionSetOriginal (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/setOriginal/${params.id}`)
    return data.data
}

    
// 取消版块置顶
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionSetCream (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/setCream/${params.id}`)
    return data.data
}

    
// 创建新的主题信息或者更新主题信息.
// GET
export async function subjectInfoManagerUserActionNonCream (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonCream/${params.id}`)
    return data.data
}

    
// 设置为精华主题.
// id: String: 主贴信息ID
// PUT
export async function subjectInfoManagerUserActionListVoteRecordForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/voterecord/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 设置为原创主题.
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionSetRecommendToBBSIndex (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/setRecommendToBBSIndex/${params.id}`)
    return data.data
}

    
// 推荐到BBS首页.
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionNonTopToMainSection (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonTopToMainSection/${params.id}`)
    return data.data
}

    
// 全局置顶.
// id: String: 主贴信息ID
// PUT
export async function subjectInfoManagerUserActionListMySubjectForPage (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/my/list/page/${params.page}/count/${params.count}`, params)
    return data.data
}

    
// 论坛置顶
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionNonRecommendToBBSIndex (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/nonRecommendToBBSIndex/${params.id}`)
    return data.data
}

    
// 主版块置顶
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionLock (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/lock/${params.id}`)
    return data.data
}

    
// 版块置顶
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionGet (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/${params.id}`)
    return data.data
}

    
// 取消问题贴采纳回复
// id: String: 主贴信息ID
// DELETE
export async function subjectInfoManagerUserActionDelete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/${params.id}`, params)
    return data.data
}

    
// 取消完成主题: 属性isCompleted = false.
// id: String: 主贴信息ID
// POST
export async function subjectInfoManagerUserActionSave (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject`, params)
    return data.data
}

    
// 锁定主题: 状态修改为'启用', 属性stopReply = false.
// id: String: 主贴信息ID
// GET
export async function subjectInfoManagerUserActionUnlock (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/unlock/${params.id}`)
    return data.data
}

    
// 提交投票信息.
// GET
export async function subjectInfoManagerUserActionComplete (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/user/subject/complete/${params.id}`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 列示根据过滤条件的论坛用户信息.
// PUT
export async function userInfoActionFilterUserInfo (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/userinfo`, params)
    return data.data
}

    
// 批量更新指定用户帖子和回复的昵称.
// person: String: 用户
// GET
export async function userInfoActionUpdateNickName (params) {
    const {data} = await request(`/x_bbs_assemble_control/jaxrs/userinfo/update/nick/name/${params.person}`)
    return data.data
}

    