
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/cache/config/flush`)
    return data.data
}

    
// 根据ID删除日历信息及所有事件
// id: String: 日历信息ID
// GET
export async function calendarActionFollowCalendarCancel (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/follow/${params.id}/cancel`)
    return data.data
}

    
// 关注一个公开的日历信息
// id: String: 日历信息ID
// PUT
export async function calendarActionListWithFilter (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/list/filter`, params)
    return data.data
}

    
// 取消关注一个公开的日历信息
// id: String: 日历信息ID
// DELETE
export async function calendarActionDestory (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/${params.id}`, params)
    return data.data
}

    
// 根据ID获取日历信息
// id: String: 日历信息ID
// GET
export async function calendarActionListPublicCalendar (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/list/public`)
    return data.data
}

    
// 判断当前用户是否对指定的日历有管理员权限
// GET
export async function calendarActionFollowCalendar (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/follow/${params.id}`)
    return data.data
}

    
// 判断当前用户是否有管理员权限
// GET
export async function calendarActionListMyCalendar (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/list/my`)
    return data.data
}

    
// 获取我能访问到的所有日历信息列表
// GET
export async function calendarActionIsCalendarManager (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/ismanager/calendar/${params.accountId}`)
    return data.data
}

    
// 获取所有公开的日历信息列表
// GET
export async function calendarActionIsManager (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/ismanager`)
    return data.data
}

    
// 根据条件查询日历信息列表
// GET
export async function calendarActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar/${params.id}`)
    return data.data
}

    
// 新建或者更新日历信息
// POST
export async function calendarActionSave (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/calendar`, params)
    return data.data
}

    
// 根据ID获取系统配置信息
// id: String: 系统配置信息ID
// GET
export async function calendarSettingActionListAllReportSetting (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting/list/all`)
    return data.data
}

    
// 根据Code获取系统配置信息
// code: String: 系统配置信息编码
// GET
export async function calendarSettingActionGetWithCode (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting/code/${params.code}`)
    return data.data
}

    
// 判断当前用户是否有管理员权限
// GET
export async function calendarSettingActionIsManager (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting/ismanager`)
    return data.data
}

    
// 获取所有系统配置信息列表
// GET
export async function calendarSettingActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting/${params.id}`)
    return data.data
}

    
// 新建或者更新系统配置信息
// POST
export async function calendarSettingActionSave (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/setting`, params)
    return data.data
}

    
// 创建一个新的日历事件信息
// DELETE
export async function calendar_EventActionDestoryAllEventsWithRepeatMaster (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/all/${params.eventId}`, params)
    return data.data
}

    
// 删除重复日程事件中指定事件开始后续所有的日程事件信息
// eventId: String: 日历事件信息ID
// PUT
export async function calendar_EventActionListWithFilterSample (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/list/filter/sample`, params)
    return data.data
}

    
// 根据指定事件ID删除所有的重复日历事件信息
// eventId: String: 日历事件信息ID
// PUT
export async function calendar_EventActionUpdateAllEventsWithRepeatMaster (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/update/all/${params.eventId}`, params)
    return data.data
}

    
// 根据事件ID删除指定的日历事件信息
// eventId: String: 日历事件信息ID
// PUT
export async function calendar_EventActionListWithFilter (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/list/filter`, params)
    return data.data
}

    
// 根据ID获取日历事件信息
// id: String: 日历事件信息ID
// PUT
export async function calendar_EventActionUpdateAfterEvent (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/update/after/${params.eventId}`, params)
    return data.data
}

    
// 根据ID获取日历事件信息的RFC内容
// id: String: 日历事件信息ID
// DELETE
export async function calendar_EventActionDestorySingleEvent (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/single/${params.eventId}`, params)
    return data.data
}

    
// 根据条件查询日历事件信息列表
// PUT
export async function calendar_EventActionUpdateSingleEvent (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/update/single/${params.eventId}`, params)
    return data.data
}

    
// 根据条件查询日历事件信息列表(返回简单列表)
// DELETE
export async function calendar_EventActionDestoryAfterEvent (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/after/${params.eventId}`, params)
    return data.data
}

    
// 更新重复日程事件中指定事件开始后续所有的日程事件信息
// eventId: String: 日历事件信息ID
// GET
export async function calendar_EventActionGetRFC (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/rfc/${params.id}`)
    return data.data
}

    
// 更新事件所有的重复日程事件
// eventId: String: 日历事件信息ID
// GET
export async function calendar_EventActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event/${params.id}`)
    return data.data
}

    
// 根据事件ID更新单个日程事件信息
// eventId: String: 日历事件信息ID
// POST
export async function calendar_EventActionCreate (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/event`, params)
    return data.data
}

    
// 接收日历消息
// POST
export async function calendar_EventMessageActionMessageReceive (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/message`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/openapi`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_calendar_assemble_control/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    