
// 根据文件的md5值查找附件.
// fileMd5: String: 附件md5值
// POST
export async function attachment2ActionUpload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/upload/folder/${params.folderId}`, params)
    return data.data
}

    
// 删除附件.
// id: String: 附件标识
// GET
export async function attachment2ActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/download`)
    return data.data
}

    
// 获取附件内容,输出头信息
// id: String: 附件标识
// GET
export async function attachment2ActionGetImageScaleBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/image/scale/${params.scale}/binary/base64`)
    return data.data
}

    
// 下载图片设定宽高后的(png格式).width(0-5000)像素,0代表不限制,height(0-5000)像素,0代表不限制.
// id: String: 附件标识
// width: Integer: 宽度
// height: Integer: 高度
// GET
export async function attachment2ActionDownloadImageWidthHeight (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/download/image/width/${params.width}/height/${params.height}`)
    return data.data
}

    
// 获取附件内容.不输出头信息
// id: String: 附件标识
// GET
export async function attachment2ActionGetImageWidthHeightBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/image/width/${params.width}/height/${params.height}/binary/base64`)
    return data.data
}

    
// 获取指定人员共享给我的文件.
// id: String: 附件标识
// GET
export async function attachment2ActionListWithFilter (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/filter/${params.name}`)
    return data.data
}

    
// 获取文件Base64编码后的内容.
// id: String: 附件标识
// GET
export async function attachment2ActionDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/download/stream`)
    return data.data
}

    
// 获取图片缩放后的base64内容(png格式).scale(0-200)百分比缩放比例.
// id: String: 附件标识
// scale: Integer: 缩放比例
// POST
export async function attachment2ActionListFileTypePaging (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/type/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取图片设定宽高后的base64内容(png格式).width(0-5000)像素,0代表不限制,height(0-5000)像素,0代表不限制.
// id: String: 附件标识
// width: Integer: 宽度
// height: Integer: 高度
// GET
export async function attachment2ActionOfficePreview (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/office/preview/type/${params.type}`)
    return data.data
}

    
// 获取当前用户或指定用户（管理员权限）使用容量.
// GET
export async function attachment2ActionGetUseCapacity (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/user/capacity`)
    return data.data
}

    
// 按附件类型分页显示.
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function attachment2ActionListWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/folder/${params.folderId}`)
    return data.data
}

    
// 获取当前人员的顶层文件.
// POST
export async function attachment2ActionPostDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/download`, params)
    return data.data
}

    
// 获取指定人员共享给我编辑的文件.
// owner: String: 文件所有人
// POST
export async function attachment2ActionPostDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/download/stream`, params)
    return data.data
}

    
// 根据文件名称查找当前用户的附件.
// name: String: 目录标识
// GET
export async function attachment2ActionListWithEditor (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/editor/${params.owner}`)
    return data.data
}

    
// 获取当前人员在指定文件夹下的文件.
// folderId: String: 目录标识
// GET
export async function attachment2ActionListWithShare (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/share/${params.owner}`)
    return data.data
}

    
// 获取指定人员共享给我的文件.
// owner: String: 文件所有人
// GET
export async function attachment2ActionCheckFileExist (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/exist/file/${params.fileMd5}`)
    return data.data
}

    
// 预览文件,输出html或pdf文件头信息，支持word、ppt、excel、pdf类型文件
// id: String: 附件标识
// type: String: 输出文件类型：html|pdf
// GET
export async function attachment2ActionGetBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}/binary/base64`)
    return data.data
}

    
// 获取附件内容,输出头信息,,使用POST方法访问.
// id: String: 附件标识
// GET
export async function attachment2ActionListTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/list/top`)
    return data.data
}

    
// 获取附件内容.不输出头信息,使用POST方法访问.
// id: String: 附件标识
// GET
export async function attachment2ActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}`)
    return data.data
}

    
// 更新Attachment
// id: String: 附件标识
// PUT
export async function attachment2ActionUpdate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}`, params)
    return data.data
}

    
// 创建Attachment的内容
// folderId: String: 目录
// DELETE
export async function attachment2ActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment2/${params.id}`, params)
    return data.data
}

    
// 删除附件.
// id: String: 附件标识
// POST
export async function attachmentActionUpload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/upload/folder/${params.folderId}`, params)
    return data.data
}

    
// 获取附件内容,输出头信息
// id: String: 附件标识
// GET
export async function attachmentActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/download`)
    return data.data
}

    
// 获取附件内容.不输出头信息
// id: String: 附件标识
// GET
export async function attachmentActionGetImageScaleBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/image/scale/${params.scale}/binary/base64`)
    return data.data
}

    
// 获取指定人员共享给我的文件.
// id: String: 附件标识
// GET
export async function attachmentActionGetImageWidthHeightBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/image/width/${params.width}/height/${params.height}/binary/base64`)
    return data.data
}

    
// 获取文件Base64编码后的内容.
// id: String: 附件标识
// POST
export async function attachmentActionUpdateContentCallback (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/update/callback/${params.callback}`, params)
    return data.data
}

    
// 获取图片缩放后的base64内容(png格式).scale(0-200)百分比缩放比例.
// id: String: 附件标识
// scale: Integer: 缩放比例
// PUT
export async function attachmentActionUpdateContent (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/update`, params)
    return data.data
}

    
// 获取图片设定宽高后的base64内容(png格式).width(0-5000)像素,0代表不限制,height(0-5000)像素,0代表不限制.
// id: String: 附件标识
// width: Integer: 宽度
// height: Integer: 高度
// GET
export async function attachmentActionDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/download/stream`)
    return data.data
}

    
// 获取当前人员的顶层文件.
// GET
export async function attachmentActionListWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/list/folder/${params.folderId}`)
    return data.data
}

    
// 获取指定人员共享给我编辑的文件.
// owner: String: 文件所有人
// POST
export async function attachmentActionPostDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/download`, params)
    return data.data
}

    
// 获取当前人员在指定文件夹下的文件.
// folderId: String: 目录标识
// POST
export async function attachmentActionPostDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/download/stream`, params)
    return data.data
}

    
// 获取指定人员共享给我的文件.
// owner: String: 文件所有人
// GET
export async function attachmentActionListWithEditor (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/list/editor/${params.owner}`)
    return data.data
}

    
// 获取附件内容,输出头信息,,使用POST方法访问.
// id: String: 附件标识
// GET
export async function attachmentActionListWithShare (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/list/share/${params.owner}`)
    return data.data
}

    
// 获取附件内容.不输出头信息,使用POST方法访问.
// id: String: 附件标识
// GET
export async function attachmentActionGetBase64 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}/binary/base64`)
    return data.data
}

    
// 更新Attachment
// id: String: 附件标识
// GET
export async function attachmentActionListTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/list/top`)
    return data.data
}

    
// 更新Attachment的内容
// id: String: 附件标识
// POST
export async function attachmentActionUploadCallback (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/upload/folder/${params.folderId}/callback/${params.callback}`, params)
    return data.data
}

    
// 更新Attachment的内容并返回回调.,使用callback方式,为了与前台兼容使用POST方法
// id: String: 附件标识
// callback: String: 回调函数名
// GET
export async function attachmentActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}`)
    return data.data
}

    
// 创建Attachment的内容
// folderId: String: 目录
// PUT
export async function attachmentActionUpdate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}`, params)
    return data.data
}

    
// 创建Attachment的内容并返回回调.
// folderId: String: 目录
// callback: String: 回调函数名
// DELETE
export async function attachmentActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/attachment/${params.id}`, params)
    return data.data
}

    
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/cache/config/flush`)
    return data.data
}

    
// 获取指定个人的顶层文件.
// GET
export async function complexActionGetWithFolderSubDirect (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/complex/folder/${params.id}`)
    return data.data
}

    
// 获取个人在指定分类下的文件.
// id: String: 文件夹标识
// GET
export async function complexActionGetTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/complex/top`)
    return data.data
}

    
// 获取云文件系统配置。
// POST
export async function configActionSaveSystemConfig (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/config`, params)
    return data.data
}

    
// 判断当前用户是否是云文件管理员。
// GET
export async function configActionIsFileManager (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/config/is/file/manager`)
    return data.data
}

    
// 保存云文件系统配置.
// GET
export async function configActionGetSystemConfig (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/config/system/config`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/echo`)
    return data.data
}

    
// 获取他人共享给我编辑的文件.
// GET
export async function editorActionList (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/editor/list`)
    return data.data
}

    
// 将Attachment的附件复制到File中,关联到referenceType和reference.
// attachmentId: String: Attachment标识
// referenceType: String: 参考类型
// reference: String: 参考
// scale: Integer: 缩放
// PUT
export async function fileActionUpload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/upload/referencetype/${params.referenceType}/reference/${params.reference}/scale/${params.scale}`, params)
    return data.data
}

    
// 根据referenceType和reference删除File.
// referenceType: String: 参考类型
// reference: String: 参考
// GET
export async function fileActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.id}/download`)
    return data.data
}

    
// 下载文件,输出contentType头.
// id: String: 文件标识
// GET
export async function fileActionListPrevWithReferenceType (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.id}/prev/${params.count}/referencetype/${params.referenceType}`)
    return data.data
}

    
// 下载文件,以附件方式,不输出contentType头.
// id: String: 文件标识
// GET
export async function fileActionListNextWithReferenceType (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.id}/next/${params.count}/referencetype/${params.referenceType}`)
    return data.data
}

    
// 获取指定File.
// id: String: 标识
// POST
export async function fileActionUploadPostOctetStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/upload/referencetype/${params.referenceType}/reference/${params.reference}/scale/${params.scale}`, params)
    return data.data
}

    
// 列示当前用户下的所有File,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function fileActionListWithReferenceTypeWithReference (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/referencetype/${params.referenceType}/reference/${params.reference}`)
    return data.data
}

    
// 列示所有File,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function fileActionListPrev (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示当前用户指定referenceType下的所有File,下一页.
// id: String: 标识
// count: Integer: 数量
// referenceType: ReferenceType: 参考类型
// POST
export async function fileActionUploadWithUrl (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/upload/with/url`, params)
    return data.data
}

    
// 列示当前用户下的所有File,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function fileActionListNext (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 列示有File,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function fileActionManageListUnusedReferenceTypeCmsDocument (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/unused/referencetype/cmsdocument/manage`)
    return data.data
}

    
// 列示当前用户指定referenceType下的所有File,上一页.
// id: String: 标识
// count: Integer: 数量
// referenceType: ReferenceType: 参考类型
// DELETE
export async function fileActionManageCleanUnusedReferenceTypeCmsDocument (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/clean/unused/referencetype/cmsdocument/manage`, params)
    return data.data
}

    
// 列示当前用户的ReferenceType.
// GET
export async function fileActionDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.id}/download/stream`)
    return data.data
}

    
// 根据指定的referenceType和reference列示所有的File.
// referenceType: String: 参考类型
// reference: String: 参考
// POST
export async function fileActionPostDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.id}/download`, params)
    return data.data
}

    
// 清理未使用的cmsDocument文件.
// POST
export async function fileActionPostDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.id}/download/stream`, params)
    return data.data
}

    
// 查找未使用的cmsDocument文件.
// POST
export async function fileActionUploadCallback (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/upload/referencetype/${params.referenceType}/reference/${params.reference}/scale/${params.scale}/callback/${params.callback}`, params)
    return data.data
}

    
// 下载文件,输出contentType头,使用POST方法访问.
// id: String: 文件标识
// GET
export async function fileActionListPrevAll (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.id}/prev/${params.count}/all`)
    return data.data
}

    
// 下载文件,以附件方式,不输出contentType头,使用POST方法访问.
// id: String: 文件标识
// GET
export async function fileActionListReference (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/referencetype`)
    return data.data
}

    
// 上传文件,并进行压缩,如果文件大小小于指定宽度或者宽度<0,则不进行压缩.
// referenceType: String: 文件类型
// reference: String: 关联id
// scale: Integer: 缩放
// GET
export async function fileActionListNextAll (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/list/${params.id}/next/${params.count}/all`)
    return data.data
}

    
// 创建Attachment的内容并返回回调.
// referenceType: String: 文件类型
// reference: String: 关联id
// scale: Integer: 缩放
// callback: String: 回调函数名
// GET
export async function fileActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/${params.id}`)
    return data.data
}

    
// 上传文件,并进行压缩,如果文件大小小于指定宽度或者宽度<0,则不进行压缩.为了兼容前台增加的POST方法.
// referenceType: String: 文件类型
// reference: String: 关联id
// scale: Integer: 缩放
// DELETE
export async function fileActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/referencetype/${params.referenceType}/reference/${params.reference}`, params)
    return data.data
}

    
// 根据url上传附件
// GET
export async function fileActionCopy (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/file/copy/attachment/${params.attachmentId}/referencetype/${params.referenceType}/reference/${params.reference}/scale/${params.scale}`)
    return data.data
}

    
// 下载文件,输出contentType头.
// id: String: 文件标识
// GET
export async function fileAnonymousActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/anonymous/file/${params.id}/download`)
    return data.data
}

    
// 下载文件,以附件方式,不输出contentType头.
// id: String: 文件标识
// GET
export async function fileAnonymousActionDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/anonymous/file/${params.id}/download/stream`)
    return data.data
}

    
// 下载文件,输出contentType头,使用POST方法访问.
// id: String: 文件标识
// POST
export async function fileAnonymousActionPostDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/anonymous/file/${params.id}/download`, params)
    return data.data
}

    
// 下载文件,以附件方式,不输出contentType头,使用POST方法访问.
// id: String: 文件标识
// POST
export async function fileAnonymousActionPostDownloadStream (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/anonymous/file/${params.id}/download/stream`, params)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 打包所有指定的附件或目录下的附件,输出头信息
// GET
export async function folder2ActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/${params.id}/download`)
    return data.data
}

    
// 创建文件夹.
// GET
export async function folder2ActionBatchDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/batch/download`)
    return data.data
}

    
// 删除分类,同时删除所有下属的文件和文件夹.
// id: String: 标识
// GET
export async function folder2ActionListWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/list/${params.id}`)
    return data.data
}

    
// 获取文件夹所有附件并打包为zip,输出头信息
// id: String: 附件标识
// GET
export async function folder2ActionListTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/list/top`)
    return data.data
}

    
// 获取文件夹对象。只能由Folder的所有者进行操作,并返回文件夹的下文件的数量和总字节。
// id: String: 标识
// GET
export async function folder2ActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/${params.id}`)
    return data.data
}

    
// 获取当前人员顶层文件夹。
// PUT
export async function folder2ActionPut (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/${params.id}`, params)
    return data.data
}

    
// 获取当前人员指定文件夹下的直属文件夹。
// id: String: 标识
// DELETE
export async function folder2ActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2/${params.id}`, params)
    return data.data
}

    
// 更新文件夹,不能重名
// id: String: 标识
// POST
export async function folder2ActionCreate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder2`, params)
    return data.data
}

    
// 创建文件夹.
// GET
export async function folderActionListWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/list/${params.id}`)
    return data.data
}

    
// 删除分类,同时删除所有下属的文件和文件夹.
// id: String: 标识
// GET
export async function folderActionListTop (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/list/top`)
    return data.data
}

    
// 获取文件夹对象。只能由Folder的所有者进行操作,并返回文件夹的下文件的数量和总字节。
// id: String: 标识
// GET
export async function folderActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/${params.id}`)
    return data.data
}

    
// 获取当前人员顶层文件夹。
// PUT
export async function folderActionPut (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/${params.id}`, params)
    return data.data
}

    
// 获取当前人员指定文件夹下的直属文件夹。
// id: String: 标识
// DELETE
export async function folderActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder/${params.id}`, params)
    return data.data
}

    
// 更新文件夹,不能重名
// id: String: 标识
// POST
export async function folderActionCreate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/folder`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/openapi`)
    return data.data
}

    
// 删除回收站的文件.
// id: String: 标识
// GET
export async function recycleActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/${params.id}`)
    return data.data
}

    
// 清空回收站的文件.
// GET
export async function recycleActionList (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/list`)
    return data.data
}

    
// 获取回收站的文件对象。
// id: String: 标识
// DELETE
export async function recycleActionEmpty (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/empty`, params)
    return data.data
}

    
// 获取回收站所有文件.
// DELETE
export async function recycleActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/${params.id}/delete`, params)
    return data.data
}

    
// 从回收站恢复数据
// id: String: 共享文件ID
// POST
export async function recycleActionResume (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/recycle/${params.id}/resume`, params)
    return data.data
}

    
// 分享文件.
// GET
export async function shareActionDownload (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/download/share/${params.shareId}/file/${params.fileId}`)
    return data.data
}

    
// 删除分享的文件.
// id: String: 标识
// GET
export async function shareActionListFolderWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/folder/share/${params.shareId}/folder/${params.folderId}/`)
    return data.data
}

    
// 获取附件内容,输出头信息.
// shareId: String: 共享文件ID
// fileId: String: 转存附件ID
// GET
export async function shareActionShield (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/shield/${params.id}`)
    return data.data
}

    
// 获取分享的文件对象。
// id: String: 标识
// GET
export async function shareActionListMyShare (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/my`)
    return data.data
}

    
// 根据密码获取分享的文件对象。
// id: String: 标识
// password: String: 共享密码
// GET
export async function shareActionListAttWithFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/att/share/${params.shareId}/folder/${params.folderId}/`)
    return data.data
}

    
// 获取共享文件指定文件夹下的附件.
// shareId: String: 共享文件ID
// folderId: String: 目录ID
// POST
export async function shareActionSaveToFolder (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/share/${params.shareId}/file/${params.fileId}/folder/${params.folderId}`, params)
    return data.data
}

    
// 获取共享文件指定文件夹下的直属文件夹.
// shareId: String: 共享文件ID
// folderId: String: 目录ID
// GET
export async function shareActionListMyShare2 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/my2/${params.shareType}/${params.fileType}`)
    return data.data
}

    
// 获取我共享的文件QueryParam.
// GET
export async function shareActionListShareToMe (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/to/me`)
    return data.data
}

    
// 获取我共享的文件2.
// shareType: String: 分享类型:密码分享(password)|指定分享(member)|全部({0})
// fileType: String: 分享的文件类型:文件(attachment)|目录(folder)|全部({0})
// GET
export async function shareActionListShare (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list`)
    return data.data
}

    
// 获取他人共享给我的文件V1.
// GET
export async function shareActionGetWithPassword (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/${params.id}/password/${params.password}`)
    return data.data
}

    
// 获取他人共享给我的文件.
// GET
export async function shareActionListShareToMe2 (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/list/to/me2/${params.fileType}`)
    return data.data
}

    
// 获取他人共享给我的文件2.
// fileType: String: 分享的文件类型:文件(attachment)|目录(folder)|全部({0})
// GET
export async function shareActionGet (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/${params.id}`)
    return data.data
}

    
// 保存到网盘
// shareId: String: 共享文件ID
// fileId: String: 转存文件ID
// folderId: String: 转存目录ID
// DELETE
export async function shareActionDelete (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share/${params.id}`, params)
    return data.data
}

    
// 屏蔽共享给我的文件
// id: String: 共享文件ID
// POST
export async function shareActionCreate (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/share`, params)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_file_assemble_control/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    