
// 列示指定省所属市级行政区域信息.
// province: String: 省
// GET
export async function areaActionListDistrict (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/area/list/province/${params.province}/city/${params.city}`)
    return data.data
}

    
// 列示指定省市所属区行政区域信息.
// province: String: 省
// city: String: 市
// GET
export async function areaActionListCity (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/area/list/province/${params.province}`)
    return data.data
}

    
// 列示省级行政区域信息.
// GET
export async function areaActionListProvince (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/area/list`)
    return data.data
}

    
// 列示指定省市区所属街道行政区域信息.
// province: String: 省
// city: String: 市
// district: String: 区
// GET
export async function areaActionListStreet (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/area/list/province/${params.province}/city/${params.city}/district/${params.district}`)
    return data.data
}

    
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/cache/config/flush`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/echo`)
    return data.data
}

    
// 文本纠错检查.
// POST
export async function ecnetActionCheck (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/ecnet/check`, params)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 获取附件.
// flag: String: 附件标识
// GET
export async function generalFileActionGet (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/generalfile/flag/${params.flag}`)
    return data.data
}

    
// html转换word.
// GET
export async function officeActionHtmlToWordResult (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/office/html/to/word/result/${params.flag}`)
    return data.data
}

    
// html转换成word结果流文件.
// flag: String: 标识
// POST
export async function officeActionHtmlToWord (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/office/html/to/word`, params)
    return data.data
}

    
// word转换html.
// POST
export async function officeActionInput (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/office`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/openapi`)
    return data.data
}

    
// GET方法生成二维码图像.
// width: Integer: 宽
// height: Integer: 高
// text: String: 文本
// POST
export async function qrCodeActionPostCreate (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/qrcode`, params)
    return data.data
}

    
// POST方法生成二维码图像.
// GET
export async function qrCodeActionGetCreate (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/qrcode/width/${params.width}/height/${params.height}/text/${params.text}`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 在流程引擎路由中增加字段defaultSelected,将defaultSelected的值直接设置成sole的值.
// GET
export async function upgradeActionAction2021090902 (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/upgrade/2021090902`)
    return data.data
}

    
// 在流程引擎路由中将route.getProperties().getSoleDirect()的值强制全部设置为false.
// GET
export async function upgradeActionAction2021090901 (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/upgrade/2021090901`)
    return data.data
}

    
// 根据2个日期计算出节假天数.
// startDate: String: 开始日期
// endDate: String: 结束日期
// GET
export async function workTimeActionIsHoliday (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/isholiday/${params.date}`)
    return data.data
}

    
// 计算开始时间和结束时间之间的工作时间间隔(分钟).
// start: String: 开始时间
// end: String: 结束时间
// GET
export async function workTimeActionBetweenHolidayCount (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/betweenholidaycount/start/${params.startDate}/end/${params.endDate}`)
    return data.data
}

    
// 计算开始时间前进指定工作天数后的工作时间.
// start: String: 开始时间
// days: int: 前进工作天数
// GET
export async function workTimeActionInDefinedHoliday (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/indefinedholiday/${params.date}`)
    return data.data
}

    
// 计算开始时间前进指定分钟数后的工作时间.
// start: String: 开始时间
// minutes: int: 前进分钟数
// GET
export async function workTimeActionBetweenMinutes (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/betweenminutes/start/${params.start}/end/${params.end}`)
    return data.data
}

    
// 返回指定时间是否定义为节假日.
// date: String: 指定日期
// GET
export async function workTimeActionForwardDays (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/forwarddays/start/${params.start}/days/${params.days}`)
    return data.data
}

    
// 返回指定时间是否定义为工作日.
// date: String: 指定日期
// GET
export async function workTimeActionIsWorkTime (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/isworktime/${params.date}`)
    return data.data
}

    
// 返回指定时间是否是节假日.
// date: String: 指定日期
// GET
export async function workTimeActionForwardMinutes (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/forwardminutes/start/${params.start}/minutes/${params.minutes}`)
    return data.data
}

    
// 返回指定时间是否是工作日.
// date: String: 指定日期
// GET
export async function workTimeActionMinutesOfWorkDay (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/minutesofworkday`)
    return data.data
}

    
// 返回指定时间是否是工作时间.
// date: String: 指定时间
// GET
export async function workTimeActionInDefinedWorkDay (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/indefinedworkday/${params.date}`)
    return data.data
}

    
// 返回一个工作日的工作分钟数.
// GET
export async function workTimeActionIsWorkDay (params) {
    const {data} = await request(`/x_general_assemble_control/jaxrs/worktime/isworkday/${params.date}`)
    return data.data
}

    