
// 将流程平台中的work附带的附件作为会议的附件.
// POST
export async function attachmentActionUpload (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/meeting/${params.meetingId}/upload/${params.summary}`, params)
    return data.data
}

    
// 删除Attachment.
// id: String: 标识
// GET
export async function attachmentActionDownload (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.id}/download/${params.stream}`)
    return data.data
}

    
// 下载附件内容.
// id: String: 附件标识
// stream: boolean: 是否直接下载附件,不使用浏览器打开
// POST
export async function attachmentActionCreateFormProcessPlatform (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/create/from/processplatform`, params)
    return data.data
}

    
// 获取指定的Attachment信息.
// id: String: 附件标识
// GET
export async function attachmentActionListPrev (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示Attachment对象,下一页.仅管理员可用
// id: String: 标识
// count: Integer: 数量
// GET
export async function attachmentActionListNext (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 列示Attachment对象,上一页.仅管理员可用
// id: String: 标识
// count: Integer: 数量
// POST
export async function attachmentActionUpdateCallback (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.id}/update/callback/${params.ballback}`, params)
    return data.data
}

    
// 列示指定会议的附件.
// meetingId: String: 会议标识
// GET
export async function attachmentActionListWithMeeting (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/list/meeting/${params.meetingId}`)
    return data.data
}

    
// 更新会议附件内容
// id: String: 会议标识
// POST
export async function attachmentActionUploadCallback (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/meeting/${params.meetingId}/upload/${params.summary}/callback/${params.callback}`, params)
    return data.data
}

    
// 更新会议附件内容
// id: String: 会议标识
// callback: String: 回调函数名
// GET
export async function attachmentActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.id}`)
    return data.data
}

    
// 创建会议附件.
// meetingId: String: 会议标识
// summary: boolean: 是否是会议纪要
// PUT
export async function attachmentActionUpdate (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.id}/update`, params)
    return data.data
}

    
// 创建会议附件.
// meetingId: String: 会议标识
// summary: boolean: 是否是会议纪要
// callback: String: 回调函数名
// DELETE
export async function attachmentActionDelete (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/attachment/${params.id}`, params)
    return data.data
}

    
// 创建Building.
// GET
export async function buildingActionListWithStartCompletedRoom (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list/start/${params.start}/completed/${params.completed}/room/${params.room}/meeting/${params.meeting}`)
    return data.data
}

    
// 删除Building.
// id: String: 建筑标识
// GET
export async function buildingActionListWithStartCompleted (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list/start/${params.start}/completed/${params.completed}`)
    return data.data
}

    
// 获取Building,同时获取Building下的Room 和 Room下的将来Meeting.
// id: String: 标识
// GET
export async function buildingActionListLikePinyin (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building//list/like/pinyin/${params.key}`)
    return data.data
}

    
// 获取所有Building 同时获取Building下的Room 和 Room下的将来Meeting.
// GET
export async function buildingActionListLike (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list/like/${params.key}`)
    return data.data
}

    
// 根据名称进行模糊查询.
// key: String: 拼音首字母
// GET
export async function buildingActionListPinyinInitial (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list/pinyininitial/${params.key}`)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询.
// key: String: 拼音首字母
// GET
export async function buildingActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/${params.id}`)
    return data.data
}

    
// 获取拼音首字母开始的Building.
// key: String: 拼音首字母
// PUT
export async function buildingActionPut (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/${params.id}`, params)
    return data.data
}

    
// 列示在所有building和下属的room，和room下面将来的会议，同时判断在指定时间内room是否空闲
// start: String: 开始时间
// completed: String: 结束时间
// GET
export async function buildingActionList (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/list`)
    return data.data
}

    
// 列示在所有building和下属的room，和room下面将来的会议，同时判断在指定时间内room是否空闲,用于修改当前预定会议时间
// start: String: 开始时间
// completed: String: 结束时间
// room: String: 会议室标识
// meeting: String: 会议标识
// DELETE
export async function buildingActionDelete (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building/${params.id}`, params)
    return data.data
}

    
// 更新Building.
// id: String: 建筑标识
// POST
export async function buildingActionCreate (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/building`, params)
    return data.data
}

    
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/cache`, params)
    return data.data
}

    
// 接收缓存刷新指令.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/cache/config/flush`)
    return data.data
}

    
// 获取会议系统配置(管理员)。
// GET
export async function configActionGetConfigManage (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/config/system/config/manage`)
    return data.data
}

    
// 获取会议系统配置。
// GET
export async function configActionGetSystemConfig (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/config/system/config`)
    return data.data
}

    
// 保存会议系统配置.
// POST
export async function configActionSaveSystemConfig (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/config`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 接受会议邀请
// id: String: 会议标识
// GET
export async function meetingActionReject (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/reject`)
    return data.data
}

    
// 增加会议邀请人.
// id: String: 会议标识
// POST
export async function meetingActionPost (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting`, params)
    return data.data
}

    
// 会议签到二维码
// id: String: 会议标识
// POST
export async function meetingActionListMeetingPagingManage (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/${params.page}/size/${params.size}/manage`, params)
    return data.data
}

    
// 会议签到
// id: String: 会议标识
// GET
export async function meetingActionLisInvitedCompleted (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/invited/completed`)
    return data.data
}

    
// 同意会议预定.
// id: String: 会议标识
// GET
export async function meetingActionListForwardMonthAll (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/forward/monthcount/${params.monthCount}/all`)
    return data.data
}

    
// 拒绝会议预定.
// id: String: 会议标识
// GET
export async function meetingActionListAppliedProcessing (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/applied/processing`)
    return data.data
}

    
// 删除会议.
// id: String: 会议标识
// GET
export async function meetingActionListAppliedCompleted (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/applied/completed`)
    return data.data
}

    
// 删除会议邀请人.
// id: String: 会议标识
// GET
export async function meetingActionLisInvitedProcessing (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/invited/processing`)
    return data.data
}

    
// 修改会议,标题,说明,只能增加邀请人
// id: String: 会议标识
// POST
export async function meetingActionModify (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}`, params)
    return data.data
}

    
// 会议提前结束,修改结束时间
// id: String: 会议标识
// GET
export async function meetingActionConfirmDeny (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/confirm/deny`)
    return data.data
}

    
// 会议提前开始,修改开始时间
// id: String: 会议标识
// PUT
export async function meetingActionDeleteInvite (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/delete/invite`, params)
    return data.data
}

    
// 获取指定会议内容.
// id: String: 会议标识
// PUT
export async function meetingActionEditStartTime (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/modify/starttime`, params)
    return data.data
}

    
// 列示我受到邀请的正在进行中的会议.
// PUT
export async function meetingActionEdit (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}`, params)
    return data.data
}

    
// 列示我受到邀请的正在进行中的会议.
// GET
export async function meetingActionCheckInBindCode (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/checkin/code`)
    return data.data
}

    
// 列示我受到邀请的已经拒绝的会议.
// GET
export async function meetingActionAccpet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/accept`)
    return data.data
}

    
// 列示我受到邀请的还未开始的会议.
// GET
export async function meetingActionManualCompleted (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/manual/completed`)
    return data.data
}

    
// 列示我申请的已经结束的会议.
// GET
export async function meetingActionCheckin (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/checkin`)
    return data.data
}

    
// 列示我申请的正在进行中的会议.
// PUT
export async function meetingActionAddInvite (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/add/invite`, params)
    return data.data
}

    
// 列示我申请的还未开始的会议.
// PUT
export async function meetingActionEditCompletedTime (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/modify/completedtime`, params)
    return data.data
}

    
// 列示我参与从当前日期开始指定日期范围的会议，或者被邀请，或者是申请人,或者是审核人，管理员可以看到所有.
// count: Integer: 数量
// GET
export async function meetingActionConfirmAllow (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}/confirm/allow`)
    return data.data
}

    
// 列示我参与从当前日期开始指定月份范围的会议，或者被邀请，或者是申请人,或者是审核人，管理员可以看到所有.
// count: Integer: 数量
// GET
export async function meetingActionLisInvitedWait (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/invited/wait`)
    return data.data
}

    
// 列示当前用户从当前时间开始指定月数内需要参与的会议
// monthCount: Integer: 制定月数
// GET
export async function meetingActionListAppliedWait (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/applied/wait`)
    return data.data
}

    
// 列示所有从当前时间开始指定月数内需要召开的会议
// monthCount: Integer: 制定月数
// POST
export async function meetingActionListMeetingPaging (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 普通用户，分页列示Meeing对象
// page: Integer: 分页
// size: Integer: 数量
// GET
export async function meetingActionListComingMonth (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/coming/month/${params.count}`)
    return data.data
}

    
// 管理员，分页列示Meeing对象
// page: Integer: 页面
// size: Integer: 数量
// GET
export async function meetingActionListComingDay (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/coming/day/${params.count}`)
    return data.data
}

    
// 列示Meeting对象,下一页.仅管理员可用
// id: String: 会议标识
// count: Integer: 数量
// GET
export async function meetingActionListOnDayAll (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.year}/month/${params.month}/day/${params.day}/all`)
    return data.data
}

    
// 列示我参与的指定日期的会议，或者被邀请，或者是申请人,或者是审核人，管理员可以看到所有.
// year: Integer: 年
// month: Integer: 月
// day: Integer: 日
// GET
export async function meetingActionListWaitConfirm (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/wait/confirm`)
    return data.data
}

    
// 列示所有指定日期的会议.
// year: Integer: 年
// month: Integer: 月
// day: Integer: 日
// GET
export async function meetingActionListOnDayByRoomID (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.year}/month/${params.month}/day/${params.day}/${params.roomId}`)
    return data.data
}

    
// 列示指定会议室id、指定日期的会议.
// year: Integer: 年
// month: Integer: 月
// day: Integer: 日
// roomId: String: 会议室记录ID
// GET
export async function meetingActionLisInvitedRejected (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/invited/rejected`)
    return data.data
}

    
// 列示我参与的指定日期当月的会议，或者被邀请，或者是申请人,或者是审核人，管理员可以看到所有.
// year: Integer: 年
// month: Integer: 月
// GET
export async function meetingActionListPrev (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示当月所有的会议.
// year: Integer: 年
// month: Integer: 月
// GET
export async function meetingActionListWaitAccept (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/wait/accept`)
    return data.data
}

    
// 列示Meeing对象,上一页.仅管理员可用
// id: String: 会议标识
// count: Integer: 数量
// GET
export async function meetingActionListNext (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 等待我确认是否参加的会议.
// GET
export async function meetingActionListOnDay (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.year}/month/${params.month}/day/${params.day}`)
    return data.data
}

    
// 列示等待我确认的会议.
// GET
export async function meetingActionListForwardMonth (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/forward/monthcount/${params.monthCount}`)
    return data.data
}

    
// 手动结束Meeting.
// id: String: 会议标识
// GET
export async function meetingActionListOnMonth (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.year}/month/${params.month}`)
    return data.data
}

    
// 修改会议、标题、说明、邀请人
// id: String: 会议标识
// GET
export async function meetingActionListOnMonthAll (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/list/year/${params.year}/month/${params.month}/all`)
    return data.data
}

    
// 创建会议
// GET
export async function meetingActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}`)
    return data.data
}

    
// 拒绝会议邀请
// id: String: 会议标识
// DELETE
export async function meetingActionDelete (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/meeting/${params.id}`, params)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/openapi`)
    return data.data
}

    
// 创建Room.
// GET
export async function roomActionListLikePinyin (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/list/like/pinyin/${params.key}`)
    return data.data
}

    
// 删除Room.
// id: String: 会议室标识
// POST
export async function roomActionSetPhoto (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/${params.id}/photo`, params)
    return data.data
}

    
// 更新Room.
// id: String: 会议室标识
// GET
export async function roomActionListLike (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/list/like/${params.key}`)
    return data.data
}

    
// 获取指定的会议室.
// id: String: 会议室标识
// PUT
export async function roomActionEdit (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/${params.id}`, params)
    return data.data
}

    
// 列示所有的会议室.
// GET
export async function roomActionListPinyinInitial (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/list/pinyininitial/${params.key}`)
    return data.data
}

    
// 根据名称进行模糊查询.
// key: String: 拼音首字母
// GET
export async function roomActionGet (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/${params.id}`)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询.
// key: String: 拼音首字母
// GET
export async function roomActionList (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/list`)
    return data.data
}

    
// 获取拼音首字母开始的.
// key: String: 拼音首字母
// DELETE
export async function roomActionDelete (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room/${params.id}`, params)
    return data.data
}

    
// 设置会议室照片.
// id: String: 标识
// POST
export async function roomActionCreate (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/room`, params)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_meeting_assemble_control/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    