
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/cache`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/echo`)
    return data.data
}

    
// 导出人员组织信息
// stream: Boolean: 用.APPLICATION_OCTET_STREAM头输出
// GET
export async function exportActionGetResult (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/export/result/flag/${params.flag}`)
    return data.data
}

    
// 获取导出结果.
// flag: String: 导入文件返回的结果标记
// GET
export async function exportActionZhengwuDingdingPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/export/zhengwudingding/person`)
    return data.data
}

    
// 获取政务钉钉人员.
// GET
export async function exportActionExportAllPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/export/export/all`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 添加群组成员.
// flag: String: 群组标识
// GET
export async function groupActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 添加群组成员mockputtopost.
// flag: String: 群组标识
// POST
export async function groupActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/like/pinyin/mockputtopost`, params)
    return data.data
}

    
// 创建群组.
// POST
export async function groupActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/like/mockputtopost`, params)
    return data.data
}

    
// 删除群组.
// flag: String: 群组标识
// POST
export async function groupActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/pinyininitial/mockputtopost`, params)
    return data.data
}

    
// 删除群组成员.
// flag: String: 群组标识
// GET
export async function groupActionListSupDirectWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/person/${params.personFlag}/sup/direct`)
    return data.data
}

    
// 删除群组成员mockputtopost.
// flag: String: 群组标识
// POST
export async function groupActionDeleteMemberMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}/delete/member/mockputtopost`, params)
    return data.data
}

    
// 删除群组mockdeletetoget.
// flag: String: 群组标识
// GET
export async function groupActionListSupNestedWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/person/${params.personFlag}/sup/nested`)
    return data.data
}

    
// 更新群组.
// flag: String: 群组标识
// POST
export async function groupActionAddMemberMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}/add/member/mockputtopost`, params)
    return data.data
}

    
// 更新群组mockputtopost.
// flag: String: 群组标识
// PUT
export async function groupActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}`, params)
    return data.data
}

    
// 获取群组.
// flag: String: 群组标识
// POST
export async function groupActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 根据名称进行模糊查询.
// GET
export async function groupActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.flag}/prev/${params.count}`)
    return data.data
}

    
// 根据名称进行模糊查询mockputtopost.
// GET
export async function groupActionListWithRole (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/role/${params.roleFlag}`)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询
// PUT
export async function groupActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/like/pinyin`, params)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询mockputtopost
// PUT
export async function groupActionAddMember (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}/add/member`, params)
    return data.data
}

    
// 列示群组,下一页.
// flag: String: 群组标识
// count: Integer: 数量
// GET
export async function groupActionListSubNested (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.flag}/sub/nested`)
    return data.data
}

    
// 获取拼音首字母开始的群组.
// GET
export async function groupActionListSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.flag}/sub/direct`)
    return data.data
}

    
// 获取拼音首字母开始的群组mockputtopost.
// GET
export async function groupActionListSupNested (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.flag}/sup/nested`)
    return data.data
}

    
// 列示群组,上一页.
// flag: String: 群组标识
// count: Integer: 数量
// PUT
export async function groupActionDeleteMember (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}/delete/member`, params)
    return data.data
}

    
// 查找群组直接作为成员所在的群组.
// flag: String: 群组标识
// PUT
export async function groupActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/like`, params)
    return data.data
}

    
// 查找群组所在的群组,包括嵌套的下级群组.
// flag: String: 群组标识
// GET
export async function groupActionListSupDirect (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.flag}/sup/direct`)
    return data.data
}

    
// 查找群组的直接上级群组.
// flag: String: 群组标识
// PUT
export async function groupActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/pinyininitial`, params)
    return data.data
}

    
// 查找人员直接作为成员所在的群组.
// personFlag: String: 个人标识
// GET
export async function groupActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/list/${params.flag}/next/${params.count}`)
    return data.data
}

    
// 查找群组的嵌套上级群组
// flag: String: 群组标识
// GET
export async function groupActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}`)
    return data.data
}

    
// 查找人员所在的群组,包括嵌套的下级群组.
// personFlag: String: 个人标识
// DELETE
export async function groupActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group/${params.flag}`, params)
    return data.data
}

    
// 查找指定角色所包含的群组.
// roleFlag: String: 角色标识
// POST
export async function groupActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/group`, params)
    return data.data
}

    
// 创建身份.
// GET
export async function identityActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 删除身份,同时删除职务.
// flag: String: 身份标识
// POST
export async function identityActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/like/pinyin/mockputtopost`, params)
    return data.data
}

    
// 删除身份,同时删除职务mockdeletetoget.
// flag: String: 身份标识
// POST
export async function identityActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/like/mockputtopost`, params)
    return data.data
}

    
// 更新身份.
// flag: String: 身份标识
// POST
export async function identityActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/pinyininitial/mockputtopost`, params)
    return data.data
}

    
// 更新身份mockputtopost.
// flag: String: 身份标识
// GET
export async function identityActionListWithUnitWithUnitDutyName (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/${params.flag}/unitduty/name/${params.unitDutyName}`)
    return data.data
}

    
// 获取身份.
// flag: String: 身份标识
// GET
export async function identityActionListWithUnitDutyName (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/unitduty/name/${params.unitDutyName}`)
    return data.data
}

    
// 进行模糊查询.
// PUT
export async function identityActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.flag}`, params)
    return data.data
}

    
// 进行模糊查询mockputtopost.
// POST
export async function identityActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 根据拼音或者首字母搜索.
// GET
export async function identityActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/${params.flag}/prev/${params.count}`)
    return data.data
}

    
// 根据拼音或者首字母搜索mockputtopost.
// PUT
export async function identityActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/like/pinyin`, params)
    return data.data
}

    
// 列示身份,下一页.
// flag: String: 身份标识
// count: Integer: 数量
// PUT
export async function identityActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/like`, params)
    return data.data
}

    
// 获取拼音首字母开始的身份.
// PUT
export async function identityActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/pinyininitial`, params)
    return data.data
}

    
// 获取拼音首字母开始的身份mockputtopost.
// GET
export async function identityActionListWithUnit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/unit/${params.unitFlag}`)
    return data.data
}

    
// 列示身份,上一页.
// flag: String: 身份标识
// count: Integer: 数量
// GET
export async function identityActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/${params.flag}/next/${params.count}`)
    return data.data
}

    
// 根据给定的人员,列示其所有的身份.
// personFlag: String: 个人标识
// GET
export async function identityActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/list/person/${params.personFlag}`)
    return data.data
}

    
// 根据给定的组织,列示其所有的身份.
// unitFlag: String: 组织标识
// GET
export async function identityActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.flag}`)
    return data.data
}

    
// 根据给定的组织职务名称,列示其所有的身份.
// unitDutyName: String: 组织职务名称
// DELETE
export async function identityActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.flag}`, params)
    return data.data
}

    
// 根据给定的组织和组织职务名称,列示其所有的身份.
// flag: String: 组织
// unitDutyName: String: 组织职务名称
// POST
export async function identityActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity`, params)
    return data.data
}

    
// 更新身份.
// flag: String: 身份标识
// followFlag: String: 后续身份标识
// GET
export async function identityActionOrder (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/identity/${params.flag}/order/before/${params.followFlag}`)
    return data.data
}

    
// 获取导入人员结果.
// flag: String: 导入文件返回的结果标记
// GET
export async function inputPersonActionGetResult (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/inputperson/result/flag/${params.flag}`)
    return data.data
}

    
// 上传Excel导入人员.
// GET
export async function inputPersonActionTemplate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/inputperson/template`)
    return data.data
}

    
// 获取导入人员模版.
// GET
export async function inputPersonActionWipeAll (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/inputperson/wipe`)
    return data.data
}

    
// 清空人员组织数据.
// POST
export async function inputPersonActionInput (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/inputperson`, params)
    return data.data
}

    
// 获取用户登录记录的Excel.
// stream: Boolean: 是否采用流格式直接作为附件下载
// GET
export async function loginRecordActionLoginRecord (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/loginrecord/${params.stream}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/openapi`)
    return data.data
}

    
// 创建通讯录权限设置.
// POST
export async function permissionSettingActionUpdateMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 删除通讯录设置配置.
// flag: String: 通讯录配置标识
// GET
export async function permissionSettingActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 删除通讯录设置配置mockdeletetoget.
// flag: String: 通讯录配置标识
// GET
export async function permissionSettingActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.flag}`)
    return data.data
}

    
// 获取通讯录配置.
// flag: String: 名片标识
// PUT
export async function permissionSettingActionUpdate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.flag}`, params)
    return data.data
}

    
// 获取所有通讯录设置配置
// GET
export async function permissionSettingActionList (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/list`)
    return data.data
}

    
// 更新通讯录配置.
// flag: String: 名片标识
// DELETE
export async function permissionSettingActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting/${params.flag}`, params)
    return data.data
}

    
// 更新通讯录配置mockputtopost.
// flag: String: 名片标识
// POST
export async function permissionSettingActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/permissionsetting`, params)
    return data.data
}

    
// 校验password密码等级.
// password: String: 校验密码
// PUT
export async function personActionSetPassword (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/set/password`, params)
    return data.data
}

    
// 创建个人.
// GET
export async function personActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 删除个人.
// flag: String: 人员标识
// POST
export async function personActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/like/pinyin/mockputtopost`, params)
    return data.data
}

    
// 删除个人mockdeletetoget.
// flag: String: 人员标识
// POST
export async function personActionSetPasswordMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/set/password/mockputtopost`, params)
    return data.data
}

    
// 更新个人.
// flag: String: 人员标识
// POST
export async function personActionSetIconMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/icon/mockputtopost`, params)
    return data.data
}

    
// 更新个人mockputtopost.
// flag: String: 人员标识
// POST
export async function personActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/like/mockputtopost`, params)
    return data.data
}

    
// 获取个人,附带身份,身份所在的组织,个人所在群组,个人拥有角色.
// flag: String: 人员标识
// GET
export async function personActionReserveDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/reserve/mockdeletetoget`)
    return data.data
}

    
// 获取个人头像.
// flag: String: 个人标识
// GET
export async function personActionListSubNestedWithGroup (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/group/${params.groupFlag}/sub/nested`)
    return data.data
}

    
// 根据名称进行模糊查询.
// GET
export async function personActionListSubDirectWithGroup (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/group/${params.groupFlag}/sub/direct`)
    return data.data
}

    
// 根据名称进行模糊查询mockputtopost.
// POST
export async function personActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/pinyininitial/mockputtopost`, params)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询.
// PUT
export async function personActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}`, params)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询mockputtopost.
// POST
export async function personActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 列示个人,下一页.
// flag: String: 人员标识
// count: Integer: 数量
// DELETE
export async function personActionReserveDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/reserve`, params)
    return data.data
}

    
// 获取拼音首字母开始的个人.
// GET
export async function personActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/${params.flag}/prev/${params.count}`)
    return data.data
}

    
// 获取拼音首字母开始的个人mockputtopost.
// GET
export async function personActionListWithRole (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/role/${params.roleFlag}`)
    return data.data
}

    
// 列示个人,上一页.
// flag: String: 人员标识
// count: Integer: 数量
// PUT
export async function personActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/like/pinyin`, params)
    return data.data
}

    
// 根据给定的群组,列示直接个人成员.
// groupFlag: String: 群组标识
// GET
export async function personActionUnlockPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/unlock/${params.flag}`)
    return data.data
}

    
// 根根据给定的群组,列示嵌套的个人成员.
// groupFlag: String: 群组标识
// GET
export async function personActionResetPassword (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/reset/password`)
    return data.data
}

    
// 根根据给定的角色,列示个人成员.
// roleFlag: String: 角色标识
// PUT
export async function personActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/like`, params)
    return data.data
}

    
// 删除个人关联信息（身份、角色等），但保留人员（企业离退休人员需要能登录平台但不能做业务处理）.
// flag: String: 人员标识
// PUT
export async function personActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/pinyininitial`, params)
    return data.data
}

    
// 删除个人关联信息（身份、角色等），但保留人员（企业离退休人员需要能登录平台但不能做业务处理）.
// flag: String: 人员标识
// GET
export async function personActionCheckPassword (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/check/password/${params.password}`)
    return data.data
}

    
// 重置个人的密码.
// flag: String: 个人标识
// GET
export async function personActionGetIconWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/icon`)
    return data.data
}

    
// 设置个人的头像.
// flag: String: 个人标识
// PUT
export async function personActionSetIcon (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/icon`, params)
    return data.data
}

    
// 设置个人的头像mockputtopost.
// flag: String: 个人标识
// GET
export async function personActionSetPasswordExpiredTime (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}/set/password/expired/time/${params.date}`)
    return data.data
}

    
// 更新指定个人的密码.
// flag: String: 个人标识
// GET
export async function personActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/list/${params.flag}/next/${params.count}`)
    return data.data
}

    
// 设置用户密码到期时间，用于管理员设置用户的密码到期时间.
// flag: String: 人员标识
// date: String: 过期时间
// GET
export async function personActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}`)
    return data.data
}

    
// 更新指定个人的密码mockputtopost.
// flag: String: 个人标识
// DELETE
export async function personActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person/${params.flag}`, params)
    return data.data
}

    
// 用户解锁，用于管理员解锁登录多次失败被锁定的用户.
// flag: String: 人员标识
// POST
export async function personActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/person`, params)
    return data.data
}

    
// 创建个人属性.
// GET
export async function personAttributeActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 删除个人属性.
// flag: String: 个人属性标识
// GET
export async function personAttributeActionStandardListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/list/${params.flag}/prev/${params.count}`)
    return data.data
}

    
// 删除个人属性mockdeletetoget.
// flag: String: 个人属性标识
// PUT
export async function personAttributeActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.flag}`, params)
    return data.data
}

    
// 更新个人属性.
// flag: String: 个人属性标识
// POST
export async function personAttributeActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 更新个人属性mockputtopost.
// flag: String: 个人属性标识
// GET
export async function personAttributeActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/list/${params.flag}/next/${params.count}`)
    return data.data
}

    
// 获取个人属性.附带个人
// flag: String: 个人属性标识
// GET
export async function personAttributeActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/list/person/${params.personFlag}`)
    return data.data
}

    
// 列示个人属性,下一页.
// flag: String: 个人属性标识
// count: Integer: 数量
// GET
export async function personAttributeActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.flag}`)
    return data.data
}

    
// 列示个人的个人属性.
// personFlag: String: 个人标识
// DELETE
export async function personAttributeActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute/${params.flag}`, params)
    return data.data
}

    
// 列示个人属性,上一页.
// flag: String: 个人属性标识
// count: Integer: 数量
// POST
export async function personAttributeActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personattribute`, params)
    return data.data
}

    
// 列出当前用户的所有分组
// PUT
export async function personCardActionListPagingWithGroupType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listpagingwithgroup/page/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 获取当前登录人的名片.分页
// page: Integer: 页码
// size: Integer: 每页几条
// POST
export async function personCardActionListPagingMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listpaging/page/${params.page}/size/${params.size}/mockputtopost`, params)
    return data.data
}

    
// 获取当前登录人的名片分页mockputtopost.
// page: Integer: 页码
// size: Integer: 每页几条
// GET
export async function personCardActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 按分组查询当前登录人的名片.分页
// page: Integer: 页码
// size: Integer: 每页几条
// POST
export async function personCardActionListPagingWithGroupTypeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listpagingwithgroup/page/${params.page}/size/${params.size}/mockputtopost`, params)
    return data.data
}

    
// 按分组查询当前登录人的名片分页mockputtopost.
// page: Integer: 页码
// size: Integer: 每页几条
// GET
export async function personCardActionPersoncode (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/createCode/${params.cardId}`)
    return data.data
}

    
// 个人通讯录生成二维码
// cardId: String: 名片id
// PUT
export async function personCardActionListPaging (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listpaging/page/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 创建名片.
// GET
export async function personCardActionMylist (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/mylist`)
    return data.data
}

    
// 删除个人名片.
// flag: String: 名片标识
// GET
export async function personCardActionListGroupTypes (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listgrouptypes`)
    return data.data
}

    
// 删除个人名片mockdeletetoget.
// flag: String: 名片标识
// GET
export async function personCardActionListVCf (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listVCf/${params.idList}`)
    return data.data
}

    
// 获取个人名片.
// flag: String: 名片标识
// GET
export async function personCardActionListPersonalVCf (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/listPersonalVCf/${params.idList}`)
    return data.data
}

    
// 导出个人通讯录vcf
// idList: String: 名片id组
// GET
export async function personCardActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/${params.flag}`)
    return data.data
}

    
// 导出组织通讯录vcf
// idList: String: 名片id组
// PUT
export async function personCardActionUpdate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/${params.flag}`, params)
    return data.data
}

    
// 获取当前登录人的所有名片
// DELETE
export async function personCardActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/${params.flag}`, params)
    return data.data
}

    
// 组织人员生成二维码
// cardId: String: 名片id
// POST
export async function personCardActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard`, params)
    return data.data
}

    
// 更新个人名片.
// flag: String: 名片标识
// GET
export async function personCardActionCode (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/personcard/createQR/${params.cardId}`)
    return data.data
}

    
// 创建角色.
// GET
export async function roleActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 删除角色对象.
// flag: String: 角色标识
// POST
export async function roleActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/like/pinyin/mockputtopost`, params)
    return data.data
}

    
// 删除角色对象mockdeletetoget.
// flag: String: 角色标识
// POST
export async function roleActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/like/mockputtopost`, params)
    return data.data
}

    
// 更新角色.
// flag: String: 角色标识
// POST
export async function roleActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/pinyininitial/mockputtopost`, params)
    return data.data
}

    
// 更新角色mockputtopost.
// flag: String: 角色标识
// PUT
export async function roleActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.flag}`, params)
    return data.data
}

    
// 获取角色.
// flag: String: 角色标识
// POST
export async function roleActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 根据名称进行模糊查询.
// GET
export async function roleActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/${params.flag}/prev/${params.count}`)
    return data.data
}

    
// 根据名称进行模糊查询mockputtopost.
// GET
export async function roleActionListWithGroup (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/group/${params.groupFlag}`)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询.
// PUT
export async function roleActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/like/pinyin`, params)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询mockputtopost.
// PUT
export async function roleActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/like`, params)
    return data.data
}

    
// 列示角色对象,下一页.
// flag: String: 角色标识
// count: Integer: 数量
// PUT
export async function roleActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/pinyininitial`, params)
    return data.data
}

    
// 获取拼音首字母开始的Person.
// GET
export async function roleActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/${params.flag}/next/${params.count}`)
    return data.data
}

    
// 获取拼音首字母开始的Person mockputtopost.
// GET
export async function roleActionListWithPerson (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/list/person/${params.personFlag}`)
    return data.data
}

    
// 列示角色对象,上一页.
// flag: String: 角色标识
// count: Integer: 数量
// GET
export async function roleActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.flag}`)
    return data.data
}

    
// 根据给定的Group ID,获取其拥有的角色对象.
// groupFlag: String: 群组标识
// DELETE
export async function roleActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role/${params.flag}`, params)
    return data.data
}

    
// 根据给定的人员的的角色.
// personFlag: String: 个人标识
// POST
export async function roleActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/role`, params)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 创建组织.
// GET
export async function unitActionListType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/type`)
    return data.data
}

    
// 删除组织.
// flag: String: 组织标识
// GET
export async function unitActionListSupNestedWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.flag}/sup/nested/type/${params.type}`)
    return data.data
}

    
// 删除组织mockdeletetoget.
// flag: String: 组织标识
// GET
export async function unitActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 更新组织.
// flag: String: 组织标识
// POST
export async function unitActionListLikePinyinMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/like/pinyin/mockputtopost`, params)
    return data.data
}

    
// 更新组织mockputtopost.
// flag: String: 组织标识
// POST
export async function unitActionListLikeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/like/mockputtopost`, params)
    return data.data
}

    
// 获取组织.
// flag: String: 组织标识
// POST
export async function unitActionListPinyinInitialMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/pinyininitial/mockputtopost`, params)
    return data.data
}

    
// 直接上级组织.
// flag: String: 组织标识
// PUT
export async function unitActionListWithUnitWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/unit/type`, params)
    return data.data
}

    
// 根据身份获取递归上级组织中等级为指定登记的组织.
// identityFlag: String: 组织标识
// level: Integer: 组织等级
// POST
export async function unitActionListWithUnitWithTypeMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/unit/type/mockputtopost`, params)
    return data.data
}

    
// 根据身份获取递归上级组织中type为指定type的组织.
// identityFlag: String: 组织标识
// type: String: 组织类型
// GET
export async function unitActionGetWithIdentityWithLevel (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/identity/${params.identityFlag}/level/${params.level}`)
    return data.data
}

    
// 批量获取组织.
// GET
export async function unitActionListSubDirectWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.flag}/sub/direct/type/${params.type}`)
    return data.data
}

    
// 根据名称进行模糊查询.
// GET
export async function unitActionGetWithIdentityWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/identity/${params.identityFlag}/type/${params.type}`)
    return data.data
}

    
// 根据名称进行模糊查询mockputtopost.
// PUT
export async function unitActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.flag}`, params)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询.
// POST
export async function unitActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 根据拼音或者首字母进行模糊查询mockputtopost.
// GET
export async function unitActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.flag}/prev/${params.count}`)
    return data.data
}

    
// 列示组织,下一页.
// flag: String: 组织标识
// count: Integer: 数量
// PUT
export async function unitActionListLikePinyin (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/like/pinyin`, params)
    return data.data
}

    
// 获取拼音首字母开始的组织.
// GET
export async function unitActionListSubNested (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.flag}/sub/nested`)
    return data.data
}

    
// 获取拼音首字母开始的组织mockputtopost.
// GET
export async function unitActionListSubDirect (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.flag}/sub/direct`)
    return data.data
}

    
// 列示组织对象,上一页.
// flag: String: 组织标识
// count: Integer: 数量
// GET
export async function unitActionListSupNested (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.flag}/sup/nested`)
    return data.data
}

    
// 直接下级组织.
// flag: String: 组织标识
// PUT
export async function unitActionListLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/like`, params)
    return data.data
}

    
// 查找直接下级组织中符合type值的对象.
// flag: String: 组织标识
// type: String: 组织的type属性值,匹配多值中的某一个
// PUT
export async function unitActionListPinyinInitial (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/pinyininitial`, params)
    return data.data
}

    
// 递归下级组织.
// flag: String: 组织标识
// POST
export async function unitActionListWithController (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/controller`, params)
    return data.data
}

    
// 递归上级组织.
// flag: String: 组织标识
// GET
export async function unitActionListTopWithType (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/top/type/${params.type}`)
    return data.data
}

    
// 查找递归上级组织中符合type值的对象.
// flag: String: 组织标识
// type: String: 组织的type属性值,匹配多值中的某一个
// GET
export async function unitActionListTop (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/top`)
    return data.data
}

    
// 列示顶层组织.
// GET
export async function unitActionGetSupDirect (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.flag}/sup/direct`)
    return data.data
}

    
// 通过type属性值搜索顶层组织.
// type: String: 组织的type属性值,匹配多值中的某一个
// GET
export async function unitActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list/${params.flag}/next/${params.count}`)
    return data.data
}

    
// 列示所有的组织属性.
// GET
export async function unitActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.flag}`)
    return data.data
}

    
// 列示指定人员在组织管理者中的组织.
// POST
export async function unitActionList (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/list`, params)
    return data.data
}

    
// 通过type属性值搜索组织.
// DELETE
export async function unitActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit/${params.flag}`, params)
    return data.data
}

    
// 通过type属性值搜索组织mockputtopost.
// POST
export async function unitActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unit`, params)
    return data.data
}

    
// 创建组织属性.
// GET
export async function unitAttributeActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 删除组织属性.
// flag: String: 组织属性标识
// PUT
export async function unitAttributeActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.flag}`, params)
    return data.data
}

    
// 删除组织属性mockdeletetoget.
// flag: String: 组织属性标识
// POST
export async function unitAttributeActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 更新组织属性.
// flag: String: 组织属性标识
// GET
export async function unitAttributeActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/list/${params.flag}/prev/${params.count}`)
    return data.data
}

    
// 更新组织属性mockputtopost.
// flag: String: 组织属性标识
// GET
export async function unitAttributeActionListWithUnit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/list/unit/${params.flag}`)
    return data.data
}

    
// 获取组织属性对象.
// flag: String: 组织属性标识
// GET
export async function unitAttributeActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/list/${params.flag}/next/${params.count}`)
    return data.data
}

    
// 列示组织属性,下一页.
// flag: String: 组织属性标识
// count: Integer: 数量
// GET
export async function unitAttributeActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.flag}`)
    return data.data
}

    
// 列示组织属性,上一页.
// flag: String: 组织属性标识
// count: Integer: 数量
// DELETE
export async function unitAttributeActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute/${params.flag}`, params)
    return data.data
}

    
// 根据给定的组织,列示其所有的组织属性对象.
// flag: String: 组织属性标识
// POST
export async function unitAttributeActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitattribute`, params)
    return data.data
}

    
// 创建组织职务.
// GET
export async function unitDutyActionDeleteMockDeleteToGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.flag}/mockdeletetoget`)
    return data.data
}

    
// 删除组织职务.
// flag: String: 组织职务标识
// PUT
export async function unitDutyActionEdit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.flag}`, params)
    return data.data
}

    
// 删除组织职务mockdeletetoget.
// flag: String: 组织职务标识
// POST
export async function unitDutyActionEditMockPutToPost (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.flag}/mockputtopost`, params)
    return data.data
}

    
// 获取去重的组织职务名称.
// GET
export async function unitDutyActionListPrev (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/${params.flag}/prev/${params.count}`)
    return data.data
}

    
// 模糊匹配组织职务的名称,匹配名称,拼音和首字母.
// key: String: 关键字,拼音或首字母
// GET
export async function unitDutyActionListWithUnit (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/unit/${params.unitFlag}`)
    return data.data
}

    
// 更新组织职务.
// flag: String: 组织职务标识
// GET
export async function unitDutyActionDistinctName (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/distinct/name`)
    return data.data
}

    
// 更新组织职务mockputtopost.
// flag: String: 组织职务标识
// GET
export async function unitDutyActionDistinctNameLike (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/distinct/name/like/${params.key}`)
    return data.data
}

    
// 获取组织职务.
// flag: String: 组织职务标识
// GET
export async function unitDutyActionListWithIdentity (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/identity/${params.identityFlag}`)
    return data.data
}

    
// 列示组织职务.下一页
// flag: String: 组织职务标识
// count: Integer: 数量
// GET
export async function unitDutyActionListWithName (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/name/${params.name}`)
    return data.data
}

    
// 列示组织职务,上一页.
// flag: String: 组织职务标识
// count: Integer: 数量
// GET
export async function unitDutyActionListNext (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/list/${params.flag}/next/${params.count}`)
    return data.data
}

    
// 根据给定的身份,获取所拥有的组织职务.
// identityFlag: String: 身份标识
// GET
export async function unitDutyActionGet (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.flag}`)
    return data.data
}

    
// 给定组织职务名称,列示组织职务.
// name: String: 组织名称
// DELETE
export async function unitDutyActionDelete (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty/${params.flag}`, params)
    return data.data
}

    
// 根据给定的组织,获取组织职务.
// unitFlag: String: 组织标识
// POST
export async function unitDutyActionCreate (params) {
    const {data} = await request(`/x_organization_assemble_control/jaxrs/unitduty`, params)
    return data.data
}

    