
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/cache`, params)
    return data.data
}

    
// 指定应用根据路径添加数据字典数据.
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)
// POST
export async function dictActionUpdateDataPathMockPutToPost (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.dictFlag}/portal/${params.portalFlag}/${params.path}/data/mockputtopost`, params)
    return data.data
}

    
// 指定应用根据路径删除数据字典数据.
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)
// GET
export async function dictActionDeleteDataPathMockDeleteToGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.dictFlag}/portal/${params.portalFlag}/${params.path}/data/mockdeletetoget`)
    return data.data
}

    
// 指定应用根据路径删除数据字典数据(mock delete to get).
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)
// GET
export async function dictActionListWithApplication (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/list/portal/${params.portalFlag}`)
    return data.data
}

    
// 获取单个数据字典以及数据字典数据.
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// POST
export async function dictActionCreateDataPath (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.dictFlag}/portal/${params.portalFlag}/${params.path}/data`, params)
    return data.data
}

    
// 指定应用获取数据字典数据.
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// PUT
export async function dictActionUpdateDataPath (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.dictFlag}/portal/${params.portalFlag}/${params.path}/data`, params)
    return data.data
}

    
// 指定应用根据路径获取数据字典数据.
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)
// GET
export async function dictActionGetDataPath (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.dictFlag}/portal/${params.portalFlag}/${params.path}/data`)
    return data.data
}

    
// 获取指定应用的数据字典列表.
// portalFlag: String: 门户应用标识
// DELETE
export async function dictActionDeleteDataPath (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.dictFlag}/portal/${params.portalFlag}/${params.path}/data`, params)
    return data.data
}

    
// 指定应用根据路径更新数据字典数据.
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)
// GET
export async function dictActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.dictFlag}/portal/${params.portalFlag}`)
    return data.data
}

    
// 指定应用根据路径更新数据字典数据(mock put to post).
// dictFlag: String: 数据字典标识
// portalFlag: String: 门户应用标识
// path: String: 路径(多层路径以.分割，如person.name)
// GET
export async function dictActionGetData (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/dict/${params.dictFlag}/portal/${params.portalFlag}/data`)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/echo`)
    return data.data
}

    
// 访问文件内容.
// flag: String: 标识
// portalFlag: String: 应用标识
// GET
export async function fileActionDownload (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/${params.flag}/portal/${params.portalFlag}/download`)
    return data.data
}

    
// 访问文件内容.
// flag: String: 文件标识(文件id、文件别名或者文件短url编码)
// GET
export async function fileActionListWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/list/portal/${params.portalFlag}`)
    return data.data
}

    
// 访问文件内容.义stream格式下载
// flag: String: 标识
// portalFlag: String: 应用标识
// GET
export async function fileActionContentV2 (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/${params.flag}`)
    return data.data
}

    
// 访问文件内容.义stream格式下载
// flag: String: 文件标识(文件id、文件别名或者文件短url编码)
// GET
export async function fileActionDownloadV2 (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/${params.flag}/download`)
    return data.data
}

    
// 列示指定站点的下所有可见的文件.
// portalFlag: String: 标识
// GET
export async function fileActionContent (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/file/${params.flag}/portal/${params.portalFlag}/content`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/openapi`)
    return data.data
}

    
// 获取Page.
// id: String: 标识
// GET
export async function pageActionV2GetWithPortalMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/v2/${params.flag}/portal/${params.portalFlag}/mobile`)
    return data.data
}

    
// 获取PageMobile.
// id: String: 标识
// GET
export async function pageActionGetWithPortalMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/${params.flag}/portal/${params.portalFlag}/mobile`)
    return data.data
}

    
// 列示属于指定Portal的Page,其中Portal可以用name,alias和id标识,Page为在此Portal下的页面.
// flag: String: 标识
// portalFlag: String: 门户标识
// GET
export async function pageActionGetMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/${params.id}/mobile`)
    return data.data
}

    
// 列示属于指定Portal的Page,其中Portal可以用name,alias和id标识,Page为在此Portal下的页面Mobile.
// flag: String: 标识
// portalFlag: String: 门户标识
// GET
export async function pageActionV2GetMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/v2/${params.id}/mobile`)
    return data.data
}

    
// 获取Page内容.
// id: String: 标识
// GET
export async function pageActionV2GetWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/v2/${params.flag}/portal/${params.portalFlag}`)
    return data.data
}

    
// 获取Page内容Mobile.
// id: String: 标识
// GET
export async function pageActionV2Get (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/v2/${params.id}`)
    return data.data
}

    
// 列示属于指定Portal的Page,其中Portal可以用name,alias和id标识,Page为在此Portal下的页面.
// flag: String: 标识
// portalFlag: String: 门户标识
// GET
export async function pageActionGetWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/${params.flag}/portal/${params.portalFlag}`)
    return data.data
}

    
// 列示属于指定Portal的Page,其中Portal可以用name,alias和id标识,Page为在此Portal下的页面Mobile.
// flag: String: 标识
// portalFlag: String: 门户标识
// GET
export async function pageActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/${params.id}`)
    return data.data
}

    
// 列示属于指定Portal的Page.
// portal: String: 门户
// GET
export async function pageActionList (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/page/list/portal/${params.portal}`)
    return data.data
}

    
// 获取单个的Portal.
// flag: String: 标识
// GET
export async function portalActionIcon (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/${params.id}/icon`)
    return data.data
}

    
// 获取Portal的角标数量(根据Portal的角标脚本计算得出).
// flag: String: 标识
// GET
export async function portalActionIconBase64 (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/${params.id}/icon/base64`)
    return data.data
}

    
// 获取Portal的图标.
// id: String: 标识
// GET
export async function portalActionGetCornerMark (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/${params.flag}/corner/mark`)
    return data.data
}

    
// 获取Portal的图标Base64编码.
// id: String: 标识
// GET
export async function portalActionListMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/list/mobile`)
    return data.data
}

    
// 列示当前用户PC端所有可见的Portal.
// GET
export async function portalActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/${params.flag}`)
    return data.data
}

    
// 列示当前用户mobile端所有可见的Portal.
// GET
export async function portalActionList (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/portal/list`)
    return data.data
}

    
// 在指定的Portal下根据flag获取Script.
// name: String: 名称
// portal: String: 门户标识
// GET
export async function scriptActionGetImported (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/script/portal/${params.portal}/name/${params.name}/imported`)
    return data.data
}

    
// 获取Script内容.
// id: String: 标识
// GET
export async function scriptActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/script/${params.id}`)
    return data.data
}

    
// 获取Script内容,并递归附带应用脚本.
// name: String: 名称
// portal: String: 门户标识
// GET
export async function scriptActionList (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/script/list/portal/${params.portal}`)
    return data.data
}

    
// 列示属于指定Portal的Script.
// portal: String: 门户标识
// POST
export async function scriptActionFlag (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/script/portal/${params.portal}/name/${params.name}`, params)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 获取部件内容.
// id: String: 标识
// GET
export async function widgetActionGetWithPortalMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/${params.flag}/portal/${params.portalFlag}/mobile`)
    return data.data
}

    
// 获取部件内容Mobile.
// id: String: 标识
// GET
export async function widgetActionGetMobile (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/${params.id}/mobile`)
    return data.data
}

    
// 列示属于指定Portal的部件,其中Portal可以用name,alias和id标识,部件为在此Portal下的页面.
// flag: String: 标识
// portalFlag: String: 门户标识
// GET
export async function widgetActionGetWithPortal (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/${params.flag}/portal/${params.portalFlag}`)
    return data.data
}

    
// 列示属于指定Portal的部件,其中Portal可以用name,alias和id标识,部件为在此Portal下的页面Mobile.
// flag: String: 标识
// portalFlag: String: 门户标识
// GET
export async function widgetActionGet (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/${params.id}`)
    return data.data
}

    
// 列示属于指定Portal的部件.
// portal: String: 门户
// GET
export async function widgetActionList (params) {
    const {data} = await request(`/x_portal_assemble_surface/jaxrs/widget/list/portal/${params.portal}`)
    return data.data
}

    