
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/cache`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/openapi`)
    return data.data
}

    
// 获取每月完成的待办任务,所对应的应用流程以及活动,根据TaskCompleted统计得到.
// GET
export async function periodActionListCountStartTask (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/task/application/${params.applicationId}/process/${params.processId}/activity/${params.activityId}/unit/${params.unit}/person/${params.person}`)
    return data.data
}

    
// 获取每月完成的待办任务,所对应的公司以及部门,根据TaskCompleted统计得到.
// GET
export async function periodActionListCountStartWork (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/work/application/${params.applicationId}/process/${params.processId}/unit/${params.unit}/person/${params.person}`)
    return data.data
}

    
// 获取每月完成的Work,所对应的应用流程以及活动,根据WorkCompleted统计得到.
// GET
export async function periodActionListCountCompletedWorkByApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/work/unit/${params.unit}/person/${params.person}/by/application`)
    return data.data
}

    
// 获取每月完成的Work,所对应的公司以及部门,根据WorkCompleted统计得到.
// GET
export async function periodActionListCountCompletedTaskByApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/task/unit/${params.unit}/person/${params.person}/by/application`)
    return data.data
}

    
// 获取过去12个月中每月完成的办理量,,根据TaskCompleted统计得到.(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// activityId: String: 活动标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountExpiredWorkByCompany (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/work/application/${params.applicationId}/process/${params.processId}/by/unit`)
    return data.data
}

    
// 获取过去12个月中每月完成的办理量,,根据TaskCompleted统计得到.按process分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 活动标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountExpiredWorkByApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/work/unit/${params.unit}/person/${params.person}/by/application`)
    return data.data
}

    
// 获取过去12个月中每月完成的办理量,,根据TaskCompleted统计得到.按application分项统计,(0)表示占位符.
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListStartTaskApplicationStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/start/task/applicationstubs`)
    return data.data
}

    
// 获取过去12个月中每月完成的办理量,,根据TaskCompleted统计得到.按process分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountStartTaskByApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/task/unit/${params.unit}/person/${params.person}/by/application`)
    return data.data
}

    
// 获取过去12个月中每月完成的办理量,,根据TaskCompleted统计得到.按unit分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// activityId: String: 活动标识
// GET
export async function periodActionListStartWorkApplicationStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/start/work/applicationstubs`)
    return data.data
}

    
// 获取过去12个月中每月完成的Work数量,时长,步数.根据workcompleted统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountCompletedWorkByCompany (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/work/application/${params.applicationId}/process/${params.processId}/by/unit`)
    return data.data
}

    
// 获取过去12个月中每月完成的Work数量,时长,步数.根据workcompleted统计得到,根据application分项统计,(0)表示占位符.
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCompletedWorkCompanyStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/completed/work/unitstubs`)
    return data.data
}

    
// 获取过去12个月中每月完成的Work数量,时长,步数.根据workcompleted统计得到,根据unit分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// GET
export async function periodActionListCompletedTaskApplicationStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/completed/task/applicationstubs`)
    return data.data
}

    
// 获取过去12个月中每月完成的Work数量,时长,步数.根据workcompleted统计得到,根据process分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListExpiredTaskCompanyStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/expired/task/unitstubs`)
    return data.data
}

    
// 获取过去12个月中每月的超时办理量,根据task和taskCompleted的截至时间来计算,计入到待办截至时间的所在月份.(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// activityId: String: 活动标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountCompletedWorkByProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/work/application/${params.applicationId}/unit/${params.unit}/person/${params.person}/by/process`)
    return data.data
}

    
// 获取过去12个月中每月的超时办理量,根据task和taskCompleted的截至时间来计算,计入到待办截至时间的所在月份,按activity分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountCompletedTaskByUnit (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/task/application/${params.applicationId}/process/${params.processId}/activity/${params.activityId}/by/unit`)
    return data.data
}

    
// 获取过去12个月中每月的超时办理量,根据task和taskCompleted的截至时间来计算,计入到待办截至时间的所在月份,按application分项统计,(0)表示占位符.
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListStartTaskCompanyStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/start/task/unitstubs`)
    return data.data
}

    
// 获取过去12个月中每月的超时办理量,根据task和taskCompleted的截至时间来计算,计入到待办截至时间的所在月份,按process分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountExpiredTaskByActivity (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/task/application/${params.applicationId}/process/${params.processId}/unit/${params.unit}/person/${params.person}/by/activity`)
    return data.data
}

    
// 获取过去12个月中每月的超时办理量,根据task和taskCompleted的截至时间来计算,计入到待办截至时间的所在月份,按unit分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// activityId: String: 活动标识
// GET
export async function periodActionListStartWorkUnitStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/start/work/unitstubs`)
    return data.data
}

    
// 获取过去12个月中每月超时的Work数量.根据work和workCompleted统计得到,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountStartWorkByCompany (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/work/application/${params.applicationId}/process/${params.processId}/by/unit`)
    return data.data
}

    
// 获取过去12个月中每月超时的Work数量.根据work和workCompleted统计得到,按department分项统计,(0)表示占位符.
// unit: String: 组织标识
// person: String: 用户标识
// GET
export async function periodActionListCountStartTaskByActivity (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/task/application/${params.applicationId}/process/${params.processId}/unit/${params.unit}/person/${params.person}/by/activity`)
    return data.data
}

    
// 获取过去12个月中每月超时的Work数量.根据work和workCompleted统计得到,按unit分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// GET
export async function periodActionListCountStartWorkByApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/work/unit/${params.unit}/person/${params.person}/by/application`)
    return data.data
}

    
// 获取过去12个月中每月超时的Work数量.根据work和workCompleted统计得到,按process分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListExpiredTaskApplicationStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/expired/task/applicationstubs`)
    return data.data
}

    
// 获取过去12个月中每月产生的待办数量,现有待办+已经办理完成的已办,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// activityId: String: 活动标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountStartWorkByProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/work/application/${params.applicationId}/unit/${params.unit}/person/${params.person}/by/process`)
    return data.data
}

    
// 获取过去12个月中每月产生的待办数量,现有待办+已经办理完成的已办,根据activity进行分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountExpiredTask (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/task/application/${params.applicationId}/process/${params.processId}/activity/${params.activityId}/unit/${params.unit}/person/${params.person}`)
    return data.data
}

    
// 获取过去12个月中每月产生的待办数量,现有待办+已经办理完成的已办,根据application进行分项统计,(0)表示占位符.
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCompletedWorkApplicationStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/completed/work/applicationstubs`)
    return data.data
}

    
// 获取过去12个月中每月产生的待办数量,现有待办+已经办理完成的已办,根据process进行分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountExpiredTaskByApplication (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/task/unit/${params.unit}/person/${params.person}/by/application`)
    return data.data
}

    
// 获取过去12个月中每月产生的待办数量,现有待办+已经办理完成的已办,根据unit进行分项统计,(0)表示占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// activityId: String: 活动标识
// GET
export async function periodActionListCountStartTaskByUnit (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/task/application/${params.applicationId}/process/${params.processId}/activity/${params.activityId}/by/unit`)
    return data.data
}

    
// 获取过去12个月中每月的Work创建量,统计work和workCompleted,(0)作为占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountExpiredTaskByUnit (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/task/application/${params.applicationId}/process/${params.processId}/activity/${params.activityId}/by/unit`)
    return data.data
}

    
// 获取过去12个月中每月的Work创建量,统计work和workCompleted,按application分项统计,(0)作为占位符.
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountCompletedTask (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/task/application/${params.applicationId}/process/${params.processId}/activity/${params.activityId}/unit/${params.unit}/person/${params.person}`)
    return data.data
}

    
// 获取过去12个月中每月的Work创建量,统计work和workCompleted,按unit分项统计,(0)作为占位符.
// applicationId: String: 应用标识
// processId: String: 流程标识
// GET
export async function periodActionListCountStartTaskByProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/start/task/application/${params.applicationId}/unit/${params.unit}/person/${params.person}/by/process`)
    return data.data
}

    
// 获取过去12个月中每月的Work创建量,统计work和workCompleted,按process分项统计,(0)作为占位符.
// applicationId: String: 应用标识
// unit: String: 组织标识
// person: String: 个人标识
// GET
export async function periodActionListCountExpiredTaskByProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/task/application/${params.applicationId}/unit/${params.unit}/person/${params.person}/by/process`)
    return data.data
}

    
// 获取每月产生的超时待办任务,所对应的应用流程以及活动,根据Task和TaskCompleted统计得到.
// GET
export async function periodActionListCompletedTaskCompanyStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/completed/task/unitstubs`)
    return data.data
}

    
// 获取每月产生的超时待办任务,所对应的公司以及部门,根据Task和TaskCompleted统计得到.
// GET
export async function periodActionListExpiredWorkApplicationStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/expired/work/applicationstubs`)
    return data.data
}

    
// 获取每月超时的Work,所对应的应用流程以及活动,根据Work和WorkCompleted统计得到.
// GET
export async function periodActionListCountExpiredWork (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/work/application/${params.applicationId}/process/${params.processId}/unit/${params.unit}/person/${params.person}`)
    return data.data
}

    
// 获取每月超时的Work,所对应的公司以及部门,根据Work和WorkCompleted统计得到.
// GET
export async function periodActionListExpiredWorkCompanyStubs (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/expired/work/unitstubs`)
    return data.data
}

    
// 获取每月产生的待办任务,所对应的应用流程以及活动,根据Task和TaskCompleted统计得到.
// GET
export async function periodActionListCountCompletedTaskByProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/task/application/${params.applicationId}/unit/${params.unit}/person/${params.person}/by/process`)
    return data.data
}

    
// 获取每月产生的待办任务,所对应的组织,根据Task和TaskCompleted统计得到.
// GET
export async function periodActionListCountCompletedWork (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/work/application/${params.applicationId}/process/${params.processId}/unit/${params.unit}/person/${params.person}`)
    return data.data
}

    
// 获取每月产生的Work,所对应的应用流程以及活动,根据Work和WorkCompleted统计得到.
// GET
export async function periodActionListCountCompletedTaskByActivity (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/completed/task/application/${params.applicationId}/process/${params.processId}/unit/${params.unit}/person/${params.person}/by/activity`)
    return data.data
}

    
// 获取每月产生的Work,所对应的公司以及部门,根据Work和WorkCompleted统计得到.
// GET
export async function periodActionListCountExpiredWorkByProcess (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/period/list/count/expired/work/application/${params.applicationId}/unit/${params.unit}/person/${params.person}/by/process`)
    return data.data
}

    
// 触发获取应用.
// GET
export async function stateActionCategoryTrigger (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/state/category/trigger`)
    return data.data
}

    
// 获取根据应用的统计.
// GET
export async function stateActionApplicationStubsTrigger (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/state/applicationtstubs/trigger`)
    return data.data
}

    
// 触发根据应用的统计.
// GET
export async function stateActionRunning (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/state/running`)
    return data.data
}

    
// 获取根据组织,个人的统计.
// GET
export async function stateActionCategory (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/state/category`)
    return data.data
}

    
// 获取运行情况.
// GET
export async function stateActionOrganization (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/state/organization`)
    return data.data
}

    
// 获取全局统计.
// GET
export async function stateActionSummary (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/state/summary`)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_processplatform_assemble_bam/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    