
// 接收刷新Config配置文件指令.
// GET
export async function cacheActionDetail (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/cache/detail`)
    return data.data
}

    
// 显示缓存状态.
// GET
export async function cacheActionConfigFlush (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/cache/config/flush`)
    return data.data
}

    
// 接收缓存刷新指令.
// POST
export async function cacheActionReceive (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/cache`, params)
    return data.data
}

    
// 根据关键字搜索设计对象.
// POST
export async function designerActionSearch (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/designer/search`, params)
    return data.data
}

    
// 获取应答.
// GET
export async function echoActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/echo`)
    return data.data
}

    
// 接受x_program_center发送过来的运行定时任务指令.
// className: String: 运行类
// GET
export async function fireScheduleActionExecute (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/fireschedule/classname/${params.className}`)
    return data.data
}

    
// 创建用于ID值的UUID
// count: Integer: 数量
// GET
export async function idActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/id/${params.count}`)
    return data.data
}

    
// 创建数据导入模型.
// POST
export async function importModelActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/${params.id}/permission`, params)
    return data.data
}

    
// 删除数据导入模型.
// id: String: 标识
// GET
export async function importModelActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/list/query/${params.flag}`)
    return data.data
}

    
// 获取数据导入模型内容.
// id: String: 标识
// GET
export async function importModelActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/${params.id}`)
    return data.data
}

    
// 根据query列示数据导入对象.
// flag: String: 查询标识
// PUT
export async function importModelActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/${params.id}`, params)
    return data.data
}

    
// 更新数据导入模型.
// id: String: 标识
// DELETE
export async function importModelActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel/${params.id}`, params)
    return data.data
}

    
// 设置数据导入模型权限.
// id: String: 标识
// POST
export async function importModelActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/importmodel`, params)
    return data.data
}

    
// 上传对比数据内容.
// PUT
export async function inputActionCover (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/cover`, params)
    return data.data
}

    
// 覆盖应用.
// PUT
export async function inputActionPrepareCover (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/prepare/cover`, params)
    return data.data
}

    
// 创建应用.
// PUT
export async function inputActionPrepareCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/prepare/create`, params)
    return data.data
}

    
// 准备覆盖应用.
// PUT
export async function inputActionCompare (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/compare`, params)
    return data.data
}

    
// 准备创建应用.
// PUT
export async function inputActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/input/create`, params)
    return data.data
}

    
// 创建模型.
// GET
export async function neuralActionGetModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model/${params.modelFlag}`)
    return data.data
}

    
// 删除项目.
// modelFlag: String: 模型标识
// POST
export async function neuralActionCreateModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model`, params)
    return data.data
}

    
// 创建条目.
// modelFlag: String: 模型标识
// GET
export async function neuralActionListModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/list/model`)
    return data.data
}

    
// 获取模型.
// modelFlag: String: 模型标识
// PUT
export async function neuralActionUpdateModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model/${params.modelFlag}`, params)
    return data.data
}

    
// 学习.
// modelFlag: String: 模型标识
// DELETE
export async function neuralActionDeleteModel (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model/${params.modelFlag}`, params)
    return data.data
}

    
// 列示所有模型.
// GET
export async function neuralActionResetStatus (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/model/${params.modelFlag}/reset/status`)
    return data.data
}

    
// 重置状态.
// modelFlag: String: 模型标识
// GET
export async function neuralActionLearn (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/learn/model/${params.modelFlag}`)
    return data.data
}

    
// 停止创建条目.
// modelFlag: String: 模型标识
// GET
export async function neuralActionStopLearning (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/stop/learn/model/${params.modelFlag}`)
    return data.data
}

    
// 停止学习.
// modelFlag: String: 模型标识
// GET
export async function neuralActionStopGenerating (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/stop/generating/model/${params.modelFlag}`)
    return data.data
}

    
// 更新模型.
// modelFlag: String: 模型标识
// GET
export async function neuralActionGenerate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/neural/generate/model/${params.modelFlag}`)
    return data.data
}

    
// 获取openapi描述文件.
// GET
export async function openApiActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/openapi`)
    return data.data
}

    
// 查看所有应用.
// PUT
export async function outputActionSelect (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/output/${params.queryFlag}/select`, params)
    return data.data
}

    
// 选择查询.
// queryFlag: String: 查询标识
// GET
export async function outputActionSelectOutput (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/output/${params.flag}/select/file`)
    return data.data
}

    
// 以文件方式导出应用.
// flag: String: 输出文件标识
// GET
export async function outputActionList (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/output/list`)
    return data.data
}

    
// 创建查询.
// PUT
export async function queryActionSetIcon (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.flag}/icon`, params)
    return data.data
}

    
// 删除查询.
// flag: String: 标识
// GET
export async function queryActionListWithQueryCategory (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/list/querycategory/${params.queryCategory}`)
    return data.data
}

    
// 更新查询.
// flag: String: 标识
// GET
export async function queryActionGetEntityProperties (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/entity/${params.entity}/category/${params.entityCategory}/properties`)
    return data.data
}

    
// 获取查询内容.
// flag: String: 标识
// GET
export async function queryActionListSummaryWithApplicationCategory (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/list/summary/querycategory/${params.queryCategory}`)
    return data.data
}

    
// 根据标识获取语句操作对象的属性信息.
// entity: String: 实体类名称(系统表要全称如com.x.query.core.entity.Query，自建表只要名称)
// entityCategory: String: 实体类类型(自建表：dynamic|系统表：official)
// GET
export async function queryActionListQueryCategory (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/querycategory/list`)
    return data.data
}

    
// 获取所有查询内容.
// PUT
export async function queryActionEdit (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.flag}`, params)
    return data.data
}

    
// 列示查询年分类,并统计数量.
// POST
export async function queryActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.id}/permission`, params)
    return data.data
}

    
// 列示所有查询，同时附带视图简要信息和统计简要信息.
// GET
export async function queryActionListAll (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/list/all`)
    return data.data
}

    
// 根据查询分类获取查询的简要信息,同时附带视图简要信息和统计简要信息应用分类不为null.
// queryCategory: String: 查询分类
// GET
export async function queryActionListSummary (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/list/summary`)
    return data.data
}

    
// 列示指定分类的查询.
// queryCategory: String: 查询分类
// GET
export async function queryActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.flag}`)
    return data.data
}

    
// 更新查询图标.
// flag: String: 应用标识
// DELETE
export async function queryActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query/${params.flag}`, params)
    return data.data
}

    
// 设置数据中心权限.
// id: String: 标识
// POST
export async function queryActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/query`, params)
    return data.data
}

    
// 创建Stat.
// POST
export async function statActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.id}/permission`, params)
    return data.data
}

    
// 删除Stat.
// id: String: 标识
// GET
export async function statActionListNext (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 获取Stat内容.
// id: String: 标识
// GET
export async function statActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/list/query/${params.flag}`)
    return data.data
}

    
// 列示Stat对象,下一页.
// id: String: 标识
// count: Integer: 数量
// PUT
export async function statActionSimulate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.id}/simulate`, params)
    return data.data
}

    
// 列示Stat对象,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function statActionListPrev (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 根据query列示stat对象.
// flag: String: 查询标识
// GET
export async function statActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.id}`)
    return data.data
}

    
// 模拟执行stat
// id: String: 视图标识
// PUT
export async function statActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.id}`, params)
    return data.data
}

    
// 更新Stat.
// id: String: 标识
// DELETE
export async function statActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat/${params.id}`, params)
    return data.data
}

    
// 设置统计权限.
// id: String: 标识
// POST
export async function statActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/stat`, params)
    return data.data
}

    
// 创建语句.
// POST
export async function statementActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.id}/permission`, params)
    return data.data
}

    
// 删除语句.
// flag: String: 标识
// POST
export async function statementActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/list/query/${params.flag}`, params)
    return data.data
}

    
// V8版本新版本查询语句,取消mode参数,增加自动count,增加自动内置参数判断,替换V2版本.
// flag: String: 标识
// page: Integer: 页码
// size: Integer: 每页数量
// POST
export async function statementActionExecuteV2 (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.flag}/execute/mode/${params.mode}/page/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 执行语句V2,可以同时执行查询结果及查询总数.
// flag: String: 标识
// mode: String: 执行模式：data|count|all
// page: Integer: 页码
// size: Integer: 每页数量
// GET
export async function statementActionManageList (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/list/manage`)
    return data.data
}

    
// 根据标识获取语句.
// flag: String: 标识
// GET
export async function statementActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.flag}`)
    return data.data
}

    
// 根据query列示statement对象.
// flag: String: 查询标识
// PUT
export async function statementActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.flag}`, params)
    return data.data
}

    
// 列示所有statement对象.
// POST
export async function statementActionExecute (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.flag}/execute/page/${params.page}/size/${params.size}`, params)
    return data.data
}

    
// 更新语句.
// flag: String: 标识
// DELETE
export async function statementActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement/${params.flag}`, params)
    return data.data
}

    
// 设置查询语句权限.
// id: String: 标识
// POST
export async function statementActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/statement`, params)
    return data.data
}

    
// 获取静态资源信息.
// filePath: String: 查找路径(根路径:(0))
// GET
export async function sysResourceActionListResource (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/sysresource/filePath/${params.filePath}`)
    return data.data
}

    
// 编译指定应用所有表,执行后需要立即重新启动，支持集群环境.
// query: String: 应用标识
// POST
export async function tableActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.id}/permission`, params)
    return data.data
}

    
// 编译指定应用所有表,执行后需要立即重新启动，仅对当前服务器.
// query: String: 应用标识
// GET
export async function tableActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/query/${params.flag}`)
    return data.data
}

    
// 创建表.
// GET
export async function tableActionBuildDispatch (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.query}/build/dispatch`)
    return data.data
}

    
// 删除表,同时会级联删除语句.
// flag: String: 标识
// GET
export async function tableActionRowCountWhere (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.tableFlag}/row/count/where/${params.where}`)
    return data.data
}

    
// 执行语句.
// flag: String: 标识
// GET
export async function tableActionRowGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.tableFlag}/row/${params.id}`)
    return data.data
}

    
// 导出行对象。
// tableFlag: String: 表标识
// count: Integer: 数量(最大2000)
// GET
export async function tableActionListRowSelectWhere (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/${params.tableFlag}/row/select/where/${params.where}`)
    return data.data
}

    
// 根据标识获取表.
// flag: String: 标识
// POST
export async function tableActionRowInsert (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.tableFlag}/row`, params)
    return data.data
}

    
// 列示表中的行对象,下一页.
// tableFlag: String: 表标识
// id: String: 标识
// count: Integer: 数量
// GET
export async function tableActionStatusDraft (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.flag}/status/draft`)
    return data.data
}

    
// 列示表中的行对象,上一页.
// tableFlag: String: 表标识
// id: String: 标识
// count: Integer: 数量
// DELETE
export async function tableActionRowDeleteAll (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.tableFlag}/row/delete/all`, params)
    return data.data
}

    
// 通过where 获取表中的数据,格式为jpql语法,o.name='zhangsan'
// tableFlag: String: 表标识
// where: String: where语句
// GET
export async function tableActionListRowNext (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/${params.tableFlag}/row/${params.id}/next/${params.count}`)
    return data.data
}

    
// 根据query列示table对象.
// flag: String: 查询标识
// GET
export async function tableActionListRowPrev (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/${params.tableFlag}/row/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示所有table对象.
// GET
export async function tableActionStatusBuild (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.flag}/status/build`)
    return data.data
}

    
// 在服务器重新编译dynamicEntity之后需要重新初始化EntityManagerContainerFactory.
// PUT
export async function tableActionRowUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.tableFlag}/row/${params.id}`, params)
    return data.data
}

    
// 通过where 统计数量
// tableFlag: String: 表标识
// where: String: where语句
// DELETE
export async function tableActionRowDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.tableFlag}/row/${params.id}`, params)
    return data.data
}

    
// 更新指定表中指定行数据.
// tableFlag: String: 表标识
// id: String: 行标识
// GET
export async function tableActionBuildQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/query/${params.query}/build`)
    return data.data
}

    
// 更新指定表中指定行数据.
// tableFlag: String: 表标识
// GET
export async function tableActionReloadDynamic (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/reload/dynamic`)
    return data.data
}

    
// 获取表中某一行数据
// tableFlag: String: 表标识
// id: String: 行标识
// GET
export async function tableActionManageList (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/list/manage`)
    return data.data
}

    
// 指定表中插入数据.
// tableFlag: String: 表标识
// POST
export async function tableActionRowSave (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.tableFlag}/row/save`, params)
    return data.data
}

    
// 指定表中批量保存或更新数据.
// tableFlag: String: 表标识
// GET
export async function tableActionExportRow (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/export/${params.tableFlag}/count/${params.count}`)
    return data.data
}

    
// 更新指定表中指定行数据.
// tableFlag: String: 表标识
// id: String: 行标识
// GET
export async function tableActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.flag}`)
    return data.data
}

    
// 标识表状态为编译.
// flag: String: 标识
// PUT
export async function tableActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.flag}`, params)
    return data.data
}

    
// 标识表状态为草稿.
// flag: String: 标识
// POST
export async function tableActionExecute (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.flag}/execute`, params)
    return data.data
}

    
// 更新表.
// flag: String: 标识
// DELETE
export async function tableActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table/${params.flag}`, params)
    return data.data
}

    
// 设置表权限.
// id: String: 标识
// POST
export async function tableActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/table`, params)
    return data.data
}

    
// 模拟执行view,输出所有bundle值
// id: String: 视图标识
// POST
export async function viewActionUpdatePermission (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.id}/permission`, params)
    return data.data
}

    
// 创建View.
// GET
export async function viewActionListNext (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/list/${params.id}/next/${params.count}`)
    return data.data
}

    
// 删除View.
// id: String: 标识
// GET
export async function viewActionListWithQuery (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/list/query/${params.flag}`)
    return data.data
}

    
// 获取View内容.
// id: String: 标识
// PUT
export async function viewActionSimulate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.id}/simulate`, params)
    return data.data
}

    
// 列示View对象,下一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function viewActionListPrev (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/list/${params.id}/prev/${params.count}`)
    return data.data
}

    
// 列示View对象,上一页.
// id: String: 标识
// count: Integer: 数量
// GET
export async function viewActionGet (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.id}`)
    return data.data
}

    
// 根据query列示view对象.
// flag: String: 查询标识
// PUT
export async function viewActionUpdate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.id}`, params)
    return data.data
}

    
// 模拟执行view
// id: String: 视图标识
// PUT
export async function viewActionBundle (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.id}/bundle`, params)
    return data.data
}

    
// 更新View.
// id: String: 标识
// DELETE
export async function viewActionDelete (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view/${params.id}`, params)
    return data.data
}

    
// 设置视图权限.
// id: String: 标识
// POST
export async function viewActionCreate (params) {
    const {data} = await request(`/x_query_assemble_designer/jaxrs/view`, params)
    return data.data
}

    