package org.linkor.callback;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

/**
 * mqtt 回调函数
 */
public class OnMessageCallback implements MqttCallback {

    @Override
    public void connectionLost(Throwable throwable) {
        // 连接丢失后，一般在这里面进行重连
        System.out.println("连接断开，可以做重连");
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) {
        // subscribe后得到的消息会执行到这里面
        System.out.println("topic: " + topic + ", content: " + message.toString());
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
        // publish 后会执行到这里
        System.out.println("deliveryComplete---------" + token.isComplete());
    }

    public static OnMessageCallback getInstance() {
        return new OnMessageCallback();
    }
}
