package org.linkor.setting;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;

/**
 * 配置信息
 */
public class Setting {

    public static int QOS;
//    public final static String BROKER = "tcp://127.0.0.1:521";
    public static String BROKER;
//    public final static String TOPIC = "ModbusTcp/#";
    public static String TOPIC;
    public static String CLIENT_ID =
            LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-ddHH:mm:ss")) + Math.random();
    public static String USERNAME;
    public static String PASSWORD;

    public static void init() {
        // read from setting.properties
        try {
            Properties properties = new Properties();
            properties.load(Setting.class.getClassLoader().getResourceAsStream("setting.properties"));
            QOS = Integer.parseInt(properties.getProperty("qos"));
            BROKER = properties.getProperty("broker");
            TOPIC = properties.getProperty("topic");
            USERNAME = properties.getProperty("username");
            PASSWORD = properties.getProperty("password");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
