package org.linkor;

import org.eclipse.paho.client.mqttv3.*;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.linkor.callback.OnMessageCallback;
import org.linkor.setting.Setting;

public class Main {

    public static void main(String[] args) {
        Setting.init();
        try {
            // host为主机名，test为 clientId 即连接MQTT的客户端ID，一般以客户端唯一标识符表示，MemoryPersistence设置clientid的保存形式，默认为以内存保存
            MqttClient client = new MqttClient(Setting.BROKER, Setting.CLIENT_ID, new MemoryPersistence());
            // MQTT的连接设置
            MqttConnectOptions options = new MqttConnectOptions();
            // 设置是否清空session,这里如果设置为false表示服务器会保留客户端的连接记录，这里设置为true表示每次连接到服务器都以新的身份连接
            options.setCleanSession(true);
            // 设置连接的用户名
            options.setUserName(Setting.USERNAME);
            // 设置连接的密码
            options.setPassword(Setting.PASSWORD.toCharArray());
            // 设置超时时间 单位为秒
            options.setConnectionTimeout(10);
            // 设置会话心跳时间 单位为秒 服务器会每隔1.5*20秒的时间向客户端发送个消息判断客户端是否在线，但这个方法并没有重连的机制
            options.setKeepAliveInterval(20);
            // 设置回调函数
            client.setCallback(OnMessageCallback.getInstance());

            // 建立连接
            System.out.println("连接到 broker: " + Setting.BROKER);
            client.connect(options);

            System.out.println("连接成功.");
            //订阅消息
            client.subscribe(Setting.TOPIC, Setting.QOS);
//            client.subscribe("ModbusTcp/数据名字", Setting.QOS);
            System.out.println("开始监听: " + Setting.TOPIC);
            System.out.println("==========================================");
            client.publish("ModbusTcp/压力", new MqttMessage("400".getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}